# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 7
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from isi_sdk_8_2_0.api_client import ApiClient


class QuotaApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_quota_quota(self, quota_quota, **kwargs):  # noqa: E501
        """create_quota_quota  # noqa: E501

        Create a new quota.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_quota_quota(quota_quota, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param QuotaQuotaCreateParams quota_quota: (required)
        :param str zone: Optional named zone to use for user and group resolution.
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_quota_quota_with_http_info(quota_quota, **kwargs)  # noqa: E501
        else:
            (data) = self.create_quota_quota_with_http_info(quota_quota, **kwargs)  # noqa: E501
            return data

    def create_quota_quota_with_http_info(self, quota_quota, **kwargs):  # noqa: E501
        """create_quota_quota  # noqa: E501

        Create a new quota.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_quota_quota_with_http_info(quota_quota, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param QuotaQuotaCreateParams quota_quota: (required)
        :param str zone: Optional named zone to use for user and group resolution.
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['quota_quota', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_quota_quota" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'quota_quota' is set
        if ('quota_quota' not in params or
                params['quota_quota'] is None):
            raise ValueError("Missing the required parameter `quota_quota` when calling `create_quota_quota`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'quota_quota' in params:
            body_params = params['quota_quota']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/quota/quotas', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_quota_report(self, quota_report, **kwargs):  # noqa: E501
        """create_quota_report  # noqa: E501

        Create a new report. The type of this report is 'manual'; it is also sometimes called 'live' or 'ad-hoc'.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_quota_report(quota_report, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Empty quota_report: (required)
        :return: CreateQuotaReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_quota_report_with_http_info(quota_report, **kwargs)  # noqa: E501
        else:
            (data) = self.create_quota_report_with_http_info(quota_report, **kwargs)  # noqa: E501
            return data

    def create_quota_report_with_http_info(self, quota_report, **kwargs):  # noqa: E501
        """create_quota_report  # noqa: E501

        Create a new report. The type of this report is 'manual'; it is also sometimes called 'live' or 'ad-hoc'.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_quota_report_with_http_info(quota_report, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Empty quota_report: (required)
        :return: CreateQuotaReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['quota_report']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_quota_report" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'quota_report' is set
        if ('quota_report' not in params or
                params['quota_report'] is None):
            raise ValueError("Missing the required parameter `quota_report` when calling `create_quota_report`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'quota_report' in params:
            body_params = params['quota_report']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/quota/reports', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateQuotaReportResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_settings_mapping(self, settings_mapping, **kwargs):  # noqa: E501
        """create_settings_mapping  # noqa: E501

        Create a new rule. The new rule must not conflict with an existing rule (e.g. match both the type and domain fields).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_settings_mapping(settings_mapping, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SettingsMappingCreateParams settings_mapping: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_settings_mapping_with_http_info(settings_mapping, **kwargs)  # noqa: E501
        else:
            (data) = self.create_settings_mapping_with_http_info(settings_mapping, **kwargs)  # noqa: E501
            return data

    def create_settings_mapping_with_http_info(self, settings_mapping, **kwargs):  # noqa: E501
        """create_settings_mapping  # noqa: E501

        Create a new rule. The new rule must not conflict with an existing rule (e.g. match both the type and domain fields).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_settings_mapping_with_http_info(settings_mapping, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SettingsMappingCreateParams settings_mapping: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['settings_mapping']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_settings_mapping" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'settings_mapping' is set
        if ('settings_mapping' not in params or
                params['settings_mapping'] is None):
            raise ValueError("Missing the required parameter `settings_mapping` when calling `create_settings_mapping`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'settings_mapping' in params:
            body_params = params['settings_mapping']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/quota/settings/mappings', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_settings_notification(self, settings_notification, **kwargs):  # noqa: E501
        """create_settings_notification  # noqa: E501

        Create a new global notification rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_settings_notification(settings_notification, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param QuotaNotificationCreateParams settings_notification: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_settings_notification_with_http_info(settings_notification, **kwargs)  # noqa: E501
        else:
            (data) = self.create_settings_notification_with_http_info(settings_notification, **kwargs)  # noqa: E501
            return data

    def create_settings_notification_with_http_info(self, settings_notification, **kwargs):  # noqa: E501
        """create_settings_notification  # noqa: E501

        Create a new global notification rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_settings_notification_with_http_info(settings_notification, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param QuotaNotificationCreateParams settings_notification: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['settings_notification']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_settings_notification" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'settings_notification' is set
        if ('settings_notification' not in params or
                params['settings_notification'] is None):
            raise ValueError("Missing the required parameter `settings_notification` when calling `create_settings_notification`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'settings_notification' in params:
            body_params = params['settings_notification']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/quota/settings/notifications', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_quota_quota(self, quota_quota_id, **kwargs):  # noqa: E501
        """delete_quota_quota  # noqa: E501

        Delete the quota.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_quota_quota(quota_quota_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str quota_quota_id: Delete the quota. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_quota_quota_with_http_info(quota_quota_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_quota_quota_with_http_info(quota_quota_id, **kwargs)  # noqa: E501
            return data

    def delete_quota_quota_with_http_info(self, quota_quota_id, **kwargs):  # noqa: E501
        """delete_quota_quota  # noqa: E501

        Delete the quota.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_quota_quota_with_http_info(quota_quota_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str quota_quota_id: Delete the quota. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['quota_quota_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_quota_quota" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'quota_quota_id' is set
        if ('quota_quota_id' not in params or
                params['quota_quota_id'] is None):
            raise ValueError("Missing the required parameter `quota_quota_id` when calling `delete_quota_quota`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'quota_quota_id' in params:
            path_params['QuotaQuotaId'] = params['quota_quota_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/quota/quotas/{QuotaQuotaId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_quota_quotas(self, **kwargs):  # noqa: E501
        """delete_quota_quotas  # noqa: E501

        Delete all or matching quotas.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_quota_quotas(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool enforced: Only delete quotas with this enforcement (non-accounting).
        :param bool include_snapshots: Only delete quotas with this setting for include_snapshots.
        :param str zone: Optional named zone to use for user and group resolution.
        :param bool recurse_path_children: If used with the path argument, delete all quotas at that path or any descendent sub-directory.
        :param bool recurse_path_parents: If used with the path argument, delete all quotas at that path or any parent directory.
        :param str persona: Only delete user or group quotas matching this persona (must be used with the corresponding type argument).  Format is <PERSONA_TYPE>:<string/integer>, where PERSONA_TYPE is one of USER, GROUP, SID, ID, or GID.
        :param str path: Only delete quotas matching this path (see also recurse_path_*).
        :param str type: Only delete quotas matching this type.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_quota_quotas_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_quota_quotas_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_quota_quotas_with_http_info(self, **kwargs):  # noqa: E501
        """delete_quota_quotas  # noqa: E501

        Delete all or matching quotas.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_quota_quotas_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool enforced: Only delete quotas with this enforcement (non-accounting).
        :param bool include_snapshots: Only delete quotas with this setting for include_snapshots.
        :param str zone: Optional named zone to use for user and group resolution.
        :param bool recurse_path_children: If used with the path argument, delete all quotas at that path or any descendent sub-directory.
        :param bool recurse_path_parents: If used with the path argument, delete all quotas at that path or any parent directory.
        :param str persona: Only delete user or group quotas matching this persona (must be used with the corresponding type argument).  Format is <PERSONA_TYPE>:<string/integer>, where PERSONA_TYPE is one of USER, GROUP, SID, ID, or GID.
        :param str path: Only delete quotas matching this path (see also recurse_path_*).
        :param str type: Only delete quotas matching this type.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['enforced', 'include_snapshots', 'zone', 'recurse_path_children', 'recurse_path_parents', 'persona', 'path', 'type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_quota_quotas" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'enforced' in params:
            query_params.append(('enforced', params['enforced']))  # noqa: E501
        if 'include_snapshots' in params:
            query_params.append(('include_snapshots', params['include_snapshots']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501
        if 'recurse_path_children' in params:
            query_params.append(('recurse_path_children', params['recurse_path_children']))  # noqa: E501
        if 'recurse_path_parents' in params:
            query_params.append(('recurse_path_parents', params['recurse_path_parents']))  # noqa: E501
        if 'persona' in params:
            query_params.append(('persona', params['persona']))  # noqa: E501
        if 'path' in params:
            query_params.append(('path', params['path']))  # noqa: E501
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/quota/quotas', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_quota_report(self, quota_report_id, **kwargs):  # noqa: E501
        """delete_quota_report  # noqa: E501

        Delete the report.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_quota_report(quota_report_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str quota_report_id: Delete the report. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_quota_report_with_http_info(quota_report_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_quota_report_with_http_info(quota_report_id, **kwargs)  # noqa: E501
            return data

    def delete_quota_report_with_http_info(self, quota_report_id, **kwargs):  # noqa: E501
        """delete_quota_report  # noqa: E501

        Delete the report.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_quota_report_with_http_info(quota_report_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str quota_report_id: Delete the report. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['quota_report_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_quota_report" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'quota_report_id' is set
        if ('quota_report_id' not in params or
                params['quota_report_id'] is None):
            raise ValueError("Missing the required parameter `quota_report_id` when calling `delete_quota_report`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'quota_report_id' in params:
            path_params['QuotaReportId'] = params['quota_report_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/quota/reports/{QuotaReportId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_settings_mapping(self, settings_mapping_id, **kwargs):  # noqa: E501
        """delete_settings_mapping  # noqa: E501

        Delete the mapping.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_settings_mapping(settings_mapping_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str settings_mapping_id: Delete the mapping. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_settings_mapping_with_http_info(settings_mapping_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_settings_mapping_with_http_info(settings_mapping_id, **kwargs)  # noqa: E501
            return data

    def delete_settings_mapping_with_http_info(self, settings_mapping_id, **kwargs):  # noqa: E501
        """delete_settings_mapping  # noqa: E501

        Delete the mapping.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_settings_mapping_with_http_info(settings_mapping_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str settings_mapping_id: Delete the mapping. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['settings_mapping_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_settings_mapping" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'settings_mapping_id' is set
        if ('settings_mapping_id' not in params or
                params['settings_mapping_id'] is None):
            raise ValueError("Missing the required parameter `settings_mapping_id` when calling `delete_settings_mapping`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'settings_mapping_id' in params:
            path_params['SettingsMappingId'] = params['settings_mapping_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/quota/settings/mappings/{SettingsMappingId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_settings_mappings(self, **kwargs):  # noqa: E501
        """delete_settings_mappings  # noqa: E501

        Delete all rules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_settings_mappings(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_settings_mappings_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_settings_mappings_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_settings_mappings_with_http_info(self, **kwargs):  # noqa: E501
        """delete_settings_mappings  # noqa: E501

        Delete all rules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_settings_mappings_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_settings_mappings" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/quota/settings/mappings', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_settings_notification(self, settings_notification_id, **kwargs):  # noqa: E501
        """delete_settings_notification  # noqa: E501

        Delete the notification rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_settings_notification(settings_notification_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str settings_notification_id: Delete the notification rule. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_settings_notification_with_http_info(settings_notification_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_settings_notification_with_http_info(settings_notification_id, **kwargs)  # noqa: E501
            return data

    def delete_settings_notification_with_http_info(self, settings_notification_id, **kwargs):  # noqa: E501
        """delete_settings_notification  # noqa: E501

        Delete the notification rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_settings_notification_with_http_info(settings_notification_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str settings_notification_id: Delete the notification rule. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['settings_notification_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_settings_notification" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'settings_notification_id' is set
        if ('settings_notification_id' not in params or
                params['settings_notification_id'] is None):
            raise ValueError("Missing the required parameter `settings_notification_id` when calling `delete_settings_notification`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'settings_notification_id' in params:
            path_params['SettingsNotificationId'] = params['settings_notification_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/quota/settings/notifications/{SettingsNotificationId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_settings_notifications(self, **kwargs):  # noqa: E501
        """delete_settings_notifications  # noqa: E501

        Delete all rules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_settings_notifications(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_settings_notifications_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_settings_notifications_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_settings_notifications_with_http_info(self, **kwargs):  # noqa: E501
        """delete_settings_notifications  # noqa: E501

        Delete all rules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_settings_notifications_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_settings_notifications" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/quota/settings/notifications', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_quota_license(self, **kwargs):  # noqa: E501
        """get_quota_license  # noqa: E501

        Retrieve license information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_quota_license(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: LicenseLicense
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_quota_license_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_quota_license_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_quota_license_with_http_info(self, **kwargs):  # noqa: E501
        """get_quota_license  # noqa: E501

        Retrieve license information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_quota_license_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: LicenseLicense
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_quota_license" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/5/quota/license', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LicenseLicense',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_quota_quota(self, quota_quota_id, **kwargs):  # noqa: E501
        """get_quota_quota  # noqa: E501

        Retrieve quota information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_quota_quota(quota_quota_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str quota_quota_id: Retrieve quota information. (required)
        :param bool resolve_names: If true, resolve group and user names in personas.
        :param str zone: Optional named zone to use for user and group resolution.
        :return: QuotaQuotas
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_quota_quota_with_http_info(quota_quota_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_quota_quota_with_http_info(quota_quota_id, **kwargs)  # noqa: E501
            return data

    def get_quota_quota_with_http_info(self, quota_quota_id, **kwargs):  # noqa: E501
        """get_quota_quota  # noqa: E501

        Retrieve quota information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_quota_quota_with_http_info(quota_quota_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str quota_quota_id: Retrieve quota information. (required)
        :param bool resolve_names: If true, resolve group and user names in personas.
        :param str zone: Optional named zone to use for user and group resolution.
        :return: QuotaQuotas
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['quota_quota_id', 'resolve_names', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_quota_quota" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'quota_quota_id' is set
        if ('quota_quota_id' not in params or
                params['quota_quota_id'] is None):
            raise ValueError("Missing the required parameter `quota_quota_id` when calling `get_quota_quota`")  # noqa: E501

        if ('zone' in params and
                len(params['zone']) > 255):
            raise ValueError("Invalid value for parameter `zone` when calling `get_quota_quota`, length must be less than or equal to `255`")  # noqa: E501
        if ('zone' in params and
                len(params['zone']) < 0):
            raise ValueError("Invalid value for parameter `zone` when calling `get_quota_quota`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'quota_quota_id' in params:
            path_params['QuotaQuotaId'] = params['quota_quota_id']  # noqa: E501

        query_params = []
        if 'resolve_names' in params:
            query_params.append(('resolve_names', params['resolve_names']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/quota/quotas/{QuotaQuotaId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QuotaQuotas',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_quota_quotas_summary(self, **kwargs):  # noqa: E501
        """get_quota_quotas_summary  # noqa: E501

        Return summary information about quotas.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_quota_quotas_summary(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: QuotaQuotasSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_quota_quotas_summary_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_quota_quotas_summary_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_quota_quotas_summary_with_http_info(self, **kwargs):  # noqa: E501
        """get_quota_quotas_summary  # noqa: E501

        Return summary information about quotas.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_quota_quotas_summary_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: QuotaQuotasSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_quota_quotas_summary" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/quota/quotas-summary', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QuotaQuotasSummary',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_quota_report(self, quota_report_id, **kwargs):  # noqa: E501
        """get_quota_report  # noqa: E501

        Retrieve report data (XML) or contents (meta-data).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_quota_report(quota_report_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str quota_report_id: Retrieve report data (XML) or contents (meta-data). (required)
        :param bool contents: Display JSON meta-data contents instead of report data.
        :return: ReportAbout
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_quota_report_with_http_info(quota_report_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_quota_report_with_http_info(quota_report_id, **kwargs)  # noqa: E501
            return data

    def get_quota_report_with_http_info(self, quota_report_id, **kwargs):  # noqa: E501
        """get_quota_report  # noqa: E501

        Retrieve report data (XML) or contents (meta-data).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_quota_report_with_http_info(quota_report_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str quota_report_id: Retrieve report data (XML) or contents (meta-data). (required)
        :param bool contents: Display JSON meta-data contents instead of report data.
        :return: ReportAbout
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['quota_report_id', 'contents']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_quota_report" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'quota_report_id' is set
        if ('quota_report_id' not in params or
                params['quota_report_id'] is None):
            raise ValueError("Missing the required parameter `quota_report_id` when calling `get_quota_report`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'quota_report_id' in params:
            path_params['QuotaReportId'] = params['quota_report_id']  # noqa: E501

        query_params = []
        if 'contents' in params:
            query_params.append(('contents', params['contents']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/quota/reports/{QuotaReportId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReportAbout',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_settings_mapping(self, settings_mapping_id, **kwargs):  # noqa: E501
        """get_settings_mapping  # noqa: E501

        Retrieve the mapping information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_settings_mapping(settings_mapping_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str settings_mapping_id: Retrieve the mapping information. (required)
        :return: SettingsMappings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_settings_mapping_with_http_info(settings_mapping_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_settings_mapping_with_http_info(settings_mapping_id, **kwargs)  # noqa: E501
            return data

    def get_settings_mapping_with_http_info(self, settings_mapping_id, **kwargs):  # noqa: E501
        """get_settings_mapping  # noqa: E501

        Retrieve the mapping information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_settings_mapping_with_http_info(settings_mapping_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str settings_mapping_id: Retrieve the mapping information. (required)
        :return: SettingsMappings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['settings_mapping_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_settings_mapping" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'settings_mapping_id' is set
        if ('settings_mapping_id' not in params or
                params['settings_mapping_id'] is None):
            raise ValueError("Missing the required parameter `settings_mapping_id` when calling `get_settings_mapping`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'settings_mapping_id' in params:
            path_params['SettingsMappingId'] = params['settings_mapping_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/quota/settings/mappings/{SettingsMappingId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SettingsMappings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_settings_notification(self, settings_notification_id, **kwargs):  # noqa: E501
        """get_settings_notification  # noqa: E501

        Retrieve notification rule information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_settings_notification(settings_notification_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str settings_notification_id: Retrieve notification rule information. (required)
        :return: QuotaNotifications
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_settings_notification_with_http_info(settings_notification_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_settings_notification_with_http_info(settings_notification_id, **kwargs)  # noqa: E501
            return data

    def get_settings_notification_with_http_info(self, settings_notification_id, **kwargs):  # noqa: E501
        """get_settings_notification  # noqa: E501

        Retrieve notification rule information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_settings_notification_with_http_info(settings_notification_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str settings_notification_id: Retrieve notification rule information. (required)
        :return: QuotaNotifications
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['settings_notification_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_settings_notification" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'settings_notification_id' is set
        if ('settings_notification_id' not in params or
                params['settings_notification_id'] is None):
            raise ValueError("Missing the required parameter `settings_notification_id` when calling `get_settings_notification`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'settings_notification_id' in params:
            path_params['SettingsNotificationId'] = params['settings_notification_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/quota/settings/notifications/{SettingsNotificationId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QuotaNotifications',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_settings_reports(self, **kwargs):  # noqa: E501
        """get_settings_reports  # noqa: E501

        List all settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_settings_reports(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :return: SettingsReports
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_settings_reports_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_settings_reports_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_settings_reports_with_http_info(self, **kwargs):  # noqa: E501
        """get_settings_reports  # noqa: E501

        List all settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_settings_reports_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scope: If specified as \"effective\" or not specified, all fields are returned.  If specified as \"user\", only fields with non-default values are shown.  If specified as \"default\", the original values are returned.
        :return: SettingsReports
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['scope']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_settings_reports" % key
                )
            params[key] = val
        del params['kwargs']

        if ('scope' in params and
                len(params['scope']) > 255):
            raise ValueError("Invalid value for parameter `scope` when calling `get_settings_reports`, length must be less than or equal to `255`")  # noqa: E501
        if ('scope' in params and
                len(params['scope']) < 0):
            raise ValueError("Invalid value for parameter `scope` when calling `get_settings_reports`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'scope' in params:
            query_params.append(('scope', params['scope']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/quota/settings/reports', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SettingsReports',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_quota_quotas(self, **kwargs):  # noqa: E501
        """list_quota_quotas  # noqa: E501

        List all or matching quotas. Can also be used to retrieve quota state from existing reports. For any query argument not supplied, the default behavior is return all.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_quota_quotas(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool enforced: Only list quotas with this enforcement (non-accounting).
        :param bool include_snapshots: Only list quotas with this setting for include_snapshots.
        :param str zone: Optional named zone to use for user and group resolution.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param bool recurse_path_children: If used with the path argument, match all quotas at that path or any descendent sub-directory.
        :param bool resolve_names: If true, resolve group and user names in personas.
        :param bool recurse_path_parents: If used with the path argument, match all quotas at that path or any parent directory.
        :param str persona: Only list user or group quotas matching this persona (must be used with the corresponding type argument).  Format is <PERSONA_TYPE>:<string/integer>, where PERSONA_TYPE is one of USER, GROUP, SID, ID, or GID.
        :param int limit: Return no more than this many results at once (see resume).
        :param bool exceeded: Set to true to only list quotas which have exceeded one or more of their thresholds.
        :param str path: Only list quotas matching this path (see also recurse_path_*).
        :param str type: Only list quotas matching this type.
        :param str report_id: Use the named report as a source rather than the live quotas. See the /q/quota/reports resource for a list of valid reports.
        :return: QuotaQuotasExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_quota_quotas_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_quota_quotas_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_quota_quotas_with_http_info(self, **kwargs):  # noqa: E501
        """list_quota_quotas  # noqa: E501

        List all or matching quotas. Can also be used to retrieve quota state from existing reports. For any query argument not supplied, the default behavior is return all.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_quota_quotas_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool enforced: Only list quotas with this enforcement (non-accounting).
        :param bool include_snapshots: Only list quotas with this setting for include_snapshots.
        :param str zone: Optional named zone to use for user and group resolution.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param bool recurse_path_children: If used with the path argument, match all quotas at that path or any descendent sub-directory.
        :param bool resolve_names: If true, resolve group and user names in personas.
        :param bool recurse_path_parents: If used with the path argument, match all quotas at that path or any parent directory.
        :param str persona: Only list user or group quotas matching this persona (must be used with the corresponding type argument).  Format is <PERSONA_TYPE>:<string/integer>, where PERSONA_TYPE is one of USER, GROUP, SID, ID, or GID.
        :param int limit: Return no more than this many results at once (see resume).
        :param bool exceeded: Set to true to only list quotas which have exceeded one or more of their thresholds.
        :param str path: Only list quotas matching this path (see also recurse_path_*).
        :param str type: Only list quotas matching this type.
        :param str report_id: Use the named report as a source rather than the live quotas. See the /q/quota/reports resource for a list of valid reports.
        :return: QuotaQuotasExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['enforced', 'include_snapshots', 'zone', 'resume', 'recurse_path_children', 'resolve_names', 'recurse_path_parents', 'persona', 'limit', 'exceeded', 'path', 'type', 'report_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_quota_quotas" % key
                )
            params[key] = val
        del params['kwargs']

        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_quota_quotas`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_quota_quotas`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_quota_quotas`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_quota_quotas`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'enforced' in params:
            query_params.append(('enforced', params['enforced']))  # noqa: E501
        if 'include_snapshots' in params:
            query_params.append(('include_snapshots', params['include_snapshots']))  # noqa: E501
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'recurse_path_children' in params:
            query_params.append(('recurse_path_children', params['recurse_path_children']))  # noqa: E501
        if 'resolve_names' in params:
            query_params.append(('resolve_names', params['resolve_names']))  # noqa: E501
        if 'recurse_path_parents' in params:
            query_params.append(('recurse_path_parents', params['recurse_path_parents']))  # noqa: E501
        if 'persona' in params:
            query_params.append(('persona', params['persona']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'exceeded' in params:
            query_params.append(('exceeded', params['exceeded']))  # noqa: E501
        if 'path' in params:
            query_params.append(('path', params['path']))  # noqa: E501
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501
        if 'report_id' in params:
            query_params.append(('report_id', params['report_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/quota/quotas', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QuotaQuotasExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_quota_reports(self, **kwargs):  # noqa: E501
        """list_quota_reports  # noqa: E501

        List all or matching reports.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_quota_reports(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: Order results by this field.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str generated: Only list reports matching this source.
        :param int limit: Return no more than this many results at once (see resume).
        :param str type: Only list reports matching this type.
        :param str dir: The direction of the sort.
        :return: QuotaReports
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_quota_reports_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_quota_reports_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_quota_reports_with_http_info(self, **kwargs):  # noqa: E501
        """list_quota_reports  # noqa: E501

        List all or matching reports.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_quota_reports_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: Order results by this field.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str generated: Only list reports matching this source.
        :param int limit: Return no more than this many results at once (see resume).
        :param str type: Only list reports matching this type.
        :param str dir: The direction of the sort.
        :return: QuotaReports
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'resume', 'generated', 'limit', 'type', 'dir']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_quota_reports" % key
                )
            params[key] = val
        del params['kwargs']

        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_quota_reports`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_quota_reports`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_quota_reports`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_quota_reports`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_quota_reports`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'generated' in params:
            query_params.append(('generated', params['generated']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/quota/reports', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QuotaReports',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_settings_mappings(self, **kwargs):  # noqa: E501
        """list_settings_mappings  # noqa: E501

        List all rules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_settings_mappings(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SettingsMappings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_settings_mappings_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_settings_mappings_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_settings_mappings_with_http_info(self, **kwargs):  # noqa: E501
        """list_settings_mappings  # noqa: E501

        List all rules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_settings_mappings_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SettingsMappings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_settings_mappings" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/quota/settings/mappings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SettingsMappings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_settings_notifications(self, **kwargs):  # noqa: E501
        """list_settings_notifications  # noqa: E501

        List all rules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_settings_notifications(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: QuotaNotificationsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_settings_notifications_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_settings_notifications_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_settings_notifications_with_http_info(self, **kwargs):  # noqa: E501
        """list_settings_notifications  # noqa: E501

        List all rules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_settings_notifications_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: QuotaNotificationsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_settings_notifications" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/quota/settings/notifications', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QuotaNotificationsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_quota_quota(self, quota_quota, quota_quota_id, **kwargs):  # noqa: E501
        """update_quota_quota  # noqa: E501

        Modify quota. All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_quota_quota(quota_quota, quota_quota_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param QuotaQuota quota_quota: (required)
        :param str quota_quota_id: Modify quota. All input fields are optional, but one or more must be supplied. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_quota_quota_with_http_info(quota_quota, quota_quota_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_quota_quota_with_http_info(quota_quota, quota_quota_id, **kwargs)  # noqa: E501
            return data

    def update_quota_quota_with_http_info(self, quota_quota, quota_quota_id, **kwargs):  # noqa: E501
        """update_quota_quota  # noqa: E501

        Modify quota. All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_quota_quota_with_http_info(quota_quota, quota_quota_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param QuotaQuota quota_quota: (required)
        :param str quota_quota_id: Modify quota. All input fields are optional, but one or more must be supplied. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['quota_quota', 'quota_quota_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_quota_quota" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'quota_quota' is set
        if ('quota_quota' not in params or
                params['quota_quota'] is None):
            raise ValueError("Missing the required parameter `quota_quota` when calling `update_quota_quota`")  # noqa: E501
        # verify the required parameter 'quota_quota_id' is set
        if ('quota_quota_id' not in params or
                params['quota_quota_id'] is None):
            raise ValueError("Missing the required parameter `quota_quota_id` when calling `update_quota_quota`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'quota_quota_id' in params:
            path_params['QuotaQuotaId'] = params['quota_quota_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'quota_quota' in params:
            body_params = params['quota_quota']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/quota/quotas/{QuotaQuotaId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_settings_mapping(self, settings_mapping, settings_mapping_id, **kwargs):  # noqa: E501
        """update_settings_mapping  # noqa: E501

        Modify the mapping.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_settings_mapping(settings_mapping, settings_mapping_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SettingsMappingExtended settings_mapping: (required)
        :param str settings_mapping_id: Modify the mapping. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_settings_mapping_with_http_info(settings_mapping, settings_mapping_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_settings_mapping_with_http_info(settings_mapping, settings_mapping_id, **kwargs)  # noqa: E501
            return data

    def update_settings_mapping_with_http_info(self, settings_mapping, settings_mapping_id, **kwargs):  # noqa: E501
        """update_settings_mapping  # noqa: E501

        Modify the mapping.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_settings_mapping_with_http_info(settings_mapping, settings_mapping_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SettingsMappingExtended settings_mapping: (required)
        :param str settings_mapping_id: Modify the mapping. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['settings_mapping', 'settings_mapping_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_settings_mapping" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'settings_mapping' is set
        if ('settings_mapping' not in params or
                params['settings_mapping'] is None):
            raise ValueError("Missing the required parameter `settings_mapping` when calling `update_settings_mapping`")  # noqa: E501
        # verify the required parameter 'settings_mapping_id' is set
        if ('settings_mapping_id' not in params or
                params['settings_mapping_id'] is None):
            raise ValueError("Missing the required parameter `settings_mapping_id` when calling `update_settings_mapping`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'settings_mapping_id' in params:
            path_params['SettingsMappingId'] = params['settings_mapping_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'settings_mapping' in params:
            body_params = params['settings_mapping']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/quota/settings/mappings/{SettingsMappingId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_settings_notification(self, settings_notification, settings_notification_id, **kwargs):  # noqa: E501
        """update_settings_notification  # noqa: E501

        Modify notification rule. All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_settings_notification(settings_notification, settings_notification_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param QuotaNotification settings_notification: (required)
        :param str settings_notification_id: Modify notification rule. All input fields are optional, but one or more must be supplied. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_settings_notification_with_http_info(settings_notification, settings_notification_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_settings_notification_with_http_info(settings_notification, settings_notification_id, **kwargs)  # noqa: E501
            return data

    def update_settings_notification_with_http_info(self, settings_notification, settings_notification_id, **kwargs):  # noqa: E501
        """update_settings_notification  # noqa: E501

        Modify notification rule. All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_settings_notification_with_http_info(settings_notification, settings_notification_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param QuotaNotification settings_notification: (required)
        :param str settings_notification_id: Modify notification rule. All input fields are optional, but one or more must be supplied. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['settings_notification', 'settings_notification_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_settings_notification" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'settings_notification' is set
        if ('settings_notification' not in params or
                params['settings_notification'] is None):
            raise ValueError("Missing the required parameter `settings_notification` when calling `update_settings_notification`")  # noqa: E501
        # verify the required parameter 'settings_notification_id' is set
        if ('settings_notification_id' not in params or
                params['settings_notification_id'] is None):
            raise ValueError("Missing the required parameter `settings_notification_id` when calling `update_settings_notification`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'settings_notification_id' in params:
            path_params['SettingsNotificationId'] = params['settings_notification_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'settings_notification' in params:
            body_params = params['settings_notification']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/quota/settings/notifications/{SettingsNotificationId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_settings_reports(self, settings_reports, **kwargs):  # noqa: E501
        """update_settings_reports  # noqa: E501

        Modify one or more settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_settings_reports(settings_reports, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SettingsReportsExtended settings_reports: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_settings_reports_with_http_info(settings_reports, **kwargs)  # noqa: E501
        else:
            (data) = self.update_settings_reports_with_http_info(settings_reports, **kwargs)  # noqa: E501
            return data

    def update_settings_reports_with_http_info(self, settings_reports, **kwargs):  # noqa: E501
        """update_settings_reports  # noqa: E501

        Modify one or more settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_settings_reports_with_http_info(settings_reports, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SettingsReportsExtended settings_reports: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['settings_reports']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_settings_reports" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'settings_reports' is set
        if ('settings_reports' not in params or
                params['settings_reports'] is None):
            raise ValueError("Missing the required parameter `settings_reports` when calling `update_settings_reports`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'settings_reports' in params:
            body_params = params['settings_reports']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/quota/settings/reports', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
