/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.struts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Form;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorResources;
import org.apache.commons.validator.Var;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.ModuleUtils;
import org.apache.struts.validator.Resources;
import org.apache.velocity.tools.struts.StrutsUtils;
import org.apache.velocity.tools.view.context.ViewContext;

public class ValidatorTool {
    protected ViewContext context;
    protected ServletContext app;
    protected HttpServletRequest request;
    protected HttpSession session;
    protected ValidatorResources resources;
    private static final String HTML_BEGIN_COMMENT = "\n<!-- Begin \n";
    private static final String HTML_END_COMMENT = "//End --> \n";
    private boolean xhtml = false;
    private boolean htmlComment = true;
    private boolean cdata = true;
    private String formName = null;
    private String methodName = null;
    private String src = null;
    private int page = 0;
    protected String jsFormName = null;
    private static final Comparator actionComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            ValidatorAction va1 = (ValidatorAction)o1;
            ValidatorAction va2 = (ValidatorAction)o2;
            if (!(va1.getDepends() != null && va1.getDepends().length() != 0 || va2.getDepends() != null && va2.getDepends().length() != 0)) {
                return 0;
            }
            if (va1.getDepends() != null && va1.getDepends().length() > 0 && (va2.getDepends() == null || va2.getDepends().length() == 0)) {
                return 1;
            }
            if ((va1.getDepends() == null || va1.getDepends().length() == 0) && va2.getDepends() != null && va2.getDepends().length() > 0) {
                return -1;
            }
            return va1.getDependencyList().size() - va2.getDependencyList().size();
        }
    };

    public void init(Object obj) {
        ActionConfig config;
        if (!(obj instanceof ViewContext)) {
            throw new IllegalArgumentException("Tool can only be initialized with a ViewContext");
        }
        this.context = (ViewContext)obj;
        this.request = this.context.getRequest();
        this.session = this.request.getSession(false);
        this.app = this.context.getServletContext();
        Boolean b = (Boolean)this.context.getAttribute("XHTML");
        if (b != null) {
            this.xhtml = b;
        }
        if ((config = (ActionConfig)this.request.getAttribute("org.apache.struts.action.mapping.instance")) != null) {
            this.formName = config.getAttribute();
        }
        ModuleConfig mconfig = ModuleUtils.getInstance().getModuleConfig(this.request, this.app);
        this.resources = (ValidatorResources)this.app.getAttribute("org.apache.commons.validator.VALIDATOR_RESOURCES" + mconfig.getPrefix());
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public String getMethod() {
        return this.methodName;
    }

    public void setMethod(String methodName) {
        this.methodName = methodName;
    }

    public boolean getHtmlComment() {
        return this.htmlComment;
    }

    public void setHtmlComment(boolean htmlComment) {
        this.htmlComment = htmlComment;
    }

    public String getSrc() {
        return this.src;
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public boolean getCdata() {
        return this.cdata;
    }

    public void setCdata(boolean cdata) {
        this.cdata = cdata;
    }

    public String getJavascript() throws Exception {
        return this.getJavascript(this.formName);
    }

    public String getJavascript(String formName) throws Exception {
        this.formName = formName;
        return this.getJavascript(formName, true);
    }

    public String getDynamicJavascript() throws Exception {
        return this.getDynamicJavascript(this.formName);
    }

    public String getStaticJavascript() throws Exception {
        StringBuffer results = new StringBuffer();
        results.append(this.getStartElement());
        if (this.htmlComment) {
            results.append(HTML_BEGIN_COMMENT);
        }
        results.append(this.getJavascriptStaticMethods(this.resources));
        results.append(this.getJavascriptEnd());
        return results.toString();
    }

    public String getDynamicJavascript(String formName) throws Exception {
        this.formName = formName;
        return this.getJavascript(formName, false);
    }

    protected String getJavascript(String formName, boolean getStatic) throws Exception {
        StringBuffer results = new StringBuffer();
        Locale locale = StrutsUtils.getLocale(this.request, this.session);
        Form form = this.resources.getForm(locale, formName);
        if (form != null) {
            results.append(this.getDynamicJavascript(this.resources, locale, form));
        }
        if (getStatic) {
            results.append(this.getJavascriptStaticMethods(this.resources));
        }
        if (form != null) {
            results.append(this.getJavascriptEnd());
        }
        return results.toString();
    }

    protected String getDynamicJavascript(ValidatorResources resources, Locale locale, Form form) {
        String formName;
        StringBuffer results = new StringBuffer();
        MessageResources messages = StrutsUtils.getMessageResources(this.request, this.app);
        List actions = this.createActionList(resources, form);
        String methods = this.createMethods(actions);
        this.jsFormName = formName = form.getName();
        if (this.jsFormName.charAt(0) == '/') {
            String mappingName = StrutsUtils.getActionMappingName(this.jsFormName);
            ModuleConfig mconfig = ModuleUtils.getInstance().getModuleConfig(this.request, this.app);
            ActionConfig mapping = mconfig.findActionConfig(mappingName);
            if (mapping == null) {
                throw new NullPointerException("Cannot retrieve mapping for action " + mappingName);
            }
            this.jsFormName = mapping.getAttribute();
        }
        results.append(this.getJavascriptBegin(methods));
        Iterator i = actions.iterator();
        while (i.hasNext()) {
            ValidatorAction va = (ValidatorAction)i.next();
            int jscriptVar = 0;
            String functionName = null;
            functionName = va.getJsFunctionName() != null && va.getJsFunctionName().length() > 0 ? va.getJsFunctionName() : va.getName();
            results.append("    function ");
            results.append(this.jsFormName);
            results.append("_");
            results.append(functionName);
            results.append(" () { \n");
            Iterator x = form.getFields().iterator();
            while (x.hasNext()) {
                Field field = (Field)x.next();
                if (field.isIndexed() || field.getPage() != this.page || !field.isDependency(va.getName())) continue;
                String message = Resources.getMessage((ServletContext)this.app, (HttpServletRequest)this.request, (MessageResources)messages, (Locale)locale, (ValidatorAction)va, (Field)field);
                message = message != null ? message : "";
                results.append("     this.a");
                results.append(jscriptVar++);
                results.append(" = new Array(\"");
                results.append(field.getKey());
                results.append("\", \"");
                results.append(this.escapeJavascript(message));
                results.append("\", ");
                results.append("new Function (\"varName\", \"");
                Map vars = field.getVars();
                Iterator varsIterator = vars.keySet().iterator();
                while (varsIterator.hasNext()) {
                    String varName = (String)varsIterator.next();
                    Var var = (Var)vars.get(varName);
                    String varValue = Resources.getVarValue((Var)var, (ServletContext)this.app, (HttpServletRequest)this.request, (boolean)false);
                    String jsType = var.getJsType();
                    if (varName.startsWith("field")) continue;
                    results.append("this.");
                    results.append(varName);
                    String escapedVarValue = this.escapeJavascript(varValue);
                    if ("int".equalsIgnoreCase(jsType)) {
                        results.append("=");
                        results.append(escapedVarValue);
                        results.append("; ");
                        continue;
                    }
                    if ("regexp".equalsIgnoreCase(jsType)) {
                        results.append("=/");
                        results.append(escapedVarValue);
                        results.append("/; ");
                        continue;
                    }
                    if ("string".equalsIgnoreCase(jsType)) {
                        results.append("='");
                        results.append(escapedVarValue);
                        results.append("'; ");
                        continue;
                    }
                    if ("mask".equalsIgnoreCase(varName)) {
                        results.append("=/");
                        results.append(escapedVarValue);
                        results.append("/; ");
                        continue;
                    }
                    results.append("='");
                    results.append(escapedVarValue);
                    results.append("'; ");
                }
                results.append(" return this[varName];\"));\n");
            }
            results.append("    } \n\n");
        }
        return results.toString();
    }

    protected String escapeJavascript(String str) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        if (length == 0) {
            return str;
        }
        StringBuffer out = new StringBuffer(length + 4);
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (c == '\"' || c == '\'' || c == '\\' || c == '\n' || c == '\r') {
                out.append('\\');
            }
            out.append(c);
        }
        return out.toString();
    }

    protected String createMethods(List actions) {
        String methodOperator = " && ";
        StringBuffer methods = null;
        Iterator i = actions.iterator();
        while (i.hasNext()) {
            ValidatorAction va = (ValidatorAction)i.next();
            if (methods == null) {
                methods = new StringBuffer(va.getMethod());
            } else {
                methods.append(methodOperator);
                methods.append(va.getMethod());
            }
            methods.append("(form)");
        }
        return methods.toString();
    }

    protected List createActionList(ValidatorResources resources, Form form) {
        ArrayList actionMethods = new ArrayList();
        Iterator i = form.getFields().iterator();
        while (i.hasNext()) {
            Field field = (Field)i.next();
            Iterator x = field.getDependencyList().iterator();
            while (x.hasNext()) {
                Object o = x.next();
                if (o == null || actionMethods.contains(o)) continue;
                actionMethods.add(o);
            }
        }
        ArrayList<ValidatorAction> actions = new ArrayList<ValidatorAction>();
        Iterator i2 = actionMethods.iterator();
        while (i2.hasNext()) {
            String depends = (String)i2.next();
            ValidatorAction va = resources.getValidatorAction(depends);
            if (va == null) {
                throw new NullPointerException("Depends string \"" + depends + "\" was not found in validator-rules.xml.");
            }
            String javascript = va.getJavascript();
            if (javascript != null && javascript.length() > 0) {
                actions.add(va);
                continue;
            }
            i2.remove();
        }
        Collections.sort(actions, actionComparator);
        return actions;
    }

    protected String getJavascriptBegin(String methods) {
        StringBuffer sb = new StringBuffer();
        String name = this.jsFormName.replace('/', '_');
        name = this.jsFormName.substring(0, 1).toUpperCase() + this.jsFormName.substring(1, this.jsFormName.length());
        sb.append(this.getStartElement());
        if (this.xhtml && this.cdata) {
            sb.append("<![CDATA[\r\n");
        }
        if (!this.xhtml && this.htmlComment) {
            sb.append(HTML_BEGIN_COMMENT);
        }
        sb.append("\n     var bCancel = false; \n\n");
        if (this.methodName == null || this.methodName.length() == 0) {
            sb.append("    function validate");
            sb.append(name);
        } else {
            sb.append("    function ");
            sb.append(this.methodName);
        }
        sb.append("(form) {");
        sb.append("                                                                   \n");
        sb.append("        if (bCancel) \n");
        sb.append("      return true; \n");
        sb.append("        else \n");
        if (methods == null || methods.length() == 0) {
            sb.append("       return true; \n");
        } else {
            sb.append(" var formValidationResult;\n");
            sb.append("       formValidationResult = " + methods + "; \n");
            sb.append("     return (formValidationResult == 1);\n");
        }
        sb.append("   } \n\n");
        return sb.toString();
    }

    protected String getJavascriptStaticMethods(ValidatorResources resources) {
        StringBuffer sb = new StringBuffer("\n\n");
        Iterator actions = resources.getValidatorActions().values().iterator();
        while (actions.hasNext()) {
            String javascript;
            ValidatorAction va = (ValidatorAction)actions.next();
            if (va == null || (javascript = va.getJavascript()) == null || javascript.length() <= 0) continue;
            sb.append(javascript + "\n");
        }
        return sb.toString();
    }

    protected String getJavascriptEnd() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        if (!this.xhtml && this.htmlComment) {
            sb.append(HTML_END_COMMENT);
        }
        if (this.xhtml && this.cdata) {
            sb.append("]]>\r\n");
        }
        sb.append("</script>\n\n");
        return sb.toString();
    }

    private String getStartElement() {
        StringBuffer start = new StringBuffer("<script type=\"text/javascript\"");
        if (!this.xhtml) {
            start.append(" language=\"Javascript1.1\"");
        }
        if (this.src != null) {
            start.append(" src=\"" + this.src + "\"");
        }
        start.append("> \n");
        return start.toString();
    }
}

