/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.ValidationException;
import net.masterthought.cucumber.json.Feature;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReportParser {
    private static final Logger LOG = LogManager.getLogger(ReportParser.class);
    private final ObjectMapper mapper = new ObjectMapper();
    private final Configuration configuration;

    public ReportParser(Configuration configuration) {
        this.configuration = configuration;
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        InjectableValues.Std values = new InjectableValues.Std().addValue(Configuration.class, (Object)configuration);
        this.mapper.setInjectableValues(values);
    }

    public List<Feature> parseJsonFiles(List<String> jsonFiles) {
        if (jsonFiles.isEmpty()) {
            throw new ValidationException("None report file was added!");
        }
        ArrayList<Feature> featureResults = new ArrayList<Feature>();
        for (int i = 0; i < jsonFiles.size(); ++i) {
            String jsonFile = jsonFiles.get(i);
            Feature[] features = this.parseForFeature(jsonFile);
            LOG.info("File '{}' contain {} features", (Object)jsonFile, (Object)features.length);
            this.setMetadata(features, jsonFile, i);
            featureResults.addAll(Arrays.asList(features));
        }
        if (featureResults.isEmpty()) {
            throw new ValidationException("Passed files have no features!");
        }
        return featureResults;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Feature[] parseForFeature(String jsonFile) {
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(jsonFile), StandardCharsets.UTF_8);){
            Object[] features = this.mapper.readValue((Reader)reader, Feature[].class);
            if (ArrayUtils.isEmpty(features)) {
                LOG.info("File '{}' does not contain features", (Object)jsonFile);
            }
            Object[] objectArray = features;
            return objectArray;
        }
        catch (JsonMappingException e) {
            throw new ValidationException(String.format("File '%s' is not proper Cucumber report!", jsonFile), e);
        }
        catch (IOException e) {
            throw new ValidationException(e);
        }
    }

    private void setMetadata(Feature[] features, String jsonFile, int jsonFileNo) {
        for (Feature feature : features) {
            feature.setMetaData(jsonFile, jsonFileNo, this.configuration);
        }
    }
}

