"""
Type annotations for batch service client.

[Open documentation](./client.md)

Usage::

    ```python
    import boto3
    from mypy_boto3_batch import BatchClient

    client: BatchClient = boto3.client("batch")
    ```
"""
import sys
from typing import Any, Dict, List, Type, overload

from botocore.client import ClientMeta

from .literals import (
    CEStateType,
    CETypeType,
    JobDefinitionTypeType,
    JobStatusType,
    JQStateType,
    PlatformCapabilityType,
)
from .paginator import (
    DescribeComputeEnvironmentsPaginator,
    DescribeJobDefinitionsPaginator,
    DescribeJobQueuesPaginator,
    ListJobsPaginator,
)
from .type_defs import (
    ArrayPropertiesTypeDef,
    ComputeEnvironmentOrderTypeDef,
    ComputeResourceTypeDef,
    ComputeResourceUpdateTypeDef,
    ContainerOverridesTypeDef,
    ContainerPropertiesTypeDef,
    CreateComputeEnvironmentResponseTypeDef,
    CreateJobQueueResponseTypeDef,
    DescribeComputeEnvironmentsResponseTypeDef,
    DescribeJobDefinitionsResponseTypeDef,
    DescribeJobQueuesResponseTypeDef,
    DescribeJobsResponseTypeDef,
    JobDependencyTypeDef,
    JobTimeoutTypeDef,
    ListJobsResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    NodeOverridesTypeDef,
    NodePropertiesTypeDef,
    RegisterJobDefinitionResponseTypeDef,
    RetryStrategyTypeDef,
    SubmitJobResponseTypeDef,
    UpdateComputeEnvironmentResponseTypeDef,
    UpdateJobQueueResponseTypeDef,
)

if sys.version_info >= (3, 8):
    from typing import Literal
else:
    from typing_extensions import Literal


__all__ = ("BatchClient",)


class BotocoreClientError(BaseException):
    MSG_TEMPLATE: str

    def __init__(self, error_response: Dict[str, Any], operation_name: str) -> None:
        self.response: Dict[str, Any]
        self.operation_name: str


class Exceptions:
    ClientError: Type[BotocoreClientError]
    ClientException: Type[BotocoreClientError]
    ServerException: Type[BotocoreClientError]


class BatchClient:
    """
    [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.84/reference/services/batch.html#Batch.Client)
    [Show boto3-stubs documentation](./client.md)
    """

    meta: ClientMeta
    exceptions: Exceptions

    def can_paginate(self, operation_name: str) -> bool:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.84/reference/services/batch.html#Batch.Client.can_paginate)
        [Show boto3-stubs documentation](./client.md#can_paginate)
        """

    def cancel_job(self, jobId: str, reason: str) -> Dict[str, Any]:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.84/reference/services/batch.html#Batch.Client.cancel_job)
        [Show boto3-stubs documentation](./client.md#cancel_job)
        """

    def create_compute_environment(
        self,
        computeEnvironmentName: str,
        type: CETypeType,
        state: CEStateType = None,
        computeResources: "ComputeResourceTypeDef" = None,
        serviceRole: str = None,
        tags: Dict[str, str] = None,
    ) -> CreateComputeEnvironmentResponseTypeDef:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.84/reference/services/batch.html#Batch.Client.create_compute_environment)
        [Show boto3-stubs documentation](./client.md#create_compute_environment)
        """

    def create_job_queue(
        self,
        jobQueueName: str,
        priority: int,
        computeEnvironmentOrder: List["ComputeEnvironmentOrderTypeDef"],
        state: JQStateType = None,
        tags: Dict[str, str] = None,
    ) -> CreateJobQueueResponseTypeDef:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.84/reference/services/batch.html#Batch.Client.create_job_queue)
        [Show boto3-stubs documentation](./client.md#create_job_queue)
        """

    def delete_compute_environment(self, computeEnvironment: str) -> Dict[str, Any]:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.84/reference/services/batch.html#Batch.Client.delete_compute_environment)
        [Show boto3-stubs documentation](./client.md#delete_compute_environment)
        """

    def delete_job_queue(self, jobQueue: str) -> Dict[str, Any]:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.84/reference/services/batch.html#Batch.Client.delete_job_queue)
        [Show boto3-stubs documentation](./client.md#delete_job_queue)
        """

    def deregister_job_definition(self, jobDefinition: str) -> Dict[str, Any]:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.84/reference/services/batch.html#Batch.Client.deregister_job_definition)
        [Show boto3-stubs documentation](./client.md#deregister_job_definition)
        """

    def describe_compute_environments(
        self, computeEnvironments: List[str] = None, maxResults: int = None, nextToken: str = None
    ) -> DescribeComputeEnvironmentsResponseTypeDef:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.84/reference/services/batch.html#Batch.Client.describe_compute_environments)
        [Show boto3-stubs documentation](./client.md#describe_compute_environments)
        """

    def describe_job_definitions(
        self,
        jobDefinitions: List[str] = None,
        maxResults: int = None,
        jobDefinitionName: str = None,
        status: str = None,
        nextToken: str = None,
    ) -> DescribeJobDefinitionsResponseTypeDef:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.84/reference/services/batch.html#Batch.Client.describe_job_definitions)
        [Show boto3-stubs documentation](./client.md#describe_job_definitions)
        """

    def describe_job_queues(
        self, jobQueues: List[str] = None, maxResults: int = None, nextToken: str = None
    ) -> DescribeJobQueuesResponseTypeDef:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.84/reference/services/batch.html#Batch.Client.describe_job_queues)
        [Show boto3-stubs documentation](./client.md#describe_job_queues)
        """

    def describe_jobs(self, jobs: List[str]) -> DescribeJobsResponseTypeDef:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.84/reference/services/batch.html#Batch.Client.describe_jobs)
        [Show boto3-stubs documentation](./client.md#describe_jobs)
        """

    def generate_presigned_url(
        self,
        ClientMethod: str,
        Params: Dict[str, Any] = None,
        ExpiresIn: int = 3600,
        HttpMethod: str = None,
    ) -> str:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.84/reference/services/batch.html#Batch.Client.generate_presigned_url)
        [Show boto3-stubs documentation](./client.md#generate_presigned_url)
        """

    def list_jobs(
        self,
        jobQueue: str = None,
        arrayJobId: str = None,
        multiNodeJobId: str = None,
        jobStatus: JobStatusType = None,
        maxResults: int = None,
        nextToken: str = None,
    ) -> ListJobsResponseTypeDef:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.84/reference/services/batch.html#Batch.Client.list_jobs)
        [Show boto3-stubs documentation](./client.md#list_jobs)
        """

    def list_tags_for_resource(self, resourceArn: str) -> ListTagsForResourceResponseTypeDef:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.84/reference/services/batch.html#Batch.Client.list_tags_for_resource)
        [Show boto3-stubs documentation](./client.md#list_tags_for_resource)
        """

    def register_job_definition(
        self,
        jobDefinitionName: str,
        type: JobDefinitionTypeType,
        parameters: Dict[str, str] = None,
        containerProperties: "ContainerPropertiesTypeDef" = None,
        nodeProperties: "NodePropertiesTypeDef" = None,
        retryStrategy: "RetryStrategyTypeDef" = None,
        propagateTags: bool = None,
        timeout: "JobTimeoutTypeDef" = None,
        tags: Dict[str, str] = None,
        platformCapabilities: List[PlatformCapabilityType] = None,
    ) -> RegisterJobDefinitionResponseTypeDef:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.84/reference/services/batch.html#Batch.Client.register_job_definition)
        [Show boto3-stubs documentation](./client.md#register_job_definition)
        """

    def submit_job(
        self,
        jobName: str,
        jobQueue: str,
        jobDefinition: str,
        arrayProperties: ArrayPropertiesTypeDef = None,
        dependsOn: List["JobDependencyTypeDef"] = None,
        parameters: Dict[str, str] = None,
        containerOverrides: "ContainerOverridesTypeDef" = None,
        nodeOverrides: NodeOverridesTypeDef = None,
        retryStrategy: "RetryStrategyTypeDef" = None,
        propagateTags: bool = None,
        timeout: "JobTimeoutTypeDef" = None,
        tags: Dict[str, str] = None,
    ) -> SubmitJobResponseTypeDef:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.84/reference/services/batch.html#Batch.Client.submit_job)
        [Show boto3-stubs documentation](./client.md#submit_job)
        """

    def tag_resource(self, resourceArn: str, tags: Dict[str, str]) -> Dict[str, Any]:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.84/reference/services/batch.html#Batch.Client.tag_resource)
        [Show boto3-stubs documentation](./client.md#tag_resource)
        """

    def terminate_job(self, jobId: str, reason: str) -> Dict[str, Any]:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.84/reference/services/batch.html#Batch.Client.terminate_job)
        [Show boto3-stubs documentation](./client.md#terminate_job)
        """

    def untag_resource(self, resourceArn: str, tagKeys: List[str]) -> Dict[str, Any]:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.84/reference/services/batch.html#Batch.Client.untag_resource)
        [Show boto3-stubs documentation](./client.md#untag_resource)
        """

    def update_compute_environment(
        self,
        computeEnvironment: str,
        state: CEStateType = None,
        computeResources: ComputeResourceUpdateTypeDef = None,
        serviceRole: str = None,
    ) -> UpdateComputeEnvironmentResponseTypeDef:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.84/reference/services/batch.html#Batch.Client.update_compute_environment)
        [Show boto3-stubs documentation](./client.md#update_compute_environment)
        """

    def update_job_queue(
        self,
        jobQueue: str,
        state: JQStateType = None,
        priority: int = None,
        computeEnvironmentOrder: List["ComputeEnvironmentOrderTypeDef"] = None,
    ) -> UpdateJobQueueResponseTypeDef:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.84/reference/services/batch.html#Batch.Client.update_job_queue)
        [Show boto3-stubs documentation](./client.md#update_job_queue)
        """

    @overload
    def get_paginator(
        self, operation_name: Literal["describe_compute_environments"]
    ) -> DescribeComputeEnvironmentsPaginator:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.84/reference/services/batch.html#Batch.Paginator.DescribeComputeEnvironments)[Show boto3-stubs documentation](./paginators.md#describecomputeenvironmentspaginator)
        """

    @overload
    def get_paginator(
        self, operation_name: Literal["describe_job_definitions"]
    ) -> DescribeJobDefinitionsPaginator:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.84/reference/services/batch.html#Batch.Paginator.DescribeJobDefinitions)[Show boto3-stubs documentation](./paginators.md#describejobdefinitionspaginator)
        """

    @overload
    def get_paginator(
        self, operation_name: Literal["describe_job_queues"]
    ) -> DescribeJobQueuesPaginator:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.84/reference/services/batch.html#Batch.Paginator.DescribeJobQueues)[Show boto3-stubs documentation](./paginators.md#describejobqueuespaginator)
        """

    @overload
    def get_paginator(self, operation_name: Literal["list_jobs"]) -> ListJobsPaginator:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.84/reference/services/batch.html#Batch.Paginator.ListJobs)[Show boto3-stubs documentation](./paginators.md#listjobspaginator)
        """
