/*
 * Decompiled with CFR 0.152.
 */
package org.cmayes.hartree.model.def;

import com.cmayes.common.exception.ExceptionUtils;
import java.util.Map;
import java.util.TreeMap;
import org.cmayes.hartree.model.DihedralPair;
import org.cmayes.hartree.model.NormalMode;
import org.cmayes.hartree.model.NormalModeReport;
import org.cmayes.hartree.model.NormalModeSummary;

public class DefaultNormalModeReport
implements NormalModeReport {
    private final Map<NormalMode, NormalModeSummary> summaries;

    public DefaultNormalModeReport(Map<NormalMode, NormalModeSummary> sums) {
        this.summaries = ExceptionUtils.asNotNull(sums, "Summary map is null", new Object[0]);
    }

    @Override
    public Map<DihedralPair, NormalMode> findHighestDihedrals() {
        TreeMap<DihedralPair, NormalMode> hiMap = new TreeMap<DihedralPair, NormalMode>();
        for (Map.Entry<NormalMode, NormalModeSummary> sumEntry : this.summaries.entrySet()) {
            for (Map.Entry<DihedralPair, Double> weights : sumEntry.getValue().getDihedralPairWeights().entrySet()) {
                DihedralPair curPair = weights.getKey();
                NormalMode existingMode = hiMap.get(curPair);
                if (existingMode == null) {
                    hiMap.put(curPair, sumEntry.getKey());
                    continue;
                }
                NormalModeSummary existingSum = this.summaries.get(existingMode);
                if (!(weights.getValue() > existingSum.getDihedralPairWeights().get(curPair))) continue;
                hiMap.put(curPair, sumEntry.getKey());
            }
        }
        return hiMap;
    }

    @Override
    public Map<NormalMode, NormalModeSummary> getSummaries() {
        return this.summaries;
    }
}

