from urllib.request import urlopen
from pathlib import Path

EXTRA_MESSAGE = """\
 * 
 * AUTOGENERATED by scripts/sbt_styles_update.py"""  # noqa

sbt_styles_files = [
    "abstracts/_mixins.scss",
    "abstracts/_variables.scss",
    "base/_base.scss",
    "base/_print.scss",
    "base/_typography.scss",
    "components/_back-to-top.scss",
    "components/_icon-links.scss",
    "components/_logo.scss",
    "components/_search.scss",
    "content/_code.scss",
    "content/_images.scss",
    "content/_margin.scss",
    "content/_notebooks.scss",
    "content/_quotes.scss",
    "extensions/_comments.scss",
    "extensions/_thebe.scss",
    "sections/_announcement.scss",
    "sections/_article.scss",
    "sections/_article-container.scss",
    "sections/_footer-article.scss",
    "sections/_footer-content.scss",
    "sections/_header-article.scss",
    "sections/_header-primary.scss",
    "sections/_sidebar-primary.scss",
    "sections/_sidebar-secondary.scss",
    "index.scss",
]
path_sbt_styles = Path(__file__).parent.parent / "src" / "plone_sphinx_theme" / "assets" / "styles" / "sphinx-book-theme"
for ifile in sbt_styles_files:
    print(f"Reading {ifile}...")
    url = f"https://raw.githubusercontent.com/executablebooks/sphinx-book-theme/master/src/sphinx_book_theme/assets/styles/{ifile}"  # noqa
    text = urlopen(url).read().decode()
    # Add introductory message directing people to this script
    if "index" in ifile:
        text = text.replace("All rights reserved.", "All rights reserved.\n" + EXTRA_MESSAGE)
    (path_sbt_styles / f"{ifile}").write_text(text)

print(f"Finished updating {len(sbt_styles_files)} files...")
