---
myst:
  html_meta:
    "description": "File system structure of Plone Sphinx Theme"
    "property=og:description": "File system structure of Plone Sphinx Theme"
    "property=og:title": "File system structure of Plone Sphinx Theme"
    "keywords": "Plone, Sphinx, Theme, plone-sphinx-theme, file, system, structure"
---

# File system structure

This reference document describes the file system structure of Plone Sphinx Theme, and the purpose of its files and directories.

Plone Sphinx Theme uses [Sphinx Theme Builder](https://sphinx-theme-builder.readthedocs.io/en/latest/) for compiling static assets and previewing design changes.
Plone Sphinx Theme's file structure follows [that of Sphinx Theme Builder](https://sphinx-theme-builder.readthedocs.io/en/latest/filesystem-layout/), with some slight variations.

```text
.
├── .github  # For CI/CD and other GitHub automation
├── docs  # Documentation of Plone Sphinx Theme
│   ├── [Documentation content and files]
│   ├── reference
│   │   └── kitchen-sink  # Files copied from Sphinx Themes Gallery. Do not edit.
│   └── conf.py  # Sphinx configuration for building documentation
├── scripts  # Scripts that update the Kitchen Sink reference and parent theme styles
├── src
│   └── plone_sphinx_theme 
│       ├── __init__.py  # Loads the theme and its configuration
│       ├── assets
│       │   ├── scripts  # JavaScripts to be compiled into final JS file
│       │   │   └── index.js
│       │   └── styles  # Styles to be compiled into final CSS file
│       │       ├── abstracts
│       │       ├── base
│       │       ├── components
│       │       ├── content
│       │       ├── index.scss
│       │       └── sphinx-book-theme  # Parent styles to be compiled. Do not edit.
│       └── theme
│           └── plone-sphinx-theme  # Page templates, components, configuration
│               ├── 404.html
│               ├── components  # Snippets for inclusion in templates
│               ├── static  # Compiled JavaScript and styles, images that don't need compilation
│               └── theme.conf
├── styles  # Vale grammar and spell checking styles
├── .gitignore
├── .vale.ini
├── LICENSE
├── Makefile
├── package.json  # For Javascript-based build tooling.
├── pyproject.toml  # For Python package metadata and tooling.
├── README.md
└── webpack.config.js  # For Javascript-based build tooling.
```

## Autogenerated directories

The following directories will be autogenerated when the theme's assets are compiled.
They're included in the project's {file}`.gitignore` file.

`.nodeenv`
:   The Node.js installation that's used to compile the theme's assets.

`node_modules`
:   The Node.js packages that are installed to compile the theme's assets.

`src/theme/plone-sphinx-theme/static/styles`
:   The compiled CSS assets for the theme.

`src/theme/plone-sphinx-theme/static/scripts`
:   The compiled JavaScript assets for the theme.
