/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.generator;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.metadata.ParameterInfoArray;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.statement.JavaType;
import com.ibm.db2.cmx.runtime.statement.SqlStatementType;
import com.ibm.db2.cmx.tools.internal.PDQDB2Types;
import com.ibm.db2.cmx.tools.internal.generator.XmlProcessor;
import com.ibm.db2.cmx.tools.internal.generator.metadata.ClassInfo;
import com.ibm.db2.cmx.tools.internal.generator.metadata.MetaDataInfo;
import com.ibm.db2.cmx.tools.internal.generator.metadata.MethodInfo;
import com.ibm.db2.cmx.tools.internal.generator.metadata.TypeInfo;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.ArtifactOptionsSet;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.PossibleArgs;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OfflineGenerationMetadataProcessor {
    public static final String rootName__ = "metadata";
    public static final String statementName__ = "statement";
    public static final String columnsElementName__ = "columns";
    public static final String columnElementName__ = "column";
    public static final String parametersElementName__ = "parameters";
    public static final String parameterElementName__ = "parameter";
    public static final String label__ = "label";
    public static final String jdbcType__ = "jdbcType";
    public static final String precision__ = "precision";
    public static final String scale__ = "scale";
    public static final String ccsid__ = "ccsid";
    public static final String tableName__ = "tableName";
    public static final String parameterMode__ = "parameterMode";
    static Map<String, Integer> parameterModeMap;
    public DocumentBuilderFactory documentBuilderFactory_;
    public ClassInfo classInfo_;
    public Document document_;
    private ArtifactOptionsSet artifactOptionsSet_;

    static void initializeParameterModeMap() {
        parameterModeMap = new HashMap<String, Integer>();
        parameterModeMap.put("parameterModeIn", 1);
        parameterModeMap.put("parameterModeOut", 4);
        parameterModeMap.put("parameterModeInOut", 2);
        parameterModeMap.put("parameterModeUnknown", 0);
    }

    public OfflineGenerationMetadataProcessor(String string, ClassInfo classInfo, ArtifactOptionsSet artifactOptionsSet) {
        this.classInfo_ = classInfo;
        this.createDocumentBuilderFactoryInstance();
        this.artifactOptionsSet_ = artifactOptionsSet;
        try {
            DocumentBuilder documentBuilder = this.documentBuilderFactory_.newDocumentBuilder();
            this.document_ = documentBuilder.parse(new FileInputStream(string));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_XML_FILE", new Object[0]), parserConfigurationException, 10198, null, null);
        }
        catch (IOException iOException) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_XML_FILE", new Object[0]), iOException, 10199, null, null);
        }
        catch (SAXException sAXException) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_XML_FILE", new Object[0]), sAXException, 10200, null, null);
        }
    }

    public void processXmlInformation() {
        Object object;
        this.setInformationForStaticArtifacts();
        NodeList nodeList = this.document_.getChildNodes();
        int n2 = nodeList.getLength();
        int n3 = 0;
        Object object2 = null;
        while (n3 < n2 && object2 == null) {
            if ((object = nodeList.item(n3++)) == null || !rootName__.equals(object.getLocalName())) continue;
            object2 = object;
        }
        if (object2 == null) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_INV_XML", new Object[0]), null, 10201, null, null);
        }
        object = object2.getChildNodes();
        int n4 = object.getLength();
        List<MethodInfo> list = this.classInfo_.getListOfMethods();
        for (int i10 = 0; i10 < n4; ++i10) {
            Node node = object.item(i10);
            this.processStatementElement(list, node);
        }
        this.validateInformation(list);
    }

    private void validateInformation(List<MethodInfo> list) {
        ParameterInfoArray parameterInfoArray = null;
        int n2 = 0;
        for (MethodInfo methodInfo : list) {
            Object object;
            TypeInfo typeInfo = methodInfo.getReturnType();
            if (SqlStatementType.isSELECTorVALUES(methodInfo.getSqlStatementType()) && typeInfo.getBaseType().getJavaType() != JavaType.JDBCRESULTSET && methodInfo.getResultMetaDataInfo() == null) {
                throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_INV_RSMD", new Object[0]), null, 10202, null, methodInfo);
            }
            parameterInfoArray = methodInfo.getParameterInfoArray();
            if (parameterInfoArray != null && (object = parameterInfoArray.getSqlParameterInfo()) != null) {
                n2 = object.size();
            }
            object = methodInfo.getParameterMetaDataInfo();
            if (n2 <= 0) continue;
            if (object == null) {
                throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_NULL_PMD", new Object[0]), null, 10203, null, methodInfo);
            }
            if (((MetaDataInfo)object).getColumnCount() == n2) continue;
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_INV_PMD", ((MetaDataInfo)object).getColumnCount(), n2), null, 10503, null, methodInfo);
        }
    }

    private void setInformationForStaticArtifacts() {
        this.classInfo_.setCollectionName(this.artifactOptionsSet_.getOptionOrArtifactSingleValue(PossibleArgs.COLLECTION));
        String string = this.artifactOptionsSet_.getOptionOrArtifactSingleValue(PossibleArgs.ROOT_PKG_NAME);
        if (string == null) {
            int n2 = 127;
            string = this.classInfo_.getTypeName();
            if (string.length() > n2) {
                string = string.substring(0, n2);
            }
        }
        this.classInfo_.setRootPkgName(string);
        long l10 = System.currentTimeMillis();
        this.classInfo_.setTimeStamp(l10);
        this.classInfo_.setPackageVersion(this.artifactOptionsSet_.getOptionOrArtifactSingleValue(PossibleArgs.PACKAGE_VERSION), l10);
    }

    private int calculateNumberOfNodes(NodeList nodeList, String string) {
        int n2 = 0;
        for (int i10 = 0; i10 < nodeList.getLength(); ++i10) {
            if (!string.equals(nodeList.item(i10).getNodeName())) continue;
            ++n2;
        }
        return n2;
    }

    private void createDocumentBuilderFactoryInstance() {
        if (this.documentBuilderFactory_ == null) {
            this.documentBuilderFactory_ = DocumentBuilderFactory.newInstance();
            this.documentBuilderFactory_.setNamespaceAware(true);
            this.documentBuilderFactory_.setCoalescing(true);
        }
    }

    private void processColumn(Node node, MetaDataInfo metaDataInfo, int n2) {
        NodeList nodeList = node.getChildNodes();
        for (int i10 = 0; i10 < nodeList.getLength(); ++i10) {
            String string;
            Node node2 = nodeList.item(i10);
            String string2 = node2.getNodeName();
            if (label__.equals(string2)) {
                string = node2.getTextContent();
                if (null == string) continue;
                metaDataInfo.getFieldNames()[n2] = string.toLowerCase();
                continue;
            }
            if (jdbcType__.equals(string2)) {
                string = node2.getTextContent();
                if (null == string) continue;
                metaDataInfo.getSqlTypeForStorageInImplOrXml()[n2] = PDQDB2Types.mapSqlTypeNameToDriverType(string);
                continue;
            }
            if (precision__.equals(string2)) {
                string = node2.getTextContent();
                if (null == string) continue;
                metaDataInfo.getSqlPrecision()[n2] = Integer.parseInt(string);
                continue;
            }
            if (scale__.equals(string2)) {
                string = node2.getTextContent();
                if (null == string) continue;
                metaDataInfo.getSqlScale()[n2] = Integer.parseInt(string);
                continue;
            }
            if (ccsid__.equals(string2)) {
                string = node2.getTextContent();
                if (null == string) continue;
                metaDataInfo.getSqlCcsid()[n2] = Integer.parseInt(string);
                continue;
            }
            if (!tableName__.equals(string2) || null == (string = node2.getTextContent())) continue;
            metaDataInfo.getTableNames()[n2] = string.toLowerCase();
        }
    }

    private void processMetaDataInformation(Node node, MethodInfo methodInfo) {
        NodeList nodeList = node.getChildNodes();
        for (int i10 = 0; i10 < nodeList.getLength(); ++i10) {
            Node node2 = nodeList.item(i10);
            String string = node2.getNodeName();
            if (columnsElementName__.equals(string)) {
                this.processResultSetMetadata(node2, methodInfo);
                continue;
            }
            if (!parametersElementName__.equals(string)) continue;
            this.processParameterMetadata(node2, methodInfo);
        }
    }

    private void processParameter(Node node, MetaDataInfo metaDataInfo, int n2) {
        NodeList nodeList = node.getChildNodes();
        for (int i10 = 0; i10 < nodeList.getLength(); ++i10) {
            String string;
            Node node2 = nodeList.item(i10);
            String string2 = node2.getNodeName();
            if (jdbcType__.equals(string2)) {
                string = node2.getTextContent();
                if (null == string) continue;
                metaDataInfo.getSqlTypeForStorageInImplOrXml()[n2] = PDQDB2Types.mapSqlTypeNameToDriverType(string);
                continue;
            }
            if (precision__.equals(string2)) {
                string = node2.getTextContent();
                if (null == string) continue;
                metaDataInfo.getSqlPrecision()[n2] = Integer.parseInt(string);
                continue;
            }
            if (scale__.equals(string2)) {
                string = node2.getTextContent();
                if (null == string) continue;
                metaDataInfo.getSqlScale()[n2] = Integer.parseInt(string);
                continue;
            }
            if (!parameterMode__.equals(string2) || null == (string = node2.getTextContent())) continue;
            metaDataInfo.getSqlParmMode()[n2] = parameterModeMap.get(string.trim());
        }
    }

    private void processParameterMetadata(Node node, MethodInfo methodInfo) {
        NodeList nodeList = node.getChildNodes();
        MetaDataInfo metaDataInfo = methodInfo.getParameterMetaDataInfo();
        if (metaDataInfo == null) {
            metaDataInfo = new MetaDataInfo(this.calculateNumberOfNodes(nodeList, parameterElementName__));
            methodInfo.setParameterMetaDataInfo(metaDataInfo);
        }
        int n2 = 0;
        for (int i10 = 0; i10 < nodeList.getLength(); ++i10) {
            Node node2 = nodeList.item(i10);
            String string = node2.getNodeName();
            if (!parameterElementName__.equals(string)) continue;
            this.processParameter(node2, metaDataInfo, n2++);
        }
    }

    private void processResultSetMetadata(Node node, MethodInfo methodInfo) {
        NodeList nodeList = node.getChildNodes();
        MetaDataInfo metaDataInfo = methodInfo.getResultMetaDataInfo();
        if (metaDataInfo == null) {
            metaDataInfo = new MetaDataInfo(this.calculateNumberOfNodes(nodeList, columnElementName__));
            methodInfo.setResultMetaDataInfo(metaDataInfo);
        }
        int n2 = 0;
        for (int i10 = 0; i10 < nodeList.getLength(); ++i10) {
            Node node2 = nodeList.item(i10);
            String string = node2.getNodeName();
            if (!columnElementName__.equals(string)) continue;
            this.processColumn(node2, metaDataInfo, n2++);
        }
    }

    private void processStatementElement(List<MethodInfo> list, Node node) {
        NamedNodeMap namedNodeMap;
        Node node2;
        MethodInfo methodInfo;
        String string = node.getLocalName();
        if (string != null && string.equals(statementName__) && (methodInfo = XmlProcessor.parseMethodSignature(list, (node2 = (namedNodeMap = node.getAttributes()).getNamedItem("method")).getNodeValue())) != null) {
            this.processMetaDataInformation(node, methodInfo);
        }
    }

    static {
        OfflineGenerationMetadataProcessor.initializeParameterModeMap();
    }
}

