/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.db;

import com.ibm.db2.cmx.runtime.HeterogeneousBatchKind;
import com.ibm.db2.cmx.runtime.exception.DataSQLException;
import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.handlers.ResultHandler;
import com.ibm.db2.cmx.runtime.handlers.RowHandler;
import com.ibm.db2.cmx.runtime.internal.db.JdbcData;
import com.ibm.db2.cmx.runtime.internal.metadata.ParameterInfoArray;
import com.ibm.db2.cmx.runtime.internal.metadata.StatementDescriptorImpl;
import com.ibm.db2.cmx.runtime.internal.parser.QOCEscapeLexer;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import com.ibm.db2.cmx.runtime.statement.Hook;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class QueryOverCollectionData
extends JdbcData {
    public QueryOverCollectionData(Connection connection, Hook hook, Map<Object, Object> map, Integer n2, Integer n3) {
        super(connection, hook, map, n2, n3, null);
        try {
            this.dbMetaData_ = connection.getMetaData();
        }
        catch (SQLException sQLException) {
            Log.getAPILogger().log(Level.FINE, "Error", sQLException);
        }
    }

    @Override
    protected void processSql(StatementDescriptorImpl statementDescriptorImpl, Object ... objectArray) {
        String string;
        if (objectArray == null) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_QOC_COLL_TYPE", new Object[0]), null, 10124);
        }
        boolean bl2 = false;
        for (Object object : objectArray) {
            if (object == null || !(object instanceof Iterable) && !(object instanceof Iterator) && !object.getClass().isArray()) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_QOC_COLL_TYPE", new Object[0]), null, 10125);
        }
        if (this.logger_.isLoggable(Level.FINER)) {
            DataLogger.sqlOriginal(this.logger_, this, "processSQL", statementDescriptorImpl.getOriginalSql());
        }
        statementDescriptorImpl.setMethodInfoArray(new ParameterInfoArray());
        QOCEscapeLexer qOCEscapeLexer = new QOCEscapeLexer(statementDescriptorImpl.getOriginalSql(), objectArray);
        try {
            int n2 = null != objectArray ? objectArray.length : 0;
            string = qOCEscapeLexer.parseSql(statementDescriptorImpl.getMethodInfoArray(), n2);
        }
        catch (DataSQLException dataSQLException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_PARSE_SQL", statementDescriptorImpl.getOriginalSql()), dataSQLException, 10020);
        }
        statementDescriptorImpl.setDynamicSQL(string);
        statementDescriptorImpl.setSqlStatementType(qOCEscapeLexer.getSqlStatementType());
    }

    @Override
    public <RES> RES query(String string, ResultHandler<RES> resultHandler, Object ... objectArray) {
        throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_QOC_NOT_SUP", "query (String sql, ResultHandler<T> handler, Object... parameters)"), null, 10246);
    }

    @Override
    public <ROW> Iterator<ROW> queryIterator(String string, RowHandler<ROW> rowHandler, Object ... objectArray) {
        throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_QOC_NOT_SUP", "queryIterator (String sql, RowHandler<T> singleRowFactory, Object... parameters)"), null, 10247);
    }

    @Override
    public <ROW> ROW[] queryArray(String string, RowHandler<ROW> rowHandler, Object ... objectArray) {
        throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_QOC_NOT_SUP", "queryArray (String sql, RowHandler<T> singleRowFactory, Object... parameters)"), null, 10248);
    }

    @Override
    public <ROW> ROW queryFirst(String string, RowHandler<ROW> rowHandler, Object ... objectArray) {
        throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_QOC_NOT_SUP", "queryFirst (String sql, RowHandler<T> singleRowFactory, Object... parameters)"), null, 10249);
    }

    @Override
    public <ROW> List<ROW> queryList(String string, RowHandler<ROW> rowHandler, Object ... objectArray) {
        throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_QOC_NOT_SUP", "queryList (String sql, RowHandler<T> singleRowFactory, Object... parameters)"), null, 10250);
    }

    @Override
    public int update(String string, Object ... objectArray) {
        throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_QOC_NOT_SUP", "update (String sql, Object... parameters)"), null, 10251);
    }

    @Override
    public <ROW> ROW update(String string, Class<ROW> clazz, String[] stringArray, Object ... objectArray) {
        throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_QOC_NOT_SUP", "update (String sql, Class<T> returnClass, String[] columnNames, Object... parameters)"), null, 10252);
    }

    @Override
    protected <T> int[] updateMany_(StatementDescriptorImpl statementDescriptorImpl, Iterator<T> iterator, T[] TArray) {
        throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_QOC_NOT_SUP", "updateMany_ (String sql, StatementDescriptorImpl stmtDesc, Iterator<T> rowIterator, T[] rowArray)"), null, 10253);
    }

    @Override
    public Connection getConnection() {
        throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_QOC_NOT_SUP", "getConnection ()"), null, 10254);
    }

    @Override
    public ResultSet queryResults(String string, Object ... objectArray) {
        throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_QOC_NOT_SUP", "queryResults (String sql, Object... parameters)"), null, 10255);
    }

    @Override
    public void setConnection(Connection connection) {
        throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_QOC_NOT_SUP", "setConnection (Connection conn)"), null, 10256);
    }

    @Override
    public void close() {
    }

    @Override
    public void commit() {
    }

    @Override
    public void rollback() {
    }

    @Override
    public void startBatch(HeterogeneousBatchKind heterogeneousBatchKind) {
        throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_QOC_NOT_SUP", "startBatch (HeterogeneousBatchKind batchKind)"), null, 10659);
    }
}

