/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.management;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.firebirdsql.gds.ServiceRequestBuffer;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.gds.ng.FbService;
import org.firebirdsql.management.BackupManager;
import org.firebirdsql.management.FBBackupManagerBase;

public class FBBackupManager
extends FBBackupManagerBase
implements BackupManager {
    private boolean noLimitBackup = false;
    private List<FBBackupManagerBase.PathSizeStruct> backupPaths = new ArrayList<FBBackupManagerBase.PathSizeStruct>();

    @Override
    protected boolean verboseBackup() {
        return this.verbose;
    }

    public FBBackupManager() {
    }

    public FBBackupManager(String gdsType) {
        super(gdsType);
    }

    public FBBackupManager(GDSType gdsType) {
        super(gdsType);
    }

    @Override
    public void setBackupPath(String backupPath) {
        this.addBackupPath(backupPath, -1);
        this.noLimitBackup = true;
    }

    @Override
    public void addBackupPath(String path, int size) {
        if (this.noLimitBackup) {
            throw new IllegalArgumentException("You cannot use setBackupPath(String) and addBackupPath(String, int) methods simultaneously.");
        }
        this.backupPaths.add(new FBBackupManagerBase.PathSizeStruct(path, size));
    }

    @Override
    public void clearBackupPaths() {
        this.backupPaths.clear();
        this.noLimitBackup = false;
    }

    @Override
    public void backupDatabase(int options) throws SQLException {
        try (FbService service = this.attachServiceManager();){
            this.executeServicesOperation(service, this.getBackupSRB(service, options));
        }
    }

    @Override
    public void restoreDatabase(int options) throws SQLException {
        try (FbService service = this.attachServiceManager();){
            this.executeServicesOperation(service, this.getRestoreSRB(service, options));
        }
    }

    @Override
    protected void addBackupsToBackupRequestBuffer(FbService service, ServiceRequestBuffer backupSPB) throws SQLException {
        Iterator<FBBackupManagerBase.PathSizeStruct> iter = this.backupPaths.iterator();
        while (iter.hasNext()) {
            FBBackupManagerBase.PathSizeStruct pathSize = iter.next();
            backupSPB.addArgument(5, pathSize.getPath());
            if (iter.hasNext() && pathSize.getSize() == -1) {
                throw new SQLException("No size specified for a backup file " + pathSize.getPath());
            }
            if (!iter.hasNext()) continue;
            backupSPB.addArgument(7, pathSize.getSize());
        }
    }

    @Override
    protected void addBackupsToRestoreRequestBuffer(FbService service, ServiceRequestBuffer restoreSPB) {
        for (FBBackupManagerBase.PathSizeStruct pathSize : this.backupPaths) {
            restoreSPB.addArgument(5, pathSize.getPath());
        }
    }
}

