/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.auth.srp;

import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.wire.auth.AuthenticationPlugin;
import org.firebirdsql.gds.ng.wire.auth.ClientAuthBlock;
import org.firebirdsql.gds.ng.wire.auth.srp.SrpClient;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;
import org.firebirdsql.util.ByteArrayHelper;

class SrpAuthenticationPlugin
implements AuthenticationPlugin {
    private static final Logger log = LoggerFactory.getLogger(SrpAuthenticationPlugin.class);
    private final String pluginName;
    private final String clientProofHashAlgorithm;
    private byte[] clientData;
    private SrpClient srpClient;
    private byte[] serverData;

    SrpAuthenticationPlugin(String pluginName, String clientProofHashAlgorithm) {
        this.pluginName = pluginName;
        this.clientProofHashAlgorithm = clientProofHashAlgorithm;
    }

    @Override
    public String getName() {
        return this.pluginName;
    }

    @Override
    public AuthenticationPlugin.AuthStatus authenticate(ClientAuthBlock clientAuthBlock) throws SQLException {
        if (this.srpClient == null) {
            log.debug("SRP phase 1, user: " + clientAuthBlock.getLogin());
            if (clientAuthBlock.getLogin() == null || clientAuthBlock.getPassword() == null) {
                return AuthenticationPlugin.AuthStatus.AUTH_CONTINUE;
            }
            this.srpClient = new SrpClient(this.clientProofHashAlgorithm);
            this.clientData = this.srpClient.getPublicKeyHex().getBytes(StandardCharsets.US_ASCII);
            return AuthenticationPlugin.AuthStatus.AUTH_MORE_DATA;
        }
        if (this.srpClient.getSessionKey() != null) {
            throw new FbExceptionBuilder().exception(335544382).messageParameter("Auth sync failure - SRP's authenticate called more times than supported").toFlatSQLException();
        }
        log.debug("SRP phase 2");
        this.clientData = SrpAuthenticationPlugin.toHex(this.srpClient.clientProof(clientAuthBlock.getNormalizedLogin(), clientAuthBlock.getPassword(), this.serverData)).getBytes(StandardCharsets.US_ASCII);
        return AuthenticationPlugin.AuthStatus.AUTH_SUCCESS;
    }

    @Override
    public byte[] getClientData() {
        return this.clientData;
    }

    @Override
    public void setServerData(byte[] serverData) {
        this.serverData = serverData;
    }

    @Override
    public boolean hasServerData() {
        return this.serverData != null && this.serverData.length > 0;
    }

    @Override
    public boolean generatesSessionKey() {
        return true;
    }

    @Override
    public byte[] getSessionKey() throws SQLException {
        return this.srpClient.getSessionKey();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : " + this.getName();
    }

    private static String toHex(byte[] bytes) {
        return ByteArrayHelper.toHexString(bytes);
    }
}

