/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Objects;
import org.firebirdsql.gds.ServiceParameterBuffer;
import org.firebirdsql.gds.ServiceRequestBuffer;
import org.firebirdsql.gds.impl.wire.XdrInputStream;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.ng.AbstractFbService;
import org.firebirdsql.gds.ng.DefaultDatatypeCoder;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.WarningMessageCallback;
import org.firebirdsql.gds.ng.wire.FbWireOperations;
import org.firebirdsql.gds.ng.wire.FbWireService;
import org.firebirdsql.gds.ng.wire.GenericResponse;
import org.firebirdsql.gds.ng.wire.ProtocolDescriptor;
import org.firebirdsql.gds.ng.wire.WireServiceConnection;
import org.firebirdsql.gds.ng.wire.XdrStreamAccess;

public abstract class AbstractFbWireService
extends AbstractFbService<WireServiceConnection>
implements FbWireService {
    protected final ProtocolDescriptor protocolDescriptor;
    protected final FbWireOperations wireOperations;

    protected AbstractFbWireService(WireServiceConnection connection, ProtocolDescriptor descriptor) {
        super(connection, DefaultDatatypeCoder.forEncodingFactory(connection.getEncodingFactory()));
        this.protocolDescriptor = Objects.requireNonNull(descriptor, "parameter descriptor should be non-null");
        this.wireOperations = descriptor.createWireOperations(connection, this.getServiceWarningCallback(), this.getSynchronizationObject());
    }

    @Override
    public void forceClose() throws SQLException {
        try {
            if (((WireServiceConnection)this.connection).isConnected()) {
                ((WireServiceConnection)this.connection).close();
            }
        }
        catch (IOException e) {
            throw new FbExceptionBuilder().exception(335544727).cause(e).toFlatSQLException();
        }
        finally {
            this.serviceListenerDispatcher.detached(this);
            this.serviceListenerDispatcher.shutdown();
            this.exceptionListenerDispatcher.shutdown();
        }
    }

    @Override
    public final ServiceParameterBuffer createServiceParameterBuffer() {
        return this.protocolDescriptor.createServiceParameterBuffer((WireServiceConnection)this.connection);
    }

    @Override
    public final ServiceRequestBuffer createServiceRequestBuffer() {
        return this.protocolDescriptor.createServiceRequestBuffer((WireServiceConnection)this.connection);
    }

    @Override
    public final boolean isAttached() {
        return super.isAttached() && ((WireServiceConnection)this.connection).isConnected();
    }

    @Override
    protected final void checkConnected() throws SQLException {
        if (!((WireServiceConnection)this.connection).isConnected()) {
            throw FbExceptionBuilder.forException(337248273).toFlatSQLException();
        }
    }

    protected final void checkAttached() throws SQLException {
        this.checkConnected();
        if (!this.isAttached()) {
            throw FbExceptionBuilder.forException(337248274).toFlatSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNetworkTimeout(int milliseconds) throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.checkConnected();
            this.wireOperations.setNetworkTimeout(milliseconds);
        }
    }

    protected final XdrInputStream getXdrIn() throws SQLException {
        return this.getXdrStreamAccess().getXdrIn();
    }

    protected final XdrOutputStream getXdrOut() throws SQLException {
        return this.getXdrStreamAccess().getXdrOut();
    }

    @Override
    public final GenericResponse readGenericResponse(WarningMessageCallback warningCallback) throws SQLException, IOException {
        return this.wireOperations.readGenericResponse(warningCallback);
    }

    @Override
    public final XdrStreamAccess getXdrStreamAccess() {
        return ((WireServiceConnection)this.connection).getXdrStreamAccess();
    }
}

