/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.common;

import com.amazon.dsi.core.impl.DSIDriverSingleton;
import com.amazon.dsi.core.interfaces.IDriver;
import com.amazon.dsi.core.interfaces.IStatement;
import com.amazon.dsi.core.utilities.Variant;
import com.amazon.dsi.dataengine.impl.DSIEmptyResultSet;
import com.amazon.dsi.dataengine.impl.DSISimpleRowCountResult;
import com.amazon.dsi.dataengine.interfaces.IDataEngine;
import com.amazon.dsi.dataengine.interfaces.IErrorResult;
import com.amazon.dsi.dataengine.interfaces.IQueryExecutor;
import com.amazon.dsi.dataengine.interfaces.IResultSet;
import com.amazon.dsi.dataengine.interfaces.IResults;
import com.amazon.dsi.dataengine.interfaces.IRowCountResult;
import com.amazon.dsi.dataengine.utilities.ExecutionContexts;
import com.amazon.dsi.dataengine.utilities.ExecutionResult;
import com.amazon.dsi.dataengine.utilities.ExecutionResultType;
import com.amazon.dsi.dataengine.utilities.ParameterGeneratedValues;
import com.amazon.dsi.dataengine.utilities.ParameterInputValue;
import com.amazon.dsi.dataengine.utilities.ParameterMetadata;
import com.amazon.exceptions.ExceptionConverter;
import com.amazon.exceptions.JDBCMessageKey;
import com.amazon.jdbc.common.SConnection;
import com.amazon.jdbc.common.SForwardResultSet;
import com.amazon.jdbc.common.SWarningListener;
import com.amazon.jdbc.common.utilities.WrapperUtilities;
import com.amazon.support.ILogger;
import com.amazon.support.IMessageSource;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogUtilities;
import com.amazon.support.Pair;
import com.amazon.support.exceptions.ErrorException;
import com.amazon.support.exceptions.ExceptionType;
import com.amazon.utilities.FunctionID;
import com.amazon.utilities.JDBCVersion;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public abstract class SStatement
implements Statement {
    private static final int MAX_ROWS_UNLIMITED = 0;
    private static final String INSERT_TOKEN = "insert";
    private static final int RESULT_SET_UPDATE_COUNT = -1;
    protected Iterator<ExecutionResult> m_resultIterator = null;
    protected ParameterGeneratedValues m_generatedParams = null;
    protected IResultSet m_generatedResult = new DSIEmptyResultSet();
    protected List<ResultContext> m_resultSets = new ArrayList<ResultContext>();
    protected IStatement m_statement = null;
    protected IQueryExecutor m_queryExecutor = null;
    private IDataEngine m_dataEngine = null;
    protected SWarningListener m_warningListener = null;
    protected IMessageSource m_messageSource = null;
    protected boolean m_escapeProcessingEnabled = true;
    protected ILogger m_logger = null;
    protected SConnection m_parentConnection = null;
    private int m_currentResultSetIndex = 0;
    private int m_concurrency = 1007;
    private List<String> m_batchSQLStatements = new ArrayList<String>();
    protected JDBCVersion m_jdbcVersion;
    private final Object m_closeLock = new Object();
    protected boolean m_isCanceled = false;
    protected boolean m_isInCancelableFunction = false;
    protected final Object m_cancelLock = new Object();
    private final Object m_resultSetsLock = new Object();
    protected volatile boolean m_closeOnCompletion = false;

    protected static boolean isInsertStatement(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = stringTokenizer.nextToken();
        return INSERT_TOKEN.equalsIgnoreCase(string2);
    }

    private static CheckResultType GetCheckResultType(long l) {
        if (0L != (l & 2L)) {
            return CheckResultType.None;
        }
        if (0L != (l & 1L)) {
            return CheckResultType.CheckAfterExec;
        }
        return CheckResultType.CheckAfterPrep;
    }

    protected static ThrowCondition GetConditionForAfterPrepare(long l, boolean bl) {
        switch (SStatement.GetCheckResultType(l)) {
            case None: 
            case CheckAfterExec: {
                return ThrowCondition.None;
            }
        }
        return bl ? ThrowCondition.SingleResult : ThrowCondition.SingleRowCount;
    }

    protected static ThrowCondition GetConditionForAfterExecute(long l, boolean bl) {
        switch (SStatement.GetCheckResultType(l)) {
            case CheckAfterExec: {
                return bl ? ThrowCondition.SingleResult : ThrowCondition.SingleRowCount;
            }
        }
        return ThrowCondition.None;
    }

    private static int longUpdateCountToInt(long l) {
        if (l == -3L) {
            return -3;
        }
        if (l == -2L || l > Integer.MAX_VALUE) {
            return -2;
        }
        if (l < 0L) {
            throw new IllegalArgumentException(String.format("Invalid updateCount: %d", l));
        }
        return (int)l;
    }

    private static int[] longUpdateCountstoInts(long[] lArray) {
        int[] nArray = new int[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            nArray[i] = SStatement.longUpdateCountToInt(lArray[i]);
        }
        return nArray;
    }

    protected static BatchUpdateException largeBatchException(List<SQLException> list, long[] lArray) {
        return SStatement.createBatchUpdateException(list, SStatement.longUpdateCountstoInts(lArray));
    }

    private static BatchUpdateException createBatchUpdateException(List<SQLException> list, int[] nArray) {
        BatchUpdateException batchUpdateException = null;
        if (null != list && !list.isEmpty()) {
            Iterator<SQLException> iterator = list.iterator();
            SQLException sQLException = iterator.next();
            SQLException sQLException2 = batchUpdateException = new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), nArray);
            while (iterator.hasNext()) {
                SQLException sQLException3 = iterator.next();
                sQLException2.setNextException(sQLException3);
                sQLException2 = sQLException3;
            }
        }
        return batchUpdateException;
    }

    protected SStatement(IStatement iStatement, SConnection sConnection, int n) {
        this.m_logger = sConnection.getConnection().getConnectionLog();
        LogUtilities.logFunctionEntrance(this.m_logger, iStatement, sConnection, n);
        this.m_parentConnection = sConnection;
        this.m_statement = iStatement;
        this.m_concurrency = n;
        this.m_messageSource = DSIDriverSingleton.getInstance().getMessageSource();
        this.m_warningListener = new SWarningListener(this.m_messageSource, null);
        this.m_warningListener.setLocale(sConnection.getDSIConnection().getLocale());
        this.m_statement.registerWarningListener(this.m_warningListener);
    }

    @Override
    public synchronized void addBatch(String string) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string);
            this.checkIfOpen();
            if (this.m_escapeProcessingEnabled && DSIDriverSingleton.getInstance().getProperty(10).getInt() == 1) {
                string = this.m_parentConnection.nativeSQL(string);
            }
            this.m_batchSQLStatements.add(string);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.checkIfOpen();
        try {
            Object object = this.m_cancelLock;
            synchronized (object) {
                if (this.m_isInCancelableFunction) {
                    this.m_isCanceled = true;
                }
            }
            object = this.m_queryExecutor;
            if (null != object) {
                object.cancelExecute();
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void clearBatch() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            this.m_batchSQLStatements.clear();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            this.m_warningListener.clear();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SQLException {
        Object object = this.m_closeLock;
        synchronized (object) {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.clearResults();
            if (null != this.m_parentConnection) {
                this.m_parentConnection.removeStatement(this);
                this.m_parentConnection = null;
            }
            this.replaceQueryExecutor(null, null);
            try {
                if (null != this.m_statement) {
                    this.m_statement.close();
                }
            }
            catch (Exception exception) {
                throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
            }
            finally {
                this.m_statement = null;
                this.m_generatedResult = null;
            }
        }
    }

    @Override
    public synchronized boolean execute(String string) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string);
            this.checkIfOpen();
            this.checkIfNullSQL(string);
            if (!this.m_batchSQLStatements.isEmpty()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.BATCH_NOT_EMPTY, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
            }
            this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_EXECUTE);
            this.clearResults();
            IResults iResults = this.executeNoParams(string, this.m_generatedParams, ThrowCondition.None);
            this.m_resultIterator = iResults.getResultItr();
            if (!this.m_resultIterator.hasNext()) {
                return false;
            }
            ExecutionResult executionResult = this.moveToNextResult();
            this.addResultPair(this.createResultPair(executionResult));
            return ExecutionResultType.RESULT_SET == this.m_resultSets.get((int)0).m_resultType || ExecutionResultType.ERROR_RESULT_SET == this.m_resultSets.get((int)0).m_resultType;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized boolean execute(String string, int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, n);
            this.checkIfOpen();
            if (n != 1 && n != 2) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_OBJECT, (IWarningListener)this.m_warningListener, ExceptionType.DATA, new Object[0]);
            }
            if (this.getConnection().getMetaData().supportsGetGeneratedKeys()) {
                this.m_generatedParams = new ParameterGeneratedValues(n);
            } else if (n == 1) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
            }
            return this.execute(string);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized boolean execute(String string, int[] nArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, nArray);
            this.checkIfOpen();
            if (this.getConnection().getMetaData().supportsGetGeneratedKeys()) {
                this.m_generatedParams = new ParameterGeneratedValues(nArray);
                return this.execute(string);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized boolean execute(String string, String[] stringArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, stringArray);
            this.checkIfOpen();
            if (this.getConnection().getMetaData().supportsGetGeneratedKeys()) {
                this.m_generatedParams = new ParameterGeneratedValues(stringArray);
                return this.execute(string);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int[] executeBatch() throws SQLException, BatchUpdateException {
        try {
            this.executeAnyBatch();
            return this.processBatchResults(this.m_queryExecutor.getResults(), Collections.emptyList(), BatchType.MULTI_STATEMENT);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void executeAnyBatch() throws SQLException, BatchUpdateException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            Object object = this.m_cancelLock;
            synchronized (object) {
                this.m_isInCancelableFunction = true;
            }
            this.m_parentConnection.beginTransaction();
            object = this.m_statement.createDataEngine();
            object.setDirectExecute();
            object.setMetadataNeeded(false);
            this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_PREPARE);
            this.replaceQueryExecutor((IDataEngine)object, object.prepareBatch(this.m_batchSQLStatements));
            ArrayList<ArrayList<ParameterInputValue>> arrayList = new ArrayList<ArrayList<ParameterInputValue>>();
            ArrayList<ParameterMetadata> arrayList2 = new ArrayList<ParameterMetadata>();
            arrayList.add(new ArrayList());
            ExecutionContexts executionContexts = new ExecutionContexts(arrayList2, arrayList);
            this.clearResults();
            Object object2 = this.m_cancelLock;
            synchronized (object2) {
                if (this.m_isCanceled) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.OPERATION_CANCELED, (IWarningListener)this.m_warningListener, ExceptionType.TRANSIENT, new Object[0]);
                }
            }
            this.m_warningListener.setCurrentFunction(FunctionID.STATEMENT_EXECUTE);
            this.m_queryExecutor.execute(executionContexts, this.m_warningListener);
        }
        catch (Exception exception) {
            try {
                this.replaceQueryExecutor(null, null);
            }
            catch (Exception exception2) {
                LogUtilities.logError(exception2, this.m_logger);
            }
            finally {
                throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
            }
        }
        finally {
            Object object = this.m_cancelLock;
            synchronized (object) {
                this.m_isCanceled = false;
                this.m_isInCancelableFunction = false;
            }
            this.m_batchSQLStatements.clear();
        }
    }

    @Override
    public synchronized ResultSet executeQuery(String string) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string);
            this.checkIfOpen();
            this.checkIfNullSQL(string);
            if (!this.m_batchSQLStatements.isEmpty()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.BATCH_NOT_EMPTY, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
            }
            this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_EXECUTE);
            this.clearResults();
            long l = DSIDriverSingleton.getInstance().getProperty(36).getLong();
            IResults iResults = this.executeNoParams(string, SStatement.GetConditionForAfterPrepare(l, true));
            this.m_resultIterator = iResults.getResultItr();
            ExecutionResult executionResult = this.checkAndMoveToNextResult(string, iResults, SStatement.GetConditionForAfterExecute(l, true));
            if (ExecutionResultType.ERROR_RESULT_SET == executionResult.getType()) {
                this.addResultPair(this.createResultPair(executionResult));
                throw ((IErrorResult)executionResult.getResult()).getError();
            }
            ResultSet resultSet = this.createResultSet(executionResult);
            ((SForwardResultSet)resultSet).initializeColumnNameMap();
            this.addResultSet(resultSet);
            return resultSet;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int executeUpdate(String string) throws SQLException {
        try {
            return this.castRowCount(this.executeAnyUpdate(string));
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    public synchronized long executeAnyUpdate(String string) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string);
            this.checkIfOpen();
            this.checkIfNullSQL(string);
            if (!this.m_batchSQLStatements.isEmpty()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.BATCH_NOT_EMPTY, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
            }
            this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_EXECUTE);
            this.clearResults();
            long l = DSIDriverSingleton.getInstance().getProperty(36).getLong();
            IResults iResults = this.executeNoParams(string, this.m_generatedParams, SStatement.GetConditionForAfterPrepare(l, false));
            this.m_resultIterator = iResults.getResultItr();
            ExecutionResult executionResult = this.checkAndMoveToNextResult(string, iResults, SStatement.GetConditionForAfterExecute(l, false));
            if (ExecutionResultType.ERROR_ROW_COUNT == executionResult.getType()) {
                this.addResultPair(this.createResultPair(executionResult));
                throw ((IErrorResult)executionResult.getResult()).getError();
            }
            IRowCountResult iRowCountResult = (IRowCountResult)executionResult.getResult();
            this.addResultPair(this.createResultPair(executionResult));
            if (iRowCountResult.hasRowCount()) {
                return iRowCountResult.getRowCount();
            }
            return 0L;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int executeUpdate(String string, int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, n);
            this.checkIfOpen();
            boolean bl = this.getConnection().getMetaData().supportsGetGeneratedKeys();
            if (bl) {
                if (n != 1 && n != 2) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_OBJECT, (IWarningListener)this.m_warningListener, ExceptionType.DATA, new Object[0]);
                }
                this.m_generatedParams = new ParameterGeneratedValues(n);
            }
            if (!bl && n == 1) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
            }
            return this.executeUpdate(string);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int executeUpdate(String string, int[] nArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, nArray);
            this.checkIfOpen();
            boolean bl = this.getConnection().getMetaData().supportsGetGeneratedKeys();
            if (bl) {
                this.m_generatedParams = new ParameterGeneratedValues(nArray);
                return this.executeUpdate(string);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int executeUpdate(String string, String[] stringArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, stringArray);
            this.checkIfOpen();
            boolean bl = this.getConnection().getMetaData().supportsGetGeneratedKeys();
            if (bl) {
                this.m_generatedParams = new ParameterGeneratedValues(stringArray);
                return this.executeUpdate(string);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public synchronized Object getAttribute(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (!this.m_statement.isCustomProperty(n)) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ATTRIBUTE, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(n));
            }
            Variant variant = this.m_statement.getCustomProperty(n);
            switch (variant.getType()) {
                case 5: {
                    return variant.getShort();
                }
                case 2: {
                    return Character.valueOf(variant.getChar());
                }
                case 6: {
                    return variant.getInt();
                }
                case 3: 
                case 7: {
                    return variant.getLong();
                }
                case 4: {
                    return variant.getBigInteger();
                }
            }
            return variant.getString();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_parentConnection;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int getFetchDirection() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return 1000;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int getFetchSize() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_statement.getProperty(6).getInt();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            if (!this.getConnection().getMetaData().supportsGetGeneratedKeys()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
            }
            ResultSet resultSet = this.createResultSet(this.m_generatedResult, false, 0);
            ((SForwardResultSet)resultSet).initializeColumnNameMap();
            return resultSet;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    protected ILogger getLogger() {
        return this.m_logger;
    }

    @Override
    public synchronized int getMaxFieldSize() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.getStatementPropertyInt(1);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int getMaxRows() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            Variant variant = this.m_statement.getProperty(2);
            long l = variant.getLong();
            if (Integer.MAX_VALUE < l || Integer.MIN_VALUE > l) {
                return 0;
            }
            return (int)l;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized boolean getMoreResults() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.getMoreResults(true);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized boolean getMoreResults(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            switch (n) {
                case 1: {
                    return this.getMoreResults(true);
                }
                case 3: {
                    this.closeAllResultsToCurrent();
                    return this.getMoreResults(true);
                }
                case 2: {
                    IDriver iDriver = DSIDriverSingleton.getInstance();
                    Variant variant = iDriver.getProperty(1005);
                    if (variant.getShort() != 1) {
                        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
                    }
                    return this.getMoreResults(false);
                }
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_MORERESULTS_VALUE, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, String.valueOf(n));
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    public SConnection getParentConnection() {
        return this.m_parentConnection;
    }

    public IQueryExecutor getQueryExecutor() {
        return this.m_queryExecutor;
    }

    @Override
    public synchronized int getQueryTimeout() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.getStatementPropertyInt(3);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized ResultSet getResultSet() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (this.m_resultSets.size() > this.m_currentResultSetIndex) {
                ResultContext resultContext = this.m_resultSets.get(this.m_currentResultSetIndex);
                if (ExecutionResultType.ERROR_RESULT_SET == resultContext.m_resultType) {
                    throw ((IErrorResult)resultContext.m_result).getError();
                }
                if (ExecutionResultType.RESULT_SET == resultContext.m_resultType) {
                    ((SForwardResultSet)resultContext.m_result).initializeColumnNameMap();
                    return (ResultSet)resultContext.m_result;
                }
            }
            return null;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_concurrency;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_parentConnection.getHoldability();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return 1003;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    public IStatement getStatement() {
        return this.m_statement;
    }

    @Override
    public synchronized int getUpdateCount() throws SQLException {
        return this.castRowCount(this.getAnyUpdateCount());
    }

    public synchronized long getAnyUpdateCount() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (this.m_resultSets.size() > this.m_currentResultSetIndex) {
                ResultContext resultContext = this.m_resultSets.get(this.m_currentResultSetIndex);
                if (ExecutionResultType.ERROR_ROW_COUNT == resultContext.m_resultType) {
                    throw ((IErrorResult)resultContext.m_result).getError();
                }
                if (ExecutionResultType.ROW_COUNT == resultContext.m_resultType) {
                    return ((IRowCountResult)resultContext.m_result).getRowCount();
                }
            }
            return -1L;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    protected SWarningListener getWarningListener() {
        return this.m_warningListener;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_warningListener.getSQLWarnings();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    public synchronized void setAttribute(int n, Object object) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (!this.m_statement.isCustomProperty(n)) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ATTRIBUTE, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(n));
            }
            int n2 = this.m_statement.getCustomPropertyType(n);
            this.m_statement.setCustomProperty(n, new Variant(n2, object));
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setCursorName(String string) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setEscapeProcessing(boolean bl) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, bl);
            this.checkIfOpen();
            this.m_escapeProcessingEnabled = bl;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setFetchDirection(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            switch (n) {
                case 1000: {
                    break;
                }
                case 1001: 
                case 1002: {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
                }
                default: {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.UNKNOWN_FETCH_DIRECTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, String.valueOf(n));
                }
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setFetchSize(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            if (n < 0) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_FETCH_SIZE_UNLIMITED_MAX, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n));
            }
            this.m_statement.setProperty(6, new Variant(4, n));
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setMaxFieldSize(int n) throws SQLException {
        long l = 0L;
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        this.checkIfOpen();
        try {
            l = this.getStatementPropertyLong(101);
        }
        catch (Exception exception) {
            // empty catch block
        }
        long l2 = 0L;
        try {
            l2 = this.getStatementPropertyLong(100);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (l > (long)n || 0L != l2 && l2 < (long)n) {
                throw new Exception();
            }
            this.setStatementProperty(1, 4, n);
        }
        catch (Exception exception) {
            String string = String.valueOf(Double.POSITIVE_INFINITY);
            String string2 = String.valueOf(l);
            if (0L != l2) {
                string = String.valueOf(l2);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_FIELD_SIZE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), string2, string);
        }
    }

    @Override
    public synchronized void setMaxRows(int n) throws SQLException {
        this.setAnyMaxRows(n);
    }

    protected synchronized void setAnyMaxRows(long l) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, l);
        this.checkIfOpen();
        long l2 = 0L;
        try {
            l2 = this.getStatementPropertyLong(103);
        }
        catch (Exception exception) {
            // empty catch block
        }
        long l3 = 0L;
        try {
            l3 = this.getStatementPropertyLong(102);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (l2 > l || 0L != l3 && l3 < l) {
                throw new Exception();
            }
            this.setStatementProperty(2, 4, l);
        }
        catch (Exception exception) {
            String string = String.valueOf(Double.POSITIVE_INFINITY);
            String string2 = String.valueOf(l2);
            if (0L != l3) {
                string = String.valueOf(l3);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_MAX_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(l), string2, string);
        }
    }

    @Override
    public synchronized void setQueryTimeout(int n) throws SQLException {
        long l = 0L;
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        this.checkIfOpen();
        try {
            l = this.getStatementPropertyLong(105);
        }
        catch (Exception exception) {
            // empty catch block
        }
        long l2 = 0L;
        try {
            l2 = this.getStatementPropertyLong(104);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            if (l > (long)n || 0L != l2 && l2 < (long)n) {
                throw new Exception();
            }
            this.setStatementProperty(3, 4, n);
        }
        catch (Exception exception) {
            String string = String.valueOf(Double.POSITIVE_INFINITY);
            String string2 = String.valueOf(l);
            if (0L != l2) {
                string = String.valueOf(l2);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_TIMEOUT, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), string2, string);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
        return null == this.m_statement || null == this.getParentConnection();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
        this.checkIfOpen();
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return WrapperUtilities.isWrapperFor(clazz, this);
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        LogUtilities.logFunctionEntrance(this.getLogger(), bl);
        this.checkIfOpen();
    }

    public void setGeneratedValues(ParameterGeneratedValues parameterGeneratedValues) {
        this.m_generatedParams = parameterGeneratedValues;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return WrapperUtilities.unwrap(clazz, this);
    }

    void closeIfPrepared() throws SQLException {
    }

    void closeResults() throws SQLException {
        for (int i = this.m_resultSets.size() - 1; i >= 0; --i) {
            ResultContext resultContext = this.m_resultSets.get(i);
            if (ExecutionResultType.RESULT_SET != resultContext.m_resultType || resultContext.m_isResultClosed) continue;
            ((ResultSet)resultContext.m_result).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markResultSetClosed(ResultSet resultSet) throws SQLException {
        boolean bl = true;
        Object object = this.m_resultSetsLock;
        synchronized (object) {
            for (ResultContext resultContext : this.m_resultSets) {
                if (resultContext.m_result == resultSet) {
                    resultContext.m_isResultClosed = true;
                }
                if (ExecutionResultType.RESULT_SET != resultContext.m_resultType || resultContext.m_isResultClosed) continue;
                bl = false;
            }
        }
        if (bl && this.m_closeOnCompletion) {
            this.close();
        }
    }

    protected void addResultPair(ResultContext resultContext) {
        if (null != this.m_resultSets && !this.m_resultSets.contains(resultContext)) {
            this.m_resultSets.add(resultContext);
        }
    }

    protected void addResultSet(ResultSet resultSet) {
        this.addResultPair(new ResultContext(resultSet));
    }

    protected ExecutionResult checkAndMoveToNextResult(String string, IResults iResults, ThrowCondition throwCondition) throws SQLException {
        if (ThrowCondition.None == throwCondition) {
            return this.moveToNextResult();
        }
        if (!this.m_resultIterator.hasNext()) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.ONE_RESULT_NOT_RETURNED, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(0), string);
        }
        ExecutionResult executionResult = this.moveToNextResult();
        if (this.m_resultIterator.hasNext()) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.ONE_RESULT_NOT_RETURNED, (IWarningListener)this.m_warningListener, ExceptionType.DATA, "1 <", string);
        }
        ExecutionResultType executionResultType = executionResult.getType();
        if (ThrowCondition.SingleResult == throwCondition && ExecutionResultType.RESULT_SET != executionResultType && ExecutionResultType.ERROR_RESULT_SET != executionResultType) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.NO_RESULTSET_GENERATED, (IWarningListener)this.m_warningListener, ExceptionType.DATA, string);
        }
        if (ThrowCondition.SingleRowCount == throwCondition && ExecutionResultType.ROW_COUNT != executionResultType && ExecutionResultType.ERROR_ROW_COUNT != executionResultType) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.NO_ROWCOUNT_GENERATED, (IWarningListener)this.m_warningListener, ExceptionType.DATA, string);
        }
        return executionResult;
    }

    protected void checkCondition(String string, ThrowCondition throwCondition) throws ErrorException, SQLException {
        if (ThrowCondition.None != throwCondition) {
            IResults iResults = this.m_queryExecutor.getResults();
            Iterator<ExecutionResult> iterator = iResults.getResultItr();
            if (!iterator.hasNext()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.ONE_RESULT_NOT_RETURNED, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(0), string);
            }
            ExecutionResult executionResult = iterator.next();
            if (iterator.hasNext()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.ONE_RESULT_NOT_RETURNED, (IWarningListener)this.m_warningListener, ExceptionType.DATA, "1 <", string);
            }
            ExecutionResultType executionResultType = executionResult.getType();
            if (ThrowCondition.SingleResult == throwCondition && ExecutionResultType.RESULT_SET != executionResultType && ExecutionResultType.ERROR_RESULT_SET != executionResultType) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.NO_RESULTSET_GENERATED, (IWarningListener)this.m_warningListener, ExceptionType.DATA, string);
            }
            if (ThrowCondition.SingleRowCount == throwCondition && ExecutionResultType.ROW_COUNT != executionResultType && ExecutionResultType.ERROR_ROW_COUNT != executionResultType) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.NO_ROWCOUNT_GENERATED, (IWarningListener)this.m_warningListener, ExceptionType.DATA, string);
            }
        }
    }

    protected void checkIfNullSQL(String string) throws SQLException {
        if (null == string) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.NULL_SQL_STRING, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkIfOpen() throws SQLException {
        Object object = this.m_closeLock;
        synchronized (object) {
            if (null == this.m_statement) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.STATEMENT_CLOSED, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
            }
        }
    }

    protected void clearResults() {
        if (null != this.m_resultSets) {
            for (ResultContext resultContext : this.m_resultSets) {
                try {
                    if (ExecutionResultType.RESULT_SET != resultContext.m_resultType || resultContext.m_isResultClosed) continue;
                    ((ResultSet)resultContext.m_result).close();
                }
                catch (Exception exception) {}
            }
            this.m_resultSets.clear();
            if (null != this.m_resultIterator) {
                while (this.m_resultIterator.hasNext()) {
                    ExecutionResult executionResult = this.m_resultIterator.next();
                    if (ExecutionResultType.RESULT_SET == executionResult.getType()) {
                        ((IResultSet)executionResult.getResult()).close();
                    }
                    executionResult.getGeneratedResult().close();
                }
                this.m_resultIterator = null;
            }
        }
        this.m_currentResultSetIndex = 0;
        if (this.m_generatedResult != null) {
            this.m_generatedResult.close();
        }
        this.m_generatedResult = new DSIEmptyResultSet();
    }

    protected ResultContext createResultPair(ExecutionResult executionResult) throws SQLException {
        if (ExecutionResultType.ROW_COUNT == executionResult.getType()) {
            IRowCountResult iRowCountResult = (IRowCountResult)executionResult.getResult();
            return new ResultContext(iRowCountResult);
        }
        if (ExecutionResultType.RESULT_SET == executionResult.getType()) {
            ResultSet resultSet = this.createResultSet(executionResult);
            return new ResultContext(resultSet);
        }
        if (ExecutionResultType.ERROR_RESULT_SET == executionResult.getType()) {
            IErrorResult iErrorResult = (IErrorResult)executionResult.getResult();
            return new ResultContext(iErrorResult, true);
        }
        IErrorResult iErrorResult = (IErrorResult)executionResult.getResult();
        return new ResultContext(iErrorResult, false);
    }

    protected ResultSet createResultSet(ExecutionResult executionResult) throws SQLException {
        return this.createResultSet((IResultSet)executionResult.getResult(), this.createsUpdatableResults(), this.getFetchSize());
    }

    protected abstract ResultSet createResultSet(IResultSet var1, boolean var2, int var3) throws SQLException;

    protected boolean createsUpdatableResults() {
        return 1007 != this.m_concurrency;
    }

    @Deprecated
    protected int[] processBatchResults(IResults iResults) throws ErrorException, SQLException {
        return this.processBatchResults(iResults, Collections.emptyList());
    }

    @Deprecated
    protected int[] processBatchResults(IResults iResults, List<Pair<Integer, SQLException>> list) throws ErrorException, SQLException {
        return this.processBatchResults(iResults, list, BatchType.UNKNOWN);
    }

    protected int[] processBatchResults(IResults iResults, List<Pair<Integer, SQLException>> list, BatchType batchType) throws ErrorException, SQLException {
        return new BatchExecutionContext(batchType).processInt(iResults, list);
    }

    @Deprecated
    protected long[] processLargeBatchResults(IResults iResults) throws ErrorException, SQLException {
        return this.processLargeBatchResults(iResults, Collections.emptyList());
    }

    @Deprecated
    protected long[] processLargeBatchResults(IResults iResults, List<Pair<Integer, SQLException>> list) throws ErrorException, SQLException {
        return this.processLargeBatchResults(iResults, list, BatchType.UNKNOWN);
    }

    protected long[] processLargeBatchResults(IResults iResults, List<Pair<Integer, SQLException>> list, BatchType batchType) throws ErrorException, SQLException {
        return new BatchExecutionContext(batchType).processLong(iResults, list);
    }

    protected void addToResultPair(boolean bl, long l) {
        if (bl) {
            this.addResultPair(new ResultContext(new DSISimpleRowCountResult(-1L)));
        } else {
            this.addResultPair(new ResultContext(new DSISimpleRowCountResult(l)));
        }
    }

    protected ExecutionResult moveToNextResult() throws SQLException {
        if (this.m_generatedResult != null) {
            this.m_generatedResult.close();
        }
        this.m_generatedParams = null;
        ExecutionResult executionResult = this.m_resultIterator.next();
        this.m_generatedResult = executionResult.getGeneratedResult();
        return executionResult;
    }

    private void closeAllResultsToCurrent() throws SQLException {
        for (int i = 0; i < this.m_currentResultSetIndex; ++i) {
            ResultContext resultContext = this.m_resultSets.get(i);
            if (ExecutionResultType.RESULT_SET != resultContext.m_resultType || resultContext.m_isResultClosed) continue;
            ((ResultSet)resultContext.m_result).close();
        }
    }

    private IResults executeNoParams(String string, ThrowCondition throwCondition) throws SQLException {
        return this.executeNoParams(string, null, throwCondition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IResults executeNoParams(String string, ParameterGeneratedValues parameterGeneratedValues, ThrowCondition throwCondition) throws SQLException {
        try {
            Object object = this.m_cancelLock;
            synchronized (object) {
                this.m_isInCancelableFunction = true;
            }
            this.m_parentConnection.beginTransaction();
            object = this.m_statement.createDataEngine();
            object.setDirectExecute();
            if (ThrowCondition.None == throwCondition) {
                object.setMetadataNeeded(false);
            }
            this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_PREPARE);
            if (this.m_escapeProcessingEnabled && DSIDriverSingleton.getInstance().getProperty(10).getInt() == 1) {
                string = this.m_parentConnection.nativeSQL(string);
            }
            this.replaceQueryExecutor((IDataEngine)object, object.prepare(string));
            if (this.m_queryExecutor.getNumParams() != 0) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_PARAM, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            }
            this.checkCondition(string, throwCondition);
            ArrayList<ArrayList<ParameterInputValue>> arrayList = new ArrayList<ArrayList<ParameterInputValue>>();
            ArrayList<ParameterMetadata> arrayList2 = new ArrayList<ParameterMetadata>();
            arrayList.add(new ArrayList());
            ExecutionContexts executionContexts = new ExecutionContexts(arrayList2, arrayList, parameterGeneratedValues);
            Object object2 = this.m_cancelLock;
            synchronized (object2) {
                if (this.m_isCanceled) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.OPERATION_CANCELED, (IWarningListener)this.m_warningListener, ExceptionType.TRANSIENT, new Object[0]);
                }
            }
            this.m_warningListener.setCurrentFunction(FunctionID.STATEMENT_EXECUTE);
            this.m_queryExecutor.execute(executionContexts, this.m_warningListener);
            object2 = this.m_queryExecutor.getResults();
            return object2;
        }
        catch (Exception exception) {
            try {
                this.replaceQueryExecutor(null, null);
            }
            catch (Exception exception2) {
                LogUtilities.logError(exception2, this.m_logger);
            }
            finally {
                throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
            }
        }
        finally {
            Object object = this.m_cancelLock;
            synchronized (object) {
                this.m_isInCancelableFunction = false;
            }
        }
    }

    private boolean getMoreResults(boolean bl) throws SQLException {
        if (this.m_resultSets.size() > this.m_currentResultSetIndex) {
            ResultContext resultContext = this.m_resultSets.get(this.m_currentResultSetIndex);
            if (bl && ExecutionResultType.RESULT_SET == resultContext.m_resultType && !resultContext.m_isResultClosed) {
                ((ResultSet)resultContext.m_result).close();
            }
            if (this.m_generatedResult != null) {
                this.m_generatedResult.close();
            }
            ++this.m_currentResultSetIndex;
            if (null != this.m_resultIterator && this.m_resultIterator.hasNext()) {
                ExecutionResult executionResult = this.moveToNextResult();
                ResultContext resultContext2 = this.createResultPair(executionResult);
                this.addResultPair(resultContext2);
            }
            if (this.m_resultSets.size() == this.m_currentResultSetIndex) {
                return false;
            }
            resultContext = this.m_resultSets.get(this.m_currentResultSetIndex);
            return ExecutionResultType.RESULT_SET == resultContext.m_resultType || ExecutionResultType.ERROR_RESULT_SET == resultContext.m_resultType;
        }
        return false;
    }

    private int getStatementPropertyInt(int n) throws SQLException {
        try {
            Variant variant = this.m_statement.getProperty(n);
            return variant.getInt();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
    }

    private long getStatementPropertyLong(int n) throws SQLException {
        try {
            Variant variant = this.m_statement.getProperty(n);
            return variant.getLong();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
    }

    protected void replaceQueryExecutor(IDataEngine iDataEngine, IQueryExecutor iQueryExecutor) {
        IQueryExecutor iQueryExecutor2 = this.m_queryExecutor;
        if (iQueryExecutor2 != null) {
            iQueryExecutor2.close();
        }
        this.m_queryExecutor = iQueryExecutor;
        IDataEngine iDataEngine2 = this.m_dataEngine;
        if (iDataEngine2 != null) {
            iDataEngine2.close();
        }
        this.m_dataEngine = iDataEngine;
    }

    private void setStatementProperty(int n, int n2, Object object) throws SQLException {
        try {
            this.m_warningListener.setCurrentFunction(FunctionID.STATEMENT_SET_PROPERTY);
            this.m_statement.setProperty(n, new Variant(n2, object));
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
    }

    private int castRowCount(long l) {
        return l > Integer.MAX_VALUE ? -2 : (int)l;
    }

    private class BatchExecutionContext {
        private List<SQLException> m_exceptions = null;
        private Boolean m_stopOnError = null;
        private final ArrayList<Long> m_results = new ArrayList();
        private long m_total = 0L;
        private boolean m_isTotalUnknown = false;
        private Iterator<Pair<Integer, SQLException>> m_errorIt = null;
        private Pair<Integer, SQLException> m_nextError = null;
        private int m_batchesUntilNextError = -1;
        private final BatchType m_type;

        public BatchExecutionContext(BatchType batchType) {
            this.m_type = batchType;
        }

        public BatchExecutionContext() {
            this(BatchType.UNKNOWN);
        }

        public int[] processInt(IResults iResults, List<Pair<Integer, SQLException>> list) throws BatchUpdateException, ErrorException {
            return (int[])this.doProcess(iResults, list, false);
        }

        public long[] processLong(IResults iResults, List<Pair<Integer, SQLException>> list) throws BatchUpdateException, ErrorException {
            return (long[])this.doProcess(iResults, list, true);
        }

        private Object doProcess(IResults iResults, List<Pair<Integer, SQLException>> list, boolean bl) throws BatchUpdateException, ErrorException {
            this.collectUpdateCounts(iResults, list);
            SStatement.this.addToResultPair(this.m_isTotalUnknown, this.m_total);
            return this.createResults(bl);
        }

        private void collectUpdateCounts(IResults iResults, List<Pair<Integer, SQLException>> list) throws ErrorException {
            this.initIterators(iResults, list);
            while (SStatement.this.m_resultIterator.hasNext() || -1 != this.m_batchesUntilNextError) {
                boolean bl;
                if (this.m_batchesUntilNextError == 0) {
                    bl = true;
                    this.processConversionError();
                } else {
                    bl = this.processExecutionResult(SStatement.this.m_resultIterator.next());
                    if (this.m_batchesUntilNextError > 0) {
                        --this.m_batchesUntilNextError;
                    }
                }
                if (!bl) continue;
                if (this.shouldStopOnError()) break;
                this.m_results.add(-3L);
            }
        }

        private Object createResults(boolean bl) throws BatchUpdateException {
            Object[] objectArray = bl ? this.toLongArray(this.m_results) : (Object[])this.toIntArray(this.m_results);
            BatchUpdateException batchUpdateException = this.createBatchUpdateException(objectArray);
            if (null != batchUpdateException) {
                throw batchUpdateException;
            }
            return objectArray;
        }

        private boolean shouldStopOnError() {
            if (this.m_stopOnError == null) {
                try {
                    switch (this.m_type) {
                        case MULTI_PARAM_SET: 
                        case MULTI_STATEMENT: {
                            long l = SStatement.this.m_parentConnection.getDSIConnection().getProperty(177).getLong();
                            long l2 = BatchType.MULTI_PARAM_SET == this.m_type ? 2L : 1L;
                            this.m_stopOnError = (l & l2) == l2;
                            break;
                        }
                        case UNKNOWN: {
                            short s = DSIDriverSingleton.getInstance().getProperty(1001).getShort();
                            this.m_stopOnError = s == 1;
                            break;
                        }
                        default: {
                            throw new RuntimeException("Invalid enum value: " + this.m_type.toString());
                        }
                    }
                }
                catch (Exception exception) {
                    LogUtilities.logWarning(exception, SStatement.this.getLogger());
                    this.m_stopOnError = Boolean.TRUE;
                }
            }
            return this.m_stopOnError;
        }

        private int[] toIntArray(List<Long> list) {
            int[] nArray = new int[list.size()];
            int n = 0;
            for (Long l : list) {
                nArray[n++] = SStatement.longUpdateCountToInt(l);
            }
            return nArray;
        }

        private long[] toLongArray(List<Long> list) {
            long[] lArray = new long[list.size()];
            int n = 0;
            for (Long l : list) {
                lArray[n++] = l;
            }
            return lArray;
        }

        BatchUpdateException createBatchUpdateException(Object object) {
            if (object instanceof int[]) {
                return SStatement.createBatchUpdateException(this.m_exceptions, (int[])object);
            }
            return SStatement.largeBatchException(this.m_exceptions, (long[])object);
        }

        private void initIterators(IResults iResults, List<Pair<Integer, SQLException>> list) {
            SStatement.this.m_resultIterator = iResults == null ? Collections.emptyList().iterator() : iResults.getResultItr();
            this.m_errorIt = list.iterator();
            this.updateNextError();
        }

        private void updateNextError() {
            if (this.m_errorIt.hasNext()) {
                this.m_nextError = this.m_errorIt.next();
                this.m_batchesUntilNextError = this.m_nextError.key();
            } else {
                this.m_nextError = null;
                this.m_batchesUntilNextError = -1;
            }
        }

        private boolean processExecutionResult(ExecutionResult executionResult) throws ErrorException {
            if (ExecutionResultType.ROW_COUNT == executionResult.getType()) {
                long l = ((IRowCountResult)executionResult.getResult()).getRowCount();
                if (-1L == l) {
                    this.m_results.add(-2L);
                    this.m_isTotalUnknown = true;
                } else {
                    if (l < 0L) {
                        throw new RuntimeException(String.format("Invalid rowcount returned: %d", l));
                    }
                    this.m_results.add(l);
                    if (!this.m_isTotalUnknown) {
                        if (this.m_total <= Long.MAX_VALUE - l) {
                            this.m_total += this.m_results.get(this.m_results.size() - 1).longValue();
                        } else {
                            this.m_isTotalUnknown = true;
                        }
                    }
                }
                return false;
            }
            if (ExecutionResultType.RESULT_SET == executionResult.getType()) {
                SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.RESULTSET_RETURNED, (IWarningListener)SStatement.this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
                this.getExceptions().add(sQLException);
            } else {
                IErrorResult iErrorResult = (IErrorResult)executionResult.getResult();
                this.getExceptions().add(ExceptionConverter.getInstance().toSQLException(iErrorResult.getError(), SStatement.this.m_warningListener));
            }
            return true;
        }

        private void processConversionError() {
            assert (this.m_nextError != null && this.m_nextError.value() != null);
            this.getExceptions().add(this.m_nextError.value());
            this.updateNextError();
        }

        private List<SQLException> getExceptions() {
            if (this.m_exceptions == null) {
                this.m_exceptions = new ArrayList<SQLException>();
            }
            return this.m_exceptions;
        }
    }

    public static enum BatchType {
        MULTI_STATEMENT,
        MULTI_PARAM_SET,
        UNKNOWN;

    }

    private static enum CheckResultType {
        None,
        CheckAfterExec,
        CheckAfterPrep;

    }

    protected static enum ThrowCondition {
        None,
        SingleResult,
        SingleRowCount;

    }

    protected static class ResultContext {
        protected ExecutionResultType m_resultType;
        protected boolean m_isResultClosed = false;
        protected Object m_result = null;

        ResultContext(IRowCountResult iRowCountResult) {
            this.m_resultType = ExecutionResultType.ROW_COUNT;
            this.m_result = iRowCountResult;
        }

        ResultContext(ResultSet resultSet) {
            this.m_resultType = ExecutionResultType.RESULT_SET;
            this.m_result = resultSet;
        }

        ResultContext(IErrorResult iErrorResult, boolean bl) {
            this.m_resultType = bl ? ExecutionResultType.ERROR_RESULT_SET : ExecutionResultType.ERROR_ROW_COUNT;
            this.m_result = iErrorResult;
        }
    }
}

