/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.tests.unit;

import com.simba.googlebigquery.googlebigquery.tests.unit.BQTestProperties;
import com.simba.googlebigquery.jdbc.DataSource;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.sql.Connection;
import java.sql.SQLException;
import junit.framework.TestCase;
import org.junit.Ignore;
import org.junit.Test;

public class BQDataSourceTests
extends TestCase {
    private DataSource datasource;

    private DataSource createDataSource() {
        DataSource dataSource = new DataSource();
        dataSource.setURL("jdbc:bigquery://googleapis.com:443");
        dataSource.setProjectId("simba-testing-jdbc");
        dataSource.setOAuthServiceAcctEmail("bqtest1@simba-testing-jdbc.iam.gserviceaccount.com");
        dataSource.setOAuthPvtKeyFilePath(BQTestProperties.SERVICE_AUTH_KEYPATH_JSON);
        dataSource.setOAuthType(0);
        return dataSource;
    }

    private void connect(DataSource dataSource) throws SQLException {
        Connection connection = dataSource.getConnection();
        BQDataSourceTests.assertTrue((null != connection ? 1 : 0) != 0);
        connection.close();
    }

    public void setUp() throws Exception {
        this.datasource = this.createDataSource();
    }

    public void tearDown() {
    }

    @Test
    public void testDataSourceAdditionalProjects() throws SQLException {
        this.datasource.setAdditionalProjects("bigquery-public-data");
        BQDataSourceTests.assertEquals((String)"bigquery-public-data", (String)this.datasource.getAdditionalProjects());
        this.connect(this.datasource);
    }

    @Test
    public void testDataSourceAllowLargeResults() throws SQLException {
        this.datasource.setAllowLargeResults(true);
        assert (this.datasource.getAllowLargeResults());
        this.connect(this.datasource);
    }

    @Test
    public void testDataSourceDefaultDataset() throws SQLException {
        this.datasource.setDefaultDataset("InternalTest");
        BQDataSourceTests.assertEquals((String)"InternalTest", (String)this.datasource.getDefaultDataset());
        this.connect(this.datasource);
    }

    @Test
    public void testDataSourceEnableHTAPI() throws SQLException {
        this.datasource.setEnableHighThroughputAPI(true);
        assert (this.datasource.getEnableHighThroughputAPI());
        this.connect(this.datasource);
    }

    @Test
    public void testDataSourceFilterTables() throws SQLException {
        this.datasource.setFilerTablesOnDataset(true);
        assert (this.datasource.getFilerTablesOnDataset());
        this.connect(this.datasource);
    }

    @Test
    public void testDataSourceHighThroughputActivationRatio() throws SQLException {
        Integer n = 1;
        this.datasource.setHighThroughputActivationRatio(n);
        BQDataSourceTests.assertEquals((Object)n, (Object)this.datasource.getHighThroughputActivationRatio());
        this.connect(this.datasource);
    }

    @Test
    public void testDataSourceHighThroughputMinTableSize() throws SQLException {
        Integer n = 1;
        this.datasource.setHighThroughputMinTableSize(n);
        BQDataSourceTests.assertEquals((Object)n, (Object)this.datasource.getHighThroughputMinTableSize());
        this.connect(this.datasource);
    }

    @Test
    public void testDataSourceKMSKeyName() throws SQLException {
        this.datasource.setKMSKeyName("projects/simba-testing-jdbc/locations/us-east1/keyRings/SimbaKeys/cryptoKeys/simba-testing-key");
        BQDataSourceTests.assertEquals((String)"projects/simba-testing-jdbc/locations/us-east1/keyRings/SimbaKeys/cryptoKeys/simba-testing-key", (String)this.datasource.getKMSKeyName());
        this.connect(this.datasource);
    }

    @Test
    public void testDataSourceLargeResultDataSet() throws SQLException {
        this.datasource.setLargeResultDataSet("InternalTest");
        BQDataSourceTests.assertEquals((String)"InternalTest", (String)this.datasource.getLargeResultDataSet());
        this.connect(this.datasource);
    }

    @Test
    public void testDataSourceLargeResultsDatasetExpirationTime() throws SQLException {
        Long l = 1L;
        this.datasource.setLargeResultsDatasetExpirationTime(l);
        BQDataSourceTests.assertEquals((Object)l, (Object)this.datasource.getLargeResultsDatasetExpirationTime());
        this.connect(this.datasource);
    }

    @Test
    public void testDataSourceLargeResultTable() throws SQLException {
        this.datasource.setLargeResultTable("table");
        BQDataSourceTests.assertEquals((String)"table", (String)this.datasource.getLargeResultTable());
        this.connect(this.datasource);
    }

    @Test
    public void testDataSourceLocation() throws SQLException {
        this.datasource.setLocation("US");
        BQDataSourceTests.assertEquals((String)"US", (String)this.datasource.getLocation());
        this.connect(this.datasource);
    }

    @Test
    public void testDataSourceMaxResults() throws ErrorException, SQLException {
        Long l = 1L;
        this.datasource.setMaxResults(l);
        BQDataSourceTests.assertEquals((Object)l, (Object)this.datasource.getMaxResults());
        this.connect(this.datasource);
    }

    @Test
    public void testDataSourceServiceAuthJSONKeyFilePath() throws SQLException {
        BQDataSourceTests.assertEquals((int)0, (int)this.datasource.getOAuthType());
        BQDataSourceTests.assertEquals((String)"bqtest1@simba-testing-jdbc.iam.gserviceaccount.com", (String)this.datasource.getOAuthServiceAcctEmail());
        BQDataSourceTests.assertEquals((String)BQTestProperties.SERVICE_AUTH_KEYPATH_JSON, (String)this.datasource.getOAuthPvtKeyFilePath());
        this.connect(this.datasource);
    }

    @Test
    public void testDataSourceServiceAuthJSONKeyFilePathThroughKey() throws SQLException {
        this.datasource.setOAuthPvtKeyFilePath("invalid");
        this.datasource.setOAuthPvtKey(BQTestProperties.SERVICE_AUTH_KEYPATH_JSON);
        BQDataSourceTests.assertEquals((int)0, (int)this.datasource.getOAuthType());
        BQDataSourceTests.assertEquals((String)"bqtest1@simba-testing-jdbc.iam.gserviceaccount.com", (String)this.datasource.getOAuthServiceAcctEmail());
        BQDataSourceTests.assertEquals((String)"invalid", (String)this.datasource.getOAuthPvtKeyFilePath());
        BQDataSourceTests.assertEquals((String)BQTestProperties.SERVICE_AUTH_KEYPATH_JSON, (String)this.datasource.getOAuthPvtKey());
        this.connect(this.datasource);
    }

    @Test
    public void testDataSourceServiceAuthP12() throws SQLException {
        this.datasource.setOAuthPvtKeyFilePath(BQTestProperties.SERVICE_AUTH_KEYPATH_P12);
        BQDataSourceTests.assertEquals((int)0, (int)this.datasource.getOAuthType());
        BQDataSourceTests.assertEquals((String)"bqtest1@simba-testing-jdbc.iam.gserviceaccount.com", (String)this.datasource.getOAuthServiceAcctEmail());
        BQDataSourceTests.assertEquals((String)BQTestProperties.SERVICE_AUTH_KEYPATH_P12, (String)this.datasource.getOAuthPvtKeyFilePath());
        this.connect(this.datasource);
    }

    @Test
    public void testDataSourceServiceAuthJSONText() throws SQLException {
        this.datasource = new DataSource();
        this.datasource.setURL("jdbc:bigquery://googleapis.com:443");
        this.datasource.setProjectId("simba-testing-jdbc");
        this.datasource.setOAuthServiceAcctEmail("bqtest1@simba-testing-jdbc.iam.gserviceaccount.com");
        this.datasource.setOAuthPvtKey("{  \"type\": \"service_account\",  \"project_id\": \"simba-testing-jdbc\",  \"private_key_id\": \"81ef2f04b1ef47bab84c7d0d7ead3e2a1765cab5\",  \"private_key\": \"-----BEGIN PRIVATE KEY-----\\nMIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQDV0CQ+qwAFEyhZ\\nxadUiITi6Cn46SjiLd4BQjZ65e9Wp7ch1TY2fgcSjE3ipfSL9QdyzeBimMnFzGDy\\ny9rny1YmeHO2KMmzo5g9U+QYurXXqoZGT08Oxoo1uZEbr5TNjMJrsvv3vDLAtqr8\\ny3c46d6kaZXq/gQ8au+3DwnH04/L+XHWjUWd1FiygbMv/NmXpT9aCNTxOVADAc68\\n/Crb+9ZSGDY2pP3zFIu6Hhj41ipyzzYUEJpnDJxyxUipD8oIiiiIs06Q2MyHATsL\\n4AEB5rSQh8nj/gk8ocXQCbhagtHgEUahPrQHO7sYVBfj+b2mJ7Ac8JiFxIcBGMPC\\n3oTviARzAgMBAAECggEATOSy9DqpIioWm9piaBtEtxnJZnPruRPHwGogj6g7n81n\\nJeq4uXYvcvM0W2tVfDPdvuLdbHgIMHNk9kxr6GqPC/zLmFoo18rgyEVwRZh4Jxxz\\nd7uz8dti/xlCX1OQzy9tCDBxP1HWasoGyi0eLkClSjmSqdU6jsPie9ITsWKbVz4w\\nXvS+306/ROfA3ROtXEnsYvyYH0A5ngsBumpQyw/Yrv0LjNKlwCYLHXTuMAklhbMG\\nwDldPkwhCQnknlXjx/s8+sBFwSCWwF5aQS9LstiuUQTBHQRfmQjz3Q7fl8lSw15Z\\nlO75Jyf1Cl2eHzoMZrV6NDBmonjxJ93dLwo2Knu3mQKBgQD+Qp4lPU53NSaVE4Ts\\nbZO5c7KWNRhHraN0yNVkT3mAdTvhODgmVHvBtBABQNqxS6Jby54eiI7Y+H7HOjiG\\n18wTcaRmPcFU482H2CGEVrds2xYKYcyRWwonB+LT4v5J7gWU8JkxmjGaEH/3ubWA\\nejfauw629BtVgcQqxtk/TM4ZZQKBgQDXRqxiDqxTNzi1ztKup8z6bOGcVQEJDCSU\\nkeKNApzRrWXbeWvTbdoFlXvPkIot7SgiQARqu6SO3JMmT7z8lzCpw/aatpTS5e9t\\nY1LFxD0SnrL4p5LyEjmfvNCtBX4CDm0Xe6gw/oJrpan/oswZ+K6DFjD3nqJop8Hx\\nKTZBk6E09wKBgDPNDrs3ikzvHzUwDNy+VmJqF/BSUOgJkEuyvwb4yiBJwjFYatgk\\nTjJgpQIcXHHSnvlkuoot+CxsNCgSzIFsZb9wX7YUztaksrMCbZGwuR4MZKko06yp\\nh5/8E1Jn5LbbL3fwrMVWTNS+l9O4minavJZrlcvgX9FD5ttwN8KVu0ehAoGAK92A\\nvrJSttonuhQcpe4XPGf3SM2hWmCZC5T2XtlLbwYwHRqOuBRIOp8NDWxcW6NZbDEz\\nNTRrAZk8erAAyE9eYRlHJJtTk+26bcWxVg74itS/jx9GOAEysLPeqYLW/EBIRmKy\\nENmrZZfqHebkQ96CYL+i1rICUeTtBeDp507XqF0CgYBLp1J9CEP7EXxh6QiGui1Y\\n9bI94WN+eNMuMHwAG8R/QQkOinkuIoq/Q15aVq1JGggHN6HapQcXN2UAHq32gMrw\\ns5LSSWofV8wMJD4+chPo3oTfs9PA4idhqiCZbva60Hx5G4lsbNVTnpP+hLMPiVm8\\nJtXJnyqqNm30tbyX4PLChw==\\n-----END PRIVATE KEY-----\\n\",  \"client_email\": \"bqtest1@simba-testing-jdbc.iam.gserviceaccount.com\",  \"client_id\": \"106472948226965157953\",  \"auth_uri\": \"https://accounts.google.com/o/oauth2/auth\",  \"token_uri\": \"https://accounts.google.com/o/oauth2/token\",  \"auth_provider_x509_cert_url\": \"https://www.googleapis.com/oauth2/v1/certs\",  \"client_x509_cert_url\": \"https://www.googleapis.com/robot/v1/metadata/x509/bqtest1%40simba-testing-jdbc.iam.gserviceaccount.com\"}");
        this.datasource.setOAuthType(0);
        BQDataSourceTests.assertEquals((String)"{  \"type\": \"service_account\",  \"project_id\": \"simba-testing-jdbc\",  \"private_key_id\": \"81ef2f04b1ef47bab84c7d0d7ead3e2a1765cab5\",  \"private_key\": \"-----BEGIN PRIVATE KEY-----\\nMIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQDV0CQ+qwAFEyhZ\\nxadUiITi6Cn46SjiLd4BQjZ65e9Wp7ch1TY2fgcSjE3ipfSL9QdyzeBimMnFzGDy\\ny9rny1YmeHO2KMmzo5g9U+QYurXXqoZGT08Oxoo1uZEbr5TNjMJrsvv3vDLAtqr8\\ny3c46d6kaZXq/gQ8au+3DwnH04/L+XHWjUWd1FiygbMv/NmXpT9aCNTxOVADAc68\\n/Crb+9ZSGDY2pP3zFIu6Hhj41ipyzzYUEJpnDJxyxUipD8oIiiiIs06Q2MyHATsL\\n4AEB5rSQh8nj/gk8ocXQCbhagtHgEUahPrQHO7sYVBfj+b2mJ7Ac8JiFxIcBGMPC\\n3oTviARzAgMBAAECggEATOSy9DqpIioWm9piaBtEtxnJZnPruRPHwGogj6g7n81n\\nJeq4uXYvcvM0W2tVfDPdvuLdbHgIMHNk9kxr6GqPC/zLmFoo18rgyEVwRZh4Jxxz\\nd7uz8dti/xlCX1OQzy9tCDBxP1HWasoGyi0eLkClSjmSqdU6jsPie9ITsWKbVz4w\\nXvS+306/ROfA3ROtXEnsYvyYH0A5ngsBumpQyw/Yrv0LjNKlwCYLHXTuMAklhbMG\\nwDldPkwhCQnknlXjx/s8+sBFwSCWwF5aQS9LstiuUQTBHQRfmQjz3Q7fl8lSw15Z\\nlO75Jyf1Cl2eHzoMZrV6NDBmonjxJ93dLwo2Knu3mQKBgQD+Qp4lPU53NSaVE4Ts\\nbZO5c7KWNRhHraN0yNVkT3mAdTvhODgmVHvBtBABQNqxS6Jby54eiI7Y+H7HOjiG\\n18wTcaRmPcFU482H2CGEVrds2xYKYcyRWwonB+LT4v5J7gWU8JkxmjGaEH/3ubWA\\nejfauw629BtVgcQqxtk/TM4ZZQKBgQDXRqxiDqxTNzi1ztKup8z6bOGcVQEJDCSU\\nkeKNApzRrWXbeWvTbdoFlXvPkIot7SgiQARqu6SO3JMmT7z8lzCpw/aatpTS5e9t\\nY1LFxD0SnrL4p5LyEjmfvNCtBX4CDm0Xe6gw/oJrpan/oswZ+K6DFjD3nqJop8Hx\\nKTZBk6E09wKBgDPNDrs3ikzvHzUwDNy+VmJqF/BSUOgJkEuyvwb4yiBJwjFYatgk\\nTjJgpQIcXHHSnvlkuoot+CxsNCgSzIFsZb9wX7YUztaksrMCbZGwuR4MZKko06yp\\nh5/8E1Jn5LbbL3fwrMVWTNS+l9O4minavJZrlcvgX9FD5ttwN8KVu0ehAoGAK92A\\nvrJSttonuhQcpe4XPGf3SM2hWmCZC5T2XtlLbwYwHRqOuBRIOp8NDWxcW6NZbDEz\\nNTRrAZk8erAAyE9eYRlHJJtTk+26bcWxVg74itS/jx9GOAEysLPeqYLW/EBIRmKy\\nENmrZZfqHebkQ96CYL+i1rICUeTtBeDp507XqF0CgYBLp1J9CEP7EXxh6QiGui1Y\\n9bI94WN+eNMuMHwAG8R/QQkOinkuIoq/Q15aVq1JGggHN6HapQcXN2UAHq32gMrw\\ns5LSSWofV8wMJD4+chPo3oTfs9PA4idhqiCZbva60Hx5G4lsbNVTnpP+hLMPiVm8\\nJtXJnyqqNm30tbyX4PLChw==\\n-----END PRIVATE KEY-----\\n\",  \"client_email\": \"bqtest1@simba-testing-jdbc.iam.gserviceaccount.com\",  \"client_id\": \"106472948226965157953\",  \"auth_uri\": \"https://accounts.google.com/o/oauth2/auth\",  \"token_uri\": \"https://accounts.google.com/o/oauth2/token\",  \"auth_provider_x509_cert_url\": \"https://www.googleapis.com/oauth2/v1/certs\",  \"client_x509_cert_url\": \"https://www.googleapis.com/robot/v1/metadata/x509/bqtest1%40simba-testing-jdbc.iam.gserviceaccount.com\"}", (String)this.datasource.getOAuthPvtKey());
        this.connect(this.datasource);
    }

    @Test
    public void testDataSourceUserAuth() throws SQLException {
        this.datasource.setOAuthClientSecret("wbER7576mc_1YOII0dGk7jEE");
        BQDataSourceTests.assertEquals((String)"wbER7576mc_1YOII0dGk7jEE", (String)this.datasource.getOAuthClientSecret());
        this.connect(this.datasource);
    }

    @Test
    public void testDataSourceAccessRefreshTokens() throws SQLException {
        this.datasource.setOAuthType(2);
        this.datasource.setOAuthRefreshToken("1//067TLt1dvPbU0CgYIARAAGAYSNwF-L9IrNHbcbfvAdy2RuPi1OI6U0FG4xTIgOEaxZ3t4IMBLAF0acGmJVvBPFQAoWriv6FmTDPc");
        this.datasource.setOAuthAccessToken("token");
        this.datasource.setOAuthClientId("977385342095.apps.googleusercontent.com");
        BQDataSourceTests.assertEquals((String)"token", (String)this.datasource.getOAuthAccessToken());
        BQDataSourceTests.assertEquals((int)2, (int)this.datasource.getOAuthType());
        BQDataSourceTests.assertEquals((String)"1//067TLt1dvPbU0CgYIARAAGAYSNwF-L9IrNHbcbfvAdy2RuPi1OI6U0FG4xTIgOEaxZ3t4IMBLAF0acGmJVvBPFQAoWriv6FmTDPc", (String)this.datasource.getOAuthRefreshToken());
        this.connect(this.datasource);
    }

    @Test
    public void testDataSourceApplicationDefault() throws SQLException {
        this.datasource.setOAuthType(3);
        BQDataSourceTests.assertEquals((int)3, (int)this.datasource.getOAuthType());
        this.connect(this.datasource);
    }

    @Test
    public void testDataSourceProjectId() throws SQLException {
        BQDataSourceTests.assertEquals((String)"simba-testing-jdbc", (String)this.datasource.getProjectId());
        this.connect(this.datasource);
    }

    @Test
    public void testDataSourceProxy() throws SQLException {
        this.datasource.setProxyHost("192.168.203.34");
        this.datasource.setProxyPort(BQTestProperties.PROXY_PORT);
        this.datasource.setProxyUsername("employee");
        this.datasource.setProxyPassword("Sunshine4u");
        BQDataSourceTests.assertEquals((String)"192.168.203.34", (String)this.datasource.getProxyHost());
        BQDataSourceTests.assertEquals((Object)BQTestProperties.PROXY_PORT, (Object)this.datasource.getProxyPort());
        BQDataSourceTests.assertEquals((String)"employee", (String)this.datasource.getProxyUsername());
        BQDataSourceTests.assertEquals((String)"Sunshine4u", (String)this.datasource.getProxyPassword());
        this.connect(this.datasource);
    }

    @Test
    public void testDataSourceQueryDialect() throws SQLException {
        this.datasource.setQueryDialect("SQL");
        BQDataSourceTests.assertEquals((String)"SQL", (String)this.datasource.getQueryDialect());
        this.connect(this.datasource);
    }

    @Test
    public void testDataSourceQueryProperties() throws SQLException {
        this.datasource.setQueryProperties("time_zone=America/Los_Angeles");
        BQDataSourceTests.assertEquals((String)"time_zone=America/Los_Angeles", (String)this.datasource.getQueryProperties());
        this.connect(this.datasource);
    }

    @Test
    public void testDataSourceTrustStore() throws SQLException {
        this.datasource.setSSLTrustStore(BQTestProperties.SSL_TRUSTSTORE);
        this.datasource.setSSLTrustStorePassword("notasecret");
        BQDataSourceTests.assertEquals((String)BQTestProperties.SSL_TRUSTSTORE, (String)this.datasource.getSSLTrustStore());
        BQDataSourceTests.assertEquals((String)"notasecret", (String)this.datasource.getSSLTrustStorePassword());
        this.connect(this.datasource);
    }

    @Test
    public void testDataSourceStringColumnLength() throws SQLException {
        Long l = 1L;
        this.datasource.setStringColumnLength(l);
        BQDataSourceTests.assertEquals((Object)l, (Object)this.datasource.getStringColumnLength());
        this.connect(this.datasource);
    }

    @Test
    public void testDataSourceTimeout() throws SQLException {
        Long l = 0L;
        this.datasource.setTimeout(l);
        BQDataSourceTests.assertEquals((Object)l, (Object)this.datasource.getTimeout());
        this.connect(this.datasource);
    }

    @Test
    public void testDatasourceTimestampFallback() throws SQLException {
        this.datasource.setTimestampFallback(false);
        BQDataSourceTests.assertFalse((boolean)this.datasource.getTimestampFallback());
        this.connect(this.datasource);
    }

    @Test
    public void testDatasourceUseQueryCache() throws SQLException {
        this.datasource.setUseQueryCache(true);
        BQDataSourceTests.assertTrue((boolean)this.datasource.getUseQueryCache());
        this.connect(this.datasource);
    }

    @Test
    @Ignore
    public void testDatasourceURL() throws SQLException {
    }
}

