/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.function;

import com.datical.liquibase.ext.storedlogic.AbstractStoredDatabaseLogicSnapshotGenerator;
import com.datical.liquibase.ext.storedlogic.function.Function;
import com.datical.liquibase.ext.storedlogic.function.mysql.MySQLFunctionSnapshotGenerator;
import com.datical.liquibase.ext.storedlogic.function.postgres.EDBPostgresFunctionSnapshotGenerator;
import com.datical.liquibase.ext.storedlogic.function.postgres.PostgresFunctionSnapshotGenerator;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.CockroachDatabase;
import liquibase.database.core.DB2Database;
import liquibase.database.core.Db2zDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import liquibase.structure.core.StoredDatabaseLogic;

public class FunctionSnapshotGenerator
extends AbstractStoredDatabaseLogicSnapshotGenerator {
    public FunctionSnapshotGenerator() {
        super(Function.class, new Class[]{Schema.class});
    }

    @Override
    protected String getObjectType(Database database) {
        return "FUNCTION";
    }

    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (database instanceof OracleDatabase || database instanceof MySQLDatabase || database instanceof MSSQLDatabase || database instanceof AbstractDb2Database || database instanceof PostgresDatabase && !(database instanceof CockroachDatabase)) {
            return super.getPriority(clazz, database);
        }
        return -1;
    }

    protected StoredDatabaseLogic<Function> createReturnObject() {
        return new Function();
    }

    @Override
    protected String getAddToSql(Schema schema, Database database) {
        if (database instanceof PostgresDatabase && !(database instanceof CockroachDatabase)) {
            return this.getPostgresFunctionGenerator(database).getAddToSql(schema, database);
        }
        if (database instanceof DB2Database) {
            return "SELECT FUNCNAME AS OBJECT_NAME FROM SYSCAT.FUNCTIONS where FUNCSCHEMA='" + schema.getCatalogName() + "' AND definer not in ('SYSIBM') AND body is not null";
        }
        if (database instanceof Db2zDatabase) {
            return "SELECT NAME AS OBJECT_NAME FROM SYSIBM.SYSROUTINES where SCHEMA='" + schema.getCatalogName() + "' AND ROUTINETYPE = 'F' ";
        }
        return super.getAddToSql(schema, database);
    }

    private PostgresFunctionSnapshotGenerator getPostgresFunctionGenerator(Database object) {
        if (!(object instanceof PostgresDatabase)) {
            throw new AssertionError((Object)"Wrong caller of this method. For Postgres only");
        }
        if (PostgresDatabase.DbTypes.EDB.equals(object = ((PostgresDatabase)object).getDbType())) {
            return new EDBPostgresFunctionSnapshotGenerator();
        }
        return new PostgresFunctionSnapshotGenerator();
    }

    @Override
    protected String getSnapshotObjectSql(StoredDatabaseLogic<?> storedDatabaseLogic, Database database) {
        if (database instanceof PostgresDatabase) {
            return this.getPostgresFunctionGenerator(database).getSnapshotObjectSql(storedDatabaseLogic, database);
        }
        if (database instanceof DB2Database) {
            return "select FUNCSCHEMA AS OBJECT_SCHEMA, FUNCNAME AS OBJECT_NAME, BODY AS OBJECT_BODY, CREATE_TIME as CREATED, 'VALID' as STATUS FROM SYSCAT.FUNCTIONS where FUNCSCHEMA='" + storedDatabaseLogic.getSchema().getCatalogName() + "' AND FUNCNAME='" + storedDatabaseLogic.getName() + "' ";
        }
        if (database instanceof Db2zDatabase) {
            return "SELECT SCHEMA AS OBJECT_SCHEMA, NAME AS OBJECT_NAME, TEXT AS OBJECT_BODY, CREATEDTS as CREATED, 'VALID' as STATUS FROM SYSIBM.SYSROUTINES where SCHEMA='" + storedDatabaseLogic.getSchema().getCatalogName() + "' AND ROUTINETYPE = 'F' AND NAME='" + storedDatabaseLogic.getName() + "' ";
        }
        if (database instanceof MySQLDatabase) {
            return "SHOW CREATE FUNCTION " + storedDatabaseLogic.getSchema().getCatalogName() + "." + storedDatabaseLogic.getName();
        }
        return super.getSnapshotObjectSql(storedDatabaseLogic, database);
    }

    @Override
    protected StoredDatabaseLogic performSnapshotAndBuildStoredObject(Database database, StoredDatabaseLogic<?> storedDatabaseLogic) {
        if (database instanceof PostgresDatabase) {
            return this.getPostgresFunctionGenerator(database).performSnapshotAndBuildStoredObject(database, storedDatabaseLogic);
        }
        if (database instanceof MySQLDatabase) {
            return new MySQLFunctionSnapshotGenerator().performSnapshotAndBuildStoredObject(database, storedDatabaseLogic);
        }
        return super.performSnapshotAndBuildStoredObject(database, storedDatabaseLogic);
    }

    @Override
    protected void addTo(DatabaseObject databaseObject, DatabaseSnapshot databaseSnapshot) {
        if (databaseSnapshot.getDatabase() instanceof PostgresDatabase && !(databaseSnapshot.getDatabase() instanceof CockroachDatabase)) {
            this.getPostgresFunctionGenerator(databaseSnapshot.getDatabase()).addTo(databaseObject, databaseSnapshot);
            return;
        }
        super.addTo(databaseObject, databaseSnapshot);
    }
}

