/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import java.io.Serializable;
import java.util.Locale;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.ReadablePartial;

public class DelegatedDateTimeField
extends DateTimeField
implements Serializable {
    private static final long serialVersionUID = -4730164440214502503L;
    private final DateTimeField iField;
    private final DurationField iRangeDurationField;
    private final DateTimeFieldType iType;

    public DelegatedDateTimeField(DateTimeField dateTimeField) {
        this(dateTimeField, null);
    }

    public DelegatedDateTimeField(DateTimeField dateTimeField, DateTimeFieldType dateTimeFieldType) {
        this(dateTimeField, null, dateTimeFieldType);
    }

    public DelegatedDateTimeField(DateTimeField dateTimeField, DurationField durationField, DateTimeFieldType dateTimeFieldType) {
        if (dateTimeField == null) {
            throw new IllegalArgumentException("The field must not be null");
        }
        this.iField = dateTimeField;
        this.iRangeDurationField = durationField;
        this.iType = dateTimeFieldType == null ? dateTimeField.getType() : dateTimeFieldType;
    }

    public final DateTimeField getWrappedField() {
        return this.iField;
    }

    public DateTimeFieldType getType() {
        return this.iType;
    }

    public String getName() {
        return this.iType.getName();
    }

    public boolean isSupported() {
        return this.iField.isSupported();
    }

    public boolean isLenient() {
        return this.iField.isLenient();
    }

    public int get(long l2) {
        return this.iField.get(l2);
    }

    public String getAsText(long l2, Locale locale) {
        return this.iField.getAsText(l2, locale);
    }

    public String getAsText(long l2) {
        return this.iField.getAsText(l2);
    }

    public String getAsText(ReadablePartial readablePartial, int n2, Locale locale) {
        return this.iField.getAsText(readablePartial, n2, locale);
    }

    public String getAsText(ReadablePartial readablePartial, Locale locale) {
        return this.iField.getAsText(readablePartial, locale);
    }

    public String getAsText(int n2, Locale locale) {
        return this.iField.getAsText(n2, locale);
    }

    public String getAsShortText(long l2, Locale locale) {
        return this.iField.getAsShortText(l2, locale);
    }

    public String getAsShortText(long l2) {
        return this.iField.getAsShortText(l2);
    }

    public String getAsShortText(ReadablePartial readablePartial, int n2, Locale locale) {
        return this.iField.getAsShortText(readablePartial, n2, locale);
    }

    public String getAsShortText(ReadablePartial readablePartial, Locale locale) {
        return this.iField.getAsShortText(readablePartial, locale);
    }

    public String getAsShortText(int n2, Locale locale) {
        return this.iField.getAsShortText(n2, locale);
    }

    public long add(long l2, int n2) {
        return this.iField.add(l2, n2);
    }

    public long add(long l2, long l3) {
        return this.iField.add(l2, l3);
    }

    public int[] add(ReadablePartial readablePartial, int n2, int[] nArray, int n3) {
        return this.iField.add(readablePartial, n2, nArray, n3);
    }

    public int[] addWrapPartial(ReadablePartial readablePartial, int n2, int[] nArray, int n3) {
        return this.iField.addWrapPartial(readablePartial, n2, nArray, n3);
    }

    public long addWrapField(long l2, int n2) {
        return this.iField.addWrapField(l2, n2);
    }

    public int[] addWrapField(ReadablePartial readablePartial, int n2, int[] nArray, int n3) {
        return this.iField.addWrapField(readablePartial, n2, nArray, n3);
    }

    public int getDifference(long l2, long l3) {
        return this.iField.getDifference(l2, l3);
    }

    public long getDifferenceAsLong(long l2, long l3) {
        return this.iField.getDifferenceAsLong(l2, l3);
    }

    public long set(long l2, int n2) {
        return this.iField.set(l2, n2);
    }

    public long set(long l2, String string, Locale locale) {
        return this.iField.set(l2, string, locale);
    }

    public long set(long l2, String string) {
        return this.iField.set(l2, string);
    }

    public int[] set(ReadablePartial readablePartial, int n2, int[] nArray, int n3) {
        return this.iField.set(readablePartial, n2, nArray, n3);
    }

    public int[] set(ReadablePartial readablePartial, int n2, int[] nArray, String string, Locale locale) {
        return this.iField.set(readablePartial, n2, nArray, string, locale);
    }

    public DurationField getDurationField() {
        return this.iField.getDurationField();
    }

    public DurationField getRangeDurationField() {
        if (this.iRangeDurationField != null) {
            return this.iRangeDurationField;
        }
        return this.iField.getRangeDurationField();
    }

    public boolean isLeap(long l2) {
        return this.iField.isLeap(l2);
    }

    public int getLeapAmount(long l2) {
        return this.iField.getLeapAmount(l2);
    }

    public DurationField getLeapDurationField() {
        return this.iField.getLeapDurationField();
    }

    public int getMinimumValue() {
        return this.iField.getMinimumValue();
    }

    public int getMinimumValue(long l2) {
        return this.iField.getMinimumValue(l2);
    }

    public int getMinimumValue(ReadablePartial readablePartial) {
        return this.iField.getMinimumValue(readablePartial);
    }

    public int getMinimumValue(ReadablePartial readablePartial, int[] nArray) {
        return this.iField.getMinimumValue(readablePartial, nArray);
    }

    public int getMaximumValue() {
        return this.iField.getMaximumValue();
    }

    public int getMaximumValue(long l2) {
        return this.iField.getMaximumValue(l2);
    }

    public int getMaximumValue(ReadablePartial readablePartial) {
        return this.iField.getMaximumValue(readablePartial);
    }

    public int getMaximumValue(ReadablePartial readablePartial, int[] nArray) {
        return this.iField.getMaximumValue(readablePartial, nArray);
    }

    public int getMaximumTextLength(Locale locale) {
        return this.iField.getMaximumTextLength(locale);
    }

    public int getMaximumShortTextLength(Locale locale) {
        return this.iField.getMaximumShortTextLength(locale);
    }

    public long roundFloor(long l2) {
        return this.iField.roundFloor(l2);
    }

    public long roundCeiling(long l2) {
        return this.iField.roundCeiling(l2);
    }

    public long roundHalfFloor(long l2) {
        return this.iField.roundHalfFloor(l2);
    }

    public long roundHalfCeiling(long l2) {
        return this.iField.roundHalfCeiling(l2);
    }

    public long roundHalfEven(long l2) {
        return this.iField.roundHalfEven(l2);
    }

    public long remainder(long l2) {
        return this.iField.remainder(l2);
    }

    public String toString() {
        return "DateTimeField[" + this.getName() + ']';
    }
}

