/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.Locale;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.chrono.BasicChronology;
import org.joda.time.chrono.GJLocaleSymbols;
import org.joda.time.field.BaseDateTimeField;
import org.joda.time.field.FieldUtils;
import org.joda.time.field.UnsupportedDurationField;

final class GJEraDateTimeField
extends BaseDateTimeField {
    private static final long serialVersionUID = 4240986525305515528L;
    private final BasicChronology iChronology;

    GJEraDateTimeField(BasicChronology basicChronology) {
        super(DateTimeFieldType.era());
        this.iChronology = basicChronology;
    }

    public boolean isLenient() {
        return false;
    }

    public int get(long l2) {
        if (this.iChronology.getYear(l2) <= 0) {
            return 0;
        }
        return 1;
    }

    public String getAsText(int n2, Locale locale) {
        return GJLocaleSymbols.forLocale(locale).eraValueToText(n2);
    }

    public long set(long l2, int n2) {
        FieldUtils.verifyValueBounds(this, n2, 0, 1);
        int n3 = this.get(l2);
        if (n3 != n2) {
            int n4 = this.iChronology.getYear(l2);
            return this.iChronology.setYear(l2, -n4);
        }
        return l2;
    }

    public long set(long l2, String string, Locale locale) {
        return this.set(l2, GJLocaleSymbols.forLocale(locale).eraTextToValue(string));
    }

    public long roundFloor(long l2) {
        if (this.get(l2) == 1) {
            return this.iChronology.setYear(0L, 1);
        }
        return Long.MIN_VALUE;
    }

    public long roundCeiling(long l2) {
        if (this.get(l2) == 0) {
            return this.iChronology.setYear(0L, 1);
        }
        return Long.MAX_VALUE;
    }

    public long roundHalfFloor(long l2) {
        return this.roundFloor(l2);
    }

    public long roundHalfCeiling(long l2) {
        return this.roundFloor(l2);
    }

    public long roundHalfEven(long l2) {
        return this.roundFloor(l2);
    }

    public DurationField getDurationField() {
        return UnsupportedDurationField.getInstance(DurationFieldType.eras());
    }

    public DurationField getRangeDurationField() {
        return null;
    }

    public int getMinimumValue() {
        return 0;
    }

    public int getMaximumValue() {
        return 1;
    }

    public int getMaximumTextLength(Locale locale) {
        return GJLocaleSymbols.forLocale(locale).getEraMaxTextLength();
    }

    private Object readResolve() {
        return this.iChronology.era();
    }
}

