/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import java.nio.ByteBuffer;
import org.capnproto.AnyPointer;
import org.capnproto.BuilderArena;
import org.capnproto.FromPointerBuilder;
import org.capnproto.SegmentBuilder;
import org.capnproto.SetPointerBuilder;

public final class MessageBuilder {
    private final BuilderArena arena;

    public MessageBuilder() {
        this.arena = new BuilderArena(1024, BuilderArena.SUGGESTED_ALLOCATION_STRATEGY);
    }

    public MessageBuilder(int n2) {
        this.arena = new BuilderArena(n2, BuilderArena.SUGGESTED_ALLOCATION_STRATEGY);
    }

    public MessageBuilder(int n2, BuilderArena.AllocationStrategy allocationStrategy) {
        this.arena = new BuilderArena(n2, allocationStrategy);
    }

    private AnyPointer.Builder getRootInternal() {
        SegmentBuilder segmentBuilder = this.arena.segments.get(0);
        if (segmentBuilder.currentSize() == 0) {
            int n2 = segmentBuilder.allocate(1);
            if (n2 == -1) {
                throw new Error("could not allocate root pointer");
            }
            if (n2 != 0) {
                throw new Error("First allocated word of new segment was not at offset 0");
            }
            return new AnyPointer.Builder(segmentBuilder, n2);
        }
        return new AnyPointer.Builder(segmentBuilder, 0);
    }

    public <T> T getRoot(FromPointerBuilder<T> fromPointerBuilder) {
        return this.getRootInternal().getAs(fromPointerBuilder);
    }

    public <T, U> void setRoot(SetPointerBuilder<T, U> setPointerBuilder, U u2) {
        this.getRootInternal().setAs(setPointerBuilder, u2);
    }

    public <T> T initRoot(FromPointerBuilder<T> fromPointerBuilder) {
        return this.getRootInternal().initAs(fromPointerBuilder);
    }

    public final ByteBuffer[] getSegmentsForOutput() {
        return this.arena.getSegmentsForOutput();
    }
}

