/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.easy;

import hex.genmodel.GenModel;
import hex.genmodel.easy.CategoricalEncoder;
import hex.genmodel.easy.DomainMapConstructor;
import hex.genmodel.easy.EigenEncoder;
import java.util.HashMap;
import java.util.Map;

public class EigenEncoderDomainMapConstructor
extends DomainMapConstructor {
    public EigenEncoderDomainMapConstructor(GenModel m2, Map<String, Integer> columnNameToIndex) {
        super(m2, columnNameToIndex);
    }

    @Override
    public Map<Integer, CategoricalEncoder> create() {
        HashMap<Integer, CategoricalEncoder> domainMap = new HashMap<Integer, CategoricalEncoder>();
        String[] columnNames = this._m.getOrigNames();
        int pos = 0;
        for (int i2 = 0; i2 < this._m.getOrigNumCols(); ++i2) {
            String colName = columnNames[i2];
            Integer colIndex = (Integer)this._columnNameToIndex.get(colName);
            String[] domainValues = this._m.getOrigDomainValues()[i2];
            if (domainValues == null) continue;
            double[] targetProjectionArray = new double[domainValues.length];
            System.arraycopy(this._m.getOrigProjectionArray(), pos, targetProjectionArray, 0, domainValues.length);
            pos += domainValues.length;
            domainMap.put(colIndex, new EigenEncoder(colName, colIndex, domainValues, targetProjectionArray));
        }
        return domainMap;
    }
}

