/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.glm;

import hex.genmodel.algos.glm.GlmMojoModelBase;

public class GlmMultinomialMojoModel
extends GlmMojoModelBase {
    private int P;
    private int noff;

    GlmMultinomialMojoModel(String[] columns, String[][] domains, String responseColumn) {
        super(columns, domains, responseColumn);
    }

    @Override
    void init() {
        this.P = this._beta.length / this._nclasses;
        if (this.P * this._nclasses != this._beta.length) {
            throw new IllegalStateException("Incorrect coding of Beta.");
        }
        this.noff = this._catOffsets[this._cats];
    }

    @Override
    public final double[] score0(double[] data, double offset, double[] preds) {
        if (this._meanImputation) {
            super.imputeMissingWithMeans(data);
        }
        return this.glmScore0(data, offset, preds);
    }

    double[] glmScore0(double[] data, double offset, double[] preds) {
        preds[0] = 0.0;
        for (int c2 = 0; c2 < this._nclasses; ++c2) {
            int i2;
            preds[c2 + 1] = 0.0;
            if (this._cats > 0) {
                int ival;
                if (!this._useAllFactorLevels) {
                    for (i2 = 0; i2 < this._catOffsets.length - 1; ++i2) {
                        if (data[i2] == 0.0) continue;
                        ival = (int)data[i2] - 1;
                        if ((double)ival != data[i2] - 1.0) {
                            throw new IllegalArgumentException("categorical value out of range");
                        }
                        if ((ival += this._catOffsets[i2]) >= this._catOffsets[i2 + 1]) continue;
                        int n2 = c2 + 1;
                        preds[n2] = preds[n2] + this._beta[ival + c2 * this.P];
                    }
                } else {
                    for (i2 = 0; i2 < this._catOffsets.length - 1; ++i2) {
                        ival = (int)data[i2];
                        if ((double)ival != data[i2]) {
                            throw new IllegalArgumentException("categorical value out of range");
                        }
                        if ((ival += this._catOffsets[i2]) >= this._catOffsets[i2 + 1]) continue;
                        int n3 = c2 + 1;
                        preds[n3] = preds[n3] + this._beta[ival + c2 * this.P];
                    }
                }
            }
            for (i2 = 0; i2 < this._nums; ++i2) {
                int n4 = c2 + 1;
                preds[n4] = preds[n4] + this._beta[this.noff + i2 + c2 * this.P] * data[i2 + this._cats];
            }
            int n5 = c2 + 1;
            preds[n5] = preds[n5] + this._beta[this.P - 1 + c2 * this.P];
        }
        double max_row = 0.0;
        for (int c3 = 1; c3 < preds.length; ++c3) {
            if (!(preds[c3] > max_row)) continue;
            max_row = preds[c3];
        }
        double sum_exp = 0.0;
        for (int c4 = 1; c4 < preds.length; ++c4) {
            preds[c4] = Math.exp(preds[c4] - max_row);
            sum_exp += preds[c4];
        }
        sum_exp = 1.0 / sum_exp;
        double max_p = 0.0;
        for (int c5 = 1; c5 < preds.length; ++c5) {
            int n6 = c5;
            double d2 = preds[n6] = preds[n6] * sum_exp;
            if (!(d2 > max_p)) continue;
            max_p = preds[c5];
            preds[0] = c5 - 1;
        }
        return preds;
    }
}

