/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.ensemble;

import hex.genmodel.MojoModel;
import java.io.Serializable;

public class StackedEnsembleMojoModel
extends MojoModel {
    MojoModel _metaLearner;
    boolean _useLogitMetaLearnerTransform;
    StackedEnsembleMojoSubModel[] _baseModels;
    int _baseModelNum;

    public StackedEnsembleMojoModel(String[] columns, String[][] domains, String responseColumn) {
        super(columns, domains, responseColumn);
    }

    private static double logit(double p2) {
        double x2 = p2 / (1.0 - p2);
        return x2 == 0.0 ? -19.0 : Math.max(-19.0, Math.log(x2));
    }

    private static void logitTransformRow(double[] basePreds) {
        for (int i2 = 0; i2 < basePreds.length; ++i2) {
            basePreds[i2] = StackedEnsembleMojoModel.logit(Math.min(0.999999999, Math.max(basePreds[i2], 1.0E-9)));
        }
    }

    @Override
    public double[] score0(double[] row, double[] preds) {
        double[] basePreds = new double[this._baseModelNum];
        double[] basePredsRow = new double[preds.length];
        if (this._nclasses > 2) {
            basePreds = new double[this._baseModelNum * this._nclasses];
            for (int i2 = 0; i2 < this._baseModelNum; ++i2) {
                if (this._baseModels[i2] == null) continue;
                for (int j2 = 0; j2 < this._nclasses; ++j2) {
                    basePreds[i2 * this._nclasses + j2] = this._baseModels[i2]._mojoModel.score0(this._baseModels[i2].remapRow(row), basePredsRow)[j2 + 1];
                }
            }
            if (this._useLogitMetaLearnerTransform) {
                StackedEnsembleMojoModel.logitTransformRow(basePreds);
            }
        } else if (this._nclasses == 2) {
            for (int i3 = 0; i3 < this._baseModelNum; ++i3) {
                if (this._baseModels[i3] == null) continue;
                this._baseModels[i3]._mojoModel.score0(this._baseModels[i3].remapRow(row), basePredsRow);
                basePreds[i3] = basePredsRow[2];
            }
            if (this._useLogitMetaLearnerTransform) {
                StackedEnsembleMojoModel.logitTransformRow(basePreds);
            }
        } else {
            for (int i4 = 0; i4 < this._baseModelNum; ++i4) {
                if (this._baseModels[i4] == null) continue;
                this._baseModels[i4]._mojoModel.score0(this._baseModels[i4].remapRow(row), basePredsRow);
                basePreds[i4] = basePredsRow[0];
            }
        }
        this._metaLearner.score0(basePreds, preds);
        return preds;
    }

    static class StackedEnsembleMojoSubModel
    implements Serializable {
        final MojoModel _mojoModel;
        final int[] _mapping;

        public StackedEnsembleMojoSubModel(MojoModel mojoModel, int[] mapping) {
            this._mojoModel = mojoModel;
            this._mapping = mapping;
        }

        public double[] remapRow(double[] row) {
            double[] remappedRow = new double[this._mapping.length];
            for (int i2 = 0; i2 < this._mapping.length; ++i2) {
                remappedRow[i2] = row[this._mapping[i2]];
            }
            return remappedRow;
        }
    }
}

