/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.utils;

import java.util.concurrent.TimeUnit;

public class StopWatch {
    private final long startMilis;
    private long lapStartMilis;

    public static StopWatch start() {
        return new StopWatch(System.currentTimeMillis());
    }

    protected StopWatch(long startMilis) {
        this.startMilis = startMilis;
        this.lapStartMilis = startMilis;
    }

    public long lap() {
        long l2 = System.currentTimeMillis();
        long l3 = l2 - this.lapStartMilis;
        this.lapStartMilis = l2;
        return TimeUnit.MILLISECONDS.toMicros(l3);
    }

    public long stop() {
        return TimeUnit.MILLISECONDS.toMicros(System.currentTimeMillis() - this.startMilis);
    }

    public String lapStr() {
        StopWatch stopWatch = this;
        return stopWatch.toString(stopWatch.lap());
    }

    public String lapStr(long opsCount) {
        assert (opsCount > 0L);
        long l2 = this.lap();
        return this.toString(l2, opsCount);
    }

    public String toString(long totalTime, long opsCount) {
        if (opsCount > 0L) {
            return this.toString(totalTime / opsCount);
        }
        return "NA";
    }

    public String toString(long usecs) {
        long l2 = TimeUnit.MICROSECONDS.toHours(usecs);
        long l3 = TimeUnit.MICROSECONDS.toMinutes(usecs -= TimeUnit.HOURS.toMicros(l2));
        long l4 = TimeUnit.MICROSECONDS.toSeconds(usecs -= TimeUnit.MINUTES.toMicros(l3));
        long l5 = TimeUnit.MICROSECONDS.toMillis(usecs -= TimeUnit.SECONDS.toMicros(l4));
        usecs -= TimeUnit.MILLISECONDS.toMicros(l5);
        if (l2 != 0L) {
            return String.format("%2d:%02d:%02d.%03d", l2, l3, l4, l5);
        }
        if (l3 != 0L) {
            return String.format("%2d min %2d.%03d sec", l3, l4, l5);
        }
        if (l4 != 0L) {
            return String.format("%2d.%03d sec", l4, l5);
        }
        if (l5 != 0L) {
            return String.format("%3d.%03d msec", l5, usecs);
        }
        return String.format("%3d usec", usecs);
    }

    public String toString() {
        StopWatch stopWatch = this;
        return stopWatch.toString(stopWatch.lap());
    }
}

