/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ArrayReaderUtils {
    private ArrayReaderUtils() {
    }

    public static double[] weightsToArray(double[][] weights) {
        if (weights == null) {
            return null;
        }
        int n2 = weights.length == 0 ? 0 : weights[0].length;
        double[] dArray = new double[weights.length * n2];
        for (int i2 = 0; i2 < weights.length; ++i2) {
            double[] dArray2 = weights[i2];
            if (dArray2.length != n2) {
                throw new IllegalArgumentException("Weights have mismatched lengths!");
            }
            int n3 = i2;
            double[] dArray3 = dArray2;
            int n4 = dArray2.length;
            for (int i3 = 0; i3 < n4; ++i3) {
                double d2;
                dArray[n3] = d2 = dArray3[i3];
                n3 += weights.length;
            }
        }
        return dArray;
    }

    public static double[] weightsToArray(List<List<Double>> weights) {
        if (weights == null) {
            return null;
        }
        int n2 = weights.size();
        int n3 = n2 == 0 ? 0 : weights.get(0).size();
        double[] dArray = new double[n2 * n3];
        for (int i2 = 0; i2 < n2; ++i2) {
            List<Double> list = weights.get(i2);
            if (list.size() != n3) {
                throw new IllegalArgumentException("Weights have mismatched lengths!");
            }
            int n4 = i2;
            Iterator<Double> iterator = list.iterator();
            while (iterator.hasNext()) {
                double d2;
                dArray[n4] = d2 = iterator.next().doubleValue();
                n4 += n2;
            }
        }
        return dArray;
    }

    public static double[] fromDoubleListToArray(Collection<Double> list) {
        double[] dArray = new double[list.size()];
        int n2 = 0;
        for (Double d2 : list) {
            dArray[n2] = d2;
            ++n2;
        }
        return dArray;
    }

    public static List<Integer> fromArrayToList(int[] array) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int[] nArray = array;
        int n2 = array.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = nArray[i2];
            arrayList.add(n3);
        }
        return arrayList;
    }

    public static int[] fromIntegerListToArray(Collection<Integer> list) {
        int[] nArray = new int[list.size()];
        int n2 = 0;
        for (Integer n3 : list) {
            nArray[n2] = n3;
            ++n2;
        }
        return nArray;
    }
}

