"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SourceCode = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("./component");
const textfile_1 = require("./textfile");
/**
 * (experimental) Represents a source file.
 *
 * @experimental
 */
class SourceCode extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, filePath, options = {}) {
        var _b;
        super(project);
        this.indentLevel = 0;
        this.indent = (_b = options.indent) !== null && _b !== void 0 ? _b : 2;
        this.file = new textfile_1.TextFile(project, filePath);
    }
    /**
     * (experimental) Emit a line of code.
     *
     * @param code The contents, if not specified, just adds a newline.
     * @experimental
     */
    line(code) {
        const spaces = this.indent * this.indentLevel;
        const prefix = ' '.repeat(spaces);
        this.file.addLine(prefix + (code !== null && code !== void 0 ? code : ''));
    }
    /**
     * (experimental) Opens a code block and increases the indentation level.
     *
     * @param code The code before the block starts (e.g. `export class {`).
     * @experimental
     */
    open(code) {
        if (code) {
            this.line(code);
        }
        this.indentLevel++;
    }
    /**
     * (experimental) Decreases the indentation level and closes a code block.
     *
     * @param code The code after the block is closed (e.g. `}`).
     * @experimental
     */
    close(code) {
        if (this.indentLevel === 0) {
            throw new Error('Cannot decrease indent level below zero');
        }
        this.indentLevel--;
        if (code) {
            this.line(code);
        }
    }
}
exports.SourceCode = SourceCode;
_a = JSII_RTTI_SYMBOL_1;
SourceCode[_a] = { fqn: "projen.SourceCode", version: "0.17.72" };
//# sourceMappingURL=data:application/json;base64,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