"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Dependabot = exports.VersioningStrategy = exports.DependabotScheduleInterval = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const yargs_1 = require("yargs");
const component_1 = require("../component");
const yaml_1 = require("../yaml");
/**
 * (experimental) How often to check for new versions and raise pull requests for version updates.
 *
 * @experimental
 */
var DependabotScheduleInterval;
(function (DependabotScheduleInterval) {
    DependabotScheduleInterval["DAILY"] = "daily";
    DependabotScheduleInterval["WEEKLY"] = "weekly";
    DependabotScheduleInterval["MONTHLY"] = "monthly";
})(DependabotScheduleInterval = exports.DependabotScheduleInterval || (exports.DependabotScheduleInterval = {}));
/**
 * (experimental) The strategy to use when edits manifest and lock files.
 *
 * @experimental
 */
var VersioningStrategy;
(function (VersioningStrategy) {
    VersioningStrategy["LOCKFILE_ONLY"] = "lockfile-only";
    VersioningStrategy["AUTO"] = "auto";
    VersioningStrategy["WIDEN"] = "widen";
    VersioningStrategy["INCREASE"] = "increase";
    VersioningStrategy["INCREASE_IF_NECESSARY"] = "increase-if-necessary";
})(VersioningStrategy = exports.VersioningStrategy || (exports.VersioningStrategy = {}));
/**
 * (experimental) Defines dependabot configuration for node projects.
 *
 * Since module versions are managed in projen, the versioning strategy will be
 * configured to "lockfile-only" which means that only updates that can be done
 * on the lockfile itself will be proposed.
 *
 * @experimental
 */
class Dependabot extends component_1.Component {
    /**
     * @experimental
     */
    constructor(github, options = {}) {
        var _b, _c, _d, _e, _f, _g;
        super(github.project);
        const project = github.project;
        this.ignore = [];
        this.config = {
            version: 2,
            updates: [
                {
                    'package-ecosystem': 'npm',
                    'versioning-strategy': 'lockfile-only',
                    'directory': '/',
                    'schedule': {
                        interval: (_b = options.scheduleInterval) !== null && _b !== void 0 ? _b : DependabotScheduleInterval.DAILY,
                    },
                    'ignore': () => this.ignore.length > 0 ? this.ignore : undefined,
                },
            ],
        };
        new yaml_1.YamlFile(project, '.github/dependabot.yml', {
            obj: this.config,
            committed: true,
        });
        if ((_c = options.autoMerge) !== null && _c !== void 0 ? _c : true) {
            (_d = github.mergify) === null || _d === void 0 ? void 0 : _d.addRule({
                name: 'Merge pull requests from dependabot if CI passes',
                conditions: [
                    'author=dependabot[bot]',
                    'status-success=build',
                ],
                actions: {
                    merge: {
                        method: 'squash',
                        commit_message: 'title+body',
                        strict: 'smart',
                        strict_method: 'merge',
                    },
                },
            });
        }
        for (const i of (_e = options.ignore) !== null && _e !== void 0 ? _e : []) {
            this.addIgnore(i.dependencyName, ...((_f = i.versions) !== null && _f !== void 0 ? _f : []));
        }
        if ((_g = options.ignoreProjen) !== null && _g !== void 0 ? _g : true) {
            this.addIgnore('projen');
        }
    }
    /**
     * (experimental) Ignores a dependency from automatic updates.
     *
     * @param dependencyName Use to ignore updates for dependencies with matching names, optionally using `*` to match zero or more characters.
     * @param versions Use to ignore specific versions or ranges of versions.
     * @experimental
     */
    addIgnore(dependencyName, ...versions) {
        this.ignore.push({
            'dependency-name': dependencyName,
            'versions': () => versions.length > 0 ? yargs_1.version : undefined,
        });
    }
}
exports.Dependabot = Dependabot;
_a = JSII_RTTI_SYMBOL_1;
Dependabot[_a] = { fqn: "projen.github.Dependabot", version: "0.17.72" };
//# sourceMappingURL=data:application/json;base64,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