/**
 * (experimental) Either an IPv4 or an IPv6 CIDR.
 *
 * @experimental
 */
export declare abstract class AclCidr {
    /**
     * (experimental) An IP network range in CIDR notation (for example, 172.16.0.0/24).
     *
     * @experimental
     */
    static ipv4(ipv4Cidr: string): AclCidr;
    /**
     * (experimental) The CIDR containing all IPv4 addresses (i.e., 0.0.0.0/0).
     *
     * @experimental
     */
    static anyIpv4(): AclCidr;
    /**
     * (experimental) An IPv6 network range in CIDR notation (for example, 2001:db8::/48).
     *
     * @experimental
     */
    static ipv6(ipv6Cidr: string): AclCidr;
    /**
     * (experimental) The CIDR containing all IPv6 addresses (i.e., ::/0).
     *
     * @experimental
     */
    static anyIpv6(): AclCidr;
    /**
     * @experimental
     */
    abstract toCidrConfig(): AclCidrConfig;
}
/**
 * (experimental) Acl Configuration for CIDR.
 *
 * @experimental
 */
export interface AclCidrConfig {
    /**
     * (experimental) Ipv4 CIDR.
     *
     * @experimental
     */
    readonly cidrBlock?: string;
    /**
     * (experimental) Ipv6 CIDR.
     *
     * @experimental
     */
    readonly ipv6CidrBlock?: string;
}
/**
 * (experimental) The traffic that is configured using a Network ACL entry.
 *
 * @experimental
 */
export declare abstract class AclTraffic {
    /**
     * (experimental) Apply the ACL entry to all traffic.
     *
     * @experimental
     */
    static allTraffic(): AclTraffic;
    /**
     * (experimental) Apply the ACL entry to ICMP traffic of given type and code.
     *
     * @experimental
     */
    static icmp(props: AclIcmp): AclTraffic;
    /**
     * (experimental) Apply the ACL entry to ICMPv6 traffic of given type and code.
     *
     * Requires an IPv6 CIDR block.
     *
     * @experimental
     */
    static icmpv6(props: AclIcmp): AclTraffic;
    /**
     * (experimental) Apply the ACL entry to TCP traffic on a given port.
     *
     * @experimental
     */
    static tcpPort(port: number): AclTraffic;
    /**
     * (experimental) Apply the ACL entry to TCP traffic on a given port range.
     *
     * @experimental
     */
    static tcpPortRange(startPort: number, endPort: number): AclTraffic;
    /**
     * (experimental) Apply the ACL entry to UDP traffic on a given port.
     *
     * @experimental
     */
    static udpPort(port: number): AclTraffic;
    /**
     * (experimental) Apply the ACL entry to UDP traffic on a given port range.
     *
     * @experimental
     */
    static udpPortRange(startPort: number, endPort: number): AclTraffic;
    /**
     * @experimental
     */
    abstract toTrafficConfig(): AclTrafficConfig;
}
/**
 * (experimental) Acl Configuration for traffic.
 *
 * @experimental
 */
export interface AclTrafficConfig {
    /**
     * (experimental) The Internet Control Message Protocol (ICMP) code and type.
     *
     * @default - Required if specifying 1 (ICMP) for the protocol parameter.
     * @experimental
     */
    readonly icmp?: AclIcmp;
    /**
     * (experimental) The range of port numbers for the UDP/TCP protocol.
     *
     * @default - Required if specifying 6 (TCP) or 17 (UDP) for the protocol parameter
     * @experimental
     */
    readonly portRange?: AclPortRange;
    /**
     * (experimental) The protocol number.
     *
     * A value of "-1" means all protocols.
     *
     * If you specify "-1" or a protocol number other than "6" (TCP), "17" (UDP),
     * or "1" (ICMP), traffic on all ports is allowed, regardless of any ports or
     * ICMP types or codes that you specify.
     *
     * If you specify protocol "58" (ICMPv6) and specify an IPv4 CIDR
     * block, traffic for all ICMP types and codes allowed, regardless of any that
     * you specify. If you specify protocol "58" (ICMPv6) and specify an IPv6 CIDR
     * block, you must specify an ICMP type and code.
     *
     * @default 17
     * @experimental
     */
    readonly protocol: number;
}
/**
 * (experimental) Properties to create Icmp.
 *
 * @experimental
 */
export interface AclIcmp {
    /**
     * (experimental) The Internet Control Message Protocol (ICMP) type.
     *
     * You can use -1 to specify all ICMP types.
     * Conditional requirement: Required if you specify 1 (ICMP) for the CreateNetworkAclEntry protocol parameter.
     *
     * @experimental
     */
    readonly type?: number;
    /**
     * (experimental) The Internet Control Message Protocol (ICMP) code.
     *
     * You can use -1 to specify all ICMP
     * codes for the given ICMP type. Requirement is conditional: Required if you
     * specify 1 (ICMP) for the protocol parameter.
     *
     * @experimental
     */
    readonly code?: number;
}
/**
 * (experimental) Properties to create PortRange.
 *
 * @experimental
 */
export interface AclPortRange {
    /**
     * (experimental) The first port in the range.
     *
     * Required if you specify 6 (TCP) or 17 (UDP) for the protocol parameter.
     *
     * @experimental
     */
    readonly from?: number;
    /**
     * (experimental) The last port in the range.
     *
     * Required if you specify 6 (TCP) or 17 (UDP) for the protocol parameter.
     *
     * @experimental
     */
    readonly to?: number;
}
