# coding: utf-8

"""
    Lidarr

    Lidarr API docs  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel
from lidarr.models.artist_metadata_lazy_loaded import ArtistMetadataLazyLoaded
from lidarr.models.ratings import Ratings

class Track(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    id: Optional[int]
    foreign_track_id: Optional[str]
    old_foreign_track_ids: Optional[List]
    foreign_recording_id: Optional[str]
    old_foreign_recording_ids: Optional[List]
    album_release_id: Optional[int]
    artist_metadata_id: Optional[int]
    track_number: Optional[str]
    absolute_track_number: Optional[int]
    title: Optional[str]
    duration: Optional[int]
    explicit: Optional[bool]
    ratings: Optional[Ratings]
    medium_number: Optional[int]
    track_file_id: Optional[int]
    has_file: Optional[bool]
    album_release: Optional[AlbumReleaseLazyLoaded]
    artist_metadata: Optional[ArtistMetadataLazyLoaded]
    track_file: Optional[TrackFileLazyLoaded]
    artist: Optional[ArtistLazyLoaded]
    album_id: Optional[int]
    album: Optional[Album]
    __properties = ["id", "foreignTrackId", "oldForeignTrackIds", "foreignRecordingId", "oldForeignRecordingIds", "albumReleaseId", "artistMetadataId", "trackNumber", "absoluteTrackNumber", "title", "duration", "explicit", "ratings", "mediumNumber", "trackFileId", "hasFile", "albumRelease", "artistMetadata", "trackFile", "artist", "albumId", "album"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True
        alias_generator = lambda x: x.split("_")[0] + "".join(word.capitalize() for word in x.split("_")[1:])

    def __getitem__(self, item):
        return getattr(self, item)

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Track:
        """Create an instance of Track from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "has_file",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of ratings
        if self.ratings:
            _dict['ratings'] = self.ratings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of album_release
        if self.album_release:
            _dict['albumRelease'] = self.album_release.to_dict()
        # override the default output from pydantic by calling `to_dict()` of artist_metadata
        if self.artist_metadata:
            _dict['artistMetadata'] = self.artist_metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of track_file
        if self.track_file:
            _dict['trackFile'] = self.track_file.to_dict()
        # override the default output from pydantic by calling `to_dict()` of artist
        if self.artist:
            _dict['artist'] = self.artist.to_dict()
        # override the default output from pydantic by calling `to_dict()` of album
        if self.album:
            _dict['album'] = self.album.to_dict()
        # set to None if foreign_track_id (nullable) is None
        if self.foreign_track_id is None:
            _dict['foreignTrackId'] = None

        # set to None if old_foreign_track_ids (nullable) is None
        if self.old_foreign_track_ids is None:
            _dict['oldForeignTrackIds'] = None

        # set to None if foreign_recording_id (nullable) is None
        if self.foreign_recording_id is None:
            _dict['foreignRecordingId'] = None

        # set to None if old_foreign_recording_ids (nullable) is None
        if self.old_foreign_recording_ids is None:
            _dict['oldForeignRecordingIds'] = None

        # set to None if track_number (nullable) is None
        if self.track_number is None:
            _dict['trackNumber'] = None

        # set to None if title (nullable) is None
        if self.title is None:
            _dict['title'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Track:
        """Create an instance of Track from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Track.parse_obj(obj)

        _obj = Track.parse_obj({
            "id": obj.get("id"),
            "foreign_track_id": obj.get("foreignTrackId"),
            "old_foreign_track_ids": obj.get("oldForeignTrackIds"),
            "foreign_recording_id": obj.get("foreignRecordingId"),
            "old_foreign_recording_ids": obj.get("oldForeignRecordingIds"),
            "album_release_id": obj.get("albumReleaseId"),
            "artist_metadata_id": obj.get("artistMetadataId"),
            "track_number": obj.get("trackNumber"),
            "absolute_track_number": obj.get("absoluteTrackNumber"),
            "title": obj.get("title"),
            "duration": obj.get("duration"),
            "explicit": obj.get("explicit"),
            "ratings": Ratings.from_dict(obj.get("ratings")) if obj.get("ratings") is not None else None,
            "medium_number": obj.get("mediumNumber"),
            "track_file_id": obj.get("trackFileId"),
            "has_file": obj.get("hasFile"),
            "album_release": AlbumReleaseLazyLoaded.from_dict(obj.get("albumRelease")) if obj.get("albumRelease") is not None else None,
            "artist_metadata": ArtistMetadataLazyLoaded.from_dict(obj.get("artistMetadata")) if obj.get("artistMetadata") is not None else None,
            "track_file": TrackFileLazyLoaded.from_dict(obj.get("trackFile")) if obj.get("trackFile") is not None else None,
            "artist": ArtistLazyLoaded.from_dict(obj.get("artist")) if obj.get("artist") is not None else None,
            "album_id": obj.get("albumId"),
            "album": Album.from_dict(obj.get("album")) if obj.get("album") is not None else None
        })
        return _obj

