import { IConstruct } from './construct-compat';
/**
 * Includes API for attaching annotations such as warning messages to constructs.
 */
export declare class Annotations {
    private readonly scope;
    /**
     * Returns the annotations API for a construct scope.
     * @param scope The scope
     */
    static of(scope: IConstruct): Annotations;
    private constructor();
    /**
     * Adds a warning metadata entry to this construct.
     *
     * The CLI will display the warning when an app is synthesized, or fail if run
     * in --strict mode.
     *
     * @param message The warning message.
     */
    addWarning(message: string): void;
    /**
     * Adds an info metadata entry to this construct.
     *
     * The CLI will display the info message when apps are synthesized.
     *
     * @param message The info message.
     */
    addInfo(message: string): void;
    /**
     * Adds an { "error": <message> } metadata entry to this construct.
     * The toolkit will fail synthesis when errors are reported.
     * @param message The error message.
     */
    addError(message: string): void;
    /**
     * Adds a message metadata entry to the construct node, to be displayed by the CDK CLI.
     * @param level The message level
     * @param message The message itself
     */
    private addMessage;
}
