"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnRemediationConfiguration = exports.CfnOrganizationConformancePack = exports.CfnOrganizationConfigRule = exports.CfnDeliveryChannel = exports.CfnConformancePack = exports.CfnConfigurationRecorder = exports.CfnConfigurationAggregator = exports.CfnConfigRule = exports.CfnAggregationAuthorization = void 0;
// Copyright 2012-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2020-08-12T18:50:18.880Z","fingerprint":"jKKgJm9FFvBK9/n3fQgclifZpk3UvlSBWUQxO7vg/rc="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const cfn_parse = require("../../core/lib/cfn-parse"); // Automatically re-written from '@aws-cdk/core/lib/cfn-parse'
/**
 * Determine whether the given properties match those of a `CfnAggregationAuthorizationProps`
 *
 * @param properties - the TypeScript properties of a `CfnAggregationAuthorizationProps`
 *
 * @returns the result of the validation.
 */
function CfnAggregationAuthorizationPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('authorizedAccountId', cdk.requiredValidator)(properties.authorizedAccountId));
    errors.collect(cdk.propertyValidator('authorizedAccountId', cdk.validateString)(properties.authorizedAccountId));
    errors.collect(cdk.propertyValidator('authorizedAwsRegion', cdk.requiredValidator)(properties.authorizedAwsRegion));
    errors.collect(cdk.propertyValidator('authorizedAwsRegion', cdk.validateString)(properties.authorizedAwsRegion));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnAggregationAuthorizationProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Config::AggregationAuthorization` resource
 *
 * @param properties - the TypeScript properties of a `CfnAggregationAuthorizationProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Config::AggregationAuthorization` resource.
 */
// @ts-ignore TS6133
function cfnAggregationAuthorizationPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAggregationAuthorizationPropsValidator(properties).assertSuccess();
    return {
        AuthorizedAccountId: cdk.stringToCloudFormation(properties.authorizedAccountId),
        AuthorizedAwsRegion: cdk.stringToCloudFormation(properties.authorizedAwsRegion),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnAggregationAuthorizationPropsFromCloudFormation(properties) {
    properties = properties || {};
    return {
        authorizedAccountId: cfn_parse.FromCloudFormation.getString(properties.AuthorizedAccountId),
        authorizedAwsRegion: cfn_parse.FromCloudFormation.getString(properties.AuthorizedAwsRegion),
        tags: properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined,
    };
}
/**
 * A CloudFormation `AWS::Config::AggregationAuthorization`
 *
 * @cloudformationResource AWS::Config::AggregationAuthorization
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-aggregationauthorization.html
 */
class CfnAggregationAuthorization extends cdk.CfnResource {
    /**
     * Create a new `AWS::Config::AggregationAuthorization`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnAggregationAuthorization.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'authorizedAccountId', this);
        cdk.requireProperty(props, 'authorizedAwsRegion', this);
        this.authorizedAccountId = props.authorizedAccountId;
        this.authorizedAwsRegion = props.authorizedAwsRegion;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::Config::AggregationAuthorization", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const cfnParser = new cfn_parse.CfnParser({
            finder: options.finder,
        });
        const resourceProperties = cfnParser.parseValue(resourceAttributes.Properties);
        const props = CfnAggregationAuthorizationPropsFromCloudFormation(resourceProperties);
        const ret = new CfnAggregationAuthorization(scope, id, props);
        cfnParser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnAggregationAuthorization.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            authorizedAccountId: this.authorizedAccountId,
            authorizedAwsRegion: this.authorizedAwsRegion,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnAggregationAuthorizationPropsToCloudFormation(props);
    }
}
exports.CfnAggregationAuthorization = CfnAggregationAuthorization;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnAggregationAuthorization.CFN_RESOURCE_TYPE_NAME = "AWS::Config::AggregationAuthorization";
/**
 * Determine whether the given properties match those of a `CfnConfigRuleProps`
 *
 * @param properties - the TypeScript properties of a `CfnConfigRuleProps`
 *
 * @returns the result of the validation.
 */
function CfnConfigRulePropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('configRuleName', cdk.validateString)(properties.configRuleName));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('inputParameters', cdk.validateObject)(properties.inputParameters));
    errors.collect(cdk.propertyValidator('maximumExecutionFrequency', cdk.validateString)(properties.maximumExecutionFrequency));
    errors.collect(cdk.propertyValidator('scope', CfnConfigRule_ScopePropertyValidator)(properties.scope));
    errors.collect(cdk.propertyValidator('source', cdk.requiredValidator)(properties.source));
    errors.collect(cdk.propertyValidator('source', CfnConfigRule_SourcePropertyValidator)(properties.source));
    return errors.wrap('supplied properties not correct for "CfnConfigRuleProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Config::ConfigRule` resource
 *
 * @param properties - the TypeScript properties of a `CfnConfigRuleProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Config::ConfigRule` resource.
 */
// @ts-ignore TS6133
function cfnConfigRulePropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnConfigRulePropsValidator(properties).assertSuccess();
    return {
        Source: cfnConfigRuleSourcePropertyToCloudFormation(properties.source),
        ConfigRuleName: cdk.stringToCloudFormation(properties.configRuleName),
        Description: cdk.stringToCloudFormation(properties.description),
        InputParameters: cdk.objectToCloudFormation(properties.inputParameters),
        MaximumExecutionFrequency: cdk.stringToCloudFormation(properties.maximumExecutionFrequency),
        Scope: cfnConfigRuleScopePropertyToCloudFormation(properties.scope),
    };
}
// @ts-ignore TS6133
function CfnConfigRulePropsFromCloudFormation(properties) {
    properties = properties || {};
    return {
        source: CfnConfigRuleSourcePropertyFromCloudFormation(properties.Source),
        configRuleName: properties.ConfigRuleName != null ? cfn_parse.FromCloudFormation.getString(properties.ConfigRuleName) : undefined,
        description: properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined,
        inputParameters: properties.InputParameters != null ? cfn_parse.FromCloudFormation.getAny(properties.InputParameters) : undefined,
        maximumExecutionFrequency: properties.MaximumExecutionFrequency != null ? cfn_parse.FromCloudFormation.getString(properties.MaximumExecutionFrequency) : undefined,
        scope: properties.Scope != null ? CfnConfigRuleScopePropertyFromCloudFormation(properties.Scope) : undefined,
    };
}
/**
 * A CloudFormation `AWS::Config::ConfigRule`
 *
 * @cloudformationResource AWS::Config::ConfigRule
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html
 */
class CfnConfigRule extends cdk.CfnResource {
    /**
     * Create a new `AWS::Config::ConfigRule`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnConfigRule.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'source', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrComplianceType = cdk.Token.asString(this.getAtt('Compliance.Type'));
        this.attrConfigRuleId = cdk.Token.asString(this.getAtt('ConfigRuleId'));
        this.source = props.source;
        this.configRuleName = props.configRuleName;
        this.description = props.description;
        this.inputParameters = props.inputParameters;
        this.maximumExecutionFrequency = props.maximumExecutionFrequency;
        this.scope = props.scope;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const cfnParser = new cfn_parse.CfnParser({
            finder: options.finder,
        });
        const resourceProperties = cfnParser.parseValue(resourceAttributes.Properties);
        const props = CfnConfigRulePropsFromCloudFormation(resourceProperties);
        const ret = new CfnConfigRule(scope, id, props);
        cfnParser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnConfigRule.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            source: this.source,
            configRuleName: this.configRuleName,
            description: this.description,
            inputParameters: this.inputParameters,
            maximumExecutionFrequency: this.maximumExecutionFrequency,
            scope: this.scope,
        };
    }
    renderProperties(props) {
        return cfnConfigRulePropsToCloudFormation(props);
    }
}
exports.CfnConfigRule = CfnConfigRule;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnConfigRule.CFN_RESOURCE_TYPE_NAME = "AWS::Config::ConfigRule";
/**
 * Determine whether the given properties match those of a `ScopeProperty`
 *
 * @param properties - the TypeScript properties of a `ScopeProperty`
 *
 * @returns the result of the validation.
 */
function CfnConfigRule_ScopePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('complianceResourceId', cdk.validateString)(properties.complianceResourceId));
    errors.collect(cdk.propertyValidator('complianceResourceTypes', cdk.listValidator(cdk.validateString))(properties.complianceResourceTypes));
    errors.collect(cdk.propertyValidator('tagKey', cdk.validateString)(properties.tagKey));
    errors.collect(cdk.propertyValidator('tagValue', cdk.validateString)(properties.tagValue));
    return errors.wrap('supplied properties not correct for "ScopeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Config::ConfigRule.Scope` resource
 *
 * @param properties - the TypeScript properties of a `ScopeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Config::ConfigRule.Scope` resource.
 */
// @ts-ignore TS6133
function cfnConfigRuleScopePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnConfigRule_ScopePropertyValidator(properties).assertSuccess();
    return {
        ComplianceResourceId: cdk.stringToCloudFormation(properties.complianceResourceId),
        ComplianceResourceTypes: cdk.listMapper(cdk.stringToCloudFormation)(properties.complianceResourceTypes),
        TagKey: cdk.stringToCloudFormation(properties.tagKey),
        TagValue: cdk.stringToCloudFormation(properties.tagValue),
    };
}
// @ts-ignore TS6133
function CfnConfigRuleScopePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        complianceResourceId: properties.ComplianceResourceId != null ? cfn_parse.FromCloudFormation.getString(properties.ComplianceResourceId) : undefined,
        complianceResourceTypes: properties.ComplianceResourceTypes != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ComplianceResourceTypes) : undefined,
        tagKey: properties.TagKey != null ? cfn_parse.FromCloudFormation.getString(properties.TagKey) : undefined,
        tagValue: properties.TagValue != null ? cfn_parse.FromCloudFormation.getString(properties.TagValue) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `SourceProperty`
 *
 * @param properties - the TypeScript properties of a `SourceProperty`
 *
 * @returns the result of the validation.
 */
function CfnConfigRule_SourcePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('owner', cdk.requiredValidator)(properties.owner));
    errors.collect(cdk.propertyValidator('owner', cdk.validateString)(properties.owner));
    errors.collect(cdk.propertyValidator('sourceDetails', cdk.listValidator(CfnConfigRule_SourceDetailPropertyValidator))(properties.sourceDetails));
    errors.collect(cdk.propertyValidator('sourceIdentifier', cdk.requiredValidator)(properties.sourceIdentifier));
    errors.collect(cdk.propertyValidator('sourceIdentifier', cdk.validateString)(properties.sourceIdentifier));
    return errors.wrap('supplied properties not correct for "SourceProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Config::ConfigRule.Source` resource
 *
 * @param properties - the TypeScript properties of a `SourceProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Config::ConfigRule.Source` resource.
 */
// @ts-ignore TS6133
function cfnConfigRuleSourcePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnConfigRule_SourcePropertyValidator(properties).assertSuccess();
    return {
        Owner: cdk.stringToCloudFormation(properties.owner),
        SourceDetails: cdk.listMapper(cfnConfigRuleSourceDetailPropertyToCloudFormation)(properties.sourceDetails),
        SourceIdentifier: cdk.stringToCloudFormation(properties.sourceIdentifier),
    };
}
// @ts-ignore TS6133
function CfnConfigRuleSourcePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        owner: cfn_parse.FromCloudFormation.getString(properties.Owner),
        sourceDetails: properties.SourceDetails != null ? cfn_parse.FromCloudFormation.getArray(CfnConfigRuleSourceDetailPropertyFromCloudFormation)(properties.SourceDetails) : undefined,
        sourceIdentifier: cfn_parse.FromCloudFormation.getString(properties.SourceIdentifier),
    };
}
/**
 * Determine whether the given properties match those of a `SourceDetailProperty`
 *
 * @param properties - the TypeScript properties of a `SourceDetailProperty`
 *
 * @returns the result of the validation.
 */
function CfnConfigRule_SourceDetailPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('eventSource', cdk.requiredValidator)(properties.eventSource));
    errors.collect(cdk.propertyValidator('eventSource', cdk.validateString)(properties.eventSource));
    errors.collect(cdk.propertyValidator('maximumExecutionFrequency', cdk.validateString)(properties.maximumExecutionFrequency));
    errors.collect(cdk.propertyValidator('messageType', cdk.requiredValidator)(properties.messageType));
    errors.collect(cdk.propertyValidator('messageType', cdk.validateString)(properties.messageType));
    return errors.wrap('supplied properties not correct for "SourceDetailProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Config::ConfigRule.SourceDetail` resource
 *
 * @param properties - the TypeScript properties of a `SourceDetailProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Config::ConfigRule.SourceDetail` resource.
 */
// @ts-ignore TS6133
function cfnConfigRuleSourceDetailPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnConfigRule_SourceDetailPropertyValidator(properties).assertSuccess();
    return {
        EventSource: cdk.stringToCloudFormation(properties.eventSource),
        MaximumExecutionFrequency: cdk.stringToCloudFormation(properties.maximumExecutionFrequency),
        MessageType: cdk.stringToCloudFormation(properties.messageType),
    };
}
// @ts-ignore TS6133
function CfnConfigRuleSourceDetailPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        eventSource: cfn_parse.FromCloudFormation.getString(properties.EventSource),
        maximumExecutionFrequency: properties.MaximumExecutionFrequency != null ? cfn_parse.FromCloudFormation.getString(properties.MaximumExecutionFrequency) : undefined,
        messageType: cfn_parse.FromCloudFormation.getString(properties.MessageType),
    };
}
/**
 * Determine whether the given properties match those of a `CfnConfigurationAggregatorProps`
 *
 * @param properties - the TypeScript properties of a `CfnConfigurationAggregatorProps`
 *
 * @returns the result of the validation.
 */
function CfnConfigurationAggregatorPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('accountAggregationSources', cdk.listValidator(CfnConfigurationAggregator_AccountAggregationSourcePropertyValidator))(properties.accountAggregationSources));
    errors.collect(cdk.propertyValidator('configurationAggregatorName', cdk.requiredValidator)(properties.configurationAggregatorName));
    errors.collect(cdk.propertyValidator('configurationAggregatorName', cdk.validateString)(properties.configurationAggregatorName));
    errors.collect(cdk.propertyValidator('organizationAggregationSource', CfnConfigurationAggregator_OrganizationAggregationSourcePropertyValidator)(properties.organizationAggregationSource));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnConfigurationAggregatorProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Config::ConfigurationAggregator` resource
 *
 * @param properties - the TypeScript properties of a `CfnConfigurationAggregatorProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Config::ConfigurationAggregator` resource.
 */
// @ts-ignore TS6133
function cfnConfigurationAggregatorPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnConfigurationAggregatorPropsValidator(properties).assertSuccess();
    return {
        ConfigurationAggregatorName: cdk.stringToCloudFormation(properties.configurationAggregatorName),
        AccountAggregationSources: cdk.listMapper(cfnConfigurationAggregatorAccountAggregationSourcePropertyToCloudFormation)(properties.accountAggregationSources),
        OrganizationAggregationSource: cfnConfigurationAggregatorOrganizationAggregationSourcePropertyToCloudFormation(properties.organizationAggregationSource),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnConfigurationAggregatorPropsFromCloudFormation(properties) {
    properties = properties || {};
    return {
        configurationAggregatorName: cfn_parse.FromCloudFormation.getString(properties.ConfigurationAggregatorName),
        accountAggregationSources: properties.AccountAggregationSources != null ? cfn_parse.FromCloudFormation.getArray(CfnConfigurationAggregatorAccountAggregationSourcePropertyFromCloudFormation)(properties.AccountAggregationSources) : undefined,
        organizationAggregationSource: properties.OrganizationAggregationSource != null ? CfnConfigurationAggregatorOrganizationAggregationSourcePropertyFromCloudFormation(properties.OrganizationAggregationSource) : undefined,
        tags: properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined,
    };
}
/**
 * A CloudFormation `AWS::Config::ConfigurationAggregator`
 *
 * @cloudformationResource AWS::Config::ConfigurationAggregator
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationaggregator.html
 */
class CfnConfigurationAggregator extends cdk.CfnResource {
    /**
     * Create a new `AWS::Config::ConfigurationAggregator`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnConfigurationAggregator.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'configurationAggregatorName', this);
        this.configurationAggregatorName = props.configurationAggregatorName;
        this.accountAggregationSources = props.accountAggregationSources;
        this.organizationAggregationSource = props.organizationAggregationSource;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::Config::ConfigurationAggregator", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const cfnParser = new cfn_parse.CfnParser({
            finder: options.finder,
        });
        const resourceProperties = cfnParser.parseValue(resourceAttributes.Properties);
        const props = CfnConfigurationAggregatorPropsFromCloudFormation(resourceProperties);
        const ret = new CfnConfigurationAggregator(scope, id, props);
        cfnParser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnConfigurationAggregator.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            configurationAggregatorName: this.configurationAggregatorName,
            accountAggregationSources: this.accountAggregationSources,
            organizationAggregationSource: this.organizationAggregationSource,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnConfigurationAggregatorPropsToCloudFormation(props);
    }
}
exports.CfnConfigurationAggregator = CfnConfigurationAggregator;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnConfigurationAggregator.CFN_RESOURCE_TYPE_NAME = "AWS::Config::ConfigurationAggregator";
/**
 * Determine whether the given properties match those of a `AccountAggregationSourceProperty`
 *
 * @param properties - the TypeScript properties of a `AccountAggregationSourceProperty`
 *
 * @returns the result of the validation.
 */
function CfnConfigurationAggregator_AccountAggregationSourcePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('accountIds', cdk.requiredValidator)(properties.accountIds));
    errors.collect(cdk.propertyValidator('accountIds', cdk.listValidator(cdk.validateString))(properties.accountIds));
    errors.collect(cdk.propertyValidator('allAwsRegions', cdk.validateBoolean)(properties.allAwsRegions));
    errors.collect(cdk.propertyValidator('awsRegions', cdk.listValidator(cdk.validateString))(properties.awsRegions));
    return errors.wrap('supplied properties not correct for "AccountAggregationSourceProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Config::ConfigurationAggregator.AccountAggregationSource` resource
 *
 * @param properties - the TypeScript properties of a `AccountAggregationSourceProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Config::ConfigurationAggregator.AccountAggregationSource` resource.
 */
// @ts-ignore TS6133
function cfnConfigurationAggregatorAccountAggregationSourcePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnConfigurationAggregator_AccountAggregationSourcePropertyValidator(properties).assertSuccess();
    return {
        AccountIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.accountIds),
        AllAwsRegions: cdk.booleanToCloudFormation(properties.allAwsRegions),
        AwsRegions: cdk.listMapper(cdk.stringToCloudFormation)(properties.awsRegions),
    };
}
// @ts-ignore TS6133
function CfnConfigurationAggregatorAccountAggregationSourcePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        accountIds: cfn_parse.FromCloudFormation.getStringArray(properties.AccountIds),
        allAwsRegions: properties.AllAwsRegions != null ? cfn_parse.FromCloudFormation.getBoolean(properties.AllAwsRegions) : undefined,
        awsRegions: properties.AwsRegions != null ? cfn_parse.FromCloudFormation.getStringArray(properties.AwsRegions) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `OrganizationAggregationSourceProperty`
 *
 * @param properties - the TypeScript properties of a `OrganizationAggregationSourceProperty`
 *
 * @returns the result of the validation.
 */
function CfnConfigurationAggregator_OrganizationAggregationSourcePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('allAwsRegions', cdk.validateBoolean)(properties.allAwsRegions));
    errors.collect(cdk.propertyValidator('awsRegions', cdk.listValidator(cdk.validateString))(properties.awsRegions));
    errors.collect(cdk.propertyValidator('roleArn', cdk.requiredValidator)(properties.roleArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    return errors.wrap('supplied properties not correct for "OrganizationAggregationSourceProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Config::ConfigurationAggregator.OrganizationAggregationSource` resource
 *
 * @param properties - the TypeScript properties of a `OrganizationAggregationSourceProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Config::ConfigurationAggregator.OrganizationAggregationSource` resource.
 */
// @ts-ignore TS6133
function cfnConfigurationAggregatorOrganizationAggregationSourcePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnConfigurationAggregator_OrganizationAggregationSourcePropertyValidator(properties).assertSuccess();
    return {
        AllAwsRegions: cdk.booleanToCloudFormation(properties.allAwsRegions),
        AwsRegions: cdk.listMapper(cdk.stringToCloudFormation)(properties.awsRegions),
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
    };
}
// @ts-ignore TS6133
function CfnConfigurationAggregatorOrganizationAggregationSourcePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        allAwsRegions: properties.AllAwsRegions != null ? cfn_parse.FromCloudFormation.getBoolean(properties.AllAwsRegions) : undefined,
        awsRegions: properties.AwsRegions != null ? cfn_parse.FromCloudFormation.getStringArray(properties.AwsRegions) : undefined,
        roleArn: cfn_parse.FromCloudFormation.getString(properties.RoleArn),
    };
}
/**
 * Determine whether the given properties match those of a `CfnConfigurationRecorderProps`
 *
 * @param properties - the TypeScript properties of a `CfnConfigurationRecorderProps`
 *
 * @returns the result of the validation.
 */
function CfnConfigurationRecorderPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('recordingGroup', CfnConfigurationRecorder_RecordingGroupPropertyValidator)(properties.recordingGroup));
    errors.collect(cdk.propertyValidator('roleArn', cdk.requiredValidator)(properties.roleArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    return errors.wrap('supplied properties not correct for "CfnConfigurationRecorderProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Config::ConfigurationRecorder` resource
 *
 * @param properties - the TypeScript properties of a `CfnConfigurationRecorderProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Config::ConfigurationRecorder` resource.
 */
// @ts-ignore TS6133
function cfnConfigurationRecorderPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnConfigurationRecorderPropsValidator(properties).assertSuccess();
    return {
        RoleARN: cdk.stringToCloudFormation(properties.roleArn),
        Name: cdk.stringToCloudFormation(properties.name),
        RecordingGroup: cfnConfigurationRecorderRecordingGroupPropertyToCloudFormation(properties.recordingGroup),
    };
}
// @ts-ignore TS6133
function CfnConfigurationRecorderPropsFromCloudFormation(properties) {
    properties = properties || {};
    return {
        roleArn: cfn_parse.FromCloudFormation.getString(properties.RoleARN),
        name: properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined,
        recordingGroup: properties.RecordingGroup != null ? CfnConfigurationRecorderRecordingGroupPropertyFromCloudFormation(properties.RecordingGroup) : undefined,
    };
}
/**
 * A CloudFormation `AWS::Config::ConfigurationRecorder`
 *
 * @cloudformationResource AWS::Config::ConfigurationRecorder
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html
 */
class CfnConfigurationRecorder extends cdk.CfnResource {
    /**
     * Create a new `AWS::Config::ConfigurationRecorder`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnConfigurationRecorder.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'roleArn', this);
        this.roleArn = props.roleArn;
        this.name = props.name;
        this.recordingGroup = props.recordingGroup;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const cfnParser = new cfn_parse.CfnParser({
            finder: options.finder,
        });
        const resourceProperties = cfnParser.parseValue(resourceAttributes.Properties);
        const props = CfnConfigurationRecorderPropsFromCloudFormation(resourceProperties);
        const ret = new CfnConfigurationRecorder(scope, id, props);
        cfnParser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnConfigurationRecorder.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            roleArn: this.roleArn,
            name: this.name,
            recordingGroup: this.recordingGroup,
        };
    }
    renderProperties(props) {
        return cfnConfigurationRecorderPropsToCloudFormation(props);
    }
}
exports.CfnConfigurationRecorder = CfnConfigurationRecorder;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnConfigurationRecorder.CFN_RESOURCE_TYPE_NAME = "AWS::Config::ConfigurationRecorder";
/**
 * Determine whether the given properties match those of a `RecordingGroupProperty`
 *
 * @param properties - the TypeScript properties of a `RecordingGroupProperty`
 *
 * @returns the result of the validation.
 */
function CfnConfigurationRecorder_RecordingGroupPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('allSupported', cdk.validateBoolean)(properties.allSupported));
    errors.collect(cdk.propertyValidator('includeGlobalResourceTypes', cdk.validateBoolean)(properties.includeGlobalResourceTypes));
    errors.collect(cdk.propertyValidator('resourceTypes', cdk.listValidator(cdk.validateString))(properties.resourceTypes));
    return errors.wrap('supplied properties not correct for "RecordingGroupProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Config::ConfigurationRecorder.RecordingGroup` resource
 *
 * @param properties - the TypeScript properties of a `RecordingGroupProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Config::ConfigurationRecorder.RecordingGroup` resource.
 */
// @ts-ignore TS6133
function cfnConfigurationRecorderRecordingGroupPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnConfigurationRecorder_RecordingGroupPropertyValidator(properties).assertSuccess();
    return {
        AllSupported: cdk.booleanToCloudFormation(properties.allSupported),
        IncludeGlobalResourceTypes: cdk.booleanToCloudFormation(properties.includeGlobalResourceTypes),
        ResourceTypes: cdk.listMapper(cdk.stringToCloudFormation)(properties.resourceTypes),
    };
}
// @ts-ignore TS6133
function CfnConfigurationRecorderRecordingGroupPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        allSupported: properties.AllSupported != null ? cfn_parse.FromCloudFormation.getBoolean(properties.AllSupported) : undefined,
        includeGlobalResourceTypes: properties.IncludeGlobalResourceTypes != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IncludeGlobalResourceTypes) : undefined,
        resourceTypes: properties.ResourceTypes != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ResourceTypes) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `CfnConformancePackProps`
 *
 * @param properties - the TypeScript properties of a `CfnConformancePackProps`
 *
 * @returns the result of the validation.
 */
function CfnConformancePackPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('conformancePackInputParameters', cdk.listValidator(CfnConformancePack_ConformancePackInputParameterPropertyValidator))(properties.conformancePackInputParameters));
    errors.collect(cdk.propertyValidator('conformancePackName', cdk.requiredValidator)(properties.conformancePackName));
    errors.collect(cdk.propertyValidator('conformancePackName', cdk.validateString)(properties.conformancePackName));
    errors.collect(cdk.propertyValidator('deliveryS3Bucket', cdk.requiredValidator)(properties.deliveryS3Bucket));
    errors.collect(cdk.propertyValidator('deliveryS3Bucket', cdk.validateString)(properties.deliveryS3Bucket));
    errors.collect(cdk.propertyValidator('deliveryS3KeyPrefix', cdk.validateString)(properties.deliveryS3KeyPrefix));
    errors.collect(cdk.propertyValidator('templateBody', cdk.validateString)(properties.templateBody));
    errors.collect(cdk.propertyValidator('templateS3Uri', cdk.validateString)(properties.templateS3Uri));
    return errors.wrap('supplied properties not correct for "CfnConformancePackProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Config::ConformancePack` resource
 *
 * @param properties - the TypeScript properties of a `CfnConformancePackProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Config::ConformancePack` resource.
 */
// @ts-ignore TS6133
function cfnConformancePackPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnConformancePackPropsValidator(properties).assertSuccess();
    return {
        ConformancePackName: cdk.stringToCloudFormation(properties.conformancePackName),
        DeliveryS3Bucket: cdk.stringToCloudFormation(properties.deliveryS3Bucket),
        ConformancePackInputParameters: cdk.listMapper(cfnConformancePackConformancePackInputParameterPropertyToCloudFormation)(properties.conformancePackInputParameters),
        DeliveryS3KeyPrefix: cdk.stringToCloudFormation(properties.deliveryS3KeyPrefix),
        TemplateBody: cdk.stringToCloudFormation(properties.templateBody),
        TemplateS3Uri: cdk.stringToCloudFormation(properties.templateS3Uri),
    };
}
// @ts-ignore TS6133
function CfnConformancePackPropsFromCloudFormation(properties) {
    properties = properties || {};
    return {
        conformancePackName: cfn_parse.FromCloudFormation.getString(properties.ConformancePackName),
        deliveryS3Bucket: cfn_parse.FromCloudFormation.getString(properties.DeliveryS3Bucket),
        conformancePackInputParameters: properties.ConformancePackInputParameters != null ? cfn_parse.FromCloudFormation.getArray(CfnConformancePackConformancePackInputParameterPropertyFromCloudFormation)(properties.ConformancePackInputParameters) : undefined,
        deliveryS3KeyPrefix: properties.DeliveryS3KeyPrefix != null ? cfn_parse.FromCloudFormation.getString(properties.DeliveryS3KeyPrefix) : undefined,
        templateBody: properties.TemplateBody != null ? cfn_parse.FromCloudFormation.getString(properties.TemplateBody) : undefined,
        templateS3Uri: properties.TemplateS3Uri != null ? cfn_parse.FromCloudFormation.getString(properties.TemplateS3Uri) : undefined,
    };
}
/**
 * A CloudFormation `AWS::Config::ConformancePack`
 *
 * @cloudformationResource AWS::Config::ConformancePack
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html
 */
class CfnConformancePack extends cdk.CfnResource {
    /**
     * Create a new `AWS::Config::ConformancePack`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnConformancePack.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'conformancePackName', this);
        cdk.requireProperty(props, 'deliveryS3Bucket', this);
        this.conformancePackName = props.conformancePackName;
        this.deliveryS3Bucket = props.deliveryS3Bucket;
        this.conformancePackInputParameters = props.conformancePackInputParameters;
        this.deliveryS3KeyPrefix = props.deliveryS3KeyPrefix;
        this.templateBody = props.templateBody;
        this.templateS3Uri = props.templateS3Uri;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const cfnParser = new cfn_parse.CfnParser({
            finder: options.finder,
        });
        const resourceProperties = cfnParser.parseValue(resourceAttributes.Properties);
        const props = CfnConformancePackPropsFromCloudFormation(resourceProperties);
        const ret = new CfnConformancePack(scope, id, props);
        cfnParser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnConformancePack.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            conformancePackName: this.conformancePackName,
            deliveryS3Bucket: this.deliveryS3Bucket,
            conformancePackInputParameters: this.conformancePackInputParameters,
            deliveryS3KeyPrefix: this.deliveryS3KeyPrefix,
            templateBody: this.templateBody,
            templateS3Uri: this.templateS3Uri,
        };
    }
    renderProperties(props) {
        return cfnConformancePackPropsToCloudFormation(props);
    }
}
exports.CfnConformancePack = CfnConformancePack;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnConformancePack.CFN_RESOURCE_TYPE_NAME = "AWS::Config::ConformancePack";
/**
 * Determine whether the given properties match those of a `ConformancePackInputParameterProperty`
 *
 * @param properties - the TypeScript properties of a `ConformancePackInputParameterProperty`
 *
 * @returns the result of the validation.
 */
function CfnConformancePack_ConformancePackInputParameterPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('parameterName', cdk.requiredValidator)(properties.parameterName));
    errors.collect(cdk.propertyValidator('parameterName', cdk.validateString)(properties.parameterName));
    errors.collect(cdk.propertyValidator('parameterValue', cdk.requiredValidator)(properties.parameterValue));
    errors.collect(cdk.propertyValidator('parameterValue', cdk.validateString)(properties.parameterValue));
    return errors.wrap('supplied properties not correct for "ConformancePackInputParameterProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Config::ConformancePack.ConformancePackInputParameter` resource
 *
 * @param properties - the TypeScript properties of a `ConformancePackInputParameterProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Config::ConformancePack.ConformancePackInputParameter` resource.
 */
// @ts-ignore TS6133
function cfnConformancePackConformancePackInputParameterPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnConformancePack_ConformancePackInputParameterPropertyValidator(properties).assertSuccess();
    return {
        ParameterName: cdk.stringToCloudFormation(properties.parameterName),
        ParameterValue: cdk.stringToCloudFormation(properties.parameterValue),
    };
}
// @ts-ignore TS6133
function CfnConformancePackConformancePackInputParameterPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        parameterName: cfn_parse.FromCloudFormation.getString(properties.ParameterName),
        parameterValue: cfn_parse.FromCloudFormation.getString(properties.ParameterValue),
    };
}
/**
 * Determine whether the given properties match those of a `CfnDeliveryChannelProps`
 *
 * @param properties - the TypeScript properties of a `CfnDeliveryChannelProps`
 *
 * @returns the result of the validation.
 */
function CfnDeliveryChannelPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('configSnapshotDeliveryProperties', CfnDeliveryChannel_ConfigSnapshotDeliveryPropertiesPropertyValidator)(properties.configSnapshotDeliveryProperties));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('s3BucketName', cdk.requiredValidator)(properties.s3BucketName));
    errors.collect(cdk.propertyValidator('s3BucketName', cdk.validateString)(properties.s3BucketName));
    errors.collect(cdk.propertyValidator('s3KeyPrefix', cdk.validateString)(properties.s3KeyPrefix));
    errors.collect(cdk.propertyValidator('snsTopicArn', cdk.validateString)(properties.snsTopicArn));
    return errors.wrap('supplied properties not correct for "CfnDeliveryChannelProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Config::DeliveryChannel` resource
 *
 * @param properties - the TypeScript properties of a `CfnDeliveryChannelProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Config::DeliveryChannel` resource.
 */
// @ts-ignore TS6133
function cfnDeliveryChannelPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDeliveryChannelPropsValidator(properties).assertSuccess();
    return {
        S3BucketName: cdk.stringToCloudFormation(properties.s3BucketName),
        ConfigSnapshotDeliveryProperties: cfnDeliveryChannelConfigSnapshotDeliveryPropertiesPropertyToCloudFormation(properties.configSnapshotDeliveryProperties),
        Name: cdk.stringToCloudFormation(properties.name),
        S3KeyPrefix: cdk.stringToCloudFormation(properties.s3KeyPrefix),
        SnsTopicARN: cdk.stringToCloudFormation(properties.snsTopicArn),
    };
}
// @ts-ignore TS6133
function CfnDeliveryChannelPropsFromCloudFormation(properties) {
    properties = properties || {};
    return {
        s3BucketName: cfn_parse.FromCloudFormation.getString(properties.S3BucketName),
        configSnapshotDeliveryProperties: properties.ConfigSnapshotDeliveryProperties != null ? CfnDeliveryChannelConfigSnapshotDeliveryPropertiesPropertyFromCloudFormation(properties.ConfigSnapshotDeliveryProperties) : undefined,
        name: properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined,
        s3KeyPrefix: properties.S3KeyPrefix != null ? cfn_parse.FromCloudFormation.getString(properties.S3KeyPrefix) : undefined,
        snsTopicArn: properties.SnsTopicARN != null ? cfn_parse.FromCloudFormation.getString(properties.SnsTopicARN) : undefined,
    };
}
/**
 * A CloudFormation `AWS::Config::DeliveryChannel`
 *
 * @cloudformationResource AWS::Config::DeliveryChannel
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-deliverychannel.html
 */
class CfnDeliveryChannel extends cdk.CfnResource {
    /**
     * Create a new `AWS::Config::DeliveryChannel`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDeliveryChannel.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 's3BucketName', this);
        this.s3BucketName = props.s3BucketName;
        this.configSnapshotDeliveryProperties = props.configSnapshotDeliveryProperties;
        this.name = props.name;
        this.s3KeyPrefix = props.s3KeyPrefix;
        this.snsTopicArn = props.snsTopicArn;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const cfnParser = new cfn_parse.CfnParser({
            finder: options.finder,
        });
        const resourceProperties = cfnParser.parseValue(resourceAttributes.Properties);
        const props = CfnDeliveryChannelPropsFromCloudFormation(resourceProperties);
        const ret = new CfnDeliveryChannel(scope, id, props);
        cfnParser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDeliveryChannel.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            s3BucketName: this.s3BucketName,
            configSnapshotDeliveryProperties: this.configSnapshotDeliveryProperties,
            name: this.name,
            s3KeyPrefix: this.s3KeyPrefix,
            snsTopicArn: this.snsTopicArn,
        };
    }
    renderProperties(props) {
        return cfnDeliveryChannelPropsToCloudFormation(props);
    }
}
exports.CfnDeliveryChannel = CfnDeliveryChannel;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDeliveryChannel.CFN_RESOURCE_TYPE_NAME = "AWS::Config::DeliveryChannel";
/**
 * Determine whether the given properties match those of a `ConfigSnapshotDeliveryPropertiesProperty`
 *
 * @param properties - the TypeScript properties of a `ConfigSnapshotDeliveryPropertiesProperty`
 *
 * @returns the result of the validation.
 */
function CfnDeliveryChannel_ConfigSnapshotDeliveryPropertiesPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('deliveryFrequency', cdk.validateString)(properties.deliveryFrequency));
    return errors.wrap('supplied properties not correct for "ConfigSnapshotDeliveryPropertiesProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Config::DeliveryChannel.ConfigSnapshotDeliveryProperties` resource
 *
 * @param properties - the TypeScript properties of a `ConfigSnapshotDeliveryPropertiesProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Config::DeliveryChannel.ConfigSnapshotDeliveryProperties` resource.
 */
// @ts-ignore TS6133
function cfnDeliveryChannelConfigSnapshotDeliveryPropertiesPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDeliveryChannel_ConfigSnapshotDeliveryPropertiesPropertyValidator(properties).assertSuccess();
    return {
        DeliveryFrequency: cdk.stringToCloudFormation(properties.deliveryFrequency),
    };
}
// @ts-ignore TS6133
function CfnDeliveryChannelConfigSnapshotDeliveryPropertiesPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        deliveryFrequency: properties.DeliveryFrequency != null ? cfn_parse.FromCloudFormation.getString(properties.DeliveryFrequency) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `CfnOrganizationConfigRuleProps`
 *
 * @param properties - the TypeScript properties of a `CfnOrganizationConfigRuleProps`
 *
 * @returns the result of the validation.
 */
function CfnOrganizationConfigRulePropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('excludedAccounts', cdk.listValidator(cdk.validateString))(properties.excludedAccounts));
    errors.collect(cdk.propertyValidator('organizationConfigRuleName', cdk.requiredValidator)(properties.organizationConfigRuleName));
    errors.collect(cdk.propertyValidator('organizationConfigRuleName', cdk.validateString)(properties.organizationConfigRuleName));
    errors.collect(cdk.propertyValidator('organizationCustomRuleMetadata', CfnOrganizationConfigRule_OrganizationCustomRuleMetadataPropertyValidator)(properties.organizationCustomRuleMetadata));
    errors.collect(cdk.propertyValidator('organizationManagedRuleMetadata', CfnOrganizationConfigRule_OrganizationManagedRuleMetadataPropertyValidator)(properties.organizationManagedRuleMetadata));
    return errors.wrap('supplied properties not correct for "CfnOrganizationConfigRuleProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Config::OrganizationConfigRule` resource
 *
 * @param properties - the TypeScript properties of a `CfnOrganizationConfigRuleProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Config::OrganizationConfigRule` resource.
 */
// @ts-ignore TS6133
function cfnOrganizationConfigRulePropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnOrganizationConfigRulePropsValidator(properties).assertSuccess();
    return {
        OrganizationConfigRuleName: cdk.stringToCloudFormation(properties.organizationConfigRuleName),
        ExcludedAccounts: cdk.listMapper(cdk.stringToCloudFormation)(properties.excludedAccounts),
        OrganizationCustomRuleMetadata: cfnOrganizationConfigRuleOrganizationCustomRuleMetadataPropertyToCloudFormation(properties.organizationCustomRuleMetadata),
        OrganizationManagedRuleMetadata: cfnOrganizationConfigRuleOrganizationManagedRuleMetadataPropertyToCloudFormation(properties.organizationManagedRuleMetadata),
    };
}
// @ts-ignore TS6133
function CfnOrganizationConfigRulePropsFromCloudFormation(properties) {
    properties = properties || {};
    return {
        organizationConfigRuleName: cfn_parse.FromCloudFormation.getString(properties.OrganizationConfigRuleName),
        excludedAccounts: properties.ExcludedAccounts != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ExcludedAccounts) : undefined,
        organizationCustomRuleMetadata: properties.OrganizationCustomRuleMetadata != null ? CfnOrganizationConfigRuleOrganizationCustomRuleMetadataPropertyFromCloudFormation(properties.OrganizationCustomRuleMetadata) : undefined,
        organizationManagedRuleMetadata: properties.OrganizationManagedRuleMetadata != null ? CfnOrganizationConfigRuleOrganizationManagedRuleMetadataPropertyFromCloudFormation(properties.OrganizationManagedRuleMetadata) : undefined,
    };
}
/**
 * A CloudFormation `AWS::Config::OrganizationConfigRule`
 *
 * @cloudformationResource AWS::Config::OrganizationConfigRule
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconfigrule.html
 */
class CfnOrganizationConfigRule extends cdk.CfnResource {
    /**
     * Create a new `AWS::Config::OrganizationConfigRule`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnOrganizationConfigRule.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'organizationConfigRuleName', this);
        this.organizationConfigRuleName = props.organizationConfigRuleName;
        this.excludedAccounts = props.excludedAccounts;
        this.organizationCustomRuleMetadata = props.organizationCustomRuleMetadata;
        this.organizationManagedRuleMetadata = props.organizationManagedRuleMetadata;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const cfnParser = new cfn_parse.CfnParser({
            finder: options.finder,
        });
        const resourceProperties = cfnParser.parseValue(resourceAttributes.Properties);
        const props = CfnOrganizationConfigRulePropsFromCloudFormation(resourceProperties);
        const ret = new CfnOrganizationConfigRule(scope, id, props);
        cfnParser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnOrganizationConfigRule.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            organizationConfigRuleName: this.organizationConfigRuleName,
            excludedAccounts: this.excludedAccounts,
            organizationCustomRuleMetadata: this.organizationCustomRuleMetadata,
            organizationManagedRuleMetadata: this.organizationManagedRuleMetadata,
        };
    }
    renderProperties(props) {
        return cfnOrganizationConfigRulePropsToCloudFormation(props);
    }
}
exports.CfnOrganizationConfigRule = CfnOrganizationConfigRule;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnOrganizationConfigRule.CFN_RESOURCE_TYPE_NAME = "AWS::Config::OrganizationConfigRule";
/**
 * Determine whether the given properties match those of a `OrganizationCustomRuleMetadataProperty`
 *
 * @param properties - the TypeScript properties of a `OrganizationCustomRuleMetadataProperty`
 *
 * @returns the result of the validation.
 */
function CfnOrganizationConfigRule_OrganizationCustomRuleMetadataPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('inputParameters', cdk.validateString)(properties.inputParameters));
    errors.collect(cdk.propertyValidator('lambdaFunctionArn', cdk.requiredValidator)(properties.lambdaFunctionArn));
    errors.collect(cdk.propertyValidator('lambdaFunctionArn', cdk.validateString)(properties.lambdaFunctionArn));
    errors.collect(cdk.propertyValidator('maximumExecutionFrequency', cdk.validateString)(properties.maximumExecutionFrequency));
    errors.collect(cdk.propertyValidator('organizationConfigRuleTriggerTypes', cdk.requiredValidator)(properties.organizationConfigRuleTriggerTypes));
    errors.collect(cdk.propertyValidator('organizationConfigRuleTriggerTypes', cdk.listValidator(cdk.validateString))(properties.organizationConfigRuleTriggerTypes));
    errors.collect(cdk.propertyValidator('resourceIdScope', cdk.validateString)(properties.resourceIdScope));
    errors.collect(cdk.propertyValidator('resourceTypesScope', cdk.listValidator(cdk.validateString))(properties.resourceTypesScope));
    errors.collect(cdk.propertyValidator('tagKeyScope', cdk.validateString)(properties.tagKeyScope));
    errors.collect(cdk.propertyValidator('tagValueScope', cdk.validateString)(properties.tagValueScope));
    return errors.wrap('supplied properties not correct for "OrganizationCustomRuleMetadataProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Config::OrganizationConfigRule.OrganizationCustomRuleMetadata` resource
 *
 * @param properties - the TypeScript properties of a `OrganizationCustomRuleMetadataProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Config::OrganizationConfigRule.OrganizationCustomRuleMetadata` resource.
 */
// @ts-ignore TS6133
function cfnOrganizationConfigRuleOrganizationCustomRuleMetadataPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnOrganizationConfigRule_OrganizationCustomRuleMetadataPropertyValidator(properties).assertSuccess();
    return {
        Description: cdk.stringToCloudFormation(properties.description),
        InputParameters: cdk.stringToCloudFormation(properties.inputParameters),
        LambdaFunctionArn: cdk.stringToCloudFormation(properties.lambdaFunctionArn),
        MaximumExecutionFrequency: cdk.stringToCloudFormation(properties.maximumExecutionFrequency),
        OrganizationConfigRuleTriggerTypes: cdk.listMapper(cdk.stringToCloudFormation)(properties.organizationConfigRuleTriggerTypes),
        ResourceIdScope: cdk.stringToCloudFormation(properties.resourceIdScope),
        ResourceTypesScope: cdk.listMapper(cdk.stringToCloudFormation)(properties.resourceTypesScope),
        TagKeyScope: cdk.stringToCloudFormation(properties.tagKeyScope),
        TagValueScope: cdk.stringToCloudFormation(properties.tagValueScope),
    };
}
// @ts-ignore TS6133
function CfnOrganizationConfigRuleOrganizationCustomRuleMetadataPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        description: properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined,
        inputParameters: properties.InputParameters != null ? cfn_parse.FromCloudFormation.getString(properties.InputParameters) : undefined,
        lambdaFunctionArn: cfn_parse.FromCloudFormation.getString(properties.LambdaFunctionArn),
        maximumExecutionFrequency: properties.MaximumExecutionFrequency != null ? cfn_parse.FromCloudFormation.getString(properties.MaximumExecutionFrequency) : undefined,
        organizationConfigRuleTriggerTypes: cfn_parse.FromCloudFormation.getStringArray(properties.OrganizationConfigRuleTriggerTypes),
        resourceIdScope: properties.ResourceIdScope != null ? cfn_parse.FromCloudFormation.getString(properties.ResourceIdScope) : undefined,
        resourceTypesScope: properties.ResourceTypesScope != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ResourceTypesScope) : undefined,
        tagKeyScope: properties.TagKeyScope != null ? cfn_parse.FromCloudFormation.getString(properties.TagKeyScope) : undefined,
        tagValueScope: properties.TagValueScope != null ? cfn_parse.FromCloudFormation.getString(properties.TagValueScope) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `OrganizationManagedRuleMetadataProperty`
 *
 * @param properties - the TypeScript properties of a `OrganizationManagedRuleMetadataProperty`
 *
 * @returns the result of the validation.
 */
function CfnOrganizationConfigRule_OrganizationManagedRuleMetadataPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('inputParameters', cdk.validateString)(properties.inputParameters));
    errors.collect(cdk.propertyValidator('maximumExecutionFrequency', cdk.validateString)(properties.maximumExecutionFrequency));
    errors.collect(cdk.propertyValidator('resourceIdScope', cdk.validateString)(properties.resourceIdScope));
    errors.collect(cdk.propertyValidator('resourceTypesScope', cdk.listValidator(cdk.validateString))(properties.resourceTypesScope));
    errors.collect(cdk.propertyValidator('ruleIdentifier', cdk.requiredValidator)(properties.ruleIdentifier));
    errors.collect(cdk.propertyValidator('ruleIdentifier', cdk.validateString)(properties.ruleIdentifier));
    errors.collect(cdk.propertyValidator('tagKeyScope', cdk.validateString)(properties.tagKeyScope));
    errors.collect(cdk.propertyValidator('tagValueScope', cdk.validateString)(properties.tagValueScope));
    return errors.wrap('supplied properties not correct for "OrganizationManagedRuleMetadataProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Config::OrganizationConfigRule.OrganizationManagedRuleMetadata` resource
 *
 * @param properties - the TypeScript properties of a `OrganizationManagedRuleMetadataProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Config::OrganizationConfigRule.OrganizationManagedRuleMetadata` resource.
 */
// @ts-ignore TS6133
function cfnOrganizationConfigRuleOrganizationManagedRuleMetadataPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnOrganizationConfigRule_OrganizationManagedRuleMetadataPropertyValidator(properties).assertSuccess();
    return {
        Description: cdk.stringToCloudFormation(properties.description),
        InputParameters: cdk.stringToCloudFormation(properties.inputParameters),
        MaximumExecutionFrequency: cdk.stringToCloudFormation(properties.maximumExecutionFrequency),
        ResourceIdScope: cdk.stringToCloudFormation(properties.resourceIdScope),
        ResourceTypesScope: cdk.listMapper(cdk.stringToCloudFormation)(properties.resourceTypesScope),
        RuleIdentifier: cdk.stringToCloudFormation(properties.ruleIdentifier),
        TagKeyScope: cdk.stringToCloudFormation(properties.tagKeyScope),
        TagValueScope: cdk.stringToCloudFormation(properties.tagValueScope),
    };
}
// @ts-ignore TS6133
function CfnOrganizationConfigRuleOrganizationManagedRuleMetadataPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        description: properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined,
        inputParameters: properties.InputParameters != null ? cfn_parse.FromCloudFormation.getString(properties.InputParameters) : undefined,
        maximumExecutionFrequency: properties.MaximumExecutionFrequency != null ? cfn_parse.FromCloudFormation.getString(properties.MaximumExecutionFrequency) : undefined,
        resourceIdScope: properties.ResourceIdScope != null ? cfn_parse.FromCloudFormation.getString(properties.ResourceIdScope) : undefined,
        resourceTypesScope: properties.ResourceTypesScope != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ResourceTypesScope) : undefined,
        ruleIdentifier: cfn_parse.FromCloudFormation.getString(properties.RuleIdentifier),
        tagKeyScope: properties.TagKeyScope != null ? cfn_parse.FromCloudFormation.getString(properties.TagKeyScope) : undefined,
        tagValueScope: properties.TagValueScope != null ? cfn_parse.FromCloudFormation.getString(properties.TagValueScope) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `CfnOrganizationConformancePackProps`
 *
 * @param properties - the TypeScript properties of a `CfnOrganizationConformancePackProps`
 *
 * @returns the result of the validation.
 */
function CfnOrganizationConformancePackPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('conformancePackInputParameters', cdk.listValidator(CfnOrganizationConformancePack_ConformancePackInputParameterPropertyValidator))(properties.conformancePackInputParameters));
    errors.collect(cdk.propertyValidator('deliveryS3Bucket', cdk.requiredValidator)(properties.deliveryS3Bucket));
    errors.collect(cdk.propertyValidator('deliveryS3Bucket', cdk.validateString)(properties.deliveryS3Bucket));
    errors.collect(cdk.propertyValidator('deliveryS3KeyPrefix', cdk.validateString)(properties.deliveryS3KeyPrefix));
    errors.collect(cdk.propertyValidator('excludedAccounts', cdk.listValidator(cdk.validateString))(properties.excludedAccounts));
    errors.collect(cdk.propertyValidator('organizationConformancePackName', cdk.requiredValidator)(properties.organizationConformancePackName));
    errors.collect(cdk.propertyValidator('organizationConformancePackName', cdk.validateString)(properties.organizationConformancePackName));
    errors.collect(cdk.propertyValidator('templateBody', cdk.validateString)(properties.templateBody));
    errors.collect(cdk.propertyValidator('templateS3Uri', cdk.validateString)(properties.templateS3Uri));
    return errors.wrap('supplied properties not correct for "CfnOrganizationConformancePackProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Config::OrganizationConformancePack` resource
 *
 * @param properties - the TypeScript properties of a `CfnOrganizationConformancePackProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Config::OrganizationConformancePack` resource.
 */
// @ts-ignore TS6133
function cfnOrganizationConformancePackPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnOrganizationConformancePackPropsValidator(properties).assertSuccess();
    return {
        DeliveryS3Bucket: cdk.stringToCloudFormation(properties.deliveryS3Bucket),
        OrganizationConformancePackName: cdk.stringToCloudFormation(properties.organizationConformancePackName),
        ConformancePackInputParameters: cdk.listMapper(cfnOrganizationConformancePackConformancePackInputParameterPropertyToCloudFormation)(properties.conformancePackInputParameters),
        DeliveryS3KeyPrefix: cdk.stringToCloudFormation(properties.deliveryS3KeyPrefix),
        ExcludedAccounts: cdk.listMapper(cdk.stringToCloudFormation)(properties.excludedAccounts),
        TemplateBody: cdk.stringToCloudFormation(properties.templateBody),
        TemplateS3Uri: cdk.stringToCloudFormation(properties.templateS3Uri),
    };
}
// @ts-ignore TS6133
function CfnOrganizationConformancePackPropsFromCloudFormation(properties) {
    properties = properties || {};
    return {
        deliveryS3Bucket: cfn_parse.FromCloudFormation.getString(properties.DeliveryS3Bucket),
        organizationConformancePackName: cfn_parse.FromCloudFormation.getString(properties.OrganizationConformancePackName),
        conformancePackInputParameters: properties.ConformancePackInputParameters != null ? cfn_parse.FromCloudFormation.getArray(CfnOrganizationConformancePackConformancePackInputParameterPropertyFromCloudFormation)(properties.ConformancePackInputParameters) : undefined,
        deliveryS3KeyPrefix: properties.DeliveryS3KeyPrefix != null ? cfn_parse.FromCloudFormation.getString(properties.DeliveryS3KeyPrefix) : undefined,
        excludedAccounts: properties.ExcludedAccounts != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ExcludedAccounts) : undefined,
        templateBody: properties.TemplateBody != null ? cfn_parse.FromCloudFormation.getString(properties.TemplateBody) : undefined,
        templateS3Uri: properties.TemplateS3Uri != null ? cfn_parse.FromCloudFormation.getString(properties.TemplateS3Uri) : undefined,
    };
}
/**
 * A CloudFormation `AWS::Config::OrganizationConformancePack`
 *
 * @cloudformationResource AWS::Config::OrganizationConformancePack
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html
 */
class CfnOrganizationConformancePack extends cdk.CfnResource {
    /**
     * Create a new `AWS::Config::OrganizationConformancePack`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnOrganizationConformancePack.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'deliveryS3Bucket', this);
        cdk.requireProperty(props, 'organizationConformancePackName', this);
        this.deliveryS3Bucket = props.deliveryS3Bucket;
        this.organizationConformancePackName = props.organizationConformancePackName;
        this.conformancePackInputParameters = props.conformancePackInputParameters;
        this.deliveryS3KeyPrefix = props.deliveryS3KeyPrefix;
        this.excludedAccounts = props.excludedAccounts;
        this.templateBody = props.templateBody;
        this.templateS3Uri = props.templateS3Uri;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const cfnParser = new cfn_parse.CfnParser({
            finder: options.finder,
        });
        const resourceProperties = cfnParser.parseValue(resourceAttributes.Properties);
        const props = CfnOrganizationConformancePackPropsFromCloudFormation(resourceProperties);
        const ret = new CfnOrganizationConformancePack(scope, id, props);
        cfnParser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnOrganizationConformancePack.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            deliveryS3Bucket: this.deliveryS3Bucket,
            organizationConformancePackName: this.organizationConformancePackName,
            conformancePackInputParameters: this.conformancePackInputParameters,
            deliveryS3KeyPrefix: this.deliveryS3KeyPrefix,
            excludedAccounts: this.excludedAccounts,
            templateBody: this.templateBody,
            templateS3Uri: this.templateS3Uri,
        };
    }
    renderProperties(props) {
        return cfnOrganizationConformancePackPropsToCloudFormation(props);
    }
}
exports.CfnOrganizationConformancePack = CfnOrganizationConformancePack;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnOrganizationConformancePack.CFN_RESOURCE_TYPE_NAME = "AWS::Config::OrganizationConformancePack";
/**
 * Determine whether the given properties match those of a `ConformancePackInputParameterProperty`
 *
 * @param properties - the TypeScript properties of a `ConformancePackInputParameterProperty`
 *
 * @returns the result of the validation.
 */
function CfnOrganizationConformancePack_ConformancePackInputParameterPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('parameterName', cdk.requiredValidator)(properties.parameterName));
    errors.collect(cdk.propertyValidator('parameterName', cdk.validateString)(properties.parameterName));
    errors.collect(cdk.propertyValidator('parameterValue', cdk.requiredValidator)(properties.parameterValue));
    errors.collect(cdk.propertyValidator('parameterValue', cdk.validateString)(properties.parameterValue));
    return errors.wrap('supplied properties not correct for "ConformancePackInputParameterProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Config::OrganizationConformancePack.ConformancePackInputParameter` resource
 *
 * @param properties - the TypeScript properties of a `ConformancePackInputParameterProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Config::OrganizationConformancePack.ConformancePackInputParameter` resource.
 */
// @ts-ignore TS6133
function cfnOrganizationConformancePackConformancePackInputParameterPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnOrganizationConformancePack_ConformancePackInputParameterPropertyValidator(properties).assertSuccess();
    return {
        ParameterName: cdk.stringToCloudFormation(properties.parameterName),
        ParameterValue: cdk.stringToCloudFormation(properties.parameterValue),
    };
}
// @ts-ignore TS6133
function CfnOrganizationConformancePackConformancePackInputParameterPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        parameterName: cfn_parse.FromCloudFormation.getString(properties.ParameterName),
        parameterValue: cfn_parse.FromCloudFormation.getString(properties.ParameterValue),
    };
}
/**
 * Determine whether the given properties match those of a `CfnRemediationConfigurationProps`
 *
 * @param properties - the TypeScript properties of a `CfnRemediationConfigurationProps`
 *
 * @returns the result of the validation.
 */
function CfnRemediationConfigurationPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('automatic', cdk.validateBoolean)(properties.automatic));
    errors.collect(cdk.propertyValidator('configRuleName', cdk.requiredValidator)(properties.configRuleName));
    errors.collect(cdk.propertyValidator('configRuleName', cdk.validateString)(properties.configRuleName));
    errors.collect(cdk.propertyValidator('executionControls', CfnRemediationConfiguration_ExecutionControlsPropertyValidator)(properties.executionControls));
    errors.collect(cdk.propertyValidator('maximumAutomaticAttempts', cdk.validateNumber)(properties.maximumAutomaticAttempts));
    errors.collect(cdk.propertyValidator('parameters', cdk.validateObject)(properties.parameters));
    errors.collect(cdk.propertyValidator('resourceType', cdk.validateString)(properties.resourceType));
    errors.collect(cdk.propertyValidator('retryAttemptSeconds', cdk.validateNumber)(properties.retryAttemptSeconds));
    errors.collect(cdk.propertyValidator('targetId', cdk.requiredValidator)(properties.targetId));
    errors.collect(cdk.propertyValidator('targetId', cdk.validateString)(properties.targetId));
    errors.collect(cdk.propertyValidator('targetType', cdk.requiredValidator)(properties.targetType));
    errors.collect(cdk.propertyValidator('targetType', cdk.validateString)(properties.targetType));
    errors.collect(cdk.propertyValidator('targetVersion', cdk.validateString)(properties.targetVersion));
    return errors.wrap('supplied properties not correct for "CfnRemediationConfigurationProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Config::RemediationConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `CfnRemediationConfigurationProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Config::RemediationConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnRemediationConfigurationPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRemediationConfigurationPropsValidator(properties).assertSuccess();
    return {
        ConfigRuleName: cdk.stringToCloudFormation(properties.configRuleName),
        TargetId: cdk.stringToCloudFormation(properties.targetId),
        TargetType: cdk.stringToCloudFormation(properties.targetType),
        Automatic: cdk.booleanToCloudFormation(properties.automatic),
        ExecutionControls: cfnRemediationConfigurationExecutionControlsPropertyToCloudFormation(properties.executionControls),
        MaximumAutomaticAttempts: cdk.numberToCloudFormation(properties.maximumAutomaticAttempts),
        Parameters: cdk.objectToCloudFormation(properties.parameters),
        ResourceType: cdk.stringToCloudFormation(properties.resourceType),
        RetryAttemptSeconds: cdk.numberToCloudFormation(properties.retryAttemptSeconds),
        TargetVersion: cdk.stringToCloudFormation(properties.targetVersion),
    };
}
// @ts-ignore TS6133
function CfnRemediationConfigurationPropsFromCloudFormation(properties) {
    properties = properties || {};
    return {
        configRuleName: cfn_parse.FromCloudFormation.getString(properties.ConfigRuleName),
        targetId: cfn_parse.FromCloudFormation.getString(properties.TargetId),
        targetType: cfn_parse.FromCloudFormation.getString(properties.TargetType),
        automatic: properties.Automatic != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Automatic) : undefined,
        executionControls: properties.ExecutionControls != null ? CfnRemediationConfigurationExecutionControlsPropertyFromCloudFormation(properties.ExecutionControls) : undefined,
        maximumAutomaticAttempts: properties.MaximumAutomaticAttempts != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaximumAutomaticAttempts) : undefined,
        parameters: properties.Parameters != null ? cfn_parse.FromCloudFormation.getAny(properties.Parameters) : undefined,
        resourceType: properties.ResourceType != null ? cfn_parse.FromCloudFormation.getString(properties.ResourceType) : undefined,
        retryAttemptSeconds: properties.RetryAttemptSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.RetryAttemptSeconds) : undefined,
        targetVersion: properties.TargetVersion != null ? cfn_parse.FromCloudFormation.getString(properties.TargetVersion) : undefined,
    };
}
/**
 * A CloudFormation `AWS::Config::RemediationConfiguration`
 *
 * @cloudformationResource AWS::Config::RemediationConfiguration
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html
 */
class CfnRemediationConfiguration extends cdk.CfnResource {
    /**
     * Create a new `AWS::Config::RemediationConfiguration`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnRemediationConfiguration.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'configRuleName', this);
        cdk.requireProperty(props, 'targetId', this);
        cdk.requireProperty(props, 'targetType', this);
        this.configRuleName = props.configRuleName;
        this.targetId = props.targetId;
        this.targetType = props.targetType;
        this.automatic = props.automatic;
        this.executionControls = props.executionControls;
        this.maximumAutomaticAttempts = props.maximumAutomaticAttempts;
        this.parameters = props.parameters;
        this.resourceType = props.resourceType;
        this.retryAttemptSeconds = props.retryAttemptSeconds;
        this.targetVersion = props.targetVersion;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const cfnParser = new cfn_parse.CfnParser({
            finder: options.finder,
        });
        const resourceProperties = cfnParser.parseValue(resourceAttributes.Properties);
        const props = CfnRemediationConfigurationPropsFromCloudFormation(resourceProperties);
        const ret = new CfnRemediationConfiguration(scope, id, props);
        cfnParser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnRemediationConfiguration.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            configRuleName: this.configRuleName,
            targetId: this.targetId,
            targetType: this.targetType,
            automatic: this.automatic,
            executionControls: this.executionControls,
            maximumAutomaticAttempts: this.maximumAutomaticAttempts,
            parameters: this.parameters,
            resourceType: this.resourceType,
            retryAttemptSeconds: this.retryAttemptSeconds,
            targetVersion: this.targetVersion,
        };
    }
    renderProperties(props) {
        return cfnRemediationConfigurationPropsToCloudFormation(props);
    }
}
exports.CfnRemediationConfiguration = CfnRemediationConfiguration;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnRemediationConfiguration.CFN_RESOURCE_TYPE_NAME = "AWS::Config::RemediationConfiguration";
/**
 * Determine whether the given properties match those of a `ExecutionControlsProperty`
 *
 * @param properties - the TypeScript properties of a `ExecutionControlsProperty`
 *
 * @returns the result of the validation.
 */
function CfnRemediationConfiguration_ExecutionControlsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('ssmControls', CfnRemediationConfiguration_SsmControlsPropertyValidator)(properties.ssmControls));
    return errors.wrap('supplied properties not correct for "ExecutionControlsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Config::RemediationConfiguration.ExecutionControls` resource
 *
 * @param properties - the TypeScript properties of a `ExecutionControlsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Config::RemediationConfiguration.ExecutionControls` resource.
 */
// @ts-ignore TS6133
function cfnRemediationConfigurationExecutionControlsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRemediationConfiguration_ExecutionControlsPropertyValidator(properties).assertSuccess();
    return {
        SsmControls: cfnRemediationConfigurationSsmControlsPropertyToCloudFormation(properties.ssmControls),
    };
}
// @ts-ignore TS6133
function CfnRemediationConfigurationExecutionControlsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        ssmControls: properties.SsmControls != null ? CfnRemediationConfigurationSsmControlsPropertyFromCloudFormation(properties.SsmControls) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `RemediationParameterValueProperty`
 *
 * @param properties - the TypeScript properties of a `RemediationParameterValueProperty`
 *
 * @returns the result of the validation.
 */
function CfnRemediationConfiguration_RemediationParameterValuePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('resourceValue', CfnRemediationConfiguration_ResourceValuePropertyValidator)(properties.resourceValue));
    errors.collect(cdk.propertyValidator('staticValue', CfnRemediationConfiguration_StaticValuePropertyValidator)(properties.staticValue));
    return errors.wrap('supplied properties not correct for "RemediationParameterValueProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Config::RemediationConfiguration.RemediationParameterValue` resource
 *
 * @param properties - the TypeScript properties of a `RemediationParameterValueProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Config::RemediationConfiguration.RemediationParameterValue` resource.
 */
// @ts-ignore TS6133
function cfnRemediationConfigurationRemediationParameterValuePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRemediationConfiguration_RemediationParameterValuePropertyValidator(properties).assertSuccess();
    return {
        ResourceValue: cfnRemediationConfigurationResourceValuePropertyToCloudFormation(properties.resourceValue),
        StaticValue: cfnRemediationConfigurationStaticValuePropertyToCloudFormation(properties.staticValue),
    };
}
// @ts-ignore TS6133
function CfnRemediationConfigurationRemediationParameterValuePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        resourceValue: properties.ResourceValue != null ? CfnRemediationConfigurationResourceValuePropertyFromCloudFormation(properties.ResourceValue) : undefined,
        staticValue: properties.StaticValue != null ? CfnRemediationConfigurationStaticValuePropertyFromCloudFormation(properties.StaticValue) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `ResourceValueProperty`
 *
 * @param properties - the TypeScript properties of a `ResourceValueProperty`
 *
 * @returns the result of the validation.
 */
function CfnRemediationConfiguration_ResourceValuePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "ResourceValueProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Config::RemediationConfiguration.ResourceValue` resource
 *
 * @param properties - the TypeScript properties of a `ResourceValueProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Config::RemediationConfiguration.ResourceValue` resource.
 */
// @ts-ignore TS6133
function cfnRemediationConfigurationResourceValuePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRemediationConfiguration_ResourceValuePropertyValidator(properties).assertSuccess();
    return {
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnRemediationConfigurationResourceValuePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        value: properties.Value != null ? cfn_parse.FromCloudFormation.getString(properties.Value) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `SsmControlsProperty`
 *
 * @param properties - the TypeScript properties of a `SsmControlsProperty`
 *
 * @returns the result of the validation.
 */
function CfnRemediationConfiguration_SsmControlsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('concurrentExecutionRatePercentage', cdk.validateNumber)(properties.concurrentExecutionRatePercentage));
    errors.collect(cdk.propertyValidator('errorPercentage', cdk.validateNumber)(properties.errorPercentage));
    return errors.wrap('supplied properties not correct for "SsmControlsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Config::RemediationConfiguration.SsmControls` resource
 *
 * @param properties - the TypeScript properties of a `SsmControlsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Config::RemediationConfiguration.SsmControls` resource.
 */
// @ts-ignore TS6133
function cfnRemediationConfigurationSsmControlsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRemediationConfiguration_SsmControlsPropertyValidator(properties).assertSuccess();
    return {
        ConcurrentExecutionRatePercentage: cdk.numberToCloudFormation(properties.concurrentExecutionRatePercentage),
        ErrorPercentage: cdk.numberToCloudFormation(properties.errorPercentage),
    };
}
// @ts-ignore TS6133
function CfnRemediationConfigurationSsmControlsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        concurrentExecutionRatePercentage: properties.ConcurrentExecutionRatePercentage != null ? cfn_parse.FromCloudFormation.getNumber(properties.ConcurrentExecutionRatePercentage) : undefined,
        errorPercentage: properties.ErrorPercentage != null ? cfn_parse.FromCloudFormation.getNumber(properties.ErrorPercentage) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `StaticValueProperty`
 *
 * @param properties - the TypeScript properties of a `StaticValueProperty`
 *
 * @returns the result of the validation.
 */
function CfnRemediationConfiguration_StaticValuePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('values', cdk.listValidator(cdk.validateString))(properties.values));
    return errors.wrap('supplied properties not correct for "StaticValueProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Config::RemediationConfiguration.StaticValue` resource
 *
 * @param properties - the TypeScript properties of a `StaticValueProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Config::RemediationConfiguration.StaticValue` resource.
 */
// @ts-ignore TS6133
function cfnRemediationConfigurationStaticValuePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRemediationConfiguration_StaticValuePropertyValidator(properties).assertSuccess();
    return {
        Values: cdk.listMapper(cdk.stringToCloudFormation)(properties.values),
    };
}
// @ts-ignore TS6133
function CfnRemediationConfigurationStaticValuePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        values: properties.Values != null ? cfn_parse.FromCloudFormation.getStringArray(properties.Values) : undefined,
    };
}
//# sourceMappingURL=data:application/json;base64,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