"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Resolver = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const appsync_generated_1 = require("./appsync.generated");
/**
 * An AppSync resolver
 */
class Resolver extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const pipelineConfig = props.pipelineConfig && props.pipelineConfig.length ? { functions: props.pipelineConfig } : undefined;
        this.resolver = new appsync_generated_1.CfnResolver(this, 'Resource', {
            apiId: props.api.apiId,
            typeName: props.typeName,
            fieldName: props.fieldName,
            dataSourceName: props.dataSource ? props.dataSource.name : undefined,
            kind: pipelineConfig ? 'PIPELINE' : 'UNIT',
            pipelineConfig: pipelineConfig,
            requestMappingTemplate: props.requestMappingTemplate ? props.requestMappingTemplate.renderTemplate() : undefined,
            responseMappingTemplate: props.responseMappingTemplate ? props.responseMappingTemplate.renderTemplate() : undefined,
        });
        this.resolver.addDependsOn(props.api.schema);
        if (props.dataSource) {
            this.resolver.addDependsOn(props.dataSource.ds);
        }
        this.arn = this.resolver.attrResolverArn;
    }
}
exports.Resolver = Resolver;
//# sourceMappingURL=data:application/json;base64,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