import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::Amplify::App`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html
 */
export interface CfnAppProps {
    /**
     * `AWS::Amplify::App.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-name
     */
    readonly name: string;
    /**
     * `AWS::Amplify::App.AccessToken`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-accesstoken
     */
    readonly accessToken?: string;
    /**
     * `AWS::Amplify::App.AutoBranchCreationConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-autobranchcreationconfig
     */
    readonly autoBranchCreationConfig?: CfnApp.AutoBranchCreationConfigProperty | cdk.IResolvable;
    /**
     * `AWS::Amplify::App.BasicAuthConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-basicauthconfig
     */
    readonly basicAuthConfig?: CfnApp.BasicAuthConfigProperty | cdk.IResolvable;
    /**
     * `AWS::Amplify::App.BuildSpec`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-buildspec
     */
    readonly buildSpec?: string;
    /**
     * `AWS::Amplify::App.CustomRules`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-customrules
     */
    readonly customRules?: Array<CfnApp.CustomRuleProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Amplify::App.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-description
     */
    readonly description?: string;
    /**
     * `AWS::Amplify::App.EnableBranchAutoDeletion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-enablebranchautodeletion
     */
    readonly enableBranchAutoDeletion?: boolean | cdk.IResolvable;
    /**
     * `AWS::Amplify::App.EnvironmentVariables`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-environmentvariables
     */
    readonly environmentVariables?: Array<CfnApp.EnvironmentVariableProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Amplify::App.IAMServiceRole`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-iamservicerole
     */
    readonly iamServiceRole?: string;
    /**
     * `AWS::Amplify::App.OauthToken`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-oauthtoken
     */
    readonly oauthToken?: string;
    /**
     * `AWS::Amplify::App.Repository`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-repository
     */
    readonly repository?: string;
    /**
     * `AWS::Amplify::App.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::Amplify::App`
 *
 * @cloudformationResource AWS::Amplify::App
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html
 */
export declare class CfnApp extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Amplify::App";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnApp;
    /**
     * @cloudformationAttribute AppId
     */
    readonly attrAppId: string;
    /**
     * @cloudformationAttribute AppName
     */
    readonly attrAppName: string;
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @cloudformationAttribute DefaultDomain
     */
    readonly attrDefaultDomain: string;
    /**
     * `AWS::Amplify::App.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-name
     */
    name: string;
    /**
     * `AWS::Amplify::App.AccessToken`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-accesstoken
     */
    accessToken: string | undefined;
    /**
     * `AWS::Amplify::App.AutoBranchCreationConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-autobranchcreationconfig
     */
    autoBranchCreationConfig: CfnApp.AutoBranchCreationConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Amplify::App.BasicAuthConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-basicauthconfig
     */
    basicAuthConfig: CfnApp.BasicAuthConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Amplify::App.BuildSpec`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-buildspec
     */
    buildSpec: string | undefined;
    /**
     * `AWS::Amplify::App.CustomRules`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-customrules
     */
    customRules: Array<CfnApp.CustomRuleProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::Amplify::App.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-description
     */
    description: string | undefined;
    /**
     * `AWS::Amplify::App.EnableBranchAutoDeletion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-enablebranchautodeletion
     */
    enableBranchAutoDeletion: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Amplify::App.EnvironmentVariables`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-environmentvariables
     */
    environmentVariables: Array<CfnApp.EnvironmentVariableProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::Amplify::App.IAMServiceRole`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-iamservicerole
     */
    iamServiceRole: string | undefined;
    /**
     * `AWS::Amplify::App.OauthToken`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-oauthtoken
     */
    oauthToken: string | undefined;
    /**
     * `AWS::Amplify::App.Repository`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-repository
     */
    repository: string | undefined;
    /**
     * `AWS::Amplify::App.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Amplify::App`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAppProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnApp {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html
     */
    interface AutoBranchCreationConfigProperty {
        /**
         * `CfnApp.AutoBranchCreationConfigProperty.AutoBranchCreationPatterns`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-autobranchcreationpatterns
         */
        readonly autoBranchCreationPatterns?: string[];
        /**
         * `CfnApp.AutoBranchCreationConfigProperty.BasicAuthConfig`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-basicauthconfig
         */
        readonly basicAuthConfig?: CfnApp.BasicAuthConfigProperty | cdk.IResolvable;
        /**
         * `CfnApp.AutoBranchCreationConfigProperty.BuildSpec`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-buildspec
         */
        readonly buildSpec?: string;
        /**
         * `CfnApp.AutoBranchCreationConfigProperty.EnableAutoBranchCreation`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-enableautobranchcreation
         */
        readonly enableAutoBranchCreation?: boolean | cdk.IResolvable;
        /**
         * `CfnApp.AutoBranchCreationConfigProperty.EnableAutoBuild`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-enableautobuild
         */
        readonly enableAutoBuild?: boolean | cdk.IResolvable;
        /**
         * `CfnApp.AutoBranchCreationConfigProperty.EnablePullRequestPreview`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-enablepullrequestpreview
         */
        readonly enablePullRequestPreview?: boolean | cdk.IResolvable;
        /**
         * `CfnApp.AutoBranchCreationConfigProperty.EnvironmentVariables`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-environmentvariables
         */
        readonly environmentVariables?: Array<CfnApp.EnvironmentVariableProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnApp.AutoBranchCreationConfigProperty.PullRequestEnvironmentName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-pullrequestenvironmentname
         */
        readonly pullRequestEnvironmentName?: string;
        /**
         * `CfnApp.AutoBranchCreationConfigProperty.Stage`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-stage
         */
        readonly stage?: string;
    }
}
export declare namespace CfnApp {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-basicauthconfig.html
     */
    interface BasicAuthConfigProperty {
        /**
         * `CfnApp.BasicAuthConfigProperty.EnableBasicAuth`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-basicauthconfig.html#cfn-amplify-app-basicauthconfig-enablebasicauth
         */
        readonly enableBasicAuth?: boolean | cdk.IResolvable;
        /**
         * `CfnApp.BasicAuthConfigProperty.Password`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-basicauthconfig.html#cfn-amplify-app-basicauthconfig-password
         */
        readonly password?: string;
        /**
         * `CfnApp.BasicAuthConfigProperty.Username`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-basicauthconfig.html#cfn-amplify-app-basicauthconfig-username
         */
        readonly username?: string;
    }
}
export declare namespace CfnApp {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-customrule.html
     */
    interface CustomRuleProperty {
        /**
         * `CfnApp.CustomRuleProperty.Condition`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-customrule.html#cfn-amplify-app-customrule-condition
         */
        readonly condition?: string;
        /**
         * `CfnApp.CustomRuleProperty.Source`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-customrule.html#cfn-amplify-app-customrule-source
         */
        readonly source: string;
        /**
         * `CfnApp.CustomRuleProperty.Status`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-customrule.html#cfn-amplify-app-customrule-status
         */
        readonly status?: string;
        /**
         * `CfnApp.CustomRuleProperty.Target`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-customrule.html#cfn-amplify-app-customrule-target
         */
        readonly target: string;
    }
}
export declare namespace CfnApp {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-environmentvariable.html
     */
    interface EnvironmentVariableProperty {
        /**
         * `CfnApp.EnvironmentVariableProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-environmentvariable.html#cfn-amplify-app-environmentvariable-name
         */
        readonly name: string;
        /**
         * `CfnApp.EnvironmentVariableProperty.Value`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-environmentvariable.html#cfn-amplify-app-environmentvariable-value
         */
        readonly value: string;
    }
}
/**
 * Properties for defining a `AWS::Amplify::Branch`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html
 */
export interface CfnBranchProps {
    /**
     * `AWS::Amplify::Branch.AppId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-appid
     */
    readonly appId: string;
    /**
     * `AWS::Amplify::Branch.BranchName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-branchname
     */
    readonly branchName: string;
    /**
     * `AWS::Amplify::Branch.BasicAuthConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-basicauthconfig
     */
    readonly basicAuthConfig?: CfnBranch.BasicAuthConfigProperty | cdk.IResolvable;
    /**
     * `AWS::Amplify::Branch.BuildSpec`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-buildspec
     */
    readonly buildSpec?: string;
    /**
     * `AWS::Amplify::Branch.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-description
     */
    readonly description?: string;
    /**
     * `AWS::Amplify::Branch.EnableAutoBuild`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-enableautobuild
     */
    readonly enableAutoBuild?: boolean | cdk.IResolvable;
    /**
     * `AWS::Amplify::Branch.EnablePullRequestPreview`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-enablepullrequestpreview
     */
    readonly enablePullRequestPreview?: boolean | cdk.IResolvable;
    /**
     * `AWS::Amplify::Branch.EnvironmentVariables`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-environmentvariables
     */
    readonly environmentVariables?: Array<CfnBranch.EnvironmentVariableProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Amplify::Branch.PullRequestEnvironmentName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-pullrequestenvironmentname
     */
    readonly pullRequestEnvironmentName?: string;
    /**
     * `AWS::Amplify::Branch.Stage`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-stage
     */
    readonly stage?: string;
    /**
     * `AWS::Amplify::Branch.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::Amplify::Branch`
 *
 * @cloudformationResource AWS::Amplify::Branch
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html
 */
export declare class CfnBranch extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Amplify::Branch";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnBranch;
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @cloudformationAttribute BranchName
     */
    readonly attrBranchName: string;
    /**
     * `AWS::Amplify::Branch.AppId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-appid
     */
    appId: string;
    /**
     * `AWS::Amplify::Branch.BranchName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-branchname
     */
    branchName: string;
    /**
     * `AWS::Amplify::Branch.BasicAuthConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-basicauthconfig
     */
    basicAuthConfig: CfnBranch.BasicAuthConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Amplify::Branch.BuildSpec`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-buildspec
     */
    buildSpec: string | undefined;
    /**
     * `AWS::Amplify::Branch.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-description
     */
    description: string | undefined;
    /**
     * `AWS::Amplify::Branch.EnableAutoBuild`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-enableautobuild
     */
    enableAutoBuild: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Amplify::Branch.EnablePullRequestPreview`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-enablepullrequestpreview
     */
    enablePullRequestPreview: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Amplify::Branch.EnvironmentVariables`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-environmentvariables
     */
    environmentVariables: Array<CfnBranch.EnvironmentVariableProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::Amplify::Branch.PullRequestEnvironmentName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-pullrequestenvironmentname
     */
    pullRequestEnvironmentName: string | undefined;
    /**
     * `AWS::Amplify::Branch.Stage`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-stage
     */
    stage: string | undefined;
    /**
     * `AWS::Amplify::Branch.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Amplify::Branch`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnBranchProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnBranch {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-branch-basicauthconfig.html
     */
    interface BasicAuthConfigProperty {
        /**
         * `CfnBranch.BasicAuthConfigProperty.EnableBasicAuth`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-branch-basicauthconfig.html#cfn-amplify-branch-basicauthconfig-enablebasicauth
         */
        readonly enableBasicAuth?: boolean | cdk.IResolvable;
        /**
         * `CfnBranch.BasicAuthConfigProperty.Password`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-branch-basicauthconfig.html#cfn-amplify-branch-basicauthconfig-password
         */
        readonly password: string;
        /**
         * `CfnBranch.BasicAuthConfigProperty.Username`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-branch-basicauthconfig.html#cfn-amplify-branch-basicauthconfig-username
         */
        readonly username: string;
    }
}
export declare namespace CfnBranch {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-branch-environmentvariable.html
     */
    interface EnvironmentVariableProperty {
        /**
         * `CfnBranch.EnvironmentVariableProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-branch-environmentvariable.html#cfn-amplify-branch-environmentvariable-name
         */
        readonly name: string;
        /**
         * `CfnBranch.EnvironmentVariableProperty.Value`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-branch-environmentvariable.html#cfn-amplify-branch-environmentvariable-value
         */
        readonly value: string;
    }
}
/**
 * Properties for defining a `AWS::Amplify::Domain`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html
 */
export interface CfnDomainProps {
    /**
     * `AWS::Amplify::Domain.AppId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-appid
     */
    readonly appId: string;
    /**
     * `AWS::Amplify::Domain.DomainName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-domainname
     */
    readonly domainName: string;
    /**
     * `AWS::Amplify::Domain.SubDomainSettings`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-subdomainsettings
     */
    readonly subDomainSettings: Array<CfnDomain.SubDomainSettingProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Amplify::Domain.AutoSubDomainCreationPatterns`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-autosubdomaincreationpatterns
     */
    readonly autoSubDomainCreationPatterns?: string[];
    /**
     * `AWS::Amplify::Domain.AutoSubDomainIAMRole`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-autosubdomainiamrole
     */
    readonly autoSubDomainIamRole?: string;
    /**
     * `AWS::Amplify::Domain.EnableAutoSubDomain`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-enableautosubdomain
     */
    readonly enableAutoSubDomain?: boolean | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Amplify::Domain`
 *
 * @cloudformationResource AWS::Amplify::Domain
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html
 */
export declare class CfnDomain extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Amplify::Domain";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnDomain;
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @cloudformationAttribute AutoSubDomainCreationPatterns
     */
    readonly attrAutoSubDomainCreationPatterns: string[];
    /**
     * @cloudformationAttribute AutoSubDomainIAMRole
     */
    readonly attrAutoSubDomainIamRole: string;
    /**
     * @cloudformationAttribute CertificateRecord
     */
    readonly attrCertificateRecord: string;
    /**
     * @cloudformationAttribute DomainName
     */
    readonly attrDomainName: string;
    /**
     * @cloudformationAttribute DomainStatus
     */
    readonly attrDomainStatus: string;
    /**
     * @cloudformationAttribute EnableAutoSubDomain
     */
    readonly attrEnableAutoSubDomain: cdk.IResolvable;
    /**
     * @cloudformationAttribute StatusReason
     */
    readonly attrStatusReason: string;
    /**
     * `AWS::Amplify::Domain.AppId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-appid
     */
    appId: string;
    /**
     * `AWS::Amplify::Domain.DomainName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-domainname
     */
    domainName: string;
    /**
     * `AWS::Amplify::Domain.SubDomainSettings`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-subdomainsettings
     */
    subDomainSettings: Array<CfnDomain.SubDomainSettingProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Amplify::Domain.AutoSubDomainCreationPatterns`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-autosubdomaincreationpatterns
     */
    autoSubDomainCreationPatterns: string[] | undefined;
    /**
     * `AWS::Amplify::Domain.AutoSubDomainIAMRole`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-autosubdomainiamrole
     */
    autoSubDomainIamRole: string | undefined;
    /**
     * `AWS::Amplify::Domain.EnableAutoSubDomain`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-enableautosubdomain
     */
    enableAutoSubDomain: boolean | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Amplify::Domain`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDomainProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnDomain {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-domain-subdomainsetting.html
     */
    interface SubDomainSettingProperty {
        /**
         * `CfnDomain.SubDomainSettingProperty.BranchName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-domain-subdomainsetting.html#cfn-amplify-domain-subdomainsetting-branchname
         */
        readonly branchName: string;
        /**
         * `CfnDomain.SubDomainSettingProperty.Prefix`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-domain-subdomainsetting.html#cfn-amplify-domain-subdomainsetting-prefix
         */
        readonly prefix: string;
    }
}
