
# DO NOT EDIT THIS FILE -- AUTOGENERATED BY PANTS
# Target: src/ai/backend/accelerator/cuda_open:dist

from setuptools import setup

setup(**{
    'author': 'Lablup Inc. and contributors',
    'classifiers': [
        'Intended Audience :: Developers',
        'Operating System :: MacOS :: MacOS X',
        'Operating System :: POSIX :: Linux',
        'Programming Language :: Python',
        'Programming Language :: Python :: 3',
        'Environment :: No Input/Output (Daemon)',
        'Topic :: Scientific/Engineering',
        'Topic :: Software Development',
        'Development Status :: 4 - Beta',
        'License :: OSI Approved :: GNU Lesser General Public License v3 or later (LGPLv3+)',
    ],
    'description': 'Backend.AI Accelerator Plugin for CUDA',
    'entry_points': {
        'backendai_accelerator_v20': [
            'cuda = ai.backend.accelerator.cuda_open.plugin:CUDAPlugin',
        ],
    },
    'install_requires': (
        'aiodocker~=0.21.0',
        'aiohttp~=3.8.1',
        'attrs>=20.3',
        'backend.ai-agent==22.06.0b3',
        'backend.ai-cli==22.06.0b3',
        'backend.ai-common==22.06.0b3',
        'backend.ai-kernel-binary==22.06.0b3',
        'backend.ai-kernel-helper==22.06.0b3',
        'backend.ai-kernel==22.06.0b3',
        'backend.ai-plugin==22.06.0b3',
    ),
    'license': 'LGPLv3',
    'long_description': """Backend.AI Accelerator Plugin for CUDA
======================================

Just install this along with Backend.AI agents, using the same virtual environment.
This will allow the agents to detect CUDA devices on their hosts and make them
available to Backend.AI kernel sessions.

```console
$ pip install backend.ai-accelerator-cuda
```

This open-source edition of CUDA plugins support allocation of one or more CUDA
devices to a container, slot-by-slot.

Compatibility Matrix
--------------------

|       Backend.AI Agent       |    CUDA Plugin   |
|:----------------------------:|:----------------:|
|  20.09.x                     |  2.0.0           |
|  20.03.9 ~                   |  2.0.0           |
|  20.03.0 ~ 20.03.8           |  0.14.x          |
|  19.09.17 ~                  |  0.13.x          |
|  19.06.x, 19.09.0 ~ 19.09.16 |  0.11.x, 0.12.x  |
|  19.03.x                     |  0.10.x          |

In the versions released after the above matrix, the agent will set the required
version range of this plugin as an extra requirements set "cuda".
""",
    'long_description_content_type': 'text/markdown',
    'name': 'backend.ai-accelerator-cuda-open',
    'namespace_packages': (
    ),
    'package_data': {
        'ai.backend.accelerator.cuda_open': (
            'VERSION',
            'py.typed',
        ),
    },
    'packages': (
        'ai.backend.accelerator.cuda_open',
    ),
    'project_urls': {
        'Documentation': 'https://docs.backend.ai/',
        'Source': 'https://github.com/lablup/backend.ai',
    },
    'python_requires': '==3.10.5',
    'url': 'https://github.com/lablup/backend.ai',
    'version': '22.06.0b3',
    'zip_safe': False,
})
