"""
Django settings for easypush project.

Generated by 'django-admin startproject' using Django 4.1.2.

For more information on this file, see
https://docs.djangoproject.com/en/4.1/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/4.1/ref/settings/
"""
import os
from pathlib import Path
from dotenv import load_dotenv, find_dotenv

load_dotenv(find_dotenv())

# Build paths inside the project like this: BASE_DIR / 'subdir'.
BASE_DIR = Path(__file__).resolve().parent.parent


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/4.1/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = 'django-insecure-v#+23e^$ou3)^nk(vbntzs-wx9_dn0$6mx%$9-xhdj)76l-b&m'

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True

ALLOWED_HOSTS = []


# Application definition

INSTALLED_APPS = [
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',

    'django_extensions',

    'easypush',
]

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
]

ROOT_URLCONF = 'easypush_demo.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

WSGI_APPLICATION = 'easypush_demo.wsgi.application'


# Database
# https://docs.djangoproject.com/en/4.1/ref/settings/#databases

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.mysql',
        'NAME': os.getenv("MYSQL:DB_NAME"),
        'HOST': os.getenv("MYSQL:HOST"),
        'PORT': os.getenv("MYSQL:PORT"),
        'USER': os.getenv("MYSQL:USER"),
        'PASSWORD': os.getenv("MYSQL:PASSWORD"),
    }
}


# Password validation
# https://docs.djangoproject.com/en/4.1/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]


# Internationalization
# https://docs.djangoproject.com/en/4.1/topics/i18n/

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'Asia/Shanghai'

USE_I18N = True

USE_TZ = False


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/4.1/howto/static-files/

STATIC_URL = 'static/'

MEDIA_ROOT = "/data/media/"
MEDIA_URL = "/media/"

# Default primary key field type
# https://docs.djangoproject.com/en/4.1/ref/settings/#default-auto-field

DEFAULT_AUTO_FIELD = 'django.db.models.BigAutoField'

CACHES = {
    "default": {
        "BACKEND": "django_redis.cache.RedisCache",
        "LOCATION": "redis://127.0.0.1:6379/0",
        "KEY_PREFIX": "circle",
        "OPTIONS": {
            "CLIENT_CLASS": "django_redis.client.DefaultClient",
            "CONNECTION_POOL_KWARGS": {"max_connections": 100, "decode_responses": True},
            "PASSWORD": None,
        }
    },
}

APP_NAME = "easypush"

# EASYPUSH
EASYPUSH = {
    "default": {
        "BACKEND": os.getenv("DING_TALK:BACKEND"),
        "CORP_ID": os.getenv("DING_TALK:CORP_ID"),
        "AGENT_ID": os.getenv("DING_TALK:AGENT_ID"),
        "APP_KEY": os.getenv("DING_TALK:APP_KEY"),
        "APP_SECRET": os.getenv("DING_TALK:APP_SECRET"),
    },

    "qy_weixin": {
        "BACKEND": os.getenv("QY_WEIXIN:BACKEND"),
        "CORP_ID": os.getenv("QY_WEIXIN:CORP_ID"),
        "AGENT_ID": os.getenv("QY_WEIXIN:AGENT_ID"),
        "APP_KEY": os.getenv("QY_WEIXIN:APP_KEY"),
        "APP_SECRET": os.getenv("QY_WEIXIN:APP_SECRET"),
    },

    "feishu": {
        "BACKEND": os.getenv("FEISHU:BACKEND"),
        "CORP_ID": os.getenv("FEISHU:CORP_ID"),
        "AGENT_ID": os.getenv("FEISHU:AGENT_ID"),
        "APP_KEY": os.getenv("FEISHU:APP_KEY"),
        "APP_SECRET": os.getenv("FEISHU:APP_SECRET"),
    },
}

EASYPUSH_CELERY_APP = "easypush_demo.celery_app:celery_app"
