# Auto generated from crdch_model.yaml by pythongen.py version: 0.9.0
# Generation date: 2021-09-23 12:01
# Schema: CRDC-H
#
# id: https://example.org/crdch
# description:
# license: https://creativecommons.org/publicdomain/zero/1.0/

import dataclasses
import sys
import re
from jsonasobj2 import JsonObj, as_dict
from typing import Optional, List, Union, Dict, ClassVar, Any
from dataclasses import dataclass
from linkml_runtime.linkml_model.meta import EnumDefinition, PermissibleValue, PvFormulaOptions

from linkml_runtime.utils.slot import Slot
from linkml_runtime.utils.metamodelcore import empty_list, empty_dict, bnode
from linkml_runtime.utils.yamlutils import YAMLRoot, extended_str, extended_float, extended_int
from linkml_runtime.utils.dataclass_extensions_376 import dataclasses_init_fn_with_kwargs
from linkml_runtime.utils.formatutils import camelcase, underscore, sfx
from linkml_runtime.utils.enumerations import EnumDefinitionImpl
from rdflib import Namespace, URIRef
from linkml_runtime.utils.curienamespace import CurieNamespace
from linkml_runtime.linkml_model.types import Boolean, Datetime, Decimal, Integer, String, Uriorcurie
from linkml_runtime.utils.metamodelcore import Bool, Decimal, URIorCURIE, XSDDateTime

metamodel_version = "1.7.0"

# Overwrite dataclasses _init_fn to add **kwargs in __init__
dataclasses._init_fn = dataclasses_init_fn_with_kwargs

# Namespaces
GDC = CurieNamespace('GDC', 'http://example.org/gdc/')
HTAN = CurieNamespace('HTAN', 'http://example.org/htan/')
ICDC = CurieNamespace('ICDC', 'http://example.org/icdc/')
NCIT = CurieNamespace('NCIT', 'http://purl.obolibrary.org/obo/NCIT_')
PDC = CurieNamespace('PDC', 'http://example.org/pdc/')
CRDCH = CurieNamespace('crdch', 'https://example.org/crdch/')
LINKML = CurieNamespace('linkml', 'https://w3id.org/linkml/')
XSD = CurieNamespace('xsd', 'http://www.w3.org/2001/XMLSchema#')
DEFAULT_ = CRDCH


# Types
class CrdchString(String):
    """ A sequence of Unicode characters.  There are no limits on the number of characters in the string. """
    type_class_uri = XSD.string
    type_class_curie = "xsd:string"
    type_name = "crdch_string"
    type_model_uri = CRDCH.CrdchString


class CrdchInteger(Integer):
    """ An integer number.  This data type is based on the decimal type, but the fractional component is not allowed.  There are no restrictions on the size of the integer. """
    type_class_uri = XSD.integer
    type_class_curie = "xsd:integer"
    type_name = "crdch_integer"
    type_model_uri = CRDCH.CrdchInteger


class CrdchDecimal(Decimal):
    """ A rational number that has a decimal representation.  This data type does not restrict the size or precision of the number. """
    type_class_uri = XSD.decimal
    type_class_curie = "xsd:decimal"
    type_name = "crdch_decimal"
    type_model_uri = CRDCH.CrdchDecimal


class CrdchBoolean(Boolean):
    """ Value representing either “true” or “false”.  Permissible values (case-sensitive) = “true”, “false”, “1”, “0”. """
    type_class_uri = XSD.boolean
    type_class_curie = "xsd:boolean"
    type_name = "crdch_boolean"
    type_model_uri = CRDCH.CrdchBoolean


class CrdchDateTime(Datetime):
    """ A date and time string specified using a specialized concatenation of the date and time data types, in the general format YYYY-MM-DDThh:mm:ss+zz:zz. """
    type_class_uri = XSD.dateTime
    type_class_curie = "xsd:dateTime"
    type_name = "crdch_dateTime"
    type_model_uri = CRDCH.CrdchDateTime


class CrdchCurie(Uriorcurie):
    """ A compact URI (CURIE), which is a bipartite identifier of the form prefix:reference, in which the prefix is a convenient abbreviation of a URI.  It is expressed in the format “prefix:reference”. When a mapping of prefix to base URI is provided (external to this data type), a CURIE may be mapped to a URI. """
    type_class_uri = XSD.anyURI
    type_class_curie = "xsd:anyURI"
    type_name = "crdch_curie"
    type_model_uri = CRDCH.CrdchCurie


class CrdchCode(String):
    type_class_uri = XSD.string
    type_class_curie = "xsd:string"
    type_name = "crdch_code"
    type_model_uri = CRDCH.CrdchCode


# Class references



class Entity(YAMLRoot):
    """
    Any resource that has its own identifier
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.Entity
    class_class_curie: ClassVar[str] = "crdch:Entity"
    class_name: ClassVar[str] = "Entity"
    class_model_uri: ClassVar[URIRef] = CRDCH.Entity


@dataclass
class AlcoholExposureObservation(Entity):
    """
    A structured object that describes a single data item about an individual's exposure to alcohol, as generated
    through a point-in-time observation, measurement, or interpretation.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.AlcoholExposureObservation
    class_class_curie: ClassVar[str] = "crdch:AlcoholExposureObservation"
    class_name: ClassVar[str] = "AlcoholExposureObservation"
    class_model_uri: ClassVar[URIRef] = CRDCH.AlcoholExposureObservation

    observation_type: Union[dict, "CodeableConcept"] = None
    id: Optional[Union[str, CrdchString]] = None
    category: Optional[Union[dict, "CodeableConcept"]] = None
    method_type: Optional[Union[dict, "CodeableConcept"]] = None
    focus: Optional[Union[dict, "Entity"]] = None
    subject: Optional[Union[dict, "Subject"]] = None
    performed_by: Optional[Union[dict, "Organization"]] = None
    value_integer: Optional[Union[int, CrdchInteger]] = None
    value_codeable_concept: Optional[Union[dict, "CodeableConcept"]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.observation_type):
            self.MissingRequiredField("observation_type")
        if not isinstance(self.observation_type, CodeableConcept):
            self.observation_type = CodeableConcept(**as_dict(self.observation_type))

        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        if self.category is not None and not isinstance(self.category, CodeableConcept):
            self.category = CodeableConcept(**as_dict(self.category))

        if self.method_type is not None and not isinstance(self.method_type, CodeableConcept):
            self.method_type = CodeableConcept(**as_dict(self.method_type))

        if self.focus is not None and not isinstance(self.focus, Entity):
            self.focus = Entity()

        if self.subject is not None and not isinstance(self.subject, Subject):
            self.subject = Subject(**as_dict(self.subject))

        if self.performed_by is not None and not isinstance(self.performed_by, Organization):
            self.performed_by = Organization(**as_dict(self.performed_by))

        if self.value_integer is not None and not isinstance(self.value_integer, CrdchInteger):
            self.value_integer = CrdchInteger(self.value_integer)

        if self.value_codeable_concept is not None and not isinstance(self.value_codeable_concept, CodeableConcept):
            self.value_codeable_concept = CodeableConcept(**as_dict(self.value_codeable_concept))

        super().__post_init__(**kwargs)


@dataclass
class BodySite(Entity):
    """
    A site in the body of an organism, typically described in terms of an anatomical location and optional qualifiers
    (e.g. left/right, upper/lower). But body sites as defined here may include 'non-anatomic' sites, such as the
    location of an implanted medical device.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.BodySite
    class_class_curie: ClassVar[str] = "crdch:BodySite"
    class_name: ClassVar[str] = "BodySite"
    class_model_uri: ClassVar[URIRef] = CRDCH.BodySite

    site: Union[dict, "CodeableConcept"] = None
    qualifier: Optional[Union[Union[dict, "CodeableConcept"], List[Union[dict, "CodeableConcept"]]]] = empty_list()

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.site):
            self.MissingRequiredField("site")
        if not isinstance(self.site, CodeableConcept):
            self.site = CodeableConcept(**as_dict(self.site))

        if not isinstance(self.qualifier, list):
            self.qualifier = [self.qualifier] if self.qualifier is not None else []
        self.qualifier = [v if isinstance(v, CodeableConcept) else CodeableConcept(**as_dict(v)) for v in self.qualifier]

        super().__post_init__(**kwargs)


@dataclass
class BiologicProduct(Entity):
    """
    A living organism, or a metabolically active biological system such as a cell culture, tissue culture, or organoid
    that is maintained or propagated in vitro.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.BiologicProduct
    class_class_curie: ClassVar[str] = "crdch:BiologicProduct"
    class_name: ClassVar[str] = "BiologicProduct"
    class_model_uri: ClassVar[URIRef] = CRDCH.BiologicProduct

    id: Optional[Union[str, CrdchString]] = None
    identifier: Optional[Union[Union[dict, "Identifier"], List[Union[dict, "Identifier"]]]] = empty_list()
    description: Optional[Union[str, CrdchString]] = None
    product_type: Optional[Union[dict, "CodeableConcept"]] = None
    passage_number: Optional[Union[Union[int, CrdchInteger], List[Union[int, CrdchInteger]]]] = empty_list()
    growth_rate: Optional[Union[Union[str, CrdchString], List[Union[str, CrdchString]]]] = empty_list()

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        self._normalize_inlined_as_list(slot_name="identifier", slot_type=Identifier, key_name="value", keyed=False)

        if self.description is not None and not isinstance(self.description, CrdchString):
            self.description = CrdchString(self.description)

        if self.product_type is not None and not isinstance(self.product_type, CodeableConcept):
            self.product_type = CodeableConcept(**as_dict(self.product_type))

        if not isinstance(self.passage_number, list):
            self.passage_number = [self.passage_number] if self.passage_number is not None else []
        self.passage_number = [v if isinstance(v, CrdchInteger) else CrdchInteger(v) for v in self.passage_number]

        if not isinstance(self.growth_rate, list):
            self.growth_rate = [self.growth_rate] if self.growth_rate is not None else []
        self.growth_rate = [v if isinstance(v, CrdchString) else CrdchString(v) for v in self.growth_rate]

        super().__post_init__(**kwargs)


@dataclass
class CancerGradeObservation(Entity):
    """
    A data structure with key (observation_type) and value (value_codeable_concept) attributes that represents a
    single cancer grade observation
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.CancerGradeObservation
    class_class_curie: ClassVar[str] = "crdch:CancerGradeObservation"
    class_name: ClassVar[str] = "CancerGradeObservation"
    class_model_uri: ClassVar[URIRef] = CRDCH.CancerGradeObservation

    observation_type: Union[dict, "CodeableConcept"] = None
    value_codeable_concept: Union[dict, "CodeableConcept"] = None
    id: Optional[Union[str, CrdchString]] = None
    category: Optional[Union[dict, "CodeableConcept"]] = None
    method_type: Optional[Union[dict, "CodeableConcept"]] = None
    focus: Optional[Union[dict, "Entity"]] = None
    subject: Optional[Union[dict, "Subject"]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.observation_type):
            self.MissingRequiredField("observation_type")
        if not isinstance(self.observation_type, CodeableConcept):
            self.observation_type = CodeableConcept(**as_dict(self.observation_type))

        if self._is_empty(self.value_codeable_concept):
            self.MissingRequiredField("value_codeable_concept")
        if not isinstance(self.value_codeable_concept, CodeableConcept):
            self.value_codeable_concept = CodeableConcept(**as_dict(self.value_codeable_concept))

        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        if self.category is not None and not isinstance(self.category, CodeableConcept):
            self.category = CodeableConcept(**as_dict(self.category))

        if self.method_type is not None and not isinstance(self.method_type, CodeableConcept):
            self.method_type = CodeableConcept(**as_dict(self.method_type))

        if self.focus is not None and not isinstance(self.focus, Entity):
            self.focus = Entity()

        if self.subject is not None and not isinstance(self.subject, Subject):
            self.subject = Subject(**as_dict(self.subject))

        super().__post_init__(**kwargs)


@dataclass
class CancerGradeObservationSet(Entity):
    """
    A structured object to hold related data items about the grade of cancer (e.g. overall, primary gleason, secondary
    gleason, etc.).
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.CancerGradeObservationSet
    class_class_curie: ClassVar[str] = "crdch:CancerGradeObservationSet"
    class_name: ClassVar[str] = "CancerGradeObservationSet"
    class_model_uri: ClassVar[URIRef] = CRDCH.CancerGradeObservationSet

    id: Optional[Union[str, CrdchString]] = None
    category: Optional[Union[dict, "CodeableConcept"]] = None
    focus: Optional[Union[Union[dict, "Entity"], List[Union[dict, "Entity"]]]] = empty_list()
    subject: Optional[Union[dict, "Subject"]] = None
    method_type: Optional[Union[Union[dict, "CodeableConcept"], List[Union[dict, "CodeableConcept"]]]] = empty_list()
    performed_by: Optional[Union[dict, "Organization"]] = None
    observations: Optional[Union[Union[dict, CancerGradeObservation], List[Union[dict, CancerGradeObservation]]]] = empty_list()

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        if self.category is not None and not isinstance(self.category, CodeableConcept):
            self.category = CodeableConcept(**as_dict(self.category))

        if not isinstance(self.focus, list):
            self.focus = [self.focus] if self.focus is not None else []
        self.focus = [v if isinstance(v, Entity) else Entity(**as_dict(v)) for v in self.focus]

        if self.subject is not None and not isinstance(self.subject, Subject):
            self.subject = Subject(**as_dict(self.subject))

        if not isinstance(self.method_type, list):
            self.method_type = [self.method_type] if self.method_type is not None else []
        self.method_type = [v if isinstance(v, CodeableConcept) else CodeableConcept(**as_dict(v)) for v in self.method_type]

        if self.performed_by is not None and not isinstance(self.performed_by, Organization):
            self.performed_by = Organization(**as_dict(self.performed_by))

        self._normalize_inlined_as_list(slot_name="observations", slot_type=CancerGradeObservation, key_name="observation_type", keyed=False)

        super().__post_init__(**kwargs)


@dataclass
class CancerStageObservation(Entity):
    """
    A data structure with key (observation_type) and value (value_codeable_concept) attributes that represents a
    single cancer staging observation, such as the Clinical Metastasis (M) component of a clinical TNM staging.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.CancerStageObservation
    class_class_curie: ClassVar[str] = "crdch:CancerStageObservation"
    class_name: ClassVar[str] = "CancerStageObservation"
    class_model_uri: ClassVar[URIRef] = CRDCH.CancerStageObservation

    observation_type: Union[dict, "CodeableConcept"] = None
    value_codeable_concept: Union[dict, "CodeableConcept"] = None
    id: Optional[Union[str, CrdchString]] = None
    category: Optional[Union[dict, "CodeableConcept"]] = None
    method_type: Optional[Union[dict, "CodeableConcept"]] = None
    focus: Optional[Union[dict, "Entity"]] = None
    subject: Optional[Union[dict, "Subject"]] = None
    performed_by: Optional[Union[dict, "Organization"]] = None
    value_entity: Optional[Union[dict, "Entity"]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.observation_type):
            self.MissingRequiredField("observation_type")
        if not isinstance(self.observation_type, CodeableConcept):
            self.observation_type = CodeableConcept(**as_dict(self.observation_type))

        if self._is_empty(self.value_codeable_concept):
            self.MissingRequiredField("value_codeable_concept")
        if not isinstance(self.value_codeable_concept, CodeableConcept):
            self.value_codeable_concept = CodeableConcept(**as_dict(self.value_codeable_concept))

        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        if self.category is not None and not isinstance(self.category, CodeableConcept):
            self.category = CodeableConcept(**as_dict(self.category))

        if self.method_type is not None and not isinstance(self.method_type, CodeableConcept):
            self.method_type = CodeableConcept(**as_dict(self.method_type))

        if self.focus is not None and not isinstance(self.focus, Entity):
            self.focus = Entity()

        if self.subject is not None and not isinstance(self.subject, Subject):
            self.subject = Subject(**as_dict(self.subject))

        if self.performed_by is not None and not isinstance(self.performed_by, Organization):
            self.performed_by = Organization(**as_dict(self.performed_by))

        if self.value_entity is not None and not isinstance(self.value_entity, Entity):
            self.value_entity = Entity()

        super().__post_init__(**kwargs)


@dataclass
class CancerStageObservationSet(Entity):
    """
    A structured object to hold related data items about the staging of cancer (e.g. overall, T, N, and M components
    of a Cancer Staging observation).
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.CancerStageObservationSet
    class_class_curie: ClassVar[str] = "crdch:CancerStageObservationSet"
    class_name: ClassVar[str] = "CancerStageObservationSet"
    class_model_uri: ClassVar[URIRef] = CRDCH.CancerStageObservationSet

    id: Optional[Union[str, CrdchString]] = None
    category: Optional[Union[dict, "CodeableConcept"]] = None
    focus: Optional[Union[Union[dict, "Entity"], List[Union[dict, "Entity"]]]] = empty_list()
    subject: Optional[Union[dict, "Subject"]] = None
    method_type: Optional[Union[Union[dict, "CodeableConcept"], List[Union[dict, "CodeableConcept"]]]] = empty_list()
    performed_by: Optional[Union[dict, "Organization"]] = None
    observations: Optional[Union[Union[dict, CancerStageObservation], List[Union[dict, CancerStageObservation]]]] = empty_list()

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        if self.category is not None and not isinstance(self.category, CodeableConcept):
            self.category = CodeableConcept(**as_dict(self.category))

        if not isinstance(self.focus, list):
            self.focus = [self.focus] if self.focus is not None else []
        self.focus = [v if isinstance(v, Entity) else Entity(**as_dict(v)) for v in self.focus]

        if self.subject is not None and not isinstance(self.subject, Subject):
            self.subject = Subject(**as_dict(self.subject))

        if not isinstance(self.method_type, list):
            self.method_type = [self.method_type] if self.method_type is not None else []
        self.method_type = [v if isinstance(v, CodeableConcept) else CodeableConcept(**as_dict(v)) for v in self.method_type]

        if self.performed_by is not None and not isinstance(self.performed_by, Organization):
            self.performed_by = Organization(**as_dict(self.performed_by))

        self._normalize_inlined_as_list(slot_name="observations", slot_type=CancerStageObservation, key_name="observation_type", keyed=False)

        super().__post_init__(**kwargs)


@dataclass
class CodeableConcept(Entity):
    """
    A representation of a concept that may be defined by or mapped to one or more codes in code systems
    (terminologies, ontologies, dictionaries, code sets, etc) - but may also be defined by the provision of text.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.CodeableConcept
    class_class_curie: ClassVar[str] = "crdch:CodeableConcept"
    class_name: ClassVar[str] = "CodeableConcept"
    class_model_uri: ClassVar[URIRef] = CRDCH.CodeableConcept

    coding: Optional[Union[Union[dict, "Coding"], List[Union[dict, "Coding"]]]] = empty_list()
    text: Optional[Union[str, CrdchString]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        self._normalize_inlined_as_list(slot_name="coding", slot_type=Coding, key_name="code", keyed=False)

        if self.text is not None and not isinstance(self.text, CrdchString):
            self.text = CrdchString(self.text)

        super().__post_init__(**kwargs)


@dataclass
class Coding(Entity):
    """
    A structured representation of a coded/enumerated data value, that includes additional metadata about the code and
    code system.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.Coding
    class_class_curie: ClassVar[str] = "crdch:Coding"
    class_name: ClassVar[str] = "Coding"
    class_model_uri: ClassVar[URIRef] = CRDCH.Coding

    code: Union[str, CrdchString] = None
    system: Union[str, CrdchString] = None
    label: Optional[Union[str, CrdchString]] = None
    system_version: Optional[Union[str, CrdchString]] = None
    value_set: Optional[Union[str, CrdchString]] = None
    value_set_version: Optional[Union[str, CrdchString]] = None
    tag: Optional[Union[Union[str, CrdchString], List[Union[str, CrdchString]]]] = empty_list()

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.code):
            self.MissingRequiredField("code")
        if not isinstance(self.code, CrdchString):
            self.code = CrdchString(self.code)

        if self._is_empty(self.system):
            self.MissingRequiredField("system")
        if not isinstance(self.system, CrdchString):
            self.system = CrdchString(self.system)

        if self.label is not None and not isinstance(self.label, CrdchString):
            self.label = CrdchString(self.label)

        if self.system_version is not None and not isinstance(self.system_version, CrdchString):
            self.system_version = CrdchString(self.system_version)

        if self.value_set is not None and not isinstance(self.value_set, CrdchString):
            self.value_set = CrdchString(self.value_set)

        if self.value_set_version is not None and not isinstance(self.value_set_version, CrdchString):
            self.value_set_version = CrdchString(self.value_set_version)

        if not isinstance(self.tag, list):
            self.tag = [self.tag] if self.tag is not None else []
        self.tag = [v if isinstance(v, CrdchString) else CrdchString(v) for v in self.tag]

        super().__post_init__(**kwargs)


@dataclass
class Diagnosis(Entity):
    """
    A collection of characteristics that describe an abnormal condition of the body as assessed at a point in time.
    May be used to capture information about neoplastic and non-neoplastic conditions.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.Diagnosis
    class_class_curie: ClassVar[str] = "crdch:Diagnosis"
    class_name: ClassVar[str] = "Diagnosis"
    class_model_uri: ClassVar[URIRef] = CRDCH.Diagnosis

    id: Optional[Union[str, CrdchString]] = None
    identifier: Optional[Union[Union[dict, "Identifier"], List[Union[dict, "Identifier"]]]] = empty_list()
    subject: Optional[Union[dict, "Subject"]] = None
    age_at_diagnosis: Optional[Union[dict, "Quantity"]] = None
    diagnosis_date: Optional[Union[dict, "TimePoint"]] = None
    condition: Optional[Union[dict, CodeableConcept]] = None
    primary_site: Optional[Union[Union[dict, BodySite], List[Union[dict, BodySite]]]] = empty_list()
    metastatic_site: Optional[Union[Union[dict, BodySite], List[Union[dict, BodySite]]]] = empty_list()
    stage: Optional[Union[Union[dict, CancerStageObservationSet], List[Union[dict, CancerStageObservationSet]]]] = empty_list()
    grade: Optional[Union[Union[dict, CancerGradeObservationSet], List[Union[dict, CancerGradeObservationSet]]]] = empty_list()
    morphology: Optional[Union[dict, CodeableConcept]] = None
    disease_status: Optional[Union[dict, CodeableConcept]] = None
    prior_diagnosis: Optional[Union[dict, "Diagnosis"]] = None
    method_of_diagnosis: Optional[Union[dict, CodeableConcept]] = None
    related_specimen: Optional[Union[Union[dict, "Specimen"], List[Union[dict, "Specimen"]]]] = empty_list()
    primary_tumor_dimensional_measures: Optional[Union[dict, "DimensionalObservationSet"]] = None
    supporting_observation: Optional[Union[Union[dict, "Observation"], List[Union[dict, "Observation"]]]] = empty_list()

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        self._normalize_inlined_as_list(slot_name="identifier", slot_type=Identifier, key_name="value", keyed=False)

        if self.subject is not None and not isinstance(self.subject, Subject):
            self.subject = Subject(**as_dict(self.subject))

        if self.age_at_diagnosis is not None and not isinstance(self.age_at_diagnosis, Quantity):
            self.age_at_diagnosis = Quantity(**as_dict(self.age_at_diagnosis))

        if self.diagnosis_date is not None and not isinstance(self.diagnosis_date, TimePoint):
            self.diagnosis_date = TimePoint(**as_dict(self.diagnosis_date))

        if self.condition is not None and not isinstance(self.condition, CodeableConcept):
            self.condition = CodeableConcept(**as_dict(self.condition))

        self._normalize_inlined_as_list(slot_name="primary_site", slot_type=BodySite, key_name="site", keyed=False)

        self._normalize_inlined_as_list(slot_name="metastatic_site", slot_type=BodySite, key_name="site", keyed=False)

        if not isinstance(self.stage, list):
            self.stage = [self.stage] if self.stage is not None else []
        self.stage = [v if isinstance(v, CancerStageObservationSet) else CancerStageObservationSet(**as_dict(v)) for v in self.stage]

        if not isinstance(self.grade, list):
            self.grade = [self.grade] if self.grade is not None else []
        self.grade = [v if isinstance(v, CancerGradeObservationSet) else CancerGradeObservationSet(**as_dict(v)) for v in self.grade]

        if self.morphology is not None and not isinstance(self.morphology, CodeableConcept):
            self.morphology = CodeableConcept(**as_dict(self.morphology))

        if self.disease_status is not None and not isinstance(self.disease_status, CodeableConcept):
            self.disease_status = CodeableConcept(**as_dict(self.disease_status))

        if self.prior_diagnosis is not None and not isinstance(self.prior_diagnosis, Diagnosis):
            self.prior_diagnosis = Diagnosis(**as_dict(self.prior_diagnosis))

        if self.method_of_diagnosis is not None and not isinstance(self.method_of_diagnosis, CodeableConcept):
            self.method_of_diagnosis = CodeableConcept(**as_dict(self.method_of_diagnosis))

        if not isinstance(self.related_specimen, list):
            self.related_specimen = [self.related_specimen] if self.related_specimen is not None else []
        self.related_specimen = [v if isinstance(v, Specimen) else Specimen(**as_dict(v)) for v in self.related_specimen]

        if self.primary_tumor_dimensional_measures is not None and not isinstance(self.primary_tumor_dimensional_measures, DimensionalObservationSet):
            self.primary_tumor_dimensional_measures = DimensionalObservationSet(**as_dict(self.primary_tumor_dimensional_measures))

        self._normalize_inlined_as_list(slot_name="supporting_observation", slot_type=Observation, key_name="observation_type", keyed=False)

        super().__post_init__(**kwargs)


@dataclass
class DimensionalObservation(Entity):
    """
    A structured object that describes a single data item about the physical dimensions of an entity (e.g. length
    width, area), as generated through a point-in-time observation or measurement.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.DimensionalObservation
    class_class_curie: ClassVar[str] = "crdch:DimensionalObservation"
    class_name: ClassVar[str] = "DimensionalObservation"
    class_model_uri: ClassVar[URIRef] = CRDCH.DimensionalObservation

    observation_type: Union[dict, CodeableConcept] = None
    value_quantity: Union[dict, "Quantity"] = None
    id: Optional[Union[str, CrdchString]] = None
    category: Optional[Union[dict, CodeableConcept]] = None
    method_type: Optional[Union[Union[dict, CodeableConcept], List[Union[dict, CodeableConcept]]]] = empty_list()
    focus: Optional[Union[Union[dict, "Entity"], List[Union[dict, "Entity"]]]] = empty_list()
    subject: Optional[Union[dict, "Subject"]] = None
    performed_by: Optional[Union[dict, "Organization"]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.observation_type):
            self.MissingRequiredField("observation_type")
        if not isinstance(self.observation_type, CodeableConcept):
            self.observation_type = CodeableConcept(**as_dict(self.observation_type))

        if self._is_empty(self.value_quantity):
            self.MissingRequiredField("value_quantity")
        if not isinstance(self.value_quantity, Quantity):
            self.value_quantity = Quantity(**as_dict(self.value_quantity))

        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        if self.category is not None and not isinstance(self.category, CodeableConcept):
            self.category = CodeableConcept(**as_dict(self.category))

        if not isinstance(self.method_type, list):
            self.method_type = [self.method_type] if self.method_type is not None else []
        self.method_type = [v if isinstance(v, CodeableConcept) else CodeableConcept(**as_dict(v)) for v in self.method_type]

        if not isinstance(self.focus, list):
            self.focus = [self.focus] if self.focus is not None else []
        self.focus = [v if isinstance(v, Entity) else Entity(**as_dict(v)) for v in self.focus]

        if self.subject is not None and not isinstance(self.subject, Subject):
            self.subject = Subject(**as_dict(self.subject))

        if self.performed_by is not None and not isinstance(self.performed_by, Organization):
            self.performed_by = Organization(**as_dict(self.performed_by))

        super().__post_init__(**kwargs)


@dataclass
class DimensionalObservationSet(Entity):
    """
    A set of one or more discrete observations about the physical dimensions of an object (e.g. length, width, area).
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.DimensionalObservationSet
    class_class_curie: ClassVar[str] = "crdch:DimensionalObservationSet"
    class_name: ClassVar[str] = "DimensionalObservationSet"
    class_model_uri: ClassVar[URIRef] = CRDCH.DimensionalObservationSet

    id: Optional[Union[str, CrdchString]] = None
    category: Optional[Union[dict, CodeableConcept]] = None
    focus: Optional[Union[Union[dict, "Entity"], List[Union[dict, "Entity"]]]] = empty_list()
    subject: Optional[Union[dict, "Subject"]] = None
    method_type: Optional[Union[Union[dict, CodeableConcept], List[Union[dict, CodeableConcept]]]] = empty_list()
    performed_by: Optional[Union[dict, "Organization"]] = None
    observations: Optional[Union[Union[dict, DimensionalObservation], List[Union[dict, DimensionalObservation]]]] = empty_list()

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        if self.category is not None and not isinstance(self.category, CodeableConcept):
            self.category = CodeableConcept(**as_dict(self.category))

        if not isinstance(self.focus, list):
            self.focus = [self.focus] if self.focus is not None else []
        self.focus = [v if isinstance(v, Entity) else Entity(**as_dict(v)) for v in self.focus]

        if self.subject is not None and not isinstance(self.subject, Subject):
            self.subject = Subject(**as_dict(self.subject))

        if not isinstance(self.method_type, list):
            self.method_type = [self.method_type] if self.method_type is not None else []
        self.method_type = [v if isinstance(v, CodeableConcept) else CodeableConcept(**as_dict(v)) for v in self.method_type]

        if self.performed_by is not None and not isinstance(self.performed_by, Organization):
            self.performed_by = Organization(**as_dict(self.performed_by))

        self._normalize_inlined_as_list(slot_name="observations", slot_type=DimensionalObservation, key_name="observation_type", keyed=False)

        super().__post_init__(**kwargs)


@dataclass
class Document(Entity):
    """
    A collection of information intented to be understood together as a whole, and codified in human-readable form.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.Document
    class_class_curie: ClassVar[str] = "crdch:Document"
    class_name: ClassVar[str] = "Document"
    class_model_uri: ClassVar[URIRef] = CRDCH.Document

    id: Optional[Union[str, CrdchString]] = None
    identifier: Optional[Union[Union[dict, "Identifier"], List[Union[dict, "Identifier"]]]] = empty_list()
    document_type: Optional[Union[dict, CodeableConcept]] = None
    description: Optional[Union[str, CrdchString]] = None
    focus: Optional[Union[dict, "Entity"]] = None
    url: Optional[Union[Union[str, CrdchString], List[Union[str, CrdchString]]]] = empty_list()

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        self._normalize_inlined_as_list(slot_name="identifier", slot_type=Identifier, key_name="value", keyed=False)

        if self.document_type is not None and not isinstance(self.document_type, CodeableConcept):
            self.document_type = CodeableConcept(**as_dict(self.document_type))

        if self.description is not None and not isinstance(self.description, CrdchString):
            self.description = CrdchString(self.description)

        if self.focus is not None and not isinstance(self.focus, Entity):
            self.focus = Entity()

        if not isinstance(self.url, list):
            self.url = [self.url] if self.url is not None else []
        self.url = [v if isinstance(v, CrdchString) else CrdchString(v) for v in self.url]

        super().__post_init__(**kwargs)


@dataclass
class EnvironmentalExposureObservation(Entity):
    """
    A structured object that describes a single data item about an individual's exposure to an environmental factor,
    as generated through a point-in-time observation, measurement, or interpretation.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.EnvironmentalExposureObservation
    class_class_curie: ClassVar[str] = "crdch:EnvironmentalExposureObservation"
    class_name: ClassVar[str] = "EnvironmentalExposureObservation"
    class_model_uri: ClassVar[URIRef] = CRDCH.EnvironmentalExposureObservation

    observation_type: Union[dict, CodeableConcept] = None
    value_codeable_concept: Union[dict, CodeableConcept] = None
    id: Optional[Union[str, CrdchString]] = None
    category: Optional[Union[dict, CodeableConcept]] = None
    method_type: Optional[Union[dict, CodeableConcept]] = None
    focus: Optional[Union[dict, Entity]] = None
    subject: Optional[Union[dict, "Subject"]] = None
    performed_by: Optional[Union[dict, "Organization"]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.observation_type):
            self.MissingRequiredField("observation_type")
        if not isinstance(self.observation_type, CodeableConcept):
            self.observation_type = CodeableConcept(**as_dict(self.observation_type))

        if self._is_empty(self.value_codeable_concept):
            self.MissingRequiredField("value_codeable_concept")
        if not isinstance(self.value_codeable_concept, CodeableConcept):
            self.value_codeable_concept = CodeableConcept(**as_dict(self.value_codeable_concept))

        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        if self.category is not None and not isinstance(self.category, CodeableConcept):
            self.category = CodeableConcept(**as_dict(self.category))

        if self.method_type is not None and not isinstance(self.method_type, CodeableConcept):
            self.method_type = CodeableConcept(**as_dict(self.method_type))

        if self.focus is not None and not isinstance(self.focus, Entity):
            self.focus = Entity()

        if self.subject is not None and not isinstance(self.subject, Subject):
            self.subject = Subject(**as_dict(self.subject))

        if self.performed_by is not None and not isinstance(self.performed_by, Organization):
            self.performed_by = Organization(**as_dict(self.performed_by))

        super().__post_init__(**kwargs)


@dataclass
class ExecutionConditionObservation(Entity):
    """
    A structured object that describes how long certain parts on an activity took to complete, as determined through a
    point-in-time observation or measurement.

    Information describing the environmental conditions in which an activity, or a specific part of an activity, was
    performed.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.ExecutionConditionObservation
    class_class_curie: ClassVar[str] = "crdch:ExecutionConditionObservation"
    class_name: ClassVar[str] = "ExecutionConditionObservation"
    class_model_uri: ClassVar[URIRef] = CRDCH.ExecutionConditionObservation

    observation_type: Union[dict, CodeableConcept] = None
    value_codeable_concept: Union[dict, CodeableConcept] = None
    id: Optional[Union[str, CrdchString]] = None
    category: Optional[Union[dict, CodeableConcept]] = None
    method_type: Optional[Union[dict, CodeableConcept]] = None
    focus: Optional[Union[dict, Entity]] = None
    subject: Optional[Union[dict, "Subject"]] = None
    performed_by: Optional[Union[dict, "Organization"]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.observation_type):
            self.MissingRequiredField("observation_type")
        if not isinstance(self.observation_type, CodeableConcept):
            self.observation_type = CodeableConcept(**as_dict(self.observation_type))

        if self._is_empty(self.value_codeable_concept):
            self.MissingRequiredField("value_codeable_concept")
        if not isinstance(self.value_codeable_concept, CodeableConcept):
            self.value_codeable_concept = CodeableConcept(**as_dict(self.value_codeable_concept))

        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        if self.category is not None and not isinstance(self.category, CodeableConcept):
            self.category = CodeableConcept(**as_dict(self.category))

        if self.method_type is not None and not isinstance(self.method_type, CodeableConcept):
            self.method_type = CodeableConcept(**as_dict(self.method_type))

        if self.focus is not None and not isinstance(self.focus, Entity):
            self.focus = Entity()

        if self.subject is not None and not isinstance(self.subject, Subject):
            self.subject = Subject(**as_dict(self.subject))

        if self.performed_by is not None and not isinstance(self.performed_by, Organization):
            self.performed_by = Organization(**as_dict(self.performed_by))

        super().__post_init__(**kwargs)


@dataclass
class ExecutionTimeObservation(Entity):
    """
    A structured object that describes how long certain parts on an activity took to complete, as determined through a
    point-in-time observation or measurement.

    Information describing the environmental conditions in which an activity, or a specific part of an activity, was
    performed.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.ExecutionTimeObservation
    class_class_curie: ClassVar[str] = "crdch:ExecutionTimeObservation"
    class_name: ClassVar[str] = "ExecutionTimeObservation"
    class_model_uri: ClassVar[URIRef] = CRDCH.ExecutionTimeObservation

    observation_type: Union[dict, CodeableConcept] = None
    value_quantity: Union[dict, "Quantity"] = None
    id: Optional[Union[str, CrdchString]] = None
    category: Optional[Union[dict, CodeableConcept]] = None
    method_type: Optional[Union[dict, CodeableConcept]] = None
    focus: Optional[Union[dict, Entity]] = None
    subject: Optional[Union[dict, "Subject"]] = None
    performed_by: Optional[Union[dict, "Organization"]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.observation_type):
            self.MissingRequiredField("observation_type")
        if not isinstance(self.observation_type, CodeableConcept):
            self.observation_type = CodeableConcept(**as_dict(self.observation_type))

        if self._is_empty(self.value_quantity):
            self.MissingRequiredField("value_quantity")
        if not isinstance(self.value_quantity, Quantity):
            self.value_quantity = Quantity(**as_dict(self.value_quantity))

        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        if self.category is not None and not isinstance(self.category, CodeableConcept):
            self.category = CodeableConcept(**as_dict(self.category))

        if self.method_type is not None and not isinstance(self.method_type, CodeableConcept):
            self.method_type = CodeableConcept(**as_dict(self.method_type))

        if self.focus is not None and not isinstance(self.focus, Entity):
            self.focus = Entity()

        if self.subject is not None and not isinstance(self.subject, Subject):
            self.subject = Subject(**as_dict(self.subject))

        if self.performed_by is not None and not isinstance(self.performed_by, Organization):
            self.performed_by = Organization(**as_dict(self.performed_by))

        super().__post_init__(**kwargs)


@dataclass
class Exposure(Entity):
    """
    Contact between an agent and a target. A state of contact or close proximity to a medicinal product, chemical,
    pathogen, radioisotope or other substance.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.Exposure
    class_class_curie: ClassVar[str] = "crdch:Exposure"
    class_name: ClassVar[str] = "Exposure"
    class_model_uri: ClassVar[URIRef] = CRDCH.Exposure

    id: Union[str, CrdchString] = None
    identifier: Optional[Union[Union[dict, "Identifier"], List[Union[dict, "Identifier"]]]] = empty_list()
    tobacco_exposure: Optional[Union[Union[dict, "TobaccoExposureObservation"], List[Union[dict, "TobaccoExposureObservation"]]]] = empty_list()
    alcohol_exposure: Optional[Union[Union[dict, AlcoholExposureObservation], List[Union[dict, AlcoholExposureObservation]]]] = empty_list()
    environmental_exposure: Optional[Union[Union[dict, EnvironmentalExposureObservation], List[Union[dict, EnvironmentalExposureObservation]]]] = empty_list()
    subject: Optional[Union[dict, "Subject"]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.id):
            self.MissingRequiredField("id")
        if not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        self._normalize_inlined_as_list(slot_name="identifier", slot_type=Identifier, key_name="value", keyed=False)

        self._normalize_inlined_as_list(slot_name="tobacco_exposure", slot_type=TobaccoExposureObservation, key_name="observation_type", keyed=False)

        self._normalize_inlined_as_list(slot_name="alcohol_exposure", slot_type=AlcoholExposureObservation, key_name="observation_type", keyed=False)

        self._normalize_inlined_as_list(slot_name="environmental_exposure", slot_type=EnvironmentalExposureObservation, key_name="observation_type", keyed=False)

        if self.subject is not None and not isinstance(self.subject, Subject):
            self.subject = Subject(**as_dict(self.subject))

        super().__post_init__(**kwargs)


@dataclass
class HistologicalCompositionObservation(Entity):
    """
    An observation about characteristics of a specimen at a microscopic level - typically related to its cellular or
    tissue composition. (e.g. how many cells in the specimen are of a given type, or exhibit a particular cellular
    phenotype).
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.HistologicalCompositionObservation
    class_class_curie: ClassVar[str] = "crdch:HistologicalCompositionObservation"
    class_name: ClassVar[str] = "HistologicalCompositionObservation"
    class_model_uri: ClassVar[URIRef] = CRDCH.HistologicalCompositionObservation

    observation_type: Union[dict, CodeableConcept] = None
    value_quantity: Union[dict, "Quantity"] = None
    id: Optional[Union[str, CrdchString]] = None
    category: Optional[Union[dict, CodeableConcept]] = None
    method_type: Optional[Union[Union[dict, CodeableConcept], List[Union[dict, CodeableConcept]]]] = empty_list()
    focus: Optional[Union[Union[dict, Entity], List[Union[dict, Entity]]]] = empty_list()
    subject: Optional[Union[dict, "Subject"]] = None
    performed_by: Optional[Union[dict, "Organization"]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.observation_type):
            self.MissingRequiredField("observation_type")
        if not isinstance(self.observation_type, CodeableConcept):
            self.observation_type = CodeableConcept(**as_dict(self.observation_type))

        if self._is_empty(self.value_quantity):
            self.MissingRequiredField("value_quantity")
        if not isinstance(self.value_quantity, Quantity):
            self.value_quantity = Quantity(**as_dict(self.value_quantity))

        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        if self.category is not None and not isinstance(self.category, CodeableConcept):
            self.category = CodeableConcept(**as_dict(self.category))

        if not isinstance(self.method_type, list):
            self.method_type = [self.method_type] if self.method_type is not None else []
        self.method_type = [v if isinstance(v, CodeableConcept) else CodeableConcept(**as_dict(v)) for v in self.method_type]

        if not isinstance(self.focus, list):
            self.focus = [self.focus] if self.focus is not None else []
        self.focus = [v if isinstance(v, Entity) else Entity(**as_dict(v)) for v in self.focus]

        if self.subject is not None and not isinstance(self.subject, Subject):
            self.subject = Subject(**as_dict(self.subject))

        if self.performed_by is not None and not isinstance(self.performed_by, Organization):
            self.performed_by = Organization(**as_dict(self.performed_by))

        super().__post_init__(**kwargs)


@dataclass
class HistologicalCompositionObservationSet(Entity):
    """
    A set of one or more discrete observations that quantify the relative or absolute composition of a specimen at
    cellular level - e.g. how many cells in the specimen are of a given type, or exhibit a particular cellular
    phenotype.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.HistologicalCompositionObservationSet
    class_class_curie: ClassVar[str] = "crdch:HistologicalCompositionObservationSet"
    class_name: ClassVar[str] = "HistologicalCompositionObservationSet"
    class_model_uri: ClassVar[URIRef] = CRDCH.HistologicalCompositionObservationSet

    id: Union[str, CrdchString] = None
    category: Union[dict, CodeableConcept] = None
    focus: Optional[Union[Union[dict, Entity], List[Union[dict, Entity]]]] = empty_list()
    subject: Optional[Union[dict, "Subject"]] = None
    method_type: Optional[Union[Union[dict, CodeableConcept], List[Union[dict, CodeableConcept]]]] = empty_list()
    performed_by: Optional[Union[dict, "Organization"]] = None
    observations: Optional[Union[Union[dict, HistologicalCompositionObservation], List[Union[dict, HistologicalCompositionObservation]]]] = empty_list()

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.id):
            self.MissingRequiredField("id")
        if not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        if self._is_empty(self.category):
            self.MissingRequiredField("category")
        if not isinstance(self.category, CodeableConcept):
            self.category = CodeableConcept(**as_dict(self.category))

        if not isinstance(self.focus, list):
            self.focus = [self.focus] if self.focus is not None else []
        self.focus = [v if isinstance(v, Entity) else Entity(**as_dict(v)) for v in self.focus]

        if self.subject is not None and not isinstance(self.subject, Subject):
            self.subject = Subject(**as_dict(self.subject))

        if not isinstance(self.method_type, list):
            self.method_type = [self.method_type] if self.method_type is not None else []
        self.method_type = [v if isinstance(v, CodeableConcept) else CodeableConcept(**as_dict(v)) for v in self.method_type]

        if self.performed_by is not None and not isinstance(self.performed_by, Organization):
            self.performed_by = Organization(**as_dict(self.performed_by))

        self._normalize_inlined_as_list(slot_name="observations", slot_type=HistologicalCompositionObservation, key_name="observation_type", keyed=False)

        super().__post_init__(**kwargs)


@dataclass
class Identifier(Entity):
    """
    An Identifier is associated with a unique object or entity within a given system.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.Identifier
    class_class_curie: ClassVar[str] = "crdch:Identifier"
    class_name: ClassVar[str] = "Identifier"
    class_model_uri: ClassVar[URIRef] = CRDCH.Identifier

    value: Union[str, CrdchString] = None
    system: Optional[Union[str, CrdchString]] = None
    type: Optional[Union[dict, CodeableConcept]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.value):
            self.MissingRequiredField("value")
        if not isinstance(self.value, CrdchString):
            self.value = CrdchString(self.value)

        if self.system is not None and not isinstance(self.system, CrdchString):
            self.system = CrdchString(self.system)

        if self.type is not None and not isinstance(self.type, CodeableConcept):
            self.type = CodeableConcept(**as_dict(self.type))

        super().__post_init__(**kwargs)


@dataclass
class Observation(Entity):
    """
    A structured object that describes a single data item about an entity, as generated through a point-in-time
    observation, measurement, or interpretation.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.Observation
    class_class_curie: ClassVar[str] = "crdch:Observation"
    class_name: ClassVar[str] = "Observation"
    class_model_uri: ClassVar[URIRef] = CRDCH.Observation

    observation_type: Union[dict, CodeableConcept] = None
    id: Optional[Union[str, CrdchString]] = None
    category: Optional[Union[dict, CodeableConcept]] = None
    method_type: Optional[Union[Union[dict, CodeableConcept], List[Union[dict, CodeableConcept]]]] = empty_list()
    focus: Optional[Union[Union[dict, Entity], List[Union[dict, Entity]]]] = empty_list()
    subject: Optional[Union[dict, "Subject"]] = None
    performed_by: Optional[Union[dict, "Organization"]] = None
    value_entity: Optional[Union[dict, Entity]] = None
    value_string: Optional[Union[str, CrdchString]] = None
    value_integer: Optional[Union[Decimal, CrdchDecimal]] = None
    value_decimal: Optional[Union[Decimal, CrdchDecimal]] = None
    value_boolean: Optional[Union[bool, CrdchBoolean]] = None
    value_date_time: Optional[Union[str, CrdchDateTime]] = None
    value_quantity: Optional[Union[dict, "Quantity"]] = None
    value_codeable_concept: Optional[Union[dict, CodeableConcept]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.observation_type):
            self.MissingRequiredField("observation_type")
        if not isinstance(self.observation_type, CodeableConcept):
            self.observation_type = CodeableConcept(**as_dict(self.observation_type))

        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        if self.category is not None and not isinstance(self.category, CodeableConcept):
            self.category = CodeableConcept(**as_dict(self.category))

        if not isinstance(self.method_type, list):
            self.method_type = [self.method_type] if self.method_type is not None else []
        self.method_type = [v if isinstance(v, CodeableConcept) else CodeableConcept(**as_dict(v)) for v in self.method_type]

        if not isinstance(self.focus, list):
            self.focus = [self.focus] if self.focus is not None else []
        self.focus = [v if isinstance(v, Entity) else Entity(**as_dict(v)) for v in self.focus]

        if self.subject is not None and not isinstance(self.subject, Subject):
            self.subject = Subject(**as_dict(self.subject))

        if self.performed_by is not None and not isinstance(self.performed_by, Organization):
            self.performed_by = Organization(**as_dict(self.performed_by))

        if self.value_entity is not None and not isinstance(self.value_entity, Entity):
            self.value_entity = Entity()

        if self.value_string is not None and not isinstance(self.value_string, CrdchString):
            self.value_string = CrdchString(self.value_string)

        if self.value_integer is not None and not isinstance(self.value_integer, CrdchDecimal):
            self.value_integer = CrdchDecimal(self.value_integer)

        if self.value_decimal is not None and not isinstance(self.value_decimal, CrdchDecimal):
            self.value_decimal = CrdchDecimal(self.value_decimal)

        if self.value_boolean is not None and not isinstance(self.value_boolean, CrdchBoolean):
            self.value_boolean = CrdchBoolean(self.value_boolean)

        if self.value_date_time is not None and not isinstance(self.value_date_time, CrdchDateTime):
            self.value_date_time = CrdchDateTime(self.value_date_time)

        if self.value_quantity is not None and not isinstance(self.value_quantity, Quantity):
            self.value_quantity = Quantity(**as_dict(self.value_quantity))

        if self.value_codeable_concept is not None and not isinstance(self.value_codeable_concept, CodeableConcept):
            self.value_codeable_concept = CodeableConcept(**as_dict(self.value_codeable_concept))

        super().__post_init__(**kwargs)


@dataclass
class ObservationSet(Entity):
    """
    A structured object to hold related data items about an entity, as generated through a point-in-time observation,
    measurement, or interpretation.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.ObservationSet
    class_class_curie: ClassVar[str] = "crdch:ObservationSet"
    class_name: ClassVar[str] = "ObservationSet"
    class_model_uri: ClassVar[URIRef] = CRDCH.ObservationSet

    id: Union[str, CrdchString] = None
    category: Union[dict, CodeableConcept] = None
    focus: Optional[Union[Union[dict, Entity], List[Union[dict, Entity]]]] = empty_list()
    subject: Optional[Union[dict, "Subject"]] = None
    method_type: Optional[Union[Union[dict, CodeableConcept], List[Union[dict, CodeableConcept]]]] = empty_list()
    performed_by: Optional[Union[dict, "Organization"]] = None
    observations: Optional[Union[Union[dict, Observation], List[Union[dict, Observation]]]] = empty_list()

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.id):
            self.MissingRequiredField("id")
        if not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        if self._is_empty(self.category):
            self.MissingRequiredField("category")
        if not isinstance(self.category, CodeableConcept):
            self.category = CodeableConcept(**as_dict(self.category))

        if not isinstance(self.focus, list):
            self.focus = [self.focus] if self.focus is not None else []
        self.focus = [v if isinstance(v, Entity) else Entity(**as_dict(v)) for v in self.focus]

        if self.subject is not None and not isinstance(self.subject, Subject):
            self.subject = Subject(**as_dict(self.subject))

        if not isinstance(self.method_type, list):
            self.method_type = [self.method_type] if self.method_type is not None else []
        self.method_type = [v if isinstance(v, CodeableConcept) else CodeableConcept(**as_dict(v)) for v in self.method_type]

        if self.performed_by is not None and not isinstance(self.performed_by, Organization):
            self.performed_by = Organization(**as_dict(self.performed_by))

        self._normalize_inlined_as_list(slot_name="observations", slot_type=Observation, key_name="observation_type", keyed=False)

        super().__post_init__(**kwargs)


@dataclass
class Organization(Entity):
    """
    A grouping of people or organizations with a common purpose such as a data coordinating center, an university, or
    an institute within a university
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.Organization
    class_class_curie: ClassVar[str] = "crdch:Organization"
    class_name: ClassVar[str] = "Organization"
    class_model_uri: ClassVar[URIRef] = CRDCH.Organization

    id: Union[str, CrdchString] = None
    identifier: Optional[Union[Union[dict, Identifier], List[Union[dict, Identifier]]]] = empty_list()
    name: Optional[Union[str, CrdchString]] = None
    alias: Optional[Union[str, CrdchString]] = None
    organization_type: Optional[Union[str, CrdchString]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.id):
            self.MissingRequiredField("id")
        if not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        self._normalize_inlined_as_list(slot_name="identifier", slot_type=Identifier, key_name="value", keyed=False)

        if self.name is not None and not isinstance(self.name, CrdchString):
            self.name = CrdchString(self.name)

        if self.alias is not None and not isinstance(self.alias, CrdchString):
            self.alias = CrdchString(self.alias)

        if self.organization_type is not None and not isinstance(self.organization_type, CrdchString):
            self.organization_type = CrdchString(self.organization_type)

        super().__post_init__(**kwargs)


@dataclass
class Quantity(Entity):
    """
    A structured object to represent an amount of something (e.g., weight, mass, length, duration of time) - including
    a value and unit.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.Quantity
    class_class_curie: ClassVar[str] = "crdch:Quantity"
    class_name: ClassVar[str] = "Quantity"
    class_model_uri: ClassVar[URIRef] = CRDCH.Quantity

    value_decimal: Optional[Union[Decimal, CrdchDecimal]] = None
    value_codeable_concept: Optional[Union[dict, CodeableConcept]] = None
    unit: Optional[Union[dict, CodeableConcept]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self.value_decimal is not None and not isinstance(self.value_decimal, CrdchDecimal):
            self.value_decimal = CrdchDecimal(self.value_decimal)

        if self.value_codeable_concept is not None and not isinstance(self.value_codeable_concept, CodeableConcept):
            self.value_codeable_concept = CodeableConcept(**as_dict(self.value_codeable_concept))

        if self.unit is not None and not isinstance(self.unit, CodeableConcept):
            self.unit = CodeableConcept(**as_dict(self.unit))

        super().__post_init__(**kwargs)


@dataclass
class ResearchProject(Entity):
    """
    A process where a researcher or organization plans and then executes a series of steps intended to increase the
    field of healthcare-related knowledge.
    This includes studies of safety, efficacy, comparative effectiveness and other information about medications,
    devices, therapies and other interventional
    and investigative techniques. A ResearchProject involves the gathering of information about human or animal
    subjects.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.ResearchProject
    class_class_curie: ClassVar[str] = "crdch:ResearchProject"
    class_name: ClassVar[str] = "ResearchProject"
    class_model_uri: ClassVar[URIRef] = CRDCH.ResearchProject

    research_project_type: Union[dict, CodeableConcept] = None
    id: Optional[Union[str, CrdchString]] = None
    identifier: Optional[Union[Union[dict, Identifier], List[Union[dict, Identifier]]]] = empty_list()
    name: Optional[Union[str, CrdchString]] = None
    name_shortened: Optional[Union[str, CrdchString]] = None
    description: Optional[Union[str, CrdchString]] = None
    description_shortened: Optional[Union[str, CrdchString]] = None
    sponsor: Optional[Union[Union[str, CrdchString], List[Union[str, CrdchString]]]] = empty_list()
    date_started: Optional[Union[dict, "TimePoint"]] = None
    date_ended: Optional[Union[dict, "TimePoint"]] = None
    primary_anatomic_site: Optional[Union[Union[dict, BodySite], List[Union[dict, BodySite]]]] = empty_list()
    url: Optional[Union[Union[str, CrdchString], List[Union[str, CrdchString]]]] = empty_list()
    part_of: Optional[Union[Union[dict, "ResearchProject"], List[Union[dict, "ResearchProject"]]]] = empty_list()
    associated_timepoint: Optional[Union[Union[dict, "TimePoint"], List[Union[dict, "TimePoint"]]]] = empty_list()

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.research_project_type):
            self.MissingRequiredField("research_project_type")
        if not isinstance(self.research_project_type, CodeableConcept):
            self.research_project_type = CodeableConcept(**as_dict(self.research_project_type))

        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        self._normalize_inlined_as_list(slot_name="identifier", slot_type=Identifier, key_name="value", keyed=False)

        if self.name is not None and not isinstance(self.name, CrdchString):
            self.name = CrdchString(self.name)

        if self.name_shortened is not None and not isinstance(self.name_shortened, CrdchString):
            self.name_shortened = CrdchString(self.name_shortened)

        if self.description is not None and not isinstance(self.description, CrdchString):
            self.description = CrdchString(self.description)

        if self.description_shortened is not None and not isinstance(self.description_shortened, CrdchString):
            self.description_shortened = CrdchString(self.description_shortened)

        if not isinstance(self.sponsor, list):
            self.sponsor = [self.sponsor] if self.sponsor is not None else []
        self.sponsor = [v if isinstance(v, CrdchString) else CrdchString(v) for v in self.sponsor]

        if self.date_started is not None and not isinstance(self.date_started, TimePoint):
            self.date_started = TimePoint(**as_dict(self.date_started))

        if self.date_ended is not None and not isinstance(self.date_ended, TimePoint):
            self.date_ended = TimePoint(**as_dict(self.date_ended))

        self._normalize_inlined_as_list(slot_name="primary_anatomic_site", slot_type=BodySite, key_name="site", keyed=False)

        if not isinstance(self.url, list):
            self.url = [self.url] if self.url is not None else []
        self.url = [v if isinstance(v, CrdchString) else CrdchString(v) for v in self.url]

        self._normalize_inlined_as_list(slot_name="part_of", slot_type=ResearchProject, key_name="research_project_type", keyed=False)

        if not isinstance(self.associated_timepoint, list):
            self.associated_timepoint = [self.associated_timepoint] if self.associated_timepoint is not None else []
        self.associated_timepoint = [v if isinstance(v, TimePoint) else TimePoint(**as_dict(v)) for v in self.associated_timepoint]

        super().__post_init__(**kwargs)


@dataclass
class ResearchSubject(Entity):
    """
    A research subject is the entity of interest in a research study, typically a human being or an animal, but can
    also be a device, group of humans or animals,
    or a tissue sample. Human research subjects are usually not traceable to a particular person to protect the
    subject’s privacy.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.ResearchSubject
    class_class_curie: ClassVar[str] = "crdch:ResearchSubject"
    class_name: ClassVar[str] = "ResearchSubject"
    class_model_uri: ClassVar[URIRef] = CRDCH.ResearchSubject

    id: Union[str, CrdchString] = None
    associated_subject: Union[dict, "Subject"] = None
    identifier: Optional[Union[Union[dict, Identifier], List[Union[dict, Identifier]]]] = empty_list()
    description: Optional[Union[str, CrdchString]] = None
    member_of_research_project: Optional[Union[dict, ResearchProject]] = None
    age_at_enrollment: Optional[Union[dict, Quantity]] = None
    primary_diagnosis_condition: Optional[Union[dict, CodeableConcept]] = None
    primary_diagnosis_site: Optional[Union[dict, BodySite]] = None
    primary_diagnosis: Optional[Union[Union[dict, Diagnosis], List[Union[dict, Diagnosis]]]] = empty_list()
    comorbid_diagnosis: Optional[Union[Union[dict, Diagnosis], List[Union[dict, Diagnosis]]]] = empty_list()
    index_timepoint: Optional[Union[dict, CodeableConcept]] = None
    originating_site: Optional[Union[dict, Organization]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.id):
            self.MissingRequiredField("id")
        if not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        if self._is_empty(self.associated_subject):
            self.MissingRequiredField("associated_subject")
        if not isinstance(self.associated_subject, Subject):
            self.associated_subject = Subject(**as_dict(self.associated_subject))

        self._normalize_inlined_as_list(slot_name="identifier", slot_type=Identifier, key_name="value", keyed=False)

        if self.description is not None and not isinstance(self.description, CrdchString):
            self.description = CrdchString(self.description)

        if self.member_of_research_project is not None and not isinstance(self.member_of_research_project, ResearchProject):
            self.member_of_research_project = ResearchProject(**as_dict(self.member_of_research_project))

        if self.age_at_enrollment is not None and not isinstance(self.age_at_enrollment, Quantity):
            self.age_at_enrollment = Quantity(**as_dict(self.age_at_enrollment))

        if self.primary_diagnosis_condition is not None and not isinstance(self.primary_diagnosis_condition, CodeableConcept):
            self.primary_diagnosis_condition = CodeableConcept(**as_dict(self.primary_diagnosis_condition))

        if self.primary_diagnosis_site is not None and not isinstance(self.primary_diagnosis_site, BodySite):
            self.primary_diagnosis_site = BodySite(**as_dict(self.primary_diagnosis_site))

        if not isinstance(self.primary_diagnosis, list):
            self.primary_diagnosis = [self.primary_diagnosis] if self.primary_diagnosis is not None else []
        self.primary_diagnosis = [v if isinstance(v, Diagnosis) else Diagnosis(**as_dict(v)) for v in self.primary_diagnosis]

        if not isinstance(self.comorbid_diagnosis, list):
            self.comorbid_diagnosis = [self.comorbid_diagnosis] if self.comorbid_diagnosis is not None else []
        self.comorbid_diagnosis = [v if isinstance(v, Diagnosis) else Diagnosis(**as_dict(v)) for v in self.comorbid_diagnosis]

        if self.index_timepoint is not None and not isinstance(self.index_timepoint, CodeableConcept):
            self.index_timepoint = CodeableConcept(**as_dict(self.index_timepoint))

        if self.originating_site is not None and not isinstance(self.originating_site, Organization):
            self.originating_site = Organization(**as_dict(self.originating_site))

        super().__post_init__(**kwargs)


@dataclass
class Specimen(Entity):
    """
    Any material taken as a sample from a biological entity (living or dead), or from a physical object or the
    environment. Specimens are usually collected as an example of their kind, often for use in some investigation.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.Specimen
    class_class_curie: ClassVar[str] = "crdch:Specimen"
    class_name: ClassVar[str] = "Specimen"
    class_model_uri: ClassVar[URIRef] = CRDCH.Specimen

    id: Optional[Union[str, CrdchString]] = None
    identifier: Optional[Union[Union[dict, Identifier], List[Union[dict, Identifier]]]] = empty_list()
    description: Optional[Union[str, CrdchString]] = None
    specimen_type: Optional[Union[dict, CodeableConcept]] = None
    analyte_type: Optional[Union[dict, CodeableConcept]] = None
    associated_project: Optional[Union[dict, ResearchProject]] = None
    data_provider: Optional[Union[dict, Organization]] = None
    source_material_type: Optional[Union[dict, CodeableConcept]] = None
    parent_specimen: Optional[Union[Union[dict, "Specimen"], List[Union[dict, "Specimen"]]]] = empty_list()
    source_subject: Optional[Union[dict, "Subject"]] = None
    tumor_status_at_collection: Optional[Union[dict, CodeableConcept]] = None
    creation_activity: Optional[Union[dict, "SpecimenCreationActivity"]] = None
    processing_activity: Optional[Union[Union[dict, "SpecimenProcessingActivity"], List[Union[dict, "SpecimenProcessingActivity"]]]] = empty_list()
    storage_activity: Optional[Union[Union[dict, "SpecimenStorageActivity"], List[Union[dict, "SpecimenStorageActivity"]]]] = empty_list()
    transport_activity: Optional[Union[Union[dict, "SpecimenTransportActivity"], List[Union[dict, "SpecimenTransportActivity"]]]] = empty_list()
    contained_in: Optional[Union[dict, "SpecimenContainer"]] = None
    dimensional_measures: Optional[Union[dict, DimensionalObservationSet]] = None
    quantity_measure: Optional[Union[Union[dict, "SpecimenQuantityObservation"], List[Union[dict, "SpecimenQuantityObservation"]]]] = empty_list()
    quality_measure: Optional[Union[Union[dict, "SpecimenQualityObservation"], List[Union[dict, "SpecimenQualityObservation"]]]] = empty_list()
    cellular_composition_type: Optional[Union[dict, CodeableConcept]] = None
    histological_composition_measures: Optional[Union[Union[dict, HistologicalCompositionObservationSet], List[Union[dict, HistologicalCompositionObservationSet]]]] = empty_list()
    general_tissue_pathology: Optional[Union[dict, CodeableConcept]] = None
    specific_tissue_pathology: Optional[Union[dict, CodeableConcept]] = None
    preinvasive_tissue_morphology: Optional[Union[dict, CodeableConcept]] = None
    morphology_pathologically_confirmed: Optional[Union[bool, CrdchBoolean]] = None
    morphology_assessor_role: Optional[Union[dict, CodeableConcept]] = None
    morphology_assessment_method: Optional[Union[dict, CodeableConcept]] = None
    degree_of_dysplasia: Optional[Union[dict, CodeableConcept]] = None
    dysplasia_fraction: Optional[Union[str, CrdchString]] = None
    related_document: Optional[Union[Union[dict, Document], List[Union[dict, Document]]]] = empty_list()
    section_location: Optional[Union[dict, CodeableConcept]] = None
    derived_product: Optional[Union[Union[dict, BiologicProduct], List[Union[dict, BiologicProduct]]]] = empty_list()
    distance_from_paired_specimen: Optional[Union[dict, Quantity]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        self._normalize_inlined_as_list(slot_name="identifier", slot_type=Identifier, key_name="value", keyed=False)

        if self.description is not None and not isinstance(self.description, CrdchString):
            self.description = CrdchString(self.description)

        if self.specimen_type is not None and not isinstance(self.specimen_type, CodeableConcept):
            self.specimen_type = CodeableConcept(**as_dict(self.specimen_type))

        if self.analyte_type is not None and not isinstance(self.analyte_type, CodeableConcept):
            self.analyte_type = CodeableConcept(**as_dict(self.analyte_type))

        if self.associated_project is not None and not isinstance(self.associated_project, ResearchProject):
            self.associated_project = ResearchProject(**as_dict(self.associated_project))

        if self.data_provider is not None and not isinstance(self.data_provider, Organization):
            self.data_provider = Organization(**as_dict(self.data_provider))

        if self.source_material_type is not None and not isinstance(self.source_material_type, CodeableConcept):
            self.source_material_type = CodeableConcept(**as_dict(self.source_material_type))

        if not isinstance(self.parent_specimen, list):
            self.parent_specimen = [self.parent_specimen] if self.parent_specimen is not None else []
        self.parent_specimen = [v if isinstance(v, Specimen) else Specimen(**as_dict(v)) for v in self.parent_specimen]

        if self.source_subject is not None and not isinstance(self.source_subject, Subject):
            self.source_subject = Subject(**as_dict(self.source_subject))

        if self.tumor_status_at_collection is not None and not isinstance(self.tumor_status_at_collection, CodeableConcept):
            self.tumor_status_at_collection = CodeableConcept(**as_dict(self.tumor_status_at_collection))

        if self.creation_activity is not None and not isinstance(self.creation_activity, SpecimenCreationActivity):
            self.creation_activity = SpecimenCreationActivity(**as_dict(self.creation_activity))

        if not isinstance(self.processing_activity, list):
            self.processing_activity = [self.processing_activity] if self.processing_activity is not None else []
        self.processing_activity = [v if isinstance(v, SpecimenProcessingActivity) else SpecimenProcessingActivity(**as_dict(v)) for v in self.processing_activity]

        if not isinstance(self.storage_activity, list):
            self.storage_activity = [self.storage_activity] if self.storage_activity is not None else []
        self.storage_activity = [v if isinstance(v, SpecimenStorageActivity) else SpecimenStorageActivity(**as_dict(v)) for v in self.storage_activity]

        if not isinstance(self.transport_activity, list):
            self.transport_activity = [self.transport_activity] if self.transport_activity is not None else []
        self.transport_activity = [v if isinstance(v, SpecimenTransportActivity) else SpecimenTransportActivity(**as_dict(v)) for v in self.transport_activity]

        if self.contained_in is not None and not isinstance(self.contained_in, SpecimenContainer):
            self.contained_in = SpecimenContainer(**as_dict(self.contained_in))

        if self.dimensional_measures is not None and not isinstance(self.dimensional_measures, DimensionalObservationSet):
            self.dimensional_measures = DimensionalObservationSet(**as_dict(self.dimensional_measures))

        self._normalize_inlined_as_list(slot_name="quantity_measure", slot_type=SpecimenQuantityObservation, key_name="observation_type", keyed=False)

        self._normalize_inlined_as_list(slot_name="quality_measure", slot_type=SpecimenQualityObservation, key_name="observation_type", keyed=False)

        if self.cellular_composition_type is not None and not isinstance(self.cellular_composition_type, CodeableConcept):
            self.cellular_composition_type = CodeableConcept(**as_dict(self.cellular_composition_type))

        self._normalize_inlined_as_list(slot_name="histological_composition_measures", slot_type=HistologicalCompositionObservationSet, key_name="id", keyed=False)

        if self.general_tissue_pathology is not None and not isinstance(self.general_tissue_pathology, CodeableConcept):
            self.general_tissue_pathology = CodeableConcept(**as_dict(self.general_tissue_pathology))

        if self.specific_tissue_pathology is not None and not isinstance(self.specific_tissue_pathology, CodeableConcept):
            self.specific_tissue_pathology = CodeableConcept(**as_dict(self.specific_tissue_pathology))

        if self.preinvasive_tissue_morphology is not None and not isinstance(self.preinvasive_tissue_morphology, CodeableConcept):
            self.preinvasive_tissue_morphology = CodeableConcept(**as_dict(self.preinvasive_tissue_morphology))

        if self.morphology_pathologically_confirmed is not None and not isinstance(self.morphology_pathologically_confirmed, CrdchBoolean):
            self.morphology_pathologically_confirmed = CrdchBoolean(self.morphology_pathologically_confirmed)

        if self.morphology_assessor_role is not None and not isinstance(self.morphology_assessor_role, CodeableConcept):
            self.morphology_assessor_role = CodeableConcept(**as_dict(self.morphology_assessor_role))

        if self.morphology_assessment_method is not None and not isinstance(self.morphology_assessment_method, CodeableConcept):
            self.morphology_assessment_method = CodeableConcept(**as_dict(self.morphology_assessment_method))

        if self.degree_of_dysplasia is not None and not isinstance(self.degree_of_dysplasia, CodeableConcept):
            self.degree_of_dysplasia = CodeableConcept(**as_dict(self.degree_of_dysplasia))

        if self.dysplasia_fraction is not None and not isinstance(self.dysplasia_fraction, CrdchString):
            self.dysplasia_fraction = CrdchString(self.dysplasia_fraction)

        if not isinstance(self.related_document, list):
            self.related_document = [self.related_document] if self.related_document is not None else []
        self.related_document = [v if isinstance(v, Document) else Document(**as_dict(v)) for v in self.related_document]

        if self.section_location is not None and not isinstance(self.section_location, CodeableConcept):
            self.section_location = CodeableConcept(**as_dict(self.section_location))

        if not isinstance(self.derived_product, list):
            self.derived_product = [self.derived_product] if self.derived_product is not None else []
        self.derived_product = [v if isinstance(v, BiologicProduct) else BiologicProduct(**as_dict(v)) for v in self.derived_product]

        if self.distance_from_paired_specimen is not None and not isinstance(self.distance_from_paired_specimen, Quantity):
            self.distance_from_paired_specimen = Quantity(**as_dict(self.distance_from_paired_specimen))

        super().__post_init__(**kwargs)


@dataclass
class SpecimenContainer(Entity):
    """
    A vessel in which a specimen is held or to which it is attached - for storage or as a substrate for growth (e.g. a
    cell culture dish) or analysis (e.g. a microscope slide or 96-well plate)
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.SpecimenContainer
    class_class_curie: ClassVar[str] = "crdch:SpecimenContainer"
    class_name: ClassVar[str] = "SpecimenContainer"
    class_model_uri: ClassVar[URIRef] = CRDCH.SpecimenContainer

    id: Optional[Union[str, CrdchString]] = None
    identifier: Optional[Union[Union[dict, Identifier], List[Union[dict, Identifier]]]] = empty_list()
    container_type: Optional[Union[dict, CodeableConcept]] = None
    container_number: Optional[Union[str, CrdchString]] = None
    additive: Optional[Union[Union[dict, "Substance"], List[Union[dict, "Substance"]]]] = empty_list()
    parent_container: Optional[Union[dict, "SpecimenContainer"]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        self._normalize_inlined_as_list(slot_name="identifier", slot_type=Identifier, key_name="value", keyed=False)

        if self.container_type is not None and not isinstance(self.container_type, CodeableConcept):
            self.container_type = CodeableConcept(**as_dict(self.container_type))

        if self.container_number is not None and not isinstance(self.container_number, CrdchString):
            self.container_number = CrdchString(self.container_number)

        if not isinstance(self.additive, list):
            self.additive = [self.additive] if self.additive is not None else []
        self.additive = [v if isinstance(v, Substance) else Substance(**as_dict(v)) for v in self.additive]

        if self.parent_container is not None and not isinstance(self.parent_container, SpecimenContainer):
            self.parent_container = SpecimenContainer(**as_dict(self.parent_container))

        super().__post_init__(**kwargs)


@dataclass
class SpecimenCreationActivity(Entity):
    """
    The process of creating a specimen. This may occur through observing and/or collecting material from an biological
    source or natural setting, or through derivation from an existing specimen (e.g. via portioning or aliquoting).
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.SpecimenCreationActivity
    class_class_curie: ClassVar[str] = "crdch:SpecimenCreationActivity"
    class_name: ClassVar[str] = "SpecimenCreationActivity"
    class_model_uri: ClassVar[URIRef] = CRDCH.SpecimenCreationActivity

    activity_type: Optional[Union[dict, CodeableConcept]] = None
    date_started: Optional[Union[dict, "TimePoint"]] = None
    date_ended: Optional[Union[dict, "TimePoint"]] = None
    performed_by: Optional[Union[dict, Organization]] = None
    collection_method_type: Optional[Union[dict, CodeableConcept]] = None
    derivation_method_type: Optional[Union[dict, CodeableConcept]] = None
    additive: Optional[Union[Union[dict, "Substance"], List[Union[dict, "Substance"]]]] = empty_list()
    collection_site: Optional[Union[dict, BodySite]] = None
    quantity_collected: Optional[Union[dict, Quantity]] = None
    execution_time_observation: Optional[Union[Union[dict, ExecutionTimeObservation], List[Union[dict, ExecutionTimeObservation]]]] = empty_list()
    execution_condition_observation: Optional[Union[Union[dict, ExecutionConditionObservation], List[Union[dict, ExecutionConditionObservation]]]] = empty_list()
    specimen_order: Optional[Union[int, CrdchInteger]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self.activity_type is not None and not isinstance(self.activity_type, CodeableConcept):
            self.activity_type = CodeableConcept(**as_dict(self.activity_type))

        if self.date_started is not None and not isinstance(self.date_started, TimePoint):
            self.date_started = TimePoint(**as_dict(self.date_started))

        if self.date_ended is not None and not isinstance(self.date_ended, TimePoint):
            self.date_ended = TimePoint(**as_dict(self.date_ended))

        if self.performed_by is not None and not isinstance(self.performed_by, Organization):
            self.performed_by = Organization(**as_dict(self.performed_by))

        if self.collection_method_type is not None and not isinstance(self.collection_method_type, CodeableConcept):
            self.collection_method_type = CodeableConcept(**as_dict(self.collection_method_type))

        if self.derivation_method_type is not None and not isinstance(self.derivation_method_type, CodeableConcept):
            self.derivation_method_type = CodeableConcept(**as_dict(self.derivation_method_type))

        if not isinstance(self.additive, list):
            self.additive = [self.additive] if self.additive is not None else []
        self.additive = [v if isinstance(v, Substance) else Substance(**as_dict(v)) for v in self.additive]

        if self.collection_site is not None and not isinstance(self.collection_site, BodySite):
            self.collection_site = BodySite(**as_dict(self.collection_site))

        if self.quantity_collected is not None and not isinstance(self.quantity_collected, Quantity):
            self.quantity_collected = Quantity(**as_dict(self.quantity_collected))

        self._normalize_inlined_as_list(slot_name="execution_time_observation", slot_type=ExecutionTimeObservation, key_name="observation_type", keyed=False)

        self._normalize_inlined_as_list(slot_name="execution_condition_observation", slot_type=ExecutionConditionObservation, key_name="observation_type", keyed=False)

        if self.specimen_order is not None and not isinstance(self.specimen_order, CrdchInteger):
            self.specimen_order = CrdchInteger(self.specimen_order)

        super().__post_init__(**kwargs)


@dataclass
class SpecimenQualityObservation(Entity):
    """
    A structured object that describes a characteristic of a specimen indicative of its quality or suitability for
    use, as generated through a point-in-time observation or measurement.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.SpecimenQualityObservation
    class_class_curie: ClassVar[str] = "crdch:SpecimenQualityObservation"
    class_name: ClassVar[str] = "SpecimenQualityObservation"
    class_model_uri: ClassVar[URIRef] = CRDCH.SpecimenQualityObservation

    observation_type: Union[dict, CodeableConcept] = None
    value_quantity: Union[dict, Quantity] = None
    id: Optional[Union[str, CrdchString]] = None
    category: Optional[Union[dict, CodeableConcept]] = None
    method_type: Optional[Union[Union[dict, CodeableConcept], List[Union[dict, CodeableConcept]]]] = empty_list()
    focus: Optional[Union[Union[dict, Entity], List[Union[dict, Entity]]]] = empty_list()
    subject: Optional[Union[dict, "Subject"]] = None
    performed_by: Optional[Union[dict, Organization]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.observation_type):
            self.MissingRequiredField("observation_type")
        if not isinstance(self.observation_type, CodeableConcept):
            self.observation_type = CodeableConcept(**as_dict(self.observation_type))

        if self._is_empty(self.value_quantity):
            self.MissingRequiredField("value_quantity")
        if not isinstance(self.value_quantity, Quantity):
            self.value_quantity = Quantity(**as_dict(self.value_quantity))

        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        if self.category is not None and not isinstance(self.category, CodeableConcept):
            self.category = CodeableConcept(**as_dict(self.category))

        if not isinstance(self.method_type, list):
            self.method_type = [self.method_type] if self.method_type is not None else []
        self.method_type = [v if isinstance(v, CodeableConcept) else CodeableConcept(**as_dict(v)) for v in self.method_type]

        if not isinstance(self.focus, list):
            self.focus = [self.focus] if self.focus is not None else []
        self.focus = [v if isinstance(v, Entity) else Entity(**as_dict(v)) for v in self.focus]

        if self.subject is not None and not isinstance(self.subject, Subject):
            self.subject = Subject(**as_dict(self.subject))

        if self.performed_by is not None and not isinstance(self.performed_by, Organization):
            self.performed_by = Organization(**as_dict(self.performed_by))

        super().__post_init__(**kwargs)


@dataclass
class SpecimenQuantityObservation(Entity):
    """
    A structured object that describes a single data item about the quantity of an entity, as generated through a
    point-in-time observation or measurement.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.SpecimenQuantityObservation
    class_class_curie: ClassVar[str] = "crdch:SpecimenQuantityObservation"
    class_name: ClassVar[str] = "SpecimenQuantityObservation"
    class_model_uri: ClassVar[URIRef] = CRDCH.SpecimenQuantityObservation

    observation_type: Union[dict, CodeableConcept] = None
    value_quantity: Union[dict, Quantity] = None
    id: Optional[Union[str, CrdchString]] = None
    category: Optional[Union[dict, CodeableConcept]] = None
    method_type: Optional[Union[Union[dict, CodeableConcept], List[Union[dict, CodeableConcept]]]] = empty_list()
    focus: Optional[Union[Union[dict, Entity], List[Union[dict, Entity]]]] = empty_list()
    subject: Optional[Union[dict, "Subject"]] = None
    performed_by: Optional[Union[dict, Organization]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.observation_type):
            self.MissingRequiredField("observation_type")
        if not isinstance(self.observation_type, CodeableConcept):
            self.observation_type = CodeableConcept(**as_dict(self.observation_type))

        if self._is_empty(self.value_quantity):
            self.MissingRequiredField("value_quantity")
        if not isinstance(self.value_quantity, Quantity):
            self.value_quantity = Quantity(**as_dict(self.value_quantity))

        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        if self.category is not None and not isinstance(self.category, CodeableConcept):
            self.category = CodeableConcept(**as_dict(self.category))

        if not isinstance(self.method_type, list):
            self.method_type = [self.method_type] if self.method_type is not None else []
        self.method_type = [v if isinstance(v, CodeableConcept) else CodeableConcept(**as_dict(v)) for v in self.method_type]

        if not isinstance(self.focus, list):
            self.focus = [self.focus] if self.focus is not None else []
        self.focus = [v if isinstance(v, Entity) else Entity(**as_dict(v)) for v in self.focus]

        if self.subject is not None and not isinstance(self.subject, Subject):
            self.subject = Subject(**as_dict(self.subject))

        if self.performed_by is not None and not isinstance(self.performed_by, Organization):
            self.performed_by = Organization(**as_dict(self.performed_by))

        super().__post_init__(**kwargs)


@dataclass
class SpecimenProcessingActivity(Entity):
    """
    An activity that modifies the physical structure, composition, or state of a specimen. Unlike SpecimenCreation,
    SpecimenProcessing activities do not result in the generation of new entities - they take a single specimen as
    input, and output that same specimen.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.SpecimenProcessingActivity
    class_class_curie: ClassVar[str] = "crdch:SpecimenProcessingActivity"
    class_name: ClassVar[str] = "SpecimenProcessingActivity"
    class_model_uri: ClassVar[URIRef] = CRDCH.SpecimenProcessingActivity

    activity_type: Optional[Union[dict, CodeableConcept]] = None
    date_started: Optional[Union[dict, "TimePoint"]] = None
    date_ended: Optional[Union[dict, "TimePoint"]] = None
    duration: Optional[Union[Union[dict, Quantity], List[Union[dict, Quantity]]]] = empty_list()
    performed_by: Optional[Union[dict, Organization]] = None
    method_type: Optional[Union[dict, CodeableConcept]] = None
    additive: Optional[Union[Union[dict, "Substance"], List[Union[dict, "Substance"]]]] = empty_list()
    execution_time_observation: Optional[Union[Union[dict, ExecutionTimeObservation], List[Union[dict, ExecutionTimeObservation]]]] = empty_list()
    execution_condition_observation: Optional[Union[Union[dict, ExecutionConditionObservation], List[Union[dict, ExecutionConditionObservation]]]] = empty_list()

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self.activity_type is not None and not isinstance(self.activity_type, CodeableConcept):
            self.activity_type = CodeableConcept(**as_dict(self.activity_type))

        if self.date_started is not None and not isinstance(self.date_started, TimePoint):
            self.date_started = TimePoint(**as_dict(self.date_started))

        if self.date_ended is not None and not isinstance(self.date_ended, TimePoint):
            self.date_ended = TimePoint(**as_dict(self.date_ended))

        if not isinstance(self.duration, list):
            self.duration = [self.duration] if self.duration is not None else []
        self.duration = [v if isinstance(v, Quantity) else Quantity(**as_dict(v)) for v in self.duration]

        if self.performed_by is not None and not isinstance(self.performed_by, Organization):
            self.performed_by = Organization(**as_dict(self.performed_by))

        if self.method_type is not None and not isinstance(self.method_type, CodeableConcept):
            self.method_type = CodeableConcept(**as_dict(self.method_type))

        if not isinstance(self.additive, list):
            self.additive = [self.additive] if self.additive is not None else []
        self.additive = [v if isinstance(v, Substance) else Substance(**as_dict(v)) for v in self.additive]

        self._normalize_inlined_as_list(slot_name="execution_time_observation", slot_type=ExecutionTimeObservation, key_name="observation_type", keyed=False)

        self._normalize_inlined_as_list(slot_name="execution_condition_observation", slot_type=ExecutionConditionObservation, key_name="observation_type", keyed=False)

        super().__post_init__(**kwargs)


@dataclass
class SpecimenStorageActivity(Entity):
    """
    An activity in which a specimen is stored or maintained in a particular location, container, or state. Unlike
    'processing' activities, storage does not alter the
    intrinsic physical nature of a specimen.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.SpecimenStorageActivity
    class_class_curie: ClassVar[str] = "crdch:SpecimenStorageActivity"
    class_name: ClassVar[str] = "SpecimenStorageActivity"
    class_model_uri: ClassVar[URIRef] = CRDCH.SpecimenStorageActivity

    date_started: Optional[Union[dict, "TimePoint"]] = None
    date_ended: Optional[Union[dict, "TimePoint"]] = None
    duration: Optional[Union[dict, Quantity]] = None
    performed_by: Optional[Union[dict, Organization]] = None
    method_type: Optional[Union[dict, CodeableConcept]] = None
    container: Optional[Union[Union[dict, SpecimenContainer], List[Union[dict, SpecimenContainer]]]] = empty_list()

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self.date_started is not None and not isinstance(self.date_started, TimePoint):
            self.date_started = TimePoint(**as_dict(self.date_started))

        if self.date_ended is not None and not isinstance(self.date_ended, TimePoint):
            self.date_ended = TimePoint(**as_dict(self.date_ended))

        if self.duration is not None and not isinstance(self.duration, Quantity):
            self.duration = Quantity(**as_dict(self.duration))

        if self.performed_by is not None and not isinstance(self.performed_by, Organization):
            self.performed_by = Organization(**as_dict(self.performed_by))

        if self.method_type is not None and not isinstance(self.method_type, CodeableConcept):
            self.method_type = CodeableConcept(**as_dict(self.method_type))

        if not isinstance(self.container, list):
            self.container = [self.container] if self.container is not None else []
        self.container = [v if isinstance(v, SpecimenContainer) else SpecimenContainer(**as_dict(v)) for v in self.container]

        super().__post_init__(**kwargs)


@dataclass
class SpecimenTransportActivity(Entity):
    """
    An activity through which a specimen is transported between locations or organizations.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.SpecimenTransportActivity
    class_class_curie: ClassVar[str] = "crdch:SpecimenTransportActivity"
    class_name: ClassVar[str] = "SpecimenTransportActivity"
    class_model_uri: ClassVar[URIRef] = CRDCH.SpecimenTransportActivity

    date_started: Optional[Union[dict, "TimePoint"]] = None
    date_ended: Optional[Union[dict, "TimePoint"]] = None
    duration: Optional[Union[Union[str, CrdchString], List[Union[str, CrdchString]]]] = empty_list()
    performed_by: Optional[Union[dict, Organization]] = None
    transport_origin: Optional[Union[dict, Organization]] = None
    transport_destination: Optional[Union[dict, Organization]] = None
    execution_condition_observation: Optional[Union[Union[dict, ExecutionConditionObservation], List[Union[dict, ExecutionConditionObservation]]]] = empty_list()

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self.date_started is not None and not isinstance(self.date_started, TimePoint):
            self.date_started = TimePoint(**as_dict(self.date_started))

        if self.date_ended is not None and not isinstance(self.date_ended, TimePoint):
            self.date_ended = TimePoint(**as_dict(self.date_ended))

        if not isinstance(self.duration, list):
            self.duration = [self.duration] if self.duration is not None else []
        self.duration = [v if isinstance(v, CrdchString) else CrdchString(v) for v in self.duration]

        if self.performed_by is not None and not isinstance(self.performed_by, Organization):
            self.performed_by = Organization(**as_dict(self.performed_by))

        if self.transport_origin is not None and not isinstance(self.transport_origin, Organization):
            self.transport_origin = Organization(**as_dict(self.transport_origin))

        if self.transport_destination is not None and not isinstance(self.transport_destination, Organization):
            self.transport_destination = Organization(**as_dict(self.transport_destination))

        self._normalize_inlined_as_list(slot_name="execution_condition_observation", slot_type=ExecutionConditionObservation, key_name="observation_type", keyed=False)

        super().__post_init__(**kwargs)


@dataclass
class Subject(Entity):
    """
    Demographics and other administrative information about an individual or animal receiving care or other
    health-related services.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.Subject
    class_class_curie: ClassVar[str] = "crdch:Subject"
    class_name: ClassVar[str] = "Subject"
    class_model_uri: ClassVar[URIRef] = CRDCH.Subject

    id: Union[str, CrdchString] = None
    identifier: Optional[Union[Union[dict, Identifier], List[Union[dict, Identifier]]]] = empty_list()
    species: Optional[Union[dict, CodeableConcept]] = None
    breed: Optional[Union[dict, CodeableConcept]] = None
    sex: Optional[Union[dict, CodeableConcept]] = None
    ethnicity: Optional[Union[dict, CodeableConcept]] = None
    race: Optional[Union[Union[dict, CodeableConcept], List[Union[dict, CodeableConcept]]]] = empty_list()
    year_of_birth: Optional[Union[int, CrdchInteger]] = None
    vital_status: Optional[Union[dict, CodeableConcept]] = None
    age_at_death: Optional[Union[dict, Quantity]] = None
    year_of_death: Optional[Union[int, CrdchInteger]] = None
    cause_of_death: Optional[Union[dict, CodeableConcept]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.id):
            self.MissingRequiredField("id")
        if not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        self._normalize_inlined_as_list(slot_name="identifier", slot_type=Identifier, key_name="value", keyed=False)

        if self.species is not None and not isinstance(self.species, CodeableConcept):
            self.species = CodeableConcept(**as_dict(self.species))

        if self.breed is not None and not isinstance(self.breed, CodeableConcept):
            self.breed = CodeableConcept(**as_dict(self.breed))

        if self.sex is not None and not isinstance(self.sex, CodeableConcept):
            self.sex = CodeableConcept(**as_dict(self.sex))

        if self.ethnicity is not None and not isinstance(self.ethnicity, CodeableConcept):
            self.ethnicity = CodeableConcept(**as_dict(self.ethnicity))

        if not isinstance(self.race, list):
            self.race = [self.race] if self.race is not None else []
        self.race = [v if isinstance(v, CodeableConcept) else CodeableConcept(**as_dict(v)) for v in self.race]

        if self.year_of_birth is not None and not isinstance(self.year_of_birth, CrdchInteger):
            self.year_of_birth = CrdchInteger(self.year_of_birth)

        if self.vital_status is not None and not isinstance(self.vital_status, CodeableConcept):
            self.vital_status = CodeableConcept(**as_dict(self.vital_status))

        if self.age_at_death is not None and not isinstance(self.age_at_death, Quantity):
            self.age_at_death = Quantity(**as_dict(self.age_at_death))

        if self.year_of_death is not None and not isinstance(self.year_of_death, CrdchInteger):
            self.year_of_death = CrdchInteger(self.year_of_death)

        if self.cause_of_death is not None and not isinstance(self.cause_of_death, CodeableConcept):
            self.cause_of_death = CodeableConcept(**as_dict(self.cause_of_death))

        super().__post_init__(**kwargs)


@dataclass
class Substance(Entity):
    """
    A type of material substance, or instance thereof, as used in a particular application. May include information
    about the role the substance played in a particular application.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.Substance
    class_class_curie: ClassVar[str] = "crdch:Substance"
    class_name: ClassVar[str] = "Substance"
    class_model_uri: ClassVar[URIRef] = CRDCH.Substance

    substance_type: Optional[Union[dict, CodeableConcept]] = None
    role: Optional[Union[Union[dict, CodeableConcept], List[Union[dict, CodeableConcept]]]] = empty_list()
    substance_quantity: Optional[Union[dict, Quantity]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self.substance_type is not None and not isinstance(self.substance_type, CodeableConcept):
            self.substance_type = CodeableConcept(**as_dict(self.substance_type))

        if not isinstance(self.role, list):
            self.role = [self.role] if self.role is not None else []
        self.role = [v if isinstance(v, CodeableConcept) else CodeableConcept(**as_dict(v)) for v in self.role]

        if self.substance_quantity is not None and not isinstance(self.substance_quantity, Quantity):
            self.substance_quantity = Quantity(**as_dict(self.substance_quantity))

        super().__post_init__(**kwargs)


@dataclass
class TimePoint(Entity):
    """
    A structured representation of a single point in time that allows direct/explicit declaration as a dateTime,
    specification in terms of offset from a defined index, or description of an event type as a proxy for the time
    point when it occurred.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.TimePoint
    class_class_curie: ClassVar[str] = "crdch:TimePoint"
    class_name: ClassVar[str] = "TimePoint"
    class_model_uri: ClassVar[URIRef] = CRDCH.TimePoint

    id: Optional[Union[str, CrdchString]] = None
    date_time: Optional[Union[str, CrdchDateTime]] = None
    index_time_point: Optional[Union[dict, "TimePoint"]] = None
    offset_from_index: Optional[Union[dict, Quantity]] = None
    event_type: Optional[Union[Union[dict, CodeableConcept], List[Union[dict, CodeableConcept]]]] = empty_list()

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        if self.date_time is not None and not isinstance(self.date_time, CrdchDateTime):
            self.date_time = CrdchDateTime(self.date_time)

        if self.index_time_point is not None and not isinstance(self.index_time_point, TimePoint):
            self.index_time_point = TimePoint(**as_dict(self.index_time_point))

        if self.offset_from_index is not None and not isinstance(self.offset_from_index, Quantity):
            self.offset_from_index = Quantity(**as_dict(self.offset_from_index))

        if not isinstance(self.event_type, list):
            self.event_type = [self.event_type] if self.event_type is not None else []
        self.event_type = [v if isinstance(v, CodeableConcept) else CodeableConcept(**as_dict(v)) for v in self.event_type]

        super().__post_init__(**kwargs)


@dataclass
class TimePeriod(Entity):
    """
    A period of time between a start and end time point.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.TimePeriod
    class_class_curie: ClassVar[str] = "crdch:TimePeriod"
    class_name: ClassVar[str] = "TimePeriod"
    class_model_uri: ClassVar[URIRef] = CRDCH.TimePeriod

    period_start_start: Optional[Union[dict, TimePoint]] = None
    period_end_end: Optional[Union[dict, TimePoint]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self.period_start_start is not None and not isinstance(self.period_start_start, TimePoint):
            self.period_start_start = TimePoint(**as_dict(self.period_start_start))

        if self.period_end_end is not None and not isinstance(self.period_end_end, TimePoint):
            self.period_end_end = TimePoint(**as_dict(self.period_end_end))

        super().__post_init__(**kwargs)


@dataclass
class TobaccoExposureObservation(Entity):
    """
    A structured object that describes a single data item about an individual's exposure to tobacco, as generated
    through a point-in-time observation, measurement, or interpretation.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.TobaccoExposureObservation
    class_class_curie: ClassVar[str] = "crdch:TobaccoExposureObservation"
    class_name: ClassVar[str] = "TobaccoExposureObservation"
    class_model_uri: ClassVar[URIRef] = CRDCH.TobaccoExposureObservation

    observation_type: Union[dict, CodeableConcept] = None
    id: Optional[Union[str, CrdchString]] = None
    category: Optional[Union[dict, CodeableConcept]] = None
    method_type: Optional[Union[dict, CodeableConcept]] = None
    focus: Optional[Union[dict, Entity]] = None
    subject: Optional[Union[dict, Subject]] = None
    performed_by: Optional[Union[dict, Organization]] = None
    value_integer: Optional[Union[int, CrdchInteger]] = None
    value_codeable_concept: Optional[Union[dict, CodeableConcept]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.observation_type):
            self.MissingRequiredField("observation_type")
        if not isinstance(self.observation_type, CodeableConcept):
            self.observation_type = CodeableConcept(**as_dict(self.observation_type))

        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        if self.category is not None and not isinstance(self.category, CodeableConcept):
            self.category = CodeableConcept(**as_dict(self.category))

        if self.method_type is not None and not isinstance(self.method_type, CodeableConcept):
            self.method_type = CodeableConcept(**as_dict(self.method_type))

        if self.focus is not None and not isinstance(self.focus, Entity):
            self.focus = Entity()

        if self.subject is not None and not isinstance(self.subject, Subject):
            self.subject = Subject(**as_dict(self.subject))

        if self.performed_by is not None and not isinstance(self.performed_by, Organization):
            self.performed_by = Organization(**as_dict(self.performed_by))

        if self.value_integer is not None and not isinstance(self.value_integer, CrdchInteger):
            self.value_integer = CrdchInteger(self.value_integer)

        if self.value_codeable_concept is not None and not isinstance(self.value_codeable_concept, CodeableConcept):
            self.value_codeable_concept = CodeableConcept(**as_dict(self.value_codeable_concept))

        super().__post_init__(**kwargs)


@dataclass
class Treatment(Entity):
    """
    Represent medication administration or other treatment types.
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = CRDCH.Treatment
    class_class_curie: ClassVar[str] = "crdch:Treatment"
    class_name: ClassVar[str] = "Treatment"
    class_model_uri: ClassVar[URIRef] = CRDCH.Treatment

    id: Optional[Union[str, CrdchString]] = None
    identifier: Optional[Union[Union[dict, Identifier], List[Union[dict, Identifier]]]] = empty_list()
    treatment_for_diagnosis: Optional[Union[Union[dict, Diagnosis], List[Union[dict, Diagnosis]]]] = empty_list()
    concurrent_treatment: Optional[Union[Union[dict, "Treatment"], List[Union[dict, "Treatment"]]]] = empty_list()
    treatment_type: Optional[Union[dict, CodeableConcept]] = None
    subject: Optional[Union[dict, Subject]] = None
    date_started: Optional[Union[dict, TimePoint]] = None
    date_ended: Optional[Union[dict, TimePoint]] = None
    treatment_end_reason: Optional[Union[Union[dict, CodeableConcept], List[Union[dict, CodeableConcept]]]] = empty_list()
    regimen: Optional[Union[dict, CodeableConcept]] = None
    therapeutic_agent: Optional[Union[dict, Substance]] = None
    number_of_cycles: Optional[Union[int, CrdchInteger]] = None
    treatment_frequency: Optional[Union[dict, CodeableConcept]] = None
    treatment_anatomic_site: Optional[Union[dict, BodySite]] = None
    treatment_intent: Optional[Union[dict, CodeableConcept]] = None
    treatment_effect: Optional[Union[dict, CodeableConcept]] = None
    treatment_outcome: Optional[Union[dict, CodeableConcept]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self.id is not None and not isinstance(self.id, CrdchString):
            self.id = CrdchString(self.id)

        self._normalize_inlined_as_list(slot_name="identifier", slot_type=Identifier, key_name="value", keyed=False)

        if not isinstance(self.treatment_for_diagnosis, list):
            self.treatment_for_diagnosis = [self.treatment_for_diagnosis] if self.treatment_for_diagnosis is not None else []
        self.treatment_for_diagnosis = [v if isinstance(v, Diagnosis) else Diagnosis(**as_dict(v)) for v in self.treatment_for_diagnosis]

        if not isinstance(self.concurrent_treatment, list):
            self.concurrent_treatment = [self.concurrent_treatment] if self.concurrent_treatment is not None else []
        self.concurrent_treatment = [v if isinstance(v, Treatment) else Treatment(**as_dict(v)) for v in self.concurrent_treatment]

        if self.treatment_type is not None and not isinstance(self.treatment_type, CodeableConcept):
            self.treatment_type = CodeableConcept(**as_dict(self.treatment_type))

        if self.subject is not None and not isinstance(self.subject, Subject):
            self.subject = Subject(**as_dict(self.subject))

        if self.date_started is not None and not isinstance(self.date_started, TimePoint):
            self.date_started = TimePoint(**as_dict(self.date_started))

        if self.date_ended is not None and not isinstance(self.date_ended, TimePoint):
            self.date_ended = TimePoint(**as_dict(self.date_ended))

        if not isinstance(self.treatment_end_reason, list):
            self.treatment_end_reason = [self.treatment_end_reason] if self.treatment_end_reason is not None else []
        self.treatment_end_reason = [v if isinstance(v, CodeableConcept) else CodeableConcept(**as_dict(v)) for v in self.treatment_end_reason]

        if self.regimen is not None and not isinstance(self.regimen, CodeableConcept):
            self.regimen = CodeableConcept(**as_dict(self.regimen))

        if self.therapeutic_agent is not None and not isinstance(self.therapeutic_agent, Substance):
            self.therapeutic_agent = Substance(**as_dict(self.therapeutic_agent))

        if self.number_of_cycles is not None and not isinstance(self.number_of_cycles, CrdchInteger):
            self.number_of_cycles = CrdchInteger(self.number_of_cycles)

        if self.treatment_frequency is not None and not isinstance(self.treatment_frequency, CodeableConcept):
            self.treatment_frequency = CodeableConcept(**as_dict(self.treatment_frequency))

        if self.treatment_anatomic_site is not None and not isinstance(self.treatment_anatomic_site, BodySite):
            self.treatment_anatomic_site = BodySite(**as_dict(self.treatment_anatomic_site))

        if self.treatment_intent is not None and not isinstance(self.treatment_intent, CodeableConcept):
            self.treatment_intent = CodeableConcept(**as_dict(self.treatment_intent))

        if self.treatment_effect is not None and not isinstance(self.treatment_effect, CodeableConcept):
            self.treatment_effect = CodeableConcept(**as_dict(self.treatment_effect))

        if self.treatment_outcome is not None and not isinstance(self.treatment_outcome, CodeableConcept):
            self.treatment_outcome = CodeableConcept(**as_dict(self.treatment_outcome))

        super().__post_init__(**kwargs)


# Enumerations
class EnumCRDCHAlcoholExposureObservationCategory(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H AlcoholExposureObservation category
    """
    _defn = EnumDefinition(
        name="EnumCRDCHAlcoholExposureObservationCategory",
        description="Autogenerated Enumeration for CRDC-H AlcoholExposureObservation category",
        code_set=None,
        code_set_version="2021-09-23T15:59:38.238570+00:00",
    )

class EnumCRDCHAlcoholExposureObservationObservationType(EnumDefinitionImpl):
    """
    Types of observations about a Subject's exposure to alcohol.
    """
    alcohol_days_per_week = PermissibleValue(text="alcohol_days_per_week",
                                                                 description="Numeric value used to describe the average number of days each week that a person consumes an alcoholic beverage.")
    alcohol_drinks_per_day = PermissibleValue(text="alcohol_drinks_per_day",
                                                                   description="Numeric value used to describe the average number of alcoholic beverages a person consumes per day.")
    alcohol_history = PermissibleValue(text="alcohol_history",
                                                     description="A response to a question that asks whether the participant has consumed at least 12 drinks of any kind of alcoholic beverage in their lifetime.")
    alcohol_intensity = PermissibleValue(text="alcohol_intensity",
                                                         description="Category to describe the patient's current level of alcohol use as self-reported by the patient.")

    _defn = EnumDefinition(
        name="EnumCRDCHAlcoholExposureObservationObservationType",
        description="Types of observations about a Subject's exposure to alcohol.",
    )

class EnumCRDCHAlcoholExposureObservationMethodType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H AlcoholExposureObservation method_type
    """
    _defn = EnumDefinition(
        name="EnumCRDCHAlcoholExposureObservationMethodType",
        description="Autogenerated Enumeration for CRDC-H AlcoholExposureObservation method_type",
        code_set=None,
        code_set_version="2021-09-23T15:59:38.806206+00:00",
    )

class EnumCRDCHAlcoholExposureObservationValueCodeableConcept(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H AlcoholExposureObservation value_codeable_concept
    """
    _defn = EnumDefinition(
        name="EnumCRDCHAlcoholExposureObservationValueCodeableConcept",
        description="Autogenerated Enumeration for CRDC-H AlcoholExposureObservation value_codeable_concept",
        code_set=None,
        code_set_version="2021-09-23T15:59:38.907495+00:00",
    )

class EnumCRDCHBodySiteSite(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H BodySite site
    """
    Brain = PermissibleValue(text="Brain",
                                 description="Brain")
    Unknown = PermissibleValue(text="Unknown")
    Skin = PermissibleValue(text="Skin",
                               description="Skin")
    Ureter = PermissibleValue(text="Ureter")
    Gallbladder = PermissibleValue(text="Gallbladder")
    Tonsil = PermissibleValue(text="Tonsil",
                                   description="Tonsil")
    Colon = PermissibleValue(text="Colon",
                                 description="Colon")
    Esophagus = PermissibleValue(text="Esophagus",
                                         description="Esophagus")
    Palate = PermissibleValue(text="Palate",
                                   description="Palate")
    Hypopharynx = PermissibleValue(text="Hypopharynx",
                                             description="Hypopharynx (Laryngopharynx)")
    Lip = PermissibleValue(text="Lip",
                             description="Lip")
    Testis = PermissibleValue(text="Testis")
    Nasopharynx = PermissibleValue(text="Nasopharynx",
                                             description="Nasopharynx")
    Meninges = PermissibleValue(text="Meninges",
                                       description="Meninges")
    Rectum = PermissibleValue(text="Rectum",
                                   description="Rectum")
    Bladder = PermissibleValue(text="Bladder",
                                     description="Bladder")
    Larynx = PermissibleValue(text="Larynx",
                                   description="Larynx")
    Vulva = PermissibleValue(text="Vulva",
                                 description="Vulva")
    Breast = PermissibleValue(text="Breast",
                                   description="Breast")
    Stomach = PermissibleValue(text="Stomach",
                                     description="Stomach")
    Kidney = PermissibleValue(text="Kidney",
                                   description="Kidney")
    Oropharynx = PermissibleValue(text="Oropharynx",
                                           description="Oropharynx")
    Trachea = PermissibleValue(text="Trachea")
    Placenta = PermissibleValue(text="Placenta")
    Thymus = PermissibleValue(text="Thymus",
                                   description="Thymus")
    Penis = PermissibleValue(text="Penis",
                                 description="Penis")
    Vagina = PermissibleValue(text="Vagina",
                                   description="Vagina")
    Gum = PermissibleValue(text="Gum",
                             description="Gingiva")
    Pancreas = PermissibleValue(text="Pancreas",
                                       description="Pancreas")
    Ovary = PermissibleValue(text="Ovary")
    Pylorus = PermissibleValue(text="Pylorus",
                                     description="Pylorus")
    Glottis = PermissibleValue(text="Glottis",
                                     description="Glottis")
    Endometrium = PermissibleValue(text="Endometrium")
    Prepuce = PermissibleValue(text="Prepuce")
    Retina = PermissibleValue(text="Retina",
                                   description="Retina")
    Subglottis = PermissibleValue(text="Subglottis",
                                           description="Subglottis")
    Liver = PermissibleValue(text="Liver",
                                 description="Liver")
    Myometrium = PermissibleValue(text="Myometrium")
    Blood = PermissibleValue(text="Blood",
                                 description="Blood")
    Urachus = PermissibleValue(text="Urachus")
    Cerebrum = PermissibleValue(text="Cerebrum",
                                       description="Cerebral Hemisphere")
    Supraglottis = PermissibleValue(text="Supraglottis",
                                               description="Supraglottis")
    Endocervix = PermissibleValue(text="Endocervix")
    Epididymis = PermissibleValue(text="Epididymis",
                                           description="Epididymis")
    Clitoris = PermissibleValue(text="Clitoris",
                                       description="Clitoris")
    Retroperitoneum = PermissibleValue(text="Retroperitoneum",
                                                     description="Retroperitoneum")
    Heart = PermissibleValue(text="Heart",
                                 description="Heart")
    Spleen = PermissibleValue(text="Spleen",
                                   description="Spleen")
    Vallecula = PermissibleValue(text="Vallecula")
    Appendix = PermissibleValue(text="Appendix",
                                       description="Appendix")
    Eyelid = PermissibleValue(text="Eyelid")
    Ileum = PermissibleValue(text="Ileum",
                                 description="Ileum")
    Cecum = PermissibleValue(text="Cecum",
                                 description="Cecum")
    Urethra = PermissibleValue(text="Urethra",
                                     description="Urethra")
    Nipple = PermissibleValue(text="Nipple")
    Parametrium = PermissibleValue(text="Parametrium")
    Duodenum = PermissibleValue(text="Duodenum",
                                       description="Duodenum")
    Choroid = PermissibleValue(text="Choroid")
    Exocervix = PermissibleValue(text="Exocervix")
    Mandible = PermissibleValue(text="Mandible",
                                       description="Mandible")
    Conjunctiva = PermissibleValue(text="Conjunctiva",
                                             description="Conjunctiva")
    Jejunum = PermissibleValue(text="Jejunum",
                                     description="Jejunum")
    Uvula = PermissibleValue(text="Uvula",
                                 description="Uvula")
    Thyroid = PermissibleValue(text="Thyroid")
    Colorectal = PermissibleValue(text="Colorectal")
    Cervix = PermissibleValue(text="Cervix",
                                   description="Cervix")
    Pleura = PermissibleValue(text="Pleura",
                                   description="Pleura")
    Bone = PermissibleValue(text="Bone",
                               description="Bone")
    Eye = PermissibleValue(text="Eye",
                             description="Eye")
    Prostate = PermissibleValue(text="Prostate",
                                       description="Prostate")
    Lung = PermissibleValue(text="Lung",
                               description="Lung")
    Uterus = PermissibleValue(text="Uterus",
                                   description="Uterus")
    Scalp = PermissibleValue(text="Scalp",
                                 description="Scalp")
    Aorta = PermissibleValue(text="Aorta",
                                 description="Aorta")
    Thigh = PermissibleValue(text="Thigh",
                                 description="Thigh")
    Buttock = PermissibleValue(text="Buttock",
                                     description="Buttock")
    Nerve = PermissibleValue(text="Nerve",
                                 description="nerve")
    Bronchiole = PermissibleValue(text="Bronchiole",
                                           description="Bronchiole")
    Pericardium = PermissibleValue(text="Pericardium",
                                             description="Pericardium")
    Mediastinum = PermissibleValue(text="Mediastinum",
                                             description="Mediastinum")
    Ischium = PermissibleValue(text="Ischium",
                                     description="Ischium")
    Cartilage = PermissibleValue(text="Cartilage",
                                         description="Cartilage")
    Chest = PermissibleValue(text="Chest",
                                 description="Chest")
    Femur = PermissibleValue(text="Femur",
                                 description="Femur")
    Pelvis = PermissibleValue(text="Pelvis",
                                   description="Pelvis")
    Maxilla = PermissibleValue(text="Maxilla",
                                     description="Maxilla")
    Acetabulum = PermissibleValue(text="Acetabulum",
                                           description="Acetabulum")
    Ligament = PermissibleValue(text="Ligament",
                                       description="Ligament")
    Artery = PermissibleValue(text="Artery",
                                   description="Artery")
    Foot = PermissibleValue(text="Foot",
                               description="Foot")
    Thorax = PermissibleValue(text="Thorax",
                                   description="Thorax")
    Joint = PermissibleValue(text="Joint")
    Hippocampus = PermissibleValue(text="Hippocampus")
    Bowel = PermissibleValue(text="Bowel",
                                 description="Bowel")
    Adrenal = PermissibleValue(text="Adrenal")
    Chin = PermissibleValue(text="Chin",
                               description="Mentum")
    Anorectum = PermissibleValue(text="Anorectum",
                                         description="Anorectum")
    Patella = PermissibleValue(text="Patella",
                                     description="Patella")
    Mesothelium = PermissibleValue(text="Mesothelium",
                                             description="Mesothelium")
    Bronchus = PermissibleValue(text="Bronchus",
                                       description="Bronchus")
    Adenoid = PermissibleValue(text="Adenoid",
                                     description="Tonsillar Tissue")
    Scapula = PermissibleValue(text="Scapula",
                                     description="Scapula")
    Peritoneum = PermissibleValue(text="Peritoneum",
                                           description="Peritoneum")
    Shoulder = PermissibleValue(text="Shoulder",
                                       description="Shoulder Joint")
    Parathyroid = PermissibleValue(text="Parathyroid",
                                             description="Parathyroid Gland")
    Capillary = PermissibleValue(text="Capillary",
                                         description="Capillary")
    Wrist = PermissibleValue(text="Wrist",
                                 description="Wrist")
    Humerus = PermissibleValue(text="Humerus",
                                     description="Humerus")
    Fibroblasts = PermissibleValue(text="Fibroblasts")
    Throat = PermissibleValue(text="Throat",
                                   description="Throat")
    Thumb = PermissibleValue(text="Thumb")
    Diaphragm = PermissibleValue(text="Diaphragm",
                                         description="Diaphragm")
    Pharynx = PermissibleValue(text="Pharynx",
                                     description="Pharynx")
    Brow = PermissibleValue(text="Brow",
                               description="Eyebrow")
    Hip = PermissibleValue(text="Hip",
                             description="Hip")
    Forehead = PermissibleValue(text="Forehead",
                                       description="Forehead")
    Forearm = PermissibleValue(text="Forearm",
                                     description="Forearm")
    Sternum = PermissibleValue(text="Sternum",
                                     description="Sternum")
    Fibula = PermissibleValue(text="Fibula",
                                   description="Fibula")
    Tibia = PermissibleValue(text="Tibia",
                                 description="Tibia")
    Vein = PermissibleValue(text="Vein",
                               description="Vein")
    Elbow = PermissibleValue(text="Elbow",
                                 description="Elbow Joint")
    Skull = PermissibleValue(text="Skull",
                                 description="Skull")
    Clavicle = PermissibleValue(text="Clavicle",
                                       description="Clavicle")
    Knee = PermissibleValue(text="Knee",
                               description="Knee Joint")
    Omentum = PermissibleValue(text="Omentum",
                                     description="Omentum")
    Other = PermissibleValue(text="Other",
                                 description="Other")
    Trunk = PermissibleValue(text="Trunk",
                                 description="Trunk")
    Synovium = PermissibleValue(text="Synovium",
                                       description="Synovial Membrane")
    Groin = PermissibleValue(text="Groin",
                                 description="Inguinal Region")
    Jaw = PermissibleValue(text="Jaw",
                             description="Jaw")
    Effusion = PermissibleValue(text="Effusion",
                                       description="Effusion")
    Leptomeninges = PermissibleValue(text="Leptomeninges",
                                                 description="Leptomeninges")
    Dermal = PermissibleValue(text="Dermal")
    Scrotum = PermissibleValue(text="Scrotum",
                                     description="Scrotum")
    Mitochondria = PermissibleValue(text="Mitochondria")
    Hepatic = PermissibleValue(text="Hepatic")
    Muscle = PermissibleValue(text="Muscle",
                                   description="Muscle")
    Foreskin = PermissibleValue(text="Foreskin",
                                       description="Male Prepuce")
    Venous = PermissibleValue(text="Venous")
    Mesentery = PermissibleValue(text="Mesentery",
                                         description="Mesentery")
    Pineal = PermissibleValue(text="Pineal")
    Adipose = PermissibleValue(text="Adipose",
                                     description="Adipose Tissue")
    Ganglia = PermissibleValue(text="Ganglia",
                                     description="Ganglion")
    Ear = PermissibleValue(text="Ear",
                             description="Ear")
    Arm = PermissibleValue(text="Arm",
                             description="Arm")
    Laryngopharynx = PermissibleValue(text="Laryngopharynx",
                                                   description="Hypopharynx (Laryngopharynx)")
    Sacrum = PermissibleValue(text="Sacrum",
                                   description="Sacrum")
    Back = PermissibleValue(text="Back",
                               description="Back")
    Rib = PermissibleValue(text="Rib")
    Ankle = PermissibleValue(text="Ankle",
                                 description="Ankle")
    Calf = PermissibleValue(text="Calf",
                               description="Calf")
    Abdomen = PermissibleValue(text="Abdomen",
                                     description="Abdominal Cavity")
    Hand = PermissibleValue(text="Hand",
                               description="Hand")
    Antrum = PermissibleValue(text="Antrum",
                                   description="Antrum Pylori")
    Anus = PermissibleValue(text="Anus",
                               description="Anus")
    Tendon = PermissibleValue(text="Tendon",
                                   description="Tendon")
    Carina = PermissibleValue(text="Carina",
                                   description="Carina")
    Vertebra = PermissibleValue(text="Vertebra",
                                       description="Vertebra")
    Cerebellum = PermissibleValue(text="Cerebellum",
                                           description="Cerebellum")
    Nails = PermissibleValue(text="Nails",
                                 description="Nail")
    Sinus = PermissibleValue(text="Sinus")
    Axilla = PermissibleValue(text="Axilla",
                                   description="Axilla")
    Cardia = PermissibleValue(text="Cardia",
                                   description="Gastric Cardia")
    Leg = PermissibleValue(text="Leg",
                             description="Leg")
    Neck = PermissibleValue(text="Neck",
                               description="Neck")
    Ilium = PermissibleValue(text="Ilium",
                                 description="Ilium")
    Tongue = PermissibleValue(text="Tongue",
                                   description="Tongue")
    Fluid = PermissibleValue(text="Fluid",
                                 description="Body Fluid or Substance")
    Finger = PermissibleValue(text="Finger",
                                   description="Fingers (Phalanges)")

    _defn = EnumDefinition(
        name="EnumCRDCHBodySiteSite",
        description="Autogenerated Enumeration for CRDC-H BodySite site",
        code_set=None,
        code_set_version="2021-09-23T15:59:39.012070+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Eye and adnexa",
                PermissibleValue(text="Eye and adnexa",
                                 description="Adnexa And Eye") )
        setattr(cls, "Rectosigmoid junction",
                PermissibleValue(text="Rectosigmoid junction") )
        setattr(cls, "Other and ill-defined digestive organs",
                PermissibleValue(text="Other and ill-defined digestive organs",
                                 description="Other and ill-defined digestive organs") )
        setattr(cls, "Parotid gland",
                PermissibleValue(text="Parotid gland") )
        setattr(cls, "Peripheral nerves and autonomic nervous system",
                PermissibleValue(text="Peripheral nerves and autonomic nervous system",
                                 description="Peripheral Nerve and Autonomic Nervous System") )
        setattr(cls, "Small intestine",
                PermissibleValue(text="Small intestine",
                                 description="Small Intestine") )
        setattr(cls, "Other and unspecified urinary organs",
                PermissibleValue(text="Other and unspecified urinary organs",
                                 description="Other and unspecified urinary organs") )
        setattr(cls, "Anus and anal canal",
                PermissibleValue(text="Anus and anal canal",
                                 description="Anus and Anal Canal") )
        setattr(cls, "Other and unspecified parts of mouth",
                PermissibleValue(text="Other and unspecified parts of mouth",
                                 description="Other and unspecified parts of mouth") )
        setattr(cls, "Prostate gland",
                PermissibleValue(text="Prostate gland") )
        setattr(cls, "Other endocrine glands and related structures",
                PermissibleValue(text="Other endocrine glands and related structures",
                                 description="Other endocrine glands and related structures") )
        setattr(cls, "Spinal cord, cranial nerves, and other parts of central nervous system",
                PermissibleValue(text="Spinal cord, cranial nerves, and other parts of central nervous system",
                                 description="Spinal Cord Cranial Nerve and Other Central Nervous System") )
        setattr(cls, "Lymph nodes",
                PermissibleValue(text="Lymph nodes",
                                 description="Lymph Node") )
        setattr(cls, "Pyriform sinus",
                PermissibleValue(text="Pyriform sinus") )
        setattr(cls, "Bronchus and lung",
                PermissibleValue(text="Bronchus and lung",
                                 description="Bronchus and Lung") )
        setattr(cls, "Other and unspecified female genital organs",
                PermissibleValue(text="Other and unspecified female genital organs",
                                 description="Other and unspecified female genital organs") )
        setattr(cls, "Uterus, NOS",
                PermissibleValue(text="Uterus, NOS") )
        setattr(cls, "Bones, joints and articular cartilage of other and unspecified sites",
                PermissibleValue(text="Bones, joints and articular cartilage of other and unspecified sites",
                                 description="Bone, Joint ,Articular Cartilage of Other and Unspecified Anatomic Site") )
        setattr(cls, "Retroperitoneum and peritoneum",
                PermissibleValue(text="Retroperitoneum and peritoneum",
                                 description="Retroperitoneum and Peritoneum") )
        setattr(cls, "Accessory sinuses",
                PermissibleValue(text="Accessory sinuses",
                                 description="Paranasal Sinus") )
        setattr(cls, "Liver and intrahepatic bile ducts",
                PermissibleValue(text="Liver and intrahepatic bile ducts",
                                 description="Liver and Intrahepatic Bile Duct") )
        setattr(cls, "Cervix uteri",
                PermissibleValue(text="Cervix uteri") )
        setattr(cls, "Adrenal gland",
                PermissibleValue(text="Adrenal gland",
                                 description="Adrenal Gland") )
        setattr(cls, "Floor of mouth",
                PermissibleValue(text="Floor of mouth") )
        setattr(cls, "Other and unspecified male genital organs",
                PermissibleValue(text="Other and unspecified male genital organs",
                                 description="Other and unspecified male genital organs") )
        setattr(cls, "Nasal cavity and middle ear",
                PermissibleValue(text="Nasal cavity and middle ear",
                                 description="Nasal Cavity and Middle Ear") )
        setattr(cls, "Renal pelvis",
                PermissibleValue(text="Renal pelvis") )
        setattr(cls, "Other and unspecified parts of tongue",
                PermissibleValue(text="Other and unspecified parts of tongue",
                                 description="Other and unspecified parts of tongue") )
        setattr(cls, "Other and ill-defined sites",
                PermissibleValue(text="Other and ill-defined sites",
                                 description="Other and ill-defined sites") )
        setattr(cls, "Thyroid gland",
                PermissibleValue(text="Thyroid gland") )
        setattr(cls, "Corpus uteri",
                PermissibleValue(text="Corpus uteri") )
        setattr(cls, "Hematopoietic and reticuloendothelial systems",
                PermissibleValue(text="Hematopoietic and reticuloendothelial systems",
                                 description="Hematopoietic and Reticuloendothelial System") )
        setattr(cls, "Not Reported",
                PermissibleValue(text="Not Reported") )
        setattr(cls, "Other and unspecified major salivary glands",
                PermissibleValue(text="Other and unspecified major salivary glands",
                                 description="Other and unspecified major salivary glands") )
        setattr(cls, "Other and ill-defined sites within respiratory system and intrathoracic organs",
                PermissibleValue(text="Other and ill-defined sites within respiratory system and intrathoracic organs",
                                 description="Other and ill-defined sites within respiratory system and intrathoracic organs") )
        setattr(cls, "Other and ill-defined sites in lip, oral cavity and pharynx",
                PermissibleValue(text="Other and ill-defined sites in lip, oral cavity and pharynx",
                                 description="Other and ill-defined sites in lip, oral cavity and pharynx") )
        setattr(cls, "Connective, subcutaneous and other soft tissues",
                PermissibleValue(text="Connective, subcutaneous and other soft tissues",
                                 description="Connective, Subcutaneous and Other Soft Tissue") )
        setattr(cls, "Base of tongue",
                PermissibleValue(text="Base of tongue",
                                 description="Base of the Tongue") )
        setattr(cls, "Other and unspecified parts of biliary tract",
                PermissibleValue(text="Other and unspecified parts of biliary tract",
                                 description="Other and unspecified parts of biliary tract") )
        setattr(cls, "Heart, mediastinum, and pleura",
                PermissibleValue(text="Heart, mediastinum, and pleura",
                                 description="Heart, Mediastinum and Pleura") )
        setattr(cls, "Bones, joints and articular cartilage of limbs",
                PermissibleValue(text="Bones, joints and articular cartilage of limbs",
                                 description="Bone, Joint, Articular Cartilage of Limb") )
        setattr(cls, "Connective, subcutaneous and other soft tissues of thorax",
                PermissibleValue(text="Connective, subcutaneous and other soft tissues of thorax") )
        setattr(cls, "External lip, NOS",
                PermissibleValue(text="External lip, NOS") )
        setattr(cls, "Other ill-defined sites",
                PermissibleValue(text="Other ill-defined sites") )
        setattr(cls, "Posterior wall of hypopharynx",
                PermissibleValue(text="Posterior wall of hypopharynx") )
        setattr(cls, "Branchial cleft",
                PermissibleValue(text="Branchial cleft") )
        setattr(cls, "Skin of trunk",
                PermissibleValue(text="Skin of trunk") )
        setattr(cls, "Cortex of adrenal gland",
                PermissibleValue(text="Cortex of adrenal gland") )
        setattr(cls, "Intrathoracic lymph nodes",
                PermissibleValue(text="Intrathoracic lymph nodes") )
        setattr(cls, "Ampulla of Vater",
                PermissibleValue(text="Ampulla of Vater") )
        setattr(cls, "Olfactory nerve",
                PermissibleValue(text="Olfactory nerve") )
        setattr(cls, "Lateral wall of bladder",
                PermissibleValue(text="Lateral wall of bladder") )
        setattr(cls, "Anterior 2/3 of tongue, NOS",
                PermissibleValue(text="Anterior 2/3 of tongue, NOS") )
        setattr(cls, "Peripheral nerves and autonomic nervous system of upper limb and shoulder",
                PermissibleValue(text="Peripheral nerves and autonomic nervous system of upper limb and shoulder") )
        setattr(cls, "Overlapping lesion of accessory sinuses",
                PermissibleValue(text="Overlapping lesion of accessory sinuses") )
        setattr(cls, "Anterior mediastinum",
                PermissibleValue(text="Anterior mediastinum") )
        setattr(cls, "Cardia, NOS",
                PermissibleValue(text="Cardia, NOS") )
        setattr(cls, "Lymph nodes of multiple regions",
                PermissibleValue(text="Lymph nodes of multiple regions") )
        setattr(cls, "Ethmoid sinus",
                PermissibleValue(text="Ethmoid sinus") )
        setattr(cls, "Rectum, NOS",
                PermissibleValue(text="Rectum, NOS") )
        setattr(cls, "Overlapping lesion of other and unspecified parts of mouth",
                PermissibleValue(text="Overlapping lesion of other and unspecified parts of mouth") )
        setattr(cls, "Frontal lobe",
                PermissibleValue(text="Frontal lobe") )
        setattr(cls, "Colon, NOS",
                PermissibleValue(text="Colon, NOS") )
        setattr(cls, "Occipital lobe",
                PermissibleValue(text="Occipital lobe") )
        setattr(cls, "Upper limb, NOS",
                PermissibleValue(text="Upper limb, NOS") )
        setattr(cls, "Anus, NOS",
                PermissibleValue(text="Anus, NOS") )
        setattr(cls, "Cornea, NOS",
                PermissibleValue(text="Cornea, NOS") )
        setattr(cls, "Upper gum",
                PermissibleValue(text="Upper gum") )
        setattr(cls, "Peripheral nerves and autonomic nervous system of pelvis",
                PermissibleValue(text="Peripheral nerves and autonomic nervous system of pelvis") )
        setattr(cls, "Retromolar area",
                PermissibleValue(text="Retromolar area") )
        setattr(cls, "Bladder, NOS",
                PermissibleValue(text="Bladder, NOS") )
        setattr(cls, "Skin of upper limb and shoulder",
                PermissibleValue(text="Skin of upper limb and shoulder") )
        setattr(cls, "Spermatic cord",
                PermissibleValue(text="Spermatic cord") )
        setattr(cls, "Lateral floor of mouth",
                PermissibleValue(text="Lateral floor of mouth") )
        setattr(cls, "Skin of lower limb and hip",
                PermissibleValue(text="Skin of lower limb and hip") )
        setattr(cls, "Ascending colon",
                PermissibleValue(text="Ascending colon") )
        setattr(cls, "Other specified parts of pancreas",
                PermissibleValue(text="Other specified parts of pancreas") )
        setattr(cls, "Endocrine gland, NOS",
                PermissibleValue(text="Endocrine gland, NOS") )
        setattr(cls, "Uterine adnexa",
                PermissibleValue(text="Uterine adnexa") )
        setattr(cls, "Brain stem",
                PermissibleValue(text="Brain stem") )
        setattr(cls, "Overlapping lesion of rectum, anus and anal canal",
                PermissibleValue(text="Overlapping lesion of rectum, anus and anal canal") )
        setattr(cls, "Overlapping lesion of breast",
                PermissibleValue(text="Overlapping lesion of breast") )
        setattr(cls, "Trigone of bladder",
                PermissibleValue(text="Trigone of bladder") )
        setattr(cls, "Laryngeal cartilage",
                PermissibleValue(text="Laryngeal cartilage") )
        setattr(cls, "Cauda equina",
                PermissibleValue(text="Cauda equina") )
        setattr(cls, "Brain, NOS",
                PermissibleValue(text="Brain, NOS") )
        setattr(cls, "Glans penis",
                PermissibleValue(text="Glans penis") )
        setattr(cls, "Head of pancreas",
                PermissibleValue(text="Head of pancreas") )
        setattr(cls, "Overlapping lesion of stomach",
                PermissibleValue(text="Overlapping lesion of stomach") )
        setattr(cls, "Overlapping lesion of colon",
                PermissibleValue(text="Overlapping lesion of colon") )
        setattr(cls, "Isthmus uteri",
                PermissibleValue(text="Isthmus uteri") )
        setattr(cls, "Overlapping lesion of heart, mediastinum and pleura",
                PermissibleValue(text="Overlapping lesion of heart, mediastinum and pleura") )
        setattr(cls, "External upper lip",
                PermissibleValue(text="External upper lip") )
        setattr(cls, "Sphenoid sinus",
                PermissibleValue(text="Sphenoid sinus") )
        setattr(cls, "Islets of Langerhans",
                PermissibleValue(text="Islets of Langerhans") )
        setattr(cls, "Gastrointestinal tract, NOS",
                PermissibleValue(text="Gastrointestinal tract, NOS") )
        setattr(cls, "Lower gum",
                PermissibleValue(text="Lower gum") )
        setattr(cls, "Sigmoid colon",
                PermissibleValue(text="Sigmoid colon") )
        setattr(cls, "Overlapping lesion of peripheral nerves and autonomic nervous system",
                PermissibleValue(text="Overlapping lesion of peripheral nerves and autonomic nervous system") )
        setattr(cls, "Nervous system, NOS",
                PermissibleValue(text="Nervous system, NOS") )
        setattr(cls, "Posterior mediastinum",
                PermissibleValue(text="Posterior mediastinum") )
        setattr(cls, "Upper-outer quadrant of breast",
                PermissibleValue(text="Upper-outer quadrant of breast") )
        setattr(cls, "Ciliary body",
                PermissibleValue(text="Ciliary body") )
        setattr(cls, "Descended testis",
                PermissibleValue(text="Descended testis") )
        setattr(cls, "Overlapping lesion of retroperitoneum and peritoneum",
                PermissibleValue(text="Overlapping lesion of retroperitoneum and peritoneum") )
        setattr(cls, "Accessory sinus, NOS",
                PermissibleValue(text="Accessory sinus, NOS") )
        setattr(cls, "Superior wall of nasopharynx",
                PermissibleValue(text="Superior wall of nasopharynx") )
        setattr(cls, "Long bones of lower limb and associated joints",
                PermissibleValue(text="Long bones of lower limb and associated joints") )
        setattr(cls, "Meninges, NOS",
                PermissibleValue(text="Meninges, NOS") )
        setattr(cls, "Pineal gland",
                PermissibleValue(text="Pineal gland") )
        setattr(cls, "Anterior wall of nasopharynx",
                PermissibleValue(text="Anterior wall of nasopharynx") )
        setattr(cls, "Paraurethral gland",
                PermissibleValue(text="Paraurethral gland") )
        setattr(cls, "Fundus of stomach",
                PermissibleValue(text="Fundus of stomach") )
        setattr(cls, "Connective, subcutaneous and other soft tissues of trunk, NOS",
                PermissibleValue(text="Connective, subcutaneous and other soft tissues of trunk, NOS") )
        setattr(cls, "Overlapping lesion of lip, oral cavity and pharynx",
                PermissibleValue(text="Overlapping lesion of lip, oral cavity and pharynx") )
        setattr(cls, "Stomach, NOS",
                PermissibleValue(text="Stomach, NOS") )
        setattr(cls, "Overlapping lesion of esophagus",
                PermissibleValue(text="Overlapping lesion of esophagus") )
        setattr(cls, "Pharynx, NOS",
                PermissibleValue(text="Pharynx, NOS") )
        setattr(cls, "Short bones of upper limb and associated joints",
                PermissibleValue(text="Short bones of upper limb and associated joints") )
        setattr(cls, "Testis, NOS",
                PermissibleValue(text="Testis, NOS") )
        setattr(cls, "Thoracic esophagus",
                PermissibleValue(text="Thoracic esophagus") )
        setattr(cls, "Spinal cord",
                PermissibleValue(text="Spinal cord") )
        setattr(cls, "Mouth, NOS",
                PermissibleValue(text="Mouth, NOS") )
        setattr(cls, "Lip, NOS",
                PermissibleValue(text="Lip, NOS") )
        setattr(cls, "Penis, NOS",
                PermissibleValue(text="Penis, NOS") )
        setattr(cls, "Fallopian tube",
                PermissibleValue(text="Fallopian tube") )
        setattr(cls, "Extrahepatic bile duct",
                PermissibleValue(text="Extrahepatic bile duct") )
        setattr(cls, "Pelvic lymph nodes",
                PermissibleValue(text="Pelvic lymph nodes") )
        setattr(cls, "Vertebral column",
                PermissibleValue(text="Vertebral column") )
        setattr(cls, "Pancreas, NOS",
                PermissibleValue(text="Pancreas, NOS") )
        setattr(cls, "Reticuloendothelial system, NOS",
                PermissibleValue(text="Reticuloendothelial system, NOS") )
        setattr(cls, "Submandibular gland",
                PermissibleValue(text="Submandibular gland") )
        setattr(cls, "Esophagus, NOS",
                PermissibleValue(text="Esophagus, NOS") )
        setattr(cls, "Mucosa of lip, NOS",
                PermissibleValue(text="Mucosa of lip, NOS") )
        setattr(cls, "Overlapping lesion of endocrine glands and related structures",
                PermissibleValue(text="Overlapping lesion of endocrine glands and related structures") )
        setattr(cls, "Overlapping lesion of female genital organs",
                PermissibleValue(text="Overlapping lesion of female genital organs") )
        setattr(cls, "Oropharynx, NOS",
                PermissibleValue(text="Oropharynx, NOS") )
        setattr(cls, "Body of stomach",
                PermissibleValue(text="Body of stomach") )
        setattr(cls, "Hard palate",
                PermissibleValue(text="Hard palate") )
        setattr(cls, "Peripheral nerves and autonomic nervous system of thorax",
                PermissibleValue(text="Peripheral nerves and autonomic nervous system of thorax") )
        setattr(cls, "Overlapping lesion of larynx",
                PermissibleValue(text="Overlapping lesion of larynx") )
        setattr(cls, "Ill-defined sites within respiratory system",
                PermissibleValue(text="Ill-defined sites within respiratory system") )
        setattr(cls, "Male genital organs, NOS",
                PermissibleValue(text="Male genital organs, NOS") )
        setattr(cls, "Labium majus",
                PermissibleValue(text="Labium majus") )
        setattr(cls, "Short bones of lower limb and associated joints",
                PermissibleValue(text="Short bones of lower limb and associated joints") )
        setattr(cls, "Bone of limb, NOS",
                PermissibleValue(text="Bone of limb, NOS") )
        setattr(cls, "Overlapping lesion of brain and central nervous system",
                PermissibleValue(text="Overlapping lesion of brain and central nervous system") )
        setattr(cls, "Overlapping lesion of connective, subcutaneous and other soft tissues",
                PermissibleValue(text="Overlapping lesion of connective, subcutaneous and other soft tissues") )
        setattr(cls, "Descending colon",
                PermissibleValue(text="Descending colon") )
        setattr(cls, "Vestibule of mouth",
                PermissibleValue(text="Vestibule of mouth") )
        setattr(cls, "Pleura, NOS",
                PermissibleValue(text="Pleura, NOS") )
        setattr(cls, "Lymph nodes of axilla or arm",
                PermissibleValue(text="Lymph nodes of axilla or arm") )
        setattr(cls, "Meckel diverticulum",
                PermissibleValue(text="Meckel diverticulum") )
        setattr(cls, "Overlapping lesion of nasopharynx",
                PermissibleValue(text="Overlapping lesion of nasopharynx") )
        setattr(cls, "Lymph nodes of head, face and neck",
                PermissibleValue(text="Lymph nodes of head, face and neck") )
        setattr(cls, "External ear",
                PermissibleValue(text="External ear") )
        setattr(cls, "Maxillary sinus",
                PermissibleValue(text="Maxillary sinus") )
        setattr(cls, "Tonsillar fossa",
                PermissibleValue(text="Tonsillar fossa") )
        setattr(cls, "Undescended testis",
                PermissibleValue(text="Undescended testis") )
        setattr(cls, "Transverse colon",
                PermissibleValue(text="Transverse colon") )
        setattr(cls, "Ventral surface of tongue, NOS",
                PermissibleValue(text="Ventral surface of tongue, NOS") )
        setattr(cls, "Hypopharynx, NOS",
                PermissibleValue(text="Hypopharynx, NOS") )
        setattr(cls, "Overlapping lesion of bladder",
                PermissibleValue(text="Overlapping lesion of bladder") )
        setattr(cls, "Fundus uteri",
                PermissibleValue(text="Fundus uteri") )
        setattr(cls, "Overlapping lesion of eye and adnexa",
                PermissibleValue(text="Overlapping lesion of eye and adnexa") )
        setattr(cls, "Long bones of upper limb, scapula and associated joints",
                PermissibleValue(text="Long bones of upper limb, scapula and associated joints") )
        setattr(cls, "Craniopharyngeal duct",
                PermissibleValue(text="Craniopharyngeal duct") )
        setattr(cls, "Soft palate, NOS",
                PermissibleValue(text="Soft palate, NOS") )
        setattr(cls, "Posterior wall of nasopharynx",
                PermissibleValue(text="Posterior wall of nasopharynx") )
        setattr(cls, "Hepatic flexure of colon",
                PermissibleValue(text="Hepatic flexure of colon") )
        setattr(cls, "Upper-inner quadrant of breast",
                PermissibleValue(text="Upper-inner quadrant of breast") )
        setattr(cls, "Gum, NOS",
                PermissibleValue(text="Gum, NOS") )
        setattr(cls, "Acoustic nerve",
                PermissibleValue(text="Acoustic nerve") )
        setattr(cls, "Temporal lobe",
                PermissibleValue(text="Temporal lobe") )
        setattr(cls, "Skin of scalp and neck",
                PermissibleValue(text="Skin of scalp and neck") )
        setattr(cls, "Larynx, NOS",
                PermissibleValue(text="Larynx, NOS") )
        setattr(cls, "Commissure of lip",
                PermissibleValue(text="Commissure of lip") )
        setattr(cls, "Middle lobe, lung",
                PermissibleValue(text="Middle lobe, lung") )
        setattr(cls, "Postcricoid region",
                PermissibleValue(text="Postcricoid region") )
        setattr(cls, "Broad ligament",
                PermissibleValue(text="Broad ligament") )
        setattr(cls, "Overlapping lesion of ill-defined sites",
                PermissibleValue(text="Overlapping lesion of ill-defined sites") )
        setattr(cls, "Intestinal tract, NOS",
                PermissibleValue(text="Intestinal tract, NOS") )
        setattr(cls, "Urinary system, NOS",
                PermissibleValue(text="Urinary system, NOS") )
        setattr(cls, "Aortic body and other paraganglia",
                PermissibleValue(text="Aortic body and other paraganglia") )
        setattr(cls, "Body of pancreas",
                PermissibleValue(text="Body of pancreas") )
        setattr(cls, "Overlapping lesion of bones, joints and articular cartilage",
                PermissibleValue(text="Overlapping lesion of bones, joints and articular cartilage") )
        setattr(cls, "Rib, sternum, clavicle and associated joints",
                PermissibleValue(text="Rib, sternum, clavicle and associated joints") )
        setattr(cls, "Bones of skull and face and associated joints",
                PermissibleValue(text="Bones of skull and face and associated joints") )
        setattr(cls, "Pancreatic duct",
                PermissibleValue(text="Pancreatic duct") )
        setattr(cls, "Body of penis",
                PermissibleValue(text="Body of penis") )
        setattr(cls, "Border of tongue",
                PermissibleValue(text="Border of tongue") )
        setattr(cls, "Central portion of breast",
                PermissibleValue(text="Central portion of breast") )
        setattr(cls, "Dorsal surface of tongue, NOS",
                PermissibleValue(text="Dorsal surface of tongue, NOS") )
        setattr(cls, "Overlapping lesion of biliary tract",
                PermissibleValue(text="Overlapping lesion of biliary tract") )
        setattr(cls, "Lesser curvature of stomach, NOS",
                PermissibleValue(text="Lesser curvature of stomach, NOS") )
        setattr(cls, "Ventricle, NOS",
                PermissibleValue(text="Ventricle, NOS") )
        setattr(cls, "Hypopharyngeal aspect of aryepiglottic fold",
                PermissibleValue(text="Hypopharyngeal aspect of aryepiglottic fold") )
        setattr(cls, "Vulva, NOS",
                PermissibleValue(text="Vulva, NOS") )
        setattr(cls, "Abdominal esophagus",
                PermissibleValue(text="Abdominal esophagus") )
        setattr(cls, "Peripheral nerves and autonomic nervous system of lower limb and hip",
                PermissibleValue(text="Peripheral nerves and autonomic nervous system of lower limb and hip") )
        setattr(cls, "Tonsillar pillar",
                PermissibleValue(text="Tonsillar pillar") )
        setattr(cls, "Upper third of esophagus",
                PermissibleValue(text="Upper third of esophagus") )
        setattr(cls, "Main bronchus",
                PermissibleValue(text="Main bronchus") )
        setattr(cls, "Cerebellum, NOS",
                PermissibleValue(text="Cerebellum, NOS") )
        setattr(cls, "Vagina, NOS",
                PermissibleValue(text="Vagina, NOS") )
        setattr(cls, "Upper lobe, lung",
                PermissibleValue(text="Upper lobe, lung") )
        setattr(cls, "Lacrimal gland",
                PermissibleValue(text="Lacrimal gland") )
        setattr(cls, "Parietal lobe",
                PermissibleValue(text="Parietal lobe") )
        setattr(cls, "Connective, subcutaneous and other soft tissues, NOS",
                PermissibleValue(text="Connective, subcutaneous and other soft tissues, NOS") )
        setattr(cls, "Axillary tail of breast",
                PermissibleValue(text="Axillary tail of breast") )
        setattr(cls, "Connective, subcutaneous and other soft tissues of abdomen",
                PermissibleValue(text="Connective, subcutaneous and other soft tissues of abdomen") )
        setattr(cls, "Connective, subcutaneous and other soft tissues of pelvis",
                PermissibleValue(text="Connective, subcutaneous and other soft tissues of pelvis") )
        setattr(cls, "Cheek mucosa",
                PermissibleValue(text="Cheek mucosa") )
        setattr(cls, "Lateral wall of nasopharynx",
                PermissibleValue(text="Lateral wall of nasopharynx") )
        setattr(cls, "Breast, NOS",
                PermissibleValue(text="Breast, NOS") )
        setattr(cls, "Ureteric orifice",
                PermissibleValue(text="Ureteric orifice") )
        setattr(cls, "Other specified parts of female genital organs",
                PermissibleValue(text="Other specified parts of female genital organs") )
        setattr(cls, "Overlapping lesion of brain",
                PermissibleValue(text="Overlapping lesion of brain") )
        setattr(cls, "Medulla of adrenal gland",
                PermissibleValue(text="Medulla of adrenal gland") )
        setattr(cls, "Bladder neck",
                PermissibleValue(text="Bladder neck") )
        setattr(cls, "Overlapping lesion of male genital organs",
                PermissibleValue(text="Overlapping lesion of male genital organs") )
        setattr(cls, "Dome of bladder",
                PermissibleValue(text="Dome of bladder") )
        setattr(cls, "Peripheral nerves and autonomic nervous system of trunk, NOS",
                PermissibleValue(text="Peripheral nerves and autonomic nervous system of trunk, NOS") )
        setattr(cls, "Peripheral nerves and autonomic nervous system of head, face, and neck",
                PermissibleValue(text="Peripheral nerves and autonomic nervous system of head, face, and neck") )
        setattr(cls, "Skin of lip, NOS",
                PermissibleValue(text="Skin of lip, NOS") )
        setattr(cls, "Spinal meninges",
                PermissibleValue(text="Spinal meninges") )
        setattr(cls, "Bone marrow",
                PermissibleValue(text="Bone marrow") )
        setattr(cls, "Overlapping lesions of oropharynx",
                PermissibleValue(text="Overlapping lesions of oropharynx") )
        setattr(cls, "Adrenal gland, NOS",
                PermissibleValue(text="Adrenal gland, NOS") )
        setattr(cls, "Floor of mouth, NOS",
                PermissibleValue(text="Floor of mouth, NOS") )
        setattr(cls, "Biliary tract, NOS",
                PermissibleValue(text="Biliary tract, NOS") )
        setattr(cls, "Small intestine, NOS",
                PermissibleValue(text="Small intestine, NOS") )
        setattr(cls, "Overlapping lesion of digestive system",
                PermissibleValue(text="Overlapping lesion of digestive system") )
        setattr(cls, "Sublingual gland",
                PermissibleValue(text="Sublingual gland") )
        setattr(cls, "Lymph node, NOS",
                PermissibleValue(text="Lymph node, NOS") )
        setattr(cls, "Head, face or neck, NOS",
                PermissibleValue(text="Head, face or neck, NOS") )
        setattr(cls, "Overlapping lesion of penis",
                PermissibleValue(text="Overlapping lesion of penis") )
        setattr(cls, "Nasopharynx, NOS",
                PermissibleValue(text="Nasopharynx, NOS") )
        setattr(cls, "Autonomic nervous system, NOS",
                PermissibleValue(text="Autonomic nervous system, NOS") )
        setattr(cls, "Bone, NOS",
                PermissibleValue(text="Bone, NOS") )
        setattr(cls, "Peritoneum, NOS",
                PermissibleValue(text="Peritoneum, NOS") )
        setattr(cls, "Overlapping lesion of pancreas",
                PermissibleValue(text="Overlapping lesion of pancreas") )
        setattr(cls, "Overlapping lesion of palate",
                PermissibleValue(text="Overlapping lesion of palate") )
        setattr(cls, "Greater curvature of stomach, NOS",
                PermissibleValue(text="Greater curvature of stomach, NOS") )
        setattr(cls, "Posterior wall of oropharynx",
                PermissibleValue(text="Posterior wall of oropharynx") )
        setattr(cls, "Connective, subcutaneous and other soft tissues of head, face, and neck",
                PermissibleValue(text="Connective, subcutaneous and other soft tissues of head, face, and neck") )
        setattr(cls, "Overlapping lesion of vulva",
                PermissibleValue(text="Overlapping lesion of vulva") )
        setattr(cls, "Overlapping lesion of lung",
                PermissibleValue(text="Overlapping lesion of lung") )
        setattr(cls, "Pelvic bones, sacrum, coccyx and associated joints",
                PermissibleValue(text="Pelvic bones, sacrum, coccyx and associated joints") )
        setattr(cls, "Other specified parts of male genital organs",
                PermissibleValue(text="Other specified parts of male genital organs") )
        setattr(cls, "Base of tongue, NOS",
                PermissibleValue(text="Base of tongue, NOS") )
        setattr(cls, "Eye, NOS",
                PermissibleValue(text="Eye, NOS") )
        setattr(cls, "Cerebral meninges",
                PermissibleValue(text="Cerebral meninges") )
        setattr(cls, "Upper respiratory tract, NOS",
                PermissibleValue(text="Upper respiratory tract, NOS") )
        setattr(cls, "Peripheral nerves and autonomic nervous system of abdomen",
                PermissibleValue(text="Peripheral nerves and autonomic nervous system of abdomen") )
        setattr(cls, "Cranial nerve, NOS",
                PermissibleValue(text="Cranial nerve, NOS") )
        setattr(cls, "Connective, subcutaneous and other soft tissues of lower limb and hip",
                PermissibleValue(text="Connective, subcutaneous and other soft tissues of lower limb and hip") )
        setattr(cls, "Overlapping lesion of respiratory system and intrathoracic organs",
                PermissibleValue(text="Overlapping lesion of respiratory system and intrathoracic organs") )
        setattr(cls, "Hematopoietic system, NOS",
                PermissibleValue(text="Hematopoietic system, NOS") )
        setattr(cls, "Major salivary gland, NOS",
                PermissibleValue(text="Major salivary gland, NOS") )
        setattr(cls, "Lower third of esophagus",
                PermissibleValue(text="Lower third of esophagus") )
        setattr(cls, "Anterior surface of epiglottis",
                PermissibleValue(text="Anterior surface of epiglottis") )
        setattr(cls, "Tonsil, NOS",
                PermissibleValue(text="Tonsil, NOS") )
        setattr(cls, "Overlapping lesion of hypopharynx",
                PermissibleValue(text="Overlapping lesion of hypopharynx") )
        setattr(cls, "Round ligament",
                PermissibleValue(text="Round ligament") )
        setattr(cls, "Overlapping lesion of tongue",
                PermissibleValue(text="Overlapping lesion of tongue") )
        setattr(cls, "Connective, subcutaneous and other soft tissues of upper limb and shoulder",
                PermissibleValue(text="Connective, subcutaneous and other soft tissues of upper limb and shoulder") )
        setattr(cls, "Skin, NOS",
                PermissibleValue(text="Skin, NOS") )
        setattr(cls, "Overlapping lesion of skin",
                PermissibleValue(text="Overlapping lesion of skin") )
        setattr(cls, "Lung, NOS",
                PermissibleValue(text="Lung, NOS") )
        setattr(cls, "Overlapping lesion of major salivary glands",
                PermissibleValue(text="Overlapping lesion of major salivary glands") )
        setattr(cls, "Overlapping lesion of small intestine",
                PermissibleValue(text="Overlapping lesion of small intestine") )
        setattr(cls, "External lower lip",
                PermissibleValue(text="External lower lip") )
        setattr(cls, "Overlapping lesion of corpus uteri",
                PermissibleValue(text="Overlapping lesion of corpus uteri") )
        setattr(cls, "Anal canal",
                PermissibleValue(text="Anal canal") )
        setattr(cls, "Cloacogenic zone",
                PermissibleValue(text="Cloacogenic zone") )
        setattr(cls, "Middle third of esophagus",
                PermissibleValue(text="Middle third of esophagus") )
        setattr(cls, "Kidney, NOS",
                PermissibleValue(text="Kidney, NOS") )
        setattr(cls, "Intra-abdominal lymph nodes",
                PermissibleValue(text="Intra-abdominal lymph nodes") )
        setattr(cls, "Optic nerve",
                PermissibleValue(text="Optic nerve") )
        setattr(cls, "Overlapping lesion of bones, joints and articular cartilage of limbs",
                PermissibleValue(text="Overlapping lesion of bones, joints and articular cartilage of limbs") )
        setattr(cls, "Cervical esophagus",
                PermissibleValue(text="Cervical esophagus") )
        setattr(cls, "Anterior wall of bladder",
                PermissibleValue(text="Anterior wall of bladder") )
        setattr(cls, "Abdomen, NOS",
                PermissibleValue(text="Abdomen, NOS") )
        setattr(cls, "Tongue, NOS",
                PermissibleValue(text="Tongue, NOS") )
        setattr(cls, "Overlapping lesion of tonsil",
                PermissibleValue(text="Overlapping lesion of tonsil") )
        setattr(cls, "Specified parts of peritoneum",
                PermissibleValue(text="Specified parts of peritoneum") )
        setattr(cls, "Overlapping lesion of urinary organs",
                PermissibleValue(text="Overlapping lesion of urinary organs") )
        setattr(cls, "Mucosa of upper lip",
                PermissibleValue(text="Mucosa of upper lip") )
        setattr(cls, "Splenic flexure of colon",
                PermissibleValue(text="Splenic flexure of colon") )
        setattr(cls, "Frontal sinus",
                PermissibleValue(text="Frontal sinus") )
        setattr(cls, "Overlapping lesion of floor of mouth",
                PermissibleValue(text="Overlapping lesion of floor of mouth") )
        setattr(cls, "Skin of other and unspecified parts of face",
                PermissibleValue(text="Skin of other and unspecified parts of face") )
        setattr(cls, "Lower lobe, lung",
                PermissibleValue(text="Lower lobe, lung") )
        setattr(cls, "Palate, NOS",
                PermissibleValue(text="Palate, NOS") )
        setattr(cls, "Posterior wall of bladder",
                PermissibleValue(text="Posterior wall of bladder") )
        setattr(cls, "Gastric antrum",
                PermissibleValue(text="Gastric antrum") )
        setattr(cls, "Lower-outer quadrant of breast",
                PermissibleValue(text="Lower-outer quadrant of breast") )
        setattr(cls, "Anterior floor of mouth",
                PermissibleValue(text="Anterior floor of mouth") )
        setattr(cls, "Labium minus",
                PermissibleValue(text="Labium minus") )
        setattr(cls, "Pelvis, NOS",
                PermissibleValue(text="Pelvis, NOS") )
        setattr(cls, "Mediastinum, NOS",
                PermissibleValue(text="Mediastinum, NOS") )
        setattr(cls, "Thorax, NOS",
                PermissibleValue(text="Thorax, NOS") )
        setattr(cls, "Middle ear",
                PermissibleValue(text="Middle ear") )
        setattr(cls, "Lower-inner quadrant of breast",
                PermissibleValue(text="Lower-inner quadrant of breast") )
        setattr(cls, "Waldeyer ring",
                PermissibleValue(text="Waldeyer ring") )
        setattr(cls, "Scrotum, NOS",
                PermissibleValue(text="Scrotum, NOS") )
        setattr(cls, "Lymph nodes of inguinal region or leg",
                PermissibleValue(text="Lymph nodes of inguinal region or leg") )
        setattr(cls, "Mucosa of lower lip",
                PermissibleValue(text="Mucosa of lower lip") )
        setattr(cls, "Overlapping lesion of cervix uteri",
                PermissibleValue(text="Overlapping lesion of cervix uteri") )
        setattr(cls, "Overlapping lesion of lip",
                PermissibleValue(text="Overlapping lesion of lip") )
        setattr(cls, "Female genital tract, NOS",
                PermissibleValue(text="Female genital tract, NOS") )
        setattr(cls, "Parathyroid gland",
                PermissibleValue(text="Parathyroid gland") )
        setattr(cls, "Pituitary gland",
                PermissibleValue(text="Pituitary gland") )
        setattr(cls, "Lateral wall of oropharynx",
                PermissibleValue(text="Lateral wall of oropharynx") )
        setattr(cls, "Intrahepatic bile duct",
                PermissibleValue(text="Intrahepatic bile duct") )
        setattr(cls, "Tail of pancreas",
                PermissibleValue(text="Tail of pancreas") )
        setattr(cls, "Nasal cavity",
                PermissibleValue(text="Nasal cavity") )
        setattr(cls, "Orbit, NOS",
                PermissibleValue(text="Orbit, NOS") )
        setattr(cls, "Unknown primary site",
                PermissibleValue(text="Unknown primary site") )
        setattr(cls, "Lingual tonsil",
                PermissibleValue(text="Lingual tonsil") )
        setattr(cls, "Carotid body",
                PermissibleValue(text="Carotid body") )
        setattr(cls, "Lower limb, NOS",
                PermissibleValue(text="Lower limb, NOS") )
        setattr(cls, "Pancreatic neck",
                PermissibleValue(text="Pancreatic neck") )
        setattr(cls, "Not Applicable",
                PermissibleValue(text="Not Applicable") )
        setattr(cls, "Nervous System",
                PermissibleValue(text="Nervous System") )
        setattr(cls, "Soft Tissue",
                PermissibleValue(text="Soft Tissue",
                                 description="Soft tissue") )
        setattr(cls, "Bile Duct",
                PermissibleValue(text="Bile Duct") )
        setattr(cls, "Head and Neck",
                PermissibleValue(text="Head and Neck") )
        setattr(cls, "Bone Marrow",
                PermissibleValue(text="Bone Marrow") )
        setattr(cls, "Lymph Nodes",
                PermissibleValue(text="Lymph Nodes") )
        setattr(cls, "Adrenal Gland",
                PermissibleValue(text="Adrenal Gland") )
        setattr(cls, "Lymph Node(s) Axilla",
                PermissibleValue(text="Lymph Node(s) Axilla",
                                 description="Axillary Lymph Node") )
        setattr(cls, "Ascending Colon",
                PermissibleValue(text="Ascending Colon") )
        setattr(cls, "Lymph Node",
                PermissibleValue(text="Lymph Node") )
        setattr(cls, "Fallopian Tube",
                PermissibleValue(text="Fallopian Tube") )
        setattr(cls, "Lymph Node(s) Inguinal",
                PermissibleValue(text="Lymph Node(s) Inguinal",
                                 description="Inguinal Lymph Node") )
        setattr(cls, "Lymph Node(s) Supraclavicular",
                PermissibleValue(text="Lymph Node(s) Supraclavicular",
                                 description="Supraclavicular Lymph Node") )
        setattr(cls, "Esophageal; Proximal",
                PermissibleValue(text="Esophageal; Proximal",
                                 description="Proximal Esophageal") )
        setattr(cls, "Temporal Cortex",
                PermissibleValue(text="Temporal Cortex") )
        setattr(cls, "Femoral Vein",
                PermissibleValue(text="Femoral Vein") )
        setattr(cls, "Tonsil (Pharyngeal)",
                PermissibleValue(text="Tonsil (Pharyngeal)") )
        setattr(cls, "Lymph Node(s) Splenic",
                PermissibleValue(text="Lymph Node(s) Splenic",
                                 description="Splenic Lymph Node") )
        setattr(cls, "Lymph Node(s) Distant",
                PermissibleValue(text="Lymph Node(s) Distant") )
        setattr(cls, "Hepatic Duct",
                PermissibleValue(text="Hepatic Duct") )
        setattr(cls, "Paraspinal Ganglion",
                PermissibleValue(text="Paraspinal Ganglion",
                                 description="Spinal Ganglion") )
        setattr(cls, "Hepatic Flexure",
                PermissibleValue(text="Hepatic Flexure",
                                 description="Hepatic Flexure") )
        setattr(cls, "Esophageal; Mid",
                PermissibleValue(text="Esophageal; Mid",
                                 description="Middle Esophageal") )
        setattr(cls, "Auditory Canal",
                PermissibleValue(text="Auditory Canal") )
        setattr(cls, "Epidural Space",
                PermissibleValue(text="Epidural Space") )
        setattr(cls, "Subcutaneous Tissue",
                PermissibleValue(text="Subcutaneous Tissue") )
        setattr(cls, "Alveolar Ridge",
                PermissibleValue(text="Alveolar Ridge",
                                 description="Alveolar Ridge") )
        setattr(cls, "Chest Wall",
                PermissibleValue(text="Chest Wall") )
        setattr(cls, "Hard Palate",
                PermissibleValue(text="Hard Palate") )
        setattr(cls, "Head & Neck",
                PermissibleValue(text="Head & Neck") )
        setattr(cls, "Femoral Artery",
                PermissibleValue(text="Femoral Artery") )
        setattr(cls, "Oral Cavity - Mucosa Only",
                PermissibleValue(text="Oral Cavity - Mucosa Only") )
        setattr(cls, "Spinal Column",
                PermissibleValue(text="Spinal Column") )
        setattr(cls, "Ocular Orbits",
                PermissibleValue(text="Ocular Orbits",
                                 description="Orbit") )
        setattr(cls, "White Blood Cells",
                PermissibleValue(text="White Blood Cells") )
        setattr(cls, "Spinal Cord",
                PermissibleValue(text="Spinal Cord",
                                 description="Spinal Cord") )
        setattr(cls, "Sciatic Nerve",
                PermissibleValue(text="Sciatic Nerve") )
        setattr(cls, "Index Finger",
                PermissibleValue(text="Index Finger") )
        setattr(cls, "Lymph Node(s) Iliac-Common",
                PermissibleValue(text="Lymph Node(s) Iliac-Common") )
        setattr(cls, "Buccal Mucosa",
                PermissibleValue(text="Buccal Mucosa") )
        setattr(cls, "Lymph Node(s) Regional",
                PermissibleValue(text="Lymph Node(s) Regional") )
        setattr(cls, "Mediastinal Soft Tissue",
                PermissibleValue(text="Mediastinal Soft Tissue",
                                 description="Mediastinal Soft Tissue") )
        setattr(cls, "Not Allowed To Collect",
                PermissibleValue(text="Not Allowed To Collect") )
        setattr(cls, "Sinus(es), Maxillary",
                PermissibleValue(text="Sinus(es), Maxillary",
                                 description="Maxillary Sinus") )
        setattr(cls, "Aqueous Fluid",
                PermissibleValue(text="Aqueous Fluid",
                                 description="Aqueous Fluid") )
        setattr(cls, "Descending Colon",
                PermissibleValue(text="Descending Colon") )
        setattr(cls, "Oral Cavity",
                PermissibleValue(text="Oral Cavity") )
        setattr(cls, "Trachea / Major Bronchi",
                PermissibleValue(text="Trachea / Major Bronchi") )
        setattr(cls, "Urinary Tract",
                PermissibleValue(text="Urinary Tract") )
        setattr(cls, "Esophagogastric Junction",
                PermissibleValue(text="Esophagogastric Junction") )
        setattr(cls, "Ear, Pinna (External)",
                PermissibleValue(text="Ear, Pinna (External)",
                                 description="External Ear") )
        setattr(cls, "Lymph Node(s) Retroperitoneal",
                PermissibleValue(text="Lymph Node(s) Retroperitoneal",
                                 description="Retroperitoneal Lymph Node") )
        setattr(cls, "Thoracic Spine",
                PermissibleValue(text="Thoracic Spine") )
        setattr(cls, "Colon - Mucosa Only",
                PermissibleValue(text="Colon - Mucosa Only") )
        setattr(cls, "Nerve(s) Cranial",
                PermissibleValue(text="Nerve(s) Cranial",
                                 description="Cranial Nerve") )
        setattr(cls, "Occipital Cortex",
                PermissibleValue(text="Occipital Cortex") )
        setattr(cls, "Hepatic Vein",
                PermissibleValue(text="Hepatic Vein") )
        setattr(cls, "Common Duct",
                PermissibleValue(text="Common Duct") )
        setattr(cls, "Small Finger",
                PermissibleValue(text="Small Finger") )
        setattr(cls, "Salivary Gland",
                PermissibleValue(text="Salivary Gland") )
        setattr(cls, "Buccal Cavity",
                PermissibleValue(text="Buccal Cavity") )
        setattr(cls, "Parotid Gland",
                PermissibleValue(text="Parotid Gland") )
        setattr(cls, "Peritoneal Cavity",
                PermissibleValue(text="Peritoneal Cavity") )
        setattr(cls, "Umbilical Cord",
                PermissibleValue(text="Umbilical Cord",
                                 description="Umbilical Cord") )
        setattr(cls, "Cervical Spine",
                PermissibleValue(text="Cervical Spine") )
        setattr(cls, "Cerebrospinal Fluid",
                PermissibleValue(text="Cerebrospinal Fluid") )
        setattr(cls, "Lymph Node(s) Occipital",
                PermissibleValue(text="Lymph Node(s) Occipital",
                                 description="Occipital Lymph Node") )
        setattr(cls, "Ampulla Of Vater",
                PermissibleValue(text="Ampulla Of Vater") )
        setattr(cls, "Broad Ligament",
                PermissibleValue(text="Broad Ligament") )
        setattr(cls, "Lymph Node(s) Mesenteric",
                PermissibleValue(text="Lymph Node(s) Mesenteric",
                                 description="Mesenteric Lymph Node") )
        setattr(cls, "Cerebral Cortex",
                PermissibleValue(text="Cerebral Cortex") )
        setattr(cls, "Autonomic Nervous System",
                PermissibleValue(text="Autonomic Nervous System") )
        setattr(cls, "Small Bowel - Mucosa Only",
                PermissibleValue(text="Small Bowel - Mucosa Only") )
        setattr(cls, "Fundus Of Stomach",
                PermissibleValue(text="Fundus Of Stomach") )
        setattr(cls, "Vas Deferens",
                PermissibleValue(text="Vas Deferens",
                                 description="Vas Deferens") )
        setattr(cls, "Retro-Orbital Region",
                PermissibleValue(text="Retro-Orbital Region") )
        setattr(cls, "Lymph Node(s) Subclavicular",
                PermissibleValue(text="Lymph Node(s) Subclavicular",
                                 description="Infraclavicular Lymph Node") )
        setattr(cls, "Aortic Body",
                PermissibleValue(text="Aortic Body",
                                 description="Aortic Body") )
        setattr(cls, "Lymph Node(s) Scalene",
                PermissibleValue(text="Lymph Node(s) Scalene") )
        setattr(cls, "Central Nervous System",
                PermissibleValue(text="Central Nervous System") )
        setattr(cls, "Lymph Node(s) Internal Mammary",
                PermissibleValue(text="Lymph Node(s) Internal Mammary") )
        setattr(cls, "Lymph Node(s) Popliteal",
                PermissibleValue(text="Lymph Node(s) Popliteal",
                                 description="Popliteal Lymph Node") )
        setattr(cls, "Skeletal Muscle",
                PermissibleValue(text="Skeletal Muscle",
                                 description="Skeletal Muscle Tissue") )
        setattr(cls, "Middle Finger",
                PermissibleValue(text="Middle Finger") )
        setattr(cls, "Splenic Flexure",
                PermissibleValue(text="Splenic Flexure",
                                 description="Splenic Flexure") )
        setattr(cls, "Nasal Cavity",
                PermissibleValue(text="Nasal Cavity",
                                 description="Nasal Cavity") )
        setattr(cls, "Small Bowel",
                PermissibleValue(text="Small Bowel") )
        setattr(cls, "Ascending Colon Hepatic Flexure",
                PermissibleValue(text="Ascending Colon Hepatic Flexure",
                                 description="Ascending Colon Hepatic Flexure") )
        setattr(cls, "Carotid Body",
                PermissibleValue(text="Carotid Body") )
        setattr(cls, "Large Bowel",
                PermissibleValue(text="Large Bowel") )
        setattr(cls, "Pineal Gland",
                PermissibleValue(text="Pineal Gland",
                                 description="Pineal Gland") )
        setattr(cls, "Gastroesophageal Junction",
                PermissibleValue(text="Gastroesophageal Junction",
                                 description="Gastroesophageal Junction") )
        setattr(cls, "Esophagus - Mucosa Only",
                PermissibleValue(text="Esophagus - Mucosa Only") )
        setattr(cls, "Connective Tissue",
                PermissibleValue(text="Connective Tissue") )
        setattr(cls, "Ring Finger",
                PermissibleValue(text="Ring Finger") )
        setattr(cls, "Abdominal Wall",
                PermissibleValue(text="Abdominal Wall") )
        setattr(cls, "Lymph Node(s) Submandibular",
                PermissibleValue(text="Lymph Node(s) Submandibular",
                                 description="Submandibular Lymph Node") )
        setattr(cls, "Lymph Nodes(s) Mediastinal",
                PermissibleValue(text="Lymph Nodes(s) Mediastinal") )
        setattr(cls, "Rectosigmoid Junction",
                PermissibleValue(text="Rectosigmoid Junction",
                                 description="Rectosigmoid Region") )
        setattr(cls, "Round Ligament",
                PermissibleValue(text="Round Ligament") )
        setattr(cls, "Endocrine Gland",
                PermissibleValue(text="Endocrine Gland") )
        setattr(cls, "Lymph Node(s) Iliac-External",
                PermissibleValue(text="Lymph Node(s) Iliac-External") )
        setattr(cls, "Esophageal; Distal",
                PermissibleValue(text="Esophageal; Distal",
                                 description="Distal Esophageal") )
        setattr(cls, "Popliteal Fossa",
                PermissibleValue(text="Popliteal Fossa") )
        setattr(cls, "Transverse Colon",
                PermissibleValue(text="Transverse Colon",
                                 description="Transverse Colon") )
        setattr(cls, "Lumbar Spine",
                PermissibleValue(text="Lumbar Spine") )
        setattr(cls, "Lacrimal Gland",
                PermissibleValue(text="Lacrimal Gland",
                                 description="Lacrimal Gland") )
        setattr(cls, "Blood Vessel",
                PermissibleValue(text="Blood Vessel") )
        setattr(cls, "Antecubital Fossa",
                PermissibleValue(text="Antecubital Fossa") )
        setattr(cls, "Cell-Line",
                PermissibleValue(text="Cell-Line") )
        setattr(cls, "Pituitary Gland",
                PermissibleValue(text="Pituitary Gland") )
        setattr(cls, "Seminal Vesicle",
                PermissibleValue(text="Seminal Vesicle",
                                 description="Seminal Vesicle") )
        setattr(cls, "Frontal Cortex",
                PermissibleValue(text="Frontal Cortex") )
        setattr(cls, "Lymph Node(s) Mammary",
                PermissibleValue(text="Lymph Node(s) Mammary",
                                 description="Mammary Lymph Node") )
        setattr(cls, "Stomach - Mucosa Only",
                PermissibleValue(text="Stomach - Mucosa Only") )
        setattr(cls, "Lymph Node(s) Femoral",
                PermissibleValue(text="Lymph Node(s) Femoral",
                                 description="Femoral Lymph Node") )
        setattr(cls, "Nasal Soft Tissue",
                PermissibleValue(text="Nasal Soft Tissue",
                                 description="Nasal Soft Tissue") )
        setattr(cls, "Anal Sphincter",
                PermissibleValue(text="Anal Sphincter") )
        setattr(cls, "Frontal Lobe",
                PermissibleValue(text="Frontal Lobe") )
        setattr(cls, "Head - Face Or Neck, Nos",
                PermissibleValue(text="Head - Face Or Neck, Nos") )
        setattr(cls, "Lymph Node(s) Pelvic",
                PermissibleValue(text="Lymph Node(s) Pelvic",
                                 description="Pelvic Lymph Node") )
        setattr(cls, "Lymph Node(s) Parotid",
                PermissibleValue(text="Lymph Node(s) Parotid",
                                 description="Parotid Gland Lymph Node") )
        setattr(cls, "Gastrointestinal Tract",
                PermissibleValue(text="Gastrointestinal Tract") )
        setattr(cls, "Periorbital Soft Tissue",
                PermissibleValue(text="Periorbital Soft Tissue") )
        setattr(cls, "Sigmoid Colon",
                PermissibleValue(text="Sigmoid Colon") )
        setattr(cls, "Amniotic Fluid",
                PermissibleValue(text="Amniotic Fluid",
                                 description="Amniotic Fluid") )
        setattr(cls, "Ear Canal",
                PermissibleValue(text="Ear Canal") )
        setattr(cls, "Lymph Node(s) Cervical",
                PermissibleValue(text="Lymph Node(s) Cervical",
                                 description="Cervical Lymph Node") )
        setattr(cls, "Lymph Node(s) Paraaortic",
                PermissibleValue(text="Lymph Node(s) Paraaortic") )
        setattr(cls, "Floor Of Mouth",
                PermissibleValue(text="Floor Of Mouth") )
        setattr(cls, "Brain Stem",
                PermissibleValue(text="Brain Stem") )
        setattr(cls, "Islet Cells",
                PermissibleValue(text="Islet Cells") )
        setattr(cls, "Lymph Node(s) Epitrochlear",
                PermissibleValue(text="Lymph Node(s) Epitrochlear",
                                 description="Epitrochlear Lymph Node") )
        setattr(cls, "Lymph Node(s) Hilar",
                PermissibleValue(text="Lymph Node(s) Hilar",
                                 description="Hilar Lymph Node") )
        setattr(cls, "Carotid Artery",
                PermissibleValue(text="Carotid Artery") )
        setattr(cls, "Sublingual Gland",
                PermissibleValue(text="Sublingual Gland") )
        setattr(cls, "Paranasal Sinuses",
                PermissibleValue(text="Paranasal Sinuses") )
        setattr(cls, "Submandibular Gland",
                PermissibleValue(text="Submandibular Gland") )

class EnumCRDCHBodySiteQualifier(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H BodySite qualifier
    """
    Bilateral = PermissibleValue(text="Bilateral",
                                         description="Bilateral")
    Left = PermissibleValue(text="Left",
                               description="Left")
    Unknown = PermissibleValue(text="Unknown")
    Right = PermissibleValue(text="Right",
                                 description="Right")

    _defn = EnumDefinition(
        name="EnumCRDCHBodySiteQualifier",
        description="Autogenerated Enumeration for CRDC-H BodySite qualifier",
        code_set=None,
        code_set_version="2021-09-23T15:59:39.996164+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Not Reported",
                PermissibleValue(text="Not Reported") )

class EnumCRDCHBiologicProductProductType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H BiologicProduct product_type
    """
    _defn = EnumDefinition(
        name="EnumCRDCHBiologicProductProductType",
        description="Autogenerated Enumeration for CRDC-H BiologicProduct product_type",
        code_set=None,
        code_set_version="2021-09-23T15:59:40.107219+00:00",
    )

class EnumCRDCHCancerGradeObservationCategory(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H CancerGradeObservation category
    """
    _defn = EnumDefinition(
        name="EnumCRDCHCancerGradeObservationCategory",
        description="Autogenerated Enumeration for CRDC-H CancerGradeObservation category",
        code_set=None,
        code_set_version="2021-09-23T15:59:40.206080+00:00",
    )

class EnumCRDCHCancerGradeObservationObservationType(EnumDefinitionImpl):

    enneking_msts_grade = PermissibleValue(text="enneking_msts_grade",
                                                             description="The text term used to describe the surgical grade of the musculoskeletal sarcoma, using the Enneking staging system approved by the Musculoskeletal Tumor Society (MSTS).")
    esophageal_columnar_dysplasia_degree = PermissibleValue(text="esophageal_columnar_dysplasia_degree",
                                                                                               description="Text term to describe the amount of dysplasia found within the benign esophageal columnar mucosa.")
    inpc_grade = PermissibleValue(text="inpc_grade",
                                           description="Text term used to describe the classification of neuroblastic differentiation within neuroblastoma tumors, as defined by the International Neuroblastoma Pathology Classification (INPC).")
    gleason_grade_group = PermissibleValue(text="gleason_grade_group",
                                                             description="The text term used to describe the overall grouping of grades defined by the Gleason grading classification, which is used to determine the aggressiveness of prostate cancer. Note that this grade describes the entire prostatectomy specimen and is not specific to the sample used for sequencing.")
    primary_gleason_grade = PermissibleValue(text="primary_gleason_grade",
                                                                 description="The text term used to describe the primary Gleason score, which describes the pattern of cells making up the largest area of the tumor. The primary and secondary Gleason pattern grades are combined to determine the patient's Gleason grade group, which is used to determine the aggressiveness of prostate cancer. Note that this grade describes the entire prostatectomy specimen and is not specific to the sample used for sequencing.")
    secondary_gleason_grade = PermissibleValue(text="secondary_gleason_grade",
                                                                     description="The text term used to describe the secondary Gleason score, which describes the pattern of cells making up the second largest area of the tumor. The primary and secondary Gleason pattern grades are combined to determine the patient's Gleason grade group, which is used to determine the aggressiveness of prostate cancer. Note that this grade describes the entire prostatectomy specimen and is not specific to the sample used for sequencing.")
    tumor_grade = PermissibleValue(text="tumor_grade",
                                             description="Text value to express the degree of abnormality of cancer cells, a measure of differentiation and aggressiveness.")

    _defn = EnumDefinition(
        name="EnumCRDCHCancerGradeObservationObservationType",
    )

class EnumCRDCHCancerGradeObservationMethodType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H CancerGradeObservation method_type
    """
    _defn = EnumDefinition(
        name="EnumCRDCHCancerGradeObservationMethodType",
        description="Autogenerated Enumeration for CRDC-H CancerGradeObservation method_type",
        code_set=None,
        code_set_version="2021-09-23T15:59:40.419324+00:00",
    )

class EnumCRDCHCancerGradeObservationValueCodeableConcept(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H CancerGradeObservation value_codeable_concept
    """
    _defn = EnumDefinition(
        name="EnumCRDCHCancerGradeObservationValueCodeableConcept",
        description="Autogenerated Enumeration for CRDC-H CancerGradeObservation value_codeable_concept",
        code_set=None,
        code_set_version="2021-09-23T15:59:40.520201+00:00",
    )

class EnumCRDCHCancerGradeObservationSetCategory(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H CancerGradeObservationSet category
    """
    _defn = EnumDefinition(
        name="EnumCRDCHCancerGradeObservationSetCategory",
        description="Autogenerated Enumeration for CRDC-H CancerGradeObservationSet category",
        code_set=None,
        code_set_version="2021-09-23T15:59:40.622070+00:00",
    )

class EnumCRDCHCancerGradeObservationSetMethodType(EnumDefinitionImpl):
    """
    A morphologic classification system of malignant tumors, usually relating to disease progression and clinical
    outcome. It is based upon the presence or absence of several morphologic parameters, including tumor cell
    necrosis, cytologic atypia, nuclear pleomorphism and mitotic figures, the architectural infiltrating patterns, and
    the degree of tumor cell differentiation. Malignant tumors usually are graded I-III
    """
    Gleason = PermissibleValue(text="Gleason",
                                     description="A grading system for prostatic carcinoma based on the microscopic glandular architectural patterns of the malignant epithelial cells. Nuclear atypia is not evaluated. It defines five patterns or grades which reflect decreasing differentiation.")
    INPC = PermissibleValue(text="INPC")

    _defn = EnumDefinition(
        name="EnumCRDCHCancerGradeObservationSetMethodType",
        description="A morphologic classification system of malignant tumors, usually relating to disease progression and clinical outcome. It is based upon the presence or absence of several morphologic parameters, including tumor cell necrosis, cytologic atypia, nuclear pleomorphism and mitotic figures, the architectural infiltrating patterns, and the degree of tumor cell differentiation. Malignant tumors usually are graded I-III",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Unspecified grading system",
                PermissibleValue(text="Unspecified grading system") )

class EnumCRDCHCancerStageObservationCategory(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H CancerStageObservation category
    """
    _defn = EnumDefinition(
        name="EnumCRDCHCancerStageObservationCategory",
        description="Autogenerated Enumeration for CRDC-H CancerStageObservation category",
        code_set=None,
        code_set_version="2021-09-23T15:59:40.826432+00:00",
    )

class EnumCRDCHCancerStageObservationObservationType(EnumDefinitionImpl):
    """
    Types of observations or components of a cancer staging assessment.
    """
    Overall = PermissibleValue(text="Overall",
                                     description="The overall stage of the disease")

    _defn = EnumDefinition(
        name="EnumCRDCHCancerStageObservationObservationType",
        description="Types of observations or components of a cancer staging assessment.",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Tumor (T)",
                PermissibleValue(text="Tumor (T)",
                                 description="T classifies the size or direct extent of the primary tumor") )
        setattr(cls, "Node (N)",
                PermissibleValue(text="Node (N)",
                                 description="N classifies the degree of spread to regional lymph nodes") )
        setattr(cls, "Metastasis (M)",
                PermissibleValue(text="Metastasis (M)",
                                 description="M classifies the presence of distant metastasis") )
        setattr(cls, "Clinical Overall",
                PermissibleValue(text="Clinical Overall",
                                 description="The overall stage of the disease; clinical stage is determined from evidence acquired before treatment (including clinical examination, imaging, endoscopy, biopsy, surgical exploration)") )
        setattr(cls, "Clinical Tumor (T)",
                PermissibleValue(text="Clinical Tumor (T)",
                                 description="T classifies the size or direct extent of the primary tumor; clinical stage is determined from evidence acquired before treatment (including clinical examination, imaging, endoscopy, biopsy, surgical exploration)") )
        setattr(cls, "Clinical Node (N)",
                PermissibleValue(text="Clinical Node (N)",
                                 description="N classifies the degree of spread to regional lymph nodes; clinical stage is determined from evidence acquired before treatment (including clinical examination, imaging, endoscopy, biopsy, surgical exploration)") )
        setattr(cls, "Clinical Metastasis (M)",
                PermissibleValue(text="Clinical Metastasis (M)",
                                 description="M classifies the presence of distant metastasis; clinical stage is determined from evidence acquired before treatment (including clinical examination, imaging, endoscopy, biopsy, surgical exploration)") )
        setattr(cls, "Pathological Overall",
                PermissibleValue(text="Pathological Overall",
                                 description="The overall stage of the disease; stage given by histopathologic examination of a surgical specimen") )
        setattr(cls, "Pathological Tumor (T)",
                PermissibleValue(text="Pathological Tumor (T)",
                                 description="T classifies the size or direct extent of the primary tumor; stage given by histopathologic examination of a surgical specimen") )
        setattr(cls, "Pathological Node (N)",
                PermissibleValue(text="Pathological Node (N)",
                                 description="N classifies the degree of spread to regional lymph nodes; stage given by histopathologic examination of a surgical specimen") )
        setattr(cls, "Pathological Metastasis (M)",
                PermissibleValue(text="Pathological Metastasis (M)",
                                 description="M classifies the presence of distant metastasis; stage given by histopathologic examination of a surgical specimen") )
        setattr(cls, "Ann Arbor Substage Modifier",
                PermissibleValue(text="Ann Arbor Substage Modifier",
                                 description="The substage classification modifiers amend each stage based on distinct features.") )

class EnumCRDCHCancerStageObservationMethodType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H CancerStageObservation method_type
    """
    _defn = EnumDefinition(
        name="EnumCRDCHCancerStageObservationMethodType",
        description="Autogenerated Enumeration for CRDC-H CancerStageObservation method_type",
        code_set=None,
        code_set_version="2021-09-23T15:59:41.029192+00:00",
    )

class EnumCRDCHCancerStageObservationValueCodeableConcept(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H CancerStageObservation value_codeable_concept
    """
    _defn = EnumDefinition(
        name="EnumCRDCHCancerStageObservationValueCodeableConcept",
        description="Autogenerated Enumeration for CRDC-H CancerStageObservation value_codeable_concept",
        code_set=None,
        code_set_version="2021-09-23T15:59:41.130366+00:00",
    )

class EnumCRDCHCancerStageObservationSetCategory(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H CancerStageObservationSet category
    """
    _defn = EnumDefinition(
        name="EnumCRDCHCancerStageObservationSetCategory",
        description="Autogenerated Enumeration for CRDC-H CancerStageObservationSet category",
        code_set=None,
        code_set_version="2021-09-23T15:59:41.232289+00:00",
    )

class EnumCRDCHCancerStageObservationSetMethodType(EnumDefinitionImpl):
    """
    Classification systems used for defining the point in the natural history of a malignant disease a patient is when
    a diagnosis is made
    """
    _defn = EnumDefinition(
        name="EnumCRDCHCancerStageObservationSetMethodType",
        description="Classification systems used for defining the point in the natural history of a malignant disease a patient is when a diagnosis is made",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "AJCC staging system 1st edition",
                PermissibleValue(text="AJCC staging system 1st edition",
                                 description="The 1st edition of the criteria developed by the American Joint Committee on Cancer (AJCC) used for the classification and staging of neoplastic diseases.") )
        setattr(cls, "AJCC staging system 2nd edition",
                PermissibleValue(text="AJCC staging system 2nd edition",
                                 description="The 2nd edition of the criteria developed by the American Joint Committee on Cancer (AJCC) used for the classification and staging of neoplastic diseases.") )
        setattr(cls, "AJCC staging system 3rd edition",
                PermissibleValue(text="AJCC staging system 3rd edition",
                                 description="The 3rd edition of the criteria developed by the American Joint Committee on Cancer (AJCC) used for the classification and staging of neoplastic diseases.") )
        setattr(cls, "AJCC staging system 4th edition",
                PermissibleValue(text="AJCC staging system 4th edition",
                                 description="The 4th edition of the criteria developed by the American Joint Committee on Cancer (AJCC) used for the classification and staging of neoplastic diseases.") )
        setattr(cls, "AJCC staging system 5th edition",
                PermissibleValue(text="AJCC staging system 5th edition",
                                 description="The 5th edition of the criteria developed by the American Joint Committee on Cancer (AJCC) used for the classification and staging of neoplastic diseases.") )
        setattr(cls, "AJCC staging system 6th edition",
                PermissibleValue(text="AJCC staging system 6th edition",
                                 description="The 6th edition of the criteria developed by the American Joint Committee on Cancer (AJCC) used for the classification and staging of neoplastic diseases.") )
        setattr(cls, "AJCC staging system 7th edition",
                PermissibleValue(text="AJCC staging system 7th edition",
                                 description="The 7th edition of the criteria developed by the American Joint Committee on Cancer (AJCC) in 2010, used for the classification and staging of neoplastic diseases.") )
        setattr(cls, "AJCC staging system 8th edition",
                PermissibleValue(text="AJCC staging system 8th edition",
                                 description="The 8th edition of the criteria developed by the American Joint Committee on Cancer (AJCC), implemented in 2018, used for the classification and staging of neoplastic diseases") )
        setattr(cls, "Ann Arbor staging system",
                PermissibleValue(text="Ann Arbor staging system",
                                 description="The Ann Arbor Staging guidelines used in the staging of lymphomas") )
        setattr(cls, "COG Liver staging system",
                PermissibleValue(text="COG Liver staging system",
                                 description="A staging system developed by Children's Oncology Group (COG) that categorizes liver tumors based on the size and extent of the tumor.") )
        setattr(cls, "COG Renal staging system",
                PermissibleValue(text="COG Renal staging system",
                                 description="A staging system developed by Children's Oncology Group (COG) that categorizes renal tumors, often Wilms tumor, based on the size and extent of the tumor.") )
        setattr(cls, "Enneking MSTS staging system",
                PermissibleValue(text="Enneking MSTS staging system",
                                 description="A staging system for malignant mesenchymal tumors that takes into account the surgical grade, local extent, and presence or absence of metastasis.") )
        setattr(cls, "FIGO staging system",
                PermissibleValue(text="FIGO staging system",
                                 description="A set of staging terms for carcinoma developed by the International Federation of Gynecology and Obstetrics (FIGO).") )
        setattr(cls, "IGCCCG staging system",
                PermissibleValue(text="IGCCCG staging system") )
        setattr(cls, "INRG staging system",
                PermissibleValue(text="INRG staging system",
                                 description="A clinical staging system for neuroblastoma based on preoperative imaging and determined prior to any treatment, including surgery. It includes two stages of localized disease (L1 and L2) and two stages of metastatic disease (M and MS).") )
        setattr(cls, "INSS staging system",
                PermissibleValue(text="INSS staging system",
                                 description="A surgicopathological staging system for neuroblastoma, based on the Evans staging system.") )
        setattr(cls, "IRS staging system",
                PermissibleValue(text="IRS staging system",
                                 description="A system developed by the Intergroup Rhabdomyosarcoma Studies (IRS) group for staging rhabdomyosarcomas based on a modified TNM staging system.") )
        setattr(cls, "ISS staging system",
                PermissibleValue(text="ISS staging system",
                                 description="A plasma cell myeloma stage defined according to the international staging system.") )
        setattr(cls, "Masaoka staging system",
                PermissibleValue(text="Masaoka staging system",
                                 description="A thymoma stage defined according to the Masaoka-Koga staging criteria.") )
        setattr(cls, "Unspecified staging system",
                PermissibleValue(text="Unspecified staging system",
                                 description="For use when a data contributor has a cancer staging value, but no clearly specified staging system under which that value falls.") )

class EnumCRDCHDiagnosisCondition(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Diagnosis condition
    """
    Ecchondrosis = PermissibleValue(text="Ecchondrosis")
    SETTLE = PermissibleValue(text="SETTLE")
    Chromaffinoma = PermissibleValue(text="Chromaffinoma")
    Neurilemosarcoma = PermissibleValue(text="Neurilemosarcoma")
    Chloroma = PermissibleValue(text="Chloroma")
    CPNET = PermissibleValue(text="CPNET")
    Osteochondrosarcoma = PermissibleValue(text="Osteochondrosarcoma")
    Angioendotheliomatosis = PermissibleValue(text="Angioendotheliomatosis")
    Reninoma = PermissibleValue(text="Reninoma")
    Medullocytoma = PermissibleValue(text="Medullocytoma")
    RARS = PermissibleValue(text="RARS")
    Myofibromatosis = PermissibleValue(text="Myofibromatosis")
    Masculinovoblastoma = PermissibleValue(text="Masculinovoblastoma")
    Myxolipoma = PermissibleValue(text="Myxolipoma")
    Lipoblastoma = PermissibleValue(text="Lipoblastoma")
    Oligodendroblastoma = PermissibleValue(text="Oligodendroblastoma")
    Lymphoblastoma = PermissibleValue(text="Lymphoblastoma")
    Pinealoma = PermissibleValue(text="Pinealoma")
    MANEC = PermissibleValue(text="MANEC")
    Myoepithelioma = PermissibleValue(text="Myoepithelioma")
    Myxoliposarcoma = PermissibleValue(text="Myxoliposarcoma")
    Gonocytoma = PermissibleValue(text="Gonocytoma")
    Xanthofibroma = PermissibleValue(text="Xanthofibroma")
    Adenomyoepithelioma = PermissibleValue(text="Adenomyoepithelioma")
    Myelomatosis = PermissibleValue(text="Myelomatosis")
    Trichofolliculoma = PermissibleValue(text="Trichofolliculoma")
    Adenosarcoma = PermissibleValue(text="Adenosarcoma",
                                               description="Adenosarcoma")
    Chorionepithelioma = PermissibleValue(text="Chorionepithelioma")
    Myofibroma = PermissibleValue(text="Myofibroma")
    Lymphangiosarcoma = PermissibleValue(text="Lymphangiosarcoma")
    Esthesioneurocytoma = PermissibleValue(text="Esthesioneurocytoma")
    Spongioneuroblastoma = PermissibleValue(text="Spongioneuroblastoma")
    Carcinomatosis = PermissibleValue(text="Carcinomatosis")
    Elastofibroma = PermissibleValue(text="Elastofibroma")
    Pituicytoma = PermissibleValue(text="Pituicytoma")
    Lymphangiomyomatosis = PermissibleValue(text="Lymphangiomyomatosis")
    Trichoepithelioma = PermissibleValue(text="Trichoepithelioma")
    Adenoacanthoma = PermissibleValue(text="Adenoacanthoma")
    Fibroliposarcoma = PermissibleValue(text="Fibroliposarcoma")
    Angiosarcoma = PermissibleValue(text="Angiosarcoma")
    Myxosarcoma = PermissibleValue(text="Myxosarcoma")
    Craniopharyngioma = PermissibleValue(text="Craniopharyngioma")
    Ecchondroma = PermissibleValue(text="Ecchondroma")
    M6A = PermissibleValue(text="M6A")
    Parachordoma = PermissibleValue(text="Parachordoma")
    Ganglioneuromatosis = PermissibleValue(text="Ganglioneuromatosis")
    Medullomyoblastoma = PermissibleValue(text="Medullomyoblastoma")
    Chemodectoma = PermissibleValue(text="Chemodectoma")
    Reticulohistiocytoma = PermissibleValue(text="Reticulohistiocytoma")
    Angioblastoma = PermissibleValue(text="Angioblastoma")
    Trichilemmocarcinoma = PermissibleValue(text="Trichilemmocarcinoma")
    Gynandroblastoma = PermissibleValue(text="Gynandroblastoma")
    Adenolymphoma = PermissibleValue(text="Adenolymphoma")
    Pneumoblastoma = PermissibleValue(text="Pneumoblastoma")
    Myosarcoma = PermissibleValue(text="Myosarcoma")
    Fibrolipoma = PermissibleValue(text="Fibrolipoma")
    Myofibroblastoma = PermissibleValue(text="Myofibroblastoma")
    Neurosarcoma = PermissibleValue(text="Neurosarcoma")
    Prolactinoma = PermissibleValue(text="Prolactinoma")
    Carcinofibroma = PermissibleValue(text="Carcinofibroma")
    Ectomesenchymoma = PermissibleValue(text="Ectomesenchymoma")
    Chorioadenoma = PermissibleValue(text="Chorioadenoma")
    Leiomyofibroma = PermissibleValue(text="Leiomyofibroma")
    Angiomyosarcoma = PermissibleValue(text="Angiomyosarcoma")
    Fibrofolliculoma = PermissibleValue(text="Fibrofolliculoma")
    Pineoblastoma = PermissibleValue(text="Pineoblastoma")
    Gliofibroma = PermissibleValue(text="Gliofibroma")
    Haemangiosarcoma = PermissibleValue(text="Haemangiosarcoma")
    Lipoadenoma = PermissibleValue(text="Lipoadenoma")
    Germinoma = PermissibleValue(text="Germinoma")
    Glomangioma = PermissibleValue(text="Glomangioma")
    Neurinoma = PermissibleValue(text="Neurinoma")
    Subependymoma = PermissibleValue(text="Subependymoma")
    PPNET = PermissibleValue(text="PPNET")
    Neurinomatosis = PermissibleValue(text="Neurinomatosis")
    MGUS = PermissibleValue(text="MGUS")
    Angiomyofibroblastoma = PermissibleValue(text="Angiomyofibroblastoma")
    Gliosarcoma = PermissibleValue(text="Gliosarcoma")
    Microglioma = PermissibleValue(text="Microglioma")
    Osteochondroma = PermissibleValue(text="Osteochondroma")
    Neuronevus = PermissibleValue(text="Neuronevus")
    Neurothekeoma = PermissibleValue(text="Neurothekeoma")
    Pheochromoblastoma = PermissibleValue(text="Pheochromoblastoma")
    Glioblastoma = PermissibleValue(text="Glioblastoma")
    Adenoameloblastoma = PermissibleValue(text="Adenoameloblastoma")
    Gangliocytoma = PermissibleValue(text="Gangliocytoma")
    Cholangioma = PermissibleValue(text="Cholangioma")
    RAEB = PermissibleValue(text="RAEB")
    Glomangiomyoma = PermissibleValue(text="Glomangiomyoma")
    Trichilemmoma = PermissibleValue(text="Trichilemmoma")
    Glioneuroma = PermissibleValue(text="Glioneuroma")
    Angioendothelioma = PermissibleValue(text="Angioendothelioma")
    Esthesioneuroepithelioma = PermissibleValue(text="Esthesioneuroepithelioma")
    CASTLE = PermissibleValue(text="CASTLE")
    Fibromyxoma = PermissibleValue(text="Fibromyxoma")
    Lipoleiomyoma = PermissibleValue(text="Lipoleiomyoma")
    Myoma = PermissibleValue(text="Myoma")
    M6B = PermissibleValue(text="M6B")
    Pineocytoma = PermissibleValue(text="Pineocytoma")
    Oligoastrocytoma = PermissibleValue(text="Oligoastrocytoma",
                                                       description="Oligoastrocytoma")
    Leiomyoblastoma = PermissibleValue(text="Leiomyoblastoma")
    Myelolipoma = PermissibleValue(text="Myelolipoma")
    Fibromyoma = PermissibleValue(text="Fibromyoma")
    Dysgerminoma = PermissibleValue(text="Dysgerminoma",
                                               description="Ovarian Dysgerminoma")
    Rhabdosarcoma = PermissibleValue(text="Rhabdosarcoma")
    Haemangioblastoma = PermissibleValue(text="Haemangioblastoma")
    Syringofibroadenoma = PermissibleValue(text="Syringofibroadenoma")
    Hypernephroma = PermissibleValue(text="Hypernephroma")
    Hepatocarcinoma = PermissibleValue(text="Hepatocarcinoma")
    Lymphoepithelioma = PermissibleValue(text="Lymphoepithelioma")
    Preleukemia = PermissibleValue(text="Preleukemia")
    Nesidioblastoma = PermissibleValue(text="Nesidioblastoma")
    Spermatocytoma = PermissibleValue(text="Spermatocytoma")
    Fibromyxolipoma = PermissibleValue(text="Fibromyxolipoma")
    Neurocytoma = PermissibleValue(text="Neurocytoma")
    Angiomyxoma = PermissibleValue(text="Angiomyxoma")
    Pancreatoblastoma = PermissibleValue(text="Pancreatoblastoma",
                                                         description="Pancreatoblastoma")
    Sympathicoblastoma = PermissibleValue(text="Sympathicoblastoma")
    Luteinoma = PermissibleValue(text="Luteinoma")
    Malignancy = PermissibleValue(text="Malignancy")
    Fibrochondrosarcoma = PermissibleValue(text="Fibrochondrosarcoma")
    Astroblastoma = PermissibleValue(text="Astroblastoma")
    Adenomyoma = PermissibleValue(text="Adenomyoma")
    Trichodiscoma = PermissibleValue(text="Trichodiscoma")
    Lipoblastomatosis = PermissibleValue(text="Lipoblastomatosis")
    Glomangiosarcoma = PermissibleValue(text="Glomangiosarcoma")
    Hemolymphangioma = PermissibleValue(text="Hemolymphangioma")
    Enchondroma = PermissibleValue(text="Enchondroma")
    Esthesioneuroblastoma = PermissibleValue(text="Esthesioneuroblastoma")
    Unknown = PermissibleValue(text="Unknown",
                                     description="Unknown")
    Neurolipocytoma = PermissibleValue(text="Neurolipocytoma")
    Hidradenocarcinoma = PermissibleValue(text="Hidradenocarcinoma")
    Oncocytoma = PermissibleValue(text="Oncocytoma")
    Immunocytoma = PermissibleValue(text="Immunocytoma")
    Gemistocytoma = PermissibleValue(text="Gemistocytoma")
    Erythroleukemia = PermissibleValue(text="Erythroleukemia")
    Lymphangioleiomyomatosis = PermissibleValue(text="Lymphangioleiomyomatosis")
    Odontoameloblastoma = PermissibleValue(text="Odontoameloblastoma")
    Osteofibroma = PermissibleValue(text="Osteofibroma")
    Fibromyxosarcoma = PermissibleValue(text="Fibromyxosarcoma")
    Hibernoma = PermissibleValue(text="Hibernoma")
    Porocarcinoma = PermissibleValue(text="Porocarcinoma")
    Apudoma = PermissibleValue(text="Apudoma")
    Orchioblastoma = PermissibleValue(text="Orchioblastoma")
    Angiokeratoma = PermissibleValue(text="Angiokeratoma")
    Angiomyolipoma = PermissibleValue(text="Angiomyolipoma")
    Neuroastrocytoma = PermissibleValue(text="Neuroastrocytoma")
    Ependymoblastoma = PermissibleValue(text="Ependymoblastoma")
    Teratocarcinoma = PermissibleValue(text="Teratocarcinoma")
    Angioleiomyoma = PermissibleValue(text="Angioleiomyoma")
    Neurofibrosarcoma = PermissibleValue(text="Neurofibrosarcoma")
    Chorioangioma = PermissibleValue(text="Chorioangioma")
    Hidrocystoma = PermissibleValue(text="Hidrocystoma")
    Osteofibrosarcoma = PermissibleValue(text="Osteofibrosarcoma")
    Hepatocholangiocarcinoma = PermissibleValue(text="Hepatocholangiocarcinoma")
    Hepatoblastoma = PermissibleValue(text="Hepatoblastoma")
    Cancer = PermissibleValue(text="Cancer")
    Adenolipoma = PermissibleValue(text="Adenolipoma")
    Lymphangiomyoma = PermissibleValue(text="Lymphangiomyoma")
    Cholangiocarcinoma = PermissibleValue(text="Cholangiocarcinoma",
                                                           description="Cholangiocarcinoma")
    Gonadoblastoma = PermissibleValue(text="Gonadoblastoma")
    Retinocytoma = PermissibleValue(text="Retinocytoma")
    Melanoameloblastoma = PermissibleValue(text="Melanoameloblastoma")
    Angiomyoma = PermissibleValue(text="Angiomyoma")
    Ganglioneuroblastoma = PermissibleValue(text="Ganglioneuroblastoma")
    Polyembryoma = PermissibleValue(text="Polyembryoma")
    Chorioepithelioma = PermissibleValue(text="Chorioepithelioma")
    GANT = PermissibleValue(text="GANT")
    Astroglioma = PermissibleValue(text="Astroglioma")
    Dentinoma = PermissibleValue(text="Dentinoma")
    Ganglioneuroma = PermissibleValue(text="Ganglioneuroma")
    Sialoblastoma = PermissibleValue(text="Sialoblastoma")

    _defn = EnumDefinition(
        name="EnumCRDCHDiagnosisCondition",
        description="Autogenerated Enumeration for CRDC-H Diagnosis condition",
        code_set=None,
        code_set_version="2021-09-23T15:59:41.436651+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Von Recklinghausen disease",
                PermissibleValue(text="Von Recklinghausen disease") )
        setattr(cls, "Choroid plexus papilloma, anaplastic",
                PermissibleValue(text="Choroid plexus papilloma, anaplastic") )
        setattr(cls, "Calcifying epithelial odontogenic tumor",
                PermissibleValue(text="Calcifying epithelial odontogenic tumor") )
        setattr(cls, "Dermoid cyst with malignant transformation",
                PermissibleValue(text="Dermoid cyst with malignant transformation") )
        setattr(cls, "Metastatic signet ring cell carcinoma",
                PermissibleValue(text="Metastatic signet ring cell carcinoma") )
        setattr(cls, "Anaplastic large cell lymphoma, T cell and Null cell type",
                PermissibleValue(text="Anaplastic large cell lymphoma, T cell and Null cell type") )
        setattr(cls, "Mucinous tubular and spindle cell carcinoma",
                PermissibleValue(text="Mucinous tubular and spindle cell carcinoma") )
        setattr(cls, "Abdominal desmoid",
                PermissibleValue(text="Abdominal desmoid") )
        setattr(cls, "Solid and cystic tumor",
                PermissibleValue(text="Solid and cystic tumor") )
        setattr(cls, "Pancreatic peptide and pancreatic peptide-like peptide within terminal tyrosine amide producing tumor",
                PermissibleValue(text="Pancreatic peptide and pancreatic peptide-like peptide within terminal tyrosine amide producing tumor") )
        setattr(cls, "Proliferative polycythemia",
                PermissibleValue(text="Proliferative polycythemia") )
        setattr(cls, "Olfactory neuroblastoma",
                PermissibleValue(text="Olfactory neuroblastoma") )
        setattr(cls, "Liver cell adenoma",
                PermissibleValue(text="Liver cell adenoma") )
        setattr(cls, "Mucinous adenoma",
                PermissibleValue(text="Mucinous adenoma") )
        setattr(cls, "Basosquamous carcinoma",
                PermissibleValue(text="Basosquamous carcinoma") )
        setattr(cls, "Spindle cell melanoma, type B",
                PermissibleValue(text="Spindle cell melanoma, type B") )
        setattr(cls, "Eccrine cystadenoma",
                PermissibleValue(text="Eccrine cystadenoma") )
        setattr(cls, "Combined small cell-large carcinoma",
                PermissibleValue(text="Combined small cell-large carcinoma") )
        setattr(cls, "Serous carcinoma, NOS",
                PermissibleValue(text="Serous carcinoma, NOS") )
        setattr(cls, "Liver cell carcinoma",
                PermissibleValue(text="Liver cell carcinoma") )
        setattr(cls, "Medullary adenocarcinoma",
                PermissibleValue(text="Medullary adenocarcinoma") )
        setattr(cls, "Apocrine adenocarcinoma",
                PermissibleValue(text="Apocrine adenocarcinoma") )
        setattr(cls, "Thymoma, lymphocyte-rich, NOS",
                PermissibleValue(text="Thymoma, lymphocyte-rich, NOS") )
        setattr(cls, "Gliomatosis cerebri",
                PermissibleValue(text="Gliomatosis cerebri") )
        setattr(cls, "Subcutaneous panniculitis-like T-cell lymphoma",
                PermissibleValue(text="Subcutaneous panniculitis-like T-cell lymphoma") )
        setattr(cls, "Oligodendroglioma, IDH-mutant and 1p/19q-codeleted",
                PermissibleValue(text="Oligodendroglioma, IDH-mutant and 1p/19q-codeleted") )
        setattr(cls, "Diffuse cutaneous mastocytosis",
                PermissibleValue(text="Diffuse cutaneous mastocytosis") )
        setattr(cls, "Glomus tumor, NOS",
                PermissibleValue(text="Glomus tumor, NOS") )
        setattr(cls, "Cystadenofibroma, NOS",
                PermissibleValue(text="Cystadenofibroma, NOS") )
        setattr(cls, "Cylindroma of skin",
                PermissibleValue(text="Cylindroma of skin") )
        setattr(cls, "Adenocarcinoma, intestinal type",
                PermissibleValue(text="Adenocarcinoma, intestinal type",
                                 description="Intestinal-Type Adenocarcinoma") )
        setattr(cls, "Fetal adenocarcinoma",
                PermissibleValue(text="Fetal adenocarcinoma") )
        setattr(cls, "Adenocarcinoma with osseous metaplasia",
                PermissibleValue(text="Adenocarcinoma with osseous metaplasia") )
        setattr(cls, "Trophoblastic tumor, epithelioid",
                PermissibleValue(text="Trophoblastic tumor, epithelioid") )
        setattr(cls, "Enterochromaffin-like cell carcinoid, NOS",
                PermissibleValue(text="Enterochromaffin-like cell carcinoid, NOS") )
        setattr(cls, "Central osteosarcoma",
                PermissibleValue(text="Central osteosarcoma") )
        setattr(cls, "Chronic myelomonocytic leukemia, Type II",
                PermissibleValue(text="Chronic myelomonocytic leukemia, Type II") )
        setattr(cls, "Small cell sarcoma",
                PermissibleValue(text="Small cell sarcoma") )
        setattr(cls, "Medulloblastoma, WNT-activated",
                PermissibleValue(text="Medulloblastoma, WNT-activated") )
        setattr(cls, "Low-grade central osteosarcoma",
                PermissibleValue(text="Low-grade central osteosarcoma") )
        setattr(cls, "Myeloproliferative disease, NOS",
                PermissibleValue(text="Myeloproliferative disease, NOS") )
        setattr(cls, "Myofibroblastic sarcoma",
                PermissibleValue(text="Myofibroblastic sarcoma") )
        setattr(cls, "Chronic monocytic leukemia",
                PermissibleValue(text="Chronic monocytic leukemia") )
        setattr(cls, "Peripheral T-cell lymphoma, large cell",
                PermissibleValue(text="Peripheral T-cell lymphoma, large cell") )
        setattr(cls, "Acute myeloid leukemia, t(16;16)(p 13;q 11)",
                PermissibleValue(text="Acute myeloid leukemia, t(16;16)(p 13;q 11)") )
        setattr(cls, "Arrhenoblastoma, NOS",
                PermissibleValue(text="Arrhenoblastoma, NOS") )
        setattr(cls, "B lymphoblastic leukemia/lymphoma with t(v;11q23); MLL rearranged",
                PermissibleValue(text="B lymphoblastic leukemia/lymphoma with t(v;11q23); MLL rearranged") )
        setattr(cls, "Giant pigmented nevus, NOS",
                PermissibleValue(text="Giant pigmented nevus, NOS") )
        setattr(cls, "Endometrial stromal nodule",
                PermissibleValue(text="Endometrial stromal nodule") )
        setattr(cls, "Mullerian adenosarcoma",
                PermissibleValue(text="Mullerian adenosarcoma") )
        setattr(cls, "Medulloepithelioma, NOS",
                PermissibleValue(text="Medulloepithelioma, NOS") )
        setattr(cls, "Intraductal papillary-mucinous tumor with intermediate dysplasia",
                PermissibleValue(text="Intraductal papillary-mucinous tumor with intermediate dysplasia") )
        setattr(cls, "Spindle epithelial tumor with thymus-like element",
                PermissibleValue(text="Spindle epithelial tumor with thymus-like element") )
        setattr(cls, "Dermal nevus",
                PermissibleValue(text="Dermal nevus") )
        setattr(cls, "Periosteal fibrosarcoma",
                PermissibleValue(text="Periosteal fibrosarcoma") )
        setattr(cls, "Cystosarcoma phyllodes, NOS",
                PermissibleValue(text="Cystosarcoma phyllodes, NOS") )
        setattr(cls, "Chronic myelogenous leukemia, BCR-ABL positive",
                PermissibleValue(text="Chronic myelogenous leukemia, BCR-ABL positive") )
        setattr(cls, "Mammary carcinoma, in situ",
                PermissibleValue(text="Mammary carcinoma, in situ") )
        setattr(cls, "Argentaffinoma, NOS",
                PermissibleValue(text="Argentaffinoma, NOS") )
        setattr(cls, "Calcifying odontogenic cyst",
                PermissibleValue(text="Calcifying odontogenic cyst") )
        setattr(cls, "Intraductal carcinoma and lobular carcinoma in situ",
                PermissibleValue(text="Intraductal carcinoma and lobular carcinoma in situ") )
        setattr(cls, "Ductal carcinoma, cribriform type",
                PermissibleValue(text="Ductal carcinoma, cribriform type") )
        setattr(cls, "Microcystic adnexal carcinoma",
                PermissibleValue(text="Microcystic adnexal carcinoma") )
        setattr(cls, "Adenoid basal carcinoma",
                PermissibleValue(text="Adenoid basal carcinoma") )
        setattr(cls, "Epithelioid mesothelioma, benign",
                PermissibleValue(text="Epithelioid mesothelioma, benign") )
        setattr(cls, "Thymoma, NOS",
                PermissibleValue(text="Thymoma, NOS") )
        setattr(cls, "Malignant lymphomatous polyposis",
                PermissibleValue(text="Malignant lymphomatous polyposis") )
        setattr(cls, "Acute myeloid leukemia with abnormal marrow eosinophils (includes all variants)",
                PermissibleValue(text="Acute myeloid leukemia with abnormal marrow eosinophils (includes all variants)") )
        setattr(cls, "Odontogenic myxoma",
                PermissibleValue(text="Odontogenic myxoma") )
        setattr(cls, "Ameloblastic fibrodentinoma",
                PermissibleValue(text="Ameloblastic fibrodentinoma") )
        setattr(cls, "Di Guglielmo disease",
                PermissibleValue(text="Di Guglielmo disease") )
        setattr(cls, "Malignant mastocytoma",
                PermissibleValue(text="Malignant mastocytoma") )
        setattr(cls, "Cartilaginous exostosis",
                PermissibleValue(text="Cartilaginous exostosis") )
        setattr(cls, "Sweat gland tumor, NOS",
                PermissibleValue(text="Sweat gland tumor, NOS") )
        setattr(cls, "Papillary mucinous cystadenoma, NOS",
                PermissibleValue(text="Papillary mucinous cystadenoma, NOS") )
        setattr(cls, "Angiomatoid fibrous histiocytoma",
                PermissibleValue(text="Angiomatoid fibrous histiocytoma") )
        setattr(cls, "Infiltrating lobular carcinoma, NOS",
                PermissibleValue(text="Infiltrating lobular carcinoma, NOS") )
        setattr(cls, "Bronchio-alveolar carcinoma, mucinous",
                PermissibleValue(text="Bronchio-alveolar carcinoma, mucinous") )
        setattr(cls, "Endolymphatic stromal myosis",
                PermissibleValue(text="Endolymphatic stromal myosis") )
        setattr(cls, "Intracystic papillary adenoma",
                PermissibleValue(text="Intracystic papillary adenoma") )
        setattr(cls, "Follicular fibroma",
                PermissibleValue(text="Follicular fibroma") )
        setattr(cls, "Mucin-secreting adenocarcinoma",
                PermissibleValue(text="Mucin-secreting adenocarcinoma") )
        setattr(cls, "Acidophil adenocarcinoma",
                PermissibleValue(text="Acidophil adenocarcinoma") )
        setattr(cls, "Chondromyxoid fibroma",
                PermissibleValue(text="Chondromyxoid fibroma") )
        setattr(cls, "Trabecular carcinoma",
                PermissibleValue(text="Trabecular carcinoma") )
        setattr(cls, "Myeloproliferative neoplasm, NOS",
                PermissibleValue(text="Myeloproliferative neoplasm, NOS") )
        setattr(cls, "Plexiform schwannoma",
                PermissibleValue(text="Plexiform schwannoma") )
        setattr(cls, "Invasive fibroma",
                PermissibleValue(text="Invasive fibroma") )
        setattr(cls, "Mixed acinar-endocrine-ductal carcinoma",
                PermissibleValue(text="Mixed acinar-endocrine-ductal carcinoma") )
        setattr(cls, "Acute myeloid leukemia with t(6;9)(p23;q34); DEK-NUP214",
                PermissibleValue(text="Acute myeloid leukemia with t(6;9)(p23;q34); DEK-NUP214") )
        setattr(cls, "Solid adenocarcinoma with mucin formation",
                PermissibleValue(text="Solid adenocarcinoma with mucin formation") )
        setattr(cls, "Neuroblastoma, NOS",
                PermissibleValue(text="Neuroblastoma, NOS") )
        setattr(cls, "Hemangioma, NOS",
                PermissibleValue(text="Hemangioma, NOS") )
        setattr(cls, "Infiltrating ductular carcinoma",
                PermissibleValue(text="Infiltrating ductular carcinoma") )
        setattr(cls, "Small cell carcinoma, intermediate cell",
                PermissibleValue(text="Small cell carcinoma, intermediate cell") )
        setattr(cls, "Endometrioid cystadenofibroma, borderline malignancy",
                PermissibleValue(text="Endometrioid cystadenofibroma, borderline malignancy") )
        setattr(cls, "Extra-adrenal paraganglioma, malignant",
                PermissibleValue(text="Extra-adrenal paraganglioma, malignant") )
        setattr(cls, "Kaposi sarcoma",
                PermissibleValue(text="Kaposi sarcoma") )
        setattr(cls, "Non-invasive EFVPTC",
                PermissibleValue(text="Non-invasive EFVPTC") )
        setattr(cls, "Hodgkin disease, nodular sclerosis, lymphocyte depletion",
                PermissibleValue(text="Hodgkin disease, nodular sclerosis, lymphocyte depletion") )
        setattr(cls, "Non-lymphocytic leukemia, NOS",
                PermissibleValue(text="Non-lymphocytic leukemia, NOS") )
        setattr(cls, "Intracystic papillary tumor with high grade intraepithelial neoplasia",
                PermissibleValue(text="Intracystic papillary tumor with high grade intraepithelial neoplasia") )
        setattr(cls, "Myxoid liposarcoma",
                PermissibleValue(text="Myxoid liposarcoma") )
        setattr(cls, "Papillocystic adenocarcinoma",
                PermissibleValue(text="Papillocystic adenocarcinoma") )
        setattr(cls, "Neuroendocrine carcinoma, low grade",
                PermissibleValue(text="Neuroendocrine carcinoma, low grade") )
        setattr(cls, "Precursor T-cell lymphoblastic leukemia",
                PermissibleValue(text="Precursor T-cell lymphoblastic leukemia") )
        setattr(cls, "Invasive lobular carcinoma",
                PermissibleValue(text="Invasive lobular carcinoma") )
        setattr(cls, "Basal cell carcinoma, fibroepithelial",
                PermissibleValue(text="Basal cell carcinoma, fibroepithelial") )
        setattr(cls, "Epithelioid hemangioendothelioma, malignant",
                PermissibleValue(text="Epithelioid hemangioendothelioma, malignant") )
        setattr(cls, "Intraductal papillary-mucinous tumor with low grade dysplasia",
                PermissibleValue(text="Intraductal papillary-mucinous tumor with low grade dysplasia") )
        setattr(cls, "Carcinosarcoma, NOS",
                PermissibleValue(text="Carcinosarcoma, NOS") )
        setattr(cls, "Bronchiolar adenocarcinoma",
                PermissibleValue(text="Bronchiolar adenocarcinoma") )
        setattr(cls, "Fibroid uterus",
                PermissibleValue(text="Fibroid uterus") )
        setattr(cls, "Stromal myosis, NOS",
                PermissibleValue(text="Stromal myosis, NOS") )
        setattr(cls, "Papillary tumor of the pineal region",
                PermissibleValue(text="Papillary tumor of the pineal region") )
        setattr(cls, "Serous cystadenofibroma, NOS",
                PermissibleValue(text="Serous cystadenofibroma, NOS") )
        setattr(cls, "Thymic carcinoma, NOS",
                PermissibleValue(text="Thymic carcinoma, NOS") )
        setattr(cls, "Hairy cell leukemia",
                PermissibleValue(text="Hairy cell leukemia") )
        setattr(cls, "Histiocytoid hemangioma",
                PermissibleValue(text="Histiocytoid hemangioma") )
        setattr(cls, "Ceruminous carcinoma",
                PermissibleValue(text="Ceruminous carcinoma") )
        setattr(cls, "Adenomyoepithelioma with carcinoma",
                PermissibleValue(text="Adenomyoepithelioma with carcinoma") )
        setattr(cls, "Mucin-secreting carcinoma",
                PermissibleValue(text="Mucin-secreting carcinoma") )
        setattr(cls, "Pulmonary adenomatosis",
                PermissibleValue(text="Pulmonary adenomatosis") )
        setattr(cls, "Central neuroblastoma",
                PermissibleValue(text="Central neuroblastoma") )
        setattr(cls, "Peripheral odontogenic fibroma",
                PermissibleValue(text="Peripheral odontogenic fibroma") )
        setattr(cls, "Acute myeloid leukemia with t(8;21)(q22;q22); RUNX1-RUNX1T1",
                PermissibleValue(text="Acute myeloid leukemia with t(8;21)(q22;q22); RUNX1-RUNX1T1") )
        setattr(cls, "Infantile myofibromatosis",
                PermissibleValue(text="Infantile myofibromatosis") )
        setattr(cls, "Mixed tumor, malignant, NOS",
                PermissibleValue(text="Mixed tumor, malignant, NOS") )
        setattr(cls, "Fibroadenoma, NOS",
                PermissibleValue(text="Fibroadenoma, NOS") )
        setattr(cls, "Mixed phenotype acute leukemia, T/myeloid, NOS",
                PermissibleValue(text="Mixed phenotype acute leukemia, T/myeloid, NOS") )
        setattr(cls, "Junctional nevus, NOS",
                PermissibleValue(text="Junctional nevus, NOS") )
        setattr(cls, "Neuroendocrine tumor, well differentiated",
                PermissibleValue(text="Neuroendocrine tumor, well differentiated") )
        setattr(cls, "Acute myeloid leukemia with prior myelodysplastic syndrome",
                PermissibleValue(text="Acute myeloid leukemia with prior myelodysplastic syndrome") )
        setattr(cls, "Acral lentiginous melanoma, malignant",
                PermissibleValue(text="Acral lentiginous melanoma, malignant") )
        setattr(cls, "Subacute lymphatic leukemia",
                PermissibleValue(text="Subacute lymphatic leukemia") )
        setattr(cls, "Systemic light chain disease",
                PermissibleValue(text="Systemic light chain disease") )
        setattr(cls, "Carcinoma with apocrine metaplasia",
                PermissibleValue(text="Carcinoma with apocrine metaplasia") )
        setattr(cls, "Endovascular papillary angioendothelioma",
                PermissibleValue(text="Endovascular papillary angioendothelioma") )
        setattr(cls, "Squamotransitional cell carcinoma",
                PermissibleValue(text="Squamotransitional cell carcinoma") )
        setattr(cls, "Myeloid leukemia associated with Down Syndrome",
                PermissibleValue(text="Myeloid leukemia associated with Down Syndrome") )
        setattr(cls, "Papillary adenoma, NOS",
                PermissibleValue(text="Papillary adenoma, NOS") )
        setattr(cls, "Mixed teratoma and seminoma",
                PermissibleValue(text="Mixed teratoma and seminoma") )
        setattr(cls, "Infiltrating and papillary adenocarcinoma",
                PermissibleValue(text="Infiltrating and papillary adenocarcinoma") )
        setattr(cls, "Squamous intraepithelial neoplasia, grade II",
                PermissibleValue(text="Squamous intraepithelial neoplasia, grade II") )
        setattr(cls, "Fibroepithelioma of Pinkus type",
                PermissibleValue(text="Fibroepithelioma of Pinkus type") )
        setattr(cls, "Acute erythremic myelosis",
                PermissibleValue(text="Acute erythremic myelosis") )
        setattr(cls, "Intestinal-type adenocarcinoma",
                PermissibleValue(text="Intestinal-type adenocarcinoma") )
        setattr(cls, "Hygroma, NOS",
                PermissibleValue(text="Hygroma, NOS") )
        setattr(cls, "Neurogenic sarcoma",
                PermissibleValue(text="Neurogenic sarcoma") )
        setattr(cls, "Adult cystic teratoma",
                PermissibleValue(text="Adult cystic teratoma") )
        setattr(cls, "Infiltrating basal cell carcinoma, sclerosing",
                PermissibleValue(text="Infiltrating basal cell carcinoma, sclerosing") )
        setattr(cls, "Primitive polar spongioblastoma",
                PermissibleValue(text="Primitive polar spongioblastoma") )
        setattr(cls, "Parosteal osteosarcoma",
                PermissibleValue(text="Parosteal osteosarcoma") )
        setattr(cls, "Histiocytosis X, NOS",
                PermissibleValue(text="Histiocytosis X, NOS") )
        setattr(cls, "Ameloblastic fibrosarcoma",
                PermissibleValue(text="Ameloblastic fibrosarcoma") )
        setattr(cls, "Clear cell ependymoma",
                PermissibleValue(text="Clear cell ependymoma") )
        setattr(cls, "Composite carcinoid",
                PermissibleValue(text="Composite carcinoid") )
        setattr(cls, "Metanephric adenoma",
                PermissibleValue(text="Metanephric adenoma") )
        setattr(cls, "Refractory neutropenia",
                PermissibleValue(text="Refractory neutropenia") )
        setattr(cls, "G cell tumor, NOS",
                PermissibleValue(text="G cell tumor, NOS") )
        setattr(cls, "Sarcomatoid carcinoma",
                PermissibleValue(text="Sarcomatoid carcinoma") )
        setattr(cls, "Thymoma, type B3, NOS",
                PermissibleValue(text="Thymoma, type B3, NOS") )
        setattr(cls, "Precursor B-cell lymphoblastic lymphoma",
                PermissibleValue(text="Precursor B-cell lymphoblastic lymphoma") )
        setattr(cls, "Gastrinoma, NOS",
                PermissibleValue(text="Gastrinoma, NOS") )
        setattr(cls, "Mastocytoma, NOS",
                PermissibleValue(text="Mastocytoma, NOS") )
        setattr(cls, "Granulocytic leukemia, NOS",
                PermissibleValue(text="Granulocytic leukemia, NOS") )
        setattr(cls, "Hodgkin lymphoma, lymphocyte predominance, nodular",
                PermissibleValue(text="Hodgkin lymphoma, lymphocyte predominance, nodular") )
        setattr(cls, "Basal cell adenocarcinoma",
                PermissibleValue(text="Basal cell adenocarcinoma",
                                 description="Salivary Gland Basal Cell Adenocarcinoma") )
        setattr(cls, "Epidermoid carcinoma, keratinizing",
                PermissibleValue(text="Epidermoid carcinoma, keratinizing") )
        setattr(cls, "Hemangiopericytoma, benign",
                PermissibleValue(text="Hemangiopericytoma, benign") )
        setattr(cls, "Squamous cell papilloma, NOS",
                PermissibleValue(text="Squamous cell papilloma, NOS") )
        setattr(cls, "Primary myelofibrosis",
                PermissibleValue(text="Primary myelofibrosis") )
        setattr(cls, "Angiotropic lymphoma",
                PermissibleValue(text="Angiotropic lymphoma") )
        setattr(cls, "Dysplastic gangliocytoma of cerebellum (Lhermitte-Duclos)",
                PermissibleValue(text="Dysplastic gangliocytoma of cerebellum (Lhermitte-Duclos)") )
        setattr(cls, "Polypoid adenoma",
                PermissibleValue(text="Polypoid adenoma") )
        setattr(cls, "Alveolar cell carcinoma",
                PermissibleValue(text="Alveolar cell carcinoma") )
        setattr(cls, "Mixed hepatocellular and bile duct carcinoma",
                PermissibleValue(text="Mixed hepatocellular and bile duct carcinoma") )
        setattr(cls, "Renomedullary interstitial cell tumor",
                PermissibleValue(text="Renomedullary interstitial cell tumor") )
        setattr(cls, "Burkitt lymphoma, NOS (Includes all variants)",
                PermissibleValue(text="Burkitt lymphoma, NOS (Includes all variants)") )
        setattr(cls, "Merkel cell carcinoma",
                PermissibleValue(text="Merkel cell carcinoma") )
        setattr(cls, "Malignant lymphoma, NOS",
                PermissibleValue(text="Malignant lymphoma, NOS") )
        setattr(cls, "Duct cell carcinoma",
                PermissibleValue(text="Duct cell carcinoma") )
        setattr(cls, "Malignant lymphoma, mixed lymphocytic-histiocytic, nodular",
                PermissibleValue(text="Malignant lymphoma, mixed lymphocytic-histiocytic, nodular") )
        setattr(cls, "Capillary hemangioma",
                PermissibleValue(text="Capillary hemangioma") )
        setattr(cls, "Papillary syringocystadenoma",
                PermissibleValue(text="Papillary syringocystadenoma") )
        setattr(cls, "Acute promyelocytic leukaemia, t(15;17)(q22;q11-12)",
                PermissibleValue(text="Acute promyelocytic leukaemia, t(15;17)(q22;q11-12)") )
        setattr(cls, "Malignant mast cell tumor",
                PermissibleValue(text="Malignant mast cell tumor") )
        setattr(cls, "Malignant mucinous adenofibroma",
                PermissibleValue(text="Malignant mucinous adenofibroma") )
        setattr(cls, "Follicular dendritic cell tumor",
                PermissibleValue(text="Follicular dendritic cell tumor") )
        setattr(cls, "Villoglandular carcinoma",
                PermissibleValue(text="Villoglandular carcinoma") )
        setattr(cls, "Epidermoid carcinoma, NOS",
                PermissibleValue(text="Epidermoid carcinoma, NOS") )
        setattr(cls, "Polyvesicular vitelline tumor",
                PermissibleValue(text="Polyvesicular vitelline tumor") )
        setattr(cls, "MPNST, NOS",
                PermissibleValue(text="MPNST, NOS") )
        setattr(cls, "Mixed adenoneuroendocrine carcinoma",
                PermissibleValue(text="Mixed adenoneuroendocrine carcinoma",
                                 description="Digestive System Mixed Adenoneuroendocrine Carcinoma") )
        setattr(cls, "Mucosal-associated lymphoid tissue lymphoma",
                PermissibleValue(text="Mucosal-associated lymphoid tissue lymphoma") )
        setattr(cls, "Choroid plexus carcinoma",
                PermissibleValue(text="Choroid plexus carcinoma") )
        setattr(cls, "Solitary fibrous tumor, malignant",
                PermissibleValue(text="Solitary fibrous tumor, malignant") )
        setattr(cls, "Cystic mesothelioma, NOS",
                PermissibleValue(text="Cystic mesothelioma, NOS") )
        setattr(cls, "Mucinous cystic neoplasm with low-grade dysplasia",
                PermissibleValue(text="Mucinous cystic neoplasm with low-grade dysplasia") )
        setattr(cls, "Myelofibrosis with myeloid metaplasia",
                PermissibleValue(text="Myelofibrosis with myeloid metaplasia") )
        setattr(cls, "Pleomorphic cell sarcoma",
                PermissibleValue(text="Pleomorphic cell sarcoma") )
        setattr(cls, "Serous cystadenocarcinofibroma",
                PermissibleValue(text="Serous cystadenocarcinofibroma") )
        setattr(cls, "Androblastoma, malignant",
                PermissibleValue(text="Androblastoma, malignant") )
        setattr(cls, "Granulosa cell-theca cell tumor",
                PermissibleValue(text="Granulosa cell-theca cell tumor") )
        setattr(cls, "Perivascular epithelioid cell tumor, malignant",
                PermissibleValue(text="Perivascular epithelioid cell tumor, malignant") )
        setattr(cls, "Inflammatory adenocarcinoma",
                PermissibleValue(text="Inflammatory adenocarcinoma") )
        setattr(cls, "Hodgkin disease, nodular sclerosis, mixed cellularity",
                PermissibleValue(text="Hodgkin disease, nodular sclerosis, mixed cellularity") )
        setattr(cls, "Langerhans cell histiocytosis, generalized",
                PermissibleValue(text="Langerhans cell histiocytosis, generalized") )
        setattr(cls, "Germ cell tumors with associated hematological malignancy",
                PermissibleValue(text="Germ cell tumors with associated hematological malignancy") )
        setattr(cls, "Giant cell tumor of bone, malignant",
                PermissibleValue(text="Giant cell tumor of bone, malignant") )
        setattr(cls, "Embryonal adenocarcinoma",
                PermissibleValue(text="Embryonal adenocarcinoma") )
        setattr(cls, "Cystic hygroma",
                PermissibleValue(text="Cystic hygroma") )
        setattr(cls, "Tumor, benign",
                PermissibleValue(text="Tumor, benign") )
        setattr(cls, "Beta cell tumor, malignant",
                PermissibleValue(text="Beta cell tumor, malignant") )
        setattr(cls, "Hepatocellular carcinoma, fibrolamellar",
                PermissibleValue(text="Hepatocellular carcinoma, fibrolamellar") )
        setattr(cls, "Alpha heavy chain disease",
                PermissibleValue(text="Alpha heavy chain disease") )
        setattr(cls, "Adult T-cell lymphoma/leukemia",
                PermissibleValue(text="Adult T-cell lymphoma/leukemia") )
        setattr(cls, "Sclerosing stromal tumor",
                PermissibleValue(text="Sclerosing stromal tumor") )
        setattr(cls, "Non-invasive FTP",
                PermissibleValue(text="Non-invasive FTP") )
        setattr(cls, "Spongioblastoma, NOS",
                PermissibleValue(text="Spongioblastoma, NOS") )
        setattr(cls, "Adenocarcinoma in situ in tubular adenoma",
                PermissibleValue(text="Adenocarcinoma in situ in tubular adenoma") )
        setattr(cls, "Seromucinous carcinoma",
                PermissibleValue(text="Seromucinous carcinoma",
                                 description="Ovarian Seromucinous Carcinoma") )
        setattr(cls, "Myeloid neoplasms with PDGFRB rearrangement",
                PermissibleValue(text="Myeloid neoplasms with PDGFRB rearrangement") )
        setattr(cls, "Transitional pineal tumor",
                PermissibleValue(text="Transitional pineal tumor") )
        setattr(cls, "Folliculome lipidique",
                PermissibleValue(text="Folliculome lipidique") )
        setattr(cls, "Multiple endocrine adenomas",
                PermissibleValue(text="Multiple endocrine adenomas") )
        setattr(cls, "Intraductal papillary-mucinous adenoma",
                PermissibleValue(text="Intraductal papillary-mucinous adenoma") )
        setattr(cls, "Hodgkin lymphoma, lymphocyte depletion, reticular",
                PermissibleValue(text="Hodgkin lymphoma, lymphocyte depletion, reticular") )
        setattr(cls, "Choriocarcinoma, NOS",
                PermissibleValue(text="Choriocarcinoma, NOS") )
        setattr(cls, "Ossifying fibromyxoid tumor",
                PermissibleValue(text="Ossifying fibromyxoid tumor") )
        setattr(cls, "Spindle cell melanoma, type A",
                PermissibleValue(text="Spindle cell melanoma, type A") )
        setattr(cls, "Infiltrating basal cell carcinoma, non-sclerosing",
                PermissibleValue(text="Infiltrating basal cell carcinoma, non-sclerosing") )
        setattr(cls, "Adrenal cortical carcinoma",
                PermissibleValue(text="Adrenal cortical carcinoma") )
        setattr(cls, "Malignant lymphoma, small cell diffuse",
                PermissibleValue(text="Malignant lymphoma, small cell diffuse") )
        setattr(cls, "Thymoma, atypical, NOS",
                PermissibleValue(text="Thymoma, atypical, NOS") )
        setattr(cls, "Acinar carcinoma",
                PermissibleValue(text="Acinar carcinoma") )
        setattr(cls, "Polymorphic reticulosis",
                PermissibleValue(text="Polymorphic reticulosis") )
        setattr(cls, "Synovial sarcoma, spindle cell",
                PermissibleValue(text="Synovial sarcoma, spindle cell") )
        setattr(cls, "Adult T-cell leukemia",
                PermissibleValue(text="Adult T-cell leukemia") )
        setattr(cls, "Oxyphilic adenocarcinoma",
                PermissibleValue(text="Oxyphilic adenocarcinoma") )
        setattr(cls, "Venous hemangioma",
                PermissibleValue(text="Venous hemangioma") )
        setattr(cls, "Malignant lymphoma, mixed small and large cell, diffuse",
                PermissibleValue(text="Malignant lymphoma, mixed small and large cell, diffuse") )
        setattr(cls, "Pancreatobiliary neoplasm, non-invasive",
                PermissibleValue(text="Pancreatobiliary neoplasm, non-invasive") )
        setattr(cls, "Therapy related myeloid neoplasm",
                PermissibleValue(text="Therapy related myeloid neoplasm") )
        setattr(cls, "Lymphangioendothelioma, malignant",
                PermissibleValue(text="Lymphangioendothelioma, malignant") )
        setattr(cls, "Cystosarcoma phyllodes, benign",
                PermissibleValue(text="Cystosarcoma phyllodes, benign") )
        setattr(cls, "Hepatocellular carcinoma, sarcomatoid",
                PermissibleValue(text="Hepatocellular carcinoma, sarcomatoid") )
        setattr(cls, "Immunoproliferative small intestinal disease",
                PermissibleValue(text="Immunoproliferative small intestinal disease") )
        setattr(cls, "Myeloid sarcoma",
                PermissibleValue(text="Myeloid sarcoma") )
        setattr(cls, "RAEB-T",
                PermissibleValue(text="RAEB-T") )
        setattr(cls, "Transitional cell carcinoma, sarcomatoid",
                PermissibleValue(text="Transitional cell carcinoma, sarcomatoid") )
        setattr(cls, "Chronic myeloproliferative disorder",
                PermissibleValue(text="Chronic myeloproliferative disorder") )
        setattr(cls, "Malignant tumor, small cell type",
                PermissibleValue(text="Malignant tumor, small cell type") )
        setattr(cls, "Pleomorphic lobular carcinoma in situ",
                PermissibleValue(text="Pleomorphic lobular carcinoma in situ") )
        setattr(cls, "Thymoma, mixed type, NOS",
                PermissibleValue(text="Thymoma, mixed type, NOS") )
        setattr(cls, "Hodgkin lymphoma, lymphocyte depletion, NOS",
                PermissibleValue(text="Hodgkin lymphoma, lymphocyte depletion, NOS") )
        setattr(cls, "Solitary mastocytoma of skin",
                PermissibleValue(text="Solitary mastocytoma of skin") )
        setattr(cls, "Malignant reticulosis, NOS",
                PermissibleValue(text="Malignant reticulosis, NOS") )
        setattr(cls, "Testicular stromal tumor",
                PermissibleValue(text="Testicular stromal tumor") )
        setattr(cls, "Acute myeloid leukemia, inv(16)(p13;q22)",
                PermissibleValue(text="Acute myeloid leukemia, inv(16)(p13;q22)") )
        setattr(cls, "Ancient schwannoma",
                PermissibleValue(text="Ancient schwannoma") )
        setattr(cls, "Mixed pineal tumor",
                PermissibleValue(text="Mixed pineal tumor") )
        setattr(cls, "Acute myeloid leukemia without prior myelodysplastic syndrome",
                PermissibleValue(text="Acute myeloid leukemia without prior myelodysplastic syndrome") )
        setattr(cls, "Mucinous cystadenocarcinofibroma",
                PermissibleValue(text="Mucinous cystadenocarcinofibroma") )
        setattr(cls, "Mesonephroma, malignant",
                PermissibleValue(text="Mesonephroma, malignant") )
        setattr(cls, "Undifferentiated high-grade pleomorphic sarcoma",
                PermissibleValue(text="Undifferentiated high-grade pleomorphic sarcoma") )
        setattr(cls, "Lipid-rich carcinoma",
                PermissibleValue(text="Lipid-rich carcinoma") )
        setattr(cls, "Precursor B-cell lymphoblastic leukemia",
                PermissibleValue(text="Precursor B-cell lymphoblastic leukemia") )
        setattr(cls, "Hepatocellular carcinoma, NOS",
                PermissibleValue(text="Hepatocellular carcinoma, NOS") )
        setattr(cls, "Cystoma, NOS",
                PermissibleValue(text="Cystoma, NOS") )
        setattr(cls, "Chondroid chordoma",
                PermissibleValue(text="Chondroid chordoma") )
        setattr(cls, "Wolffian duct carcinoma",
                PermissibleValue(text="Wolffian duct carcinoma") )
        setattr(cls, "Pheochromocytoma, NOS",
                PermissibleValue(text="Pheochromocytoma, NOS") )
        setattr(cls, "Neoplasm, benign",
                PermissibleValue(text="Neoplasm, benign") )
        setattr(cls, "L-cell tumor",
                PermissibleValue(text="L-cell tumor") )
        setattr(cls, "Malignant tumor, clear cell type",
                PermissibleValue(text="Malignant tumor, clear cell type") )
        setattr(cls, "Hydatidiform mole, NOS",
                PermissibleValue(text="Hydatidiform mole, NOS") )
        setattr(cls, "Cerebellar sarcoma, NOS",
                PermissibleValue(text="Cerebellar sarcoma, NOS") )
        setattr(cls, "Germ cell tumor, NOS",
                PermissibleValue(text="Germ cell tumor, NOS") )
        setattr(cls, "Sclerosing rhabdomyosarcoma",
                PermissibleValue(text="Sclerosing rhabdomyosarcoma") )
        setattr(cls, "Juxtacortical chondrosarcoma",
                PermissibleValue(text="Juxtacortical chondrosarcoma") )
        setattr(cls, "Epithelioid cell nevus",
                PermissibleValue(text="Epithelioid cell nevus") )
        setattr(cls, "Inflammatory carcinoma",
                PermissibleValue(text="Inflammatory carcinoma") )
        setattr(cls, "Small cell carcinoma, hypercalcemic type",
                PermissibleValue(text="Small cell carcinoma, hypercalcemic type",
                                 description="Ovarian Small Cell Carcinoma, Hypercalcemic Type") )
        setattr(cls, "Degenerated schwannoma",
                PermissibleValue(text="Degenerated schwannoma") )
        setattr(cls, "Solid carcinoma, NOS",
                PermissibleValue(text="Solid carcinoma, NOS") )
        setattr(cls, "Hepatoid yolk sac tumor",
                PermissibleValue(text="Hepatoid yolk sac tumor") )
        setattr(cls, "Acute myelogenous leukemia",
                PermissibleValue(text="Acute myelogenous leukemia") )
        setattr(cls, "Carcinoma with productive fibrosis",
                PermissibleValue(text="Carcinoma with productive fibrosis") )
        setattr(cls, "Chondroblastoma, NOS",
                PermissibleValue(text="Chondroblastoma, NOS") )
        setattr(cls, "Desmoplastic melanoma, malignant",
                PermissibleValue(text="Desmoplastic melanoma, malignant") )
        setattr(cls, "Goblet cell carcinoid",
                PermissibleValue(text="Goblet cell carcinoid") )
        setattr(cls, "Parietal cell adenocarcinoma",
                PermissibleValue(text="Parietal cell adenocarcinoma") )
        setattr(cls, "Desmoplastic melanoma, amelanotic",
                PermissibleValue(text="Desmoplastic melanoma, amelanotic") )
        setattr(cls, "Cellular ependymoma",
                PermissibleValue(text="Cellular ependymoma") )
        setattr(cls, "Bile duct cystadenoma",
                PermissibleValue(text="Bile duct cystadenoma") )
        setattr(cls, "Intraductal tubular-papillary neoplasm, high grade",
                PermissibleValue(text="Intraductal tubular-papillary neoplasm, high grade") )
        setattr(cls, "Ductal carcinoma in situ, NOS",
                PermissibleValue(text="Ductal carcinoma in situ, NOS") )
        setattr(cls, "Osteosarcoma in Paget disease of bone",
                PermissibleValue(text="Osteosarcoma in Paget disease of bone") )
        setattr(cls, "Multiple meningiomas",
                PermissibleValue(text="Multiple meningiomas") )
        setattr(cls, "Medulloblastoma, SHH-activated and TP53-wildtype",
                PermissibleValue(text="Medulloblastoma, SHH-activated and TP53-wildtype") )
        setattr(cls, "Queyrat erythroplasia",
                PermissibleValue(text="Queyrat erythroplasia") )
        setattr(cls, "Paraganglioma, malignant",
                PermissibleValue(text="Paraganglioma, malignant") )
        setattr(cls, "Serous surface papilloma",
                PermissibleValue(text="Serous surface papilloma") )
        setattr(cls, "Localized fibrous tumor",
                PermissibleValue(text="Localized fibrous tumor") )
        setattr(cls, "Malignant lymphoma, large B-cell, diffuse, NOS",
                PermissibleValue(text="Malignant lymphoma, large B-cell, diffuse, NOS") )
        setattr(cls, "Glucagonoma, malignant",
                PermissibleValue(text="Glucagonoma, malignant") )
        setattr(cls, "Epithelioid sarcoma",
                PermissibleValue(text="Epithelioid sarcoma") )
        setattr(cls, "Teratoid medulloepithelioma",
                PermissibleValue(text="Teratoid medulloepithelioma") )
        setattr(cls, "Subependymal astrocytoma, NOS",
                PermissibleValue(text="Subependymal astrocytoma, NOS") )
        setattr(cls, "Alveolar adenoma",
                PermissibleValue(text="Alveolar adenoma") )
        setattr(cls, "Schwannoma, NOS",
                PermissibleValue(text="Schwannoma, NOS") )
        setattr(cls, "Acute myeloid leukemia with inv(3)(q21q26.2) or t(3;3)(q21;q26.2); RPN1-EVI1",
                PermissibleValue(text="Acute myeloid leukemia with inv(3)(q21q26.2) or t(3;3)(q21;q26.2); RPN1-EVI1") )
        setattr(cls, "Ossifying fibroma",
                PermissibleValue(text="Ossifying fibroma") )
        setattr(cls, "Adenocarcinoma, cribriform comedo-type",
                PermissibleValue(text="Adenocarcinoma, cribriform comedo-type") )
        setattr(cls, "Adamantinoma, malignant",
                PermissibleValue(text="Adamantinoma, malignant") )
        setattr(cls, "Squamous intraepithelial neoplasia, high grade",
                PermissibleValue(text="Squamous intraepithelial neoplasia, high grade") )
        setattr(cls, "Monomorphic adenoma",
                PermissibleValue(text="Monomorphic adenoma") )
        setattr(cls, "FAB M2, AML1(CBF-alpha)/ETO",
                PermissibleValue(text="FAB M2, AML1(CBF-alpha)/ETO") )
        setattr(cls, "Pigmented spindle cell nevus of Reed",
                PermissibleValue(text="Pigmented spindle cell nevus of Reed") )
        setattr(cls, "Malignant lymphoma, nodular, NOS",
                PermissibleValue(text="Malignant lymphoma, nodular, NOS") )
        setattr(cls, "Sweat gland adenoma",
                PermissibleValue(text="Sweat gland adenoma") )
        setattr(cls, "Adenofibroma, NOS",
                PermissibleValue(text="Adenofibroma, NOS") )
        setattr(cls, "Traditional sessile serrated adenoma",
                PermissibleValue(text="Traditional sessile serrated adenoma") )
        setattr(cls, "Basal cell carcinoma, nodular",
                PermissibleValue(text="Basal cell carcinoma, nodular") )
        setattr(cls, "Melanoma, malignant, of soft parts",
                PermissibleValue(text="Melanoma, malignant, of soft parts") )
        setattr(cls, "Sertoli cell adenoma",
                PermissibleValue(text="Sertoli cell adenoma") )
        setattr(cls, "Acute megakaryoblastic leukaemia",
                PermissibleValue(text="Acute megakaryoblastic leukaemia") )
        setattr(cls, "Precursor cell lymphoblastic leukemia, not phenotyped",
                PermissibleValue(text="Precursor cell lymphoblastic leukemia, not phenotyped") )
        setattr(cls, "Choroid plexus papilloma, NOS",
                PermissibleValue(text="Choroid plexus papilloma, NOS") )
        setattr(cls, "B lymphoblastic leukemia/lymphoma, NOS",
                PermissibleValue(text="B lymphoblastic leukemia/lymphoma, NOS") )
        setattr(cls, "RAEB II",
                PermissibleValue(text="RAEB II") )
        setattr(cls, "Unclassified tumor, borderline malignancy",
                PermissibleValue(text="Unclassified tumor, borderline malignancy") )
        setattr(cls, "Pilomatricoma, NOS",
                PermissibleValue(text="Pilomatricoma, NOS") )
        setattr(cls, "Primary cutaneous follicle centre lymphoma",
                PermissibleValue(text="Primary cutaneous follicle centre lymphoma") )
        setattr(cls, "Granular cell carcinoma",
                PermissibleValue(text="Granular cell carcinoma") )
        setattr(cls, "Pituitary adenoma, NOS",
                PermissibleValue(text="Pituitary adenoma, NOS") )
        setattr(cls, "Mature teratoma",
                PermissibleValue(text="Mature teratoma") )
        setattr(cls, "Pleomorphic xanthoastrocytoma",
                PermissibleValue(text="Pleomorphic xanthoastrocytoma") )
        setattr(cls, "Hemangioendothelioma, benign",
                PermissibleValue(text="Hemangioendothelioma, benign") )
        setattr(cls, "Islet cell adenomatosis",
                PermissibleValue(text="Islet cell adenomatosis") )
        setattr(cls, "Mixed tumor, NOS",
                PermissibleValue(text="Mixed tumor, NOS") )
        setattr(cls, "Papillary carcinoma, tall cell",
                PermissibleValue(text="Papillary carcinoma, tall cell") )
        setattr(cls, "Giant cell tumor of tendon sheath",
                PermissibleValue(text="Giant cell tumor of tendon sheath") )
        setattr(cls, "Proliferating trichilemmal tumor",
                PermissibleValue(text="Proliferating trichilemmal tumor") )
        setattr(cls, "Papillary serous cystadenoma, NOS",
                PermissibleValue(text="Papillary serous cystadenoma, NOS") )
        setattr(cls, "Melanocytoma, NOS",
                PermissibleValue(text="Melanocytoma, NOS") )
        setattr(cls, "Follicular lymphoma, grade 2",
                PermissibleValue(text="Follicular lymphoma, grade 2") )
        setattr(cls, "Ossifying fibromyxoid tumor, malignant",
                PermissibleValue(text="Ossifying fibromyxoid tumor, malignant") )
        setattr(cls, "Megakaryocytic myelosclerosis",
                PermissibleValue(text="Megakaryocytic myelosclerosis") )
        setattr(cls, "Sebaceous carcinoma",
                PermissibleValue(text="Sebaceous carcinoma") )
        setattr(cls, "Invasive carcinoma of no special type",
                PermissibleValue(text="Invasive carcinoma of no special type") )
        setattr(cls, "Nodular hidradenoma",
                PermissibleValue(text="Nodular hidradenoma") )
        setattr(cls, "Thymoma, type AB, malignant",
                PermissibleValue(text="Thymoma, type AB, malignant") )
        setattr(cls, "Blastic plasmacytoid dendritic cell neoplasm",
                PermissibleValue(text="Blastic plasmacytoid dendritic cell neoplasm") )
        setattr(cls, "Low grade adenosquamous carcinoma",
                PermissibleValue(text="Low grade adenosquamous carcinoma") )
        setattr(cls, "Nevus, NOS",
                PermissibleValue(text="Nevus, NOS") )
        setattr(cls, "Follicular dendritic cell sarcoma",
                PermissibleValue(text="Follicular dendritic cell sarcoma") )
        setattr(cls, "Acute lymphoblastic leukemia, precursor cell type",
                PermissibleValue(text="Acute lymphoblastic leukemia, precursor cell type") )
        setattr(cls, "Alveolar adenocarcinoma",
                PermissibleValue(text="Alveolar adenocarcinoma") )
        setattr(cls, "Infiltrating papillary adenocarcinoma",
                PermissibleValue(text="Infiltrating papillary adenocarcinoma") )
        setattr(cls, "Mixed embryonal carcinoma and teratoma",
                PermissibleValue(text="Mixed embryonal carcinoma and teratoma") )
        setattr(cls, "Comedocarcinoma, noninfiltrating",
                PermissibleValue(text="Comedocarcinoma, noninfiltrating") )
        setattr(cls, "Diffuse astrocytoma",
                PermissibleValue(text="Diffuse astrocytoma") )
        setattr(cls, "Testicular adenoma",
                PermissibleValue(text="Testicular adenoma") )
        setattr(cls, "Papillary meningioma",
                PermissibleValue(text="Papillary meningioma") )
        setattr(cls, "Juvenile astrocytoma",
                PermissibleValue(text="Juvenile astrocytoma") )
        setattr(cls, "Schneiderian carcinoma",
                PermissibleValue(text="Schneiderian carcinoma") )
        setattr(cls, "Epithelioma, benign",
                PermissibleValue(text="Epithelioma, benign") )
        setattr(cls, "Diffuse leptomeningeal glioneuronal tumor",
                PermissibleValue(text="Diffuse leptomeningeal glioneuronal tumor") )
        setattr(cls, "Adrenal cortical adenoma, mixed cell",
                PermissibleValue(text="Adrenal cortical adenoma, mixed cell") )
        setattr(cls, "Enteroglucagonoma, malignant",
                PermissibleValue(text="Enteroglucagonoma, malignant") )
        setattr(cls, "Mucinous cystic neoplasm with an associated invasive carcinoma",
                PermissibleValue(text="Mucinous cystic neoplasm with an associated invasive carcinoma",
                                 description="Bile Duct Cystadenocarcinoma") )
        setattr(cls, "Fascial fibroma",
                PermissibleValue(text="Fascial fibroma") )
        setattr(cls, "Malignant lymphoma, lymphocytic, poorly differentiated, diffuse",
                PermissibleValue(text="Malignant lymphoma, lymphocytic, poorly differentiated, diffuse") )
        setattr(cls, "Somatostatin cell tumor, malignant",
                PermissibleValue(text="Somatostatin cell tumor, malignant") )
        setattr(cls, "Endometrial stromal sarcoma, NOS",
                PermissibleValue(text="Endometrial stromal sarcoma, NOS") )
        setattr(cls, "Malignant lymphoma, large cell, noncleaved, diffuse",
                PermissibleValue(text="Malignant lymphoma, large cell, noncleaved, diffuse") )
        setattr(cls, "Papillary cystadenoma, borderline malignancy",
                PermissibleValue(text="Papillary cystadenoma, borderline malignancy") )
        setattr(cls, "Amelanotic melanoma",
                PermissibleValue(text="Amelanotic melanoma") )
        setattr(cls, "Langerhans cell granulomatosis, unifocal",
                PermissibleValue(text="Langerhans cell granulomatosis, unifocal") )
        setattr(cls, "Epithelioid leiomyosarcoma",
                PermissibleValue(text="Epithelioid leiomyosarcoma") )
        setattr(cls, "Peripheral T-cell lymphoma, pleomorphic medium and large cell",
                PermissibleValue(text="Peripheral T-cell lymphoma, pleomorphic medium and large cell") )
        setattr(cls, "Myelodysplastic syndrome with 5q deletion (5q-) syndrome",
                PermissibleValue(text="Myelodysplastic syndrome with 5q deletion (5q-) syndrome") )
        setattr(cls, "Endometrioid adenofibroma, borderline malignancy",
                PermissibleValue(text="Endometrioid adenofibroma, borderline malignancy") )
        setattr(cls, "Desmoplastic infantile astrocytoma",
                PermissibleValue(text="Desmoplastic infantile astrocytoma") )
        setattr(cls, "Serous surface papillary tumor of borderline malignancy",
                PermissibleValue(text="Serous surface papillary tumor of borderline malignancy") )
        setattr(cls, "Paget disease and infiltrating duct carcinoma of breast",
                PermissibleValue(text="Paget disease and infiltrating duct carcinoma of breast") )
        setattr(cls, "Malignant myoepithelioma",
                PermissibleValue(text="Malignant myoepithelioma") )
        setattr(cls, "Sertoli cell tumor with lipid storage",
                PermissibleValue(text="Sertoli cell tumor with lipid storage") )
        setattr(cls, "Fibroxanthoma, malignant",
                PermissibleValue(text="Fibroxanthoma, malignant") )
        setattr(cls, "Mucoepidermoid carcinoma",
                PermissibleValue(text="Mucoepidermoid carcinoma",
                                 description="Mucoepidermoid Carcinoma") )
        setattr(cls, "Invasive mucinous adenocarcinoma",
                PermissibleValue(text="Invasive mucinous adenocarcinoma") )
        setattr(cls, "Epithelioid hemangioma",
                PermissibleValue(text="Epithelioid hemangioma") )
        setattr(cls, "Dermoid, NOS",
                PermissibleValue(text="Dermoid, NOS") )
        setattr(cls, "Seminoma, anaplastic",
                PermissibleValue(text="Seminoma, anaplastic") )
        setattr(cls, "Mucocarcinoid tumor",
                PermissibleValue(text="Mucocarcinoid tumor") )
        setattr(cls, "Hodgkin lymphoma, nodular sclerosis, NOS",
                PermissibleValue(text="Hodgkin lymphoma, nodular sclerosis, NOS") )
        setattr(cls, "Mixed small cell carcinoma",
                PermissibleValue(text="Mixed small cell carcinoma") )
        setattr(cls, "Transitional cell papilloma, NOS",
                PermissibleValue(text="Transitional cell papilloma, NOS") )
        setattr(cls, "Smooth muscle tumor of uncertain malignant potential",
                PermissibleValue(text="Smooth muscle tumor of uncertain malignant potential") )
        setattr(cls, "Malignant giant cell tumor of soft parts",
                PermissibleValue(text="Malignant giant cell tumor of soft parts") )
        setattr(cls, "Partial hydatidiform mole",
                PermissibleValue(text="Partial hydatidiform mole") )
        setattr(cls, "Squamous intraepithelial neoplasia, grade III",
                PermissibleValue(text="Squamous intraepithelial neoplasia, grade III") )
        setattr(cls, "Malignant lymphoma, noncleaved, NOS",
                PermissibleValue(text="Malignant lymphoma, noncleaved, NOS") )
        setattr(cls, "Conventional central osteosarcoma",
                PermissibleValue(text="Conventional central osteosarcoma") )
        setattr(cls, "Retinoblastoma, spontaneously regressed",
                PermissibleValue(text="Retinoblastoma, spontaneously regressed") )
        setattr(cls, "Neuroendocrine carcinoma, well-differentiated",
                PermissibleValue(text="Neuroendocrine carcinoma, well-differentiated") )
        setattr(cls, "Primary amyloidosis",
                PermissibleValue(text="Primary amyloidosis") )
        setattr(cls, "Serous adenofibroma, NOS",
                PermissibleValue(text="Serous adenofibroma, NOS") )
        setattr(cls, "Epithelioid mesothelioma, NOS",
                PermissibleValue(text="Epithelioid mesothelioma, NOS") )
        setattr(cls, "T-cell rich large B-cell lymphoma",
                PermissibleValue(text="T-cell rich large B-cell lymphoma") )
        setattr(cls, "Myelodysplastic/myeloproliferative neoplasm, unclassifiable",
                PermissibleValue(text="Myelodysplastic/myeloproliferative neoplasm, unclassifiable") )
        setattr(cls, "Mucinous cystadenofibroma of borderline malignancy",
                PermissibleValue(text="Mucinous cystadenofibroma of borderline malignancy") )
        setattr(cls, "Bronchiolo-alveolar carcinoma, Clara cell",
                PermissibleValue(text="Bronchiolo-alveolar carcinoma, Clara cell") )
        setattr(cls, "Mixed acidophil-basophil adenoma",
                PermissibleValue(text="Mixed acidophil-basophil adenoma") )
        setattr(cls, "Colloid adenocarcinoma",
                PermissibleValue(text="Colloid adenocarcinoma",
                                 description="Lung Mucinous Adenocarcinoma") )
        setattr(cls, "Malignant lymphoma, small cleaved cell, NOS",
                PermissibleValue(text="Malignant lymphoma, small cleaved cell, NOS") )
        setattr(cls, "Lentigo maligna melanoma",
                PermissibleValue(text="Lentigo maligna melanoma",
                                 description="Lentigo Maligna Melanoma") )
        setattr(cls, "c-ALL",
                PermissibleValue(text="c-ALL") )
        setattr(cls, "Neuroendocrine carcinoma, poorly differentiated",
                PermissibleValue(text="Neuroendocrine carcinoma, poorly differentiated") )
        setattr(cls, "Idiopathic thrombocythemia",
                PermissibleValue(text="Idiopathic thrombocythemia") )
        setattr(cls, "Giant cell sarcoma of bone",
                PermissibleValue(text="Giant cell sarcoma of bone") )
        setattr(cls, "Acinar cell carcinoma",
                PermissibleValue(text="Acinar cell carcinoma",
                                 description="Acinar Cell Carcinoma") )
        setattr(cls, "Carotid body tumor",
                PermissibleValue(text="Carotid body tumor") )
        setattr(cls, "Papillary syringadenoma",
                PermissibleValue(text="Papillary syringadenoma") )
        setattr(cls, "Squamous cell carcinoma, large cell, keratinizing",
                PermissibleValue(text="Squamous cell carcinoma, large cell, keratinizing") )
        setattr(cls, "Signet ring cell carcinoma",
                PermissibleValue(text="Signet ring cell carcinoma") )
        setattr(cls, "Papilloma, NOS",
                PermissibleValue(text="Papilloma, NOS") )
        setattr(cls, "Lipoma-like liposarcoma",
                PermissibleValue(text="Lipoma-like liposarcoma") )
        setattr(cls, "Chondromatosis, NOS",
                PermissibleValue(text="Chondromatosis, NOS") )
        setattr(cls, "Basal cell adenoma",
                PermissibleValue(text="Basal cell adenoma") )
        setattr(cls, "Hairy nevus",
                PermissibleValue(text="Hairy nevus") )
        setattr(cls, "Perineurioma, NOS",
                PermissibleValue(text="Perineurioma, NOS") )
        setattr(cls, "Giant cell tumor of tendon sheath, malignant",
                PermissibleValue(text="Giant cell tumor of tendon sheath, malignant") )
        setattr(cls, "Atypical proliferating serous tumor",
                PermissibleValue(text="Atypical proliferating serous tumor") )
        setattr(cls, "Rodent ulcer",
                PermissibleValue(text="Rodent ulcer") )
        setattr(cls, "Primary cutaneous neuroendocrine carcinoma",
                PermissibleValue(text="Primary cutaneous neuroendocrine carcinoma") )
        setattr(cls, "Neuroendocrine carcinoma, moderately differentiated",
                PermissibleValue(text="Neuroendocrine carcinoma, moderately differentiated") )
        setattr(cls, "Carcinoid tumor, argentaffin, NOS",
                PermissibleValue(text="Carcinoid tumor, argentaffin, NOS") )
        setattr(cls, "Basophil carcinoma",
                PermissibleValue(text="Basophil carcinoma") )
        setattr(cls, "Chondroblastoma, malignant",
                PermissibleValue(text="Chondroblastoma, malignant") )
        setattr(cls, "Adenocarcinoma in tubular adenoma",
                PermissibleValue(text="Adenocarcinoma in tubular adenoma") )
        setattr(cls, "Achromic nevus",
                PermissibleValue(text="Achromic nevus") )
        setattr(cls, "Intraductal and lobular carcinoma",
                PermissibleValue(text="Intraductal and lobular carcinoma") )
        setattr(cls, "Hodgkin disease, lymphocyte predominance, NOS",
                PermissibleValue(text="Hodgkin disease, lymphocyte predominance, NOS") )
        setattr(cls, "Diffuse melanocytosis",
                PermissibleValue(text="Diffuse melanocytosis") )
        setattr(cls, "Renal cell adenocarcinoma",
                PermissibleValue(text="Renal cell adenocarcinoma") )
        setattr(cls, "Squamous cell carcinoma, microinvasive",
                PermissibleValue(text="Squamous cell carcinoma, microinvasive") )
        setattr(cls, "Mucin-producing adenocarcinoma",
                PermissibleValue(text="Mucin-producing adenocarcinoma") )
        setattr(cls, "Scirrhous carcinoma",
                PermissibleValue(text="Scirrhous carcinoma") )
        setattr(cls, "Mesothelioma, malignant",
                PermissibleValue(text="Mesothelioma, malignant") )
        setattr(cls, "Carcinoid tumor, NOS",
                PermissibleValue(text="Carcinoid tumor, NOS") )
        setattr(cls, "Gastrointestinal autonomic nerve tumor",
                PermissibleValue(text="Gastrointestinal autonomic nerve tumor") )
        setattr(cls, "Mixed pancreatic endocrine and exocrine tumor, malignant",
                PermissibleValue(text="Mixed pancreatic endocrine and exocrine tumor, malignant") )
        setattr(cls, "Olfactory neurocytoma",
                PermissibleValue(text="Olfactory neurocytoma") )
        setattr(cls, "Pleomorphic adenoma",
                PermissibleValue(text="Pleomorphic adenoma") )
        setattr(cls, "Enteric adenocarcinoma",
                PermissibleValue(text="Enteric adenocarcinoma",
                                 description="Lung Enteric Adenocarcinoma") )
        setattr(cls, "Melanotic psammomatous MPNST",
                PermissibleValue(text="Melanotic psammomatous MPNST") )
        setattr(cls, "Olfactory neurogenic tumor",
                PermissibleValue(text="Olfactory neurogenic tumor") )
        setattr(cls, "Thymoma, benign",
                PermissibleValue(text="Thymoma, benign") )
        setattr(cls, "Malignant lymphoma, noncleaved, diffuse, NOS",
                PermissibleValue(text="Malignant lymphoma, noncleaved, diffuse, NOS") )
        setattr(cls, "Solitary plasmacytoma",
                PermissibleValue(text="Solitary plasmacytoma") )
        setattr(cls, "Jugulotympanic paraganglioma",
                PermissibleValue(text="Jugulotympanic paraganglioma") )
        setattr(cls, "Androblastoma, NOS",
                PermissibleValue(text="Androblastoma, NOS") )
        setattr(cls, "Adenocarcinoma with cartilaginous metaplasia",
                PermissibleValue(text="Adenocarcinoma with cartilaginous metaplasia") )
        setattr(cls, "Junction nevus",
                PermissibleValue(text="Junction nevus") )
        setattr(cls, "Mesenchymoma, malignant",
                PermissibleValue(text="Mesenchymoma, malignant") )
        setattr(cls, "Urothelial carcinoma with trophoblastic differentiation",
                PermissibleValue(text="Urothelial carcinoma with trophoblastic differentiation") )
        setattr(cls, "Metaplastic carcinoma with chondroid differentiation",
                PermissibleValue(text="Metaplastic carcinoma with chondroid differentiation") )
        setattr(cls, "Papillary urothelial carcinoma",
                PermissibleValue(text="Papillary urothelial carcinoma") )
        setattr(cls, "Melanotic neuroectodermal tumor",
                PermissibleValue(text="Melanotic neuroectodermal tumor") )
        setattr(cls, "Nonpigmented nevus",
                PermissibleValue(text="Nonpigmented nevus") )
        setattr(cls, "Seminoma, NOS",
                PermissibleValue(text="Seminoma, NOS") )
        setattr(cls, "Intraepidermal carcinoma, NOS",
                PermissibleValue(text="Intraepidermal carcinoma, NOS") )
        setattr(cls, "Lymphangioma, NOS",
                PermissibleValue(text="Lymphangioma, NOS") )
        setattr(cls, "Carcinoma, anaplastic, NOS",
                PermissibleValue(text="Carcinoma, anaplastic, NOS") )
        setattr(cls, "Classical Hodgkin lymphoma, nodular sclerosis, grade 2",
                PermissibleValue(text="Classical Hodgkin lymphoma, nodular sclerosis, grade 2") )
        setattr(cls, "LCIS, NOS",
                PermissibleValue(text="LCIS, NOS") )
        setattr(cls, "Biphenotypic sinonasal sarcoma",
                PermissibleValue(text="Biphenotypic sinonasal sarcoma",
                                 description="Biphenotypic Sinonasal Sarcoma") )
        setattr(cls, "Meningothelial sarcoma",
                PermissibleValue(text="Meningothelial sarcoma") )
        setattr(cls, "Hurthle cell adenocarcinoma",
                PermissibleValue(text="Hurthle cell adenocarcinoma") )
        setattr(cls, "Pancreatic microadenoma",
                PermissibleValue(text="Pancreatic microadenoma") )
        setattr(cls, "Carcinoma in adenomatous polyp",
                PermissibleValue(text="Carcinoma in adenomatous polyp") )
        setattr(cls, "Basaloid carcinoma",
                PermissibleValue(text="Basaloid carcinoma") )
        setattr(cls, "Squamous cell carcinoma, large cell, nonkeratinizing, NOS",
                PermissibleValue(text="Squamous cell carcinoma, large cell, nonkeratinizing, NOS") )
        setattr(cls, "Ameloblastoma, malignant",
                PermissibleValue(text="Ameloblastoma, malignant") )
        setattr(cls, "Synovioma, malignant",
                PermissibleValue(text="Synovioma, malignant") )
        setattr(cls, "Monocytic leukemia, NOS",
                PermissibleValue(text="Monocytic leukemia, NOS") )
        setattr(cls, "Acute myeloid leukemia, t(15:17)(g22;q11-12)",
                PermissibleValue(text="Acute myeloid leukemia, t(15:17)(g22;q11-12)") )
        setattr(cls, "Fascial fibrosarcoma",
                PermissibleValue(text="Fascial fibrosarcoma") )
        setattr(cls, "Adenocarcinoma of rete ovarii",
                PermissibleValue(text="Adenocarcinoma of rete ovarii") )
        setattr(cls, "Sertoli-Leydig cell tumor, well differentiated",
                PermissibleValue(text="Sertoli-Leydig cell tumor, well differentiated") )
        setattr(cls, "AIN III",
                PermissibleValue(text="AIN III") )
        setattr(cls, "Small cell carcinoma, fusiform cell",
                PermissibleValue(text="Small cell carcinoma, fusiform cell") )
        setattr(cls, "Thymoma, lymphocytic, NOS",
                PermissibleValue(text="Thymoma, lymphocytic, NOS") )
        setattr(cls, "Malignant teratoma, anaplastic",
                PermissibleValue(text="Malignant teratoma, anaplastic") )
        setattr(cls, "Granulosa cell tumor, NOS",
                PermissibleValue(text="Granulosa cell tumor, NOS") )
        setattr(cls, "Acute myelosclerosis, NOS",
                PermissibleValue(text="Acute myelosclerosis, NOS") )
        setattr(cls, "Thymoma, organoid, NOS",
                PermissibleValue(text="Thymoma, organoid, NOS") )
        setattr(cls, "Splenic marginal zone B-cell lymphoma",
                PermissibleValue(text="Splenic marginal zone B-cell lymphoma") )
        setattr(cls, "Bednar tumor",
                PermissibleValue(text="Bednar tumor") )
        setattr(cls, "Intermediate and giant congenital nevus",
                PermissibleValue(text="Intermediate and giant congenital nevus") )
        setattr(cls, "Minimally invasive adenocarcinoma, non-mucinous",
                PermissibleValue(text="Minimally invasive adenocarcinoma, non-mucinous") )
        setattr(cls, "Adenocarcinoma in situ, non-mucinous",
                PermissibleValue(text="Adenocarcinoma in situ, non-mucinous") )
        setattr(cls, "Primary cutaneous CD30+ large T-cell lymphoma",
                PermissibleValue(text="Primary cutaneous CD30+ large T-cell lymphoma") )
        setattr(cls, "Gastrin cell tumor",
                PermissibleValue(text="Gastrin cell tumor") )
        setattr(cls, "Urothelial carcinoma, NOS",
                PermissibleValue(text="Urothelial carcinoma, NOS") )
        setattr(cls, "Hepatocellular carcinoma, scirrhous",
                PermissibleValue(text="Hepatocellular carcinoma, scirrhous") )
        setattr(cls, "Serous cystadenoma, NOS",
                PermissibleValue(text="Serous cystadenoma, NOS") )
        setattr(cls, "Fibroepithelioma, NOS",
                PermissibleValue(text="Fibroepithelioma, NOS") )
        setattr(cls, "Atypical meningioma",
                PermissibleValue(text="Atypical meningioma") )
        setattr(cls, "Reticulosarcoma, NOS",
                PermissibleValue(text="Reticulosarcoma, NOS") )
        setattr(cls, "Cutaneous T-cell lymphoma, NOS",
                PermissibleValue(text="Cutaneous T-cell lymphoma, NOS") )
        setattr(cls, "Grawitz tumor",
                PermissibleValue(text="Grawitz tumor") )
        setattr(cls, "Metaplastic carcinoma, NOS",
                PermissibleValue(text="Metaplastic carcinoma, NOS") )
        setattr(cls, "Malignant lymphoma, large cell, follicular, NOS",
                PermissibleValue(text="Malignant lymphoma, large cell, follicular, NOS") )
        setattr(cls, "Sertoli-Leydig cell tumor, sarcomatoid",
                PermissibleValue(text="Sertoli-Leydig cell tumor, sarcomatoid") )
        setattr(cls, "Cavernous lymphangioma",
                PermissibleValue(text="Cavernous lymphangioma") )
        setattr(cls, "Malignant mucinous cystadenofibroma",
                PermissibleValue(text="Malignant mucinous cystadenofibroma") )
        setattr(cls, "Malignant lymphoma, centroblasticcentrocytic, follicular",
                PermissibleValue(text="Malignant lymphoma, centroblasticcentrocytic, follicular") )
        setattr(cls, "Adnexal tumor, benign",
                PermissibleValue(text="Adnexal tumor, benign") )
        setattr(cls, "Malignant schwannoma with rhabdomyoblastic differentiation",
                PermissibleValue(text="Malignant schwannoma with rhabdomyoblastic differentiation") )
        setattr(cls, "Meningioma, anaplastic",
                PermissibleValue(text="Meningioma, anaplastic") )
        setattr(cls, "Chronic granulocytic leukemia, BCR/ABL",
                PermissibleValue(text="Chronic granulocytic leukemia, BCR/ABL") )
        setattr(cls, "Mucinous cystic tumor with high-grade dysplasia",
                PermissibleValue(text="Mucinous cystic tumor with high-grade dysplasia") )
        setattr(cls, "Eccrine dermal cylindroma",
                PermissibleValue(text="Eccrine dermal cylindroma") )
        setattr(cls, "Granular cell tumor, malignant",
                PermissibleValue(text="Granular cell tumor, malignant") )
        setattr(cls, "Sarcomatosis, NOS",
                PermissibleValue(text="Sarcomatosis, NOS") )
        setattr(cls, "Thymoma, mixed type, malignant",
                PermissibleValue(text="Thymoma, mixed type, malignant") )
        setattr(cls, "Intraductal carcinoma, noninfiltrating, NOS",
                PermissibleValue(text="Intraductal carcinoma, noninfiltrating, NOS") )
        setattr(cls, "Atypical medullary carcinoma",
                PermissibleValue(text="Atypical medullary carcinoma") )
        setattr(cls, "Chronic idiopathic myelofibrosis",
                PermissibleValue(text="Chronic idiopathic myelofibrosis") )
        setattr(cls, "Secondary carcinoma",
                PermissibleValue(text="Secondary carcinoma") )
        setattr(cls, "Serous cystadenoma, borderline malignancy",
                PermissibleValue(text="Serous cystadenoma, borderline malignancy") )
        setattr(cls, "Primary diffuse large B-cell lymphoma of the CNS",
                PermissibleValue(text="Primary diffuse large B-cell lymphoma of the CNS") )
        setattr(cls, "Malignant lymphoma, lymphocytic, intermediate differentiation, diffuse",
                PermissibleValue(text="Malignant lymphoma, lymphocytic, intermediate differentiation, diffuse") )
        setattr(cls, "Acinic cell adenoma",
                PermissibleValue(text="Acinic cell adenoma") )
        setattr(cls, "Struma ovarii, NOS",
                PermissibleValue(text="Struma ovarii, NOS") )
        setattr(cls, "Mycosis fungoides",
                PermissibleValue(text="Mycosis fungoides") )
        setattr(cls, "Endometrioid tumor of low malignant potential",
                PermissibleValue(text="Endometrioid tumor of low malignant potential") )
        setattr(cls, "Chronic myeloid leukemia, NOS",
                PermissibleValue(text="Chronic myeloid leukemia, NOS") )
        setattr(cls, "Primary cutaneous CD30+ T-cell lymphoproliferative disorder",
                PermissibleValue(text="Primary cutaneous CD30+ T-cell lymphoproliferative disorder") )
        setattr(cls, "Cellular fibroma",
                PermissibleValue(text="Cellular fibroma") )
        setattr(cls, "Thymoma, type C",
                PermissibleValue(text="Thymoma, type C") )
        setattr(cls, "FAB M7",
                PermissibleValue(text="FAB M7") )
        setattr(cls, "Meningioma, malignant",
                PermissibleValue(text="Meningioma, malignant") )
        setattr(cls, "Large cell calcifying Sertoli cell tumor",
                PermissibleValue(text="Large cell calcifying Sertoli cell tumor") )
        setattr(cls, "Kaposiform hemangioendothelioma",
                PermissibleValue(text="Kaposiform hemangioendothelioma") )
        setattr(cls, "Clear cell cystadenofibroma of borderline malignancy",
                PermissibleValue(text="Clear cell cystadenofibroma of borderline malignancy") )
        setattr(cls, "NUT carcinoma",
                PermissibleValue(text="NUT carcinoma",
                                 description="NUT Carcinoma") )
        setattr(cls, "Cystic mesothelioma, benign",
                PermissibleValue(text="Cystic mesothelioma, benign") )
        setattr(cls, "Papillary mucinous cystadenoma, borderline malignancy",
                PermissibleValue(text="Papillary mucinous cystadenoma, borderline malignancy") )
        setattr(cls, "Malignant rhabdoid tumor",
                PermissibleValue(text="Malignant rhabdoid tumor") )
        setattr(cls, "Malignant lymphoma, follicle center, follicular",
                PermissibleValue(text="Malignant lymphoma, follicle center, follicular") )
        setattr(cls, "Serous adenocarcinofibroma",
                PermissibleValue(text="Serous adenocarcinofibroma") )
        setattr(cls, "Non-Hodgkin lymphoma, NOS",
                PermissibleValue(text="Non-Hodgkin lymphoma, NOS") )
        setattr(cls, "Fetal lipoma, NOS",
                PermissibleValue(text="Fetal lipoma, NOS") )
        setattr(cls, "Papillotubular adenocarcinoma",
                PermissibleValue(text="Papillotubular adenocarcinoma") )
        setattr(cls, "Combined carcinoid and adenocarcinoma",
                PermissibleValue(text="Combined carcinoid and adenocarcinoma") )
        setattr(cls, "Malignant melanoma in junctional nevus",
                PermissibleValue(text="Malignant melanoma in junctional nevus") )
        setattr(cls, "Langerhans cell histiocytosis, unifocal",
                PermissibleValue(text="Langerhans cell histiocytosis, unifocal") )
        setattr(cls, "Squamous cell carcinoma, adenoid",
                PermissibleValue(text="Squamous cell carcinoma, adenoid") )
        setattr(cls, "Renal carcinoma, collecting duct type",
                PermissibleValue(text="Renal carcinoma, collecting duct type") )
        setattr(cls, "Islet cell tumor, benign",
                PermissibleValue(text="Islet cell tumor, benign") )
        setattr(cls, "Ovarian stromal tumor",
                PermissibleValue(text="Ovarian stromal tumor") )
        setattr(cls, "BALT lymphoma",
                PermissibleValue(text="BALT lymphoma") )
        setattr(cls, "Retinoblastoma, diffuse",
                PermissibleValue(text="Retinoblastoma, diffuse") )
        setattr(cls, "Transitional papilloma, inverted, benign",
                PermissibleValue(text="Transitional papilloma, inverted, benign") )
        setattr(cls, "Urachal carcinoma",
                PermissibleValue(text="Urachal carcinoma") )
        setattr(cls, "Mesothelioma, benign",
                PermissibleValue(text="Mesothelioma, benign") )
        setattr(cls, "Epidermoid carcinoma in situ with questionable stromal invasion",
                PermissibleValue(text="Epidermoid carcinoma in situ with questionable stromal invasion") )
        setattr(cls, "Verrucous carcinoma, NOS",
                PermissibleValue(text="Verrucous carcinoma, NOS") )
        setattr(cls, "Leydig cell tumor, benign",
                PermissibleValue(text="Leydig cell tumor, benign") )
        setattr(cls, "Thymoma, epithelial, malignant",
                PermissibleValue(text="Thymoma, epithelial, malignant") )
        setattr(cls, "Mucous adenocarcinoma",
                PermissibleValue(text="Mucous adenocarcinoma") )
        setattr(cls, "Epithelioid cell sarcoma",
                PermissibleValue(text="Epithelioid cell sarcoma") )
        setattr(cls, "Leydig cell tumor, malignant",
                PermissibleValue(text="Leydig cell tumor, malignant") )
        setattr(cls, "Sclerosing hepatic carcinoma",
                PermissibleValue(text="Sclerosing hepatic carcinoma") )
        setattr(cls, "Urothelial carcinoma with squamous differentiation",
                PermissibleValue(text="Urothelial carcinoma with squamous differentiation") )
        setattr(cls, "Perineurioma, malignant",
                PermissibleValue(text="Perineurioma, malignant") )
        setattr(cls, "Plexiform hemangioma",
                PermissibleValue(text="Plexiform hemangioma") )
        setattr(cls, "Olfactory neuroepithelioma",
                PermissibleValue(text="Olfactory neuroepithelioma") )
        setattr(cls, "Intracystic papillary neoplasm with high grade intraepithelial neoplasia",
                PermissibleValue(text="Intracystic papillary neoplasm with high grade intraepithelial neoplasia") )
        setattr(cls, "Melanotic MPNST",
                PermissibleValue(text="Melanotic MPNST") )
        setattr(cls, "Mixed endocrine and exocrine adenocarcinoma",
                PermissibleValue(text="Mixed endocrine and exocrine adenocarcinoma") )
        setattr(cls, "Pilomatrixoma, NOS",
                PermissibleValue(text="Pilomatrixoma, NOS") )
        setattr(cls, "Colloid adenoma",
                PermissibleValue(text="Colloid adenoma") )
        setattr(cls, "Mixed invasive mucinous and non-mucinous adenocarcinoma",
                PermissibleValue(text="Mixed invasive mucinous and non-mucinous adenocarcinoma") )
        setattr(cls, "Pulmonary artery intimal sarcoma",
                PermissibleValue(text="Pulmonary artery intimal sarcoma") )
        setattr(cls, "Intramuscular hemangioma",
                PermissibleValue(text="Intramuscular hemangioma") )
        setattr(cls, "Lipid-rich urothelial carcinoma",
                PermissibleValue(text="Lipid-rich urothelial carcinoma") )
        setattr(cls, "Mixed germ cell tumor",
                PermissibleValue(text="Mixed germ cell tumor") )
        setattr(cls, "Psammomatous schwannoma",
                PermissibleValue(text="Psammomatous schwannoma") )
        setattr(cls, "Synovioma, benign",
                PermissibleValue(text="Synovioma, benign") )
        setattr(cls, "High-grade serous carcinoma",
                PermissibleValue(text="High-grade serous carcinoma") )
        setattr(cls, "Bronchiolo-alveolar carcinoma, NOS",
                PermissibleValue(text="Bronchiolo-alveolar carcinoma, NOS") )
        setattr(cls, "Triton tumor, malignant",
                PermissibleValue(text="Triton tumor, malignant") )
        setattr(cls, "Malignant histiocytosis",
                PermissibleValue(text="Malignant histiocytosis") )
        setattr(cls, "B cell lymphoma, NOS",
                PermissibleValue(text="B cell lymphoma, NOS") )
        setattr(cls, "Papillary epidermoid carcinoma",
                PermissibleValue(text="Papillary epidermoid carcinoma") )
        setattr(cls, "Embryonal carcinoma, NOS",
                PermissibleValue(text="Embryonal carcinoma, NOS") )
        setattr(cls, "Plasma cell myeloma",
                PermissibleValue(text="Plasma cell myeloma") )
        setattr(cls, "Fibromatosis-like metaplastic carcinoma",
                PermissibleValue(text="Fibromatosis-like metaplastic carcinoma") )
        setattr(cls, "Multiple neurofibromatosis",
                PermissibleValue(text="Multiple neurofibromatosis") )
        setattr(cls, "Round cell carcinoma",
                PermissibleValue(text="Round cell carcinoma") )
        setattr(cls, "Aleukemic lymphocytic leukemia",
                PermissibleValue(text="Aleukemic lymphocytic leukemia") )
        setattr(cls, "Jadassohn blue nevus",
                PermissibleValue(text="Jadassohn blue nevus") )
        setattr(cls, "Infiltrating duct and mucinous carcinoma",
                PermissibleValue(text="Infiltrating duct and mucinous carcinoma") )
        setattr(cls, "Turban tumor",
                PermissibleValue(text="Turban tumor") )
        setattr(cls, "Adult rhabdomyoma",
                PermissibleValue(text="Adult rhabdomyoma") )
        setattr(cls, "Lymphoid leukemia, NOS",
                PermissibleValue(text="Lymphoid leukemia, NOS") )
        setattr(cls, "B-cell lymphoma, unclassifiable, with features intermediate between diffuse large B-cell lymphoma and classical Hodgkin lymphoma",
                PermissibleValue(text="B-cell lymphoma, unclassifiable, with features intermediate between diffuse large B-cell lymphoma and classical Hodgkin lymphoma") )
        setattr(cls, "Multicentric basal cell carcinoma",
                PermissibleValue(text="Multicentric basal cell carcinoma") )
        setattr(cls, "Mixed phenotype acute leukemia with t(9;22)(q34;q11.2); BCR-ABL1",
                PermissibleValue(text="Mixed phenotype acute leukemia with t(9;22)(q34;q11.2); BCR-ABL1") )
        setattr(cls, "Duct carcinoma, desmoplastic type",
                PermissibleValue(text="Duct carcinoma, desmoplastic type") )
        setattr(cls, "Langerhans cell histiocytosis, mono-ostotic",
                PermissibleValue(text="Langerhans cell histiocytosis, mono-ostotic") )
        setattr(cls, "Malignant lymphoma, small lymphocytic, NOS",
                PermissibleValue(text="Malignant lymphoma, small lymphocytic, NOS") )
        setattr(cls, "Adenocarcinoid tumor",
                PermissibleValue(text="Adenocarcinoid tumor") )
        setattr(cls, "Small cell neuroendocrine carcinoma",
                PermissibleValue(text="Small cell neuroendocrine carcinoma",
                                 description="Colorectal Small Cell Neuroendocrine Carcinoma") )
        setattr(cls, "Cylindrical cell carcinoma",
                PermissibleValue(text="Cylindrical cell carcinoma") )
        setattr(cls, "Adenocarcinoma, endocervical type",
                PermissibleValue(text="Adenocarcinoma, endocervical type") )
        setattr(cls, "Odontogenic myxofibroma",
                PermissibleValue(text="Odontogenic myxofibroma") )
        setattr(cls, "Apocrine adenoma",
                PermissibleValue(text="Apocrine adenoma") )
        setattr(cls, "Acute leukemia, Burkitt type",
                PermissibleValue(text="Acute leukemia, Burkitt type") )
        setattr(cls, "Common precursor B ALL",
                PermissibleValue(text="Common precursor B ALL") )
        setattr(cls, "Mixed phenotype acute leukemia, B/myeloid, NOS",
                PermissibleValue(text="Mixed phenotype acute leukemia, B/myeloid, NOS") )
        setattr(cls, "Basal cell carcinoma, desmoplastic type",
                PermissibleValue(text="Basal cell carcinoma, desmoplastic type") )
        setattr(cls, "Telangiectatic osteosarcoma",
                PermissibleValue(text="Telangiectatic osteosarcoma") )
        setattr(cls, "Mucinous cystic tumor with an associated invasive carcinoma",
                PermissibleValue(text="Mucinous cystic tumor with an associated invasive carcinoma") )
        setattr(cls, "Subacute leukemia, NOS",
                PermissibleValue(text="Subacute leukemia, NOS") )
        setattr(cls, "Differentiated-type vulvar intraepithelial neoplasia",
                PermissibleValue(text="Differentiated-type vulvar intraepithelial neoplasia") )
        setattr(cls, "Adenomatoid tumor, NOS",
                PermissibleValue(text="Adenomatoid tumor, NOS") )
        setattr(cls, "Fibrous astrocytoma",
                PermissibleValue(text="Fibrous astrocytoma") )
        setattr(cls, "Central odontogenic fibroma",
                PermissibleValue(text="Central odontogenic fibroma") )
        setattr(cls, "Thymoma, type AB, NOS",
                PermissibleValue(text="Thymoma, type AB, NOS") )
        setattr(cls, "Periductal stromal tumor, low grade",
                PermissibleValue(text="Periductal stromal tumor, low grade") )
        setattr(cls, "Glucagonoma, NOS",
                PermissibleValue(text="Glucagonoma, NOS") )
        setattr(cls, "Fibroma, NOS",
                PermissibleValue(text="Fibroma, NOS") )
        setattr(cls, "Serrated adenoma",
                PermissibleValue(text="Serrated adenoma") )
        setattr(cls, "Water-clear cell adenocarcinoma",
                PermissibleValue(text="Water-clear cell adenocarcinoma") )
        setattr(cls, "Cystic hypersecretory carcinoma",
                PermissibleValue(text="Cystic hypersecretory carcinoma") )
        setattr(cls, "Ductal carcinoma in situ, comedo type",
                PermissibleValue(text="Ductal carcinoma in situ, comedo type") )
        setattr(cls, "Combined small cell-adenocarcinoma",
                PermissibleValue(text="Combined small cell-adenocarcinoma") )
        setattr(cls, "Leptomeningeal sarcoma",
                PermissibleValue(text="Leptomeningeal sarcoma") )
        setattr(cls, "Perineural MPNST",
                PermissibleValue(text="Perineural MPNST") )
        setattr(cls, "Tumor, NOS",
                PermissibleValue(text="Tumor, NOS") )
        setattr(cls, "MPNST with glandular differentiation",
                PermissibleValue(text="MPNST with glandular differentiation") )
        setattr(cls, "Dermoid cyst, NOS",
                PermissibleValue(text="Dermoid cyst, NOS") )
        setattr(cls, "Giant cell sarcoma",
                PermissibleValue(text="Giant cell sarcoma") )
        setattr(cls, "Urothelial carcinoma with divergent differentiation",
                PermissibleValue(text="Urothelial carcinoma with divergent differentiation") )
        setattr(cls, "Juvenile chronic myelomonocytic leukemia",
                PermissibleValue(text="Juvenile chronic myelomonocytic leukemia") )
        setattr(cls, "Hodgkin lymphoma, nodular lymphocyte predominance",
                PermissibleValue(text="Hodgkin lymphoma, nodular lymphocyte predominance") )
        setattr(cls, "Adenocarcinoma in multiple adenomatous polyps",
                PermissibleValue(text="Adenocarcinoma in multiple adenomatous polyps") )
        setattr(cls, "Chromaffin tumor",
                PermissibleValue(text="Chromaffin tumor") )
        setattr(cls, "Carcinoma showing thymus-like element",
                PermissibleValue(text="Carcinoma showing thymus-like element") )
        setattr(cls, "Glandular intraepithelial neoplasia, high grade",
                PermissibleValue(text="Glandular intraepithelial neoplasia, high grade") )
        setattr(cls, "Verrucous papilloma",
                PermissibleValue(text="Verrucous papilloma") )
        setattr(cls, "Brooke tumor",
                PermissibleValue(text="Brooke tumor") )
        setattr(cls, "Therapy-related acute myeloid leukemia, alkylating agent related",
                PermissibleValue(text="Therapy-related acute myeloid leukemia, alkylating agent related") )
        setattr(cls, "Adenocarcinoma combined with other types of carcinoma",
                PermissibleValue(text="Adenocarcinoma combined with other types of carcinoma") )
        setattr(cls, "Osteoid osteoma, NOS",
                PermissibleValue(text="Osteoid osteoma, NOS") )
        setattr(cls, "Minimally invasive adenocarcinoma, mucinous",
                PermissibleValue(text="Minimally invasive adenocarcinoma, mucinous",
                                 description="Mucinous Bronchioloalveolar Carcinoma") )
        setattr(cls, "Stromal endometriosis",
                PermissibleValue(text="Stromal endometriosis") )
        setattr(cls, "Chromaffin paraganglioma",
                PermissibleValue(text="Chromaffin paraganglioma") )
        setattr(cls, "FAB M2, NOS",
                PermissibleValue(text="FAB M2, NOS") )
        setattr(cls, "Hypereosinophilic syndrome",
                PermissibleValue(text="Hypereosinophilic syndrome") )
        setattr(cls, "Polymorphic post transplant lymphoproliferative disorder",
                PermissibleValue(text="Polymorphic post transplant lymphoproliferative disorder") )
        setattr(cls, "Leukemic reticuloendotheliosis",
                PermissibleValue(text="Leukemic reticuloendotheliosis") )
        setattr(cls, "Rhabdoid tumor, NOS",
                PermissibleValue(text="Rhabdoid tumor, NOS") )
        setattr(cls, "Plexiform leiomyoma",
                PermissibleValue(text="Plexiform leiomyoma") )
        setattr(cls, "Hodgkin disease, nodular sclerosis, syncytial variant",
                PermissibleValue(text="Hodgkin disease, nodular sclerosis, syncytial variant") )
        setattr(cls, "Adult T-cell lymphoma",
                PermissibleValue(text="Adult T-cell lymphoma") )
        setattr(cls, "Granular cell adenocarcinoma",
                PermissibleValue(text="Granular cell adenocarcinoma") )
        setattr(cls, "Papillary serous cystadenoma, borderline malignancy",
                PermissibleValue(text="Papillary serous cystadenoma, borderline malignancy") )
        setattr(cls, "Undifferentiated leukaemia",
                PermissibleValue(text="Undifferentiated leukaemia") )
        setattr(cls, "Cervical intraepithelial neoplasia, grade III",
                PermissibleValue(text="Cervical intraepithelial neoplasia, grade III") )
        setattr(cls, "Intestinal T-cell lymphoma",
                PermissibleValue(text="Intestinal T-cell lymphoma") )
        setattr(cls, "Intraosseous low grade osteosarcoma",
                PermissibleValue(text="Intraosseous low grade osteosarcoma") )
        setattr(cls, "Acute myeloid leukemia, NOS",
                PermissibleValue(text="Acute myeloid leukemia, NOS") )
        setattr(cls, "Malignant lymphoma, diffuse, NOS",
                PermissibleValue(text="Malignant lymphoma, diffuse, NOS") )
        setattr(cls, "Myelomonocytic leukemia, NOS",
                PermissibleValue(text="Myelomonocytic leukemia, NOS") )
        setattr(cls, "Mixed type rhabdomyosarcoma",
                PermissibleValue(text="Mixed type rhabdomyosarcoma") )
        setattr(cls, "Classical Hodgkin lymphoma, lymphocyte depletion, reticular",
                PermissibleValue(text="Classical Hodgkin lymphoma, lymphocyte depletion, reticular") )
        setattr(cls, "Pacinian tumor",
                PermissibleValue(text="Pacinian tumor") )
        setattr(cls, "Chorioadenoma destruens",
                PermissibleValue(text="Chorioadenoma destruens") )
        setattr(cls, "Dermoid cyst with secondary tumor",
                PermissibleValue(text="Dermoid cyst with secondary tumor") )
        setattr(cls, "Canalicular adenoma",
                PermissibleValue(text="Canalicular adenoma") )
        setattr(cls, "Post transplant lymphoproliferative disorder, NOS",
                PermissibleValue(text="Post transplant lymphoproliferative disorder, NOS") )
        setattr(cls, "Myelofibrosis as a result of myeloproliferative disease",
                PermissibleValue(text="Myelofibrosis as a result of myeloproliferative disease") )
        setattr(cls, "Struma ovarii and carcinoid",
                PermissibleValue(text="Struma ovarii and carcinoid") )
        setattr(cls, "Reticulum cell sarcoma, diffuse",
                PermissibleValue(text="Reticulum cell sarcoma, diffuse") )
        setattr(cls, "Refractory cytopenia of childhood",
                PermissibleValue(text="Refractory cytopenia of childhood") )
        setattr(cls, "Tubular adenocarcinoma",
                PermissibleValue(text="Tubular adenocarcinoma") )
        setattr(cls, "Neoplasm, malignant",
                PermissibleValue(text="Neoplasm, malignant") )
        setattr(cls, "Atypical proliferative endometrioid tumor",
                PermissibleValue(text="Atypical proliferative endometrioid tumor") )
        setattr(cls, "Malignant hydatidiform mole",
                PermissibleValue(text="Malignant hydatidiform mole") )
        setattr(cls, "Extraosseous plasmacytoma",
                PermissibleValue(text="Extraosseous plasmacytoma") )
        setattr(cls, "Papillary transitional cell carcinoma",
                PermissibleValue(text="Papillary transitional cell carcinoma") )
        setattr(cls, "Chordoid glioma",
                PermissibleValue(text="Chordoid glioma") )
        setattr(cls, "FAB MO",
                PermissibleValue(text="FAB MO") )
        setattr(cls, "Acute progressive histiocytosis X",
                PermissibleValue(text="Acute progressive histiocytosis X") )
        setattr(cls, "Somatostatin cell tumor, NOS",
                PermissibleValue(text="Somatostatin cell tumor, NOS") )
        setattr(cls, "Malignant lymphoma, mixed small cleaved and large cell, follicular",
                PermissibleValue(text="Malignant lymphoma, mixed small cleaved and large cell, follicular") )
        setattr(cls, "Sebaceous adenoma",
                PermissibleValue(text="Sebaceous adenoma") )
        setattr(cls, "Sclerosing sweat duct carcinoma",
                PermissibleValue(text="Sclerosing sweat duct carcinoma") )
        setattr(cls, "Hepatosplenic T-cell lymphoma",
                PermissibleValue(text="Hepatosplenic T-cell lymphoma") )
        setattr(cls, "Adrenal cortical adenoma, compact cell",
                PermissibleValue(text="Adrenal cortical adenoma, compact cell") )
        setattr(cls, "Hemangioendothelioma, NOS",
                PermissibleValue(text="Hemangioendothelioma, NOS") )
        setattr(cls, "Lepidic adenocarcinoma",
                PermissibleValue(text="Lepidic adenocarcinoma") )
        setattr(cls, "Large cell neuroendocrine carcinoma",
                PermissibleValue(text="Large cell neuroendocrine carcinoma") )
        setattr(cls, "Leiomyomatosis, NOS",
                PermissibleValue(text="Leiomyomatosis, NOS") )
        setattr(cls, "Fibrosarcomatous dermatofibrosarcoma protuberans",
                PermissibleValue(text="Fibrosarcomatous dermatofibrosarcoma protuberans") )
        setattr(cls, "Clear cell odontogenic carcinoma",
                PermissibleValue(text="Clear cell odontogenic carcinoma") )
        setattr(cls, "Squamous cell carcinoma, spindle cell",
                PermissibleValue(text="Squamous cell carcinoma, spindle cell") )
        setattr(cls, "Classical Hodgkin lymphoma, lymphocyte depletion, diffuse fibrosis",
                PermissibleValue(text="Classical Hodgkin lymphoma, lymphocyte depletion, diffuse fibrosis") )
        setattr(cls, "Alpha cell tumor, NOS",
                PermissibleValue(text="Alpha cell tumor, NOS") )
        setattr(cls, "Well differentiated papillary mesothelioma, benign",
                PermissibleValue(text="Well differentiated papillary mesothelioma, benign") )
        setattr(cls, "Basophil adenocarcinoma",
                PermissibleValue(text="Basophil adenocarcinoma") )
        setattr(cls, "NK/T-cell lymphoma, nasal and nasal-type",
                PermissibleValue(text="NK/T-cell lymphoma, nasal and nasal-type") )
        setattr(cls, "Granulosa cell tumor, juvenile",
                PermissibleValue(text="Granulosa cell tumor, juvenile") )
        setattr(cls, "Primary serous papillary carcinoma of peritoneum",
                PermissibleValue(text="Primary serous papillary carcinoma of peritoneum") )
        setattr(cls, "Gastrinoma, malignant",
                PermissibleValue(text="Gastrinoma, malignant") )
        setattr(cls, "Cylindroma, NOS",
                PermissibleValue(text="Cylindroma, NOS") )
        setattr(cls, "Myelocytic leukemia, NOS",
                PermissibleValue(text="Myelocytic leukemia, NOS") )
        setattr(cls, "Combined small cell carcinoma",
                PermissibleValue(text="Combined small cell carcinoma") )
        setattr(cls, "Granulosa cell tumor, adult type",
                PermissibleValue(text="Granulosa cell tumor, adult type",
                                 description="Adult Type Ovarian Granulosa Cell Tumor") )
        setattr(cls, "Malignant lymphoma, centroblastic, follicular",
                PermissibleValue(text="Malignant lymphoma, centroblastic, follicular") )
        setattr(cls, "Hidradenoma, NOS",
                PermissibleValue(text="Hidradenoma, NOS") )
        setattr(cls, "Adenomatous polyp, NOS",
                PermissibleValue(text="Adenomatous polyp, NOS") )
        setattr(cls, "Juvenile nevus",
                PermissibleValue(text="Juvenile nevus") )
        setattr(cls, "Enterochromaffin-like cell tumor, malignant",
                PermissibleValue(text="Enterochromaffin-like cell tumor, malignant") )
        setattr(cls, "Atypical proliferative papillary serous tumor",
                PermissibleValue(text="Atypical proliferative papillary serous tumor") )
        setattr(cls, "Pigmented adenoma",
                PermissibleValue(text="Pigmented adenoma") )
        setattr(cls, "Acquired cystic disease-associated renal cell carcinoma (RCC)",
                PermissibleValue(text="Acquired cystic disease-associated renal cell carcinoma (RCC)") )
        setattr(cls, "Epithelial ependymoma",
                PermissibleValue(text="Epithelial ependymoma") )
        setattr(cls, "Bronchiolo-alveolar carcinoma, Clara cell and goblet cell type",
                PermissibleValue(text="Bronchiolo-alveolar carcinoma, Clara cell and goblet cell type") )
        setattr(cls, "Giant cell carcinoma",
                PermissibleValue(text="Giant cell carcinoma") )
        setattr(cls, "Gelatinous carcinoma",
                PermissibleValue(text="Gelatinous carcinoma") )
        setattr(cls, "Pilocytic astrocytoma",
                PermissibleValue(text="Pilocytic astrocytoma") )
        setattr(cls, "Immunoblastic sarcoma",
                PermissibleValue(text="Immunoblastic sarcoma") )
        setattr(cls, "Benign fibrous histiocytoma",
                PermissibleValue(text="Benign fibrous histiocytoma") )
        setattr(cls, "Verrucous squamous cell carcinoma",
                PermissibleValue(text="Verrucous squamous cell carcinoma") )
        setattr(cls, "Rhabdomyosarcoma with ganglionic differentiation",
                PermissibleValue(text="Rhabdomyosarcoma with ganglionic differentiation") )
        setattr(cls, "Hemangiopericytoma, NOS",
                PermissibleValue(text="Hemangiopericytoma, NOS") )
        setattr(cls, "Tumor cells, uncertain whether benign or malignant",
                PermissibleValue(text="Tumor cells, uncertain whether benign or malignant") )
        setattr(cls, "Glioma, NOS",
                PermissibleValue(text="Glioma, NOS") )
        setattr(cls, "Invasive mole, NOS",
                PermissibleValue(text="Invasive mole, NOS") )
        setattr(cls, "Malignant lymphoma, follicular, NOS",
                PermissibleValue(text="Malignant lymphoma, follicular, NOS") )
        setattr(cls, "Glioblastoma with sarcomatous component",
                PermissibleValue(text="Glioblastoma with sarcomatous component") )
        setattr(cls, "Lymphoproliferative disease, NOS",
                PermissibleValue(text="Lymphoproliferative disease, NOS") )
        setattr(cls, "Solitary fibrous tumor/hemangiopericytoma Grade 3 (CNS)",
                PermissibleValue(text="Solitary fibrous tumor/hemangiopericytoma Grade 3 (CNS)") )
        setattr(cls, "Lennert lymphoma",
                PermissibleValue(text="Lennert lymphoma") )
        setattr(cls, "Infiltrating duct and cribriform carcinoma",
                PermissibleValue(text="Infiltrating duct and cribriform carcinoma") )
        setattr(cls, "Refractory anemia with sideroblasts",
                PermissibleValue(text="Refractory anemia with sideroblasts") )
        setattr(cls, "Signet ring cell adenocarcinoma",
                PermissibleValue(text="Signet ring cell adenocarcinoma") )
        setattr(cls, "Bronchiolo-alveolar carcinoma; type II pneumocyte",
                PermissibleValue(text="Bronchiolo-alveolar carcinoma; type II pneumocyte") )
        setattr(cls, "Acute myeloid leukemia with t(9;11)(p22;q23); MLLT3-MLL",
                PermissibleValue(text="Acute myeloid leukemia with t(9;11)(p22;q23); MLLT3-MLL") )
        setattr(cls, "Mixed epithelioid and spindle cell melanoma",
                PermissibleValue(text="Mixed epithelioid and spindle cell melanoma") )
        setattr(cls, "Malignant tenosynovial giant cell tumor",
                PermissibleValue(text="Malignant tenosynovial giant cell tumor") )
        setattr(cls, "Gelatinous adenocarcinoma",
                PermissibleValue(text="Gelatinous adenocarcinoma") )
        setattr(cls, "Columnar cell papilloma",
                PermissibleValue(text="Columnar cell papilloma") )
        setattr(cls, "Malignant eccrine spiradenoma",
                PermissibleValue(text="Malignant eccrine spiradenoma") )
        setattr(cls, "Insular carcinoma",
                PermissibleValue(text="Insular carcinoma") )
        setattr(cls, "Low-grade myofibroblastic sarcoma",
                PermissibleValue(text="Low-grade myofibroblastic sarcoma") )
        setattr(cls, "Chronic myelomonocytic leukemia, NOS",
                PermissibleValue(text="Chronic myelomonocytic leukemia, NOS") )
        setattr(cls, "Intratubular germ cell neoplasia",
                PermissibleValue(text="Intratubular germ cell neoplasia") )
        setattr(cls, "T-cell large granular lymphocytosis",
                PermissibleValue(text="T-cell large granular lymphocytosis") )
        setattr(cls, "Mucinous cystadenofibroma, NOS",
                PermissibleValue(text="Mucinous cystadenofibroma, NOS") )
        setattr(cls, "Interstitial cell tumor, malignant",
                PermissibleValue(text="Interstitial cell tumor, malignant") )
        setattr(cls, "Acute myeloid leukemia, MLL",
                PermissibleValue(text="Acute myeloid leukemia, MLL") )
        setattr(cls, "Solid papillary carcinoma in situ",
                PermissibleValue(text="Solid papillary carcinoma in situ") )
        setattr(cls, "Intraepithelial squamous cell carcinoma",
                PermissibleValue(text="Intraepithelial squamous cell carcinoma") )
        setattr(cls, "Astrocytoma, low grade",
                PermissibleValue(text="Astrocytoma, low grade") )
        setattr(cls, "Infiltrating duct and lobular carcinoma",
                PermissibleValue(text="Infiltrating duct and lobular carcinoma") )
        setattr(cls, "Plexiform neurofibroma",
                PermissibleValue(text="Plexiform neurofibroma") )
        setattr(cls, "Myxoinflammatory fibroblastic sarcoma (MIFS)",
                PermissibleValue(text="Myxoinflammatory fibroblastic sarcoma (MIFS)") )
        setattr(cls, "Skin appendage carcinoma",
                PermissibleValue(text="Skin appendage carcinoma") )
        setattr(cls, "Periosteal fibroma",
                PermissibleValue(text="Periosteal fibroma") )
        setattr(cls, "Verrucous keratotic hemangioma",
                PermissibleValue(text="Verrucous keratotic hemangioma") )
        setattr(cls, "Mast cell leukaemia",
                PermissibleValue(text="Mast cell leukaemia") )
        setattr(cls, "Tubulovillous adenoma, NOS",
                PermissibleValue(text="Tubulovillous adenoma, NOS") )
        setattr(cls, "Intracanalicular fibroadenoma",
                PermissibleValue(text="Intracanalicular fibroadenoma") )
        setattr(cls, "Mucinous cystadenocarcinoma, NOS",
                PermissibleValue(text="Mucinous cystadenocarcinoma, NOS") )
        setattr(cls, "Ductal carcinoma in situ, micropapillary",
                PermissibleValue(text="Ductal carcinoma in situ, micropapillary") )
        setattr(cls, "Sinonasal papilloma, fungiform",
                PermissibleValue(text="Sinonasal papilloma, fungiform") )
        setattr(cls, "Small cell carcinoma, NOS",
                PermissibleValue(text="Small cell carcinoma, NOS") )
        setattr(cls, "Carcinoma, NOS",
                PermissibleValue(text="Carcinoma, NOS") )
        setattr(cls, "Precursor cell lymphoblastic lymphoma, NOS",
                PermissibleValue(text="Precursor cell lymphoblastic lymphoma, NOS") )
        setattr(cls, "DIN 3",
                PermissibleValue(text="DIN 3") )
        setattr(cls, "Retinoblastoma, NOS",
                PermissibleValue(text="Retinoblastoma, NOS") )
        setattr(cls, "Serous surface papillary carcinoma",
                PermissibleValue(text="Serous surface papillary carcinoma") )
        setattr(cls, "Endometrioid carcinoma with squamous differentiation",
                PermissibleValue(text="Endometrioid carcinoma with squamous differentiation",
                                 description="Endometrial Squamous Cell Carcinoma") )
        setattr(cls, "Syncytial meningioma",
                PermissibleValue(text="Syncytial meningioma") )
        setattr(cls, "Mucinous adenofibroma, NOS",
                PermissibleValue(text="Mucinous adenofibroma, NOS") )
        setattr(cls, "Mucinous cystic neoplasm with high-grade dysplasia",
                PermissibleValue(text="Mucinous cystic neoplasm with high-grade dysplasia") )
        setattr(cls, "Malignant lymphoma, lymphocytic, nodular, NOS",
                PermissibleValue(text="Malignant lymphoma, lymphocytic, nodular, NOS") )
        setattr(cls, "Duct adenoma, NOS",
                PermissibleValue(text="Duct adenoma, NOS") )
        setattr(cls, "Intracystic papillary tumor with high grade dysplasia",
                PermissibleValue(text="Intracystic papillary tumor with high grade dysplasia") )
        setattr(cls, "Adenocarcinoma in situ in tubulovillous adenoma",
                PermissibleValue(text="Adenocarcinoma in situ in tubulovillous adenoma") )
        setattr(cls, "Cystadenoma, NOS",
                PermissibleValue(text="Cystadenoma, NOS") )
        setattr(cls, "Follicular lymphoma, grade 3A",
                PermissibleValue(text="Follicular lymphoma, grade 3A") )
        setattr(cls, "Cemento-ossifying fibroma",
                PermissibleValue(text="Cemento-ossifying fibroma") )
        setattr(cls, "Aortic body paraganglioma",
                PermissibleValue(text="Aortic body paraganglioma") )
        setattr(cls, "Mixed ductal-endocrine carcinoma",
                PermissibleValue(text="Mixed ductal-endocrine carcinoma") )
        setattr(cls, "Intraductal papillary carcinoma",
                PermissibleValue(text="Intraductal papillary carcinoma") )
        setattr(cls, "Intraductal papillary-mucinous neoplasm with moderate dysplasia",
                PermissibleValue(text="Intraductal papillary-mucinous neoplasm with moderate dysplasia") )
        setattr(cls, "Glandular intraepithelial neoplasia, grade II",
                PermissibleValue(text="Glandular intraepithelial neoplasia, grade II") )
        setattr(cls, "Minimally invasive adenocarcinoma, NOS",
                PermissibleValue(text="Minimally invasive adenocarcinoma, NOS") )
        setattr(cls, "Mucinous adenofibroma of borderline malignancy",
                PermissibleValue(text="Mucinous adenofibroma of borderline malignancy") )
        setattr(cls, "Sarcoma botryoides",
                PermissibleValue(text="Sarcoma botryoides") )
        setattr(cls, "Subacute myelogenous leukemia",
                PermissibleValue(text="Subacute myelogenous leukemia") )
        setattr(cls, "Aggressive digital papillary adenoma",
                PermissibleValue(text="Aggressive digital papillary adenoma") )
        setattr(cls, "Juvenile myelomonocytic leukemia",
                PermissibleValue(text="Juvenile myelomonocytic leukemia") )
        setattr(cls, "Myofibroblastic tumor, peribronchial",
                PermissibleValue(text="Myofibroblastic tumor, peribronchial") )
        setattr(cls, "Reticulosarcoma, diffuse",
                PermissibleValue(text="Reticulosarcoma, diffuse") )
        setattr(cls, "Tumor cells, NOS",
                PermissibleValue(text="Tumor cells, NOS") )
        setattr(cls, "Spindle cell oncocytoma",
                PermissibleValue(text="Spindle cell oncocytoma") )
        setattr(cls, "Embryonal rhabdomyosarcoma, NOS",
                PermissibleValue(text="Embryonal rhabdomyosarcoma, NOS") )
        setattr(cls, "Proliferative dermal lesion in congenital nevus",
                PermissibleValue(text="Proliferative dermal lesion in congenital nevus") )
        setattr(cls, "Malignant lymphoma, lymphocytic, well differentiated, diffuse",
                PermissibleValue(text="Malignant lymphoma, lymphocytic, well differentiated, diffuse") )
        setattr(cls, "Hydatid mole",
                PermissibleValue(text="Hydatid mole") )
        setattr(cls, "Acinic cell tumor",
                PermissibleValue(text="Acinic cell tumor") )
        setattr(cls, "Malignant lymphoma, mixed cell type, follicular",
                PermissibleValue(text="Malignant lymphoma, mixed cell type, follicular") )
        setattr(cls, "Clear cell meningioma",
                PermissibleValue(text="Clear cell meningioma") )
        setattr(cls, "G cell tumor, malignant",
                PermissibleValue(text="G cell tumor, malignant") )
        setattr(cls, "Eccrine adenocarcinoma",
                PermissibleValue(text="Eccrine adenocarcinoma") )
        setattr(cls, "Chondromatous giant cell tumor",
                PermissibleValue(text="Chondromatous giant cell tumor") )
        setattr(cls, "Pigmented nevus, NOS",
                PermissibleValue(text="Pigmented nevus, NOS") )
        setattr(cls, "Adenomatosis, NOS",
                PermissibleValue(text="Adenomatosis, NOS") )
        setattr(cls, "Esophageal glandular dysplasia (intraepithelial neoplasia), low grade",
                PermissibleValue(text="Esophageal glandular dysplasia (intraepithelial neoplasia), low grade") )
        setattr(cls, "Lymphoplasmacyte-rich meningioma",
                PermissibleValue(text="Lymphoplasmacyte-rich meningioma") )
        setattr(cls, "Medullary carcinoma with lymphoid stroma",
                PermissibleValue(text="Medullary carcinoma with lymphoid stroma") )
        setattr(cls, "Langerhans cell histiocytosis, NOS",
                PermissibleValue(text="Langerhans cell histiocytosis, NOS") )
        setattr(cls, "Teratoma, benign",
                PermissibleValue(text="Teratoma, benign") )
        setattr(cls, "Peripheral T-cell lymphoma, NOS",
                PermissibleValue(text="Peripheral T-cell lymphoma, NOS") )
        setattr(cls, "Smooth muscle tumor, NOS",
                PermissibleValue(text="Smooth muscle tumor, NOS") )
        setattr(cls, "Adenocarcinoma in tubolovillous adenoma",
                PermissibleValue(text="Adenocarcinoma in tubolovillous adenoma") )
        setattr(cls, "Lipid cell tumor of ovary",
                PermissibleValue(text="Lipid cell tumor of ovary") )
        setattr(cls, "Adrenal rest tumor",
                PermissibleValue(text="Adrenal rest tumor") )
        setattr(cls, "Mesonephric adenoma",
                PermissibleValue(text="Mesonephric adenoma") )
        setattr(cls, "Mixed embryonal rhabdomyosarcoma and alveolar rhabdomyosarcoma",
                PermissibleValue(text="Mixed embryonal rhabdomyosarcoma and alveolar rhabdomyosarcoma") )
        setattr(cls, "Aleukemic lymphoid leukemia",
                PermissibleValue(text="Aleukemic lymphoid leukemia") )
        setattr(cls, "Carcinoid tumor, NOS, of appendix",
                PermissibleValue(text="Carcinoid tumor, NOS, of appendix") )
        setattr(cls, "FAB Ll",
                PermissibleValue(text="FAB Ll") )
        setattr(cls, "Clear cell sarcoma of kidney",
                PermissibleValue(text="Clear cell sarcoma of kidney") )
        setattr(cls, "Serous cystadenofibroma of borderline malignancy",
                PermissibleValue(text="Serous cystadenofibroma of borderline malignancy") )
        setattr(cls, "Therapy-related myelodysplastic syndrome, NOS",
                PermissibleValue(text="Therapy-related myelodysplastic syndrome, NOS") )
        setattr(cls, "Granular cell myoblastoma, malignant",
                PermissibleValue(text="Granular cell myoblastoma, malignant") )
        setattr(cls, "Mucinous adenocarcinoma, endocervical type",
                PermissibleValue(text="Mucinous adenocarcinoma, endocervical type") )
        setattr(cls, "Tumor cells, malignant",
                PermissibleValue(text="Tumor cells, malignant") )
        setattr(cls, "Chronic lymphatic leukemia",
                PermissibleValue(text="Chronic lymphatic leukemia") )
        setattr(cls, "Embryonal rhabdomyosarcoma, pleomorphic",
                PermissibleValue(text="Embryonal rhabdomyosarcoma, pleomorphic") )
        setattr(cls, "Langerhans cell granulomatosis",
                PermissibleValue(text="Langerhans cell granulomatosis") )
        setattr(cls, "Intraductal papillary mucinous neoplasm with high grade dysplasia",
                PermissibleValue(text="Intraductal papillary mucinous neoplasm with high grade dysplasia") )
        setattr(cls, "Melanocytic nevus",
                PermissibleValue(text="Melanocytic nevus") )
        setattr(cls, "MiT family translocation renal cell carcinoma",
                PermissibleValue(text="MiT family translocation renal cell carcinoma",
                                 description="MiT Family Translocation-Associated Renal Cell Carcinoma") )
        setattr(cls, "Ductal carcinoma in situ, papillary",
                PermissibleValue(text="Ductal carcinoma in situ, papillary") )
        setattr(cls, "Lymphosarcoma cell leukemia",
                PermissibleValue(text="Lymphosarcoma cell leukemia") )
        setattr(cls, "Fibroblastic reticular cell tumor",
                PermissibleValue(text="Fibroblastic reticular cell tumor") )
        setattr(cls, "Angiocentric T-cell lymphoma",
                PermissibleValue(text="Angiocentric T-cell lymphoma") )
        setattr(cls, "Mesonephroma, benign",
                PermissibleValue(text="Mesonephroma, benign") )
        setattr(cls, "Invasive mammary carcinoma",
                PermissibleValue(text="Invasive mammary carcinoma") )
        setattr(cls, "Neuroendocrine tumor, grade 2",
                PermissibleValue(text="Neuroendocrine tumor, grade 2") )
        setattr(cls, "Acute myeloid leukemia with multilineage dysplasia",
                PermissibleValue(text="Acute myeloid leukemia with multilineage dysplasia") )
        setattr(cls, "Anaplastic large cell lymphoma, ALK positive",
                PermissibleValue(text="Anaplastic large cell lymphoma, ALK positive") )
        setattr(cls, "Adult granulosa cell tumor",
                PermissibleValue(text="Adult granulosa cell tumor") )
        setattr(cls, "Mast cell sarcoma",
                PermissibleValue(text="Mast cell sarcoma") )
        setattr(cls, "Transitional carcinoma",
                PermissibleValue(text="Transitional carcinoma") )
        setattr(cls, "Chronic myelogenous leukemia, t(9;22)(q34;q11)",
                PermissibleValue(text="Chronic myelogenous leukemia, t(9;22)(q34;q11)") )
        setattr(cls, "Adnexal carcinoma",
                PermissibleValue(text="Adnexal carcinoma") )
        setattr(cls, "Combined small cell-squamous cell carcinoma",
                PermissibleValue(text="Combined small cell-squamous cell carcinoma") )
        setattr(cls, "Refractory cytopenia with multilineage dysplasia",
                PermissibleValue(text="Refractory cytopenia with multilineage dysplasia") )
        setattr(cls, "Giant cell angiofibroma",
                PermissibleValue(text="Giant cell angiofibroma") )
        setattr(cls, "Anaplastic astrocytoma, IDH-mutant",
                PermissibleValue(text="Anaplastic astrocytoma, IDH-mutant") )
        setattr(cls, "Acinic cell adenocarcinoma",
                PermissibleValue(text="Acinic cell adenocarcinoma") )
        setattr(cls, "Mucinous cystic neoplasm with intermediate-grade intraepithelial neoplasia",
                PermissibleValue(text="Mucinous cystic neoplasm with intermediate-grade intraepithelial neoplasia") )
        setattr(cls, "Malignant teratoma, undifferentiated",
                PermissibleValue(text="Malignant teratoma, undifferentiated") )
        setattr(cls, "Pre-T ALL",
                PermissibleValue(text="Pre-T ALL") )
        setattr(cls, "Sex cord-gonadal stromal tumor, NOS",
                PermissibleValue(text="Sex cord-gonadal stromal tumor, NOS") )
        setattr(cls, "Small congenital nevus",
                PermissibleValue(text="Small congenital nevus") )
        setattr(cls, "Chondroblastic osteosarcoma",
                PermissibleValue(text="Chondroblastic osteosarcoma") )
        setattr(cls, "Gastrointestinal pacemaker cell tumor",
                PermissibleValue(text="Gastrointestinal pacemaker cell tumor") )
        setattr(cls, "Sympathetic paraganglioma",
                PermissibleValue(text="Sympathetic paraganglioma") )
        setattr(cls, "Noninvasive pancreatobiliary papillary neoplasm with low grade intraepithelial neoplasia",
                PermissibleValue(text="Noninvasive pancreatobiliary papillary neoplasm with low grade intraepithelial neoplasia") )
        setattr(cls, "Germ cell tumor, nonseminomatous",
                PermissibleValue(text="Germ cell tumor, nonseminomatous") )
        setattr(cls, "Follicular carcinoma, encapsulated",
                PermissibleValue(text="Follicular carcinoma, encapsulated") )
        setattr(cls, "Giant osteoid osteoma",
                PermissibleValue(text="Giant osteoid osteoma") )
        setattr(cls, "Sweat gland tumor, benign",
                PermissibleValue(text="Sweat gland tumor, benign") )
        setattr(cls, "Periapical cemento-osseous dysplasia",
                PermissibleValue(text="Periapical cemento-osseous dysplasia") )
        setattr(cls, "Intracystic papilloma",
                PermissibleValue(text="Intracystic papilloma") )
        setattr(cls, "Thecoma, malignant",
                PermissibleValue(text="Thecoma, malignant") )
        setattr(cls, "Papillotubular adenoma",
                PermissibleValue(text="Papillotubular adenoma") )
        setattr(cls, "Renal cell carcinoma, NOS",
                PermissibleValue(text="Renal cell carcinoma, NOS") )
        setattr(cls, "B lymphoblastic leukemia/lymphoma with t(1;19)(q23;p13.3); E2A-PBX1 (TCF3-PBX1)",
                PermissibleValue(text="B lymphoblastic leukemia/lymphoma with t(1;19)(q23;p13.3); E2A-PBX1 (TCF3-PBX1)") )
        setattr(cls, "Fibrous papule of nose",
                PermissibleValue(text="Fibrous papule of nose") )
        setattr(cls, "Intraductal papillary-mucinous tumor with moderate dysplasia",
                PermissibleValue(text="Intraductal papillary-mucinous tumor with moderate dysplasia") )
        setattr(cls, "Diffuse large B-cell lymphoma associated with chronic inflammation",
                PermissibleValue(text="Diffuse large B-cell lymphoma associated with chronic inflammation") )
        setattr(cls, "Low-grade serous carcinoma",
                PermissibleValue(text="Low-grade serous carcinoma") )
        setattr(cls, "Myeloid leukemia, NOS",
                PermissibleValue(text="Myeloid leukemia, NOS") )
        setattr(cls, "PTLD, NOS",
                PermissibleValue(text="PTLD, NOS") )
        setattr(cls, "Malignant chondroid syringoma",
                PermissibleValue(text="Malignant chondroid syringoma") )
        setattr(cls, "Halo nevus",
                PermissibleValue(text="Halo nevus") )
        setattr(cls, "Thymoma, medullary, malignant",
                PermissibleValue(text="Thymoma, medullary, malignant") )
        setattr(cls, "Carcinoid, NOS",
                PermissibleValue(text="Carcinoid, NOS") )
        setattr(cls, "Polar spongioblastoma",
                PermissibleValue(text="Polar spongioblastoma") )
        setattr(cls, "Meningeal melanocytoma",
                PermissibleValue(text="Meningeal melanocytoma") )
        setattr(cls, "Alveolar rhabdomyosarcoma",
                PermissibleValue(text="Alveolar rhabdomyosarcoma") )
        setattr(cls, "Teratoma, differentiated",
                PermissibleValue(text="Teratoma, differentiated") )
        setattr(cls, "Spiradenoma, NOS",
                PermissibleValue(text="Spiradenoma, NOS") )
        setattr(cls, "Acute bilineal leukemia",
                PermissibleValue(text="Acute bilineal leukemia") )
        setattr(cls, "Follicular adenoma",
                PermissibleValue(text="Follicular adenoma") )
        setattr(cls, "Serous borderline tumor-micropapillary variant",
                PermissibleValue(text="Serous borderline tumor-micropapillary variant") )
        setattr(cls, "Gemistocytic astrocytoma",
                PermissibleValue(text="Gemistocytic astrocytoma") )
        setattr(cls, "Squamous papilloma",
                PermissibleValue(text="Squamous papilloma") )
        setattr(cls, "Infiltrating duct and lobular carcinoma in situ",
                PermissibleValue(text="Infiltrating duct and lobular carcinoma in situ") )
        setattr(cls, "Fibrosarcoma, NOS",
                PermissibleValue(text="Fibrosarcoma, NOS") )
        setattr(cls, "Malignant lymphoma, large cell, noncleaved, follicular",
                PermissibleValue(text="Malignant lymphoma, large cell, noncleaved, follicular") )
        setattr(cls, "Angiofibroma, NOS",
                PermissibleValue(text="Angiofibroma, NOS") )
        setattr(cls, "Placental site trophoblastic tumor",
                PermissibleValue(text="Placental site trophoblastic tumor") )
        setattr(cls, "Cerebellar liponeurocytoma",
                PermissibleValue(text="Cerebellar liponeurocytoma") )
        setattr(cls, "Theca cell tumor",
                PermissibleValue(text="Theca cell tumor") )
        setattr(cls, "Bizarre leiomyoma",
                PermissibleValue(text="Bizarre leiomyoma") )
        setattr(cls, "Cementifying fibroma",
                PermissibleValue(text="Cementifying fibroma") )
        setattr(cls, "Squamous odontogenic tumor",
                PermissibleValue(text="Squamous odontogenic tumor") )
        setattr(cls, "Osteoblastic sarcoma",
                PermissibleValue(text="Osteoblastic sarcoma") )
        setattr(cls, "Endometrioid adenoma, NOS",
                PermissibleValue(text="Endometrioid adenoma, NOS") )
        setattr(cls, "Marginal zone lymphoma, NOS",
                PermissibleValue(text="Marginal zone lymphoma, NOS",
                                 description="Marginal Zone Lymphoma Not Otherwise Specified") )
        setattr(cls, "Oat cell carcinoma",
                PermissibleValue(text="Oat cell carcinoma") )
        setattr(cls, "Extracutaneous mastocytoma",
                PermissibleValue(text="Extracutaneous mastocytoma") )
        setattr(cls, "Chronic leukemia, NOS",
                PermissibleValue(text="Chronic leukemia, NOS") )
        setattr(cls, "Malignant lymphoma, Hodgkin",
                PermissibleValue(text="Malignant lymphoma, Hodgkin") )
        setattr(cls, "Thymoma, organoid, malignant",
                PermissibleValue(text="Thymoma, organoid, malignant") )
        setattr(cls, "Meningeal sarcoma",
                PermissibleValue(text="Meningeal sarcoma") )
        setattr(cls, "Adenomatoid odontogenic tumor",
                PermissibleValue(text="Adenomatoid odontogenic tumor") )
        setattr(cls, "Parafollicular cell carcinoma",
                PermissibleValue(text="Parafollicular cell carcinoma") )
        setattr(cls, "Nonencapsulated sclerosing tumor",
                PermissibleValue(text="Nonencapsulated sclerosing tumor") )
        setattr(cls, "Malignant tumor, fusiform cell type",
                PermissibleValue(text="Malignant tumor, fusiform cell type") )
        setattr(cls, "Thymoma, malignant, NOS",
                PermissibleValue(text="Thymoma, malignant, NOS") )
        setattr(cls, "Adrenal cortical adenocarcinoma",
                PermissibleValue(text="Adrenal cortical adenocarcinoma") )
        setattr(cls, "Solitary fibrous tumor/hemangiopericytoma Grade 2 (CNS)",
                PermissibleValue(text="Solitary fibrous tumor/hemangiopericytoma Grade 2 (CNS)") )
        setattr(cls, "Cystic teratoma, NOS",
                PermissibleValue(text="Cystic teratoma, NOS") )
        setattr(cls, "Atypical adenoma",
                PermissibleValue(text="Atypical adenoma") )
        setattr(cls, "Retinoblastoma, differentiated",
                PermissibleValue(text="Retinoblastoma, differentiated") )
        setattr(cls, "Pilomatricoma, malignant",
                PermissibleValue(text="Pilomatricoma, malignant") )
        setattr(cls, "Thymoma, predominantly cortical, NOS",
                PermissibleValue(text="Thymoma, predominantly cortical, NOS") )
        setattr(cls, "Myeloma, NOS",
                PermissibleValue(text="Myeloma, NOS") )
        setattr(cls, "Adenocarcinoma in adenomatous polyp",
                PermissibleValue(text="Adenocarcinoma in adenomatous polyp") )
        setattr(cls, "Myelodysplastic syndrome, unclassifiable",
                PermissibleValue(text="Myelodysplastic syndrome, unclassifiable") )
        setattr(cls, "Acute myeloid leukemia without maturation",
                PermissibleValue(text="Acute myeloid leukemia without maturation") )
        setattr(cls, "Intraductal adenocarcinoma, noninfiltrating, NOS",
                PermissibleValue(text="Intraductal adenocarcinoma, noninfiltrating, NOS") )
        setattr(cls, "Intraosseous well differentiated osteosarcoma",
                PermissibleValue(text="Intraosseous well differentiated osteosarcoma") )
        setattr(cls, "Paraganglioma, benign",
                PermissibleValue(text="Paraganglioma, benign") )
        setattr(cls, "Papillary carcinoma, diffuse sclerosing",
                PermissibleValue(text="Papillary carcinoma, diffuse sclerosing") )
        setattr(cls, "Soft tissue tumor, malignant",
                PermissibleValue(text="Soft tissue tumor, malignant") )
        setattr(cls, "Osteocartilaginous exostosis",
                PermissibleValue(text="Osteocartilaginous exostosis") )
        setattr(cls, "Mucinous cystadenoma, borderline malignancy",
                PermissibleValue(text="Mucinous cystadenoma, borderline malignancy") )
        setattr(cls, "Dedifferentiated chondrosarcoma",
                PermissibleValue(text="Dedifferentiated chondrosarcoma") )
        setattr(cls, "Mediterranean lymphoma",
                PermissibleValue(text="Mediterranean lymphoma") )
        setattr(cls, "Plasmacytoma of bone",
                PermissibleValue(text="Plasmacytoma of bone") )
        setattr(cls, "Diffuse astrocytoma, IDH-wildtype",
                PermissibleValue(text="Diffuse astrocytoma, IDH-wildtype") )
        setattr(cls, "Megakaryocytic leukemia",
                PermissibleValue(text="Megakaryocytic leukemia") )
        setattr(cls, "Hairy cell leukaemia variant",
                PermissibleValue(text="Hairy cell leukaemia variant") )
        setattr(cls, "Melanoma in situ",
                PermissibleValue(text="Melanoma in situ") )
        setattr(cls, "Thecoma, luteinized",
                PermissibleValue(text="Thecoma, luteinized") )
        setattr(cls, "Lymphoproliferative disorder, NOS",
                PermissibleValue(text="Lymphoproliferative disorder, NOS") )
        setattr(cls, "Digital papillary adenocarcinoma",
                PermissibleValue(text="Digital papillary adenocarcinoma") )
        setattr(cls, "Serous tubal intraepithelial carcinoma",
                PermissibleValue(text="Serous tubal intraepithelial carcinoma") )
        setattr(cls, "Eccrine spiradenoma",
                PermissibleValue(text="Eccrine spiradenoma") )
        setattr(cls, "Refractory thrombocytopenia",
                PermissibleValue(text="Refractory thrombocytopenia") )
        setattr(cls, "Eccrine poroma, malignant",
                PermissibleValue(text="Eccrine poroma, malignant") )
        setattr(cls, "PEComa, malignant",
                PermissibleValue(text="PEComa, malignant") )
        setattr(cls, "Pseudomucinous cystadenocarcinoma, NOS",
                PermissibleValue(text="Pseudomucinous cystadenocarcinoma, NOS") )
        setattr(cls, "Beta cell adenoma",
                PermissibleValue(text="Beta cell adenoma") )
        setattr(cls, "Endometrial stromal sarcoma, high grade",
                PermissibleValue(text="Endometrial stromal sarcoma, high grade") )
        setattr(cls, "Aleukemic monocytic leukemia",
                PermissibleValue(text="Aleukemic monocytic leukemia") )
        setattr(cls, "Hemangioblastic meningioma",
                PermissibleValue(text="Hemangioblastic meningioma") )
        setattr(cls, "Odontogenic tumor, NOS",
                PermissibleValue(text="Odontogenic tumor, NOS") )
        setattr(cls, "Pindborg tumor",
                PermissibleValue(text="Pindborg tumor") )
        setattr(cls, "Primary cutaneous DLBCL, leg type",
                PermissibleValue(text="Primary cutaneous DLBCL, leg type") )
        setattr(cls, "Plasma cell leukemia",
                PermissibleValue(text="Plasma cell leukemia") )
        setattr(cls, "Endometrial stromatosis",
                PermissibleValue(text="Endometrial stromatosis") )
        setattr(cls, "Mixed basal-squamous cell carcinoma",
                PermissibleValue(text="Mixed basal-squamous cell carcinoma") )
        setattr(cls, "Phyllodes tumor, borderline",
                PermissibleValue(text="Phyllodes tumor, borderline") )
        setattr(cls, "Choriocarcinoma combined with embryonal carcinoma",
                PermissibleValue(text="Choriocarcinoma combined with embryonal carcinoma") )
        setattr(cls, "Mesothelioma, NOS",
                PermissibleValue(text="Mesothelioma, NOS") )
        setattr(cls, "Yolk sac tumor",
                PermissibleValue(text="Yolk sac tumor") )
        setattr(cls, "Hodgkin lymphoma, lymphocyte-rich",
                PermissibleValue(text="Hodgkin lymphoma, lymphocyte-rich") )
        setattr(cls, "Pseudomyxoma peritonei with unknown primary site",
                PermissibleValue(text="Pseudomyxoma peritonei with unknown primary site") )
        setattr(cls, "Cloacogenic carcinoma",
                PermissibleValue(text="Cloacogenic carcinoma") )
        setattr(cls, "Acute myeloblastic leukemia",
                PermissibleValue(text="Acute myeloblastic leukemia") )
        setattr(cls, "Nodal marginal zone lymphoma",
                PermissibleValue(text="Nodal marginal zone lymphoma") )
        setattr(cls, "Solid papillary carcinoma with invasion",
                PermissibleValue(text="Solid papillary carcinoma with invasion") )
        setattr(cls, "Malignant lymphoma, non-cleaved cell, NOS",
                PermissibleValue(text="Malignant lymphoma, non-cleaved cell, NOS") )
        setattr(cls, "Chronic lymphocytic leukemia, B-cell type (includes all variants of BCLL)",
                PermissibleValue(text="Chronic lymphocytic leukemia, B-cell type (includes all variants of BCLL)") )
        setattr(cls, "Intraductal papillary mucinous neoplasm with an associated invasive carcinoma",
                PermissibleValue(text="Intraductal papillary mucinous neoplasm with an associated invasive carcinoma") )
        setattr(cls, "Tubular androblastoma, NOS",
                PermissibleValue(text="Tubular androblastoma, NOS") )
        setattr(cls, "Atypical fibroxanthoma",
                PermissibleValue(text="Atypical fibroxanthoma") )
        setattr(cls, "Odontogenic carcinosarcoma",
                PermissibleValue(text="Odontogenic carcinosarcoma") )
        setattr(cls, "Serous endometrial intraepithelial carcinoma",
                PermissibleValue(text="Serous endometrial intraepithelial carcinoma",
                                 description="Serous Endometrial Intraepithelial Carcinoma") )
        setattr(cls, "Follicular adenocarcinoma, trabecular",
                PermissibleValue(text="Follicular adenocarcinoma, trabecular") )
        setattr(cls, "Acute lymphatic leukemia",
                PermissibleValue(text="Acute lymphatic leukemia") )
        setattr(cls, "Atypical hyperplasia/Endometrioid intraepithelial neoplasm",
                PermissibleValue(text="Atypical hyperplasia/Endometrioid intraepithelial neoplasm") )
        setattr(cls, "Solid teratoma",
                PermissibleValue(text="Solid teratoma") )
        setattr(cls, "Eccrine papillary adenocarcinoma",
                PermissibleValue(text="Eccrine papillary adenocarcinoma") )
        setattr(cls, "Transitional cell papilloma, benign",
                PermissibleValue(text="Transitional cell papilloma, benign") )
        setattr(cls, "Melanotic medulloblastoma",
                PermissibleValue(text="Melanotic medulloblastoma") )
        setattr(cls, "Atypical follicular adenoma",
                PermissibleValue(text="Atypical follicular adenoma") )
        setattr(cls, "Magnocellular nevus",
                PermissibleValue(text="Magnocellular nevus") )
        setattr(cls, "Sertoli-Leydig cell tumor, retiform, with heterologous elements",
                PermissibleValue(text="Sertoli-Leydig cell tumor, retiform, with heterologous elements") )
        setattr(cls, "Non-invasive mammary carcinoma",
                PermissibleValue(text="Non-invasive mammary carcinoma") )
        setattr(cls, "Squamous cell carcinoma, clear cell type",
                PermissibleValue(text="Squamous cell carcinoma, clear cell type") )
        setattr(cls, "Malignant lymphoma, histiocytic, diffuse",
                PermissibleValue(text="Malignant lymphoma, histiocytic, diffuse") )
        setattr(cls, "Endodermal sinus tumor",
                PermissibleValue(text="Endodermal sinus tumor") )
        setattr(cls, "Astrocytoma, anaplastic",
                PermissibleValue(text="Astrocytoma, anaplastic") )
        setattr(cls, "Mixed medullary-follicular carcinoma",
                PermissibleValue(text="Mixed medullary-follicular carcinoma") )
        setattr(cls, "Oligodendroglioma, anaplastic",
                PermissibleValue(text="Oligodendroglioma, anaplastic") )
        setattr(cls, "Central primitive neuroectodermal tumor, NOS",
                PermissibleValue(text="Central primitive neuroectodermal tumor, NOS") )
        setattr(cls, "Dermal and epidermal nevus",
                PermissibleValue(text="Dermal and epidermal nevus") )
        setattr(cls, "Malignant lymphoma, large cell, NOS",
                PermissibleValue(text="Malignant lymphoma, large cell, NOS") )
        setattr(cls, "Papillary carcinoma, encapsulated",
                PermissibleValue(text="Papillary carcinoma, encapsulated") )
        setattr(cls, "Carcinoma, diffuse type",
                PermissibleValue(text="Carcinoma, diffuse type") )
        setattr(cls, "Acute myelofibrosis",
                PermissibleValue(text="Acute myelofibrosis") )
        setattr(cls, "Desmoid, NOS",
                PermissibleValue(text="Desmoid, NOS") )
        setattr(cls, "Malignant lymphoma, large B-cell, diffuse, immunoblastic, NOS",
                PermissibleValue(text="Malignant lymphoma, large B-cell, diffuse, immunoblastic, NOS") )
        setattr(cls, "NK-cell large granular lymphocytic leukemia",
                PermissibleValue(text="NK-cell large granular lymphocytic leukemia") )
        setattr(cls, "Mucinous adenocarcinoma",
                PermissibleValue(text="Mucinous adenocarcinoma") )
        setattr(cls, "Acute promyelocytic leukaemia, PML-RAR-alpha",
                PermissibleValue(text="Acute promyelocytic leukaemia, PML-RAR-alpha") )
        setattr(cls, "Myxopapillary ependymoma",
                PermissibleValue(text="Myxopapillary ependymoma") )
        setattr(cls, "Hepatoblastoma, mixed epithelial-mesenchymal",
                PermissibleValue(text="Hepatoblastoma, mixed epithelial-mesenchymal") )
        setattr(cls, "Liposarcoma, differentiated",
                PermissibleValue(text="Liposarcoma, differentiated") )
        setattr(cls, "Malignant lymphoma, large cell, immunoblastic",
                PermissibleValue(text="Malignant lymphoma, large cell, immunoblastic") )
        setattr(cls, "Bronchiolo-alveolar adenocarcinoma, NOS",
                PermissibleValue(text="Bronchiolo-alveolar adenocarcinoma, NOS") )
        setattr(cls, "Lipomatous medulloblastoma",
                PermissibleValue(text="Lipomatous medulloblastoma") )
        setattr(cls, "Papillary carcinoma, NOS",
                PermissibleValue(text="Papillary carcinoma, NOS") )
        setattr(cls, "Nephroblastoma, NOS",
                PermissibleValue(text="Nephroblastoma, NOS") )
        setattr(cls, "Hemangiopericytoma, malignant",
                PermissibleValue(text="Hemangiopericytoma, malignant") )
        setattr(cls, "Pulmonary blastoma",
                PermissibleValue(text="Pulmonary blastoma") )
        setattr(cls, "Desmoplastic infantile ganglioglioma",
                PermissibleValue(text="Desmoplastic infantile ganglioglioma") )
        setattr(cls, "Acute myeloid leukemia with mutated NPM1",
                PermissibleValue(text="Acute myeloid leukemia with mutated NPM1") )
        setattr(cls, "Myoepithelial carcinoma",
                PermissibleValue(text="Myoepithelial carcinoma",
                                 description="Malignant Myoepithelioma") )
        setattr(cls, "Calcifying nested epithelial stromal tumor",
                PermissibleValue(text="Calcifying nested epithelial stromal tumor") )
        setattr(cls, "Spindle cell lipoma",
                PermissibleValue(text="Spindle cell lipoma") )
        setattr(cls, "Dysembryoplastic neuroepithelial tumor",
                PermissibleValue(text="Dysembryoplastic neuroepithelial tumor") )
        setattr(cls, "Refractory anemia with ring sideroblasts associated with marked thrombocytosis",
                PermissibleValue(text="Refractory anemia with ring sideroblasts associated with marked thrombocytosis") )
        setattr(cls, "Thymoma, type A, malignant",
                PermissibleValue(text="Thymoma, type A, malignant") )
        setattr(cls, "Chronic neutrophilic leukemia",
                PermissibleValue(text="Chronic neutrophilic leukemia") )
        setattr(cls, "Adenocarcinoma with neuroendocrine differentiation",
                PermissibleValue(text="Adenocarcinoma with neuroendocrine differentiation") )
        setattr(cls, "Eccrine acrospiroma",
                PermissibleValue(text="Eccrine acrospiroma") )
        setattr(cls, "Undifferentiated epithelioid sarcoma",
                PermissibleValue(text="Undifferentiated epithelioid sarcoma") )
        setattr(cls, "Thymoma, epithelial, NOS",
                PermissibleValue(text="Thymoma, epithelial, NOS") )
        setattr(cls, "Mediastinal (thymic) large B-cell lymphoma",
                PermissibleValue(text="Mediastinal (thymic) large B-cell lymphoma") )
        setattr(cls, "Hurthle cell carcinoma",
                PermissibleValue(text="Hurthle cell carcinoma") )
        setattr(cls, "Mucinous carcinoma, intestinal type",
                PermissibleValue(text="Mucinous carcinoma, intestinal type") )
        setattr(cls, "Pleomorphic leiomyoma",
                PermissibleValue(text="Pleomorphic leiomyoma") )
        setattr(cls, "Mixed phenotype acute leukemia with t(v;11q23); MLL rearranged",
                PermissibleValue(text="Mixed phenotype acute leukemia with t(v;11q23); MLL rearranged") )
        setattr(cls, "Intraductal carcinoma, solid type",
                PermissibleValue(text="Intraductal carcinoma, solid type") )
        setattr(cls, "Hemangioendothelioma, malignant",
                PermissibleValue(text="Hemangioendothelioma, malignant") )
        setattr(cls, "Thymoma, type B2, malignant",
                PermissibleValue(text="Thymoma, type B2, malignant") )
        setattr(cls, "Papillary serous tumor of low malignant potential",
                PermissibleValue(text="Papillary serous tumor of low malignant potential") )
        setattr(cls, "Papillary transitional cell carcinoma, non-invasive",
                PermissibleValue(text="Papillary transitional cell carcinoma, non-invasive") )
        setattr(cls, "Aleukemic lymphatic leukemia",
                PermissibleValue(text="Aleukemic lymphatic leukemia") )
        setattr(cls, "Clear cell sarcoma, NOS",
                PermissibleValue(text="Clear cell sarcoma, NOS") )
        setattr(cls, "Retinal anlage tumor",
                PermissibleValue(text="Retinal anlage tumor") )
        setattr(cls, "Hurthle cell tumor",
                PermissibleValue(text="Hurthle cell tumor") )
        setattr(cls, "Hemangioendothelial sarcoma",
                PermissibleValue(text="Hemangioendothelial sarcoma") )
        setattr(cls, "Malignant lymphoma, lymphoblastic, NOS",
                PermissibleValue(text="Malignant lymphoma, lymphoblastic, NOS") )
        setattr(cls, "Polycythemia vera",
                PermissibleValue(text="Polycythemia vera") )
        setattr(cls, "Fibro-osteoma",
                PermissibleValue(text="Fibro-osteoma") )
        setattr(cls, "Preleukemic syndrome",
                PermissibleValue(text="Preleukemic syndrome") )
        setattr(cls, "Wilms tumor",
                PermissibleValue(text="Wilms tumor") )
        setattr(cls, "B lymphoblastic leukemia/lymphoma with t(9;22)(q34;q11.2); BCR-ABL1",
                PermissibleValue(text="B lymphoblastic leukemia/lymphoma with t(9;22)(q34;q11.2); BCR-ABL1") )
        setattr(cls, "Epidermoid carcinoma, spindle cell",
                PermissibleValue(text="Epidermoid carcinoma, spindle cell") )
        setattr(cls, "Precursor T-cell lymphoblastic lymphoma",
                PermissibleValue(text="Precursor T-cell lymphoblastic lymphoma") )
        setattr(cls, "Spitz nevus",
                PermissibleValue(text="Spitz nevus") )
        setattr(cls, "High-grade neuroendocrine carcinoma",
                PermissibleValue(text="High-grade neuroendocrine carcinoma") )
        setattr(cls, "Essential hemorrhagic thrombocythaemia",
                PermissibleValue(text="Essential hemorrhagic thrombocythaemia") )
        setattr(cls, "Desmoplastic mesothelioma",
                PermissibleValue(text="Desmoplastic mesothelioma",
                                 description="Desmoplastic Mesothelioma") )
        setattr(cls, "Ameloblastic carcinoma",
                PermissibleValue(text="Ameloblastic carcinoma") )
        setattr(cls, "Nonlipid reticuloendotheliosis",
                PermissibleValue(text="Nonlipid reticuloendotheliosis") )
        setattr(cls, "Therapy-related acute myeloid leukemia, NOS",
                PermissibleValue(text="Therapy-related acute myeloid leukemia, NOS") )
        setattr(cls, "Angiomatous meningioma",
                PermissibleValue(text="Angiomatous meningioma") )
        setattr(cls, "Medulloblastoma, non-WNT/non-SHH",
                PermissibleValue(text="Medulloblastoma, non-WNT/non-SHH") )
        setattr(cls, "Clear cell adenoma",
                PermissibleValue(text="Clear cell adenoma") )
        setattr(cls, "Cavernous hemangioma",
                PermissibleValue(text="Cavernous hemangioma") )
        setattr(cls, "Hodgkin lymphoma, nodular sclerosis, grade 1",
                PermissibleValue(text="Hodgkin lymphoma, nodular sclerosis, grade 1") )
        setattr(cls, "Idiopathic hemorrhagic thrombocythaemia",
                PermissibleValue(text="Idiopathic hemorrhagic thrombocythaemia") )
        setattr(cls, "Granulosa cell carcinoma",
                PermissibleValue(text="Granulosa cell carcinoma") )
        setattr(cls, "Gastrointestinal stromal tumor, NOS",
                PermissibleValue(text="Gastrointestinal stromal tumor, NOS") )
        setattr(cls, "Thymoma, type B1, malignant",
                PermissibleValue(text="Thymoma, type B1, malignant") )
        setattr(cls, "Follicular carcinoma, moderately differentiated",
                PermissibleValue(text="Follicular carcinoma, moderately differentiated") )
        setattr(cls, "Dermatofibrosarcoma protuberans, NOS",
                PermissibleValue(text="Dermatofibrosarcoma protuberans, NOS") )
        setattr(cls, "Mucinous cystadenocarcinoma, non-invasive",
                PermissibleValue(text="Mucinous cystadenocarcinoma, non-invasive") )
        setattr(cls, "Squamous cell carcinoma, acantholytic",
                PermissibleValue(text="Squamous cell carcinoma, acantholytic") )
        setattr(cls, "Tubulocystic renal cell carcinoma",
                PermissibleValue(text="Tubulocystic renal cell carcinoma",
                                 description="Tubulocystic Renal Cell Carcinoma") )
        setattr(cls, "Myelogenous leukemia, NOS",
                PermissibleValue(text="Myelogenous leukemia, NOS") )
        setattr(cls, "Glioblastoma multiforme",
                PermissibleValue(text="Glioblastoma multiforme") )
        setattr(cls, "Thymoma, cortical, NOS",
                PermissibleValue(text="Thymoma, cortical, NOS") )
        setattr(cls, "Primary cutaneous CD4-positive small/medium T-cell lymphoma",
                PermissibleValue(text="Primary cutaneous CD4-positive small/medium T-cell lymphoma") )
        setattr(cls, "Atypical proliferating clear cell tumor",
                PermissibleValue(text="Atypical proliferating clear cell tumor") )
        setattr(cls, "Duct carcinoma, NOS",
                PermissibleValue(text="Duct carcinoma, NOS") )
        setattr(cls, "Squamous cell carcinoma, NOS",
                PermissibleValue(text="Squamous cell carcinoma, NOS") )
        setattr(cls, "Hepatoblastoma, epithelioid",
                PermissibleValue(text="Hepatoblastoma, epithelioid") )
        setattr(cls, "Meningothelial meningioma",
                PermissibleValue(text="Meningothelial meningioma") )
        setattr(cls, "Carcinoma in situ, NOS",
                PermissibleValue(text="Carcinoma in situ, NOS") )
        setattr(cls, "Desmoplastic medulloblastoma",
                PermissibleValue(text="Desmoplastic medulloblastoma") )
        setattr(cls, "Mucoid adenocarcinoma",
                PermissibleValue(text="Mucoid adenocarcinoma") )
        setattr(cls, "Adenomatous polyposis coli",
                PermissibleValue(text="Adenomatous polyposis coli") )
        setattr(cls, "Compound odontoma",
                PermissibleValue(text="Compound odontoma") )
        setattr(cls, "Syringomatous carcinoma",
                PermissibleValue(text="Syringomatous carcinoma") )
        setattr(cls, "Gastrin cell tumor, malignant",
                PermissibleValue(text="Gastrin cell tumor, malignant") )
        setattr(cls, "Malignant teratoma, intermediate",
                PermissibleValue(text="Malignant teratoma, intermediate") )
        setattr(cls, "Langerhans cell sarcoma",
                PermissibleValue(text="Langerhans cell sarcoma") )
        setattr(cls, "Adrenal cortical adenoma, pigmented",
                PermissibleValue(text="Adrenal cortical adenoma, pigmented") )
        setattr(cls, "Enteropathy type intestinal T-cell lymphoma",
                PermissibleValue(text="Enteropathy type intestinal T-cell lymphoma") )
        setattr(cls, "Parasympathetic paraganglioma",
                PermissibleValue(text="Parasympathetic paraganglioma") )
        setattr(cls, "Malignant myelosclerosis",
                PermissibleValue(text="Malignant myelosclerosis") )
        setattr(cls, "Acute panmyelosis, NOS",
                PermissibleValue(text="Acute panmyelosis, NOS") )
        setattr(cls, "Congenital generalized fibromatosis",
                PermissibleValue(text="Congenital generalized fibromatosis") )
        setattr(cls, "Soft tissue sarcoma",
                PermissibleValue(text="Soft tissue sarcoma") )
        setattr(cls, "Melanotic neurofibroma",
                PermissibleValue(text="Melanotic neurofibroma") )
        setattr(cls, "Chromophobe carcinoma",
                PermissibleValue(text="Chromophobe carcinoma") )
        setattr(cls, "Duct adenocarcinoma, NOS",
                PermissibleValue(text="Duct adenocarcinoma, NOS") )
        setattr(cls, "Matrical carcinoma",
                PermissibleValue(text="Matrical carcinoma") )
        setattr(cls, "Giant cell glioblastoma",
                PermissibleValue(text="Giant cell glioblastoma") )
        setattr(cls, "Ceruminous adenoma",
                PermissibleValue(text="Ceruminous adenoma") )
        setattr(cls, "Mesothelioma, biphasic, malignant",
                PermissibleValue(text="Mesothelioma, biphasic, malignant") )
        setattr(cls, "Sweat gland tumor, malignant",
                PermissibleValue(text="Sweat gland tumor, malignant") )
        setattr(cls, "PNET, NOS",
                PermissibleValue(text="PNET, NOS") )
        setattr(cls, "Neuroectodermal tumor, NOS",
                PermissibleValue(text="Neuroectodermal tumor, NOS") )
        setattr(cls, "Extra-adrenal paraganglioma, NOS",
                PermissibleValue(text="Extra-adrenal paraganglioma, NOS") )
        setattr(cls, "Medulloblastoma, SHH-activated and TP53-mutant",
                PermissibleValue(text="Medulloblastoma, SHH-activated and TP53-mutant") )
        setattr(cls, "Eccrine papillary adenoma",
                PermissibleValue(text="Eccrine papillary adenoma") )
        setattr(cls, "Alveolar carcinoma",
                PermissibleValue(text="Alveolar carcinoma") )
        setattr(cls, "Wolffian duct tumor",
                PermissibleValue(text="Wolffian duct tumor") )
        setattr(cls, "Ewing sarcoma",
                PermissibleValue(text="Ewing sarcoma") )
        setattr(cls, "Angioma, NOS",
                PermissibleValue(text="Angioma, NOS") )
        setattr(cls, "Fibrous meningioma",
                PermissibleValue(text="Fibrous meningioma") )
        setattr(cls, "Mesenteric fibromatosis",
                PermissibleValue(text="Mesenteric fibromatosis") )
        setattr(cls, "Mucinous carcinoid",
                PermissibleValue(text="Mucinous carcinoid") )
        setattr(cls, "Craniopharyngioma, papillary",
                PermissibleValue(text="Craniopharyngioma, papillary") )
        setattr(cls, "Aggressive NK-cell leukaemia",
                PermissibleValue(text="Aggressive NK-cell leukaemia") )
        setattr(cls, "Subacute lymphocytic leukemia",
                PermissibleValue(text="Subacute lymphocytic leukemia") )
        setattr(cls, "Carcinoma showing thymus-like differentiation",
                PermissibleValue(text="Carcinoma showing thymus-like differentiation") )
        setattr(cls, "Thymoma, type A, NOS",
                PermissibleValue(text="Thymoma, type A, NOS") )
        setattr(cls, "Neoplasm, NOS",
                PermissibleValue(text="Neoplasm, NOS") )
        setattr(cls, "Lobular and ductal carcinoma",
                PermissibleValue(text="Lobular and ductal carcinoma") )
        setattr(cls, "Adult T-cell leukemia/lymphoma (HTLV-1 positive) (includes all variants)",
                PermissibleValue(text="Adult T-cell leukemia/lymphoma (HTLV-1 positive) (includes all variants)") )
        setattr(cls, "Fibrillary astrocytoma",
                PermissibleValue(text="Fibrillary astrocytoma") )
        setattr(cls, "EBV positive diffuse large B-cell lymphoma of the elderly",
                PermissibleValue(text="EBV positive diffuse large B-cell lymphoma of the elderly") )
        setattr(cls, "Erythremic myelosis, NOS",
                PermissibleValue(text="Erythremic myelosis, NOS") )
        setattr(cls, "Mixed tumor, salivary gland type, malignant",
                PermissibleValue(text="Mixed tumor, salivary gland type, malignant") )
        setattr(cls, "Papillary and follicular carcinoma",
                PermissibleValue(text="Papillary and follicular carcinoma") )
        setattr(cls, "Noninvasive pancreatobiliary papillary neoplasm with low grade dysplasia",
                PermissibleValue(text="Noninvasive pancreatobiliary papillary neoplasm with low grade dysplasia") )
        setattr(cls, "Papillary urothelial carcinoma, non-invasive",
                PermissibleValue(text="Papillary urothelial carcinoma, non-invasive") )
        setattr(cls, "Intraductal papilloma with lobular carcinoma in situ",
                PermissibleValue(text="Intraductal papilloma with lobular carcinoma in situ") )
        setattr(cls, "Hodgkin sarcoma",
                PermissibleValue(text="Hodgkin sarcoma") )
        setattr(cls, "Tibial adamantinoma",
                PermissibleValue(text="Tibial adamantinoma") )
        setattr(cls, "Deep histiocytoma",
                PermissibleValue(text="Deep histiocytoma") )
        setattr(cls, "Adenocarcinoma in villous adenoma",
                PermissibleValue(text="Adenocarcinoma in villous adenoma") )
        setattr(cls, "Pseudomucinous cystadenoma, borderline malignancy",
                PermissibleValue(text="Pseudomucinous cystadenoma, borderline malignancy") )
        setattr(cls, "Argentaffinoma, malignant",
                PermissibleValue(text="Argentaffinoma, malignant") )
        setattr(cls, "Therapy-related myelodysplastic syndrome, epipodophyllotoxin-related",
                PermissibleValue(text="Therapy-related myelodysplastic syndrome, epipodophyllotoxin-related") )
        setattr(cls, "Serotonin producing carcinoid",
                PermissibleValue(text="Serotonin producing carcinoid") )
        setattr(cls, "Noninfiltrating intraductal papillary carcinoma",
                PermissibleValue(text="Noninfiltrating intraductal papillary carcinoma") )
        setattr(cls, "Syringocystadenoma papilliferum",
                PermissibleValue(text="Syringocystadenoma papilliferum") )
        setattr(cls, "Classical Hodgkin lymphoma, nodular sclerosis, cellular phase",
                PermissibleValue(text="Classical Hodgkin lymphoma, nodular sclerosis, cellular phase") )
        setattr(cls, "Kupffer cell sarcoma",
                PermissibleValue(text="Kupffer cell sarcoma") )
        setattr(cls, "Neuroepithelioma, NOS",
                PermissibleValue(text="Neuroepithelioma, NOS") )
        setattr(cls, "Malignant tumor, giant cell type",
                PermissibleValue(text="Malignant tumor, giant cell type") )
        setattr(cls, "Neurofibroma, NOS",
                PermissibleValue(text="Neurofibroma, NOS") )
        setattr(cls, "Hodgkin lymphoma, NOS",
                PermissibleValue(text="Hodgkin lymphoma, NOS") )
        setattr(cls, "Neurotropic melanoma, malignant",
                PermissibleValue(text="Neurotropic melanoma, malignant") )
        setattr(cls, "Therapy-related myelodysplastic syndrome, alkylating agent related",
                PermissibleValue(text="Therapy-related myelodysplastic syndrome, alkylating agent related") )
        setattr(cls, "Pleomorphic rhabdomyosarcoma, adult type",
                PermissibleValue(text="Pleomorphic rhabdomyosarcoma, adult type") )
        setattr(cls, "Soft tissue tumor, benign",
                PermissibleValue(text="Soft tissue tumor, benign") )
        setattr(cls, "Metaplastic carcinoma with other types mesenchymal differentiation",
                PermissibleValue(text="Metaplastic carcinoma with other types mesenchymal differentiation") )
        setattr(cls, "Spindle cell melanoma, NOS",
                PermissibleValue(text="Spindle cell melanoma, NOS") )
        setattr(cls, "Struma ovarii, malignant",
                PermissibleValue(text="Struma ovarii, malignant") )
        setattr(cls, "Sclerosing hemangioma",
                PermissibleValue(text="Sclerosing hemangioma") )
        setattr(cls, "Dabska tumor",
                PermissibleValue(text="Dabska tumor") )
        setattr(cls, "Ductal carcinoma, NOS",
                PermissibleValue(text="Ductal carcinoma, NOS") )
        setattr(cls, "Chronic lymphoid leukemia",
                PermissibleValue(text="Chronic lymphoid leukemia") )
        setattr(cls, "Intraglandular papillary neoplasm with low grade intraepithelial neoplasia",
                PermissibleValue(text="Intraglandular papillary neoplasm with low grade intraepithelial neoplasia") )
        setattr(cls, "Osteogenic sarcoma, NOS",
                PermissibleValue(text="Osteogenic sarcoma, NOS") )
        setattr(cls, "Adenocarcinoma in situ in adenomatous polyp",
                PermissibleValue(text="Adenocarcinoma in situ in adenomatous polyp") )
        setattr(cls, "Fetal lipomatosis",
                PermissibleValue(text="Fetal lipomatosis") )
        setattr(cls, "Melanoma, NOS",
                PermissibleValue(text="Melanoma, NOS",
                                 description="Not Otherwise Specified Melanoma") )
        setattr(cls, "Basal cell tumor",
                PermissibleValue(text="Basal cell tumor") )
        setattr(cls, "Blue nevus, NOS",
                PermissibleValue(text="Blue nevus, NOS") )
        setattr(cls, "Classical Hodgkin lymphoma, lymphocyte depletion, NOS",
                PermissibleValue(text="Classical Hodgkin lymphoma, lymphocyte depletion, NOS") )
        setattr(cls, "Hilar cell tumor",
                PermissibleValue(text="Hilar cell tumor") )
        setattr(cls, "MPNST with mesenchymal differentiation",
                PermissibleValue(text="MPNST with mesenchymal differentiation") )
        setattr(cls, "Ameloblastic sarcoma",
                PermissibleValue(text="Ameloblastic sarcoma") )
        setattr(cls, "Thymoma, medullary, NOS",
                PermissibleValue(text="Thymoma, medullary, NOS") )
        setattr(cls, "Eccrine poroma",
                PermissibleValue(text="Eccrine poroma") )
        setattr(cls, "Ductal papilloma",
                PermissibleValue(text="Ductal papilloma") )
        setattr(cls, "Biliary papillomatosis",
                PermissibleValue(text="Biliary papillomatosis") )
        setattr(cls, "Lymphosarcoma, NOS",
                PermissibleValue(text="Lymphosarcoma, NOS") )
        setattr(cls, "Astrocytoma, NOS",
                PermissibleValue(text="Astrocytoma, NOS") )
        setattr(cls, "Nodular melanoma",
                PermissibleValue(text="Nodular melanoma",
                                 description="Nodular Melanoma") )
        setattr(cls, "Eosinophilic leukemia",
                PermissibleValue(text="Eosinophilic leukemia") )
        setattr(cls, "Acute myeloid leukemia, AML1(CBF-alpha)/ETO",
                PermissibleValue(text="Acute myeloid leukemia, AML1(CBF-alpha)/ETO") )
        setattr(cls, "Gigantiform cementoma",
                PermissibleValue(text="Gigantiform cementoma") )
        setattr(cls, "Oncocytic carcinoma",
                PermissibleValue(text="Oncocytic carcinoma",
                                 description="Oxyphilic Adenocarcinoma") )
        setattr(cls, "Odontogenic fibrosarcoma",
                PermissibleValue(text="Odontogenic fibrosarcoma") )
        setattr(cls, "Verrucous epidermoid carcinoma",
                PermissibleValue(text="Verrucous epidermoid carcinoma") )
        setattr(cls, "Flat intraepithelial glandular neoplasia, high grade",
                PermissibleValue(text="Flat intraepithelial glandular neoplasia, high grade") )
        setattr(cls, "Malignant melanoma in congenital melanocytic nevus",
                PermissibleValue(text="Malignant melanoma in congenital melanocytic nevus") )
        setattr(cls, "Aleukemic granulocytic leukemia",
                PermissibleValue(text="Aleukemic granulocytic leukemia") )
        setattr(cls, "Oncocytic adenoma",
                PermissibleValue(text="Oncocytic adenoma") )
        setattr(cls, "Adenocarcinoma of anal glands",
                PermissibleValue(text="Adenocarcinoma of anal glands") )
        setattr(cls, "FAB M1",
                PermissibleValue(text="FAB M1") )
        setattr(cls, "Pigmented dermatofibrosarcoma protuberans",
                PermissibleValue(text="Pigmented dermatofibrosarcoma protuberans") )
        setattr(cls, "Metatypical carcinoma",
                PermissibleValue(text="Metatypical carcinoma") )
        setattr(cls, "Cribriform comedo-type carcinoma",
                PermissibleValue(text="Cribriform comedo-type carcinoma") )
        setattr(cls, "T-zone lymphoma",
                PermissibleValue(text="T-zone lymphoma") )
        setattr(cls, "Hyalinizing trabecular adenoma",
                PermissibleValue(text="Hyalinizing trabecular adenoma") )
        setattr(cls, "Endometrial stromal sarcoma, low grade",
                PermissibleValue(text="Endometrial stromal sarcoma, low grade") )
        setattr(cls, "Retinoblastoma, undifferentiated",
                PermissibleValue(text="Retinoblastoma, undifferentiated") )
        setattr(cls, "Transitional cell papilloma, inverted, benign",
                PermissibleValue(text="Transitional cell papilloma, inverted, benign") )
        setattr(cls, "Classical Hodgkin lymphoma, nodular sclerosis, grade 1",
                PermissibleValue(text="Classical Hodgkin lymphoma, nodular sclerosis, grade 1") )
        setattr(cls, "Acute lymphoid leukemia",
                PermissibleValue(text="Acute lymphoid leukemia") )
        setattr(cls, "Biliary intraepithelial neoplasia, grade 3",
                PermissibleValue(text="Biliary intraepithelial neoplasia, grade 3") )
        setattr(cls, "Follicular thyroid carcinoma (FTC), encapsulated angioinvasive",
                PermissibleValue(text="Follicular thyroid carcinoma (FTC), encapsulated angioinvasive") )
        setattr(cls, "Mantle cell lymphoma (Includes all variants blastic, pleomorphic, small cell)",
                PermissibleValue(text="Mantle cell lymphoma (Includes all variants blastic, pleomorphic, small cell)") )
        setattr(cls, "Intraductal papillary tumor with high grade dysplasia",
                PermissibleValue(text="Intraductal papillary tumor with high grade dysplasia") )
        setattr(cls, "Malignant fibrous histiocytoma (MFH) of bone",
                PermissibleValue(text="Malignant fibrous histiocytoma (MFH) of bone") )
        setattr(cls, "Pilomyxoid astrocytoma",
                PermissibleValue(text="Pilomyxoid astrocytoma") )
        setattr(cls, "Mucinous cystoma",
                PermissibleValue(text="Mucinous cystoma") )
        setattr(cls, "Pre-pre-B ALL",
                PermissibleValue(text="Pre-pre-B ALL") )
        setattr(cls, "Odontoma, NOS",
                PermissibleValue(text="Odontoma, NOS") )
        setattr(cls, "Rosette-forming glioneuronal tumor",
                PermissibleValue(text="Rosette-forming glioneuronal tumor") )
        setattr(cls, "Meningeal melanomatosis",
                PermissibleValue(text="Meningeal melanomatosis") )
        setattr(cls, "Intraneural perineurioma",
                PermissibleValue(text="Intraneural perineurioma") )
        setattr(cls, "Esophageal squamous intraepithelial neoplasia (dysplasia), low grade",
                PermissibleValue(text="Esophageal squamous intraepithelial neoplasia (dysplasia), low grade") )
        setattr(cls, "GIST, NOS",
                PermissibleValue(text="GIST, NOS") )
        setattr(cls, "Mucinous cystic tumor with intermediate dysplasia",
                PermissibleValue(text="Mucinous cystic tumor with intermediate dysplasia") )
        setattr(cls, "Reserve cell carcinoma",
                PermissibleValue(text="Reserve cell carcinoma") )
        setattr(cls, "Pulmonary myxoid sarcoma with EWSR1-CREB1 translocation",
                PermissibleValue(text="Pulmonary myxoid sarcoma with EWSR1-CREB1 translocation") )
        setattr(cls, "Epithelial-myoepithelial carcinoma",
                PermissibleValue(text="Epithelial-myoepithelial carcinoma",
                                 description="Epithelial-Myoepithelial Carcinoma") )
        setattr(cls, "Adenocarcinoma of anal ducts",
                PermissibleValue(text="Adenocarcinoma of anal ducts") )
        setattr(cls, "Intraductal tubular-papillary neoplasm, low grade",
                PermissibleValue(text="Intraductal tubular-papillary neoplasm, low grade") )
        setattr(cls, "Involuting nevus",
                PermissibleValue(text="Involuting nevus") )
        setattr(cls, "Thymoma, spindle cell, malignant",
                PermissibleValue(text="Thymoma, spindle cell, malignant") )
        setattr(cls, "Intimal sarcoma",
                PermissibleValue(text="Intimal sarcoma") )
        setattr(cls, "Intracystic papillary neoplasm with intermediate grade intraepithelial neoplasia",
                PermissibleValue(text="Intracystic papillary neoplasm with intermediate grade intraepithelial neoplasia") )
        setattr(cls, "Papillomatosis, NOS",
                PermissibleValue(text="Papillomatosis, NOS") )
        setattr(cls, "Follicular carcinoma, minimally invasive",
                PermissibleValue(text="Follicular carcinoma, minimally invasive") )
        setattr(cls, "Compound nevus",
                PermissibleValue(text="Compound nevus") )
        setattr(cls, "Thymoma, spindle cell, NOS",
                PermissibleValue(text="Thymoma, spindle cell, NOS") )
        setattr(cls, "Mixed pineocytoma-pineoblastoma",
                PermissibleValue(text="Mixed pineocytoma-pineoblastoma") )
        setattr(cls, "Salivary duct carcinoma",
                PermissibleValue(text="Salivary duct carcinoma",
                                 description="Salivary Duct Carcinoma") )
        setattr(cls, "Vipoma, malignant",
                PermissibleValue(text="Vipoma, malignant") )
        setattr(cls, "Carcinoid tumor, argentaffin, malignant",
                PermissibleValue(text="Carcinoid tumor, argentaffin, malignant") )
        setattr(cls, "Glandular intraepithelial neoplasia, grade III",
                PermissibleValue(text="Glandular intraepithelial neoplasia, grade III") )
        setattr(cls, "Meningiomatosis, NOS",
                PermissibleValue(text="Meningiomatosis, NOS") )
        setattr(cls, "Carcinoma with osteoclast-like giant cells",
                PermissibleValue(text="Carcinoma with osteoclast-like giant cells") )
        setattr(cls, "Malignant lymphoma, small noncleaved, Burkitt type",
                PermissibleValue(text="Malignant lymphoma, small noncleaved, Burkitt type") )
        setattr(cls, "Squamous papillomatosis",
                PermissibleValue(text="Squamous papillomatosis") )
        setattr(cls, "Papillary carcinoma of thyroid",
                PermissibleValue(text="Papillary carcinoma of thyroid") )
        setattr(cls, "Intracystic papillary neoplasm with associated invasive carcinoma",
                PermissibleValue(text="Intracystic papillary neoplasm with associated invasive carcinoma") )
        setattr(cls, "Squamous cell carcinoma in situ with questionable stromal invasion",
                PermissibleValue(text="Squamous cell carcinoma in situ with questionable stromal invasion") )
        setattr(cls, "Desmoplastic small round cell tumor",
                PermissibleValue(text="Desmoplastic small round cell tumor") )
        setattr(cls, "Low grade appendiceal mucinous neoplasm",
                PermissibleValue(text="Low grade appendiceal mucinous neoplasm") )
        setattr(cls, "Fetal fat cell lipoma",
                PermissibleValue(text="Fetal fat cell lipoma") )
        setattr(cls, "Aortic body tumor",
                PermissibleValue(text="Aortic body tumor") )
        setattr(cls, "Low-grade fibromyxoid sarcoma",
                PermissibleValue(text="Low-grade fibromyxoid sarcoma") )
        setattr(cls, "Lymphangioendothelioma, NOS",
                PermissibleValue(text="Lymphangioendothelioma, NOS") )
        setattr(cls, "Epidermoid carcinoma, small cell, nonkeratinizing",
                PermissibleValue(text="Epidermoid carcinoma, small cell, nonkeratinizing") )
        setattr(cls, "Adenosquamous carcinoma",
                PermissibleValue(text="Adenosquamous carcinoma") )
        setattr(cls, "Precursor cell lymphoblastic leukemia, NOS",
                PermissibleValue(text="Precursor cell lymphoblastic leukemia, NOS") )
        setattr(cls, "Liposarcoma, well differentiated",
                PermissibleValue(text="Liposarcoma, well differentiated") )
        setattr(cls, "Endometrioid adenofibroma, NOS",
                PermissibleValue(text="Endometrioid adenofibroma, NOS") )
        setattr(cls, "Fibroepithelial basal cell carcinoma, Pinkus type",
                PermissibleValue(text="Fibroepithelial basal cell carcinoma, Pinkus type") )
        setattr(cls, "Splenic marginal zone lymphoma, NOS",
                PermissibleValue(text="Splenic marginal zone lymphoma, NOS") )
        setattr(cls, "Atypical chronic myeloid leukemia, Philadelphia chromosome (Ph1) negative",
                PermissibleValue(text="Atypical chronic myeloid leukemia, Philadelphia chromosome (Ph1) negative") )
        setattr(cls, "Agnogenic myeloid metaplasia",
                PermissibleValue(text="Agnogenic myeloid metaplasia") )
        setattr(cls, "Angioimmunoblastic lymphoma",
                PermissibleValue(text="Angioimmunoblastic lymphoma") )
        setattr(cls, "Serrated adenocarcinoma",
                PermissibleValue(text="Serrated adenocarcinoma") )
        setattr(cls, "Classical Hodgkin lymphoma, mixed cellularity, NOS",
                PermissibleValue(text="Classical Hodgkin lymphoma, mixed cellularity, NOS") )
        setattr(cls, "Infiltrating lobular carcinoma and ductal carcinoma in situ",
                PermissibleValue(text="Infiltrating lobular carcinoma and ductal carcinoma in situ") )
        setattr(cls, "FAB M3 (includes all variants)",
                PermissibleValue(text="FAB M3 (includes all variants)") )
        setattr(cls, "Keratotoc papilloma",
                PermissibleValue(text="Keratotoc papilloma") )
        setattr(cls, "Juvenile hemangioma",
                PermissibleValue(text="Juvenile hemangioma") )
        setattr(cls, "Malignant lymphoma, centroblastic, diffuse",
                PermissibleValue(text="Malignant lymphoma, centroblastic, diffuse") )
        setattr(cls, "Adrenal cortical adenoma, glomerulosa cell",
                PermissibleValue(text="Adrenal cortical adenoma, glomerulosa cell") )
        setattr(cls, "Adenocarcinoma in situ in a polyp, NOS",
                PermissibleValue(text="Adenocarcinoma in situ in a polyp, NOS") )
        setattr(cls, "Malignant lymphoma, non-Hodgkin, NOS",
                PermissibleValue(text="Malignant lymphoma, non-Hodgkin, NOS") )
        setattr(cls, "Cystosarcoma phyllodes, malignant",
                PermissibleValue(text="Cystosarcoma phyllodes, malignant") )
        setattr(cls, "Malignant lymphoma, plasmacytoid",
                PermissibleValue(text="Malignant lymphoma, plasmacytoid") )
        setattr(cls, "Hepatosplenic gamma-delta cell lymphoma",
                PermissibleValue(text="Hepatosplenic gamma-delta cell lymphoma") )
        setattr(cls, "Low grade cribriform cystadenocarcinoma (LGCCC)",
                PermissibleValue(text="Low grade cribriform cystadenocarcinoma (LGCCC)") )
        setattr(cls, "Bronchiolo-alveolar carcinoma, non-mucinous",
                PermissibleValue(text="Bronchiolo-alveolar carcinoma, non-mucinous") )
        setattr(cls, "Endometrioid adenoma, borderline malignancy",
                PermissibleValue(text="Endometrioid adenoma, borderline malignancy") )
        setattr(cls, "Craniopharyngioma, adamantinomatous",
                PermissibleValue(text="Craniopharyngioma, adamantinomatous") )
        setattr(cls, "Vascular leiomyoma",
                PermissibleValue(text="Vascular leiomyoma") )
        setattr(cls, "Epithelial tumor, malignant",
                PermissibleValue(text="Epithelial tumor, malignant") )
        setattr(cls, "Diffuse intraductal papillomatosis",
                PermissibleValue(text="Diffuse intraductal papillomatosis") )
        setattr(cls, "Large granular lymphocytosis, NOS",
                PermissibleValue(text="Large granular lymphocytosis, NOS") )
        setattr(cls, "Warthin tumor",
                PermissibleValue(text="Warthin tumor") )
        setattr(cls, "Splenic lymphoma with villous lymphocytes",
                PermissibleValue(text="Splenic lymphoma with villous lymphocytes") )
        setattr(cls, "Histiocytic sarcoma",
                PermissibleValue(text="Histiocytic sarcoma") )
        setattr(cls, "Embryonal hepatoma",
                PermissibleValue(text="Embryonal hepatoma") )
        setattr(cls, "Malignant lymphoma, mixed cell type, nodular",
                PermissibleValue(text="Malignant lymphoma, mixed cell type, nodular") )
        setattr(cls, "Mixed adenomatous and hyperplastic polyp",
                PermissibleValue(text="Mixed adenomatous and hyperplastic polyp") )
        setattr(cls, "DCIS, NOS",
                PermissibleValue(text="DCIS, NOS") )
        setattr(cls, "Malignant lymphoma, small cell, noncleaved, diffuse",
                PermissibleValue(text="Malignant lymphoma, small cell, noncleaved, diffuse") )
        setattr(cls, "Malignant lymphoma, lymphocytic, NOS",
                PermissibleValue(text="Malignant lymphoma, lymphocytic, NOS") )
        setattr(cls, "Granular cell tumor of the sellar region",
                PermissibleValue(text="Granular cell tumor of the sellar region") )
        setattr(cls, "Lymphangioendothelial sarcoma",
                PermissibleValue(text="Lymphangioendothelial sarcoma") )
        setattr(cls, "Prolymphocytic leukemia, B-cell type",
                PermissibleValue(text="Prolymphocytic leukemia, B-cell type") )
        setattr(cls, "Composite Hodgkin and non-Hodgkin lymphoma",
                PermissibleValue(text="Composite Hodgkin and non-Hodgkin lymphoma") )
        setattr(cls, "High grade surface osteosarcoma",
                PermissibleValue(text="High grade surface osteosarcoma") )
        setattr(cls, "Ameloblastic fibroma",
                PermissibleValue(text="Ameloblastic fibroma") )
        setattr(cls, "Renal cell carcinoma, spindle cell",
                PermissibleValue(text="Renal cell carcinoma, spindle cell") )
        setattr(cls, "Flat adenoma",
                PermissibleValue(text="Flat adenoma") )
        setattr(cls, "Medullary carcinoma, NOS",
                PermissibleValue(text="Medullary carcinoma, NOS") )
        setattr(cls, "Mesothelial papilloma",
                PermissibleValue(text="Mesothelial papilloma") )
        setattr(cls, "Adenoma of nipple",
                PermissibleValue(text="Adenoma of nipple") )
        setattr(cls, "Acute lymphocytic leukemia",
                PermissibleValue(text="Acute lymphocytic leukemia") )
        setattr(cls, "Primary cutaneous anaplastic large cell lymphoma",
                PermissibleValue(text="Primary cutaneous anaplastic large cell lymphoma") )
        setattr(cls, "Acute monoblastic leukemia",
                PermissibleValue(text="Acute monoblastic leukemia") )
        setattr(cls, "Glycogen-rich carcinoma",
                PermissibleValue(text="Glycogen-rich carcinoma") )
        setattr(cls, "Adenocystic carcinoma",
                PermissibleValue(text="Adenocystic carcinoma") )
        setattr(cls, "Rhabdomyoma, NOS",
                PermissibleValue(text="Rhabdomyoma, NOS") )
        setattr(cls, "Brenner tumor, borderline malignancy",
                PermissibleValue(text="Brenner tumor, borderline malignancy") )
        setattr(cls, "FAB M4",
                PermissibleValue(text="FAB M4") )
        setattr(cls, "Sertoli-Leydig cell tumor of intermediate differentiation",
                PermissibleValue(text="Sertoli-Leydig cell tumor of intermediate differentiation") )
        setattr(cls, "Sezary syndrome",
                PermissibleValue(text="Sezary syndrome") )
        setattr(cls, "Infiltrating lipoma",
                PermissibleValue(text="Infiltrating lipoma") )
        setattr(cls, "Lentigo maligna",
                PermissibleValue(text="Lentigo maligna") )
        setattr(cls, "Eosinophil adenocarcinoma",
                PermissibleValue(text="Eosinophil adenocarcinoma") )
        setattr(cls, "Odontogenic carcinoma",
                PermissibleValue(text="Odontogenic carcinoma") )
        setattr(cls, "Brenner tumor, proliferating",
                PermissibleValue(text="Brenner tumor, proliferating") )
        setattr(cls, "Clear cell adenocarcinoma, NOS",
                PermissibleValue(text="Clear cell adenocarcinoma, NOS") )
        setattr(cls, "Carcinoma in pleomorphic adenoma",
                PermissibleValue(text="Carcinoma in pleomorphic adenoma") )
        setattr(cls, "Serous cystoma",
                PermissibleValue(text="Serous cystoma") )
        setattr(cls, "Bronchiolo-alveolar carcinoma, type II pneumocyte and goblet cell type",
                PermissibleValue(text="Bronchiolo-alveolar carcinoma, type II pneumocyte and goblet cell type") )
        setattr(cls, "Follicular adenocarcinoma, moderately differentiated",
                PermissibleValue(text="Follicular adenocarcinoma, moderately differentiated") )
        setattr(cls, "Urothelial papilloma, NOS",
                PermissibleValue(text="Urothelial papilloma, NOS") )
        setattr(cls, "Solitary fibrous tumor",
                PermissibleValue(text="Solitary fibrous tumor") )
        setattr(cls, "Enteroglucagonoma, NOS",
                PermissibleValue(text="Enteroglucagonoma, NOS") )
        setattr(cls, "Carcinoma, intestinal type",
                PermissibleValue(text="Carcinoma, intestinal type") )
        setattr(cls, "Tanycytic ependymoma",
                PermissibleValue(text="Tanycytic ependymoma") )
        setattr(cls, "Papillary squamous cell carcinoma in situ",
                PermissibleValue(text="Papillary squamous cell carcinoma in situ") )
        setattr(cls, "Acute myeloid leukemia, CBF-beta/MYH11",
                PermissibleValue(text="Acute myeloid leukemia, CBF-beta/MYH11") )
        setattr(cls, "VIN III",
                PermissibleValue(text="VIN III") )
        setattr(cls, "Squamous cell carcinoma, nonkeratinizing, NOS",
                PermissibleValue(text="Squamous cell carcinoma, nonkeratinizing, NOS") )
        setattr(cls, "B-ALL",
                PermissibleValue(text="B-ALL") )
        setattr(cls, "Unclassified tumor, malignant, uncertain whether primary or metastatic",
                PermissibleValue(text="Unclassified tumor, malignant, uncertain whether primary or metastatic") )
        setattr(cls, "Askin tumor",
                PermissibleValue(text="Askin tumor") )
        setattr(cls, "Mesenchymal chondrosarcoma",
                PermissibleValue(text="Mesenchymal chondrosarcoma") )
        setattr(cls, "Villoglandular adenoma",
                PermissibleValue(text="Villoglandular adenoma") )
        setattr(cls, "Flat intraepithelial neoplasia, high grade",
                PermissibleValue(text="Flat intraepithelial neoplasia, high grade") )
        setattr(cls, "Papillary carcinoma, columnar cell",
                PermissibleValue(text="Papillary carcinoma, columnar cell") )
        setattr(cls, "Small cell carcinoma pulmonary type",
                PermissibleValue(text="Small cell carcinoma pulmonary type") )
        setattr(cls, "Synovial sarcoma, epithelioid cell",
                PermissibleValue(text="Synovial sarcoma, epithelioid cell") )
        setattr(cls, "Villous papilloma",
                PermissibleValue(text="Villous papilloma") )
        setattr(cls, "Mixed adenocarcinoma and squamous cell carcinoma",
                PermissibleValue(text="Mixed adenocarcinoma and squamous cell carcinoma") )
        setattr(cls, "Carcinoma in situ in a polyp, NOS",
                PermissibleValue(text="Carcinoma in situ in a polyp, NOS") )
        setattr(cls, "Acute lymphoblastic leukemia-lymphoma, NOS",
                PermissibleValue(text="Acute lymphoblastic leukemia-lymphoma, NOS") )
        setattr(cls, "Intracystic carcinoma, NOS",
                PermissibleValue(text="Intracystic carcinoma, NOS") )
        setattr(cls, "Squamous carcinoma",
                PermissibleValue(text="Squamous carcinoma") )
        setattr(cls, "Endometrioid adenocarcinoma, villoglandular",
                PermissibleValue(text="Endometrioid adenocarcinoma, villoglandular") )
        setattr(cls, "Anaplastic medulloblastoma",
                PermissibleValue(text="Anaplastic medulloblastoma") )
        setattr(cls, "Monocytoid B-cell lymphoma",
                PermissibleValue(text="Monocytoid B-cell lymphoma") )
        setattr(cls, "Refractory anemia",
                PermissibleValue(text="Refractory anemia") )
        setattr(cls, "Teratoma, malignant, NOS",
                PermissibleValue(text="Teratoma, malignant, NOS") )
        setattr(cls, "Not Reported",
                PermissibleValue(text="Not Reported") )
        setattr(cls, "Malignant lymphoma, lymphocytic, diffuse, NOS",
                PermissibleValue(text="Malignant lymphoma, lymphocytic, diffuse, NOS") )
        setattr(cls, "Trabecular adenocarcinoma",
                PermissibleValue(text="Trabecular adenocarcinoma") )
        setattr(cls, "Clear cell adenocarcinofibroma",
                PermissibleValue(text="Clear cell adenocarcinofibroma") )
        setattr(cls, "Carcinoma in situ in adenomatous polyp",
                PermissibleValue(text="Carcinoma in situ in adenomatous polyp") )
        setattr(cls, "Acute myelomonocytic leukemia",
                PermissibleValue(text="Acute myelomonocytic leukemia") )
        setattr(cls, "Endocervical adenocarcinoma usual type",
                PermissibleValue(text="Endocervical adenocarcinoma usual type") )
        setattr(cls, "Lymphoblastic leukemia, NOS",
                PermissibleValue(text="Lymphoblastic leukemia, NOS") )
        setattr(cls, "Invasive carcinoma, NST",
                PermissibleValue(text="Invasive carcinoma, NST") )
        setattr(cls, "Malignant lymphoma, centroblasticcentrocytic, diffuse",
                PermissibleValue(text="Malignant lymphoma, centroblasticcentrocytic, diffuse") )
        setattr(cls, "Cystic partially differentiated nephroblastoma",
                PermissibleValue(text="Cystic partially differentiated nephroblastoma") )
        setattr(cls, "Superficial spreading adenocarcinoma",
                PermissibleValue(text="Superficial spreading adenocarcinoma") )
        setattr(cls, "Acinar cell cystadenocarcinoma",
                PermissibleValue(text="Acinar cell cystadenocarcinoma",
                                 description="Pancreatic Acinar Cell Cystadenocarcinoma") )
        setattr(cls, "Teratoma, NOS",
                PermissibleValue(text="Teratoma, NOS") )
        setattr(cls, "Parietal cell carcinoma",
                PermissibleValue(text="Parietal cell carcinoma") )
        setattr(cls, "Hepatoma, NOS",
                PermissibleValue(text="Hepatoma, NOS") )
        setattr(cls, "Sebaceous epithelioma",
                PermissibleValue(text="Sebaceous epithelioma") )
        setattr(cls, "Adenocarcinoma in situ in villous adenoma",
                PermissibleValue(text="Adenocarcinoma in situ in villous adenoma") )
        setattr(cls, "Hodgkin disease, NOS",
                PermissibleValue(text="Hodgkin disease, NOS") )
        setattr(cls, "Endometrioid cystadenoma, borderline malignancy",
                PermissibleValue(text="Endometrioid cystadenoma, borderline malignancy") )
        setattr(cls, "Hepatocellular carcinoma, clear cell type",
                PermissibleValue(text="Hepatocellular carcinoma, clear cell type") )
        setattr(cls, "Infiltrating duct and tubular carcinoma",
                PermissibleValue(text="Infiltrating duct and tubular carcinoma") )
        setattr(cls, "Round cell osteosarcoma",
                PermissibleValue(text="Round cell osteosarcoma") )
        setattr(cls, "Rathke pouch tumor",
                PermissibleValue(text="Rathke pouch tumor") )
        setattr(cls, "Subependymal giant cell astrocytoma",
                PermissibleValue(text="Subependymal giant cell astrocytoma") )
        setattr(cls, "Sertoli-Leydig cell tumor, poorly differentiated",
                PermissibleValue(text="Sertoli-Leydig cell tumor, poorly differentiated") )
        setattr(cls, "Squamous cell papilloma, inverted",
                PermissibleValue(text="Squamous cell papilloma, inverted") )
        setattr(cls, "Sarcoma, NOS",
                PermissibleValue(text="Sarcoma, NOS") )
        setattr(cls, "Subacute myeloid leukemia",
                PermissibleValue(text="Subacute myeloid leukemia") )
        setattr(cls, "Intraepithelial carcinoma, NOS",
                PermissibleValue(text="Intraepithelial carcinoma, NOS") )
        setattr(cls, "Comedocarcinoma, NOS",
                PermissibleValue(text="Comedocarcinoma, NOS") )
        setattr(cls, "Adenocarcinoma in situ, NOS",
                PermissibleValue(text="Adenocarcinoma in situ, NOS") )
        setattr(cls, "Hodgkin lymphoma, mixed cellularity, NOS",
                PermissibleValue(text="Hodgkin lymphoma, mixed cellularity, NOS") )
        setattr(cls, "Hepatoma, benign",
                PermissibleValue(text="Hepatoma, benign") )
        setattr(cls, "Pilar tumor",
                PermissibleValue(text="Pilar tumor") )
        setattr(cls, "Synovial sarcoma, NOS",
                PermissibleValue(text="Synovial sarcoma, NOS") )
        setattr(cls, "Thecoma, NOS",
                PermissibleValue(text="Thecoma, NOS") )
        setattr(cls, "Serous microcystic adenoma",
                PermissibleValue(text="Serous microcystic adenoma") )
        setattr(cls, "Acinar cell adenoma",
                PermissibleValue(text="Acinar cell adenoma") )
        setattr(cls, "Glioblastoma, IDH-mutant",
                PermissibleValue(text="Glioblastoma, IDH-mutant") )
        setattr(cls, "Diffuse astrocytoma, IDH-mutant",
                PermissibleValue(text="Diffuse astrocytoma, IDH-mutant") )
        setattr(cls, "Condylomatous carcinoma",
                PermissibleValue(text="Condylomatous carcinoma") )
        setattr(cls, "Follicular carcinoma, trabecular",
                PermissibleValue(text="Follicular carcinoma, trabecular") )
        setattr(cls, "Malignant lymphoma, lymphoplasmacytic",
                PermissibleValue(text="Malignant lymphoma, lymphoplasmacytic") )
        setattr(cls, "Solid and papillary epithelial neoplasm",
                PermissibleValue(text="Solid and papillary epithelial neoplasm") )
        setattr(cls, "Mullerian mixed tumor",
                PermissibleValue(text="Mullerian mixed tumor") )
        setattr(cls, "Papillary microcarcinoma",
                PermissibleValue(text="Papillary microcarcinoma") )
        setattr(cls, "Melanotic progonoma",
                PermissibleValue(text="Melanotic progonoma") )
        setattr(cls, "Melanotic schwannoma",
                PermissibleValue(text="Melanotic schwannoma") )
        setattr(cls, "Ductal intraepithelial neoplasia 3",
                PermissibleValue(text="Ductal intraepithelial neoplasia 3") )
        setattr(cls, "Juvenile melanoma",
                PermissibleValue(text="Juvenile melanoma") )
        setattr(cls, "Malignant serous adenofibroma",
                PermissibleValue(text="Malignant serous adenofibroma") )
        setattr(cls, "Intraductal papilloma with ductal carcinoma in situ",
                PermissibleValue(text="Intraductal papilloma with ductal carcinoma in situ") )
        setattr(cls, "Non-invasive follicular thyroid neoplasm with papillary-like nuclear features (NIFTP)",
                PermissibleValue(text="Non-invasive follicular thyroid neoplasm with papillary-like nuclear features (NIFTP)") )
        setattr(cls, "Periapical cemental dysplasia",
                PermissibleValue(text="Periapical cemental dysplasia") )
        setattr(cls, "Paget disease, mammary",
                PermissibleValue(text="Paget disease, mammary") )
        setattr(cls, "Schneiderian papilloma, inverted",
                PermissibleValue(text="Schneiderian papilloma, inverted") )
        setattr(cls, "Sinonasal papilloma, NOS",
                PermissibleValue(text="Sinonasal papilloma, NOS") )
        setattr(cls, "Alpha cell tumor, malignant",
                PermissibleValue(text="Alpha cell tumor, malignant") )
        setattr(cls, "Infiltrating lobular mixed with other types of carcinoma",
                PermissibleValue(text="Infiltrating lobular mixed with other types of carcinoma") )
        setattr(cls, "Proliferating trichilemmal cyst",
                PermissibleValue(text="Proliferating trichilemmal cyst") )
        setattr(cls, "Well differentiated thymic carcinoma",
                PermissibleValue(text="Well differentiated thymic carcinoma") )
        setattr(cls, "Diktyoma, malignant",
                PermissibleValue(text="Diktyoma, malignant") )
        setattr(cls, "Periosteal chondrosarcoma",
                PermissibleValue(text="Periosteal chondrosarcoma") )
        setattr(cls, "Atypical fibrous histiocytoma",
                PermissibleValue(text="Atypical fibrous histiocytoma") )
        setattr(cls, "Mucinous adenocarcinofibroma",
                PermissibleValue(text="Mucinous adenocarcinofibroma") )
        setattr(cls, "Mixed cell adenocarcinoma",
                PermissibleValue(text="Mixed cell adenocarcinoma") )
        setattr(cls, "Large cell medulloblastoma",
                PermissibleValue(text="Large cell medulloblastoma") )
        setattr(cls, "Chronic myelomonocytic leukemia in transformation",
                PermissibleValue(text="Chronic myelomonocytic leukemia in transformation") )
        setattr(cls, "Tubulolobular carcinoma",
                PermissibleValue(text="Tubulolobular carcinoma") )
        setattr(cls, "Subependymal glioma",
                PermissibleValue(text="Subependymal glioma") )
        setattr(cls, "Hodgkin lymphoma, nodular sclerosis, cellular phase",
                PermissibleValue(text="Hodgkin lymphoma, nodular sclerosis, cellular phase") )
        setattr(cls, "Adenocarcinoma in a polyp, NOS",
                PermissibleValue(text="Adenocarcinoma in a polyp, NOS") )
        setattr(cls, "Pro-B ALL",
                PermissibleValue(text="Pro-B ALL") )
        setattr(cls, "Adenocarcinoma, pancreatobiliary type",
                PermissibleValue(text="Adenocarcinoma, pancreatobiliary type") )
        setattr(cls, "Tubulopapillary adenocarcinoma",
                PermissibleValue(text="Tubulopapillary adenocarcinoma") )
        setattr(cls, "Diffuse large B-cell lymphoma, NOS",
                PermissibleValue(text="Diffuse large B-cell lymphoma, NOS") )
        setattr(cls, "Interdigitating dendritic cell sarcoma",
                PermissibleValue(text="Interdigitating dendritic cell sarcoma") )
        setattr(cls, "Large B-cell lymphoma arising in HHV8-associated multicentric Castleman disease",
                PermissibleValue(text="Large B-cell lymphoma arising in HHV8-associated multicentric Castleman disease") )
        setattr(cls, "Squamous intraepithelial neoplasia, grade I",
                PermissibleValue(text="Squamous intraepithelial neoplasia, grade I") )
        setattr(cls, "Ganglioglioma, anaplastic",
                PermissibleValue(text="Ganglioglioma, anaplastic") )
        setattr(cls, "Eosinophil carcinoma",
                PermissibleValue(text="Eosinophil carcinoma") )
        setattr(cls, "Papilloma of bladder",
                PermissibleValue(text="Papilloma of bladder") )
        setattr(cls, "Warty carcinoma",
                PermissibleValue(text="Warty carcinoma") )
        setattr(cls, "Malignant lymphoma, mixed cell type, diffuse",
                PermissibleValue(text="Malignant lymphoma, mixed cell type, diffuse") )
        setattr(cls, "Mixed tumor, salivary gland type, NOS",
                PermissibleValue(text="Mixed tumor, salivary gland type, NOS") )
        setattr(cls, "Myeloid and lymphoid neoplasms with PDGFRA rearrangement",
                PermissibleValue(text="Myeloid and lymphoid neoplasms with PDGFRA rearrangement") )
        setattr(cls, "Mucoepidermoid tumor",
                PermissibleValue(text="Mucoepidermoid tumor") )
        setattr(cls, "Hodgkin granuloma",
                PermissibleValue(text="Hodgkin granuloma") )
        setattr(cls, "Metaplastic carcinoma with osseous differentiation",
                PermissibleValue(text="Metaplastic carcinoma with osseous differentiation") )
        setattr(cls, "Blastic NK cell lymphoma",
                PermissibleValue(text="Blastic NK cell lymphoma") )
        setattr(cls, "Intraductal micropapillary carcinoma",
                PermissibleValue(text="Intraductal micropapillary carcinoma") )
        setattr(cls, "Granular cell tumor, NOS",
                PermissibleValue(text="Granular cell tumor, NOS") )
        setattr(cls, "Letterer-Siwe disease",
                PermissibleValue(text="Letterer-Siwe disease") )
        setattr(cls, "Epithelioma, malignant",
                PermissibleValue(text="Epithelioma, malignant") )
        setattr(cls, "Clear cell adenofibroma",
                PermissibleValue(text="Clear cell adenofibroma") )
        setattr(cls, "Biliary intraepithelial neoplasia, high grade",
                PermissibleValue(text="Biliary intraepithelial neoplasia, high grade") )
        setattr(cls, "Endometrial sarcoma, NOS",
                PermissibleValue(text="Endometrial sarcoma, NOS") )
        setattr(cls, "Indeterminate dendritic cell tumor",
                PermissibleValue(text="Indeterminate dendritic cell tumor") )
        setattr(cls, "Cellular leiomyoma",
                PermissibleValue(text="Cellular leiomyoma") )
        setattr(cls, "Mixed cell adenoma",
                PermissibleValue(text="Mixed cell adenoma") )
        setattr(cls, "Theca cell-granulosa cell tumor",
                PermissibleValue(text="Theca cell-granulosa cell tumor") )
        setattr(cls, "Carcinoma, undifferentiated, NOS",
                PermissibleValue(text="Carcinoma, undifferentiated, NOS") )
        setattr(cls, "Gastrointestinal stromal tumor, benign",
                PermissibleValue(text="Gastrointestinal stromal tumor, benign") )
        setattr(cls, "Ectopic hamartomatous thymoma",
                PermissibleValue(text="Ectopic hamartomatous thymoma") )
        setattr(cls, "Subacute monocytic leukemia",
                PermissibleValue(text="Subacute monocytic leukemia") )
        setattr(cls, "Non-invasive encapsulated follicular variant of papillary thyroid carcinoma (non-invasive EFVPTC)",
                PermissibleValue(text="Non-invasive encapsulated follicular variant of papillary thyroid carcinoma (non-invasive EFVPTC)") )
        setattr(cls, "True histiocytic lymphoma",
                PermissibleValue(text="True histiocytic lymphoma") )
        setattr(cls, "Plexiform fibrohistiocytic tumor",
                PermissibleValue(text="Plexiform fibrohistiocytic tumor") )
        setattr(cls, "Intramuscular lipoma",
                PermissibleValue(text="Intramuscular lipoma") )
        setattr(cls, "Malignant mastocytosis",
                PermissibleValue(text="Malignant mastocytosis") )
        setattr(cls, "Pseudomucinous cystadenoma, NOS",
                PermissibleValue(text="Pseudomucinous cystadenoma, NOS") )
        setattr(cls, "Carcinoid tumor of uncertain malignant potential",
                PermissibleValue(text="Carcinoid tumor of uncertain malignant potential") )
        setattr(cls, "Brown fat tumor",
                PermissibleValue(text="Brown fat tumor") )
        setattr(cls, "Lipoma, NOS",
                PermissibleValue(text="Lipoma, NOS") )
        setattr(cls, "Sinonasal papilloma, exophytic",
                PermissibleValue(text="Sinonasal papilloma, exophytic") )
        setattr(cls, "B lymphoblastic leukemia/lymphoma with hypodiploidy (Hypodiploid ALL)",
                PermissibleValue(text="B lymphoblastic leukemia/lymphoma with hypodiploidy (Hypodiploid ALL)") )
        setattr(cls, "Mesonephric tumor, NOS",
                PermissibleValue(text="Mesonephric tumor, NOS") )
        setattr(cls, "Malignant lymphoma, large cell, cleaved and noncleaved",
                PermissibleValue(text="Malignant lymphoma, large cell, cleaved and noncleaved") )
        setattr(cls, "Adenocarcinoma with spindle cell metaplasia",
                PermissibleValue(text="Adenocarcinoma with spindle cell metaplasia") )
        setattr(cls, "Mucinous carcinoma",
                PermissibleValue(text="Mucinous carcinoma") )
        setattr(cls, "Mesonephric adenocarcinoma",
                PermissibleValue(text="Mesonephric adenocarcinoma") )
        setattr(cls, "Heavy chain disease, NOS",
                PermissibleValue(text="Heavy chain disease, NOS") )
        setattr(cls, "Tumor embolus",
                PermissibleValue(text="Tumor embolus") )
        setattr(cls, "Epidermoid carcinoma in situ, NOS",
                PermissibleValue(text="Epidermoid carcinoma in situ, NOS") )
        setattr(cls, "Plasmablastic lymphoma",
                PermissibleValue(text="Plasmablastic lymphoma") )
        setattr(cls, "Biliary intraepithelial neoplasia, low grade",
                PermissibleValue(text="Biliary intraepithelial neoplasia, low grade") )
        setattr(cls, "Astrocytic glioma",
                PermissibleValue(text="Astrocytic glioma") )
        setattr(cls, "Malignant fibrous histiocytoma",
                PermissibleValue(text="Malignant fibrous histiocytoma") )
        setattr(cls, "Inflammatory liposarcoma",
                PermissibleValue(text="Inflammatory liposarcoma") )
        setattr(cls, "Tumorlet, NOS",
                PermissibleValue(text="Tumorlet, NOS") )
        setattr(cls, "Intraductal papillary-mucinous carcinoma, invasive",
                PermissibleValue(text="Intraductal papillary-mucinous carcinoma, invasive") )
        setattr(cls, "Metaplastic carcinoma of no special type",
                PermissibleValue(text="Metaplastic carcinoma of no special type") )
        setattr(cls, "Cystic tumor of atrio-ventricular node",
                PermissibleValue(text="Cystic tumor of atrio-ventricular node") )
        setattr(cls, "Bronchiolo-alveolar carcinoma, goblet cell type",
                PermissibleValue(text="Bronchiolo-alveolar carcinoma, goblet cell type") )
        setattr(cls, "Monoblastic leukemia, NOS",
                PermissibleValue(text="Monoblastic leukemia, NOS") )
        setattr(cls, "Mast cell tumor, NOS",
                PermissibleValue(text="Mast cell tumor, NOS") )
        setattr(cls, "Papillary and follicular adenocarcinoma",
                PermissibleValue(text="Papillary and follicular adenocarcinoma") )
        setattr(cls, "Plasmacytic lymphoma",
                PermissibleValue(text="Plasmacytic lymphoma") )
        setattr(cls, "Common ALL",
                PermissibleValue(text="Common ALL") )
        setattr(cls, "Endometrioid adenocarcinoma, secretory variant",
                PermissibleValue(text="Endometrioid adenocarcinoma, secretory variant") )
        setattr(cls, "AML M6",
                PermissibleValue(text="AML M6") )
        setattr(cls, "Invasive lobular carcinoma, solid type",
                PermissibleValue(text="Invasive lobular carcinoma, solid type") )
        setattr(cls, "Water-clear cell carcinoma",
                PermissibleValue(text="Water-clear cell carcinoma") )
        setattr(cls, "Secretory meningioma",
                PermissibleValue(text="Secretory meningioma") )
        setattr(cls, "Ewing tumor",
                PermissibleValue(text="Ewing tumor") )
        setattr(cls, "Malignant lymphoma, centrocytic",
                PermissibleValue(text="Malignant lymphoma, centrocytic") )
        setattr(cls, "Hereditary leiomyomatosis & RCC-associated renal cell carcinoma",
                PermissibleValue(text="Hereditary leiomyomatosis & RCC-associated renal cell carcinoma") )
        setattr(cls, "Acute myloid leukemia, 11q23 abnormalities",
                PermissibleValue(text="Acute myloid leukemia, 11q23 abnormalities") )
        setattr(cls, "Refractory anemia with excess blasts in transformation",
                PermissibleValue(text="Refractory anemia with excess blasts in transformation") )
        setattr(cls, "Malignant lymphoma, lymphocytic, well differentiated, nodular",
                PermissibleValue(text="Malignant lymphoma, lymphocytic, well differentiated, nodular") )
        setattr(cls, "Meningioma, NOS",
                PermissibleValue(text="Meningioma, NOS") )
        setattr(cls, "Microcystic meningioma",
                PermissibleValue(text="Microcystic meningioma") )
        setattr(cls, "Micropapillary carcinoma, NOS",
                PermissibleValue(text="Micropapillary carcinoma, NOS") )
        setattr(cls, "Carcinoma simplex",
                PermissibleValue(text="Carcinoma simplex") )
        setattr(cls, "Mixed subependymoma-ependymoma",
                PermissibleValue(text="Mixed subependymoma-ependymoma") )
        setattr(cls, "Adenocarcinoma in situ in polypoid adenoma",
                PermissibleValue(text="Adenocarcinoma in situ in polypoid adenoma") )
        setattr(cls, "Langerhans cell histiocytosis, disseminated",
                PermissibleValue(text="Langerhans cell histiocytosis, disseminated") )
        setattr(cls, "Embryonal tumor with rhabdoid features",
                PermissibleValue(text="Embryonal tumor with rhabdoid features") )
        setattr(cls, "Skin appendage adenoma",
                PermissibleValue(text="Skin appendage adenoma") )
        setattr(cls, "Primary cutaneous CD8-positive aggressive epidermotropic cytotoxic T-cell lymphoma",
                PermissibleValue(text="Primary cutaneous CD8-positive aggressive epidermotropic cytotoxic T-cell lymphoma") )
        setattr(cls, "Rhabdoid meningioma",
                PermissibleValue(text="Rhabdoid meningioma") )
        setattr(cls, "Immunoglobulin deposition disease",
                PermissibleValue(text="Immunoglobulin deposition disease") )
        setattr(cls, "Intraductal carcinoma, clinging",
                PermissibleValue(text="Intraductal carcinoma, clinging") )
        setattr(cls, "Follicular carcinoma, NOS",
                PermissibleValue(text="Follicular carcinoma, NOS") )
        setattr(cls, "Malignant lymphoma, small cleaved cell, diffuse",
                PermissibleValue(text="Malignant lymphoma, small cleaved cell, diffuse") )
        setattr(cls, "Refractory anemia with excess blasts",
                PermissibleValue(text="Refractory anemia with excess blasts") )
        setattr(cls, "Papillary cystadenocarcinoma, NOS",
                PermissibleValue(text="Papillary cystadenocarcinoma, NOS") )
        setattr(cls, "Medulloepithelioma, benign",
                PermissibleValue(text="Medulloepithelioma, benign") )
        setattr(cls, "Osteochondromatosis, NOS",
                PermissibleValue(text="Osteochondromatosis, NOS") )
        setattr(cls, "Mixed medullary-papillary carcinoma",
                PermissibleValue(text="Mixed medullary-papillary carcinoma") )
        setattr(cls, "Subacute granulocytic leukemia",
                PermissibleValue(text="Subacute granulocytic leukemia") )
        setattr(cls, "Large cell carcinoma, NOS",
                PermissibleValue(text="Large cell carcinoma, NOS") )
        setattr(cls, "Spindled mesothelioma",
                PermissibleValue(text="Spindled mesothelioma") )
        setattr(cls, "Fetal rhabdomyoma",
                PermissibleValue(text="Fetal rhabdomyoma") )
        setattr(cls, "Malignant lymphoma, lymphocytic, intermediate differentiation, nodular",
                PermissibleValue(text="Malignant lymphoma, lymphocytic, intermediate differentiation, nodular") )
        setattr(cls, "Angioimmunoblastic T-cell lymphoma",
                PermissibleValue(text="Angioimmunoblastic T-cell lymphoma") )
        setattr(cls, "Transitional cell papilloma, inverted, NOS",
                PermissibleValue(text="Transitional cell papilloma, inverted, NOS") )
        setattr(cls, "Refractory anemia with ringed sideroblasts",
                PermissibleValue(text="Refractory anemia with ringed sideroblasts") )
        setattr(cls, "Giant cell fibroblastoma",
                PermissibleValue(text="Giant cell fibroblastoma") )
        setattr(cls, "Burkitt-like lymphoma",
                PermissibleValue(text="Burkitt-like lymphoma") )
        setattr(cls, "Spongioblastoma multiforme",
                PermissibleValue(text="Spongioblastoma multiforme") )
        setattr(cls, "Mixed squamous cell and glandular papilloma",
                PermissibleValue(text="Mixed squamous cell and glandular papilloma") )
        setattr(cls, "Cutaneous histiocytoma, NOS",
                PermissibleValue(text="Cutaneous histiocytoma, NOS") )
        setattr(cls, "Immature teratoma, malignant",
                PermissibleValue(text="Immature teratoma, malignant") )
        setattr(cls, "Mucinous cystic tumor with moderate dysplasia",
                PermissibleValue(text="Mucinous cystic tumor with moderate dysplasia") )
        setattr(cls, "GIST, malignant",
                PermissibleValue(text="GIST, malignant") )
        setattr(cls, "Myxoma, NOS",
                PermissibleValue(text="Myxoma, NOS") )
        setattr(cls, "Papillary neoplasm, pancreatobiliary-type, with high grade intraepithelial neoplasia",
                PermissibleValue(text="Papillary neoplasm, pancreatobiliary-type, with high grade intraepithelial neoplasia") )
        setattr(cls, "NUT midline carcinoma",
                PermissibleValue(text="NUT midline carcinoma") )
        setattr(cls, "Codman tumor",
                PermissibleValue(text="Codman tumor") )
        setattr(cls, "Primitive neuroectodermal tumor, NOS",
                PermissibleValue(text="Primitive neuroectodermal tumor, NOS") )
        setattr(cls, "Ganglioglioma, NOS",
                PermissibleValue(text="Ganglioglioma, NOS") )
        setattr(cls, "Luteoma, NOS",
                PermissibleValue(text="Luteoma, NOS") )
        setattr(cls, "Acute myeloid leukemia, PML/RAR-alpha",
                PermissibleValue(text="Acute myeloid leukemia, PML/RAR-alpha") )
        setattr(cls, "Adenoma, NOS",
                PermissibleValue(text="Adenoma, NOS") )
        setattr(cls, "Transitional cell carcinoma, spindle cell",
                PermissibleValue(text="Transitional cell carcinoma, spindle cell") )
        setattr(cls, "Intracystic papillary tumor with high grade entraepithelial neoplasia",
                PermissibleValue(text="Intracystic papillary tumor with high grade entraepithelial neoplasia") )
        setattr(cls, "Malignant lymphoma, large cell, cleaved, NOS",
                PermissibleValue(text="Malignant lymphoma, large cell, cleaved, NOS") )
        setattr(cls, "Lipid-rich Sertoli cell tumor",
                PermissibleValue(text="Lipid-rich Sertoli cell tumor") )
        setattr(cls, "Bronchiolo-alveolar carcinoma, indeterminate type",
                PermissibleValue(text="Bronchiolo-alveolar carcinoma, indeterminate type") )
        setattr(cls, "Intraductal papillary adenocarcinoma, NOS",
                PermissibleValue(text="Intraductal papillary adenocarcinoma, NOS") )
        setattr(cls, "Ependymoma, NOS",
                PermissibleValue(text="Ependymoma, NOS") )
        setattr(cls, "Abdominal fibromatosis",
                PermissibleValue(text="Abdominal fibromatosis") )
        setattr(cls, "Hepatoid carcinoma",
                PermissibleValue(text="Hepatoid carcinoma") )
        setattr(cls, "Squamous cell carcinoma, HPV-negative",
                PermissibleValue(text="Squamous cell carcinoma, HPV-negative") )
        setattr(cls, "Unclassified tumor, malignant",
                PermissibleValue(text="Unclassified tumor, malignant") )
        setattr(cls, "Follicular lymphoma, NOS",
                PermissibleValue(text="Follicular lymphoma, NOS") )
        setattr(cls, "Paget disease of breast",
                PermissibleValue(text="Paget disease of breast") )
        setattr(cls, "Malignant lymphoma, convoluted cell",
                PermissibleValue(text="Malignant lymphoma, convoluted cell") )
        setattr(cls, "Botryoid sarcoma",
                PermissibleValue(text="Botryoid sarcoma") )
        setattr(cls, "Hodgkin disease, nodular sclerosis, lymphocyte predominance",
                PermissibleValue(text="Hodgkin disease, nodular sclerosis, lymphocyte predominance") )
        setattr(cls, "Ossifying renal tumor",
                PermissibleValue(text="Ossifying renal tumor") )
        setattr(cls, "Fetal adenoma",
                PermissibleValue(text="Fetal adenoma") )
        setattr(cls, "Follicular carcinoma, oxyphilic cell",
                PermissibleValue(text="Follicular carcinoma, oxyphilic cell") )
        setattr(cls, "Angioimmunoblastic lymphadenopathy",
                PermissibleValue(text="Angioimmunoblastic lymphadenopathy") )
        setattr(cls, "Marginal zone B-cell lymphoma, NOS",
                PermissibleValue(text="Marginal zone B-cell lymphoma, NOS") )
        setattr(cls, "Granulocytic sarcoma",
                PermissibleValue(text="Granulocytic sarcoma") )
        setattr(cls, "Medulloblastoma, NOS",
                PermissibleValue(text="Medulloblastoma, NOS") )
        setattr(cls, "Oncocytic Schneiderian papilloma",
                PermissibleValue(text="Oncocytic Schneiderian papilloma") )
        setattr(cls, "Squamous cell carcinoma, small cell, nonkeratinizing",
                PermissibleValue(text="Squamous cell carcinoma, small cell, nonkeratinizing") )
        setattr(cls, "Cribriform carcinoma in situ",
                PermissibleValue(text="Cribriform carcinoma in situ") )
        setattr(cls, "Clear cell sarcoma, of tendons and aponeuroses",
                PermissibleValue(text="Clear cell sarcoma, of tendons and aponeuroses") )
        setattr(cls, "ECL cell carcinoid, malignant",
                PermissibleValue(text="ECL cell carcinoid, malignant") )
        setattr(cls, "Tumorlet, benign",
                PermissibleValue(text="Tumorlet, benign") )
        setattr(cls, "Schmincke tumor",
                PermissibleValue(text="Schmincke tumor") )
        setattr(cls, "B-cell lymphocytic leukemia/small lymphocytic lymphoma",
                PermissibleValue(text="B-cell lymphocytic leukemia/small lymphocytic lymphoma") )
        setattr(cls, "Adenocarcinoma, diffuse type",
                PermissibleValue(text="Adenocarcinoma, diffuse type") )
        setattr(cls, "Periosteal sarcoma, NOS",
                PermissibleValue(text="Periosteal sarcoma, NOS") )
        setattr(cls, "Lymphosarcoma, diffuse",
                PermissibleValue(text="Lymphosarcoma, diffuse") )
        setattr(cls, "Hodgkin disease, lymphocytic-histiocytic predominance",
                PermissibleValue(text="Hodgkin disease, lymphocytic-histiocytic predominance") )
        setattr(cls, "Invasive micropapillary carcinoma",
                PermissibleValue(text="Invasive micropapillary carcinoma") )
        setattr(cls, "Sarcomatoid mesothelioma",
                PermissibleValue(text="Sarcomatoid mesothelioma",
                                 description="Sarcomatoid Mesothelioma") )
        setattr(cls, "Burkitt cell leukemia",
                PermissibleValue(text="Burkitt cell leukemia") )
        setattr(cls, "Aggressive fibromatosis",
                PermissibleValue(text="Aggressive fibromatosis") )
        setattr(cls, "Metaplastic meningioma",
                PermissibleValue(text="Metaplastic meningioma") )
        setattr(cls, "Poorly cohesive carcinoma",
                PermissibleValue(text="Poorly cohesive carcinoma") )
        setattr(cls, "Adrenal cortical adenoma, NOS",
                PermissibleValue(text="Adrenal cortical adenoma, NOS") )
        setattr(cls, "Multiple myeloma",
                PermissibleValue(text="Multiple myeloma") )
        setattr(cls, "Pituitary carcinoma, NOS",
                PermissibleValue(text="Pituitary carcinoma, NOS") )
        setattr(cls, "Malignant lymphoma, centroblasticcentrocytic, NOS",
                PermissibleValue(text="Malignant lymphoma, centroblasticcentrocytic, NOS") )
        setattr(cls, "Neuroma, NOS",
                PermissibleValue(text="Neuroma, NOS") )
        setattr(cls, "Somatostatinoma, malignant",
                PermissibleValue(text="Somatostatinoma, malignant") )
        setattr(cls, "Papillary cystic tumor",
                PermissibleValue(text="Papillary cystic tumor") )
        setattr(cls, "Secretory carcinoma of breast",
                PermissibleValue(text="Secretory carcinoma of breast") )
        setattr(cls, "Angiocentric immunoproliferative lesion",
                PermissibleValue(text="Angiocentric immunoproliferative lesion") )
        setattr(cls, "Sex cord-gonadal stromal tumor, mixed forms",
                PermissibleValue(text="Sex cord-gonadal stromal tumor, mixed forms") )
        setattr(cls, "Chondroid lipoma",
                PermissibleValue(text="Chondroid lipoma") )
        setattr(cls, "Hodgkin paragranuloma, NOS",
                PermissibleValue(text="Hodgkin paragranuloma, NOS") )
        setattr(cls, "Combined large cell neuroendocrine carcinoma",
                PermissibleValue(text="Combined large cell neuroendocrine carcinoma") )
        setattr(cls, "EC cell carcinoid",
                PermissibleValue(text="EC cell carcinoid") )
        setattr(cls, "Nested urothelial carcinoma",
                PermissibleValue(text="Nested urothelial carcinoma") )
        setattr(cls, "Hypernephroid tumor",
                PermissibleValue(text="Hypernephroid tumor") )
        setattr(cls, "Genital rhabdomyoma",
                PermissibleValue(text="Genital rhabdomyoma") )
        setattr(cls, "Cylindrical cell papilloma",
                PermissibleValue(text="Cylindrical cell papilloma") )
        setattr(cls, "Epithelioid glioblastoma",
                PermissibleValue(text="Epithelioid glioblastoma") )
        setattr(cls, "Transitional cell carcinoma",
                PermissibleValue(text="Transitional cell carcinoma",
                                 description="Ovarian Transitional Cell Carcinoma") )
        setattr(cls, "Pleomorphic lobular carcinoma",
                PermissibleValue(text="Pleomorphic lobular carcinoma") )
        setattr(cls, "Lobular adenocarcinoma",
                PermissibleValue(text="Lobular adenocarcinoma") )
        setattr(cls, "Nephrogenic adenofibroma",
                PermissibleValue(text="Nephrogenic adenofibroma") )
        setattr(cls, "Histiocyte-rich large B-cell lymphoma",
                PermissibleValue(text="Histiocyte-rich large B-cell lymphoma") )
        setattr(cls, "Glioma, malignant",
                PermissibleValue(text="Glioma, malignant") )
        setattr(cls, "Villous adenocarcinoma",
                PermissibleValue(text="Villous adenocarcinoma") )
        setattr(cls, "Intracystic papillary adenocarcinoma",
                PermissibleValue(text="Intracystic papillary adenocarcinoma") )
        setattr(cls, "Encapsulated papillary carcinoma with invasion",
                PermissibleValue(text="Encapsulated papillary carcinoma with invasion") )
        setattr(cls, "Juvenile histiocytoma",
                PermissibleValue(text="Juvenile histiocytoma") )
        setattr(cls, "Mesodermal mixed tumor",
                PermissibleValue(text="Mesodermal mixed tumor") )
        setattr(cls, "Ameloblastic odontosarcoma",
                PermissibleValue(text="Ameloblastic odontosarcoma") )
        setattr(cls, "Glandular papilloma",
                PermissibleValue(text="Glandular papilloma") )
        setattr(cls, "Capillary lymphangioma",
                PermissibleValue(text="Capillary lymphangioma") )
        setattr(cls, "Pick tubular adenoma",
                PermissibleValue(text="Pick tubular adenoma") )
        setattr(cls, "Tubular carcinoma",
                PermissibleValue(text="Tubular carcinoma") )
        setattr(cls, "Dedifferentiated chordoma",
                PermissibleValue(text="Dedifferentiated chordoma") )
        setattr(cls, "FAB L2",
                PermissibleValue(text="FAB L2") )
        setattr(cls, "Tumor, metastatic",
                PermissibleValue(text="Tumor, metastatic") )
        setattr(cls, "DCIS, comedo type",
                PermissibleValue(text="DCIS, comedo type") )
        setattr(cls, "Extra-abdominal desmoid",
                PermissibleValue(text="Extra-abdominal desmoid") )
        setattr(cls, "Interdigitating cell sarcoma",
                PermissibleValue(text="Interdigitating cell sarcoma") )
        setattr(cls, "Cortical T ALL",
                PermissibleValue(text="Cortical T ALL") )
        setattr(cls, "Congenital fibrosarcoma",
                PermissibleValue(text="Congenital fibrosarcoma") )
        setattr(cls, "Spindle cell rhabdomyosarcoma",
                PermissibleValue(text="Spindle cell rhabdomyosarcoma") )
        setattr(cls, "Intraductal papillary adenocarcinoma with invasion",
                PermissibleValue(text="Intraductal papillary adenocarcinoma with invasion") )
        setattr(cls, "Strumal carcinoid",
                PermissibleValue(text="Strumal carcinoid") )
        setattr(cls, "Papillomatosis, glandular",
                PermissibleValue(text="Papillomatosis, glandular") )
        setattr(cls, "Oncocytic adenocarcinoma",
                PermissibleValue(text="Oncocytic adenocarcinoma") )
        setattr(cls, "Racemose hemangioma",
                PermissibleValue(text="Racemose hemangioma") )
        setattr(cls, "Osteoma, NOS",
                PermissibleValue(text="Osteoma, NOS") )
        setattr(cls, "Clear cell tumor, NOS",
                PermissibleValue(text="Clear cell tumor, NOS") )
        setattr(cls, "Prostatic intraepithelial neoplasia, grade III",
                PermissibleValue(text="Prostatic intraepithelial neoplasia, grade III") )
        setattr(cls, "Clear cell cystadenofibroma",
                PermissibleValue(text="Clear cell cystadenofibroma") )
        setattr(cls, "Thymoma, type B2, NOS",
                PermissibleValue(text="Thymoma, type B2, NOS") )
        setattr(cls, "Basal cell carcinoma, micronodular",
                PermissibleValue(text="Basal cell carcinoma, micronodular") )
        setattr(cls, "Differentiated penile intraepithelial neoplasia",
                PermissibleValue(text="Differentiated penile intraepithelial neoplasia") )
        setattr(cls, "Ependymoma, anaplastic",
                PermissibleValue(text="Ependymoma, anaplastic") )
        setattr(cls, "Follicular lymphoma, grade 3",
                PermissibleValue(text="Follicular lymphoma, grade 3") )
        setattr(cls, "Infiltrating angiolipoma",
                PermissibleValue(text="Infiltrating angiolipoma") )
        setattr(cls, "Arteriovenous hemangioma",
                PermissibleValue(text="Arteriovenous hemangioma") )
        setattr(cls, "Infiltrating duct adenocarcinoma",
                PermissibleValue(text="Infiltrating duct adenocarcinoma") )
        setattr(cls, "Infantile hemangioma",
                PermissibleValue(text="Infantile hemangioma") )
        setattr(cls, "Papillary mucinous tumor of low malignant potential",
                PermissibleValue(text="Papillary mucinous tumor of low malignant potential") )
        setattr(cls, "Pericanalicular fibroadenoma",
                PermissibleValue(text="Pericanalicular fibroadenoma") )
        setattr(cls, "Chronic lymphocytic leukemia",
                PermissibleValue(text="Chronic lymphocytic leukemia") )
        setattr(cls, "Thymoma, lymphocyte-rich, malignant",
                PermissibleValue(text="Thymoma, lymphocyte-rich, malignant") )
        setattr(cls, "Mucinous tumor, NOS, of low malignant potential",
                PermissibleValue(text="Mucinous tumor, NOS, of low malignant potential") )
        setattr(cls, "Nephroma, NOS",
                PermissibleValue(text="Nephroma, NOS") )
        setattr(cls, "Cystic astrocytoma",
                PermissibleValue(text="Cystic astrocytoma") )
        setattr(cls, "Malignant lymphoma, undifferentiated, Burkitt type",
                PermissibleValue(text="Malignant lymphoma, undifferentiated, Burkitt type") )
        setattr(cls, "Carotid body paraganglioma",
                PermissibleValue(text="Carotid body paraganglioma") )
        setattr(cls, "Pheochromocytoma, malignant",
                PermissibleValue(text="Pheochromocytoma, malignant") )
        setattr(cls, "B lymphoblastic leukemia/lymphoma with t(12;21)(p13;q22); TEL-AML1 (ETV6-RUNX1)",
                PermissibleValue(text="B lymphoblastic leukemia/lymphoma with t(12;21)(p13;q22); TEL-AML1 (ETV6-RUNX1)") )
        setattr(cls, "Granulosa cell tumor, sarcomatoid",
                PermissibleValue(text="Granulosa cell tumor, sarcomatoid") )
        setattr(cls, "Transitional meningioma",
                PermissibleValue(text="Transitional meningioma") )
        setattr(cls, "Systemic tissue mast cell disease",
                PermissibleValue(text="Systemic tissue mast cell disease") )
        setattr(cls, "Complex odontoma",
                PermissibleValue(text="Complex odontoma") )
        setattr(cls, "Adenocarcinoma with mixed subtypes",
                PermissibleValue(text="Adenocarcinoma with mixed subtypes") )
        setattr(cls, "Complete hydatidiform mole",
                PermissibleValue(text="Complete hydatidiform mole") )
        setattr(cls, "Malignant lymphoma, noncleaved cell, follicular, NOS",
                PermissibleValue(text="Malignant lymphoma, noncleaved cell, follicular, NOS") )
        setattr(cls, "Chronic lymphoproliferative disorder of NK cells",
                PermissibleValue(text="Chronic lymphoproliferative disorder of NK cells") )
        setattr(cls, "Chondrosarcoma grade 2/3",
                PermissibleValue(text="Chondrosarcoma grade 2/3") )
        setattr(cls, "Synovioma, NOS",
                PermissibleValue(text="Synovioma, NOS") )
        setattr(cls, "Cribriform carcinoma, NOS",
                PermissibleValue(text="Cribriform carcinoma, NOS") )
        setattr(cls, "Acute myeloid leukaemia, t(8;21)(q22;q22)",
                PermissibleValue(text="Acute myeloid leukaemia, t(8;21)(q22;q22)") )
        setattr(cls, "Intraductal papillary neoplasm with high grade dysplasia",
                PermissibleValue(text="Intraductal papillary neoplasm with high grade dysplasia") )
        setattr(cls, "Adrenal cortical tumor, malignant",
                PermissibleValue(text="Adrenal cortical tumor, malignant") )
        setattr(cls, "Adenocarcinoma with squamous metaplasia",
                PermissibleValue(text="Adenocarcinoma with squamous metaplasia") )
        setattr(cls, "Trichilemmal carcinoma",
                PermissibleValue(text="Trichilemmal carcinoma") )
        setattr(cls, "Papillary glioneuronal tumor",
                PermissibleValue(text="Papillary glioneuronal tumor") )
        setattr(cls, "Adamantinoma, NOS",
                PermissibleValue(text="Adamantinoma, NOS") )
        setattr(cls, "Microcystic adenoma",
                PermissibleValue(text="Microcystic adenoma") )
        setattr(cls, "Pigmented basal cell carcinoma",
                PermissibleValue(text="Pigmented basal cell carcinoma") )
        setattr(cls, "Embryonal carcinoma, polyembryonal type",
                PermissibleValue(text="Embryonal carcinoma, polyembryonal type") )
        setattr(cls, "Polymorphous low grade adenocarcinoma",
                PermissibleValue(text="Polymorphous low grade adenocarcinoma") )
        setattr(cls, "Adenocarcinoma, NOS",
                PermissibleValue(text="Adenocarcinoma, NOS") )
        setattr(cls, "Acidophil adenoma",
                PermissibleValue(text="Acidophil adenoma") )
        setattr(cls, "Stromal sarcoma, NOS",
                PermissibleValue(text="Stromal sarcoma, NOS") )
        setattr(cls, "Pre-B ALL",
                PermissibleValue(text="Pre-B ALL") )
        setattr(cls, "FAB M5 (includes all variants)",
                PermissibleValue(text="FAB M5 (includes all variants)") )
        setattr(cls, "Steroid cell tumor, NOS",
                PermissibleValue(text="Steroid cell tumor, NOS") )
        setattr(cls, "Regressing nevus",
                PermissibleValue(text="Regressing nevus") )
        setattr(cls, "Follicular lymphoma, grade 1",
                PermissibleValue(text="Follicular lymphoma, grade 1") )
        setattr(cls, "Giant cell and spindle cell carcinoma",
                PermissibleValue(text="Giant cell and spindle cell carcinoma") )
        setattr(cls, "Clear cell adenocarcinoma, mesonephroid",
                PermissibleValue(text="Clear cell adenocarcinoma, mesonephroid") )
        setattr(cls, "Sex cord tumor with annular tubules",
                PermissibleValue(text="Sex cord tumor with annular tubules") )
        setattr(cls, "Odontogenic fibroma, NOS",
                PermissibleValue(text="Odontogenic fibroma, NOS") )
        setattr(cls, "Black adenoma",
                PermissibleValue(text="Black adenoma") )
        setattr(cls, "Sezary disease",
                PermissibleValue(text="Sezary disease") )
        setattr(cls, "Serous adenofibroma of borderline malignancy",
                PermissibleValue(text="Serous adenofibroma of borderline malignancy") )
        setattr(cls, "Leukemia, NOS",
                PermissibleValue(text="Leukemia, NOS") )
        setattr(cls, "Plexiform neuroma",
                PermissibleValue(text="Plexiform neuroma") )
        setattr(cls, "Papillary squamous cell carcinoma, non-invasive",
                PermissibleValue(text="Papillary squamous cell carcinoma, non-invasive") )
        setattr(cls, "Clear cell cystadenoma",
                PermissibleValue(text="Clear cell cystadenoma") )
        setattr(cls, "Malignant lymphoma, small B lymphocytic, NOS",
                PermissibleValue(text="Malignant lymphoma, small B lymphocytic, NOS") )
        setattr(cls, "Anal intraepithelial neoplasia, grade III",
                PermissibleValue(text="Anal intraepithelial neoplasia, grade III") )
        setattr(cls, "Lepidic predominant adenocarcinoma",
                PermissibleValue(text="Lepidic predominant adenocarcinoma",
                                 description="Lepidic Predominant Adenocarcinoma") )
        setattr(cls, "Malignant midline reticulosis",
                PermissibleValue(text="Malignant midline reticulosis") )
        setattr(cls, "Atypical proliferative mucinous tumor",
                PermissibleValue(text="Atypical proliferative mucinous tumor") )
        setattr(cls, "Mesenchymal tumor, malignant",
                PermissibleValue(text="Mesenchymal tumor, malignant") )
        setattr(cls, "Follicular lymphoma, small cleaved cell",
                PermissibleValue(text="Follicular lymphoma, small cleaved cell") )
        setattr(cls, "Aorticopulmonary paraganglioma",
                PermissibleValue(text="Aorticopulmonary paraganglioma") )
        setattr(cls, "Sessile serrated adenoma",
                PermissibleValue(text="Sessile serrated adenoma") )
        setattr(cls, "Aggressive angiomyxoma",
                PermissibleValue(text="Aggressive angiomyxoma") )
        setattr(cls, "Micropapillary adenocarcinoma",
                PermissibleValue(text="Micropapillary adenocarcinoma") )
        setattr(cls, "Carcinosarcoma, embryonal",
                PermissibleValue(text="Carcinosarcoma, embryonal") )
        setattr(cls, "Acute myeloid leukemia with mutated CEBPA",
                PermissibleValue(text="Acute myeloid leukemia with mutated CEBPA") )
        setattr(cls, "Primary effusion lymphoma",
                PermissibleValue(text="Primary effusion lymphoma") )
        setattr(cls, "Myelosclerosis with myeloid metaplasia",
                PermissibleValue(text="Myelosclerosis with myeloid metaplasia") )
        setattr(cls, "Splenic B-cell lymphoma/leukemia, unclassifiable",
                PermissibleValue(text="Splenic B-cell lymphoma/leukemia, unclassifiable") )
        setattr(cls, "Juvenile carcinoma of breast",
                PermissibleValue(text="Juvenile carcinoma of breast") )
        setattr(cls, "Aleukemic leukemia, NOS",
                PermissibleValue(text="Aleukemic leukemia, NOS") )
        setattr(cls, "Choroid plexus papilloma, malignant",
                PermissibleValue(text="Choroid plexus papilloma, malignant") )
        setattr(cls, "Lobular carcinoma, noninfiltrating",
                PermissibleValue(text="Lobular carcinoma, noninfiltrating") )
        setattr(cls, "Papillary squamous cell carcinoma",
                PermissibleValue(text="Papillary squamous cell carcinoma") )
        setattr(cls, "Malignant lymphoma, mixed lymphocytic-histiocytic, diffuse",
                PermissibleValue(text="Malignant lymphoma, mixed lymphocytic-histiocytic, diffuse") )
        setattr(cls, "Islet cell adenoma",
                PermissibleValue(text="Islet cell adenoma") )
        setattr(cls, "Schneiderian papilloma, NOS",
                PermissibleValue(text="Schneiderian papilloma, NOS") )
        setattr(cls, "Malignant lymphoma, cleaved cell, NOS",
                PermissibleValue(text="Malignant lymphoma, cleaved cell, NOS") )
        setattr(cls, "Hepatocellular carcinoma, spindle cell variant",
                PermissibleValue(text="Hepatocellular carcinoma, spindle cell variant") )
        setattr(cls, "Teratoblastoma, malignant",
                PermissibleValue(text="Teratoblastoma, malignant") )
        setattr(cls, "Intraductal papillomatosis, NOS",
                PermissibleValue(text="Intraductal papillomatosis, NOS") )
        setattr(cls, "Phosphaturic mesenchymal tumor, malignant",
                PermissibleValue(text="Phosphaturic mesenchymal tumor, malignant") )
        setattr(cls, "Squamous cell carcinoma in situ, NOS",
                PermissibleValue(text="Squamous cell carcinoma in situ, NOS") )
        setattr(cls, "Anal intraepithelial neoplasia, low grade",
                PermissibleValue(text="Anal intraepithelial neoplasia, low grade") )
        setattr(cls, "Urticaria pigmentosa",
                PermissibleValue(text="Urticaria pigmentosa") )
        setattr(cls, "Chronic eosinophilic leukemia, NOS",
                PermissibleValue(text="Chronic eosinophilic leukemia, NOS") )
        setattr(cls, "Mucinous cystic neoplasm with intermediate-grade dysplasia",
                PermissibleValue(text="Mucinous cystic neoplasm with intermediate-grade dysplasia") )
        setattr(cls, "Diffuse meningiomatosis",
                PermissibleValue(text="Diffuse meningiomatosis") )
        setattr(cls, "Hemangioma simplex",
                PermissibleValue(text="Hemangioma simplex") )
        setattr(cls, "Cutaneous lymphoma, NOS",
                PermissibleValue(text="Cutaneous lymphoma, NOS") )
        setattr(cls, "Dysplastic nevus",
                PermissibleValue(text="Dysplastic nevus") )
        setattr(cls, "Plasmacytic leukemia",
                PermissibleValue(text="Plasmacytic leukemia") )
        setattr(cls, "CIN III with severe dysplasia",
                PermissibleValue(text="CIN III with severe dysplasia") )
        setattr(cls, "Intraductal carcinoma, NOS",
                PermissibleValue(text="Intraductal carcinoma, NOS") )
        setattr(cls, "Esophageal glandular dysplasia (intraepithelial neoplasia), high grade",
                PermissibleValue(text="Esophageal glandular dysplasia (intraepithelial neoplasia), high grade") )
        setattr(cls, "Giant fibroadenoma",
                PermissibleValue(text="Giant fibroadenoma") )
        setattr(cls, "Papillary adenofibroma",
                PermissibleValue(text="Papillary adenofibroma") )
        setattr(cls, "Anaplastic oligodendroglioma, IDH-mutant and 1p/19q-codeleted",
                PermissibleValue(text="Anaplastic oligodendroglioma, IDH-mutant and 1p/19q-codeleted") )
        setattr(cls, "Ameloblastoma, NOS",
                PermissibleValue(text="Ameloblastoma, NOS") )
        setattr(cls, "Round cell liposarcoma",
                PermissibleValue(text="Round cell liposarcoma") )
        setattr(cls, "Typical carcinoid",
                PermissibleValue(text="Typical carcinoid") )
        setattr(cls, "Acquired tufted hemangioma",
                PermissibleValue(text="Acquired tufted hemangioma") )
        setattr(cls, "Plexiform fibromyxoma",
                PermissibleValue(text="Plexiform fibromyxoma") )
        setattr(cls, "Juxtacortical osteosarcoma",
                PermissibleValue(text="Juxtacortical osteosarcoma") )
        setattr(cls, "Lymphomatoid papulosis",
                PermissibleValue(text="Lymphomatoid papulosis") )
        setattr(cls, "Spermatocytic seminoma",
                PermissibleValue(text="Spermatocytic seminoma") )
        setattr(cls, "Hodgkin paragranuloma, nodular",
                PermissibleValue(text="Hodgkin paragranuloma, nodular") )
        setattr(cls, "Malignant lymphoma, undifferentiated cell, non-Burkitt",
                PermissibleValue(text="Malignant lymphoma, undifferentiated cell, non-Burkitt") )
        setattr(cls, "Primary cutaneous gamma-delta T-cell lymphoma",
                PermissibleValue(text="Primary cutaneous gamma-delta T-cell lymphoma") )
        setattr(cls, "Mixed acidophil-basophil carcinoma",
                PermissibleValue(text="Mixed acidophil-basophil carcinoma") )
        setattr(cls, "Retroperitoneal fibromatosis",
                PermissibleValue(text="Retroperitoneal fibromatosis") )
        setattr(cls, "Unclassified tumor, benign",
                PermissibleValue(text="Unclassified tumor, benign") )
        setattr(cls, "Multicystic mesothelioma, benign",
                PermissibleValue(text="Multicystic mesothelioma, benign") )
        setattr(cls, "Spindle cell sarcoma",
                PermissibleValue(text="Spindle cell sarcoma") )
        setattr(cls, "Juvenile angiofibroma",
                PermissibleValue(text="Juvenile angiofibroma") )
        setattr(cls, "Malignant lymphoma, follicle center, NOS",
                PermissibleValue(text="Malignant lymphoma, follicle center, NOS") )
        setattr(cls, "Chief cell adenoma",
                PermissibleValue(text="Chief cell adenoma") )
        setattr(cls, "Fibroblastic osteosarcoma",
                PermissibleValue(text="Fibroblastic osteosarcoma") )
        setattr(cls, "Intraductal papillary neoplasm with low grade intraepithelial neoplasia",
                PermissibleValue(text="Intraductal papillary neoplasm with low grade intraepithelial neoplasia") )
        setattr(cls, "Acute myelomonocytic leukemia with abnormal eosinophils",
                PermissibleValue(text="Acute myelomonocytic leukemia with abnormal eosinophils") )
        setattr(cls, "Mesenchymoma, benign",
                PermissibleValue(text="Mesenchymoma, benign") )
        setattr(cls, "Papillary pseudomucinous cystadenoma, NOS",
                PermissibleValue(text="Papillary pseudomucinous cystadenoma, NOS") )
        setattr(cls, "Desmoplastic nodular medulloblastoma",
                PermissibleValue(text="Desmoplastic nodular medulloblastoma") )
        setattr(cls, "Choriocarcinoma combined with teratorna",
                PermissibleValue(text="Choriocarcinoma combined with teratorna") )
        setattr(cls, "Subacute lymphoid leukemia",
                PermissibleValue(text="Subacute lymphoid leukemia") )
        setattr(cls, "Intraductal papillary mucinous neoplasm (IPMN) with an associated invasive carcinoma",
                PermissibleValue(text="Intraductal papillary mucinous neoplasm (IPMN) with an associated invasive carcinoma") )
        setattr(cls, "Nonencapsulated sclerosing carcinoma",
                PermissibleValue(text="Nonencapsulated sclerosing carcinoma") )
        setattr(cls, "Bile duct adenocarcinoma",
                PermissibleValue(text="Bile duct adenocarcinoma") )
        setattr(cls, "Epithelioma adenoides cysticum",
                PermissibleValue(text="Epithelioma adenoides cysticum") )
        setattr(cls, "Papillary carcinoma in situ",
                PermissibleValue(text="Papillary carcinoma in situ") )
        setattr(cls, "Fibroblastic meningioma",
                PermissibleValue(text="Fibroblastic meningioma") )
        setattr(cls, "Mucinous cystic tumor with low grade dysplasia",
                PermissibleValue(text="Mucinous cystic tumor with low grade dysplasia") )
        setattr(cls, "Squamous cell carcinoma with horn formation",
                PermissibleValue(text="Squamous cell carcinoma with horn formation") )
        setattr(cls, "Sex cord tumor, NOS",
                PermissibleValue(text="Sex cord tumor, NOS") )
        setattr(cls, "Odontogenic tumor, malignant",
                PermissibleValue(text="Odontogenic tumor, malignant") )
        setattr(cls, "Krukenberg tumor",
                PermissibleValue(text="Krukenberg tumor") )
        setattr(cls, "Piloid astrocytoma",
                PermissibleValue(text="Piloid astrocytoma") )
        setattr(cls, "Epithelioid hemangioendothelioma, NOS",
                PermissibleValue(text="Epithelioid hemangioendothelioma, NOS") )
        setattr(cls, "Mixed islet cell and exocrine adenocarcinoma",
                PermissibleValue(text="Mixed islet cell and exocrine adenocarcinoma") )
        setattr(cls, "Neoplasm, uncertain whether benign or malignant",
                PermissibleValue(text="Neoplasm, uncertain whether benign or malignant") )
        setattr(cls, "Myofibroblastic tumor, NOS",
                PermissibleValue(text="Myofibroblastic tumor, NOS") )
        setattr(cls, "Brenner tumor, NOS",
                PermissibleValue(text="Brenner tumor, NOS") )
        setattr(cls, "Angioblastic meningioma",
                PermissibleValue(text="Angioblastic meningioma") )
        setattr(cls, "Monoclonal gammopathy of undetermined significance",
                PermissibleValue(text="Monoclonal gammopathy of undetermined significance") )
        setattr(cls, "Polycythemia rubra vera",
                PermissibleValue(text="Polycythemia rubra vera") )
        setattr(cls, "Pigmented schwannoma",
                PermissibleValue(text="Pigmented schwannoma") )
        setattr(cls, "Follicular adenoma, oxyphilic cell",
                PermissibleValue(text="Follicular adenoma, oxyphilic cell") )
        setattr(cls, "Fibrous histiocytoma of tendon sheath",
                PermissibleValue(text="Fibrous histiocytoma of tendon sheath") )
        setattr(cls, "T-cell rich/histiocyte-rich large B-cell lymphoma",
                PermissibleValue(text="T-cell rich/histiocyte-rich large B-cell lymphoma") )
        setattr(cls, "Subareolar duct papillomatosis",
                PermissibleValue(text="Subareolar duct papillomatosis") )
        setattr(cls, "Large cell (Ki-1+) lymphoma",
                PermissibleValue(text="Large cell (Ki-1+) lymphoma") )
        setattr(cls, "Tumor, secondary",
                PermissibleValue(text="Tumor, secondary") )
        setattr(cls, "Pinkus tumor",
                PermissibleValue(text="Pinkus tumor") )
        setattr(cls, "Tubulo-papillary adenoma",
                PermissibleValue(text="Tubulo-papillary adenoma") )
        setattr(cls, "Ameloblastic fibro-odontosarcoma",
                PermissibleValue(text="Ameloblastic fibro-odontosarcoma") )
        setattr(cls, "Stromal tumor, benign",
                PermissibleValue(text="Stromal tumor, benign") )
        setattr(cls, "Endocrine adenomatosis",
                PermissibleValue(text="Endocrine adenomatosis") )
        setattr(cls, "Stem cell leukemia",
                PermissibleValue(text="Stem cell leukemia") )
        setattr(cls, "Brenner tumor, malignant",
                PermissibleValue(text="Brenner tumor, malignant") )
        setattr(cls, "Myelodysplastic syndrome with isolated del (5q)",
                PermissibleValue(text="Myelodysplastic syndrome with isolated del (5q)") )
        setattr(cls, "Embryonal sarcoma",
                PermissibleValue(text="Embryonal sarcoma") )
        setattr(cls, "Sessile serrated polyp",
                PermissibleValue(text="Sessile serrated polyp") )
        setattr(cls, "Tubular adenoma, NOS",
                PermissibleValue(text="Tubular adenoma, NOS") )
        setattr(cls, "Fibroxanthoma, NOS",
                PermissibleValue(text="Fibroxanthoma, NOS") )
        setattr(cls, "Therapy-related acute myeloid leukemia, epipodophyllotoxin-related",
                PermissibleValue(text="Therapy-related acute myeloid leukemia, epipodophyllotoxin-related") )
        setattr(cls, "Acute monoblastic and monocytic leukemia",
                PermissibleValue(text="Acute monoblastic and monocytic leukemia") )
        setattr(cls, "Neoplasm, malignant, uncertain whether primary or metastatic",
                PermissibleValue(text="Neoplasm, malignant, uncertain whether primary or metastatic") )
        setattr(cls, "Androblastoma, benign",
                PermissibleValue(text="Androblastoma, benign") )
        setattr(cls, "Intracystic papillary neoplasm with low grade intraepithelial neoplasia",
                PermissibleValue(text="Intracystic papillary neoplasm with low grade intraepithelial neoplasia") )
        setattr(cls, "Central neurocytoma",
                PermissibleValue(text="Central neurocytoma") )
        setattr(cls, "Wolffian duct adenoma",
                PermissibleValue(text="Wolffian duct adenoma") )
        setattr(cls, "Malignant lymphoma, large B-cell, diffuse, centroblastic, NOS",
                PermissibleValue(text="Malignant lymphoma, large B-cell, diffuse, centroblastic, NOS") )
        setattr(cls, "Invasive lobular carcinoma, alveolar type",
                PermissibleValue(text="Invasive lobular carcinoma, alveolar type") )
        setattr(cls, "Periosteal chondroma",
                PermissibleValue(text="Periosteal chondroma") )
        setattr(cls, "Malignant serous cystadenofibroma",
                PermissibleValue(text="Malignant serous cystadenofibroma") )
        setattr(cls, "Peripheral T-cell lymphoma, AILD (Angioimmunoblastic Lymphadenopathy with Dysproteinemia)",
                PermissibleValue(text="Peripheral T-cell lymphoma, AILD (Angioimmunoblastic Lymphadenopathy with Dysproteinemia)") )
        setattr(cls, "Angiolipoma, NOS",
                PermissibleValue(text="Angiolipoma, NOS") )
        setattr(cls, "Mesenchymoma, NOS",
                PermissibleValue(text="Mesenchymoma, NOS") )
        setattr(cls, "Intratubular malignant germ cells",
                PermissibleValue(text="Intratubular malignant germ cells") )
        setattr(cls, "Embryonal carcinoma, infantile",
                PermissibleValue(text="Embryonal carcinoma, infantile") )
        setattr(cls, "Benign cystic nephroma",
                PermissibleValue(text="Benign cystic nephroma") )
        setattr(cls, "Serous adenocarcinoma, NOS",
                PermissibleValue(text="Serous adenocarcinoma, NOS") )
        setattr(cls, "Sertoli-Leydig cell tumor, intermediate differentiation, with heterologous elements",
                PermissibleValue(text="Sertoli-Leydig cell tumor, intermediate differentiation, with heterologous elements") )
        setattr(cls, "Malignant lymphoma, large cell, cleaved, diffuse",
                PermissibleValue(text="Malignant lymphoma, large cell, cleaved, diffuse") )
        setattr(cls, "Mixed acinar-ductal carcinoma",
                PermissibleValue(text="Mixed acinar-ductal carcinoma",
                                 description="Mixed Acinar-Ductal Carcinoma of the Pancreas") )
        setattr(cls, "Cellular angiofibroma",
                PermissibleValue(text="Cellular angiofibroma") )
        setattr(cls, "Mucoid cell adenoma",
                PermissibleValue(text="Mucoid cell adenoma") )
        setattr(cls, "Vaginal intraepithelial neoplasia, grade III",
                PermissibleValue(text="Vaginal intraepithelial neoplasia, grade III") )
        setattr(cls, "Hydroa vacciniforme-like lymphoma",
                PermissibleValue(text="Hydroa vacciniforme-like lymphoma") )
        setattr(cls, "Pro-T ALL",
                PermissibleValue(text="Pro-T ALL") )
        setattr(cls, "Pseudomyxoma peritonei",
                PermissibleValue(text="Pseudomyxoma peritonei") )
        setattr(cls, "Dendritic cell sarcoma, NOS",
                PermissibleValue(text="Dendritic cell sarcoma, NOS") )
        setattr(cls, "Malignant lymphoma, small cleaved cell, follicular",
                PermissibleValue(text="Malignant lymphoma, small cleaved cell, follicular") )
        setattr(cls, "Spindle cell hemangioendothelioma",
                PermissibleValue(text="Spindle cell hemangioendothelioma") )
        setattr(cls, "Blastoma, NOS",
                PermissibleValue(text="Blastoma, NOS") )
        setattr(cls, "FAB M4Eo",
                PermissibleValue(text="FAB M4Eo") )
        setattr(cls, "Transitional papilloma, inverted, NOS",
                PermissibleValue(text="Transitional papilloma, inverted, NOS") )
        setattr(cls, "Lymphomatoid granulomatosis",
                PermissibleValue(text="Lymphomatoid granulomatosis") )
        setattr(cls, "Undifferentiated round cell sarcoma",
                PermissibleValue(text="Undifferentiated round cell sarcoma") )
        setattr(cls, "Chronic granulocytic leukemia, NOS",
                PermissibleValue(text="Chronic granulocytic leukemia, NOS") )
        setattr(cls, "Endocrine tumor, functioning, NOS",
                PermissibleValue(text="Endocrine tumor, functioning, NOS") )
        setattr(cls, "Gamma heavy chain disease",
                PermissibleValue(text="Gamma heavy chain disease") )
        setattr(cls, "Malignant lymphoma, immunoblastic, NOS",
                PermissibleValue(text="Malignant lymphoma, immunoblastic, NOS") )
        setattr(cls, "Malignant perivascular epithelial cell tumor",
                PermissibleValue(text="Malignant perivascular epithelial cell tumor") )
        setattr(cls, "Clear cell cystic tumor of borderline malignancy",
                PermissibleValue(text="Clear cell cystic tumor of borderline malignancy") )
        setattr(cls, "Pleomorphic carcinoma",
                PermissibleValue(text="Pleomorphic carcinoma") )
        setattr(cls, "Alveolar soft part sarcoma",
                PermissibleValue(text="Alveolar soft part sarcoma") )
        setattr(cls, "Sex cord-gonadal stromal tumor, incompletely differentiated",
                PermissibleValue(text="Sex cord-gonadal stromal tumor, incompletely differentiated") )
        setattr(cls, "Aleukemic myeloid leukemia",
                PermissibleValue(text="Aleukemic myeloid leukemia") )
        setattr(cls, "Acute myeloid leukemia (megakaryoblastic) with t(1;22)(p13;q13); RBM15-MKL1",
                PermissibleValue(text="Acute myeloid leukemia (megakaryoblastic) with t(1;22)(p13;q13); RBM15-MKL1") )
        setattr(cls, "Aggressive osteoblastoma",
                PermissibleValue(text="Aggressive osteoblastoma") )
        setattr(cls, "Mantle zone lymphoma",
                PermissibleValue(text="Mantle zone lymphoma") )
        setattr(cls, "Adrenal cortical adenoma, clear cell",
                PermissibleValue(text="Adrenal cortical adenoma, clear cell") )
        setattr(cls, "Mucinous carcinoma, gastric type",
                PermissibleValue(text="Mucinous carcinoma, gastric type") )
        setattr(cls, "Vipoma, NOS",
                PermissibleValue(text="Vipoma, NOS") )
        setattr(cls, "Endometrioid adenocarcinoma, NOS",
                PermissibleValue(text="Endometrioid adenocarcinoma, NOS") )
        setattr(cls, "Granulosa cell tumor, malignant",
                PermissibleValue(text="Granulosa cell tumor, malignant") )
        setattr(cls, "Clear cell carcinoma",
                PermissibleValue(text="Clear cell carcinoma") )
        setattr(cls, "Hand-Schuller-Christian disease",
                PermissibleValue(text="Hand-Schuller-Christian disease") )
        setattr(cls, "Sclerosing liposarcoma",
                PermissibleValue(text="Sclerosing liposarcoma") )
        setattr(cls, "Serous tumor, NOS, of low malignant potential",
                PermissibleValue(text="Serous tumor, NOS, of low malignant potential") )
        setattr(cls, "Mature T-cell lymphoma, NOS",
                PermissibleValue(text="Mature T-cell lymphoma, NOS") )
        setattr(cls, "Chondroma, NOS",
                PermissibleValue(text="Chondroma, NOS") )
        setattr(cls, "Balloon cell nevus",
                PermissibleValue(text="Balloon cell nevus") )
        setattr(cls, "Squamous cell carcinoma, HPV-positive",
                PermissibleValue(text="Squamous cell carcinoma, HPV-positive") )
        setattr(cls, "Diffuse astrocytoma, low grade",
                PermissibleValue(text="Diffuse astrocytoma, low grade") )
        setattr(cls, "Synovial sarcoma, biphasic",
                PermissibleValue(text="Synovial sarcoma, biphasic") )
        setattr(cls, "Mucinous cystic neoplasm with low-grade intraepithelial neoplasia",
                PermissibleValue(text="Mucinous cystic neoplasm with low-grade intraepithelial neoplasia") )
        setattr(cls, "Rhabdoid sarcoma",
                PermissibleValue(text="Rhabdoid sarcoma") )
        setattr(cls, "Squamous intraepithelial neoplasia, low grade",
                PermissibleValue(text="Squamous intraepithelial neoplasia, low grade") )
        setattr(cls, "Chordoma, NOS",
                PermissibleValue(text="Chordoma, NOS") )
        setattr(cls, "Mixed mesenchymal tumor",
                PermissibleValue(text="Mixed mesenchymal tumor") )
        setattr(cls, "Malignant melanoma in giant pigmented nevus",
                PermissibleValue(text="Malignant melanoma in giant pigmented nevus") )
        setattr(cls, "Invasive encapsulated follicular variant of papillary thyroid carcinoma (invasive EFVPTC)",
                PermissibleValue(text="Invasive encapsulated follicular variant of papillary thyroid carcinoma (invasive EFVPTC)") )
        setattr(cls, "Gonadal stromal tumor, NOS",
                PermissibleValue(text="Gonadal stromal tumor, NOS") )
        setattr(cls, "Fibrous mesothelioma, NOS",
                PermissibleValue(text="Fibrous mesothelioma, NOS") )
        setattr(cls, "Atypical choroid plexus papilloma",
                PermissibleValue(text="Atypical choroid plexus papilloma") )
        setattr(cls, "Insulinoma, NOS",
                PermissibleValue(text="Insulinoma, NOS") )
        setattr(cls, "T lymphoblastic leukemia/lymphoma",
                PermissibleValue(text="T lymphoblastic leukemia/lymphoma") )
        setattr(cls, "T/NK-cell lymphoma",
                PermissibleValue(text="T/NK-cell lymphoma") )
        setattr(cls, "Thymoma, type B1, NOS",
                PermissibleValue(text="Thymoma, type B1, NOS") )
        setattr(cls, "FAB L3",
                PermissibleValue(text="FAB L3") )
        setattr(cls, "Squamous cell carcinoma, sarcomatoid",
                PermissibleValue(text="Squamous cell carcinoma, sarcomatoid") )
        setattr(cls, "Cervical intraepithelial neoplasia, low grade",
                PermissibleValue(text="Cervical intraepithelial neoplasia, low grade") )
        setattr(cls, "Pancreatic endocrine tumor, NOS",
                PermissibleValue(text="Pancreatic endocrine tumor, NOS") )
        setattr(cls, "Anaplastic large B-cell lymphoma",
                PermissibleValue(text="Anaplastic large B-cell lymphoma") )
        setattr(cls, "CNS Embryonal tumor with rhabdoid features",
                PermissibleValue(text="CNS Embryonal tumor with rhabdoid features") )
        setattr(cls, "Cellular blue nevus",
                PermissibleValue(text="Cellular blue nevus") )
        setattr(cls, "Cin III, NOS",
                PermissibleValue(text="Cin III, NOS") )
        setattr(cls, "Eosinophilic granuloma",
                PermissibleValue(text="Eosinophilic granuloma") )
        setattr(cls, "Papillary adenocarcinoma, NOS",
                PermissibleValue(text="Papillary adenocarcinoma, NOS") )
        setattr(cls, "Intraductal tubulopapillary neoplasm",
                PermissibleValue(text="Intraductal tubulopapillary neoplasm") )
        setattr(cls, "Nonchromaffin paraganglioma, malignant",
                PermissibleValue(text="Nonchromaffin paraganglioma, malignant") )
        setattr(cls, "T-cell lymphoma, NOS",
                PermissibleValue(text="T-cell lymphoma, NOS") )
        setattr(cls, "Spindle epithelial tumor with thymus-like differentiation",
                PermissibleValue(text="Spindle epithelial tumor with thymus-like differentiation") )
        setattr(cls, "Medullary osteosarcoma",
                PermissibleValue(text="Medullary osteosarcoma") )
        setattr(cls, "Tenosynovial giant cell tumor",
                PermissibleValue(text="Tenosynovial giant cell tumor") )
        setattr(cls, "Periosteal osteosarcoma",
                PermissibleValue(text="Periosteal osteosarcoma") )
        setattr(cls, "Pancreatobiliary-type carcinoma",
                PermissibleValue(text="Pancreatobiliary-type carcinoma") )
        setattr(cls, "Atypical teratoid/rhabdoid tumor",
                PermissibleValue(text="Atypical teratoid/rhabdoid tumor") )
        setattr(cls, "Dedifferentiated liposarcoma",
                PermissibleValue(text="Dedifferentiated liposarcoma",
                                 description="Dedifferentiated Liposarcoma") )
        setattr(cls, "Pagetoid reticulosis",
                PermissibleValue(text="Pagetoid reticulosis") )
        setattr(cls, "Vulvar intraepithelial neoplasia, grade III",
                PermissibleValue(text="Vulvar intraepithelial neoplasia, grade III") )
        setattr(cls, "Pancreatic endocrine tumor, benign",
                PermissibleValue(text="Pancreatic endocrine tumor, benign") )
        setattr(cls, "Malignant cystic nephroma",
                PermissibleValue(text="Malignant cystic nephroma") )
        setattr(cls, "Cementoma, NOS",
                PermissibleValue(text="Cementoma, NOS") )
        setattr(cls, "Lymphoepithelioid lymphoma",
                PermissibleValue(text="Lymphoepithelioid lymphoma") )
        setattr(cls, "Systemic mastocytosis with associated hematological clonal non-mast cell disorder",
                PermissibleValue(text="Systemic mastocytosis with associated hematological clonal non-mast cell disorder") )
        setattr(cls, "Sertoli cell carcinoma",
                PermissibleValue(text="Sertoli cell carcinoma") )
        setattr(cls, "Nonchromaffin paraganglioma, NOS",
                PermissibleValue(text="Nonchromaffin paraganglioma, NOS") )
        setattr(cls, "Fibroblastic liposarcoma",
                PermissibleValue(text="Fibroblastic liposarcoma") )
        setattr(cls, "Dermatofibroma lenticulare",
                PermissibleValue(text="Dermatofibroma lenticulare") )
        setattr(cls, "Hodgkin disease, nodular sclerosis, NOS",
                PermissibleValue(text="Hodgkin disease, nodular sclerosis, NOS") )
        setattr(cls, "Bellini duct carcinoma",
                PermissibleValue(text="Bellini duct carcinoma") )
        setattr(cls, "Bronchial adenoma, carcinoid",
                PermissibleValue(text="Bronchial adenoma, carcinoid") )
        setattr(cls, "Hepatoid adenocarcinoma",
                PermissibleValue(text="Hepatoid adenocarcinoma",
                                 description="Hepatoid Adenocarcinoma") )
        setattr(cls, "Thymoma, predominantly cortical, malignant",
                PermissibleValue(text="Thymoma, predominantly cortical, malignant") )
        setattr(cls, "Langerhans cell histiocytosis, poly-ostotic",
                PermissibleValue(text="Langerhans cell histiocytosis, poly-ostotic") )
        setattr(cls, "Noninvasive pancreatobiliary papillary neoplasm with high grade intraepithelial neoplasia",
                PermissibleValue(text="Noninvasive pancreatobiliary papillary neoplasm with high grade intraepithelial neoplasia") )
        setattr(cls, "Sertoli-Leydig cell tumor, poorly differentiated, with heterologous elements",
                PermissibleValue(text="Sertoli-Leydig cell tumor, poorly differentiated, with heterologous elements") )
        setattr(cls, "Pilomatrix carcinoma",
                PermissibleValue(text="Pilomatrix carcinoma") )
        setattr(cls, "Acute myeloid leukemia, M6 type",
                PermissibleValue(text="Acute myeloid leukemia, M6 type") )
        setattr(cls, "Round cell sarcoma",
                PermissibleValue(text="Round cell sarcoma") )
        setattr(cls, "Malignant peripheral nerve sheath tumor with rhabdomyoblastic differentiation",
                PermissibleValue(text="Malignant peripheral nerve sheath tumor with rhabdomyoblastic differentiation") )
        setattr(cls, "Hodgkin disease, lymphocyte predominance, diffuse",
                PermissibleValue(text="Hodgkin disease, lymphocyte predominance, diffuse") )
        setattr(cls, "Malignant melanoma in Hutchinson melanotic freckle",
                PermissibleValue(text="Malignant melanoma in Hutchinson melanotic freckle") )
        setattr(cls, "Adenocarcinoma in polypoid adenoma",
                PermissibleValue(text="Adenocarcinoma in polypoid adenoma") )
        setattr(cls, "Mixed adenocarcinoma and epidermoid carcinoma",
                PermissibleValue(text="Mixed adenocarcinoma and epidermoid carcinoma") )
        setattr(cls, "Oxyphilic adenoma",
                PermissibleValue(text="Oxyphilic adenoma") )
        setattr(cls, "MALT lymphoma",
                PermissibleValue(text="MALT lymphoma") )
        setattr(cls, "Chronic granulocytic leukemia, t(9;22)(q34;q11)",
                PermissibleValue(text="Chronic granulocytic leukemia, t(9;22)(q34;q11)") )
        setattr(cls, "Acinar adenocarcinoma",
                PermissibleValue(text="Acinar adenocarcinoma") )
        setattr(cls, "Adenocarcinoma with apocrine metaplasia",
                PermissibleValue(text="Adenocarcinoma with apocrine metaplasia") )
        setattr(cls, "Stromal tumor with minor sex cord elements",
                PermissibleValue(text="Stromal tumor with minor sex cord elements") )
        setattr(cls, "Skin-associated lymphoid tissue lymphoma",
                PermissibleValue(text="Skin-associated lymphoid tissue lymphoma") )
        setattr(cls, "Phyllodes tumor, benign",
                PermissibleValue(text="Phyllodes tumor, benign") )
        setattr(cls, "Mixed carcinoid-adenocarcinoma",
                PermissibleValue(text="Mixed carcinoid-adenocarcinoma") )
        setattr(cls, "Follicular lymphoma, grade 3B",
                PermissibleValue(text="Follicular lymphoma, grade 3B") )
        setattr(cls, "Epithelial tumor, benign",
                PermissibleValue(text="Epithelial tumor, benign") )
        setattr(cls, "Aleukemic myelogenous leukemia",
                PermissibleValue(text="Aleukemic myelogenous leukemia") )
        setattr(cls, "Circumscribed arachnoidal cerebellar sarcoma",
                PermissibleValue(text="Circumscribed arachnoidal cerebellar sarcoma") )
        setattr(cls, "Monoclonal gammopathy, NOS",
                PermissibleValue(text="Monoclonal gammopathy, NOS") )
        setattr(cls, "Acute biphenotypic leukemia",
                PermissibleValue(text="Acute biphenotypic leukemia") )
        setattr(cls, "Embryonal adenoma",
                PermissibleValue(text="Embryonal adenoma") )
        setattr(cls, "Spindle cell carcinoma, NOS",
                PermissibleValue(text="Spindle cell carcinoma, NOS") )
        setattr(cls, "Anaplastic large cell lymphoma, NOS",
                PermissibleValue(text="Anaplastic large cell lymphoma, NOS") )
        setattr(cls, "Malignant tumor, spindle cell type",
                PermissibleValue(text="Malignant tumor, spindle cell type") )
        setattr(cls, "Thymoma, lymphocytic, malignant",
                PermissibleValue(text="Thymoma, lymphocytic, malignant") )
        setattr(cls, "Nerve sheath myxoma",
                PermissibleValue(text="Nerve sheath myxoma") )
        setattr(cls, "Renal cell carcinoma, chromophobe type",
                PermissibleValue(text="Renal cell carcinoma, chromophobe type") )
        setattr(cls, "Undifferentiated sarcoma",
                PermissibleValue(text="Undifferentiated sarcoma") )
        setattr(cls, "Well differentiated liposarcoma of superficial soft tissue",
                PermissibleValue(text="Well differentiated liposarcoma of superficial soft tissue") )
        setattr(cls, "Nodular hidradenoma, malignant",
                PermissibleValue(text="Nodular hidradenoma, malignant") )
        setattr(cls, "Syringadenoma, NOS",
                PermissibleValue(text="Syringadenoma, NOS") )
        setattr(cls, "Pleomorphic rhabdomyosarcoma, NOS",
                PermissibleValue(text="Pleomorphic rhabdomyosarcoma, NOS") )
        setattr(cls, "Primary intraosseous carcinoma",
                PermissibleValue(text="Primary intraosseous carcinoma") )
        setattr(cls, "Interstitial cell tumor, benign",
                PermissibleValue(text="Interstitial cell tumor, benign") )
        setattr(cls, "Epithelioid malignant peripheral nerve sheath tumor",
                PermissibleValue(text="Epithelioid malignant peripheral nerve sheath tumor") )
        setattr(cls, "Syringoma, NOS",
                PermissibleValue(text="Syringoma, NOS") )
        setattr(cls, "Renomedullary fibroma",
                PermissibleValue(text="Renomedullary fibroma") )
        setattr(cls, "Acute panmyelosis with myelofibrosis",
                PermissibleValue(text="Acute panmyelosis with myelofibrosis") )
        setattr(cls, "Microcystic urothelial carcinoma",
                PermissibleValue(text="Microcystic urothelial carcinoma") )
        setattr(cls, "Pseudomucinous adenocarcinoma",
                PermissibleValue(text="Pseudomucinous adenocarcinoma") )
        setattr(cls, "Arrhenoblastoma, malignant",
                PermissibleValue(text="Arrhenoblastoma, malignant") )
        setattr(cls, "Nonencapsulated sclerosing adenocarcinoma",
                PermissibleValue(text="Nonencapsulated sclerosing adenocarcinoma") )
        setattr(cls, "Cementoblastoma, benign",
                PermissibleValue(text="Cementoblastoma, benign") )
        setattr(cls, "Myoepithelial adenoma",
                PermissibleValue(text="Myoepithelial adenoma") )
        setattr(cls, "Extranodal NK/T-cell lymphoma, nasal type",
                PermissibleValue(text="Extranodal NK/T-cell lymphoma, nasal type") )
        setattr(cls, "Choriocarcinoma combined with other germ cell elements",
                PermissibleValue(text="Choriocarcinoma combined with other germ cell elements") )
        setattr(cls, "Water-clear cell adenoma",
                PermissibleValue(text="Water-clear cell adenoma") )
        setattr(cls, "Phyllodes tumor, NOS",
                PermissibleValue(text="Phyllodes tumor, NOS") )
        setattr(cls, "Epidermoid carcinoma, large cell, nonkeratinizing",
                PermissibleValue(text="Epidermoid carcinoma, large cell, nonkeratinizing") )
        setattr(cls, "Leiomyoma, NOS",
                PermissibleValue(text="Leiomyoma, NOS") )
        setattr(cls, "Mu heavy chain disease",
                PermissibleValue(text="Mu heavy chain disease") )
        setattr(cls, "Papillary renal cell carcinoma",
                PermissibleValue(text="Papillary renal cell carcinoma") )
        setattr(cls, "B-cell lymphoma, unclassifiable, with features intermediate between diffuse large B-cell lymphoma and Burkitt lymphoma",
                PermissibleValue(text="B-cell lymphoma, unclassifiable, with features intermediate between diffuse large B-cell lymphoma and Burkitt lymphoma") )
        setattr(cls, "Neurofibromatosis, NOS",
                PermissibleValue(text="Neurofibromatosis, NOS") )
        setattr(cls, "RAEB I",
                PermissibleValue(text="RAEB I") )
        setattr(cls, "Papillary pseudomucinous cystadenoma, borderline malignancy",
                PermissibleValue(text="Papillary pseudomucinous cystadenoma, borderline malignancy") )
        setattr(cls, "Lipoid cell tumor of ovary",
                PermissibleValue(text="Lipoid cell tumor of ovary") )
        setattr(cls, "Hutchinson melanotic freckle, NOS",
                PermissibleValue(text="Hutchinson melanotic freckle, NOS") )
        setattr(cls, "Acinar adenoma",
                PermissibleValue(text="Acinar adenoma") )
        setattr(cls, "Papillary serous cystadenocarcinoma",
                PermissibleValue(text="Papillary serous cystadenocarcinoma") )
        setattr(cls, "Chromophobe adenoma",
                PermissibleValue(text="Chromophobe adenoma") )
        setattr(cls, "Clear cell hidradenoma",
                PermissibleValue(text="Clear cell hidradenoma") )
        setattr(cls, "Granular cell myoblastoma, NOS",
                PermissibleValue(text="Granular cell myoblastoma, NOS") )
        setattr(cls, "Chondrosarcoma, NOS",
                PermissibleValue(text="Chondrosarcoma, NOS") )
        setattr(cls, "Papillary carcinoma, follicular variant",
                PermissibleValue(text="Papillary carcinoma, follicular variant") )
        setattr(cls, "Langerhans cell histiocytosis, multifocal",
                PermissibleValue(text="Langerhans cell histiocytosis, multifocal") )
        setattr(cls, "Medullary carcinoma with amyloid stroma",
                PermissibleValue(text="Medullary carcinoma with amyloid stroma") )
        setattr(cls, "Bronchial adenoma, NOS",
                PermissibleValue(text="Bronchial adenoma, NOS") )
        setattr(cls, "Mixed meningioma",
                PermissibleValue(text="Mixed meningioma") )
        setattr(cls, "Waldenstrom macroglobulinemia",
                PermissibleValue(text="Waldenstrom macroglobulinemia") )
        setattr(cls, "Anaplastic astrocytoma, IDH-wildtype",
                PermissibleValue(text="Anaplastic astrocytoma, IDH-wildtype") )
        setattr(cls, "Eosinophil adenoma",
                PermissibleValue(text="Eosinophil adenoma") )
        setattr(cls, "Sebaceous adenocarcinoma",
                PermissibleValue(text="Sebaceous adenocarcinoma",
                                 description="Head and Neck Sebaceous Carcinoma") )
        setattr(cls, "Encapsulated follicular variant of papillary thyroid carcinoma, NOS (EFVPTC, NOS)",
                PermissibleValue(text="Encapsulated follicular variant of papillary thyroid carcinoma, NOS (EFVPTC, NOS)") )
        setattr(cls, "Malignant lymphoma, large cleaved cell, follicular",
                PermissibleValue(text="Malignant lymphoma, large cleaved cell, follicular") )
        setattr(cls, "C cell carcinoma",
                PermissibleValue(text="C cell carcinoma") )
        setattr(cls, "Classical Hodgkin lymphoma, nodular sclerosis, NOS",
                PermissibleValue(text="Classical Hodgkin lymphoma, nodular sclerosis, NOS") )
        setattr(cls, "B lymphoblastic leukemia/lymphoma with hyperdiploidy",
                PermissibleValue(text="B lymphoblastic leukemia/lymphoma with hyperdiploidy") )
        setattr(cls, "Medulloblastoma, classic",
                PermissibleValue(text="Medulloblastoma, classic") )
        setattr(cls, "Meningeal sarcomatosis",
                PermissibleValue(text="Meningeal sarcomatosis") )
        setattr(cls, "Follicular adenocarcinoma, well differentiated",
                PermissibleValue(text="Follicular adenocarcinoma, well differentiated") )
        setattr(cls, "Desmoplastic fibroma",
                PermissibleValue(text="Desmoplastic fibroma") )
        setattr(cls, "Intravascular bronchial alveolar tumor",
                PermissibleValue(text="Intravascular bronchial alveolar tumor") )
        setattr(cls, "Lymphocytic leukemia, NOS",
                PermissibleValue(text="Lymphocytic leukemia, NOS") )
        setattr(cls, "Gastrointestinal stromal tumor, malignant",
                PermissibleValue(text="Gastrointestinal stromal tumor, malignant") )
        setattr(cls, "Transitional cell carcinoma, micropapillary",
                PermissibleValue(text="Transitional cell carcinoma, micropapillary") )
        setattr(cls, "Squamous cell carcinoma, pseudoglandular",
                PermissibleValue(text="Squamous cell carcinoma, pseudoglandular") )
        setattr(cls, "FAB M2, t(8;21)(q22;q22)",
                PermissibleValue(text="FAB M2, t(8;21)(q22;q22)") )
        setattr(cls, "Infantile fibrosarcoma",
                PermissibleValue(text="Infantile fibrosarcoma") )
        setattr(cls, "Mucin-producing carcinoma",
                PermissibleValue(text="Mucin-producing carcinoma") )
        setattr(cls, "Peripheral T-cell lymphoma, pleomorphic small cell",
                PermissibleValue(text="Peripheral T-cell lymphoma, pleomorphic small cell") )
        setattr(cls, "Ceruminous adenocarcinoma",
                PermissibleValue(text="Ceruminous adenocarcinoma") )
        setattr(cls, "Psammomatous meningioma",
                PermissibleValue(text="Psammomatous meningioma") )
        setattr(cls, "Juxtaglomerular tumor",
                PermissibleValue(text="Juxtaglomerular tumor") )
        setattr(cls, "Malignant lymphoma, large cell, noncleaved, NOS",
                PermissibleValue(text="Malignant lymphoma, large cell, noncleaved, NOS") )
        setattr(cls, "Non-small cell carcinoma",
                PermissibleValue(text="Non-small cell carcinoma") )
        setattr(cls, "Blast cell leukemia",
                PermissibleValue(text="Blast cell leukemia") )
        setattr(cls, "Neoplasm, secondary",
                PermissibleValue(text="Neoplasm, secondary") )
        setattr(cls, "Pineal parenchymal tumor of intermediate differentiation",
                PermissibleValue(text="Pineal parenchymal tumor of intermediate differentiation") )
        setattr(cls, "Multiple adenomatous polyps",
                PermissibleValue(text="Multiple adenomatous polyps") )
        setattr(cls, "Endometrioid cystadenofibroma, NOS",
                PermissibleValue(text="Endometrioid cystadenofibroma, NOS") )
        setattr(cls, "Chromophobe cell renal carcinoma",
                PermissibleValue(text="Chromophobe cell renal carcinoma") )
        setattr(cls, "Microfollicular adenoma, NOS",
                PermissibleValue(text="Microfollicular adenoma, NOS") )
        setattr(cls, "Gangliocytic paraganglioma",
                PermissibleValue(text="Gangliocytic paraganglioma") )
        setattr(cls, "Extranodal marginal zone lymphoma of mucosa-associated lymphoid tissue",
                PermissibleValue(text="Extranodal marginal zone lymphoma of mucosa-associated lymphoid tissue") )
        setattr(cls, "Basal cell epithelioma",
                PermissibleValue(text="Basal cell epithelioma") )
        setattr(cls, "Glioblastoma, IDH wildtype",
                PermissibleValue(text="Glioblastoma, IDH wildtype") )
        setattr(cls, "Dermatofibroma, NOS",
                PermissibleValue(text="Dermatofibroma, NOS") )
        setattr(cls, "Reticulum cell sarcoma, NOS",
                PermissibleValue(text="Reticulum cell sarcoma, NOS") )
        setattr(cls, "Atypical chronic myeloid leukemia, BCR/ABL negative",
                PermissibleValue(text="Atypical chronic myeloid leukemia, BCR/ABL negative") )
        setattr(cls, "Systemic mastocytosis with AHNMD",
                PermissibleValue(text="Systemic mastocytosis with AHNMD") )
        setattr(cls, "Bowen disease",
                PermissibleValue(text="Bowen disease") )
        setattr(cls, "Anaplastic oligoastrocytoma",
                PermissibleValue(text="Anaplastic oligoastrocytoma") )
        setattr(cls, "Prolymphocytic leukemia, NOS",
                PermissibleValue(text="Prolymphocytic leukemia, NOS") )
        setattr(cls, "Acute myeloid leukemia, minimal differentiation",
                PermissibleValue(text="Acute myeloid leukemia, minimal differentiation") )
        setattr(cls, "Spindle cell angioendothelioma",
                PermissibleValue(text="Spindle cell angioendothelioma") )
        setattr(cls, "PP/PYY producing tumor",
                PermissibleValue(text="PP/PYY producing tumor") )
        setattr(cls, "Chromophobe adenocarcinoma",
                PermissibleValue(text="Chromophobe adenocarcinoma") )
        setattr(cls, "Acidophil carcinoma",
                PermissibleValue(text="Acidophil carcinoma") )
        setattr(cls, "Malignant lymphoma, lymphoplasmacytoid",
                PermissibleValue(text="Malignant lymphoma, lymphoplasmacytoid") )
        setattr(cls, "Angiocentric glioma",
                PermissibleValue(text="Angiocentric glioma") )
        setattr(cls, "Malignant lymphoma, centroblastic, NOS",
                PermissibleValue(text="Malignant lymphoma, centroblastic, NOS") )
        setattr(cls, "Endometrioid cystadenofibroma, malignant",
                PermissibleValue(text="Endometrioid cystadenofibroma, malignant") )
        setattr(cls, "Sertoli-Leydig cell tumor, retiform",
                PermissibleValue(text="Sertoli-Leydig cell tumor, retiform") )
        setattr(cls, "Transitional cell carcinoma in situ",
                PermissibleValue(text="Transitional cell carcinoma in situ") )
        setattr(cls, "Bronchial adenoma, cylindroid",
                PermissibleValue(text="Bronchial adenoma, cylindroid") )
        setattr(cls, "Renal cell carcinoma, unclassified",
                PermissibleValue(text="Renal cell carcinoma, unclassified",
                                 description="Unclassified Renal Cell Carcinoma") )
        setattr(cls, "Enterochromaffin cell carcinoid",
                PermissibleValue(text="Enterochromaffin cell carcinoid") )
        setattr(cls, "Lobular carcinoma, NOS",
                PermissibleValue(text="Lobular carcinoma, NOS") )
        setattr(cls, "Intradermal nevus",
                PermissibleValue(text="Intradermal nevus") )
        setattr(cls, "Basophil adenoma",
                PermissibleValue(text="Basophil adenoma") )
        setattr(cls, "Esophageal intraepithelial neoplasia, high grade",
                PermissibleValue(text="Esophageal intraepithelial neoplasia, high grade") )
        setattr(cls, "Sweat gland carcinoma",
                PermissibleValue(text="Sweat gland carcinoma") )
        setattr(cls, "Indolent systemic mastocytosis",
                PermissibleValue(text="Indolent systemic mastocytosis") )
        setattr(cls, "Mesothelioma, biphasic, NOS",
                PermissibleValue(text="Mesothelioma, biphasic, NOS") )
        setattr(cls, "Familial polyposis coli",
                PermissibleValue(text="Familial polyposis coli") )
        setattr(cls, "Carcinoma, metastatic, NOS",
                PermissibleValue(text="Carcinoma, metastatic, NOS") )
        setattr(cls, "Malignant lymphoma, large cleaved cell, NOS",
                PermissibleValue(text="Malignant lymphoma, large cleaved cell, NOS") )
        setattr(cls, "Multifocal superficial basal cell carcinoma",
                PermissibleValue(text="Multifocal superficial basal cell carcinoma") )
        setattr(cls, "Terminal duct adenocarcinoma",
                PermissibleValue(text="Terminal duct adenocarcinoma") )
        setattr(cls, "Invasive lobular carcinoma, tubulolobular variant",
                PermissibleValue(text="Invasive lobular carcinoma, tubulolobular variant") )
        setattr(cls, "Clear cell odontogenic tumor",
                PermissibleValue(text="Clear cell odontogenic tumor") )
        setattr(cls, "Islet cell carcinoma",
                PermissibleValue(text="Islet cell carcinoma") )
        setattr(cls, "Papillary hidradenoma",
                PermissibleValue(text="Papillary hidradenoma") )
        setattr(cls, "Infiltrating duct and colloid carcinoma",
                PermissibleValue(text="Infiltrating duct and colloid carcinoma") )
        setattr(cls, "Immature teratoma, NOS",
                PermissibleValue(text="Immature teratoma, NOS") )
        setattr(cls, "Tumor, malignant, NOS",
                PermissibleValue(text="Tumor, malignant, NOS") )
        setattr(cls, "Chronic erythremia",
                PermissibleValue(text="Chronic erythremia") )
        setattr(cls, "Large cell carcinoma with rhabdoid phenotype",
                PermissibleValue(text="Large cell carcinoma with rhabdoid phenotype") )
        setattr(cls, "Unclassified tumor, uncertain whether benign or malignant",
                PermissibleValue(text="Unclassified tumor, uncertain whether benign or malignant") )
        setattr(cls, "Chordoid glioma of third ventricle",
                PermissibleValue(text="Chordoid glioma of third ventricle") )
        setattr(cls, "Transitional papilloma",
                PermissibleValue(text="Transitional papilloma") )
        setattr(cls, "Solitary fibrous tumor/hemangiopericytoma Grade 1 (CNS)",
                PermissibleValue(text="Solitary fibrous tumor/hemangiopericytoma Grade 1 (CNS)") )
        setattr(cls, "Acute basophilic leukaemia",
                PermissibleValue(text="Acute basophilic leukaemia") )
        setattr(cls, "Myloproliferative neoplasm, unclassifiable",
                PermissibleValue(text="Myloproliferative neoplasm, unclassifiable") )
        setattr(cls, "Malignant melanoma, regressing",
                PermissibleValue(text="Malignant melanoma, regressing") )
        setattr(cls, "Endometrioid cystadenocarcinoma",
                PermissibleValue(text="Endometrioid cystadenocarcinoma") )
        setattr(cls, "Pancreatic endocrine tumor, nonfunctioning",
                PermissibleValue(text="Pancreatic endocrine tumor, nonfunctioning") )
        setattr(cls, "Intraductal papillary neoplasm with intermediate grade neoplasia",
                PermissibleValue(text="Intraductal papillary neoplasm with intermediate grade neoplasia") )
        setattr(cls, "Endometrioid carcinoma, NOS",
                PermissibleValue(text="Endometrioid carcinoma, NOS",
                                 description="Endometrial Carcinoma") )
        setattr(cls, "Hidradenoma papilliferum",
                PermissibleValue(text="Hidradenoma papilliferum") )
        setattr(cls, "Intravascular large B-cell lymphoma",
                PermissibleValue(text="Intravascular large B-cell lymphoma") )
        setattr(cls, "Clear cell cystadenocarcinofibroma",
                PermissibleValue(text="Clear cell cystadenocarcinofibroma") )
        setattr(cls, "Spindle cell nevus, NOS",
                PermissibleValue(text="Spindle cell nevus, NOS") )
        setattr(cls, "Scirrhous adenocarcinoma",
                PermissibleValue(text="Scirrhous adenocarcinoma") )
        setattr(cls, "Fibroameloblastic odontoma",
                PermissibleValue(text="Fibroameloblastic odontoma") )
        setattr(cls, "Esophageal squamous intraepithelial neoplasia (dysplasia), high grade",
                PermissibleValue(text="Esophageal squamous intraepithelial neoplasia (dysplasia), high grade") )
        setattr(cls, "Lymphoepithelioma-like carcinoma",
                PermissibleValue(text="Lymphoepithelioma-like carcinoma") )
        setattr(cls, "Adrenal cortical tumor, NOS",
                PermissibleValue(text="Adrenal cortical tumor, NOS") )
        setattr(cls, "Lactating adenoma",
                PermissibleValue(text="Lactating adenoma") )
        setattr(cls, "Malignant melanoma, NOS",
                PermissibleValue(text="Malignant melanoma, NOS") )
        setattr(cls, "Spongioblastoma polare",
                PermissibleValue(text="Spongioblastoma polare") )
        setattr(cls, "Mucinous cystic tumor of borderline malignancy",
                PermissibleValue(text="Mucinous cystic tumor of borderline malignancy") )
        setattr(cls, "Tubular androblastoma with lipid storage",
                PermissibleValue(text="Tubular androblastoma with lipid storage") )
        setattr(cls, "T-gamma lymphoproliferative disease",
                PermissibleValue(text="T-gamma lymphoproliferative disease") )
        setattr(cls, "Mucoid cell adenocarcinoma",
                PermissibleValue(text="Mucoid cell adenocarcinoma") )
        setattr(cls, "Epithelioid mesothelioma, malignant",
                PermissibleValue(text="Epithelioid mesothelioma, malignant") )
        setattr(cls, "Myxofibroma, NOS",
                PermissibleValue(text="Myxofibroma, NOS") )
        setattr(cls, "Hurthle cell adenoma",
                PermissibleValue(text="Hurthle cell adenoma") )
        setattr(cls, "Osteoblastoma, malignant",
                PermissibleValue(text="Osteoblastoma, malignant") )
        setattr(cls, "Intraepidermal squamous cell carcinoma, Bowen type",
                PermissibleValue(text="Intraepidermal squamous cell carcinoma, Bowen type") )
        setattr(cls, "Juvenile fibroadenoma",
                PermissibleValue(text="Juvenile fibroadenoma") )
        setattr(cls, "Glucagon-like peptide-producing tumor",
                PermissibleValue(text="Glucagon-like peptide-producing tumor") )
        setattr(cls, "Endometrioid adenocarcinoma, ciliated cell variant",
                PermissibleValue(text="Endometrioid adenocarcinoma, ciliated cell variant") )
        setattr(cls, "Malignant lymphoma, undifferentiated cell type, NOS",
                PermissibleValue(text="Malignant lymphoma, undifferentiated cell type, NOS") )
        setattr(cls, "Adenocarcinoma, cylindroid",
                PermissibleValue(text="Adenocarcinoma, cylindroid") )
        setattr(cls, "Clear cell (glycogen-rich) urothelial carcinoma",
                PermissibleValue(text="Clear cell (glycogen-rich) urothelial carcinoma") )
        setattr(cls, "Glandular intraepithelial neoplasia, grade I",
                PermissibleValue(text="Glandular intraepithelial neoplasia, grade I") )
        setattr(cls, "Blue nevus, malignant",
                PermissibleValue(text="Blue nevus, malignant") )
        setattr(cls, "Hilus cell tumor",
                PermissibleValue(text="Hilus cell tumor") )
        setattr(cls, "Adenocarcinoma in adenomatous polyposis coli",
                PermissibleValue(text="Adenocarcinoma in adenomatous polyposis coli") )
        setattr(cls, "Embryonal tumor with multilayered rosettes, NOS",
                PermissibleValue(text="Embryonal tumor with multilayered rosettes, NOS") )
        setattr(cls, "Sclerosing epithelioid fibrosarcoma",
                PermissibleValue(text="Sclerosing epithelioid fibrosarcoma") )
        setattr(cls, "Multiple hemorrhagic sarcoma",
                PermissibleValue(text="Multiple hemorrhagic sarcoma") )
        setattr(cls, "Hodgkin lymphoma, lymphocyte depletion, diffuse fibrosis",
                PermissibleValue(text="Hodgkin lymphoma, lymphocyte depletion, diffuse fibrosis") )
        setattr(cls, "Acute monocytic leukemia",
                PermissibleValue(text="Acute monocytic leukemia") )
        setattr(cls, "Acute leukemia, NOS",
                PermissibleValue(text="Acute leukemia, NOS") )
        setattr(cls, "Myeloid and lymphoid neoplasms with FGFR1 abnormalities",
                PermissibleValue(text="Myeloid and lymphoid neoplasms with FGFR1 abnormalities") )
        setattr(cls, "Mixed liposarcoma",
                PermissibleValue(text="Mixed liposarcoma") )
        setattr(cls, "Lobular carcinoma in situ, NOS",
                PermissibleValue(text="Lobular carcinoma in situ, NOS") )
        setattr(cls, "Islet cell tumor, NOS",
                PermissibleValue(text="Islet cell tumor, NOS") )
        setattr(cls, "Serous cystadenocarcinoma, NOS",
                PermissibleValue(text="Serous cystadenocarcinoma, NOS") )
        setattr(cls, "Carcinoma with neuroendocrine differentiation",
                PermissibleValue(text="Carcinoma with neuroendocrine differentiation") )
        setattr(cls, "Papillary cystadenoma, NOS",
                PermissibleValue(text="Papillary cystadenoma, NOS") )
        setattr(cls, "Tubular carcinoid",
                PermissibleValue(text="Tubular carcinoid") )
        setattr(cls, "Acute myeloid leukemia with maturation",
                PermissibleValue(text="Acute myeloid leukemia with maturation") )
        setattr(cls, "Arrhenoblastoma, benign",
                PermissibleValue(text="Arrhenoblastoma, benign") )
        setattr(cls, "Sertoli-Leydig cell tumor, NOS",
                PermissibleValue(text="Sertoli-Leydig cell tumor, NOS") )
        setattr(cls, "Endotheliomatous meningioma",
                PermissibleValue(text="Endotheliomatous meningioma") )
        setattr(cls, "Hemangiopericytic meningioma",
                PermissibleValue(text="Hemangiopericytic meningioma") )
        setattr(cls, "Epithelioid and spindle cell nevus",
                PermissibleValue(text="Epithelioid and spindle cell nevus") )
        setattr(cls, "Combined hepatocellular carcinoma and cholangiocarcinoma",
                PermissibleValue(text="Combined hepatocellular carcinoma and cholangiocarcinoma") )
        setattr(cls, "Malignant lymphoma, small cell, NOS",
                PermissibleValue(text="Malignant lymphoma, small cell, NOS") )
        setattr(cls, "Squamous cell epithelioma",
                PermissibleValue(text="Squamous cell epithelioma") )
        setattr(cls, "Medulloblastoma, group 3",
                PermissibleValue(text="Medulloblastoma, group 3") )
        setattr(cls, "Embryonal tumor with multilayered rosettes C19MC-altered",
                PermissibleValue(text="Embryonal tumor with multilayered rosettes C19MC-altered") )
        setattr(cls, "Metastasizing leiomyoma",
                PermissibleValue(text="Metastasizing leiomyoma") )
        setattr(cls, "Franklin disease",
                PermissibleValue(text="Franklin disease") )
        setattr(cls, "Peripheral neuroectodermal tumor",
                PermissibleValue(text="Peripheral neuroectodermal tumor") )
        setattr(cls, "Recklinghausen disease",
                PermissibleValue(text="Recklinghausen disease") )
        setattr(cls, "Phyllodes tumor, malignant",
                PermissibleValue(text="Phyllodes tumor, malignant") )
        setattr(cls, "Mucinous cystic neoplasm with high-grade intraepithelial neoplasia",
                PermissibleValue(text="Mucinous cystic neoplasm with high-grade intraepithelial neoplasia") )
        setattr(cls, "Ductal carcinoma in situ, solid type",
                PermissibleValue(text="Ductal carcinoma in situ, solid type") )
        setattr(cls, "Small cell osteosarcoma",
                PermissibleValue(text="Small cell osteosarcoma") )
        setattr(cls, "Myoepithelial tumor",
                PermissibleValue(text="Myoepithelial tumor") )
        setattr(cls, "Intravascular leiomyomatosis",
                PermissibleValue(text="Intravascular leiomyomatosis") )
        setattr(cls, "Malignant lymphoma, histiocytic, nodular",
                PermissibleValue(text="Malignant lymphoma, histiocytic, nodular") )
        setattr(cls, "Polygonal cell carcinoma",
                PermissibleValue(text="Polygonal cell carcinoma") )
        setattr(cls, "Cellular schwannoma",
                PermissibleValue(text="Cellular schwannoma") )
        setattr(cls, "Histiocytoma, NOS",
                PermissibleValue(text="Histiocytoma, NOS") )
        setattr(cls, "Paget disease and intraductal carcinoma of breast",
                PermissibleValue(text="Paget disease and intraductal carcinoma of breast") )
        setattr(cls, "Liposarcoma, NOS",
                PermissibleValue(text="Liposarcoma, NOS") )
        setattr(cls, "Bronchio-alveolar carcinoma, mixed mucinous and non-mucinous",
                PermissibleValue(text="Bronchio-alveolar carcinoma, mixed mucinous and non-mucinous") )
        setattr(cls, "Papillary transitional cell neoplasm of low malignant potential",
                PermissibleValue(text="Papillary transitional cell neoplasm of low malignant potential") )
        setattr(cls, "ECL cell carcinoid, NOS",
                PermissibleValue(text="ECL cell carcinoid, NOS") )
        setattr(cls, "Intracortical osteosarcoma",
                PermissibleValue(text="Intracortical osteosarcoma") )
        setattr(cls, "Urothelial carcinoma in situ",
                PermissibleValue(text="Urothelial carcinoma in situ") )
        setattr(cls, "Carcinoma with other types mesenchymal differentiation",
                PermissibleValue(text="Carcinoma with other types mesenchymal differentiation") )
        setattr(cls, "Cyst-associated renal cell carcinoma",
                PermissibleValue(text="Cyst-associated renal cell carcinoma") )
        setattr(cls, "Interstitial cell tumor, NOS",
                PermissibleValue(text="Interstitial cell tumor, NOS") )
        setattr(cls, "Glycogenic rhabdomyoma",
                PermissibleValue(text="Glycogenic rhabdomyoma") )
        setattr(cls, "Intraductal papillary neoplasm with associated invasive carcinoma",
                PermissibleValue(text="Intraductal papillary neoplasm with associated invasive carcinoma") )
        setattr(cls, "Neuroendocrine carcinoma, NOS",
                PermissibleValue(text="Neuroendocrine carcinoma, NOS") )
        setattr(cls, "Diktyoma, benign",
                PermissibleValue(text="Diktyoma, benign") )
        setattr(cls, "Bronchial-associated lymphoid tissue lymphoma",
                PermissibleValue(text="Bronchial-associated lymphoid tissue lymphoma") )
        setattr(cls, "Pseudosarcomatous carcinoma",
                PermissibleValue(text="Pseudosarcomatous carcinoma") )
        setattr(cls, "Inflammatory myofibroblastic tumor",
                PermissibleValue(text="Inflammatory myofibroblastic tumor",
                                 description="Inflammatory Myofibroblastic Tumor") )
        setattr(cls, "Classical Hodgkin lymphoma, lymphocyte-rich",
                PermissibleValue(text="Classical Hodgkin lymphoma, lymphocyte-rich") )
        setattr(cls, "Malignant multilocular cystic nephroma",
                PermissibleValue(text="Malignant multilocular cystic nephroma") )
        setattr(cls, "SALT lymphoma",
                PermissibleValue(text="SALT lymphoma") )
        setattr(cls, "Malignant lymphoma, lymphocytic, poorly differentiated, nodular",
                PermissibleValue(text="Malignant lymphoma, lymphocytic, poorly differentiated, nodular") )
        setattr(cls, "T-cell large granular lymphocytic leukemia",
                PermissibleValue(text="T-cell large granular lymphocytic leukemia") )
        setattr(cls, "Malignant schwannoma, NOS",
                PermissibleValue(text="Malignant schwannoma, NOS") )
        setattr(cls, "Peripheral primitive neuroectodermal tumor, NOS",
                PermissibleValue(text="Peripheral primitive neuroectodermal tumor, NOS") )
        setattr(cls, "Ameloblastic fibro-odontoma",
                PermissibleValue(text="Ameloblastic fibro-odontoma") )
        setattr(cls, "Tumor cells, benign",
                PermissibleValue(text="Tumor cells, benign") )
        setattr(cls, "Thymic carcinoma with adenoid cystic carcinoma-like features",
                PermissibleValue(text="Thymic carcinoma with adenoid cystic carcinoma-like features") )
        setattr(cls, "Chronic myelomonocytic leukemia, Type 1",
                PermissibleValue(text="Chronic myelomonocytic leukemia, Type 1") )
        setattr(cls, "Chronic myeloproliferative disease, NOS",
                PermissibleValue(text="Chronic myeloproliferative disease, NOS") )
        setattr(cls, "Solid pseudopapillary tumor",
                PermissibleValue(text="Solid pseudopapillary tumor") )
        setattr(cls, "Hepatoma, malignant",
                PermissibleValue(text="Hepatoma, malignant") )
        setattr(cls, "Clear cell adenofibroma of borderline malignancy",
                PermissibleValue(text="Clear cell adenofibroma of borderline malignancy") )
        setattr(cls, "Basal cell carcinoma, morpheic",
                PermissibleValue(text="Basal cell carcinoma, morpheic") )
        setattr(cls, "Squamous cell carcinoma, keratinizing, NOS",
                PermissibleValue(text="Squamous cell carcinoma, keratinizing, NOS") )
        setattr(cls, "Odontogenic tumor, benign",
                PermissibleValue(text="Odontogenic tumor, benign") )
        setattr(cls, "Acute myeloid leukemia with myelodysplasia-related changes",
                PermissibleValue(text="Acute myeloid leukemia with myelodysplasia-related changes") )
        setattr(cls, "Cystic lymphangioma",
                PermissibleValue(text="Cystic lymphangioma") )
        setattr(cls, "Endometrioid adenofibroma, malignant",
                PermissibleValue(text="Endometrioid adenofibroma, malignant") )
        setattr(cls, "Osteoblastoma, NOS",
                PermissibleValue(text="Osteoblastoma, NOS") )
        setattr(cls, "Malignant lymphoma, large cell, diffuse, NOS",
                PermissibleValue(text="Malignant lymphoma, large cell, diffuse, NOS") )
        setattr(cls, "Undifferentiated pleomorphic sarcoma",
                PermissibleValue(text="Undifferentiated pleomorphic sarcoma") )
        setattr(cls, "Mucosal lentiginous melanoma",
                PermissibleValue(text="Mucosal lentiginous melanoma") )
        setattr(cls, "Micropapillary serous carcinoma",
                PermissibleValue(text="Micropapillary serous carcinoma") )
        setattr(cls, "Epithelioid leiomyoma",
                PermissibleValue(text="Epithelioid leiomyoma") )
        setattr(cls, "Acute lymphoblastic leukemia, mature B-cell type",
                PermissibleValue(text="Acute lymphoblastic leukemia, mature B-cell type") )
        setattr(cls, "Pilomatrixoma, malignant",
                PermissibleValue(text="Pilomatrixoma, malignant") )
        setattr(cls, "Glassy cell carcinoma",
                PermissibleValue(text="Glassy cell carcinoma") )
        setattr(cls, "Solid carcinoma with mucin formation",
                PermissibleValue(text="Solid carcinoma with mucin formation") )
        setattr(cls, "Colloid carcinoma",
                PermissibleValue(text="Colloid carcinoma") )
        setattr(cls, "Bronchiolar carcinoma",
                PermissibleValue(text="Bronchiolar carcinoma") )
        setattr(cls, "Subepidermal nodular fibrosis",
                PermissibleValue(text="Subepidermal nodular fibrosis") )
        setattr(cls, "Intravascular B-cell lymphoma",
                PermissibleValue(text="Intravascular B-cell lymphoma") )
        setattr(cls, "Systemic EBV positive T-cell lymphoproliferative disease of childhood",
                PermissibleValue(text="Systemic EBV positive T-cell lymphoproliferative disease of childhood") )
        setattr(cls, "Malignant lymphoma, histiocytic, NOS",
                PermissibleValue(text="Malignant lymphoma, histiocytic, NOS") )
        setattr(cls, "Carcinoma with chondroid differentiation",
                PermissibleValue(text="Carcinoma with chondroid differentiation") )
        setattr(cls, "Plasmacytoma, extramedullary",
                PermissibleValue(text="Plasmacytoma, extramedullary") )
        setattr(cls, "Neuroendocrine tumor, grade 1",
                PermissibleValue(text="Neuroendocrine tumor, grade 1") )
        setattr(cls, "Synovial sarcoma, monophasic fibrous",
                PermissibleValue(text="Synovial sarcoma, monophasic fibrous") )
        setattr(cls, "Adult teratoma, NOS",
                PermissibleValue(text="Adult teratoma, NOS") )
        setattr(cls, "Epithelioid MPNST",
                PermissibleValue(text="Epithelioid MPNST") )
        setattr(cls, "Balloon cell melanoma",
                PermissibleValue(text="Balloon cell melanoma") )
        setattr(cls, "Acute erythremia",
                PermissibleValue(text="Acute erythremia") )
        setattr(cls, "Chordoid meningioma",
                PermissibleValue(text="Chordoid meningioma") )
        setattr(cls, "Apocrine cystadenoma",
                PermissibleValue(text="Apocrine cystadenoma") )
        setattr(cls, "Chronic myelocytic leukemia, NOS",
                PermissibleValue(text="Chronic myelocytic leukemia, NOS") )
        setattr(cls, "Papillary cystadenoma lymphomatosum",
                PermissibleValue(text="Papillary cystadenoma lymphomatosum") )
        setattr(cls, "Renal cell carcinoma, sarcomatoid",
                PermissibleValue(text="Renal cell carcinoma, sarcomatoid") )
        setattr(cls, "Macrofollicular adenoma",
                PermissibleValue(text="Macrofollicular adenoma") )
        setattr(cls, "Follicular adenocarcinoma, NOS",
                PermissibleValue(text="Follicular adenocarcinoma, NOS") )
        setattr(cls, "Supratentorial PNET",
                PermissibleValue(text="Supratentorial PNET") )
        setattr(cls, "Lymphatic leukemic, NOS",
                PermissibleValue(text="Lymphatic leukemic, NOS") )
        setattr(cls, "Epithelioma, NOS",
                PermissibleValue(text="Epithelioma, NOS") )
        setattr(cls, "Encapsulated papillary carcinoma",
                PermissibleValue(text="Encapsulated papillary carcinoma") )
        setattr(cls, "Gastrointestinal stromal tumor, uncertain malignant potential",
                PermissibleValue(text="Gastrointestinal stromal tumor, uncertain malignant potential") )
        setattr(cls, "Acute lymphoblastic leukemia, L2 type, NOS",
                PermissibleValue(text="Acute lymphoblastic leukemia, L2 type, NOS") )
        setattr(cls, "Adrenal medullary paraganglioma",
                PermissibleValue(text="Adrenal medullary paraganglioma") )
        setattr(cls, "Thymic large B-cell lymphoma",
                PermissibleValue(text="Thymic large B-cell lymphoma") )
        setattr(cls, "Acute promyelocytic leukemia, NOS",
                PermissibleValue(text="Acute promyelocytic leukemia, NOS") )
        setattr(cls, "Mesoblastic nephroma",
                PermissibleValue(text="Mesoblastic nephroma") )
        setattr(cls, "Leiomyosarcoma, NOS",
                PermissibleValue(text="Leiomyosarcoma, NOS") )
        setattr(cls, "Pleomorphic lipoma",
                PermissibleValue(text="Pleomorphic lipoma") )
        setattr(cls, "Cutaneous mastocytosis",
                PermissibleValue(text="Cutaneous mastocytosis") )
        setattr(cls, "Acute mixed lineage leukemia",
                PermissibleValue(text="Acute mixed lineage leukemia") )
        setattr(cls, "Dermatofibrosarcoma, NOS",
                PermissibleValue(text="Dermatofibrosarcoma, NOS") )
        setattr(cls, "Sertoli cell tumor, NOS",
                PermissibleValue(text="Sertoli cell tumor, NOS") )
        setattr(cls, "Papillary carcinoma, oxyphilic cell",
                PermissibleValue(text="Papillary carcinoma, oxyphilic cell") )
        setattr(cls, "Acinar cell tumor",
                PermissibleValue(text="Acinar cell tumor") )
        setattr(cls, "Papillary ependymoma",
                PermissibleValue(text="Papillary ependymoma") )
        setattr(cls, "Thymoma, atypical, malignant",
                PermissibleValue(text="Thymoma, atypical, malignant") )
        setattr(cls, "Adenocarcinoma admixed with neuroendocrine carcinoma",
                PermissibleValue(text="Adenocarcinoma admixed with neuroendocrine carcinoma") )
        setattr(cls, "Stromal tumor, NOS",
                PermissibleValue(text="Stromal tumor, NOS") )
        setattr(cls, "Intraductal papillary-mucinous neoplasm with low grade dysplasia",
                PermissibleValue(text="Intraductal papillary-mucinous neoplasm with low grade dysplasia") )
        setattr(cls, "Basal cell carcinoma, NOS",
                PermissibleValue(text="Basal cell carcinoma, NOS") )
        setattr(cls, "Papillary pseudomucinous cystadenocarcinoma",
                PermissibleValue(text="Papillary pseudomucinous cystadenocarcinoma") )
        setattr(cls, "Acute granulocytic leukemia",
                PermissibleValue(text="Acute granulocytic leukemia") )
        setattr(cls, "Superficial spreading melanoma",
                PermissibleValue(text="Superficial spreading melanoma",
                                 description="Superficial Spreading Melanoma") )
        setattr(cls, "Ependymoma, RELA fusion-positive",
                PermissibleValue(text="Ependymoma, RELA fusion-positive") )
        setattr(cls, "Adamantinoma of long bones",
                PermissibleValue(text="Adamantinoma of long bones") )
        setattr(cls, "Glomoid sarcoma",
                PermissibleValue(text="Glomoid sarcoma") )
        setattr(cls, "Mixed germ cell sex cord-stromal tumor, unclassified",
                PermissibleValue(text="Mixed germ cell sex cord-stromal tumor, unclassified") )
        setattr(cls, "Sweat gland adenocarcinoma",
                PermissibleValue(text="Sweat gland adenocarcinoma") )
        setattr(cls, "Glomus tumor, malignant",
                PermissibleValue(text="Glomus tumor, malignant") )
        setattr(cls, "Calcifying epithelioma of Malherbe",
                PermissibleValue(text="Calcifying epithelioma of Malherbe") )
        setattr(cls, "Hodgkin lymphoma, nodular sclerosis, grade 2",
                PermissibleValue(text="Hodgkin lymphoma, nodular sclerosis, grade 2") )
        setattr(cls, "Somatostatinoma, NOS",
                PermissibleValue(text="Somatostatinoma, NOS") )
        setattr(cls, "Aggressive systemic mastocytosis",
                PermissibleValue(text="Aggressive systemic mastocytosis") )
        setattr(cls, "Adrenal cortical tumor, benign",
                PermissibleValue(text="Adrenal cortical tumor, benign") )
        setattr(cls, "Malignant teratoma, trophoblastic",
                PermissibleValue(text="Malignant teratoma, trophoblastic") )
        setattr(cls, "Undifferentiated uterine sarcoma",
                PermissibleValue(text="Undifferentiated uterine sarcoma") )
        setattr(cls, "Essential thrombocythemia",
                PermissibleValue(text="Essential thrombocythemia") )
        setattr(cls, "ACTH-producing tumor",
                PermissibleValue(text="ACTH-producing tumor") )
        setattr(cls, "Acinar adenocarcinoma, sarcomatoid",
                PermissibleValue(text="Acinar adenocarcinoma, sarcomatoid") )
        setattr(cls, "Ductal carcinoma in situ, cribriform type",
                PermissibleValue(text="Ductal carcinoma in situ, cribriform type") )
        setattr(cls, "Papillary urothelial neoplasm of low malignant potential",
                PermissibleValue(text="Papillary urothelial neoplasm of low malignant potential") )
        setattr(cls, "Teratoid medulloepithelioma, benign",
                PermissibleValue(text="Teratoid medulloepithelioma, benign") )
        setattr(cls, "Fibrous histiocytoma, NOS",
                PermissibleValue(text="Fibrous histiocytoma, NOS") )
        setattr(cls, "Mucous carcinoma",
                PermissibleValue(text="Mucous carcinoma") )
        setattr(cls, "Myxoid fibroma",
                PermissibleValue(text="Myxoid fibroma") )
        setattr(cls, "Carcinoma in a polyp, NOS",
                PermissibleValue(text="Carcinoma in a polyp, NOS") )
        setattr(cls, "Anaplastic large cell lymphoma, ALK negative",
                PermissibleValue(text="Anaplastic large cell lymphoma, ALK negative") )
        setattr(cls, "Symplastic leiomyoma",
                PermissibleValue(text="Symplastic leiomyoma") )
        setattr(cls, "Pancreatic endocrine tumor, malignant",
                PermissibleValue(text="Pancreatic endocrine tumor, malignant") )
        setattr(cls, "Intraductal papillary neoplasm, NOS",
                PermissibleValue(text="Intraductal papillary neoplasm, NOS") )
        setattr(cls, "Malignant melanoma in precancerous melanosis",
                PermissibleValue(text="Malignant melanoma in precancerous melanosis") )
        setattr(cls, "Glomus jugulare tumor, NOS",
                PermissibleValue(text="Glomus jugulare tumor, NOS") )
        setattr(cls, "Chondroid syringoma",
                PermissibleValue(text="Chondroid syringoma") )
        setattr(cls, "Ameloblastic fibrodentinosarcoma",
                PermissibleValue(text="Ameloblastic fibrodentinosarcoma") )
        setattr(cls, "Non-invasive low grade serous carcinoma",
                PermissibleValue(text="Non-invasive low grade serous carcinoma") )
        setattr(cls, "Chronic myelogenous leukemia, Philadelphia chromosome (Ph 1) positive",
                PermissibleValue(text="Chronic myelogenous leukemia, Philadelphia chromosome (Ph 1) positive") )
        setattr(cls, "Myelodysplastic syndrome, NOS",
                PermissibleValue(text="Myelodysplastic syndrome, NOS") )
        setattr(cls, "GIST, benign",
                PermissibleValue(text="GIST, benign") )
        setattr(cls, "Intraductal papillary tumor with high grade intraepithelial neoplasia",
                PermissibleValue(text="Intraductal papillary tumor with high grade intraepithelial neoplasia") )
        setattr(cls, "Villous adenoma, NOS",
                PermissibleValue(text="Villous adenoma, NOS") )
        setattr(cls, "Odontogenic ghost cell tumor",
                PermissibleValue(text="Odontogenic ghost cell tumor") )
        setattr(cls, "DCIS, papillary",
                PermissibleValue(text="DCIS, papillary") )
        setattr(cls, "Bile duct cystadenocarcinoma",
                PermissibleValue(text="Bile duct cystadenocarcinoma") )
        setattr(cls, "Myxoid chondrosarcoma",
                PermissibleValue(text="Myxoid chondrosarcoma") )
        setattr(cls, "Intraepidermal nevus",
                PermissibleValue(text="Intraepidermal nevus") )
        setattr(cls, "Myxoid leiomyosarcoma",
                PermissibleValue(text="Myxoid leiomyosarcoma") )
        setattr(cls, "Infiltrating duct mixed with other types of carcinoma",
                PermissibleValue(text="Infiltrating duct mixed with other types of carcinoma") )
        setattr(cls, "Prolymphocytic leukemia, T-cell type",
                PermissibleValue(text="Prolymphocytic leukemia, T-cell type") )
        setattr(cls, "Skin appendage tumor, benign",
                PermissibleValue(text="Skin appendage tumor, benign") )
        setattr(cls, "Ghost cell odontogenic carcinoma",
                PermissibleValue(text="Ghost cell odontogenic carcinoma") )
        setattr(cls, "Acute erythroid leukaemia",
                PermissibleValue(text="Acute erythroid leukaemia") )
        setattr(cls, "Steroid cell tumor, malignant",
                PermissibleValue(text="Steroid cell tumor, malignant") )
        setattr(cls, "Extraventricular neurocytoma",
                PermissibleValue(text="Extraventricular neurocytoma") )
        setattr(cls, "Mucoid carcinoma",
                PermissibleValue(text="Mucoid carcinoma") )
        setattr(cls, "FAB M6",
                PermissibleValue(text="FAB M6") )
        setattr(cls, "Infiltrating duct carcinoma, NOS",
                PermissibleValue(text="Infiltrating duct carcinoma, NOS") )
        setattr(cls, "Neoplasm, metastatic",
                PermissibleValue(text="Neoplasm, metastatic") )
        setattr(cls, "Islet cell adenocarcinoma",
                PermissibleValue(text="Islet cell adenocarcinoma") )
        setattr(cls, "Atypical lipoma",
                PermissibleValue(text="Atypical lipoma") )
        setattr(cls, "Noninfiltrating intraductal papillary adenocarcinoma",
                PermissibleValue(text="Noninfiltrating intraductal papillary adenocarcinoma") )
        setattr(cls, "Intraductal papilloma",
                PermissibleValue(text="Intraductal papilloma") )
        setattr(cls, "Oligodendroglioma, NOS",
                PermissibleValue(text="Oligodendroglioma, NOS") )
        setattr(cls, "Medulloblastoma with extensive nodularity",
                PermissibleValue(text="Medulloblastoma with extensive nodularity") )
        setattr(cls, "Thymoma, cortical, malignant",
                PermissibleValue(text="Thymoma, cortical, malignant") )
        setattr(cls, "MPNST with rhabdomyoblastic differentiation",
                PermissibleValue(text="MPNST with rhabdomyoblastic differentiation") )
        setattr(cls, "Atypical polypoid adenomyoma",
                PermissibleValue(text="Atypical polypoid adenomyoma") )
        setattr(cls, "Seminoma with high mitotic index",
                PermissibleValue(text="Seminoma with high mitotic index") )
        setattr(cls, "Enteropathy associated T-cell lymphoma",
                PermissibleValue(text="Enteropathy associated T-cell lymphoma") )
        setattr(cls, "Anaplastic pleomorphic xanthroastrocytoma",
                PermissibleValue(text="Anaplastic pleomorphic xanthroastrocytoma") )
        setattr(cls, "Thymoma, type B3, malignant",
                PermissibleValue(text="Thymoma, type B3, malignant") )
        setattr(cls, "Perifollicular fibroma",
                PermissibleValue(text="Perifollicular fibroma") )
        setattr(cls, "Meningeal melanoma",
                PermissibleValue(text="Meningeal melanoma") )
        setattr(cls, "Mixed acinar-endocrine carcinoma",
                PermissibleValue(text="Mixed acinar-endocrine carcinoma") )
        setattr(cls, "Noninfiltrating intracystic carcinoma",
                PermissibleValue(text="Noninfiltrating intracystic carcinoma") )
        setattr(cls, "B lymphoblastic leukemia/lymphoma with t(5;14)(q31;q32); IL3-IGH",
                PermissibleValue(text="B lymphoblastic leukemia/lymphoma with t(5;14)(q31;q32); IL3-IGH") )
        setattr(cls, "Carcinoma with osseous differentiation",
                PermissibleValue(text="Carcinoma with osseous differentiation") )
        setattr(cls, "Invasive hydatidiform mole",
                PermissibleValue(text="Invasive hydatidiform mole") )
        setattr(cls, "Monstrocellular sarcoma",
                PermissibleValue(text="Monstrocellular sarcoma") )
        setattr(cls, "Glandular intraepithelial neoplasia, low grade",
                PermissibleValue(text="Glandular intraepithelial neoplasia, low grade") )
        setattr(cls, "Linitis plastica",
                PermissibleValue(text="Linitis plastica") )
        setattr(cls, "Refractory anemia without sideroblasts",
                PermissibleValue(text="Refractory anemia without sideroblasts") )
        setattr(cls, "Malignant peripheral nerve sheath tumor",
                PermissibleValue(text="Malignant peripheral nerve sheath tumor") )
        setattr(cls, "Embryonal teratoma",
                PermissibleValue(text="Embryonal teratoma") )
        setattr(cls, "Trabecular adenoma",
                PermissibleValue(text="Trabecular adenoma") )
        setattr(cls, "Giant cell tumor of soft parts, NOS",
                PermissibleValue(text="Giant cell tumor of soft parts, NOS") )
        setattr(cls, "Fibrous mesothelioma, benign",
                PermissibleValue(text="Fibrous mesothelioma, benign") )
        setattr(cls, "Rhabdomyosarcoma, NOS",
                PermissibleValue(text="Rhabdomyosarcoma, NOS") )
        setattr(cls, "Histiocytic medullary reticulosis",
                PermissibleValue(text="Histiocytic medullary reticulosis") )
        setattr(cls, "Plasmacytoma, NOS",
                PermissibleValue(text="Plasmacytoma, NOS") )
        setattr(cls, "Cystadenocarcinoma, NOS",
                PermissibleValue(text="Cystadenocarcinoma, NOS") )
        setattr(cls, "Immunoproliferative disease, NOS",
                PermissibleValue(text="Immunoproliferative disease, NOS") )
        setattr(cls, "Hepatocellular carcinoma, pleomorphic type",
                PermissibleValue(text="Hepatocellular carcinoma, pleomorphic type") )
        setattr(cls, "Low-grade intramedullary osteosarcoma",
                PermissibleValue(text="Low-grade intramedullary osteosarcoma") )
        setattr(cls, "Papillary adenocarcinoma, follicular variant",
                PermissibleValue(text="Papillary adenocarcinoma, follicular variant") )
        setattr(cls, "Solid pseudopapillary carcinoma",
                PermissibleValue(text="Solid pseudopapillary carcinoma") )
        setattr(cls, "Plasma cell tumor",
                PermissibleValue(text="Plasma cell tumor") )
        setattr(cls, "Solitary myeloma",
                PermissibleValue(text="Solitary myeloma") )
        setattr(cls, "Acute non-lymphocytic leukemia",
                PermissibleValue(text="Acute non-lymphocytic leukemia") )
        setattr(cls, "Hairy cell leukemia variant",
                PermissibleValue(text="Hairy cell leukemia variant") )
        setattr(cls, "Adenocarcinoma in situ, mucinous",
                PermissibleValue(text="Adenocarcinoma in situ, mucinous",
                                 description="Mucinous Lung Adenocarcinoma In Situ") )
        setattr(cls, "Adenocarcinoma with cartilaginous and osseous metaplasia",
                PermissibleValue(text="Adenocarcinoma with cartilaginous and osseous metaplasia") )
        setattr(cls, "Anaplastic large cell lymphoma, CD30+",
                PermissibleValue(text="Anaplastic large cell lymphoma, CD30+") )
        setattr(cls, "Mucinous cystadenoma, NOS",
                PermissibleValue(text="Mucinous cystadenoma, NOS") )
        setattr(cls, "Gastrointestinal stromal sarcoma",
                PermissibleValue(text="Gastrointestinal stromal sarcoma") )
        setattr(cls, "Precancerous melanosis, NOS",
                PermissibleValue(text="Precancerous melanosis, NOS") )
        setattr(cls, "Renal medullary carcinoma",
                PermissibleValue(text="Renal medullary carcinoma",
                                 description="Kidney Medullary Carcinoma") )
        setattr(cls, "Serous papillary cystic tumor of borderline malignancy",
                PermissibleValue(text="Serous papillary cystic tumor of borderline malignancy") )
        setattr(cls, "Bile duct carcinoma",
                PermissibleValue(text="Bile duct carcinoma") )
        setattr(cls, "Intraductal papillary neoplasm with high grade intraepithelial neoplasia",
                PermissibleValue(text="Intraductal papillary neoplasm with high grade intraepithelial neoplasia") )
        setattr(cls, "Clear cell chondrosarcoma",
                PermissibleValue(text="Clear cell chondrosarcoma") )
        setattr(cls, "Acute myelocytic leukemia",
                PermissibleValue(text="Acute myelocytic leukemia") )
        setattr(cls, "Noninvasive pancreatobiliary papillary neoplasm with high grade dysplasia",
                PermissibleValue(text="Noninvasive pancreatobiliary papillary neoplasm with high grade dysplasia") )
        setattr(cls, "Lymphoma, NOS",
                PermissibleValue(text="Lymphoma, NOS") )
        setattr(cls, "Mixed glioma",
                PermissibleValue(text="Mixed glioma") )
        setattr(cls, "Lymphoepithelial carcinoma",
                PermissibleValue(text="Lymphoepithelial carcinoma",
                                 description="Nasopharyngeal Type Undifferentiated Carcinoma") )
        setattr(cls, "Intraepidermal epithelioma of Jadassohn",
                PermissibleValue(text="Intraepidermal epithelioma of Jadassohn") )
        setattr(cls, "Pleuropulmonary blastoma",
                PermissibleValue(text="Pleuropulmonary blastoma") )
        setattr(cls, "Carcinoid, NOS, of appendix",
                PermissibleValue(text="Carcinoid, NOS, of appendix") )
        setattr(cls, "Diffuse midline glioma, H3 K27M-mutant",
                PermissibleValue(text="Diffuse midline glioma, H3 K27M-mutant") )
        setattr(cls, "Osteosarcoma, NOS",
                PermissibleValue(text="Osteosarcoma, NOS") )
        setattr(cls, "Neurilemoma, malignant",
                PermissibleValue(text="Neurilemoma, malignant") )
        setattr(cls, "Collecting duct carcinoma",
                PermissibleValue(text="Collecting duct carcinoma",
                                 description="Carcinoma of the Collecting Ducts of Bellini") )
        setattr(cls, "Undifferentiated spindle cell sarcoma",
                PermissibleValue(text="Undifferentiated spindle cell sarcoma") )
        setattr(cls, "Papillary mucinous cystadenocarcinoma",
                PermissibleValue(text="Papillary mucinous cystadenocarcinoma") )
        setattr(cls, "PIN III",
                PermissibleValue(text="PIN III") )
        setattr(cls, "Paraganglioma, NOS",
                PermissibleValue(text="Paraganglioma, NOS") )
        setattr(cls, "Protoplasmic astrocytoma",
                PermissibleValue(text="Protoplasmic astrocytoma") )
        setattr(cls, "Bile duct adenoma",
                PermissibleValue(text="Bile duct adenoma") )
        setattr(cls, "Squamous cell carcinoma, metastatic, NOS",
                PermissibleValue(text="Squamous cell carcinoma, metastatic, NOS") )
        setattr(cls, "Neurilemoma, NOS",
                PermissibleValue(text="Neurilemoma, NOS") )
        setattr(cls, "Odontogenic sarcoma",
                PermissibleValue(text="Odontogenic sarcoma") )
        setattr(cls, "Atypical carcinoid tumor",
                PermissibleValue(text="Atypical carcinoid tumor") )
        setattr(cls, "ALK positive large B-cell lymphoma",
                PermissibleValue(text="ALK positive large B-cell lymphoma") )
        setattr(cls, "Superficial well differentiated liposarcoma",
                PermissibleValue(text="Superficial well differentiated liposarcoma") )
        setattr(cls, "Klatskin tumor",
                PermissibleValue(text="Klatskin tumor") )
        setattr(cls, "Pleomorphic liposarcoma",
                PermissibleValue(text="Pleomorphic liposarcoma") )
        setattr(cls, "Soft tissue perineurioma",
                PermissibleValue(text="Soft tissue perineurioma") )
        setattr(cls, "Follicular carcinoma, well differentiated",
                PermissibleValue(text="Follicular carcinoma, well differentiated") )
        setattr(cls, "Combined/mixed carcinoid and adenocarcinoma",
                PermissibleValue(text="Combined/mixed carcinoid and adenocarcinoma") )
        setattr(cls, "Endometrioid cystadenoma, NOS",
                PermissibleValue(text="Endometrioid cystadenoma, NOS") )
        setattr(cls, "Transient abnormal myelopoiesis",
                PermissibleValue(text="Transient abnormal myelopoiesis") )
        setattr(cls, "Jugular paraganglioma",
                PermissibleValue(text="Jugular paraganglioma") )
        setattr(cls, "Papillary serous adenocarcinoma",
                PermissibleValue(text="Papillary serous adenocarcinoma") )
        setattr(cls, "Hepatocellular adenoma",
                PermissibleValue(text="Hepatocellular adenoma") )
        setattr(cls, "Congenital peribronchial myofibroblastic tumor",
                PermissibleValue(text="Congenital peribronchial myofibroblastic tumor") )
        setattr(cls, "Chronic granulocytic leukemia, Philadelphia chromosome (Ph1) positive",
                PermissibleValue(text="Chronic granulocytic leukemia, Philadelphia chromosome (Ph1) positive") )
        setattr(cls, "Melanocytoma, eyeball",
                PermissibleValue(text="Melanocytoma, eyeball") )
        setattr(cls, "Teratoma with malignant transformation",
                PermissibleValue(text="Teratoma with malignant transformation") )
        setattr(cls, "Paget disease, extramammary",
                PermissibleValue(text="Paget disease, extramammary") )
        setattr(cls, "Infiltrating basal cell carcinoma, NOS",
                PermissibleValue(text="Infiltrating basal cell carcinoma, NOS") )
        setattr(cls, "Leydig cell tumor, NOS",
                PermissibleValue(text="Leydig cell tumor, NOS") )
        setattr(cls, "Intraductal papillary-mucinous carcinoma, non-invasive",
                PermissibleValue(text="Intraductal papillary-mucinous carcinoma, non-invasive") )
        setattr(cls, "Basaloid squamous cell carcinoma",
                PermissibleValue(text="Basaloid squamous cell carcinoma",
                                 description="Basaloid Squamous Cell Carcinoma") )
        setattr(cls, "Atypical leiomyoma",
                PermissibleValue(text="Atypical leiomyoma") )
        setattr(cls, "Merkel cell tumor",
                PermissibleValue(text="Merkel cell tumor") )
        setattr(cls, "Mesonephroma, NOS",
                PermissibleValue(text="Mesonephroma, NOS") )
        setattr(cls, "Epithelioid cell melanoma",
                PermissibleValue(text="Epithelioid cell melanoma") )
        setattr(cls, "Mixed mesenchymal sarcoma",
                PermissibleValue(text="Mixed mesenchymal sarcoma") )
        setattr(cls, "Adenocarcinoma, metastatic, NOS",
                PermissibleValue(text="Adenocarcinoma, metastatic, NOS") )
        setattr(cls, "Malignant lymphoma, large B-cell, NOS",
                PermissibleValue(text="Malignant lymphoma, large B-cell, NOS") )
        setattr(cls, "Juxtacortical chondroma",
                PermissibleValue(text="Juxtacortical chondroma") )
        setattr(cls, "Midline carcinoma of children and young adults with NUT rearrangement",
                PermissibleValue(text="Midline carcinoma of children and young adults with NUT rearrangement") )
        setattr(cls, "Adrenal medullary paraganglioma, malignant",
                PermissibleValue(text="Adrenal medullary paraganglioma, malignant") )
        setattr(cls, "Florid osseous dysplasia",
                PermissibleValue(text="Florid osseous dysplasia") )
        setattr(cls, "VAIN III",
                PermissibleValue(text="VAIN III") )
        setattr(cls, "Splenic diffuse red pulp small B-cell lymphoma",
                PermissibleValue(text="Splenic diffuse red pulp small B-cell lymphoma") )
        setattr(cls, "Giant cell tumor of bone, NOS",
                PermissibleValue(text="Giant cell tumor of bone, NOS") )
        setattr(cls, "Insulinoma, malignant",
                PermissibleValue(text="Insulinoma, malignant") )
        setattr(cls, "Fibrous mesothelioma, malignant",
                PermissibleValue(text="Fibrous mesothelioma, malignant") )
        setattr(cls, "Traditional serrated adenoma",
                PermissibleValue(text="Traditional serrated adenoma") )
        setattr(cls, "Burkitt tumor",
                PermissibleValue(text="Burkitt tumor") )
        setattr(cls, "Acoustic neuroma",
                PermissibleValue(text="Acoustic neuroma") )
        setattr(cls, "Adenoid cystic carcinoma",
                PermissibleValue(text="Adenoid cystic carcinoma") )
        setattr(cls, "Acute lymphoblastic leukemia, NOS",
                PermissibleValue(text="Acute lymphoblastic leukemia, NOS") )
        setattr(cls, "Mature T ALL",
                PermissibleValue(text="Mature T ALL") )
        setattr(cls, "Medulloblastoma, group 4",
                PermissibleValue(text="Medulloblastoma, group 4") )
        setattr(cls, "Malignant lymphoma, small lymphocytic, diffuse",
                PermissibleValue(text="Malignant lymphoma, small lymphocytic, diffuse") )

class EnumCRDCHDiagnosisMorphology(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Diagnosis morphology
    """
    Unknown = PermissibleValue(text="Unknown")

    _defn = EnumDefinition(
        name="EnumCRDCHDiagnosisMorphology",
        description="Autogenerated Enumeration for CRDC-H Diagnosis morphology",
        code_set=None,
        code_set_version="2021-09-23T15:59:44.456566+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "9261/3",
                PermissibleValue(text="9261/3") )
        setattr(cls, "8814/3",
                PermissibleValue(text="8814/3") )
        setattr(cls, "9385/3",
                PermissibleValue(text="9385/3") )
        setattr(cls, "9662/3",
                PermissibleValue(text="9662/3") )
        setattr(cls, "9011/0",
                PermissibleValue(text="9011/0") )
        setattr(cls, "8824/0",
                PermissibleValue(text="8824/0") )
        setattr(cls, "8936/1",
                PermissibleValue(text="8936/1") )
        setattr(cls, "8503/0",
                PermissibleValue(text="8503/0") )
        setattr(cls, "9392/3",
                PermissibleValue(text="9392/3") )
        setattr(cls, "8500/2",
                PermissibleValue(text="8500/2") )
        setattr(cls, "8550/0",
                PermissibleValue(text="8550/0") )
        setattr(cls, "8072/3",
                PermissibleValue(text="8072/3") )
        setattr(cls, "9751/3",
                PermissibleValue(text="9751/3") )
        setattr(cls, "9762/3",
                PermissibleValue(text="9762/3") )
        setattr(cls, "8621/1",
                PermissibleValue(text="8621/1") )
        setattr(cls, "9492/0",
                PermissibleValue(text="9492/0") )
        setattr(cls, "9051/3",
                PermissibleValue(text="9051/3") )
        setattr(cls, "8346/3",
                PermissibleValue(text="8346/3") )
        setattr(cls, "8454/0",
                PermissibleValue(text="8454/0") )
        setattr(cls, "8522/3",
                PermissibleValue(text="8522/3") )
        setattr(cls, "8800/3",
                PermissibleValue(text="8800/3") )
        setattr(cls, "8631/3",
                PermissibleValue(text="8631/3") )
        setattr(cls, "8010/3",
                PermissibleValue(text="8010/3") )
        setattr(cls, "9045/3",
                PermissibleValue(text="9045/3") )
        setattr(cls, "8508/3",
                PermissibleValue(text="8508/3") )
        setattr(cls, "9891/3",
                PermissibleValue(text="9891/3") )
        setattr(cls, "8001/0",
                PermissibleValue(text="8001/0") )
        setattr(cls, "9054/0",
                PermissibleValue(text="9054/0") )
        setattr(cls, "8262/3",
                PermissibleValue(text="8262/3") )
        setattr(cls, "8780/3",
                PermissibleValue(text="8780/3") )
        setattr(cls, "8221/3",
                PermissibleValue(text="8221/3") )
        setattr(cls, "9120/3",
                PermissibleValue(text="9120/3") )
        setattr(cls, "8742/3",
                PermissibleValue(text="8742/3") )
        setattr(cls, "8240/1",
                PermissibleValue(text="8240/1") )
        setattr(cls, "8641/0",
                PermissibleValue(text="8641/0") )
        setattr(cls, "9477/3",
                PermissibleValue(text="9477/3") )
        setattr(cls, "9040/0",
                PermissibleValue(text="9040/0") )
        setattr(cls, "9560/1",
                PermissibleValue(text="9560/1") )
        setattr(cls, "9100/3",
                PermissibleValue(text="9100/3") )
        setattr(cls, "8880/0",
                PermissibleValue(text="8880/0") )
        setattr(cls, "8811/0",
                PermissibleValue(text="8811/0") )
        setattr(cls, "8251/0",
                PermissibleValue(text="8251/0") )
        setattr(cls, "9510/0",
                PermissibleValue(text="9510/0") )
        setattr(cls, "9150/3",
                PermissibleValue(text="9150/3") )
        setattr(cls, "9195/3",
                PermissibleValue(text="9195/3") )
        setattr(cls, "8264/0",
                PermissibleValue(text="8264/0") )
        setattr(cls, "9535/0",
                PermissibleValue(text="9535/0") )
        setattr(cls, "8770/0",
                PermissibleValue(text="8770/0") )
        setattr(cls, "8815/0",
                PermissibleValue(text="8815/0") )
        setattr(cls, "8330/0",
                PermissibleValue(text="8330/0") )
        setattr(cls, "9200/1",
                PermissibleValue(text="9200/1") )
        setattr(cls, "9700/3",
                PermissibleValue(text="9700/3") )
        setattr(cls, "8602/0",
                PermissibleValue(text="8602/0") )
        setattr(cls, "8010/0",
                PermissibleValue(text="8010/0") )
        setattr(cls, "8481/3",
                PermissibleValue(text="8481/3") )
        setattr(cls, "8593/1",
                PermissibleValue(text="8593/1") )
        setattr(cls, "8890/1",
                PermissibleValue(text="8890/1") )
        setattr(cls, "9581/3",
                PermissibleValue(text="9581/3") )
        setattr(cls, "9684/3",
                PermissibleValue(text="9684/3") )
        setattr(cls, "9262/0",
                PermissibleValue(text="9262/0") )
        setattr(cls, "9650/3",
                PermissibleValue(text="9650/3") )
        setattr(cls, "8640/3",
                PermissibleValue(text="8640/3") )
        setattr(cls, "9540/0",
                PermissibleValue(text="9540/0") )
        setattr(cls, "9653/3",
                PermissibleValue(text="9653/3") )
        setattr(cls, "8096/0",
                PermissibleValue(text="8096/0") )
        setattr(cls, "8812/0",
                PermissibleValue(text="8812/0") )
        setattr(cls, "9665/3",
                PermissibleValue(text="9665/3") )
        setattr(cls, "8552/3",
                PermissibleValue(text="8552/3") )
        setattr(cls, "8322/3",
                PermissibleValue(text="8322/3") )
        setattr(cls, "9470/3",
                PermissibleValue(text="9470/3") )
        setattr(cls, "9471/3",
                PermissibleValue(text="9471/3") )
        setattr(cls, "8313/1",
                PermissibleValue(text="8313/1") )
        setattr(cls, "8140/2",
                PermissibleValue(text="8140/2") )
        setattr(cls, "9382/3",
                PermissibleValue(text="9382/3") )
        setattr(cls, "8760/0",
                PermissibleValue(text="8760/0") )
        setattr(cls, "8950/3",
                PermissibleValue(text="8950/3") )
        setattr(cls, "9815/3",
                PermissibleValue(text="9815/3") )
        setattr(cls, "9834/3",
                PermissibleValue(text="9834/3") )
        setattr(cls, "8121/0",
                PermissibleValue(text="8121/0") )
        setattr(cls, "9110/0",
                PermissibleValue(text="9110/0") )
        setattr(cls, "9727/3",
                PermissibleValue(text="9727/3") )
        setattr(cls, "8509/2",
                PermissibleValue(text="8509/2") )
        setattr(cls, "9876/3",
                PermissibleValue(text="9876/3") )
        setattr(cls, "8474/1",
                PermissibleValue(text="8474/1") )
        setattr(cls, "8472/1",
                PermissibleValue(text="8472/1") )
        setattr(cls, "8390/3",
                PermissibleValue(text="8390/3") )
        setattr(cls, "9836/3",
                PermissibleValue(text="9836/3") )
        setattr(cls, "9963/3",
                PermissibleValue(text="9963/3") )
        setattr(cls, "8246/3",
                PermissibleValue(text="8246/3") )
        setattr(cls, "9424/3",
                PermissibleValue(text="9424/3") )
        setattr(cls, "8824/1",
                PermissibleValue(text="8824/1") )
        setattr(cls, "8452/1",
                PermissibleValue(text="8452/1") )
        setattr(cls, "8102/0",
                PermissibleValue(text="8102/0") )
        setattr(cls, "8610/0",
                PermissibleValue(text="8610/0") )
        setattr(cls, "9230/3",
                PermissibleValue(text="9230/3") )
        setattr(cls, "9967/3",
                PermissibleValue(text="9967/3") )
        setattr(cls, "8857/0",
                PermissibleValue(text="8857/0") )
        setattr(cls, "9531/0",
                PermissibleValue(text="9531/0") )
        setattr(cls, "8410/3",
                PermissibleValue(text="8410/3") )
        setattr(cls, "8120/0",
                PermissibleValue(text="8120/0") )
        setattr(cls, "9475/3",
                PermissibleValue(text="9475/3") )
        setattr(cls, "8158/1",
                PermissibleValue(text="8158/1") )
        setattr(cls, "8990/1",
                PermissibleValue(text="8990/1") )
        setattr(cls, "9817/3",
                PermissibleValue(text="9817/3") )
        setattr(cls, "9170/0",
                PermissibleValue(text="9170/0") )
        setattr(cls, "9800/3",
                PermissibleValue(text="9800/3") )
        setattr(cls, "8140/1",
                PermissibleValue(text="8140/1") )
        setattr(cls, "8408/1",
                PermissibleValue(text="8408/1") )
        setattr(cls, "8981/3",
                PermissibleValue(text="8981/3") )
        setattr(cls, "9050/0",
                PermissibleValue(text="9050/0") )
        setattr(cls, "8215/3",
                PermissibleValue(text="8215/3") )
        setattr(cls, "8771/3",
                PermissibleValue(text="8771/3") )
        setattr(cls, "8771/0",
                PermissibleValue(text="8771/0") )
        setattr(cls, "8812/3",
                PermissibleValue(text="8812/3") )
        setattr(cls, "8524/3",
                PermissibleValue(text="8524/3") )
        setattr(cls, "9505/1",
                PermissibleValue(text="9505/1") )
        setattr(cls, "9063/3",
                PermissibleValue(text="9063/3") )
        setattr(cls, "9130/0",
                PermissibleValue(text="9130/0") )
        setattr(cls, "8146/0",
                PermissibleValue(text="8146/0") )
        setattr(cls, "9136/1",
                PermissibleValue(text="9136/1") )
        setattr(cls, "8090/1",
                PermissibleValue(text="8090/1") )
        setattr(cls, "8560/0",
                PermissibleValue(text="8560/0") )
        setattr(cls, "8530/3",
                PermissibleValue(text="8530/3") )
        setattr(cls, "8272/3",
                PermissibleValue(text="8272/3") )
        setattr(cls, "8580/1",
                PermissibleValue(text="8580/1") )
        setattr(cls, "9015/1",
                PermissibleValue(text="9015/1") )
        setattr(cls, "9808/3",
                PermissibleValue(text="9808/3") )
        setattr(cls, "9170/3",
                PermissibleValue(text="9170/3") )
        setattr(cls, "8034/3",
                PermissibleValue(text="8034/3") )
        setattr(cls, "9210/0",
                PermissibleValue(text="9210/0") )
        setattr(cls, "8010/9",
                PermissibleValue(text="8010/9") )
        setattr(cls, "8147/3",
                PermissibleValue(text="8147/3") )
        setattr(cls, "8630/1",
                PermissibleValue(text="8630/1") )
        setattr(cls, "8372/0",
                PermissibleValue(text="8372/0") )
        setattr(cls, "8762/1",
                PermissibleValue(text="8762/1") )
        setattr(cls, "8151/0",
                PermissibleValue(text="8151/0") )
        setattr(cls, "9712/3",
                PermissibleValue(text="9712/3") )
        setattr(cls, "9440/3",
                PermissibleValue(text="9440/3") )
        setattr(cls, "9816/3",
                PermissibleValue(text="9816/3") )
        setattr(cls, "8313/3",
                PermissibleValue(text="8313/3") )
        setattr(cls, "8583/1",
                PermissibleValue(text="8583/1") )
        setattr(cls, "9679/3",
                PermissibleValue(text="9679/3") )
        setattr(cls, "8149/0",
                PermissibleValue(text="8149/0") )
        setattr(cls, "9971/1",
                PermissibleValue(text="9971/1") )
        setattr(cls, "9870/3",
                PermissibleValue(text="9870/3") )
        setattr(cls, "8830/3",
                PermissibleValue(text="8830/3") )
        setattr(cls, "8152/1",
                PermissibleValue(text="8152/1") )
        setattr(cls, "8921/3",
                PermissibleValue(text="8921/3") )
        setattr(cls, "8761/1",
                PermissibleValue(text="8761/1") )
        setattr(cls, "9560/3",
                PermissibleValue(text="9560/3") )
        setattr(cls, "8728/1",
                PermissibleValue(text="8728/1") )
        setattr(cls, "8076/2",
                PermissibleValue(text="8076/2") )
        setattr(cls, "9872/3",
                PermissibleValue(text="9872/3") )
        setattr(cls, "8152/3",
                PermissibleValue(text="8152/3") )
        setattr(cls, "8032/3",
                PermissibleValue(text="8032/3") )
        setattr(cls, "8471/3",
                PermissibleValue(text="8471/3") )
        setattr(cls, "9270/3",
                PermissibleValue(text="9270/3") )
        setattr(cls, "8153/3",
                PermissibleValue(text="8153/3") )
        setattr(cls, "8895/3",
                PermissibleValue(text="8895/3") )
        setattr(cls, "8316/3",
                PermissibleValue(text="8316/3") )
        setattr(cls, "9065/3",
                PermissibleValue(text="9065/3") )
        setattr(cls, "8140/3",
                PermissibleValue(text="8140/3") )
        setattr(cls, "9950/3",
                PermissibleValue(text="9950/3") )
        setattr(cls, "8120/2",
                PermissibleValue(text="8120/2") )
        setattr(cls, "9015/3",
                PermissibleValue(text="9015/3") )
        setattr(cls, "9539/3",
                PermissibleValue(text="9539/3") )
        setattr(cls, "9480/3",
                PermissibleValue(text="9480/3") )
        setattr(cls, "9812/3",
                PermissibleValue(text="9812/3") )
        setattr(cls, "8741/3",
                PermissibleValue(text="8741/3") )
        setattr(cls, "8891/3",
                PermissibleValue(text="8891/3") )
        setattr(cls, "9874/3",
                PermissibleValue(text="9874/3") )
        setattr(cls, "9131/0",
                PermissibleValue(text="9131/0") )
        setattr(cls, "8261/3",
                PermissibleValue(text="8261/3") )
        setattr(cls, "9534/0",
                PermissibleValue(text="9534/0") )
        setattr(cls, "9971/3",
                PermissibleValue(text="9971/3") )
        setattr(cls, "9270/1",
                PermissibleValue(text="9270/1") )
        setattr(cls, "9562/0",
                PermissibleValue(text="9562/0") )
        setattr(cls, "8851/3",
                PermissibleValue(text="8851/3") )
        setattr(cls, "9130/1",
                PermissibleValue(text="9130/1") )
        setattr(cls, "8074/3",
                PermissibleValue(text="8074/3") )
        setattr(cls, "8101/0",
                PermissibleValue(text="8101/0") )
        setattr(cls, "8161/0",
                PermissibleValue(text="8161/0") )
        setattr(cls, "8586/3",
                PermissibleValue(text="8586/3") )
        setattr(cls, "8005/3",
                PermissibleValue(text="8005/3") )
        setattr(cls, "9220/3",
                PermissibleValue(text="9220/3") )
        setattr(cls, "8461/3",
                PermissibleValue(text="8461/3") )
        setattr(cls, "9741/3",
                PermissibleValue(text="9741/3") )
        setattr(cls, "9764/3",
                PermissibleValue(text="9764/3") )
        setattr(cls, "8250/2",
                PermissibleValue(text="8250/2") )
        setattr(cls, "9341/3",
                PermissibleValue(text="9341/3") )
        setattr(cls, "8144/3",
                PermissibleValue(text="8144/3") )
        setattr(cls, "8040/1",
                PermissibleValue(text="8040/1") )
        setattr(cls, "8073/3",
                PermissibleValue(text="8073/3") )
        setattr(cls, "9312/0",
                PermissibleValue(text="9312/0") )
        setattr(cls, "9533/0",
                PermissibleValue(text="9533/0") )
        setattr(cls, "8723/3",
                PermissibleValue(text="8723/3") )
        setattr(cls, "8901/3",
                PermissibleValue(text="8901/3") )
        setattr(cls, "9064/3",
                PermissibleValue(text="9064/3") )
        setattr(cls, "9521/3",
                PermissibleValue(text="9521/3") )
        setattr(cls, "8800/0",
                PermissibleValue(text="8800/0") )
        setattr(cls, "8201/3",
                PermissibleValue(text="8201/3") )
        setattr(cls, "8082/3",
                PermissibleValue(text="8082/3") )
        setattr(cls, "9984/3",
                PermissibleValue(text="9984/3") )
        setattr(cls, "8743/3",
                PermissibleValue(text="8743/3") )
        setattr(cls, "8790/0",
                PermissibleValue(text="8790/0") )
        setattr(cls, "8022/3",
                PermissibleValue(text="8022/3") )
        setattr(cls, "9507/0",
                PermissibleValue(text="9507/0") )
        setattr(cls, "8631/0",
                PermissibleValue(text="8631/0") )
        setattr(cls, "9411/3",
                PermissibleValue(text="9411/3") )
        setattr(cls, "9652/3",
                PermissibleValue(text="9652/3") )
        setattr(cls, "8936/3",
                PermissibleValue(text="8936/3") )
        setattr(cls, "8772/0",
                PermissibleValue(text="8772/0") )
        setattr(cls, "9814/3",
                PermissibleValue(text="9814/3") )
        setattr(cls, "8031/3",
                PermissibleValue(text="8031/3") )
        setattr(cls, "9813/3",
                PermissibleValue(text="9813/3") )
        setattr(cls, "9360/1",
                PermissibleValue(text="9360/1") )
        setattr(cls, "9137/3",
                PermissibleValue(text="9137/3") )
        setattr(cls, "9560/0",
                PermissibleValue(text="9560/0") )
        setattr(cls, "8334/0",
                PermissibleValue(text="8334/0") )
        setattr(cls, "9741/1",
                PermissibleValue(text="9741/1") )
        setattr(cls, "8711/3",
                PermissibleValue(text="8711/3") )
        setattr(cls, "9133/3",
                PermissibleValue(text="9133/3") )
        setattr(cls, "9100/0",
                PermissibleValue(text="9100/0") )
        setattr(cls, "8934/3",
                PermissibleValue(text="8934/3") )
        setattr(cls, "8170/3",
                PermissibleValue(text="8170/3") )
        setattr(cls, "8870/0",
                PermissibleValue(text="8870/0") )
        setattr(cls, "8162/3",
                PermissibleValue(text="8162/3") )
        setattr(cls, "8163/0",
                PermissibleValue(text="8163/0") )
        setattr(cls, "8480/1",
                PermissibleValue(text="8480/1") )
        setattr(cls, "8935/1",
                PermissibleValue(text="8935/1") )
        setattr(cls, "9920/3",
                PermissibleValue(text="9920/3") )
        setattr(cls, "8097/3",
                PermissibleValue(text="8097/3") )
        setattr(cls, "8633/1",
                PermissibleValue(text="8633/1") )
        setattr(cls, "9719/3",
                PermissibleValue(text="9719/3") )
        setattr(cls, "8720/2",
                PermissibleValue(text="8720/2") )
        setattr(cls, "8471/0",
                PermissibleValue(text="8471/0") )
        setattr(cls, "8263/3",
                PermissibleValue(text="8263/3") )
        setattr(cls, "8084/3",
                PermissibleValue(text="8084/3") )
        setattr(cls, "9384/1",
                PermissibleValue(text="9384/1") )
        setattr(cls, "8813/0",
                PermissibleValue(text="8813/0") )
        setattr(cls, "8070/33",
                PermissibleValue(text="8070/33") )
        setattr(cls, "8091/3",
                PermissibleValue(text="8091/3") )
        setattr(cls, "9381/3",
                PermissibleValue(text="9381/3") )
        setattr(cls, "9571/0",
                PermissibleValue(text="9571/0") )
        setattr(cls, "9930/3",
                PermissibleValue(text="9930/3") )
        setattr(cls, "8590/1",
                PermissibleValue(text="8590/1") )
        setattr(cls, "9508/3",
                PermissibleValue(text="9508/3") )
        setattr(cls, "8190/3",
                PermissibleValue(text="8190/3") )
        setattr(cls, "9512/3",
                PermissibleValue(text="9512/3") )
        setattr(cls, "9827/3",
                PermissibleValue(text="9827/3") )
        setattr(cls, "8190/0",
                PermissibleValue(text="8190/0") )
        setattr(cls, "8214/3",
                PermissibleValue(text="8214/3") )
        setattr(cls, "9702/3",
                PermissibleValue(text="9702/3") )
        setattr(cls, "8150/3",
                PermissibleValue(text="8150/3") )
        setattr(cls, "8280/3",
                PermissibleValue(text="8280/3") )
        setattr(cls, "9281/0",
                PermissibleValue(text="9281/0") )
        setattr(cls, "8860/0",
                PermissibleValue(text="8860/0") )
        setattr(cls, "9509/1",
                PermissibleValue(text="9509/1") )
        setattr(cls, "8340/3",
                PermissibleValue(text="8340/3") )
        setattr(cls, "9442/3",
                PermissibleValue(text="9442/3") )
        setattr(cls, "9175/0",
                PermissibleValue(text="9175/0") )
        setattr(cls, "9501/0",
                PermissibleValue(text="9501/0") )
        setattr(cls, "8951/3",
                PermissibleValue(text="8951/3") )
        setattr(cls, "9350/1",
                PermissibleValue(text="9350/1") )
        setattr(cls, "9818/3",
                PermissibleValue(text="9818/3") )
        setattr(cls, "8380/2",
                PermissibleValue(text="8380/2") )
        setattr(cls, "9090/3",
                PermissibleValue(text="9090/3") )
        setattr(cls, "9898/1",
                PermissibleValue(text="9898/1") )
        setattr(cls, "8413/3",
                PermissibleValue(text="8413/3") )
        setattr(cls, "9383/1",
                PermissibleValue(text="9383/1") )
        setattr(cls, "8825/3",
                PermissibleValue(text="8825/3") )
        setattr(cls, "9104/1",
                PermissibleValue(text="9104/1") )
        setattr(cls, "9241/0",
                PermissibleValue(text="9241/0") )
        setattr(cls, "8510/3",
                PermissibleValue(text="8510/3") )
        setattr(cls, "9840/3",
                PermissibleValue(text="9840/3") )
        setattr(cls, "8650/0",
                PermissibleValue(text="8650/0") )
        setattr(cls, "9873/3",
                PermissibleValue(text="9873/3") )
        setattr(cls, "8263/0",
                PermissibleValue(text="8263/0") )
        setattr(cls, "9961/3",
                PermissibleValue(text="9961/3") )
        setattr(cls, "9372/3",
                PermissibleValue(text="9372/3") )
        setattr(cls, "8902/3",
                PermissibleValue(text="8902/3") )
        setattr(cls, "8562/3",
                PermissibleValue(text="8562/3") )
        setattr(cls, "8830/0",
                PermissibleValue(text="8830/0") )
        setattr(cls, "8713/0",
                PermissibleValue(text="8713/0") )
        setattr(cls, "9580/3",
                PermissibleValue(text="9580/3") )
        setattr(cls, "9043/3",
                PermissibleValue(text="9043/3") )
        setattr(cls, "8834/1",
                PermissibleValue(text="8834/1") )
        setattr(cls, "8740/3",
                PermissibleValue(text="8740/3") )
        setattr(cls, "8221/0",
                PermissibleValue(text="8221/0") )
        setattr(cls, "9010/0",
                PermissibleValue(text="9010/0") )
        setattr(cls, "9731/3",
                PermissibleValue(text="9731/3") )
        setattr(cls, "8043/3",
                PermissibleValue(text="8043/3") )
        setattr(cls, "8071/3",
                PermissibleValue(text="8071/3") )
        setattr(cls, "8519/2",
                PermissibleValue(text="8519/2") )
        setattr(cls, "9085/3",
                PermissibleValue(text="9085/3") )
        setattr(cls, "9701/3",
                PermissibleValue(text="9701/3") )
        setattr(cls, "8967/0",
                PermissibleValue(text="8967/0") )
        setattr(cls, "9272/0",
                PermissibleValue(text="9272/0") )
        setattr(cls, "9080/1",
                PermissibleValue(text="9080/1") )
        setattr(cls, "9055/1",
                PermissibleValue(text="9055/1") )
        setattr(cls, "8581/1",
                PermissibleValue(text="8581/1") )
        setattr(cls, "9160/0",
                PermissibleValue(text="9160/0") )
        setattr(cls, "8408/0",
                PermissibleValue(text="8408/0") )
        setattr(cls, "8574/3",
                PermissibleValue(text="8574/3") )
        setattr(cls, "8904/0",
                PermissibleValue(text="8904/0") )
        setattr(cls, "9964/3",
                PermissibleValue(text="9964/3") )
        setattr(cls, "9120/0",
                PermissibleValue(text="9120/0") )
        setattr(cls, "8078/3",
                PermissibleValue(text="8078/3") )
        setattr(cls, "8620/3",
                PermissibleValue(text="8620/3") )
        setattr(cls, "8550/3",
                PermissibleValue(text="8550/3") )
        setattr(cls, "9172/0",
                PermissibleValue(text="9172/0") )
        setattr(cls, "8856/0",
                PermissibleValue(text="8856/0") )
        setattr(cls, "9960/3",
                PermissibleValue(text="9960/3") )
        setattr(cls, "8680/1",
                PermissibleValue(text="8680/1") )
        setattr(cls, "8011/3",
                PermissibleValue(text="8011/3") )
        setattr(cls, "9591/3",
                PermissibleValue(text="9591/3") )
        setattr(cls, "9511/3",
                PermissibleValue(text="9511/3") )
        setattr(cls, "9698/3",
                PermissibleValue(text="9698/3") )
        setattr(cls, "8092/3",
                PermissibleValue(text="8092/3") )
        setattr(cls, "8180/3",
                PermissibleValue(text="8180/3") )
        setattr(cls, "8332/3",
                PermissibleValue(text="8332/3") )
        setattr(cls, "9946/3",
                PermissibleValue(text="9946/3") )
        setattr(cls, "9991/3",
                PermissibleValue(text="9991/3") )
        setattr(cls, "8632/1",
                PermissibleValue(text="8632/1") )
        setattr(cls, "9393/3",
                PermissibleValue(text="9393/3") )
        setattr(cls, "9490/0",
                PermissibleValue(text="9490/0") )
        setattr(cls, "8210/0",
                PermissibleValue(text="8210/0") )
        setattr(cls, "9184/3",
                PermissibleValue(text="9184/3") )
        setattr(cls, "9561/3",
                PermissibleValue(text="9561/3") )
        setattr(cls, "8746/3",
                PermissibleValue(text="8746/3") )
        setattr(cls, "9444/1",
                PermissibleValue(text="9444/1") )
        setattr(cls, "9766/1",
                PermissibleValue(text="9766/1") )
        setattr(cls, "9390/3",
                PermissibleValue(text="9390/3") )
        setattr(cls, "8317/3",
                PermissibleValue(text="8317/3") )
        setattr(cls, "8842/0",
                PermissibleValue(text="8842/0") )
        setattr(cls, "9390/1",
                PermissibleValue(text="9390/1") )
        setattr(cls, "9070/3",
                PermissibleValue(text="9070/3") )
        setattr(cls, "8211/0",
                PermissibleValue(text="8211/0") )
        setattr(cls, "9361/1",
                PermissibleValue(text="9361/1") )
        setattr(cls, "8742/2",
                PermissibleValue(text="8742/2") )
        setattr(cls, "8509/3",
                PermissibleValue(text="8509/3") )
        setattr(cls, "9250/3",
                PermissibleValue(text="9250/3") )
        setattr(cls, "8750/0",
                PermissibleValue(text="8750/0") )
        setattr(cls, "9013/0",
                PermissibleValue(text="9013/0") )
        setattr(cls, "8242/1",
                PermissibleValue(text="8242/1") )
        setattr(cls, "8220/3",
                PermissibleValue(text="8220/3") )
        setattr(cls, "9678/3",
                PermissibleValue(text="9678/3") )
        setattr(cls, "8124/3",
                PermissibleValue(text="8124/3") )
        setattr(cls, "9726/3",
                PermissibleValue(text="9726/3") )
        setattr(cls, "8935/3",
                PermissibleValue(text="8935/3") )
        setattr(cls, "8521/1",
                PermissibleValue(text="8521/1") )
        setattr(cls, "9194/3",
                PermissibleValue(text="9194/3") )
        setattr(cls, "8982/0",
                PermissibleValue(text="8982/0") )
        setattr(cls, "9689/3",
                PermissibleValue(text="9689/3") )
        setattr(cls, "8290/3",
                PermissibleValue(text="8290/3") )
        setattr(cls, "8381/1",
                PermissibleValue(text="8381/1") )
        setattr(cls, "8634/3",
                PermissibleValue(text="8634/3") )
        setattr(cls, "9965/3",
                PermissibleValue(text="9965/3") )
        setattr(cls, "8250/3",
                PermissibleValue(text="8250/3") )
        setattr(cls, "8373/0",
                PermissibleValue(text="8373/0") )
        setattr(cls, "8015/3",
                PermissibleValue(text="8015/3") )
        setattr(cls, "8370/1",
                PermissibleValue(text="8370/1") )
        setattr(cls, "8260/0",
                PermissibleValue(text="8260/0") )
        setattr(cls, "9080/3",
                PermissibleValue(text="9080/3") )
        setattr(cls, "9875/3",
                PermissibleValue(text="9875/3") )
        setattr(cls, "9752/1",
                PermissibleValue(text="9752/1") )
        setattr(cls, "8339/3",
                PermissibleValue(text="8339/3") )
        setattr(cls, "8523/3",
                PermissibleValue(text="8523/3") )
        setattr(cls, "9542/3",
                PermissibleValue(text="9542/3") )
        setattr(cls, "8035/3",
                PermissibleValue(text="8035/3") )
        setattr(cls, "8900/0",
                PermissibleValue(text="8900/0") )
        setattr(cls, "8347/3",
                PermissibleValue(text="8347/3") )
        setattr(cls, "8855/3",
                PermissibleValue(text="8855/3") )
        setattr(cls, "8330/3",
                PermissibleValue(text="8330/3") )
        setattr(cls, "9301/0",
                PermissibleValue(text="9301/0") )
        setattr(cls, "8404/0",
                PermissibleValue(text="8404/0") )
        setattr(cls, "8200/3",
                PermissibleValue(text="8200/3") )
        setattr(cls, "9831/3",
                PermissibleValue(text="9831/3") )
        setattr(cls, "8143/3",
                PermissibleValue(text="8143/3") )
        setattr(cls, "9280/0",
                PermissibleValue(text="9280/0") )
        setattr(cls, "9451/3",
                PermissibleValue(text="9451/3") )
        setattr(cls, "8542/3",
                PermissibleValue(text="8542/3") )
        setattr(cls, "9101/3",
                PermissibleValue(text="9101/3") )
        setattr(cls, "8120/1",
                PermissibleValue(text="8120/1") )
        setattr(cls, "8210/2",
                PermissibleValue(text="8210/2") )
        setattr(cls, "8833/3",
                PermissibleValue(text="8833/3") )
        setattr(cls, "9522/3",
                PermissibleValue(text="9522/3") )
        setattr(cls, "8408/3",
                PermissibleValue(text="8408/3") )
        setattr(cls, "9124/3",
                PermissibleValue(text="9124/3") )
        setattr(cls, "9193/3",
                PermissibleValue(text="9193/3") )
        setattr(cls, "8601/0",
                PermissibleValue(text="8601/0") )
        setattr(cls, "9690/3",
                PermissibleValue(text="9690/3") )
        setattr(cls, "9910/3",
                PermissibleValue(text="9910/3") )
        setattr(cls, "9737/3",
                PermissibleValue(text="9737/3") )
        setattr(cls, "8300/3",
                PermissibleValue(text="8300/3") )
        setattr(cls, "8343/2",
                PermissibleValue(text="8343/2") )
        setattr(cls, "9180/3",
                PermissibleValue(text="9180/3") )
        setattr(cls, "8103/0",
                PermissibleValue(text="8103/0") )
        setattr(cls, "9396/3",
                PermissibleValue(text="9396/3") )
        setattr(cls, "8086/3",
                PermissibleValue(text="8086/3") )
        setattr(cls, "8774/3",
                PermissibleValue(text="8774/3") )
        setattr(cls, "9251/3",
                PermissibleValue(text="9251/3") )
        setattr(cls, "8600/0",
                PermissibleValue(text="8600/0") )
        setattr(cls, "9431/1",
                PermissibleValue(text="9431/1") )
        setattr(cls, "8245/1",
                PermissibleValue(text="8245/1") )
        setattr(cls, "9330/3",
                PermissibleValue(text="9330/3") )
        setattr(cls, "8102/3",
                PermissibleValue(text="8102/3") )
        setattr(cls, "8249/3",
                PermissibleValue(text="8249/3") )
        setattr(cls, "8148/2",
                PermissibleValue(text="8148/2") )
        setattr(cls, "8315/3",
                PermissibleValue(text="8315/3") )
        setattr(cls, "8441/3",
                PermissibleValue(text="8441/3") )
        setattr(cls, "9150/0",
                PermissibleValue(text="9150/0") )
        setattr(cls, "9042/3",
                PermissibleValue(text="9042/3") )
        setattr(cls, "8861/0",
                PermissibleValue(text="8861/0") )
        setattr(cls, "8522/2",
                PermissibleValue(text="8522/2") )
        setattr(cls, "8375/0",
                PermissibleValue(text="8375/0") )
        setattr(cls, "9130/3",
                PermissibleValue(text="9130/3") )
        setattr(cls, "8000/1",
                PermissibleValue(text="8000/1") )
        setattr(cls, "9182/3",
                PermissibleValue(text="9182/3") )
        setattr(cls, "8000/3",
                PermissibleValue(text="8000/3") )
        setattr(cls, "8010/2",
                PermissibleValue(text="8010/2") )
        setattr(cls, "8504/2",
                PermissibleValue(text="8504/2") )
        setattr(cls, "8172/3",
                PermissibleValue(text="8172/3") )
        setattr(cls, "9699/3",
                PermissibleValue(text="9699/3") )
        setattr(cls, "9537/0",
                PermissibleValue(text="9537/0") )
        setattr(cls, "8841/1",
                PermissibleValue(text="8841/1") )
        setattr(cls, "9103/0",
                PermissibleValue(text="9103/0") )
        setattr(cls, "8013/3",
                PermissibleValue(text="8013/3") )
        setattr(cls, "8083/3",
                PermissibleValue(text="8083/3") )
        setattr(cls, "8371/0",
                PermissibleValue(text="8371/0") )
        setattr(cls, "9020/1",
                PermissibleValue(text="9020/1") )
        setattr(cls, "9423/3",
                PermissibleValue(text="9423/3") )
        setattr(cls, "8342/3",
                PermissibleValue(text="8342/3") )
        setattr(cls, "8337/3",
                PermissibleValue(text="8337/3") )
        setattr(cls, "8525/3",
                PermissibleValue(text="8525/3") )
        setattr(cls, "9072/3",
                PermissibleValue(text="9072/3") )
        setattr(cls, "8936/0",
                PermissibleValue(text="8936/0") )
        setattr(cls, "8319/3",
                PermissibleValue(text="8319/3") )
        setattr(cls, "8120/3",
                PermissibleValue(text="8120/3") )
        setattr(cls, "9897/3",
                PermissibleValue(text="9897/3") )
        setattr(cls, "8910/3",
                PermissibleValue(text="8910/3") )
        setattr(cls, "9671/3",
                PermissibleValue(text="9671/3") )
        setattr(cls, "9073/1",
                PermissibleValue(text="9073/1") )
        setattr(cls, "8244/3",
                PermissibleValue(text="8244/3") )
        setattr(cls, "8160/0",
                PermissibleValue(text="8160/0") )
        setattr(cls, "9330/0",
                PermissibleValue(text="9330/0") )
        setattr(cls, "8050/0",
                PermissibleValue(text="8050/0") )
        setattr(cls, "9735/3",
                PermissibleValue(text="9735/3") )
        setattr(cls, "8980/3",
                PermissibleValue(text="8980/3") )
        setattr(cls, "8442/1",
                PermissibleValue(text="8442/1") )
        setattr(cls, "9181/3",
                PermissibleValue(text="9181/3") )
        setattr(cls, "8154/3",
                PermissibleValue(text="8154/3") )
        setattr(cls, "9105/3",
                PermissibleValue(text="9105/3") )
        setattr(cls, "9962/3",
                PermissibleValue(text="9962/3") )
        setattr(cls, "8972/3",
                PermissibleValue(text="8972/3") )
        setattr(cls, "8080/2",
                PermissibleValue(text="8080/2") )
        setattr(cls, "8321/0",
                PermissibleValue(text="8321/0") )
        setattr(cls, "9724/3",
                PermissibleValue(text="9724/3") )
        setattr(cls, "8896/3",
                PermissibleValue(text="8896/3") )
        setattr(cls, "8070/6",
                PermissibleValue(text="8070/6") )
        setattr(cls, "8090/3",
                PermissibleValue(text="8090/3") )
        setattr(cls, "8130/2",
                PermissibleValue(text="8130/2") )
        setattr(cls, "8854/0",
                PermissibleValue(text="8854/0") )
        setattr(cls, "9945/3",
                PermissibleValue(text="9945/3") )
        setattr(cls, "8932/0",
                PermissibleValue(text="8932/0") )
        setattr(cls, "8966/0",
                PermissibleValue(text="8966/0") )
        setattr(cls, "9364/3",
                PermissibleValue(text="9364/3") )
        setattr(cls, "9740/1",
                PermissibleValue(text="9740/1") )
        setattr(cls, "9680/3",
                PermissibleValue(text="9680/3") )
        setattr(cls, "8156/3",
                PermissibleValue(text="8156/3") )
        setattr(cls, "9341/1",
                PermissibleValue(text="9341/1") )
        setattr(cls, "8990/3",
                PermissibleValue(text="8990/3") )
        setattr(cls, "8589/3",
                PermissibleValue(text="8589/3") )
        setattr(cls, "8631/1",
                PermissibleValue(text="8631/1") )
        setattr(cls, "8248/1",
                PermissibleValue(text="8248/1") )
        setattr(cls, "8801/3",
                PermissibleValue(text="8801/3") )
        setattr(cls, "8891/0",
                PermissibleValue(text="8891/0") )
        setattr(cls, "9015/0",
                PermissibleValue(text="9015/0") )
        setattr(cls, "8310/0",
                PermissibleValue(text="8310/0") )
        setattr(cls, "9121/0",
                PermissibleValue(text="9121/0") )
        setattr(cls, "8420/0",
                PermissibleValue(text="8420/0") )
        setattr(cls, "9135/1",
                PermissibleValue(text="9135/1") )
        setattr(cls, "8374/0",
                PermissibleValue(text="8374/0") )
        setattr(cls, "8930/3",
                PermissibleValue(text="8930/3") )
        setattr(cls, "8241/3",
                PermissibleValue(text="8241/3") )
        setattr(cls, "8370/0",
                PermissibleValue(text="8370/0") )
        setattr(cls, "8245/3",
                PermissibleValue(text="8245/3") )
        setattr(cls, "8075/3",
                PermissibleValue(text="8075/3") )
        setattr(cls, "8551/3",
                PermissibleValue(text="8551/3") )
        setattr(cls, "9210/1",
                PermissibleValue(text="9210/1") )
        setattr(cls, "8825/0",
                PermissibleValue(text="8825/0") )
        setattr(cls, "9580/0",
                PermissibleValue(text="9580/0") )
        setattr(cls, "9290/0",
                PermissibleValue(text="9290/0") )
        setattr(cls, "9302/3",
                PermissibleValue(text="9302/3") )
        setattr(cls, "9000/0",
                PermissibleValue(text="9000/0") )
        setattr(cls, "8815/3",
                PermissibleValue(text="8815/3") )
        setattr(cls, "8000/6",
                PermissibleValue(text="8000/6") )
        setattr(cls, "8905/0",
                PermissibleValue(text="8905/0") )
        setattr(cls, "9705/3",
                PermissibleValue(text="9705/3") )
        setattr(cls, "9231/3",
                PermissibleValue(text="9231/3") )
        setattr(cls, "9240/3",
                PermissibleValue(text="9240/3") )
        setattr(cls, "8940/0",
                PermissibleValue(text="8940/0") )
        setattr(cls, "8520/2",
                PermissibleValue(text="8520/2") )
        setattr(cls, "9491/0",
                PermissibleValue(text="9491/0") )
        setattr(cls, "8345/3",
                PermissibleValue(text="8345/3") )
        setattr(cls, "8831/0",
                PermissibleValue(text="8831/0") )
        setattr(cls, "9012/0",
                PermissibleValue(text="9012/0") )
        setattr(cls, "9086/3",
                PermissibleValue(text="9086/3") )
        setattr(cls, "8982/3",
                PermissibleValue(text="8982/3") )
        setattr(cls, "8550/1",
                PermissibleValue(text="8550/1") )
        setattr(cls, "9663/3",
                PermissibleValue(text="9663/3") )
        setattr(cls, "9220/0",
                PermissibleValue(text="9220/0") )
        setattr(cls, "9755/3",
                PermissibleValue(text="9755/3") )
        setattr(cls, "8325/0",
                PermissibleValue(text="8325/0") )
        setattr(cls, "8512/3",
                PermissibleValue(text="8512/3") )
        setattr(cls, "9992/3",
                PermissibleValue(text="9992/3") )
        setattr(cls, "9425/3",
                PermissibleValue(text="9425/3") )
        setattr(cls, "8623/1",
                PermissibleValue(text="8623/1") )
        setattr(cls, "9050/3",
                PermissibleValue(text="9050/3") )
        setattr(cls, "9987/3",
                PermissibleValue(text="9987/3") )
        setattr(cls, "8650/1",
                PermissibleValue(text="8650/1") )
        setattr(cls, "8772/3",
                PermissibleValue(text="8772/3") )
        setattr(cls, "8173/3",
                PermissibleValue(text="8173/3") )
        setattr(cls, "9432/1",
                PermissibleValue(text="9432/1") )
        setattr(cls, "8650/3",
                PermissibleValue(text="8650/3") )
        setattr(cls, "8634/1",
                PermissibleValue(text="8634/1") )
        setattr(cls, "8441/2",
                PermissibleValue(text="8441/2") )
        setattr(cls, "9055/0",
                PermissibleValue(text="9055/0") )
        setattr(cls, "8402/0",
                PermissibleValue(text="8402/0") )
        setattr(cls, "9597/3",
                PermissibleValue(text="9597/3") )
        setattr(cls, "8683/0",
                PermissibleValue(text="8683/0") )
        setattr(cls, "8147/0",
                PermissibleValue(text="8147/0") )
        setattr(cls, "8990/0",
                PermissibleValue(text="8990/0") )
        setattr(cls, "8263/2",
                PermissibleValue(text="8263/2") )
        setattr(cls, "8430/1",
                PermissibleValue(text="8430/1") )
        setattr(cls, "8270/0",
                PermissibleValue(text="8270/0") )
        setattr(cls, "8730/0",
                PermissibleValue(text="8730/0") )
        setattr(cls, "8160/3",
                PermissibleValue(text="8160/3") )
        setattr(cls, "8728/3",
                PermissibleValue(text="8728/3") )
        setattr(cls, "8253/3",
                PermissibleValue(text="8253/3") )
        setattr(cls, "8482/3",
                PermissibleValue(text="8482/3") )
        setattr(cls, "9807/3",
                PermissibleValue(text="9807/3") )
        setattr(cls, "8281/3",
                PermissibleValue(text="8281/3") )
        setattr(cls, "9532/0",
                PermissibleValue(text="9532/0") )
        setattr(cls, "8440/3",
                PermissibleValue(text="8440/3") )
        setattr(cls, "8473/1",
                PermissibleValue(text="8473/1") )
        setattr(cls, "8964/3",
                PermissibleValue(text="8964/3") )
        setattr(cls, "8341/3",
                PermissibleValue(text="8341/3") )
        setattr(cls, "8070/2",
                PermissibleValue(text="8070/2") )
        setattr(cls, "9539/1",
                PermissibleValue(text="9539/1") )
        setattr(cls, "8543/3",
                PermissibleValue(text="8543/3") )
        setattr(cls, "9110/3",
                PermissibleValue(text="9110/3") )
        setattr(cls, "9530/3",
                PermissibleValue(text="9530/3") )
        setattr(cls, "8851/0",
                PermissibleValue(text="8851/0") )
        setattr(cls, "8594/1",
                PermissibleValue(text="8594/1") )
        setattr(cls, "8220/0",
                PermissibleValue(text="8220/0") )
        setattr(cls, "8254/3",
                PermissibleValue(text="8254/3") )
        setattr(cls, "9150/1",
                PermissibleValue(text="9150/1") )
        setattr(cls, "9867/3",
                PermissibleValue(text="9867/3") )
        setattr(cls, "9503/3",
                PermissibleValue(text="9503/3") )
        setattr(cls, "8974/1",
                PermissibleValue(text="8974/1") )
        setattr(cls, "8460/0",
                PermissibleValue(text="8460/0") )
        setattr(cls, "8858/3",
                PermissibleValue(text="8858/3") )
        setattr(cls, "8983/3",
                PermissibleValue(text="8983/3") )
        setattr(cls, "8350/3",
                PermissibleValue(text="8350/3") )
        setattr(cls, "8931/3",
                PermissibleValue(text="8931/3") )
        setattr(cls, "9174/0",
                PermissibleValue(text="9174/0") )
        setattr(cls, "8420/3",
                PermissibleValue(text="8420/3") )
        setattr(cls, "8014/3",
                PermissibleValue(text="8014/3") )
        setattr(cls, "9174/1",
                PermissibleValue(text="9174/1") )
        setattr(cls, "8403/0",
                PermissibleValue(text="8403/0") )
        setattr(cls, "8272/0",
                PermissibleValue(text="8272/0") )
        setattr(cls, "8001/3",
                PermissibleValue(text="8001/3") )
        setattr(cls, "9020/0",
                PermissibleValue(text="9020/0") )
        setattr(cls, "8142/3",
                PermissibleValue(text="8142/3") )
        setattr(cls, "8270/3",
                PermissibleValue(text="8270/3") )
        setattr(cls, "8261/2",
                PermissibleValue(text="8261/2") )
        setattr(cls, "8290/0",
                PermissibleValue(text="8290/0") )
        setattr(cls, "8042/3",
                PermissibleValue(text="8042/3") )
        setattr(cls, "8991/3",
                PermissibleValue(text="8991/3") )
        setattr(cls, "9582/0",
                PermissibleValue(text="9582/0") )
        setattr(cls, "9708/3",
                PermissibleValue(text="9708/3") )
        setattr(cls, "9758/3",
                PermissibleValue(text="9758/3") )
        setattr(cls, "9186/3",
                PermissibleValue(text="9186/3") )
        setattr(cls, "9391/3",
                PermissibleValue(text="9391/3") )
        setattr(cls, "8720/3",
                PermissibleValue(text="8720/3") )
        setattr(cls, "8409/3",
                PermissibleValue(text="8409/3") )
        setattr(cls, "8407/0",
                PermissibleValue(text="8407/0") )
        setattr(cls, "8050/2",
                PermissibleValue(text="8050/2") )
        setattr(cls, "8001/1",
                PermissibleValue(text="8001/1") )
        setattr(cls, "8155/3",
                PermissibleValue(text="8155/3") )
        setattr(cls, "8121/3",
                PermissibleValue(text="8121/3") )
        setattr(cls, "8210/3",
                PermissibleValue(text="8210/3") )
        setattr(cls, "8804/3",
                PermissibleValue(text="8804/3") )
        setattr(cls, "8728/0",
                PermissibleValue(text="8728/0") )
        setattr(cls, "8893/0",
                PermissibleValue(text="8893/0") )
        setattr(cls, "8862/0",
                PermissibleValue(text="8862/0") )
        setattr(cls, "8770/3",
                PermissibleValue(text="8770/3") )
        setattr(cls, "8894/0",
                PermissibleValue(text="8894/0") )
        setattr(cls, "9474/3",
                PermissibleValue(text="9474/3") )
        setattr(cls, "8585/3",
                PermissibleValue(text="8585/3") )
        setattr(cls, "9410/3",
                PermissibleValue(text="9410/3") )
        setattr(cls, "9753/1",
                PermissibleValue(text="9753/1") )
        setattr(cls, "8046/3",
                PermissibleValue(text="8046/3") )
        setattr(cls, "9342/3",
                PermissibleValue(text="9342/3") )
        setattr(cls, "9983/3",
                PermissibleValue(text="9983/3") )
        setattr(cls, "9673/3",
                PermissibleValue(text="9673/3") )
        setattr(cls, "9734/3",
                PermissibleValue(text="9734/3") )
        setattr(cls, "8453/3",
                PermissibleValue(text="8453/3") )
        setattr(cls, "8501/3",
                PermissibleValue(text="8501/3") )
        setattr(cls, "8504/0",
                PermissibleValue(text="8504/0") )
        setattr(cls, "9322/0",
                PermissibleValue(text="9322/0") )
        setattr(cls, "8451/1",
                PermissibleValue(text="8451/1") )
        setattr(cls, "8975/1",
                PermissibleValue(text="8975/1") )
        setattr(cls, "8453/2",
                PermissibleValue(text="8453/2") )
        setattr(cls, "9221/3",
                PermissibleValue(text="9221/3") )
        setattr(cls, "8382/3",
                PermissibleValue(text="8382/3") )
        setattr(cls, "8005/0",
                PermissibleValue(text="8005/0") )
        setattr(cls, "8503/3",
                PermissibleValue(text="8503/3") )
        setattr(cls, "8898/1",
                PermissibleValue(text="8898/1") )
        setattr(cls, "9014/1",
                PermissibleValue(text="9014/1") )
        setattr(cls, "9733/3",
                PermissibleValue(text="9733/3") )
        setattr(cls, "8150/0",
                PermissibleValue(text="8150/0") )
        setattr(cls, "9082/3",
                PermissibleValue(text="9082/3") )
        setattr(cls, "8231/3",
                PermissibleValue(text="8231/3") )
        setattr(cls, "8670/3",
                PermissibleValue(text="8670/3") )
        setattr(cls, "9866/3",
                PermissibleValue(text="9866/3") )
        setattr(cls, "8361/0",
                PermissibleValue(text="8361/0") )
        setattr(cls, "9161/1",
                PermissibleValue(text="9161/1") )
        setattr(cls, "9931/3",
                PermissibleValue(text="9931/3") )
        setattr(cls, "8963/3",
                PermissibleValue(text="8963/3") )
        setattr(cls, "9754/3",
                PermissibleValue(text="9754/3") )
        setattr(cls, "9090/0",
                PermissibleValue(text="9090/0") )
        setattr(cls, "8811/1",
                PermissibleValue(text="8811/1") )
        setattr(cls, "8744/3",
                PermissibleValue(text="8744/3") )
        setattr(cls, "9761/3",
                PermissibleValue(text="9761/3") )
        setattr(cls, "8081/2",
                PermissibleValue(text="8081/2") )
        setattr(cls, "8140/0",
                PermissibleValue(text="8140/0") )
        setattr(cls, "9275/0",
                PermissibleValue(text="9275/0") )
        setattr(cls, "9989/3",
                PermissibleValue(text="9989/3") )
        setattr(cls, "9321/0",
                PermissibleValue(text="9321/0") )
        setattr(cls, "8311/3",
                PermissibleValue(text="8311/3") )
        setattr(cls, "8174/3",
                PermissibleValue(text="8174/3") )
        setattr(cls, "8514/3",
                PermissibleValue(text="8514/3") )
        setattr(cls, "9132/0",
                PermissibleValue(text="9132/0") )
        setattr(cls, "8890/0",
                PermissibleValue(text="8890/0") )
        setattr(cls, "9052/0",
                PermissibleValue(text="9052/0") )
        setattr(cls, "9430/3",
                PermissibleValue(text="9430/3") )
        setattr(cls, "8591/1",
                PermissibleValue(text="8591/1") )
        setattr(cls, "8912/3",
                PermissibleValue(text="8912/3") )
        setattr(cls, "8392/0",
                PermissibleValue(text="8392/0") )
        setattr(cls, "8959/1",
                PermissibleValue(text="8959/1") )
        setattr(cls, "8592/1",
                PermissibleValue(text="8592/1") )
        setattr(cls, "8085/3",
                PermissibleValue(text="8085/3") )
        setattr(cls, "8010/6",
                PermissibleValue(text="8010/6") )
        setattr(cls, "8230/2",
                PermissibleValue(text="8230/2") )
        setattr(cls, "8191/0",
                PermissibleValue(text="8191/0") )
        setattr(cls, "9514/1",
                PermissibleValue(text="9514/1") )
        setattr(cls, "9040/3",
                PermissibleValue(text="9040/3") )
        setattr(cls, "8148/0",
                PermissibleValue(text="8148/0") )
        setattr(cls, "8585/1",
                PermissibleValue(text="8585/1") )
        setattr(cls, "8211/3",
                PermissibleValue(text="8211/3") )
        setattr(cls, "8773/3",
                PermissibleValue(text="8773/3") )
        setattr(cls, "8693/3",
                PermissibleValue(text="8693/3") )
        setattr(cls, "9801/3",
                PermissibleValue(text="9801/3") )
        setattr(cls, "9472/3",
                PermissibleValue(text="9472/3") )
        setattr(cls, "8740/0",
                PermissibleValue(text="8740/0") )
        setattr(cls, "8265/3",
                PermissibleValue(text="8265/3") )
        setattr(cls, "8247/3",
                PermissibleValue(text="8247/3") )
        setattr(cls, "8712/0",
                PermissibleValue(text="8712/0") )
        setattr(cls, "9729/3",
                PermissibleValue(text="9729/3") )
        setattr(cls, "9860/3",
                PermissibleValue(text="9860/3") )
        setattr(cls, "9185/3",
                PermissibleValue(text="9185/3") )
        setattr(cls, "9273/0",
                PermissibleValue(text="9273/0") )
        setattr(cls, "8003/3",
                PermissibleValue(text="8003/3") )
        setattr(cls, "9675/3",
                PermissibleValue(text="9675/3") )
        setattr(cls, "8400/0",
                PermissibleValue(text="8400/0") )
        setattr(cls, "8430/3",
                PermissibleValue(text="8430/3") )
        setattr(cls, "9062/3",
                PermissibleValue(text="9062/3") )
        setattr(cls, "8033/3",
                PermissibleValue(text="8033/3") )
        setattr(cls, "9505/3",
                PermissibleValue(text="9505/3") )
        setattr(cls, "9759/3",
                PermissibleValue(text="9759/3") )
        setattr(cls, "9282/0",
                PermissibleValue(text="9282/0") )
        setattr(cls, "8441/0",
                PermissibleValue(text="8441/0") )
        setattr(cls, "8660/0",
                PermissibleValue(text="8660/0") )
        setattr(cls, "8580/3",
                PermissibleValue(text="8580/3") )
        setattr(cls, "8381/3",
                PermissibleValue(text="8381/3") )
        setattr(cls, "8331/3",
                PermissibleValue(text="8331/3") )
        setattr(cls, "9016/0",
                PermissibleValue(text="9016/0") )
        setattr(cls, "9530/0",
                PermissibleValue(text="9530/0") )
        setattr(cls, "9751/1",
                PermissibleValue(text="9751/1") )
        setattr(cls, "9380/3",
                PermissibleValue(text="9380/3") )
        setattr(cls, "8200/0",
                PermissibleValue(text="8200/0") )
        setattr(cls, "8460/2",
                PermissibleValue(text="8460/2") )
        setattr(cls, "9460/3",
                PermissibleValue(text="9460/3") )
        setattr(cls, "9363/0",
                PermissibleValue(text="9363/0") )
        setattr(cls, "9183/3",
                PermissibleValue(text="9183/3") )
        setattr(cls, "9220/1",
                PermissibleValue(text="9220/1") )
        setattr(cls, "8310/3",
                PermissibleValue(text="8310/3") )
        setattr(cls, "9000/1",
                PermissibleValue(text="9000/1") )
        setattr(cls, "8443/0",
                PermissibleValue(text="8443/0") )
        setattr(cls, "8802/3",
                PermissibleValue(text="8802/3") )
        setattr(cls, "8810/1",
                PermissibleValue(text="8810/1") )
        setattr(cls, "8803/3",
                PermissibleValue(text="8803/3") )
        setattr(cls, "8252/3",
                PermissibleValue(text="8252/3") )
        setattr(cls, "8333/0",
                PermissibleValue(text="8333/0") )
        setattr(cls, "9805/3",
                PermissibleValue(text="9805/3") )
        setattr(cls, "9140/3",
                PermissibleValue(text="9140/3") )
        setattr(cls, "8507/3",
                PermissibleValue(text="8507/3") )
        setattr(cls, "8587/0",
                PermissibleValue(text="8587/0") )
        setattr(cls, "9192/3",
                PermissibleValue(text="9192/3") )
        setattr(cls, "8380/0",
                PermissibleValue(text="8380/0") )
        setattr(cls, "9000/3",
                PermissibleValue(text="9000/3") )
        setattr(cls, "8561/0",
                PermissibleValue(text="8561/0") )
        setattr(cls, "9980/3",
                PermissibleValue(text="9980/3") )
        setattr(cls, "8004/3",
                PermissibleValue(text="8004/3") )
        setattr(cls, "8271/0",
                PermissibleValue(text="8271/0") )
        setattr(cls, "9100/1",
                PermissibleValue(text="9100/1") )
        setattr(cls, "8281/0",
                PermissibleValue(text="8281/0") )
        setattr(cls, "8500/3",
                PermissibleValue(text="8500/3") )
        setattr(cls, "9806/3",
                PermissibleValue(text="9806/3") )
        setattr(cls, "9664/3",
                PermissibleValue(text="9664/3") )
        setattr(cls, "8722/0",
                PermissibleValue(text="8722/0") )
        setattr(cls, "8343/3",
                PermissibleValue(text="8343/3") )
        setattr(cls, "9718/3",
                PermissibleValue(text="9718/3") )
        setattr(cls, "8741/2",
                PermissibleValue(text="8741/2") )
        setattr(cls, "8903/0",
                PermissibleValue(text="8903/0") )
        setattr(cls, "8401/3",
                PermissibleValue(text="8401/3") )
        setattr(cls, "8761/0",
                PermissibleValue(text="8761/0") )
        setattr(cls, "8854/3",
                PermissibleValue(text="8854/3") )
        setattr(cls, "8444/1",
                PermissibleValue(text="8444/1") )
        setattr(cls, "8021/3",
                PermissibleValue(text="8021/3") )
        setattr(cls, "8745/3",
                PermissibleValue(text="8745/3") )
        setattr(cls, "8077/2",
                PermissibleValue(text="8077/2") )
        setattr(cls, "8098/3",
                PermissibleValue(text="8098/3") )
        setattr(cls, "9441/3",
                PermissibleValue(text="9441/3") )
        setattr(cls, "8030/3",
                PermissibleValue(text="8030/3") )
        setattr(cls, "8504/3",
                PermissibleValue(text="8504/3") )
        setattr(cls, "8140/33",
                PermissibleValue(text="8140/33") )
        setattr(cls, "8474/3",
                PermissibleValue(text="8474/3") )
        setattr(cls, "9071/3",
                PermissibleValue(text="9071/3") )
        setattr(cls, "8693/1",
                PermissibleValue(text="8693/1") )
        setattr(cls, "8857/3",
                PermissibleValue(text="8857/3") )
        setattr(cls, "8933/3",
                PermissibleValue(text="8933/3") )
        setattr(cls, "8314/3",
                PermissibleValue(text="8314/3") )
        setattr(cls, "8640/1",
                PermissibleValue(text="8640/1") )
        setattr(cls, "9896/3",
                PermissibleValue(text="9896/3") )
        setattr(cls, "9716/3",
                PermissibleValue(text="9716/3") )
        setattr(cls, "8204/0",
                PermissibleValue(text="8204/0") )
        setattr(cls, "9500/3",
                PermissibleValue(text="9500/3") )
        setattr(cls, "8940/3",
                PermissibleValue(text="8940/3") )
        setattr(cls, "8810/0",
                PermissibleValue(text="8810/0") )
        setattr(cls, "9080/0",
                PermissibleValue(text="9080/0") )
        setattr(cls, "9530/1",
                PermissibleValue(text="9530/1") )
        setattr(cls, "8095/3",
                PermissibleValue(text="8095/3") )
        setattr(cls, "8970/3",
                PermissibleValue(text="8970/3") )
        setattr(cls, "8895/0",
                PermissibleValue(text="8895/0") )
        setattr(cls, "8480/6",
                PermissibleValue(text="8480/6") )
        setattr(cls, "8682/1",
                PermissibleValue(text="8682/1") )
        setattr(cls, "8630/3",
                PermissibleValue(text="8630/3") )
        setattr(cls, "8462/1",
                PermissibleValue(text="8462/1") )
        setattr(cls, "8502/3",
                PermissibleValue(text="8502/3") )
        setattr(cls, "9661/3",
                PermissibleValue(text="9661/3") )
        setattr(cls, "8600/3",
                PermissibleValue(text="8600/3") )
        setattr(cls, "8960/3",
                PermissibleValue(text="8960/3") )
        setattr(cls, "8171/3",
                PermissibleValue(text="8171/3") )
        setattr(cls, "9811/3",
                PermissibleValue(text="9811/3") )
        setattr(cls, "9053/3",
                PermissibleValue(text="9053/3") )
        setattr(cls, "8201/2",
                PermissibleValue(text="8201/2") )
        setattr(cls, "8150/1",
                PermissibleValue(text="8150/1") )
        setattr(cls, "8826/0",
                PermissibleValue(text="8826/0") )
        setattr(cls, "8894/3",
                PermissibleValue(text="8894/3") )
        setattr(cls, "8460/3",
                PermissibleValue(text="8460/3") )
        setattr(cls, "8463/1",
                PermissibleValue(text="8463/1") )
        setattr(cls, "8450/3",
                PermissibleValue(text="8450/3") )
        setattr(cls, "9861/3",
                PermissibleValue(text="9861/3") )
        setattr(cls, "8727/0",
                PermissibleValue(text="8727/0") )
        setattr(cls, "8576/3",
                PermissibleValue(text="8576/3") )
        setattr(cls, "9493/0",
                PermissibleValue(text="9493/0") )
        setattr(cls, "9373/0",
                PermissibleValue(text="9373/0") )
        setattr(cls, "9898/3",
                PermissibleValue(text="9898/3") )
        setattr(cls, "9478/3",
                PermissibleValue(text="9478/3") )
        setattr(cls, "9948/3",
                PermissibleValue(text="9948/3") )
        setattr(cls, "8077/0",
                PermissibleValue(text="8077/0") )
        setattr(cls, "8041/3",
                PermissibleValue(text="8041/3") )
        setattr(cls, "9362/3",
                PermissibleValue(text="9362/3") )
        setattr(cls, "8324/0",
                PermissibleValue(text="8324/0") )
        setattr(cls, "9251/1",
                PermissibleValue(text="9251/1") )
        setattr(cls, "8575/3",
                PermissibleValue(text="8575/3") )
        setattr(cls, "9142/0",
                PermissibleValue(text="9142/0") )
        setattr(cls, "9667/3",
                PermissibleValue(text="9667/3") )
        setattr(cls, "8213/0",
                PermissibleValue(text="8213/0") )
        setattr(cls, "8023/3",
                PermissibleValue(text="8023/3") )
        setattr(cls, "8622/1",
                PermissibleValue(text="8622/1") )
        setattr(cls, "9051/0",
                PermissibleValue(text="9051/0") )
        setattr(cls, "8541/3",
                PermissibleValue(text="8541/3") )
        setattr(cls, "9571/3",
                PermissibleValue(text="9571/3") )
        setattr(cls, "8730/3",
                PermissibleValue(text="8730/3") )
        setattr(cls, "8333/3",
                PermissibleValue(text="8333/3") )
        setattr(cls, "9200/0",
                PermissibleValue(text="9200/0") )
        setattr(cls, "8155/1",
                PermissibleValue(text="8155/1") )
        setattr(cls, "8318/3",
                PermissibleValue(text="8318/3") )
        setattr(cls, "9395/3",
                PermissibleValue(text="9395/3") )
        setattr(cls, "8973/3",
                PermissibleValue(text="8973/3") )
        setattr(cls, "8825/1",
                PermissibleValue(text="8825/1") )
        setattr(cls, "8402/3",
                PermissibleValue(text="8402/3") )
        setattr(cls, "8960/1",
                PermissibleValue(text="8960/1") )
        setattr(cls, "9442/1",
                PermissibleValue(text="9442/1") )
        setattr(cls, "9401/3",
                PermissibleValue(text="9401/3") )
        setattr(cls, "9041/3",
                PermissibleValue(text="9041/3") )
        setattr(cls, "8409/0",
                PermissibleValue(text="8409/0") )
        setattr(cls, "9506/1",
                PermissibleValue(text="9506/1") )
        setattr(cls, "8520/3",
                PermissibleValue(text="8520/3") )
        setattr(cls, "8360/1",
                PermissibleValue(text="8360/1") )
        setattr(cls, "9550/0",
                PermissibleValue(text="9550/0") )
        setattr(cls, "8900/3",
                PermissibleValue(text="8900/3") )
        setattr(cls, "8920/3",
                PermissibleValue(text="8920/3") )
        setattr(cls, "8800/9",
                PermissibleValue(text="8800/9") )
        setattr(cls, "9252/3",
                PermissibleValue(text="9252/3") )
        setattr(cls, "8941/3",
                PermissibleValue(text="8941/3") )
        setattr(cls, "8850/3",
                PermissibleValue(text="8850/3") )
        setattr(cls, "9490/3",
                PermissibleValue(text="9490/3") )
        setattr(cls, "9371/3",
                PermissibleValue(text="9371/3") )
        setattr(cls, "8311/1",
                PermissibleValue(text="8311/1") )
        setattr(cls, "9365/3",
                PermissibleValue(text="9365/3") )
        setattr(cls, "8470/3",
                PermissibleValue(text="8470/3") )
        setattr(cls, "9320/0",
                PermissibleValue(text="9320/0") )
        setattr(cls, "9540/3",
                PermissibleValue(text="9540/3") )
        setattr(cls, "9695/3",
                PermissibleValue(text="9695/3") )
        setattr(cls, "8521/3",
                PermissibleValue(text="8521/3") )
        setattr(cls, "8470/0",
                PermissibleValue(text="8470/0") )
        setattr(cls, "8076/3",
                PermissibleValue(text="8076/3") )
        setattr(cls, "8140/6",
                PermissibleValue(text="8140/6") )
        setattr(cls, "8401/0",
                PermissibleValue(text="8401/0") )
        setattr(cls, "8093/3",
                PermissibleValue(text="8093/3") )
        setattr(cls, "8110/0",
                PermissibleValue(text="8110/0") )
        setattr(cls, "8461/0",
                PermissibleValue(text="8461/0") )
        setattr(cls, "9596/3",
                PermissibleValue(text="9596/3") )
        setattr(cls, "8161/3",
                PermissibleValue(text="8161/3") )
        setattr(cls, "9290/3",
                PermissibleValue(text="9290/3") )
        setattr(cls, "9260/3",
                PermissibleValue(text="9260/3") )
        setattr(cls, "9510/3",
                PermissibleValue(text="9510/3") )
        setattr(cls, "9445/3",
                PermissibleValue(text="9445/3") )
        setattr(cls, "8642/1",
                PermissibleValue(text="8642/1") )
        setattr(cls, "8725/0",
                PermissibleValue(text="8725/0") )
        setattr(cls, "8250/1",
                PermissibleValue(text="8250/1") )
        setattr(cls, "8130/3",
                PermissibleValue(text="8130/3") )
        setattr(cls, "8051/0",
                PermissibleValue(text="8051/0") )
        setattr(cls, "8041/34",
                PermissibleValue(text="8041/34") )
        setattr(cls, "8406/0",
                PermissibleValue(text="8406/0") )
        setattr(cls, "9413/0",
                PermissibleValue(text="9413/0") )
        setattr(cls, "8726/0",
                PermissibleValue(text="8726/0") )
        setattr(cls, "8722/3",
                PermissibleValue(text="8722/3") )
        setattr(cls, "8230/3",
                PermissibleValue(text="8230/3") )
        setattr(cls, "8313/0",
                PermissibleValue(text="8313/0") )
        setattr(cls, "8584/3",
                PermissibleValue(text="8584/3") )
        setattr(cls, "8832/3",
                PermissibleValue(text="8832/3") )
        setattr(cls, "8811/3",
                PermissibleValue(text="8811/3") )
        setattr(cls, "8390/0",
                PermissibleValue(text="8390/0") )
        setattr(cls, "8052/2",
                PermissibleValue(text="8052/2") )
        setattr(cls, "9310/0",
                PermissibleValue(text="9310/0") )
        setattr(cls, "9520/3",
                PermissibleValue(text="9520/3") )
        setattr(cls, "8050/3",
                PermissibleValue(text="8050/3") )
        setattr(cls, "8582/3",
                PermissibleValue(text="8582/3") )
        setattr(cls, "9270/0",
                PermissibleValue(text="9270/0") )
        setattr(cls, "8959/3",
                PermissibleValue(text="8959/3") )
        setattr(cls, "9570/0",
                PermissibleValue(text="9570/0") )
        setattr(cls, "8892/0",
                PermissibleValue(text="8892/0") )
        setattr(cls, "8850/1",
                PermissibleValue(text="8850/1") )
        setattr(cls, "8100/0",
                PermissibleValue(text="8100/0") )
        setattr(cls, "9659/3",
                PermissibleValue(text="9659/3") )
        setattr(cls, "8261/0",
                PermissibleValue(text="8261/0") )
        setattr(cls, "8391/0",
                PermissibleValue(text="8391/0") )
        setattr(cls, "8840/0",
                PermissibleValue(text="8840/0") )
        setattr(cls, "8711/0",
                PermissibleValue(text="8711/0") )
        setattr(cls, "9390/0",
                PermissibleValue(text="9390/0") )
        setattr(cls, "8852/0",
                PermissibleValue(text="8852/0") )
        setattr(cls, "9832/3",
                PermissibleValue(text="9832/3") )
        setattr(cls, "8151/3",
                PermissibleValue(text="8151/3") )
        setattr(cls, "8832/0",
                PermissibleValue(text="8832/0") )
        setattr(cls, "8971/3",
                PermissibleValue(text="8971/3") )
        setattr(cls, "8588/3",
                PermissibleValue(text="8588/3") )
        setattr(cls, "9060/3",
                PermissibleValue(text="9060/3") )
        setattr(cls, "8680/3",
                PermissibleValue(text="8680/3") )
        setattr(cls, "9728/3",
                PermissibleValue(text="9728/3") )
        setattr(cls, "8255/3",
                PermissibleValue(text="8255/3") )
        setattr(cls, "8822/1",
                PermissibleValue(text="8822/1") )
        setattr(cls, "9125/0",
                PermissibleValue(text="9125/0") )
        setattr(cls, "8580/0",
                PermissibleValue(text="8580/0") )
        setattr(cls, "8320/3",
                PermissibleValue(text="8320/3") )
        setattr(cls, "9687/3",
                PermissibleValue(text="9687/3") )
        setattr(cls, "8820/0",
                PermissibleValue(text="8820/0") )
        setattr(cls, "8721/3",
                PermissibleValue(text="8721/3") )
        setattr(cls, "9161/0",
                PermissibleValue(text="9161/0") )
        setattr(cls, "9102/3",
                PermissibleValue(text="9102/3") )
        setattr(cls, "9768/1",
                PermissibleValue(text="9768/1") )
        setattr(cls, "8450/0",
                PermissibleValue(text="8450/0") )
        setattr(cls, "9738/3",
                PermissibleValue(text="9738/3") )
        setattr(cls, "8582/1",
                PermissibleValue(text="8582/1") )
        setattr(cls, "8690/1",
                PermissibleValue(text="8690/1") )
        setattr(cls, "9654/3",
                PermissibleValue(text="9654/3") )
        setattr(cls, "8122/3",
                PermissibleValue(text="8122/3") )
        setattr(cls, "8060/0",
                PermissibleValue(text="8060/0") )
        setattr(cls, "9230/0",
                PermissibleValue(text="9230/0") )
        setattr(cls, "9740/3",
                PermissibleValue(text="9740/3") )
        setattr(cls, "8505/0",
                PermissibleValue(text="8505/0") )
        setattr(cls, "9986/3",
                PermissibleValue(text="9986/3") )
        setattr(cls, "8572/3",
                PermissibleValue(text="8572/3") )
        setattr(cls, "8045/3",
                PermissibleValue(text="8045/3") )
        setattr(cls, "9823/3",
                PermissibleValue(text="9823/3") )
        setattr(cls, "8827/1",
                PermissibleValue(text="8827/1") )
        setattr(cls, "9835/3",
                PermissibleValue(text="9835/3") )
        setattr(cls, "8583/3",
                PermissibleValue(text="8583/3") )
        setattr(cls, "9180/0",
                PermissibleValue(text="9180/0") )
        setattr(cls, "9966/3",
                PermissibleValue(text="9966/3") )
        setattr(cls, "8965/0",
                PermissibleValue(text="8965/0") )
        setattr(cls, "9473/3",
                PermissibleValue(text="9473/3") )
        setattr(cls, "8380/3",
                PermissibleValue(text="8380/3") )
        setattr(cls, "8810/3",
                PermissibleValue(text="8810/3") )
        setattr(cls, "8681/1",
                PermissibleValue(text="8681/1") )
        setattr(cls, "9863/3",
                PermissibleValue(text="9863/3") )
        setattr(cls, "8370/3",
                PermissibleValue(text="8370/3") )
        setattr(cls, "8821/1",
                PermissibleValue(text="8821/1") )
        setattr(cls, "9742/3",
                PermissibleValue(text="9742/3") )
        setattr(cls, "9310/3",
                PermissibleValue(text="9310/3") )
        setattr(cls, "9760/3",
                PermissibleValue(text="9760/3") )
        setattr(cls, "8691/1",
                PermissibleValue(text="8691/1") )
        setattr(cls, "8384/3",
                PermissibleValue(text="8384/3") )
        setattr(cls, "8983/0",
                PermissibleValue(text="8983/0") )
        setattr(cls, "9809/3",
                PermissibleValue(text="9809/3") )
        setattr(cls, "9191/0",
                PermissibleValue(text="9191/0") )
        setattr(cls, "9123/0",
                PermissibleValue(text="9123/0") )
        setattr(cls, "8153/1",
                PermissibleValue(text="8153/1") )
        setattr(cls, "8813/3",
                PermissibleValue(text="8813/3") )
        setattr(cls, "8881/0",
                PermissibleValue(text="8881/0") )
        setattr(cls, "9911/3",
                PermissibleValue(text="9911/3") )
        setattr(cls, "8012/3",
                PermissibleValue(text="8012/3") )
        setattr(cls, "9970/1",
                PermissibleValue(text="9970/1") )
        setattr(cls, "9083/3",
                PermissibleValue(text="9083/3") )
        setattr(cls, "8470/2",
                PermissibleValue(text="8470/2") )
        setattr(cls, "8700/3",
                PermissibleValue(text="8700/3") )
        setattr(cls, "8620/1",
                PermissibleValue(text="8620/1") )
        setattr(cls, "8312/3",
                PermissibleValue(text="8312/3") )
        setattr(cls, "9940/3",
                PermissibleValue(text="9940/3") )
        setattr(cls, "8145/3",
                PermissibleValue(text="8145/3") )
        setattr(cls, "8410/0",
                PermissibleValue(text="8410/0") )
        setattr(cls, "8507/2",
                PermissibleValue(text="8507/2") )
        setattr(cls, "8815/1",
                PermissibleValue(text="8815/1") )
        setattr(cls, "8052/0",
                PermissibleValue(text="8052/0") )
        setattr(cls, "8780/0",
                PermissibleValue(text="8780/0") )
        setattr(cls, "8257/3",
                PermissibleValue(text="8257/3") )
        setattr(cls, "8251/3",
                PermissibleValue(text="8251/3") )
        setattr(cls, "8403/3",
                PermissibleValue(text="8403/3") )
        setattr(cls, "8400/1",
                PermissibleValue(text="8400/1") )
        setattr(cls, "8336/0",
                PermissibleValue(text="8336/0") )
        setattr(cls, "9895/3",
                PermissibleValue(text="9895/3") )
        setattr(cls, "9871/3",
                PermissibleValue(text="9871/3") )
        setattr(cls, "8842/3",
                PermissibleValue(text="8842/3") )
        setattr(cls, "9865/3",
                PermissibleValue(text="9865/3") )
        setattr(cls, "9502/0",
                PermissibleValue(text="9502/0") )
        setattr(cls, "8071/2",
                PermissibleValue(text="8071/2") )
        setattr(cls, "9476/3",
                PermissibleValue(text="9476/3") )
        setattr(cls, "9400/3",
                PermissibleValue(text="9400/3") )
        setattr(cls, "9064/2",
                PermissibleValue(text="9064/2") )
        setattr(cls, "9141/0",
                PermissibleValue(text="9141/0") )
        setattr(cls, "9767/1",
                PermissibleValue(text="9767/1") )
        setattr(cls, "8835/1",
                PermissibleValue(text="8835/1") )
        setattr(cls, "9750/3",
                PermissibleValue(text="9750/3") )
        setattr(cls, "9221/0",
                PermissibleValue(text="9221/0") )
        setattr(cls, "9242/3",
                PermissibleValue(text="9242/3") )
        setattr(cls, "9020/3",
                PermissibleValue(text="9020/3") )
        setattr(cls, "8110/3",
                PermissibleValue(text="8110/3") )
        setattr(cls, "9340/0",
                PermissibleValue(text="9340/0") )
        setattr(cls, "8070/3",
                PermissibleValue(text="8070/3") )
        setattr(cls, "8710/3",
                PermissibleValue(text="8710/3") )
        setattr(cls, "8163/2",
                PermissibleValue(text="8163/2") )
        setattr(cls, "8890/3",
                PermissibleValue(text="8890/3") )
        setattr(cls, "8503/2",
                PermissibleValue(text="8503/2") )
        setattr(cls, "9869/3",
                PermissibleValue(text="9869/3") )
        setattr(cls, "9709/3",
                PermissibleValue(text="9709/3") )
        setattr(cls, "8581/3",
                PermissibleValue(text="8581/3") )
        setattr(cls, "8040/0",
                PermissibleValue(text="8040/0") )
        setattr(cls, "8573/3",
                PermissibleValue(text="8573/3") )
        setattr(cls, "8052/3",
                PermissibleValue(text="8052/3") )
        setattr(cls, "9252/0",
                PermissibleValue(text="9252/0") )
        setattr(cls, "9014/0",
                PermissibleValue(text="9014/0") )
        setattr(cls, "9540/1",
                PermissibleValue(text="9540/1") )
        setattr(cls, "8670/0",
                PermissibleValue(text="8670/0") )
        setattr(cls, "8823/0",
                PermissibleValue(text="8823/0") )
        setattr(cls, "8407/3",
                PermissibleValue(text="8407/3") )
        setattr(cls, "8094/3",
                PermissibleValue(text="8094/3") )
        setattr(cls, "9765/1",
                PermissibleValue(text="9765/1") )
        setattr(cls, "9757/3",
                PermissibleValue(text="9757/3") )
        setattr(cls, "8044/3",
                PermissibleValue(text="8044/3") )
        setattr(cls, "8051/3",
                PermissibleValue(text="8051/3") )
        setattr(cls, "8720/0",
                PermissibleValue(text="8720/0") )
        setattr(cls, "8323/3",
                PermissibleValue(text="8323/3") )
        setattr(cls, "8323/0",
                PermissibleValue(text="8323/0") )
        setattr(cls, "9133/1",
                PermissibleValue(text="9133/1") )
        setattr(cls, "8011/0",
                PermissibleValue(text="8011/0") )
        setattr(cls, "8692/1",
                PermissibleValue(text="8692/1") )
        setattr(cls, "9756/3",
                PermissibleValue(text="9756/3") )
        setattr(cls, "8452/3",
                PermissibleValue(text="8452/3") )
        setattr(cls, "9351/1",
                PermissibleValue(text="9351/1") )
        setattr(cls, "8280/0",
                PermissibleValue(text="8280/0") )
        setattr(cls, "9300/0",
                PermissibleValue(text="9300/0") )
        setattr(cls, "9590/3",
                PermissibleValue(text="9590/3") )
        setattr(cls, "9274/0",
                PermissibleValue(text="9274/0") )
        setattr(cls, "9084/3",
                PermissibleValue(text="9084/3") )
        setattr(cls, "8121/1",
                PermissibleValue(text="8121/1") )
        setattr(cls, "8131/3",
                PermissibleValue(text="8131/3") )
        setattr(cls, "8935/0",
                PermissibleValue(text="8935/0") )
        setattr(cls, "8383/3",
                PermissibleValue(text="8383/3") )
        setattr(cls, "8440/0",
                PermissibleValue(text="8440/0") )
        setattr(cls, "8000/0",
                PermissibleValue(text="8000/0") )
        setattr(cls, "9538/3",
                PermissibleValue(text="9538/3") )
        setattr(cls, "9769/1",
                PermissibleValue(text="9769/1") )
        setattr(cls, "9523/3",
                PermissibleValue(text="9523/3") )
        setattr(cls, "8897/1",
                PermissibleValue(text="8897/1") )
        setattr(cls, "9271/0",
                PermissibleValue(text="9271/0") )
        setattr(cls, "8506/0",
                PermissibleValue(text="8506/0") )
        setattr(cls, "8680/0",
                PermissibleValue(text="8680/0") )
        setattr(cls, "9975/3",
                PermissibleValue(text="9975/3") )
        setattr(cls, "8852/3",
                PermissibleValue(text="8852/3") )
        setattr(cls, "9833/3",
                PermissibleValue(text="9833/3") )
        setattr(cls, "9110/1",
                PermissibleValue(text="9110/1") )
        setattr(cls, "9502/3",
                PermissibleValue(text="9502/3") )
        setattr(cls, "8322/0",
                PermissibleValue(text="8322/0") )
        setattr(cls, "8405/0",
                PermissibleValue(text="8405/0") )
        setattr(cls, "8853/3",
                PermissibleValue(text="8853/3") )
        setattr(cls, "9732/3",
                PermissibleValue(text="9732/3") )
        setattr(cls, "9725/3",
                PermissibleValue(text="9725/3") )
        setattr(cls, "8300/0",
                PermissibleValue(text="8300/0") )
        setattr(cls, "9670/3",
                PermissibleValue(text="9670/3") )
        setattr(cls, "9243/3",
                PermissibleValue(text="9243/3") )
        setattr(cls, "9302/0",
                PermissibleValue(text="9302/0") )
        setattr(cls, "8584/1",
                PermissibleValue(text="8584/1") )
        setattr(cls, "8571/3",
                PermissibleValue(text="8571/3") )
        setattr(cls, "8240/3",
                PermissibleValue(text="8240/3") )
        setattr(cls, "8570/3",
                PermissibleValue(text="8570/3") )
        setattr(cls, "8453/0",
                PermissibleValue(text="8453/0") )
        setattr(cls, "9044/3",
                PermissibleValue(text="9044/3") )
        setattr(cls, "8540/3",
                PermissibleValue(text="8540/3") )
        setattr(cls, "9052/3",
                PermissibleValue(text="9052/3") )
        setattr(cls, "8260/3",
                PermissibleValue(text="8260/3") )
        setattr(cls, "8213/3",
                PermissibleValue(text="8213/3") )
        setattr(cls, "9826/3",
                PermissibleValue(text="9826/3") )
        setattr(cls, "8002/3",
                PermissibleValue(text="8002/3") )
        setattr(cls, "8053/0",
                PermissibleValue(text="8053/0") )
        setattr(cls, "9837/3",
                PermissibleValue(text="9837/3") )
        setattr(cls, "9651/3",
                PermissibleValue(text="9651/3") )
        setattr(cls, "8836/1",
                PermissibleValue(text="8836/1") )
        setattr(cls, "8130/1",
                PermissibleValue(text="8130/1") )
        setattr(cls, "8020/3",
                PermissibleValue(text="8020/3") )
        setattr(cls, "9691/3",
                PermissibleValue(text="9691/3") )
        setattr(cls, "9541/0",
                PermissibleValue(text="9541/0") )
        setattr(cls, "9171/0",
                PermissibleValue(text="9171/0") )
        setattr(cls, "8141/3",
                PermissibleValue(text="8141/3") )
        setattr(cls, "9352/1",
                PermissibleValue(text="9352/1") )
        setattr(cls, "8480/0",
                PermissibleValue(text="8480/0") )
        setattr(cls, "9985/3",
                PermissibleValue(text="9985/3") )
        setattr(cls, "9655/3",
                PermissibleValue(text="9655/3") )
        setattr(cls, "8381/0",
                PermissibleValue(text="8381/0") )
        setattr(cls, "9030/0",
                PermissibleValue(text="9030/0") )
        setattr(cls, "8501/2",
                PermissibleValue(text="8501/2") )
        setattr(cls, "9421/1",
                PermissibleValue(text="9421/1") )
        setattr(cls, "8560/3",
                PermissibleValue(text="8560/3") )
        setattr(cls, "8175/3",
                PermissibleValue(text="8175/3") )
        setattr(cls, "9014/3",
                PermissibleValue(text="9014/3") )
        setattr(cls, "8959/0",
                PermissibleValue(text="8959/0") )
        setattr(cls, "8761/3",
                PermissibleValue(text="8761/3") )
        setattr(cls, "9717/3",
                PermissibleValue(text="9717/3") )
        setattr(cls, "8805/3",
                PermissibleValue(text="8805/3") )
        setattr(cls, "9187/3",
                PermissibleValue(text="9187/3") )
        setattr(cls, "8700/0",
                PermissibleValue(text="8700/0") )
        setattr(cls, "9081/3",
                PermissibleValue(text="9081/3") )
        setattr(cls, "9311/0",
                PermissibleValue(text="9311/0") )
        setattr(cls, "8806/3",
                PermissibleValue(text="8806/3") )
        setattr(cls, "8202/0",
                PermissibleValue(text="8202/0") )
        setattr(cls, "9513/3",
                PermissibleValue(text="9513/3") )
        setattr(cls, "9091/1",
                PermissibleValue(text="9091/1") )
        setattr(cls, "8671/0",
                PermissibleValue(text="8671/0") )
        setattr(cls, "9688/3",
                PermissibleValue(text="9688/3") )
        setattr(cls, "9982/3",
                PermissibleValue(text="9982/3") )
        setattr(cls, "8170/0",
                PermissibleValue(text="8170/0") )
        setattr(cls, "9412/1",
                PermissibleValue(text="9412/1") )
        setattr(cls, "8344/3",
                PermissibleValue(text="8344/3") )
        setattr(cls, "8335/3",
                PermissibleValue(text="8335/3") )
        setattr(cls, "Not Reported",
                PermissibleValue(text="Not Reported") )
        setattr(cls, "8490/6",
                PermissibleValue(text="8490/6") )
        setattr(cls, "8513/3",
                PermissibleValue(text="8513/3") )
        setattr(cls, "8522/1",
                PermissibleValue(text="8522/1") )
        setattr(cls, "8850/0",
                PermissibleValue(text="8850/0") )
        setattr(cls, "9714/3",
                PermissibleValue(text="9714/3") )
        setattr(cls, "9820/3",
                PermissibleValue(text="9820/3") )
        setattr(cls, "9084/0",
                PermissibleValue(text="9084/0") )
        setattr(cls, "8930/0",
                PermissibleValue(text="8930/0") )
        setattr(cls, "8380/1",
                PermissibleValue(text="8380/1") )
        setattr(cls, "9250/1",
                PermissibleValue(text="9250/1") )
        setattr(cls, "9122/0",
                PermissibleValue(text="9122/0") )
        setattr(cls, "8830/1",
                PermissibleValue(text="8830/1") )
        setattr(cls, "8723/0",
                PermissibleValue(text="8723/0") )
        setattr(cls, "8212/0",
                PermissibleValue(text="8212/0") )
        setattr(cls, "8490/3",
                PermissibleValue(text="8490/3") )
        setattr(cls, "8330/1",
                PermissibleValue(text="8330/1") )
        setattr(cls, "8630/0",
                PermissibleValue(text="8630/0") )
        setattr(cls, "8000/9",
                PermissibleValue(text="8000/9") )
        setattr(cls, "9420/3",
                PermissibleValue(text="9420/3") )
        setattr(cls, "8256/3",
                PermissibleValue(text="8256/3") )
        setattr(cls, "9450/3",
                PermissibleValue(text="9450/3") )
        setattr(cls, "9061/3",
                PermissibleValue(text="9061/3") )
        setattr(cls, "9538/1",
                PermissibleValue(text="9538/1") )
        setattr(cls, "9173/0",
                PermissibleValue(text="9173/0") )
        setattr(cls, "8123/3",
                PermissibleValue(text="8123/3") )
        setattr(cls, "9370/3",
                PermissibleValue(text="9370/3") )
        setattr(cls, "8242/3",
                PermissibleValue(text="8242/3") )
        setattr(cls, "9504/3",
                PermissibleValue(text="9504/3") )
        setattr(cls, "8163/3",
                PermissibleValue(text="8163/3") )
        setattr(cls, "8156/1",
                PermissibleValue(text="8156/1") )
        setattr(cls, "8480/3",
                PermissibleValue(text="8480/3") )
        setattr(cls, "8714/3",
                PermissibleValue(text="8714/3") )
        setattr(cls, "9394/1",
                PermissibleValue(text="9394/1") )
        setattr(cls, "8400/3",
                PermissibleValue(text="8400/3") )
        setattr(cls, "8840/3",
                PermissibleValue(text="8840/3") )
        setattr(cls, "9501/3",
                PermissibleValue(text="9501/3") )
        setattr(cls, "8243/3",
                PermissibleValue(text="8243/3") )
        setattr(cls, "8046/6",
                PermissibleValue(text="8046/6") )
        setattr(cls, "8801/6",
                PermissibleValue(text="8801/6") )
        setattr(cls, "8249/6",
                PermissibleValue(text="8249/6") )
        setattr(cls, "9440/6",
                PermissibleValue(text="9440/6") )
        setattr(cls, "8804/6",
                PermissibleValue(text="8804/6") )
        setattr(cls, "8240/6",
                PermissibleValue(text="8240/6") )
        setattr(cls, "8441/6",
                PermissibleValue(text="8441/6") )
        setattr(cls, "8806/6",
                PermissibleValue(text="8806/6") )
        setattr(cls, "8500/6",
                PermissibleValue(text="8500/6") )
        setattr(cls, "8041/6",
                PermissibleValue(text="8041/6") )
        setattr(cls, "8800/6",
                PermissibleValue(text="8800/6") )
        setattr(cls, "8020/6",
                PermissibleValue(text="8020/6") )
        setattr(cls, "8040/3",
                PermissibleValue(text="8040/3") )
        setattr(cls, "8482/6",
                PermissibleValue(text="8482/6") )
        setattr(cls, "8720/6",
                PermissibleValue(text="8720/6") )
        setattr(cls, "9180/6",
                PermissibleValue(text="9180/6") )
        setattr(cls, "8471/1",
                PermissibleValue(text="8471/1") )
        setattr(cls, "8920/6",
                PermissibleValue(text="8920/6") )
        setattr(cls, "8311/6",
                PermissibleValue(text="8311/6") )
        setattr(cls, "8950/6",
                PermissibleValue(text="8950/6") )
        setattr(cls, "8310/6",
                PermissibleValue(text="8310/6") )

class EnumCRDCHDiagnosisDiseaseStatus(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Diagnosis disease_status
    """
    Unknown = PermissibleValue(text="Unknown")

    _defn = EnumDefinition(
        name="EnumCRDCHDiagnosisDiseaseStatus",
        description="Autogenerated Enumeration for CRDC-H Diagnosis disease_status",
        code_set=None,
        code_set_version="2021-09-23T15:59:45.824276+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Initial Diagnosis",
                PermissibleValue(text="Initial Diagnosis") )
        setattr(cls, "Not Reported",
                PermissibleValue(text="Not Reported") )
        setattr(cls, "Residual Disease",
                PermissibleValue(text="Residual Disease") )
        setattr(cls, "Recurrent Disease",
                PermissibleValue(text="Recurrent Disease") )
        setattr(cls, "Progressive Disease",
                PermissibleValue(text="Progressive Disease") )

class EnumCRDCHDiagnosisMethodOfDiagnosis(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Diagnosis method_of_diagnosis
    """
    Cystoscopy = PermissibleValue(text="Cystoscopy",
                                           description="Cystoscopy")
    Laparoscopy = PermissibleValue(text="Laparoscopy",
                                             description="Laparoscopy")
    Debulking = PermissibleValue(text="Debulking",
                                         description="Debulking")
    Other = PermissibleValue(text="Other",
                                 description="Other")
    Cytology = PermissibleValue(text="Cytology",
                                       description="Cytology")
    Unknown = PermissibleValue(text="Unknown",
                                     description="Unknown")
    Laparotomy = PermissibleValue(text="Laparotomy",
                                           description="Laparotomy")
    Enucleation = PermissibleValue(text="Enucleation",
                                             description="Enucleation")
    Thoracentesis = PermissibleValue(text="Thoracentesis",
                                                 description="Thoracentesis")
    Biopsy = PermissibleValue(text="Biopsy",
                                   description="Biopsy")
    Autopsy = PermissibleValue(text="Autopsy",
                                     description="Autopsy")
    Imaging = PermissibleValue(text="Imaging",
                                     description="Imaging Technique")

    _defn = EnumDefinition(
        name="EnumCRDCHDiagnosisMethodOfDiagnosis",
        description="Autogenerated Enumeration for CRDC-H Diagnosis method_of_diagnosis",
        code_set=None,
        code_set_version="2021-09-23T15:59:45.936216+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Surgical Resection",
                PermissibleValue(text="Surgical Resection",
                                 description="Excision") )
        setattr(cls, "Incisional Biopsy",
                PermissibleValue(text="Incisional Biopsy",
                                 description="Incisional Biopsy") )
        setattr(cls, "Dilation and Curettage Procedure",
                PermissibleValue(text="Dilation and Curettage Procedure",
                                 description="Dilation and Curettage") )
        setattr(cls, "Not Allowed To Collect",
                PermissibleValue(text="Not Allowed To Collect") )
        setattr(cls, "Pathologic Review",
                PermissibleValue(text="Pathologic Review",
                                 description="Pathologic Examination") )
        setattr(cls, "Physical Exam",
                PermissibleValue(text="Physical Exam",
                                 description="Physical Examination") )
        setattr(cls, "Ultrasound Guided Biopsy",
                PermissibleValue(text="Ultrasound Guided Biopsy",
                                 description="Ultrasound guided biopsy") )
        setattr(cls, "Pap Smear",
                PermissibleValue(text="Pap Smear",
                                 description="Papanicolaou Smear Procedure") )
        setattr(cls, "Blood Draw",
                PermissibleValue(text="Blood Draw",
                                 description="Phlebotomy") )
        setattr(cls, "Excisional Biopsy",
                PermissibleValue(text="Excisional Biopsy",
                                 description="Excisional Biopsy") )
        setattr(cls, "Fine Needle Aspiration",
                PermissibleValue(text="Fine Needle Aspiration",
                                 description="Fine-Needle Aspiration") )
        setattr(cls, "Bone Marrow Aspirate",
                PermissibleValue(text="Bone Marrow Aspirate",
                                 description="Bone Marrow Aspiration") )
        setattr(cls, "Core Biopsy",
                PermissibleValue(text="Core Biopsy",
                                 description="Core Biopsy") )
        setattr(cls, "Not Reported",
                PermissibleValue(text="Not Reported",
                                 description="Not Reported") )
        setattr(cls, "Diagnostic Imaging",
                PermissibleValue(text="Diagnostic Imaging",
                                 description="Diagnostic Imaging") )

class EnumCRDCHDimensionalObservationCategory(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H DimensionalObservation category
    """
    _defn = EnumDefinition(
        name="EnumCRDCHDimensionalObservationCategory",
        description="Autogenerated Enumeration for CRDC-H DimensionalObservation category",
        code_set=None,
        code_set_version="2021-09-23T15:59:46.070978+00:00",
    )

class EnumCRDCHDimensionalObservationObservationType(EnumDefinitionImpl):
    """
    Types of measurements that describe the physical dimensions of an entity (e.g. a Specimen)
    """
    length = PermissibleValue(text="length",
                                   description="The length of a three-dimensional specimen, as measured in a plane perpendicular to the planes in which the width and height of the specimen are measured.")
    width = PermissibleValue(text="width",
                                 description="The width of a three-dimensional specimen, as measured in a plane perpendicular to the planes in which the length and height of the specimen are measured.")
    longest_dimension = PermissibleValue(text="longest_dimension",
                                                         description="The measured extent of the longest straight path across a specimen.")
    shortest_dimension = PermissibleValue(text="shortest_dimension",
                                                           description="The measured extent of the shortest straight path across a specimen.")
    intermediate_dimension = PermissibleValue(text="intermediate_dimension",
                                                                   description="The measured extent of the intermediate straight path across a specimen.")
    surface_area = PermissibleValue(text="surface_area",
                                               description="The total surface area of the specimen")

    _defn = EnumDefinition(
        name="EnumCRDCHDimensionalObservationObservationType",
        description="Types of measurements that describe the physical dimensions of an entity (e.g. a Specimen)",
    )

class EnumCRDCHDimensionalObservationMethodType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H DimensionalObservation method_type
    """
    _defn = EnumDefinition(
        name="EnumCRDCHDimensionalObservationMethodType",
        description="Autogenerated Enumeration for CRDC-H DimensionalObservation method_type",
        code_set=None,
        code_set_version="2021-09-23T15:59:46.274398+00:00",
    )

class EnumCRDCHDimensionalObservationSetCategory(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H DimensionalObservationSet category
    """
    _defn = EnumDefinition(
        name="EnumCRDCHDimensionalObservationSetCategory",
        description="Autogenerated Enumeration for CRDC-H DimensionalObservationSet category",
        code_set=None,
        code_set_version="2021-09-23T15:59:46.378533+00:00",
    )

class EnumCRDCHDimensionalObservationSetMethodType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H DimensionalObservationSet method_type
    """
    _defn = EnumDefinition(
        name="EnumCRDCHDimensionalObservationSetMethodType",
        description="Autogenerated Enumeration for CRDC-H DimensionalObservationSet method_type",
        code_set=None,
        code_set_version="2021-09-23T15:59:46.483558+00:00",
    )

class EnumCRDCHDocumentDocumentType(EnumDefinitionImpl):
    """
    The high-level type of the report (e.g. 'pathology report')
    """
    protocol = PermissibleValue(text="protocol",
                                       description="A protocol by which the sample was obtained or generated (e.g. a protocol listed in protocols.io)")

    _defn = EnumDefinition(
        name="EnumCRDCHDocumentDocumentType",
        description="The high-level type of the report (e.g. 'pathology report')",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "pathology report",
                PermissibleValue(text="pathology report",
                                 description="A pathology report describing the specimen") )

class EnumCRDCHEnvironmentalExposureObservationCategory(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H EnvironmentalExposureObservation category
    """
    _defn = EnumDefinition(
        name="EnumCRDCHEnvironmentalExposureObservationCategory",
        description="Autogenerated Enumeration for CRDC-H EnvironmentalExposureObservation category",
        code_set=None,
        code_set_version="2021-09-23T15:59:46.687076+00:00",
    )

class EnumCRDCHEnvironmentalExposureObservationObservationType(EnumDefinitionImpl):
    """
    Types of observations about a Subject's environmental exposures.
    """
    asbestos_exposure = PermissibleValue(text="asbestos_exposure",
                                                         description="The yes/no/unknown indicator used to describe whether the patient was exposed to asbestos.")
    coal_dust_exposure = PermissibleValue(text="coal_dust_exposure",
                                                           description="The yes/no/unknown indicator used to describe whether a patient was exposed to fine powder derived by the crushing of coal.")
    radon_exposure = PermissibleValue(text="radon_exposure",
                                                   description="The yes/no/unknown indicator used to describe whether the patient was exposed to radon.")
    respirable_crystalline_silica_exposure = PermissibleValue(text="respirable_crystalline_silica_exposure",
                                                                                                   description="The yes/no/unknown indicator used to describe whether a patient was exposed to respirable crystalline silica, a widespread, naturally occurring, crystalline metal oxide that consists of different forms including quartz, cristobalite, tridymite, tripoli, ganister, chert and novaculite.")
    type_of_smoke_exposure = PermissibleValue(text="type_of_smoke_exposure",
                                                                   description="The text term used to describe the patient's specific type of smoke exposure.")

    _defn = EnumDefinition(
        name="EnumCRDCHEnvironmentalExposureObservationObservationType",
        description="Types of observations about a Subject's environmental exposures.",
    )

class EnumCRDCHEnvironmentalExposureObservationMethodType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H EnvironmentalExposureObservation method_type
    """
    _defn = EnumDefinition(
        name="EnumCRDCHEnvironmentalExposureObservationMethodType",
        description="Autogenerated Enumeration for CRDC-H EnvironmentalExposureObservation method_type",
        code_set=None,
        code_set_version="2021-09-23T15:59:46.885066+00:00",
    )

class EnumCRDCHEnvironmentalExposureObservationValueCodeableConcept(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H EnvironmentalExposureObservation value_codeable_concept
    """
    _defn = EnumDefinition(
        name="EnumCRDCHEnvironmentalExposureObservationValueCodeableConcept",
        description="Autogenerated Enumeration for CRDC-H EnvironmentalExposureObservation value_codeable_concept",
        code_set=None,
        code_set_version="2021-09-23T15:59:46.988804+00:00",
    )

class EnumCRDCHExecutionConditionObservationCategory(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H ExecutionConditionObservation category
    """
    _defn = EnumDefinition(
        name="EnumCRDCHExecutionConditionObservationCategory",
        description="Autogenerated Enumeration for CRDC-H ExecutionConditionObservation category",
        code_set=None,
        code_set_version="2021-09-23T15:59:47.091912+00:00",
    )

class EnumCRDCHExecutionConditionObservationObservationType(EnumDefinitionImpl):
    """
    Types of observations about the environmental conditions under which specific aspects of an activity were
    performed.
    """
    ischemic_temperature = PermissibleValue(text="ischemic_temperature",
                                                               description="A term describing the temperature of a specimen when it experienced ischemia.")

    _defn = EnumDefinition(
        name="EnumCRDCHExecutionConditionObservationObservationType",
        description="Types of observations about the environmental conditions under which specific aspects of an activity were performed.",
    )

class EnumCRDCHExecutionConditionObservationMethodType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H ExecutionConditionObservation method_type
    """
    _defn = EnumDefinition(
        name="EnumCRDCHExecutionConditionObservationMethodType",
        description="Autogenerated Enumeration for CRDC-H ExecutionConditionObservation method_type",
        code_set=None,
        code_set_version="2021-09-23T15:59:47.299037+00:00",
    )

class EnumCRDCHExecutionConditionObservationValueCodeableConcept(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H ExecutionConditionObservation value_codeable_concept
    """
    _defn = EnumDefinition(
        name="EnumCRDCHExecutionConditionObservationValueCodeableConcept",
        description="Autogenerated Enumeration for CRDC-H ExecutionConditionObservation value_codeable_concept",
        code_set=None,
        code_set_version="2021-09-23T15:59:47.405300+00:00",
    )

class EnumCRDCHExecutionTimeObservationCategory(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H ExecutionTimeObservation category
    """
    _defn = EnumDefinition(
        name="EnumCRDCHExecutionTimeObservationCategory",
        description="Autogenerated Enumeration for CRDC-H ExecutionTimeObservation category",
        code_set=None,
        code_set_version="2021-09-23T15:59:47.512425+00:00",
    )

class EnumCRDCHExecutionTimeObservationObservationType(EnumDefinitionImpl):
    """
    An observation about the duration of specific aspects / parts of an activity.
    """
    time_between_excision_and_freezing = PermissibleValue(text="time_between_excision_and_freezing",
                                                                                           description="The elapsed time between the excision and freezing of the specimen from its subject/source.")
    time_between_clamping_and_freezing = PermissibleValue(text="time_between_clamping_and_freezing",
                                                                                           description="The elapsed time between the clamping of blood supply and freezing of the specimen from its subject/source.")
    ischemic_time = PermissibleValue(text="ischemic_time",
                                                 description="Duration of time, in seconds, between when the specimen stopped receiving oxygen and when it was preserved or processed.")

    _defn = EnumDefinition(
        name="EnumCRDCHExecutionTimeObservationObservationType",
        description="An observation about the duration of specific aspects / parts of an activity.",
    )

class EnumCRDCHExecutionTimeObservationMethodType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H ExecutionTimeObservation method_type
    """
    _defn = EnumDefinition(
        name="EnumCRDCHExecutionTimeObservationMethodType",
        description="Autogenerated Enumeration for CRDC-H ExecutionTimeObservation method_type",
        code_set=None,
        code_set_version="2021-09-23T15:59:47.715012+00:00",
    )

class EnumCRDCHHistologicalCompositionObservationCategory(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H HistologicalCompositionObservation category
    """
    _defn = EnumDefinition(
        name="EnumCRDCHHistologicalCompositionObservationCategory",
        description="Autogenerated Enumeration for CRDC-H HistologicalCompositionObservation category",
        code_set=None,
        code_set_version="2021-09-23T15:59:47.818882+00:00",
    )

class EnumCRDCHHistologicalCompositionObservationObservationType(EnumDefinitionImpl):
    """
    Types of measurements that describe microscopic characteristics of a specimen - typically related to its cellular
    and tissue composition.
    """
    number_proliferating_cells = PermissibleValue(text="number_proliferating_cells",
                                                                           description="Numeric value that represents the count of proliferating cells determined during pathologic review of the sample slide(s).")
    percent_eosinophil_infiltration = PermissibleValue(text="percent_eosinophil_infiltration",
                                                                                     description="Numeric value to represent the percentage of infiltration by eosinophils in a tumor sample or specimen.")
    percent_granulocyte_infiltration = PermissibleValue(text="percent_granulocyte_infiltration",
                                                                                       description="Numeric value to represent the percentage of infiltration by granulocytes in a tumor sample or specimen.")
    percent_inflam_infiltration = PermissibleValue(text="percent_inflam_infiltration",
                                                                             description="Numeric value to represent local response to cellular injury, marked by capillary dilatation, edema and leukocyte infiltration; clinically, inflammation is manifest by redness, heat, pain, swelling and loss of function, with the need to heal damaged tissue.")
    percent_lymphocyte_infiltration = PermissibleValue(text="percent_lymphocyte_infiltration",
                                                                                     description="Numeric value to represent the percentage of infiltration by lymphocytes in a solid tissue normal sample or specimen.")
    percent_monocyte_infiltration = PermissibleValue(text="percent_monocyte_infiltration",
                                                                                 description="Numeric value to represent the percentage of monocyte infiltration in a sample or specimen.")
    percent_necrosis = PermissibleValue(text="percent_necrosis",
                                                       description="Numeric value to represent the percentage of cell death in a malignant tumor sample or specimen.")
    percent_neutrophil_infiltration = PermissibleValue(text="percent_neutrophil_infiltration",
                                                                                     description="Numeric value to represent the percentage of infiltration by neutrophils in a tumor sample or specimen.")
    percent_normal_cells = PermissibleValue(text="percent_normal_cells",
                                                               description="Numeric value to represent the percentage of normal cell content in a malignant tumor sample or specimen.")
    percent_stromal_cells = PermissibleValue(text="percent_stromal_cells",
                                                                 description="Numeric value to represent the percentage of reactive cells that are present in a malignant tumor sample or specimen but are not malignant such as fibroblasts, vascular structures, etc.")
    percent_tumor_cells = PermissibleValue(text="percent_tumor_cells",
                                                             description="Numeric value that represents the percentage of infiltration by tumor cells in a sample.")
    percent_tumor_nuclei = PermissibleValue(text="percent_tumor_nuclei",
                                                               description="Numeric value to represent the percentage of tumor nuclei in a malignant neoplasm sample or specimen.")
    tumor_infiltrating_lymphocytes = PermissibleValue(text="tumor_infiltrating_lymphocytes",
                                                                                   description="Measure of Tumor-Infiltrating Lymphocytes")
    non_tumor_tissue_area = PermissibleValue(text="non_tumor_tissue_area",
                                                                 description="The area within a sample that is represented by non-tumor tissue.")
    tumor_tissue_area = PermissibleValue(text="tumor_tissue_area",
                                                         description="The area within a sample that is comprised of tumor tissue.")
    analysis_area = PermissibleValue(text="analysis_area",
                                                 description="The total area of a sample that is used for analysis.")
    analysis_area_percentage_stroma = PermissibleValue(text="analysis_area_percentage_stroma",
                                                                                     description="The percentage of the analysis area that is represented by stromal tissue.")
    analysis_area_percentage_tumor = PermissibleValue(text="analysis_area_percentage_tumor",
                                                                                   description="The percentage of the analysis area that is represented by tumor tissue.")
    analysis_area_percentage_glass = PermissibleValue(text="analysis_area_percentage_glass",
                                                                                   description="The area of a sample on a slide that is represented by glass; the area of the sample that represents gaps in the sample.")
    analysis_area_percentage_pigmented_tumor = PermissibleValue(text="analysis_area_percentage_pigmented_tumor",
                                                                                                       description="The area of a sample on a slide that is represented by pigmented tumor tissue, which will be analyzed.")

    _defn = EnumDefinition(
        name="EnumCRDCHHistologicalCompositionObservationObservationType",
        description="Types of measurements that describe microscopic characteristics of a specimen - typically related to its cellular and tissue composition.",
    )

class EnumCRDCHHistologicalCompositionObservationMethodType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H HistologicalCompositionObservation method_type
    """
    _defn = EnumDefinition(
        name="EnumCRDCHHistologicalCompositionObservationMethodType",
        description="Autogenerated Enumeration for CRDC-H HistologicalCompositionObservation method_type",
        code_set=None,
        code_set_version="2021-09-23T15:59:48.018837+00:00",
    )

class EnumCRDCHHistologicalCompositionObservationSetCategory(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H HistologicalCompositionObservationSet category
    """
    _defn = EnumDefinition(
        name="EnumCRDCHHistologicalCompositionObservationSetCategory",
        description="Autogenerated Enumeration for CRDC-H HistologicalCompositionObservationSet category",
        code_set=None,
        code_set_version="2021-09-23T15:59:48.117612+00:00",
    )

class EnumCRDCHHistologicalCompositionObservationSetMethodType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H HistologicalCompositionObservationSet method_type
    """
    _defn = EnumDefinition(
        name="EnumCRDCHHistologicalCompositionObservationSetMethodType",
        description="Autogenerated Enumeration for CRDC-H HistologicalCompositionObservationSet method_type",
        code_set=None,
        code_set_version="2021-09-23T15:59:48.217863+00:00",
    )

class EnumCRDCHIdentifierType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Identifier type
    """
    _defn = EnumDefinition(
        name="EnumCRDCHIdentifierType",
        description="Autogenerated Enumeration for CRDC-H Identifier type",
        code_set=None,
        code_set_version="2021-09-23T15:59:48.323029+00:00",
    )

class EnumCRDCHObservationCategory(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Observation category
    """
    _defn = EnumDefinition(
        name="EnumCRDCHObservationCategory",
        description="Autogenerated Enumeration for CRDC-H Observation category",
        code_set=None,
        code_set_version="2021-09-23T15:59:48.423241+00:00",
    )

class EnumCRDCHObservationObservationType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Observation observation_type
    """
    _defn = EnumDefinition(
        name="EnumCRDCHObservationObservationType",
        description="Autogenerated Enumeration for CRDC-H Observation observation_type",
        code_set=None,
        code_set_version="2021-09-23T15:59:48.524532+00:00",
    )

class EnumCRDCHObservationMethodType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Observation method_type
    """
    _defn = EnumDefinition(
        name="EnumCRDCHObservationMethodType",
        description="Autogenerated Enumeration for CRDC-H Observation method_type",
        code_set=None,
        code_set_version="2021-09-23T15:59:48.627594+00:00",
    )

class EnumCRDCHObservationValueCodeableConcept(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Observation value_codeable_concept
    """
    _defn = EnumDefinition(
        name="EnumCRDCHObservationValueCodeableConcept",
        description="Autogenerated Enumeration for CRDC-H Observation value_codeable_concept",
        code_set=None,
        code_set_version="2021-09-23T15:59:48.730624+00:00",
    )

class EnumCRDCHObservationSetCategory(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H ObservationSet category
    """
    _defn = EnumDefinition(
        name="EnumCRDCHObservationSetCategory",
        description="Autogenerated Enumeration for CRDC-H ObservationSet category",
        code_set=None,
        code_set_version="2021-09-23T15:59:48.833540+00:00",
    )

class EnumCRDCHObservationSetMethodType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H ObservationSet method_type
    """
    _defn = EnumDefinition(
        name="EnumCRDCHObservationSetMethodType",
        description="Autogenerated Enumeration for CRDC-H ObservationSet method_type",
        code_set=None,
        code_set_version="2021-09-23T15:59:48.942147+00:00",
    )

class EnumCRDCHQuantityValueCodeableConcept(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Quantity value_codeable_concept
    """
    _defn = EnumDefinition(
        name="EnumCRDCHQuantityValueCodeableConcept",
        description="Autogenerated Enumeration for CRDC-H Quantity value_codeable_concept",
        code_set=None,
        code_set_version="2021-09-23T15:59:49.048081+00:00",
    )

class EnumCRDCHQuantityUnit(EnumDefinitionImpl):
    """
    The unit for a value
    """
    milligrams = PermissibleValue(text="milligrams")
    days = PermissibleValue(text="days")
    minutes = PermissibleValue(text="minutes")

    _defn = EnumDefinition(
        name="EnumCRDCHQuantityUnit",
        description="The unit for a value",
    )

class EnumCRDCHResearchProjectResearchProjectType(EnumDefinitionImpl):
    """
    A high-level type of research activity
    """
    Program = PermissibleValue(text="Program",
                                     description="A broad framework of goals to be achieved.")
    Project = PermissibleValue(text="Project",
                                     description="Any specifically defined piece of work that is undertaken or attempted to meet a single requirement.")

    _defn = EnumDefinition(
        name="EnumCRDCHResearchProjectResearchProjectType",
        description="A high-level type of research activity",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Clinical Trial",
                PermissibleValue(text="Clinical Trial",
                                 description="A research study that prospectively assigns participants to one or more health-related interventions to evaluate the effects on health outcomes.") )

class EnumCRDCHResearchSubjectPrimaryDiagnosisCondition(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H ResearchSubject primary_diagnosis_condition
    """
    Gliomas = PermissibleValue(text="Gliomas",
                                     description="Glioma")
    Mesonephromas = PermissibleValue(text="Mesonephromas",
                                                 description="Mesonephric Neoplasm")
    Unknown = PermissibleValue(text="Unknown",
                                     description="Unknown")
    Meningiomas = PermissibleValue(text="Meningiomas",
                                             description="Meningioma")
    Cholangiocarcinoma = PermissibleValue(text="Cholangiocarcinoma")
    Thymoma = PermissibleValue(text="Thymoma")
    Sarcoma = PermissibleValue(text="Sarcoma")
    Neuroblastoma = PermissibleValue(text="Neuroblastoma")
    Osteosarcoma = PermissibleValue(text="Osteosarcoma")
    Mesothelioma = PermissibleValue(text="Mesothelioma")
    Glioblastoma = PermissibleValue(text="Glioblastoma")
    Other = PermissibleValue(text="Other")

    _defn = EnumDefinition(
        name="EnumCRDCHResearchSubjectPrimaryDiagnosisCondition",
        description="Autogenerated Enumeration for CRDC-H ResearchSubject primary_diagnosis_condition",
        code_set=None,
        code_set_version="2021-09-23T15:59:49.370438+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Soft Tissue Tumors and Sarcomas, NOS",
                PermissibleValue(text="Soft Tissue Tumors and Sarcomas, NOS",
                                 description="Soft Tissue Neoplasm and Soft Tissue Sarcoma") )
        setattr(cls, "Precursor Cell Lymphoblastic Lymphoma",
                PermissibleValue(text="Precursor Cell Lymphoblastic Lymphoma",
                                 description="Lymphoblastic Lymphoma") )
        setattr(cls, "Myeloid Leukemias",
                PermissibleValue(text="Myeloid Leukemias",
                                 description="Myeloid Leukemia") )
        setattr(cls, "Hodgkin Lymphoma",
                PermissibleValue(text="Hodgkin Lymphoma",
                                 description="Hodgkin Lymphoma") )
        setattr(cls, "Not Reported",
                PermissibleValue(text="Not Reported",
                                 description="Not Reported") )
        setattr(cls, "Germ Cell Neoplasms",
                PermissibleValue(text="Germ Cell Neoplasms",
                                 description="Germ Cell Tumor") )
        setattr(cls, "Blood Vessel Tumors",
                PermissibleValue(text="Blood Vessel Tumors",
                                 description="Blood Vessel Neoplasm") )
        setattr(cls, "Fibroepithelial Neoplasms",
                PermissibleValue(text="Fibroepithelial Neoplasms",
                                 description="Fibroepithelial Neoplasm") )
        setattr(cls, "Neoplasms, NOS",
                PermissibleValue(text="Neoplasms, NOS",
                                 description="Not Otherwise Specified Neoplasm") )
        setattr(cls, "Basal Cell Neoplasms",
                PermissibleValue(text="Basal Cell Neoplasms",
                                 description="Basal Cell Neoplasm") )
        setattr(cls, "Mast Cell Tumors",
                PermissibleValue(text="Mast Cell Tumors",
                                 description="Mast Cell Neoplasm") )
        setattr(cls, "Complex Epithelial Neoplasms",
                PermissibleValue(text="Complex Epithelial Neoplasms") )
        setattr(cls, "Other Leukemias",
                PermissibleValue(text="Other Leukemias",
                                 description="Other Leukemia") )
        setattr(cls, "Complex Mixed and Stromal Neoplasms",
                PermissibleValue(text="Complex Mixed and Stromal Neoplasms",
                                 description="Complex Mixed and Stromal Neoplasm") )
        setattr(cls, "Not Applicable",
                PermissibleValue(text="Not Applicable") )
        setattr(cls, "Mature B-Cell Lymphomas",
                PermissibleValue(text="Mature B-Cell Lymphomas",
                                 description="Mature B-Cell Non-Hodgkin Lymphoma") )
        setattr(cls, "Adnexal and Skin Appendage Neoplasms",
                PermissibleValue(text="Adnexal and Skin Appendage Neoplasms",
                                 description="Adnexal Carcinoma and Skin Appendage Neoplasm") )
        setattr(cls, "Chronic Myeloproliferative Disorders",
                PermissibleValue(text="Chronic Myeloproliferative Disorders",
                                 description="Chronic Myeloproliferative Neoplasm") )
        setattr(cls, "Acinar Cell Neoplasms",
                PermissibleValue(text="Acinar Cell Neoplasms",
                                 description="Acinar Cell Neoplasm") )
        setattr(cls, "Osseous and Chondromatous Neoplasms",
                PermissibleValue(text="Osseous and Chondromatous Neoplasms",
                                 description="Osteogenic Neoplasm and Chondrogenic Neoplasm") )
        setattr(cls, "Miscellaneous Bone Tumors",
                PermissibleValue(text="Miscellaneous Bone Tumors",
                                 description="Miscellaneous Bone Neoplasm") )
        setattr(cls, "Paragangliomas and Glomus Tumors",
                PermissibleValue(text="Paragangliomas and Glomus Tumors",
                                 description="Paraganglioma And Glomus Tumor") )
        setattr(cls, "Fibromatous Neoplasms",
                PermissibleValue(text="Fibromatous Neoplasms",
                                 description="Fibromatosis") )
        setattr(cls, "Mesothelial Neoplasms",
                PermissibleValue(text="Mesothelial Neoplasms",
                                 description="Mesothelial Neoplasm") )
        setattr(cls, "Granular Cell Tumors and Alveolar Soft Part Sarcomas",
                PermissibleValue(text="Granular Cell Tumors and Alveolar Soft Part Sarcomas",
                                 description="Granular Cell Tumor and Alveolar Soft Part Sarcoma") )
        setattr(cls, "Neoplasms of Histiocytes and Accessory Lymphoid Cells",
                PermissibleValue(text="Neoplasms of Histiocytes and Accessory Lymphoid Cells",
                                 description="Neoplasms of Histiocytes and Accessory Lymphoid Cells") )
        setattr(cls, "Immunoproliferative Diseases",
                PermissibleValue(text="Immunoproliferative Diseases",
                                 description="Immunoproliferative Disease") )
        setattr(cls, "Thymic Epithelial Neoplasms",
                PermissibleValue(text="Thymic Epithelial Neoplasms",
                                 description="Combined Thymic Epithelial Neoplasm") )
        setattr(cls, "Mucoepidermoid Neoplasms",
                PermissibleValue(text="Mucoepidermoid Neoplasms",
                                 description="Mucoepidermoid Carcinoma") )
        setattr(cls, "Nerve Sheath Tumors",
                PermissibleValue(text="Nerve Sheath Tumors",
                                 description="Nerve Sheath Neoplasm") )
        setattr(cls, "Adenomas and Adenocarcinomas",
                PermissibleValue(text="Adenomas and Adenocarcinomas",
                                 description="Adenoma and Adenocarcinoma") )
        setattr(cls, "Lymphoid Leukemias",
                PermissibleValue(text="Lymphoid Leukemias",
                                 description="Lymphoid Leukemia") )
        setattr(cls, "Odontogenic Tumors",
                PermissibleValue(text="Odontogenic Tumors",
                                 description="Odontogenic Neoplasm") )
        setattr(cls, "Cystic, Mucinous and Serous Neoplasms",
                PermissibleValue(text="Cystic, Mucinous and Serous Neoplasms",
                                 description="Cystic Neoplasm Mucinous Neoplasm and Serous Neoplasm") )
        setattr(cls, "Squamous Cell Neoplasms",
                PermissibleValue(text="Squamous Cell Neoplasms",
                                 description="Squamous Cell Neoplasm") )
        setattr(cls, "Transitional Cell Papillomas and Carcinomas",
                PermissibleValue(text="Transitional Cell Papillomas and Carcinomas",
                                 description="Transitional Cell Papilloma and Transitional Cell Carcinoma") )
        setattr(cls, "Ductal and Lobular Neoplasms",
                PermissibleValue(text="Ductal and Lobular Neoplasms",
                                 description="Ductal Breast Carcinoma In Situ and Lobular Carcinoma In Situ") )
        setattr(cls, "Leukemias, NOS",
                PermissibleValue(text="Leukemias, NOS",
                                 description="Not Otherwise Specified Leukemia") )
        setattr(cls, "Trophoblastic neoplasms",
                PermissibleValue(text="Trophoblastic neoplasms",
                                 description="Trophoblastic Tumor") )
        setattr(cls, "Other Hematologic Disorders",
                PermissibleValue(text="Other Hematologic Disorders",
                                 description="Other Hematologic and Lymphocytic Disorder") )
        setattr(cls, "Epithelial Neoplasms, NOS",
                PermissibleValue(text="Epithelial Neoplasms, NOS",
                                 description="Not Otherwise Specified Epithelial Neoplasm") )
        setattr(cls, "Neuroepitheliomatous Neoplasms",
                PermissibleValue(text="Neuroepitheliomatous Neoplasms",
                                 description="Neuroepithelial Neoplasm") )
        setattr(cls, "Specialized Gonadal Neoplasms",
                PermissibleValue(text="Specialized Gonadal Neoplasms",
                                 description="Specialized Gonadal Neoplasm") )
        setattr(cls, "Myomatous Neoplasms",
                PermissibleValue(text="Myomatous Neoplasms",
                                 description="Myomatous Neoplasm") )
        setattr(cls, "Myelodysplastic Syndromes",
                PermissibleValue(text="Myelodysplastic Syndromes",
                                 description="Myelodysplastic Syndrome") )
        setattr(cls, "Mature T- and NK-Cell Lymphomas",
                PermissibleValue(text="Mature T- and NK-Cell Lymphomas",
                                 description="Mature T-Cell and NK-Cell Non-Hodgkin Lymphoma") )
        setattr(cls, "Plasma Cell Tumors",
                PermissibleValue(text="Plasma Cell Tumors",
                                 description="Plasma Cell Neoplasm") )
        setattr(cls, "Giant Cell Tumors",
                PermissibleValue(text="Giant Cell Tumors",
                                 description="Giant Cell Tumor") )
        setattr(cls, "Myxomatous Neoplasms",
                PermissibleValue(text="Myxomatous Neoplasms",
                                 description="Myxoma") )
        setattr(cls, "Miscellaneous Tumors",
                PermissibleValue(text="Miscellaneous Tumors",
                                 description="Miscellaneous Neoplasm") )
        setattr(cls, "Lymphatic Vessel Tumors",
                PermissibleValue(text="Lymphatic Vessel Tumors",
                                 description="Lymphatic Vessel Neoplasm") )
        setattr(cls, "Synovial-like Neoplasms",
                PermissibleValue(text="Synovial-like Neoplasms",
                                 description="Synovial Neoplasm") )
        setattr(cls, "Lipomatous Neoplasms",
                PermissibleValue(text="Lipomatous Neoplasms",
                                 description="Lipomatous Neoplasm") )
        setattr(cls, "Nevi and Melanomas",
                PermissibleValue(text="Nevi and Melanomas",
                                 description="Melanocytic Nevus and Melanoma") )
        setattr(cls, "Malignant Lymphomas, NOS or Diffuse",
                PermissibleValue(text="Malignant Lymphomas, NOS or Diffuse",
                                 description="Not Otherwise Specified or Diffuse Lymphoma") )
        setattr(cls, "Chromophobe Renal Cell Carcinoma",
                PermissibleValue(text="Chromophobe Renal Cell Carcinoma") )
        setattr(cls, "Clear Cell Renal Cell Carcinoma",
                PermissibleValue(text="Clear Cell Renal Cell Carcinoma") )
        setattr(cls, "Thyroid Carcinoma",
                PermissibleValue(text="Thyroid Carcinoma") )
        setattr(cls, "Prostate Adenocarcinoma",
                PermissibleValue(text="Prostate Adenocarcinoma") )
        setattr(cls, "HIV+ Tumor Molecular Characterization Project - Cervical Cancer",
                PermissibleValue(text="HIV+ Tumor Molecular Characterization Project - Cervical Cancer") )
        setattr(cls, "High-Risk Wilms Tumor",
                PermissibleValue(text="High-Risk Wilms Tumor") )
        setattr(cls, "Kidney Renal Papillary Cell Carcinoma",
                PermissibleValue(text="Kidney Renal Papillary Cell Carcinoma") )
        setattr(cls, "Glioblastoma Multiforme",
                PermissibleValue(text="Glioblastoma Multiforme") )
        setattr(cls, "Head and Neck Squamous Cell Carcinoma",
                PermissibleValue(text="Head and Neck Squamous Cell Carcinoma") )
        setattr(cls, "Rectum Adenocarcinoma",
                PermissibleValue(text="Rectum Adenocarcinoma") )
        setattr(cls, "Rhabdoid Tumor",
                PermissibleValue(text="Rhabdoid Tumor") )
        setattr(cls, "Ovarian Serous Cystadenocarcinoma",
                PermissibleValue(text="Ovarian Serous Cystadenocarcinoma") )
        setattr(cls, "HIV+ Tumor Molecular Characterization Project - Lung Cancer",
                PermissibleValue(text="HIV+ Tumor Molecular Characterization Project - Lung Cancer") )
        setattr(cls, "Pancreatic Ductal Adenocarcinoma",
                PermissibleValue(text="Pancreatic Ductal Adenocarcinoma") )
        setattr(cls, "Testicular Germ Cell Tumors",
                PermissibleValue(text="Testicular Germ Cell Tumors") )
        setattr(cls, "Cervical Squamous Cell Carcinoma and Endocervical Adenocarcinoma",
                PermissibleValue(text="Cervical Squamous Cell Carcinoma and Endocervical Adenocarcinoma") )
        setattr(cls, "Liver Hepatocellular Carcinoma",
                PermissibleValue(text="Liver Hepatocellular Carcinoma") )
        setattr(cls, "Kidney Renal Clear Cell Carcinoma",
                PermissibleValue(text="Kidney Renal Clear Cell Carcinoma") )
        setattr(cls, "Hepatocellular Carcinoma",
                PermissibleValue(text="Hepatocellular Carcinoma") )
        setattr(cls, "Kidney Chromophobe",
                PermissibleValue(text="Kidney Chromophobe") )
        setattr(cls, "Skin Cutaneous Melanoma",
                PermissibleValue(text="Skin Cutaneous Melanoma") )
        setattr(cls, "Clear Cell Sarcoma of the Kidney",
                PermissibleValue(text="Clear Cell Sarcoma of the Kidney") )
        setattr(cls, "Bladder Urothelial Carcinoma",
                PermissibleValue(text="Bladder Urothelial Carcinoma") )
        setattr(cls, "Acute Lymphoblastic Leukemia",
                PermissibleValue(text="Acute Lymphoblastic Leukemia") )
        setattr(cls, "Lymphoid Neoplasm Diffuse Large B-cell Lymphoma",
                PermissibleValue(text="Lymphoid Neoplasm Diffuse Large B-cell Lymphoma") )
        setattr(cls, "Burkitt Lymphoma",
                PermissibleValue(text="Burkitt Lymphoma") )
        setattr(cls, "Papillary Renal Cell Carcinoma",
                PermissibleValue(text="Papillary Renal Cell Carcinoma") )
        setattr(cls, "Pheochromocytoma and Paraganglioma",
                PermissibleValue(text="Pheochromocytoma and Paraganglioma") )
        setattr(cls, "Stomach Adenocarcinoma",
                PermissibleValue(text="Stomach Adenocarcinoma") )
        setattr(cls, "Uveal Melanoma",
                PermissibleValue(text="Uveal Melanoma") )
        setattr(cls, "Esophageal Carcinoma",
                PermissibleValue(text="Esophageal Carcinoma") )
        setattr(cls, "Pancreatic Adenocarcinoma",
                PermissibleValue(text="Pancreatic Adenocarcinoma") )
        setattr(cls, "Acute Myeloid Leukemia",
                PermissibleValue(text="Acute Myeloid Leukemia") )
        setattr(cls, "Lung Adenocarcinoma",
                PermissibleValue(text="Lung Adenocarcinoma") )
        setattr(cls, "Multiple Myeloma",
                PermissibleValue(text="Multiple Myeloma") )
        setattr(cls, "Chronic Lymphocytic Leukemia",
                PermissibleValue(text="Chronic Lymphocytic Leukemia") )
        setattr(cls, "Adrenocortical Carcinoma",
                PermissibleValue(text="Adrenocortical Carcinoma") )
        setattr(cls, "Early Onset Gastric Cancer",
                PermissibleValue(text="Early Onset Gastric Cancer") )
        setattr(cls, "Lung Squamous Cell Carcinoma",
                PermissibleValue(text="Lung Squamous Cell Carcinoma") )
        setattr(cls, "Uterine Corpus Endometrial Carcinoma",
                PermissibleValue(text="Uterine Corpus Endometrial Carcinoma") )
        setattr(cls, "Uterine Carcinosarcoma",
                PermissibleValue(text="Uterine Carcinosarcoma") )
        setattr(cls, "Oral Squamous Cell Carcinoma",
                PermissibleValue(text="Oral Squamous Cell Carcinoma") )
        setattr(cls, "Brain Lower Grade Glioma",
                PermissibleValue(text="Brain Lower Grade Glioma") )
        setattr(cls, "Pediatric/AYA Brain Tumors",
                PermissibleValue(text="Pediatric/AYA Brain Tumors") )
        setattr(cls, "Breast Invasive Carcinoma",
                PermissibleValue(text="Breast Invasive Carcinoma") )
        setattr(cls, "Colon Adenocarcinoma",
                PermissibleValue(text="Colon Adenocarcinoma") )

class EnumCRDCHResearchSubjectIndexTimepoint(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H ResearchSubject index_timepoint
    """
    Diagnosis = PermissibleValue(text="Diagnosis",
                                         description="Diagnosis")
    Recurrence = PermissibleValue(text="Recurrence")

    _defn = EnumDefinition(
        name="EnumCRDCHResearchSubjectIndexTimepoint",
        description="Autogenerated Enumeration for CRDC-H ResearchSubject index_timepoint",
        code_set=None,
        code_set_version="2021-09-23T15:59:49.582580+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Study Enrollment",
                PermissibleValue(text="Study Enrollment",
                                 description="Clinical Study Enrollment") )
        setattr(cls, "First Patient Visit",
                PermissibleValue(text="First Patient Visit",
                                 description="First Patient Visit") )
        setattr(cls, "First Treatment",
                PermissibleValue(text="First Treatment") )
        setattr(cls, "Sample Procurement",
                PermissibleValue(text="Sample Procurement",
                                 description="Tissue Procurement") )
        setattr(cls, "Initial Genomic Sequencing",
                PermissibleValue(text="Initial Genomic Sequencing") )

class EnumCRDCHSpecimenSpecimenType(EnumDefinitionImpl):
    """
    A high-level type of specimen, based on its derivation provenance (i.e. how far removed it is from the original
    sample extracted from a source).
    """
    portion = PermissibleValue(text="portion",
                                     description="A physical sub-part taken from an existing specimen.")
    aliquot = PermissibleValue(text="aliquot",
                                     description="A specimen that results from the division of some parent specimen into equal amounts for downstream analysis.")
    analyte = PermissibleValue(text="analyte",
                                     description="A specimen generated through the extraction of a specified class of substance/chemical (e.g. DNA, RNA, protein) from a parent specimen, which is stored in solution as an analyte.")
    slide = PermissibleValue(text="slide",
                                 description="A specimen that is mounted on a slide or coverslip for microscopic analysis.")

    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenSpecimenType",
        description="A high-level type of specimen, based on its derivation provenance (i.e. how far removed it is from the original sample extracted from a source).",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Fresh Specimen",
                PermissibleValue(text="Fresh Specimen",
                                 description="A specimen representing the material that was directly collected from a subject (i.e. not generated through portioning, aliquoting, or analyte extraction from an existing specimen).") )

class EnumCRDCHSpecimenAnalyteType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Specimen analyte_type
    """
    cfDNA = PermissibleValue(text="cfDNA")
    DNA = PermissibleValue(text="DNA",
                             description="DNA")
    RNA = PermissibleValue(text="RNA",
                             description="Ribonucleic Acid")
    H = PermissibleValue(text="H",
                         description="Hybrid Extraction RNA")
    E = PermissibleValue(text="E")
    X = PermissibleValue(text="X",
                         description="Repli-G X (Qiagen) DNA")
    G = PermissibleValue(text="G",
                         description="GenomePlex (Rubicon) Amplified DNA")
    T = PermissibleValue(text="T",
                         description="Total Ribonucleic Acid")
    R = PermissibleValue(text="R",
                         description="Ribonucleic Acid")
    S = PermissibleValue(text="S")
    D = PermissibleValue(text="D",
                         description="DNA")
    W = PermissibleValue(text="W",
                         description="Repli-G (Qiagen) DNA")
    Y = PermissibleValue(text="Y")
    Protein = PermissibleValue(text="Protein",
                                     description="Protein")

    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenAnalyteType",
        description="Autogenerated Enumeration for CRDC-H Specimen analyte_type",
        code_set=None,
        code_set_version="2021-09-23T15:59:49.794691+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Repli-G (Qiagen) DNA",
                PermissibleValue(text="Repli-G (Qiagen) DNA",
                                 description="Repli-G (Qiagen) DNA") )
        setattr(cls, "FFPE RNA",
                PermissibleValue(text="FFPE RNA",
                                 description="Formalin-Fixed Paraffin-Embedded RNA") )
        setattr(cls, "Repli-G Pooled (Qiagen) DNA",
                PermissibleValue(text="Repli-G Pooled (Qiagen) DNA",
                                 description="REPLI-g Pooled DNA") )
        setattr(cls, "FFPE DNA",
                PermissibleValue(text="FFPE DNA",
                                 description="Formalin-Fixed Paraffin-Embedded DNA") )
        setattr(cls, "Nuclei RNA",
                PermissibleValue(text="Nuclei RNA") )
        setattr(cls, "Total RNA",
                PermissibleValue(text="Total RNA",
                                 description="Total Ribonucleic Acid") )
        setattr(cls, "EBV Immortalized Normal",
                PermissibleValue(text="EBV Immortalized Normal",
                                 description="Normal Epstein-Barr Virus Immortalization") )
        setattr(cls, "Repli-G X (Qiagen) DNA",
                PermissibleValue(text="Repli-G X (Qiagen) DNA",
                                 description="Repli-G X (Qiagen) DNA") )
        setattr(cls, "GenomePlex (Rubicon) Amplified DNA",
                PermissibleValue(text="GenomePlex (Rubicon) Amplified DNA") )

class EnumCRDCHSpecimenSourceMaterialType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Specimen source_material_type
    """
    Tumor = PermissibleValue(text="Tumor",
                                 description="Neoplasm")
    RNA = PermissibleValue(text="RNA")
    Granulocytes = PermissibleValue(text="Granulocytes",
                                               description="Granulocyte")
    Slides = PermissibleValue(text="Slides")
    DNA = PermissibleValue(text="DNA")
    Unknown = PermissibleValue(text="Unknown")
    Metastatic = PermissibleValue(text="Metastatic")
    Saliva = PermissibleValue(text="Saliva",
                                   description="Saliva")

    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenSourceMaterialType",
        description="Autogenerated Enumeration for CRDC-H Specimen source_material_type",
        code_set=None,
        code_set_version="2021-09-23T15:59:49.998382+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Recurrent Blood Derived Cancer - Bone Marrow",
                PermissibleValue(text="Recurrent Blood Derived Cancer - Bone Marrow") )
        setattr(cls, "Fibroblasts from Bone Marrow Normal",
                PermissibleValue(text="Fibroblasts from Bone Marrow Normal") )
        setattr(cls, "Buccal Cell Normal",
                PermissibleValue(text="Buccal Cell Normal") )
        setattr(cls, "Lymphoid Normal",
                PermissibleValue(text="Lymphoid Normal") )
        setattr(cls, "Blood Derived Cancer - Peripheral Blood, Post-treatment",
                PermissibleValue(text="Blood Derived Cancer - Peripheral Blood, Post-treatment") )
        setattr(cls, "Solid Tissue Normal",
                PermissibleValue(text="Solid Tissue Normal") )
        setattr(cls, "Repli-G (Qiagen) DNA",
                PermissibleValue(text="Repli-G (Qiagen) DNA") )
        setattr(cls, "Blood Derived Cancer - Bone Marrow",
                PermissibleValue(text="Blood Derived Cancer - Bone Marrow") )
        setattr(cls, "Primary Xenograft Tissue",
                PermissibleValue(text="Primary Xenograft Tissue") )
        setattr(cls, "Cell Lines",
                PermissibleValue(text="Cell Lines") )
        setattr(cls, "Primary Tumor",
                PermissibleValue(text="Primary Tumor",
                                 description="Primary Neoplasm") )
        setattr(cls, "FFPE Recurrent",
                PermissibleValue(text="FFPE Recurrent") )
        setattr(cls, "Pleural Effusion",
                PermissibleValue(text="Pleural Effusion") )
        setattr(cls, "Benign Neoplasms",
                PermissibleValue(text="Benign Neoplasms") )
        setattr(cls, "Recurrent Tumor",
                PermissibleValue(text="Recurrent Tumor") )
        setattr(cls, "Normal Adjacent Tissue",
                PermissibleValue(text="Normal Adjacent Tissue") )
        setattr(cls, "Control Analyte",
                PermissibleValue(text="Control Analyte") )
        setattr(cls, "Blood Derived Liquid Biopsy",
                PermissibleValue(text="Blood Derived Liquid Biopsy") )
        setattr(cls, "Post neo-adjuvant therapy",
                PermissibleValue(text="Post neo-adjuvant therapy") )
        setattr(cls, "Not Reported",
                PermissibleValue(text="Not Reported") )
        setattr(cls, "FFPE Scrolls",
                PermissibleValue(text="FFPE Scrolls",
                                 description="Formalin Fixed Paraffin Embedded Tissue Scroll") )
        setattr(cls, "Primary Blood Derived Cancer - Peripheral Blood",
                PermissibleValue(text="Primary Blood Derived Cancer - Peripheral Blood") )
        setattr(cls, "Primary Blood Derived Cancer - Bone Marrow",
                PermissibleValue(text="Primary Blood Derived Cancer - Bone Marrow") )
        setattr(cls, "Human Tumor Original Cells",
                PermissibleValue(text="Human Tumor Original Cells") )
        setattr(cls, "Expanded Next Generation Cancer Model",
                PermissibleValue(text="Expanded Next Generation Cancer Model") )
        setattr(cls, "In Situ Neoplasms",
                PermissibleValue(text="In Situ Neoplasms") )
        setattr(cls, "GenomePlex (Rubicon) Amplified DNA",
                PermissibleValue(text="GenomePlex (Rubicon) Amplified DNA") )
        setattr(cls, "Additional Metastatic",
                PermissibleValue(text="Additional Metastatic") )
        setattr(cls, "Blood Derived Normal",
                PermissibleValue(text="Blood Derived Normal") )
        setattr(cls, "Bone Marrow Normal",
                PermissibleValue(text="Bone Marrow Normal") )
        setattr(cls, "Neoplasms of Uncertain and Unknown Behavior",
                PermissibleValue(text="Neoplasms of Uncertain and Unknown Behavior") )
        setattr(cls, "Not Allowed To Collect",
                PermissibleValue(text="Not Allowed To Collect") )
        setattr(cls, "Blood Derived Cancer - Peripheral Blood",
                PermissibleValue(text="Blood Derived Cancer - Peripheral Blood") )
        setattr(cls, "EBV Immortalized Normal",
                PermissibleValue(text="EBV Immortalized Normal") )
        setattr(cls, "Recurrent Blood Derived Cancer - Peripheral Blood",
                PermissibleValue(text="Recurrent Blood Derived Cancer - Peripheral Blood") )
        setattr(cls, "Repli-G X (Qiagen) DNA",
                PermissibleValue(text="Repli-G X (Qiagen) DNA") )
        setattr(cls, "Next Generation Cancer Model",
                PermissibleValue(text="Next Generation Cancer Model") )
        setattr(cls, "Additional - New Primary",
                PermissibleValue(text="Additional - New Primary") )
        setattr(cls, "Blood Derived Cancer - Bone Marrow, Post-treatment",
                PermissibleValue(text="Blood Derived Cancer - Bone Marrow, Post-treatment") )
        setattr(cls, "Total RNA",
                PermissibleValue(text="Total RNA") )
        setattr(cls, "Cell Line Derived Xenograft Tissue",
                PermissibleValue(text="Cell Line Derived Xenograft Tissue") )
        setattr(cls, "Xenograft Tissue",
                PermissibleValue(text="Xenograft Tissue") )
        setattr(cls, "Tumor Adjacent Normal - Post Neo-adjuvant Therapy",
                PermissibleValue(text="Tumor Adjacent Normal - Post Neo-adjuvant Therapy") )
        setattr(cls, "Mononuclear Cells from Bone Marrow Normal",
                PermissibleValue(text="Mononuclear Cells from Bone Marrow Normal") )
        setattr(cls, "Mixed Adherent Suspension",
                PermissibleValue(text="Mixed Adherent Suspension") )
        setattr(cls, "85",
                PermissibleValue(text="85") )
        setattr(cls, "08",
                PermissibleValue(text="08") )
        setattr(cls, "09",
                PermissibleValue(text="09") )
        setattr(cls, "10",
                PermissibleValue(text="10") )
        setattr(cls, "60",
                PermissibleValue(text="60") )
        setattr(cls, "86",
                PermissibleValue(text="86") )
        setattr(cls, "50",
                PermissibleValue(text="50") )
        setattr(cls, "42",
                PermissibleValue(text="42") )
        setattr(cls, "02",
                PermissibleValue(text="02") )
        setattr(cls, "99",
                PermissibleValue(text="99") )
        setattr(cls, "20",
                PermissibleValue(text="20") )
        setattr(cls, "03",
                PermissibleValue(text="03") )
        setattr(cls, "18",
                PermissibleValue(text="18") )
        setattr(cls, "17",
                PermissibleValue(text="17") )
        setattr(cls, "07",
                PermissibleValue(text="07") )
        setattr(cls, "06",
                PermissibleValue(text="06") )
        setattr(cls, "15",
                PermissibleValue(text="15") )
        setattr(cls, "11",
                PermissibleValue(text="11") )
        setattr(cls, "01",
                PermissibleValue(text="01") )
        setattr(cls, "61",
                PermissibleValue(text="61") )
        setattr(cls, "04",
                PermissibleValue(text="04") )
        setattr(cls, "16",
                PermissibleValue(text="16") )
        setattr(cls, "13",
                PermissibleValue(text="13") )
        setattr(cls, "41",
                PermissibleValue(text="41") )
        setattr(cls, "30",
                PermissibleValue(text="30") )
        setattr(cls, "31",
                PermissibleValue(text="31") )
        setattr(cls, "14",
                PermissibleValue(text="14") )
        setattr(cls, "32",
                PermissibleValue(text="32") )
        setattr(cls, "05",
                PermissibleValue(text="05") )
        setattr(cls, "12",
                PermissibleValue(text="12") )
        setattr(cls, "40",
                PermissibleValue(text="40") )

class EnumCRDCHSpecimenTumorStatusAtCollection(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Specimen tumor_status_at_collection
    """
    recurrence = PermissibleValue(text="recurrence")
    other = PermissibleValue(text="other")
    metastasis = PermissibleValue(text="metastasis")
    Unknown = PermissibleValue(text="Unknown")
    primary = PermissibleValue(text="primary")
    Xenograft = PermissibleValue(text="Xenograft",
                                         description="Xenograft")
    Premalignant = PermissibleValue(text="Premalignant",
                                               description="Premalignant")
    NOS = PermissibleValue(text="NOS",
                             description="Not Otherwise Specified")
    Primary = PermissibleValue(text="Primary",
                                     description="Primary Untreated Malignant Tumor Tissue")
    Metastatic = PermissibleValue(text="Metastatic",
                                           description="Metastatic Tumor Tissue")
    Recurrence = PermissibleValue(text="Recurrence")
    Progression = PermissibleValue(text="Progression")

    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenTumorStatusAtCollection",
        description="Autogenerated Enumeration for CRDC-H Specimen tumor_status_at_collection",
        code_set=None,
        code_set_version="2021-09-23T15:59:50.173359+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Not Allowed To Collect",
                PermissibleValue(text="Not Allowed To Collect") )
        setattr(cls, "not reported",
                PermissibleValue(text="not reported") )
        setattr(cls, "Not Applicable",
                PermissibleValue(text="Not Applicable") )
        setattr(cls, "Not Reported",
                PermissibleValue(text="Not Reported") )

class EnumCRDCHSpecimenCellularCompositionType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Specimen cellular_composition_type
    """
    Lymphocytes = PermissibleValue(text="Lymphocytes",
                                             description="Lymphocyte")
    Plasma = PermissibleValue(text="Plasma",
                                   description="Plasma")
    Unknown = PermissibleValue(text="Unknown")
    Sputum = PermissibleValue(text="Sputum",
                                   description="Sputum")
    Saliva = PermissibleValue(text="Saliva",
                                   description="Saliva")
    Granulocytes = PermissibleValue(text="Granulocytes",
                                               description="Granulocyte")
    Cell = PermissibleValue(text="Cell",
                               description="Cell")
    Serum = PermissibleValue(text="Serum",
                                 description="Serum")

    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenCellularCompositionType",
        description="Autogenerated Enumeration for CRDC-H Specimen cellular_composition_type",
        code_set=None,
        code_set_version="2021-09-23T15:59:50.297953+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Derived Cell Line",
                PermissibleValue(text="Derived Cell Line",
                                 description="Derived Cell Line") )
        setattr(cls, "Peripheral Whole Blood",
                PermissibleValue(text="Peripheral Whole Blood",
                                 description="Peripheral Whole Blood") )
        setattr(cls, "2D Classical Conditionally Reprogrammed Cells",
                PermissibleValue(text="2D Classical Conditionally Reprogrammed Cells") )
        setattr(cls, "Fibroblasts from Bone Marrow Normal",
                PermissibleValue(text="Fibroblasts from Bone Marrow Normal",
                                 description="Normal Bone Marrow Fibroblast") )
        setattr(cls, "Human Original Cells",
                PermissibleValue(text="Human Original Cells") )
        setattr(cls, "Peripheral Blood Components NOS",
                PermissibleValue(text="Peripheral Blood Components NOS",
                                 description="Peripheral Blood Component Not Otherwise Specified") )
        setattr(cls, "3D Neurosphere",
                PermissibleValue(text="3D Neurosphere") )
        setattr(cls, "Bone Marrow Components",
                PermissibleValue(text="Bone Marrow Components",
                                 description="Bone Marrow Component") )
        setattr(cls, "Control Analyte",
                PermissibleValue(text="Control Analyte",
                                 description="Control Analyte") )
        setattr(cls, "Sorted Cells",
                PermissibleValue(text="Sorted Cells") )
        setattr(cls, "Not Reported",
                PermissibleValue(text="Not Reported") )
        setattr(cls, "2D Modified Conditionally Reprogrammed Cells",
                PermissibleValue(text="2D Modified Conditionally Reprogrammed Cells") )
        setattr(cls, "Mononuclear Cells from Bone Marrow Normal",
                PermissibleValue(text="Mononuclear Cells from Bone Marrow Normal",
                                 description="Normal Bone Marrow Monocyte") )
        setattr(cls, "Solid Tissue",
                PermissibleValue(text="Solid Tissue",
                                 description="Solid Tissue") )
        setattr(cls, "Whole Bone Marrow",
                PermissibleValue(text="Whole Bone Marrow",
                                 description="Whole Bone Marrow") )
        setattr(cls, "Mixed Adherent Suspension",
                PermissibleValue(text="Mixed Adherent Suspension") )
        setattr(cls, "3D Air-Liquid Interface Organoid",
                PermissibleValue(text="3D Air-Liquid Interface Organoid") )
        setattr(cls, "Liquid Suspension Cell Line",
                PermissibleValue(text="Liquid Suspension Cell Line") )
        setattr(cls, "Buccal Cells",
                PermissibleValue(text="Buccal Cells",
                                 description="Buccal Cell") )
        setattr(cls, "EBV Immortalized",
                PermissibleValue(text="EBV Immortalized",
                                 description="Epstein-Barr Virus Immortalized") )
        setattr(cls, "Buffy Coat",
                PermissibleValue(text="Buffy Coat",
                                 description="Buffy Coat") )
        setattr(cls, "Bone Marrow Components NOS",
                PermissibleValue(text="Bone Marrow Components NOS",
                                 description="Bone Marrow Component Not Otherwise Specified") )
        setattr(cls, "Pleural Effusion",
                PermissibleValue(text="Pleural Effusion",
                                 description="Pleural Fluid") )
        setattr(cls, "Adherent Cell Line",
                PermissibleValue(text="Adherent Cell Line") )
        setattr(cls, "3D Organoid",
                PermissibleValue(text="3D Organoid") )
        setattr(cls, "Not Allowed To Collect",
                PermissibleValue(text="Not Allowed To Collect") )

class EnumCRDCHSpecimenGeneralTissuePathology(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Specimen general_tissue_pathology
    """
    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenGeneralTissuePathology",
        description="Autogenerated Enumeration for CRDC-H Specimen general_tissue_pathology",
        code_set=None,
        code_set_version="2021-09-23T15:59:50.438372+00:00",
    )

class EnumCRDCHSpecimenSpecificTissuePathology(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Specimen specific_tissue_pathology
    """
    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenSpecificTissuePathology",
        description="Autogenerated Enumeration for CRDC-H Specimen specific_tissue_pathology",
        code_set=None,
        code_set_version="2021-09-23T15:59:50.540261+00:00",
    )

class EnumCRDCHSpecimenPreinvasiveTissueMorphology(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Specimen preinvasive_tissue_morphology
    """
    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenPreinvasiveTissueMorphology",
        description="Autogenerated Enumeration for CRDC-H Specimen preinvasive_tissue_morphology",
        code_set=None,
        code_set_version="2021-09-23T15:59:50.640876+00:00",
    )

class EnumCRDCHSpecimenMorphologyAssessorRole(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Specimen morphology_assessor_role
    """
    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenMorphologyAssessorRole",
        description="Autogenerated Enumeration for CRDC-H Specimen morphology_assessor_role",
        code_set=None,
        code_set_version="2021-09-23T15:59:50.744602+00:00",
    )

class EnumCRDCHSpecimenMorphologyAssessmentMethod(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Specimen morphology_assessment_method
    """
    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenMorphologyAssessmentMethod",
        description="Autogenerated Enumeration for CRDC-H Specimen morphology_assessment_method",
        code_set=None,
        code_set_version="2021-09-23T15:59:50.844091+00:00",
    )

class EnumCRDCHSpecimenDegreeOfDysplasia(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Specimen degree_of_dysplasia
    """
    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenDegreeOfDysplasia",
        description="Autogenerated Enumeration for CRDC-H Specimen degree_of_dysplasia",
        code_set=None,
        code_set_version="2021-09-23T15:59:50.947642+00:00",
    )

class EnumCRDCHSpecimenSectionLocation(EnumDefinitionImpl):
    """
    The location in a parent specimen from which a section/portion was excised.
    """
    top = PermissibleValue(text="top",
                             description="The part of a specimen designated as its 'top' based on specified orientation criteria.")
    unknown = PermissibleValue(text="unknown",
                                     description="An unknown location on a specimen.")
    bottom = PermissibleValue(text="bottom",
                                   description="The part of a specimen designated as its 'bottom' based on specified orientation criteria.")

    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenSectionLocation",
        description="The location in a parent specimen from which a section/portion was excised.",
    )

class EnumCRDCHSpecimenContainerContainerType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H SpecimenContainer container_type
    """
    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenContainerContainerType",
        description="Autogenerated Enumeration for CRDC-H SpecimenContainer container_type",
        code_set=None,
        code_set_version="2021-09-23T15:59:51.146541+00:00",
    )

class EnumCRDCHSpecimenCreationActivityActivityType(EnumDefinitionImpl):
    """
    The high-level type of activity through which the specimen was generated (i.e. via collection from the original
    source, or via derivation from an existing specimen)
    """
    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenCreationActivityActivityType",
        description="The high-level type of activity through which the specimen was generated (i.e. via collection from the original source, or via derivation from an existing specimen)",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "collection from source",
                PermissibleValue(text="collection from source",
                                 description="An activity that collects an initial sample directly from a subject / source.") )
        setattr(cls, "derivation from specimen",
                PermissibleValue(text="derivation from specimen",
                                 description="An activity that derives a new specimen from an existing one.") )

class EnumCRDCHSpecimenCreationActivityCollectionMethodType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H SpecimenCreationActivity collection_method_type
    """
    Yes = PermissibleValue(text="Yes")
    No = PermissibleValue(text="No")
    Oophorectomy = PermissibleValue(text="Oophorectomy")
    Pneumonectomy = PermissibleValue(text="Pneumonectomy")
    Lumpectomy = PermissibleValue(text="Lumpectomy")
    Unknown = PermissibleValue(text="Unknown")
    Pancreatectomy = PermissibleValue(text="Pancreatectomy")
    Thoracentesis = PermissibleValue(text="Thoracentesis")
    Salpingectomy = PermissibleValue(text="Salpingectomy")
    Enucleation = PermissibleValue(text="Enucleation")
    Aspirate = PermissibleValue(text="Aspirate")
    Orchiectomy = PermissibleValue(text="Orchiectomy")
    Autopsy = PermissibleValue(text="Autopsy")
    Lymphadenectomy = PermissibleValue(text="Lymphadenectomy")
    Lobectomy = PermissibleValue(text="Lobectomy")
    Cystectomy = PermissibleValue(text="Cystectomy")
    Transplant = PermissibleValue(text="Transplant")
    Biopsy = PermissibleValue(text="Biopsy")
    Paracentesis = PermissibleValue(text="Paracentesis")
    Omentectomy = PermissibleValue(text="Omentectomy")
    Indeterminant = PermissibleValue(text="Indeterminant")
    Metastasectomy = PermissibleValue(text="Metastasectomy")
    Other = PermissibleValue(text="Other")
    Glossectomy = PermissibleValue(text="Glossectomy")
    Mandibulectomy = PermissibleValue(text="Mandibulectomy")
    Laryngopharyngectomy = PermissibleValue(text="Laryngopharyngectomy")
    Tonsillectomy = PermissibleValue(text="Tonsillectomy")
    Maxillectomy = PermissibleValue(text="Maxillectomy")
    Palatectomy = PermissibleValue(text="Palatectomy")

    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenCreationActivityCollectionMethodType",
        description="Autogenerated Enumeration for CRDC-H SpecimenCreationActivity collection_method_type",
        code_set=None,
        code_set_version="2021-09-23T15:59:51.344660+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Peritoneal Lavage",
                PermissibleValue(text="Peritoneal Lavage") )
        setattr(cls, "Anterior Resection of Rectum",
                PermissibleValue(text="Anterior Resection of Rectum") )
        setattr(cls, "Not Reported",
                PermissibleValue(text="Not Reported") )
        setattr(cls, "Full Hysterectomy",
                PermissibleValue(text="Full Hysterectomy") )
        setattr(cls, "Salpingo-oophorectomy",
                PermissibleValue(text="Salpingo-oophorectomy") )
        setattr(cls, "Transurethral resection (TURBT)",
                PermissibleValue(text="Transurethral resection (TURBT)") )
        setattr(cls, "Right Hemicolectomy",
                PermissibleValue(text="Right Hemicolectomy") )
        setattr(cls, "Endoscopic Mucosal Resection (EMR)",
                PermissibleValue(text="Endoscopic Mucosal Resection (EMR)") )
        setattr(cls, "Surgical Resection",
                PermissibleValue(text="Surgical Resection") )
        setattr(cls, "Laparoscopic Partial Nephrectomy",
                PermissibleValue(text="Laparoscopic Partial Nephrectomy") )
        setattr(cls, "Endo Rectal Tumor Resection",
                PermissibleValue(text="Endo Rectal Tumor Resection") )
        setattr(cls, "Hand Assisted Laparoscopic Radical Nephrectomy",
                PermissibleValue(text="Hand Assisted Laparoscopic Radical Nephrectomy") )
        setattr(cls, "Whipple Procedure",
                PermissibleValue(text="Whipple Procedure") )
        setattr(cls, "Bone Marrow Aspirate",
                PermissibleValue(text="Bone Marrow Aspirate") )
        setattr(cls, "Core Biopsy",
                PermissibleValue(text="Core Biopsy") )
        setattr(cls, "Laparoscopic Biopsy",
                PermissibleValue(text="Laparoscopic Biopsy") )
        setattr(cls, "Radical Hysterectomy",
                PermissibleValue(text="Radical Hysterectomy") )
        setattr(cls, "Punch Biopsy",
                PermissibleValue(text="Punch Biopsy") )
        setattr(cls, "Left Hemicolectomy",
                PermissibleValue(text="Left Hemicolectomy") )
        setattr(cls, "Simple Mastectomy",
                PermissibleValue(text="Simple Mastectomy") )
        setattr(cls, "Total Hepatectomy",
                PermissibleValue(text="Total Hepatectomy") )
        setattr(cls, "Incisional Biopsy",
                PermissibleValue(text="Incisional Biopsy") )
        setattr(cls, "Blood Draw",
                PermissibleValue(text="Blood Draw") )
        setattr(cls, "Pan-Procto Colectomy",
                PermissibleValue(text="Pan-Procto Colectomy") )
        setattr(cls, "Laparoscopic Radical Prostatectomy with Robotics",
                PermissibleValue(text="Laparoscopic Radical Prostatectomy with Robotics") )
        setattr(cls, "Not Allowed To Collect",
                PermissibleValue(text="Not Allowed To Collect") )
        setattr(cls, "Supracervical Hysterectomy",
                PermissibleValue(text="Supracervical Hysterectomy") )
        setattr(cls, "Ascites Drainage",
                PermissibleValue(text="Ascites Drainage") )
        setattr(cls, "Sigmoid Colectomy",
                PermissibleValue(text="Sigmoid Colectomy") )
        setattr(cls, "Tumor Resection",
                PermissibleValue(text="Tumor Resection") )
        setattr(cls, "Hysterectomy NOS",
                PermissibleValue(text="Hysterectomy NOS") )
        setattr(cls, "Total Mastectomy",
                PermissibleValue(text="Total Mastectomy") )
        setattr(cls, "Needle Biopsy",
                PermissibleValue(text="Needle Biopsy") )
        setattr(cls, "Laparoscopic Radical Prostatectomy without Robotics",
                PermissibleValue(text="Laparoscopic Radical Prostatectomy without Robotics") )
        setattr(cls, "Fine Needle Aspiration",
                PermissibleValue(text="Fine Needle Aspiration") )
        setattr(cls, "Subtotal Resection",
                PermissibleValue(text="Subtotal Resection") )
        setattr(cls, "Modified Radical Mastectomy",
                PermissibleValue(text="Modified Radical Mastectomy") )
        setattr(cls, "Tumor Debulking",
                PermissibleValue(text="Tumor Debulking") )
        setattr(cls, "Partial Hepatectomy",
                PermissibleValue(text="Partial Hepatectomy") )
        setattr(cls, "Wedge Resection",
                PermissibleValue(text="Wedge Resection") )
        setattr(cls, "Open Radical Nephrectomy",
                PermissibleValue(text="Open Radical Nephrectomy") )
        setattr(cls, "Laparoscopic Radical Nephrectomy",
                PermissibleValue(text="Laparoscopic Radical Nephrectomy") )
        setattr(cls, "Simple Hysterectomy",
                PermissibleValue(text="Simple Hysterectomy") )
        setattr(cls, "Total Colectomy",
                PermissibleValue(text="Total Colectomy") )
        setattr(cls, "Open Partial Nephrectomy",
                PermissibleValue(text="Open Partial Nephrectomy") )
        setattr(cls, "Open Craniotomy",
                PermissibleValue(text="Open Craniotomy") )
        setattr(cls, "Thoracoscopic Biopsy",
                PermissibleValue(text="Thoracoscopic Biopsy") )
        setattr(cls, "Liquid Biopsy",
                PermissibleValue(text="Liquid Biopsy") )
        setattr(cls, "Abdomino-perineal Resection of Rectum",
                PermissibleValue(text="Abdomino-perineal Resection of Rectum") )
        setattr(cls, "Endoscopic Biopsy",
                PermissibleValue(text="Endoscopic Biopsy") )
        setattr(cls, "Transverse Colectomy",
                PermissibleValue(text="Transverse Colectomy") )
        setattr(cls, "Open Radical Prostatectomy",
                PermissibleValue(text="Open Radical Prostatectomy") )
        setattr(cls, "Excisional Biopsy",
                PermissibleValue(text="Excisional Biopsy") )
        setattr(cls, "Other Surgical Resection",
                PermissibleValue(text="Other Surgical Resection") )
        setattr(cls, "Local Resection (Exoresection; wall resection)",
                PermissibleValue(text="Local Resection (Exoresection; wall resection)") )
        setattr(cls, "Gross Total Resection",
                PermissibleValue(text="Gross Total Resection") )
        setattr(cls, "Lymph Node Dissection",
                PermissibleValue(text="Lymph Node Dissection") )
        setattr(cls, "Total Nephrectomy",
                PermissibleValue(text="Total Nephrectomy") )
        setattr(cls, "Parotidectomy, NOS",
                PermissibleValue(text="Parotidectomy, NOS") )
        setattr(cls, "Partial Maxillectomy",
                PermissibleValue(text="Partial Maxillectomy") )
        setattr(cls, "Partial Nephrectomy",
                PermissibleValue(text="Partial Nephrectomy") )
        setattr(cls, "Buccal Mucosal Resection",
                PermissibleValue(text="Buccal Mucosal Resection") )
        setattr(cls, "Total Laryngectomy",
                PermissibleValue(text="Total Laryngectomy") )
        setattr(cls, "Radical Nephrectomy",
                PermissibleValue(text="Radical Nephrectomy") )
        setattr(cls, "Subtotal Prostatectomy",
                PermissibleValue(text="Subtotal Prostatectomy") )
        setattr(cls, "Transurethral Resection (TURP)",
                PermissibleValue(text="Transurethral Resection (TURP)") )
        setattr(cls, "Endolaryngeal Excision",
                PermissibleValue(text="Endolaryngeal Excision") )
        setattr(cls, "Supracricoid Laryngectomy",
                PermissibleValue(text="Supracricoid Laryngectomy") )
        setattr(cls, "Radical Maxillectomy",
                PermissibleValue(text="Radical Maxillectomy") )
        setattr(cls, "Superficial Parotidectomy",
                PermissibleValue(text="Superficial Parotidectomy") )
        setattr(cls, "Deep Parotidectomy",
                PermissibleValue(text="Deep Parotidectomy") )
        setattr(cls, "Supraglottic Laryngectomy",
                PermissibleValue(text="Supraglottic Laryngectomy") )
        setattr(cls, "Radical Prostatectomy",
                PermissibleValue(text="Radical Prostatectomy") )
        setattr(cls, "Partial Laryngectomy",
                PermissibleValue(text="Partial Laryngectomy") )
        setattr(cls, "Vertical Hemilaryngectomy",
                PermissibleValue(text="Vertical Hemilaryngectomy") )
        setattr(cls, "Transoral Laser Excision",
                PermissibleValue(text="Transoral Laser Excision") )

class EnumCRDCHSpecimenCreationActivityDerivationMethodType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H SpecimenCreationActivity derivation_method_type
    """
    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenCreationActivityDerivationMethodType",
        description="Autogenerated Enumeration for CRDC-H SpecimenCreationActivity derivation_method_type",
        code_set=None,
        code_set_version="2021-09-23T15:59:51.535313+00:00",
    )

class EnumCRDCHSpecimenQualityObservationCategory(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H SpecimenQualityObservation category
    """
    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenQualityObservationCategory",
        description="Autogenerated Enumeration for CRDC-H SpecimenQualityObservation category",
        code_set=None,
        code_set_version="2021-09-23T15:59:51.634867+00:00",
    )

class EnumCRDCHSpecimenQualityObservationObservationType(EnumDefinitionImpl):
    """
    Types of measurements that reflect the quality of a specimen or its suitability for use.
    """
    ribosomal_rna_28s_16s_ratio = PermissibleValue(text="ribosomal_rna_28s_16s_ratio",
                                                                             description="Ratio of quantity of 28s RNA over that of 16s RNA.")

    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenQualityObservationObservationType",
        description="Types of measurements that reflect the quality of a specimen or its suitability for use.",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "a260_a280_ratio  ",
                PermissibleValue(text="a260_a280_ratio  ",
                                 description="Ratio of absorbance measured at a wavelength of 260 over that at a wavelength of 280.") )

class EnumCRDCHSpecimenQualityObservationMethodType(EnumDefinitionImpl):
    """
    A type of method used in determining the quantity of a specimen.
    """
    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenQualityObservationMethodType",
        description="A type of method used in determining the quantity of a specimen.",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "UV Spec",
                PermissibleValue(text="UV Spec",
                                 description="A technique used to measure light absorbance across the ultraviolet and visible ranges of the electromagnetic spectrum.") )
        setattr(cls, "Pico Green",
                PermissibleValue(text="Pico Green",
                                 description="A technique applying the Pico488 fluorescent sensor dye that is used for quantifying the amount of double-stranded DNA (dsDNA) present in a given sample.") )

class EnumCRDCHSpecimenQuantityObservationCategory(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H SpecimenQuantityObservation category
    """
    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenQuantityObservationCategory",
        description="Autogenerated Enumeration for CRDC-H SpecimenQuantityObservation category",
        code_set=None,
        code_set_version="2021-09-23T15:59:51.957965+00:00",
    )

class EnumCRDCHSpecimenQuantityObservationObservationType(EnumDefinitionImpl):
    """
    Measures related to the quantity of a specimen or analyte it currently contains - e.g. its weight, volume, or
    concentration.
    """
    weight = PermissibleValue(text="weight",
                                   description="The current weight of the specimen, at the time of recording (as opposed to an initial weight before its processing or portioning).")
    volume = PermissibleValue(text="volume",
                                   description="The current total volume of the specimen, at the time of recording.")
    concentration = PermissibleValue(text="concentration",
                                                 description="The concentration of an extracted analyte that is present in a specimen (specifically, in a specimen of type 'analyte', or an 'aliquot' derived from an analyte). For example, the concentration of DNA in a specimen created through extracting DNA from a blood sample.")

    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenQuantityObservationObservationType",
        description="Measures related to the quantity of a specimen or analyte it currently contains - e.g. its weight, volume, or concentration.",
    )

class EnumCRDCHSpecimenQuantityObservationMethodType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H SpecimenQuantityObservation method_type
    """
    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenQuantityObservationMethodType",
        description="Autogenerated Enumeration for CRDC-H SpecimenQuantityObservation method_type",
        code_set=None,
        code_set_version="2021-09-23T15:59:52.158090+00:00",
    )

class EnumCRDCHSpecimenProcessingActivityActivityType(EnumDefinitionImpl):
    """
    The high-level type of processing activity performed.
    """
    Fixation = PermissibleValue(text="Fixation",
                                       description="A processing activity that applies chemicals to preserve biological tissues from decay due to autolysis or putrefaction")
    Freezing = PermissibleValue(text="Freezing",
                                       description="A processing activity that aims to freeze a specimen.")
    Mounting = PermissibleValue(text="Mounting",
                                       description="A processing activity that aims to secure a specimen or slide in place in preparation for further examination (usually via microscopy)")
    Preservation = PermissibleValue(text="Preservation",
                                               description="A processing activity that aims to preserve a specimen.")

    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenProcessingActivityActivityType",
        description="The high-level type of processing activity performed.",
    )

class EnumCRDCHSpecimenProcessingActivityMethodType(EnumDefinitionImpl):
    """
    A type of method used to process a specimen (e.g. freezing, fixing, treating, preserving, labeling, etc.).
    """
    LN2 = PermissibleValue(text="LN2",
                             description="Freezing in liquid nitrogen.")
    isopentane = PermissibleValue(text="isopentane",
                                           description="Freezing in isopentane.")

    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenProcessingActivityMethodType",
        description="A type of method used to process a specimen (e.g. freezing, fixing, treating, preserving, labeling, etc.).",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Minues 80 Degrees Celsius Freezer",
                PermissibleValue(text="Minues 80 Degrees Celsius Freezer",
                                 description="Freezing at -80 degrees celcius") )
        setattr(cls, "-20",
                PermissibleValue(text="-20",
                                 description="Freezing at -20 degrees celcius") )

class EnumCRDCHSpecimenStorageActivityMethodType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H SpecimenStorageActivity method_type
    """
    _defn = EnumDefinition(
        name="EnumCRDCHSpecimenStorageActivityMethodType",
        description="Autogenerated Enumeration for CRDC-H SpecimenStorageActivity method_type",
        code_set=None,
        code_set_version="2021-09-23T15:59:52.474910+00:00",
    )

class EnumCRDCHSubjectSpecies(EnumDefinitionImpl):
    """
    The scientific binomial name for the species of the subject
    """
    _defn = EnumDefinition(
        name="EnumCRDCHSubjectSpecies",
        description="The scientific binomial name for the species of the subject",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Homo sapiens",
                PermissibleValue(text="Homo sapiens") )
        setattr(cls, "Canis familiaris",
                PermissibleValue(text="Canis familiaris") )
        setattr(cls, "Mus musculus",
                PermissibleValue(text="Mus musculus") )

class EnumCRDCHSubjectBreed(EnumDefinitionImpl):
    """
    A label given to a group of animals homogeneous in appearance and other characteristics that distinguish it from
    other animals of the same species.
    """
    Akita = PermissibleValue(text="Akita")
    Beagle = PermissibleValue(text="Beagle")
    Boxer = PermissibleValue(text="Boxer")
    Bulldog = PermissibleValue(text="Bulldog")
    Bullmastiff = PermissibleValue(text="Bullmastiff")
    Chihuahua = PermissibleValue(text="Chihuahua")
    Dalmatian = PermissibleValue(text="Dalmatian")
    Greyhound = PermissibleValue(text="Greyhound")
    Mastiff = PermissibleValue(text="Mastiff")
    Poodle = PermissibleValue(text="Poodle")
    Rottweiler = PermissibleValue(text="Rottweiler")
    Samoyed = PermissibleValue(text="Samoyed")
    Vizsla = PermissibleValue(text="Vizsla")
    Weimaraner = PermissibleValue(text="Weimaraner")

    _defn = EnumDefinition(
        name="EnumCRDCHSubjectBreed",
        description="A label given to a group of animals homogeneous in appearance and other characteristics that distinguish it from other animals of the same species.",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "American Staffordshire Terrier",
                PermissibleValue(text="American Staffordshire Terrier") )
        setattr(cls, "Australian Shepherd",
                PermissibleValue(text="Australian Shepherd") )
        setattr(cls, "Basset Hound",
                PermissibleValue(text="Basset Hound") )
        setattr(cls, "Belgian Malinois",
                PermissibleValue(text="Belgian Malinois") )
        setattr(cls, "Bernese Mountain Dog",
                PermissibleValue(text="Bernese Mountain Dog") )
        setattr(cls, "Black and Tan Coonhound",
                PermissibleValue(text="Black and Tan Coonhound") )
        setattr(cls, "Border Collie",
                PermissibleValue(text="Border Collie") )
        setattr(cls, "Boston Terrier",
                PermissibleValue(text="Boston Terrier") )
        setattr(cls, "Bouvier des Flandres",
                PermissibleValue(text="Bouvier des Flandres") )
        setattr(cls, "Cavalier King Charles Spaniel",
                PermissibleValue(text="Cavalier King Charles Spaniel") )
        setattr(cls, "Chesapeake Bay Retriever",
                PermissibleValue(text="Chesapeake Bay Retriever") )
        setattr(cls, "Chinese Shar-Pei",
                PermissibleValue(text="Chinese Shar-Pei") )
        setattr(cls, "Cocker Spaniel",
                PermissibleValue(text="Cocker Spaniel") )
        setattr(cls, "Doberman Pinscher",
                PermissibleValue(text="Doberman Pinscher") )
        setattr(cls, "English Setter",
                PermissibleValue(text="English Setter") )
        setattr(cls, "Flat-Coated Retriever",
                PermissibleValue(text="Flat-Coated Retriever") )
        setattr(cls, "French Bulldog",
                PermissibleValue(text="French Bulldog") )
        setattr(cls, "German Shepherd Dog",
                PermissibleValue(text="German Shepherd Dog") )
        setattr(cls, "German Shorthaired Pointer",
                PermissibleValue(text="German Shorthaired Pointer") )
        setattr(cls, "Giant Schnauzer",
                PermissibleValue(text="Giant Schnauzer") )
        setattr(cls, "Golden Retriever",
                PermissibleValue(text="Golden Retriever") )
        setattr(cls, "Gordon Setter",
                PermissibleValue(text="Gordon Setter") )
        setattr(cls, "Irish Setter",
                PermissibleValue(text="Irish Setter") )
        setattr(cls, "Irish Wolfhound",
                PermissibleValue(text="Irish Wolfhound") )
        setattr(cls, "Labrador Retriever",
                PermissibleValue(text="Labrador Retriever") )
        setattr(cls, "Miniature Schnauzer",
                PermissibleValue(text="Miniature Schnauzer") )
        setattr(cls, "Mixed Breed",
                PermissibleValue(text="Mixed Breed") )
        setattr(cls, "Parson Russell Terrier",
                PermissibleValue(text="Parson Russell Terrier") )
        setattr(cls, "Saint Bernard",
                PermissibleValue(text="Saint Bernard") )
        setattr(cls, "Shih Tzu",
                PermissibleValue(text="Shih Tzu") )
        setattr(cls, "Staffordshire Bull Terrier",
                PermissibleValue(text="Staffordshire Bull Terrier") )
        setattr(cls, "West Highland White Terrier",
                PermissibleValue(text="West Highland White Terrier") )
        setattr(cls, "Yorkshire Terrier",
                PermissibleValue(text="Yorkshire Terrier") )

class EnumCRDCHSubjectSex(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Subject sex
    """
    unknown = PermissibleValue(text="unknown")
    female = PermissibleValue(text="female")
    male = PermissibleValue(text="male")
    unspecified = PermissibleValue(text="unspecified")

    _defn = EnumDefinition(
        name="EnumCRDCHSubjectSex",
        description="Autogenerated Enumeration for CRDC-H Subject sex",
        code_set=None,
        code_set_version="2021-09-23T15:59:52.778588+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "not reported",
                PermissibleValue(text="not reported") )

class EnumCRDCHSubjectEthnicity(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Subject ethnicity
    """
    Unknown = PermissibleValue(text="Unknown",
                                     description="Unknown")
    unknown = PermissibleValue(text="unknown")

    _defn = EnumDefinition(
        name="EnumCRDCHSubjectEthnicity",
        description="Autogenerated Enumeration for CRDC-H Subject ethnicity",
        code_set=None,
        code_set_version="2021-09-23T15:59:52.881727+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "not hispanic or latino",
                PermissibleValue(text="not hispanic or latino") )
        setattr(cls, "hispanic or latino",
                PermissibleValue(text="hispanic or latino") )
        setattr(cls, "not reported",
                PermissibleValue(text="not reported") )
        setattr(cls, "not allowed to collect",
                PermissibleValue(text="not allowed to collect") )

class EnumCRDCHSubjectRace(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Subject race
    """
    unknown = PermissibleValue(text="unknown")
    Unknown = PermissibleValue(text="Unknown",
                                     description="Unknown")
    white = PermissibleValue(text="white")
    asian = PermissibleValue(text="asian")
    other = PermissibleValue(text="other")

    _defn = EnumDefinition(
        name="EnumCRDCHSubjectRace",
        description="Autogenerated Enumeration for CRDC-H Subject race",
        code_set=None,
        code_set_version="2021-09-23T15:59:52.990221+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "not allowed to collect",
                PermissibleValue(text="not allowed to collect") )
        setattr(cls, "not reported",
                PermissibleValue(text="not reported") )
        setattr(cls, "native hawaiian or other pacific islander",
                PermissibleValue(text="native hawaiian or other pacific islander") )
        setattr(cls, "american indian or alaska native",
                PermissibleValue(text="american indian or alaska native") )
        setattr(cls, "black or african american",
                PermissibleValue(text="black or african american") )

class EnumCRDCHSubjectVitalStatus(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Subject vital_status
    """
    Unknown = PermissibleValue(text="Unknown",
                                     description="Unknown")
    Dead = PermissibleValue(text="Dead",
                               description="DEAD")
    Alive = PermissibleValue(text="Alive",
                                 description="ALIVE")

    _defn = EnumDefinition(
        name="EnumCRDCHSubjectVitalStatus",
        description="Autogenerated Enumeration for CRDC-H Subject vital_status",
        code_set=None,
        code_set_version="2021-09-23T15:59:53.100413+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Not Reported",
                PermissibleValue(text="Not Reported",
                                 description="Not Reported") )

class EnumCRDCHSubjectCauseOfDeath(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Subject cause_of_death
    """
    Infection = PermissibleValue(text="Infection",
                                         description="Infection")
    Toxicity = PermissibleValue(text="Toxicity",
                                       description="Toxicity")
    Unknown = PermissibleValue(text="Unknown",
                                     description="Unknown")

    _defn = EnumDefinition(
        name="EnumCRDCHSubjectCauseOfDeath",
        description="Autogenerated Enumeration for CRDC-H Subject cause_of_death",
        code_set=None,
        code_set_version="2021-09-23T15:59:53.208179+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Not Reported",
                PermissibleValue(text="Not Reported",
                                 description="Not Reported") )
        setattr(cls, "Surgical Complications",
                PermissibleValue(text="Surgical Complications",
                                 description="Surgical Procedure Complication") )
        setattr(cls, "Not Cancer Related",
                PermissibleValue(text="Not Cancer Related") )
        setattr(cls, "End-stage Renal Disease",
                PermissibleValue(text="End-stage Renal Disease",
                                 description="Chronic Kidney Disease, Stage 5") )
        setattr(cls, "Spinal Muscular Atrophy",
                PermissibleValue(text="Spinal Muscular Atrophy",
                                 description="Spinal Muscular Atrophy") )
        setattr(cls, "Renal Disorder, NOS",
                PermissibleValue(text="Renal Disorder, NOS",
                                 description="Renal Disorder, NOS") )
        setattr(cls, "Cardiovascular Disorder, NOS",
                PermissibleValue(text="Cardiovascular Disorder, NOS",
                                 description="Cardiovascular Disorder, NOS") )
        setattr(cls, "Cancer Related",
                PermissibleValue(text="Cancer Related") )

class EnumCRDCHSubstanceSubstanceType(EnumDefinitionImpl):
    """
    Autogenerated Enumeration for CRDC-H Substance substance_type
    """
    Zotatifin = PermissibleValue(text="Zotatifin")
    Mitoflaxone = PermissibleValue(text="Mitoflaxone")
    Pasireotide = PermissibleValue(text="Pasireotide")
    Alofanib = PermissibleValue(text="Alofanib")
    Levothyroxine = PermissibleValue(text="Levothyroxine")
    Epipropidine = PermissibleValue(text="Epipropidine")
    Navoximod = PermissibleValue(text="Navoximod")
    Infliximab = PermissibleValue(text="Infliximab")
    Toremifene = PermissibleValue(text="Toremifene")
    Onvatilimab = PermissibleValue(text="Onvatilimab")
    Tenalisib = PermissibleValue(text="Tenalisib")
    Imaradenant = PermissibleValue(text="Imaradenant")
    Nilotinib = PermissibleValue(text="Nilotinib")
    Sobuzoxane = PermissibleValue(text="Sobuzoxane")
    Safingol = PermissibleValue(text="Safingol")
    Onartuzumab = PermissibleValue(text="Onartuzumab")
    Ipilimumab = PermissibleValue(text="Ipilimumab")
    Hydroxychloroquine = PermissibleValue(text="Hydroxychloroquine")
    Spongistatin = PermissibleValue(text="Spongistatin")
    Bemcentinib = PermissibleValue(text="Bemcentinib")
    Ipafricept = PermissibleValue(text="Ipafricept")
    Acridine = PermissibleValue(text="Acridine")
    Brentuximab = PermissibleValue(text="Brentuximab")
    Retelliptine = PermissibleValue(text="Retelliptine")
    Zorubicin = PermissibleValue(text="Zorubicin")
    Lurtotecan = PermissibleValue(text="Lurtotecan")
    Pirfenidone = PermissibleValue(text="Pirfenidone")
    Bicalutamide = PermissibleValue(text="Bicalutamide")
    Bortezomib = PermissibleValue(text="Bortezomib")
    Oxaliplatin = PermissibleValue(text="Oxaliplatin")
    Detorubicin = PermissibleValue(text="Detorubicin")
    Alemtuzumab = PermissibleValue(text="Alemtuzumab")
    Pentoxifylline = PermissibleValue(text="Pentoxifylline")
    Mezagitamab = PermissibleValue(text="Mezagitamab")
    Tubercidin = PermissibleValue(text="Tubercidin")
    Dacarbazine = PermissibleValue(text="Dacarbazine")
    Sizofiran = PermissibleValue(text="Sizofiran")
    Fianlimab = PermissibleValue(text="Fianlimab")
    Oxidopamine = PermissibleValue(text="Oxidopamine")
    Plitidepsin = PermissibleValue(text="Plitidepsin")
    Ametantrone = PermissibleValue(text="Ametantrone")
    Enasidenib = PermissibleValue(text="Enasidenib")
    Intetumumab = PermissibleValue(text="Intetumumab")
    Chiauranib = PermissibleValue(text="Chiauranib")
    Thalidomide = PermissibleValue(text="Thalidomide")
    Mafosfamide = PermissibleValue(text="Mafosfamide")
    Acodazole = PermissibleValue(text="Acodazole")
    Genistein = PermissibleValue(text="Genistein")
    Sulofenur = PermissibleValue(text="Sulofenur")
    Paclitaxel = PermissibleValue(text="Paclitaxel")
    Afatinib = PermissibleValue(text="Afatinib")
    Tivantinib = PermissibleValue(text="Tivantinib")
    Pinometostat = PermissibleValue(text="Pinometostat")
    Samuraciclib = PermissibleValue(text="Samuraciclib")
    Ianalumab = PermissibleValue(text="Ianalumab")
    Crenolanib = PermissibleValue(text="Crenolanib")
    Verubulin = PermissibleValue(text="Verubulin")
    Chlorodihydropyrimidine = PermissibleValue(text="Chlorodihydropyrimidine")
    Delanzomib = PermissibleValue(text="Delanzomib")
    Tomaralimab = PermissibleValue(text="Tomaralimab")
    Cactinomycin = PermissibleValue(text="Cactinomycin")
    Azathioprine = PermissibleValue(text="Azathioprine")
    Serplulimab = PermissibleValue(text="Serplulimab")
    Cimetidine = PermissibleValue(text="Cimetidine")
    Cedazuridine = PermissibleValue(text="Cedazuridine")
    Tilogotamab = PermissibleValue(text="Tilogotamab")
    Spirogermanium = PermissibleValue(text="Spirogermanium")
    Prednisolone = PermissibleValue(text="Prednisolone")
    Tenifatecan = PermissibleValue(text="Tenifatecan")
    Siltuximab = PermissibleValue(text="Siltuximab")
    Pimasertib = PermissibleValue(text="Pimasertib")
    Fenebrutinib = PermissibleValue(text="Fenebrutinib")
    Digitoxin = PermissibleValue(text="Digitoxin")
    Rindopepimut = PermissibleValue(text="Rindopepimut")
    Triptorelin = PermissibleValue(text="Triptorelin")
    Lintuzumab = PermissibleValue(text="Lintuzumab")
    Roniciclib = PermissibleValue(text="Roniciclib")
    Pexmetinib = PermissibleValue(text="Pexmetinib")
    Ispinesib = PermissibleValue(text="Ispinesib")
    Dexamethason = PermissibleValue(text="Dexamethason")
    Monalizumab = PermissibleValue(text="Monalizumab")
    Selinexor = PermissibleValue(text="Selinexor")
    Budigalimab = PermissibleValue(text="Budigalimab")
    Annamycin = PermissibleValue(text="Annamycin")
    Enavatuzumab = PermissibleValue(text="Enavatuzumab")
    Ensituximab = PermissibleValue(text="Ensituximab")
    Emapalumab = PermissibleValue(text="Emapalumab")
    Canfosfamide = PermissibleValue(text="Canfosfamide")
    Zalutumumab = PermissibleValue(text="Zalutumumab")
    Filanesib = PermissibleValue(text="Filanesib")
    Marizomib = PermissibleValue(text="Marizomib")
    Bufalin = PermissibleValue(text="Bufalin")
    Cladribine = PermissibleValue(text="Cladribine")
    Azimexon = PermissibleValue(text="Azimexon")
    Streptozocin = PermissibleValue(text="Streptozocin")
    Oltipraz = PermissibleValue(text="Oltipraz")
    Tetrahydrouridine = PermissibleValue(text="Tetrahydrouridine")
    Telratolimod = PermissibleValue(text="Telratolimod")
    Sirolimus = PermissibleValue(text="Sirolimus")
    Icrucumab = PermissibleValue(text="Icrucumab")
    Ifabotuzumab = PermissibleValue(text="Ifabotuzumab")
    Glofitamab = PermissibleValue(text="Glofitamab")
    Tasisulam = PermissibleValue(text="Tasisulam")
    Bafetinib = PermissibleValue(text="Bafetinib")
    Urabrelimab = PermissibleValue(text="Urabrelimab")
    Puquitinib = PermissibleValue(text="Puquitinib")
    Sabarubicin = PermissibleValue(text="Sabarubicin")
    Navarixin = PermissibleValue(text="Navarixin")
    Parsaclisib = PermissibleValue(text="Parsaclisib")
    Ulocuplumab = PermissibleValue(text="Ulocuplumab")
    Roflumilast = PermissibleValue(text="Roflumilast")
    Selonsertib = PermissibleValue(text="Selonsertib")
    Chlorambucil = PermissibleValue(text="Chlorambucil")
    Teclistamab = PermissibleValue(text="Teclistamab")
    Pioglitazone = PermissibleValue(text="Pioglitazone")
    Rigosertib = PermissibleValue(text="Rigosertib")
    Zalcitabine = PermissibleValue(text="Zalcitabine")
    Chlorotoxin = PermissibleValue(text="Chlorotoxin")
    Bexmarilimab = PermissibleValue(text="Bexmarilimab")
    Darleukin = PermissibleValue(text="Darleukin")
    Pelareorep = PermissibleValue(text="Pelareorep")
    Banoxantrone = PermissibleValue(text="Banoxantrone")
    Kanglaite = PermissibleValue(text="Kanglaite")
    Lontucirev = PermissibleValue(text="Lontucirev")
    Samalizumab = PermissibleValue(text="Samalizumab")
    Apomine = PermissibleValue(text="Apomine")
    Saracatinib = PermissibleValue(text="Saracatinib")
    Tasquinimod = PermissibleValue(text="Tasquinimod")
    Belinostat = PermissibleValue(text="Belinostat")
    Methylselenocysteine = PermissibleValue(text="Methylselenocysteine")
    Tositumomab = PermissibleValue(text="Tositumomab")
    Serdemetan = PermissibleValue(text="Serdemetan")
    Tipifarnib = PermissibleValue(text="Tipifarnib")
    Tarenflurbil = PermissibleValue(text="Tarenflurbil")
    Venetoclax = PermissibleValue(text="Venetoclax")
    Melphalan = PermissibleValue(text="Melphalan")
    Darolutamide = PermissibleValue(text="Darolutamide")
    Zanolimumab = PermissibleValue(text="Zanolimumab")
    Ganitumab = PermissibleValue(text="Ganitumab")
    Vedolizumab = PermissibleValue(text="Vedolizumab")
    PCNU = PermissibleValue(text="PCNU")
    Elagolix = PermissibleValue(text="Elagolix")
    Vinfosiltine = PermissibleValue(text="Vinfosiltine")
    Doxifluridine = PermissibleValue(text="Doxifluridine")
    Mifamurtide = PermissibleValue(text="Mifamurtide")
    Leurubicin = PermissibleValue(text="Leurubicin")
    Tesevatinib = PermissibleValue(text="Tesevatinib")
    Clivatuzumab = PermissibleValue(text="Clivatuzumab")
    Hycanthone = PermissibleValue(text="Hycanthone")
    Epirubicin = PermissibleValue(text="Epirubicin")
    Budotitane = PermissibleValue(text="Budotitane")
    Fluoxymesterone = PermissibleValue(text="Fluoxymesterone")
    Revdofilimab = PermissibleValue(text="Revdofilimab")
    Capecitabine = PermissibleValue(text="Capecitabine")
    Vorinostat = PermissibleValue(text="Vorinostat")
    Pseudoisocytidine = PermissibleValue(text="Pseudoisocytidine")
    Dactinomycin = PermissibleValue(text="Dactinomycin")
    Puromycin = PermissibleValue(text="Puromycin")
    Rodorubicin = PermissibleValue(text="Rodorubicin")
    Pralatrexate = PermissibleValue(text="Pralatrexate")
    Erdafitinib = PermissibleValue(text="Erdafitinib")
    Copanlisib = PermissibleValue(text="Copanlisib")
    Teprotumumab = PermissibleValue(text="Teprotumumab")
    Prinomastat = PermissibleValue(text="Prinomastat")
    Vulinacimab = PermissibleValue(text="Vulinacimab")
    Zandelisib = PermissibleValue(text="Zandelisib")
    Peptichemio = PermissibleValue(text="Peptichemio")
    Trigriluzole = PermissibleValue(text="Trigriluzole")
    Radgocitabine = PermissibleValue(text="Radgocitabine")
    Ionomycin = PermissibleValue(text="Ionomycin")
    Fisogatinib = PermissibleValue(text="Fisogatinib")
    Triethylenemelamine = PermissibleValue(text="Triethylenemelamine")
    Spiromustine = PermissibleValue(text="Spiromustine")
    Ivosidenib = PermissibleValue(text="Ivosidenib")
    Mivebresib = PermissibleValue(text="Mivebresib")
    Daratumumab = PermissibleValue(text="Daratumumab")
    Vibecotamab = PermissibleValue(text="Vibecotamab")
    Paricalcitol = PermissibleValue(text="Paricalcitol")
    Mosedipimod = PermissibleValue(text="Mosedipimod")
    Cyclophosphamide = PermissibleValue(text="Cyclophosphamide")
    Asaley = PermissibleValue(text="Asaley")
    Nortopixantrone = PermissibleValue(text="Nortopixantrone")
    Bevacizumab = PermissibleValue(text="Bevacizumab")
    Luminespib = PermissibleValue(text="Luminespib")
    Pibrozelesin = PermissibleValue(text="Pibrozelesin")
    Leucovorin = PermissibleValue(text="Leucovorin")
    Pibenzimol = PermissibleValue(text="Pibenzimol")
    Modotuximab = PermissibleValue(text="Modotuximab")
    Etoglucid = PermissibleValue(text="Etoglucid")
    Trebananib = PermissibleValue(text="Trebananib")
    Bendamustine = PermissibleValue(text="Bendamustine")
    Zibotentan = PermissibleValue(text="Zibotentan")
    Omipalisib = PermissibleValue(text="Omipalisib")
    Dinutuximab = PermissibleValue(text="Dinutuximab")
    Citarinostat = PermissibleValue(text="Citarinostat")
    Triaziquone = PermissibleValue(text="Triaziquone")
    Camptothecin = PermissibleValue(text="Camptothecin")
    Galiximab = PermissibleValue(text="Galiximab")
    Carbetimer = PermissibleValue(text="Carbetimer")
    Iniparib = PermissibleValue(text="Iniparib")
    Talampanel = PermissibleValue(text="Talampanel")
    Rubitecan = PermissibleValue(text="Rubitecan")
    Gedatolisib = PermissibleValue(text="Gedatolisib")
    Matuzumab = PermissibleValue(text="Matuzumab")
    Cixutumumab = PermissibleValue(text="Cixutumumab")
    Atiprimod = PermissibleValue(text="Atiprimod")
    Belvarafenib = PermissibleValue(text="Belvarafenib")
    Duvortuxizumab = PermissibleValue(text="Duvortuxizumab")
    Dimethylmyleran = PermissibleValue(text="Dimethylmyleran")
    Degarelix = PermissibleValue(text="Degarelix")
    Alitretinoin = PermissibleValue(text="Alitretinoin")
    Namodenoson = PermissibleValue(text="Namodenoson")
    Morpholinodoxorubicin = PermissibleValue(text="Morpholinodoxorubicin")
    Irofulven = PermissibleValue(text="Irofulven")
    Famitinib = PermissibleValue(text="Famitinib")
    Abarelix = PermissibleValue(text="Abarelix")
    Fazarabine = PermissibleValue(text="Fazarabine")
    Ontorpacept = PermissibleValue(text="Ontorpacept")
    Itraconazole = PermissibleValue(text="Itraconazole")
    Maytansine = PermissibleValue(text="Maytansine")
    Treosulfan = PermissibleValue(text="Treosulfan")
    Ragifilimab = PermissibleValue(text="Ragifilimab")
    Spartalizumab = PermissibleValue(text="Spartalizumab")
    Pepinemab = PermissibleValue(text="Pepinemab")
    Andrographolide = PermissibleValue(text="Andrographolide")
    Fedratinib = PermissibleValue(text="Fedratinib")
    Amifostine = PermissibleValue(text="Amifostine")
    Mobocertinib = PermissibleValue(text="Mobocertinib")
    Perfosfamide = PermissibleValue(text="Perfosfamide")
    Upifitamab = PermissibleValue(text="Upifitamab")
    Padeliporfin = PermissibleValue(text="Padeliporfin")
    Cancell = PermissibleValue(text="Cancell")
    Milataxel = PermissibleValue(text="Milataxel")
    Cemiplimab = PermissibleValue(text="Cemiplimab")
    Cabiralizumab = PermissibleValue(text="Cabiralizumab")
    Chlorozotocin = PermissibleValue(text="Chlorozotocin")
    Pegaspargase = PermissibleValue(text="Pegaspargase")
    Taurolidine = PermissibleValue(text="Taurolidine")
    Seviteronel = PermissibleValue(text="Seviteronel")
    Fluorouracil = PermissibleValue(text="Fluorouracil")
    Amrubicin = PermissibleValue(text="Amrubicin")
    Scopoletin = PermissibleValue(text="Scopoletin")
    Neratinib = PermissibleValue(text="Neratinib")
    Remetinostat = PermissibleValue(text="Remetinostat")
    Cisplatin = PermissibleValue(text="Cisplatin")
    Gossypol = PermissibleValue(text="Gossypol")
    Curcumin = PermissibleValue(text="Curcumin")
    Rituximab = PermissibleValue(text="Rituximab")
    Domatinostat = PermissibleValue(text="Domatinostat")
    Motesanib = PermissibleValue(text="Motesanib")
    Bisthianostat = PermissibleValue(text="Bisthianostat")
    Prolgolimab = PermissibleValue(text="Prolgolimab")
    Litronesib = PermissibleValue(text="Litronesib")
    Paxalisib = PermissibleValue(text="Paxalisib")
    Levetiracetam = PermissibleValue(text="Levetiracetam")
    Cenisertib = PermissibleValue(text="Cenisertib")
    Ieramilimab = PermissibleValue(text="Ieramilimab")
    Tezacitabine = PermissibleValue(text="Tezacitabine")
    Numidargistat = PermissibleValue(text="Numidargistat")
    Lerociclib = PermissibleValue(text="Lerociclib")
    Deuteporfin = PermissibleValue(text="Deuteporfin")
    Etoricoxib = PermissibleValue(text="Etoricoxib")
    Uroacitides = PermissibleValue(text="Uroacitides")
    Danusertib = PermissibleValue(text="Danusertib")
    Clioquinol = PermissibleValue(text="Clioquinol")
    Arcitumomab = PermissibleValue(text="Arcitumomab")
    Abagovomab = PermissibleValue(text="Abagovomab")
    Pilaralisib = PermissibleValue(text="Pilaralisib")
    Alpelisib = PermissibleValue(text="Alpelisib")
    Demecolcine = PermissibleValue(text="Demecolcine")
    Piposulfan = PermissibleValue(text="Piposulfan")
    Larotrectinib = PermissibleValue(text="Larotrectinib")
    Retinol = PermissibleValue(text="Retinol")
    Nidanilimab = PermissibleValue(text="Nidanilimab")
    Asparaginase = PermissibleValue(text="Asparaginase")
    Nifurtimox = PermissibleValue(text="Nifurtimox")
    Tocotrienol = PermissibleValue(text="Tocotrienol")
    Flutamide = PermissibleValue(text="Flutamide")
    Etanercept = PermissibleValue(text="Etanercept")
    Imetelstat = PermissibleValue(text="Imetelstat")
    Ascrinvacumab = PermissibleValue(text="Ascrinvacumab")
    Vinblastine = PermissibleValue(text="Vinblastine")
    Obinutuzumab = PermissibleValue(text="Obinutuzumab")
    Quinine = PermissibleValue(text="Quinine")
    Retifanlimab = PermissibleValue(text="Retifanlimab")
    Ritrosulfan = PermissibleValue(text="Ritrosulfan")
    Avelumab = PermissibleValue(text="Avelumab")
    Trimelamol = PermissibleValue(text="Trimelamol")
    Fludarabine = PermissibleValue(text="Fludarabine")
    Apalutamide = PermissibleValue(text="Apalutamide")
    Etoposide = PermissibleValue(text="Etoposide")
    Epratuzumab = PermissibleValue(text="Epratuzumab")
    Imalumab = PermissibleValue(text="Imalumab")
    Dexrazoxane = PermissibleValue(text="Dexrazoxane")
    Cositecan = PermissibleValue(text="Cositecan")
    Blinatumomab = PermissibleValue(text="Blinatumomab")
    Picibanil = PermissibleValue(text="Picibanil")
    Tarextumab = PermissibleValue(text="Tarextumab")
    Macitentan = PermissibleValue(text="Macitentan")
    Tazarotene = PermissibleValue(text="Tazarotene")
    Ortataxel = PermissibleValue(text="Ortataxel")
    Durvalumab = PermissibleValue(text="Durvalumab")
    Intoplicine = PermissibleValue(text="Intoplicine")
    Elesclomol = PermissibleValue(text="Elesclomol")
    Lilotomab = PermissibleValue(text="Lilotomab")
    Taurultam = PermissibleValue(text="Taurultam")
    Tocilizumab = PermissibleValue(text="Tocilizumab")
    Birabresib = PermissibleValue(text="Birabresib")
    Tributyrin = PermissibleValue(text="Tributyrin")
    Fursultiamine = PermissibleValue(text="Fursultiamine")
    Polidocanol = PermissibleValue(text="Polidocanol")
    Metoprine = PermissibleValue(text="Metoprine")
    Ontuxizumab = PermissibleValue(text="Ontuxizumab")
    Trabectedin = PermissibleValue(text="Trabectedin")
    Auranofin = PermissibleValue(text="Auranofin")
    Bermekimab = PermissibleValue(text="Bermekimab")
    Enoticumab = PermissibleValue(text="Enoticumab")
    Bempegaldesleukin = PermissibleValue(text="Bempegaldesleukin")
    Zalifrelimab = PermissibleValue(text="Zalifrelimab")
    Vonlerolizumab = PermissibleValue(text="Vonlerolizumab")
    Avdoralimab = PermissibleValue(text="Avdoralimab")
    Efatutazone = PermissibleValue(text="Efatutazone")
    Platinum = PermissibleValue(text="Platinum")
    Anastrozole = PermissibleValue(text="Anastrozole")
    Trilaciclib = PermissibleValue(text="Trilaciclib")
    Roblitinib = PermissibleValue(text="Roblitinib")
    Alsevalimab = PermissibleValue(text="Alsevalimab")
    Fresolimumab = PermissibleValue(text="Fresolimumab")
    Sargramostim = PermissibleValue(text="Sargramostim")
    Vorolanib = PermissibleValue(text="Vorolanib")
    Bavituximab = PermissibleValue(text="Bavituximab")
    Nirogacestat = PermissibleValue(text="Nirogacestat")
    SarCNU = PermissibleValue(text="SarCNU")
    Cordycepin = PermissibleValue(text="Cordycepin")
    Diethylnorspermine = PermissibleValue(text="Diethylnorspermine")
    Cinobufotalin = PermissibleValue(text="Cinobufotalin")
    Linperlisib = PermissibleValue(text="Linperlisib")
    Elpamotide = PermissibleValue(text="Elpamotide")
    Pegdinetanib = PermissibleValue(text="Pegdinetanib")
    Sonidegib = PermissibleValue(text="Sonidegib")
    Inecalcitol = PermissibleValue(text="Inecalcitol")
    Methylprednisolone = PermissibleValue(text="Methylprednisolone")
    Oleandrin = PermissibleValue(text="Oleandrin")
    Simeprevir = PermissibleValue(text="Simeprevir")
    Tepoditamab = PermissibleValue(text="Tepoditamab")
    Emibetuzumab = PermissibleValue(text="Emibetuzumab")
    Atamestane = PermissibleValue(text="Atamestane")
    Cerdulatinib = PermissibleValue(text="Cerdulatinib")
    Digoxin = PermissibleValue(text="Digoxin")
    Mivobulin = PermissibleValue(text="Mivobulin")
    Lovastatin = PermissibleValue(text="Lovastatin")
    Repotrectinib = PermissibleValue(text="Repotrectinib")
    Volasertib = PermissibleValue(text="Volasertib")
    Lumretuzumab = PermissibleValue(text="Lumretuzumab")
    Daclizumab = PermissibleValue(text="Daclizumab")
    Tabelecleucel = PermissibleValue(text="Tabelecleucel")
    Azaserine = PermissibleValue(text="Azaserine")
    Futibatinib = PermissibleValue(text="Futibatinib")
    Atezolizumab = PermissibleValue(text="Atezolizumab")
    Unknown = PermissibleValue(text="Unknown")
    Andecaliximab = PermissibleValue(text="Andecaliximab")
    Teloxantrone = PermissibleValue(text="Teloxantrone")
    Girodazole = PermissibleValue(text="Girodazole")
    Milatuzumab = PermissibleValue(text="Milatuzumab")
    Tegavivint = PermissibleValue(text="Tegavivint")
    Zinostatin = PermissibleValue(text="Zinostatin")
    Romidepsin = PermissibleValue(text="Romidepsin")
    Ropocamptide = PermissibleValue(text="Ropocamptide")
    Galarubicin = PermissibleValue(text="Galarubicin")
    Clanfenur = PermissibleValue(text="Clanfenur")
    Ranibizumab = PermissibleValue(text="Ranibizumab")
    Oraxol = PermissibleValue(text="Oraxol")
    Tasidotin = PermissibleValue(text="Tasidotin")
    Capivasertib = PermissibleValue(text="Capivasertib")
    Eflornithine = PermissibleValue(text="Eflornithine")
    Figitumumab = PermissibleValue(text="Figitumumab")
    Vapreotide = PermissibleValue(text="Vapreotide")
    Vilaprisan = PermissibleValue(text="Vilaprisan")
    Idelalisib = PermissibleValue(text="Idelalisib")
    Dubermatinib = PermissibleValue(text="Dubermatinib")
    Carmustine = PermissibleValue(text="Carmustine")
    Mercaptopurine = PermissibleValue(text="Mercaptopurine")
    Lometrexol = PermissibleValue(text="Lometrexol")
    Fruquintinib = PermissibleValue(text="Fruquintinib")
    Sasanlimab = PermissibleValue(text="Sasanlimab")
    Abemaciclib = PermissibleValue(text="Abemaciclib")
    Tirbanibulin = PermissibleValue(text="Tirbanibulin")
    Lobaplatin = PermissibleValue(text="Lobaplatin")
    Tauromustine = PermissibleValue(text="Tauromustine")
    Tesetaxel = PermissibleValue(text="Tesetaxel")
    Mureletecan = PermissibleValue(text="Mureletecan")
    Penclomedine = PermissibleValue(text="Penclomedine")
    Palifosfamide = PermissibleValue(text="Palifosfamide")
    Brequinar = PermissibleValue(text="Brequinar")
    Margetuximab = PermissibleValue(text="Margetuximab")
    Pentostatin = PermissibleValue(text="Pentostatin")
    Baricitinib = PermissibleValue(text="Baricitinib")
    Xevinapant = PermissibleValue(text="Xevinapant")
    Enadenotucirev = PermissibleValue(text="Enadenotucirev")
    Alefacept = PermissibleValue(text="Alefacept")
    Tinostamustine = PermissibleValue(text="Tinostamustine")
    Elgemtumab = PermissibleValue(text="Elgemtumab")
    Pipobroman = PermissibleValue(text="Pipobroman")
    Laromustine = PermissibleValue(text="Laromustine")
    Savolitinib = PermissibleValue(text="Savolitinib")
    Bozitinib = PermissibleValue(text="Bozitinib")
    Pyroxamide = PermissibleValue(text="Pyroxamide")
    Tamoxifen = PermissibleValue(text="Tamoxifen")
    Cediranib = PermissibleValue(text="Cediranib")
    Sabatolimab = PermissibleValue(text="Sabatolimab")
    Porfiromycin = PermissibleValue(text="Porfiromycin")
    Lodapolimab = PermissibleValue(text="Lodapolimab")
    Cintirorgon = PermissibleValue(text="Cintirorgon")
    Asunercept = PermissibleValue(text="Asunercept")
    Chaparrin = PermissibleValue(text="Chaparrin")
    Daniquidone = PermissibleValue(text="Daniquidone")
    Troriluzole = PermissibleValue(text="Troriluzole")
    MK0731 = PermissibleValue(text="MK0731")
    Dostarlimab = PermissibleValue(text="Dostarlimab")
    Toripalimab = PermissibleValue(text="Toripalimab")
    Tretazicar = PermissibleValue(text="Tretazicar")
    Penberol = PermissibleValue(text="Penberol")
    Pyrotinib = PermissibleValue(text="Pyrotinib")
    Amustaline = PermissibleValue(text="Amustaline")
    Vinzolidine = PermissibleValue(text="Vinzolidine")
    Valrubicin = PermissibleValue(text="Valrubicin")
    Aprutumab = PermissibleValue(text="Aprutumab")
    Esorubicin = PermissibleValue(text="Esorubicin")
    Brigatinib = PermissibleValue(text="Brigatinib")
    Fenretinide = PermissibleValue(text="Fenretinide")
    Denibulin = PermissibleValue(text="Denibulin")
    Tigapotide = PermissibleValue(text="Tigapotide")
    Adavosertib = PermissibleValue(text="Adavosertib")
    Galocitabine = PermissibleValue(text="Galocitabine")
    Mitoguazone = PermissibleValue(text="Mitoguazone")
    Febuxostat = PermissibleValue(text="Febuxostat")
    Bosutinib = PermissibleValue(text="Bosutinib")
    Methotrexate = PermissibleValue(text="Methotrexate")
    Cyproterone = PermissibleValue(text="Cyproterone")
    Elmustine = PermissibleValue(text="Elmustine")
    Entinostat = PermissibleValue(text="Entinostat")
    Danvatirsen = PermissibleValue(text="Danvatirsen")
    Ripretinib = PermissibleValue(text="Ripretinib")
    Ethylnitrosourea = PermissibleValue(text="Ethylnitrosourea")
    Pemigatinib = PermissibleValue(text="Pemigatinib")
    Ulixertinib = PermissibleValue(text="Ulixertinib")
    Glesatinib = PermissibleValue(text="Glesatinib")
    Dilpacimab = PermissibleValue(text="Dilpacimab")
    Epcoritamab = PermissibleValue(text="Epcoritamab")
    Raloxifene = PermissibleValue(text="Raloxifene")
    Edotecarin = PermissibleValue(text="Edotecarin")
    Zorifertinib = PermissibleValue(text="Zorifertinib")
    Acalisib = PermissibleValue(text="Acalisib")
    Tesidolumab = PermissibleValue(text="Tesidolumab")
    Amuvatinib = PermissibleValue(text="Amuvatinib")
    Echinomycin = PermissibleValue(text="Echinomycin")
    Relacorilant = PermissibleValue(text="Relacorilant")
    Cobomarsen = PermissibleValue(text="Cobomarsen")
    Mitotane = PermissibleValue(text="Mitotane")
    Quarfloxin = PermissibleValue(text="Quarfloxin")
    Glasdegib = PermissibleValue(text="Glasdegib")
    Clarithromycin = PermissibleValue(text="Clarithromycin")
    Metformin = PermissibleValue(text="Metformin")
    Nemorubicin = PermissibleValue(text="Nemorubicin")
    Telaglenastat = PermissibleValue(text="Telaglenastat")
    Racotumomab = PermissibleValue(text="Racotumomab")
    Tallimustine = PermissibleValue(text="Tallimustine")
    Tetrathiomolybdate = PermissibleValue(text="Tetrathiomolybdate")
    Xiliertinib = PermissibleValue(text="Xiliertinib")
    Anthramycin = PermissibleValue(text="Anthramycin")
    Nivolumab = PermissibleValue(text="Nivolumab")
    Fotretamine = PermissibleValue(text="Fotretamine")
    Belapectin = PermissibleValue(text="Belapectin")
    Olaratumab = PermissibleValue(text="Olaratumab")
    Terameprocol = PermissibleValue(text="Terameprocol")
    Talabostat = PermissibleValue(text="Talabostat")
    Bersanlimab = PermissibleValue(text="Bersanlimab")
    Depatuxizumab = PermissibleValue(text="Depatuxizumab")
    Berzosertib = PermissibleValue(text="Berzosertib")
    Ipatasertib = PermissibleValue(text="Ipatasertib")
    Selitrectinib = PermissibleValue(text="Selitrectinib")
    Flumatinib = PermissibleValue(text="Flumatinib")
    Etalocib = PermissibleValue(text="Etalocib")
    Altretamine = PermissibleValue(text="Altretamine")
    Tucidinostat = PermissibleValue(text="Tucidinostat")
    Cetrelimab = PermissibleValue(text="Cetrelimab")
    Dianhydrogalactitol = PermissibleValue(text="Dianhydrogalactitol")
    Palbociclib = PermissibleValue(text="Palbociclib")
    Varlitinib = PermissibleValue(text="Varlitinib")
    Nanatinostat = PermissibleValue(text="Nanatinostat")
    Temoporfin = PermissibleValue(text="Temoporfin")
    Camsirubicin = PermissibleValue(text="Camsirubicin")
    Farletuzumab = PermissibleValue(text="Farletuzumab")
    Lapatinib = PermissibleValue(text="Lapatinib")
    Umbralisib = PermissibleValue(text="Umbralisib")
    Ezabenlimab = PermissibleValue(text="Ezabenlimab")
    Momelotinib = PermissibleValue(text="Momelotinib")
    Ficlatuzumab = PermissibleValue(text="Ficlatuzumab")
    Methylcantharidimide = PermissibleValue(text="Methylcantharidimide")
    Fostriecin = PermissibleValue(text="Fostriecin")
    Vincristine = PermissibleValue(text="Vincristine")
    Celecoxib = PermissibleValue(text="Celecoxib")
    Plamotamab = PermissibleValue(text="Plamotamab")
    Tislelizumab = PermissibleValue(text="Tislelizumab")
    Rucaparib = PermissibleValue(text="Rucaparib")
    Pevonedistat = PermissibleValue(text="Pevonedistat")
    Pacmilimab = PermissibleValue(text="Pacmilimab")
    Losoxantrone = PermissibleValue(text="Losoxantrone")
    Pembrolizumab = PermissibleValue(text="Pembrolizumab")
    Ancitabine = PermissibleValue(text="Ancitabine")
    Bardoxolone = PermissibleValue(text="Bardoxolone")
    Axitinib = PermissibleValue(text="Axitinib")
    Batabulin = PermissibleValue(text="Batabulin")
    Imexon = PermissibleValue(text="Imexon")
    Veltuzumab = PermissibleValue(text="Veltuzumab")
    Onalespib = PermissibleValue(text="Onalespib")
    Liposome = PermissibleValue(text="Liposome")
    Panobinostat = PermissibleValue(text="Panobinostat")
    Belimumab = PermissibleValue(text="Belimumab")
    Ivuxolimab = PermissibleValue(text="Ivuxolimab")
    Benaxibine = PermissibleValue(text="Benaxibine")
    Bazedoxifene = PermissibleValue(text="Bazedoxifene")
    Tirapazamine = PermissibleValue(text="Tirapazamine")
    Ulinastatin = PermissibleValue(text="Ulinastatin")
    Formestane = PermissibleValue(text="Formestane")
    Ruxolitinib = PermissibleValue(text="Ruxolitinib")
    Lacutamab = PermissibleValue(text="Lacutamab")
    Pralsetinib = PermissibleValue(text="Pralsetinib")
    Simotaxel = PermissibleValue(text="Simotaxel")
    Satraplatin = PermissibleValue(text="Satraplatin")
    Ubenimex = PermissibleValue(text="Ubenimex")
    Thioguanine = PermissibleValue(text="Thioguanine")
    Tafasitamab = PermissibleValue(text="Tafasitamab")
    Mapatumumab = PermissibleValue(text="Mapatumumab")
    Sintilimab = PermissibleValue(text="Sintilimab")
    Virulizin = PermissibleValue(text="Virulizin")
    Clomesone = PermissibleValue(text="Clomesone")
    Ranimustine = PermissibleValue(text="Ranimustine")
    Aspacytarabine = PermissibleValue(text="Aspacytarabine")
    Upamostat = PermissibleValue(text="Upamostat")
    Dinaciclib = PermissibleValue(text="Dinaciclib")
    Ruxotemitide = PermissibleValue(text="Ruxotemitide")
    Filgrastim = PermissibleValue(text="Filgrastim")
    Crizotinib = PermissibleValue(text="Crizotinib")
    Thiarabine = PermissibleValue(text="Thiarabine")
    Tipiracil = PermissibleValue(text="Tipiracil")
    Tepotinib = PermissibleValue(text="Tepotinib")
    Combretastatin = PermissibleValue(text="Combretastatin")
    Intiquinatine = PermissibleValue(text="Intiquinatine")
    Vemurafenib = PermissibleValue(text="Vemurafenib")
    Pasotuxizumab = PermissibleValue(text="Pasotuxizumab")
    Etaracizumab = PermissibleValue(text="Etaracizumab")
    Lorlatinib = PermissibleValue(text="Lorlatinib")
    Denosumab = PermissibleValue(text="Denosumab")
    Panulisib = PermissibleValue(text="Panulisib")
    Lomustine = PermissibleValue(text="Lomustine")
    Riviciclib = PermissibleValue(text="Riviciclib")
    Hydroxyurea = PermissibleValue(text="Hydroxyurea")
    Cevipabulin = PermissibleValue(text="Cevipabulin")
    Indisulam = PermissibleValue(text="Indisulam")
    Aceglatone = PermissibleValue(text="Aceglatone")
    Tolebrutinib = PermissibleValue(text="Tolebrutinib")
    Dezaguanine = PermissibleValue(text="Dezaguanine")
    Mibefradil = PermissibleValue(text="Mibefradil")
    Alvocidib = PermissibleValue(text="Alvocidib")
    Carmofur = PermissibleValue(text="Carmofur")
    Talotrexin = PermissibleValue(text="Talotrexin")
    Oprozomib = PermissibleValue(text="Oprozomib")
    Avadomide = PermissibleValue(text="Avadomide")
    Decitabine = PermissibleValue(text="Decitabine")
    Edrecolomab = PermissibleValue(text="Edrecolomab")
    Mifepristone = PermissibleValue(text="Mifepristone")
    Conatumumab = PermissibleValue(text="Conatumumab")
    Fibromun = PermissibleValue(text="Fibromun")
    Ladirubicin = PermissibleValue(text="Ladirubicin")
    Mesna = PermissibleValue(text="Mesna")
    Ipomeanol = PermissibleValue(text="Ipomeanol")
    Taletrectinib = PermissibleValue(text="Taletrectinib")
    Burosumab = PermissibleValue(text="Burosumab")
    Sagopilone = PermissibleValue(text="Sagopilone")
    Encelimab = PermissibleValue(text="Encelimab")
    Macimorelin = PermissibleValue(text="Macimorelin")
    Imgatuzumab = PermissibleValue(text="Imgatuzumab")
    Testolactone = PermissibleValue(text="Testolactone")
    Folitixorin = PermissibleValue(text="Folitixorin")
    Sapitinib = PermissibleValue(text="Sapitinib")
    Captopril = PermissibleValue(text="Captopril")
    Tacedinaline = PermissibleValue(text="Tacedinaline")
    Aldesleukin = PermissibleValue(text="Aldesleukin")
    Givinostat = PermissibleValue(text="Givinostat")
    Selumetinib = PermissibleValue(text="Selumetinib")
    Afuresertib = PermissibleValue(text="Afuresertib")
    Entospletinib = PermissibleValue(text="Entospletinib")
    Vandetanib = PermissibleValue(text="Vandetanib")
    Lentinan = PermissibleValue(text="Lentinan")
    Tilarginine = PermissibleValue(text="Tilarginine")
    Duligotuzumab = PermissibleValue(text="Duligotuzumab")
    Burixafor = PermissibleValue(text="Burixafor")
    Tabalumab = PermissibleValue(text="Tabalumab")
    Lenalidomide = PermissibleValue(text="Lenalidomide")
    Ecromeximab = PermissibleValue(text="Ecromeximab")
    Elinafide = PermissibleValue(text="Elinafide")
    Asulacrine = PermissibleValue(text="Asulacrine")
    Taminadenant = PermissibleValue(text="Taminadenant")
    Roquinimex = PermissibleValue(text="Roquinimex")
    Girentuximab = PermissibleValue(text="Girentuximab")
    Vinflunine = PermissibleValue(text="Vinflunine")
    Alectinib = PermissibleValue(text="Alectinib")
    Erlotinib = PermissibleValue(text="Erlotinib")
    Menatetrenone = PermissibleValue(text="Menatetrenone")
    Napabucasin = PermissibleValue(text="Napabucasin")
    Mipsagargin = PermissibleValue(text="Mipsagargin")
    Troxacitabine = PermissibleValue(text="Troxacitabine")
    Amivantamab = PermissibleValue(text="Amivantamab")
    Veliparib = PermissibleValue(text="Veliparib")
    Fosbretabulin = PermissibleValue(text="Fosbretabulin")
    Terfluranol = PermissibleValue(text="Terfluranol")
    Inalimarev = PermissibleValue(text="Inalimarev")
    Cobolimab = PermissibleValue(text="Cobolimab")
    Nilutamide = PermissibleValue(text="Nilutamide")
    Mitoxantrone = PermissibleValue(text="Mitoxantrone")
    Peposertib = PermissibleValue(text="Peposertib")
    Pixatimod = PermissibleValue(text="Pixatimod")
    Urelumab = PermissibleValue(text="Urelumab")
    Vismodegib = PermissibleValue(text="Vismodegib")
    Peldesine = PermissibleValue(text="Peldesine")
    Etarotene = PermissibleValue(text="Etarotene")
    Afimoxifene = PermissibleValue(text="Afimoxifene")
    Vosilasarm = PermissibleValue(text="Vosilasarm")
    Axatilimab = PermissibleValue(text="Axatilimab")
    Rilotumumab = PermissibleValue(text="Rilotumumab")
    Cetuximab = PermissibleValue(text="Cetuximab")
    Nedisertib = PermissibleValue(text="Nedisertib")
    Uzansertib = PermissibleValue(text="Uzansertib")
    Emactuzumab = PermissibleValue(text="Emactuzumab")
    Buserelin = PermissibleValue(text="Buserelin")
    Enloplatin = PermissibleValue(text="Enloplatin")
    Orelabrutinib = PermissibleValue(text="Orelabrutinib")
    Pyrazinamide = PermissibleValue(text="Pyrazinamide")
    Sulfatinib = PermissibleValue(text="Sulfatinib")
    Ponatinib = PermissibleValue(text="Ponatinib")
    Patidegib = PermissibleValue(text="Patidegib")
    Lucitanib = PermissibleValue(text="Lucitanib")
    Geldanamycin = PermissibleValue(text="Geldanamycin")
    Diphencyprone = PermissibleValue(text="Diphencyprone")
    Orteronel = PermissibleValue(text="Orteronel")
    ASP4132 = PermissibleValue(text="ASP4132")
    Defactinib = PermissibleValue(text="Defactinib")
    Evofosfamide = PermissibleValue(text="Evofosfamide")
    Filgotinib = PermissibleValue(text="Filgotinib")
    Pertuzumab = PermissibleValue(text="Pertuzumab")
    Glufosfamide = PermissibleValue(text="Glufosfamide")
    Alobresib = PermissibleValue(text="Alobresib")
    Docetaxel = PermissibleValue(text="Docetaxel")
    Istiratumab = PermissibleValue(text="Istiratumab")
    Leflunomide = PermissibleValue(text="Leflunomide")
    Adecatumumab = PermissibleValue(text="Adecatumumab")
    Carboxyamidotriazole = PermissibleValue(text="Carboxyamidotriazole")
    Elacestrant = PermissibleValue(text="Elacestrant")
    Imatinib = PermissibleValue(text="Imatinib")
    Mocetinostat = PermissibleValue(text="Mocetinostat")
    Rosuvastatin = PermissibleValue(text="Rosuvastatin")
    Avapritinib = PermissibleValue(text="Avapritinib")
    Envafolimab = PermissibleValue(text="Envafolimab")
    Edatrexate = PermissibleValue(text="Edatrexate")
    Rabusertib = PermissibleValue(text="Rabusertib")
    Thiodiglycol = PermissibleValue(text="Thiodiglycol")
    Pirotinib = PermissibleValue(text="Pirotinib")
    Carzinophilin = PermissibleValue(text="Carzinophilin")
    Thalicarpine = PermissibleValue(text="Thalicarpine")
    Topotecan = PermissibleValue(text="Topotecan")
    Quisinostat = PermissibleValue(text="Quisinostat")
    Olinvacimab = PermissibleValue(text="Olinvacimab")
    Aldoxorubicin = PermissibleValue(text="Aldoxorubicin")
    Abituzumab = PermissibleValue(text="Abituzumab")
    Cyclodisone = PermissibleValue(text="Cyclodisone")
    Cedefingol = PermissibleValue(text="Cedefingol")
    Cryptophycin = PermissibleValue(text="Cryptophycin")
    Tandutinib = PermissibleValue(text="Tandutinib")
    Simmitinib = PermissibleValue(text="Simmitinib")
    Dulanermin = PermissibleValue(text="Dulanermin")
    Dezapelisib = PermissibleValue(text="Dezapelisib")
    Pancratistatin = PermissibleValue(text="Pancratistatin")
    Linsitinib = PermissibleValue(text="Linsitinib")
    Pegzilarginase = PermissibleValue(text="Pegzilarginase")
    Camrelizumab = PermissibleValue(text="Camrelizumab")
    Mofarotene = PermissibleValue(text="Mofarotene")
    Trofosfamide = PermissibleValue(text="Trofosfamide")
    Muparfostat = PermissibleValue(text="Muparfostat")
    Imifoplatin = PermissibleValue(text="Imifoplatin")
    Spiroplatin = PermissibleValue(text="Spiroplatin")
    Lestaurtinib = PermissibleValue(text="Lestaurtinib")
    Lapachone = PermissibleValue(text="Lapachone")
    Iroplact = PermissibleValue(text="Iroplact")
    Rosmantuzumab = PermissibleValue(text="Rosmantuzumab")
    Tefinostat = PermissibleValue(text="Tefinostat")
    Thioinosine = PermissibleValue(text="Thioinosine")
    Apaziquone = PermissibleValue(text="Apaziquone")
    Trametinib = PermissibleValue(text="Trametinib")
    Futuximab = PermissibleValue(text="Futuximab")
    Laniquidar = PermissibleValue(text="Laniquidar")
    Pimurutamab = PermissibleValue(text="Pimurutamab")
    Sotorasib = PermissibleValue(text="Sotorasib")
    Placebo = PermissibleValue(text="Placebo")
    Pacritinib = PermissibleValue(text="Pacritinib")
    Aclarubicin = PermissibleValue(text="Aclarubicin")
    Diaziquone = PermissibleValue(text="Diaziquone")
    Necitumumab = PermissibleValue(text="Necitumumab")
    Sitravatinib = PermissibleValue(text="Sitravatinib")
    Uprosertib = PermissibleValue(text="Uprosertib")
    Bromacrylide = PermissibleValue(text="Bromacrylide")
    Dexanabinol = PermissibleValue(text="Dexanabinol")
    Pelitinib = PermissibleValue(text="Pelitinib")
    Catumaxomab = PermissibleValue(text="Catumaxomab")
    Raltitrexed = PermissibleValue(text="Raltitrexed")
    Ambamustine = PermissibleValue(text="Ambamustine")
    Pomalidomide = PermissibleValue(text="Pomalidomide")
    Enobosarm = PermissibleValue(text="Enobosarm")
    Audencel = PermissibleValue(text="Audencel")
    Dovitinib = PermissibleValue(text="Dovitinib")
    Sunitinib = PermissibleValue(text="Sunitinib")
    Tiazofurin = PermissibleValue(text="Tiazofurin")
    Tucatinib = PermissibleValue(text="Tucatinib")
    Ethaselen = PermissibleValue(text="Ethaselen")
    Apitolisib = PermissibleValue(text="Apitolisib")
    Devimistat = PermissibleValue(text="Devimistat")
    Nimodipine = PermissibleValue(text="Nimodipine")
    Garlic = PermissibleValue(text="Garlic")
    Teroxirone = PermissibleValue(text="Teroxirone")
    Etanidazole = PermissibleValue(text="Etanidazole")
    Diazepinomicin = PermissibleValue(text="Diazepinomicin")
    Bleomycin = PermissibleValue(text="Bleomycin")
    Bisnafide = PermissibleValue(text="Bisnafide")
    Masoprocol = PermissibleValue(text="Masoprocol")
    Mogamulizumab = PermissibleValue(text="Mogamulizumab")
    Valemetostat = PermissibleValue(text="Valemetostat")
    Ethyleneimine = PermissibleValue(text="Ethyleneimine")
    Ifosfamide = PermissibleValue(text="Ifosfamide")
    Ilorasertib = PermissibleValue(text="Ilorasertib")
    Arfolitixorin = PermissibleValue(text="Arfolitixorin")
    Carbogen = PermissibleValue(text="Carbogen")
    Suramin = PermissibleValue(text="Suramin")
    APC8015F = PermissibleValue(text="APC8015F")
    Oleclumab = PermissibleValue(text="Oleclumab")
    Merestinib = PermissibleValue(text="Merestinib")
    Donafenib = PermissibleValue(text="Donafenib")
    Lonafarnib = PermissibleValue(text="Lonafarnib")
    Penicillamine = PermissibleValue(text="Penicillamine")
    Vitespen = PermissibleValue(text="Vitespen")
    Indoximod = PermissibleValue(text="Indoximod")
    Motolimod = PermissibleValue(text="Motolimod")
    Bisantrene = PermissibleValue(text="Bisantrene")
    Bexarotene = PermissibleValue(text="Bexarotene")
    Amsacrine = PermissibleValue(text="Amsacrine")
    Merbarone = PermissibleValue(text="Merbarone")
    Ridaforolimus = PermissibleValue(text="Ridaforolimus")
    Tanomastat = PermissibleValue(text="Tanomastat")
    EGb761 = PermissibleValue(text="EGb761")
    Niclosamide = PermissibleValue(text="Niclosamide")
    Teglarinad = PermissibleValue(text="Teglarinad")
    Sorafenib = PermissibleValue(text="Sorafenib")
    Enzastaurin = PermissibleValue(text="Enzastaurin")
    Cilengitide = PermissibleValue(text="Cilengitide")
    Uproleselan = PermissibleValue(text="Uproleselan")
    Trifluridine = PermissibleValue(text="Trifluridine")
    Nogalamycin = PermissibleValue(text="Nogalamycin")
    Itacitinib = PermissibleValue(text="Itacitinib")
    Bactobolin = PermissibleValue(text="Bactobolin")
    Prexasertib = PermissibleValue(text="Prexasertib")
    Fimepinostat = PermissibleValue(text="Fimepinostat")
    Glumetinib = PermissibleValue(text="Glumetinib")
    Lucanthone = PermissibleValue(text="Lucanthone")
    Nelarabine = PermissibleValue(text="Nelarabine")
    Roneparstat = PermissibleValue(text="Roneparstat")
    Mivavotinib = PermissibleValue(text="Mivavotinib")
    Beauvericin = PermissibleValue(text="Beauvericin")
    Vofatamab = PermissibleValue(text="Vofatamab")
    Nintedanib = PermissibleValue(text="Nintedanib")
    Verapamil = PermissibleValue(text="Verapamil")
    Gentuximab = PermissibleValue(text="Gentuximab")
    Broxuridine = PermissibleValue(text="Broxuridine")
    Trapoxin = PermissibleValue(text="Trapoxin")
    Irinotecan = PermissibleValue(text="Irinotecan")
    Gilteritinib = PermissibleValue(text="Gilteritinib")
    Pirarubicin = PermissibleValue(text="Pirarubicin")
    Ertumaxomab = PermissibleValue(text="Ertumaxomab")
    Miltefosine = PermissibleValue(text="Miltefosine")
    Doxercalciferol = PermissibleValue(text="Doxercalciferol")
    Letrozole = PermissibleValue(text="Letrozole")
    Olmutinib = PermissibleValue(text="Olmutinib")
    Aminocamptothecin = PermissibleValue(text="Aminocamptothecin")
    Pegargiminase = PermissibleValue(text="Pegargiminase")
    Ribociclib = PermissibleValue(text="Ribociclib")
    Galunisertib = PermissibleValue(text="Galunisertib")
    Niraparib = PermissibleValue(text="Niraparib")
    Demcizumab = PermissibleValue(text="Demcizumab")
    Pterostilbene = PermissibleValue(text="Pterostilbene")
    Enpromate = PermissibleValue(text="Enpromate")
    Grapiprant = PermissibleValue(text="Grapiprant")
    Norgestrel = PermissibleValue(text="Norgestrel")
    Semuloparin = PermissibleValue(text="Semuloparin")
    Abexinostat = PermissibleValue(text="Abexinostat")
    Telapristone = PermissibleValue(text="Telapristone")
    Robatumumab = PermissibleValue(text="Robatumumab")
    Trodusquemine = PermissibleValue(text="Trodusquemine")
    Poziotinib = PermissibleValue(text="Poziotinib")
    Erbulozole = PermissibleValue(text="Erbulozole")
    Tritylcysteine = PermissibleValue(text="Tritylcysteine")
    Falimarev = PermissibleValue(text="Falimarev")
    Doxorubicin = PermissibleValue(text="Doxorubicin")
    Lifirafenib = PermissibleValue(text="Lifirafenib")
    Oregovomab = PermissibleValue(text="Oregovomab")
    Xeloda = PermissibleValue(text="Xeloda")
    Thioureidobutyronitrile = PermissibleValue(text="Thioureidobutyronitrile")
    Cabazitaxel = PermissibleValue(text="Cabazitaxel")
    Ozarelix = PermissibleValue(text="Ozarelix")
    Benzoylphenylurea = PermissibleValue(text="Benzoylphenylurea")
    Misonidazole = PermissibleValue(text="Misonidazole")
    Exisulind = PermissibleValue(text="Exisulind")
    Glaucarubolone = PermissibleValue(text="Glaucarubolone")
    Edelfosine = PermissibleValue(text="Edelfosine")
    Cinobufagin = PermissibleValue(text="Cinobufagin")
    Triapine = PermissibleValue(text="Triapine")
    Vadimezan = PermissibleValue(text="Vadimezan")
    Razoxane = PermissibleValue(text="Razoxane")
    Pixantrone = PermissibleValue(text="Pixantrone")
    Hypericin = PermissibleValue(text="Hypericin")
    Essiac = PermissibleValue(text="Essiac")
    Acivicin = PermissibleValue(text="Acivicin")
    Menogaril = PermissibleValue(text="Menogaril")
    Utomilumab = PermissibleValue(text="Utomilumab")
    Floxuridine = PermissibleValue(text="Floxuridine")
    Magrolimab = PermissibleValue(text="Magrolimab")
    Mitomycin = PermissibleValue(text="Mitomycin")
    Rociletinib = PermissibleValue(text="Rociletinib")
    Bimiralisib = PermissibleValue(text="Bimiralisib")
    Tamibarotene = PermissibleValue(text="Tamibarotene")
    Nimustine = PermissibleValue(text="Nimustine")
    Aviscumine = PermissibleValue(text="Aviscumine")
    Giredestrant = PermissibleValue(text="Giredestrant")
    Zanidatamab = PermissibleValue(text="Zanidatamab")
    Pimitespib = PermissibleValue(text="Pimitespib")
    Cemadotin = PermissibleValue(text="Cemadotin")
    Plevitrexed = PermissibleValue(text="Plevitrexed")
    Ceritinib = PermissibleValue(text="Ceritinib")
    Refametinib = PermissibleValue(text="Refametinib")
    Kanitinib = PermissibleValue(text="Kanitinib")
    Siremadlin = PermissibleValue(text="Siremadlin")
    Gefitinib = PermissibleValue(text="Gefitinib")
    Navicixizumab = PermissibleValue(text="Navicixizumab")
    Padoporfin = PermissibleValue(text="Padoporfin")
    Miptenalimab = PermissibleValue(text="Miptenalimab")
    Alanosine = PermissibleValue(text="Alanosine")
    Polyandrol = PermissibleValue(text="Polyandrol")
    Sapanisertib = PermissibleValue(text="Sapanisertib")
    Vatalanib = PermissibleValue(text="Vatalanib")
    Sevacizumab = PermissibleValue(text="Sevacizumab")
    Trimetrexate = PermissibleValue(text="Trimetrexate")
    Dabrafenib = PermissibleValue(text="Dabrafenib")
    Mevociclib = PermissibleValue(text="Mevociclib")
    Metamelfalan = PermissibleValue(text="Metamelfalan")
    Piperazinedione = PermissibleValue(text="Piperazinedione")
    Becatecarin = PermissibleValue(text="Becatecarin")
    Marimastat = PermissibleValue(text="Marimastat")
    Resveratrol = PermissibleValue(text="Resveratrol")
    Carfilzomib = PermissibleValue(text="Carfilzomib")
    Plinabulin = PermissibleValue(text="Plinabulin")
    Metarrestin = PermissibleValue(text="Metarrestin")
    Ranolazine = PermissibleValue(text="Ranolazine")
    Rogaratinib = PermissibleValue(text="Rogaratinib")
    Valspodar = PermissibleValue(text="Valspodar")
    Pamiparib = PermissibleValue(text="Pamiparib")
    Bazlitoran = PermissibleValue(text="Bazlitoran")
    Opaganib = PermissibleValue(text="Opaganib")
    Simurosertib = PermissibleValue(text="Simurosertib")
    Inositol = PermissibleValue(text="Inositol")
    Archexin = PermissibleValue(text="Archexin")
    Ocaratuzumab = PermissibleValue(text="Ocaratuzumab")
    Fluorodopan = PermissibleValue(text="Fluorodopan")
    Cannabidiol = PermissibleValue(text="Cannabidiol")
    Ublituximab = PermissibleValue(text="Ublituximab")
    Triazinate = PermissibleValue(text="Triazinate")
    Seliciclib = PermissibleValue(text="Seliciclib")
    Piritrexim = PermissibleValue(text="Piritrexim")
    Ambazone = PermissibleValue(text="Ambazone")
    Procarbazine = PermissibleValue(text="Procarbazine")
    Ifetroban = PermissibleValue(text="Ifetroban")
    Carzelesin = PermissibleValue(text="Carzelesin")
    Pumitepa = PermissibleValue(text="Pumitepa")
    Lenzilumab = PermissibleValue(text="Lenzilumab")
    Amsilarotene = PermissibleValue(text="Amsilarotene")
    Encorafenib = PermissibleValue(text="Encorafenib")
    Talmapimod = PermissibleValue(text="Talmapimod")
    Indomethacin = PermissibleValue(text="Indomethacin")
    Carboquone = PermissibleValue(text="Carboquone")
    Namirotene = PermissibleValue(text="Namirotene")
    Ripertamab = PermissibleValue(text="Ripertamab")
    Carboplatin = PermissibleValue(text="Carboplatin")
    Opucolimab = PermissibleValue(text="Opucolimab")
    Vistusertib = PermissibleValue(text="Vistusertib")
    Chaparrinone = PermissibleValue(text="Chaparrinone")
    Brostallicin = PermissibleValue(text="Brostallicin")
    Brivudine = PermissibleValue(text="Brivudine")
    Staurosporine = PermissibleValue(text="Staurosporine")
    Octreotide = PermissibleValue(text="Octreotide")
    Tocladesine = PermissibleValue(text="Tocladesine")
    Ceralasertib = PermissibleValue(text="Ceralasertib")
    Asciminib = PermissibleValue(text="Asciminib")
    Regorafenib = PermissibleValue(text="Regorafenib")
    Glucarpidase = PermissibleValue(text="Glucarpidase")
    Exicorilant = PermissibleValue(text="Exicorilant")
    Prexigebersen = PermissibleValue(text="Prexigebersen")
    Eltanexor = PermissibleValue(text="Eltanexor")
    Rezivertinib = PermissibleValue(text="Rezivertinib")
    Azapicyl = PermissibleValue(text="Azapicyl")
    Lifileucel = PermissibleValue(text="Lifileucel")
    Sapacitabine = PermissibleValue(text="Sapacitabine")
    Methazolamide = PermissibleValue(text="Methazolamide")
    Buparlisib = PermissibleValue(text="Buparlisib")
    Ixabepilone = PermissibleValue(text="Ixabepilone")
    Poliglusam = PermissibleValue(text="Poliglusam")
    Peplomycin = PermissibleValue(text="Peplomycin")
    Inulin = PermissibleValue(text="Inulin")
    Cenersen = PermissibleValue(text="Cenersen")
    Tanespimycin = PermissibleValue(text="Tanespimycin")
    Olivomycin = PermissibleValue(text="Olivomycin")
    Naxitamab = PermissibleValue(text="Naxitamab")
    Aranose = PermissibleValue(text="Aranose")
    Pyrazoloacridine = PermissibleValue(text="Pyrazoloacridine")
    Codrituzumab = PermissibleValue(text="Codrituzumab")
    Caracemide = PermissibleValue(text="Caracemide")
    Mitobronitol = PermissibleValue(text="Mitobronitol")
    Tosedostat = PermissibleValue(text="Tosedostat")
    Flotetuzumab = PermissibleValue(text="Flotetuzumab")
    Mosunetuzumab = PermissibleValue(text="Mosunetuzumab")
    Mitolactol = PermissibleValue(text="Mitolactol")
    Sonolisib = PermissibleValue(text="Sonolisib")
    Herbimycin = PermissibleValue(text="Herbimycin")
    Inebilizumab = PermissibleValue(text="Inebilizumab")
    Dexamethasone = PermissibleValue(text="Dexamethasone")
    Cytarabine = PermissibleValue(text="Cytarabine")
    Fluvastatin = PermissibleValue(text="Fluvastatin")
    Brontictuzumab = PermissibleValue(text="Brontictuzumab")
    Selpercatinib = PermissibleValue(text="Selpercatinib")
    Capmatinib = PermissibleValue(text="Capmatinib")
    Theramide = PermissibleValue(text="Theramide")
    Duborimycin = PermissibleValue(text="Duborimycin")
    Tolnidamine = PermissibleValue(text="Tolnidamine")
    Rogletimide = PermissibleValue(text="Rogletimide")
    Idronoxil = PermissibleValue(text="Idronoxil")
    Cyclosporine = PermissibleValue(text="Cyclosporine")
    Vintafolide = PermissibleValue(text="Vintafolide")
    Tretinoin = PermissibleValue(text="Tretinoin")
    Gandotinib = PermissibleValue(text="Gandotinib")
    Mitotenamine = PermissibleValue(text="Mitotenamine")
    Carlumab = PermissibleValue(text="Carlumab")
    Cibisatamab = PermissibleValue(text="Cibisatamab")
    Daunorubicin = PermissibleValue(text="Daunorubicin")
    Nimotuzumab = PermissibleValue(text="Nimotuzumab")
    Deslorelin = PermissibleValue(text="Deslorelin")
    Guselkumab = PermissibleValue(text="Guselkumab")
    Anthrapyrazole = PermissibleValue(text="Anthrapyrazole")
    Lenvatinib = PermissibleValue(text="Lenvatinib")
    Ilixadencel = PermissibleValue(text="Ilixadencel")
    Daporinad = PermissibleValue(text="Daporinad")
    Elliptinium = PermissibleValue(text="Elliptinium")
    Landogrozumab = PermissibleValue(text="Landogrozumab")
    Dynemicin = PermissibleValue(text="Dynemicin")
    Pelitrexol = PermissibleValue(text="Pelitrexol")
    Plicamycin = PermissibleValue(text="Plicamycin")
    Ofatumumab = PermissibleValue(text="Ofatumumab")
    Crolibulin = PermissibleValue(text="Crolibulin")
    Laetrile = PermissibleValue(text="Laetrile")
    Ropidoxuridine = PermissibleValue(text="Ropidoxuridine")
    Mitozolomide = PermissibleValue(text="Mitozolomide")
    Balstilimab = PermissibleValue(text="Balstilimab")
    Siplizumab = PermissibleValue(text="Siplizumab")
    Retaspimycin = PermissibleValue(text="Retaspimycin")
    Spanlecortemlocel = PermissibleValue(text="Spanlecortemlocel")
    Dactolisib = PermissibleValue(text="Dactolisib")
    Golotimod = PermissibleValue(text="Golotimod")
    Fosquidone = PermissibleValue(text="Fosquidone")
    Dienogest = PermissibleValue(text="Dienogest")
    Etoprine = PermissibleValue(text="Etoprine")
    Azotomycin = PermissibleValue(text="Azotomycin")
    Lexatumumab = PermissibleValue(text="Lexatumumab")
    Parsatuzumab = PermissibleValue(text="Parsatuzumab")
    Nedaplatin = PermissibleValue(text="Nedaplatin")
    Alkotinib = PermissibleValue(text="Alkotinib")
    Prednisone = PermissibleValue(text="Prednisone")
    Pamrevlumab = PermissibleValue(text="Pamrevlumab")
    Plozalizumab = PermissibleValue(text="Plozalizumab")
    Solitomab = PermissibleValue(text="Solitomab")
    Nagrestipen = PermissibleValue(text="Nagrestipen")
    Zelavespib = PermissibleValue(text="Zelavespib")
    Thymopentin = PermissibleValue(text="Thymopentin")
    Lisavanbulin = PermissibleValue(text="Lisavanbulin")
    Marcellomycin = PermissibleValue(text="Marcellomycin")
    Isatuximab = PermissibleValue(text="Isatuximab")
    Abiraterone = PermissibleValue(text="Abiraterone")
    HPPH = PermissibleValue(text="HPPH")
    Tigatuzumab = PermissibleValue(text="Tigatuzumab")
    Sotrastaurin = PermissibleValue(text="Sotrastaurin")
    Methoxsalen = PermissibleValue(text="Methoxsalen")
    Cantrixil = PermissibleValue(text="Cantrixil")
    Enzalutamide = PermissibleValue(text="Enzalutamide")
    Reparixin = PermissibleValue(text="Reparixin")
    Cabozantinib = PermissibleValue(text="Cabozantinib")
    Dalotuzumab = PermissibleValue(text="Dalotuzumab")
    Pazopanib = PermissibleValue(text="Pazopanib")
    Anakinra = PermissibleValue(text="Anakinra")
    Vinorelbine = PermissibleValue(text="Vinorelbine")
    AEE788 = PermissibleValue(text="AEE788")
    Naquotinib = PermissibleValue(text="Naquotinib")
    Ketotrexate = PermissibleValue(text="Ketotrexate")
    Almurtide = PermissibleValue(text="Almurtide")
    Brivanib = PermissibleValue(text="Brivanib")
    Binetrakin = PermissibleValue(text="Binetrakin")
    Gatipotuzumab = PermissibleValue(text="Gatipotuzumab")
    Medorubicin = PermissibleValue(text="Medorubicin")
    Ciforadenant = PermissibleValue(text="Ciforadenant")
    Phenesterin = PermissibleValue(text="Phenesterin")
    Empesertib = PermissibleValue(text="Empesertib")
    Azacitidine = PermissibleValue(text="Azacitidine")
    Imiquimod = PermissibleValue(text="Imiquimod")
    Linifanib = PermissibleValue(text="Linifanib")
    Tremelimumab = PermissibleValue(text="Tremelimumab")
    Taltobulin = PermissibleValue(text="Taltobulin")
    Felzartamab = PermissibleValue(text="Felzartamab")
    Dicycloplatin = PermissibleValue(text="Dicycloplatin")
    Gimeracil = PermissibleValue(text="Gimeracil")
    Alestramustine = PermissibleValue(text="Alestramustine")
    Lazertinib = PermissibleValue(text="Lazertinib")
    Tisagenlecleucel = PermissibleValue(text="Tisagenlecleucel")
    Noscapine = PermissibleValue(text="Noscapine")
    Tertomotide = PermissibleValue(text="Tertomotide")
    Ricolinostat = PermissibleValue(text="Ricolinostat")
    Zanubrutinib = PermissibleValue(text="Zanubrutinib")
    Topsalysin = PermissibleValue(text="Topsalysin")
    Fosaprepitant = PermissibleValue(text="Fosaprepitant")
    Midostaurin = PermissibleValue(text="Midostaurin")
    Dacomitinib = PermissibleValue(text="Dacomitinib")
    Manelimab = PermissibleValue(text="Manelimab")
    Sugemalimab = PermissibleValue(text="Sugemalimab")
    Seocalcitol = PermissibleValue(text="Seocalcitol")
    Goserelin = PermissibleValue(text="Goserelin")
    Tebentafusp = PermissibleValue(text="Tebentafusp")
    Sotigalimab = PermissibleValue(text="Sotigalimab")
    Birinapant = PermissibleValue(text="Birinapant")
    Vindesine = PermissibleValue(text="Vindesine")
    Fotemustine = PermissibleValue(text="Fotemustine")
    Picoplatin = PermissibleValue(text="Picoplatin")
    Anaxirone = PermissibleValue(text="Anaxirone")
    Carubicin = PermissibleValue(text="Carubicin")
    Osimertinib = PermissibleValue(text="Osimertinib")
    Otlertuzumab = PermissibleValue(text="Otlertuzumab")
    Mitindomide = PermissibleValue(text="Mitindomide")
    Sulindac = PermissibleValue(text="Sulindac")
    Balixafortide = PermissibleValue(text="Balixafortide")
    Ibrutinib = PermissibleValue(text="Ibrutinib")
    Pegfilgrastim = PermissibleValue(text="Pegfilgrastim")
    Foretinib = PermissibleValue(text="Foretinib")
    Topixantrone = PermissibleValue(text="Topixantrone")
    Nanafrocin = PermissibleValue(text="Nanafrocin")
    Volociximab = PermissibleValue(text="Volociximab")
    Cusatuzumab = PermissibleValue(text="Cusatuzumab")
    Prednimustine = PermissibleValue(text="Prednimustine")
    Trastuzumab = PermissibleValue(text="Trastuzumab")
    Tazemetostat = PermissibleValue(text="Tazemetostat")
    Ketoconazole = PermissibleValue(text="Ketoconazole")
    Tovetumab = PermissibleValue(text="Tovetumab")
    Xentuzumab = PermissibleValue(text="Xentuzumab")
    Miransertib = PermissibleValue(text="Miransertib")
    Redaporfin = PermissibleValue(text="Redaporfin")
    Vactosertib = PermissibleValue(text="Vactosertib")
    Nurulimab = PermissibleValue(text="Nurulimab")
    Temarotene = PermissibleValue(text="Temarotene")
    Eribulin = PermissibleValue(text="Eribulin")
    Temozolomide = PermissibleValue(text="Temozolomide")
    Azaribine = PermissibleValue(text="Azaribine")
    Motixafortide = PermissibleValue(text="Motixafortide")
    Vecabrutinib = PermissibleValue(text="Vecabrutinib")
    Tivozanib = PermissibleValue(text="Tivozanib")
    Pentamustine = PermissibleValue(text="Pentamustine")
    Iloprost = PermissibleValue(text="Iloprost")
    Rosabulin = PermissibleValue(text="Rosabulin")
    Carbendazim = PermissibleValue(text="Carbendazim")
    Elisidepsin = PermissibleValue(text="Elisidepsin")
    Lefitolimod = PermissibleValue(text="Lefitolimod")
    Onatasertib = PermissibleValue(text="Onatasertib")
    Dihydrolenperone = PermissibleValue(text="Dihydrolenperone")
    Sardomozide = PermissibleValue(text="Sardomozide")
    Dacetuzumab = PermissibleValue(text="Dacetuzumab")
    Zolbetuximab = PermissibleValue(text="Zolbetuximab")
    Seclidemstat = PermissibleValue(text="Seclidemstat")
    Leuprolide = PermissibleValue(text="Leuprolide")
    Calcitriol = PermissibleValue(text="Calcitriol")
    Exemestane = PermissibleValue(text="Exemestane")
    Vesencumab = PermissibleValue(text="Vesencumab")
    Diindolylmethane = PermissibleValue(text="Diindolylmethane")
    Enclomiphene = PermissibleValue(text="Enclomiphene")
    Mirdametinib = PermissibleValue(text="Mirdametinib")
    Bomedemstat = PermissibleValue(text="Bomedemstat")
    Molibresib = PermissibleValue(text="Molibresib")
    Proxalutamide = PermissibleValue(text="Proxalutamide")
    Ocrelizumab = PermissibleValue(text="Ocrelizumab")
    Tyroserleutide = PermissibleValue(text="Tyroserleutide")
    Guadecitabine = PermissibleValue(text="Guadecitabine")
    Cosibelimab = PermissibleValue(text="Cosibelimab")
    Aderbasib = PermissibleValue(text="Aderbasib")
    Ranpirnase = PermissibleValue(text="Ranpirnase")
    Spebrutinib = PermissibleValue(text="Spebrutinib")
    Edicotinib = PermissibleValue(text="Edicotinib")
    Ixazomib = PermissibleValue(text="Ixazomib")
    Chloroquine = PermissibleValue(text="Chloroquine")
    Other = PermissibleValue(text="Other")
    Tasadenoturev = PermissibleValue(text="Tasadenoturev")
    Timonacic = PermissibleValue(text="Timonacic")
    Dusigitumab = PermissibleValue(text="Dusigitumab")
    Hexylresorcinol = PermissibleValue(text="Hexylresorcinol")
    Xanthohumol = PermissibleValue(text="Xanthohumol")
    Batimastat = PermissibleValue(text="Batimastat")
    Sibrotuzumab = PermissibleValue(text="Sibrotuzumab")
    Cobimetinib = PermissibleValue(text="Cobimetinib")
    Telisotuzumab = PermissibleValue(text="Telisotuzumab")
    Vanucizumab = PermissibleValue(text="Vanucizumab")
    Cycloleucine = PermissibleValue(text="Cycloleucine")
    Ombrabulin = PermissibleValue(text="Ombrabulin")
    Artesunate = PermissibleValue(text="Artesunate")
    Onvansertib = PermissibleValue(text="Onvansertib")
    Theliatinib = PermissibleValue(text="Theliatinib")
    Mavelertinib = PermissibleValue(text="Mavelertinib")
    Conbercept = PermissibleValue(text="Conbercept")
    Cesalin = PermissibleValue(text="Cesalin")
    Feladilimab = PermissibleValue(text="Feladilimab")
    Sonepcizumab = PermissibleValue(text="Sonepcizumab")
    Denenicokin = PermissibleValue(text="Denenicokin")
    Nesvacumab = PermissibleValue(text="Nesvacumab")
    Stallimycin = PermissibleValue(text="Stallimycin")
    Ormaplatin = PermissibleValue(text="Ormaplatin")
    Trabedersen = PermissibleValue(text="Trabedersen")
    Pexidartinib = PermissibleValue(text="Pexidartinib")
    Pictilisib = PermissibleValue(text="Pictilisib")
    Cirmtuzumab = PermissibleValue(text="Cirmtuzumab")
    Inproquone = PermissibleValue(text="Inproquone")
    Rofecoxib = PermissibleValue(text="Rofecoxib")
    Samotolisib = PermissibleValue(text="Samotolisib")
    T900607 = PermissibleValue(text="T900607")
    Voxtalisib = PermissibleValue(text="Voxtalisib")
    Sergiolide = PermissibleValue(text="Sergiolide")
    Canerpaturev = PermissibleValue(text="Canerpaturev")
    Etigilimab = PermissibleValue(text="Etigilimab")
    Ganetespib = PermissibleValue(text="Ganetespib")
    Pentamethylmelamine = PermissibleValue(text="Pentamethylmelamine")
    Trioxifene = PermissibleValue(text="Trioxifene")
    Amcasertib = PermissibleValue(text="Amcasertib")
    Apomab = PermissibleValue(text="Apomab")
    Sulforaphane = PermissibleValue(text="Sulforaphane")
    Fadraciclib = PermissibleValue(text="Fadraciclib")
    Rebeccamycin = PermissibleValue(text="Rebeccamycin")
    Roducitabine = PermissibleValue(text="Roducitabine")
    Mitoclomine = PermissibleValue(text="Mitoclomine")
    Mannosulfan = PermissibleValue(text="Mannosulfan")
    Barasertib = PermissibleValue(text="Barasertib")
    Methoxyamine = PermissibleValue(text="Methoxyamine")
    Epitiostanol = PermissibleValue(text="Epitiostanol")
    Vopratelimab = PermissibleValue(text="Vopratelimab")
    Nocodazole = PermissibleValue(text="Nocodazole")
    Relugolix = PermissibleValue(text="Relugolix")
    Silibinin = PermissibleValue(text="Silibinin")
    Elacytarabine = PermissibleValue(text="Elacytarabine")
    Clofarabine = PermissibleValue(text="Clofarabine")
    Giloralimab = PermissibleValue(text="Giloralimab")
    Golvatinib = PermissibleValue(text="Golvatinib")
    Patritumab = PermissibleValue(text="Patritumab")
    Fluzoparib = PermissibleValue(text="Fluzoparib")
    Licorice = PermissibleValue(text="Licorice")
    Favezelimab = PermissibleValue(text="Favezelimab")
    Clomiphene = PermissibleValue(text="Clomiphene")
    Methyltestosterone = PermissibleValue(text="Methyltestosterone")
    Breflate = PermissibleValue(text="Breflate")
    Dupilumab = PermissibleValue(text="Dupilumab")
    Murizatoclax = PermissibleValue(text="Murizatoclax")
    Diazooxonorleucine = PermissibleValue(text="Diazooxonorleucine")
    Relatlimab = PermissibleValue(text="Relatlimab")
    Alvespimycin = PermissibleValue(text="Alvespimycin")
    Acitretin = PermissibleValue(text="Acitretin")
    Cytochlor = PermissibleValue(text="Cytochlor")
    Galamustine = PermissibleValue(text="Galamustine")
    Resiquimod = PermissibleValue(text="Resiquimod")
    Lexibulin = PermissibleValue(text="Lexibulin")
    Natalizumab = PermissibleValue(text="Natalizumab")
    Derazantinib = PermissibleValue(text="Derazantinib")
    Doxazosin = PermissibleValue(text="Doxazosin")
    Gemcitabine = PermissibleValue(text="Gemcitabine")
    Iboctadekin = PermissibleValue(text="Iboctadekin")
    Apolizumab = PermissibleValue(text="Apolizumab")
    Acalabrutinib = PermissibleValue(text="Acalabrutinib")
    Peretinoin = PermissibleValue(text="Peretinoin")
    Piroxantrone = PermissibleValue(text="Piroxantrone")
    Selicrelumab = PermissibleValue(text="Selicrelumab")
    Salirasib = PermissibleValue(text="Salirasib")
    Anhydrovinblastine = PermissibleValue(text="Anhydrovinblastine")
    Dacplatinum = PermissibleValue(text="Dacplatinum")
    Isotretinoin = PermissibleValue(text="Isotretinoin")
    Drozitumab = PermissibleValue(text="Drozitumab")
    Didox = PermissibleValue(text="Didox")
    Rosopatamab = PermissibleValue(text="Rosopatamab")
    Pemetrexed = PermissibleValue(text="Pemetrexed")
    Pingyangmycin = PermissibleValue(text="Pingyangmycin")
    Amatuximab = PermissibleValue(text="Amatuximab")
    Tavolimab = PermissibleValue(text="Tavolimab")
    Vinepidine = PermissibleValue(text="Vinepidine")
    Olutasidenib = PermissibleValue(text="Olutasidenib")
    Bemarituzumab = PermissibleValue(text="Bemarituzumab")
    Pelabresib = PermissibleValue(text="Pelabresib")
    Navitoclax = PermissibleValue(text="Navitoclax")
    Pegilodecakin = PermissibleValue(text="Pegilodecakin")
    Binimetinib = PermissibleValue(text="Binimetinib")
    Incyclinide = PermissibleValue(text="Incyclinide")
    Tirabrutinib = PermissibleValue(text="Tirabrutinib")
    Quizartinib = PermissibleValue(text="Quizartinib")
    Pegvisomant = PermissibleValue(text="Pegvisomant")
    Ditiocarb = PermissibleValue(text="Ditiocarb")
    Rebimastat = PermissibleValue(text="Rebimastat")
    Aminopterin = PermissibleValue(text="Aminopterin")
    Panitumumab = PermissibleValue(text="Panitumumab")
    KRN5500 = PermissibleValue(text="KRN5500")
    Gutolactone = PermissibleValue(text="Gutolactone")
    Perifosine = PermissibleValue(text="Perifosine")
    Irosustat = PermissibleValue(text="Irosustat")
    Brilanestrant = PermissibleValue(text="Brilanestrant")
    Lirilumab = PermissibleValue(text="Lirilumab")
    Temsirolimus = PermissibleValue(text="Temsirolimus")
    Gelonin = PermissibleValue(text="Gelonin")
    Patupilone = PermissibleValue(text="Patupilone")
    Bruceantin = PermissibleValue(text="Bruceantin")
    Odronextamab = PermissibleValue(text="Odronextamab")
    Infigratinib = PermissibleValue(text="Infigratinib")
    Mitazalimab = PermissibleValue(text="Mitazalimab")
    Linrodostat = PermissibleValue(text="Linrodostat")
    Daromun = PermissibleValue(text="Daromun")
    Tanibirumab = PermissibleValue(text="Tanibirumab")
    Plocabulin = PermissibleValue(text="Plocabulin")
    Narnatumab = PermissibleValue(text="Narnatumab")
    Chemotherapy = PermissibleValue(text="Chemotherapy")
    Busulfan = PermissibleValue(text="Busulfan")
    Simtuzumab = PermissibleValue(text="Simtuzumab")
    Oxeclosporin = PermissibleValue(text="Oxeclosporin")
    Larotaxel = PermissibleValue(text="Larotaxel")
    Niacinamide = PermissibleValue(text="Niacinamide")
    Ilginatinib = PermissibleValue(text="Ilginatinib")
    Taladegib = PermissibleValue(text="Taladegib")
    Rivoceranib = PermissibleValue(text="Rivoceranib")
    Iratumumab = PermissibleValue(text="Iratumumab")
    Everolimus = PermissibleValue(text="Everolimus")
    Nazartinib = PermissibleValue(text="Nazartinib")
    Ramucirumab = PermissibleValue(text="Ramucirumab")
    Tariquidar = PermissibleValue(text="Tariquidar")
    Elotuzumab = PermissibleValue(text="Elotuzumab")
    Galeterone = PermissibleValue(text="Galeterone")
    Lucatumumab = PermissibleValue(text="Lucatumumab")
    Pipendoxifene = PermissibleValue(text="Pipendoxifene")
    Apricoxib = PermissibleValue(text="Apricoxib")
    Dalantercept = PermissibleValue(text="Dalantercept")
    Agerafenib = PermissibleValue(text="Agerafenib")
    Iadademstat = PermissibleValue(text="Iadademstat")
    Taselisib = PermissibleValue(text="Taselisib")
    Talazoparib = PermissibleValue(text="Talazoparib")
    Bizelesin = PermissibleValue(text="Bizelesin")
    Belzutifan = PermissibleValue(text="Belzutifan")
    Mechlorethamine = PermissibleValue(text="Mechlorethamine")
    Idasanutlin = PermissibleValue(text="Idasanutlin")
    Fulvestrant = PermissibleValue(text="Fulvestrant")
    Estramustine = PermissibleValue(text="Estramustine")
    Hydroxytyrosol = PermissibleValue(text="Hydroxytyrosol")
    Alisertib = PermissibleValue(text="Alisertib")
    Acetylcysteine = PermissibleValue(text="Acetylcysteine")
    Oxcarbazepine = PermissibleValue(text="Oxcarbazepine")
    Orantinib = PermissibleValue(text="Orantinib")
    Varlilumab = PermissibleValue(text="Varlilumab")
    Pracinostat = PermissibleValue(text="Pracinostat")
    Idetrexed = PermissibleValue(text="Idetrexed")
    Sivifene = PermissibleValue(text="Sivifene")
    Tapotoclax = PermissibleValue(text="Tapotoclax")
    Iproplatin = PermissibleValue(text="Iproplatin")
    HuaChanSu = PermissibleValue(text="HuaChanSu")
    Mirabegron = PermissibleValue(text="Mirabegron")
    Ensartinib = PermissibleValue(text="Ensartinib")
    Pidilizumab = PermissibleValue(text="Pidilizumab")
    Seribantumab = PermissibleValue(text="Seribantumab")
    Darinaparsin = PermissibleValue(text="Darinaparsin")
    Vantictumab = PermissibleValue(text="Vantictumab")
    Dasatinib = PermissibleValue(text="Dasatinib")
    Teniposide = PermissibleValue(text="Teniposide")
    Hexaminolevulinate = PermissibleValue(text="Hexaminolevulinate")
    Epacadostat = PermissibleValue(text="Epacadostat")
    Semaxanib = PermissibleValue(text="Semaxanib")
    Tidutamab = PermissibleValue(text="Tidutamab")
    Mavorixafor = PermissibleValue(text="Mavorixafor")
    Semustine = PermissibleValue(text="Semustine")
    Vorasidenib = PermissibleValue(text="Vorasidenib")
    Letolizumab = PermissibleValue(text="Letolizumab")
    Gimatecan = PermissibleValue(text="Gimatecan")
    Vosaroxin = PermissibleValue(text="Vosaroxin")
    Deferoxamine = PermissibleValue(text="Deferoxamine")
    Enoblituzumab = PermissibleValue(text="Enoblituzumab")
    Idarubicin = PermissibleValue(text="Idarubicin")
    Carotuximab = PermissibleValue(text="Carotuximab")
    Thiotepa = PermissibleValue(text="Thiotepa")
    Resminostat = PermissibleValue(text="Resminostat")
    Valecobulin = PermissibleValue(text="Valecobulin")
    Efizonerimod = PermissibleValue(text="Efizonerimod")
    Liarozole = PermissibleValue(text="Liarozole")
    Flanvotumab = PermissibleValue(text="Flanvotumab")
    Ivaltinostat = PermissibleValue(text="Ivaltinostat")
    Entrectinib = PermissibleValue(text="Entrectinib")
    Detirelix = PermissibleValue(text="Detirelix")
    Medroxyprogesterone = PermissibleValue(text="Medroxyprogesterone")
    Streptonigrin = PermissibleValue(text="Streptonigrin")
    Talacotuzumab = PermissibleValue(text="Talacotuzumab")
    Iberdomide = PermissibleValue(text="Iberdomide")
    Minretumomab = PermissibleValue(text="Minretumomab")
    Picropodophyllin = PermissibleValue(text="Picropodophyllin")
    Atuveciclib = PermissibleValue(text="Atuveciclib")
    Altiratinib = PermissibleValue(text="Altiratinib")
    Tomivosertib = PermissibleValue(text="Tomivosertib")
    Elsamitrucin = PermissibleValue(text="Elsamitrucin")
    Acronine = PermissibleValue(text="Acronine")
    Lurbinectedin = PermissibleValue(text="Lurbinectedin")
    Duvelisib = PermissibleValue(text="Duvelisib")
    Olaparib = PermissibleValue(text="Olaparib")
    Aprinocarsen = PermissibleValue(text="Aprinocarsen")
    Halofuginone = PermissibleValue(text="Halofuginone")
    Apatorsen = PermissibleValue(text="Apatorsen")
    Tegafur = PermissibleValue(text="Tegafur")
    Interferon = PermissibleValue(text="Interferon")
    Emitefur = PermissibleValue(text="Emitefur")
    Zebularine = PermissibleValue(text="Zebularine")
    Entolimod = PermissibleValue(text="Entolimod")
    Licartin = PermissibleValue(text="Licartin")
    Cevostamab = PermissibleValue(text="Cevostamab")
    Troglitazone = PermissibleValue(text="Troglitazone")
    Foslinanib = PermissibleValue(text="Foslinanib")
    Osilodrostat = PermissibleValue(text="Osilodrostat")
    Serabelisib = PermissibleValue(text="Serabelisib")
    Tiragolumab = PermissibleValue(text="Tiragolumab")
    Vibostolimab = PermissibleValue(text="Vibostolimab")
    Rhizoxin = PermissibleValue(text="Rhizoxin")
    Indibulin = PermissibleValue(text="Indibulin")

    _defn = EnumDefinition(
        name="EnumCRDCHSubstanceSubstanceType",
        description="Autogenerated Enumeration for CRDC-H Substance substance_type",
        code_set=None,
        code_set_version="2021-09-23T15:59:53.327354+00:00",
    )

    @classmethod
    def _addvals(cls):
        setattr(cls, "Anti-PTK7/Auristatin-0101 Antibody-drug Conjugate PF-06647020",
                PermissibleValue(text="Anti-PTK7/Auristatin-0101 Antibody-drug Conjugate PF-06647020") )
        setattr(cls, "EGFR/TGFb Fusion Monoclonal Antibody BCA101",
                PermissibleValue(text="EGFR/TGFb Fusion Monoclonal Antibody BCA101") )
        setattr(cls, "Naphthalimide Analogue UNBS5162",
                PermissibleValue(text="Naphthalimide Analogue UNBS5162") )
        setattr(cls, "Oral Ixabepilone",
                PermissibleValue(text="Oral Ixabepilone") )
        setattr(cls, "DNA Minor Groove Binding Agent SG2000",
                PermissibleValue(text="DNA Minor Groove Binding Agent SG2000") )
        setattr(cls, "Dromostanolone Propionate",
                PermissibleValue(text="Dromostanolone Propionate") )
        setattr(cls, "Pegylated Liposomal Nanoparticle-based Docetaxel Prodrug MNK-010",
                PermissibleValue(text="Pegylated Liposomal Nanoparticle-based Docetaxel Prodrug MNK-010") )
        setattr(cls, "ALK/FAK/Pyk2 Inhibitor CT-707",
                PermissibleValue(text="ALK/FAK/Pyk2 Inhibitor CT-707") )
        setattr(cls, "Attenuated Measles Virus Encoding SCD Transgene TMV-018",
                PermissibleValue(text="Attenuated Measles Virus Encoding SCD Transgene TMV-018") )
        setattr(cls, "Bcl-2 Inhibitor BGB-11417",
                PermissibleValue(text="Bcl-2 Inhibitor BGB-11417") )
        setattr(cls, "Rovalpituzumab Tesirine",
                PermissibleValue(text="Rovalpituzumab Tesirine") )
        setattr(cls, "Erastin Analogue PRLX 93936",
                PermissibleValue(text="Erastin Analogue PRLX 93936") )
        setattr(cls, "Anti-EGFRvIII Antibody Drug Conjugate AMG 595",
                PermissibleValue(text="Anti-EGFRvIII Antibody Drug Conjugate AMG 595") )
        setattr(cls, "Protein Arginine Methyltransferase 5 Inhibitor GSK3326595",
                PermissibleValue(text="Protein Arginine Methyltransferase 5 Inhibitor GSK3326595") )
        setattr(cls, "Mcl-1 Inhibitor AZD5991",
                PermissibleValue(text="Mcl-1 Inhibitor AZD5991") )
        setattr(cls, "Anti-LAG-3 Monoclonal Antibody LAG525",
                PermissibleValue(text="Anti-LAG-3 Monoclonal Antibody LAG525") )
        setattr(cls, "Anti-C4.4a Antibody-Drug Conjugate BAY1129980",
                PermissibleValue(text="Anti-C4.4a Antibody-Drug Conjugate BAY1129980") )
        setattr(cls, "Oblimersen Sodium",
                PermissibleValue(text="Oblimersen Sodium") )
        setattr(cls, "Anti-NY-ESO1/LAGE-1A TCR/scFv Anti-CD3 IMCnyeso",
                PermissibleValue(text="Anti-NY-ESO1/LAGE-1A TCR/scFv Anti-CD3 IMCnyeso") )
        setattr(cls, "Epothilone Analog UTD1",
                PermissibleValue(text="Epothilone Analog UTD1") )
        setattr(cls, "Indicine-N-Oxide",
                PermissibleValue(text="Indicine-N-Oxide") )
        setattr(cls, "HER2-targeting Antibody Fc Fragment FS102",
                PermissibleValue(text="HER2-targeting Antibody Fc Fragment FS102") )
        setattr(cls, "UAE Inhibitor TAK-243",
                PermissibleValue(text="UAE Inhibitor TAK-243") )
        setattr(cls, "HM2/MMAE Antibody-Drug Conjugate ALT-P7",
                PermissibleValue(text="HM2/MMAE Antibody-Drug Conjugate ALT-P7") )
        setattr(cls, "Anti-PD-L1/4-1BB Bispecific Antibody INBRX-105",
                PermissibleValue(text="Anti-PD-L1/4-1BB Bispecific Antibody INBRX-105") )
        setattr(cls, "FGF Receptor Antagonist HGS1036",
                PermissibleValue(text="FGF Receptor Antagonist HGS1036") )
        setattr(cls, "Anti-PR1/HLA-A2 Monoclonal Antibody Hu8F4",
                PermissibleValue(text="Anti-PR1/HLA-A2 Monoclonal Antibody Hu8F4") )
        setattr(cls, "DR5-targeting Tetrameric Nanobody Agonist TAS266",
                PermissibleValue(text="DR5-targeting Tetrameric Nanobody Agonist TAS266") )
        setattr(cls, "Methotrexate Sodium",
                PermissibleValue(text="Methotrexate Sodium") )
        setattr(cls, "Neoantigen-based Melanoma-Poly-ICLC Vaccine",
                PermissibleValue(text="Neoantigen-based Melanoma-Poly-ICLC Vaccine") )
        setattr(cls, "Phytochlorin Sodium-Polyvinylpyrrolidone Complex",
                PermissibleValue(text="Phytochlorin Sodium-Polyvinylpyrrolidone Complex") )
        setattr(cls, "TRPM8 Agonist D-3263",
                PermissibleValue(text="TRPM8 Agonist D-3263") )
        setattr(cls, "Folate Receptor-Targeted Vinca Alkaloid/Mitomycin C EC0225",
                PermissibleValue(text="Folate Receptor-Targeted Vinca Alkaloid/Mitomycin C EC0225") )
        setattr(cls, "Trifluridine and Tipiracil Hydrochloride",
                PermissibleValue(text="Trifluridine and Tipiracil Hydrochloride") )
        setattr(cls, "Recombinant Anti-WT1 Immunotherapeutic GSK2302024A",
                PermissibleValue(text="Recombinant Anti-WT1 Immunotherapeutic GSK2302024A") )
        setattr(cls, "Cytokine-based Biologic Agent IRX-2",
                PermissibleValue(text="Cytokine-based Biologic Agent IRX-2") )
        setattr(cls, "Anti-LIF Monoclonal Antibody MSC-1",
                PermissibleValue(text="Anti-LIF Monoclonal Antibody MSC-1") )
        setattr(cls, "Anti-Ribonucleoprotein Antibody ATRC-101",
                PermissibleValue(text="Anti-Ribonucleoprotein Antibody ATRC-101") )
        setattr(cls, "PARP-1/2 Inhibitor ABT-767",
                PermissibleValue(text="PARP-1/2 Inhibitor ABT-767") )
        setattr(cls, "2-Methoxyestradiol Nanocrystal Colloidal Dispersion",
                PermissibleValue(text="2-Methoxyestradiol Nanocrystal Colloidal Dispersion") )
        setattr(cls, "Yttrium Y 90 DOTA Anti-CEA Monoclonal Antibody M5A",
                PermissibleValue(text="Yttrium Y 90 DOTA Anti-CEA Monoclonal Antibody M5A") )
        setattr(cls, "Bis(choline)tetrathiomolybdate",
                PermissibleValue(text="Bis(choline)tetrathiomolybdate") )
        setattr(cls, "AXL/ FLT3/VEGFR2 Inhibitor KC1036",
                PermissibleValue(text="AXL/ FLT3/VEGFR2 Inhibitor KC1036") )
        setattr(cls, "Soy Protein Isolate",
                PermissibleValue(text="Soy Protein Isolate") )
        setattr(cls, "Anti-LIV-1 Monoclonal Antibody-MMAE Conjugate SGN-LIV1A",
                PermissibleValue(text="Anti-LIV-1 Monoclonal Antibody-MMAE Conjugate SGN-LIV1A") )
        setattr(cls, "Doxorubicin-HPMA Conjugate",
                PermissibleValue(text="Doxorubicin-HPMA Conjugate") )
        setattr(cls, "Allogeneic GM-CSF-secreting Breast Cancer Vaccine SV-BR-1-GM",
                PermissibleValue(text="Allogeneic GM-CSF-secreting Breast Cancer Vaccine SV-BR-1-GM") )
        setattr(cls, "p70S6K/Akt Inhibitor MSC2363318A",
                PermissibleValue(text="p70S6K/Akt Inhibitor MSC2363318A") )
        setattr(cls, "p97 Inhibitor CB-5339",
                PermissibleValue(text="p97 Inhibitor CB-5339") )
        setattr(cls, "Pan-KRAS Inhibitor BI 1701963",
                PermissibleValue(text="Pan-KRAS Inhibitor BI 1701963") )
        setattr(cls, "Zuclomiphene Citrate",
                PermissibleValue(text="Zuclomiphene Citrate") )
        setattr(cls, "Recombinant Interferon",
                PermissibleValue(text="Recombinant Interferon") )
        setattr(cls, "Non-Small Cell Lung Cancer mRNA-Derived Vaccine CV9201",
                PermissibleValue(text="Non-Small Cell Lung Cancer mRNA-Derived Vaccine CV9201") )
        setattr(cls, "Trans Sodium Crocetinate",
                PermissibleValue(text="Trans Sodium Crocetinate") )
        setattr(cls, "Androgen Receptor Ligand-binding Domain-encoding Plasmid DNA Vaccine MVI-118",
                PermissibleValue(text="Androgen Receptor Ligand-binding Domain-encoding Plasmid DNA Vaccine MVI-118") )
        setattr(cls, "PE/HPV16 E7/KDEL Fusion Protein/GPI-0100 TVGV-1",
                PermissibleValue(text="PE/HPV16 E7/KDEL Fusion Protein/GPI-0100 TVGV-1") )
        setattr(cls, "Androstane Steroid HE3235",
                PermissibleValue(text="Androstane Steroid HE3235") )
        setattr(cls, "Antibody-drug Conjugate ABBV-085",
                PermissibleValue(text="Antibody-drug Conjugate ABBV-085") )
        setattr(cls, "Recombinant Granulocyte-Macrophage Colony-Stimulating Factor",
                PermissibleValue(text="Recombinant Granulocyte-Macrophage Colony-Stimulating Factor") )
        setattr(cls, "OPCs/Green Tea/Spirullina/Curcumin/Antrodia Camphorate/Fermented Soymilk Extract Capsule",
                PermissibleValue(text="OPCs/Green Tea/Spirullina/Curcumin/Antrodia Camphorate/Fermented Soymilk Extract Capsule") )
        setattr(cls, "Lipid Nanoparticle Encapsulated mRNAs Encoding Human IL-12A/IL-12B MEDI-1191",
                PermissibleValue(text="Lipid Nanoparticle Encapsulated mRNAs Encoding Human IL-12A/IL-12B MEDI-1191") )
        setattr(cls, "Ribonuclease QBI-139",
                PermissibleValue(text="Ribonuclease QBI-139") )
        setattr(cls, "Folate Receptor-Targeted Tubulysin Conjugate EC1456",
                PermissibleValue(text="Folate Receptor-Targeted Tubulysin Conjugate EC1456") )
        setattr(cls, "Fas Ligand-treated Allogeneic Mobilized Peripheral Blood Cells",
                PermissibleValue(text="Fas Ligand-treated Allogeneic Mobilized Peripheral Blood Cells") )
        setattr(cls, "Bruceanol A",
                PermissibleValue(text="Bruceanol A") )
        setattr(cls, "Ispinesib Mesylate",
                PermissibleValue(text="Ispinesib Mesylate") )
        setattr(cls, "Buthionine Sulfoximine",
                PermissibleValue(text="Buthionine Sulfoximine") )
        setattr(cls, "Recombinant Fractalkine",
                PermissibleValue(text="Recombinant Fractalkine") )
        setattr(cls, "IDH1(R132) Inhibitor IDH305",
                PermissibleValue(text="IDH1(R132) Inhibitor IDH305") )
        setattr(cls, "XBP1-US/XBP1-SP/CD138/CS1 Multipeptide Vaccine PVX-410",
                PermissibleValue(text="XBP1-US/XBP1-SP/CD138/CS1 Multipeptide Vaccine PVX-410") )
        setattr(cls, "Anti-GARP Monoclonal Antibody ABBV-151",
                PermissibleValue(text="Anti-GARP Monoclonal Antibody ABBV-151") )
        setattr(cls, "NG-nitro-L-arginine",
                PermissibleValue(text="NG-nitro-L-arginine") )
        setattr(cls, "FGFR2 Inhibitor RLY-4008",
                PermissibleValue(text="FGFR2 Inhibitor RLY-4008") )
        setattr(cls, "Radotinib Hydrochloride",
                PermissibleValue(text="Radotinib Hydrochloride") )
        setattr(cls, "Vascular Disrupting Agent BNC105P",
                PermissibleValue(text="Vascular Disrupting Agent BNC105P") )
        setattr(cls, "Sustained-release Mitomycin C Hydrogel Formulation UGN-101",
                PermissibleValue(text="Sustained-release Mitomycin C Hydrogel Formulation UGN-101") )
        setattr(cls, "Anti-CXCR4 Monoclonal Antibody PF-06747143",
                PermissibleValue(text="Anti-CXCR4 Monoclonal Antibody PF-06747143") )
        setattr(cls, "Iodine I-131",
                PermissibleValue(text="Iodine I-131") )
        setattr(cls, "iPSC-derived Natural Killer Cells FT500",
                PermissibleValue(text="iPSC-derived Natural Killer Cells FT500") )
        setattr(cls, "HDAC8 Inhibitor NBM-BMX",
                PermissibleValue(text="HDAC8 Inhibitor NBM-BMX") )
        setattr(cls, "Anti-CLDN6 Monoclonal Antibody ASP1650",
                PermissibleValue(text="Anti-CLDN6 Monoclonal Antibody ASP1650") )
        setattr(cls, "Piroxantrone Hydrochloride",
                PermissibleValue(text="Piroxantrone Hydrochloride") )
        setattr(cls, "Allogeneic Cellular Vaccine 1650-G",
                PermissibleValue(text="Allogeneic Cellular Vaccine 1650-G") )
        setattr(cls, "Bcl-2 Inhibitor S65487",
                PermissibleValue(text="Bcl-2 Inhibitor S65487") )
        setattr(cls, "Rhenium Re-186 Hydroxyethylidene Diphosphonate",
                PermissibleValue(text="Rhenium Re-186 Hydroxyethylidene Diphosphonate") )
        setattr(cls, "TRK Inhibitor AZD6918",
                PermissibleValue(text="TRK Inhibitor AZD6918") )
        setattr(cls, "MCL-1 Inhibitor AMG 176",
                PermissibleValue(text="MCL-1 Inhibitor AMG 176") )
        setattr(cls, "Tubulin-Binding Agent SSR97225",
                PermissibleValue(text="Tubulin-Binding Agent SSR97225") )
        setattr(cls, "Anti-CD32B Monoclonal Antibody BI-1206",
                PermissibleValue(text="Anti-CD32B Monoclonal Antibody BI-1206") )
        setattr(cls, "Metatinib Tromethamine",
                PermissibleValue(text="Metatinib Tromethamine") )
        setattr(cls, "Oral Cancer Vaccine V3-OVA",
                PermissibleValue(text="Oral Cancer Vaccine V3-OVA") )
        setattr(cls, "Anti-IL-8 Monoclonal Antibody HuMax-IL8",
                PermissibleValue(text="Anti-IL-8 Monoclonal Antibody HuMax-IL8") )
        setattr(cls, "Ingenol Mebutate Gel",
                PermissibleValue(text="Ingenol Mebutate Gel") )
        setattr(cls, "Docetaxel Polymeric Micelles",
                PermissibleValue(text="Docetaxel Polymeric Micelles") )
        setattr(cls, "MEK inhibitor CS3006",
                PermissibleValue(text="MEK inhibitor CS3006") )
        setattr(cls, "Sunitinib Malate",
                PermissibleValue(text="Sunitinib Malate") )
        setattr(cls, "Autologous ROR2-targeted CAR T-cells CCT301-59",
                PermissibleValue(text="Autologous ROR2-targeted CAR T-cells CCT301-59") )
        setattr(cls, "Cell Cycle Checkpoint/DNA Repair Antagonist IC83",
                PermissibleValue(text="Cell Cycle Checkpoint/DNA Repair Antagonist IC83") )
        setattr(cls, "Nogapendekin Alfa",
                PermissibleValue(text="Nogapendekin Alfa") )
        setattr(cls, "CAR T-Cells AMG 119",
                PermissibleValue(text="CAR T-Cells AMG 119") )
        setattr(cls, "Fadrozole Hydrochloride",
                PermissibleValue(text="Fadrozole Hydrochloride") )
        setattr(cls, "Anti-PD-L1 Monoclonal Antibody RC98",
                PermissibleValue(text="Anti-PD-L1 Monoclonal Antibody RC98") )
        setattr(cls, "Etirinotecan Pegol",
                PermissibleValue(text="Etirinotecan Pegol") )
        setattr(cls, "Protein Phosphatase 2A Inhibitor LB-100",
                PermissibleValue(text="Protein Phosphatase 2A Inhibitor LB-100") )
        setattr(cls, "Calaspargase Pegol-mknl",
                PermissibleValue(text="Calaspargase Pegol-mknl") )
        setattr(cls, "Polypodium leucotomos Extract",
                PermissibleValue(text="Polypodium leucotomos Extract") )
        setattr(cls, "Tegafur-Uracil",
                PermissibleValue(text="Tegafur-Uracil") )
        setattr(cls, "FAK Inhibitor VS-4718",
                PermissibleValue(text="FAK Inhibitor VS-4718") )
        setattr(cls, "BTK Inhibitor HZ-A-018",
                PermissibleValue(text="BTK Inhibitor HZ-A-018") )
        setattr(cls, "4'-Iodo-4'-Deoxydoxorubicin",
                PermissibleValue(text="4'-Iodo-4'-Deoxydoxorubicin") )
        setattr(cls, "PARP Inhibitor E7016",
                PermissibleValue(text="PARP Inhibitor E7016") )
        setattr(cls, "Anti-PD-L1/TIM-3 Bispecific Antibody LY3415244",
                PermissibleValue(text="Anti-PD-L1/TIM-3 Bispecific Antibody LY3415244") )
        setattr(cls, "Akt/ERK Inhibitor ONC201",
                PermissibleValue(text="Akt/ERK Inhibitor ONC201") )
        setattr(cls, "Autologous NKG2D CAR-CD3zeta-DAP10-expressing T-Lymphocytes CYAD-01",
                PermissibleValue(text="Autologous NKG2D CAR-CD3zeta-DAP10-expressing T-Lymphocytes CYAD-01") )
        setattr(cls, "Checkpoint Kinase Inhibitor XL844",
                PermissibleValue(text="Checkpoint Kinase Inhibitor XL844") )
        setattr(cls, "Autologous CD19/PD-1 Bispecific CAR-T Cells",
                PermissibleValue(text="Autologous CD19/PD-1 Bispecific CAR-T Cells") )
        setattr(cls, "Long Peptide Vaccine 7",
                PermissibleValue(text="Long Peptide Vaccine 7") )
        setattr(cls, "Matrix Metalloproteinase Inhibitor MMI270",
                PermissibleValue(text="Matrix Metalloproteinase Inhibitor MMI270") )
        setattr(cls, "Bleomycin Sulfate",
                PermissibleValue(text="Bleomycin Sulfate") )
        setattr(cls, "EGFR Inhibitor TY-9591",
                PermissibleValue(text="EGFR Inhibitor TY-9591") )
        setattr(cls, "Anti-CD30 Monoclonal Antibody MDX-1401",
                PermissibleValue(text="Anti-CD30 Monoclonal Antibody MDX-1401") )
        setattr(cls, "Survivin mRNA Antagonist EZN-3042",
                PermissibleValue(text="Survivin mRNA Antagonist EZN-3042") )
        setattr(cls, "Anti-VEGF Anticalin PRS-050-PEG40",
                PermissibleValue(text="Anti-VEGF Anticalin PRS-050-PEG40") )
        setattr(cls, "LMB-2 Immunotoxin",
                PermissibleValue(text="LMB-2 Immunotoxin") )
        setattr(cls, "St. John's Wort",
                PermissibleValue(text="St. John's Wort") )
        setattr(cls, "Brequinar Sodium",
                PermissibleValue(text="Brequinar Sodium") )
        setattr(cls, "mTOR Kinase Inhibitor PP242",
                PermissibleValue(text="mTOR Kinase Inhibitor PP242") )
        setattr(cls, "2-Hydroxyestrone",
                PermissibleValue(text="2-Hydroxyestrone") )
        setattr(cls, "Total Androgen Blockade",
                PermissibleValue(text="Total Androgen Blockade") )
        setattr(cls, "FGFR/VEGFR/PDGFR/FLT3/SRC Inhibitor XL999",
                PermissibleValue(text="FGFR/VEGFR/PDGFR/FLT3/SRC Inhibitor XL999") )
        setattr(cls, "Anti-PD-1 Monoclonal Antibody AK105",
                PermissibleValue(text="Anti-PD-1 Monoclonal Antibody AK105") )
        setattr(cls, "Talaporfin Sodium",
                PermissibleValue(text="Talaporfin Sodium") )
        setattr(cls, "PKC-beta Inhibitor MS-553",
                PermissibleValue(text="PKC-beta Inhibitor MS-553") )
        setattr(cls, "Autologous Genetically-modified MAGE-A4 C1032 T Cells",
                PermissibleValue(text="Autologous Genetically-modified MAGE-A4 C1032 T Cells") )
        setattr(cls, "Zinc Finger Nuclease ZFN-758",
                PermissibleValue(text="Zinc Finger Nuclease ZFN-758") )
        setattr(cls, "Prednisolone Sodium Phosphate",
                PermissibleValue(text="Prednisolone Sodium Phosphate") )
        setattr(cls, "MUC1-targeted Peptide GO-203-2C",
                PermissibleValue(text="MUC1-targeted Peptide GO-203-2C") )
        setattr(cls, "Aminopterin Sodium",
                PermissibleValue(text="Aminopterin Sodium") )
        setattr(cls, "2-Hydroxyestradiol",
                PermissibleValue(text="2-Hydroxyestradiol") )
        setattr(cls, "Plasmid DNA Vaccine pING-hHER3FL",
                PermissibleValue(text="Plasmid DNA Vaccine pING-hHER3FL") )
        setattr(cls, "Ang2/VEGF-Binding Peptides-Antibody Fusion Protein CVX-241",
                PermissibleValue(text="Ang2/VEGF-Binding Peptides-Antibody Fusion Protein CVX-241") )
        setattr(cls, "Anti-GRP78 Monoclonal Antibody PAT-SM6",
                PermissibleValue(text="Anti-GRP78 Monoclonal Antibody PAT-SM6") )
        setattr(cls, "Anti-LAG-3 Monoclonal Antibody IBI-110",
                PermissibleValue(text="Anti-LAG-3 Monoclonal Antibody IBI-110") )
        setattr(cls, "Anti-CD123/CD3 Bispecific Antibody APVO436",
                PermissibleValue(text="Anti-CD123/CD3 Bispecific Antibody APVO436") )
        setattr(cls, "Synthetic hTERT DNA Vaccine INO-1401",
                PermissibleValue(text="Synthetic hTERT DNA Vaccine INO-1401") )
        setattr(cls, "Infigratinib Mesylate",
                PermissibleValue(text="Infigratinib Mesylate") )
        setattr(cls, "Anti-TROP2 Antibody-drug Conjugate BAT8003",
                PermissibleValue(text="Anti-TROP2 Antibody-drug Conjugate BAT8003") )
        setattr(cls, "Oxaliplatin-Encapsulated Transferrin-Conjugated N-glutaryl Phosphatidylethanolamine Liposome",
                PermissibleValue(text="Oxaliplatin-Encapsulated Transferrin-Conjugated N-glutaryl Phosphatidylethanolamine Liposome") )
        setattr(cls, "Autologous Anti-NY-ESO-1/LAGE-1 TCR-transduced c259 T Lymphocytes GSK3377794",
                PermissibleValue(text="Autologous Anti-NY-ESO-1/LAGE-1 TCR-transduced c259 T Lymphocytes GSK3377794") )
        setattr(cls, "HSP90-targeted SN-38 Conjugate PEN-866",
                PermissibleValue(text="HSP90-targeted SN-38 Conjugate PEN-866") )
        setattr(cls, "Ras Peptide CYS",
                PermissibleValue(text="Ras Peptide CYS") )
        setattr(cls, "SHP2 Inhibitor RMC-4630",
                PermissibleValue(text="SHP2 Inhibitor RMC-4630") )
        setattr(cls, "Copper Cu 67 Tyr3-octreotate",
                PermissibleValue(text="Copper Cu 67 Tyr3-octreotate") )
        setattr(cls, "Integrin alpha-2 Inhibitor E7820",
                PermissibleValue(text="Integrin alpha-2 Inhibitor E7820") )
        setattr(cls, "Survivin Antigen Vaccine DPX-Survivac",
                PermissibleValue(text="Survivin Antigen Vaccine DPX-Survivac") )
        setattr(cls, "Autologous Anti-CD22 CAR-4-1BB-TCRz-transduced T-lymphocytes CART22-65s",
                PermissibleValue(text="Autologous Anti-CD22 CAR-4-1BB-TCRz-transduced T-lymphocytes CART22-65s") )
        setattr(cls, "ALK/TRK Inhibitor TSR-011",
                PermissibleValue(text="ALK/TRK Inhibitor TSR-011") )
        setattr(cls, "Anti-PRL-3 Monoclonal Antibody PRL3-zumab",
                PermissibleValue(text="Anti-PRL-3 Monoclonal Antibody PRL3-zumab") )
        setattr(cls, "FGFR Inhibitor TAS-120",
                PermissibleValue(text="FGFR Inhibitor TAS-120") )
        setattr(cls, "Denintuzumab Mafodotin",
                PermissibleValue(text="Denintuzumab Mafodotin") )
        setattr(cls, "PI3K-delta Inhibitor HMPL 689",
                PermissibleValue(text="PI3K-delta Inhibitor HMPL 689") )
        setattr(cls, "Topical Betulinic Acid",
                PermissibleValue(text="Topical Betulinic Acid") )
        setattr(cls, "Hsp90-targeted Photosensitizer HS-201",
                PermissibleValue(text="Hsp90-targeted Photosensitizer HS-201") )
        setattr(cls, "Heparan Sulfate Glycosaminoglycan Mimetic M402",
                PermissibleValue(text="Heparan Sulfate Glycosaminoglycan Mimetic M402") )
        setattr(cls, "Hsp90 Inhibitor AB-010",
                PermissibleValue(text="Hsp90 Inhibitor AB-010") )
        setattr(cls, "Anti-CD19 iCAR NK Cells",
                PermissibleValue(text="Anti-CD19 iCAR NK Cells") )
        setattr(cls, "Polyunsaturated Fatty Acid",
                PermissibleValue(text="Polyunsaturated Fatty Acid") )
        setattr(cls, "CAB-ROR2-ADC BA3021",
                PermissibleValue(text="CAB-ROR2-ADC BA3021") )
        setattr(cls, "Levothyroxine Sodium",
                PermissibleValue(text="Levothyroxine Sodium") )
        setattr(cls, "Triptolide Analog",
                PermissibleValue(text="Triptolide Analog") )
        setattr(cls, "Panobinostat Nanoparticle Formulation MTX110",
                PermissibleValue(text="Panobinostat Nanoparticle Formulation MTX110") )
        setattr(cls, "HLA-A2-restricted Melanoma-specific Peptides Vaccine GRN-1201",
                PermissibleValue(text="HLA-A2-restricted Melanoma-specific Peptides Vaccine GRN-1201") )
        setattr(cls, "Anti-VEGF/ANG2 Nanobody BI 836880",
                PermissibleValue(text="Anti-VEGF/ANG2 Nanobody BI 836880") )
        setattr(cls, "Iodine I 131 Derlotuximab Biotin",
                PermissibleValue(text="Iodine I 131 Derlotuximab Biotin") )
        setattr(cls, "Nucleotide Analogue GS 9219",
                PermissibleValue(text="Nucleotide Analogue GS 9219") )
        setattr(cls, "Anti-CD47 ADC SGN-CD47M",
                PermissibleValue(text="Anti-CD47 ADC SGN-CD47M") )
        setattr(cls, "Anti-PSMA/CD3 Monoclonal Antibody MOR209/ES414",
                PermissibleValue(text="Anti-PSMA/CD3 Monoclonal Antibody MOR209/ES414") )
        setattr(cls, "Ets-family Transcription Factor Inhibitor TK216",
                PermissibleValue(text="Ets-family Transcription Factor Inhibitor TK216") )
        setattr(cls, "Adenosine A2A/A2B Receptor Antagonist AB928",
                PermissibleValue(text="Adenosine A2A/A2B Receptor Antagonist AB928") )
        setattr(cls, "Anti-PD-L1 Monoclonal Antibody TG-1501",
                PermissibleValue(text="Anti-PD-L1 Monoclonal Antibody TG-1501") )
        setattr(cls, "Oral Hsp90 Inhibitor IPI-493",
                PermissibleValue(text="Oral Hsp90 Inhibitor IPI-493") )
        setattr(cls, "Anti-PVRIG Monoclonal Antibody COM701",
                PermissibleValue(text="Anti-PVRIG Monoclonal Antibody COM701") )
        setattr(cls, "DHEA Mustard",
                PermissibleValue(text="DHEA Mustard") )
        setattr(cls, "SSTR2-targeting Protein/DM1 Conjugate PEN-221",
                PermissibleValue(text="SSTR2-targeting Protein/DM1 Conjugate PEN-221") )
        setattr(cls, "Anti-CEACAM1 Monoclonal Antibody CM-24",
                PermissibleValue(text="Anti-CEACAM1 Monoclonal Antibody CM-24") )
        setattr(cls, "Anti-PD-1 Monoclonal Antibody BAT1306",
                PermissibleValue(text="Anti-PD-1 Monoclonal Antibody BAT1306") )
        setattr(cls, "Raf Kinase Inhibitor HM95573",
                PermissibleValue(text="Raf Kinase Inhibitor HM95573") )
        setattr(cls, "Anti-PD-L1 Monoclonal Antibody MDX-1105",
                PermissibleValue(text="Anti-PD-L1 Monoclonal Antibody MDX-1105") )
        setattr(cls, "Palonosetron Hydrochloride",
                PermissibleValue(text="Palonosetron Hydrochloride") )
        setattr(cls, "Gemcitabine-Releasing Intravesical System",
                PermissibleValue(text="Gemcitabine-Releasing Intravesical System") )
        setattr(cls, "Allogeneic Anti-CD20-CAR T-cells PBCAR20A",
                PermissibleValue(text="Allogeneic Anti-CD20-CAR T-cells PBCAR20A") )
        setattr(cls, "Yttrium Y 90 Colloid",
                PermissibleValue(text="Yttrium Y 90 Colloid") )
        setattr(cls, "Colchicine-Site Binding Agent ABT-751",
                PermissibleValue(text="Colchicine-Site Binding Agent ABT-751") )
        setattr(cls, "Antineoplastic Agent Combination SM-88",
                PermissibleValue(text="Antineoplastic Agent Combination SM-88") )
        setattr(cls, "Pan-AKT Inhibitor ARQ751",
                PermissibleValue(text="Pan-AKT Inhibitor ARQ751") )
        setattr(cls, "White Carrot",
                PermissibleValue(text="White Carrot") )
        setattr(cls, "HPV 16 E7 Antigen-expressing Lactobacillis casei Vaccine BLS-ILB-E710c",
                PermissibleValue(text="HPV 16 E7 Antigen-expressing Lactobacillis casei Vaccine BLS-ILB-E710c") )
        setattr(cls, "Anti-HER2/Anti-CD3 Bispecific Monoclonal Antibody BTRC 4017A",
                PermissibleValue(text="Anti-HER2/Anti-CD3 Bispecific Monoclonal Antibody BTRC 4017A") )
        setattr(cls, "Lutetium Lu 177-DTPA-omburtamab",
                PermissibleValue(text="Lutetium Lu 177-DTPA-omburtamab") )
        setattr(cls, "Imetelstat Sodium",
                PermissibleValue(text="Imetelstat Sodium") )
        setattr(cls, "Pan-PIM Inhibitor INCB053914",
                PermissibleValue(text="Pan-PIM Inhibitor INCB053914") )
        setattr(cls, "Liposomal Curcumin",
                PermissibleValue(text="Liposomal Curcumin") )
        setattr(cls, "Cyclodextrin-Based Polymer-Camptothecin CRLX101",
                PermissibleValue(text="Cyclodextrin-Based Polymer-Camptothecin CRLX101") )
        setattr(cls, "Anti-BCMA/CD3 BiTE Antibody AMG 701",
                PermissibleValue(text="Anti-BCMA/CD3 BiTE Antibody AMG 701") )
        setattr(cls, "Anti-MUC16/CD3 BiTE Antibody REGN4018",
                PermissibleValue(text="Anti-MUC16/CD3 BiTE Antibody REGN4018") )
        setattr(cls, "Amuvatinib Hydrochloride",
                PermissibleValue(text="Amuvatinib Hydrochloride") )
        setattr(cls, "Sodium Salicylate",
                PermissibleValue(text="Sodium Salicylate") )
        setattr(cls, "Anti-TIM3 Monoclonal Antibody SHR-1702",
                PermissibleValue(text="Anti-TIM3 Monoclonal Antibody SHR-1702") )
        setattr(cls, "DEC-205/NY-ESO-1 Fusion Protein CDX-1401",
                PermissibleValue(text="DEC-205/NY-ESO-1 Fusion Protein CDX-1401") )
        setattr(cls, "Methanol Extraction Residue of BCG",
                PermissibleValue(text="Methanol Extraction Residue of BCG") )
        setattr(cls, "Aminoflavone Prodrug AFP464",
                PermissibleValue(text="Aminoflavone Prodrug AFP464") )
        setattr(cls, "Autologous BCMA-targeted CAR T Cells CC-98633",
                PermissibleValue(text="Autologous BCMA-targeted CAR T Cells CC-98633") )
        setattr(cls, "Autologous Prostate Cancer Antigen-expressing Dendritic Cell Vaccine BPX-101",
                PermissibleValue(text="Autologous Prostate Cancer Antigen-expressing Dendritic Cell Vaccine BPX-101") )
        setattr(cls, "Engineered Human Umbilical Vein Endothelial Cells AB-205",
                PermissibleValue(text="Engineered Human Umbilical Vein Endothelial Cells AB-205") )
        setattr(cls, "Sodium Phenylbutyrate",
                PermissibleValue(text="Sodium Phenylbutyrate") )
        setattr(cls, "FGFR Inhibitor Debio 1347",
                PermissibleValue(text="FGFR Inhibitor Debio 1347") )
        setattr(cls, "Pyrotinib Dimaleate",
                PermissibleValue(text="Pyrotinib Dimaleate") )
        setattr(cls, "CD40 Agonist Monoclonal Antibody CP-870,893",
                PermissibleValue(text="CD40 Agonist Monoclonal Antibody CP-870,893") )
        setattr(cls, "Alpha-Thioguanine Deoxyriboside",
                PermissibleValue(text="Alpha-Thioguanine Deoxyriboside") )
        setattr(cls, "Bispecific Antibody 2B1",
                PermissibleValue(text="Bispecific Antibody 2B1") )
        setattr(cls, "Rocapuldencel-T",
                PermissibleValue(text="Rocapuldencel-T") )
        setattr(cls, "NLRP3 Agonist BMS-986299",
                PermissibleValue(text="NLRP3 Agonist BMS-986299") )
        setattr(cls, "Anti-alpha5beta1 Integrin Antibody MINT1526A",
                PermissibleValue(text="Anti-alpha5beta1 Integrin Antibody MINT1526A") )
        setattr(cls, "Anti-CD33 Antibody-drug Conjugate IMGN779",
                PermissibleValue(text="Anti-CD33 Antibody-drug Conjugate IMGN779") )
        setattr(cls, "Anti-CD20 Monoclonal Antibody MIL62",
                PermissibleValue(text="Anti-CD20 Monoclonal Antibody MIL62") )
        setattr(cls, "Anti-FGFR2 Antibody BAY1179470",
                PermissibleValue(text="Anti-FGFR2 Antibody BAY1179470") )
        setattr(cls, "Anti-TIM-3 Monoclonal Antibody INCAGN02390",
                PermissibleValue(text="Anti-TIM-3 Monoclonal Antibody INCAGN02390") )
        setattr(cls, "Firtecan Pegol",
                PermissibleValue(text="Firtecan Pegol") )
        setattr(cls, "BRAF(V600E) Kinase Inhibitor ABM-1310",
                PermissibleValue(text="BRAF(V600E) Kinase Inhibitor ABM-1310") )
        setattr(cls, "Salmonella VNP20009",
                PermissibleValue(text="Salmonella VNP20009") )
        setattr(cls, "Hyaluronidase-zzxf/Pertuzumab/Trastuzumab",
                PermissibleValue(text="Hyaluronidase-zzxf/Pertuzumab/Trastuzumab") )
        setattr(cls, "Belotecan Hydrochloride",
                PermissibleValue(text="Belotecan Hydrochloride") )
        setattr(cls, "BET Inhibitor CPI-0610",
                PermissibleValue(text="BET Inhibitor CPI-0610") )
        setattr(cls, "Camptothecin-20(S)-O-Propionate Hydrate",
                PermissibleValue(text="Camptothecin-20(S)-O-Propionate Hydrate") )
        setattr(cls, "Colloidal Gold-Bound Tumor Necrosis Factor",
                PermissibleValue(text="Colloidal Gold-Bound Tumor Necrosis Factor") )
        setattr(cls, "Mitomycin B",
                PermissibleValue(text="Mitomycin B") )
        setattr(cls, "Anti-DR5 Agonist Monoclonal Antibody TRA-8",
                PermissibleValue(text="Anti-DR5 Agonist Monoclonal Antibody TRA-8") )
        setattr(cls, "Yttrium Y 90 Tabituximab Barzuxetan",
                PermissibleValue(text="Yttrium Y 90 Tabituximab Barzuxetan") )
        setattr(cls, "Anti-CTLA-4 Monoclonal Antibody BCD-145",
                PermissibleValue(text="Anti-CTLA-4 Monoclonal Antibody BCD-145") )
        setattr(cls, "Iodine I 131 MIP-1095",
                PermissibleValue(text="Iodine I 131 MIP-1095") )
        setattr(cls, "Multipeptide Vaccine S-588210",
                PermissibleValue(text="Multipeptide Vaccine S-588210") )
        setattr(cls, "Adenoviral Tumor-specific Neoantigen Priming Vaccine GRT-C901",
                PermissibleValue(text="Adenoviral Tumor-specific Neoantigen Priming Vaccine GRT-C901") )
        setattr(cls, "Anti-CD3/Anti-BCMA Bispecific Monoclonal Antibody JNJ-64007957",
                PermissibleValue(text="Anti-CD3/Anti-BCMA Bispecific Monoclonal Antibody JNJ-64007957") )
        setattr(cls, "Green Tea Extract-based Antioxidant Supplement",
                PermissibleValue(text="Green Tea Extract-based Antioxidant Supplement") )
        setattr(cls, "IDO1/TDO2 Inhibitor DN1406131",
                PermissibleValue(text="IDO1/TDO2 Inhibitor DN1406131") )
        setattr(cls, "Anti-EphA2 Antibody-directed Liposomal Docetaxel Prodrug MM-310",
                PermissibleValue(text="Anti-EphA2 Antibody-directed Liposomal Docetaxel Prodrug MM-310") )
        setattr(cls, "PDK1 Inhibitor AR-12",
                PermissibleValue(text="PDK1 Inhibitor AR-12") )
        setattr(cls, "Topical Gemcitabine Hydrochloride",
                PermissibleValue(text="Topical Gemcitabine Hydrochloride") )
        setattr(cls, "Methotrexate-Encapsulating Autologous Tumor-Derived Microparticles",
                PermissibleValue(text="Methotrexate-Encapsulating Autologous Tumor-Derived Microparticles") )
        setattr(cls, "Shenqi Fuzheng Injection SQ001",
                PermissibleValue(text="Shenqi Fuzheng Injection SQ001") )
        setattr(cls, "Selective Estrogen Receptor Degrader LX-039",
                PermissibleValue(text="Selective Estrogen Receptor Degrader LX-039") )
        setattr(cls, "Chk1 Inhibitor GDC-0575",
                PermissibleValue(text="Chk1 Inhibitor GDC-0575") )
        setattr(cls, "Lutetium Lu-177 Girentuximab",
                PermissibleValue(text="Lutetium Lu-177 Girentuximab") )
        setattr(cls, "Coenzyme Q10",
                PermissibleValue(text="Coenzyme Q10") )
        setattr(cls, "ChiNing Decoction",
                PermissibleValue(text="ChiNing Decoction") )
        setattr(cls, "Immediate-release Tablet Afuresertib",
                PermissibleValue(text="Immediate-release Tablet Afuresertib") )
        setattr(cls, "Anti-GD2 Monoclonal Antibody MORAb-028",
                PermissibleValue(text="Anti-GD2 Monoclonal Antibody MORAb-028") )
        setattr(cls, "Holmium Ho 166 Poly(L-Lactic Acid) Microspheres",
                PermissibleValue(text="Holmium Ho 166 Poly(L-Lactic Acid) Microspheres") )
        setattr(cls, "Autologous Anti-BCMA-CAR-4-1BB-CD3zeta-expressing CD4+/CD8+ T-lymphocytes JCARH125",
                PermissibleValue(text="Autologous Anti-BCMA-CAR-4-1BB-CD3zeta-expressing CD4+/CD8+ T-lymphocytes JCARH125") )
        setattr(cls, "Luminespib Mesylate",
                PermissibleValue(text="Luminespib Mesylate") )
        setattr(cls, "Sacituzumab Govitecan",
                PermissibleValue(text="Sacituzumab Govitecan") )
        setattr(cls, "PLK1 Inhibitor CYC140",
                PermissibleValue(text="PLK1 Inhibitor CYC140") )
        setattr(cls, "Gastrin Immunotoxin",
                PermissibleValue(text="Gastrin Immunotoxin") )
        setattr(cls, "Anti-B7-H3 Antibody DS-5573a",
                PermissibleValue(text="Anti-B7-H3 Antibody DS-5573a") )
        setattr(cls, "mTOR Kinase Inhibitor OSI-027",
                PermissibleValue(text="mTOR Kinase Inhibitor OSI-027") )
        setattr(cls, "Beta-Glucan MM-10-001",
                PermissibleValue(text="Beta-Glucan MM-10-001") )
        setattr(cls, "Therapeutic Estradiol",
                PermissibleValue(text="Therapeutic Estradiol") )
        setattr(cls, "Interleukin-15/Interleukin-15 Receptor Alpha Complex-Fc Fusion Protein XmAb24306",
                PermissibleValue(text="Interleukin-15/Interleukin-15 Receptor Alpha Complex-Fc Fusion Protein XmAb24306") )
        setattr(cls, "Tasisulam Sodium",
                PermissibleValue(text="Tasisulam Sodium") )
        setattr(cls, "Eniluracil/5-FU Combination Tablet",
                PermissibleValue(text="Eniluracil/5-FU Combination Tablet") )
        setattr(cls, "Botanical Agent LEAC-102",
                PermissibleValue(text="Botanical Agent LEAC-102") )
        setattr(cls, "Androgen Receptor Antagonist TAS3681",
                PermissibleValue(text="Androgen Receptor Antagonist TAS3681") )
        setattr(cls, "Lipid Encapsulated Anti-PLK1 siRNA TKM-PLK1",
                PermissibleValue(text="Lipid Encapsulated Anti-PLK1 siRNA TKM-PLK1") )
        setattr(cls, "Exatecan Mesylate Anhydrous",
                PermissibleValue(text="Exatecan Mesylate Anhydrous") )
        setattr(cls, "Betulinic Acid",
                PermissibleValue(text="Betulinic Acid") )
        setattr(cls, "CD11b Agonist GB1275",
                PermissibleValue(text="CD11b Agonist GB1275") )
        setattr(cls, "ROBO1-targeted BiCAR-NKT Cells",
                PermissibleValue(text="ROBO1-targeted BiCAR-NKT Cells") )
        setattr(cls, "Attenuated Listeria monocytogenes CRS-100",
                PermissibleValue(text="Attenuated Listeria monocytogenes CRS-100") )
        setattr(cls, "Anti-ICOS Monoclonal Antibody MEDI-570",
                PermissibleValue(text="Anti-ICOS Monoclonal Antibody MEDI-570") )
        setattr(cls, "10-Deacetyltaxol",
                PermissibleValue(text="10-Deacetyltaxol") )
        setattr(cls, "Gemcitabine Hydrochloride Emulsion",
                PermissibleValue(text="Gemcitabine Hydrochloride Emulsion") )
        setattr(cls, "Selective Estrogen Receptor Modulator TAS-108",
                PermissibleValue(text="Selective Estrogen Receptor Modulator TAS-108") )
        setattr(cls, "Anti-ACTR/4-1BB/CD3zeta-Viral Vector-transduced Autologous T-Lymphocytes ACTR087",
                PermissibleValue(text="Anti-ACTR/4-1BB/CD3zeta-Viral Vector-transduced Autologous T-Lymphocytes ACTR087") )
        setattr(cls, "Taxol Analogue SID 530",
                PermissibleValue(text="Taxol Analogue SID 530") )
        setattr(cls, "Tisotumab Vedotin",
                PermissibleValue(text="Tisotumab Vedotin") )
        setattr(cls, "Y 90 Monoclonal Antibody M195",
                PermissibleValue(text="Y 90 Monoclonal Antibody M195") )
        setattr(cls, "SERD G1T48",
                PermissibleValue(text="SERD G1T48") )
        setattr(cls, "PARP Inhibitor NMS-03305293",
                PermissibleValue(text="PARP Inhibitor NMS-03305293") )
        setattr(cls, "Niraparib Tosylate Monohydrate",
                PermissibleValue(text="Niraparib Tosylate Monohydrate") )
        setattr(cls, "Maraba Oncolytic Virus Expressing Mutant HPV E6/E7",
                PermissibleValue(text="Maraba Oncolytic Virus Expressing Mutant HPV E6/E7") )
        setattr(cls, "Silicon Phthalocyanine 4",
                PermissibleValue(text="Silicon Phthalocyanine 4") )
        setattr(cls, "pan-PI3K/mTOR Inhibitor SF1126",
                PermissibleValue(text="pan-PI3K/mTOR Inhibitor SF1126") )
        setattr(cls, "Cortisone Acetate",
                PermissibleValue(text="Cortisone Acetate") )
        setattr(cls, "Src Kinase Inhibitor M475271",
                PermissibleValue(text="Src Kinase Inhibitor M475271") )
        setattr(cls, "TLR8 Agonist DN1508052",
                PermissibleValue(text="TLR8 Agonist DN1508052") )
        setattr(cls, "Gemcitabine Hydrochloride",
                PermissibleValue(text="Gemcitabine Hydrochloride") )
        setattr(cls, "Carbon C 14-pamiparib",
                PermissibleValue(text="Carbon C 14-pamiparib") )
        setattr(cls, "GSK-3 Inhibitor 9-ING-41",
                PermissibleValue(text="GSK-3 Inhibitor 9-ING-41") )
        setattr(cls, "Methylprednisolone Acetate",
                PermissibleValue(text="Methylprednisolone Acetate") )
        setattr(cls, "Anti-HER2-DM1 Antibody-drug Conjugate GQ1001",
                PermissibleValue(text="Anti-HER2-DM1 Antibody-drug Conjugate GQ1001") )
        setattr(cls, "Genetically Modified Interleukin-12 Transgene-encoding Bifidobacterium longum",
                PermissibleValue(text="Genetically Modified Interleukin-12 Transgene-encoding Bifidobacterium longum") )
        setattr(cls, "Brentuximab Vedotin",
                PermissibleValue(text="Brentuximab Vedotin") )
        setattr(cls, "EGFR Antisense DNA BB-401",
                PermissibleValue(text="EGFR Antisense DNA BB-401") )
        setattr(cls, "Synthetic hTERT DNA Vaccine INO-1400",
                PermissibleValue(text="Synthetic hTERT DNA Vaccine INO-1400") )
        setattr(cls, "Black Cohosh",
                PermissibleValue(text="Black Cohosh") )
        setattr(cls, "Aprutumab Ixadotin",
                PermissibleValue(text="Aprutumab Ixadotin") )
        setattr(cls, "Personalized Neoantigen DNA Vaccine GNOS-PVO2",
                PermissibleValue(text="Personalized Neoantigen DNA Vaccine GNOS-PVO2") )
        setattr(cls, "Anti-FLT3 Monoclonal Antibody IMC-EB10",
                PermissibleValue(text="Anti-FLT3 Monoclonal Antibody IMC-EB10") )
        setattr(cls, "Anti-CTLA-4 Monoclonal Antibody HBM4003",
                PermissibleValue(text="Anti-CTLA-4 Monoclonal Antibody HBM4003") )
        setattr(cls, "Diarylsulfonylurea Compound ILX-295501",
                PermissibleValue(text="Diarylsulfonylurea Compound ILX-295501") )
        setattr(cls, "Cordycepin Triphosphate",
                PermissibleValue(text="Cordycepin Triphosphate") )
        setattr(cls, "Selective Human Estrogen-receptor Alpha Partial Agonist TTC-352",
                PermissibleValue(text="Selective Human Estrogen-receptor Alpha Partial Agonist TTC-352") )
        setattr(cls, "Anti-OX40 Monoclonal Antibody IBI101",
                PermissibleValue(text="Anti-OX40 Monoclonal Antibody IBI101") )
        setattr(cls, "Tavokinogene Telseplasmid",
                PermissibleValue(text="Tavokinogene Telseplasmid") )
        setattr(cls, "Asparaginase Erwinia chrysanthemi",
                PermissibleValue(text="Asparaginase Erwinia chrysanthemi") )
        setattr(cls, "HPV E6/E7-encoding Arenavirus Vaccine HB-201",
                PermissibleValue(text="HPV E6/E7-encoding Arenavirus Vaccine HB-201") )
        setattr(cls, "Beta-Thioguanine Deoxyriboside",
                PermissibleValue(text="Beta-Thioguanine Deoxyriboside") )
        setattr(cls, "AXL Inhibitor DS-1205c",
                PermissibleValue(text="AXL Inhibitor DS-1205c") )
        setattr(cls, "Hsp90 Inhibitor BIIB028",
                PermissibleValue(text="Hsp90 Inhibitor BIIB028") )
        setattr(cls, "Iodine I 131 Tositumomab",
                PermissibleValue(text="Iodine I 131 Tositumomab") )
        setattr(cls, "Aziridinylbenzoquinone RH1",
                PermissibleValue(text="Aziridinylbenzoquinone RH1") )
        setattr(cls, "Lutetium Lu 177 Lilotomab-satetraxetan",
                PermissibleValue(text="Lutetium Lu 177 Lilotomab-satetraxetan") )
        setattr(cls, "Trimetrexate Glucuronate",
                PermissibleValue(text="Trimetrexate Glucuronate") )
        setattr(cls, "Antimetabolite FF-10502",
                PermissibleValue(text="Antimetabolite FF-10502") )
        setattr(cls, "Monoclonal Antibody HuAFP31",
                PermissibleValue(text="Monoclonal Antibody HuAFP31") )
        setattr(cls, "Dual IGF-1R/InsR Inhibitor BMS-754807",
                PermissibleValue(text="Dual IGF-1R/InsR Inhibitor BMS-754807") )
        setattr(cls, "Synthetic Alkaloid PM00104",
                PermissibleValue(text="Synthetic Alkaloid PM00104") )
        setattr(cls, "Anti-TIM-3 Monoclonal Antibody MBG453",
                PermissibleValue(text="Anti-TIM-3 Monoclonal Antibody MBG453") )
        setattr(cls, "7-Cyanoquinocarcinol",
                PermissibleValue(text="7-Cyanoquinocarcinol") )
        setattr(cls, "Autologous CD19 CAR-expressing CD4+/CD8+ T-cells MB-CART19.1",
                PermissibleValue(text="Autologous CD19 CAR-expressing CD4+/CD8+ T-cells MB-CART19.1") )
        setattr(cls, "BTK Inhibitor LOXO-305",
                PermissibleValue(text="BTK Inhibitor LOXO-305") )
        setattr(cls, "Annamycin Liposomal",
                PermissibleValue(text="Annamycin Liposomal") )
        setattr(cls, "Seneca Valley Virus-001",
                PermissibleValue(text="Seneca Valley Virus-001") )
        setattr(cls, "Anti-CD20-engineered Toxin Body MT-3724",
                PermissibleValue(text="Anti-CD20-engineered Toxin Body MT-3724") )
        setattr(cls, "GBM Antigens and Alloantigens Immunotherapeutic Vaccine",
                PermissibleValue(text="GBM Antigens and Alloantigens Immunotherapeutic Vaccine") )
        setattr(cls, "Nanoparticle-based Paclitaxel Suspension",
                PermissibleValue(text="Nanoparticle-based Paclitaxel Suspension") )
        setattr(cls, "Yttrium Y 90-DOTA-Biotin",
                PermissibleValue(text="Yttrium Y 90-DOTA-Biotin") )
        setattr(cls, "Adenoviral Transduced hIL-12-expressing Autologous Dendritic Cells INXN-3001 Plus Activator Ligand INXN-1001",
                PermissibleValue(text="Adenoviral Transduced hIL-12-expressing Autologous Dendritic Cells INXN-3001 Plus Activator Ligand INXN-1001") )
        setattr(cls, "Metformin Hydrochloride",
                PermissibleValue(text="Metformin Hydrochloride") )
        setattr(cls, "Anti-CD27 Agonistic Monoclonal Antibody MK-5890",
                PermissibleValue(text="Anti-CD27 Agonistic Monoclonal Antibody MK-5890") )
        setattr(cls, "Spherical Nucleic Acid Nanoparticle NU-0129",
                PermissibleValue(text="Spherical Nucleic Acid Nanoparticle NU-0129") )
        setattr(cls, "SN-38-Loaded Polymeric Micelles NK012",
                PermissibleValue(text="SN-38-Loaded Polymeric Micelles NK012") )
        setattr(cls, "IMT-1012 Immunotherapeutic Vaccine",
                PermissibleValue(text="IMT-1012 Immunotherapeutic Vaccine") )
        setattr(cls, "TP40 Immunotoxin",
                PermissibleValue(text="TP40 Immunotoxin") )
        setattr(cls, "TGF-beta Receptor 1 Kinase Inhibitor SH3051",
                PermissibleValue(text="TGF-beta Receptor 1 Kinase Inhibitor SH3051") )
        setattr(cls, "Anti-PD-L1 Monoclonal Antibody A167",
                PermissibleValue(text="Anti-PD-L1 Monoclonal Antibody A167") )
        setattr(cls, "Radgocitabine Hydrochloride",
                PermissibleValue(text="Radgocitabine Hydrochloride") )
        setattr(cls, "Anti-HER2 Monoclonal Antibody B002",
                PermissibleValue(text="Anti-HER2 Monoclonal Antibody B002") )
        setattr(cls, "Ofranergene Obadenovec",
                PermissibleValue(text="Ofranergene Obadenovec") )
        setattr(cls, "Liposomal Docetaxel",
                PermissibleValue(text="Liposomal Docetaxel") )
        setattr(cls, "Anti-CSF1R Monoclonal Antibody IMC-CS4",
                PermissibleValue(text="Anti-CSF1R Monoclonal Antibody IMC-CS4") )
        setattr(cls, "LV.IL-2/B7.1-Transduced AML Blast Vaccine RFUSIN2-AML1",
                PermissibleValue(text="LV.IL-2/B7.1-Transduced AML Blast Vaccine RFUSIN2-AML1") )
        setattr(cls, "Docetaxel-PNP",
                PermissibleValue(text="Docetaxel-PNP") )
        setattr(cls, "MET Tyrosine Kinase Inhibitor SAR125844",
                PermissibleValue(text="MET Tyrosine Kinase Inhibitor SAR125844") )
        setattr(cls, "LMP7 Inhibitor M3258",
                PermissibleValue(text="LMP7 Inhibitor M3258") )
        setattr(cls, "Vincristine Sulfate",
                PermissibleValue(text="Vincristine Sulfate") )
        setattr(cls, "Yttrium Y 90-Edotreotide",
                PermissibleValue(text="Yttrium Y 90-Edotreotide") )
        setattr(cls, "CK2-targeting Synthetic Peptide CIGB-300",
                PermissibleValue(text="CK2-targeting Synthetic Peptide CIGB-300") )
        setattr(cls, "Anti-PD-1/CTLA-4 Bispecific Antibody AK104",
                PermissibleValue(text="Anti-PD-1/CTLA-4 Bispecific Antibody AK104") )
        setattr(cls, "ALK Inhibitor RO5424802",
                PermissibleValue(text="ALK Inhibitor RO5424802") )
        setattr(cls, "MDM2 Inhibitor AMGMDS3",
                PermissibleValue(text="MDM2 Inhibitor AMGMDS3") )
        setattr(cls, "Autologous Peripheral Blood Lymphocytes from Ibrutinib-treated Chronic Lymphocytic Leukemia Patients IOV-2001",
                PermissibleValue(text="Autologous Peripheral Blood Lymphocytes from Ibrutinib-treated Chronic Lymphocytic Leukemia Patients IOV-2001") )
        setattr(cls, "PRIMA-1 Analog APR-246",
                PermissibleValue(text="PRIMA-1 Analog APR-246") )
        setattr(cls, "BTK Inhibitor DTRMWXHS-12",
                PermissibleValue(text="BTK Inhibitor DTRMWXHS-12") )
        setattr(cls, "GS/pan-Notch Inhibitor AL101",
                PermissibleValue(text="GS/pan-Notch Inhibitor AL101") )
        setattr(cls, "Monoclonal Antibody 105AD7 Anti-idiotype Vaccine",
                PermissibleValue(text="Monoclonal Antibody 105AD7 Anti-idiotype Vaccine") )
        setattr(cls, "Anti-c-Met Monoclonal Antibody HLX55",
                PermissibleValue(text="Anti-c-Met Monoclonal Antibody HLX55") )
        setattr(cls, "Combretastatin A1 Diphosphate",
                PermissibleValue(text="Combretastatin A1 Diphosphate") )
        setattr(cls, "Anti-CD70 CAR-expressing T Lymphocytes",
                PermissibleValue(text="Anti-CD70 CAR-expressing T Lymphocytes") )
        setattr(cls, "NTRK/ROS1 Inhibitor DS-6051b",
                PermissibleValue(text="NTRK/ROS1 Inhibitor DS-6051b") )
        setattr(cls, "Nemorubicin Hydrochloride",
                PermissibleValue(text="Nemorubicin Hydrochloride") )
        setattr(cls, "Mesothelin/CD3e Tri-specific T-cell Activating Construct HPN536",
                PermissibleValue(text="Mesothelin/CD3e Tri-specific T-cell Activating Construct HPN536") )
        setattr(cls, "Muscadine Grape Extract",
                PermissibleValue(text="Muscadine Grape Extract") )
        setattr(cls, "Acolbifene Hydrochloride",
                PermissibleValue(text="Acolbifene Hydrochloride") )
        setattr(cls, "Multi-glioblastoma-peptide-targeting Autologous Dendritic Cell Vaccine ICT-107",
                PermissibleValue(text="Multi-glioblastoma-peptide-targeting Autologous Dendritic Cell Vaccine ICT-107") )
        setattr(cls, "Synthetic Hypericin",
                PermissibleValue(text="Synthetic Hypericin") )
        setattr(cls, "Toll-like Receptor 7 Agonist DSP-0509",
                PermissibleValue(text="Toll-like Receptor 7 Agonist DSP-0509") )
        setattr(cls, "pan-PIM Kinase Inhibitor NVP-LGB-321",
                PermissibleValue(text="pan-PIM Kinase Inhibitor NVP-LGB-321") )
        setattr(cls, "Dihydro-5-Azacytidine",
                PermissibleValue(text="Dihydro-5-Azacytidine") )
        setattr(cls, "Atorvastatin Calcium",
                PermissibleValue(text="Atorvastatin Calcium") )
        setattr(cls, "Immunomodulator OHR/AVR118",
                PermissibleValue(text="Immunomodulator OHR/AVR118") )
        setattr(cls, "Anti-HIF-1alpha LNA Antisense Oligonucleotide EZN-2968",
                PermissibleValue(text="Anti-HIF-1alpha LNA Antisense Oligonucleotide EZN-2968") )
        setattr(cls, "Mirzotamab Clezutoclax",
                PermissibleValue(text="Mirzotamab Clezutoclax") )
        setattr(cls, "PI3K Inhibitor BGT226",
                PermissibleValue(text="PI3K Inhibitor BGT226") )
        setattr(cls, "Irinotecan Hydrochloride",
                PermissibleValue(text="Irinotecan Hydrochloride") )
        setattr(cls, "Tucotuzumab Celmoleukin",
                PermissibleValue(text="Tucotuzumab Celmoleukin") )
        setattr(cls, "MARCKS Protein Inhibitor BIO-11006",
                PermissibleValue(text="MARCKS Protein Inhibitor BIO-11006") )
        setattr(cls, "Perflenapent Emulsion",
                PermissibleValue(text="Perflenapent Emulsion") )
        setattr(cls, "Anti-prolactin Receptor Antibody LFA102",
                PermissibleValue(text="Anti-prolactin Receptor Antibody LFA102") )
        setattr(cls, "9-Ethyl 6-Mercaptopurine",
                PermissibleValue(text="9-Ethyl 6-Mercaptopurine") )
        setattr(cls, "CDK Inhibitor R547",
                PermissibleValue(text="CDK Inhibitor R547") )
        setattr(cls, "Cathelicidin LL-37",
                PermissibleValue(text="Cathelicidin LL-37") )
        setattr(cls, "VEGF Inhibitor PTC299",
                PermissibleValue(text="VEGF Inhibitor PTC299") )
        setattr(cls, "Polo-like Kinase 1 Inhibitor NMS-1286937",
                PermissibleValue(text="Polo-like Kinase 1 Inhibitor NMS-1286937") )
        setattr(cls, "BCMA-CD19 Compound CAR T Cells",
                PermissibleValue(text="BCMA-CD19 Compound CAR T Cells") )
        setattr(cls, "Anti-PD-1 Monoclonal Antibody JTX-4014",
                PermissibleValue(text="Anti-PD-1 Monoclonal Antibody JTX-4014") )
        setattr(cls, "Leucovorin Calcium",
                PermissibleValue(text="Leucovorin Calcium") )
        setattr(cls, "Anti-BCMA Antibody-drug Conjugate AMG 224",
                PermissibleValue(text="Anti-BCMA Antibody-drug Conjugate AMG 224") )
        setattr(cls, "Forodesine Hydrochloride",
                PermissibleValue(text="Forodesine Hydrochloride") )
        setattr(cls, "Bispecific Antibody AGEN1223",
                PermissibleValue(text="Bispecific Antibody AGEN1223") )
        setattr(cls, "Anti-PD-1 Monoclonal Antibody Sym021",
                PermissibleValue(text="Anti-PD-1 Monoclonal Antibody Sym021") )
        setattr(cls, "Anti-VEGFR3 Monoclonal Antibody IMC-3C5",
                PermissibleValue(text="Anti-VEGFR3 Monoclonal Antibody IMC-3C5") )
        setattr(cls, "Arginine Butyrate",
                PermissibleValue(text="Arginine Butyrate") )
        setattr(cls, "pNGVL4a-CRT-E6E7L2 DNA Vaccine",
                PermissibleValue(text="pNGVL4a-CRT-E6E7L2 DNA Vaccine") )
        setattr(cls, "Anti-BCMA Antibody SEA-BCMA",
                PermissibleValue(text="Anti-BCMA Antibody SEA-BCMA") )
        setattr(cls, "SLC6A8 Inhibitor RGX-202",
                PermissibleValue(text="SLC6A8 Inhibitor RGX-202") )
        setattr(cls, "Anti-Met Monoclonal Antibody Mixture Sym015",
                PermissibleValue(text="Anti-Met Monoclonal Antibody Mixture Sym015") )
        setattr(cls, "Paclitaxel PPE Microspheres",
                PermissibleValue(text="Paclitaxel PPE Microspheres") )
        setattr(cls, "Elesclomol Sodium",
                PermissibleValue(text="Elesclomol Sodium") )
        setattr(cls, "Cereblon Modulator CC-90009",
                PermissibleValue(text="Cereblon Modulator CC-90009") )
        setattr(cls, "EGFR Inhibitor DBPR112",
                PermissibleValue(text="EGFR Inhibitor DBPR112") )
        setattr(cls, "Anti-CD47 Monoclonal Antibody SRF231",
                PermissibleValue(text="Anti-CD47 Monoclonal Antibody SRF231") )
        setattr(cls, "Iodine I 131 Rituximab",
                PermissibleValue(text="Iodine I 131 Rituximab") )
        setattr(cls, "Lometrexol Sodium",
                PermissibleValue(text="Lometrexol Sodium") )
        setattr(cls, "Teloxantrone Hydrochloride",
                PermissibleValue(text="Teloxantrone Hydrochloride") )
        setattr(cls, "Human Papillomavirus 16 E7 Peptide/Padre 965.10",
                PermissibleValue(text="Human Papillomavirus 16 E7 Peptide/Padre 965.10") )
        setattr(cls, "NY-ESO-B",
                PermissibleValue(text="NY-ESO-B") )
        setattr(cls, "Tagraxofusp-erzs",
                PermissibleValue(text="Tagraxofusp-erzs") )
        setattr(cls, "Immunomodulatory Oligonucleotide HYB2055",
                PermissibleValue(text="Immunomodulatory Oligonucleotide HYB2055") )
        setattr(cls, "Live-attenuated Listeria monocytogenes-encoding EGFRvIII-NY-ESO-1 Vaccine ADU-623",
                PermissibleValue(text="Live-attenuated Listeria monocytogenes-encoding EGFRvIII-NY-ESO-1 Vaccine ADU-623") )
        setattr(cls, "Taxane Compound",
                PermissibleValue(text="Taxane Compound") )
        setattr(cls, "Squalamine Lactate",
                PermissibleValue(text="Squalamine Lactate") )
        setattr(cls, "Cytarabine-asparagine Prodrug BST-236",
                PermissibleValue(text="Cytarabine-asparagine Prodrug BST-236") )
        setattr(cls, "Tubulin Binding Agent TTI-237",
                PermissibleValue(text="Tubulin Binding Agent TTI-237") )
        setattr(cls, "Anti-CD157 Monoclonal Antibody MEN1112",
                PermissibleValue(text="Anti-CD157 Monoclonal Antibody MEN1112") )
        setattr(cls, "Anti-CD33/CD3 Bispecific Antibody GEM 333",
                PermissibleValue(text="Anti-CD33/CD3 Bispecific Antibody GEM 333") )
        setattr(cls, "CEA-targeting Agent RG6123",
                PermissibleValue(text="CEA-targeting Agent RG6123") )
        setattr(cls, "MOv-gamma Chimeric Receptor Gene",
                PermissibleValue(text="MOv-gamma Chimeric Receptor Gene") )
        setattr(cls, "Realgar-Indigo naturalis Formulation",
                PermissibleValue(text="Realgar-Indigo naturalis Formulation") )
        setattr(cls, "Fosbretabulin Disodium",
                PermissibleValue(text="Fosbretabulin Disodium") )
        setattr(cls, "Sodium-Potassium Adenosine Triphosphatase Inhibitor RX108",
                PermissibleValue(text="Sodium-Potassium Adenosine Triphosphatase Inhibitor RX108") )
        setattr(cls, "Tamrintamab Pamozirine",
                PermissibleValue(text="Tamrintamab Pamozirine") )
        setattr(cls, "Vadacabtagene Leraleucel",
                PermissibleValue(text="Vadacabtagene Leraleucel") )
        setattr(cls, "Anti-CD47 Monoclonal Antibody IMC-002",
                PermissibleValue(text="Anti-CD47 Monoclonal Antibody IMC-002") )
        setattr(cls, "Efatutazone Dihydrochloride",
                PermissibleValue(text="Efatutazone Dihydrochloride") )
        setattr(cls, "Anti-CD33 Antigen/CD3 Receptor Bispecific Monoclonal Antibody AMV564",
                PermissibleValue(text="Anti-CD33 Antigen/CD3 Receptor Bispecific Monoclonal Antibody AMV564") )
        setattr(cls, "MET Kinase Inhibitor OMO-1",
                PermissibleValue(text="MET Kinase Inhibitor OMO-1") )
        setattr(cls, "Monoclonal Antibody CC49-delta CH2",
                PermissibleValue(text="Monoclonal Antibody CC49-delta CH2") )
        setattr(cls, "Anti-PSMA/PBD ADC MEDI3726",
                PermissibleValue(text="Anti-PSMA/PBD ADC MEDI3726") )
        setattr(cls, "N-dihydrogalactochitosan",
                PermissibleValue(text="N-dihydrogalactochitosan") )
        setattr(cls, "FPV Vaccine CV301",
                PermissibleValue(text="FPV Vaccine CV301") )
        setattr(cls, "Sialyl Tn-KLH Vaccine",
                PermissibleValue(text="Sialyl Tn-KLH Vaccine") )
        setattr(cls, "Anti-TGF-beta Monoclonal Antibody SAR-439459",
                PermissibleValue(text="Anti-TGF-beta Monoclonal Antibody SAR-439459") )
        setattr(cls, "Sipuleucel-T",
                PermissibleValue(text="Sipuleucel-T") )
        setattr(cls, "LSD1 Inhibitor RO7051790",
                PermissibleValue(text="LSD1 Inhibitor RO7051790") )
        setattr(cls, "Anti-CD47 Monoclonal Antibody IBI188",
                PermissibleValue(text="Anti-CD47 Monoclonal Antibody IBI188") )
        setattr(cls, "PSA/PSMA DNA Plasmid INO-5150",
                PermissibleValue(text="PSA/PSMA DNA Plasmid INO-5150") )
        setattr(cls, "hTERT Vaccine V934/V935",
                PermissibleValue(text="hTERT Vaccine V934/V935") )
        setattr(cls, "Oxaliplatin Eluting Beads",
                PermissibleValue(text="Oxaliplatin Eluting Beads") )
        setattr(cls, "Anti-ICOS Agonist Antibody GSK3359609",
                PermissibleValue(text="Anti-ICOS Agonist Antibody GSK3359609") )
        setattr(cls, "Allogeneic CD8+ Leukemia-associated Antigens Specific T Cells NEXI-001",
                PermissibleValue(text="Allogeneic CD8+ Leukemia-associated Antigens Specific T Cells NEXI-001") )
        setattr(cls, "CD80-Fc Fusion Protein ALPN-202",
                PermissibleValue(text="CD80-Fc Fusion Protein ALPN-202") )
        setattr(cls, "Monoclonal Antibody GD2 Anti-Idiotype Vaccine",
                PermissibleValue(text="Monoclonal Antibody GD2 Anti-Idiotype Vaccine") )
        setattr(cls, "dUTPase/DPD Inhibitor TAS-114",
                PermissibleValue(text="dUTPase/DPD Inhibitor TAS-114") )
        setattr(cls, "Interferon Alfacon-1",
                PermissibleValue(text="Interferon Alfacon-1") )
        setattr(cls, "Antiangiogenic Drug Combination TL-118",
                PermissibleValue(text="Antiangiogenic Drug Combination TL-118") )
        setattr(cls, "Cationic Liposome-Encapsulated Paclitaxel",
                PermissibleValue(text="Cationic Liposome-Encapsulated Paclitaxel") )
        setattr(cls, "Actinomycin C3",
                PermissibleValue(text="Actinomycin C3") )
        setattr(cls, "Methionine Aminopeptidase 2 Inhibitor PPI-2458",
                PermissibleValue(text="Methionine Aminopeptidase 2 Inhibitor PPI-2458") )
        setattr(cls, "Anti-PD-1 Monoclonal Antibody BCD-100",
                PermissibleValue(text="Anti-PD-1 Monoclonal Antibody BCD-100") )
        setattr(cls, "ICT-121 Dendritic Cell Vaccine",
                PermissibleValue(text="ICT-121 Dendritic Cell Vaccine") )
        setattr(cls, "Obatoclax Mesylate",
                PermissibleValue(text="Obatoclax Mesylate") )
        setattr(cls, "PGG Beta-Glucan",
                PermissibleValue(text="PGG Beta-Glucan") )
        setattr(cls, "Ibandronate Sodium",
                PermissibleValue(text="Ibandronate Sodium") )
        setattr(cls, "PI3K Inhibitor ZSTK474",
                PermissibleValue(text="PI3K Inhibitor ZSTK474") )
        setattr(cls, "Prohibitin-Targeting Peptide 1",
                PermissibleValue(text="Prohibitin-Targeting Peptide 1") )
        setattr(cls, "Pan-TRK Inhibitor ONO-7579",
                PermissibleValue(text="Pan-TRK Inhibitor ONO-7579") )
        setattr(cls, "Nimesulide-Hyaluronic Acid Conjugate CA102N",
                PermissibleValue(text="Nimesulide-Hyaluronic Acid Conjugate CA102N") )
        setattr(cls, "Anti-HIV-1 Lentiviral Vector-expressing sh5/C46 Cal-1",
                PermissibleValue(text="Anti-HIV-1 Lentiviral Vector-expressing sh5/C46 Cal-1") )
        setattr(cls, "Anti-CD3/Anti-GPRC5D Bispecific Monoclonal Antibody JNJ-64407564",
                PermissibleValue(text="Anti-CD3/Anti-GPRC5D Bispecific Monoclonal Antibody JNJ-64407564") )
        setattr(cls, "Recombinant Interleukin-12",
                PermissibleValue(text="Recombinant Interleukin-12") )
        setattr(cls, "Jin Fu Kang",
                PermissibleValue(text="Jin Fu Kang") )
        setattr(cls, "Cord Blood-derived Expanded Natural Killer Cells PNK-007",
                PermissibleValue(text="Cord Blood-derived Expanded Natural Killer Cells PNK-007") )
        setattr(cls, "Fluvastatin Sodium",
                PermissibleValue(text="Fluvastatin Sodium") )
        setattr(cls, "Anti-CD123 Monoclonal Antibody CSL360",
                PermissibleValue(text="Anti-CD123 Monoclonal Antibody CSL360") )
        setattr(cls, "Recombinant Fas Ligand",
                PermissibleValue(text="Recombinant Fas Ligand") )
        setattr(cls, "Therapeutic Breast/Ovarian/Prostate Peptide Cancer Vaccine DPX-0907",
                PermissibleValue(text="Therapeutic Breast/Ovarian/Prostate Peptide Cancer Vaccine DPX-0907") )
        setattr(cls, "Axicabtagene Ciloleucel",
                PermissibleValue(text="Axicabtagene Ciloleucel") )
        setattr(cls, "Recombinant Tyrosinase-Related Protein-2",
                PermissibleValue(text="Recombinant Tyrosinase-Related Protein-2") )
        setattr(cls, "Artemisinin Dimer",
                PermissibleValue(text="Artemisinin Dimer") )
        setattr(cls, "DPT/Typhoid/Staphylococcus aureus/Paratyphoid A/Paratyphoid B Vaccine",
                PermissibleValue(text="DPT/Typhoid/Staphylococcus aureus/Paratyphoid A/Paratyphoid B Vaccine") )
        setattr(cls, "Mutant-selective EGFR Inhibitor PF-06459988",
                PermissibleValue(text="Mutant-selective EGFR Inhibitor PF-06459988") )
        setattr(cls, "Milademetan Tosylate",
                PermissibleValue(text="Milademetan Tosylate") )
        setattr(cls, "Light-activated AU-011",
                PermissibleValue(text="Light-activated AU-011") )
        setattr(cls, "iPSC-derived CD16-expressing Natural Killer Cells FT516",
                PermissibleValue(text="iPSC-derived CD16-expressing Natural Killer Cells FT516") )
        setattr(cls, "Selective Cytokine Inhibitory Drug CC-1088",
                PermissibleValue(text="Selective Cytokine Inhibitory Drug CC-1088") )
        setattr(cls, "Clodronic Acid",
                PermissibleValue(text="Clodronic Acid") )
        setattr(cls, "Lutetium Lu 177 DOTA-biotin",
                PermissibleValue(text="Lutetium Lu 177 DOTA-biotin") )
        setattr(cls, "Batabulin Sodium",
                PermissibleValue(text="Batabulin Sodium") )
        setattr(cls, "Compound Kushen Injection",
                PermissibleValue(text="Compound Kushen Injection") )
        setattr(cls, "Autologous FRa-4SCAR-expressing T-cells 4SCAR-FRa",
                PermissibleValue(text="Autologous FRa-4SCAR-expressing T-cells 4SCAR-FRa") )
        setattr(cls, "Talimogene Laherparepvec",
                PermissibleValue(text="Talimogene Laherparepvec") )
        setattr(cls, "Topotecan Sustained-release Episcleral Plaque",
                PermissibleValue(text="Topotecan Sustained-release Episcleral Plaque") )
        setattr(cls, "mRNA-based Personalized Cancer Vaccine mRNA-4157",
                PermissibleValue(text="mRNA-based Personalized Cancer Vaccine mRNA-4157") )
        setattr(cls, "CD123-CD33 Compound CAR T Cells",
                PermissibleValue(text="CD123-CD33 Compound CAR T Cells") )
        setattr(cls, "mTOR Inhibitor GDC-0349",
                PermissibleValue(text="mTOR Inhibitor GDC-0349") )
        setattr(cls, "Polyethylene Glycol Recombinant Endostatin",
                PermissibleValue(text="Polyethylene Glycol Recombinant Endostatin") )
        setattr(cls, "Idiotype-Pulsed Autologous Dendritic Cell Vaccine APC8020",
                PermissibleValue(text="Idiotype-Pulsed Autologous Dendritic Cell Vaccine APC8020") )
        setattr(cls, "Camptothecin Analogue TLC388",
                PermissibleValue(text="Camptothecin Analogue TLC388") )
        setattr(cls, "Picrasinoside H",
                PermissibleValue(text="Picrasinoside H") )
        setattr(cls, "Beta-lapachone Prodrug ARQ 761",
                PermissibleValue(text="Beta-lapachone Prodrug ARQ 761") )
        setattr(cls, "TRPV6 Calcium Channel Inhibitor SOR-C13",
                PermissibleValue(text="TRPV6 Calcium Channel Inhibitor SOR-C13") )
        setattr(cls, "Anti-CD38 Monoclonal Antibody SAR442085",
                PermissibleValue(text="Anti-CD38 Monoclonal Antibody SAR442085") )
        setattr(cls, "VEGFR2 Tyrosine Kinase Inhibitor PF-00337210",
                PermissibleValue(text="VEGFR2 Tyrosine Kinase Inhibitor PF-00337210") )
        setattr(cls, "13-Deoxydoxorubicin",
                PermissibleValue(text="13-Deoxydoxorubicin") )
        setattr(cls, "PLK1 Inhibitor TAK-960",
                PermissibleValue(text="PLK1 Inhibitor TAK-960") )
        setattr(cls, "Autologous Bone Marrow-derived CD34/CXCR4-positive Stem Cells AMR-001",
                PermissibleValue(text="Autologous Bone Marrow-derived CD34/CXCR4-positive Stem Cells AMR-001") )
        setattr(cls, "Bcl-2 Inhibitor BCL201",
                PermissibleValue(text="Bcl-2 Inhibitor BCL201") )
        setattr(cls, "Oral Azacitidine",
                PermissibleValue(text="Oral Azacitidine") )
        setattr(cls, "Yttrium Y 90 Anti-CEA Monoclonal Antibody cT84.66",
                PermissibleValue(text="Yttrium Y 90 Anti-CEA Monoclonal Antibody cT84.66") )
        setattr(cls, "RSK1-4 Inhibitor PMD-026",
                PermissibleValue(text="RSK1-4 Inhibitor PMD-026") )
        setattr(cls, "Anti-BCMA/PBD ADC MEDI2228",
                PermissibleValue(text="Anti-BCMA/PBD ADC MEDI2228") )
        setattr(cls, "Anti-FGFR4 Monoclonal Antibody U3-1784",
                PermissibleValue(text="Anti-FGFR4 Monoclonal Antibody U3-1784") )
        setattr(cls, "Monoclonal Antibody RAV12",
                PermissibleValue(text="Monoclonal Antibody RAV12") )
        setattr(cls, "BTK Inhibitor CT-1530",
                PermissibleValue(text="BTK Inhibitor CT-1530") )
        setattr(cls, "Anti-fucosyl-GM1 Monoclonal Antibody BMS-986012",
                PermissibleValue(text="Anti-fucosyl-GM1 Monoclonal Antibody BMS-986012") )
        setattr(cls, "Oxidative Phosphorylation Inhibitor IACS-010759",
                PermissibleValue(text="Oxidative Phosphorylation Inhibitor IACS-010759") )
        setattr(cls, "ERK Inhibitor MK-8353",
                PermissibleValue(text="ERK Inhibitor MK-8353") )
        setattr(cls, "IGF-methotrexate Conjugate",
                PermissibleValue(text="IGF-methotrexate Conjugate") )
        setattr(cls, "NEDD8 Activating Enzyme E1 Inhibitor TAS4464",
                PermissibleValue(text="NEDD8 Activating Enzyme E1 Inhibitor TAS4464") )
        setattr(cls, "Naptumomab Estafenatox",
                PermissibleValue(text="Naptumomab Estafenatox") )
        setattr(cls, "hTERT-encoding DNA Vaccine INVAC-1",
                PermissibleValue(text="hTERT-encoding DNA Vaccine INVAC-1") )
        setattr(cls, "Monoclonal Antibody R24",
                PermissibleValue(text="Monoclonal Antibody R24") )
        setattr(cls, "PRMT5 Inhibitor PRT811",
                PermissibleValue(text="PRMT5 Inhibitor PRT811") )
        setattr(cls, "Anti-CEA BiTE Monoclonal Antibody AMG211",
                PermissibleValue(text="Anti-CEA BiTE Monoclonal Antibody AMG211") )
        setattr(cls, "Liposomal Mitoxantrone Hydrochloride",
                PermissibleValue(text="Liposomal Mitoxantrone Hydrochloride") )
        setattr(cls, "RhoC Peptide Vaccine RV001V",
                PermissibleValue(text="RhoC Peptide Vaccine RV001V") )
        setattr(cls, "CD44v6-specific CAR T-cells",
                PermissibleValue(text="CD44v6-specific CAR T-cells") )
        setattr(cls, "Geranylgeranyltransferase I Inhibitor",
                PermissibleValue(text="Geranylgeranyltransferase I Inhibitor") )
        setattr(cls, "SERD SAR439859",
                PermissibleValue(text="SERD SAR439859") )
        setattr(cls, "Allogeneic Anti-CD19-CAR T-cells PBCAR0191",
                PermissibleValue(text="Allogeneic Anti-CD19-CAR T-cells PBCAR0191") )
        setattr(cls, "Pan-FLT3/Pan-BTK Multi-kinase Inhibitor CG-806",
                PermissibleValue(text="Pan-FLT3/Pan-BTK Multi-kinase Inhibitor CG-806") )
        setattr(cls, "Pegylated SN-38 Conjugate PLX038",
                PermissibleValue(text="Pegylated SN-38 Conjugate PLX038") )
        setattr(cls, "Autologous AFP Specific T Cell Receptor Transduced T Cells C-TCR055",
                PermissibleValue(text="Autologous AFP Specific T Cell Receptor Transduced T Cells C-TCR055") )
        setattr(cls, "Zotiraciclib Citrate",
                PermissibleValue(text="Zotiraciclib Citrate") )
        setattr(cls, "Pegylated Recombinant L-asparaginase Erwinia chrysanthemi",
                PermissibleValue(text="Pegylated Recombinant L-asparaginase Erwinia chrysanthemi") )
        setattr(cls, "Ningetinib Tosylate",
                PermissibleValue(text="Ningetinib Tosylate") )
        setattr(cls, "Dociparstat sodium",
                PermissibleValue(text="Dociparstat sodium") )
        setattr(cls, "Methylprednisolone Sodium Succinate",
                PermissibleValue(text="Methylprednisolone Sodium Succinate") )
        setattr(cls, "Paclitaxel Liposome",
                PermissibleValue(text="Paclitaxel Liposome") )
        setattr(cls, "Varlitinib Tosylate",
                PermissibleValue(text="Varlitinib Tosylate") )
        setattr(cls, "HDAC Inhibitor AR-42",
                PermissibleValue(text="HDAC Inhibitor AR-42") )
        setattr(cls, "BH3 Mimetic ABT-737",
                PermissibleValue(text="BH3 Mimetic ABT-737") )
        setattr(cls, "Atrasentan Hydrochloride",
                PermissibleValue(text="Atrasentan Hydrochloride") )
        setattr(cls, "Phenethyl Isothiocyanate",
                PermissibleValue(text="Phenethyl Isothiocyanate") )
        setattr(cls, "Autologous Anti-CD19 TAC-T cells TAC01-CD19",
                PermissibleValue(text="Autologous Anti-CD19 TAC-T cells TAC01-CD19") )
        setattr(cls, "Anti-C-met Monoclonal Antibody SAIT301",
                PermissibleValue(text="Anti-C-met Monoclonal Antibody SAIT301") )
        setattr(cls, "Acai Berry Juice",
                PermissibleValue(text="Acai Berry Juice") )
        setattr(cls, "CpG Oligodeoxynucleotide GNKG168",
                PermissibleValue(text="CpG Oligodeoxynucleotide GNKG168") )
        setattr(cls, "Tyrosinase Peptide",
                PermissibleValue(text="Tyrosinase Peptide") )
        setattr(cls, "Trastuzumab-TLR 7/8 Agonist BDC-1001",
                PermissibleValue(text="Trastuzumab-TLR 7/8 Agonist BDC-1001") )
        setattr(cls, "Liposomal NDDP",
                PermissibleValue(text="Liposomal NDDP") )
        setattr(cls, "Recombinant Interferon Beta",
                PermissibleValue(text="Recombinant Interferon Beta") )
        setattr(cls, "CDK7 Inhibitor CT7001",
                PermissibleValue(text="CDK7 Inhibitor CT7001") )
        setattr(cls, "RAF Kinase Inhibitor L-779450",
                PermissibleValue(text="RAF Kinase Inhibitor L-779450") )
        setattr(cls, "Microbiome GEN-001",
                PermissibleValue(text="Microbiome GEN-001") )
        setattr(cls, "Triptorelin Pamoate",
                PermissibleValue(text="Triptorelin Pamoate") )
        setattr(cls, "L-Gossypol",
                PermissibleValue(text="L-Gossypol") )
        setattr(cls, "Sodium Dichloroacetate",
                PermissibleValue(text="Sodium Dichloroacetate") )
        setattr(cls, "Adenosine A2A Receptor Antagonist AZD4635",
                PermissibleValue(text="Adenosine A2A Receptor Antagonist AZD4635") )
        setattr(cls, "Syk Inhibitor HMPL-523",
                PermissibleValue(text="Syk Inhibitor HMPL-523") )
        setattr(cls, "Verpasep Caltespen",
                PermissibleValue(text="Verpasep Caltespen") )
        setattr(cls, "Autologous TCR-engineered T-cells IMA203",
                PermissibleValue(text="Autologous TCR-engineered T-cells IMA203") )
        setattr(cls, "Resiquimod Topical Gel",
                PermissibleValue(text="Resiquimod Topical Gel") )
        setattr(cls, "Membrane-Disrupting Peptide EP-100",
                PermissibleValue(text="Membrane-Disrupting Peptide EP-100") )
        setattr(cls, "Ciltacabtagene Autoleucel",
                PermissibleValue(text="Ciltacabtagene Autoleucel") )
        setattr(cls, "Tyrosine Kinase Inhibitor XL228",
                PermissibleValue(text="Tyrosine Kinase Inhibitor XL228") )
        setattr(cls, "Anti-BCMA/CD3 BiTE Antibody AMG 420",
                PermissibleValue(text="Anti-BCMA/CD3 BiTE Antibody AMG 420") )
        setattr(cls, "Yttrium Y-90 Ibritumomab Tiuxetan",
                PermissibleValue(text="Yttrium Y-90 Ibritumomab Tiuxetan") )
        setattr(cls, "Hsp90 Inhibitor TQB3474",
                PermissibleValue(text="Hsp90 Inhibitor TQB3474") )
        setattr(cls, "Hsp90 Inhibitor MPC-3100",
                PermissibleValue(text="Hsp90 Inhibitor MPC-3100") )
        setattr(cls, "Albumin-binding Cisplatin Prodrug BTP-114",
                PermissibleValue(text="Albumin-binding Cisplatin Prodrug BTP-114") )
        setattr(cls, "EBNA-1 inhibitor VK-2019",
                PermissibleValue(text="EBNA-1 inhibitor VK-2019") )
        setattr(cls, "Pictilisib Bismesylate",
                PermissibleValue(text="Pictilisib Bismesylate") )
        setattr(cls, "Porfimer Sodium",
                PermissibleValue(text="Porfimer Sodium") )
        setattr(cls, "Anti-CD137 Agonistic Monoclonal Antibody CTX-471",
                PermissibleValue(text="Anti-CD137 Agonistic Monoclonal Antibody CTX-471") )
        setattr(cls, "STING-activating Cyclic Dinucleotide Agonist MIW815",
                PermissibleValue(text="STING-activating Cyclic Dinucleotide Agonist MIW815") )
        setattr(cls, "Androgen Receptor Inhibitor EPI-7386",
                PermissibleValue(text="Androgen Receptor Inhibitor EPI-7386") )
        setattr(cls, "Perillyl Alcohol",
                PermissibleValue(text="Perillyl Alcohol") )
        setattr(cls, "Neratinib Maleate",
                PermissibleValue(text="Neratinib Maleate") )
        setattr(cls, "mTOR1/2 Kinase Inhibitor ME-344",
                PermissibleValue(text="mTOR1/2 Kinase Inhibitor ME-344") )
        setattr(cls, "CD20-CD19 Compound CAR T Cells",
                PermissibleValue(text="CD20-CD19 Compound CAR T Cells") )
        setattr(cls, "PARP 1/2 Inhibitor IMP4297",
                PermissibleValue(text="PARP 1/2 Inhibitor IMP4297") )
        setattr(cls, "Halichondrin B",
                PermissibleValue(text="Halichondrin B") )
        setattr(cls, "Amino Acid Injection",
                PermissibleValue(text="Amino Acid Injection") )
        setattr(cls, "Iodine I 131 Monoclonal Antibody 81C6",
                PermissibleValue(text="Iodine I 131 Monoclonal Antibody 81C6") )
        setattr(cls, "Gamboge Resin Extract TSB-9-W1",
                PermissibleValue(text="Gamboge Resin Extract TSB-9-W1") )
        setattr(cls, "Topical Trichloroacetic Acid",
                PermissibleValue(text="Topical Trichloroacetic Acid") )
        setattr(cls, "CDK7 Inhibitor SY-5609",
                PermissibleValue(text="CDK7 Inhibitor SY-5609") )
        setattr(cls, "SIRPa-Fc Fusion Protein TTI-621",
                PermissibleValue(text="SIRPa-Fc Fusion Protein TTI-621") )
        setattr(cls, "Hemiasterlin Analog E7974",
                PermissibleValue(text="Hemiasterlin Analog E7974") )
        setattr(cls, "Liothyronine Sodium",
                PermissibleValue(text="Liothyronine Sodium") )
        setattr(cls, "Ralaniten Acetate",
                PermissibleValue(text="Ralaniten Acetate") )
        setattr(cls, "Anti-IGF-1R Recombinant Monoclonal Antibody BIIB022",
                PermissibleValue(text="Anti-IGF-1R Recombinant Monoclonal Antibody BIIB022") )
        setattr(cls, "Anti-HER2 Bi-specific Monoclonal Antibody ZW25",
                PermissibleValue(text="Anti-HER2 Bi-specific Monoclonal Antibody ZW25") )
        setattr(cls, "Antibody-drug Conjugate ABBV-838",
                PermissibleValue(text="Antibody-drug Conjugate ABBV-838") )
        setattr(cls, "Limonene, (+/-)-",
                PermissibleValue(text="Limonene, (+/-)-") )
        setattr(cls, "Bcl-Xs Adenovirus Vaccine",
                PermissibleValue(text="Bcl-Xs Adenovirus Vaccine") )
        setattr(cls, "Hsp90 Inhibitor HSP990",
                PermissibleValue(text="Hsp90 Inhibitor HSP990") )
        setattr(cls, "Pharmacological Ascorbate",
                PermissibleValue(text="Pharmacological Ascorbate") )
        setattr(cls, "Zinostatin Stimalamer",
                PermissibleValue(text="Zinostatin Stimalamer") )
        setattr(cls, "Autologous Anti-BCMA-CAR-4-1BB-CD3zeta-expressing Memory T-lymphocytes bb21217",
                PermissibleValue(text="Autologous Anti-BCMA-CAR-4-1BB-CD3zeta-expressing Memory T-lymphocytes bb21217") )
        setattr(cls, "GM-CSF-encoding Oncolytic Adenovirus CGTG-102",
                PermissibleValue(text="GM-CSF-encoding Oncolytic Adenovirus CGTG-102") )
        setattr(cls, "Doxorubicin Hydrochloride",
                PermissibleValue(text="Doxorubicin Hydrochloride") )
        setattr(cls, "p53-HDM2 Interaction Inhibitor MI-773",
                PermissibleValue(text="p53-HDM2 Interaction Inhibitor MI-773") )
        setattr(cls, "Anti-PRAME T-cell Receptor/Anti-CD3 scFv Fusion Protein IMC-F106C",
                PermissibleValue(text="Anti-PRAME T-cell Receptor/Anti-CD3 scFv Fusion Protein IMC-F106C") )
        setattr(cls, "ARC Fusion Protein SL-279252",
                PermissibleValue(text="ARC Fusion Protein SL-279252") )
        setattr(cls, "Larotinib Mesylate",
                PermissibleValue(text="Larotinib Mesylate") )
        setattr(cls, "Anti-CD40 Agonist Monoclonal Antibody CDX-1140",
                PermissibleValue(text="Anti-CD40 Agonist Monoclonal Antibody CDX-1140") )
        setattr(cls, "MEK Inhibitor RO4987655",
                PermissibleValue(text="MEK Inhibitor RO4987655") )
        setattr(cls, "Anti-5T4 Antibody-Drug Conjugate PF-06263507",
                PermissibleValue(text="Anti-5T4 Antibody-Drug Conjugate PF-06263507") )
        setattr(cls, "Nucleotide Analog Prodrug NUC-3373",
                PermissibleValue(text="Nucleotide Analog Prodrug NUC-3373") )
        setattr(cls, "NY-ESO-1-specific TCR Gene-transduced T Lymphocytes TBI-1301",
                PermissibleValue(text="NY-ESO-1-specific TCR Gene-transduced T Lymphocytes TBI-1301") )
        setattr(cls, "Phellodendron amurense Bark Extract",
                PermissibleValue(text="Phellodendron amurense Bark Extract") )
        setattr(cls, "Anti-GPR20/DXd Antibody-drug Conjugate DS-6157a",
                PermissibleValue(text="Anti-GPR20/DXd Antibody-drug Conjugate DS-6157a") )
        setattr(cls, "Monoclonal Antibody ASP1948",
                PermissibleValue(text="Monoclonal Antibody ASP1948") )
        setattr(cls, "Anti-EGFR Monoclonal Antibody SYN004",
                PermissibleValue(text="Anti-EGFR Monoclonal Antibody SYN004") )
        setattr(cls, "Carmustine in Ethanol",
                PermissibleValue(text="Carmustine in Ethanol") )
        setattr(cls, "Androgen Receptor Antisense Oligonucleotide EZN-4176",
                PermissibleValue(text="Androgen Receptor Antisense Oligonucleotide EZN-4176") )
        setattr(cls, "Nitric Oxide-Releasing Acetylsalicylic Acid Derivative",
                PermissibleValue(text="Nitric Oxide-Releasing Acetylsalicylic Acid Derivative") )
        setattr(cls, "Actinomycin C2",
                PermissibleValue(text="Actinomycin C2") )
        setattr(cls, "PSMA-targeted Docetaxel Nanoparticles BIND-014",
                PermissibleValue(text="PSMA-targeted Docetaxel Nanoparticles BIND-014") )
        setattr(cls, "Warfarin Sodium",
                PermissibleValue(text="Warfarin Sodium") )
        setattr(cls, "XIAP Antisense Oligonucleotide AEG35156",
                PermissibleValue(text="XIAP Antisense Oligonucleotide AEG35156") )
        setattr(cls, "Medroxyprogesterone Acetate",
                PermissibleValue(text="Medroxyprogesterone Acetate") )
        setattr(cls, "BXQ-350 Nanovesicle Formulation",
                PermissibleValue(text="BXQ-350 Nanovesicle Formulation") )
        setattr(cls, "Limonene, (+)-",
                PermissibleValue(text="Limonene, (+)-") )
        setattr(cls, "Telatinib Mesylate",
                PermissibleValue(text="Telatinib Mesylate") )
        setattr(cls, "Lanreotide Acetate",
                PermissibleValue(text="Lanreotide Acetate") )
        setattr(cls, "Bispecific Antibody AMG 509",
                PermissibleValue(text="Bispecific Antibody AMG 509") )
        setattr(cls, "Wnt-5a Mimic Hexapeptide Foxy-5",
                PermissibleValue(text="Wnt-5a Mimic Hexapeptide Foxy-5") )
        setattr(cls, "Autologous Anti-CD19/CD20 Bispecific Nanobody-based CAR-T cells",
                PermissibleValue(text="Autologous Anti-CD19/CD20 Bispecific Nanobody-based CAR-T cells") )
        setattr(cls, "Individualized MVA-based Vaccine TG4050",
                PermissibleValue(text="Individualized MVA-based Vaccine TG4050") )
        setattr(cls, "Anti-PD-1/Anti-CTLA4 DART Protein MGD019",
                PermissibleValue(text="Anti-PD-1/Anti-CTLA4 DART Protein MGD019") )
        setattr(cls, "Cevipabulin Fumarate",
                PermissibleValue(text="Cevipabulin Fumarate") )
        setattr(cls, "Sodium Stibogluconate",
                PermissibleValue(text="Sodium Stibogluconate") )
        setattr(cls, "Sorafenib Tosylate",
                PermissibleValue(text="Sorafenib Tosylate") )
        setattr(cls, "Bruceanol H",
                PermissibleValue(text="Bruceanol H") )
        setattr(cls, "Human Monoclonal Antibody B11-hCG Beta Fusion Protein CDX-1307",
                PermissibleValue(text="Human Monoclonal Antibody B11-hCG Beta Fusion Protein CDX-1307") )
        setattr(cls, "Cemadotin Hydrochloride",
                PermissibleValue(text="Cemadotin Hydrochloride") )
        setattr(cls, "Anti-VISTA Monoclonal Antibody JNJ 61610588",
                PermissibleValue(text="Anti-VISTA Monoclonal Antibody JNJ 61610588") )
        setattr(cls, "N-Methylformamide",
                PermissibleValue(text="N-Methylformamide") )
        setattr(cls, "Trimethylcolchicinic Acid",
                PermissibleValue(text="Trimethylcolchicinic Acid") )
        setattr(cls, "Monoclonal Antibody AbGn-7",
                PermissibleValue(text="Monoclonal Antibody AbGn-7") )
        setattr(cls, "HDAC6 Inhibitor KA2507",
                PermissibleValue(text="HDAC6 Inhibitor KA2507") )
        setattr(cls, "PARP Inhibitor CEP-9722",
                PermissibleValue(text="PARP Inhibitor CEP-9722") )
        setattr(cls, "Hodgkin's Antigens-GM-CSF-Expressing Cell Vaccine",
                PermissibleValue(text="Hodgkin's Antigens-GM-CSF-Expressing Cell Vaccine") )
        setattr(cls, "Tocotrienol-rich Fraction",
                PermissibleValue(text="Tocotrienol-rich Fraction") )
        setattr(cls, "Lyophilized Black Raspberry Lozenge",
                PermissibleValue(text="Lyophilized Black Raspberry Lozenge") )
        setattr(cls, "Anetumab Ravtansine",
                PermissibleValue(text="Anetumab Ravtansine") )
        setattr(cls, "Oncolytic Newcastle Disease Virus MTH-68H",
                PermissibleValue(text="Oncolytic Newcastle Disease Virus MTH-68H") )
        setattr(cls, "Anti-PD-1 Monoclonal Antibody HX008",
                PermissibleValue(text="Anti-PD-1 Monoclonal Antibody HX008") )
        setattr(cls, "Porcupine Inhibitor XNW7201",
                PermissibleValue(text="Porcupine Inhibitor XNW7201") )
        setattr(cls, "PI3K/mTOR Kinase Inhibitor DS-7423",
                PermissibleValue(text="PI3K/mTOR Kinase Inhibitor DS-7423") )
        setattr(cls, "Allogeneic Natural Killer Cell Line MG4101",
                PermissibleValue(text="Allogeneic Natural Killer Cell Line MG4101") )
        setattr(cls, "huBC1-huIL12 Fusion Protein AS1409",
                PermissibleValue(text="huBC1-huIL12 Fusion Protein AS1409") )
        setattr(cls, "Anti-CD3/Anti-CD20 Trifunctional Bispecific Monoclonal Antibody FBTA05",
                PermissibleValue(text="Anti-CD3/Anti-CD20 Trifunctional Bispecific Monoclonal Antibody FBTA05") )
        setattr(cls, "Anti-latent TGF-beta 1 Monoclonal Antibody SRK-181",
                PermissibleValue(text="Anti-latent TGF-beta 1 Monoclonal Antibody SRK-181") )
        setattr(cls, "Cedazuridine/Azacitidine Combination Agent ASTX030",
                PermissibleValue(text="Cedazuridine/Azacitidine Combination Agent ASTX030") )
        setattr(cls, "Lipid Nanoparticle Encapsulating Glutathione S-transferase P siRNA NBF-006",
                PermissibleValue(text="Lipid Nanoparticle Encapsulating Glutathione S-transferase P siRNA NBF-006") )
        setattr(cls, "Pladienolide Derivative E7107",
                PermissibleValue(text="Pladienolide Derivative E7107") )
        setattr(cls, "Antineoplaston AS2-1",
                PermissibleValue(text="Antineoplaston AS2-1") )
        setattr(cls, "Monoclonal Antibody m170",
                PermissibleValue(text="Monoclonal Antibody m170") )
        setattr(cls, "HSP90alpha/beta Inhibitor TAS-116",
                PermissibleValue(text="HSP90alpha/beta Inhibitor TAS-116") )
        setattr(cls, "SHP-1 Agonist SC-43",
                PermissibleValue(text="SHP-1 Agonist SC-43") )
        setattr(cls, "BTK Inhibitor ARQ 531",
                PermissibleValue(text="BTK Inhibitor ARQ 531") )
        setattr(cls, "Ethinyl Estradiol",
                PermissibleValue(text="Ethinyl Estradiol") )
        setattr(cls, "Extended Release Flucytosine",
                PermissibleValue(text="Extended Release Flucytosine") )
        setattr(cls, "Anti-OX40 Antibody BMS 986178",
                PermissibleValue(text="Anti-OX40 Antibody BMS 986178") )
        setattr(cls, "Autologous Monocyte-derived Lysate-pulsed Dendritic Cell Vaccine PV-001-DC",
                PermissibleValue(text="Autologous Monocyte-derived Lysate-pulsed Dendritic Cell Vaccine PV-001-DC") )
        setattr(cls, "MET Tyrosine Kinase Inhibitor EMD 1204831",
                PermissibleValue(text="MET Tyrosine Kinase Inhibitor EMD 1204831") )
        setattr(cls, "Anti-PD-1 Checkpoint Inhibitor PF-06801591",
                PermissibleValue(text="Anti-PD-1 Checkpoint Inhibitor PF-06801591") )
        setattr(cls, "Aphidicoline Glycinate",
                PermissibleValue(text="Aphidicoline Glycinate") )
        setattr(cls, "IL-2 Recombinant Fusion Protein ALT-801",
                PermissibleValue(text="IL-2 Recombinant Fusion Protein ALT-801") )
        setattr(cls, "Autologous Anti-HLA-A*02/AFP TCRm-expressing T-cells ET140202",
                PermissibleValue(text="Autologous Anti-HLA-A*02/AFP TCRm-expressing T-cells ET140202") )
        setattr(cls, "Interleukin-15 Fusion Protein BJ-001",
                PermissibleValue(text="Interleukin-15 Fusion Protein BJ-001") )
        setattr(cls, "FLT3/ABL/Aurora Kinase Inhibitor KW-2449",
                PermissibleValue(text="FLT3/ABL/Aurora Kinase Inhibitor KW-2449") )
        setattr(cls, "MAGE-A3 Multipeptide Vaccine GL-0817",
                PermissibleValue(text="MAGE-A3 Multipeptide Vaccine GL-0817") )
        setattr(cls, "PD-1 Directed Probody CX-188",
                PermissibleValue(text="PD-1 Directed Probody CX-188") )
        setattr(cls, "Gemcitabine-Phosphoramidate Hydrochloride NUC-1031",
                PermissibleValue(text="Gemcitabine-Phosphoramidate Hydrochloride NUC-1031") )
        setattr(cls, "PI3K/mTOR Kinase Inhibitor VS-5584",
                PermissibleValue(text="PI3K/mTOR Kinase Inhibitor VS-5584") )
        setattr(cls, "Canfosfamide Hydrochloride",
                PermissibleValue(text="Canfosfamide Hydrochloride") )
        setattr(cls, "Fms/Trk Tyrosine Kinase Inhibitor PLX7486 Tosylate",
                PermissibleValue(text="Fms/Trk Tyrosine Kinase Inhibitor PLX7486 Tosylate") )
        setattr(cls, "CYP17/CYP11B2 Inhibitor LAE001",
                PermissibleValue(text="CYP17/CYP11B2 Inhibitor LAE001") )
        setattr(cls, "Idarubicin-Eluting Beads",
                PermissibleValue(text="Idarubicin-Eluting Beads") )
        setattr(cls, "Anti-TGF-beta Monoclonal Antibody NIS793",
                PermissibleValue(text="Anti-TGF-beta Monoclonal Antibody NIS793") )
        setattr(cls, "Ubidecarenone Nanodispersion BPM31510n",
                PermissibleValue(text="Ubidecarenone Nanodispersion BPM31510n") )
        setattr(cls, "Melphalan Hydrochloride/Sulfobutyl Ether Beta-Cyclodextrin Complex",
                PermissibleValue(text="Melphalan Hydrochloride/Sulfobutyl Ether Beta-Cyclodextrin Complex") )
        setattr(cls, "Smac Mimetic LCL161",
                PermissibleValue(text="Smac Mimetic LCL161") )
        setattr(cls, "Allogeneic GM-CSF-secreting Lethally Irradiated Whole Melanoma Cell Vaccine",
                PermissibleValue(text="Allogeneic GM-CSF-secreting Lethally Irradiated Whole Melanoma Cell Vaccine") )
        setattr(cls, "CD123-specific Targeting Module TM123",
                PermissibleValue(text="CD123-specific Targeting Module TM123") )
        setattr(cls, "BP-Cx1-Platinum Complex BP-C1",
                PermissibleValue(text="BP-Cx1-Platinum Complex BP-C1") )
        setattr(cls, "Autologous TCR-engineered T-cells IMA201",
                PermissibleValue(text="Autologous TCR-engineered T-cells IMA201") )
        setattr(cls, "Anti-HER2 Monoclonal Antibody CT-P6",
                PermissibleValue(text="Anti-HER2 Monoclonal Antibody CT-P6") )
        setattr(cls, "Tomato-Soy Juice",
                PermissibleValue(text="Tomato-Soy Juice") )
        setattr(cls, "Samarium Sm 153-DOTMP",
                PermissibleValue(text="Samarium Sm 153-DOTMP") )
        setattr(cls, "Natural IFN-alpha OPC-18",
                PermissibleValue(text="Natural IFN-alpha OPC-18") )
        setattr(cls, "Interleukin-15 Agonist Fusion Protein SHR1501",
                PermissibleValue(text="Interleukin-15 Agonist Fusion Protein SHR1501") )
        setattr(cls, "Smoothened Antagonist BMS-833923",
                PermissibleValue(text="Smoothened Antagonist BMS-833923") )
        setattr(cls, "Autologous Anti-CD19 Chimeric Antigen Receptor T-cells AUTO1",
                PermissibleValue(text="Autologous Anti-CD19 Chimeric Antigen Receptor T-cells AUTO1") )
        setattr(cls, "CD44 Targeted Agent SPL-108",
                PermissibleValue(text="CD44 Targeted Agent SPL-108") )
        setattr(cls, "Cyclopentenyl Cytosine",
                PermissibleValue(text="Cyclopentenyl Cytosine") )
        setattr(cls, "Rigosertib Sodium",
                PermissibleValue(text="Rigosertib Sodium") )
        setattr(cls, "7-Ethyl-10-Hydroxycamptothecin",
                PermissibleValue(text="7-Ethyl-10-Hydroxycamptothecin") )
        setattr(cls, "Bacillus Calmette-Guerin Substrain Connaught Live Antigen",
                PermissibleValue(text="Bacillus Calmette-Guerin Substrain Connaught Live Antigen") )
        setattr(cls, "Taxane Analogue TPI 287",
                PermissibleValue(text="Taxane Analogue TPI 287") )
        setattr(cls, "Pegylated Deoxycytidine Analogue DFP-14927",
                PermissibleValue(text="Pegylated Deoxycytidine Analogue DFP-14927") )
        setattr(cls, "Huaier Extract Granule",
                PermissibleValue(text="Huaier Extract Granule") )
        setattr(cls, "Aurora A Kinase/Tyrosine Kinase Inhibitor ENMD-2076",
                PermissibleValue(text="Aurora A Kinase/Tyrosine Kinase Inhibitor ENMD-2076") )
        setattr(cls, "Fedratinib Hydrochloride",
                PermissibleValue(text="Fedratinib Hydrochloride") )
        setattr(cls, "Pegvorhyaluronidase Alfa",
                PermissibleValue(text="Pegvorhyaluronidase Alfa") )
        setattr(cls, "Anti-OX40 Hexavalent Agonist Antibody INBRX-106",
                PermissibleValue(text="Anti-OX40 Hexavalent Agonist Antibody INBRX-106") )
        setattr(cls, "Dihydroorotate Dehydrogenase Inhibitor BAY2402234",
                PermissibleValue(text="Dihydroorotate Dehydrogenase Inhibitor BAY2402234") )
        setattr(cls, "Ondansetron Hydrochloride",
                PermissibleValue(text="Ondansetron Hydrochloride") )
        setattr(cls, "Anti-BTLA Monoclonal Antibody TAB004",
                PermissibleValue(text="Anti-BTLA Monoclonal Antibody TAB004") )
        setattr(cls, "BMS-184476",
                PermissibleValue(text="BMS-184476") )
        setattr(cls, "Ruthenium Ru-106",
                PermissibleValue(text="Ruthenium Ru-106") )
        setattr(cls, "Deuterated Enzalutamide",
                PermissibleValue(text="Deuterated Enzalutamide") )
        setattr(cls, "Anti-PRAME Immunotherapeutic GSK2302032A",
                PermissibleValue(text="Anti-PRAME Immunotherapeutic GSK2302032A") )
        setattr(cls, "Recombinant Macrophage Colony-Stimulating Factor",
                PermissibleValue(text="Recombinant Macrophage Colony-Stimulating Factor") )
        setattr(cls, "HER-2-positive B-cell Peptide Antigen P467-DT-CRM197/Montanide Vaccine IMU-131",
                PermissibleValue(text="HER-2-positive B-cell Peptide Antigen P467-DT-CRM197/Montanide Vaccine IMU-131") )
        setattr(cls, "Iodine I 125-Anti-EGFR-425 Monoclonal Antibody",
                PermissibleValue(text="Iodine I 125-Anti-EGFR-425 Monoclonal Antibody") )
        setattr(cls, "Carmustine Sustained-Release Implant Wafer",
                PermissibleValue(text="Carmustine Sustained-Release Implant Wafer") )
        setattr(cls, "Anti-EGFR TAP Antibody-drug Conjugate IMGN289",
                PermissibleValue(text="Anti-EGFR TAP Antibody-drug Conjugate IMGN289") )
        setattr(cls, "Brimonidine Tartrate Nanoemulsion OCU-300",
                PermissibleValue(text="Brimonidine Tartrate Nanoemulsion OCU-300") )
        setattr(cls, "Saracatinib Difumarate",
                PermissibleValue(text="Saracatinib Difumarate") )
        setattr(cls, "INO-1001",
                PermissibleValue(text="INO-1001") )
        setattr(cls, "Src/tubulin Inhibitor KX02",
                PermissibleValue(text="Src/tubulin Inhibitor KX02") )
        setattr(cls, "Moxetumomab Pasudotox",
                PermissibleValue(text="Moxetumomab Pasudotox") )
        setattr(cls, "Autologous Anti-CD20 CAR Transduced CD4/CD8 Enriched T-cells MB-CART20.1",
                PermissibleValue(text="Autologous Anti-CD20 CAR Transduced CD4/CD8 Enriched T-cells MB-CART20.1") )
        setattr(cls, "Broad-Spectrum Human Papillomavirus Vaccine V505",
                PermissibleValue(text="Broad-Spectrum Human Papillomavirus Vaccine V505") )
        setattr(cls, "Bushen-Jianpi Decoction",
                PermissibleValue(text="Bushen-Jianpi Decoction") )
        setattr(cls, "Eftilagimod Alpha",
                PermissibleValue(text="Eftilagimod Alpha") )
        setattr(cls, "PSMA/CD3 Tri-specific T-cell Activating Construct HPN424",
                PermissibleValue(text="PSMA/CD3 Tri-specific T-cell Activating Construct HPN424") )
        setattr(cls, "Omacetaxine Mepesuccinate",
                PermissibleValue(text="Omacetaxine Mepesuccinate") )
        setattr(cls, "Anti-PD-L1 Monoclonal Antibody HLX20",
                PermissibleValue(text="Anti-PD-L1 Monoclonal Antibody HLX20") )
        setattr(cls, "BET inhibitor BI 894999",
                PermissibleValue(text="BET inhibitor BI 894999") )
        setattr(cls, "Synthetic Long E6/E7 Peptides Vaccine HPV-01",
                PermissibleValue(text="Synthetic Long E6/E7 Peptides Vaccine HPV-01") )
        setattr(cls, "Autologous MAGE-A3/A6-specific TCR Gene-engineered Lymphocytes KITE-718",
                PermissibleValue(text="Autologous MAGE-A3/A6-specific TCR Gene-engineered Lymphocytes KITE-718") )
        setattr(cls, "Autologous Pancreatic Adenocarcinoma Lysate and mRNA-loaded Dendritic Cell Vaccine",
                PermissibleValue(text="Autologous Pancreatic Adenocarcinoma Lysate and mRNA-loaded Dendritic Cell Vaccine") )
        setattr(cls, "CHP-NY-ESO-1 Peptide Vaccine IMF-001",
                PermissibleValue(text="CHP-NY-ESO-1 Peptide Vaccine IMF-001") )
        setattr(cls, "Anti-CD3/CD7-Ricin Toxin A Immunotoxin",
                PermissibleValue(text="Anti-CD3/CD7-Ricin Toxin A Immunotoxin") )
        setattr(cls, "PI3K Inhibitor GDC0077",
                PermissibleValue(text="PI3K Inhibitor GDC0077") )
        setattr(cls, "Anti-NaPi2b Monoclonal Antibody XMT-1535",
                PermissibleValue(text="Anti-NaPi2b Monoclonal Antibody XMT-1535") )
        setattr(cls, "Resistant Starch",
                PermissibleValue(text="Resistant Starch") )
        setattr(cls, "Polyvalent Melanoma Vaccine",
                PermissibleValue(text="Polyvalent Melanoma Vaccine") )
        setattr(cls, "Anti-CD37 Monoclonal Antibody BI 836826",
                PermissibleValue(text="Anti-CD37 Monoclonal Antibody BI 836826") )
        setattr(cls, "Babaodan Capsule",
                PermissibleValue(text="Babaodan Capsule") )
        setattr(cls, "Anti-CD46 Antibody-drug Conjugate FOR46",
                PermissibleValue(text="Anti-CD46 Antibody-drug Conjugate FOR46") )
        setattr(cls, "FGFR4 Antagonist INCB062079",
                PermissibleValue(text="FGFR4 Antagonist INCB062079") )
        setattr(cls, "CDK4/6 Inhibitor TQB3616",
                PermissibleValue(text="CDK4/6 Inhibitor TQB3616") )
        setattr(cls, "Anti-MUC16/CD3 Bispecific Antibody REGN4018",
                PermissibleValue(text="Anti-MUC16/CD3 Bispecific Antibody REGN4018") )
        setattr(cls, "Berubicin Hydrochloride",
                PermissibleValue(text="Berubicin Hydrochloride") )
        setattr(cls, "Prednisolone Acetate",
                PermissibleValue(text="Prednisolone Acetate") )
        setattr(cls, "Aurora Kinase Inhibitor SNS-314",
                PermissibleValue(text="Aurora Kinase Inhibitor SNS-314") )
        setattr(cls, "At 211 Monoclonal Antibody 81C6",
                PermissibleValue(text="At 211 Monoclonal Antibody 81C6") )
        setattr(cls, "AE37 Peptide/GM-CSF Vaccine",
                PermissibleValue(text="AE37 Peptide/GM-CSF Vaccine") )
        setattr(cls, "Anti-CD19 Monoclonal Antibody MDX-1342",
                PermissibleValue(text="Anti-CD19 Monoclonal Antibody MDX-1342") )
        setattr(cls, "Monoclonal Microbial EDP1503",
                PermissibleValue(text="Monoclonal Microbial EDP1503") )
        setattr(cls, "Iodine I 131 IPA",
                PermissibleValue(text="Iodine I 131 IPA") )
        setattr(cls, "Anti-BTN3A Agonistic Monoclonal Antibody ICT01",
                PermissibleValue(text="Anti-BTN3A Agonistic Monoclonal Antibody ICT01") )
        setattr(cls, "Antibody-drug Conjugate SC-002",
                PermissibleValue(text="Antibody-drug Conjugate SC-002") )
        setattr(cls, "CDK2/5/9 Inhibitor CYC065",
                PermissibleValue(text="CDK2/5/9 Inhibitor CYC065") )
        setattr(cls, "Multi-epitope Anti-folate Receptor Peptide Vaccine TPIV 200",
                PermissibleValue(text="Multi-epitope Anti-folate Receptor Peptide Vaccine TPIV 200") )
        setattr(cls, "Glutaminase Inhibitor IPN60090",
                PermissibleValue(text="Glutaminase Inhibitor IPN60090") )
        setattr(cls, "HER2 Inhibitor CP-724,714",
                PermissibleValue(text="HER2 Inhibitor CP-724,714") )
        setattr(cls, "Indole-3-Carbinol",
                PermissibleValue(text="Indole-3-Carbinol") )
        setattr(cls, "Survivin Antigen",
                PermissibleValue(text="Survivin Antigen") )
        setattr(cls, "BET Bromodomain Inhibitor ZEN-3694",
                PermissibleValue(text="BET Bromodomain Inhibitor ZEN-3694") )
        setattr(cls, "Navy Bean Powder",
                PermissibleValue(text="Navy Bean Powder") )
        setattr(cls, "Ceramide Nanoliposome",
                PermissibleValue(text="Ceramide Nanoliposome") )
        setattr(cls, "Sacubitril/Valsartan",
                PermissibleValue(text="Sacubitril/Valsartan") )
        setattr(cls, "ERa36 Modulator Icaritin",
                PermissibleValue(text="ERa36 Modulator Icaritin") )
        setattr(cls, "Belagenpumatucel-L",
                PermissibleValue(text="Belagenpumatucel-L") )
        setattr(cls, "Cyclin-dependent Kinase 8/19 Inhibitor BCD 115",
                PermissibleValue(text="Cyclin-dependent Kinase 8/19 Inhibitor BCD 115") )
        setattr(cls, "Anti-HER-2 Bispecific Antibody KN026",
                PermissibleValue(text="Anti-HER-2 Bispecific Antibody KN026") )
        setattr(cls, "mRNA-based TriMix Melanoma Vaccine ECI-006",
                PermissibleValue(text="mRNA-based TriMix Melanoma Vaccine ECI-006") )
        setattr(cls, "Anti-CD40/Anti-TAA Bispecific Monoclonal Antibody ABBV-428",
                PermissibleValue(text="Anti-CD40/Anti-TAA Bispecific Monoclonal Antibody ABBV-428") )
        setattr(cls, "SIRPa-IgG4-Fc Fusion Protein TTI-622",
                PermissibleValue(text="SIRPa-IgG4-Fc Fusion Protein TTI-622") )
        setattr(cls, "ERK1/2 Inhibitor HH2710",
                PermissibleValue(text="ERK1/2 Inhibitor HH2710") )
        setattr(cls, "Exatecan Mesylate",
                PermissibleValue(text="Exatecan Mesylate") )
        setattr(cls, "MUC-1/WT1 Peptide-primed Autologous Dendritic Cells",
                PermissibleValue(text="MUC-1/WT1 Peptide-primed Autologous Dendritic Cells") )
        setattr(cls, "FLT3 Inhibitor FF-10101 Succinate",
                PermissibleValue(text="FLT3 Inhibitor FF-10101 Succinate") )
        setattr(cls, "ATR Kinase Inhibitor VX-803",
                PermissibleValue(text="ATR Kinase Inhibitor VX-803") )
        setattr(cls, "DNA-PK inhibitor AZD7648",
                PermissibleValue(text="DNA-PK inhibitor AZD7648") )
        setattr(cls, "AKR1C3-activated Prodrug OBI-3424",
                PermissibleValue(text="AKR1C3-activated Prodrug OBI-3424") )
        setattr(cls, "Tetanus Toxoid Vaccine",
                PermissibleValue(text="Tetanus Toxoid Vaccine") )
        setattr(cls, "Anti-EGFR/HER2/HER3 Monoclonal Antibody Mixture Sym013",
                PermissibleValue(text="Anti-EGFR/HER2/HER3 Monoclonal Antibody Mixture Sym013") )
        setattr(cls, "PARP7 Inhibitor RBN-2397",
                PermissibleValue(text="PARP7 Inhibitor RBN-2397") )
        setattr(cls, "Rhenium Re-188 Etidronate",
                PermissibleValue(text="Rhenium Re-188 Etidronate") )
        setattr(cls, "Anti-ErbB3 Antibody ISU104",
                PermissibleValue(text="Anti-ErbB3 Antibody ISU104") )
        setattr(cls, "PEG-interleukin-2",
                PermissibleValue(text="PEG-interleukin-2") )
        setattr(cls, "Oligonucleotide SPC2996",
                PermissibleValue(text="Oligonucleotide SPC2996") )
        setattr(cls, "Gossypol Acetic Acid",
                PermissibleValue(text="Gossypol Acetic Acid") )
        setattr(cls, "pNGVL4a-Sig/E7(detox)/HSP70 DNA and HPV16 L2/E6/E7 Fusion Protein TA-CIN Vaccine PVX-2",
                PermissibleValue(text="pNGVL4a-Sig/E7(detox)/HSP70 DNA and HPV16 L2/E6/E7 Fusion Protein TA-CIN Vaccine PVX-2") )
        setattr(cls, "HPV Types 16/18 E6/E7-Adenoviral Transduced Autologous Lymphocytes/alpha-Galactosylceramide Vaccine BVAC-C",
                PermissibleValue(text="HPV Types 16/18 E6/E7-Adenoviral Transduced Autologous Lymphocytes/alpha-Galactosylceramide Vaccine BVAC-C") )
        setattr(cls, "HDAC Inhibitor OBP-801",
                PermissibleValue(text="HDAC Inhibitor OBP-801") )
        setattr(cls, "Dibrospidium Chloride",
                PermissibleValue(text="Dibrospidium Chloride") )
        setattr(cls, "Calcium Release-activated Channels Inhibitor RP4010",
                PermissibleValue(text="Calcium Release-activated Channels Inhibitor RP4010") )
        setattr(cls, "Monoclonal Antibody MX35 F(ab')2",
                PermissibleValue(text="Monoclonal Antibody MX35 F(ab')2") )
        setattr(cls, "Nab-paclitaxel/Rituximab-coated Nanoparticle AR160",
                PermissibleValue(text="Nab-paclitaxel/Rituximab-coated Nanoparticle AR160") )
        setattr(cls, "Estradiol Valerate",
                PermissibleValue(text="Estradiol Valerate") )
        setattr(cls, "Ashwagandha Root Powder Extract",
                PermissibleValue(text="Ashwagandha Root Powder Extract") )
        setattr(cls, "p97 Inhibitor CB-5339 Tosylate",
                PermissibleValue(text="p97 Inhibitor CB-5339 Tosylate") )
        setattr(cls, "Mucoadhesive Paclitaxel Formulation",
                PermissibleValue(text="Mucoadhesive Paclitaxel Formulation") )
        setattr(cls, "Anti-PD-L1 Monoclonal Antibody CK-301",
                PermissibleValue(text="Anti-PD-L1 Monoclonal Antibody CK-301") )
        setattr(cls, "Tubulin Inhibitor ALB-109564",
                PermissibleValue(text="Tubulin Inhibitor ALB-109564") )
        setattr(cls, "PI3K Alpha/mTOR Inhibitor PWT33597 Mesylate",
                PermissibleValue(text="PI3K Alpha/mTOR Inhibitor PWT33597 Mesylate") )
        setattr(cls, "Anti-NY-ESO-1 Immunotherapeutic GSK-2241658A",
                PermissibleValue(text="Anti-NY-ESO-1 Immunotherapeutic GSK-2241658A") )
        setattr(cls, "Anti-CD123 Monoclonal Antibody KHK2823",
                PermissibleValue(text="Anti-CD123 Monoclonal Antibody KHK2823") )
        setattr(cls, "Smac Mimetic GDC-0917",
                PermissibleValue(text="Smac Mimetic GDC-0917") )
        setattr(cls, "Recombinant Human Papillomavirus Bivalent Vaccine",
                PermissibleValue(text="Recombinant Human Papillomavirus Bivalent Vaccine") )
        setattr(cls, "VEGFR-2 DNA Vaccine VXM01",
                PermissibleValue(text="VEGFR-2 DNA Vaccine VXM01") )
        setattr(cls, "Immediate-release Onapristone",
                PermissibleValue(text="Immediate-release Onapristone") )
        setattr(cls, "Anti-MAGE-A4 T-cell Receptor/Anti-CD3 scFv Fusion Protein IMC-C103C",
                PermissibleValue(text="Anti-MAGE-A4 T-cell Receptor/Anti-CD3 scFv Fusion Protein IMC-C103C") )
        setattr(cls, "Anti-CD47 Monoclonal Antibody SHR-1603",
                PermissibleValue(text="Anti-CD47 Monoclonal Antibody SHR-1603") )
        setattr(cls, "Adenoviral Brachyury Vaccine ETBX-051",
                PermissibleValue(text="Adenoviral Brachyury Vaccine ETBX-051") )
        setattr(cls, "Antibody-drug Conjugate MEDI7247",
                PermissibleValue(text="Antibody-drug Conjugate MEDI7247") )
        setattr(cls, "Palifosfamide Tromethamine",
                PermissibleValue(text="Palifosfamide Tromethamine") )
        setattr(cls, "Sodium Iodide I-131",
                PermissibleValue(text="Sodium Iodide I-131") )
        setattr(cls, "FGFR4 Inhibitor BLU 9931",
                PermissibleValue(text="FGFR4 Inhibitor BLU 9931") )
        setattr(cls, "Rucaparib Camsylate",
                PermissibleValue(text="Rucaparib Camsylate") )
        setattr(cls, "Anti-CD45 Monoclonal Antibody AHN-12",
                PermissibleValue(text="Anti-CD45 Monoclonal Antibody AHN-12") )
        setattr(cls, "Imidazole-Pyrazole",
                PermissibleValue(text="Imidazole-Pyrazole") )
        setattr(cls, "Radium Ra 224-labeled Calcium Carbonate Microparticles",
                PermissibleValue(text="Radium Ra 224-labeled Calcium Carbonate Microparticles") )
        setattr(cls, "BL22 Immunotoxin",
                PermissibleValue(text="BL22 Immunotoxin") )
        setattr(cls, "MEK Inhibitor PD0325901",
                PermissibleValue(text="MEK Inhibitor PD0325901") )
        setattr(cls, "Alpha V Beta 1 Inhibitor ATN-161",
                PermissibleValue(text="Alpha V Beta 1 Inhibitor ATN-161") )
        setattr(cls, "Anti-c-Met Antibody-drug Conjugate HTI-1066",
                PermissibleValue(text="Anti-c-Met Antibody-drug Conjugate HTI-1066") )
        setattr(cls, "2,6-Diaminopurine",
                PermissibleValue(text="2,6-Diaminopurine") )
        setattr(cls, "VGEFR/c-kit/PDGFR Tyrosine Kinase Inhibitor XL820",
                PermissibleValue(text="VGEFR/c-kit/PDGFR Tyrosine Kinase Inhibitor XL820") )
        setattr(cls, "Anti-nectin-4 Monoclonal Antibody-Drug Conjugate AGS-22M6E",
                PermissibleValue(text="Anti-nectin-4 Monoclonal Antibody-Drug Conjugate AGS-22M6E") )
        setattr(cls, "EGFR Mutant-selective  Inhibitor TQB3804",
                PermissibleValue(text="EGFR Mutant-selective  Inhibitor TQB3804") )
        setattr(cls, "Autologous Anti-CD19 CAR-CD3zeta-4-1BB-expressing T-cells PZ01",
                PermissibleValue(text="Autologous Anti-CD19 CAR-CD3zeta-4-1BB-expressing T-cells PZ01") )
        setattr(cls, "Shared Anti-Idiotype-AB-S006",
                PermissibleValue(text="Shared Anti-Idiotype-AB-S006") )
        setattr(cls, "Autologous Anti-FLT3 CAR T Cells AMG 553",
                PermissibleValue(text="Autologous Anti-FLT3 CAR T Cells AMG 553") )
        setattr(cls, "Anti-Denatured Collagen Monoclonal Antibody TRC093",
                PermissibleValue(text="Anti-Denatured Collagen Monoclonal Antibody TRC093") )
        setattr(cls, "Recombinant Human Adenovirus Type 5 H101",
                PermissibleValue(text="Recombinant Human Adenovirus Type 5 H101") )
        setattr(cls, "Allogeneic Anti-BCMA-CAR T-cells PBCAR269A",
                PermissibleValue(text="Allogeneic Anti-BCMA-CAR T-cells PBCAR269A") )
        setattr(cls, "Aurora A Kinase Inhibitor TAS-119",
                PermissibleValue(text="Aurora A Kinase Inhibitor TAS-119") )
        setattr(cls, "Recombinant MIP1-alpha Variant ECI301",
                PermissibleValue(text="Recombinant MIP1-alpha Variant ECI301") )
        setattr(cls, "Personalized Cancer Vaccine RO7198457",
                PermissibleValue(text="Personalized Cancer Vaccine RO7198457") )
        setattr(cls, "Vatalanib Succinate",
                PermissibleValue(text="Vatalanib Succinate") )
        setattr(cls, "Anti-CD20 Monoclonal Antibody BAT4306F",
                PermissibleValue(text="Anti-CD20 Monoclonal Antibody BAT4306F") )
        setattr(cls, "Anti-BCMA/Anti-CD3 Bispecific Antibody REGN5459",
                PermissibleValue(text="Anti-BCMA/Anti-CD3 Bispecific Antibody REGN5459") )
        setattr(cls, "Botanical Agent BEL-X-HG",
                PermissibleValue(text="Botanical Agent BEL-X-HG") )
        setattr(cls, "Bispecific Antibody MDX447",
                PermissibleValue(text="Bispecific Antibody MDX447") )
        setattr(cls, "Anti-OX40 Agonist Monoclonal Antibody PF-04518600",
                PermissibleValue(text="Anti-OX40 Agonist Monoclonal Antibody PF-04518600") )
        setattr(cls, "Anti-CD98 Monoclonal Antibody IGN523",
                PermissibleValue(text="Anti-CD98 Monoclonal Antibody IGN523") )
        setattr(cls, "Pan-TRK Inhibitor NOV1601",
                PermissibleValue(text="Pan-TRK Inhibitor NOV1601") )
        setattr(cls, "Anti-mesothelin/MMAE Antibody-Drug Conjugate DMOT4039A",
                PermissibleValue(text="Anti-mesothelin/MMAE Antibody-Drug Conjugate DMOT4039A") )
        setattr(cls, "Microtubule Inhibitor SCB01A",
                PermissibleValue(text="Microtubule Inhibitor SCB01A") )
        setattr(cls, "2-Fluoroadenine",
                PermissibleValue(text="2-Fluoroadenine") )
        setattr(cls, "c-Met Inhibitor AMG 337",
                PermissibleValue(text="c-Met Inhibitor AMG 337") )
        setattr(cls, "Anti-VEGF Monoclonal Antibody hPV19",
                PermissibleValue(text="Anti-VEGF Monoclonal Antibody hPV19") )
        setattr(cls, "Thioredoxin-1 Inhibitor PX-12",
                PermissibleValue(text="Thioredoxin-1 Inhibitor PX-12") )
        setattr(cls, "Rucaparib Phosphate",
                PermissibleValue(text="Rucaparib Phosphate") )
        setattr(cls, "Dabrafenib Mesylate",
                PermissibleValue(text="Dabrafenib Mesylate") )
        setattr(cls, "Adenosine A2A Receptor Antagonist NIR178",
                PermissibleValue(text="Adenosine A2A Receptor Antagonist NIR178") )
        setattr(cls, "Anti-CLEC12A/CD3 Bispecific Antibody MCLA117",
                PermissibleValue(text="Anti-CLEC12A/CD3 Bispecific Antibody MCLA117") )
        setattr(cls, "c-Met Inhibitor JNJ-38877605",
                PermissibleValue(text="c-Met Inhibitor JNJ-38877605") )
        setattr(cls, "Glioblastoma Multiforme Multipeptide Vaccine IMA950",
                PermissibleValue(text="Glioblastoma Multiforme Multipeptide Vaccine IMA950") )
        setattr(cls, "Allogeneic CD56-positive CD3-negative Natural Killer Cells CYNK-001",
                PermissibleValue(text="Allogeneic CD56-positive CD3-negative Natural Killer Cells CYNK-001") )
        setattr(cls, "Custirsen Sodium",
                PermissibleValue(text="Custirsen Sodium") )
        setattr(cls, "Amonafide L-Malate",
                PermissibleValue(text="Amonafide L-Malate") )
        setattr(cls, "Anti-PD-L1 Monoclonal Antibody ZKAB001",
                PermissibleValue(text="Anti-PD-L1 Monoclonal Antibody ZKAB001") )
        setattr(cls, "Autologous CD38-4SCAR-expressing T-cells 4SCAR38",
                PermissibleValue(text="Autologous CD38-4SCAR-expressing T-cells 4SCAR38") )
        setattr(cls, "Aurora A Kinase Inhibitor LY3295668 Erbumine",
                PermissibleValue(text="Aurora A Kinase Inhibitor LY3295668 Erbumine") )
        setattr(cls, "Anti-CD37 Antibody-Drug Conjugate IMGN529",
                PermissibleValue(text="Anti-CD37 Antibody-Drug Conjugate IMGN529") )
        setattr(cls, "Agonistic Anti-OX40 Monoclonal Antibody INCAGN01949",
                PermissibleValue(text="Agonistic Anti-OX40 Monoclonal Antibody INCAGN01949") )
        setattr(cls, "Zoledronic Acid",
                PermissibleValue(text="Zoledronic Acid") )
        setattr(cls, "Dual-affinity B7-H3/CD3-targeted Protein MGD009",
                PermissibleValue(text="Dual-affinity B7-H3/CD3-targeted Protein MGD009") )
        setattr(cls, "DKK1-Neutralizing Monoclonal Antibody DKN-01",
                PermissibleValue(text="DKK1-Neutralizing Monoclonal Antibody DKN-01") )
        setattr(cls, "CXCR4 Antagonist BL-8040",
                PermissibleValue(text="CXCR4 Antagonist BL-8040") )
        setattr(cls, "Conditionally Active Biologic Anti-AXL Antibody-drug Conjugate BA3011",
                PermissibleValue(text="Conditionally Active Biologic Anti-AXL Antibody-drug Conjugate BA3011") )
        setattr(cls, "STING Agonist SB 11285",
                PermissibleValue(text="STING Agonist SB 11285") )
        setattr(cls, "Immunotoxin CMD-193",
                PermissibleValue(text="Immunotoxin CMD-193") )
        setattr(cls, "Irinotecan/P-glycoprotein Inhibitor HM30181AK Combination Tablet",
                PermissibleValue(text="Irinotecan/P-glycoprotein Inhibitor HM30181AK Combination Tablet") )
        setattr(cls, "Camptothecin Glycoconjugate BAY 38-3441",
                PermissibleValue(text="Camptothecin Glycoconjugate BAY 38-3441") )
        setattr(cls, "CDK4/6 Inhibitor CS3002",
                PermissibleValue(text="CDK4/6 Inhibitor CS3002") )
        setattr(cls, "Peginterferon Alfa-2a",
                PermissibleValue(text="Peginterferon Alfa-2a") )
        setattr(cls, "Polysaccharide-K",
                PermissibleValue(text="Polysaccharide-K") )
        setattr(cls, "Interleukin-2 Liposome",
                PermissibleValue(text="Interleukin-2 Liposome") )
        setattr(cls, "Tamoxifen Citrate",
                PermissibleValue(text="Tamoxifen Citrate") )
        setattr(cls, "Anti-EGFR Monoclonal Antibody CPGJ 602",
                PermissibleValue(text="Anti-EGFR Monoclonal Antibody CPGJ 602") )
        setattr(cls, "Anti-IL-8 Monoclonal Antibody BMS-986253",
                PermissibleValue(text="Anti-IL-8 Monoclonal Antibody BMS-986253") )
        setattr(cls, "PI3K Inhibitor ACP-319",
                PermissibleValue(text="PI3K Inhibitor ACP-319") )
        setattr(cls, "HER2 ECD+TM Virus-like Replicon Particles Vaccine AVX901",
                PermissibleValue(text="HER2 ECD+TM Virus-like Replicon Particles Vaccine AVX901") )
        setattr(cls, "Anti-EGFR/DM1 Antibody-drug Conjugate AVID100",
                PermissibleValue(text="Anti-EGFR/DM1 Antibody-drug Conjugate AVID100") )
        setattr(cls, "Rilimogene Galvacirepvec/Rilimogene Glafolivec",
                PermissibleValue(text="Rilimogene Galvacirepvec/Rilimogene Glafolivec") )
        setattr(cls, "Thyroid Extract",
                PermissibleValue(text="Thyroid Extract") )
        setattr(cls, "Anti-TAG-72 Monoclonal Antibody scFV CC-49/218",
                PermissibleValue(text="Anti-TAG-72 Monoclonal Antibody scFV CC-49/218") )
        setattr(cls, "Anti-CEACAM6 Antibody BAY1834942",
                PermissibleValue(text="Anti-CEACAM6 Antibody BAY1834942") )
        setattr(cls, "Antibody-drug Conjugate ABBV-011",
                PermissibleValue(text="Antibody-drug Conjugate ABBV-011") )
        setattr(cls, "EGFR T790M Antagonist BPI-15086",
                PermissibleValue(text="EGFR T790M Antagonist BPI-15086") )
        setattr(cls, "Recombinant Human Hsp110-gp100 Chaperone Complex Vaccine",
                PermissibleValue(text="Recombinant Human Hsp110-gp100 Chaperone Complex Vaccine") )
        setattr(cls, "Lavendustin A",
                PermissibleValue(text="Lavendustin A") )
        setattr(cls, "GSK-3 Inhibitor LY2090314",
                PermissibleValue(text="GSK-3 Inhibitor LY2090314") )
        setattr(cls, "mTORC1/2 Kinase Inhibitor BI 860585",
                PermissibleValue(text="mTORC1/2 Kinase Inhibitor BI 860585") )
        setattr(cls, "Triazene Derivative CB10-277",
                PermissibleValue(text="Triazene Derivative CB10-277") )
        setattr(cls, "Telaglenastat Hydrochloride",
                PermissibleValue(text="Telaglenastat Hydrochloride") )
        setattr(cls, "Triamcinolone Hexacetonide",
                PermissibleValue(text="Triamcinolone Hexacetonide") )
        setattr(cls, "Shark Cartilage",
                PermissibleValue(text="Shark Cartilage") )
        setattr(cls, "Vascular Disrupting Agent ZD6126",
                PermissibleValue(text="Vascular Disrupting Agent ZD6126") )
        setattr(cls, "CSF1R Inhibitor DCC-3014",
                PermissibleValue(text="CSF1R Inhibitor DCC-3014") )
        setattr(cls, "Cinrebafusp Alfa",
                PermissibleValue(text="Cinrebafusp Alfa") )
        setattr(cls, "STAT3 Inhibitor OPB-51602",
                PermissibleValue(text="STAT3 Inhibitor OPB-51602") )
        setattr(cls, "Ralimetinib Mesylate",
                PermissibleValue(text="Ralimetinib Mesylate") )
        setattr(cls, "MKC-1",
                PermissibleValue(text="MKC-1") )
        setattr(cls, "Paclitaxel Polymeric Micelle Formulation NANT-008",
                PermissibleValue(text="Paclitaxel Polymeric Micelle Formulation NANT-008") )
        setattr(cls, "Immunocytokine NHS-IL2-LT",
                PermissibleValue(text="Immunocytokine NHS-IL2-LT") )
        setattr(cls, "Coxsackievirus V937",
                PermissibleValue(text="Coxsackievirus V937") )
        setattr(cls, "SHP2 Inhibitor TNO155",
                PermissibleValue(text="SHP2 Inhibitor TNO155") )
        setattr(cls, "I 131 Monoclonal Antibody F19",
                PermissibleValue(text="I 131 Monoclonal Antibody F19") )
        setattr(cls, "Anti-VEGFC Monoclonal Antibody VGX-100",
                PermissibleValue(text="Anti-VEGFC Monoclonal Antibody VGX-100") )
        setattr(cls, "Anti-HER3 Antibody-drug Conjugate U3 1402",
                PermissibleValue(text="Anti-HER3 Antibody-drug Conjugate U3 1402") )
        setattr(cls, "Methoxyamine Hydrochloride",
                PermissibleValue(text="Methoxyamine Hydrochloride") )
        setattr(cls, "Quadrivalent Human Papillomavirus (types 6, 11, 16, 18) Recombinant Vaccine",
                PermissibleValue(text="Quadrivalent Human Papillomavirus (types 6, 11, 16, 18) Recombinant Vaccine") )
        setattr(cls, "EGFR Antagonist Hemay022",
                PermissibleValue(text="EGFR Antagonist Hemay022") )
        setattr(cls, "Modified Vaccinia Ankara-vectored HPV16/18 Vaccine JNJ-65195208",
                PermissibleValue(text="Modified Vaccinia Ankara-vectored HPV16/18 Vaccine JNJ-65195208") )
        setattr(cls, "Autologous Anti-EGFR CAR-transduced CXCR 5-modified T-lymphocytes",
                PermissibleValue(text="Autologous Anti-EGFR CAR-transduced CXCR 5-modified T-lymphocytes") )
        setattr(cls, "BET Inhibitor GSK2820151",
                PermissibleValue(text="BET Inhibitor GSK2820151") )
        setattr(cls, "Autologous Anti-PSMA CAR-T Cells P-PSMA-101",
                PermissibleValue(text="Autologous Anti-PSMA CAR-T Cells P-PSMA-101") )
        setattr(cls, "Autologous CD22-4SCAR-expressing T-cells 4SCAR22",
                PermissibleValue(text="Autologous CD22-4SCAR-expressing T-cells 4SCAR22") )
        setattr(cls, "Phosphaplatin PT-112",
                PermissibleValue(text="Phosphaplatin PT-112") )
        setattr(cls, "Autologous LMP1/LMP2/EBNA1-specific HLA-A02:01/24:02/11:01-restricted TCR-expressing T-lymphocytes YT-E001",
                PermissibleValue(text="Autologous LMP1/LMP2/EBNA1-specific HLA-A02:01/24:02/11:01-restricted TCR-expressing T-lymphocytes YT-E001") )
        setattr(cls, "DNMT1 Inhibitor NTX-301",
                PermissibleValue(text="DNMT1 Inhibitor NTX-301") )
        setattr(cls, "Angiogenesis Inhibitor JI-101",
                PermissibleValue(text="Angiogenesis Inhibitor JI-101") )
        setattr(cls, "L-methylfolate",
                PermissibleValue(text="L-methylfolate") )
        setattr(cls, "Mutant IDH1 Inhibitor DS-1001",
                PermissibleValue(text="Mutant IDH1 Inhibitor DS-1001") )
        setattr(cls, "Multikinase Inhibitor 4SC-203",
                PermissibleValue(text="Multikinase Inhibitor 4SC-203") )
        setattr(cls, "LMP-2:419-427 Peptide Vaccine",
                PermissibleValue(text="LMP-2:419-427 Peptide Vaccine") )
        setattr(cls, "FGFR1/2/3 Inhibitor HMPL-453",
                PermissibleValue(text="FGFR1/2/3 Inhibitor HMPL-453") )
        setattr(cls, "Gataparsen Sodium",
                PermissibleValue(text="Gataparsen Sodium") )
        setattr(cls, "Recombinant Erwinia asparaginase JZP-458",
                PermissibleValue(text="Recombinant Erwinia asparaginase JZP-458") )
        setattr(cls, "MetAP2 Inhibitor APL-1202",
                PermissibleValue(text="MetAP2 Inhibitor APL-1202") )
        setattr(cls, "Irradiated Allogeneic Human Lung Cancer Cells Expressing OX40L-Ig Vaccine HS-130",
                PermissibleValue(text="Irradiated Allogeneic Human Lung Cancer Cells Expressing OX40L-Ig Vaccine HS-130") )
        setattr(cls, "Antibody-drug Conjugate SC-007",
                PermissibleValue(text="Antibody-drug Conjugate SC-007") )
        setattr(cls, "Ansamitomicin P-3",
                PermissibleValue(text="Ansamitomicin P-3") )
        setattr(cls, "MET Tyrosine Kinase Inhibitor BMS-777607",
                PermissibleValue(text="MET Tyrosine Kinase Inhibitor BMS-777607") )
        setattr(cls, "Axl/Mer Inhibitor PF-07265807",
                PermissibleValue(text="Axl/Mer Inhibitor PF-07265807") )
        setattr(cls, "Huang Lian",
                PermissibleValue(text="Huang Lian") )
        setattr(cls, "ATR Inhibitor RP-3500",
                PermissibleValue(text="ATR Inhibitor RP-3500") )
        setattr(cls, "Peptide 946-Tetanus Peptide Conjugate Melanoma Vaccine",
                PermissibleValue(text="Peptide 946-Tetanus Peptide Conjugate Melanoma Vaccine") )
        setattr(cls, "Tezacitabine Anhydrous",
                PermissibleValue(text="Tezacitabine Anhydrous") )
        setattr(cls, "Daratumumab and Hyaluronidase-fihj",
                PermissibleValue(text="Daratumumab and Hyaluronidase-fihj") )
        setattr(cls, "cis-Urocanic Acid",
                PermissibleValue(text="cis-Urocanic Acid") )
        setattr(cls, "Tubulin Inhibitor ALB 109564 Dihydrochloride",
                PermissibleValue(text="Tubulin Inhibitor ALB 109564 Dihydrochloride") )
        setattr(cls, "TIGIT-targeting Agent MK-7684",
                PermissibleValue(text="TIGIT-targeting Agent MK-7684") )
        setattr(cls, "Anti-CD40 Monoclonal Antibody Chi Lob 7/4",
                PermissibleValue(text="Anti-CD40 Monoclonal Antibody Chi Lob 7/4") )
        setattr(cls, "Lyso-Thermosensitive Liposome Doxorubicin",
                PermissibleValue(text="Lyso-Thermosensitive Liposome Doxorubicin") )
        setattr(cls, "OxPhos Inhibitor VLX600",
                PermissibleValue(text="OxPhos Inhibitor VLX600") )
        setattr(cls, "Anti-CD20 Monoclonal Antibody TL011",
                PermissibleValue(text="Anti-CD20 Monoclonal Antibody TL011") )
        setattr(cls, "DNA-dependent Protein Kinase Inhibitor VX-984",
                PermissibleValue(text="DNA-dependent Protein Kinase Inhibitor VX-984") )
        setattr(cls, "Liposomal Vinorelbine",
                PermissibleValue(text="Liposomal Vinorelbine") )
        setattr(cls, "Vector-peptide Conjugated Paclitaxel",
                PermissibleValue(text="Vector-peptide Conjugated Paclitaxel") )
        setattr(cls, "PVA Microporous Hydrospheres/Doxorubicin Hydrochloride",
                PermissibleValue(text="PVA Microporous Hydrospheres/Doxorubicin Hydrochloride") )
        setattr(cls, "8-Azaguanine",
                PermissibleValue(text="8-Azaguanine") )
        setattr(cls, "MAT2A Inhibitor AG-270",
                PermissibleValue(text="MAT2A Inhibitor AG-270") )
        setattr(cls, "Cofetuzumab Pelidotin",
                PermissibleValue(text="Cofetuzumab Pelidotin") )
        setattr(cls, "HCV DNA Vaccine INO-8000",
                PermissibleValue(text="HCV DNA Vaccine INO-8000") )
        setattr(cls, "PI3K-delta Inhibitor YY-20394",
                PermissibleValue(text="PI3K-delta Inhibitor YY-20394") )
        setattr(cls, "A2A Receptor Antagonist EOS100850",
                PermissibleValue(text="A2A Receptor Antagonist EOS100850") )
        setattr(cls, "Renal Cell Carcinoma Peptides Vaccine IMA901",
                PermissibleValue(text="Renal Cell Carcinoma Peptides Vaccine IMA901") )
        setattr(cls, "Autologous Genetically-modified MAGE-A4 C1032 CD8alpha T Cells",
                PermissibleValue(text="Autologous Genetically-modified MAGE-A4 C1032 CD8alpha T Cells") )
        setattr(cls, "Protein Kinase C Inhibitor IDE196",
                PermissibleValue(text="Protein Kinase C Inhibitor IDE196") )
        setattr(cls, "Androgen Receptor Antagonist SHR3680",
                PermissibleValue(text="Androgen Receptor Antagonist SHR3680") )
        setattr(cls, "Cabozantinib S-malate",
                PermissibleValue(text="Cabozantinib S-malate") )
        setattr(cls, "Bruceanol F",
                PermissibleValue(text="Bruceanol F") )
        setattr(cls, "Anti-CTLA-4 Monoclonal Antibody REGN4659",
                PermissibleValue(text="Anti-CTLA-4 Monoclonal Antibody REGN4659") )
        setattr(cls, "Recombinant Super-compound Interferon",
                PermissibleValue(text="Recombinant Super-compound Interferon") )
        setattr(cls, "Topoisomerase I Inhibitor LMP776",
                PermissibleValue(text="Topoisomerase I Inhibitor LMP776") )
        setattr(cls, "Oncolytic Measles Virus Encoding Helicobacter pylori Neutrophil-activating Protein",
                PermissibleValue(text="Oncolytic Measles Virus Encoding Helicobacter pylori Neutrophil-activating Protein") )
        setattr(cls, "Hu14.18-IL2 Fusion Protein EMD 273063",
                PermissibleValue(text="Hu14.18-IL2 Fusion Protein EMD 273063") )
        setattr(cls, "Anti-HER2/MMAE Antibody-drug Conjugate MRG002",
                PermissibleValue(text="Anti-HER2/MMAE Antibody-drug Conjugate MRG002") )
        setattr(cls, "Pamidronic Acid",
                PermissibleValue(text="Pamidronic Acid") )
        setattr(cls, "Antibody-drug Conjugate SC-005",
                PermissibleValue(text="Antibody-drug Conjugate SC-005") )
        setattr(cls, "Anti-TF Monoclonal Antibody ALT-836",
                PermissibleValue(text="Anti-TF Monoclonal Antibody ALT-836") )
        setattr(cls, "Nanoscale Coordination Polymer Nanoparticles CPI-100",
                PermissibleValue(text="Nanoscale Coordination Polymer Nanoparticles CPI-100") )
        setattr(cls, "Epitinib Succinate",
                PermissibleValue(text="Epitinib Succinate") )
        setattr(cls, "Folate Receptor-Targeted Vinca Alkaloid EC0489",
                PermissibleValue(text="Folate Receptor-Targeted Vinca Alkaloid EC0489") )
        setattr(cls, "CHK1 Inhibitor PF-477736",
                PermissibleValue(text="CHK1 Inhibitor PF-477736") )
        setattr(cls, "TGFbeta Inhibitor LY3200882",
                PermissibleValue(text="TGFbeta Inhibitor LY3200882") )
        setattr(cls, "Imidazole Mustard",
                PermissibleValue(text="Imidazole Mustard") )
        setattr(cls, "Hsp90 Inhibitor SNX-5422 Mesylate",
                PermissibleValue(text="Hsp90 Inhibitor SNX-5422 Mesylate") )
        setattr(cls, "Allogeneic Melanoma Vaccine AGI-101H",
                PermissibleValue(text="Allogeneic Melanoma Vaccine AGI-101H") )
        setattr(cls, "Phosphorus P-32",
                PermissibleValue(text="Phosphorus P-32") )
        setattr(cls, "Magnesium Valproate",
                PermissibleValue(text="Magnesium Valproate") )
        setattr(cls, "Vaccinium myrtillus/Macleaya cordata/Echinacea angustifolia Extract Granules",
                PermissibleValue(text="Vaccinium myrtillus/Macleaya cordata/Echinacea angustifolia Extract Granules") )
        setattr(cls, "Oncolytic HSV-1 Expressing IL-12 and Anti-PD-1 Antibody T3011",
                PermissibleValue(text="Oncolytic HSV-1 Expressing IL-12 and Anti-PD-1 Antibody T3011") )
        setattr(cls, "Inotuzumab Ozogamicin",
                PermissibleValue(text="Inotuzumab Ozogamicin") )
        setattr(cls, "Azintuxizumab Vedotin",
                PermissibleValue(text="Azintuxizumab Vedotin") )
        setattr(cls, "Lutetium Lu 177 Dotatate",
                PermissibleValue(text="Lutetium Lu 177 Dotatate") )
        setattr(cls, "Autologous Anti-CD19 T-cell Receptor T cells ET190L1",
                PermissibleValue(text="Autologous Anti-CD19 T-cell Receptor T cells ET190L1") )
        setattr(cls, "Anti-CD73 Monoclonal Antibody CPI-006",
                PermissibleValue(text="Anti-CD73 Monoclonal Antibody CPI-006") )
        setattr(cls, "Anti-PD-1/Anti-PD-L1 Bispecific Antibody LY3434172",
                PermissibleValue(text="Anti-PD-1/Anti-PD-L1 Bispecific Antibody LY3434172") )
        setattr(cls, "EGFR/HER2 Inhibitor AP32788",
                PermissibleValue(text="EGFR/HER2 Inhibitor AP32788") )
        setattr(cls, "SR-BP1/HSI Inhibitor SR31747A",
                PermissibleValue(text="SR-BP1/HSI Inhibitor SR31747A") )
        setattr(cls, "Anti-LGR5 Monoclonal Antibody BNC101",
                PermissibleValue(text="Anti-LGR5 Monoclonal Antibody BNC101") )
        setattr(cls, "Mixed Bacteria Vaccine",
                PermissibleValue(text="Mixed Bacteria Vaccine") )
        setattr(cls, "Ancitabine Hydrochloride",
                PermissibleValue(text="Ancitabine Hydrochloride") )
        setattr(cls, "siG12D LODER",
                PermissibleValue(text="siG12D LODER") )
        setattr(cls, "Attenuated Live Listeria Encoding HPV 16 E7 Vaccine ADXS11-001",
                PermissibleValue(text="Attenuated Live Listeria Encoding HPV 16 E7 Vaccine ADXS11-001") )
        setattr(cls, "Fludarabine Phosphate",
                PermissibleValue(text="Fludarabine Phosphate") )
        setattr(cls, "Prostate Cancer Vaccine ONY-P1",
                PermissibleValue(text="Prostate Cancer Vaccine ONY-P1") )
        setattr(cls, "Opolimogene Capmilisbac",
                PermissibleValue(text="Opolimogene Capmilisbac") )
        setattr(cls, "MALT1 Inhibitor JNJ-67856633",
                PermissibleValue(text="MALT1 Inhibitor JNJ-67856633") )
        setattr(cls, "S1P Receptor Agonist KRP203",
                PermissibleValue(text="S1P Receptor Agonist KRP203") )
        setattr(cls, "Nicotinamide Riboside",
                PermissibleValue(text="Nicotinamide Riboside") )
        setattr(cls, "Peptide 946 Melanoma Vaccine",
                PermissibleValue(text="Peptide 946 Melanoma Vaccine") )
        setattr(cls, "DNA Plasmid-encoding Interleukin-12 INO-9012/PSA/PSMA DNA Plasmids INO-5150 Formulation INO-5151",
                PermissibleValue(text="DNA Plasmid-encoding Interleukin-12 INO-9012/PSA/PSMA DNA Plasmids INO-5150 Formulation INO-5151") )
        setattr(cls, "Chimeric Monoclonal Antibody 81C6",
                PermissibleValue(text="Chimeric Monoclonal Antibody 81C6") )
        setattr(cls, "Pan-Mutant-IDH1 Inhibitor Bay-1436032",
                PermissibleValue(text="Pan-Mutant-IDH1 Inhibitor Bay-1436032") )
        setattr(cls, "Methotrexate-E Therapeutic Implant",
                PermissibleValue(text="Methotrexate-E Therapeutic Implant") )
        setattr(cls, "Cetuximab-loaded Ethylcellulose Polymeric Nanoparticles Decorated with Octreotide (SY)",
                PermissibleValue(text="Cetuximab-loaded Ethylcellulose Polymeric Nanoparticles Decorated with Octreotide (SY)") )
        setattr(cls, "FAP/4-1BB-targeting Fusion Protein RO7122290",
                PermissibleValue(text="FAP/4-1BB-targeting Fusion Protein RO7122290") )
        setattr(cls, "CDK Inhibitor SNS-032",
                PermissibleValue(text="CDK Inhibitor SNS-032") )
        setattr(cls, "Anti-LAG3 Monoclonal Antibody MK-4280",
                PermissibleValue(text="Anti-LAG3 Monoclonal Antibody MK-4280") )
        setattr(cls, "EGFR Mutant-specific Inhibitor CK-101",
                PermissibleValue(text="EGFR Mutant-specific Inhibitor CK-101") )
        setattr(cls, "EZH1/2 Inhibitor HH2853",
                PermissibleValue(text="EZH1/2 Inhibitor HH2853") )
        setattr(cls, "CYP17/Androgen Receptor Inhibitor ODM 204",
                PermissibleValue(text="CYP17/Androgen Receptor Inhibitor ODM 204") )
        setattr(cls, "FGFR4 Inhibitor H3B-6527",
                PermissibleValue(text="FGFR4 Inhibitor H3B-6527") )
        setattr(cls, "ERK Inhibitor LTT462",
                PermissibleValue(text="ERK Inhibitor LTT462") )
        setattr(cls, "PI3K-gamma Inhibitor IPI-549",
                PermissibleValue(text="PI3K-gamma Inhibitor IPI-549") )
        setattr(cls, "Monoclonal Antibody CAL",
                PermissibleValue(text="Monoclonal Antibody CAL") )
        setattr(cls, "Anti-MUC17/CD3 BiTE Antibody AMG 199",
                PermissibleValue(text="Anti-MUC17/CD3 BiTE Antibody AMG 199") )
        setattr(cls, "PI3K Inhibitor GSK1059615",
                PermissibleValue(text="PI3K Inhibitor GSK1059615") )
        setattr(cls, "Acridine Carboxamide",
                PermissibleValue(text="Acridine Carboxamide") )
        setattr(cls, "Autologous Anti-CD19 CAR T-cells 19(T2)28z1xx",
                PermissibleValue(text="Autologous Anti-CD19 CAR T-cells 19(T2)28z1xx") )
        setattr(cls, "Aryl Hydrocarbon Receptor Inhibitor IK-175",
                PermissibleValue(text="Aryl Hydrocarbon Receptor Inhibitor IK-175") )
        setattr(cls, "Anti-PD-L1 Monoclonal Antibody SHR-1316",
                PermissibleValue(text="Anti-PD-L1 Monoclonal Antibody SHR-1316") )
        setattr(cls, "Carubicin Hydrochloride",
                PermissibleValue(text="Carubicin Hydrochloride") )
        setattr(cls, "Antrodia cinnamomea Supplement",
                PermissibleValue(text="Antrodia cinnamomea Supplement") )
        setattr(cls, "TRK Inhibitor TQB3558",
                PermissibleValue(text="TRK Inhibitor TQB3558") )
        setattr(cls, "Recombinant Oncolytic Poliovirus PVS-RIPO",
                PermissibleValue(text="Recombinant Oncolytic Poliovirus PVS-RIPO") )
        setattr(cls, "Dopamine-Somatostatin Chimeric Molecule BIM-23A760",
                PermissibleValue(text="Dopamine-Somatostatin Chimeric Molecule BIM-23A760") )
        setattr(cls, "Sparfosate Sodium",
                PermissibleValue(text="Sparfosate Sodium") )
        setattr(cls, "BR96-Doxorubicin Immunoconjugate",
                PermissibleValue(text="BR96-Doxorubicin Immunoconjugate") )
        setattr(cls, "Prostaglandin E2 EP4 Receptor Inhibitor AN0025",
                PermissibleValue(text="Prostaglandin E2 EP4 Receptor Inhibitor AN0025") )
        setattr(cls, "Anti-FCRH5/CD3 BiTE Antibody BFCR4350A",
                PermissibleValue(text="Anti-FCRH5/CD3 BiTE Antibody BFCR4350A") )
        setattr(cls, "HDAC inhibitor CG200745",
                PermissibleValue(text="HDAC inhibitor CG200745") )
        setattr(cls, "Vocimagene Amiretrorepvec",
                PermissibleValue(text="Vocimagene Amiretrorepvec") )
        setattr(cls, "SNS01-T Nanoparticles",
                PermissibleValue(text="SNS01-T Nanoparticles") )
        setattr(cls, "Immunoconjugate RO5479599",
                PermissibleValue(text="Immunoconjugate RO5479599") )
        setattr(cls, "Anti-CTLA-4/LAG-3 Bispecific Antibody XmAb22841",
                PermissibleValue(text="Anti-CTLA-4/LAG-3 Bispecific Antibody XmAb22841") )
        setattr(cls, "TLR Agonist BSG-001",
                PermissibleValue(text="TLR Agonist BSG-001") )
        setattr(cls, "Enfortumab Vedotin",
                PermissibleValue(text="Enfortumab Vedotin") )
        setattr(cls, "PI3K Inhibitor WX-037",
                PermissibleValue(text="PI3K Inhibitor WX-037") )
        setattr(cls, "Ziv-Aflibercept",
                PermissibleValue(text="Ziv-Aflibercept") )
        setattr(cls, "Anti-EGFR/c-Met Bispecific Antibody JNJ-61186372",
                PermissibleValue(text="Anti-EGFR/c-Met Bispecific Antibody JNJ-61186372") )
        setattr(cls, "Porcupine Inhibitor WNT974",
                PermissibleValue(text="Porcupine Inhibitor WNT974") )
        setattr(cls, "Antigen-presenting Cells-expressing HPV16 E6/E7 SQZ-PBMC-HPV",
                PermissibleValue(text="Antigen-presenting Cells-expressing HPV16 E6/E7 SQZ-PBMC-HPV") )
        setattr(cls, "Phospholipid Ether-drug Conjugate CLR 131",
                PermissibleValue(text="Phospholipid Ether-drug Conjugate CLR 131") )
        setattr(cls, "Beta-elemene",
                PermissibleValue(text="Beta-elemene") )
        setattr(cls, "Glutathione Pegylated Liposomal Doxorubicin Hydrochloride Formulation 2B3-101",
                PermissibleValue(text="Glutathione Pegylated Liposomal Doxorubicin Hydrochloride Formulation 2B3-101") )
        setattr(cls, "Anti-CD38 Antibody-drug Conjugate STI-6129",
                PermissibleValue(text="Anti-CD38 Antibody-drug Conjugate STI-6129") )
        setattr(cls, "Liposome-encapsulated OSI-7904",
                PermissibleValue(text="Liposome-encapsulated OSI-7904") )
        setattr(cls, "Cold Contaminant-free Iobenguane I-131",
                PermissibleValue(text="Cold Contaminant-free Iobenguane I-131") )
        setattr(cls, "I 131 Monoclonal Antibody A33",
                PermissibleValue(text="I 131 Monoclonal Antibody A33") )
        setattr(cls, "Beta-Glucan",
                PermissibleValue(text="Beta-Glucan") )
        setattr(cls, "STING Agonist BMS-986301",
                PermissibleValue(text="STING Agonist BMS-986301") )
        setattr(cls, "NA17.A2 Peptide Vaccine",
                PermissibleValue(text="NA17.A2 Peptide Vaccine") )
        setattr(cls, "Allogeneic CD22-specific Universal CAR-expressing T-lymphocytes UCART22",
                PermissibleValue(text="Allogeneic CD22-specific Universal CAR-expressing T-lymphocytes UCART22") )
        setattr(cls, "Alpha-tocopheryloxyacetic Acid",
                PermissibleValue(text="Alpha-tocopheryloxyacetic Acid") )
        setattr(cls, "Autologous TCRm-expressing T-cells ET140203",
                PermissibleValue(text="Autologous TCRm-expressing T-cells ET140203") )
        setattr(cls, "Enadenotucirev-expressing Anti-CD40 Agonistic Monoclonal Antibody NG-350A",
                PermissibleValue(text="Enadenotucirev-expressing Anti-CD40 Agonistic Monoclonal Antibody NG-350A") )
        setattr(cls, "Multikinase Inhibitor AT9283",
                PermissibleValue(text="Multikinase Inhibitor AT9283") )
        setattr(cls, "Anti-Glypican 3/CD3 Bispecific Antibody ERY974",
                PermissibleValue(text="Anti-Glypican 3/CD3 Bispecific Antibody ERY974") )
        setattr(cls, "Anti-PD-1/Anti-LAG-3 DART Protein MGD013",
                PermissibleValue(text="Anti-PD-1/Anti-LAG-3 DART Protein MGD013") )
        setattr(cls, "Antisense Oligonucleotide GTI-2040",
                PermissibleValue(text="Antisense Oligonucleotide GTI-2040") )
        setattr(cls, "PH20 Hyaluronidase-expressing Adenovirus VCN-01",
                PermissibleValue(text="PH20 Hyaluronidase-expressing Adenovirus VCN-01") )
        setattr(cls, "Anti-CD3 Immunotoxin A-dmDT390-bisFv(UCHT1)",
                PermissibleValue(text="Anti-CD3 Immunotoxin A-dmDT390-bisFv(UCHT1)") )
        setattr(cls, "Anti-PD-1 Monoclonal Antibody TSR-042",
                PermissibleValue(text="Anti-PD-1 Monoclonal Antibody TSR-042") )
        setattr(cls, "Anti-APRIL Monoclonal Antibody BION-1301",
                PermissibleValue(text="Anti-APRIL Monoclonal Antibody BION-1301") )
        setattr(cls, "Gusperimus Trihydrochloride",
                PermissibleValue(text="Gusperimus Trihydrochloride") )
        setattr(cls, "Blueberry Powder Supplement",
                PermissibleValue(text="Blueberry Powder Supplement") )
        setattr(cls, "Monoclonal Antibody 4B5 Anti-Idiotype Vaccine",
                PermissibleValue(text="Monoclonal Antibody 4B5 Anti-Idiotype Vaccine") )
        setattr(cls, "Epipodophyllotoxin Analog GL331",
                PermissibleValue(text="Epipodophyllotoxin Analog GL331") )
        setattr(cls, "Anti-Ganglioside GM2 Monoclonal Antibody BIW-8962",
                PermissibleValue(text="Anti-Ganglioside GM2 Monoclonal Antibody BIW-8962") )
        setattr(cls, "Simalikalactone D",
                PermissibleValue(text="Simalikalactone D") )
        setattr(cls, "Pegylated Liposomal Mitomycin C Lipid-based Prodrug",
                PermissibleValue(text="Pegylated Liposomal Mitomycin C Lipid-based Prodrug") )
        setattr(cls, "VEGFR Inhibitor KRN951",
                PermissibleValue(text="VEGFR Inhibitor KRN951") )
        setattr(cls, "SERD ZN-c5",
                PermissibleValue(text="SERD ZN-c5") )
        setattr(cls, "Submicron Particle Paclitaxel Sterile Suspension",
                PermissibleValue(text="Submicron Particle Paclitaxel Sterile Suspension") )
        setattr(cls, "Taurultam Analogue GP-2250",
                PermissibleValue(text="Taurultam Analogue GP-2250") )
        setattr(cls, "IDH1 Mutant Inhibitor LY3410738",
                PermissibleValue(text="IDH1 Mutant Inhibitor LY3410738") )
        setattr(cls, "Anti-CD44 Monoclonal Antibody RO5429083",
                PermissibleValue(text="Anti-CD44 Monoclonal Antibody RO5429083") )
        setattr(cls, "Topical Fluorouracil",
                PermissibleValue(text="Topical Fluorouracil") )
        setattr(cls, "N-(5-tert-butyl-3-isoxazolyl)-N-(4-(4-pyridinyl)oxyphenyl) Urea",
                PermissibleValue(text="N-(5-tert-butyl-3-isoxazolyl)-N-(4-(4-pyridinyl)oxyphenyl) Urea") )
        setattr(cls, "Pegylated Liposomal Irinotecan",
                PermissibleValue(text="Pegylated Liposomal Irinotecan") )
        setattr(cls, "Anti-CCR7 Antibody-drug Conjugate JBH492",
                PermissibleValue(text="Anti-CCR7 Antibody-drug Conjugate JBH492") )
        setattr(cls, "Anti-HGF Monoclonal Antibody TAK-701",
                PermissibleValue(text="Anti-HGF Monoclonal Antibody TAK-701") )
        setattr(cls, "Anhydrous Enol-oxaloacetate",
                PermissibleValue(text="Anhydrous Enol-oxaloacetate") )
        setattr(cls, "Yttrium Y 90 Resin Microspheres",
                PermissibleValue(text="Yttrium Y 90 Resin Microspheres") )
        setattr(cls, "Lurtotecan Liposome",
                PermissibleValue(text="Lurtotecan Liposome") )
        setattr(cls, "Anti-CEA/Anti-HSG Bispecific Monoclonal Antibody TF2",
                PermissibleValue(text="Anti-CEA/Anti-HSG Bispecific Monoclonal Antibody TF2") )
        setattr(cls, "Y 90 Monoclonal Antibody Lym-1",
                PermissibleValue(text="Y 90 Monoclonal Antibody Lym-1") )
        setattr(cls, "Anti-HER2-DM1 ADC B003",
                PermissibleValue(text="Anti-HER2-DM1 ADC B003") )
        setattr(cls, "JAK2 Inhibitor XL019",
                PermissibleValue(text="JAK2 Inhibitor XL019") )
        setattr(cls, "Trastuzumab/Tesirine Antibody-drug Conjugate ADCT-502",
                PermissibleValue(text="Trastuzumab/Tesirine Antibody-drug Conjugate ADCT-502") )
        setattr(cls, "Peplomycin Sulfate",
                PermissibleValue(text="Peplomycin Sulfate") )
        setattr(cls, "Fluorine F 18 Ara-G",
                PermissibleValue(text="Fluorine F 18 Ara-G") )
        setattr(cls, "Anti-CD38-targeted IgG4-attenuated IFNa TAK-573",
                PermissibleValue(text="Anti-CD38-targeted IgG4-attenuated IFNa TAK-573") )
        setattr(cls, "Topoisomerase-II-beta Inhibitor Racemic XK469",
                PermissibleValue(text="Topoisomerase-II-beta Inhibitor Racemic XK469") )
        setattr(cls, "Hedgehog Inhibitor IPI-609",
                PermissibleValue(text="Hedgehog Inhibitor IPI-609") )
        setattr(cls, "Doxorubicin Prodrug/Prodrug-activating Biomaterial SQ3370",
                PermissibleValue(text="Doxorubicin Prodrug/Prodrug-activating Biomaterial SQ3370") )
        setattr(cls, "Brachyury-expressing Yeast Vaccine GI-6301",
                PermissibleValue(text="Brachyury-expressing Yeast Vaccine GI-6301") )
        setattr(cls, "Pan-IDH Mutant Inhibitor AG-881",
                PermissibleValue(text="Pan-IDH Mutant Inhibitor AG-881") )
        setattr(cls, "Mechlorethamine Hydrochloride",
                PermissibleValue(text="Mechlorethamine Hydrochloride") )
        setattr(cls, "MDM2/MDMX Inhibitor ALRN-6924",
                PermissibleValue(text="MDM2/MDMX Inhibitor ALRN-6924") )
        setattr(cls, "Anti-5T4 Antibody-drug Conjugate SYD1875",
                PermissibleValue(text="Anti-5T4 Antibody-drug Conjugate SYD1875") )
        setattr(cls, "DACH Polymer Platinate AP5346",
                PermissibleValue(text="DACH Polymer Platinate AP5346") )
        setattr(cls, "STING-expressing E. coli SYNB1891",
                PermissibleValue(text="STING-expressing E. coli SYNB1891") )
        setattr(cls, "Autologous HPV16 E7-specific HLA-A*02:01-restricted TCR Gene Engineered Lymphocytes KITE-439",
                PermissibleValue(text="Autologous HPV16 E7-specific HLA-A*02:01-restricted TCR Gene Engineered Lymphocytes KITE-439") )
        setattr(cls, "Coltuximab Ravtansine",
                PermissibleValue(text="Coltuximab Ravtansine") )
        setattr(cls, "RET/SRC Inhibitor TPX-0046",
                PermissibleValue(text="RET/SRC Inhibitor TPX-0046") )
        setattr(cls, "Triciribine Phosphate",
                PermissibleValue(text="Triciribine Phosphate") )
        setattr(cls, "Microparticle-encapsulated CYP1B1-encoding DNA Vaccine ZYC300",
                PermissibleValue(text="Microparticle-encapsulated CYP1B1-encoding DNA Vaccine ZYC300") )
        setattr(cls, "Autologous Bispecific CD19/CD22-targeted CAR-T Cells GC022",
                PermissibleValue(text="Autologous Bispecific CD19/CD22-targeted CAR-T Cells GC022") )
        setattr(cls, "Mitoxantrone Hydrochloride",
                PermissibleValue(text="Mitoxantrone Hydrochloride") )
        setattr(cls, "Monoclonal Antibody A27.15",
                PermissibleValue(text="Monoclonal Antibody A27.15") )
        setattr(cls, "I 131 Monoclonal Antibody Lym-1",
                PermissibleValue(text="I 131 Monoclonal Antibody Lym-1") )
        setattr(cls, "Ursolic Acid",
                PermissibleValue(text="Ursolic Acid") )
        setattr(cls, "Oncolytic HSV-1 rQNestin34.5v.2",
                PermissibleValue(text="Oncolytic HSV-1 rQNestin34.5v.2") )
        setattr(cls, "Palladium Pd-103",
                PermissibleValue(text="Palladium Pd-103") )
        setattr(cls, "Anti-PD-L1/CD137 Bispecific Antibody MCLA-145",
                PermissibleValue(text="Anti-PD-L1/CD137 Bispecific Antibody MCLA-145") )
        setattr(cls, "Anti-Lewis B/Lewis Y Monoclonal Antibody GNX102",
                PermissibleValue(text="Anti-Lewis B/Lewis Y Monoclonal Antibody GNX102") )
        setattr(cls, "Iodine I 131 Monoclonal Antibody BC8",
                PermissibleValue(text="Iodine I 131 Monoclonal Antibody BC8") )
        setattr(cls, "Radix Angelicae Sinensis/Radix Astragali Herbal Supplement",
                PermissibleValue(text="Radix Angelicae Sinensis/Radix Astragali Herbal Supplement") )
        setattr(cls, "LMP-2:340-349 Peptide Vaccine",
                PermissibleValue(text="LMP-2:340-349 Peptide Vaccine") )
        setattr(cls, "Anti-A33 Monoclonal Antibody KRN330",
                PermissibleValue(text="Anti-A33 Monoclonal Antibody KRN330") )
        setattr(cls, "PEG-PEI-cholesterol Lipopolymer-encased IL-12 DNA Plasmid Vector GEN-1",
                PermissibleValue(text="PEG-PEI-cholesterol Lipopolymer-encased IL-12 DNA Plasmid Vector GEN-1") )
        setattr(cls, "Sitimagene Ceradenovec",
                PermissibleValue(text="Sitimagene Ceradenovec") )
        setattr(cls, "Anti-PD-1 Monoclonal Antibody LZM009",
                PermissibleValue(text="Anti-PD-1 Monoclonal Antibody LZM009") )
        setattr(cls, "Carmustine Implant",
                PermissibleValue(text="Carmustine Implant") )
        setattr(cls, "Allovectin-7",
                PermissibleValue(text="Allovectin-7") )
        setattr(cls, "Telomerase Inhibitor FJ5002",
                PermissibleValue(text="Telomerase Inhibitor FJ5002") )
        setattr(cls, "Recombinant Human 6Ckine",
                PermissibleValue(text="Recombinant Human 6Ckine") )
        setattr(cls, "Topotecan Hydrochloride Liposomes",
                PermissibleValue(text="Topotecan Hydrochloride Liposomes") )
        setattr(cls, "Cryptophycin 52",
                PermissibleValue(text="Cryptophycin 52") )
        setattr(cls, "Phenytoin Sodium",
                PermissibleValue(text="Phenytoin Sodium") )
        setattr(cls, "Anti-ROR1/PNU-159682 Derivative Antibody-drug Conjugate NBE-002",
                PermissibleValue(text="Anti-ROR1/PNU-159682 Derivative Antibody-drug Conjugate NBE-002") )
        setattr(cls, "Enterococcus gallinarum Strain MRx0518",
                PermissibleValue(text="Enterococcus gallinarum Strain MRx0518") )
        setattr(cls, "Recombinant Bacterial Minicells VAX014",
                PermissibleValue(text="Recombinant Bacterial Minicells VAX014") )
        setattr(cls, "VEGFR/PDGFR Tyrosine Kinase Inhibitor TAK-593",
                PermissibleValue(text="VEGFR/PDGFR Tyrosine Kinase Inhibitor TAK-593") )
        setattr(cls, "Dovitinib Lactate",
                PermissibleValue(text="Dovitinib Lactate") )
        setattr(cls, "I 131 Antiferritin Immunoglobulin",
                PermissibleValue(text="I 131 Antiferritin Immunoglobulin") )
        setattr(cls, "Bromocriptine Mesylate",
                PermissibleValue(text="Bromocriptine Mesylate") )
        setattr(cls, "Vaccine-Sensitized Draining Lymph Node Cells",
                PermissibleValue(text="Vaccine-Sensitized Draining Lymph Node Cells") )
        setattr(cls, "CDK4/6 Inhibitor SHR6390",
                PermissibleValue(text="CDK4/6 Inhibitor SHR6390") )
        setattr(cls, "EGFR Mutant-specific Inhibitor D-0316",
                PermissibleValue(text="EGFR Mutant-specific Inhibitor D-0316") )
        setattr(cls, "Monoclonal Antibody TRK-950",
                PermissibleValue(text="Monoclonal Antibody TRK-950") )
        setattr(cls, "Notch Signaling Pathway Inhibitor MK0752",
                PermissibleValue(text="Notch Signaling Pathway Inhibitor MK0752") )
        setattr(cls, "Anti-CD40 Agonist Monoclonal Antibody ABBV-927",
                PermissibleValue(text="Anti-CD40 Agonist Monoclonal Antibody ABBV-927") )
        setattr(cls, "Vinorelbine Tartrate",
                PermissibleValue(text="Vinorelbine Tartrate") )
        setattr(cls, "p53-HDM2 Protein-protein Interaction Inhibitor APG-115",
                PermissibleValue(text="p53-HDM2 Protein-protein Interaction Inhibitor APG-115") )
        setattr(cls, "Lutetium Lu 177 Anti-CA19-9 Monoclonal Antibody 5B1",
                PermissibleValue(text="Lutetium Lu 177 Anti-CA19-9 Monoclonal Antibody 5B1") )
        setattr(cls, "EGFR/HER2 Inhibitor DZD9008",
                PermissibleValue(text="EGFR/HER2 Inhibitor DZD9008") )
        setattr(cls, "Bivalent BRD4 Inhibitor AZD5153",
                PermissibleValue(text="Bivalent BRD4 Inhibitor AZD5153") )
        setattr(cls, "BRAF/EGFR Inhibitor BGB-283",
                PermissibleValue(text="BRAF/EGFR Inhibitor BGB-283") )
        setattr(cls, "PRMT1 Inhibitor GSK3368715",
                PermissibleValue(text="PRMT1 Inhibitor GSK3368715") )
        setattr(cls, "Sotrastaurin Acetate",
                PermissibleValue(text="Sotrastaurin Acetate") )
        setattr(cls, "Kunecatechins Ointment",
                PermissibleValue(text="Kunecatechins Ointment") )
        setattr(cls, "Anti-CD33 Monoclonal Antibody-DM4 Conjugate AVE9633",
                PermissibleValue(text="Anti-CD33 Monoclonal Antibody-DM4 Conjugate AVE9633") )
        setattr(cls, "Black Raspberry Nectar",
                PermissibleValue(text="Black Raspberry Nectar") )
        setattr(cls, "Oncolytic HSV-1 G207",
                PermissibleValue(text="Oncolytic HSV-1 G207") )
        setattr(cls, "IDO1 Inhibitor MK-7162",
                PermissibleValue(text="IDO1 Inhibitor MK-7162") )
        setattr(cls, "Short Chain Fatty Acid HQK-1004",
                PermissibleValue(text="Short Chain Fatty Acid HQK-1004") )
        setattr(cls, "Imipramine Blue",
                PermissibleValue(text="Imipramine Blue") )
        setattr(cls, "Astatine At 211 Anti-CD45 Monoclonal Antibody BC8-B10",
                PermissibleValue(text="Astatine At 211 Anti-CD45 Monoclonal Antibody BC8-B10") )
        setattr(cls, "cEt KRAS Antisense Oligonucleotide AZD4785",
                PermissibleValue(text="cEt KRAS Antisense Oligonucleotide AZD4785") )
        setattr(cls, "Cereblon E3 Ubiquitin Ligase Modulating Agent CC-99282",
                PermissibleValue(text="Cereblon E3 Ubiquitin Ligase Modulating Agent CC-99282") )
        setattr(cls, "Anti-HER2 Monoclonal Antibody/Anti-CD137Anticalin Bispecific Fusion Protein PRS-343",
                PermissibleValue(text="Anti-HER2 Monoclonal Antibody/Anti-CD137Anticalin Bispecific Fusion Protein PRS-343") )
        setattr(cls, "Glioblastoma Cancer Vaccine ERC1671",
                PermissibleValue(text="Glioblastoma Cancer Vaccine ERC1671") )
        setattr(cls, "DPX-E7 HPV Vaccine",
                PermissibleValue(text="DPX-E7 HPV Vaccine") )
        setattr(cls, "Liarozole Hydrochloride",
                PermissibleValue(text="Liarozole Hydrochloride") )
        setattr(cls, "Anti-CLEVER-1 Monoclonal Antibody FP-1305",
                PermissibleValue(text="Anti-CLEVER-1 Monoclonal Antibody FP-1305") )
        setattr(cls, "Pemetrexed Disodium",
                PermissibleValue(text="Pemetrexed Disodium") )
        setattr(cls, "Alpha Galactosylceramide",
                PermissibleValue(text="Alpha Galactosylceramide") )
        setattr(cls, "Esperamicin A1",
                PermissibleValue(text="Esperamicin A1") )
        setattr(cls, "3'-dA Phosphoramidate NUC-7738",
                PermissibleValue(text="3'-dA Phosphoramidate NUC-7738") )
        setattr(cls, "Gemtuzumab Ozogamicin",
                PermissibleValue(text="Gemtuzumab Ozogamicin") )
        setattr(cls, "Sodium Butyrate",
                PermissibleValue(text="Sodium Butyrate") )
        setattr(cls, "P-cadherin Inhibitor PCA062",
                PermissibleValue(text="P-cadherin Inhibitor PCA062") )
        setattr(cls, "Pol I Inhibitor CX5461",
                PermissibleValue(text="Pol I Inhibitor CX5461") )
        setattr(cls, "Pirarubicin Hydrochloride",
                PermissibleValue(text="Pirarubicin Hydrochloride") )
        setattr(cls, "Mps1 Inhibitor BAY 1217389",
                PermissibleValue(text="Mps1 Inhibitor BAY 1217389") )
        setattr(cls, "Glioma-associated Peptide-loaded Dendritic Cell Vaccine SL-701",
                PermissibleValue(text="Glioma-associated Peptide-loaded Dendritic Cell Vaccine SL-701") )
        setattr(cls, "Methionine Aminopeptidase 2 Inhibitor M8891",
                PermissibleValue(text="Methionine Aminopeptidase 2 Inhibitor M8891") )
        setattr(cls, "PSA/IL-2/GM-CSF Vaccine",
                PermissibleValue(text="PSA/IL-2/GM-CSF Vaccine") )
        setattr(cls, "Anti-HB-EGF Monoclonal Antibody KHK2866",
                PermissibleValue(text="Anti-HB-EGF Monoclonal Antibody KHK2866") )
        setattr(cls, "Anti-c-MET Monoclonal Antibody LY2875358",
                PermissibleValue(text="Anti-c-MET Monoclonal Antibody LY2875358") )
        setattr(cls, "Nimustine Hydrochloride",
                PermissibleValue(text="Nimustine Hydrochloride") )
        setattr(cls, "Interferon Alfa-N3",
                PermissibleValue(text="Interferon Alfa-N3") )
        setattr(cls, "HDAC Inhibitor CHR-2845",
                PermissibleValue(text="HDAC Inhibitor CHR-2845") )
        setattr(cls, "Anti-ILT4 Monoclonal Antibody MK-4830",
                PermissibleValue(text="Anti-ILT4 Monoclonal Antibody MK-4830") )
        setattr(cls, "Vitamin E Compound",
                PermissibleValue(text="Vitamin E Compound") )
        setattr(cls, "VLP-encapsulated TLR9 Agonist CMP-001",
                PermissibleValue(text="VLP-encapsulated TLR9 Agonist CMP-001") )
        setattr(cls, "Milk Thistle",
                PermissibleValue(text="Milk Thistle") )
        setattr(cls, "Glycooptimized Trastuzumab-GEX",
                PermissibleValue(text="Glycooptimized Trastuzumab-GEX") )
        setattr(cls, "Denileukin Diftitox",
                PermissibleValue(text="Denileukin Diftitox") )
        setattr(cls, "Ribosome-Inactivating Protein CY503",
                PermissibleValue(text="Ribosome-Inactivating Protein CY503") )
        setattr(cls, "BC-819 Plasmid/Polyethylenimine Complex",
                PermissibleValue(text="BC-819 Plasmid/Polyethylenimine Complex") )
        setattr(cls, "Anti-CD74 Antibody-drug Conjugate STRO-001",
                PermissibleValue(text="Anti-CD74 Antibody-drug Conjugate STRO-001") )
        setattr(cls, "HIF-2alpha Inhibitor PT2977",
                PermissibleValue(text="HIF-2alpha Inhibitor PT2977") )
        setattr(cls, "Monoclonal Antibody Lym-1",
                PermissibleValue(text="Monoclonal Antibody Lym-1") )
        setattr(cls, "Docetaxel Lipid Microspheres",
                PermissibleValue(text="Docetaxel Lipid Microspheres") )
        setattr(cls, "Listeria monocytogenes-LLO-PSA Vaccine ADXS31-142",
                PermissibleValue(text="Listeria monocytogenes-LLO-PSA Vaccine ADXS31-142") )
        setattr(cls, "Macrocycle-bridged STING Agonist E7766",
                PermissibleValue(text="Macrocycle-bridged STING Agonist E7766") )
        setattr(cls, "Smac Mimetic GDC-0152",
                PermissibleValue(text="Smac Mimetic GDC-0152") )
        setattr(cls, "Mitomycin C Analog KW-2149",
                PermissibleValue(text="Mitomycin C Analog KW-2149") )
        setattr(cls, "Topical Celecoxib",
                PermissibleValue(text="Topical Celecoxib") )
        setattr(cls, "Cedazuridine/Decitabine Combination Agent ASTX727",
                PermissibleValue(text="Cedazuridine/Decitabine Combination Agent ASTX727") )
        setattr(cls, "Nilotinib Hydrochloride Monohydrate",
                PermissibleValue(text="Nilotinib Hydrochloride Monohydrate") )
        setattr(cls, "Anti-ICOS Monoclonal Antibody KY1044",
                PermissibleValue(text="Anti-ICOS Monoclonal Antibody KY1044") )
        setattr(cls, "Yangzheng Xiaoji Extract",
                PermissibleValue(text="Yangzheng Xiaoji Extract") )
        setattr(cls, "TLR7 agonist BNT411",
                PermissibleValue(text="TLR7 agonist BNT411") )
        setattr(cls, "Zoptarelin Doxorubicin",
                PermissibleValue(text="Zoptarelin Doxorubicin") )
        setattr(cls, "Selatinib Ditosilate",
                PermissibleValue(text="Selatinib Ditosilate") )
        setattr(cls, "Colorectal Tumor-Associated Peptides Vaccine IMA910",
                PermissibleValue(text="Colorectal Tumor-Associated Peptides Vaccine IMA910") )
        setattr(cls, "KRAS G12C Inhibitor LY3499446",
                PermissibleValue(text="KRAS G12C Inhibitor LY3499446") )
        setattr(cls, "Bcl-2 Inhibitor LP-108",
                PermissibleValue(text="Bcl-2 Inhibitor LP-108") )
        setattr(cls, "Anti-PSMA Monoclonal Antibody-MMAE Conjugate",
                PermissibleValue(text="Anti-PSMA Monoclonal Antibody-MMAE Conjugate") )
        setattr(cls, "HPV 16 E6/E7-encoding Arenavirus Vaccine HB-202",
                PermissibleValue(text="HPV 16 E6/E7-encoding Arenavirus Vaccine HB-202") )
        setattr(cls, "Fosbretabulin Tromethamine",
                PermissibleValue(text="Fosbretabulin Tromethamine") )
        setattr(cls, "Hypoxia-activated Prodrug TH-4000",
                PermissibleValue(text="Hypoxia-activated Prodrug TH-4000") )
        setattr(cls, "Anti-CD47 Monoclonal Antibody Hu5F9-G4",
                PermissibleValue(text="Anti-CD47 Monoclonal Antibody Hu5F9-G4") )
        setattr(cls, "Oncolytic Virus RP1",
                PermissibleValue(text="Oncolytic Virus RP1") )
        setattr(cls, "Anti-DKK-1 Monoclonal Antibody LY2812176",
                PermissibleValue(text="Anti-DKK-1 Monoclonal Antibody LY2812176") )
        setattr(cls, "Amsacrine Lactate",
                PermissibleValue(text="Amsacrine Lactate") )
        setattr(cls, "Epratuzumab-cys-tesirine",
                PermissibleValue(text="Epratuzumab-cys-tesirine") )
        setattr(cls, "Gold Sodium Thiomalate",
                PermissibleValue(text="Gold Sodium Thiomalate") )
        setattr(cls, "Hsp90 Antagonist KW-2478",
                PermissibleValue(text="Hsp90 Antagonist KW-2478") )
        setattr(cls, "Flt3/MerTK Inhibitor MRX-2843",
                PermissibleValue(text="Flt3/MerTK Inhibitor MRX-2843") )
        setattr(cls, "Mannosylerythritol Lipid",
                PermissibleValue(text="Mannosylerythritol Lipid") )
        setattr(cls, "Anti-PD-L1 Monoclonal Antibody MSB2311",
                PermissibleValue(text="Anti-PD-L1 Monoclonal Antibody MSB2311") )
        setattr(cls, "Oncolytic HSV-1 rRp450",
                PermissibleValue(text="Oncolytic HSV-1 rRp450") )
        setattr(cls, "Thorium Th 227 Anti-PSMA Monoclonal Antibody BAY 2315497",
                PermissibleValue(text="Thorium Th 227 Anti-PSMA Monoclonal Antibody BAY 2315497") )
        setattr(cls, "BCMA/CD3e Tri-specific T-cell Activating Construct HPN217",
                PermissibleValue(text="BCMA/CD3e Tri-specific T-cell Activating Construct HPN217") )
        setattr(cls, "Pegylated Liposomal Mitoxantrone Hydrochloride",
                PermissibleValue(text="Pegylated Liposomal Mitoxantrone Hydrochloride") )
        setattr(cls, "Olvimulogene Nanivacirepvec",
                PermissibleValue(text="Olvimulogene Nanivacirepvec") )
        setattr(cls, "pan-RAF Kinase Inhibitor CCT3833",
                PermissibleValue(text="pan-RAF Kinase Inhibitor CCT3833") )
        setattr(cls, "CEA-MUC-1-TRICOM Vaccine CV301",
                PermissibleValue(text="CEA-MUC-1-TRICOM Vaccine CV301") )
        setattr(cls, "ATR Kinase Inhibitor M6620",
                PermissibleValue(text="ATR Kinase Inhibitor M6620") )
        setattr(cls, "Anti-mesothelin Antibody-drug Conjugate BMS-986148",
                PermissibleValue(text="Anti-mesothelin Antibody-drug Conjugate BMS-986148") )
        setattr(cls, "Anti-CD3/Anti-5T4 Bispecific Antibody GEN1044",
                PermissibleValue(text="Anti-CD3/Anti-5T4 Bispecific Antibody GEN1044") )
        setattr(cls, "BCG Vaccine",
                PermissibleValue(text="BCG Vaccine") )
        setattr(cls, "Yttrium Y 90 Monoclonal Antibody B3",
                PermissibleValue(text="Yttrium Y 90 Monoclonal Antibody B3") )
        setattr(cls, "Anti-TIGIT Monoclonal Antibody AB154",
                PermissibleValue(text="Anti-TIGIT Monoclonal Antibody AB154") )
        setattr(cls, "Anti-IRF4 Antisense Oligonucleotide ION251",
                PermissibleValue(text="Anti-IRF4 Antisense Oligonucleotide ION251") )
        setattr(cls, "JAK Inhibitor INCB047986",
                PermissibleValue(text="JAK Inhibitor INCB047986") )
        setattr(cls, "Dioscorea nipponica Makino Extract DNE3",
                PermissibleValue(text="Dioscorea nipponica Makino Extract DNE3") )
        setattr(cls, "HER2-targeted Liposomal Doxorubicin Hydrochloride MM-302",
                PermissibleValue(text="HER2-targeted Liposomal Doxorubicin Hydrochloride MM-302") )
        setattr(cls, "Hsp90 Inhibitor SNX-5542 Mesylate",
                PermissibleValue(text="Hsp90 Inhibitor SNX-5542 Mesylate") )
        setattr(cls, "Liposomal Cytarabine",
                PermissibleValue(text="Liposomal Cytarabine") )
        setattr(cls, "Lutetium Lu 177-DOTA-EB-TATE",
                PermissibleValue(text="Lutetium Lu 177-DOTA-EB-TATE") )
        setattr(cls, "Anti-LAG-3 Monoclonal Antibody INCAGN02385",
                PermissibleValue(text="Anti-LAG-3 Monoclonal Antibody INCAGN02385") )
        setattr(cls, "Anti-CD123-Pyrrolobenzodiazepine Dimer Antibody Drug Conjugate SGN-CD123A",
                PermissibleValue(text="Anti-CD123-Pyrrolobenzodiazepine Dimer Antibody Drug Conjugate SGN-CD123A") )
        setattr(cls, "Anti-HER2-vc0101 ADC PF-06804103",
                PermissibleValue(text="Anti-HER2-vc0101 ADC PF-06804103") )
        setattr(cls, "Ganglioside GM2",
                PermissibleValue(text="Ganglioside GM2") )
        setattr(cls, "Lorvotuzumab Mertansine",
                PermissibleValue(text="Lorvotuzumab Mertansine") )
        setattr(cls, "Phenethyl Isothiocyanate-containing Watercress Juice",
                PermissibleValue(text="Phenethyl Isothiocyanate-containing Watercress Juice") )
        setattr(cls, "EZH2 Inhibitor SHR2554",
                PermissibleValue(text="EZH2 Inhibitor SHR2554") )
        setattr(cls, "Methyl-5-Aminolevulinate Hydrochloride Cream",
                PermissibleValue(text="Methyl-5-Aminolevulinate Hydrochloride Cream") )
        setattr(cls, "Immunotherapeutic Combination Product CMB305",
                PermissibleValue(text="Immunotherapeutic Combination Product CMB305") )
        setattr(cls, "Anti-PD-1/CD47 Infusion Protein HX009",
                PermissibleValue(text="Anti-PD-1/CD47 Infusion Protein HX009") )
        setattr(cls, "Anti-Met/EGFR Monoclonal Antibody LY3164530",
                PermissibleValue(text="Anti-Met/EGFR Monoclonal Antibody LY3164530") )
        setattr(cls, "Menin-MLL Interaction Inhibitor SNDX-5613",
                PermissibleValue(text="Menin-MLL Interaction Inhibitor SNDX-5613") )
        setattr(cls, "Benzaldehyde Dimethane Sulfonate",
                PermissibleValue(text="Benzaldehyde Dimethane Sulfonate") )
        setattr(cls, "MAGE-A3-specific Immunotherapeutic GSK 2132231A",
                PermissibleValue(text="MAGE-A3-specific Immunotherapeutic GSK 2132231A") )
        setattr(cls, "Anti-DLL4 Monoclonal Antibody MEDI0639",
                PermissibleValue(text="Anti-DLL4 Monoclonal Antibody MEDI0639") )
        setattr(cls, "Anti-HER2/Anti-HER3 Bispecific Monoclonal Antibody MCLA-128",
                PermissibleValue(text="Anti-HER2/Anti-HER3 Bispecific Monoclonal Antibody MCLA-128") )
        setattr(cls, "Nutraceutical TBL-12",
                PermissibleValue(text="Nutraceutical TBL-12") )
        setattr(cls, "Oral Myoma Vaccine V3-myoma",
                PermissibleValue(text="Oral Myoma Vaccine V3-myoma") )
        setattr(cls, "Tiomolibdate Diammonium",
                PermissibleValue(text="Tiomolibdate Diammonium") )
        setattr(cls, "Retaspimycin Hydrochloride",
                PermissibleValue(text="Retaspimycin Hydrochloride") )
        setattr(cls, "Anti-SIRPa Monoclonal Antibody CC-95251",
                PermissibleValue(text="Anti-SIRPa Monoclonal Antibody CC-95251") )
        setattr(cls, "PI3K/BET Inhibitor LY294002",
                PermissibleValue(text="PI3K/BET Inhibitor LY294002") )
        setattr(cls, "Agatolimod Sodium",
                PermissibleValue(text="Agatolimod Sodium") )
        setattr(cls, "Anti-PD-1 Fusion Protein AMP-224",
                PermissibleValue(text="Anti-PD-1 Fusion Protein AMP-224") )
        setattr(cls, "NY-ESO-1/GLA-SE Vaccine ID-G305",
                PermissibleValue(text="NY-ESO-1/GLA-SE Vaccine ID-G305") )
        setattr(cls, "IL-12-expressing HSV-1 NSC 733972",
                PermissibleValue(text="IL-12-expressing HSV-1 NSC 733972") )
        setattr(cls, "Angiogenesis/Heparanase Inhibitor PG545",
                PermissibleValue(text="Angiogenesis/Heparanase Inhibitor PG545") )
        setattr(cls, "Puquitinib Mesylate",
                PermissibleValue(text="Puquitinib Mesylate") )
        setattr(cls, "BET Inhibitor CC-90010",
                PermissibleValue(text="BET Inhibitor CC-90010") )
        setattr(cls, "Threonine Tyrosine Kinase Inhibitor CFI-402257",
                PermissibleValue(text="Threonine Tyrosine Kinase Inhibitor CFI-402257") )
        setattr(cls, "Autologous Anti-CD19 Chimeric Antigen Receptor T-cells SJCAR19",
                PermissibleValue(text="Autologous Anti-CD19 Chimeric Antigen Receptor T-cells SJCAR19") )
        setattr(cls, "Autologous ACTR-CD16-CD28-expressing T-lymphocytes ACTR707",
                PermissibleValue(text="Autologous ACTR-CD16-CD28-expressing T-lymphocytes ACTR707") )
        setattr(cls, "Rhenium Re 188 BMEDA-labeled Liposomes",
                PermissibleValue(text="Rhenium Re 188 BMEDA-labeled Liposomes") )
        setattr(cls, "Nanocell-encapsulated miR-16-based microRNA Mimic",
                PermissibleValue(text="Nanocell-encapsulated miR-16-based microRNA Mimic") )
        setattr(cls, "Interferon Beta-1A",
                PermissibleValue(text="Interferon Beta-1A") )
        setattr(cls, "Fas Receptor Agonist APO010",
                PermissibleValue(text="Fas Receptor Agonist APO010") )
        setattr(cls, "Superagonist Interleukin-15:Interleukin-15 Receptor alphaSu/Fc Fusion Complex ALT-803",
                PermissibleValue(text="Superagonist Interleukin-15:Interleukin-15 Receptor alphaSu/Fc Fusion Complex ALT-803") )
        setattr(cls, "Lactoferrin-derived Lytic Peptide LTX-315",
                PermissibleValue(text="Lactoferrin-derived Lytic Peptide LTX-315") )
        setattr(cls, "CD4-specific Telomerase Peptide Vaccine UCPVax",
                PermissibleValue(text="CD4-specific Telomerase Peptide Vaccine UCPVax") )
        setattr(cls, "Anti-FLT3 Antibody-drug Conjugate AGS62P1",
                PermissibleValue(text="Anti-FLT3 Antibody-drug Conjugate AGS62P1") )
        setattr(cls, "HLA-A*2402-Restricted Multipeptide Vaccine S-488410",
                PermissibleValue(text="HLA-A*2402-Restricted Multipeptide Vaccine S-488410") )
        setattr(cls, "Chk1 Inhibitor CCT245737",
                PermissibleValue(text="Chk1 Inhibitor CCT245737") )
        setattr(cls, "Halichondrin Analogue E7130",
                PermissibleValue(text="Halichondrin Analogue E7130") )
        setattr(cls, "Human MHC Non-Restricted Cytotoxic T-Cell Line TALL-104",
                PermissibleValue(text="Human MHC Non-Restricted Cytotoxic T-Cell Line TALL-104") )
        setattr(cls, "Smoothened Antagonist LEQ506",
                PermissibleValue(text="Smoothened Antagonist LEQ506") )
        setattr(cls, "Clomiphene Citrate",
                PermissibleValue(text="Clomiphene Citrate") )
        setattr(cls, "5-Aza-4'-thio-2'-deoxycytidine",
                PermissibleValue(text="5-Aza-4'-thio-2'-deoxycytidine") )
        setattr(cls, "Recombinant Thyrotropin Alfa",
                PermissibleValue(text="Recombinant Thyrotropin Alfa") )
        setattr(cls, "Anti-FGFR3 Antibody-drug Conjugate LY3076226",
                PermissibleValue(text="Anti-FGFR3 Antibody-drug Conjugate LY3076226") )
        setattr(cls, "Pegylated Recombinant Human Hyaluronidase PH20",
                PermissibleValue(text="Pegylated Recombinant Human Hyaluronidase PH20") )
        setattr(cls, "Oncolytic Herpes Simplex Virus-1 ONCR-177",
                PermissibleValue(text="Oncolytic Herpes Simplex Virus-1 ONCR-177") )
        setattr(cls, "Pomegranate Juice",
                PermissibleValue(text="Pomegranate Juice") )
        setattr(cls, "Anti-HBEGF Monoclonal Antibody U3-1565",
                PermissibleValue(text="Anti-HBEGF Monoclonal Antibody U3-1565") )
        setattr(cls, "Anti-CD47 Monoclonal Antibody AO-176",
                PermissibleValue(text="Anti-CD47 Monoclonal Antibody AO-176") )
        setattr(cls, "CXCR1/2 Inhibitor SX-682",
                PermissibleValue(text="CXCR1/2 Inhibitor SX-682") )
        setattr(cls, "Autologous CD19-targeted CAR-T Cells GC007F",
                PermissibleValue(text="Autologous CD19-targeted CAR-T Cells GC007F") )
        setattr(cls, "Ropeginterferon Alfa-2B",
                PermissibleValue(text="Ropeginterferon Alfa-2B") )
        setattr(cls, "Larotrectinib Sulfate",
                PermissibleValue(text="Larotrectinib Sulfate") )
        setattr(cls, "CHK1 Inhibitor MK-8776",
                PermissibleValue(text="CHK1 Inhibitor MK-8776") )
        setattr(cls, "DNA Interference Oligonucleotide PNT2258",
                PermissibleValue(text="DNA Interference Oligonucleotide PNT2258") )
        setattr(cls, "Aryl Hydrocarbon Receptor Antagonist BAY2416964",
                PermissibleValue(text="Aryl Hydrocarbon Receptor Antagonist BAY2416964") )
        setattr(cls, "Beta Alethine",
                PermissibleValue(text="Beta Alethine") )
        setattr(cls, "STAT3 Inhibitor TTI-101",
                PermissibleValue(text="STAT3 Inhibitor TTI-101") )
        setattr(cls, "Yttrium Y 90 Anti-CD45 Monoclonal Antibody AHN-12",
                PermissibleValue(text="Yttrium Y 90 Anti-CD45 Monoclonal Antibody AHN-12") )
        setattr(cls, "Anti-mesothelin/MMAE Antibody-drug Conjugate RC88",
         