from docile.dataset.bbox import BBox
from docile.dataset.cached_object import CachingConfig
from docile.dataset.dataset import Dataset
from docile.dataset.document import Document
from docile.dataset.field import Field, load_predictions, store_predictions
from docile.dataset.table_grid import TableGrid

KILE_FIELDTYPES = [
    "account_num",
    "amount_due",
    "amount_paid",
    "amount_total_gross",
    "amount_total_net",
    "amount_total_tax",
    "bank_num",
    "bic",
    "currency_code_amount_due",
    "customer_billing_address",
    "customer_billing_name",
    "customer_delivery_address",
    "customer_delivery_name",
    "customer_id",
    "customer_order_id",
    "customer_other_address",
    "customer_other_name",
    "customer_registration_id",
    "customer_tax_id",
    "date_due",
    "date_issue",
    "document_id",
    "iban",
    "order_id",
    "payment_reference",
    "payment_terms",
    "tax_detail_gross",
    "tax_detail_net",
    "tax_detail_rate",
    "tax_detail_tax",
    "vendor_address",
    "vendor_email",
    "vendor_name",
    "vendor_order_id",
    "vendor_registration_id",
    "vendor_tax_id",
]

LIR_FIELDTYPES = [
    "line_item_amount_gross",
    "line_item_amount_net",
    "line_item_code",
    "line_item_currency",
    "line_item_date",
    "line_item_description",
    "line_item_discount_amount",
    "line_item_discount_rate",
    "line_item_hts_number",
    "line_item_order_id",
    "line_item_person_name",
    "line_item_position",
    "line_item_quantity",
    "line_item_tax",
    "line_item_tax_rate",
    "line_item_unit_price_gross",
    "line_item_unit_price_net",
    "line_item_units_of_measure",
    "line_item_weight",
]

__all__ = [
    "BBox",
    "CachingConfig",
    "Dataset",
    "Document",
    "Field",
    "KILE_FIELDTYPES",
    "LIR_FIELDTYPES",
    "TableGrid",
    "load_predictions",
    "store_predictions",
]
