# 本田由紀「社会変容がもたらす“悪”」ー公開講座「悪」2015

https://www.youtube.com/watch?v=aIsqvnTOuEE

## <Untitled Chapter 1>

全員の変化, 社会変容がもたらす悪ということで、 50分ほどお話しさせていただきたいと思います。

私、最初にお詫びを申し上げておきたいんですけれども、 子供の頃から大変早口で怒られ続けております。で、講演や授業などでもですね、 気をつけなくてはいけないとは分かっているんですけれども、 お話ししたいことがいつも大変そのたくさんありまして、 しかも時間が限られている場合が多いということで、後に行くほどですね、 自分で後で録音を聞くと驚くほどの早口になっていることがあります。今日はできるだけそのようにならないように 気をつけますけれども、もし同じ過ちを繰り返してしまいましたら、 本当に申し訳ありません。

では始めたいと思います。

お手元にはですね、今日使いますパワーポイントの ごくその中心的な部分だけお配りしていただいてあります。

まずですね、ちょっと中身に入る前に、 エピソードのようなものを3つほどお見せしたいと思います。いずれもテレビですとか、 あるいはマスメディアから撮ってきたものですけれども、まず最初はですね、これは2014年9月に放送された NHKスペシャルから貼り付けたものです。一人暮らしの高齢者が今約600万人という数に達していると。そしてその半数ほどが生活保護水準以下の年金収入しかない。その300万人のうち生活保護を受けているのは70万人ほど。残り200万人余りは生活保護を受けずに暮らしている。貯蓄もなくギリギリの暮らしを、身寄りもなくですね、 頼れる人もなく続けてきた高齢者が、今破産寸前と言っていいような状態に追い込まれているという、 そういうドキュメンタリーが昨年報道されました。

2つ目のエピソードです。先ほどは高齢の方でしたけれども、 こちらはですね、若年若い女性たち、あるいは子どもたちの貧困ということが、 今非常に大きな話題になっております。

これは昨年1月に放送された「NHKクローズアップ現代、 明日が見えない。深刻化する若年女性の貧困」というところから、 言葉を貼り付けて、上のですね、写真は左側がこのクローズアップ現代から、 書籍として刊行されたものの表紙を付けてあります。

学校卒業後、非正規の不安定な仕事にしか つけない女性が増加し続けています。今、働く世代の単身女性の3分の1が、 年収114万円未満ということで、月あたり10万円にも達しない、 そういう収入で暮らしていると。中でも深刻化していると言われるのが、 10代、20代の貧困です。こういった報道もあります。

もう一つお見せします。これはあるインターネット記事から 貼り付けたものですけれども、ちょっと字が小さいかもしれませんので 読み上げますと、電話が鳴ると。受話器を取ると土器を含んだ男の声が 耳に響いた。あんたら人様の税金を 無駄遣いしているんだろうと。ああ、またか。担当者はそう思いながらも 勤めて冷静に、そして穏やかに答える。どういうことでしょうか。男はさらに声を張り上げた。怠け者なんかに 金を出すなってことだよ。電話はそこで切れた。東京都内の福祉事務所。生活保護業務を受け持つ 40代男性のケースワーカーがため息混じりに話す。今なお主に大都市の福祉事務所には、前述のような批判・非難の電話が 大量に寄せられていると言う。一連の報道によって、まるで生活保護が楽して 儲けるための制度だと誤解されてしまったようなんです。つまり、金をばらまく 役所がけしからんというわけです。こういったようなことが 今の日本社会では起こっています。

今3つのエピソードをお見せしましたけれども、これらはですね、例えば貧困の中で孤立する高齢者であったり、あるいは懸命に働いても収入が少なく、明日の展望が見えない若年女性であったり、あるいは生活保護受給者や、在日と呼ばれる在日、朝鮮韓国人の方にですね、向けられるような、極めて激しい増といったようなものが、今、日本の中で至る所に観察されるようになっています。

今年の公開講座のテーマは悪ですけれども、私はその悪というのを、非常にシンプルに定義しておきたいと思います。

つまり、人々、個人であったり、あるいはその集合としての、この社会全体といってもいいんですけれども、人々の存在と生活を脅かすもの、というふうに定義するとすれば、現在の日本社会というのは、こうした悪があふれているような状況にあるといえます。

ではなぜ、このような状況が起きてしまったのか。今の日本社会は、一体どういう経緯をたどって、今どのような形になっているのかということを、少し長い期間をとって、しかも社会の全域を見渡すような形で、振り返っておきたいと思います。

## 社会変容の見取り図

経減園の見取り図ということなんですけれども、これはお手元にもお配りしてあります。 ちょっとごちゃごちゃしたグラフで申し訳ないんですけれども、このグラフはですね、 横軸に時間の流れをとっています。60年代半ばから現在に至るまでの時間の流れをとり、 左側の縦軸は、これはパーセントです。右側の縦軸は、 満単位の実数を示しています。そして、ここにですね、ここに示しているような、 長期的に手に入れることができるような、様々な社会指標を一度に、 折れ線グラフや棒グラフで書き込んでみたものです。

こういう図はですね、多分皆さん、 日本社会の変容の様子というものをですね、目で見て実感として把握していただけるかもしれないと思って、 作ってみたものです。

でですね、ここに赤い線が2本、 赤い点線が刺さっていますけれども、これは戦後2本を時期区分するとすれば、 その境目にあたるところに、赤い縦線を書き入れてあります。

時期を見ていただければお分かりのように、 左側が石油危機、オイルショックですね。右側がバブル経済の崩壊です。で、この2つの時期に区切られる、 3つの時期というのは、それぞれですね、いわゆる高度経済成長期、 安定成長期、そして低成長期という、この3つの時期に対応しています。

高度経済成長期においては、年平均9.1%という、 文字通り高度な経済成長というものが達成されていたわけですけれども、それをオイルショックを経て、 その後70年代から80年代いっぱいの間は、平均4.2%という形で、9.1からすると半分以下になっておりますけれども、一定の経済成長率というものを達成できていたと。それがバブル経済を経てですね、 その後の90年代から2000年代に入りますと、失われた20年という言い方もありますけれども、マイナス成長の年が全く珍しくなくなっていると。2014年もそうです。平均すると0.9%という、1%にも達しないような経済成長率になっていると。経済が膨らまない、富が増えない、そういう状況に私たちはすっかり立ち至って、もう20年が経っています。日本社会は経済成長率一つ見てもですね、このように階段を一歩ずつ降りていくような、そういう経緯をこれまでたどってきました。今のような経済成長率の変容というのは、こちらの先ほどのグラフの様々な折れ線グラフやですね、棒グラフにもしっかり反映されています。そして、パッと目で見て分かっていただけるのはですね、オイルショック前後の変化よりも、バブル経済崩壊の前後の、この社会の変容の方が、はっきりと極めて著しいということです。

この90年代以降ですね、ここに書き込んであるいくつものグラフが、いずれも鎌首を、蛇が鎌首を持たげるような形で、ぐーっと増えています。特に目に立ちますのが、この黄緑色の細い棒グラフですけれども、これはこちらにありますように、完全失業者数ですね。やや凸凹はあります。一回ものすごい勢いで増えまして、イザナギ超えと言われる景気回復期で、ちょっと減りまして、そして、リーマンショックでまた増えまして、今少し減ってきています。この失業者が、失業率が減ってきていることを、アベノミクスの成果のように、おっしゃる方もいるんですけれども、実は、アベノミクスを持ち出す必要はないと、私は考えています。

と言いますのも、下に書き込んであるんですけれども、日本の人口の中で、大変規模の大きい、2つの世代のうちの、1つであるところの段階世代、これが今、労働市場をどんどん抜け始めています。年退職の時期を迎え始めているわけですね。大変その規模の大きい段階世代が、今、仕事をお辞めになってですね、引退され始めているので、さすがに人手が足りなくなっている。ということで、採用がやや活性化しているわけなんですけれども、かといって、仕事の質が良くなっているかというと、そういうことはない。例えば、この非正規雇用比率などを見ていただいても、こちらですね、この青い方ですね。こちらを見ていただいても、とどまるところを知らないように上昇しています。あるいは、こういう中で、この灰色の線、これは貯蓄非保有世帯比率、これは2名以上の世帯だけ取り出していますけれども、2名以上の世帯の中で、貯金が全くない世帯が、このように上昇している。この下の方をピンクの棒グラフが上がっていますけれども、これは一番上に書いてある、生活保護世帯ですね。この増加の増えている分の大半は、高齢者で年金の額が非常に少ない方が、それを補うためにですね、生活保護を取られているという、そういうケースが非常に多くの比率を占めています。こういう中で、もう1つ増えているものがあります。それはこの赤い折れ線なんですけれども、これはこちらに書いてあります。大学短大進学率です。例えば、失業ということは仕事がない。そして、非正規なので不安定で、やはり賃金が低い、貯金もないといったように、90年代以降日本は、生活を支える賃金や仕事や貯金や、といったものが、どんどん掘り崩されていく状況にあるわけですけれども、その中で、高等教育進学率は増えている。その背景にはですね、例えば、バブル経済の崩壊後に、新規高卒者への求人数が、ものすごい勢いで減ります。高校を出て、まともな仕事につけなくなってきた、ということがあって、無理を重ねてでも、子どもたちを大学に進学させてやりたいという、親御さんの気持ちが、ここには反映されていますし、また、ちょうどこの、90年代以降ですね、大学の設置基準や、入学定員に関して規制が緩和された、ということもあって、この時期に大学は、非常に規模の拡大を遂げます。大学は規模が拡大したんですけれども、その出口において、かつての大学卒業者がついていたような、仕事が膨らんだわけではない。で起きているのが、いわゆる出口で混雑するような状態ですね。膨らんだのに、出口で良い仕事をめぐる争いというものが、非常に激しくなっている。いわゆるボトルネックのような状態というものが、今の大学生の中では、これまでの大学生の中では生じてきたと。大変学費が高いことを、日本の高等教育は特徴としております。後でデータもお示ししますけれども、そういう高い学費を払ってですね、ようやく卒業まで行ったんだけれども、そこで仕事が得られないような、そういう大学生というのも、この間増えてきたというような状況に、日本の社会はあるわけです。でですね、このように大きく分ければ、1、2、3段、3つの時期。もっとざっくり分ければ、このバブル経済崩壊前後の2つの時期に、日本社会は分けられるわけです。その中で先ほど申しました、規模の大きい世代がですね、どういうライフコース、つまり人生ですね、を辿ってきたかを簡単に確認しますと、まずこちらの段階世代というのは、ご存知のように、第二次世界大戦が終わって、1947、89、1950年ぐらいに、生まれた方たちです。で、47年生まれというふうに、仮に設定しますと、47年生まれの方はですね、高校出られたのが、47+18歳ですから、1965年になります。この頃の大学進学率は、まだ10%台でしたけれども、大学に行っていらしたとすればですね、47+22歳ですから、1969年になります。あるいはこの世代は、中卒で仕事に疲れた方も、たくさん含まれています。その方の場合は、47+15歳ですから、1962年に、中学を卒業されて、仕事に疲れていたことになります。いずれにしてもですね、中卒、高卒、大卒のいずれにしても、この段階世代の方たちが、学校を卒業して、社会に出られた時期というのは、先ほど見ました、高度経済成長期であったと。これは、この段階世代の方たちにとっても、あるいは日本の産業界にとってもですね、極めて幸運なことでした。当時はですね、高度経済成長のもとで、日本中に会社がどんどん増える、規模も拡大すると、工場や店舗やですね、事業所が日本中に、ウゴの竹の子のようにできていた時期に、問題化していたのは、人手が足りないということでした。人手不足ということが、当時の報道には踊っていたわけですけれども、見出しにたくさん見られていたわけですけれども、ちょうどその時期にですね、人数の多い段階世代が、学校を卒業して、世の中に出てきてくれていたと。ですから産業界は、彼らをですね、非常に競うようにして、採用していたわけです。もしそのような時期でなかったとすれば、大変人口規模が大きいので、この段階世代は、学校を出られた時点で、大量の失業者を発生させていたはずなんですけれども、折氏も高度経済成長期だったので、そういうことにはならなかったと。

もちろんですね、集団就職のような形で、地方から大都会へ、親御さんと離れて就職されていたような方たちは、もちろん含まれていますけれども、仕事に就くということ自体は、それほど難しいことではなかった。というのが段階世代の方たちです。

そして20代の頃にですね、石油危機が起きます。そしてその後、この時期のですね、先ほど見た安定成長期と言われる時期に、この段階世代の方たちは、30代から40代前半という、文字通りその働き盛りのような時期を迎えていらして、この安定成長を支えるような働きをされていた。ただしこの安定成長期というのは、今の日本を考える上で、非常に癖ものというかですね、大変重要な時期です。この安定成長期においては、かつての高度経済成長期のような、明るさや勢いは消え、それでも何とか成長を叩き出すために、すでにこの後の時期に一層問題化するような、諸問題が現れ始めていました。そしてその多くは、日本独特な形をとっていました。例えば典型的には、いわゆる日本的雇用慣行であるとかですね、その中で、会社人間、社畜、あるいは過労死と呼ばれるような、非常に厳しい働き方が、この時期から広がっていたわけですけれども、その主な対象が、この団塊世代の方たちであったと。そして団塊の世代の方たちがですね、40代半ばでバブルが崩壊します。そしてその後の長期不況期において、団塊世代の方たちは、50代という時期を迎えていらしたわけですが、高度経済成長期においては、大変ラッキーであった、この団塊世代と産業界とのマッチングというのはですね、この低成長期になると、全く逆にですね、非常に不幸な関係になります。

と言いますのも、50代というのは、日本的雇用慣行のもとでは、最も人件費が高くなる時期にあたっています。その人件費の高い50代の方たちが、人口が多い団塊世代として、会社の上部にですね、大量に存在していたということが、この時期の長期不況の企業にとってですね、非常に重い負担になっていたということがあります。であるがゆえに、新規の学卒者を、正社員として、新たに採用するだけの余力を、この時期の企業は、非常に失っていました。ですから、例えば、就職氷河期、超氷河期、あるいは、ロストジェネレーションと呼ばれるようなですね、厳しい状況にある若者というのが、この時期に出現することになっていたわけです。

そしてようやくですね、47年生まれの方は、2012年に65歳を迎えて、定年で退職されていっています。48年、49年、50年というふうに生まれる方たちがですね、ここ数年、どんどん退職期を迎えられていたと。そして、この団塊世代の方たちが抜けられたということが、先ほど申しましたように、この失業率の低下や、あるいは新規学卒労働市場の、やや活性感にですね、つながっているということが言えます。

一方ですね、この団塊世代の方たちの、子どもたちもたくさん含まれている、団塊ジュニア世代という、もう一つ人口規模の大きい世代があります。この世代は、70年代前半生まれというふうに言われています。仮に72年生まれ、72年生まれというふうにしますと、この72年生まれの、高卒で就職された方たちは、ギリギリバブル経済の崩壊前に、就職することができていました。72+18歳ですから、1990年ですね。90年は、バブル経済のピークの時期にあたり、大変その、新規高卒求人倍率も高い時期でした。いわゆる大企業、名柄企業のようなところに、高卒であっても、どんどん就職できていたというのが、この世代です。同じ72年生まれであっても、4年生大学まで進学されていますと、卒業されるのは、72+22歳ですから、1994年です。94年になりますと、すっかりバブル経済崩壊の波が、新規大卒の採用にも襲いかかっていまして、ちょうどこの時期の人たちが、先ほど申しました、ロストジェネレーションの最も早い時期の人たちである、ということになります。

そして72年生まれの方たちは、今年2015年に43歳を迎えています。

ということはですね、72年よりも後に生まれた若者たち、つまり年齢で言えば、今43歳よりも若い方たちというのは、その全てがですね、学校を出て歩み入っていかれた、その先の社会というのは、このように仕事や賃金や貯蓄やという、貯蓄やという生活基盤が、どんどん崩壊していくような、そういう社会状況であったということが確認されます。

まあですね、どうしてこういう図をちまちま作ったりしているかといいますと、今少し収まっていますけれども、数年前まではですね、高齢の方、段階世代あるいはそれよりももう少し高齢の方が、日本社会がですね、その元気がないのは、今の若者がなっとらんからだといったようなことを盛んにおっしゃっていました。やる気がない、努力をしない、甘えている。だからこそ日本の経済が活気がないのだと、成長しないのだということをおっしゃる方がたくさんいました。保守的な政治家の中にはですね、若者を自衛隊に入れてイラクに送っておけば、ピシッとして帰ってくるはずだといったようなことをまことしやかにおっしゃる場合もあったわけです。そういうことをたくさん目にしていまして、いや、私はそんな話ではないということが言いたかったんですね。

このようなマクロンなですね、長期的な推移を見たときに、この 90年代以降の状況が、個々の若者一人一人の心根のあり方でもたらされたような、そういう説明は当てはまらない。むしろ高齢の方たちがですね、確かに日本が貧しかった頃から非常に努力をされて、豊かにされてきたということはあるかもしれないけれども、そもそも学校出られた時期は高度経済成長期だったし、少年期には安定成長期ということで、蓄えなどもすることができたではありませんか。ご努力されてきたかもしれませんけれども、いわゆる揚げ潮に乗っていらしたではありませんか、ということをお示ししたくてですね、このようなグラフを作ったりしています。 Thank you.

## 戦後日本型循環モデルの破綻

そしてですね、日本社会というのは今お見せしましたバブル経済の崩壊よりも前と後ではその形そのものは変わっています。これからお話するのは高度経済成長期に作られ、その後安定成長期に日本社会に広がり深まっていった大変独特な日本の社会の形のあり方というのをなんとか考えていることをお伝えしたくて作ったモデル図です。戦後日本型循環モデルと私はこれを呼びまして、 いろんなところで使っているわけなのですけれども、この循環モデルの大きな特徴はですね、 教育と仕事と家族という3つの社会領域の間がこのような一方向の極めて太い矢印で結ばれ、 この矢印に乗っかってですね、ある社会領域のアウトプットが次の社会領域のインプットとして、 資源としてですね、順繰りに注ぎ込まれるような、 そういう関係が成立していたということです。

教育から仕事には労働力が、 仕事から家族には賃金が、家族から教育にはその教育を支えるための費用と、 勉強への意欲ということが注ぎ込まれていた。

そして、このように説明しますと、 そんなことは、どこの社会でも当てはまることであろうと、当たり前ではないかとお感じかもしれませんけれども、 違います。他の先進諸国では、これほど太い矢印で、 教育と仕事と家族が、きっちりと結ばれるような状況というものは、 それぞれの社会が辿ってきた、歴史的なプロセスによるところがありますけれども、 成立していません。この間を補うような形で、 政府がさまざまな社会保障政策などによって補っているというのが、他の、特に日本より先にですね、 発展を開始した欧米諸国では一般に見られることです。後発国でもそうです。

ところが日本はですね、1960年代において、 今あるような教育、今あるような仕事、今あるような家族、つまり、今あるような教育というのは、 義務教育段階よりも先に多くの人がどんどん進学するような、非常にその拡大普及を遂げた教育ということですし、 今あるような仕事というのは、第一次産業のように自然を相手に、 多くは自営で働くようなあり方ではなく、大半が会社に雇われて働くような、 第二次、第三次産業がガッと普及したのが、1960年代でした。

そしてまた、今あるような家族というのはですね、 例えば親戚や使用人が、たくさん集まって住んでいるような、 そういうあり方ではなくて、多くは二人の親のもとにですね、 多くは二人程度のですね、子どもたちが住むという、 各家族と呼んでもいいんですけれども、そこに小さい単位の家族が形成されて、 中でもその中で、女性はですね、 主に家庭を支える役割に就くことが多くなったと、そういう家族というものが成立したのも、 やはり60年代だったわけです。

この三つの領域の変化が、同時に、 しかもものすごいスピードで、急激に、日本では1960年代に起きました。

で、急激な変化というのは、 ある意味、やや無理やりの変化なわけで、それを達成するために、各社会領域が、 その一つ前の社会領域から、最大限に資源を吸い上げる、吸い取ると、 それを活用することによって成長するといったような、そういう、お互いに絡み合った竜巻のようなですね、 この循環構造が、日本では1960年代に起きていたわけです。

そして具体的に、この矢印の中身を見てもですね、 それは大変日本独特と呼ばれるものが、いずれもその内容を占めています。

例えば、教育と仕事の関係に関してはですね、日本では新規学卒一括採用と呼ばれる、 在学中に、卒業よりもずっと前の段階から就職活動をして、 内定を取っておくと。そして年度末に卒業式に出て、 年度初めの4月1日に入社式に出るといったように、生徒や学生である状態から、年度代わりとともに、 パッと社員である状態に移行すると。時間の隙間が全くない、 そういう教育と仕事の関係というのがですね、日本では成立しています。時間的な隙間はほぼ全くないんですけれども、逆に学校で学んだ内容と、 仕事としてやる内容との間の対応関係は、非常に希薄である場合が多いという。これが日本の新規学卒一括採用の特徴です。これは世界標準から大きく外れています。これも日本の中で生きていればですね、 それが普通であろうというふうに、お感じかもしれませんけれども、 世界標準は全く裏というか逆でして、時間的な隙間が空くことは、 そんなに悪いことではないとみなされている。数ヶ月とか、あるいは、 もしかしたら1年以上経っても構わないので、自分で仕事を見つけていくのが、 当たり前のような状況があります。

しかし、仕事を見つける際にですね、私はこれこれこういうものです、 というふうに仕事に応募していく際に、どのような教育機関で、 何をどれほどの水準で学んできたかという、そういう証明というのは、 大変重要な意味を持ちます。

というように、世界標準とは全く逆の、 そういう教育と仕事の関係が、日本においては見られるわけです。

このような独特な、 新規学卒一括採用が広がった背景に、先ほど申しました、 高度経済成長期におけるですね、とにかく頭数が、とにかく欲しい。人手が欲しい。人手をとにかく我が社に入れておきたい。人手さえ確保すれば、 あとは社内で何とか育てる。といったようなやり方が広がったということが、日本の独特な歴史的な経験としてあります。

そしてこの矢印に乗っかっていればですね、特に男性であれば、 先ほど申しましたように、仕事に就くことはそれほど難しくはなかった。新規学卒一括採用に、 このルートに乗っかっていればですね、特に何も言わなくても、 正社員になることは当たり前であった。正社員ですか、非正社員ですか、 という区別が必要になってきたのは、90年代以降のことです。当時の、特に男性は、 このルートに乗ってですね、もちろん企業規模や産業などによって、 賃金水準などには違いがあったかもしれませんけれども、普通に正社員になることができていた。そして正社員になればですね、 こちらに書いてありますけれども、そうそうクビにはならない。雇用というのは安定的に 確保されるものだという前提。そしてまた、普通に働いていれば、 賃金というのは順調に上がっていくものだと、そういう見込みがですね、 確保されていました。

ただ、この順調に上がっていく 年効的な賃金というのは、日本的雇用慣行の特徴というふうに 言われていますが、実のところその背景には、 経済そのもののパイが膨らんでいた。それが賃金にも反映されていたという、 そういうこともありました。

いずれにしても、この安定的な雇用と 上がっていく賃金に基づいて、結婚して子どもを作る、 つまり家族を作ることができていたわけです。そしてその家族に主な働き手としての父親が、 上がっていく賃金をどんどん持ち帰る。それを受け取った家族の支え手としての女性、 つまり母であり妻である女性たちが、三種の神器と言われる家電を買ったり、 あるいは団地からマイホームに住め替えたり、あるいはマイカーを買ったり、 というような形で消費行動によって、家族生活を豊かに便利にするような 役割を果たしていたわけです。

ところが、ただしですね、 母親の役割というのは消費行動だけではなくて、次世代である子どもたちの教育に対して、 一つは費用を、もう一つは意欲を、非常に熱心に注ぎ込むようなアクターとして、 日本の母親たちは振る舞い続けてきました。

それは、日本の親たちにとって子どもというのが、 自分の代理として、自分よりも一歩上の学歴や、 あるいは一歩上の職業的な地位達成を、してもらう存在というふうに 見なされていたが故にですね、非常に、政府が公的な教育への支出を 抑制している分を補うような形で、家計からですね、私費として、 学校や、あるいは学校外教育に、費用を支払い続けてきましたし、 もう一つは、ちゃんと勉強しなさいよと、遅刻するんじゃないのよと、 宿題をやったの?という形でですね、のび太くんのお母さんであれ、 マルコちゃんのお母さんであれ、必ず子どもを叱咤激励する存在として、 描かれる日本の母親たちの、モデルというかですね、 実情というものがその背後にありました。

で、このような形で循環が、 順繰りに注ぎ込まれるような資源に基づいて、循環が成り立っていたが故にですね、 政府は、例えばダムを作る、道路を作るといったような、 公共事業を含む産業政策によって、なんとか仕事の世界が成り立つように 手当てをしておけばですね、あとは政府から教育へ、 政府から家族への支出は、非常に節約することができていたと。で、この循環が勝手に回ってくれていた ということがありました。

というふうに、 戦後日本型循環モデルのご説明をしますと、皆様は、特に年配の方はですね、なんていいモデルだったことかという ふうにお感じかもしれません。

政府は小さくて済む、循環を回っていると、 素晴らしいと、あの頃は良かったと、あの頃に戻りたいと、 戻るべきだというふうにお感じかもしれません。

しかし、それが間違いであるということを すぐに申し上げておきたいと思います。

というのはですね、このような循環構造が 日本社会に出来上がった途端に、この循環構造そのものを原因とするような さまざまな問題が、すでにこの頃から紛失していたということを、 私たちは忘れがちですけれども、覚えておく必要があります。

どういうことかと言いますと、 この太い矢印がですね、比喩で言いますと、その生えている根っこの 社会領域のエネルギーを吸い尽くし、汲み取り尽くし、その社会領域を 枯らしていくといったような、比喩でイメージすることができるような 社会問題が、この全ての関係性において発生していました。

例えばですね、教育と仕事の関係に関しては、お勉強して、良い高校や良い大学に入って、 その先に良い会社に入る。そのために勉強するんだといったような、 この矢印に引きずられたような、学習動機というものが、日本の教育の中では、既に60年代の末頃から、すっかりはびこっていました。いわゆる受験競争とかですね、 その激化や早期化といったようなものが、それに当たるわけですけれども、 この受験競争の激化がもたらすような、もたらす、例えば落ちこぼれであったり、 あるいは不登校であったり、あるいは校内暴力であったり、そのストレスというのは、学校教育の中で、 圧力釜のような状態になっていた。そういうストレスを抱える子どもたちを 押し込めるための管理教育みたいなものも、すっかり70年代、80年代においては、 蔓延していたわけです。その下で、一体学ぶとは何かと、 本当に自分を豊かにする学びとは何かといったようなことは、どこか置いておいて、とにかく自分の一生、 あるいは子どもの一生を少しでも相対的に良くするためには、この学力あるいは偏差値の序列の中で、 人よりも一歩上に上がっていくことがいいことなどだといったような、そういう勉強に対する考え方、 教育に対する考え方が広がっていた。同じようなことが例えば、 妻と子どもを養うためには、会社に何を言われても、 時には法律に反することをやらされようが、あるいは大事なはずの家族と離れて 単身赴任を命じられようが、受け入れて働かなければならないといったような、 それこそ会社人間的な社畜的な働き方というのを、働く人々の中にもたらしていたわけです。

その下で、一体自分が一生懸けてしたい仕事は何かと、自分がやっている仕事のそのものの意味、 意義が何かといったようなことは、やはり置いておいて、妻と子どもを養うためには、組織に言われることは受け入れなければならないという、 そういう働き方が広がっていました。

また家族も、この循環構造の歯車の一つとして きっちり組み込まれていたが故に、家族としてのプライベートな時間や、 充実した余暇といったようなものは、人生が不十分であるままに現在に至っている。そもそも、父、母、子が別々の社会領域に 主に住むというようなことになっていました。

お父さんお仕事頑張ってね、 子どもは夜遅くまで塾に行ってお勉強頑張るのよ、お母さんは家族を支えるからといったように、 一応家族のメンバーではあるはずの父母子なんですけれども、主に占領する領域というのが違っていたが故に、先ほど言いましたような、 家族の親密な関係というのは十分に形成されないままになっている。さらに、親が子どもに対して、 教育熱心になりすぎ、それが子どもの教育がですね、 その期待を子どもが十分に満たすことができなかった場合には、極めて激しい、痛ましいような、 親子間の祖母にもつながっていたわけです。

こういう状況の下で、 一体学ぶとは何か。何のために学ぶのか。何のために働くのか。何のために人と愛し合って 一緒に住むのかといったような、人間の一生にとって非常に重要であるはずのですね、それぞれの社会領域の本質的な意義というのは置いといて、この自動的なですね、 循環構造がぶんぶん回る中で、とにかくそれに乗っておく必要がある。それから外れることなんてイメージもできないし、乗っていれば、まあ、おそらく、食いっぱくれたりすることはないであろうという中で、何か変だなと思いながらですね、この循環に乗りながら生きていたというのが、バブル経済崩壊前の日本の人々であった。その意味で、すでにこの循環構造には、多くの問題がはらまれていたということを 思い出す必要があります。

そしてこの中でですね、これはですね、当時の日本の人々の、自分や社会に対するイメージをお伝えしたくて 作った動画なんですけれども、まあ、横軸に時間をとり、縦軸にですね、 豊かさとか地位とかいったものをとりますと、このもこもことした形は不平等を意味しています。社会の中にもこもこもこと、均質ではなく、有利な人たちとそうではない人たちという、この不平等が存在しているけれども、日本の流れとともに、それはみんなが平行移動的に良くなっていき、良くなりながら、不平等ももっと縮まっていくであろう。もっと平等になっていくであろう。そういう想定のもとに、日本の人たちは、 この当時生きていたわけですね。

当時のデータを確認しますと、学歴や収入や貯蓄やといったような不平等は、はっきりと60年代、70年代、80年代においても観察されます。でも日本では、1億総中流社会というような 言われ方がされていました。なぜそうだったかというと、みんな平行移動的により良い明日が獲得できるよね。そのイメージそのものが共有されていたからこそ、現在の不平等というものは、 それほど大きく意識されずにですね。みんなだんだん良くなっていくという点では、 平等なんだ、共通なんだという、そういうふうな感覚を抱くことができていたわけです。

ところがですね、90年代以降、 この戦後日本型循環モデルは形を変えます。先ほどと見比べていただきますとですね、矢印が、まだ実践で書かれている矢印も 存在してはいますけれども、もう点線で書かれた矢印、つまり、ある社会領域から次の社会領域に うまく資源を流し込めない、そういう矢印というものが、 この時期に現れ、その太さを増してきている。その結果ですね、言うまでもなく、教育を終えた後にですね、 安定した仕事につけない若者や、労働条件が劣悪であるがために 家族を作ることができない若者や、あるいは何とか家族を作れたとしても、 子供に何をしてやれるかに関して、非常に家族の間の差が広がり、 全体として下に引っ張られるような形で、劣悪化していますので、今、その家族が子供に対して 何をしてやるかということに関しても、すごく差が広がっています。

一方では、このように社会が不安定化する中で、 かつてよりもずっと教育熱心になってらっしゃる親御さんというのも、非常に目立ってきています。お勉強だけではダメだと、生きる力が必要だから、 生きる力をつけるための塾に行かせるとかですね。あるいは、子供の大学の入学式や卒業式にも、 自分の成果なので一緒に来る親御さんであるとか、あるいは子供の就職活動にも介入してくると。

中小企業に対してですね、 今度うちの子がそこを受けに行くんですけど、お宅中小で、外文が悪いので落としてくださいと。そういう電話をかけてくる親御さんとか。そういう非常に熱心に子供の人生から リスクを減らそうとして、様々に手当てをしようとする親御さんというのも 増えてきていますが、他方にはですね、 子供に何かしてやりたくても、してやるだけの資源がない。資源というのは、金銭的にもそうですし、例えば、いろんなこの、例えば本であるとかですね、文化的な要素に関しても資源に差がありますし、あるいは時間がない、忙しく働いているので、子供に構ってやる時間がない、時間資源という点でも 欠落しているような、そういうお母さん、お父さんというのが現れ始めている。で、その中で子供たちの間にですね、家庭からの支援の差が広がってきているので、それが教育達成にも反映されるようになってきている。つまり、あの堅牢な循環構造が、今や悪循環に成り下がってしまっているという状況が、これが今日の日本社会の基本的な現状である、というふうに私は考えています。

この中で、この点線の方の矢印、まあ、こう、草っと丸木橋のようになってしまったような、うまくこう、資源が流し込まれない矢印から、こぼれ落ちてしまう個人というのが、いろんな形で可視的になっています。先ほど最初にお見せしたような、例えば高齢の方であったり、例えば若者であったり、例えば女性であったり、あるいは男性の中にも、あるいは子供たちの中にも、特に障害を持たれている方や、家庭が貧困な子供たちだっていう、いろんな形で社会の中で観察されるわけですけれども、こういうこぼれ落ちてしまった、何の支えもなく孤独で、困窮状態に耐えるような個人というものが、明らかに増加してきている。しかし、こういう状況の中で、政府は高齢化していますので、高齢者の年金や医療ということを支えるためには、確かに財政的な問題というのはあります。ご存知のように、日本の財政赤字というのは、世界一と言われるほどの状況になっているわけで、お金がない、お金がないということは、これは確かではあります。あるいはオスプレイを買いたいといったような、そういうニーズもあるのかもしれません。その中で、政府は、社会構造がこのように変化する中で、かつてから気迫であったセーフティネットを、むしろもっと切り下げる。例えば、生活保護のですね、住宅費の算定基準を切り下げる、あるいは高熱費も切り下げるといったような形で、いっそセーフティネットを剥ぎ取る方向の選択をとっています。ですから、この循環自体が破綻しているにも関わらず、その周囲がですね、かつてから酸素が薄いような状況になったので、それがどんどん真空化していっている。その中で、この孤立した苦しい個人というのはですね、一層苦しい状況に置かれているというのが、これが日本の状況であり、これこそが、このような構造的な変容そのものがですね、悪をもたらしているというのが、私の認識です。そしてですね、大変絶望的なことに、ここまでで私は時間の大半を使ってしまっている、ということに気づいたわけですが、次のこれはお示しする必要があります。

## 自己と社会のイメージの変化

これは何かというとですね 日本型循環モデルが形を変えるとともに 世の中の人々の自分や周囲に対するイメージ認識も変わってきています かつてであればこのもこもこした変な形が時間の流れとともに だんだんみんな良くなっていくよねっていうような共通理解があったものが 今やそれはもうなくなっていると このもこもこした角層が分断されて 有利不利に応じて縦に並ぶようになってきているとただ有利不利であるだけではなくてですね それぞれの置かれている質的な状況が異なってきている これはいろんなデータで繰り返し確認されることです家族に関するデータ 仕事に関するデータ 教育に関するデータ 同じような構造が起きているので こういう図で示してみたんですけれども社会全体が経済が成長しない中で どの層であれ かつてと比べて苦しい状況というものは目立ってきていますでその中で有利な層であってもですね 例えば比較的高い賃金を獲得するためには異常なほどの長時間労働 過重労働に耐えなくてはならなくなっているそういう状況が出てきています またそれほど長時間労働過重労働過重労働に苦しむことはなくて済むような 例えば非正規労働者や仕事がない方っていうのは 国旗使われることによって苦しいのではなく仕事が非常に不安定で収入も不安定で いったい明日生きていけるのかと10年後の自分がイメージできない あるいは3年後もイメージできないようなそういう不安定さの中で生きている といったようにですねどちらも辛いんですけれども辛さの中身が違う 辛さの中身が違うがゆえにお互いに共感したり連帯したりすることが 前よりも難しくなっていますむしろ教会の連帯どころか 互いに憎み合うようなことにもなっているある職場における正社員はですね 非正社員に対してなんであいつら急に休むんだよもうシフトが抜けたら俺が 変わらなきゃいけないんだよっていうようなですねあいつら本当に無責任で困るよ みたいなことを正社員の側は感じあるいは非正社員の側はなんで あんなに汗細りながら会社のために長時間働いてるのあいつらバカ見て っていうようなことになっているわけですお互いに立場が違うがゆえに 詐欺み合ったり憎み合ったりすることにもつながっている それによって分断というのは一層深まっているわけです 一番最初のエピソードの一つにですね例えば生活保護バッシングなどのことも 示しましたけれども社会の各層がそれぞれ何らか 無理をしながら生きている中で誰かが悪い 誰かがずるいといったような誰かに憎悪を向けるようになって きているというのはこのような構造がその背景にあります

しかしですね いろんなデータを見ておりますと日本の人々を広く覆っているような 共通にみんながはいと答えるようなそういう調査項目もあります 例えばその典型的な一つがですね人々は個々人のその能力に応じた仕事に就いたり 能力に応じて賃金を得ることが良いことであるというそういう項目に対して 賛成する度合いというのは日本で非常に高いですここで言っている能力というのは 広い意味での能力で例えば生まれ持っている資質や あるいはどれぐらい努力できるかといったようなことまで含めていますけれどもとにかく個々人が今ある状態というのは その個々人がどれほどできる人なのかやった人なのか それに応じているべきだし実際そうなんだという発想が強いわけですけれどもそれが何をもたらしているかというとですねその共通認識が何をもたらしているかというとそれが一層分断を深めるような状況があるわけです例えばですね 比較的有利な人自分が努力したから今このCを獲得したんだぜと思っている人はですね誰にもとにかく言われる必要はないし今俺がようやく獲得したものを 誰かに分け与えてやる必要はないと思っていますとろいやつは死ぬか とろいやつは死ねというふうに強い人たちは思っている一方苦しい状況にある人たちはですねこれは自分がどこかで何か 何かが努力が足りなかったあるいは何かが劣っているこれは自分が悪かったせいだというふうに自分をどんどん攻める方向で社会から撤退していくような状況があるとその結果分断はむしろ深まっているわけですそれは社会の全体的な課題を解決する方向に 何も向かわない個々人の置かれている状況を 個々人の努力や能力や資質で説明してしまってはですね今私たちが置かれている一つ前にお示ししたような この構造の破綻これをどうしていくんだというところの議論に なかなか進まないわけですその結果解決は遅れているさて先ほど5分前というフリップを 見せていただきましたこの後私が今お話したことが決して妄想などではない ということをお見せしたくてですね実はこのパワーポイントには 大量のデータを貼り付けてありますしかしそれをご説明していくことは無理ですまああの ありますということだけお見せしていきたいと思います

## データで見る日本社会の現状

もちろん高齢化はどんどん進んでいます。 労働力人口は減っている。 一体この社会これからどうやって持たせるんだ。維持できるのかというところに今立ち至っているわけです。 貧困も増えてきている。特に子どもや母子家庭の貧困が国際的に見ても著しい。 今ひどいのは日本の仕事の現状です。正社員はあれもやれこれもやれとにかく限定なく優秀な人ほど過重な長時間の要請の労働に要求されるようになってきている。一方で非正社員の方は非常に不安定な状況に置かれているんですが、 今その正社員の過重さと非正社員の不安定さの悪いとこ取りをするような形の働かせ方が広がっている。それがいわゆるブラック企業とかブラックバイトと呼ばれるものである。

日本の大きな問題は働き方にある。 これはちょっと強調しておきたいところです。その結果ですね、仕事につけない若者や女性がどんどん非正規に追い込まれておりながら活躍しろとも言われている。そういう状況がある。で、活躍しろと言われながらこれほどの賃金差別というのはまだある。一方で正社員の長時間労働は今や韓国よりも悪い。これこの一つ前のデータでは韓国の方が長時間労働が多かったんですけれども、今や日本の方が多い。で、政府は教育にはお金を払わない。特に修学前と高等教育に関しては日本では私費負担でやってくれという、そういう話が通用してしまっている。で、あるが故に家庭は苦しいわけです。で、奨学金制度も手をついた。使われる図なんでご覧になったことがあるかもしれませんけれども、多くの国は授業料が低いか、もしくは奨学金で手当てをするかという形で、高等教育を受ける人を支援しているわけですが、日本は奨学金政策の割合は、対象者の割合は低いですし、授業料は、これ国立だけ取ってもですね、相対的に高いわけですね。ここに手術を書き加えたら、ものすごく高いわけです。他の世界の国々とぴょんと離れた、得意な位置にあるというのが、日本の高等教育財政構造である。で、日本の奨学金というのはローンなので、奨学金と呼ぶに値しません。ですからこの図はそもそも間違っているわけです。で、このようにして高いお金を払った教育が、実際に若者を社会で生きていく上で、支えてくれるような存在になってくれる上で、意味や意義を持ち得ているかということをですね、検討すると、やはり非常に気迫です。初等・中等教育であれ、高等教育であれ、そこで学んだことが、自分の今の生活や将来の市民としての在り方、あるいは職業人としての在り方に役に立った、有用であったという、そういう回答は世界的に見ても、いろんな国際比較データで見ても、必ず日本はそこの水準です。ちなみに私の授業は違います。いや、すいません。いやいやいや。でですね、こういう中で、すいません、掛け足で。例えば、あなたは自分のお父さんを超えられましたかという、そういう質問に対して、2本見つけられますか。下から2つ目ですね。父親を超えられたと答える人の水準というのは、これだけの国が並んでいる中で最低です。で、あなたは自分の人生をどれほど変えられると思いますかというふうに聞くとですね、男性であれ、女性であれ、自分の人生は自分で何とかしていけると思っている人たちの比率は、やはり世界最低水準である。自殺率は高い。日本は、かつての戦後日本型循環モデルに凝り固まった社会、それが破綻しているにも関わらず、変えることができない、そういう中でですね、どんどん自滅を進めていっているように見えます。

## 新たな社会モデル

しかし、そうやって手をこもねいて天を仰いでいるわけにはいきません。 対処はしなければならない。 たとえ難しくてもしなければならない。で、馬鹿みたいな図ですけれども、私が考えてみた 対処の青写真というのはですね、どういうことかというと、一方向の矢印で繋がれていた過去の循環モデルは、 それが成立していた頃から問題含みでしたし、 もう成立しなくなっています。過去は良かったといくら言ってみても、 人口構造も世界的な経済構造も変わっています。 もう戻ることはできませんし、戻ることは望ましくもない。とすればですね、私たちがこれから先に思い描く 新しい社会モデルというのは、この領域の間に一方向ではなく、双方向の矢印、 均衡や連携の関係を作り出していくという方向しかない。

つまり、具体的に言うとですね、例えば 教育と仕事の間には、どんどん卒業生を送り出したりすれば、企業が受け取って、よしよしと育ててくれるような関係が もう見込めなくなったとすれば、教育がその職業人をちゃんとたくましく養成するという役割も 担わなければならない。あるいは家族と教育の間もですね、これまでは家族が必死で 子どもたちの教育を後から支えていましたけれども、そういう家族ばかりではないとすれば、 逆に教育から家族に対して支援の手を伸ばすことができるような、 そういう教育にする必要がある。そうなると教育の負担は、 家族よりも増えますので、今までのようにギリギリまで支出を抑制してくるような 安上がりの雑な、そういう高教育で済むわけがない。家族と仕事の間にも、 男性も女性も働いて、家族と仕事が両立できるような、 そういう働き方、あるいは家族の在り方を作っていくしかない。 しかしですね、この関係だけで、もう物事は解決できなくなっています。 苦しい人はどんどん生み出されます。せめて死なない程度の、 生きていてもいいんだと思える程度のセーフティネットすら、 今の政府は引いていません。それは政府の責任として引くべきです。

加えてですね、どんなセーフティネットを引いても、 そこに苦しい人がどんどん溜まっていっては、そのネットも破れますので、 一度苦しい人を受け止めて、でももう一度元気になってもらって、 社会の機能を支える働き、あるいは税金なども、 もし納めてもらえるようなことまでしてもらえば、大変嬉しい。 ただできる範囲でお願いだから、助けてくださいという形で、 苦しい人にもう一回アクティブになってもらう。それをアクティベーションと言いますけれども、セーフティネットとアクティベーションの 2枚の布団を重ねて敷いておく必要がある。

しかし今の日本は、苦しい人はとにかく セーフティネットに押し込んでおけと。で、そのセーフティネットの置き合いや水際に、 できるだけセーフティネットに入れなくて済むように、セーフティネットないままのアクティベーションで、 いいから働いてくれよというような、対象にするようなですね、 そういう施策を展開しています。それは機能しない。 でもまだやっている。というようにですね、 この雑な青写真に基づいて、私はいろんなことを見定めようとしています。この動きはいいことか、 この動きはダメなことかということを考える際に、これは私にとっての基準になっているわけです。

もし、これに一理あるというふうにお考えであれば、 このような方向への社会の転換というのは、どこかスイッチ1個押せば、 どこか政策法律1個変えれば進むようなことではありません。これは社会の全域に及ぶことだからです。

ですから、大勢の人のですね、 たくさんの人のそれぞれの現場での活動ということが不可欠です。

もし、納得したと言ってもらえるのであれば、 ぜひ皆様も何らかの形で、このような方向に社会の形を変えていく上で、 力を貸していただければと思います。ちょっと延びて申し訳ありません。 以上です。終わりです。

ありがとうございました。 Thank you.