"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
const iam = require("@aws-cdk/aws-iam");
const ec2 = require("@aws-cdk/aws-ec2");
class GitlabContainerRunner extends cdk.Construct {
    constructor(scope, id, props) {
        var _a, _b, _c, _d, _e, _f, _g;
        super(scope, id);
        const vpc = (_a = props.selfvpc) !== null && _a !== void 0 ? _a : new ec2.Vpc(this, 'VPC', {
            cidr: '10.0.0.0/16',
            maxAzs: 2,
            subnetConfiguration: [{
                    cidrMask: 26,
                    name: 'RunnerVPC',
                    subnetType: ec2.SubnetType.PUBLIC,
                }],
            natGateways: 0,
        });
        var token = props.gitlabtoken;
        var tag1 = (_b = props.tag1) !== null && _b !== void 0 ? _b : 'gitlab';
        var tag2 = (_c = props.tag2) !== null && _c !== void 0 ? _c : 'awscdk';
        var tag3 = (_d = props.tag3) !== null && _d !== void 0 ? _d : 'runner';
        var gitlaburl = (_e = props.gitlaburl) !== null && _e !== void 0 ? _e : 'https://gitlab.com/';
        var ec2type = (_f = props.ec2type) !== null && _f !== void 0 ? _f : 't3.micro';
        const shell = ec2.UserData.forLinux();
        shell.addCommands('yum update -y');
        shell.addCommands('yum install docker -y');
        shell.addCommands('service docker start');
        shell.addCommands('usermod -aG docker ec2-user');
        shell.addCommands('chmod +x /var/run/docker.sock');
        shell.addCommands('service docker restart &&  chkconfig docker on');
        shell.addCommands('docker run -d -v /home/ec2-user/.gitlab-runner:/etc/gitlab-runner -v /var/run/docker.sock:/var/run/docker.sock --name gitlab-runner-register gitlab/gitlab-runner:alpine register --non-interactive --url ' + gitlaburl + ' --registration-token ' + token + ' --docker-pull-policy if-not-present --docker-volumes \"/var/run/docker.sock:/var/run/docker.sock\" --executor docker --docker-image \"alpine:latest\" --description \"Docker Runner\" --tag-list \"' + tag1 + ',' + tag2 + ',' + tag3 + '\" --docker-privileged');
        shell.addCommands('sleep 2 && docker run --restart always -d -v /home/ec2-user/.gitlab-runner:/etc/gitlab-runner -v /var/run/docker.sock:/var/run/docker.sock --name gitlab-runner gitlab/gitlab-runner:alpine');
        shell.addCommands('usermod -aG docker ssm-user');
        const ec2role = this.runnerRole = (_g = props.ec2iamrole) !== null && _g !== void 0 ? _g : new iam.Role(this, 'runner-role', {
            assumedBy: new iam.ServicePrincipal('ec2.amazonaws.com'),
            description: 'For Gitlab EC2 Runner Role',
        });
        const runner = this.runnerEc2 = new ec2.Instance(this, 'GitlabRunner', {
            instanceType: new ec2.InstanceType(ec2type),
            instanceName: 'Gitlab-Runner',
            vpc,
            machineImage: ec2.MachineImage.latestAmazonLinux({ generation: ec2.AmazonLinuxGeneration.AMAZON_LINUX_2 }),
            role: ec2role,
            userData: shell,
            blockDevices: [({ deviceName: '/dev/xvda', volume: ec2.BlockDeviceVolume.ebs(60) })],
        });
        runner.role.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'));
        new cdk.CfnOutput(this, 'Runner-Instance-ID', { value: runner.instanceId });
        new cdk.CfnOutput(this, 'Runner-Role-Arn', { value: runner.role.roleArn });
    }
}
exports.GitlabContainerRunner = GitlabContainerRunner;
//# sourceMappingURL=data:application/json;base64,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