import * as cdk from '@aws-cdk/core';
import * as iam from '@aws-cdk/aws-iam';
import * as ec2 from '@aws-cdk/aws-ec2';
export interface GitlabContainerRunnerProps {
    readonly gitlabtoken: string;
    readonly ec2type?: string;
    readonly selfvpc?: ec2.IVpc;
    readonly ec2iamrole?: iam.IRole;
    readonly tag1?: string;
    readonly tag2?: string;
    readonly tag3?: string;
    readonly gitlaburl?: string;
}
export declare class GitlabContainerRunner extends cdk.Construct {
    readonly runnerRole: iam.IRole;
    readonly runnerEc2: ec2.IInstance;
    constructor(scope: cdk.Construct, id: string, props: GitlabContainerRunnerProps);
}
