"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VirtualNodeListener = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const utils_1 = require("./private/utils");
const shared_interfaces_1 = require("./shared-interfaces");
/**
 * (experimental) Defines listener for a VirtualNode.
 *
 * @experimental
 */
class VirtualNodeListener {
    /**
     * (experimental) Returns an HTTP Listener for a VirtualNode.
     *
     * @experimental
     */
    static http(props = {}) {
        return new VirtualNodeListenerImpl(shared_interfaces_1.Protocol.HTTP, props.healthCheck, props.timeout, props.port, props.tlsCertificate, props.outlierDetection, props.connectionPool);
    }
    /**
     * (experimental) Returns an HTTP2 Listener for a VirtualNode.
     *
     * @experimental
     */
    static http2(props = {}) {
        return new VirtualNodeListenerImpl(shared_interfaces_1.Protocol.HTTP2, props.healthCheck, props.timeout, props.port, props.tlsCertificate, props.outlierDetection, props.connectionPool);
    }
    /**
     * (experimental) Returns an GRPC Listener for a VirtualNode.
     *
     * @experimental
     */
    static grpc(props = {}) {
        return new VirtualNodeListenerImpl(shared_interfaces_1.Protocol.GRPC, props.healthCheck, props.timeout, props.port, props.tlsCertificate, props.outlierDetection, props.connectionPool);
    }
    /**
     * (experimental) Returns an TCP Listener for a VirtualNode.
     *
     * @experimental
     */
    static tcp(props = {}) {
        return new VirtualNodeListenerImpl(shared_interfaces_1.Protocol.TCP, props.healthCheck, props.timeout, props.port, props.tlsCertificate, props.outlierDetection, props.connectionPool);
    }
}
exports.VirtualNodeListener = VirtualNodeListener;
_a = JSII_RTTI_SYMBOL_1;
VirtualNodeListener[_a] = { fqn: "@aws-cdk/aws-appmesh.VirtualNodeListener", version: "1.101.0" };
class VirtualNodeListenerImpl extends VirtualNodeListener {
    constructor(protocol, healthCheck, timeout, port = 8080, tlsCertificate, outlierDetection, connectionPool) {
        super();
        this.protocol = protocol;
        this.healthCheck = healthCheck;
        this.timeout = timeout;
        this.port = port;
        this.tlsCertificate = tlsCertificate;
        this.outlierDetection = outlierDetection;
        this.connectionPool = connectionPool;
    }
    bind(scope) {
        var _b;
        const tlsConfig = (_b = this.tlsCertificate) === null || _b === void 0 ? void 0 : _b.bind(scope);
        return {
            listener: {
                portMapping: {
                    port: this.port,
                    protocol: this.protocol,
                },
                healthCheck: this.healthCheck ? this.renderHealthCheck(this.healthCheck) : undefined,
                timeout: this.timeout ? this.renderTimeout(this.timeout) : undefined,
                tls: tlsConfig ? this.renderTls(tlsConfig) : undefined,
                outlierDetection: this.outlierDetection ? this.renderOutlierDetection(this.outlierDetection) : undefined,
                connectionPool: this.connectionPool ? this.renderConnectionPool(this.connectionPool) : undefined,
            },
        };
    }
    /**
     * Renders the TLS config for a listener
     */
    renderTls(tlsCertificateConfig) {
        return {
            certificate: tlsCertificateConfig.tlsCertificate,
            mode: tlsCertificateConfig.tlsMode.toString(),
        };
    }
    renderHealthCheck(hc) {
        if (hc === undefined) {
            return undefined;
        }
        if (hc.protocol === shared_interfaces_1.Protocol.TCP && hc.path) {
            throw new Error('The path property cannot be set with Protocol.TCP');
        }
        if (hc.protocol === shared_interfaces_1.Protocol.GRPC && hc.path) {
            throw new Error('The path property cannot be set with Protocol.GRPC');
        }
        const healthCheck = {
            healthyThreshold: hc.healthyThreshold || 2,
            intervalMillis: (hc.interval || cdk.Duration.seconds(5)).toMilliseconds(),
            path: hc.path || (hc.protocol === shared_interfaces_1.Protocol.HTTP ? '/' : undefined),
            port: hc.port || this.port,
            protocol: hc.protocol || this.protocol,
            timeoutMillis: (hc.timeout || cdk.Duration.seconds(2)).toMilliseconds(),
            unhealthyThreshold: hc.unhealthyThreshold || 2,
        };
        utils_1.validateHealthChecks(healthCheck);
        return healthCheck;
    }
    renderTimeout(timeout) {
        return ({
            [this.protocol]: {
                idle: (timeout === null || timeout === void 0 ? void 0 : timeout.idle) !== undefined ? {
                    unit: 'ms',
                    value: timeout === null || timeout === void 0 ? void 0 : timeout.idle.toMilliseconds(),
                } : undefined,
                perRequest: (timeout === null || timeout === void 0 ? void 0 : timeout.perRequest) !== undefined ? {
                    unit: 'ms',
                    value: timeout === null || timeout === void 0 ? void 0 : timeout.perRequest.toMilliseconds(),
                } : undefined,
            },
        });
    }
    renderOutlierDetection(outlierDetection) {
        return {
            baseEjectionDuration: {
                unit: 'ms',
                value: outlierDetection.baseEjectionDuration.toMilliseconds(),
            },
            interval: {
                unit: 'ms',
                value: outlierDetection.interval.toMilliseconds(),
            },
            maxEjectionPercent: outlierDetection.maxEjectionPercent,
            maxServerErrors: outlierDetection.maxServerErrors,
        };
    }
    renderConnectionPool(connectionPool) {
        return ({
            [this.protocol]: {
                maxRequests: (connectionPool === null || connectionPool === void 0 ? void 0 : connectionPool.maxRequests) !== undefined ? connectionPool.maxRequests : undefined,
                maxConnections: (connectionPool === null || connectionPool === void 0 ? void 0 : connectionPool.maxConnections) !== undefined ? connectionPool.maxConnections : undefined,
                maxPendingRequests: (connectionPool === null || connectionPool === void 0 ? void 0 : connectionPool.maxPendingRequests) !== undefined ? connectionPool.maxPendingRequests : undefined,
            },
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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