import { CfnVirtualGateway, CfnVirtualNode } from '../appmesh.generated';
declare type AppMeshHealthCheck = CfnVirtualNode.HealthCheckProperty | CfnVirtualGateway.VirtualGatewayHealthCheckPolicyProperty;
/**
 * Validates health check properties, throws an error if they are misconfigured.
 *
 * @param healthCheck Healthcheck property from a Virtual Node or Virtual Gateway
 */
export declare function validateHealthChecks(healthCheck: AppMeshHealthCheck): void;
/**
 * Generated Connection pool config
 */
export interface ConnectionPoolConfig {
    /**
     * The maximum connections in the pool
     *
     * @default - none
     */
    readonly maxConnections?: number;
    /**
     * The maximum pending requests in the pool
     *
     * @default - none
     */
    readonly maxPendingRequests?: number;
    /**
     * The maximum requests in the pool
     *
     * @default - none
     */
    readonly maxRequests?: number;
}
export {};
