"""Data derived from the Unicode character database (UCD).

This file was generated from pyunormalize/tools/generate_unicode.py
"""

UNICODE_VERSION = "15.0.0"

# Character decomposition mappings (not including Hangul syllables)
_DECOMP = {
    0x000A0: ["<noBreak>", 0x0020],  # NO-BREAK SPACE
    0x000A8: ["<compat>", 0x0020, 0x0308],  # DIAERESIS
    0x000AA: ["<super>", 0x0061],  # FEMININE ORDINAL INDICATOR
    0x000AF: ["<compat>", 0x0020, 0x0304],  # MACRON
    0x000B2: ["<super>", 0x0032],  # SUPERSCRIPT TWO
    0x000B3: ["<super>", 0x0033],  # SUPERSCRIPT THREE
    0x000B4: ["<compat>", 0x0020, 0x0301],  # ACUTE ACCENT
    0x000B5: ["<compat>", 0x03BC],  # MICRO SIGN
    0x000B8: ["<compat>", 0x0020, 0x0327],  # CEDILLA
    0x000B9: ["<super>", 0x0031],  # SUPERSCRIPT ONE
    0x000BA: ["<super>", 0x006F],  # MASCULINE ORDINAL INDICATOR
    0x000BC: ["<fraction>", 0x0031, 0x2044, 0x0034],  # VULGAR FRACTION ONE QUARTER
    0x000BD: ["<fraction>", 0x0031, 0x2044, 0x0032],  # VULGAR FRACTION ONE HALF
    0x000BE: ["<fraction>", 0x0033, 0x2044, 0x0034],  # VULGAR FRACTION THREE QUARTERS
    0x000C0: [0x0041, 0x0300],  # LATIN CAPITAL LETTER A WITH GRAVE
    0x000C1: [0x0041, 0x0301],  # LATIN CAPITAL LETTER A WITH ACUTE
    0x000C2: [0x0041, 0x0302],  # LATIN CAPITAL LETTER A WITH CIRCUMFLEX
    0x000C3: [0x0041, 0x0303],  # LATIN CAPITAL LETTER A WITH TILDE
    0x000C4: [0x0041, 0x0308],  # LATIN CAPITAL LETTER A WITH DIAERESIS
    0x000C5: [0x0041, 0x030A],  # LATIN CAPITAL LETTER A WITH RING ABOVE
    0x000C7: [0x0043, 0x0327],  # LATIN CAPITAL LETTER C WITH CEDILLA
    0x000C8: [0x0045, 0x0300],  # LATIN CAPITAL LETTER E WITH GRAVE
    0x000C9: [0x0045, 0x0301],  # LATIN CAPITAL LETTER E WITH ACUTE
    0x000CA: [0x0045, 0x0302],  # LATIN CAPITAL LETTER E WITH CIRCUMFLEX
    0x000CB: [0x0045, 0x0308],  # LATIN CAPITAL LETTER E WITH DIAERESIS
    0x000CC: [0x0049, 0x0300],  # LATIN CAPITAL LETTER I WITH GRAVE
    0x000CD: [0x0049, 0x0301],  # LATIN CAPITAL LETTER I WITH ACUTE
    0x000CE: [0x0049, 0x0302],  # LATIN CAPITAL LETTER I WITH CIRCUMFLEX
    0x000CF: [0x0049, 0x0308],  # LATIN CAPITAL LETTER I WITH DIAERESIS
    0x000D1: [0x004E, 0x0303],  # LATIN CAPITAL LETTER N WITH TILDE
    0x000D2: [0x004F, 0x0300],  # LATIN CAPITAL LETTER O WITH GRAVE
    0x000D3: [0x004F, 0x0301],  # LATIN CAPITAL LETTER O WITH ACUTE
    0x000D4: [0x004F, 0x0302],  # LATIN CAPITAL LETTER O WITH CIRCUMFLEX
    0x000D5: [0x004F, 0x0303],  # LATIN CAPITAL LETTER O WITH TILDE
    0x000D6: [0x004F, 0x0308],  # LATIN CAPITAL LETTER O WITH DIAERESIS
    0x000D9: [0x0055, 0x0300],  # LATIN CAPITAL LETTER U WITH GRAVE
    0x000DA: [0x0055, 0x0301],  # LATIN CAPITAL LETTER U WITH ACUTE
    0x000DB: [0x0055, 0x0302],  # LATIN CAPITAL LETTER U WITH CIRCUMFLEX
    0x000DC: [0x0055, 0x0308],  # LATIN CAPITAL LETTER U WITH DIAERESIS
    0x000DD: [0x0059, 0x0301],  # LATIN CAPITAL LETTER Y WITH ACUTE
    0x000E0: [0x0061, 0x0300],  # LATIN SMALL LETTER A WITH GRAVE
    0x000E1: [0x0061, 0x0301],  # LATIN SMALL LETTER A WITH ACUTE
    0x000E2: [0x0061, 0x0302],  # LATIN SMALL LETTER A WITH CIRCUMFLEX
    0x000E3: [0x0061, 0x0303],  # LATIN SMALL LETTER A WITH TILDE
    0x000E4: [0x0061, 0x0308],  # LATIN SMALL LETTER A WITH DIAERESIS
    0x000E5: [0x0061, 0x030A],  # LATIN SMALL LETTER A WITH RING ABOVE
    0x000E7: [0x0063, 0x0327],  # LATIN SMALL LETTER C WITH CEDILLA
    0x000E8: [0x0065, 0x0300],  # LATIN SMALL LETTER E WITH GRAVE
    0x000E9: [0x0065, 0x0301],  # LATIN SMALL LETTER E WITH ACUTE
    0x000EA: [0x0065, 0x0302],  # LATIN SMALL LETTER E WITH CIRCUMFLEX
    0x000EB: [0x0065, 0x0308],  # LATIN SMALL LETTER E WITH DIAERESIS
    0x000EC: [0x0069, 0x0300],  # LATIN SMALL LETTER I WITH GRAVE
    0x000ED: [0x0069, 0x0301],  # LATIN SMALL LETTER I WITH ACUTE
    0x000EE: [0x0069, 0x0302],  # LATIN SMALL LETTER I WITH CIRCUMFLEX
    0x000EF: [0x0069, 0x0308],  # LATIN SMALL LETTER I WITH DIAERESIS
    0x000F1: [0x006E, 0x0303],  # LATIN SMALL LETTER N WITH TILDE
    0x000F2: [0x006F, 0x0300],  # LATIN SMALL LETTER O WITH GRAVE
    0x000F3: [0x006F, 0x0301],  # LATIN SMALL LETTER O WITH ACUTE
    0x000F4: [0x006F, 0x0302],  # LATIN SMALL LETTER O WITH CIRCUMFLEX
    0x000F5: [0x006F, 0x0303],  # LATIN SMALL LETTER O WITH TILDE
    0x000F6: [0x006F, 0x0308],  # LATIN SMALL LETTER O WITH DIAERESIS
    0x000F9: [0x0075, 0x0300],  # LATIN SMALL LETTER U WITH GRAVE
    0x000FA: [0x0075, 0x0301],  # LATIN SMALL LETTER U WITH ACUTE
    0x000FB: [0x0075, 0x0302],  # LATIN SMALL LETTER U WITH CIRCUMFLEX
    0x000FC: [0x0075, 0x0308],  # LATIN SMALL LETTER U WITH DIAERESIS
    0x000FD: [0x0079, 0x0301],  # LATIN SMALL LETTER Y WITH ACUTE
    0x000FF: [0x0079, 0x0308],  # LATIN SMALL LETTER Y WITH DIAERESIS
    0x00100: [0x0041, 0x0304],  # LATIN CAPITAL LETTER A WITH MACRON
    0x00101: [0x0061, 0x0304],  # LATIN SMALL LETTER A WITH MACRON
    0x00102: [0x0041, 0x0306],  # LATIN CAPITAL LETTER A WITH BREVE
    0x00103: [0x0061, 0x0306],  # LATIN SMALL LETTER A WITH BREVE
    0x00104: [0x0041, 0x0328],  # LATIN CAPITAL LETTER A WITH OGONEK
    0x00105: [0x0061, 0x0328],  # LATIN SMALL LETTER A WITH OGONEK
    0x00106: [0x0043, 0x0301],  # LATIN CAPITAL LETTER C WITH ACUTE
    0x00107: [0x0063, 0x0301],  # LATIN SMALL LETTER C WITH ACUTE
    0x00108: [0x0043, 0x0302],  # LATIN CAPITAL LETTER C WITH CIRCUMFLEX
    0x00109: [0x0063, 0x0302],  # LATIN SMALL LETTER C WITH CIRCUMFLEX
    0x0010A: [0x0043, 0x0307],  # LATIN CAPITAL LETTER C WITH DOT ABOVE
    0x0010B: [0x0063, 0x0307],  # LATIN SMALL LETTER C WITH DOT ABOVE
    0x0010C: [0x0043, 0x030C],  # LATIN CAPITAL LETTER C WITH CARON
    0x0010D: [0x0063, 0x030C],  # LATIN SMALL LETTER C WITH CARON
    0x0010E: [0x0044, 0x030C],  # LATIN CAPITAL LETTER D WITH CARON
    0x0010F: [0x0064, 0x030C],  # LATIN SMALL LETTER D WITH CARON
    0x00112: [0x0045, 0x0304],  # LATIN CAPITAL LETTER E WITH MACRON
    0x00113: [0x0065, 0x0304],  # LATIN SMALL LETTER E WITH MACRON
    0x00114: [0x0045, 0x0306],  # LATIN CAPITAL LETTER E WITH BREVE
    0x00115: [0x0065, 0x0306],  # LATIN SMALL LETTER E WITH BREVE
    0x00116: [0x0045, 0x0307],  # LATIN CAPITAL LETTER E WITH DOT ABOVE
    0x00117: [0x0065, 0x0307],  # LATIN SMALL LETTER E WITH DOT ABOVE
    0x00118: [0x0045, 0x0328],  # LATIN CAPITAL LETTER E WITH OGONEK
    0x00119: [0x0065, 0x0328],  # LATIN SMALL LETTER E WITH OGONEK
    0x0011A: [0x0045, 0x030C],  # LATIN CAPITAL LETTER E WITH CARON
    0x0011B: [0x0065, 0x030C],  # LATIN SMALL LETTER E WITH CARON
    0x0011C: [0x0047, 0x0302],  # LATIN CAPITAL LETTER G WITH CIRCUMFLEX
    0x0011D: [0x0067, 0x0302],  # LATIN SMALL LETTER G WITH CIRCUMFLEX
    0x0011E: [0x0047, 0x0306],  # LATIN CAPITAL LETTER G WITH BREVE
    0x0011F: [0x0067, 0x0306],  # LATIN SMALL LETTER G WITH BREVE
    0x00120: [0x0047, 0x0307],  # LATIN CAPITAL LETTER G WITH DOT ABOVE
    0x00121: [0x0067, 0x0307],  # LATIN SMALL LETTER G WITH DOT ABOVE
    0x00122: [0x0047, 0x0327],  # LATIN CAPITAL LETTER G WITH CEDILLA
    0x00123: [0x0067, 0x0327],  # LATIN SMALL LETTER G WITH CEDILLA
    0x00124: [0x0048, 0x0302],  # LATIN CAPITAL LETTER H WITH CIRCUMFLEX
    0x00125: [0x0068, 0x0302],  # LATIN SMALL LETTER H WITH CIRCUMFLEX
    0x00128: [0x0049, 0x0303],  # LATIN CAPITAL LETTER I WITH TILDE
    0x00129: [0x0069, 0x0303],  # LATIN SMALL LETTER I WITH TILDE
    0x0012A: [0x0049, 0x0304],  # LATIN CAPITAL LETTER I WITH MACRON
    0x0012B: [0x0069, 0x0304],  # LATIN SMALL LETTER I WITH MACRON
    0x0012C: [0x0049, 0x0306],  # LATIN CAPITAL LETTER I WITH BREVE
    0x0012D: [0x0069, 0x0306],  # LATIN SMALL LETTER I WITH BREVE
    0x0012E: [0x0049, 0x0328],  # LATIN CAPITAL LETTER I WITH OGONEK
    0x0012F: [0x0069, 0x0328],  # LATIN SMALL LETTER I WITH OGONEK
    0x00130: [0x0049, 0x0307],  # LATIN CAPITAL LETTER I WITH DOT ABOVE
    0x00132: ["<compat>", 0x0049, 0x004A],  # LATIN CAPITAL LIGATURE IJ
    0x00133: ["<compat>", 0x0069, 0x006A],  # LATIN SMALL LIGATURE IJ
    0x00134: [0x004A, 0x0302],  # LATIN CAPITAL LETTER J WITH CIRCUMFLEX
    0x00135: [0x006A, 0x0302],  # LATIN SMALL LETTER J WITH CIRCUMFLEX
    0x00136: [0x004B, 0x0327],  # LATIN CAPITAL LETTER K WITH CEDILLA
    0x00137: [0x006B, 0x0327],  # LATIN SMALL LETTER K WITH CEDILLA
    0x00139: [0x004C, 0x0301],  # LATIN CAPITAL LETTER L WITH ACUTE
    0x0013A: [0x006C, 0x0301],  # LATIN SMALL LETTER L WITH ACUTE
    0x0013B: [0x004C, 0x0327],  # LATIN CAPITAL LETTER L WITH CEDILLA
    0x0013C: [0x006C, 0x0327],  # LATIN SMALL LETTER L WITH CEDILLA
    0x0013D: [0x004C, 0x030C],  # LATIN CAPITAL LETTER L WITH CARON
    0x0013E: [0x006C, 0x030C],  # LATIN SMALL LETTER L WITH CARON
    0x0013F: ["<compat>", 0x004C, 0x00B7],  # LATIN CAPITAL LETTER L WITH MIDDLE DOT
    0x00140: ["<compat>", 0x006C, 0x00B7],  # LATIN SMALL LETTER L WITH MIDDLE DOT
    0x00143: [0x004E, 0x0301],  # LATIN CAPITAL LETTER N WITH ACUTE
    0x00144: [0x006E, 0x0301],  # LATIN SMALL LETTER N WITH ACUTE
    0x00145: [0x004E, 0x0327],  # LATIN CAPITAL LETTER N WITH CEDILLA
    0x00146: [0x006E, 0x0327],  # LATIN SMALL LETTER N WITH CEDILLA
    0x00147: [0x004E, 0x030C],  # LATIN CAPITAL LETTER N WITH CARON
    0x00148: [0x006E, 0x030C],  # LATIN SMALL LETTER N WITH CARON
    0x00149: ["<compat>", 0x02BC, 0x006E],  # LATIN SMALL LETTER N PRECEDED BY APOSTROPHE
    0x0014C: [0x004F, 0x0304],  # LATIN CAPITAL LETTER O WITH MACRON
    0x0014D: [0x006F, 0x0304],  # LATIN SMALL LETTER O WITH MACRON
    0x0014E: [0x004F, 0x0306],  # LATIN CAPITAL LETTER O WITH BREVE
    0x0014F: [0x006F, 0x0306],  # LATIN SMALL LETTER O WITH BREVE
    0x00150: [0x004F, 0x030B],  # LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
    0x00151: [0x006F, 0x030B],  # LATIN SMALL LETTER O WITH DOUBLE ACUTE
    0x00154: [0x0052, 0x0301],  # LATIN CAPITAL LETTER R WITH ACUTE
    0x00155: [0x0072, 0x0301],  # LATIN SMALL LETTER R WITH ACUTE
    0x00156: [0x0052, 0x0327],  # LATIN CAPITAL LETTER R WITH CEDILLA
    0x00157: [0x0072, 0x0327],  # LATIN SMALL LETTER R WITH CEDILLA
    0x00158: [0x0052, 0x030C],  # LATIN CAPITAL LETTER R WITH CARON
    0x00159: [0x0072, 0x030C],  # LATIN SMALL LETTER R WITH CARON
    0x0015A: [0x0053, 0x0301],  # LATIN CAPITAL LETTER S WITH ACUTE
    0x0015B: [0x0073, 0x0301],  # LATIN SMALL LETTER S WITH ACUTE
    0x0015C: [0x0053, 0x0302],  # LATIN CAPITAL LETTER S WITH CIRCUMFLEX
    0x0015D: [0x0073, 0x0302],  # LATIN SMALL LETTER S WITH CIRCUMFLEX
    0x0015E: [0x0053, 0x0327],  # LATIN CAPITAL LETTER S WITH CEDILLA
    0x0015F: [0x0073, 0x0327],  # LATIN SMALL LETTER S WITH CEDILLA
    0x00160: [0x0053, 0x030C],  # LATIN CAPITAL LETTER S WITH CARON
    0x00161: [0x0073, 0x030C],  # LATIN SMALL LETTER S WITH CARON
    0x00162: [0x0054, 0x0327],  # LATIN CAPITAL LETTER T WITH CEDILLA
    0x00163: [0x0074, 0x0327],  # LATIN SMALL LETTER T WITH CEDILLA
    0x00164: [0x0054, 0x030C],  # LATIN CAPITAL LETTER T WITH CARON
    0x00165: [0x0074, 0x030C],  # LATIN SMALL LETTER T WITH CARON
    0x00168: [0x0055, 0x0303],  # LATIN CAPITAL LETTER U WITH TILDE
    0x00169: [0x0075, 0x0303],  # LATIN SMALL LETTER U WITH TILDE
    0x0016A: [0x0055, 0x0304],  # LATIN CAPITAL LETTER U WITH MACRON
    0x0016B: [0x0075, 0x0304],  # LATIN SMALL LETTER U WITH MACRON
    0x0016C: [0x0055, 0x0306],  # LATIN CAPITAL LETTER U WITH BREVE
    0x0016D: [0x0075, 0x0306],  # LATIN SMALL LETTER U WITH BREVE
    0x0016E: [0x0055, 0x030A],  # LATIN CAPITAL LETTER U WITH RING ABOVE
    0x0016F: [0x0075, 0x030A],  # LATIN SMALL LETTER U WITH RING ABOVE
    0x00170: [0x0055, 0x030B],  # LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
    0x00171: [0x0075, 0x030B],  # LATIN SMALL LETTER U WITH DOUBLE ACUTE
    0x00172: [0x0055, 0x0328],  # LATIN CAPITAL LETTER U WITH OGONEK
    0x00173: [0x0075, 0x0328],  # LATIN SMALL LETTER U WITH OGONEK
    0x00174: [0x0057, 0x0302],  # LATIN CAPITAL LETTER W WITH CIRCUMFLEX
    0x00175: [0x0077, 0x0302],  # LATIN SMALL LETTER W WITH CIRCUMFLEX
    0x00176: [0x0059, 0x0302],  # LATIN CAPITAL LETTER Y WITH CIRCUMFLEX
    0x00177: [0x0079, 0x0302],  # LATIN SMALL LETTER Y WITH CIRCUMFLEX
    0x00178: [0x0059, 0x0308],  # LATIN CAPITAL LETTER Y WITH DIAERESIS
    0x00179: [0x005A, 0x0301],  # LATIN CAPITAL LETTER Z WITH ACUTE
    0x0017A: [0x007A, 0x0301],  # LATIN SMALL LETTER Z WITH ACUTE
    0x0017B: [0x005A, 0x0307],  # LATIN CAPITAL LETTER Z WITH DOT ABOVE
    0x0017C: [0x007A, 0x0307],  # LATIN SMALL LETTER Z WITH DOT ABOVE
    0x0017D: [0x005A, 0x030C],  # LATIN CAPITAL LETTER Z WITH CARON
    0x0017E: [0x007A, 0x030C],  # LATIN SMALL LETTER Z WITH CARON
    0x0017F: ["<compat>", 0x0073],  # LATIN SMALL LETTER LONG S
    0x001A0: [0x004F, 0x031B],  # LATIN CAPITAL LETTER O WITH HORN
    0x001A1: [0x006F, 0x031B],  # LATIN SMALL LETTER O WITH HORN
    0x001AF: [0x0055, 0x031B],  # LATIN CAPITAL LETTER U WITH HORN
    0x001B0: [0x0075, 0x031B],  # LATIN SMALL LETTER U WITH HORN
    0x001C4: ["<compat>", 0x0044, 0x017D],  # LATIN CAPITAL LETTER DZ WITH CARON
    0x001C5: ["<compat>", 0x0044, 0x017E],  # LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON
    0x001C6: ["<compat>", 0x0064, 0x017E],  # LATIN SMALL LETTER DZ WITH CARON
    0x001C7: ["<compat>", 0x004C, 0x004A],  # LATIN CAPITAL LETTER LJ
    0x001C8: ["<compat>", 0x004C, 0x006A],  # LATIN CAPITAL LETTER L WITH SMALL LETTER J
    0x001C9: ["<compat>", 0x006C, 0x006A],  # LATIN SMALL LETTER LJ
    0x001CA: ["<compat>", 0x004E, 0x004A],  # LATIN CAPITAL LETTER NJ
    0x001CB: ["<compat>", 0x004E, 0x006A],  # LATIN CAPITAL LETTER N WITH SMALL LETTER J
    0x001CC: ["<compat>", 0x006E, 0x006A],  # LATIN SMALL LETTER NJ
    0x001CD: [0x0041, 0x030C],  # LATIN CAPITAL LETTER A WITH CARON
    0x001CE: [0x0061, 0x030C],  # LATIN SMALL LETTER A WITH CARON
    0x001CF: [0x0049, 0x030C],  # LATIN CAPITAL LETTER I WITH CARON
    0x001D0: [0x0069, 0x030C],  # LATIN SMALL LETTER I WITH CARON
    0x001D1: [0x004F, 0x030C],  # LATIN CAPITAL LETTER O WITH CARON
    0x001D2: [0x006F, 0x030C],  # LATIN SMALL LETTER O WITH CARON
    0x001D3: [0x0055, 0x030C],  # LATIN CAPITAL LETTER U WITH CARON
    0x001D4: [0x0075, 0x030C],  # LATIN SMALL LETTER U WITH CARON
    0x001D5: [0x00DC, 0x0304],  # LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
    0x001D6: [0x00FC, 0x0304],  # LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
    0x001D7: [0x00DC, 0x0301],  # LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
    0x001D8: [0x00FC, 0x0301],  # LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
    0x001D9: [0x00DC, 0x030C],  # LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
    0x001DA: [0x00FC, 0x030C],  # LATIN SMALL LETTER U WITH DIAERESIS AND CARON
    0x001DB: [0x00DC, 0x0300],  # LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
    0x001DC: [0x00FC, 0x0300],  # LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
    0x001DE: [0x00C4, 0x0304],  # LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON
    0x001DF: [0x00E4, 0x0304],  # LATIN SMALL LETTER A WITH DIAERESIS AND MACRON
    0x001E0: [0x0226, 0x0304],  # LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON
    0x001E1: [0x0227, 0x0304],  # LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON
    0x001E2: [0x00C6, 0x0304],  # LATIN CAPITAL LETTER AE WITH MACRON
    0x001E3: [0x00E6, 0x0304],  # LATIN SMALL LETTER AE WITH MACRON
    0x001E6: [0x0047, 0x030C],  # LATIN CAPITAL LETTER G WITH CARON
    0x001E7: [0x0067, 0x030C],  # LATIN SMALL LETTER G WITH CARON
    0x001E8: [0x004B, 0x030C],  # LATIN CAPITAL LETTER K WITH CARON
    0x001E9: [0x006B, 0x030C],  # LATIN SMALL LETTER K WITH CARON
    0x001EA: [0x004F, 0x0328],  # LATIN CAPITAL LETTER O WITH OGONEK
    0x001EB: [0x006F, 0x0328],  # LATIN SMALL LETTER O WITH OGONEK
    0x001EC: [0x01EA, 0x0304],  # LATIN CAPITAL LETTER O WITH OGONEK AND MACRON
    0x001ED: [0x01EB, 0x0304],  # LATIN SMALL LETTER O WITH OGONEK AND MACRON
    0x001EE: [0x01B7, 0x030C],  # LATIN CAPITAL LETTER EZH WITH CARON
    0x001EF: [0x0292, 0x030C],  # LATIN SMALL LETTER EZH WITH CARON
    0x001F0: [0x006A, 0x030C],  # LATIN SMALL LETTER J WITH CARON
    0x001F1: ["<compat>", 0x0044, 0x005A],  # LATIN CAPITAL LETTER DZ
    0x001F2: ["<compat>", 0x0044, 0x007A],  # LATIN CAPITAL LETTER D WITH SMALL LETTER Z
    0x001F3: ["<compat>", 0x0064, 0x007A],  # LATIN SMALL LETTER DZ
    0x001F4: [0x0047, 0x0301],  # LATIN CAPITAL LETTER G WITH ACUTE
    0x001F5: [0x0067, 0x0301],  # LATIN SMALL LETTER G WITH ACUTE
    0x001F8: [0x004E, 0x0300],  # LATIN CAPITAL LETTER N WITH GRAVE
    0x001F9: [0x006E, 0x0300],  # LATIN SMALL LETTER N WITH GRAVE
    0x001FA: [0x00C5, 0x0301],  # LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE
    0x001FB: [0x00E5, 0x0301],  # LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE
    0x001FC: [0x00C6, 0x0301],  # LATIN CAPITAL LETTER AE WITH ACUTE
    0x001FD: [0x00E6, 0x0301],  # LATIN SMALL LETTER AE WITH ACUTE
    0x001FE: [0x00D8, 0x0301],  # LATIN CAPITAL LETTER O WITH STROKE AND ACUTE
    0x001FF: [0x00F8, 0x0301],  # LATIN SMALL LETTER O WITH STROKE AND ACUTE
    0x00200: [0x0041, 0x030F],  # LATIN CAPITAL LETTER A WITH DOUBLE GRAVE
    0x00201: [0x0061, 0x030F],  # LATIN SMALL LETTER A WITH DOUBLE GRAVE
    0x00202: [0x0041, 0x0311],  # LATIN CAPITAL LETTER A WITH INVERTED BREVE
    0x00203: [0x0061, 0x0311],  # LATIN SMALL LETTER A WITH INVERTED BREVE
    0x00204: [0x0045, 0x030F],  # LATIN CAPITAL LETTER E WITH DOUBLE GRAVE
    0x00205: [0x0065, 0x030F],  # LATIN SMALL LETTER E WITH DOUBLE GRAVE
    0x00206: [0x0045, 0x0311],  # LATIN CAPITAL LETTER E WITH INVERTED BREVE
    0x00207: [0x0065, 0x0311],  # LATIN SMALL LETTER E WITH INVERTED BREVE
    0x00208: [0x0049, 0x030F],  # LATIN CAPITAL LETTER I WITH DOUBLE GRAVE
    0x00209: [0x0069, 0x030F],  # LATIN SMALL LETTER I WITH DOUBLE GRAVE
    0x0020A: [0x0049, 0x0311],  # LATIN CAPITAL LETTER I WITH INVERTED BREVE
    0x0020B: [0x0069, 0x0311],  # LATIN SMALL LETTER I WITH INVERTED BREVE
    0x0020C: [0x004F, 0x030F],  # LATIN CAPITAL LETTER O WITH DOUBLE GRAVE
    0x0020D: [0x006F, 0x030F],  # LATIN SMALL LETTER O WITH DOUBLE GRAVE
    0x0020E: [0x004F, 0x0311],  # LATIN CAPITAL LETTER O WITH INVERTED BREVE
    0x0020F: [0x006F, 0x0311],  # LATIN SMALL LETTER O WITH INVERTED BREVE
    0x00210: [0x0052, 0x030F],  # LATIN CAPITAL LETTER R WITH DOUBLE GRAVE
    0x00211: [0x0072, 0x030F],  # LATIN SMALL LETTER R WITH DOUBLE GRAVE
    0x00212: [0x0052, 0x0311],  # LATIN CAPITAL LETTER R WITH INVERTED BREVE
    0x00213: [0x0072, 0x0311],  # LATIN SMALL LETTER R WITH INVERTED BREVE
    0x00214: [0x0055, 0x030F],  # LATIN CAPITAL LETTER U WITH DOUBLE GRAVE
    0x00215: [0x0075, 0x030F],  # LATIN SMALL LETTER U WITH DOUBLE GRAVE
    0x00216: [0x0055, 0x0311],  # LATIN CAPITAL LETTER U WITH INVERTED BREVE
    0x00217: [0x0075, 0x0311],  # LATIN SMALL LETTER U WITH INVERTED BREVE
    0x00218: [0x0053, 0x0326],  # LATIN CAPITAL LETTER S WITH COMMA BELOW
    0x00219: [0x0073, 0x0326],  # LATIN SMALL LETTER S WITH COMMA BELOW
    0x0021A: [0x0054, 0x0326],  # LATIN CAPITAL LETTER T WITH COMMA BELOW
    0x0021B: [0x0074, 0x0326],  # LATIN SMALL LETTER T WITH COMMA BELOW
    0x0021E: [0x0048, 0x030C],  # LATIN CAPITAL LETTER H WITH CARON
    0x0021F: [0x0068, 0x030C],  # LATIN SMALL LETTER H WITH CARON
    0x00226: [0x0041, 0x0307],  # LATIN CAPITAL LETTER A WITH DOT ABOVE
    0x00227: [0x0061, 0x0307],  # LATIN SMALL LETTER A WITH DOT ABOVE
    0x00228: [0x0045, 0x0327],  # LATIN CAPITAL LETTER E WITH CEDILLA
    0x00229: [0x0065, 0x0327],  # LATIN SMALL LETTER E WITH CEDILLA
    0x0022A: [0x00D6, 0x0304],  # LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON
    0x0022B: [0x00F6, 0x0304],  # LATIN SMALL LETTER O WITH DIAERESIS AND MACRON
    0x0022C: [0x00D5, 0x0304],  # LATIN CAPITAL LETTER O WITH TILDE AND MACRON
    0x0022D: [0x00F5, 0x0304],  # LATIN SMALL LETTER O WITH TILDE AND MACRON
    0x0022E: [0x004F, 0x0307],  # LATIN CAPITAL LETTER O WITH DOT ABOVE
    0x0022F: [0x006F, 0x0307],  # LATIN SMALL LETTER O WITH DOT ABOVE
    0x00230: [0x022E, 0x0304],  # LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON
    0x00231: [0x022F, 0x0304],  # LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON
    0x00232: [0x0059, 0x0304],  # LATIN CAPITAL LETTER Y WITH MACRON
    0x00233: [0x0079, 0x0304],  # LATIN SMALL LETTER Y WITH MACRON
    0x002B0: ["<super>", 0x0068],  # MODIFIER LETTER SMALL H
    0x002B1: ["<super>", 0x0266],  # MODIFIER LETTER SMALL H WITH HOOK
    0x002B2: ["<super>", 0x006A],  # MODIFIER LETTER SMALL J
    0x002B3: ["<super>", 0x0072],  # MODIFIER LETTER SMALL R
    0x002B4: ["<super>", 0x0279],  # MODIFIER LETTER SMALL TURNED R
    0x002B5: ["<super>", 0x027B],  # MODIFIER LETTER SMALL TURNED R WITH HOOK
    0x002B6: ["<super>", 0x0281],  # MODIFIER LETTER SMALL CAPITAL INVERTED R
    0x002B7: ["<super>", 0x0077],  # MODIFIER LETTER SMALL W
    0x002B8: ["<super>", 0x0079],  # MODIFIER LETTER SMALL Y
    0x002D8: ["<compat>", 0x0020, 0x0306],  # BREVE
    0x002D9: ["<compat>", 0x0020, 0x0307],  # DOT ABOVE
    0x002DA: ["<compat>", 0x0020, 0x030A],  # RING ABOVE
    0x002DB: ["<compat>", 0x0020, 0x0328],  # OGONEK
    0x002DC: ["<compat>", 0x0020, 0x0303],  # SMALL TILDE
    0x002DD: ["<compat>", 0x0020, 0x030B],  # DOUBLE ACUTE ACCENT
    0x002E0: ["<super>", 0x0263],  # MODIFIER LETTER SMALL GAMMA
    0x002E1: ["<super>", 0x006C],  # MODIFIER LETTER SMALL L
    0x002E2: ["<super>", 0x0073],  # MODIFIER LETTER SMALL S
    0x002E3: ["<super>", 0x0078],  # MODIFIER LETTER SMALL X
    0x002E4: ["<super>", 0x0295],  # MODIFIER LETTER SMALL REVERSED GLOTTAL STOP
    0x00340: [0x0300],  # COMBINING GRAVE TONE MARK
    0x00341: [0x0301],  # COMBINING ACUTE TONE MARK
    0x00343: [0x0313],  # COMBINING GREEK KORONIS
    0x00344: [0x0308, 0x0301],  # COMBINING GREEK DIALYTIKA TONOS
    0x00374: [0x02B9],  # GREEK NUMERAL SIGN
    0x0037A: ["<compat>", 0x0020, 0x0345],  # GREEK YPOGEGRAMMENI
    0x0037E: [0x003B],  # GREEK QUESTION MARK
    0x00384: ["<compat>", 0x0020, 0x0301],  # GREEK TONOS
    0x00385: [0x00A8, 0x0301],  # GREEK DIALYTIKA TONOS
    0x00386: [0x0391, 0x0301],  # GREEK CAPITAL LETTER ALPHA WITH TONOS
    0x00387: [0x00B7],  # GREEK ANO TELEIA
    0x00388: [0x0395, 0x0301],  # GREEK CAPITAL LETTER EPSILON WITH TONOS
    0x00389: [0x0397, 0x0301],  # GREEK CAPITAL LETTER ETA WITH TONOS
    0x0038A: [0x0399, 0x0301],  # GREEK CAPITAL LETTER IOTA WITH TONOS
    0x0038C: [0x039F, 0x0301],  # GREEK CAPITAL LETTER OMICRON WITH TONOS
    0x0038E: [0x03A5, 0x0301],  # GREEK CAPITAL LETTER UPSILON WITH TONOS
    0x0038F: [0x03A9, 0x0301],  # GREEK CAPITAL LETTER OMEGA WITH TONOS
    0x00390: [0x03CA, 0x0301],  # GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS
    0x003AA: [0x0399, 0x0308],  # GREEK CAPITAL LETTER IOTA WITH DIALYTIKA
    0x003AB: [0x03A5, 0x0308],  # GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA
    0x003AC: [0x03B1, 0x0301],  # GREEK SMALL LETTER ALPHA WITH TONOS
    0x003AD: [0x03B5, 0x0301],  # GREEK SMALL LETTER EPSILON WITH TONOS
    0x003AE: [0x03B7, 0x0301],  # GREEK SMALL LETTER ETA WITH TONOS
    0x003AF: [0x03B9, 0x0301],  # GREEK SMALL LETTER IOTA WITH TONOS
    0x003B0: [0x03CB, 0x0301],  # GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS
    0x003CA: [0x03B9, 0x0308],  # GREEK SMALL LETTER IOTA WITH DIALYTIKA
    0x003CB: [0x03C5, 0x0308],  # GREEK SMALL LETTER UPSILON WITH DIALYTIKA
    0x003CC: [0x03BF, 0x0301],  # GREEK SMALL LETTER OMICRON WITH TONOS
    0x003CD: [0x03C5, 0x0301],  # GREEK SMALL LETTER UPSILON WITH TONOS
    0x003CE: [0x03C9, 0x0301],  # GREEK SMALL LETTER OMEGA WITH TONOS
    0x003D0: ["<compat>", 0x03B2],  # GREEK BETA SYMBOL
    0x003D1: ["<compat>", 0x03B8],  # GREEK THETA SYMBOL
    0x003D2: ["<compat>", 0x03A5],  # GREEK UPSILON WITH HOOK SYMBOL
    0x003D3: [0x03D2, 0x0301],  # GREEK UPSILON WITH ACUTE AND HOOK SYMBOL
    0x003D4: [0x03D2, 0x0308],  # GREEK UPSILON WITH DIAERESIS AND HOOK SYMBOL
    0x003D5: ["<compat>", 0x03C6],  # GREEK PHI SYMBOL
    0x003D6: ["<compat>", 0x03C0],  # GREEK PI SYMBOL
    0x003F0: ["<compat>", 0x03BA],  # GREEK KAPPA SYMBOL
    0x003F1: ["<compat>", 0x03C1],  # GREEK RHO SYMBOL
    0x003F2: ["<compat>", 0x03C2],  # GREEK LUNATE SIGMA SYMBOL
    0x003F4: ["<compat>", 0x0398],  # GREEK CAPITAL THETA SYMBOL
    0x003F5: ["<compat>", 0x03B5],  # GREEK LUNATE EPSILON SYMBOL
    0x003F9: ["<compat>", 0x03A3],  # GREEK CAPITAL LUNATE SIGMA SYMBOL
    0x00400: [0x0415, 0x0300],  # CYRILLIC CAPITAL LETTER IE WITH GRAVE
    0x00401: [0x0415, 0x0308],  # CYRILLIC CAPITAL LETTER IO
    0x00403: [0x0413, 0x0301],  # CYRILLIC CAPITAL LETTER GJE
    0x00407: [0x0406, 0x0308],  # CYRILLIC CAPITAL LETTER YI
    0x0040C: [0x041A, 0x0301],  # CYRILLIC CAPITAL LETTER KJE
    0x0040D: [0x0418, 0x0300],  # CYRILLIC CAPITAL LETTER I WITH GRAVE
    0x0040E: [0x0423, 0x0306],  # CYRILLIC CAPITAL LETTER SHORT U
    0x00419: [0x0418, 0x0306],  # CYRILLIC CAPITAL LETTER SHORT I
    0x00439: [0x0438, 0x0306],  # CYRILLIC SMALL LETTER SHORT I
    0x00450: [0x0435, 0x0300],  # CYRILLIC SMALL LETTER IE WITH GRAVE
    0x00451: [0x0435, 0x0308],  # CYRILLIC SMALL LETTER IO
    0x00453: [0x0433, 0x0301],  # CYRILLIC SMALL LETTER GJE
    0x00457: [0x0456, 0x0308],  # CYRILLIC SMALL LETTER YI
    0x0045C: [0x043A, 0x0301],  # CYRILLIC SMALL LETTER KJE
    0x0045D: [0x0438, 0x0300],  # CYRILLIC SMALL LETTER I WITH GRAVE
    0x0045E: [0x0443, 0x0306],  # CYRILLIC SMALL LETTER SHORT U
    0x00476: [0x0474, 0x030F],  # CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT
    0x00477: [0x0475, 0x030F],  # CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT
    0x004C1: [0x0416, 0x0306],  # CYRILLIC CAPITAL LETTER ZHE WITH BREVE
    0x004C2: [0x0436, 0x0306],  # CYRILLIC SMALL LETTER ZHE WITH BREVE
    0x004D0: [0x0410, 0x0306],  # CYRILLIC CAPITAL LETTER A WITH BREVE
    0x004D1: [0x0430, 0x0306],  # CYRILLIC SMALL LETTER A WITH BREVE
    0x004D2: [0x0410, 0x0308],  # CYRILLIC CAPITAL LETTER A WITH DIAERESIS
    0x004D3: [0x0430, 0x0308],  # CYRILLIC SMALL LETTER A WITH DIAERESIS
    0x004D6: [0x0415, 0x0306],  # CYRILLIC CAPITAL LETTER IE WITH BREVE
    0x004D7: [0x0435, 0x0306],  # CYRILLIC SMALL LETTER IE WITH BREVE
    0x004DA: [0x04D8, 0x0308],  # CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS
    0x004DB: [0x04D9, 0x0308],  # CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS
    0x004DC: [0x0416, 0x0308],  # CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS
    0x004DD: [0x0436, 0x0308],  # CYRILLIC SMALL LETTER ZHE WITH DIAERESIS
    0x004DE: [0x0417, 0x0308],  # CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS
    0x004DF: [0x0437, 0x0308],  # CYRILLIC SMALL LETTER ZE WITH DIAERESIS
    0x004E2: [0x0418, 0x0304],  # CYRILLIC CAPITAL LETTER I WITH MACRON
    0x004E3: [0x0438, 0x0304],  # CYRILLIC SMALL LETTER I WITH MACRON
    0x004E4: [0x0418, 0x0308],  # CYRILLIC CAPITAL LETTER I WITH DIAERESIS
    0x004E5: [0x0438, 0x0308],  # CYRILLIC SMALL LETTER I WITH DIAERESIS
    0x004E6: [0x041E, 0x0308],  # CYRILLIC CAPITAL LETTER O WITH DIAERESIS
    0x004E7: [0x043E, 0x0308],  # CYRILLIC SMALL LETTER O WITH DIAERESIS
    0x004EA: [0x04E8, 0x0308],  # CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS
    0x004EB: [0x04E9, 0x0308],  # CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS
    0x004EC: [0x042D, 0x0308],  # CYRILLIC CAPITAL LETTER E WITH DIAERESIS
    0x004ED: [0x044D, 0x0308],  # CYRILLIC SMALL LETTER E WITH DIAERESIS
    0x004EE: [0x0423, 0x0304],  # CYRILLIC CAPITAL LETTER U WITH MACRON
    0x004EF: [0x0443, 0x0304],  # CYRILLIC SMALL LETTER U WITH MACRON
    0x004F0: [0x0423, 0x0308],  # CYRILLIC CAPITAL LETTER U WITH DIAERESIS
    0x004F1: [0x0443, 0x0308],  # CYRILLIC SMALL LETTER U WITH DIAERESIS
    0x004F2: [0x0423, 0x030B],  # CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE
    0x004F3: [0x0443, 0x030B],  # CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE
    0x004F4: [0x0427, 0x0308],  # CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS
    0x004F5: [0x0447, 0x0308],  # CYRILLIC SMALL LETTER CHE WITH DIAERESIS
    0x004F8: [0x042B, 0x0308],  # CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS
    0x004F9: [0x044B, 0x0308],  # CYRILLIC SMALL LETTER YERU WITH DIAERESIS
    0x00587: ["<compat>", 0x0565, 0x0582],  # ARMENIAN SMALL LIGATURE ECH YIWN
    0x00622: [0x0627, 0x0653],  # ARABIC LETTER ALEF WITH MADDA ABOVE
    0x00623: [0x0627, 0x0654],  # ARABIC LETTER ALEF WITH HAMZA ABOVE
    0x00624: [0x0648, 0x0654],  # ARABIC LETTER WAW WITH HAMZA ABOVE
    0x00625: [0x0627, 0x0655],  # ARABIC LETTER ALEF WITH HAMZA BELOW
    0x00626: [0x064A, 0x0654],  # ARABIC LETTER YEH WITH HAMZA ABOVE
    0x00675: ["<compat>", 0x0627, 0x0674],  # ARABIC LETTER HIGH HAMZA ALEF
    0x00676: ["<compat>", 0x0648, 0x0674],  # ARABIC LETTER HIGH HAMZA WAW
    0x00677: ["<compat>", 0x06C7, 0x0674],  # ARABIC LETTER U WITH HAMZA ABOVE
    0x00678: ["<compat>", 0x064A, 0x0674],  # ARABIC LETTER HIGH HAMZA YEH
    0x006C0: [0x06D5, 0x0654],  # ARABIC LETTER HEH WITH YEH ABOVE
    0x006C2: [0x06C1, 0x0654],  # ARABIC LETTER HEH GOAL WITH HAMZA ABOVE
    0x006D3: [0x06D2, 0x0654],  # ARABIC LETTER YEH BARREE WITH HAMZA ABOVE
    0x00929: [0x0928, 0x093C],  # DEVANAGARI LETTER NNNA
    0x00931: [0x0930, 0x093C],  # DEVANAGARI LETTER RRA
    0x00934: [0x0933, 0x093C],  # DEVANAGARI LETTER LLLA
    0x00958: [0x0915, 0x093C],  # DEVANAGARI LETTER QA
    0x00959: [0x0916, 0x093C],  # DEVANAGARI LETTER KHHA
    0x0095A: [0x0917, 0x093C],  # DEVANAGARI LETTER GHHA
    0x0095B: [0x091C, 0x093C],  # DEVANAGARI LETTER ZA
    0x0095C: [0x0921, 0x093C],  # DEVANAGARI LETTER DDDHA
    0x0095D: [0x0922, 0x093C],  # DEVANAGARI LETTER RHA
    0x0095E: [0x092B, 0x093C],  # DEVANAGARI LETTER FA
    0x0095F: [0x092F, 0x093C],  # DEVANAGARI LETTER YYA
    0x009CB: [0x09C7, 0x09BE],  # BENGALI VOWEL SIGN O
    0x009CC: [0x09C7, 0x09D7],  # BENGALI VOWEL SIGN AU
    0x009DC: [0x09A1, 0x09BC],  # BENGALI LETTER RRA
    0x009DD: [0x09A2, 0x09BC],  # BENGALI LETTER RHA
    0x009DF: [0x09AF, 0x09BC],  # BENGALI LETTER YYA
    0x00A33: [0x0A32, 0x0A3C],  # GURMUKHI LETTER LLA
    0x00A36: [0x0A38, 0x0A3C],  # GURMUKHI LETTER SHA
    0x00A59: [0x0A16, 0x0A3C],  # GURMUKHI LETTER KHHA
    0x00A5A: [0x0A17, 0x0A3C],  # GURMUKHI LETTER GHHA
    0x00A5B: [0x0A1C, 0x0A3C],  # GURMUKHI LETTER ZA
    0x00A5E: [0x0A2B, 0x0A3C],  # GURMUKHI LETTER FA
    0x00B48: [0x0B47, 0x0B56],  # ORIYA VOWEL SIGN AI
    0x00B4B: [0x0B47, 0x0B3E],  # ORIYA VOWEL SIGN O
    0x00B4C: [0x0B47, 0x0B57],  # ORIYA VOWEL SIGN AU
    0x00B5C: [0x0B21, 0x0B3C],  # ORIYA LETTER RRA
    0x00B5D: [0x0B22, 0x0B3C],  # ORIYA LETTER RHA
    0x00B94: [0x0B92, 0x0BD7],  # TAMIL LETTER AU
    0x00BCA: [0x0BC6, 0x0BBE],  # TAMIL VOWEL SIGN O
    0x00BCB: [0x0BC7, 0x0BBE],  # TAMIL VOWEL SIGN OO
    0x00BCC: [0x0BC6, 0x0BD7],  # TAMIL VOWEL SIGN AU
    0x00C48: [0x0C46, 0x0C56],  # TELUGU VOWEL SIGN AI
    0x00CC0: [0x0CBF, 0x0CD5],  # KANNADA VOWEL SIGN II
    0x00CC7: [0x0CC6, 0x0CD5],  # KANNADA VOWEL SIGN EE
    0x00CC8: [0x0CC6, 0x0CD6],  # KANNADA VOWEL SIGN AI
    0x00CCA: [0x0CC6, 0x0CC2],  # KANNADA VOWEL SIGN O
    0x00CCB: [0x0CCA, 0x0CD5],  # KANNADA VOWEL SIGN OO
    0x00D4A: [0x0D46, 0x0D3E],  # MALAYALAM VOWEL SIGN O
    0x00D4B: [0x0D47, 0x0D3E],  # MALAYALAM VOWEL SIGN OO
    0x00D4C: [0x0D46, 0x0D57],  # MALAYALAM VOWEL SIGN AU
    0x00DDA: [0x0DD9, 0x0DCA],  # SINHALA VOWEL SIGN DIGA KOMBUVA
    0x00DDC: [0x0DD9, 0x0DCF],  # SINHALA VOWEL SIGN KOMBUVA HAA AELA-PILLA
    0x00DDD: [0x0DDC, 0x0DCA],  # SINHALA VOWEL SIGN KOMBUVA HAA DIGA AELA-PILLA
    0x00DDE: [0x0DD9, 0x0DDF],  # SINHALA VOWEL SIGN KOMBUVA HAA GAYANUKITTA
    0x00E33: ["<compat>", 0x0E4D, 0x0E32],  # THAI CHARACTER SARA AM
    0x00EB3: ["<compat>", 0x0ECD, 0x0EB2],  # LAO VOWEL SIGN AM
    0x00EDC: ["<compat>", 0x0EAB, 0x0E99],  # LAO HO NO
    0x00EDD: ["<compat>", 0x0EAB, 0x0EA1],  # LAO HO MO
    0x00F0C: ["<noBreak>", 0x0F0B],  # TIBETAN MARK DELIMITER TSHEG BSTAR
    0x00F43: [0x0F42, 0x0FB7],  # TIBETAN LETTER GHA
    0x00F4D: [0x0F4C, 0x0FB7],  # TIBETAN LETTER DDHA
    0x00F52: [0x0F51, 0x0FB7],  # TIBETAN LETTER DHA
    0x00F57: [0x0F56, 0x0FB7],  # TIBETAN LETTER BHA
    0x00F5C: [0x0F5B, 0x0FB7],  # TIBETAN LETTER DZHA
    0x00F69: [0x0F40, 0x0FB5],  # TIBETAN LETTER KSSA
    0x00F73: [0x0F71, 0x0F72],  # TIBETAN VOWEL SIGN II
    0x00F75: [0x0F71, 0x0F74],  # TIBETAN VOWEL SIGN UU
    0x00F76: [0x0FB2, 0x0F80],  # TIBETAN VOWEL SIGN VOCALIC R
    0x00F77: ["<compat>", 0x0FB2, 0x0F81],  # TIBETAN VOWEL SIGN VOCALIC RR
    0x00F78: [0x0FB3, 0x0F80],  # TIBETAN VOWEL SIGN VOCALIC L
    0x00F79: ["<compat>", 0x0FB3, 0x0F81],  # TIBETAN VOWEL SIGN VOCALIC LL
    0x00F81: [0x0F71, 0x0F80],  # TIBETAN VOWEL SIGN REVERSED II
    0x00F93: [0x0F92, 0x0FB7],  # TIBETAN SUBJOINED LETTER GHA
    0x00F9D: [0x0F9C, 0x0FB7],  # TIBETAN SUBJOINED LETTER DDHA
    0x00FA2: [0x0FA1, 0x0FB7],  # TIBETAN SUBJOINED LETTER DHA
    0x00FA7: [0x0FA6, 0x0FB7],  # TIBETAN SUBJOINED LETTER BHA
    0x00FAC: [0x0FAB, 0x0FB7],  # TIBETAN SUBJOINED LETTER DZHA
    0x00FB9: [0x0F90, 0x0FB5],  # TIBETAN SUBJOINED LETTER KSSA
    0x01026: [0x1025, 0x102E],  # MYANMAR LETTER UU
    0x010FC: ["<super>", 0x10DC],  # MODIFIER LETTER GEORGIAN NAR
    0x01B06: [0x1B05, 0x1B35],  # BALINESE LETTER AKARA TEDUNG
    0x01B08: [0x1B07, 0x1B35],  # BALINESE LETTER IKARA TEDUNG
    0x01B0A: [0x1B09, 0x1B35],  # BALINESE LETTER UKARA TEDUNG
    0x01B0C: [0x1B0B, 0x1B35],  # BALINESE LETTER RA REPA TEDUNG
    0x01B0E: [0x1B0D, 0x1B35],  # BALINESE LETTER LA LENGA TEDUNG
    0x01B12: [0x1B11, 0x1B35],  # BALINESE LETTER OKARA TEDUNG
    0x01B3B: [0x1B3A, 0x1B35],  # BALINESE VOWEL SIGN RA REPA TEDUNG
    0x01B3D: [0x1B3C, 0x1B35],  # BALINESE VOWEL SIGN LA LENGA TEDUNG
    0x01B40: [0x1B3E, 0x1B35],  # BALINESE VOWEL SIGN TALING TEDUNG
    0x01B41: [0x1B3F, 0x1B35],  # BALINESE VOWEL SIGN TALING REPA TEDUNG
    0x01B43: [0x1B42, 0x1B35],  # BALINESE VOWEL SIGN PEPET TEDUNG
    0x01D2C: ["<super>", 0x0041],  # MODIFIER LETTER CAPITAL A
    0x01D2D: ["<super>", 0x00C6],  # MODIFIER LETTER CAPITAL AE
    0x01D2E: ["<super>", 0x0042],  # MODIFIER LETTER CAPITAL B
    0x01D30: ["<super>", 0x0044],  # MODIFIER LETTER CAPITAL D
    0x01D31: ["<super>", 0x0045],  # MODIFIER LETTER CAPITAL E
    0x01D32: ["<super>", 0x018E],  # MODIFIER LETTER CAPITAL REVERSED E
    0x01D33: ["<super>", 0x0047],  # MODIFIER LETTER CAPITAL G
    0x01D34: ["<super>", 0x0048],  # MODIFIER LETTER CAPITAL H
    0x01D35: ["<super>", 0x0049],  # MODIFIER LETTER CAPITAL I
    0x01D36: ["<super>", 0x004A],  # MODIFIER LETTER CAPITAL J
    0x01D37: ["<super>", 0x004B],  # MODIFIER LETTER CAPITAL K
    0x01D38: ["<super>", 0x004C],  # MODIFIER LETTER CAPITAL L
    0x01D39: ["<super>", 0x004D],  # MODIFIER LETTER CAPITAL M
    0x01D3A: ["<super>", 0x004E],  # MODIFIER LETTER CAPITAL N
    0x01D3C: ["<super>", 0x004F],  # MODIFIER LETTER CAPITAL O
    0x01D3D: ["<super>", 0x0222],  # MODIFIER LETTER CAPITAL OU
    0x01D3E: ["<super>", 0x0050],  # MODIFIER LETTER CAPITAL P
    0x01D3F: ["<super>", 0x0052],  # MODIFIER LETTER CAPITAL R
    0x01D40: ["<super>", 0x0054],  # MODIFIER LETTER CAPITAL T
    0x01D41: ["<super>", 0x0055],  # MODIFIER LETTER CAPITAL U
    0x01D42: ["<super>", 0x0057],  # MODIFIER LETTER CAPITAL W
    0x01D43: ["<super>", 0x0061],  # MODIFIER LETTER SMALL A
    0x01D44: ["<super>", 0x0250],  # MODIFIER LETTER SMALL TURNED A
    0x01D45: ["<super>", 0x0251],  # MODIFIER LETTER SMALL ALPHA
    0x01D46: ["<super>", 0x1D02],  # MODIFIER LETTER SMALL TURNED AE
    0x01D47: ["<super>", 0x0062],  # MODIFIER LETTER SMALL B
    0x01D48: ["<super>", 0x0064],  # MODIFIER LETTER SMALL D
    0x01D49: ["<super>", 0x0065],  # MODIFIER LETTER SMALL E
    0x01D4A: ["<super>", 0x0259],  # MODIFIER LETTER SMALL SCHWA
    0x01D4B: ["<super>", 0x025B],  # MODIFIER LETTER SMALL OPEN E
    0x01D4C: ["<super>", 0x025C],  # MODIFIER LETTER SMALL TURNED OPEN E
    0x01D4D: ["<super>", 0x0067],  # MODIFIER LETTER SMALL G
    0x01D4F: ["<super>", 0x006B],  # MODIFIER LETTER SMALL K
    0x01D50: ["<super>", 0x006D],  # MODIFIER LETTER SMALL M
    0x01D51: ["<super>", 0x014B],  # MODIFIER LETTER SMALL ENG
    0x01D52: ["<super>", 0x006F],  # MODIFIER LETTER SMALL O
    0x01D53: ["<super>", 0x0254],  # MODIFIER LETTER SMALL OPEN O
    0x01D54: ["<super>", 0x1D16],  # MODIFIER LETTER SMALL TOP HALF O
    0x01D55: ["<super>", 0x1D17],  # MODIFIER LETTER SMALL BOTTOM HALF O
    0x01D56: ["<super>", 0x0070],  # MODIFIER LETTER SMALL P
    0x01D57: ["<super>", 0x0074],  # MODIFIER LETTER SMALL T
    0x01D58: ["<super>", 0x0075],  # MODIFIER LETTER SMALL U
    0x01D59: ["<super>", 0x1D1D],  # MODIFIER LETTER SMALL SIDEWAYS U
    0x01D5A: ["<super>", 0x026F],  # MODIFIER LETTER SMALL TURNED M
    0x01D5B: ["<super>", 0x0076],  # MODIFIER LETTER SMALL V
    0x01D5C: ["<super>", 0x1D25],  # MODIFIER LETTER SMALL AIN
    0x01D5D: ["<super>", 0x03B2],  # MODIFIER LETTER SMALL BETA
    0x01D5E: ["<super>", 0x03B3],  # MODIFIER LETTER SMALL GREEK GAMMA
    0x01D5F: ["<super>", 0x03B4],  # MODIFIER LETTER SMALL DELTA
    0x01D60: ["<super>", 0x03C6],  # MODIFIER LETTER SMALL GREEK PHI
    0x01D61: ["<super>", 0x03C7],  # MODIFIER LETTER SMALL CHI
    0x01D62: ["<sub>", 0x0069],  # LATIN SUBSCRIPT SMALL LETTER I
    0x01D63: ["<sub>", 0x0072],  # LATIN SUBSCRIPT SMALL LETTER R
    0x01D64: ["<sub>", 0x0075],  # LATIN SUBSCRIPT SMALL LETTER U
    0x01D65: ["<sub>", 0x0076],  # LATIN SUBSCRIPT SMALL LETTER V
    0x01D66: ["<sub>", 0x03B2],  # GREEK SUBSCRIPT SMALL LETTER BETA
    0x01D67: ["<sub>", 0x03B3],  # GREEK SUBSCRIPT SMALL LETTER GAMMA
    0x01D68: ["<sub>", 0x03C1],  # GREEK SUBSCRIPT SMALL LETTER RHO
    0x01D69: ["<sub>", 0x03C6],  # GREEK SUBSCRIPT SMALL LETTER PHI
    0x01D6A: ["<sub>", 0x03C7],  # GREEK SUBSCRIPT SMALL LETTER CHI
    0x01D78: ["<super>", 0x043D],  # MODIFIER LETTER CYRILLIC EN
    0x01D9B: ["<super>", 0x0252],  # MODIFIER LETTER SMALL TURNED ALPHA
    0x01D9C: ["<super>", 0x0063],  # MODIFIER LETTER SMALL C
    0x01D9D: ["<super>", 0x0255],  # MODIFIER LETTER SMALL C WITH CURL
    0x01D9E: ["<super>", 0x00F0],  # MODIFIER LETTER SMALL ETH
    0x01D9F: ["<super>", 0x025C],  # MODIFIER LETTER SMALL REVERSED OPEN E
    0x01DA0: ["<super>", 0x0066],  # MODIFIER LETTER SMALL F
    0x01DA1: ["<super>", 0x025F],  # MODIFIER LETTER SMALL DOTLESS J WITH STROKE
    0x01DA2: ["<super>", 0x0261],  # MODIFIER LETTER SMALL SCRIPT G
    0x01DA3: ["<super>", 0x0265],  # MODIFIER LETTER SMALL TURNED H
    0x01DA4: ["<super>", 0x0268],  # MODIFIER LETTER SMALL I WITH STROKE
    0x01DA5: ["<super>", 0x0269],  # MODIFIER LETTER SMALL IOTA
    0x01DA6: ["<super>", 0x026A],  # MODIFIER LETTER SMALL CAPITAL I
    0x01DA7: ["<super>", 0x1D7B],  # MODIFIER LETTER SMALL CAPITAL I WITH STROKE
    0x01DA8: ["<super>", 0x029D],  # MODIFIER LETTER SMALL J WITH CROSSED-TAIL
    0x01DA9: ["<super>", 0x026D],  # MODIFIER LETTER SMALL L WITH RETROFLEX HOOK
    0x01DAA: ["<super>", 0x1D85],  # MODIFIER LETTER SMALL L WITH PALATAL HOOK
    0x01DAB: ["<super>", 0x029F],  # MODIFIER LETTER SMALL CAPITAL L
    0x01DAC: ["<super>", 0x0271],  # MODIFIER LETTER SMALL M WITH HOOK
    0x01DAD: ["<super>", 0x0270],  # MODIFIER LETTER SMALL TURNED M WITH LONG LEG
    0x01DAE: ["<super>", 0x0272],  # MODIFIER LETTER SMALL N WITH LEFT HOOK
    0x01DAF: ["<super>", 0x0273],  # MODIFIER LETTER SMALL N WITH RETROFLEX HOOK
    0x01DB0: ["<super>", 0x0274],  # MODIFIER LETTER SMALL CAPITAL N
    0x01DB1: ["<super>", 0x0275],  # MODIFIER LETTER SMALL BARRED O
    0x01DB2: ["<super>", 0x0278],  # MODIFIER LETTER SMALL PHI
    0x01DB3: ["<super>", 0x0282],  # MODIFIER LETTER SMALL S WITH HOOK
    0x01DB4: ["<super>", 0x0283],  # MODIFIER LETTER SMALL ESH
    0x01DB5: ["<super>", 0x01AB],  # MODIFIER LETTER SMALL T WITH PALATAL HOOK
    0x01DB6: ["<super>", 0x0289],  # MODIFIER LETTER SMALL U BAR
    0x01DB7: ["<super>", 0x028A],  # MODIFIER LETTER SMALL UPSILON
    0x01DB8: ["<super>", 0x1D1C],  # MODIFIER LETTER SMALL CAPITAL U
    0x01DB9: ["<super>", 0x028B],  # MODIFIER LETTER SMALL V WITH HOOK
    0x01DBA: ["<super>", 0x028C],  # MODIFIER LETTER SMALL TURNED V
    0x01DBB: ["<super>", 0x007A],  # MODIFIER LETTER SMALL Z
    0x01DBC: ["<super>", 0x0290],  # MODIFIER LETTER SMALL Z WITH RETROFLEX HOOK
    0x01DBD: ["<super>", 0x0291],  # MODIFIER LETTER SMALL Z WITH CURL
    0x01DBE: ["<super>", 0x0292],  # MODIFIER LETTER SMALL EZH
    0x01DBF: ["<super>", 0x03B8],  # MODIFIER LETTER SMALL THETA
    0x01E00: [0x0041, 0x0325],  # LATIN CAPITAL LETTER A WITH RING BELOW
    0x01E01: [0x0061, 0x0325],  # LATIN SMALL LETTER A WITH RING BELOW
    0x01E02: [0x0042, 0x0307],  # LATIN CAPITAL LETTER B WITH DOT ABOVE
    0x01E03: [0x0062, 0x0307],  # LATIN SMALL LETTER B WITH DOT ABOVE
    0x01E04: [0x0042, 0x0323],  # LATIN CAPITAL LETTER B WITH DOT BELOW
    0x01E05: [0x0062, 0x0323],  # LATIN SMALL LETTER B WITH DOT BELOW
    0x01E06: [0x0042, 0x0331],  # LATIN CAPITAL LETTER B WITH LINE BELOW
    0x01E07: [0x0062, 0x0331],  # LATIN SMALL LETTER B WITH LINE BELOW
    0x01E08: [0x00C7, 0x0301],  # LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE
    0x01E09: [0x00E7, 0x0301],  # LATIN SMALL LETTER C WITH CEDILLA AND ACUTE
    0x01E0A: [0x0044, 0x0307],  # LATIN CAPITAL LETTER D WITH DOT ABOVE
    0x01E0B: [0x0064, 0x0307],  # LATIN SMALL LETTER D WITH DOT ABOVE
    0x01E0C: [0x0044, 0x0323],  # LATIN CAPITAL LETTER D WITH DOT BELOW
    0x01E0D: [0x0064, 0x0323],  # LATIN SMALL LETTER D WITH DOT BELOW
    0x01E0E: [0x0044, 0x0331],  # LATIN CAPITAL LETTER D WITH LINE BELOW
    0x01E0F: [0x0064, 0x0331],  # LATIN SMALL LETTER D WITH LINE BELOW
    0x01E10: [0x0044, 0x0327],  # LATIN CAPITAL LETTER D WITH CEDILLA
    0x01E11: [0x0064, 0x0327],  # LATIN SMALL LETTER D WITH CEDILLA
    0x01E12: [0x0044, 0x032D],  # LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW
    0x01E13: [0x0064, 0x032D],  # LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW
    0x01E14: [0x0112, 0x0300],  # LATIN CAPITAL LETTER E WITH MACRON AND GRAVE
    0x01E15: [0x0113, 0x0300],  # LATIN SMALL LETTER E WITH MACRON AND GRAVE
    0x01E16: [0x0112, 0x0301],  # LATIN CAPITAL LETTER E WITH MACRON AND ACUTE
    0x01E17: [0x0113, 0x0301],  # LATIN SMALL LETTER E WITH MACRON AND ACUTE
    0x01E18: [0x0045, 0x032D],  # LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW
    0x01E19: [0x0065, 0x032D],  # LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW
    0x01E1A: [0x0045, 0x0330],  # LATIN CAPITAL LETTER E WITH TILDE BELOW
    0x01E1B: [0x0065, 0x0330],  # LATIN SMALL LETTER E WITH TILDE BELOW
    0x01E1C: [0x0228, 0x0306],  # LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE
    0x01E1D: [0x0229, 0x0306],  # LATIN SMALL LETTER E WITH CEDILLA AND BREVE
    0x01E1E: [0x0046, 0x0307],  # LATIN CAPITAL LETTER F WITH DOT ABOVE
    0x01E1F: [0x0066, 0x0307],  # LATIN SMALL LETTER F WITH DOT ABOVE
    0x01E20: [0x0047, 0x0304],  # LATIN CAPITAL LETTER G WITH MACRON
    0x01E21: [0x0067, 0x0304],  # LATIN SMALL LETTER G WITH MACRON
    0x01E22: [0x0048, 0x0307],  # LATIN CAPITAL LETTER H WITH DOT ABOVE
    0x01E23: [0x0068, 0x0307],  # LATIN SMALL LETTER H WITH DOT ABOVE
    0x01E24: [0x0048, 0x0323],  # LATIN CAPITAL LETTER H WITH DOT BELOW
    0x01E25: [0x0068, 0x0323],  # LATIN SMALL LETTER H WITH DOT BELOW
    0x01E26: [0x0048, 0x0308],  # LATIN CAPITAL LETTER H WITH DIAERESIS
    0x01E27: [0x0068, 0x0308],  # LATIN SMALL LETTER H WITH DIAERESIS
    0x01E28: [0x0048, 0x0327],  # LATIN CAPITAL LETTER H WITH CEDILLA
    0x01E29: [0x0068, 0x0327],  # LATIN SMALL LETTER H WITH CEDILLA
    0x01E2A: [0x0048, 0x032E],  # LATIN CAPITAL LETTER H WITH BREVE BELOW
    0x01E2B: [0x0068, 0x032E],  # LATIN SMALL LETTER H WITH BREVE BELOW
    0x01E2C: [0x0049, 0x0330],  # LATIN CAPITAL LETTER I WITH TILDE BELOW
    0x01E2D: [0x0069, 0x0330],  # LATIN SMALL LETTER I WITH TILDE BELOW
    0x01E2E: [0x00CF, 0x0301],  # LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE
    0x01E2F: [0x00EF, 0x0301],  # LATIN SMALL LETTER I WITH DIAERESIS AND ACUTE
    0x01E30: [0x004B, 0x0301],  # LATIN CAPITAL LETTER K WITH ACUTE
    0x01E31: [0x006B, 0x0301],  # LATIN SMALL LETTER K WITH ACUTE
    0x01E32: [0x004B, 0x0323],  # LATIN CAPITAL LETTER K WITH DOT BELOW
    0x01E33: [0x006B, 0x0323],  # LATIN SMALL LETTER K WITH DOT BELOW
    0x01E34: [0x004B, 0x0331],  # LATIN CAPITAL LETTER K WITH LINE BELOW
    0x01E35: [0x006B, 0x0331],  # LATIN SMALL LETTER K WITH LINE BELOW
    0x01E36: [0x004C, 0x0323],  # LATIN CAPITAL LETTER L WITH DOT BELOW
    0x01E37: [0x006C, 0x0323],  # LATIN SMALL LETTER L WITH DOT BELOW
    0x01E38: [0x1E36, 0x0304],  # LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON
    0x01E39: [0x1E37, 0x0304],  # LATIN SMALL LETTER L WITH DOT BELOW AND MACRON
    0x01E3A: [0x004C, 0x0331],  # LATIN CAPITAL LETTER L WITH LINE BELOW
    0x01E3B: [0x006C, 0x0331],  # LATIN SMALL LETTER L WITH LINE BELOW
    0x01E3C: [0x004C, 0x032D],  # LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW
    0x01E3D: [0x006C, 0x032D],  # LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW
    0x01E3E: [0x004D, 0x0301],  # LATIN CAPITAL LETTER M WITH ACUTE
    0x01E3F: [0x006D, 0x0301],  # LATIN SMALL LETTER M WITH ACUTE
    0x01E40: [0x004D, 0x0307],  # LATIN CAPITAL LETTER M WITH DOT ABOVE
    0x01E41: [0x006D, 0x0307],  # LATIN SMALL LETTER M WITH DOT ABOVE
    0x01E42: [0x004D, 0x0323],  # LATIN CAPITAL LETTER M WITH DOT BELOW
    0x01E43: [0x006D, 0x0323],  # LATIN SMALL LETTER M WITH DOT BELOW
    0x01E44: [0x004E, 0x0307],  # LATIN CAPITAL LETTER N WITH DOT ABOVE
    0x01E45: [0x006E, 0x0307],  # LATIN SMALL LETTER N WITH DOT ABOVE
    0x01E46: [0x004E, 0x0323],  # LATIN CAPITAL LETTER N WITH DOT BELOW
    0x01E47: [0x006E, 0x0323],  # LATIN SMALL LETTER N WITH DOT BELOW
    0x01E48: [0x004E, 0x0331],  # LATIN CAPITAL LETTER N WITH LINE BELOW
    0x01E49: [0x006E, 0x0331],  # LATIN SMALL LETTER N WITH LINE BELOW
    0x01E4A: [0x004E, 0x032D],  # LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW
    0x01E4B: [0x006E, 0x032D],  # LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW
    0x01E4C: [0x00D5, 0x0301],  # LATIN CAPITAL LETTER O WITH TILDE AND ACUTE
    0x01E4D: [0x00F5, 0x0301],  # LATIN SMALL LETTER O WITH TILDE AND ACUTE
    0x01E4E: [0x00D5, 0x0308],  # LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS
    0x01E4F: [0x00F5, 0x0308],  # LATIN SMALL LETTER O WITH TILDE AND DIAERESIS
    0x01E50: [0x014C, 0x0300],  # LATIN CAPITAL LETTER O WITH MACRON AND GRAVE
    0x01E51: [0x014D, 0x0300],  # LATIN SMALL LETTER O WITH MACRON AND GRAVE
    0x01E52: [0x014C, 0x0301],  # LATIN CAPITAL LETTER O WITH MACRON AND ACUTE
    0x01E53: [0x014D, 0x0301],  # LATIN SMALL LETTER O WITH MACRON AND ACUTE
    0x01E54: [0x0050, 0x0301],  # LATIN CAPITAL LETTER P WITH ACUTE
    0x01E55: [0x0070, 0x0301],  # LATIN SMALL LETTER P WITH ACUTE
    0x01E56: [0x0050, 0x0307],  # LATIN CAPITAL LETTER P WITH DOT ABOVE
    0x01E57: [0x0070, 0x0307],  # LATIN SMALL LETTER P WITH DOT ABOVE
    0x01E58: [0x0052, 0x0307],  # LATIN CAPITAL LETTER R WITH DOT ABOVE
    0x01E59: [0x0072, 0x0307],  # LATIN SMALL LETTER R WITH DOT ABOVE
    0x01E5A: [0x0052, 0x0323],  # LATIN CAPITAL LETTER R WITH DOT BELOW
    0x01E5B: [0x0072, 0x0323],  # LATIN SMALL LETTER R WITH DOT BELOW
    0x01E5C: [0x1E5A, 0x0304],  # LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON
    0x01E5D: [0x1E5B, 0x0304],  # LATIN SMALL LETTER R WITH DOT BELOW AND MACRON
    0x01E5E: [0x0052, 0x0331],  # LATIN CAPITAL LETTER R WITH LINE BELOW
    0x01E5F: [0x0072, 0x0331],  # LATIN SMALL LETTER R WITH LINE BELOW
    0x01E60: [0x0053, 0x0307],  # LATIN CAPITAL LETTER S WITH DOT ABOVE
    0x01E61: [0x0073, 0x0307],  # LATIN SMALL LETTER S WITH DOT ABOVE
    0x01E62: [0x0053, 0x0323],  # LATIN CAPITAL LETTER S WITH DOT BELOW
    0x01E63: [0x0073, 0x0323],  # LATIN SMALL LETTER S WITH DOT BELOW
    0x01E64: [0x015A, 0x0307],  # LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE
    0x01E65: [0x015B, 0x0307],  # LATIN SMALL LETTER S WITH ACUTE AND DOT ABOVE
    0x01E66: [0x0160, 0x0307],  # LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE
    0x01E67: [0x0161, 0x0307],  # LATIN SMALL LETTER S WITH CARON AND DOT ABOVE
    0x01E68: [0x1E62, 0x0307],  # LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE
    0x01E69: [0x1E63, 0x0307],  # LATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVE
    0x01E6A: [0x0054, 0x0307],  # LATIN CAPITAL LETTER T WITH DOT ABOVE
    0x01E6B: [0x0074, 0x0307],  # LATIN SMALL LETTER T WITH DOT ABOVE
    0x01E6C: [0x0054, 0x0323],  # LATIN CAPITAL LETTER T WITH DOT BELOW
    0x01E6D: [0x0074, 0x0323],  # LATIN SMALL LETTER T WITH DOT BELOW
    0x01E6E: [0x0054, 0x0331],  # LATIN CAPITAL LETTER T WITH LINE BELOW
    0x01E6F: [0x0074, 0x0331],  # LATIN SMALL LETTER T WITH LINE BELOW
    0x01E70: [0x0054, 0x032D],  # LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW
    0x01E71: [0x0074, 0x032D],  # LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW
    0x01E72: [0x0055, 0x0324],  # LATIN CAPITAL LETTER U WITH DIAERESIS BELOW
    0x01E73: [0x0075, 0x0324],  # LATIN SMALL LETTER U WITH DIAERESIS BELOW
    0x01E74: [0x0055, 0x0330],  # LATIN CAPITAL LETTER U WITH TILDE BELOW
    0x01E75: [0x0075, 0x0330],  # LATIN SMALL LETTER U WITH TILDE BELOW
    0x01E76: [0x0055, 0x032D],  # LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW
    0x01E77: [0x0075, 0x032D],  # LATIN SMALL LETTER U WITH CIRCUMFLEX BELOW
    0x01E78: [0x0168, 0x0301],  # LATIN CAPITAL LETTER U WITH TILDE AND ACUTE
    0x01E79: [0x0169, 0x0301],  # LATIN SMALL LETTER U WITH TILDE AND ACUTE
    0x01E7A: [0x016A, 0x0308],  # LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS
    0x01E7B: [0x016B, 0x0308],  # LATIN SMALL LETTER U WITH MACRON AND DIAERESIS
    0x01E7C: [0x0056, 0x0303],  # LATIN CAPITAL LETTER V WITH TILDE
    0x01E7D: [0x0076, 0x0303],  # LATIN SMALL LETTER V WITH TILDE
    0x01E7E: [0x0056, 0x0323],  # LATIN CAPITAL LETTER V WITH DOT BELOW
    0x01E7F: [0x0076, 0x0323],  # LATIN SMALL LETTER V WITH DOT BELOW
    0x01E80: [0x0057, 0x0300],  # LATIN CAPITAL LETTER W WITH GRAVE
    0x01E81: [0x0077, 0x0300],  # LATIN SMALL LETTER W WITH GRAVE
    0x01E82: [0x0057, 0x0301],  # LATIN CAPITAL LETTER W WITH ACUTE
    0x01E83: [0x0077, 0x0301],  # LATIN SMALL LETTER W WITH ACUTE
    0x01E84: [0x0057, 0x0308],  # LATIN CAPITAL LETTER W WITH DIAERESIS
    0x01E85: [0x0077, 0x0308],  # LATIN SMALL LETTER W WITH DIAERESIS
    0x01E86: [0x0057, 0x0307],  # LATIN CAPITAL LETTER W WITH DOT ABOVE
    0x01E87: [0x0077, 0x0307],  # LATIN SMALL LETTER W WITH DOT ABOVE
    0x01E88: [0x0057, 0x0323],  # LATIN CAPITAL LETTER W WITH DOT BELOW
    0x01E89: [0x0077, 0x0323],  # LATIN SMALL LETTER W WITH DOT BELOW
    0x01E8A: [0x0058, 0x0307],  # LATIN CAPITAL LETTER X WITH DOT ABOVE
    0x01E8B: [0x0078, 0x0307],  # LATIN SMALL LETTER X WITH DOT ABOVE
    0x01E8C: [0x0058, 0x0308],  # LATIN CAPITAL LETTER X WITH DIAERESIS
    0x01E8D: [0x0078, 0x0308],  # LATIN SMALL LETTER X WITH DIAERESIS
    0x01E8E: [0x0059, 0x0307],  # LATIN CAPITAL LETTER Y WITH DOT ABOVE
    0x01E8F: [0x0079, 0x0307],  # LATIN SMALL LETTER Y WITH DOT ABOVE
    0x01E90: [0x005A, 0x0302],  # LATIN CAPITAL LETTER Z WITH CIRCUMFLEX
    0x01E91: [0x007A, 0x0302],  # LATIN SMALL LETTER Z WITH CIRCUMFLEX
    0x01E92: [0x005A, 0x0323],  # LATIN CAPITAL LETTER Z WITH DOT BELOW
    0x01E93: [0x007A, 0x0323],  # LATIN SMALL LETTER Z WITH DOT BELOW
    0x01E94: [0x005A, 0x0331],  # LATIN CAPITAL LETTER Z WITH LINE BELOW
    0x01E95: [0x007A, 0x0331],  # LATIN SMALL LETTER Z WITH LINE BELOW
    0x01E96: [0x0068, 0x0331],  # LATIN SMALL LETTER H WITH LINE BELOW
    0x01E97: [0x0074, 0x0308],  # LATIN SMALL LETTER T WITH DIAERESIS
    0x01E98: [0x0077, 0x030A],  # LATIN SMALL LETTER W WITH RING ABOVE
    0x01E99: [0x0079, 0x030A],  # LATIN SMALL LETTER Y WITH RING ABOVE
    0x01E9A: ["<compat>", 0x0061, 0x02BE],  # LATIN SMALL LETTER A WITH RIGHT HALF RING
    0x01E9B: [0x017F, 0x0307],  # LATIN SMALL LETTER LONG S WITH DOT ABOVE
    0x01EA0: [0x0041, 0x0323],  # LATIN CAPITAL LETTER A WITH DOT BELOW
    0x01EA1: [0x0061, 0x0323],  # LATIN SMALL LETTER A WITH DOT BELOW
    0x01EA2: [0x0041, 0x0309],  # LATIN CAPITAL LETTER A WITH HOOK ABOVE
    0x01EA3: [0x0061, 0x0309],  # LATIN SMALL LETTER A WITH HOOK ABOVE
    0x01EA4: [0x00C2, 0x0301],  # LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE
    0x01EA5: [0x00E2, 0x0301],  # LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE
    0x01EA6: [0x00C2, 0x0300],  # LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE
    0x01EA7: [0x00E2, 0x0300],  # LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE
    0x01EA8: [0x00C2, 0x0309],  # LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
    0x01EA9: [0x00E2, 0x0309],  # LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
    0x01EAA: [0x00C2, 0x0303],  # LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE
    0x01EAB: [0x00E2, 0x0303],  # LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE
    0x01EAC: [0x1EA0, 0x0302],  # LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW
    0x01EAD: [0x1EA1, 0x0302],  # LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW
    0x01EAE: [0x0102, 0x0301],  # LATIN CAPITAL LETTER A WITH BREVE AND ACUTE
    0x01EAF: [0x0103, 0x0301],  # LATIN SMALL LETTER A WITH BREVE AND ACUTE
    0x01EB0: [0x0102, 0x0300],  # LATIN CAPITAL LETTER A WITH BREVE AND GRAVE
    0x01EB1: [0x0103, 0x0300],  # LATIN SMALL LETTER A WITH BREVE AND GRAVE
    0x01EB2: [0x0102, 0x0309],  # LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE
    0x01EB3: [0x0103, 0x0309],  # LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE
    0x01EB4: [0x0102, 0x0303],  # LATIN CAPITAL LETTER A WITH BREVE AND TILDE
    0x01EB5: [0x0103, 0x0303],  # LATIN SMALL LETTER A WITH BREVE AND TILDE
    0x01EB6: [0x1EA0, 0x0306],  # LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW
    0x01EB7: [0x1EA1, 0x0306],  # LATIN SMALL LETTER A WITH BREVE AND DOT BELOW
    0x01EB8: [0x0045, 0x0323],  # LATIN CAPITAL LETTER E WITH DOT BELOW
    0x01EB9: [0x0065, 0x0323],  # LATIN SMALL LETTER E WITH DOT BELOW
    0x01EBA: [0x0045, 0x0309],  # LATIN CAPITAL LETTER E WITH HOOK ABOVE
    0x01EBB: [0x0065, 0x0309],  # LATIN SMALL LETTER E WITH HOOK ABOVE
    0x01EBC: [0x0045, 0x0303],  # LATIN CAPITAL LETTER E WITH TILDE
    0x01EBD: [0x0065, 0x0303],  # LATIN SMALL LETTER E WITH TILDE
    0x01EBE: [0x00CA, 0x0301],  # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
    0x01EBF: [0x00EA, 0x0301],  # LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
    0x01EC0: [0x00CA, 0x0300],  # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
    0x01EC1: [0x00EA, 0x0300],  # LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
    0x01EC2: [0x00CA, 0x0309],  # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
    0x01EC3: [0x00EA, 0x0309],  # LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
    0x01EC4: [0x00CA, 0x0303],  # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE
    0x01EC5: [0x00EA, 0x0303],  # LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE
    0x01EC6: [0x1EB8, 0x0302],  # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW
    0x01EC7: [0x1EB9, 0x0302],  # LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW
    0x01EC8: [0x0049, 0x0309],  # LATIN CAPITAL LETTER I WITH HOOK ABOVE
    0x01EC9: [0x0069, 0x0309],  # LATIN SMALL LETTER I WITH HOOK ABOVE
    0x01ECA: [0x0049, 0x0323],  # LATIN CAPITAL LETTER I WITH DOT BELOW
    0x01ECB: [0x0069, 0x0323],  # LATIN SMALL LETTER I WITH DOT BELOW
    0x01ECC: [0x004F, 0x0323],  # LATIN CAPITAL LETTER O WITH DOT BELOW
    0x01ECD: [0x006F, 0x0323],  # LATIN SMALL LETTER O WITH DOT BELOW
    0x01ECE: [0x004F, 0x0309],  # LATIN CAPITAL LETTER O WITH HOOK ABOVE
    0x01ECF: [0x006F, 0x0309],  # LATIN SMALL LETTER O WITH HOOK ABOVE
    0x01ED0: [0x00D4, 0x0301],  # LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE
    0x01ED1: [0x00F4, 0x0301],  # LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE
    0x01ED2: [0x00D4, 0x0300],  # LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE
    0x01ED3: [0x00F4, 0x0300],  # LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE
    0x01ED4: [0x00D4, 0x0309],  # LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
    0x01ED5: [0x00F4, 0x0309],  # LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
    0x01ED6: [0x00D4, 0x0303],  # LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE
    0x01ED7: [0x00F4, 0x0303],  # LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE
    0x01ED8: [0x1ECC, 0x0302],  # LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW
    0x01ED9: [0x1ECD, 0x0302],  # LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW
    0x01EDA: [0x01A0, 0x0301],  # LATIN CAPITAL LETTER O WITH HORN AND ACUTE
    0x01EDB: [0x01A1, 0x0301],  # LATIN SMALL LETTER O WITH HORN AND ACUTE
    0x01EDC: [0x01A0, 0x0300],  # LATIN CAPITAL LETTER O WITH HORN AND GRAVE
    0x01EDD: [0x01A1, 0x0300],  # LATIN SMALL LETTER O WITH HORN AND GRAVE
    0x01EDE: [0x01A0, 0x0309],  # LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE
    0x01EDF: [0x01A1, 0x0309],  # LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE
    0x01EE0: [0x01A0, 0x0303],  # LATIN CAPITAL LETTER O WITH HORN AND TILDE
    0x01EE1: [0x01A1, 0x0303],  # LATIN SMALL LETTER O WITH HORN AND TILDE
    0x01EE2: [0x01A0, 0x0323],  # LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW
    0x01EE3: [0x01A1, 0x0323],  # LATIN SMALL LETTER O WITH HORN AND DOT BELOW
    0x01EE4: [0x0055, 0x0323],  # LATIN CAPITAL LETTER U WITH DOT BELOW
    0x01EE5: [0x0075, 0x0323],  # LATIN SMALL LETTER U WITH DOT BELOW
    0x01EE6: [0x0055, 0x0309],  # LATIN CAPITAL LETTER U WITH HOOK ABOVE
    0x01EE7: [0x0075, 0x0309],  # LATIN SMALL LETTER U WITH HOOK ABOVE
    0x01EE8: [0x01AF, 0x0301],  # LATIN CAPITAL LETTER U WITH HORN AND ACUTE
    0x01EE9: [0x01B0, 0x0301],  # LATIN SMALL LETTER U WITH HORN AND ACUTE
    0x01EEA: [0x01AF, 0x0300],  # LATIN CAPITAL LETTER U WITH HORN AND GRAVE
    0x01EEB: [0x01B0, 0x0300],  # LATIN SMALL LETTER U WITH HORN AND GRAVE
    0x01EEC: [0x01AF, 0x0309],  # LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE
    0x01EED: [0x01B0, 0x0309],  # LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE
    0x01EEE: [0x01AF, 0x0303],  # LATIN CAPITAL LETTER U WITH HORN AND TILDE
    0x01EEF: [0x01B0, 0x0303],  # LATIN SMALL LETTER U WITH HORN AND TILDE
    0x01EF0: [0x01AF, 0x0323],  # LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW
    0x01EF1: [0x01B0, 0x0323],  # LATIN SMALL LETTER U WITH HORN AND DOT BELOW
    0x01EF2: [0x0059, 0x0300],  # LATIN CAPITAL LETTER Y WITH GRAVE
    0x01EF3: [0x0079, 0x0300],  # LATIN SMALL LETTER Y WITH GRAVE
    0x01EF4: [0x0059, 0x0323],  # LATIN CAPITAL LETTER Y WITH DOT BELOW
    0x01EF5: [0x0079, 0x0323],  # LATIN SMALL LETTER Y WITH DOT BELOW
    0x01EF6: [0x0059, 0x0309],  # LATIN CAPITAL LETTER Y WITH HOOK ABOVE
    0x01EF7: [0x0079, 0x0309],  # LATIN SMALL LETTER Y WITH HOOK ABOVE
    0x01EF8: [0x0059, 0x0303],  # LATIN CAPITAL LETTER Y WITH TILDE
    0x01EF9: [0x0079, 0x0303],  # LATIN SMALL LETTER Y WITH TILDE
    0x01F00: [0x03B1, 0x0313],  # GREEK SMALL LETTER ALPHA WITH PSILI
    0x01F01: [0x03B1, 0x0314],  # GREEK SMALL LETTER ALPHA WITH DASIA
    0x01F02: [0x1F00, 0x0300],  # GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA
    0x01F03: [0x1F01, 0x0300],  # GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA
    0x01F04: [0x1F00, 0x0301],  # GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA
    0x01F05: [0x1F01, 0x0301],  # GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA
    0x01F06: [0x1F00, 0x0342],  # GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI
    0x01F07: [0x1F01, 0x0342],  # GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI
    0x01F08: [0x0391, 0x0313],  # GREEK CAPITAL LETTER ALPHA WITH PSILI
    0x01F09: [0x0391, 0x0314],  # GREEK CAPITAL LETTER ALPHA WITH DASIA
    0x01F0A: [0x1F08, 0x0300],  # GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA
    0x01F0B: [0x1F09, 0x0300],  # GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA
    0x01F0C: [0x1F08, 0x0301],  # GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA
    0x01F0D: [0x1F09, 0x0301],  # GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA
    0x01F0E: [0x1F08, 0x0342],  # GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI
    0x01F0F: [0x1F09, 0x0342],  # GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI
    0x01F10: [0x03B5, 0x0313],  # GREEK SMALL LETTER EPSILON WITH PSILI
    0x01F11: [0x03B5, 0x0314],  # GREEK SMALL LETTER EPSILON WITH DASIA
    0x01F12: [0x1F10, 0x0300],  # GREEK SMALL LETTER EPSILON WITH PSILI AND VARIA
    0x01F13: [0x1F11, 0x0300],  # GREEK SMALL LETTER EPSILON WITH DASIA AND VARIA
    0x01F14: [0x1F10, 0x0301],  # GREEK SMALL LETTER EPSILON WITH PSILI AND OXIA
    0x01F15: [0x1F11, 0x0301],  # GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA
    0x01F18: [0x0395, 0x0313],  # GREEK CAPITAL LETTER EPSILON WITH PSILI
    0x01F19: [0x0395, 0x0314],  # GREEK CAPITAL LETTER EPSILON WITH DASIA
    0x01F1A: [0x1F18, 0x0300],  # GREEK CAPITAL LETTER EPSILON WITH PSILI AND VARIA
    0x01F1B: [0x1F19, 0x0300],  # GREEK CAPITAL LETTER EPSILON WITH DASIA AND VARIA
    0x01F1C: [0x1F18, 0x0301],  # GREEK CAPITAL LETTER EPSILON WITH PSILI AND OXIA
    0x01F1D: [0x1F19, 0x0301],  # GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA
    0x01F20: [0x03B7, 0x0313],  # GREEK SMALL LETTER ETA WITH PSILI
    0x01F21: [0x03B7, 0x0314],  # GREEK SMALL LETTER ETA WITH DASIA
    0x01F22: [0x1F20, 0x0300],  # GREEK SMALL LETTER ETA WITH PSILI AND VARIA
    0x01F23: [0x1F21, 0x0300],  # GREEK SMALL LETTER ETA WITH DASIA AND VARIA
    0x01F24: [0x1F20, 0x0301],  # GREEK SMALL LETTER ETA WITH PSILI AND OXIA
    0x01F25: [0x1F21, 0x0301],  # GREEK SMALL LETTER ETA WITH DASIA AND OXIA
    0x01F26: [0x1F20, 0x0342],  # GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI
    0x01F27: [0x1F21, 0x0342],  # GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI
    0x01F28: [0x0397, 0x0313],  # GREEK CAPITAL LETTER ETA WITH PSILI
    0x01F29: [0x0397, 0x0314],  # GREEK CAPITAL LETTER ETA WITH DASIA
    0x01F2A: [0x1F28, 0x0300],  # GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA
    0x01F2B: [0x1F29, 0x0300],  # GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA
    0x01F2C: [0x1F28, 0x0301],  # GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA
    0x01F2D: [0x1F29, 0x0301],  # GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA
    0x01F2E: [0x1F28, 0x0342],  # GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI
    0x01F2F: [0x1F29, 0x0342],  # GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI
    0x01F30: [0x03B9, 0x0313],  # GREEK SMALL LETTER IOTA WITH PSILI
    0x01F31: [0x03B9, 0x0314],  # GREEK SMALL LETTER IOTA WITH DASIA
    0x01F32: [0x1F30, 0x0300],  # GREEK SMALL LETTER IOTA WITH PSILI AND VARIA
    0x01F33: [0x1F31, 0x0300],  # GREEK SMALL LETTER IOTA WITH DASIA AND VARIA
    0x01F34: [0x1F30, 0x0301],  # GREEK SMALL LETTER IOTA WITH PSILI AND OXIA
    0x01F35: [0x1F31, 0x0301],  # GREEK SMALL LETTER IOTA WITH DASIA AND OXIA
    0x01F36: [0x1F30, 0x0342],  # GREEK SMALL LETTER IOTA WITH PSILI AND PERISPOMENI
    0x01F37: [0x1F31, 0x0342],  # GREEK SMALL LETTER IOTA WITH DASIA AND PERISPOMENI
    0x01F38: [0x0399, 0x0313],  # GREEK CAPITAL LETTER IOTA WITH PSILI
    0x01F39: [0x0399, 0x0314],  # GREEK CAPITAL LETTER IOTA WITH DASIA
    0x01F3A: [0x1F38, 0x0300],  # GREEK CAPITAL LETTER IOTA WITH PSILI AND VARIA
    0x01F3B: [0x1F39, 0x0300],  # GREEK CAPITAL LETTER IOTA WITH DASIA AND VARIA
    0x01F3C: [0x1F38, 0x0301],  # GREEK CAPITAL LETTER IOTA WITH PSILI AND OXIA
    0x01F3D: [0x1F39, 0x0301],  # GREEK CAPITAL LETTER IOTA WITH DASIA AND OXIA
    0x01F3E: [0x1F38, 0x0342],  # GREEK CAPITAL LETTER IOTA WITH PSILI AND PERISPOMENI
    0x01F3F: [0x1F39, 0x0342],  # GREEK CAPITAL LETTER IOTA WITH DASIA AND PERISPOMENI
    0x01F40: [0x03BF, 0x0313],  # GREEK SMALL LETTER OMICRON WITH PSILI
    0x01F41: [0x03BF, 0x0314],  # GREEK SMALL LETTER OMICRON WITH DASIA
    0x01F42: [0x1F40, 0x0300],  # GREEK SMALL LETTER OMICRON WITH PSILI AND VARIA
    0x01F43: [0x1F41, 0x0300],  # GREEK SMALL LETTER OMICRON WITH DASIA AND VARIA
    0x01F44: [0x1F40, 0x0301],  # GREEK SMALL LETTER OMICRON WITH PSILI AND OXIA
    0x01F45: [0x1F41, 0x0301],  # GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA
    0x01F48: [0x039F, 0x0313],  # GREEK CAPITAL LETTER OMICRON WITH PSILI
    0x01F49: [0x039F, 0x0314],  # GREEK CAPITAL LETTER OMICRON WITH DASIA
    0x01F4A: [0x1F48, 0x0300],  # GREEK CAPITAL LETTER OMICRON WITH PSILI AND VARIA
    0x01F4B: [0x1F49, 0x0300],  # GREEK CAPITAL LETTER OMICRON WITH DASIA AND VARIA
    0x01F4C: [0x1F48, 0x0301],  # GREEK CAPITAL LETTER OMICRON WITH PSILI AND OXIA
    0x01F4D: [0x1F49, 0x0301],  # GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA
    0x01F50: [0x03C5, 0x0313],  # GREEK SMALL LETTER UPSILON WITH PSILI
    0x01F51: [0x03C5, 0x0314],  # GREEK SMALL LETTER UPSILON WITH DASIA
    0x01F52: [0x1F50, 0x0300],  # GREEK SMALL LETTER UPSILON WITH PSILI AND VARIA
    0x01F53: [0x1F51, 0x0300],  # GREEK SMALL LETTER UPSILON WITH DASIA AND VARIA
    0x01F54: [0x1F50, 0x0301],  # GREEK SMALL LETTER UPSILON WITH PSILI AND OXIA
    0x01F55: [0x1F51, 0x0301],  # GREEK SMALL LETTER UPSILON WITH DASIA AND OXIA
    0x01F56: [0x1F50, 0x0342],  # GREEK SMALL LETTER UPSILON WITH PSILI AND PERISPOMENI
    0x01F57: [0x1F51, 0x0342],  # GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI
    0x01F59: [0x03A5, 0x0314],  # GREEK CAPITAL LETTER UPSILON WITH DASIA
    0x01F5B: [0x1F59, 0x0300],  # GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA
    0x01F5D: [0x1F59, 0x0301],  # GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA
    0x01F5F: [0x1F59, 0x0342],  # GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI
    0x01F60: [0x03C9, 0x0313],  # GREEK SMALL LETTER OMEGA WITH PSILI
    0x01F61: [0x03C9, 0x0314],  # GREEK SMALL LETTER OMEGA WITH DASIA
    0x01F62: [0x1F60, 0x0300],  # GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA
    0x01F63: [0x1F61, 0x0300],  # GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA
    0x01F64: [0x1F60, 0x0301],  # GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA
    0x01F65: [0x1F61, 0x0301],  # GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA
    0x01F66: [0x1F60, 0x0342],  # GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI
    0x01F67: [0x1F61, 0x0342],  # GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI
    0x01F68: [0x03A9, 0x0313],  # GREEK CAPITAL LETTER OMEGA WITH PSILI
    0x01F69: [0x03A9, 0x0314],  # GREEK CAPITAL LETTER OMEGA WITH DASIA
    0x01F6A: [0x1F68, 0x0300],  # GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA
    0x01F6B: [0x1F69, 0x0300],  # GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA
    0x01F6C: [0x1F68, 0x0301],  # GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA
    0x01F6D: [0x1F69, 0x0301],  # GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA
    0x01F6E: [0x1F68, 0x0342],  # GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI
    0x01F6F: [0x1F69, 0x0342],  # GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI
    0x01F70: [0x03B1, 0x0300],  # GREEK SMALL LETTER ALPHA WITH VARIA
    0x01F71: [0x03AC],  # GREEK SMALL LETTER ALPHA WITH OXIA
    0x01F72: [0x03B5, 0x0300],  # GREEK SMALL LETTER EPSILON WITH VARIA
    0x01F73: [0x03AD],  # GREEK SMALL LETTER EPSILON WITH OXIA
    0x01F74: [0x03B7, 0x0300],  # GREEK SMALL LETTER ETA WITH VARIA
    0x01F75: [0x03AE],  # GREEK SMALL LETTER ETA WITH OXIA
    0x01F76: [0x03B9, 0x0300],  # GREEK SMALL LETTER IOTA WITH VARIA
    0x01F77: [0x03AF],  # GREEK SMALL LETTER IOTA WITH OXIA
    0x01F78: [0x03BF, 0x0300],  # GREEK SMALL LETTER OMICRON WITH VARIA
    0x01F79: [0x03CC],  # GREEK SMALL LETTER OMICRON WITH OXIA
    0x01F7A: [0x03C5, 0x0300],  # GREEK SMALL LETTER UPSILON WITH VARIA
    0x01F7B: [0x03CD],  # GREEK SMALL LETTER UPSILON WITH OXIA
    0x01F7C: [0x03C9, 0x0300],  # GREEK SMALL LETTER OMEGA WITH VARIA
    0x01F7D: [0x03CE],  # GREEK SMALL LETTER OMEGA WITH OXIA
    0x01F80: [0x1F00, 0x0345],  # GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI
    0x01F81: [0x1F01, 0x0345],  # GREEK SMALL LETTER ALPHA WITH DASIA AND YPOGEGRAMMENI
    0x01F82: [0x1F02, 0x0345],  # GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA AND YPOGEGRAMMENI
    0x01F83: [0x1F03, 0x0345],  # GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA AND YPOGEGRAMMENI
    0x01F84: [0x1F04, 0x0345],  # GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA AND YPOGEGRAMMENI
    0x01F85: [0x1F05, 0x0345],  # GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA AND YPOGEGRAMMENI
    0x01F86: [0x1F06, 0x0345],  # GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI
    0x01F87: [0x1F07, 0x0345],  # GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
    0x01F88: [0x1F08, 0x0345],  # GREEK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENI
    0x01F89: [0x1F09, 0x0345],  # GREEK CAPITAL LETTER ALPHA WITH DASIA AND PROSGEGRAMMENI
    0x01F8A: [0x1F0A, 0x0345],  # GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA AND PROSGEGRAMMENI
    0x01F8B: [0x1F0B, 0x0345],  # GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA AND PROSGEGRAMMENI
    0x01F8C: [0x1F0C, 0x0345],  # GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA AND PROSGEGRAMMENI
    0x01F8D: [0x1F0D, 0x0345],  # GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA AND PROSGEGRAMMENI
    0x01F8E: [0x1F0E, 0x0345],  # GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
    0x01F8F: [0x1F0F, 0x0345],  # GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
    0x01F90: [0x1F20, 0x0345],  # GREEK SMALL LETTER ETA WITH PSILI AND YPOGEGRAMMENI
    0x01F91: [0x1F21, 0x0345],  # GREEK SMALL LETTER ETA WITH DASIA AND YPOGEGRAMMENI
    0x01F92: [0x1F22, 0x0345],  # GREEK SMALL LETTER ETA WITH PSILI AND VARIA AND YPOGEGRAMMENI
    0x01F93: [0x1F23, 0x0345],  # GREEK SMALL LETTER ETA WITH DASIA AND VARIA AND YPOGEGRAMMENI
    0x01F94: [0x1F24, 0x0345],  # GREEK SMALL LETTER ETA WITH PSILI AND OXIA AND YPOGEGRAMMENI
    0x01F95: [0x1F25, 0x0345],  # GREEK SMALL LETTER ETA WITH DASIA AND OXIA AND YPOGEGRAMMENI
    0x01F96: [0x1F26, 0x0345],  # GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI
    0x01F97: [0x1F27, 0x0345],  # GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
    0x01F98: [0x1F28, 0x0345],  # GREEK CAPITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENI
    0x01F99: [0x1F29, 0x0345],  # GREEK CAPITAL LETTER ETA WITH DASIA AND PROSGEGRAMMENI
    0x01F9A: [0x1F2A, 0x0345],  # GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA AND PROSGEGRAMMENI
    0x01F9B: [0x1F2B, 0x0345],  # GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA AND PROSGEGRAMMENI
    0x01F9C: [0x1F2C, 0x0345],  # GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA AND PROSGEGRAMMENI
    0x01F9D: [0x1F2D, 0x0345],  # GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA AND PROSGEGRAMMENI
    0x01F9E: [0x1F2E, 0x0345],  # GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
    0x01F9F: [0x1F2F, 0x0345],  # GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
    0x01FA0: [0x1F60, 0x0345],  # GREEK SMALL LETTER OMEGA WITH PSILI AND YPOGEGRAMMENI
    0x01FA1: [0x1F61, 0x0345],  # GREEK SMALL LETTER OMEGA WITH DASIA AND YPOGEGRAMMENI
    0x01FA2: [0x1F62, 0x0345],  # GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA AND YPOGEGRAMMENI
    0x01FA3: [0x1F63, 0x0345],  # GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA AND YPOGEGRAMMENI
    0x01FA4: [0x1F64, 0x0345],  # GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA AND YPOGEGRAMMENI
    0x01FA5: [0x1F65, 0x0345],  # GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA AND YPOGEGRAMMENI
    0x01FA6: [0x1F66, 0x0345],  # GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI
    0x01FA7: [0x1F67, 0x0345],  # GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
    0x01FA8: [0x1F68, 0x0345],  # GREEK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENI
    0x01FA9: [0x1F69, 0x0345],  # GREEK CAPITAL LETTER OMEGA WITH DASIA AND PROSGEGRAMMENI
    0x01FAA: [0x1F6A, 0x0345],  # GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA AND PROSGEGRAMMENI
    0x01FAB: [0x1F6B, 0x0345],  # GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA AND PROSGEGRAMMENI
    0x01FAC: [0x1F6C, 0x0345],  # GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA AND PROSGEGRAMMENI
    0x01FAD: [0x1F6D, 0x0345],  # GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA AND PROSGEGRAMMENI
    0x01FAE: [0x1F6E, 0x0345],  # GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
    0x01FAF: [0x1F6F, 0x0345],  # GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
    0x01FB0: [0x03B1, 0x0306],  # GREEK SMALL LETTER ALPHA WITH VRACHY
    0x01FB1: [0x03B1, 0x0304],  # GREEK SMALL LETTER ALPHA WITH MACRON
    0x01FB2: [0x1F70, 0x0345],  # GREEK SMALL LETTER ALPHA WITH VARIA AND YPOGEGRAMMENI
    0x01FB3: [0x03B1, 0x0345],  # GREEK SMALL LETTER ALPHA WITH YPOGEGRAMMENI
    0x01FB4: [0x03AC, 0x0345],  # GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI
    0x01FB6: [0x03B1, 0x0342],  # GREEK SMALL LETTER ALPHA WITH PERISPOMENI
    0x01FB7: [0x1FB6, 0x0345],  # GREEK SMALL LETTER ALPHA WITH PERISPOMENI AND YPOGEGRAMMENI
    0x01FB8: [0x0391, 0x0306],  # GREEK CAPITAL LETTER ALPHA WITH VRACHY
    0x01FB9: [0x0391, 0x0304],  # GREEK CAPITAL LETTER ALPHA WITH MACRON
    0x01FBA: [0x0391, 0x0300],  # GREEK CAPITAL LETTER ALPHA WITH VARIA
    0x01FBB: [0x0386],  # GREEK CAPITAL LETTER ALPHA WITH OXIA
    0x01FBC: [0x0391, 0x0345],  # GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI
    0x01FBD: ["<compat>", 0x0020, 0x0313],  # GREEK KORONIS
    0x01FBE: [0x03B9],  # GREEK PROSGEGRAMMENI
    0x01FBF: ["<compat>", 0x0020, 0x0313],  # GREEK PSILI
    0x01FC0: ["<compat>", 0x0020, 0x0342],  # GREEK PERISPOMENI
    0x01FC1: [0x00A8, 0x0342],  # GREEK DIALYTIKA AND PERISPOMENI
    0x01FC2: [0x1F74, 0x0345],  # GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI
    0x01FC3: [0x03B7, 0x0345],  # GREEK SMALL LETTER ETA WITH YPOGEGRAMMENI
    0x01FC4: [0x03AE, 0x0345],  # GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI
    0x01FC6: [0x03B7, 0x0342],  # GREEK SMALL LETTER ETA WITH PERISPOMENI
    0x01FC7: [0x1FC6, 0x0345],  # GREEK SMALL LETTER ETA WITH PERISPOMENI AND YPOGEGRAMMENI
    0x01FC8: [0x0395, 0x0300],  # GREEK CAPITAL LETTER EPSILON WITH VARIA
    0x01FC9: [0x0388],  # GREEK CAPITAL LETTER EPSILON WITH OXIA
    0x01FCA: [0x0397, 0x0300],  # GREEK CAPITAL LETTER ETA WITH VARIA
    0x01FCB: [0x0389],  # GREEK CAPITAL LETTER ETA WITH OXIA
    0x01FCC: [0x0397, 0x0345],  # GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI
    0x01FCD: [0x1FBF, 0x0300],  # GREEK PSILI AND VARIA
    0x01FCE: [0x1FBF, 0x0301],  # GREEK PSILI AND OXIA
    0x01FCF: [0x1FBF, 0x0342],  # GREEK PSILI AND PERISPOMENI
    0x01FD0: [0x03B9, 0x0306],  # GREEK SMALL LETTER IOTA WITH VRACHY
    0x01FD1: [0x03B9, 0x0304],  # GREEK SMALL LETTER IOTA WITH MACRON
    0x01FD2: [0x03CA, 0x0300],  # GREEK SMALL LETTER IOTA WITH DIALYTIKA AND VARIA
    0x01FD3: [0x0390],  # GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA
    0x01FD6: [0x03B9, 0x0342],  # GREEK SMALL LETTER IOTA WITH PERISPOMENI
    0x01FD7: [0x03CA, 0x0342],  # GREEK SMALL LETTER IOTA WITH DIALYTIKA AND PERISPOMENI
    0x01FD8: [0x0399, 0x0306],  # GREEK CAPITAL LETTER IOTA WITH VRACHY
    0x01FD9: [0x0399, 0x0304],  # GREEK CAPITAL LETTER IOTA WITH MACRON
    0x01FDA: [0x0399, 0x0300],  # GREEK CAPITAL LETTER IOTA WITH VARIA
    0x01FDB: [0x038A],  # GREEK CAPITAL LETTER IOTA WITH OXIA
    0x01FDD: [0x1FFE, 0x0300],  # GREEK DASIA AND VARIA
    0x01FDE: [0x1FFE, 0x0301],  # GREEK DASIA AND OXIA
    0x01FDF: [0x1FFE, 0x0342],  # GREEK DASIA AND PERISPOMENI
    0x01FE0: [0x03C5, 0x0306],  # GREEK SMALL LETTER UPSILON WITH VRACHY
    0x01FE1: [0x03C5, 0x0304],  # GREEK SMALL LETTER UPSILON WITH MACRON
    0x01FE2: [0x03CB, 0x0300],  # GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND VARIA
    0x01FE3: [0x03B0],  # GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND OXIA
    0x01FE4: [0x03C1, 0x0313],  # GREEK SMALL LETTER RHO WITH PSILI
    0x01FE5: [0x03C1, 0x0314],  # GREEK SMALL LETTER RHO WITH DASIA
    0x01FE6: [0x03C5, 0x0342],  # GREEK SMALL LETTER UPSILON WITH PERISPOMENI
    0x01FE7: [0x03CB, 0x0342],  # GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND PERISPOMENI
    0x01FE8: [0x03A5, 0x0306],  # GREEK CAPITAL LETTER UPSILON WITH VRACHY
    0x01FE9: [0x03A5, 0x0304],  # GREEK CAPITAL LETTER UPSILON WITH MACRON
    0x01FEA: [0x03A5, 0x0300],  # GREEK CAPITAL LETTER UPSILON WITH VARIA
    0x01FEB: [0x038E],  # GREEK CAPITAL LETTER UPSILON WITH OXIA
    0x01FEC: [0x03A1, 0x0314],  # GREEK CAPITAL LETTER RHO WITH DASIA
    0x01FED: [0x00A8, 0x0300],  # GREEK DIALYTIKA AND VARIA
    0x01FEE: [0x0385],  # GREEK DIALYTIKA AND OXIA
    0x01FEF: [0x0060],  # GREEK VARIA
    0x01FF2: [0x1F7C, 0x0345],  # GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI
    0x01FF3: [0x03C9, 0x0345],  # GREEK SMALL LETTER OMEGA WITH YPOGEGRAMMENI
    0x01FF4: [0x03CE, 0x0345],  # GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI
    0x01FF6: [0x03C9, 0x0342],  # GREEK SMALL LETTER OMEGA WITH PERISPOMENI
    0x01FF7: [0x1FF6, 0x0345],  # GREEK SMALL LETTER OMEGA WITH PERISPOMENI AND YPOGEGRAMMENI
    0x01FF8: [0x039F, 0x0300],  # GREEK CAPITAL LETTER OMICRON WITH VARIA
    0x01FF9: [0x038C],  # GREEK CAPITAL LETTER OMICRON WITH OXIA
    0x01FFA: [0x03A9, 0x0300],  # GREEK CAPITAL LETTER OMEGA WITH VARIA
    0x01FFB: [0x038F],  # GREEK CAPITAL LETTER OMEGA WITH OXIA
    0x01FFC: [0x03A9, 0x0345],  # GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI
    0x01FFD: [0x00B4],  # GREEK OXIA
    0x01FFE: ["<compat>", 0x0020, 0x0314],  # GREEK DASIA
    0x02000: [0x2002],  # EN QUAD
    0x02001: [0x2003],  # EM QUAD
    0x02002: ["<compat>", 0x0020],  # EN SPACE
    0x02003: ["<compat>", 0x0020],  # EM SPACE
    0x02004: ["<compat>", 0x0020],  # THREE-PER-EM SPACE
    0x02005: ["<compat>", 0x0020],  # FOUR-PER-EM SPACE
    0x02006: ["<compat>", 0x0020],  # SIX-PER-EM SPACE
    0x02007: ["<noBreak>", 0x0020],  # FIGURE SPACE
    0x02008: ["<compat>", 0x0020],  # PUNCTUATION SPACE
    0x02009: ["<compat>", 0x0020],  # THIN SPACE
    0x0200A: ["<compat>", 0x0020],  # HAIR SPACE
    0x02011: ["<noBreak>", 0x2010],  # NON-BREAKING HYPHEN
    0x02017: ["<compat>", 0x0020, 0x0333],  # DOUBLE LOW LINE
    0x02024: ["<compat>", 0x002E],  # ONE DOT LEADER
    0x02025: ["<compat>", 0x002E, 0x002E],  # TWO DOT LEADER
    0x02026: ["<compat>", 0x002E, 0x002E, 0x002E],  # HORIZONTAL ELLIPSIS
    0x0202F: ["<noBreak>", 0x0020],  # NARROW NO-BREAK SPACE
    0x02033: ["<compat>", 0x2032, 0x2032],  # DOUBLE PRIME
    0x02034: ["<compat>", 0x2032, 0x2032, 0x2032],  # TRIPLE PRIME
    0x02036: ["<compat>", 0x2035, 0x2035],  # REVERSED DOUBLE PRIME
    0x02037: ["<compat>", 0x2035, 0x2035, 0x2035],  # REVERSED TRIPLE PRIME
    0x0203C: ["<compat>", 0x0021, 0x0021],  # DOUBLE EXCLAMATION MARK
    0x0203E: ["<compat>", 0x0020, 0x0305],  # OVERLINE
    0x02047: ["<compat>", 0x003F, 0x003F],  # DOUBLE QUESTION MARK
    0x02048: ["<compat>", 0x003F, 0x0021],  # QUESTION EXCLAMATION MARK
    0x02049: ["<compat>", 0x0021, 0x003F],  # EXCLAMATION QUESTION MARK
    0x02057: ["<compat>", 0x2032, 0x2032, 0x2032, 0x2032],  # QUADRUPLE PRIME
    0x0205F: ["<compat>", 0x0020],  # MEDIUM MATHEMATICAL SPACE
    0x02070: ["<super>", 0x0030],  # SUPERSCRIPT ZERO
    0x02071: ["<super>", 0x0069],  # SUPERSCRIPT LATIN SMALL LETTER I
    0x02074: ["<super>", 0x0034],  # SUPERSCRIPT FOUR
    0x02075: ["<super>", 0x0035],  # SUPERSCRIPT FIVE
    0x02076: ["<super>", 0x0036],  # SUPERSCRIPT SIX
    0x02077: ["<super>", 0x0037],  # SUPERSCRIPT SEVEN
    0x02078: ["<super>", 0x0038],  # SUPERSCRIPT EIGHT
    0x02079: ["<super>", 0x0039],  # SUPERSCRIPT NINE
    0x0207A: ["<super>", 0x002B],  # SUPERSCRIPT PLUS SIGN
    0x0207B: ["<super>", 0x2212],  # SUPERSCRIPT MINUS
    0x0207C: ["<super>", 0x003D],  # SUPERSCRIPT EQUALS SIGN
    0x0207D: ["<super>", 0x0028],  # SUPERSCRIPT LEFT PARENTHESIS
    0x0207E: ["<super>", 0x0029],  # SUPERSCRIPT RIGHT PARENTHESIS
    0x0207F: ["<super>", 0x006E],  # SUPERSCRIPT LATIN SMALL LETTER N
    0x02080: ["<sub>", 0x0030],  # SUBSCRIPT ZERO
    0x02081: ["<sub>", 0x0031],  # SUBSCRIPT ONE
    0x02082: ["<sub>", 0x0032],  # SUBSCRIPT TWO
    0x02083: ["<sub>", 0x0033],  # SUBSCRIPT THREE
    0x02084: ["<sub>", 0x0034],  # SUBSCRIPT FOUR
    0x02085: ["<sub>", 0x0035],  # SUBSCRIPT FIVE
    0x02086: ["<sub>", 0x0036],  # SUBSCRIPT SIX
    0x02087: ["<sub>", 0x0037],  # SUBSCRIPT SEVEN
    0x02088: ["<sub>", 0x0038],  # SUBSCRIPT EIGHT
    0x02089: ["<sub>", 0x0039],  # SUBSCRIPT NINE
    0x0208A: ["<sub>", 0x002B],  # SUBSCRIPT PLUS SIGN
    0x0208B: ["<sub>", 0x2212],  # SUBSCRIPT MINUS
    0x0208C: ["<sub>", 0x003D],  # SUBSCRIPT EQUALS SIGN
    0x0208D: ["<sub>", 0x0028],  # SUBSCRIPT LEFT PARENTHESIS
    0x0208E: ["<sub>", 0x0029],  # SUBSCRIPT RIGHT PARENTHESIS
    0x02090: ["<sub>", 0x0061],  # LATIN SUBSCRIPT SMALL LETTER A
    0x02091: ["<sub>", 0x0065],  # LATIN SUBSCRIPT SMALL LETTER E
    0x02092: ["<sub>", 0x006F],  # LATIN SUBSCRIPT SMALL LETTER O
    0x02093: ["<sub>", 0x0078],  # LATIN SUBSCRIPT SMALL LETTER X
    0x02094: ["<sub>", 0x0259],  # LATIN SUBSCRIPT SMALL LETTER SCHWA
    0x02095: ["<sub>", 0x0068],  # LATIN SUBSCRIPT SMALL LETTER H
    0x02096: ["<sub>", 0x006B],  # LATIN SUBSCRIPT SMALL LETTER K
    0x02097: ["<sub>", 0x006C],  # LATIN SUBSCRIPT SMALL LETTER L
    0x02098: ["<sub>", 0x006D],  # LATIN SUBSCRIPT SMALL LETTER M
    0x02099: ["<sub>", 0x006E],  # LATIN SUBSCRIPT SMALL LETTER N
    0x0209A: ["<sub>", 0x0070],  # LATIN SUBSCRIPT SMALL LETTER P
    0x0209B: ["<sub>", 0x0073],  # LATIN SUBSCRIPT SMALL LETTER S
    0x0209C: ["<sub>", 0x0074],  # LATIN SUBSCRIPT SMALL LETTER T
    0x020A8: ["<compat>", 0x0052, 0x0073],  # RUPEE SIGN
    0x02100: ["<compat>", 0x0061, 0x002F, 0x0063],  # ACCOUNT OF
    0x02101: ["<compat>", 0x0061, 0x002F, 0x0073],  # ADDRESSED TO THE SUBJECT
    0x02102: ["<font>", 0x0043],  # DOUBLE-STRUCK CAPITAL C
    0x02103: ["<compat>", 0x00B0, 0x0043],  # DEGREE CELSIUS
    0x02105: ["<compat>", 0x0063, 0x002F, 0x006F],  # CARE OF
    0x02106: ["<compat>", 0x0063, 0x002F, 0x0075],  # CADA UNA
    0x02107: ["<compat>", 0x0190],  # EULER CONSTANT
    0x02109: ["<compat>", 0x00B0, 0x0046],  # DEGREE FAHRENHEIT
    0x0210A: ["<font>", 0x0067],  # SCRIPT SMALL G
    0x0210B: ["<font>", 0x0048],  # SCRIPT CAPITAL H
    0x0210C: ["<font>", 0x0048],  # BLACK-LETTER CAPITAL H
    0x0210D: ["<font>", 0x0048],  # DOUBLE-STRUCK CAPITAL H
    0x0210E: ["<font>", 0x0068],  # PLANCK CONSTANT
    0x0210F: ["<font>", 0x0127],  # PLANCK CONSTANT OVER TWO PI
    0x02110: ["<font>", 0x0049],  # SCRIPT CAPITAL I
    0x02111: ["<font>", 0x0049],  # BLACK-LETTER CAPITAL I
    0x02112: ["<font>", 0x004C],  # SCRIPT CAPITAL L
    0x02113: ["<font>", 0x006C],  # SCRIPT SMALL L
    0x02115: ["<font>", 0x004E],  # DOUBLE-STRUCK CAPITAL N
    0x02116: ["<compat>", 0x004E, 0x006F],  # NUMERO SIGN
    0x02119: ["<font>", 0x0050],  # DOUBLE-STRUCK CAPITAL P
    0x0211A: ["<font>", 0x0051],  # DOUBLE-STRUCK CAPITAL Q
    0x0211B: ["<font>", 0x0052],  # SCRIPT CAPITAL R
    0x0211C: ["<font>", 0x0052],  # BLACK-LETTER CAPITAL R
    0x0211D: ["<font>", 0x0052],  # DOUBLE-STRUCK CAPITAL R
    0x02120: ["<super>", 0x0053, 0x004D],  # SERVICE MARK
    0x02121: ["<compat>", 0x0054, 0x0045, 0x004C],  # TELEPHONE SIGN
    0x02122: ["<super>", 0x0054, 0x004D],  # TRADE MARK SIGN
    0x02124: ["<font>", 0x005A],  # DOUBLE-STRUCK CAPITAL Z
    0x02126: [0x03A9],  # OHM SIGN
    0x02128: ["<font>", 0x005A],  # BLACK-LETTER CAPITAL Z
    0x0212A: [0x004B],  # KELVIN SIGN
    0x0212B: [0x00C5],  # ANGSTROM SIGN
    0x0212C: ["<font>", 0x0042],  # SCRIPT CAPITAL B
    0x0212D: ["<font>", 0x0043],  # BLACK-LETTER CAPITAL C
    0x0212F: ["<font>", 0x0065],  # SCRIPT SMALL E
    0x02130: ["<font>", 0x0045],  # SCRIPT CAPITAL E
    0x02131: ["<font>", 0x0046],  # SCRIPT CAPITAL F
    0x02133: ["<font>", 0x004D],  # SCRIPT CAPITAL M
    0x02134: ["<font>", 0x006F],  # SCRIPT SMALL O
    0x02135: ["<compat>", 0x05D0],  # ALEF SYMBOL
    0x02136: ["<compat>", 0x05D1],  # BET SYMBOL
    0x02137: ["<compat>", 0x05D2],  # GIMEL SYMBOL
    0x02138: ["<compat>", 0x05D3],  # DALET SYMBOL
    0x02139: ["<font>", 0x0069],  # INFORMATION SOURCE
    0x0213B: ["<compat>", 0x0046, 0x0041, 0x0058],  # FACSIMILE SIGN
    0x0213C: ["<font>", 0x03C0],  # DOUBLE-STRUCK SMALL PI
    0x0213D: ["<font>", 0x03B3],  # DOUBLE-STRUCK SMALL GAMMA
    0x0213E: ["<font>", 0x0393],  # DOUBLE-STRUCK CAPITAL GAMMA
    0x0213F: ["<font>", 0x03A0],  # DOUBLE-STRUCK CAPITAL PI
    0x02140: ["<font>", 0x2211],  # DOUBLE-STRUCK N-ARY SUMMATION
    0x02145: ["<font>", 0x0044],  # DOUBLE-STRUCK ITALIC CAPITAL D
    0x02146: ["<font>", 0x0064],  # DOUBLE-STRUCK ITALIC SMALL D
    0x02147: ["<font>", 0x0065],  # DOUBLE-STRUCK ITALIC SMALL E
    0x02148: ["<font>", 0x0069],  # DOUBLE-STRUCK ITALIC SMALL I
    0x02149: ["<font>", 0x006A],  # DOUBLE-STRUCK ITALIC SMALL J
    0x02150: ["<fraction>", 0x0031, 0x2044, 0x0037],  # VULGAR FRACTION ONE SEVENTH
    0x02151: ["<fraction>", 0x0031, 0x2044, 0x0039],  # VULGAR FRACTION ONE NINTH
    0x02152: ["<fraction>", 0x0031, 0x2044, 0x0031, 0x0030],  # VULGAR FRACTION ONE TENTH
    0x02153: ["<fraction>", 0x0031, 0x2044, 0x0033],  # VULGAR FRACTION ONE THIRD
    0x02154: ["<fraction>", 0x0032, 0x2044, 0x0033],  # VULGAR FRACTION TWO THIRDS
    0x02155: ["<fraction>", 0x0031, 0x2044, 0x0035],  # VULGAR FRACTION ONE FIFTH
    0x02156: ["<fraction>", 0x0032, 0x2044, 0x0035],  # VULGAR FRACTION TWO FIFTHS
    0x02157: ["<fraction>", 0x0033, 0x2044, 0x0035],  # VULGAR FRACTION THREE FIFTHS
    0x02158: ["<fraction>", 0x0034, 0x2044, 0x0035],  # VULGAR FRACTION FOUR FIFTHS
    0x02159: ["<fraction>", 0x0031, 0x2044, 0x0036],  # VULGAR FRACTION ONE SIXTH
    0x0215A: ["<fraction>", 0x0035, 0x2044, 0x0036],  # VULGAR FRACTION FIVE SIXTHS
    0x0215B: ["<fraction>", 0x0031, 0x2044, 0x0038],  # VULGAR FRACTION ONE EIGHTH
    0x0215C: ["<fraction>", 0x0033, 0x2044, 0x0038],  # VULGAR FRACTION THREE EIGHTHS
    0x0215D: ["<fraction>", 0x0035, 0x2044, 0x0038],  # VULGAR FRACTION FIVE EIGHTHS
    0x0215E: ["<fraction>", 0x0037, 0x2044, 0x0038],  # VULGAR FRACTION SEVEN EIGHTHS
    0x0215F: ["<fraction>", 0x0031, 0x2044],  # FRACTION NUMERATOR ONE
    0x02160: ["<compat>", 0x0049],  # ROMAN NUMERAL ONE
    0x02161: ["<compat>", 0x0049, 0x0049],  # ROMAN NUMERAL TWO
    0x02162: ["<compat>", 0x0049, 0x0049, 0x0049],  # ROMAN NUMERAL THREE
    0x02163: ["<compat>", 0x0049, 0x0056],  # ROMAN NUMERAL FOUR
    0x02164: ["<compat>", 0x0056],  # ROMAN NUMERAL FIVE
    0x02165: ["<compat>", 0x0056, 0x0049],  # ROMAN NUMERAL SIX
    0x02166: ["<compat>", 0x0056, 0x0049, 0x0049],  # ROMAN NUMERAL SEVEN
    0x02167: ["<compat>", 0x0056, 0x0049, 0x0049, 0x0049],  # ROMAN NUMERAL EIGHT
    0x02168: ["<compat>", 0x0049, 0x0058],  # ROMAN NUMERAL NINE
    0x02169: ["<compat>", 0x0058],  # ROMAN NUMERAL TEN
    0x0216A: ["<compat>", 0x0058, 0x0049],  # ROMAN NUMERAL ELEVEN
    0x0216B: ["<compat>", 0x0058, 0x0049, 0x0049],  # ROMAN NUMERAL TWELVE
    0x0216C: ["<compat>", 0x004C],  # ROMAN NUMERAL FIFTY
    0x0216D: ["<compat>", 0x0043],  # ROMAN NUMERAL ONE HUNDRED
    0x0216E: ["<compat>", 0x0044],  # ROMAN NUMERAL FIVE HUNDRED
    0x0216F: ["<compat>", 0x004D],  # ROMAN NUMERAL ONE THOUSAND
    0x02170: ["<compat>", 0x0069],  # SMALL ROMAN NUMERAL ONE
    0x02171: ["<compat>", 0x0069, 0x0069],  # SMALL ROMAN NUMERAL TWO
    0x02172: ["<compat>", 0x0069, 0x0069, 0x0069],  # SMALL ROMAN NUMERAL THREE
    0x02173: ["<compat>", 0x0069, 0x0076],  # SMALL ROMAN NUMERAL FOUR
    0x02174: ["<compat>", 0x0076],  # SMALL ROMAN NUMERAL FIVE
    0x02175: ["<compat>", 0x0076, 0x0069],  # SMALL ROMAN NUMERAL SIX
    0x02176: ["<compat>", 0x0076, 0x0069, 0x0069],  # SMALL ROMAN NUMERAL SEVEN
    0x02177: ["<compat>", 0x0076, 0x0069, 0x0069, 0x0069],  # SMALL ROMAN NUMERAL EIGHT
    0x02178: ["<compat>", 0x0069, 0x0078],  # SMALL ROMAN NUMERAL NINE
    0x02179: ["<compat>", 0x0078],  # SMALL ROMAN NUMERAL TEN
    0x0217A: ["<compat>", 0x0078, 0x0069],  # SMALL ROMAN NUMERAL ELEVEN
    0x0217B: ["<compat>", 0x0078, 0x0069, 0x0069],  # SMALL ROMAN NUMERAL TWELVE
    0x0217C: ["<compat>", 0x006C],  # SMALL ROMAN NUMERAL FIFTY
    0x0217D: ["<compat>", 0x0063],  # SMALL ROMAN NUMERAL ONE HUNDRED
    0x0217E: ["<compat>", 0x0064],  # SMALL ROMAN NUMERAL FIVE HUNDRED
    0x0217F: ["<compat>", 0x006D],  # SMALL ROMAN NUMERAL ONE THOUSAND
    0x02189: ["<fraction>", 0x0030, 0x2044, 0x0033],  # VULGAR FRACTION ZERO THIRDS
    0x0219A: [0x2190, 0x0338],  # LEFTWARDS ARROW WITH STROKE
    0x0219B: [0x2192, 0x0338],  # RIGHTWARDS ARROW WITH STROKE
    0x021AE: [0x2194, 0x0338],  # LEFT RIGHT ARROW WITH STROKE
    0x021CD: [0x21D0, 0x0338],  # LEFTWARDS DOUBLE ARROW WITH STROKE
    0x021CE: [0x21D4, 0x0338],  # LEFT RIGHT DOUBLE ARROW WITH STROKE
    0x021CF: [0x21D2, 0x0338],  # RIGHTWARDS DOUBLE ARROW WITH STROKE
    0x02204: [0x2203, 0x0338],  # THERE DOES NOT EXIST
    0x02209: [0x2208, 0x0338],  # NOT AN ELEMENT OF
    0x0220C: [0x220B, 0x0338],  # DOES NOT CONTAIN AS MEMBER
    0x02224: [0x2223, 0x0338],  # DOES NOT DIVIDE
    0x02226: [0x2225, 0x0338],  # NOT PARALLEL TO
    0x0222C: ["<compat>", 0x222B, 0x222B],  # DOUBLE INTEGRAL
    0x0222D: ["<compat>", 0x222B, 0x222B, 0x222B],  # TRIPLE INTEGRAL
    0x0222F: ["<compat>", 0x222E, 0x222E],  # SURFACE INTEGRAL
    0x02230: ["<compat>", 0x222E, 0x222E, 0x222E],  # VOLUME INTEGRAL
    0x02241: [0x223C, 0x0338],  # NOT TILDE
    0x02244: [0x2243, 0x0338],  # NOT ASYMPTOTICALLY EQUAL TO
    0x02247: [0x2245, 0x0338],  # NEITHER APPROXIMATELY NOR ACTUALLY EQUAL TO
    0x02249: [0x2248, 0x0338],  # NOT ALMOST EQUAL TO
    0x02260: [0x003D, 0x0338],  # NOT EQUAL TO
    0x02262: [0x2261, 0x0338],  # NOT IDENTICAL TO
    0x0226D: [0x224D, 0x0338],  # NOT EQUIVALENT TO
    0x0226E: [0x003C, 0x0338],  # NOT LESS-THAN
    0x0226F: [0x003E, 0x0338],  # NOT GREATER-THAN
    0x02270: [0x2264, 0x0338],  # NEITHER LESS-THAN NOR EQUAL TO
    0x02271: [0x2265, 0x0338],  # NEITHER GREATER-THAN NOR EQUAL TO
    0x02274: [0x2272, 0x0338],  # NEITHER LESS-THAN NOR EQUIVALENT TO
    0x02275: [0x2273, 0x0338],  # NEITHER GREATER-THAN NOR EQUIVALENT TO
    0x02278: [0x2276, 0x0338],  # NEITHER LESS-THAN NOR GREATER-THAN
    0x02279: [0x2277, 0x0338],  # NEITHER GREATER-THAN NOR LESS-THAN
    0x02280: [0x227A, 0x0338],  # DOES NOT PRECEDE
    0x02281: [0x227B, 0x0338],  # DOES NOT SUCCEED
    0x02284: [0x2282, 0x0338],  # NOT A SUBSET OF
    0x02285: [0x2283, 0x0338],  # NOT A SUPERSET OF
    0x02288: [0x2286, 0x0338],  # NEITHER A SUBSET OF NOR EQUAL TO
    0x02289: [0x2287, 0x0338],  # NEITHER A SUPERSET OF NOR EQUAL TO
    0x022AC: [0x22A2, 0x0338],  # DOES NOT PROVE
    0x022AD: [0x22A8, 0x0338],  # NOT TRUE
    0x022AE: [0x22A9, 0x0338],  # DOES NOT FORCE
    0x022AF: [0x22AB, 0x0338],  # NEGATED DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE
    0x022E0: [0x227C, 0x0338],  # DOES NOT PRECEDE OR EQUAL
    0x022E1: [0x227D, 0x0338],  # DOES NOT SUCCEED OR EQUAL
    0x022E2: [0x2291, 0x0338],  # NOT SQUARE IMAGE OF OR EQUAL TO
    0x022E3: [0x2292, 0x0338],  # NOT SQUARE ORIGINAL OF OR EQUAL TO
    0x022EA: [0x22B2, 0x0338],  # NOT NORMAL SUBGROUP OF
    0x022EB: [0x22B3, 0x0338],  # DOES NOT CONTAIN AS NORMAL SUBGROUP
    0x022EC: [0x22B4, 0x0338],  # NOT NORMAL SUBGROUP OF OR EQUAL TO
    0x022ED: [0x22B5, 0x0338],  # DOES NOT CONTAIN AS NORMAL SUBGROUP OR EQUAL
    0x02329: [0x3008],  # LEFT-POINTING ANGLE BRACKET
    0x0232A: [0x3009],  # RIGHT-POINTING ANGLE BRACKET
    0x02460: ["<circle>", 0x0031],  # CIRCLED DIGIT ONE
    0x02461: ["<circle>", 0x0032],  # CIRCLED DIGIT TWO
    0x02462: ["<circle>", 0x0033],  # CIRCLED DIGIT THREE
    0x02463: ["<circle>", 0x0034],  # CIRCLED DIGIT FOUR
    0x02464: ["<circle>", 0x0035],  # CIRCLED DIGIT FIVE
    0x02465: ["<circle>", 0x0036],  # CIRCLED DIGIT SIX
    0x02466: ["<circle>", 0x0037],  # CIRCLED DIGIT SEVEN
    0x02467: ["<circle>", 0x0038],  # CIRCLED DIGIT EIGHT
    0x02468: ["<circle>", 0x0039],  # CIRCLED DIGIT NINE
    0x02469: ["<circle>", 0x0031, 0x0030],  # CIRCLED NUMBER TEN
    0x0246A: ["<circle>", 0x0031, 0x0031],  # CIRCLED NUMBER ELEVEN
    0x0246B: ["<circle>", 0x0031, 0x0032],  # CIRCLED NUMBER TWELVE
    0x0246C: ["<circle>", 0x0031, 0x0033],  # CIRCLED NUMBER THIRTEEN
    0x0246D: ["<circle>", 0x0031, 0x0034],  # CIRCLED NUMBER FOURTEEN
    0x0246E: ["<circle>", 0x0031, 0x0035],  # CIRCLED NUMBER FIFTEEN
    0x0246F: ["<circle>", 0x0031, 0x0036],  # CIRCLED NUMBER SIXTEEN
    0x02470: ["<circle>", 0x0031, 0x0037],  # CIRCLED NUMBER SEVENTEEN
    0x02471: ["<circle>", 0x0031, 0x0038],  # CIRCLED NUMBER EIGHTEEN
    0x02472: ["<circle>", 0x0031, 0x0039],  # CIRCLED NUMBER NINETEEN
    0x02473: ["<circle>", 0x0032, 0x0030],  # CIRCLED NUMBER TWENTY
    0x02474: ["<compat>", 0x0028, 0x0031, 0x0029],  # PARENTHESIZED DIGIT ONE
    0x02475: ["<compat>", 0x0028, 0x0032, 0x0029],  # PARENTHESIZED DIGIT TWO
    0x02476: ["<compat>", 0x0028, 0x0033, 0x0029],  # PARENTHESIZED DIGIT THREE
    0x02477: ["<compat>", 0x0028, 0x0034, 0x0029],  # PARENTHESIZED DIGIT FOUR
    0x02478: ["<compat>", 0x0028, 0x0035, 0x0029],  # PARENTHESIZED DIGIT FIVE
    0x02479: ["<compat>", 0x0028, 0x0036, 0x0029],  # PARENTHESIZED DIGIT SIX
    0x0247A: ["<compat>", 0x0028, 0x0037, 0x0029],  # PARENTHESIZED DIGIT SEVEN
    0x0247B: ["<compat>", 0x0028, 0x0038, 0x0029],  # PARENTHESIZED DIGIT EIGHT
    0x0247C: ["<compat>", 0x0028, 0x0039, 0x0029],  # PARENTHESIZED DIGIT NINE
    0x0247D: ["<compat>", 0x0028, 0x0031, 0x0030, 0x0029],  # PARENTHESIZED NUMBER TEN
    0x0247E: ["<compat>", 0x0028, 0x0031, 0x0031, 0x0029],  # PARENTHESIZED NUMBER ELEVEN
    0x0247F: ["<compat>", 0x0028, 0x0031, 0x0032, 0x0029],  # PARENTHESIZED NUMBER TWELVE
    0x02480: ["<compat>", 0x0028, 0x0031, 0x0033, 0x0029],  # PARENTHESIZED NUMBER THIRTEEN
    0x02481: ["<compat>", 0x0028, 0x0031, 0x0034, 0x0029],  # PARENTHESIZED NUMBER FOURTEEN
    0x02482: ["<compat>", 0x0028, 0x0031, 0x0035, 0x0029],  # PARENTHESIZED NUMBER FIFTEEN
    0x02483: ["<compat>", 0x0028, 0x0031, 0x0036, 0x0029],  # PARENTHESIZED NUMBER SIXTEEN
    0x02484: ["<compat>", 0x0028, 0x0031, 0x0037, 0x0029],  # PARENTHESIZED NUMBER SEVENTEEN
    0x02485: ["<compat>", 0x0028, 0x0031, 0x0038, 0x0029],  # PARENTHESIZED NUMBER EIGHTEEN
    0x02486: ["<compat>", 0x0028, 0x0031, 0x0039, 0x0029],  # PARENTHESIZED NUMBER NINETEEN
    0x02487: ["<compat>", 0x0028, 0x0032, 0x0030, 0x0029],  # PARENTHESIZED NUMBER TWENTY
    0x02488: ["<compat>", 0x0031, 0x002E],  # DIGIT ONE FULL STOP
    0x02489: ["<compat>", 0x0032, 0x002E],  # DIGIT TWO FULL STOP
    0x0248A: ["<compat>", 0x0033, 0x002E],  # DIGIT THREE FULL STOP
    0x0248B: ["<compat>", 0x0034, 0x002E],  # DIGIT FOUR FULL STOP
    0x0248C: ["<compat>", 0x0035, 0x002E],  # DIGIT FIVE FULL STOP
    0x0248D: ["<compat>", 0x0036, 0x002E],  # DIGIT SIX FULL STOP
    0x0248E: ["<compat>", 0x0037, 0x002E],  # DIGIT SEVEN FULL STOP
    0x0248F: ["<compat>", 0x0038, 0x002E],  # DIGIT EIGHT FULL STOP
    0x02490: ["<compat>", 0x0039, 0x002E],  # DIGIT NINE FULL STOP
    0x02491: ["<compat>", 0x0031, 0x0030, 0x002E],  # NUMBER TEN FULL STOP
    0x02492: ["<compat>", 0x0031, 0x0031, 0x002E],  # NUMBER ELEVEN FULL STOP
    0x02493: ["<compat>", 0x0031, 0x0032, 0x002E],  # NUMBER TWELVE FULL STOP
    0x02494: ["<compat>", 0x0031, 0x0033, 0x002E],  # NUMBER THIRTEEN FULL STOP
    0x02495: ["<compat>", 0x0031, 0x0034, 0x002E],  # NUMBER FOURTEEN FULL STOP
    0x02496: ["<compat>", 0x0031, 0x0035, 0x002E],  # NUMBER FIFTEEN FULL STOP
    0x02497: ["<compat>", 0x0031, 0x0036, 0x002E],  # NUMBER SIXTEEN FULL STOP
    0x02498: ["<compat>", 0x0031, 0x0037, 0x002E],  # NUMBER SEVENTEEN FULL STOP
    0x02499: ["<compat>", 0x0031, 0x0038, 0x002E],  # NUMBER EIGHTEEN FULL STOP
    0x0249A: ["<compat>", 0x0031, 0x0039, 0x002E],  # NUMBER NINETEEN FULL STOP
    0x0249B: ["<compat>", 0x0032, 0x0030, 0x002E],  # NUMBER TWENTY FULL STOP
    0x0249C: ["<compat>", 0x0028, 0x0061, 0x0029],  # PARENTHESIZED LATIN SMALL LETTER A
    0x0249D: ["<compat>", 0x0028, 0x0062, 0x0029],  # PARENTHESIZED LATIN SMALL LETTER B
    0x0249E: ["<compat>", 0x0028, 0x0063, 0x0029],  # PARENTHESIZED LATIN SMALL LETTER C
    0x0249F: ["<compat>", 0x0028, 0x0064, 0x0029],  # PARENTHESIZED LATIN SMALL LETTER D
    0x024A0: ["<compat>", 0x0028, 0x0065, 0x0029],  # PARENTHESIZED LATIN SMALL LETTER E
    0x024A1: ["<compat>", 0x0028, 0x0066, 0x0029],  # PARENTHESIZED LATIN SMALL LETTER F
    0x024A2: ["<compat>", 0x0028, 0x0067, 0x0029],  # PARENTHESIZED LATIN SMALL LETTER G
    0x024A3: ["<compat>", 0x0028, 0x0068, 0x0029],  # PARENTHESIZED LATIN SMALL LETTER H
    0x024A4: ["<compat>", 0x0028, 0x0069, 0x0029],  # PARENTHESIZED LATIN SMALL LETTER I
    0x024A5: ["<compat>", 0x0028, 0x006A, 0x0029],  # PARENTHESIZED LATIN SMALL LETTER J
    0x024A6: ["<compat>", 0x0028, 0x006B, 0x0029],  # PARENTHESIZED LATIN SMALL LETTER K
    0x024A7: ["<compat>", 0x0028, 0x006C, 0x0029],  # PARENTHESIZED LATIN SMALL LETTER L
    0x024A8: ["<compat>", 0x0028, 0x006D, 0x0029],  # PARENTHESIZED LATIN SMALL LETTER M
    0x024A9: ["<compat>", 0x0028, 0x006E, 0x0029],  # PARENTHESIZED LATIN SMALL LETTER N
    0x024AA: ["<compat>", 0x0028, 0x006F, 0x0029],  # PARENTHESIZED LATIN SMALL LETTER O
    0x024AB: ["<compat>", 0x0028, 0x0070, 0x0029],  # PARENTHESIZED LATIN SMALL LETTER P
    0x024AC: ["<compat>", 0x0028, 0x0071, 0x0029],  # PARENTHESIZED LATIN SMALL LETTER Q
    0x024AD: ["<compat>", 0x0028, 0x0072, 0x0029],  # PARENTHESIZED LATIN SMALL LETTER R
    0x024AE: ["<compat>", 0x0028, 0x0073, 0x0029],  # PARENTHESIZED LATIN SMALL LETTER S
    0x024AF: ["<compat>", 0x0028, 0x0074, 0x0029],  # PARENTHESIZED LATIN SMALL LETTER T
    0x024B0: ["<compat>", 0x0028, 0x0075, 0x0029],  # PARENTHESIZED LATIN SMALL LETTER U
    0x024B1: ["<compat>", 0x0028, 0x0076, 0x0029],  # PARENTHESIZED LATIN SMALL LETTER V
    0x024B2: ["<compat>", 0x0028, 0x0077, 0x0029],  # PARENTHESIZED LATIN SMALL LETTER W
    0x024B3: ["<compat>", 0x0028, 0x0078, 0x0029],  # PARENTHESIZED LATIN SMALL LETTER X
    0x024B4: ["<compat>", 0x0028, 0x0079, 0x0029],  # PARENTHESIZED LATIN SMALL LETTER Y
    0x024B5: ["<compat>", 0x0028, 0x007A, 0x0029],  # PARENTHESIZED LATIN SMALL LETTER Z
    0x024B6: ["<circle>", 0x0041],  # CIRCLED LATIN CAPITAL LETTER A
    0x024B7: ["<circle>", 0x0042],  # CIRCLED LATIN CAPITAL LETTER B
    0x024B8: ["<circle>", 0x0043],  # CIRCLED LATIN CAPITAL LETTER C
    0x024B9: ["<circle>", 0x0044],  # CIRCLED LATIN CAPITAL LETTER D
    0x024BA: ["<circle>", 0x0045],  # CIRCLED LATIN CAPITAL LETTER E
    0x024BB: ["<circle>", 0x0046],  # CIRCLED LATIN CAPITAL LETTER F
    0x024BC: ["<circle>", 0x0047],  # CIRCLED LATIN CAPITAL LETTER G
    0x024BD: ["<circle>", 0x0048],  # CIRCLED LATIN CAPITAL LETTER H
    0x024BE: ["<circle>", 0x0049],  # CIRCLED LATIN CAPITAL LETTER I
    0x024BF: ["<circle>", 0x004A],  # CIRCLED LATIN CAPITAL LETTER J
    0x024C0: ["<circle>", 0x004B],  # CIRCLED LATIN CAPITAL LETTER K
    0x024C1: ["<circle>", 0x004C],  # CIRCLED LATIN CAPITAL LETTER L
    0x024C2: ["<circle>", 0x004D],  # CIRCLED LATIN CAPITAL LETTER M
    0x024C3: ["<circle>", 0x004E],  # CIRCLED LATIN CAPITAL LETTER N
    0x024C4: ["<circle>", 0x004F],  # CIRCLED LATIN CAPITAL LETTER O
    0x024C5: ["<circle>", 0x0050],  # CIRCLED LATIN CAPITAL LETTER P
    0x024C6: ["<circle>", 0x0051],  # CIRCLED LATIN CAPITAL LETTER Q
    0x024C7: ["<circle>", 0x0052],  # CIRCLED LATIN CAPITAL LETTER R
    0x024C8: ["<circle>", 0x0053],  # CIRCLED LATIN CAPITAL LETTER S
    0x024C9: ["<circle>", 0x0054],  # CIRCLED LATIN CAPITAL LETTER T
    0x024CA: ["<circle>", 0x0055],  # CIRCLED LATIN CAPITAL LETTER U
    0x024CB: ["<circle>", 0x0056],  # CIRCLED LATIN CAPITAL LETTER V
    0x024CC: ["<circle>", 0x0057],  # CIRCLED LATIN CAPITAL LETTER W
    0x024CD: ["<circle>", 0x0058],  # CIRCLED LATIN CAPITAL LETTER X
    0x024CE: ["<circle>", 0x0059],  # CIRCLED LATIN CAPITAL LETTER Y
    0x024CF: ["<circle>", 0x005A],  # CIRCLED LATIN CAPITAL LETTER Z
    0x024D0: ["<circle>", 0x0061],  # CIRCLED LATIN SMALL LETTER A
    0x024D1: ["<circle>", 0x0062],  # CIRCLED LATIN SMALL LETTER B
    0x024D2: ["<circle>", 0x0063],  # CIRCLED LATIN SMALL LETTER C
    0x024D3: ["<circle>", 0x0064],  # CIRCLED LATIN SMALL LETTER D
    0x024D4: ["<circle>", 0x0065],  # CIRCLED LATIN SMALL LETTER E
    0x024D5: ["<circle>", 0x0066],  # CIRCLED LATIN SMALL LETTER F
    0x024D6: ["<circle>", 0x0067],  # CIRCLED LATIN SMALL LETTER G
    0x024D7: ["<circle>", 0x0068],  # CIRCLED LATIN SMALL LETTER H
    0x024D8: ["<circle>", 0x0069],  # CIRCLED LATIN SMALL LETTER I
    0x024D9: ["<circle>", 0x006A],  # CIRCLED LATIN SMALL LETTER J
    0x024DA: ["<circle>", 0x006B],  # CIRCLED LATIN SMALL LETTER K
    0x024DB: ["<circle>", 0x006C],  # CIRCLED LATIN SMALL LETTER L
    0x024DC: ["<circle>", 0x006D],  # CIRCLED LATIN SMALL LETTER M
    0x024DD: ["<circle>", 0x006E],  # CIRCLED LATIN SMALL LETTER N
    0x024DE: ["<circle>", 0x006F],  # CIRCLED LATIN SMALL LETTER O
    0x024DF: ["<circle>", 0x0070],  # CIRCLED LATIN SMALL LETTER P
    0x024E0: ["<circle>", 0x0071],  # CIRCLED LATIN SMALL LETTER Q
    0x024E1: ["<circle>", 0x0072],  # CIRCLED LATIN SMALL LETTER R
    0x024E2: ["<circle>", 0x0073],  # CIRCLED LATIN SMALL LETTER S
    0x024E3: ["<circle>", 0x0074],  # CIRCLED LATIN SMALL LETTER T
    0x024E4: ["<circle>", 0x0075],  # CIRCLED LATIN SMALL LETTER U
    0x024E5: ["<circle>", 0x0076],  # CIRCLED LATIN SMALL LETTER V
    0x024E6: ["<circle>", 0x0077],  # CIRCLED LATIN SMALL LETTER W
    0x024E7: ["<circle>", 0x0078],  # CIRCLED LATIN SMALL LETTER X
    0x024E8: ["<circle>", 0x0079],  # CIRCLED LATIN SMALL LETTER Y
    0x024E9: ["<circle>", 0x007A],  # CIRCLED LATIN SMALL LETTER Z
    0x024EA: ["<circle>", 0x0030],  # CIRCLED DIGIT ZERO
    0x02A0C: ["<compat>", 0x222B, 0x222B, 0x222B, 0x222B],  # QUADRUPLE INTEGRAL OPERATOR
    0x02A74: ["<compat>", 0x003A, 0x003A, 0x003D],  # DOUBLE COLON EQUAL
    0x02A75: ["<compat>", 0x003D, 0x003D],  # TWO CONSECUTIVE EQUALS SIGNS
    0x02A76: ["<compat>", 0x003D, 0x003D, 0x003D],  # THREE CONSECUTIVE EQUALS SIGNS
    0x02ADC: [0x2ADD, 0x0338],  # FORKING
    0x02C7C: ["<sub>", 0x006A],  # LATIN SUBSCRIPT SMALL LETTER J
    0x02C7D: ["<super>", 0x0056],  # MODIFIER LETTER CAPITAL V
    0x02D6F: ["<super>", 0x2D61],  # TIFINAGH MODIFIER LETTER LABIALIZATION MARK
    0x02E9F: ["<compat>", 0x6BCD],  # CJK RADICAL MOTHER
    0x02EF3: ["<compat>", 0x9F9F],  # CJK RADICAL C-SIMPLIFIED TURTLE
    0x02F00: ["<compat>", 0x4E00],  # KANGXI RADICAL ONE
    0x02F01: ["<compat>", 0x4E28],  # KANGXI RADICAL LINE
    0x02F02: ["<compat>", 0x4E36],  # KANGXI RADICAL DOT
    0x02F03: ["<compat>", 0x4E3F],  # KANGXI RADICAL SLASH
    0x02F04: ["<compat>", 0x4E59],  # KANGXI RADICAL SECOND
    0x02F05: ["<compat>", 0x4E85],  # KANGXI RADICAL HOOK
    0x02F06: ["<compat>", 0x4E8C],  # KANGXI RADICAL TWO
    0x02F07: ["<compat>", 0x4EA0],  # KANGXI RADICAL LID
    0x02F08: ["<compat>", 0x4EBA],  # KANGXI RADICAL MAN
    0x02F09: ["<compat>", 0x513F],  # KANGXI RADICAL LEGS
    0x02F0A: ["<compat>", 0x5165],  # KANGXI RADICAL ENTER
    0x02F0B: ["<compat>", 0x516B],  # KANGXI RADICAL EIGHT
    0x02F0C: ["<compat>", 0x5182],  # KANGXI RADICAL DOWN BOX
    0x02F0D: ["<compat>", 0x5196],  # KANGXI RADICAL COVER
    0x02F0E: ["<compat>", 0x51AB],  # KANGXI RADICAL ICE
    0x02F0F: ["<compat>", 0x51E0],  # KANGXI RADICAL TABLE
    0x02F10: ["<compat>", 0x51F5],  # KANGXI RADICAL OPEN BOX
    0x02F11: ["<compat>", 0x5200],  # KANGXI RADICAL KNIFE
    0x02F12: ["<compat>", 0x529B],  # KANGXI RADICAL POWER
    0x02F13: ["<compat>", 0x52F9],  # KANGXI RADICAL WRAP
    0x02F14: ["<compat>", 0x5315],  # KANGXI RADICAL SPOON
    0x02F15: ["<compat>", 0x531A],  # KANGXI RADICAL RIGHT OPEN BOX
    0x02F16: ["<compat>", 0x5338],  # KANGXI RADICAL HIDING ENCLOSURE
    0x02F17: ["<compat>", 0x5341],  # KANGXI RADICAL TEN
    0x02F18: ["<compat>", 0x535C],  # KANGXI RADICAL DIVINATION
    0x02F19: ["<compat>", 0x5369],  # KANGXI RADICAL SEAL
    0x02F1A: ["<compat>", 0x5382],  # KANGXI RADICAL CLIFF
    0x02F1B: ["<compat>", 0x53B6],  # KANGXI RADICAL PRIVATE
    0x02F1C: ["<compat>", 0x53C8],  # KANGXI RADICAL AGAIN
    0x02F1D: ["<compat>", 0x53E3],  # KANGXI RADICAL MOUTH
    0x02F1E: ["<compat>", 0x56D7],  # KANGXI RADICAL ENCLOSURE
    0x02F1F: ["<compat>", 0x571F],  # KANGXI RADICAL EARTH
    0x02F20: ["<compat>", 0x58EB],  # KANGXI RADICAL SCHOLAR
    0x02F21: ["<compat>", 0x5902],  # KANGXI RADICAL GO
    0x02F22: ["<compat>", 0x590A],  # KANGXI RADICAL GO SLOWLY
    0x02F23: ["<compat>", 0x5915],  # KANGXI RADICAL EVENING
    0x02F24: ["<compat>", 0x5927],  # KANGXI RADICAL BIG
    0x02F25: ["<compat>", 0x5973],  # KANGXI RADICAL WOMAN
    0x02F26: ["<compat>", 0x5B50],  # KANGXI RADICAL CHILD
    0x02F27: ["<compat>", 0x5B80],  # KANGXI RADICAL ROOF
    0x02F28: ["<compat>", 0x5BF8],  # KANGXI RADICAL INCH
    0x02F29: ["<compat>", 0x5C0F],  # KANGXI RADICAL SMALL
    0x02F2A: ["<compat>", 0x5C22],  # KANGXI RADICAL LAME
    0x02F2B: ["<compat>", 0x5C38],  # KANGXI RADICAL CORPSE
    0x02F2C: ["<compat>", 0x5C6E],  # KANGXI RADICAL SPROUT
    0x02F2D: ["<compat>", 0x5C71],  # KANGXI RADICAL MOUNTAIN
    0x02F2E: ["<compat>", 0x5DDB],  # KANGXI RADICAL RIVER
    0x02F2F: ["<compat>", 0x5DE5],  # KANGXI RADICAL WORK
    0x02F30: ["<compat>", 0x5DF1],  # KANGXI RADICAL ONESELF
    0x02F31: ["<compat>", 0x5DFE],  # KANGXI RADICAL TURBAN
    0x02F32: ["<compat>", 0x5E72],  # KANGXI RADICAL DRY
    0x02F33: ["<compat>", 0x5E7A],  # KANGXI RADICAL SHORT THREAD
    0x02F34: ["<compat>", 0x5E7F],  # KANGXI RADICAL DOTTED CLIFF
    0x02F35: ["<compat>", 0x5EF4],  # KANGXI RADICAL LONG STRIDE
    0x02F36: ["<compat>", 0x5EFE],  # KANGXI RADICAL TWO HANDS
    0x02F37: ["<compat>", 0x5F0B],  # KANGXI RADICAL SHOOT
    0x02F38: ["<compat>", 0x5F13],  # KANGXI RADICAL BOW
    0x02F39: ["<compat>", 0x5F50],  # KANGXI RADICAL SNOUT
    0x02F3A: ["<compat>", 0x5F61],  # KANGXI RADICAL BRISTLE
    0x02F3B: ["<compat>", 0x5F73],  # KANGXI RADICAL STEP
    0x02F3C: ["<compat>", 0x5FC3],  # KANGXI RADICAL HEART
    0x02F3D: ["<compat>", 0x6208],  # KANGXI RADICAL HALBERD
    0x02F3E: ["<compat>", 0x6236],  # KANGXI RADICAL DOOR
    0x02F3F: ["<compat>", 0x624B],  # KANGXI RADICAL HAND
    0x02F40: ["<compat>", 0x652F],  # KANGXI RADICAL BRANCH
    0x02F41: ["<compat>", 0x6534],  # KANGXI RADICAL RAP
    0x02F42: ["<compat>", 0x6587],  # KANGXI RADICAL SCRIPT
    0x02F43: ["<compat>", 0x6597],  # KANGXI RADICAL DIPPER
    0x02F44: ["<compat>", 0x65A4],  # KANGXI RADICAL AXE
    0x02F45: ["<compat>", 0x65B9],  # KANGXI RADICAL SQUARE
    0x02F46: ["<compat>", 0x65E0],  # KANGXI RADICAL NOT
    0x02F47: ["<compat>", 0x65E5],  # KANGXI RADICAL SUN
    0x02F48: ["<compat>", 0x66F0],  # KANGXI RADICAL SAY
    0x02F49: ["<compat>", 0x6708],  # KANGXI RADICAL MOON
    0x02F4A: ["<compat>", 0x6728],  # KANGXI RADICAL TREE
    0x02F4B: ["<compat>", 0x6B20],  # KANGXI RADICAL LACK
    0x02F4C: ["<compat>", 0x6B62],  # KANGXI RADICAL STOP
    0x02F4D: ["<compat>", 0x6B79],  # KANGXI RADICAL DEATH
    0x02F4E: ["<compat>", 0x6BB3],  # KANGXI RADICAL WEAPON
    0x02F4F: ["<compat>", 0x6BCB],  # KANGXI RADICAL DO NOT
    0x02F50: ["<compat>", 0x6BD4],  # KANGXI RADICAL COMPARE
    0x02F51: ["<compat>", 0x6BDB],  # KANGXI RADICAL FUR
    0x02F52: ["<compat>", 0x6C0F],  # KANGXI RADICAL CLAN
    0x02F53: ["<compat>", 0x6C14],  # KANGXI RADICAL STEAM
    0x02F54: ["<compat>", 0x6C34],  # KANGXI RADICAL WATER
    0x02F55: ["<compat>", 0x706B],  # KANGXI RADICAL FIRE
    0x02F56: ["<compat>", 0x722A],  # KANGXI RADICAL CLAW
    0x02F57: ["<compat>", 0x7236],  # KANGXI RADICAL FATHER
    0x02F58: ["<compat>", 0x723B],  # KANGXI RADICAL DOUBLE X
    0x02F59: ["<compat>", 0x723F],  # KANGXI RADICAL HALF TREE TRUNK
    0x02F5A: ["<compat>", 0x7247],  # KANGXI RADICAL SLICE
    0x02F5B: ["<compat>", 0x7259],  # KANGXI RADICAL FANG
    0x02F5C: ["<compat>", 0x725B],  # KANGXI RADICAL COW
    0x02F5D: ["<compat>", 0x72AC],  # KANGXI RADICAL DOG
    0x02F5E: ["<compat>", 0x7384],  # KANGXI RADICAL PROFOUND
    0x02F5F: ["<compat>", 0x7389],  # KANGXI RADICAL JADE
    0x02F60: ["<compat>", 0x74DC],  # KANGXI RADICAL MELON
    0x02F61: ["<compat>", 0x74E6],  # KANGXI RADICAL TILE
    0x02F62: ["<compat>", 0x7518],  # KANGXI RADICAL SWEET
    0x02F63: ["<compat>", 0x751F],  # KANGXI RADICAL LIFE
    0x02F64: ["<compat>", 0x7528],  # KANGXI RADICAL USE
    0x02F65: ["<compat>", 0x7530],  # KANGXI RADICAL FIELD
    0x02F66: ["<compat>", 0x758B],  # KANGXI RADICAL BOLT OF CLOTH
    0x02F67: ["<compat>", 0x7592],  # KANGXI RADICAL SICKNESS
    0x02F68: ["<compat>", 0x7676],  # KANGXI RADICAL DOTTED TENT
    0x02F69: ["<compat>", 0x767D],  # KANGXI RADICAL WHITE
    0x02F6A: ["<compat>", 0x76AE],  # KANGXI RADICAL SKIN
    0x02F6B: ["<compat>", 0x76BF],  # KANGXI RADICAL DISH
    0x02F6C: ["<compat>", 0x76EE],  # KANGXI RADICAL EYE
    0x02F6D: ["<compat>", 0x77DB],  # KANGXI RADICAL SPEAR
    0x02F6E: ["<compat>", 0x77E2],  # KANGXI RADICAL ARROW
    0x02F6F: ["<compat>", 0x77F3],  # KANGXI RADICAL STONE
    0x02F70: ["<compat>", 0x793A],  # KANGXI RADICAL SPIRIT
    0x02F71: ["<compat>", 0x79B8],  # KANGXI RADICAL TRACK
    0x02F72: ["<compat>", 0x79BE],  # KANGXI RADICAL GRAIN
    0x02F73: ["<compat>", 0x7A74],  # KANGXI RADICAL CAVE
    0x02F74: ["<compat>", 0x7ACB],  # KANGXI RADICAL STAND
    0x02F75: ["<compat>", 0x7AF9],  # KANGXI RADICAL BAMBOO
    0x02F76: ["<compat>", 0x7C73],  # KANGXI RADICAL RICE
    0x02F77: ["<compat>", 0x7CF8],  # KANGXI RADICAL SILK
    0x02F78: ["<compat>", 0x7F36],  # KANGXI RADICAL JAR
    0x02F79: ["<compat>", 0x7F51],  # KANGXI RADICAL NET
    0x02F7A: ["<compat>", 0x7F8A],  # KANGXI RADICAL SHEEP
    0x02F7B: ["<compat>", 0x7FBD],  # KANGXI RADICAL FEATHER
    0x02F7C: ["<compat>", 0x8001],  # KANGXI RADICAL OLD
    0x02F7D: ["<compat>", 0x800C],  # KANGXI RADICAL AND
    0x02F7E: ["<compat>", 0x8012],  # KANGXI RADICAL PLOW
    0x02F7F: ["<compat>", 0x8033],  # KANGXI RADICAL EAR
    0x02F80: ["<compat>", 0x807F],  # KANGXI RADICAL BRUSH
    0x02F81: ["<compat>", 0x8089],  # KANGXI RADICAL MEAT
    0x02F82: ["<compat>", 0x81E3],  # KANGXI RADICAL MINISTER
    0x02F83: ["<compat>", 0x81EA],  # KANGXI RADICAL SELF
    0x02F84: ["<compat>", 0x81F3],  # KANGXI RADICAL ARRIVE
    0x02F85: ["<compat>", 0x81FC],  # KANGXI RADICAL MORTAR
    0x02F86: ["<compat>", 0x820C],  # KANGXI RADICAL TONGUE
    0x02F87: ["<compat>", 0x821B],  # KANGXI RADICAL OPPOSE
    0x02F88: ["<compat>", 0x821F],  # KANGXI RADICAL BOAT
    0x02F89: ["<compat>", 0x826E],  # KANGXI RADICAL STOPPING
    0x02F8A: ["<compat>", 0x8272],  # KANGXI RADICAL COLOR
    0x02F8B: ["<compat>", 0x8278],  # KANGXI RADICAL GRASS
    0x02F8C: ["<compat>", 0x864D],  # KANGXI RADICAL TIGER
    0x02F8D: ["<compat>", 0x866B],  # KANGXI RADICAL INSECT
    0x02F8E: ["<compat>", 0x8840],  # KANGXI RADICAL BLOOD
    0x02F8F: ["<compat>", 0x884C],  # KANGXI RADICAL WALK ENCLOSURE
    0x02F90: ["<compat>", 0x8863],  # KANGXI RADICAL CLOTHES
    0x02F91: ["<compat>", 0x897E],  # KANGXI RADICAL WEST
    0x02F92: ["<compat>", 0x898B],  # KANGXI RADICAL SEE
    0x02F93: ["<compat>", 0x89D2],  # KANGXI RADICAL HORN
    0x02F94: ["<compat>", 0x8A00],  # KANGXI RADICAL SPEECH
    0x02F95: ["<compat>", 0x8C37],  # KANGXI RADICAL VALLEY
    0x02F96: ["<compat>", 0x8C46],  # KANGXI RADICAL BEAN
    0x02F97: ["<compat>", 0x8C55],  # KANGXI RADICAL PIG
    0x02F98: ["<compat>", 0x8C78],  # KANGXI RADICAL BADGER
    0x02F99: ["<compat>", 0x8C9D],  # KANGXI RADICAL SHELL
    0x02F9A: ["<compat>", 0x8D64],  # KANGXI RADICAL RED
    0x02F9B: ["<compat>", 0x8D70],  # KANGXI RADICAL RUN
    0x02F9C: ["<compat>", 0x8DB3],  # KANGXI RADICAL FOOT
    0x02F9D: ["<compat>", 0x8EAB],  # KANGXI RADICAL BODY
    0x02F9E: ["<compat>", 0x8ECA],  # KANGXI RADICAL CART
    0x02F9F: ["<compat>", 0x8F9B],  # KANGXI RADICAL BITTER
    0x02FA0: ["<compat>", 0x8FB0],  # KANGXI RADICAL MORNING
    0x02FA1: ["<compat>", 0x8FB5],  # KANGXI RADICAL WALK
    0x02FA2: ["<compat>", 0x9091],  # KANGXI RADICAL CITY
    0x02FA3: ["<compat>", 0x9149],  # KANGXI RADICAL WINE
    0x02FA4: ["<compat>", 0x91C6],  # KANGXI RADICAL DISTINGUISH
    0x02FA5: ["<compat>", 0x91CC],  # KANGXI RADICAL VILLAGE
    0x02FA6: ["<compat>", 0x91D1],  # KANGXI RADICAL GOLD
    0x02FA7: ["<compat>", 0x9577],  # KANGXI RADICAL LONG
    0x02FA8: ["<compat>", 0x9580],  # KANGXI RADICAL GATE
    0x02FA9: ["<compat>", 0x961C],  # KANGXI RADICAL MOUND
    0x02FAA: ["<compat>", 0x96B6],  # KANGXI RADICAL SLAVE
    0x02FAB: ["<compat>", 0x96B9],  # KANGXI RADICAL SHORT TAILED BIRD
    0x02FAC: ["<compat>", 0x96E8],  # KANGXI RADICAL RAIN
    0x02FAD: ["<compat>", 0x9751],  # KANGXI RADICAL BLUE
    0x02FAE: ["<compat>", 0x975E],  # KANGXI RADICAL WRONG
    0x02FAF: ["<compat>", 0x9762],  # KANGXI RADICAL FACE
    0x02FB0: ["<compat>", 0x9769],  # KANGXI RADICAL LEATHER
    0x02FB1: ["<compat>", 0x97CB],  # KANGXI RADICAL TANNED LEATHER
    0x02FB2: ["<compat>", 0x97ED],  # KANGXI RADICAL LEEK
    0x02FB3: ["<compat>", 0x97F3],  # KANGXI RADICAL SOUND
    0x02FB4: ["<compat>", 0x9801],  # KANGXI RADICAL LEAF
    0x02FB5: ["<compat>", 0x98A8],  # KANGXI RADICAL WIND
    0x02FB6: ["<compat>", 0x98DB],  # KANGXI RADICAL FLY
    0x02FB7: ["<compat>", 0x98DF],  # KANGXI RADICAL EAT
    0x02FB8: ["<compat>", 0x9996],  # KANGXI RADICAL HEAD
    0x02FB9: ["<compat>", 0x9999],  # KANGXI RADICAL FRAGRANT
    0x02FBA: ["<compat>", 0x99AC],  # KANGXI RADICAL HORSE
    0x02FBB: ["<compat>", 0x9AA8],  # KANGXI RADICAL BONE
    0x02FBC: ["<compat>", 0x9AD8],  # KANGXI RADICAL TALL
    0x02FBD: ["<compat>", 0x9ADF],  # KANGXI RADICAL HAIR
    0x02FBE: ["<compat>", 0x9B25],  # KANGXI RADICAL FIGHT
    0x02FBF: ["<compat>", 0x9B2F],  # KANGXI RADICAL SACRIFICIAL WINE
    0x02FC0: ["<compat>", 0x9B32],  # KANGXI RADICAL CAULDRON
    0x02FC1: ["<compat>", 0x9B3C],  # KANGXI RADICAL GHOST
    0x02FC2: ["<compat>", 0x9B5A],  # KANGXI RADICAL FISH
    0x02FC3: ["<compat>", 0x9CE5],  # KANGXI RADICAL BIRD
    0x02FC4: ["<compat>", 0x9E75],  # KANGXI RADICAL SALT
    0x02FC5: ["<compat>", 0x9E7F],  # KANGXI RADICAL DEER
    0x02FC6: ["<compat>", 0x9EA5],  # KANGXI RADICAL WHEAT
    0x02FC7: ["<compat>", 0x9EBB],  # KANGXI RADICAL HEMP
    0x02FC8: ["<compat>", 0x9EC3],  # KANGXI RADICAL YELLOW
    0x02FC9: ["<compat>", 0x9ECD],  # KANGXI RADICAL MILLET
    0x02FCA: ["<compat>", 0x9ED1],  # KANGXI RADICAL BLACK
    0x02FCB: ["<compat>", 0x9EF9],  # KANGXI RADICAL EMBROIDERY
    0x02FCC: ["<compat>", 0x9EFD],  # KANGXI RADICAL FROG
    0x02FCD: ["<compat>", 0x9F0E],  # KANGXI RADICAL TRIPOD
    0x02FCE: ["<compat>", 0x9F13],  # KANGXI RADICAL DRUM
    0x02FCF: ["<compat>", 0x9F20],  # KANGXI RADICAL RAT
    0x02FD0: ["<compat>", 0x9F3B],  # KANGXI RADICAL NOSE
    0x02FD1: ["<compat>", 0x9F4A],  # KANGXI RADICAL EVEN
    0x02FD2: ["<compat>", 0x9F52],  # KANGXI RADICAL TOOTH
    0x02FD3: ["<compat>", 0x9F8D],  # KANGXI RADICAL DRAGON
    0x02FD4: ["<compat>", 0x9F9C],  # KANGXI RADICAL TURTLE
    0x02FD5: ["<compat>", 0x9FA0],  # KANGXI RADICAL FLUTE
    0x03000: ["<wide>", 0x0020],  # IDEOGRAPHIC SPACE
    0x03036: ["<compat>", 0x3012],  # CIRCLED POSTAL MARK
    0x03038: ["<compat>", 0x5341],  # HANGZHOU NUMERAL TEN
    0x03039: ["<compat>", 0x5344],  # HANGZHOU NUMERAL TWENTY
    0x0303A: ["<compat>", 0x5345],  # HANGZHOU NUMERAL THIRTY
    0x0304C: [0x304B, 0x3099],  # HIRAGANA LETTER GA
    0x0304E: [0x304D, 0x3099],  # HIRAGANA LETTER GI
    0x03050: [0x304F, 0x3099],  # HIRAGANA LETTER GU
    0x03052: [0x3051, 0x3099],  # HIRAGANA LETTER GE
    0x03054: [0x3053, 0x3099],  # HIRAGANA LETTER GO
    0x03056: [0x3055, 0x3099],  # HIRAGANA LETTER ZA
    0x03058: [0x3057, 0x3099],  # HIRAGANA LETTER ZI
    0x0305A: [0x3059, 0x3099],  # HIRAGANA LETTER ZU
    0x0305C: [0x305B, 0x3099],  # HIRAGANA LETTER ZE
    0x0305E: [0x305D, 0x3099],  # HIRAGANA LETTER ZO
    0x03060: [0x305F, 0x3099],  # HIRAGANA LETTER DA
    0x03062: [0x3061, 0x3099],  # HIRAGANA LETTER DI
    0x03065: [0x3064, 0x3099],  # HIRAGANA LETTER DU
    0x03067: [0x3066, 0x3099],  # HIRAGANA LETTER DE
    0x03069: [0x3068, 0x3099],  # HIRAGANA LETTER DO
    0x03070: [0x306F, 0x3099],  # HIRAGANA LETTER BA
    0x03071: [0x306F, 0x309A],  # HIRAGANA LETTER PA
    0x03073: [0x3072, 0x3099],  # HIRAGANA LETTER BI
    0x03074: [0x3072, 0x309A],  # HIRAGANA LETTER PI
    0x03076: [0x3075, 0x3099],  # HIRAGANA LETTER BU
    0x03077: [0x3075, 0x309A],  # HIRAGANA LETTER PU
    0x03079: [0x3078, 0x3099],  # HIRAGANA LETTER BE
    0x0307A: [0x3078, 0x309A],  # HIRAGANA LETTER PE
    0x0307C: [0x307B, 0x3099],  # HIRAGANA LETTER BO
    0x0307D: [0x307B, 0x309A],  # HIRAGANA LETTER PO
    0x03094: [0x3046, 0x3099],  # HIRAGANA LETTER VU
    0x0309B: ["<compat>", 0x0020, 0x3099],  # KATAKANA-HIRAGANA VOICED SOUND MARK
    0x0309C: ["<compat>", 0x0020, 0x309A],  # KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
    0x0309E: [0x309D, 0x3099],  # HIRAGANA VOICED ITERATION MARK
    0x0309F: ["<vertical>", 0x3088, 0x308A],  # HIRAGANA DIGRAPH YORI
    0x030AC: [0x30AB, 0x3099],  # KATAKANA LETTER GA
    0x030AE: [0x30AD, 0x3099],  # KATAKANA LETTER GI
    0x030B0: [0x30AF, 0x3099],  # KATAKANA LETTER GU
    0x030B2: [0x30B1, 0x3099],  # KATAKANA LETTER GE
    0x030B4: [0x30B3, 0x3099],  # KATAKANA LETTER GO
    0x030B6: [0x30B5, 0x3099],  # KATAKANA LETTER ZA
    0x030B8: [0x30B7, 0x3099],  # KATAKANA LETTER ZI
    0x030BA: [0x30B9, 0x3099],  # KATAKANA LETTER ZU
    0x030BC: [0x30BB, 0x3099],  # KATAKANA LETTER ZE
    0x030BE: [0x30BD, 0x3099],  # KATAKANA LETTER ZO
    0x030C0: [0x30BF, 0x3099],  # KATAKANA LETTER DA
    0x030C2: [0x30C1, 0x3099],  # KATAKANA LETTER DI
    0x030C5: [0x30C4, 0x3099],  # KATAKANA LETTER DU
    0x030C7: [0x30C6, 0x3099],  # KATAKANA LETTER DE
    0x030C9: [0x30C8, 0x3099],  # KATAKANA LETTER DO
    0x030D0: [0x30CF, 0x3099],  # KATAKANA LETTER BA
    0x030D1: [0x30CF, 0x309A],  # KATAKANA LETTER PA
    0x030D3: [0x30D2, 0x3099],  # KATAKANA LETTER BI
    0x030D4: [0x30D2, 0x309A],  # KATAKANA LETTER PI
    0x030D6: [0x30D5, 0x3099],  # KATAKANA LETTER BU
    0x030D7: [0x30D5, 0x309A],  # KATAKANA LETTER PU
    0x030D9: [0x30D8, 0x3099],  # KATAKANA LETTER BE
    0x030DA: [0x30D8, 0x309A],  # KATAKANA LETTER PE
    0x030DC: [0x30DB, 0x3099],  # KATAKANA LETTER BO
    0x030DD: [0x30DB, 0x309A],  # KATAKANA LETTER PO
    0x030F4: [0x30A6, 0x3099],  # KATAKANA LETTER VU
    0x030F7: [0x30EF, 0x3099],  # KATAKANA LETTER VA
    0x030F8: [0x30F0, 0x3099],  # KATAKANA LETTER VI
    0x030F9: [0x30F1, 0x3099],  # KATAKANA LETTER VE
    0x030FA: [0x30F2, 0x3099],  # KATAKANA LETTER VO
    0x030FE: [0x30FD, 0x3099],  # KATAKANA VOICED ITERATION MARK
    0x030FF: ["<vertical>", 0x30B3, 0x30C8],  # KATAKANA DIGRAPH KOTO
    0x03131: ["<compat>", 0x1100],  # HANGUL LETTER KIYEOK
    0x03132: ["<compat>", 0x1101],  # HANGUL LETTER SSANGKIYEOK
    0x03133: ["<compat>", 0x11AA],  # HANGUL LETTER KIYEOK-SIOS
    0x03134: ["<compat>", 0x1102],  # HANGUL LETTER NIEUN
    0x03135: ["<compat>", 0x11AC],  # HANGUL LETTER NIEUN-CIEUC
    0x03136: ["<compat>", 0x11AD],  # HANGUL LETTER NIEUN-HIEUH
    0x03137: ["<compat>", 0x1103],  # HANGUL LETTER TIKEUT
    0x03138: ["<compat>", 0x1104],  # HANGUL LETTER SSANGTIKEUT
    0x03139: ["<compat>", 0x1105],  # HANGUL LETTER RIEUL
    0x0313A: ["<compat>", 0x11B0],  # HANGUL LETTER RIEUL-KIYEOK
    0x0313B: ["<compat>", 0x11B1],  # HANGUL LETTER RIEUL-MIEUM
    0x0313C: ["<compat>", 0x11B2],  # HANGUL LETTER RIEUL-PIEUP
    0x0313D: ["<compat>", 0x11B3],  # HANGUL LETTER RIEUL-SIOS
    0x0313E: ["<compat>", 0x11B4],  # HANGUL LETTER RIEUL-THIEUTH
    0x0313F: ["<compat>", 0x11B5],  # HANGUL LETTER RIEUL-PHIEUPH
    0x03140: ["<compat>", 0x111A],  # HANGUL LETTER RIEUL-HIEUH
    0x03141: ["<compat>", 0x1106],  # HANGUL LETTER MIEUM
    0x03142: ["<compat>", 0x1107],  # HANGUL LETTER PIEUP
    0x03143: ["<compat>", 0x1108],  # HANGUL LETTER SSANGPIEUP
    0x03144: ["<compat>", 0x1121],  # HANGUL LETTER PIEUP-SIOS
    0x03145: ["<compat>", 0x1109],  # HANGUL LETTER SIOS
    0x03146: ["<compat>", 0x110A],  # HANGUL LETTER SSANGSIOS
    0x03147: ["<compat>", 0x110B],  # HANGUL LETTER IEUNG
    0x03148: ["<compat>", 0x110C],  # HANGUL LETTER CIEUC
    0x03149: ["<compat>", 0x110D],  # HANGUL LETTER SSANGCIEUC
    0x0314A: ["<compat>", 0x110E],  # HANGUL LETTER CHIEUCH
    0x0314B: ["<compat>", 0x110F],  # HANGUL LETTER KHIEUKH
    0x0314C: ["<compat>", 0x1110],  # HANGUL LETTER THIEUTH
    0x0314D: ["<compat>", 0x1111],  # HANGUL LETTER PHIEUPH
    0x0314E: ["<compat>", 0x1112],  # HANGUL LETTER HIEUH
    0x0314F: ["<compat>", 0x1161],  # HANGUL LETTER A
    0x03150: ["<compat>", 0x1162],  # HANGUL LETTER AE
    0x03151: ["<compat>", 0x1163],  # HANGUL LETTER YA
    0x03152: ["<compat>", 0x1164],  # HANGUL LETTER YAE
    0x03153: ["<compat>", 0x1165],  # HANGUL LETTER EO
    0x03154: ["<compat>", 0x1166],  # HANGUL LETTER E
    0x03155: ["<compat>", 0x1167],  # HANGUL LETTER YEO
    0x03156: ["<compat>", 0x1168],  # HANGUL LETTER YE
    0x03157: ["<compat>", 0x1169],  # HANGUL LETTER O
    0x03158: ["<compat>", 0x116A],  # HANGUL LETTER WA
    0x03159: ["<compat>", 0x116B],  # HANGUL LETTER WAE
    0x0315A: ["<compat>", 0x116C],  # HANGUL LETTER OE
    0x0315B: ["<compat>", 0x116D],  # HANGUL LETTER YO
    0x0315C: ["<compat>", 0x116E],  # HANGUL LETTER U
    0x0315D: ["<compat>", 0x116F],  # HANGUL LETTER WEO
    0x0315E: ["<compat>", 0x1170],  # HANGUL LETTER WE
    0x0315F: ["<compat>", 0x1171],  # HANGUL LETTER WI
    0x03160: ["<compat>", 0x1172],  # HANGUL LETTER YU
    0x03161: ["<compat>", 0x1173],  # HANGUL LETTER EU
    0x03162: ["<compat>", 0x1174],  # HANGUL LETTER YI
    0x03163: ["<compat>", 0x1175],  # HANGUL LETTER I
    0x03164: ["<compat>", 0x1160],  # HANGUL FILLER
    0x03165: ["<compat>", 0x1114],  # HANGUL LETTER SSANGNIEUN
    0x03166: ["<compat>", 0x1115],  # HANGUL LETTER NIEUN-TIKEUT
    0x03167: ["<compat>", 0x11C7],  # HANGUL LETTER NIEUN-SIOS
    0x03168: ["<compat>", 0x11C8],  # HANGUL LETTER NIEUN-PANSIOS
    0x03169: ["<compat>", 0x11CC],  # HANGUL LETTER RIEUL-KIYEOK-SIOS
    0x0316A: ["<compat>", 0x11CE],  # HANGUL LETTER RIEUL-TIKEUT
    0x0316B: ["<compat>", 0x11D3],  # HANGUL LETTER RIEUL-PIEUP-SIOS
    0x0316C: ["<compat>", 0x11D7],  # HANGUL LETTER RIEUL-PANSIOS
    0x0316D: ["<compat>", 0x11D9],  # HANGUL LETTER RIEUL-YEORINHIEUH
    0x0316E: ["<compat>", 0x111C],  # HANGUL LETTER MIEUM-PIEUP
    0x0316F: ["<compat>", 0x11DD],  # HANGUL LETTER MIEUM-SIOS
    0x03170: ["<compat>", 0x11DF],  # HANGUL LETTER MIEUM-PANSIOS
    0x03171: ["<compat>", 0x111D],  # HANGUL LETTER KAPYEOUNMIEUM
    0x03172: ["<compat>", 0x111E],  # HANGUL LETTER PIEUP-KIYEOK
    0x03173: ["<compat>", 0x1120],  # HANGUL LETTER PIEUP-TIKEUT
    0x03174: ["<compat>", 0x1122],  # HANGUL LETTER PIEUP-SIOS-KIYEOK
    0x03175: ["<compat>", 0x1123],  # HANGUL LETTER PIEUP-SIOS-TIKEUT
    0x03176: ["<compat>", 0x1127],  # HANGUL LETTER PIEUP-CIEUC
    0x03177: ["<compat>", 0x1129],  # HANGUL LETTER PIEUP-THIEUTH
    0x03178: ["<compat>", 0x112B],  # HANGUL LETTER KAPYEOUNPIEUP
    0x03179: ["<compat>", 0x112C],  # HANGUL LETTER KAPYEOUNSSANGPIEUP
    0x0317A: ["<compat>", 0x112D],  # HANGUL LETTER SIOS-KIYEOK
    0x0317B: ["<compat>", 0x112E],  # HANGUL LETTER SIOS-NIEUN
    0x0317C: ["<compat>", 0x112F],  # HANGUL LETTER SIOS-TIKEUT
    0x0317D: ["<compat>", 0x1132],  # HANGUL LETTER SIOS-PIEUP
    0x0317E: ["<compat>", 0x1136],  # HANGUL LETTER SIOS-CIEUC
    0x0317F: ["<compat>", 0x1140],  # HANGUL LETTER PANSIOS
    0x03180: ["<compat>", 0x1147],  # HANGUL LETTER SSANGIEUNG
    0x03181: ["<compat>", 0x114C],  # HANGUL LETTER YESIEUNG
    0x03182: ["<compat>", 0x11F1],  # HANGUL LETTER YESIEUNG-SIOS
    0x03183: ["<compat>", 0x11F2],  # HANGUL LETTER YESIEUNG-PANSIOS
    0x03184: ["<compat>", 0x1157],  # HANGUL LETTER KAPYEOUNPHIEUPH
    0x03185: ["<compat>", 0x1158],  # HANGUL LETTER SSANGHIEUH
    0x03186: ["<compat>", 0x1159],  # HANGUL LETTER YEORINHIEUH
    0x03187: ["<compat>", 0x1184],  # HANGUL LETTER YO-YA
    0x03188: ["<compat>", 0x1185],  # HANGUL LETTER YO-YAE
    0x03189: ["<compat>", 0x1188],  # HANGUL LETTER YO-I
    0x0318A: ["<compat>", 0x1191],  # HANGUL LETTER YU-YEO
    0x0318B: ["<compat>", 0x1192],  # HANGUL LETTER YU-YE
    0x0318C: ["<compat>", 0x1194],  # HANGUL LETTER YU-I
    0x0318D: ["<compat>", 0x119E],  # HANGUL LETTER ARAEA
    0x0318E: ["<compat>", 0x11A1],  # HANGUL LETTER ARAEAE
    0x03192: ["<super>", 0x4E00],  # IDEOGRAPHIC ANNOTATION ONE MARK
    0x03193: ["<super>", 0x4E8C],  # IDEOGRAPHIC ANNOTATION TWO MARK
    0x03194: ["<super>", 0x4E09],  # IDEOGRAPHIC ANNOTATION THREE MARK
    0x03195: ["<super>", 0x56DB],  # IDEOGRAPHIC ANNOTATION FOUR MARK
    0x03196: ["<super>", 0x4E0A],  # IDEOGRAPHIC ANNOTATION TOP MARK
    0x03197: ["<super>", 0x4E2D],  # IDEOGRAPHIC ANNOTATION MIDDLE MARK
    0x03198: ["<super>", 0x4E0B],  # IDEOGRAPHIC ANNOTATION BOTTOM MARK
    0x03199: ["<super>", 0x7532],  # IDEOGRAPHIC ANNOTATION FIRST MARK
    0x0319A: ["<super>", 0x4E59],  # IDEOGRAPHIC ANNOTATION SECOND MARK
    0x0319B: ["<super>", 0x4E19],  # IDEOGRAPHIC ANNOTATION THIRD MARK
    0x0319C: ["<super>", 0x4E01],  # IDEOGRAPHIC ANNOTATION FOURTH MARK
    0x0319D: ["<super>", 0x5929],  # IDEOGRAPHIC ANNOTATION HEAVEN MARK
    0x0319E: ["<super>", 0x5730],  # IDEOGRAPHIC ANNOTATION EARTH MARK
    0x0319F: ["<super>", 0x4EBA],  # IDEOGRAPHIC ANNOTATION MAN MARK
    0x03200: ["<compat>", 0x0028, 0x1100, 0x0029],  # PARENTHESIZED HANGUL KIYEOK
    0x03201: ["<compat>", 0x0028, 0x1102, 0x0029],  # PARENTHESIZED HANGUL NIEUN
    0x03202: ["<compat>", 0x0028, 0x1103, 0x0029],  # PARENTHESIZED HANGUL TIKEUT
    0x03203: ["<compat>", 0x0028, 0x1105, 0x0029],  # PARENTHESIZED HANGUL RIEUL
    0x03204: ["<compat>", 0x0028, 0x1106, 0x0029],  # PARENTHESIZED HANGUL MIEUM
    0x03205: ["<compat>", 0x0028, 0x1107, 0x0029],  # PARENTHESIZED HANGUL PIEUP
    0x03206: ["<compat>", 0x0028, 0x1109, 0x0029],  # PARENTHESIZED HANGUL SIOS
    0x03207: ["<compat>", 0x0028, 0x110B, 0x0029],  # PARENTHESIZED HANGUL IEUNG
    0x03208: ["<compat>", 0x0028, 0x110C, 0x0029],  # PARENTHESIZED HANGUL CIEUC
    0x03209: ["<compat>", 0x0028, 0x110E, 0x0029],  # PARENTHESIZED HANGUL CHIEUCH
    0x0320A: ["<compat>", 0x0028, 0x110F, 0x0029],  # PARENTHESIZED HANGUL KHIEUKH
    0x0320B: ["<compat>", 0x0028, 0x1110, 0x0029],  # PARENTHESIZED HANGUL THIEUTH
    0x0320C: ["<compat>", 0x0028, 0x1111, 0x0029],  # PARENTHESIZED HANGUL PHIEUPH
    0x0320D: ["<compat>", 0x0028, 0x1112, 0x0029],  # PARENTHESIZED HANGUL HIEUH
    0x0320E: ["<compat>", 0x0028, 0x1100, 0x1161, 0x0029],  # PARENTHESIZED HANGUL KIYEOK A
    0x0320F: ["<compat>", 0x0028, 0x1102, 0x1161, 0x0029],  # PARENTHESIZED HANGUL NIEUN A
    0x03210: ["<compat>", 0x0028, 0x1103, 0x1161, 0x0029],  # PARENTHESIZED HANGUL TIKEUT A
    0x03211: ["<compat>", 0x0028, 0x1105, 0x1161, 0x0029],  # PARENTHESIZED HANGUL RIEUL A
    0x03212: ["<compat>", 0x0028, 0x1106, 0x1161, 0x0029],  # PARENTHESIZED HANGUL MIEUM A
    0x03213: ["<compat>", 0x0028, 0x1107, 0x1161, 0x0029],  # PARENTHESIZED HANGUL PIEUP A
    0x03214: ["<compat>", 0x0028, 0x1109, 0x1161, 0x0029],  # PARENTHESIZED HANGUL SIOS A
    0x03215: ["<compat>", 0x0028, 0x110B, 0x1161, 0x0029],  # PARENTHESIZED HANGUL IEUNG A
    0x03216: ["<compat>", 0x0028, 0x110C, 0x1161, 0x0029],  # PARENTHESIZED HANGUL CIEUC A
    0x03217: ["<compat>", 0x0028, 0x110E, 0x1161, 0x0029],  # PARENTHESIZED HANGUL CHIEUCH A
    0x03218: ["<compat>", 0x0028, 0x110F, 0x1161, 0x0029],  # PARENTHESIZED HANGUL KHIEUKH A
    0x03219: ["<compat>", 0x0028, 0x1110, 0x1161, 0x0029],  # PARENTHESIZED HANGUL THIEUTH A
    0x0321A: ["<compat>", 0x0028, 0x1111, 0x1161, 0x0029],  # PARENTHESIZED HANGUL PHIEUPH A
    0x0321B: ["<compat>", 0x0028, 0x1112, 0x1161, 0x0029],  # PARENTHESIZED HANGUL HIEUH A
    0x0321C: ["<compat>", 0x0028, 0x110C, 0x116E, 0x0029],  # PARENTHESIZED HANGUL CIEUC U
    0x0321D: ["<compat>", 0x0028, 0x110B, 0x1169, 0x110C, 0x1165, 0x11AB, 0x0029],  # PARENTHESIZED KOREAN CHARACTER OJEON
    0x0321E: ["<compat>", 0x0028, 0x110B, 0x1169, 0x1112, 0x116E, 0x0029],  # PARENTHESIZED KOREAN CHARACTER O HU
    0x03220: ["<compat>", 0x0028, 0x4E00, 0x0029],  # PARENTHESIZED IDEOGRAPH ONE
    0x03221: ["<compat>", 0x0028, 0x4E8C, 0x0029],  # PARENTHESIZED IDEOGRAPH TWO
    0x03222: ["<compat>", 0x0028, 0x4E09, 0x0029],  # PARENTHESIZED IDEOGRAPH THREE
    0x03223: ["<compat>", 0x0028, 0x56DB, 0x0029],  # PARENTHESIZED IDEOGRAPH FOUR
    0x03224: ["<compat>", 0x0028, 0x4E94, 0x0029],  # PARENTHESIZED IDEOGRAPH FIVE
    0x03225: ["<compat>", 0x0028, 0x516D, 0x0029],  # PARENTHESIZED IDEOGRAPH SIX
    0x03226: ["<compat>", 0x0028, 0x4E03, 0x0029],  # PARENTHESIZED IDEOGRAPH SEVEN
    0x03227: ["<compat>", 0x0028, 0x516B, 0x0029],  # PARENTHESIZED IDEOGRAPH EIGHT
    0x03228: ["<compat>", 0x0028, 0x4E5D, 0x0029],  # PARENTHESIZED IDEOGRAPH NINE
    0x03229: ["<compat>", 0x0028, 0x5341, 0x0029],  # PARENTHESIZED IDEOGRAPH TEN
    0x0322A: ["<compat>", 0x0028, 0x6708, 0x0029],  # PARENTHESIZED IDEOGRAPH MOON
    0x0322B: ["<compat>", 0x0028, 0x706B, 0x0029],  # PARENTHESIZED IDEOGRAPH FIRE
    0x0322C: ["<compat>", 0x0028, 0x6C34, 0x0029],  # PARENTHESIZED IDEOGRAPH WATER
    0x0322D: ["<compat>", 0x0028, 0x6728, 0x0029],  # PARENTHESIZED IDEOGRAPH WOOD
    0x0322E: ["<compat>", 0x0028, 0x91D1, 0x0029],  # PARENTHESIZED IDEOGRAPH METAL
    0x0322F: ["<compat>", 0x0028, 0x571F, 0x0029],  # PARENTHESIZED IDEOGRAPH EARTH
    0x03230: ["<compat>", 0x0028, 0x65E5, 0x0029],  # PARENTHESIZED IDEOGRAPH SUN
    0x03231: ["<compat>", 0x0028, 0x682A, 0x0029],  # PARENTHESIZED IDEOGRAPH STOCK
    0x03232: ["<compat>", 0x0028, 0x6709, 0x0029],  # PARENTHESIZED IDEOGRAPH HAVE
    0x03233: ["<compat>", 0x0028, 0x793E, 0x0029],  # PARENTHESIZED IDEOGRAPH SOCIETY
    0x03234: ["<compat>", 0x0028, 0x540D, 0x0029],  # PARENTHESIZED IDEOGRAPH NAME
    0x03235: ["<compat>", 0x0028, 0x7279, 0x0029],  # PARENTHESIZED IDEOGRAPH SPECIAL
    0x03236: ["<compat>", 0x0028, 0x8CA1, 0x0029],  # PARENTHESIZED IDEOGRAPH FINANCIAL
    0x03237: ["<compat>", 0x0028, 0x795D, 0x0029],  # PARENTHESIZED IDEOGRAPH CONGRATULATION
    0x03238: ["<compat>", 0x0028, 0x52B4, 0x0029],  # PARENTHESIZED IDEOGRAPH LABOR
    0x03239: ["<compat>", 0x0028, 0x4EE3, 0x0029],  # PARENTHESIZED IDEOGRAPH REPRESENT
    0x0323A: ["<compat>", 0x0028, 0x547C, 0x0029],  # PARENTHESIZED IDEOGRAPH CALL
    0x0323B: ["<compat>", 0x0028, 0x5B66, 0x0029],  # PARENTHESIZED IDEOGRAPH STUDY
    0x0323C: ["<compat>", 0x0028, 0x76E3, 0x0029],  # PARENTHESIZED IDEOGRAPH SUPERVISE
    0x0323D: ["<compat>", 0x0028, 0x4F01, 0x0029],  # PARENTHESIZED IDEOGRAPH ENTERPRISE
    0x0323E: ["<compat>", 0x0028, 0x8CC7, 0x0029],  # PARENTHESIZED IDEOGRAPH RESOURCE
    0x0323F: ["<compat>", 0x0028, 0x5354, 0x0029],  # PARENTHESIZED IDEOGRAPH ALLIANCE
    0x03240: ["<compat>", 0x0028, 0x796D, 0x0029],  # PARENTHESIZED IDEOGRAPH FESTIVAL
    0x03241: ["<compat>", 0x0028, 0x4F11, 0x0029],  # PARENTHESIZED IDEOGRAPH REST
    0x03242: ["<compat>", 0x0028, 0x81EA, 0x0029],  # PARENTHESIZED IDEOGRAPH SELF
    0x03243: ["<compat>", 0x0028, 0x81F3, 0x0029],  # PARENTHESIZED IDEOGRAPH REACH
    0x03244: ["<circle>", 0x554F],  # CIRCLED IDEOGRAPH QUESTION
    0x03245: ["<circle>", 0x5E7C],  # CIRCLED IDEOGRAPH KINDERGARTEN
    0x03246: ["<circle>", 0x6587],  # CIRCLED IDEOGRAPH SCHOOL
    0x03247: ["<circle>", 0x7B8F],  # CIRCLED IDEOGRAPH KOTO
    0x03250: ["<square>", 0x0050, 0x0054, 0x0045],  # PARTNERSHIP SIGN
    0x03251: ["<circle>", 0x0032, 0x0031],  # CIRCLED NUMBER TWENTY ONE
    0x03252: ["<circle>", 0x0032, 0x0032],  # CIRCLED NUMBER TWENTY TWO
    0x03253: ["<circle>", 0x0032, 0x0033],  # CIRCLED NUMBER TWENTY THREE
    0x03254: ["<circle>", 0x0032, 0x0034],  # CIRCLED NUMBER TWENTY FOUR
    0x03255: ["<circle>", 0x0032, 0x0035],  # CIRCLED NUMBER TWENTY FIVE
    0x03256: ["<circle>", 0x0032, 0x0036],  # CIRCLED NUMBER TWENTY SIX
    0x03257: ["<circle>", 0x0032, 0x0037],  # CIRCLED NUMBER TWENTY SEVEN
    0x03258: ["<circle>", 0x0032, 0x0038],  # CIRCLED NUMBER TWENTY EIGHT
    0x03259: ["<circle>", 0x0032, 0x0039],  # CIRCLED NUMBER TWENTY NINE
    0x0325A: ["<circle>", 0x0033, 0x0030],  # CIRCLED NUMBER THIRTY
    0x0325B: ["<circle>", 0x0033, 0x0031],  # CIRCLED NUMBER THIRTY ONE
    0x0325C: ["<circle>", 0x0033, 0x0032],  # CIRCLED NUMBER THIRTY TWO
    0x0325D: ["<circle>", 0x0033, 0x0033],  # CIRCLED NUMBER THIRTY THREE
    0x0325E: ["<circle>", 0x0033, 0x0034],  # CIRCLED NUMBER THIRTY FOUR
    0x0325F: ["<circle>", 0x0033, 0x0035],  # CIRCLED NUMBER THIRTY FIVE
    0x03260: ["<circle>", 0x1100],  # CIRCLED HANGUL KIYEOK
    0x03261: ["<circle>", 0x1102],  # CIRCLED HANGUL NIEUN
    0x03262: ["<circle>", 0x1103],  # CIRCLED HANGUL TIKEUT
    0x03263: ["<circle>", 0x1105],  # CIRCLED HANGUL RIEUL
    0x03264: ["<circle>", 0x1106],  # CIRCLED HANGUL MIEUM
    0x03265: ["<circle>", 0x1107],  # CIRCLED HANGUL PIEUP
    0x03266: ["<circle>", 0x1109],  # CIRCLED HANGUL SIOS
    0x03267: ["<circle>", 0x110B],  # CIRCLED HANGUL IEUNG
    0x03268: ["<circle>", 0x110C],  # CIRCLED HANGUL CIEUC
    0x03269: ["<circle>", 0x110E],  # CIRCLED HANGUL CHIEUCH
    0x0326A: ["<circle>", 0x110F],  # CIRCLED HANGUL KHIEUKH
    0x0326B: ["<circle>", 0x1110],  # CIRCLED HANGUL THIEUTH
    0x0326C: ["<circle>", 0x1111],  # CIRCLED HANGUL PHIEUPH
    0x0326D: ["<circle>", 0x1112],  # CIRCLED HANGUL HIEUH
    0x0326E: ["<circle>", 0x1100, 0x1161],  # CIRCLED HANGUL KIYEOK A
    0x0326F: ["<circle>", 0x1102, 0x1161],  # CIRCLED HANGUL NIEUN A
    0x03270: ["<circle>", 0x1103, 0x1161],  # CIRCLED HANGUL TIKEUT A
    0x03271: ["<circle>", 0x1105, 0x1161],  # CIRCLED HANGUL RIEUL A
    0x03272: ["<circle>", 0x1106, 0x1161],  # CIRCLED HANGUL MIEUM A
    0x03273: ["<circle>", 0x1107, 0x1161],  # CIRCLED HANGUL PIEUP A
    0x03274: ["<circle>", 0x1109, 0x1161],  # CIRCLED HANGUL SIOS A
    0x03275: ["<circle>", 0x110B, 0x1161],  # CIRCLED HANGUL IEUNG A
    0x03276: ["<circle>", 0x110C, 0x1161],  # CIRCLED HANGUL CIEUC A
    0x03277: ["<circle>", 0x110E, 0x1161],  # CIRCLED HANGUL CHIEUCH A
    0x03278: ["<circle>", 0x110F, 0x1161],  # CIRCLED HANGUL KHIEUKH A
    0x03279: ["<circle>", 0x1110, 0x1161],  # CIRCLED HANGUL THIEUTH A
    0x0327A: ["<circle>", 0x1111, 0x1161],  # CIRCLED HANGUL PHIEUPH A
    0x0327B: ["<circle>", 0x1112, 0x1161],  # CIRCLED HANGUL HIEUH A
    0x0327C: ["<circle>", 0x110E, 0x1161, 0x11B7, 0x1100, 0x1169],  # CIRCLED KOREAN CHARACTER CHAMKO
    0x0327D: ["<circle>", 0x110C, 0x116E, 0x110B, 0x1174],  # CIRCLED KOREAN CHARACTER JUEUI
    0x0327E: ["<circle>", 0x110B, 0x116E],  # CIRCLED HANGUL IEUNG U
    0x03280: ["<circle>", 0x4E00],  # CIRCLED IDEOGRAPH ONE
    0x03281: ["<circle>", 0x4E8C],  # CIRCLED IDEOGRAPH TWO
    0x03282: ["<circle>", 0x4E09],  # CIRCLED IDEOGRAPH THREE
    0x03283: ["<circle>", 0x56DB],  # CIRCLED IDEOGRAPH FOUR
    0x03284: ["<circle>", 0x4E94],  # CIRCLED IDEOGRAPH FIVE
    0x03285: ["<circle>", 0x516D],  # CIRCLED IDEOGRAPH SIX
    0x03286: ["<circle>", 0x4E03],  # CIRCLED IDEOGRAPH SEVEN
    0x03287: ["<circle>", 0x516B],  # CIRCLED IDEOGRAPH EIGHT
    0x03288: ["<circle>", 0x4E5D],  # CIRCLED IDEOGRAPH NINE
    0x03289: ["<circle>", 0x5341],  # CIRCLED IDEOGRAPH TEN
    0x0328A: ["<circle>", 0x6708],  # CIRCLED IDEOGRAPH MOON
    0x0328B: ["<circle>", 0x706B],  # CIRCLED IDEOGRAPH FIRE
    0x0328C: ["<circle>", 0x6C34],  # CIRCLED IDEOGRAPH WATER
    0x0328D: ["<circle>", 0x6728],  # CIRCLED IDEOGRAPH WOOD
    0x0328E: ["<circle>", 0x91D1],  # CIRCLED IDEOGRAPH METAL
    0x0328F: ["<circle>", 0x571F],  # CIRCLED IDEOGRAPH EARTH
    0x03290: ["<circle>", 0x65E5],  # CIRCLED IDEOGRAPH SUN
    0x03291: ["<circle>", 0x682A],  # CIRCLED IDEOGRAPH STOCK
    0x03292: ["<circle>", 0x6709],  # CIRCLED IDEOGRAPH HAVE
    0x03293: ["<circle>", 0x793E],  # CIRCLED IDEOGRAPH SOCIETY
    0x03294: ["<circle>", 0x540D],  # CIRCLED IDEOGRAPH NAME
    0x03295: ["<circle>", 0x7279],  # CIRCLED IDEOGRAPH SPECIAL
    0x03296: ["<circle>", 0x8CA1],  # CIRCLED IDEOGRAPH FINANCIAL
    0x03297: ["<circle>", 0x795D],  # CIRCLED IDEOGRAPH CONGRATULATION
    0x03298: ["<circle>", 0x52B4],  # CIRCLED IDEOGRAPH LABOR
    0x03299: ["<circle>", 0x79D8],  # CIRCLED IDEOGRAPH SECRET
    0x0329A: ["<circle>", 0x7537],  # CIRCLED IDEOGRAPH MALE
    0x0329B: ["<circle>", 0x5973],  # CIRCLED IDEOGRAPH FEMALE
    0x0329C: ["<circle>", 0x9069],  # CIRCLED IDEOGRAPH SUITABLE
    0x0329D: ["<circle>", 0x512A],  # CIRCLED IDEOGRAPH EXCELLENT
    0x0329E: ["<circle>", 0x5370],  # CIRCLED IDEOGRAPH PRINT
    0x0329F: ["<circle>", 0x6CE8],  # CIRCLED IDEOGRAPH ATTENTION
    0x032A0: ["<circle>", 0x9805],  # CIRCLED IDEOGRAPH ITEM
    0x032A1: ["<circle>", 0x4F11],  # CIRCLED IDEOGRAPH REST
    0x032A2: ["<circle>", 0x5199],  # CIRCLED IDEOGRAPH COPY
    0x032A3: ["<circle>", 0x6B63],  # CIRCLED IDEOGRAPH CORRECT
    0x032A4: ["<circle>", 0x4E0A],  # CIRCLED IDEOGRAPH HIGH
    0x032A5: ["<circle>", 0x4E2D],  # CIRCLED IDEOGRAPH CENTRE
    0x032A6: ["<circle>", 0x4E0B],  # CIRCLED IDEOGRAPH LOW
    0x032A7: ["<circle>", 0x5DE6],  # CIRCLED IDEOGRAPH LEFT
    0x032A8: ["<circle>", 0x53F3],  # CIRCLED IDEOGRAPH RIGHT
    0x032A9: ["<circle>", 0x533B],  # CIRCLED IDEOGRAPH MEDICINE
    0x032AA: ["<circle>", 0x5B97],  # CIRCLED IDEOGRAPH RELIGION
    0x032AB: ["<circle>", 0x5B66],  # CIRCLED IDEOGRAPH STUDY
    0x032AC: ["<circle>", 0x76E3],  # CIRCLED IDEOGRAPH SUPERVISE
    0x032AD: ["<circle>", 0x4F01],  # CIRCLED IDEOGRAPH ENTERPRISE
    0x032AE: ["<circle>", 0x8CC7],  # CIRCLED IDEOGRAPH RESOURCE
    0x032AF: ["<circle>", 0x5354],  # CIRCLED IDEOGRAPH ALLIANCE
    0x032B0: ["<circle>", 0x591C],  # CIRCLED IDEOGRAPH NIGHT
    0x032B1: ["<circle>", 0x0033, 0x0036],  # CIRCLED NUMBER THIRTY SIX
    0x032B2: ["<circle>", 0x0033, 0x0037],  # CIRCLED NUMBER THIRTY SEVEN
    0x032B3: ["<circle>", 0x0033, 0x0038],  # CIRCLED NUMBER THIRTY EIGHT
    0x032B4: ["<circle>", 0x0033, 0x0039],  # CIRCLED NUMBER THIRTY NINE
    0x032B5: ["<circle>", 0x0034, 0x0030],  # CIRCLED NUMBER FORTY
    0x032B6: ["<circle>", 0x0034, 0x0031],  # CIRCLED NUMBER FORTY ONE
    0x032B7: ["<circle>", 0x0034, 0x0032],  # CIRCLED NUMBER FORTY TWO
    0x032B8: ["<circle>", 0x0034, 0x0033],  # CIRCLED NUMBER FORTY THREE
    0x032B9: ["<circle>", 0x0034, 0x0034],  # CIRCLED NUMBER FORTY FOUR
    0x032BA: ["<circle>", 0x0034, 0x0035],  # CIRCLED NUMBER FORTY FIVE
    0x032BB: ["<circle>", 0x0034, 0x0036],  # CIRCLED NUMBER FORTY SIX
    0x032BC: ["<circle>", 0x0034, 0x0037],  # CIRCLED NUMBER FORTY SEVEN
    0x032BD: ["<circle>", 0x0034, 0x0038],  # CIRCLED NUMBER FORTY EIGHT
    0x032BE: ["<circle>", 0x0034, 0x0039],  # CIRCLED NUMBER FORTY NINE
    0x032BF: ["<circle>", 0x0035, 0x0030],  # CIRCLED NUMBER FIFTY
    0x032C0: ["<compat>", 0x0031, 0x6708],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR JANUARY
    0x032C1: ["<compat>", 0x0032, 0x6708],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR FEBRUARY
    0x032C2: ["<compat>", 0x0033, 0x6708],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR MARCH
    0x032C3: ["<compat>", 0x0034, 0x6708],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR APRIL
    0x032C4: ["<compat>", 0x0035, 0x6708],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR MAY
    0x032C5: ["<compat>", 0x0036, 0x6708],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR JUNE
    0x032C6: ["<compat>", 0x0037, 0x6708],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR JULY
    0x032C7: ["<compat>", 0x0038, 0x6708],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR AUGUST
    0x032C8: ["<compat>", 0x0039, 0x6708],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR SEPTEMBER
    0x032C9: ["<compat>", 0x0031, 0x0030, 0x6708],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR OCTOBER
    0x032CA: ["<compat>", 0x0031, 0x0031, 0x6708],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR NOVEMBER
    0x032CB: ["<compat>", 0x0031, 0x0032, 0x6708],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DECEMBER
    0x032CC: ["<square>", 0x0048, 0x0067],  # SQUARE HG
    0x032CD: ["<square>", 0x0065, 0x0072, 0x0067],  # SQUARE ERG
    0x032CE: ["<square>", 0x0065, 0x0056],  # SQUARE EV
    0x032CF: ["<square>", 0x004C, 0x0054, 0x0044],  # LIMITED LIABILITY SIGN
    0x032D0: ["<circle>", 0x30A2],  # CIRCLED KATAKANA A
    0x032D1: ["<circle>", 0x30A4],  # CIRCLED KATAKANA I
    0x032D2: ["<circle>", 0x30A6],  # CIRCLED KATAKANA U
    0x032D3: ["<circle>", 0x30A8],  # CIRCLED KATAKANA E
    0x032D4: ["<circle>", 0x30AA],  # CIRCLED KATAKANA O
    0x032D5: ["<circle>", 0x30AB],  # CIRCLED KATAKANA KA
    0x032D6: ["<circle>", 0x30AD],  # CIRCLED KATAKANA KI
    0x032D7: ["<circle>", 0x30AF],  # CIRCLED KATAKANA KU
    0x032D8: ["<circle>", 0x30B1],  # CIRCLED KATAKANA KE
    0x032D9: ["<circle>", 0x30B3],  # CIRCLED KATAKANA KO
    0x032DA: ["<circle>", 0x30B5],  # CIRCLED KATAKANA SA
    0x032DB: ["<circle>", 0x30B7],  # CIRCLED KATAKANA SI
    0x032DC: ["<circle>", 0x30B9],  # CIRCLED KATAKANA SU
    0x032DD: ["<circle>", 0x30BB],  # CIRCLED KATAKANA SE
    0x032DE: ["<circle>", 0x30BD],  # CIRCLED KATAKANA SO
    0x032DF: ["<circle>", 0x30BF],  # CIRCLED KATAKANA TA
    0x032E0: ["<circle>", 0x30C1],  # CIRCLED KATAKANA TI
    0x032E1: ["<circle>", 0x30C4],  # CIRCLED KATAKANA TU
    0x032E2: ["<circle>", 0x30C6],  # CIRCLED KATAKANA TE
    0x032E3: ["<circle>", 0x30C8],  # CIRCLED KATAKANA TO
    0x032E4: ["<circle>", 0x30CA],  # CIRCLED KATAKANA NA
    0x032E5: ["<circle>", 0x30CB],  # CIRCLED KATAKANA NI
    0x032E6: ["<circle>", 0x30CC],  # CIRCLED KATAKANA NU
    0x032E7: ["<circle>", 0x30CD],  # CIRCLED KATAKANA NE
    0x032E8: ["<circle>", 0x30CE],  # CIRCLED KATAKANA NO
    0x032E9: ["<circle>", 0x30CF],  # CIRCLED KATAKANA HA
    0x032EA: ["<circle>", 0x30D2],  # CIRCLED KATAKANA HI
    0x032EB: ["<circle>", 0x30D5],  # CIRCLED KATAKANA HU
    0x032EC: ["<circle>", 0x30D8],  # CIRCLED KATAKANA HE
    0x032ED: ["<circle>", 0x30DB],  # CIRCLED KATAKANA HO
    0x032EE: ["<circle>", 0x30DE],  # CIRCLED KATAKANA MA
    0x032EF: ["<circle>", 0x30DF],  # CIRCLED KATAKANA MI
    0x032F0: ["<circle>", 0x30E0],  # CIRCLED KATAKANA MU
    0x032F1: ["<circle>", 0x30E1],  # CIRCLED KATAKANA ME
    0x032F2: ["<circle>", 0x30E2],  # CIRCLED KATAKANA MO
    0x032F3: ["<circle>", 0x30E4],  # CIRCLED KATAKANA YA
    0x032F4: ["<circle>", 0x30E6],  # CIRCLED KATAKANA YU
    0x032F5: ["<circle>", 0x30E8],  # CIRCLED KATAKANA YO
    0x032F6: ["<circle>", 0x30E9],  # CIRCLED KATAKANA RA
    0x032F7: ["<circle>", 0x30EA],  # CIRCLED KATAKANA RI
    0x032F8: ["<circle>", 0x30EB],  # CIRCLED KATAKANA RU
    0x032F9: ["<circle>", 0x30EC],  # CIRCLED KATAKANA RE
    0x032FA: ["<circle>", 0x30ED],  # CIRCLED KATAKANA RO
    0x032FB: ["<circle>", 0x30EF],  # CIRCLED KATAKANA WA
    0x032FC: ["<circle>", 0x30F0],  # CIRCLED KATAKANA WI
    0x032FD: ["<circle>", 0x30F1],  # CIRCLED KATAKANA WE
    0x032FE: ["<circle>", 0x30F2],  # CIRCLED KATAKANA WO
    0x032FF: ["<square>", 0x4EE4, 0x548C],  # SQUARE ERA NAME REIWA
    0x03300: ["<square>", 0x30A2, 0x30D1, 0x30FC, 0x30C8],  # SQUARE APAATO
    0x03301: ["<square>", 0x30A2, 0x30EB, 0x30D5, 0x30A1],  # SQUARE ARUHUA
    0x03302: ["<square>", 0x30A2, 0x30F3, 0x30DA, 0x30A2],  # SQUARE ANPEA
    0x03303: ["<square>", 0x30A2, 0x30FC, 0x30EB],  # SQUARE AARU
    0x03304: ["<square>", 0x30A4, 0x30CB, 0x30F3, 0x30B0],  # SQUARE ININGU
    0x03305: ["<square>", 0x30A4, 0x30F3, 0x30C1],  # SQUARE INTI
    0x03306: ["<square>", 0x30A6, 0x30A9, 0x30F3],  # SQUARE UON
    0x03307: ["<square>", 0x30A8, 0x30B9, 0x30AF, 0x30FC, 0x30C9],  # SQUARE ESUKUUDO
    0x03308: ["<square>", 0x30A8, 0x30FC, 0x30AB, 0x30FC],  # SQUARE EEKAA
    0x03309: ["<square>", 0x30AA, 0x30F3, 0x30B9],  # SQUARE ONSU
    0x0330A: ["<square>", 0x30AA, 0x30FC, 0x30E0],  # SQUARE OOMU
    0x0330B: ["<square>", 0x30AB, 0x30A4, 0x30EA],  # SQUARE KAIRI
    0x0330C: ["<square>", 0x30AB, 0x30E9, 0x30C3, 0x30C8],  # SQUARE KARATTO
    0x0330D: ["<square>", 0x30AB, 0x30ED, 0x30EA, 0x30FC],  # SQUARE KARORII
    0x0330E: ["<square>", 0x30AC, 0x30ED, 0x30F3],  # SQUARE GARON
    0x0330F: ["<square>", 0x30AC, 0x30F3, 0x30DE],  # SQUARE GANMA
    0x03310: ["<square>", 0x30AE, 0x30AC],  # SQUARE GIGA
    0x03311: ["<square>", 0x30AE, 0x30CB, 0x30FC],  # SQUARE GINII
    0x03312: ["<square>", 0x30AD, 0x30E5, 0x30EA, 0x30FC],  # SQUARE KYURII
    0x03313: ["<square>", 0x30AE, 0x30EB, 0x30C0, 0x30FC],  # SQUARE GIRUDAA
    0x03314: ["<square>", 0x30AD, 0x30ED],  # SQUARE KIRO
    0x03315: ["<square>", 0x30AD, 0x30ED, 0x30B0, 0x30E9, 0x30E0],  # SQUARE KIROGURAMU
    0x03316: ["<square>", 0x30AD, 0x30ED, 0x30E1, 0x30FC, 0x30C8, 0x30EB],  # SQUARE KIROMEETORU
    0x03317: ["<square>", 0x30AD, 0x30ED, 0x30EF, 0x30C3, 0x30C8],  # SQUARE KIROWATTO
    0x03318: ["<square>", 0x30B0, 0x30E9, 0x30E0],  # SQUARE GURAMU
    0x03319: ["<square>", 0x30B0, 0x30E9, 0x30E0, 0x30C8, 0x30F3],  # SQUARE GURAMUTON
    0x0331A: ["<square>", 0x30AF, 0x30EB, 0x30BC, 0x30A4, 0x30ED],  # SQUARE KURUZEIRO
    0x0331B: ["<square>", 0x30AF, 0x30ED, 0x30FC, 0x30CD],  # SQUARE KUROONE
    0x0331C: ["<square>", 0x30B1, 0x30FC, 0x30B9],  # SQUARE KEESU
    0x0331D: ["<square>", 0x30B3, 0x30EB, 0x30CA],  # SQUARE KORUNA
    0x0331E: ["<square>", 0x30B3, 0x30FC, 0x30DD],  # SQUARE KOOPO
    0x0331F: ["<square>", 0x30B5, 0x30A4, 0x30AF, 0x30EB],  # SQUARE SAIKURU
    0x03320: ["<square>", 0x30B5, 0x30F3, 0x30C1, 0x30FC, 0x30E0],  # SQUARE SANTIIMU
    0x03321: ["<square>", 0x30B7, 0x30EA, 0x30F3, 0x30B0],  # SQUARE SIRINGU
    0x03322: ["<square>", 0x30BB, 0x30F3, 0x30C1],  # SQUARE SENTI
    0x03323: ["<square>", 0x30BB, 0x30F3, 0x30C8],  # SQUARE SENTO
    0x03324: ["<square>", 0x30C0, 0x30FC, 0x30B9],  # SQUARE DAASU
    0x03325: ["<square>", 0x30C7, 0x30B7],  # SQUARE DESI
    0x03326: ["<square>", 0x30C9, 0x30EB],  # SQUARE DORU
    0x03327: ["<square>", 0x30C8, 0x30F3],  # SQUARE TON
    0x03328: ["<square>", 0x30CA, 0x30CE],  # SQUARE NANO
    0x03329: ["<square>", 0x30CE, 0x30C3, 0x30C8],  # SQUARE NOTTO
    0x0332A: ["<square>", 0x30CF, 0x30A4, 0x30C4],  # SQUARE HAITU
    0x0332B: ["<square>", 0x30D1, 0x30FC, 0x30BB, 0x30F3, 0x30C8],  # SQUARE PAASENTO
    0x0332C: ["<square>", 0x30D1, 0x30FC, 0x30C4],  # SQUARE PAATU
    0x0332D: ["<square>", 0x30D0, 0x30FC, 0x30EC, 0x30EB],  # SQUARE BAARERU
    0x0332E: ["<square>", 0x30D4, 0x30A2, 0x30B9, 0x30C8, 0x30EB],  # SQUARE PIASUTORU
    0x0332F: ["<square>", 0x30D4, 0x30AF, 0x30EB],  # SQUARE PIKURU
    0x03330: ["<square>", 0x30D4, 0x30B3],  # SQUARE PIKO
    0x03331: ["<square>", 0x30D3, 0x30EB],  # SQUARE BIRU
    0x03332: ["<square>", 0x30D5, 0x30A1, 0x30E9, 0x30C3, 0x30C9],  # SQUARE HUARADDO
    0x03333: ["<square>", 0x30D5, 0x30A3, 0x30FC, 0x30C8],  # SQUARE HUIITO
    0x03334: ["<square>", 0x30D6, 0x30C3, 0x30B7, 0x30A7, 0x30EB],  # SQUARE BUSSYERU
    0x03335: ["<square>", 0x30D5, 0x30E9, 0x30F3],  # SQUARE HURAN
    0x03336: ["<square>", 0x30D8, 0x30AF, 0x30BF, 0x30FC, 0x30EB],  # SQUARE HEKUTAARU
    0x03337: ["<square>", 0x30DA, 0x30BD],  # SQUARE PESO
    0x03338: ["<square>", 0x30DA, 0x30CB, 0x30D2],  # SQUARE PENIHI
    0x03339: ["<square>", 0x30D8, 0x30EB, 0x30C4],  # SQUARE HERUTU
    0x0333A: ["<square>", 0x30DA, 0x30F3, 0x30B9],  # SQUARE PENSU
    0x0333B: ["<square>", 0x30DA, 0x30FC, 0x30B8],  # SQUARE PEEZI
    0x0333C: ["<square>", 0x30D9, 0x30FC, 0x30BF],  # SQUARE BEETA
    0x0333D: ["<square>", 0x30DD, 0x30A4, 0x30F3, 0x30C8],  # SQUARE POINTO
    0x0333E: ["<square>", 0x30DC, 0x30EB, 0x30C8],  # SQUARE BORUTO
    0x0333F: ["<square>", 0x30DB, 0x30F3],  # SQUARE HON
    0x03340: ["<square>", 0x30DD, 0x30F3, 0x30C9],  # SQUARE PONDO
    0x03341: ["<square>", 0x30DB, 0x30FC, 0x30EB],  # SQUARE HOORU
    0x03342: ["<square>", 0x30DB, 0x30FC, 0x30F3],  # SQUARE HOON
    0x03343: ["<square>", 0x30DE, 0x30A4, 0x30AF, 0x30ED],  # SQUARE MAIKURO
    0x03344: ["<square>", 0x30DE, 0x30A4, 0x30EB],  # SQUARE MAIRU
    0x03345: ["<square>", 0x30DE, 0x30C3, 0x30CF],  # SQUARE MAHHA
    0x03346: ["<square>", 0x30DE, 0x30EB, 0x30AF],  # SQUARE MARUKU
    0x03347: ["<square>", 0x30DE, 0x30F3, 0x30B7, 0x30E7, 0x30F3],  # SQUARE MANSYON
    0x03348: ["<square>", 0x30DF, 0x30AF, 0x30ED, 0x30F3],  # SQUARE MIKURON
    0x03349: ["<square>", 0x30DF, 0x30EA],  # SQUARE MIRI
    0x0334A: ["<square>", 0x30DF, 0x30EA, 0x30D0, 0x30FC, 0x30EB],  # SQUARE MIRIBAARU
    0x0334B: ["<square>", 0x30E1, 0x30AC],  # SQUARE MEGA
    0x0334C: ["<square>", 0x30E1, 0x30AC, 0x30C8, 0x30F3],  # SQUARE MEGATON
    0x0334D: ["<square>", 0x30E1, 0x30FC, 0x30C8, 0x30EB],  # SQUARE MEETORU
    0x0334E: ["<square>", 0x30E4, 0x30FC, 0x30C9],  # SQUARE YAADO
    0x0334F: ["<square>", 0x30E4, 0x30FC, 0x30EB],  # SQUARE YAARU
    0x03350: ["<square>", 0x30E6, 0x30A2, 0x30F3],  # SQUARE YUAN
    0x03351: ["<square>", 0x30EA, 0x30C3, 0x30C8, 0x30EB],  # SQUARE RITTORU
    0x03352: ["<square>", 0x30EA, 0x30E9],  # SQUARE RIRA
    0x03353: ["<square>", 0x30EB, 0x30D4, 0x30FC],  # SQUARE RUPII
    0x03354: ["<square>", 0x30EB, 0x30FC, 0x30D6, 0x30EB],  # SQUARE RUUBURU
    0x03355: ["<square>", 0x30EC, 0x30E0],  # SQUARE REMU
    0x03356: ["<square>", 0x30EC, 0x30F3, 0x30C8, 0x30B2, 0x30F3],  # SQUARE RENTOGEN
    0x03357: ["<square>", 0x30EF, 0x30C3, 0x30C8],  # SQUARE WATTO
    0x03358: ["<compat>", 0x0030, 0x70B9],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ZERO
    0x03359: ["<compat>", 0x0031, 0x70B9],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ONE
    0x0335A: ["<compat>", 0x0032, 0x70B9],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWO
    0x0335B: ["<compat>", 0x0033, 0x70B9],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR THREE
    0x0335C: ["<compat>", 0x0034, 0x70B9],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOUR
    0x0335D: ["<compat>", 0x0035, 0x70B9],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIVE
    0x0335E: ["<compat>", 0x0036, 0x70B9],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIX
    0x0335F: ["<compat>", 0x0037, 0x70B9],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVEN
    0x03360: ["<compat>", 0x0038, 0x70B9],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGHT
    0x03361: ["<compat>", 0x0039, 0x70B9],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINE
    0x03362: ["<compat>", 0x0031, 0x0030, 0x70B9],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TEN
    0x03363: ["<compat>", 0x0031, 0x0031, 0x70B9],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ELEVEN
    0x03364: ["<compat>", 0x0031, 0x0032, 0x70B9],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWELVE
    0x03365: ["<compat>", 0x0031, 0x0033, 0x70B9],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR THIRTEEN
    0x03366: ["<compat>", 0x0031, 0x0034, 0x70B9],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOURTEEN
    0x03367: ["<compat>", 0x0031, 0x0035, 0x70B9],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIFTEEN
    0x03368: ["<compat>", 0x0031, 0x0036, 0x70B9],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIXTEEN
    0x03369: ["<compat>", 0x0031, 0x0037, 0x70B9],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVENTEEN
    0x0336A: ["<compat>", 0x0031, 0x0038, 0x70B9],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGHTEEN
    0x0336B: ["<compat>", 0x0031, 0x0039, 0x70B9],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINETEEN
    0x0336C: ["<compat>", 0x0032, 0x0030, 0x70B9],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY
    0x0336D: ["<compat>", 0x0032, 0x0031, 0x70B9],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-ONE
    0x0336E: ["<compat>", 0x0032, 0x0032, 0x70B9],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-TWO
    0x0336F: ["<compat>", 0x0032, 0x0033, 0x70B9],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-THREE
    0x03370: ["<compat>", 0x0032, 0x0034, 0x70B9],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-FOUR
    0x03371: ["<square>", 0x0068, 0x0050, 0x0061],  # SQUARE HPA
    0x03372: ["<square>", 0x0064, 0x0061],  # SQUARE DA
    0x03373: ["<square>", 0x0041, 0x0055],  # SQUARE AU
    0x03374: ["<square>", 0x0062, 0x0061, 0x0072],  # SQUARE BAR
    0x03375: ["<square>", 0x006F, 0x0056],  # SQUARE OV
    0x03376: ["<square>", 0x0070, 0x0063],  # SQUARE PC
    0x03377: ["<square>", 0x0064, 0x006D],  # SQUARE DM
    0x03378: ["<square>", 0x0064, 0x006D, 0x00B2],  # SQUARE DM SQUARED
    0x03379: ["<square>", 0x0064, 0x006D, 0x00B3],  # SQUARE DM CUBED
    0x0337A: ["<square>", 0x0049, 0x0055],  # SQUARE IU
    0x0337B: ["<square>", 0x5E73, 0x6210],  # SQUARE ERA NAME HEISEI
    0x0337C: ["<square>", 0x662D, 0x548C],  # SQUARE ERA NAME SYOUWA
    0x0337D: ["<square>", 0x5927, 0x6B63],  # SQUARE ERA NAME TAISYOU
    0x0337E: ["<square>", 0x660E, 0x6CBB],  # SQUARE ERA NAME MEIZI
    0x0337F: ["<square>", 0x682A, 0x5F0F, 0x4F1A, 0x793E],  # SQUARE CORPORATION
    0x03380: ["<square>", 0x0070, 0x0041],  # SQUARE PA AMPS
    0x03381: ["<square>", 0x006E, 0x0041],  # SQUARE NA
    0x03382: ["<square>", 0x03BC, 0x0041],  # SQUARE MU A
    0x03383: ["<square>", 0x006D, 0x0041],  # SQUARE MA
    0x03384: ["<square>", 0x006B, 0x0041],  # SQUARE KA
    0x03385: ["<square>", 0x004B, 0x0042],  # SQUARE KB
    0x03386: ["<square>", 0x004D, 0x0042],  # SQUARE MB
    0x03387: ["<square>", 0x0047, 0x0042],  # SQUARE GB
    0x03388: ["<square>", 0x0063, 0x0061, 0x006C],  # SQUARE CAL
    0x03389: ["<square>", 0x006B, 0x0063, 0x0061, 0x006C],  # SQUARE KCAL
    0x0338A: ["<square>", 0x0070, 0x0046],  # SQUARE PF
    0x0338B: ["<square>", 0x006E, 0x0046],  # SQUARE NF
    0x0338C: ["<square>", 0x03BC, 0x0046],  # SQUARE MU F
    0x0338D: ["<square>", 0x03BC, 0x0067],  # SQUARE MU G
    0x0338E: ["<square>", 0x006D, 0x0067],  # SQUARE MG
    0x0338F: ["<square>", 0x006B, 0x0067],  # SQUARE KG
    0x03390: ["<square>", 0x0048, 0x007A],  # SQUARE HZ
    0x03391: ["<square>", 0x006B, 0x0048, 0x007A],  # SQUARE KHZ
    0x03392: ["<square>", 0x004D, 0x0048, 0x007A],  # SQUARE MHZ
    0x03393: ["<square>", 0x0047, 0x0048, 0x007A],  # SQUARE GHZ
    0x03394: ["<square>", 0x0054, 0x0048, 0x007A],  # SQUARE THZ
    0x03395: ["<square>", 0x03BC, 0x2113],  # SQUARE MU L
    0x03396: ["<square>", 0x006D, 0x2113],  # SQUARE ML
    0x03397: ["<square>", 0x0064, 0x2113],  # SQUARE DL
    0x03398: ["<square>", 0x006B, 0x2113],  # SQUARE KL
    0x03399: ["<square>", 0x0066, 0x006D],  # SQUARE FM
    0x0339A: ["<square>", 0x006E, 0x006D],  # SQUARE NM
    0x0339B: ["<square>", 0x03BC, 0x006D],  # SQUARE MU M
    0x0339C: ["<square>", 0x006D, 0x006D],  # SQUARE MM
    0x0339D: ["<square>", 0x0063, 0x006D],  # SQUARE CM
    0x0339E: ["<square>", 0x006B, 0x006D],  # SQUARE KM
    0x0339F: ["<square>", 0x006D, 0x006D, 0x00B2],  # SQUARE MM SQUARED
    0x033A0: ["<square>", 0x0063, 0x006D, 0x00B2],  # SQUARE CM SQUARED
    0x033A1: ["<square>", 0x006D, 0x00B2],  # SQUARE M SQUARED
    0x033A2: ["<square>", 0x006B, 0x006D, 0x00B2],  # SQUARE KM SQUARED
    0x033A3: ["<square>", 0x006D, 0x006D, 0x00B3],  # SQUARE MM CUBED
    0x033A4: ["<square>", 0x0063, 0x006D, 0x00B3],  # SQUARE CM CUBED
    0x033A5: ["<square>", 0x006D, 0x00B3],  # SQUARE M CUBED
    0x033A6: ["<square>", 0x006B, 0x006D, 0x00B3],  # SQUARE KM CUBED
    0x033A7: ["<square>", 0x006D, 0x2215, 0x0073],  # SQUARE M OVER S
    0x033A8: ["<square>", 0x006D, 0x2215, 0x0073, 0x00B2],  # SQUARE M OVER S SQUARED
    0x033A9: ["<square>", 0x0050, 0x0061],  # SQUARE PA
    0x033AA: ["<square>", 0x006B, 0x0050, 0x0061],  # SQUARE KPA
    0x033AB: ["<square>", 0x004D, 0x0050, 0x0061],  # SQUARE MPA
    0x033AC: ["<square>", 0x0047, 0x0050, 0x0061],  # SQUARE GPA
    0x033AD: ["<square>", 0x0072, 0x0061, 0x0064],  # SQUARE RAD
    0x033AE: ["<square>", 0x0072, 0x0061, 0x0064, 0x2215, 0x0073],  # SQUARE RAD OVER S
    0x033AF: ["<square>", 0x0072, 0x0061, 0x0064, 0x2215, 0x0073, 0x00B2],  # SQUARE RAD OVER S SQUARED
    0x033B0: ["<square>", 0x0070, 0x0073],  # SQUARE PS
    0x033B1: ["<square>", 0x006E, 0x0073],  # SQUARE NS
    0x033B2: ["<square>", 0x03BC, 0x0073],  # SQUARE MU S
    0x033B3: ["<square>", 0x006D, 0x0073],  # SQUARE MS
    0x033B4: ["<square>", 0x0070, 0x0056],  # SQUARE PV
    0x033B5: ["<square>", 0x006E, 0x0056],  # SQUARE NV
    0x033B6: ["<square>", 0x03BC, 0x0056],  # SQUARE MU V
    0x033B7: ["<square>", 0x006D, 0x0056],  # SQUARE MV
    0x033B8: ["<square>", 0x006B, 0x0056],  # SQUARE KV
    0x033B9: ["<square>", 0x004D, 0x0056],  # SQUARE MV MEGA
    0x033BA: ["<square>", 0x0070, 0x0057],  # SQUARE PW
    0x033BB: ["<square>", 0x006E, 0x0057],  # SQUARE NW
    0x033BC: ["<square>", 0x03BC, 0x0057],  # SQUARE MU W
    0x033BD: ["<square>", 0x006D, 0x0057],  # SQUARE MW
    0x033BE: ["<square>", 0x006B, 0x0057],  # SQUARE KW
    0x033BF: ["<square>", 0x004D, 0x0057],  # SQUARE MW MEGA
    0x033C0: ["<square>", 0x006B, 0x03A9],  # SQUARE K OHM
    0x033C1: ["<square>", 0x004D, 0x03A9],  # SQUARE M OHM
    0x033C2: ["<square>", 0x0061, 0x002E, 0x006D, 0x002E],  # SQUARE AM
    0x033C3: ["<square>", 0x0042, 0x0071],  # SQUARE BQ
    0x033C4: ["<square>", 0x0063, 0x0063],  # SQUARE CC
    0x033C5: ["<square>", 0x0063, 0x0064],  # SQUARE CD
    0x033C6: ["<square>", 0x0043, 0x2215, 0x006B, 0x0067],  # SQUARE C OVER KG
    0x033C7: ["<square>", 0x0043, 0x006F, 0x002E],  # SQUARE CO
    0x033C8: ["<square>", 0x0064, 0x0042],  # SQUARE DB
    0x033C9: ["<square>", 0x0047, 0x0079],  # SQUARE GY
    0x033CA: ["<square>", 0x0068, 0x0061],  # SQUARE HA
    0x033CB: ["<square>", 0x0048, 0x0050],  # SQUARE HP
    0x033CC: ["<square>", 0x0069, 0x006E],  # SQUARE IN
    0x033CD: ["<square>", 0x004B, 0x004B],  # SQUARE KK
    0x033CE: ["<square>", 0x004B, 0x004D],  # SQUARE KM CAPITAL
    0x033CF: ["<square>", 0x006B, 0x0074],  # SQUARE KT
    0x033D0: ["<square>", 0x006C, 0x006D],  # SQUARE LM
    0x033D1: ["<square>", 0x006C, 0x006E],  # SQUARE LN
    0x033D2: ["<square>", 0x006C, 0x006F, 0x0067],  # SQUARE LOG
    0x033D3: ["<square>", 0x006C, 0x0078],  # SQUARE LX
    0x033D4: ["<square>", 0x006D, 0x0062],  # SQUARE MB SMALL
    0x033D5: ["<square>", 0x006D, 0x0069, 0x006C],  # SQUARE MIL
    0x033D6: ["<square>", 0x006D, 0x006F, 0x006C],  # SQUARE MOL
    0x033D7: ["<square>", 0x0050, 0x0048],  # SQUARE PH
    0x033D8: ["<square>", 0x0070, 0x002E, 0x006D, 0x002E],  # SQUARE PM
    0x033D9: ["<square>", 0x0050, 0x0050, 0x004D],  # SQUARE PPM
    0x033DA: ["<square>", 0x0050, 0x0052],  # SQUARE PR
    0x033DB: ["<square>", 0x0073, 0x0072],  # SQUARE SR
    0x033DC: ["<square>", 0x0053, 0x0076],  # SQUARE SV
    0x033DD: ["<square>", 0x0057, 0x0062],  # SQUARE WB
    0x033DE: ["<square>", 0x0056, 0x2215, 0x006D],  # SQUARE V OVER M
    0x033DF: ["<square>", 0x0041, 0x2215, 0x006D],  # SQUARE A OVER M
    0x033E0: ["<compat>", 0x0031, 0x65E5],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ONE
    0x033E1: ["<compat>", 0x0032, 0x65E5],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWO
    0x033E2: ["<compat>", 0x0033, 0x65E5],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THREE
    0x033E3: ["<compat>", 0x0034, 0x65E5],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOUR
    0x033E4: ["<compat>", 0x0035, 0x65E5],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIVE
    0x033E5: ["<compat>", 0x0036, 0x65E5],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SIX
    0x033E6: ["<compat>", 0x0037, 0x65E5],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVEN
    0x033E7: ["<compat>", 0x0038, 0x65E5],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHT
    0x033E8: ["<compat>", 0x0039, 0x65E5],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINE
    0x033E9: ["<compat>", 0x0031, 0x0030, 0x65E5],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TEN
    0x033EA: ["<compat>", 0x0031, 0x0031, 0x65E5],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ELEVEN
    0x033EB: ["<compat>", 0x0031, 0x0032, 0x65E5],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWELVE
    0x033EC: ["<compat>", 0x0031, 0x0033, 0x65E5],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTEEN
    0x033ED: ["<compat>", 0x0031, 0x0034, 0x65E5],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOURTEEN
    0x033EE: ["<compat>", 0x0031, 0x0035, 0x65E5],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIFTEEN
    0x033EF: ["<compat>", 0x0031, 0x0036, 0x65E5],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SIXTEEN
    0x033F0: ["<compat>", 0x0031, 0x0037, 0x65E5],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVENTEEN
    0x033F1: ["<compat>", 0x0031, 0x0038, 0x65E5],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHTEEN
    0x033F2: ["<compat>", 0x0031, 0x0039, 0x65E5],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINETEEN
    0x033F3: ["<compat>", 0x0032, 0x0030, 0x65E5],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY
    0x033F4: ["<compat>", 0x0032, 0x0031, 0x65E5],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-ONE
    0x033F5: ["<compat>", 0x0032, 0x0032, 0x65E5],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-TWO
    0x033F6: ["<compat>", 0x0032, 0x0033, 0x65E5],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-THREE
    0x033F7: ["<compat>", 0x0032, 0x0034, 0x65E5],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FOUR
    0x033F8: ["<compat>", 0x0032, 0x0035, 0x65E5],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FIVE
    0x033F9: ["<compat>", 0x0032, 0x0036, 0x65E5],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-SIX
    0x033FA: ["<compat>", 0x0032, 0x0037, 0x65E5],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-SEVEN
    0x033FB: ["<compat>", 0x0032, 0x0038, 0x65E5],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-EIGHT
    0x033FC: ["<compat>", 0x0032, 0x0039, 0x65E5],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-NINE
    0x033FD: ["<compat>", 0x0033, 0x0030, 0x65E5],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTY
    0x033FE: ["<compat>", 0x0033, 0x0031, 0x65E5],  # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTY-ONE
    0x033FF: ["<square>", 0x0067, 0x0061, 0x006C],  # SQUARE GAL
    0x0A69C: ["<super>", 0x044A],  # MODIFIER LETTER CYRILLIC HARD SIGN
    0x0A69D: ["<super>", 0x044C],  # MODIFIER LETTER CYRILLIC SOFT SIGN
    0x0A770: ["<super>", 0xA76F],  # MODIFIER LETTER US
    0x0A7F2: ["<super>", 0x0043],  # MODIFIER LETTER CAPITAL C
    0x0A7F3: ["<super>", 0x0046],  # MODIFIER LETTER CAPITAL F
    0x0A7F4: ["<super>", 0x0051],  # MODIFIER LETTER CAPITAL Q
    0x0A7F8: ["<super>", 0x0126],  # MODIFIER LETTER CAPITAL H WITH STROKE
    0x0A7F9: ["<super>", 0x0153],  # MODIFIER LETTER SMALL LIGATURE OE
    0x0AB5C: ["<super>", 0xA727],  # MODIFIER LETTER SMALL HENG
    0x0AB5D: ["<super>", 0xAB37],  # MODIFIER LETTER SMALL L WITH INVERTED LAZY S
    0x0AB5E: ["<super>", 0x026B],  # MODIFIER LETTER SMALL L WITH MIDDLE TILDE
    0x0AB5F: ["<super>", 0xAB52],  # MODIFIER LETTER SMALL U WITH LEFT HOOK
    0x0AB69: ["<super>", 0x028D],  # MODIFIER LETTER SMALL TURNED W
    0x0F900: [0x8C48],  # CJK COMPATIBILITY IDEOGRAPH-F900
    0x0F901: [0x66F4],  # CJK COMPATIBILITY IDEOGRAPH-F901
    0x0F902: [0x8ECA],  # CJK COMPATIBILITY IDEOGRAPH-F902
    0x0F903: [0x8CC8],  # CJK COMPATIBILITY IDEOGRAPH-F903
    0x0F904: [0x6ED1],  # CJK COMPATIBILITY IDEOGRAPH-F904
    0x0F905: [0x4E32],  # CJK COMPATIBILITY IDEOGRAPH-F905
    0x0F906: [0x53E5],  # CJK COMPATIBILITY IDEOGRAPH-F906
    0x0F907: [0x9F9C],  # CJK COMPATIBILITY IDEOGRAPH-F907
    0x0F908: [0x9F9C],  # CJK COMPATIBILITY IDEOGRAPH-F908
    0x0F909: [0x5951],  # CJK COMPATIBILITY IDEOGRAPH-F909
    0x0F90A: [0x91D1],  # CJK COMPATIBILITY IDEOGRAPH-F90A
    0x0F90B: [0x5587],  # CJK COMPATIBILITY IDEOGRAPH-F90B
    0x0F90C: [0x5948],  # CJK COMPATIBILITY IDEOGRAPH-F90C
    0x0F90D: [0x61F6],  # CJK COMPATIBILITY IDEOGRAPH-F90D
    0x0F90E: [0x7669],  # CJK COMPATIBILITY IDEOGRAPH-F90E
    0x0F90F: [0x7F85],  # CJK COMPATIBILITY IDEOGRAPH-F90F
    0x0F910: [0x863F],  # CJK COMPATIBILITY IDEOGRAPH-F910
    0x0F911: [0x87BA],  # CJK COMPATIBILITY IDEOGRAPH-F911
    0x0F912: [0x88F8],  # CJK COMPATIBILITY IDEOGRAPH-F912
    0x0F913: [0x908F],  # CJK COMPATIBILITY IDEOGRAPH-F913
    0x0F914: [0x6A02],  # CJK COMPATIBILITY IDEOGRAPH-F914
    0x0F915: [0x6D1B],  # CJK COMPATIBILITY IDEOGRAPH-F915
    0x0F916: [0x70D9],  # CJK COMPATIBILITY IDEOGRAPH-F916
    0x0F917: [0x73DE],  # CJK COMPATIBILITY IDEOGRAPH-F917
    0x0F918: [0x843D],  # CJK COMPATIBILITY IDEOGRAPH-F918
    0x0F919: [0x916A],  # CJK COMPATIBILITY IDEOGRAPH-F919
    0x0F91A: [0x99F1],  # CJK COMPATIBILITY IDEOGRAPH-F91A
    0x0F91B: [0x4E82],  # CJK COMPATIBILITY IDEOGRAPH-F91B
    0x0F91C: [0x5375],  # CJK COMPATIBILITY IDEOGRAPH-F91C
    0x0F91D: [0x6B04],  # CJK COMPATIBILITY IDEOGRAPH-F91D
    0x0F91E: [0x721B],  # CJK COMPATIBILITY IDEOGRAPH-F91E
    0x0F91F: [0x862D],  # CJK COMPATIBILITY IDEOGRAPH-F91F
    0x0F920: [0x9E1E],  # CJK COMPATIBILITY IDEOGRAPH-F920
    0x0F921: [0x5D50],  # CJK COMPATIBILITY IDEOGRAPH-F921
    0x0F922: [0x6FEB],  # CJK COMPATIBILITY IDEOGRAPH-F922
    0x0F923: [0x85CD],  # CJK COMPATIBILITY IDEOGRAPH-F923
    0x0F924: [0x8964],  # CJK COMPATIBILITY IDEOGRAPH-F924
    0x0F925: [0x62C9],  # CJK COMPATIBILITY IDEOGRAPH-F925
    0x0F926: [0x81D8],  # CJK COMPATIBILITY IDEOGRAPH-F926
    0x0F927: [0x881F],  # CJK COMPATIBILITY IDEOGRAPH-F927
    0x0F928: [0x5ECA],  # CJK COMPATIBILITY IDEOGRAPH-F928
    0x0F929: [0x6717],  # CJK COMPATIBILITY IDEOGRAPH-F929
    0x0F92A: [0x6D6A],  # CJK COMPATIBILITY IDEOGRAPH-F92A
    0x0F92B: [0x72FC],  # CJK COMPATIBILITY IDEOGRAPH-F92B
    0x0F92C: [0x90CE],  # CJK COMPATIBILITY IDEOGRAPH-F92C
    0x0F92D: [0x4F86],  # CJK COMPATIBILITY IDEOGRAPH-F92D
    0x0F92E: [0x51B7],  # CJK COMPATIBILITY IDEOGRAPH-F92E
    0x0F92F: [0x52DE],  # CJK COMPATIBILITY IDEOGRAPH-F92F
    0x0F930: [0x64C4],  # CJK COMPATIBILITY IDEOGRAPH-F930
    0x0F931: [0x6AD3],  # CJK COMPATIBILITY IDEOGRAPH-F931
    0x0F932: [0x7210],  # CJK COMPATIBILITY IDEOGRAPH-F932
    0x0F933: [0x76E7],  # CJK COMPATIBILITY IDEOGRAPH-F933
    0x0F934: [0x8001],  # CJK COMPATIBILITY IDEOGRAPH-F934
    0x0F935: [0x8606],  # CJK COMPATIBILITY IDEOGRAPH-F935
    0x0F936: [0x865C],  # CJK COMPATIBILITY IDEOGRAPH-F936
    0x0F937: [0x8DEF],  # CJK COMPATIBILITY IDEOGRAPH-F937
    0x0F938: [0x9732],  # CJK COMPATIBILITY IDEOGRAPH-F938
    0x0F939: [0x9B6F],  # CJK COMPATIBILITY IDEOGRAPH-F939
    0x0F93A: [0x9DFA],  # CJK COMPATIBILITY IDEOGRAPH-F93A
    0x0F93B: [0x788C],  # CJK COMPATIBILITY IDEOGRAPH-F93B
    0x0F93C: [0x797F],  # CJK COMPATIBILITY IDEOGRAPH-F93C
    0x0F93D: [0x7DA0],  # CJK COMPATIBILITY IDEOGRAPH-F93D
    0x0F93E: [0x83C9],  # CJK COMPATIBILITY IDEOGRAPH-F93E
    0x0F93F: [0x9304],  # CJK COMPATIBILITY IDEOGRAPH-F93F
    0x0F940: [0x9E7F],  # CJK COMPATIBILITY IDEOGRAPH-F940
    0x0F941: [0x8AD6],  # CJK COMPATIBILITY IDEOGRAPH-F941
    0x0F942: [0x58DF],  # CJK COMPATIBILITY IDEOGRAPH-F942
    0x0F943: [0x5F04],  # CJK COMPATIBILITY IDEOGRAPH-F943
    0x0F944: [0x7C60],  # CJK COMPATIBILITY IDEOGRAPH-F944
    0x0F945: [0x807E],  # CJK COMPATIBILITY IDEOGRAPH-F945
    0x0F946: [0x7262],  # CJK COMPATIBILITY IDEOGRAPH-F946
    0x0F947: [0x78CA],  # CJK COMPATIBILITY IDEOGRAPH-F947
    0x0F948: [0x8CC2],  # CJK COMPATIBILITY IDEOGRAPH-F948
    0x0F949: [0x96F7],  # CJK COMPATIBILITY IDEOGRAPH-F949
    0x0F94A: [0x58D8],  # CJK COMPATIBILITY IDEOGRAPH-F94A
    0x0F94B: [0x5C62],  # CJK COMPATIBILITY IDEOGRAPH-F94B
    0x0F94C: [0x6A13],  # CJK COMPATIBILITY IDEOGRAPH-F94C
    0x0F94D: [0x6DDA],  # CJK COMPATIBILITY IDEOGRAPH-F94D
    0x0F94E: [0x6F0F],  # CJK COMPATIBILITY IDEOGRAPH-F94E
    0x0F94F: [0x7D2F],  # CJK COMPATIBILITY IDEOGRAPH-F94F
    0x0F950: [0x7E37],  # CJK COMPATIBILITY IDEOGRAPH-F950
    0x0F951: [0x964B],  # CJK COMPATIBILITY IDEOGRAPH-F951
    0x0F952: [0x52D2],  # CJK COMPATIBILITY IDEOGRAPH-F952
    0x0F953: [0x808B],  # CJK COMPATIBILITY IDEOGRAPH-F953
    0x0F954: [0x51DC],  # CJK COMPATIBILITY IDEOGRAPH-F954
    0x0F955: [0x51CC],  # CJK COMPATIBILITY IDEOGRAPH-F955
    0x0F956: [0x7A1C],  # CJK COMPATIBILITY IDEOGRAPH-F956
    0x0F957: [0x7DBE],  # CJK COMPATIBILITY IDEOGRAPH-F957
    0x0F958: [0x83F1],  # CJK COMPATIBILITY IDEOGRAPH-F958
    0x0F959: [0x9675],  # CJK COMPATIBILITY IDEOGRAPH-F959
    0x0F95A: [0x8B80],  # CJK COMPATIBILITY IDEOGRAPH-F95A
    0x0F95B: [0x62CF],  # CJK COMPATIBILITY IDEOGRAPH-F95B
    0x0F95C: [0x6A02],  # CJK COMPATIBILITY IDEOGRAPH-F95C
    0x0F95D: [0x8AFE],  # CJK COMPATIBILITY IDEOGRAPH-F95D
    0x0F95E: [0x4E39],  # CJK COMPATIBILITY IDEOGRAPH-F95E
    0x0F95F: [0x5BE7],  # CJK COMPATIBILITY IDEOGRAPH-F95F
    0x0F960: [0x6012],  # CJK COMPATIBILITY IDEOGRAPH-F960
    0x0F961: [0x7387],  # CJK COMPATIBILITY IDEOGRAPH-F961
    0x0F962: [0x7570],  # CJK COMPATIBILITY IDEOGRAPH-F962
    0x0F963: [0x5317],  # CJK COMPATIBILITY IDEOGRAPH-F963
    0x0F964: [0x78FB],  # CJK COMPATIBILITY IDEOGRAPH-F964
    0x0F965: [0x4FBF],  # CJK COMPATIBILITY IDEOGRAPH-F965
    0x0F966: [0x5FA9],  # CJK COMPATIBILITY IDEOGRAPH-F966
    0x0F967: [0x4E0D],  # CJK COMPATIBILITY IDEOGRAPH-F967
    0x0F968: [0x6CCC],  # CJK COMPATIBILITY IDEOGRAPH-F968
    0x0F969: [0x6578],  # CJK COMPATIBILITY IDEOGRAPH-F969
    0x0F96A: [0x7D22],  # CJK COMPATIBILITY IDEOGRAPH-F96A
    0x0F96B: [0x53C3],  # CJK COMPATIBILITY IDEOGRAPH-F96B
    0x0F96C: [0x585E],  # CJK COMPATIBILITY IDEOGRAPH-F96C
    0x0F96D: [0x7701],  # CJK COMPATIBILITY IDEOGRAPH-F96D
    0x0F96E: [0x8449],  # CJK COMPATIBILITY IDEOGRAPH-F96E
    0x0F96F: [0x8AAA],  # CJK COMPATIBILITY IDEOGRAPH-F96F
    0x0F970: [0x6BBA],  # CJK COMPATIBILITY IDEOGRAPH-F970
    0x0F971: [0x8FB0],  # CJK COMPATIBILITY IDEOGRAPH-F971
    0x0F972: [0x6C88],  # CJK COMPATIBILITY IDEOGRAPH-F972
    0x0F973: [0x62FE],  # CJK COMPATIBILITY IDEOGRAPH-F973
    0x0F974: [0x82E5],  # CJK COMPATIBILITY IDEOGRAPH-F974
    0x0F975: [0x63A0],  # CJK COMPATIBILITY IDEOGRAPH-F975
    0x0F976: [0x7565],  # CJK COMPATIBILITY IDEOGRAPH-F976
    0x0F977: [0x4EAE],  # CJK COMPATIBILITY IDEOGRAPH-F977
    0x0F978: [0x5169],  # CJK COMPATIBILITY IDEOGRAPH-F978
    0x0F979: [0x51C9],  # CJK COMPATIBILITY IDEOGRAPH-F979
    0x0F97A: [0x6881],  # CJK COMPATIBILITY IDEOGRAPH-F97A
    0x0F97B: [0x7CE7],  # CJK COMPATIBILITY IDEOGRAPH-F97B
    0x0F97C: [0x826F],  # CJK COMPATIBILITY IDEOGRAPH-F97C
    0x0F97D: [0x8AD2],  # CJK COMPATIBILITY IDEOGRAPH-F97D
    0x0F97E: [0x91CF],  # CJK COMPATIBILITY IDEOGRAPH-F97E
    0x0F97F: [0x52F5],  # CJK COMPATIBILITY IDEOGRAPH-F97F
    0x0F980: [0x5442],  # CJK COMPATIBILITY IDEOGRAPH-F980
    0x0F981: [0x5973],  # CJK COMPATIBILITY IDEOGRAPH-F981
    0x0F982: [0x5EEC],  # CJK COMPATIBILITY IDEOGRAPH-F982
    0x0F983: [0x65C5],  # CJK COMPATIBILITY IDEOGRAPH-F983
    0x0F984: [0x6FFE],  # CJK COMPATIBILITY IDEOGRAPH-F984
    0x0F985: [0x792A],  # CJK COMPATIBILITY IDEOGRAPH-F985
    0x0F986: [0x95AD],  # CJK COMPATIBILITY IDEOGRAPH-F986
    0x0F987: [0x9A6A],  # CJK COMPATIBILITY IDEOGRAPH-F987
    0x0F988: [0x9E97],  # CJK COMPATIBILITY IDEOGRAPH-F988
    0x0F989: [0x9ECE],  # CJK COMPATIBILITY IDEOGRAPH-F989
    0x0F98A: [0x529B],  # CJK COMPATIBILITY IDEOGRAPH-F98A
    0x0F98B: [0x66C6],  # CJK COMPATIBILITY IDEOGRAPH-F98B
    0x0F98C: [0x6B77],  # CJK COMPATIBILITY IDEOGRAPH-F98C
    0x0F98D: [0x8F62],  # CJK COMPATIBILITY IDEOGRAPH-F98D
    0x0F98E: [0x5E74],  # CJK COMPATIBILITY IDEOGRAPH-F98E
    0x0F98F: [0x6190],  # CJK COMPATIBILITY IDEOGRAPH-F98F
    0x0F990: [0x6200],  # CJK COMPATIBILITY IDEOGRAPH-F990
    0x0F991: [0x649A],  # CJK COMPATIBILITY IDEOGRAPH-F991
    0x0F992: [0x6F23],  # CJK COMPATIBILITY IDEOGRAPH-F992
    0x0F993: [0x7149],  # CJK COMPATIBILITY IDEOGRAPH-F993
    0x0F994: [0x7489],  # CJK COMPATIBILITY IDEOGRAPH-F994
    0x0F995: [0x79CA],  # CJK COMPATIBILITY IDEOGRAPH-F995
    0x0F996: [0x7DF4],  # CJK COMPATIBILITY IDEOGRAPH-F996
    0x0F997: [0x806F],  # CJK COMPATIBILITY IDEOGRAPH-F997
    0x0F998: [0x8F26],  # CJK COMPATIBILITY IDEOGRAPH-F998
    0x0F999: [0x84EE],  # CJK COMPATIBILITY IDEOGRAPH-F999
    0x0F99A: [0x9023],  # CJK COMPATIBILITY IDEOGRAPH-F99A
    0x0F99B: [0x934A],  # CJK COMPATIBILITY IDEOGRAPH-F99B
    0x0F99C: [0x5217],  # CJK COMPATIBILITY IDEOGRAPH-F99C
    0x0F99D: [0x52A3],  # CJK COMPATIBILITY IDEOGRAPH-F99D
    0x0F99E: [0x54BD],  # CJK COMPATIBILITY IDEOGRAPH-F99E
    0x0F99F: [0x70C8],  # CJK COMPATIBILITY IDEOGRAPH-F99F
    0x0F9A0: [0x88C2],  # CJK COMPATIBILITY IDEOGRAPH-F9A0
    0x0F9A1: [0x8AAA],  # CJK COMPATIBILITY IDEOGRAPH-F9A1
    0x0F9A2: [0x5EC9],  # CJK COMPATIBILITY IDEOGRAPH-F9A2
    0x0F9A3: [0x5FF5],  # CJK COMPATIBILITY IDEOGRAPH-F9A3
    0x0F9A4: [0x637B],  # CJK COMPATIBILITY IDEOGRAPH-F9A4
    0x0F9A5: [0x6BAE],  # CJK COMPATIBILITY IDEOGRAPH-F9A5
    0x0F9A6: [0x7C3E],  # CJK COMPATIBILITY IDEOGRAPH-F9A6
    0x0F9A7: [0x7375],  # CJK COMPATIBILITY IDEOGRAPH-F9A7
    0x0F9A8: [0x4EE4],  # CJK COMPATIBILITY IDEOGRAPH-F9A8
    0x0F9A9: [0x56F9],  # CJK COMPATIBILITY IDEOGRAPH-F9A9
    0x0F9AA: [0x5BE7],  # CJK COMPATIBILITY IDEOGRAPH-F9AA
    0x0F9AB: [0x5DBA],  # CJK COMPATIBILITY IDEOGRAPH-F9AB
    0x0F9AC: [0x601C],  # CJK COMPATIBILITY IDEOGRAPH-F9AC
    0x0F9AD: [0x73B2],  # CJK COMPATIBILITY IDEOGRAPH-F9AD
    0x0F9AE: [0x7469],  # CJK COMPATIBILITY IDEOGRAPH-F9AE
    0x0F9AF: [0x7F9A],  # CJK COMPATIBILITY IDEOGRAPH-F9AF
    0x0F9B0: [0x8046],  # CJK COMPATIBILITY IDEOGRAPH-F9B0
    0x0F9B1: [0x9234],  # CJK COMPATIBILITY IDEOGRAPH-F9B1
    0x0F9B2: [0x96F6],  # CJK COMPATIBILITY IDEOGRAPH-F9B2
    0x0F9B3: [0x9748],  # CJK COMPATIBILITY IDEOGRAPH-F9B3
    0x0F9B4: [0x9818],  # CJK COMPATIBILITY IDEOGRAPH-F9B4
    0x0F9B5: [0x4F8B],  # CJK COMPATIBILITY IDEOGRAPH-F9B5
    0x0F9B6: [0x79AE],  # CJK COMPATIBILITY IDEOGRAPH-F9B6
    0x0F9B7: [0x91B4],  # CJK COMPATIBILITY IDEOGRAPH-F9B7
    0x0F9B8: [0x96B8],  # CJK COMPATIBILITY IDEOGRAPH-F9B8
    0x0F9B9: [0x60E1],  # CJK COMPATIBILITY IDEOGRAPH-F9B9
    0x0F9BA: [0x4E86],  # CJK COMPATIBILITY IDEOGRAPH-F9BA
    0x0F9BB: [0x50DA],  # CJK COMPATIBILITY IDEOGRAPH-F9BB
    0x0F9BC: [0x5BEE],  # CJK COMPATIBILITY IDEOGRAPH-F9BC
    0x0F9BD: [0x5C3F],  # CJK COMPATIBILITY IDEOGRAPH-F9BD
    0x0F9BE: [0x6599],  # CJK COMPATIBILITY IDEOGRAPH-F9BE
    0x0F9BF: [0x6A02],  # CJK COMPATIBILITY IDEOGRAPH-F9BF
    0x0F9C0: [0x71CE],  # CJK COMPATIBILITY IDEOGRAPH-F9C0
    0x0F9C1: [0x7642],  # CJK COMPATIBILITY IDEOGRAPH-F9C1
    0x0F9C2: [0x84FC],  # CJK COMPATIBILITY IDEOGRAPH-F9C2
    0x0F9C3: [0x907C],  # CJK COMPATIBILITY IDEOGRAPH-F9C3
    0x0F9C4: [0x9F8D],  # CJK COMPATIBILITY IDEOGRAPH-F9C4
    0x0F9C5: [0x6688],  # CJK COMPATIBILITY IDEOGRAPH-F9C5
    0x0F9C6: [0x962E],  # CJK COMPATIBILITY IDEOGRAPH-F9C6
    0x0F9C7: [0x5289],  # CJK COMPATIBILITY IDEOGRAPH-F9C7
    0x0F9C8: [0x677B],  # CJK COMPATIBILITY IDEOGRAPH-F9C8
    0x0F9C9: [0x67F3],  # CJK COMPATIBILITY IDEOGRAPH-F9C9
    0x0F9CA: [0x6D41],  # CJK COMPATIBILITY IDEOGRAPH-F9CA
    0x0F9CB: [0x6E9C],  # CJK COMPATIBILITY IDEOGRAPH-F9CB
    0x0F9CC: [0x7409],  # CJK COMPATIBILITY IDEOGRAPH-F9CC
    0x0F9CD: [0x7559],  # CJK COMPATIBILITY IDEOGRAPH-F9CD
    0x0F9CE: [0x786B],  # CJK COMPATIBILITY IDEOGRAPH-F9CE
    0x0F9CF: [0x7D10],  # CJK COMPATIBILITY IDEOGRAPH-F9CF
    0x0F9D0: [0x985E],  # CJK COMPATIBILITY IDEOGRAPH-F9D0
    0x0F9D1: [0x516D],  # CJK COMPATIBILITY IDEOGRAPH-F9D1
    0x0F9D2: [0x622E],  # CJK COMPATIBILITY IDEOGRAPH-F9D2
    0x0F9D3: [0x9678],  # CJK COMPATIBILITY IDEOGRAPH-F9D3
    0x0F9D4: [0x502B],  # CJK COMPATIBILITY IDEOGRAPH-F9D4
    0x0F9D5: [0x5D19],  # CJK COMPATIBILITY IDEOGRAPH-F9D5
    0x0F9D6: [0x6DEA],  # CJK COMPATIBILITY IDEOGRAPH-F9D6
    0x0F9D7: [0x8F2A],  # CJK COMPATIBILITY IDEOGRAPH-F9D7
    0x0F9D8: [0x5F8B],  # CJK COMPATIBILITY IDEOGRAPH-F9D8
    0x0F9D9: [0x6144],  # CJK COMPATIBILITY IDEOGRAPH-F9D9
    0x0F9DA: [0x6817],  # CJK COMPATIBILITY IDEOGRAPH-F9DA
    0x0F9DB: [0x7387],  # CJK COMPATIBILITY IDEOGRAPH-F9DB
    0x0F9DC: [0x9686],  # CJK COMPATIBILITY IDEOGRAPH-F9DC
    0x0F9DD: [0x5229],  # CJK COMPATIBILITY IDEOGRAPH-F9DD
    0x0F9DE: [0x540F],  # CJK COMPATIBILITY IDEOGRAPH-F9DE
    0x0F9DF: [0x5C65],  # CJK COMPATIBILITY IDEOGRAPH-F9DF
    0x0F9E0: [0x6613],  # CJK COMPATIBILITY IDEOGRAPH-F9E0
    0x0F9E1: [0x674E],  # CJK COMPATIBILITY IDEOGRAPH-F9E1
    0x0F9E2: [0x68A8],  # CJK COMPATIBILITY IDEOGRAPH-F9E2
    0x0F9E3: [0x6CE5],  # CJK COMPATIBILITY IDEOGRAPH-F9E3
    0x0F9E4: [0x7406],  # CJK COMPATIBILITY IDEOGRAPH-F9E4
    0x0F9E5: [0x75E2],  # CJK COMPATIBILITY IDEOGRAPH-F9E5
    0x0F9E6: [0x7F79],  # CJK COMPATIBILITY IDEOGRAPH-F9E6
    0x0F9E7: [0x88CF],  # CJK COMPATIBILITY IDEOGRAPH-F9E7
    0x0F9E8: [0x88E1],  # CJK COMPATIBILITY IDEOGRAPH-F9E8
    0x0F9E9: [0x91CC],  # CJK COMPATIBILITY IDEOGRAPH-F9E9
    0x0F9EA: [0x96E2],  # CJK COMPATIBILITY IDEOGRAPH-F9EA
    0x0F9EB: [0x533F],  # CJK COMPATIBILITY IDEOGRAPH-F9EB
    0x0F9EC: [0x6EBA],  # CJK COMPATIBILITY IDEOGRAPH-F9EC
    0x0F9ED: [0x541D],  # CJK COMPATIBILITY IDEOGRAPH-F9ED
    0x0F9EE: [0x71D0],  # CJK COMPATIBILITY IDEOGRAPH-F9EE
    0x0F9EF: [0x7498],  # CJK COMPATIBILITY IDEOGRAPH-F9EF
    0x0F9F0: [0x85FA],  # CJK COMPATIBILITY IDEOGRAPH-F9F0
    0x0F9F1: [0x96A3],  # CJK COMPATIBILITY IDEOGRAPH-F9F1
    0x0F9F2: [0x9C57],  # CJK COMPATIBILITY IDEOGRAPH-F9F2
    0x0F9F3: [0x9E9F],  # CJK COMPATIBILITY IDEOGRAPH-F9F3
    0x0F9F4: [0x6797],  # CJK COMPATIBILITY IDEOGRAPH-F9F4
    0x0F9F5: [0x6DCB],  # CJK COMPATIBILITY IDEOGRAPH-F9F5
    0x0F9F6: [0x81E8],  # CJK COMPATIBILITY IDEOGRAPH-F9F6
    0x0F9F7: [0x7ACB],  # CJK COMPATIBILITY IDEOGRAPH-F9F7
    0x0F9F8: [0x7B20],  # CJK COMPATIBILITY IDEOGRAPH-F9F8
    0x0F9F9: [0x7C92],  # CJK COMPATIBILITY IDEOGRAPH-F9F9
    0x0F9FA: [0x72C0],  # CJK COMPATIBILITY IDEOGRAPH-F9FA
    0x0F9FB: [0x7099],  # CJK COMPATIBILITY IDEOGRAPH-F9FB
    0x0F9FC: [0x8B58],  # CJK COMPATIBILITY IDEOGRAPH-F9FC
    0x0F9FD: [0x4EC0],  # CJK COMPATIBILITY IDEOGRAPH-F9FD
    0x0F9FE: [0x8336],  # CJK COMPATIBILITY IDEOGRAPH-F9FE
    0x0F9FF: [0x523A],  # CJK COMPATIBILITY IDEOGRAPH-F9FF
    0x0FA00: [0x5207],  # CJK COMPATIBILITY IDEOGRAPH-FA00
    0x0FA01: [0x5EA6],  # CJK COMPATIBILITY IDEOGRAPH-FA01
    0x0FA02: [0x62D3],  # CJK COMPATIBILITY IDEOGRAPH-FA02
    0x0FA03: [0x7CD6],  # CJK COMPATIBILITY IDEOGRAPH-FA03
    0x0FA04: [0x5B85],  # CJK COMPATIBILITY IDEOGRAPH-FA04
    0x0FA05: [0x6D1E],  # CJK COMPATIBILITY IDEOGRAPH-FA05
    0x0FA06: [0x66B4],  # CJK COMPATIBILITY IDEOGRAPH-FA06
    0x0FA07: [0x8F3B],  # CJK COMPATIBILITY IDEOGRAPH-FA07
    0x0FA08: [0x884C],  # CJK COMPATIBILITY IDEOGRAPH-FA08
    0x0FA09: [0x964D],  # CJK COMPATIBILITY IDEOGRAPH-FA09
    0x0FA0A: [0x898B],  # CJK COMPATIBILITY IDEOGRAPH-FA0A
    0x0FA0B: [0x5ED3],  # CJK COMPATIBILITY IDEOGRAPH-FA0B
    0x0FA0C: [0x5140],  # CJK COMPATIBILITY IDEOGRAPH-FA0C
    0x0FA0D: [0x55C0],  # CJK COMPATIBILITY IDEOGRAPH-FA0D
    0x0FA10: [0x585A],  # CJK COMPATIBILITY IDEOGRAPH-FA10
    0x0FA12: [0x6674],  # CJK COMPATIBILITY IDEOGRAPH-FA12
    0x0FA15: [0x51DE],  # CJK COMPATIBILITY IDEOGRAPH-FA15
    0x0FA16: [0x732A],  # CJK COMPATIBILITY IDEOGRAPH-FA16
    0x0FA17: [0x76CA],  # CJK COMPATIBILITY IDEOGRAPH-FA17
    0x0FA18: [0x793C],  # CJK COMPATIBILITY IDEOGRAPH-FA18
    0x0FA19: [0x795E],  # CJK COMPATIBILITY IDEOGRAPH-FA19
    0x0FA1A: [0x7965],  # CJK COMPATIBILITY IDEOGRAPH-FA1A
    0x0FA1B: [0x798F],  # CJK COMPATIBILITY IDEOGRAPH-FA1B
    0x0FA1C: [0x9756],  # CJK COMPATIBILITY IDEOGRAPH-FA1C
    0x0FA1D: [0x7CBE],  # CJK COMPATIBILITY IDEOGRAPH-FA1D
    0x0FA1E: [0x7FBD],  # CJK COMPATIBILITY IDEOGRAPH-FA1E
    0x0FA20: [0x8612],  # CJK COMPATIBILITY IDEOGRAPH-FA20
    0x0FA22: [0x8AF8],  # CJK COMPATIBILITY IDEOGRAPH-FA22
    0x0FA25: [0x9038],  # CJK COMPATIBILITY IDEOGRAPH-FA25
    0x0FA26: [0x90FD],  # CJK COMPATIBILITY IDEOGRAPH-FA26
    0x0FA2A: [0x98EF],  # CJK COMPATIBILITY IDEOGRAPH-FA2A
    0x0FA2B: [0x98FC],  # CJK COMPATIBILITY IDEOGRAPH-FA2B
    0x0FA2C: [0x9928],  # CJK COMPATIBILITY IDEOGRAPH-FA2C
    0x0FA2D: [0x9DB4],  # CJK COMPATIBILITY IDEOGRAPH-FA2D
    0x0FA2E: [0x90DE],  # CJK COMPATIBILITY IDEOGRAPH-FA2E
    0x0FA2F: [0x96B7],  # CJK COMPATIBILITY IDEOGRAPH-FA2F
    0x0FA30: [0x4FAE],  # CJK COMPATIBILITY IDEOGRAPH-FA30
    0x0FA31: [0x50E7],  # CJK COMPATIBILITY IDEOGRAPH-FA31
    0x0FA32: [0x514D],  # CJK COMPATIBILITY IDEOGRAPH-FA32
    0x0FA33: [0x52C9],  # CJK COMPATIBILITY IDEOGRAPH-FA33
    0x0FA34: [0x52E4],  # CJK COMPATIBILITY IDEOGRAPH-FA34
    0x0FA35: [0x5351],  # CJK COMPATIBILITY IDEOGRAPH-FA35
    0x0FA36: [0x559D],  # CJK COMPATIBILITY IDEOGRAPH-FA36
    0x0FA37: [0x5606],  # CJK COMPATIBILITY IDEOGRAPH-FA37
    0x0FA38: [0x5668],  # CJK COMPATIBILITY IDEOGRAPH-FA38
    0x0FA39: [0x5840],  # CJK COMPATIBILITY IDEOGRAPH-FA39
    0x0FA3A: [0x58A8],  # CJK COMPATIBILITY IDEOGRAPH-FA3A
    0x0FA3B: [0x5C64],  # CJK COMPATIBILITY IDEOGRAPH-FA3B
    0x0FA3C: [0x5C6E],  # CJK COMPATIBILITY IDEOGRAPH-FA3C
    0x0FA3D: [0x6094],  # CJK COMPATIBILITY IDEOGRAPH-FA3D
    0x0FA3E: [0x6168],  # CJK COMPATIBILITY IDEOGRAPH-FA3E
    0x0FA3F: [0x618E],  # CJK COMPATIBILITY IDEOGRAPH-FA3F
    0x0FA40: [0x61F2],  # CJK COMPATIBILITY IDEOGRAPH-FA40
    0x0FA41: [0x654F],  # CJK COMPATIBILITY IDEOGRAPH-FA41
    0x0FA42: [0x65E2],  # CJK COMPATIBILITY IDEOGRAPH-FA42
    0x0FA43: [0x6691],  # CJK COMPATIBILITY IDEOGRAPH-FA43
    0x0FA44: [0x6885],  # CJK COMPATIBILITY IDEOGRAPH-FA44
    0x0FA45: [0x6D77],  # CJK COMPATIBILITY IDEOGRAPH-FA45
    0x0FA46: [0x6E1A],  # CJK COMPATIBILITY IDEOGRAPH-FA46
    0x0FA47: [0x6F22],  # CJK COMPATIBILITY IDEOGRAPH-FA47
    0x0FA48: [0x716E],  # CJK COMPATIBILITY IDEOGRAPH-FA48
    0x0FA49: [0x722B],  # CJK COMPATIBILITY IDEOGRAPH-FA49
    0x0FA4A: [0x7422],  # CJK COMPATIBILITY IDEOGRAPH-FA4A
    0x0FA4B: [0x7891],  # CJK COMPATIBILITY IDEOGRAPH-FA4B
    0x0FA4C: [0x793E],  # CJK COMPATIBILITY IDEOGRAPH-FA4C
    0x0FA4D: [0x7949],  # CJK COMPATIBILITY IDEOGRAPH-FA4D
    0x0FA4E: [0x7948],  # CJK COMPATIBILITY IDEOGRAPH-FA4E
    0x0FA4F: [0x7950],  # CJK COMPATIBILITY IDEOGRAPH-FA4F
    0x0FA50: [0x7956],  # CJK COMPATIBILITY IDEOGRAPH-FA50
    0x0FA51: [0x795D],  # CJK COMPATIBILITY IDEOGRAPH-FA51
    0x0FA52: [0x798D],  # CJK COMPATIBILITY IDEOGRAPH-FA52
    0x0FA53: [0x798E],  # CJK COMPATIBILITY IDEOGRAPH-FA53
    0x0FA54: [0x7A40],  # CJK COMPATIBILITY IDEOGRAPH-FA54
    0x0FA55: [0x7A81],  # CJK COMPATIBILITY IDEOGRAPH-FA55
    0x0FA56: [0x7BC0],  # CJK COMPATIBILITY IDEOGRAPH-FA56
    0x0FA57: [0x7DF4],  # CJK COMPATIBILITY IDEOGRAPH-FA57
    0x0FA58: [0x7E09],  # CJK COMPATIBILITY IDEOGRAPH-FA58
    0x0FA59: [0x7E41],  # CJK COMPATIBILITY IDEOGRAPH-FA59
    0x0FA5A: [0x7F72],  # CJK COMPATIBILITY IDEOGRAPH-FA5A
    0x0FA5B: [0x8005],  # CJK COMPATIBILITY IDEOGRAPH-FA5B
    0x0FA5C: [0x81ED],  # CJK COMPATIBILITY IDEOGRAPH-FA5C
    0x0FA5D: [0x8279],  # CJK COMPATIBILITY IDEOGRAPH-FA5D
    0x0FA5E: [0x8279],  # CJK COMPATIBILITY IDEOGRAPH-FA5E
    0x0FA5F: [0x8457],  # CJK COMPATIBILITY IDEOGRAPH-FA5F
    0x0FA60: [0x8910],  # CJK COMPATIBILITY IDEOGRAPH-FA60
    0x0FA61: [0x8996],  # CJK COMPATIBILITY IDEOGRAPH-FA61
    0x0FA62: [0x8B01],  # CJK COMPATIBILITY IDEOGRAPH-FA62
    0x0FA63: [0x8B39],  # CJK COMPATIBILITY IDEOGRAPH-FA63
    0x0FA64: [0x8CD3],  # CJK COMPATIBILITY IDEOGRAPH-FA64
    0x0FA65: [0x8D08],  # CJK COMPATIBILITY IDEOGRAPH-FA65
    0x0FA66: [0x8FB6],  # CJK COMPATIBILITY IDEOGRAPH-FA66
    0x0FA67: [0x9038],  # CJK COMPATIBILITY IDEOGRAPH-FA67
    0x0FA68: [0x96E3],  # CJK COMPATIBILITY IDEOGRAPH-FA68
    0x0FA69: [0x97FF],  # CJK COMPATIBILITY IDEOGRAPH-FA69
    0x0FA6A: [0x983B],  # CJK COMPATIBILITY IDEOGRAPH-FA6A
    0x0FA6B: [0x6075],  # CJK COMPATIBILITY IDEOGRAPH-FA6B
    0x0FA6C: [0x242EE],  # CJK COMPATIBILITY IDEOGRAPH-FA6C
    0x0FA6D: [0x8218],  # CJK COMPATIBILITY IDEOGRAPH-FA6D
    0x0FA70: [0x4E26],  # CJK COMPATIBILITY IDEOGRAPH-FA70
    0x0FA71: [0x51B5],  # CJK COMPATIBILITY IDEOGRAPH-FA71
    0x0FA72: [0x5168],  # CJK COMPATIBILITY IDEOGRAPH-FA72
    0x0FA73: [0x4F80],  # CJK COMPATIBILITY IDEOGRAPH-FA73
    0x0FA74: [0x5145],  # CJK COMPATIBILITY IDEOGRAPH-FA74
    0x0FA75: [0x5180],  # CJK COMPATIBILITY IDEOGRAPH-FA75
    0x0FA76: [0x52C7],  # CJK COMPATIBILITY IDEOGRAPH-FA76
    0x0FA77: [0x52FA],  # CJK COMPATIBILITY IDEOGRAPH-FA77
    0x0FA78: [0x559D],  # CJK COMPATIBILITY IDEOGRAPH-FA78
    0x0FA79: [0x5555],  # CJK COMPATIBILITY IDEOGRAPH-FA79
    0x0FA7A: [0x5599],  # CJK COMPATIBILITY IDEOGRAPH-FA7A
    0x0FA7B: [0x55E2],  # CJK COMPATIBILITY IDEOGRAPH-FA7B
    0x0FA7C: [0x585A],  # CJK COMPATIBILITY IDEOGRAPH-FA7C
    0x0FA7D: [0x58B3],  # CJK COMPATIBILITY IDEOGRAPH-FA7D
    0x0FA7E: [0x5944],  # CJK COMPATIBILITY IDEOGRAPH-FA7E
    0x0FA7F: [0x5954],  # CJK COMPATIBILITY IDEOGRAPH-FA7F
    0x0FA80: [0x5A62],  # CJK COMPATIBILITY IDEOGRAPH-FA80
    0x0FA81: [0x5B28],  # CJK COMPATIBILITY IDEOGRAPH-FA81
    0x0FA82: [0x5ED2],  # CJK COMPATIBILITY IDEOGRAPH-FA82
    0x0FA83: [0x5ED9],  # CJK COMPATIBILITY IDEOGRAPH-FA83
    0x0FA84: [0x5F69],  # CJK COMPATIBILITY IDEOGRAPH-FA84
    0x0FA85: [0x5FAD],  # CJK COMPATIBILITY IDEOGRAPH-FA85
    0x0FA86: [0x60D8],  # CJK COMPATIBILITY IDEOGRAPH-FA86
    0x0FA87: [0x614E],  # CJK COMPATIBILITY IDEOGRAPH-FA87
    0x0FA88: [0x6108],  # CJK COMPATIBILITY IDEOGRAPH-FA88
    0x0FA89: [0x618E],  # CJK COMPATIBILITY IDEOGRAPH-FA89
    0x0FA8A: [0x6160],  # CJK COMPATIBILITY IDEOGRAPH-FA8A
    0x0FA8B: [0x61F2],  # CJK COMPATIBILITY IDEOGRAPH-FA8B
    0x0FA8C: [0x6234],  # CJK COMPATIBILITY IDEOGRAPH-FA8C
    0x0FA8D: [0x63C4],  # CJK COMPATIBILITY IDEOGRAPH-FA8D
    0x0FA8E: [0x641C],  # CJK COMPATIBILITY IDEOGRAPH-FA8E
    0x0FA8F: [0x6452],  # CJK COMPATIBILITY IDEOGRAPH-FA8F
    0x0FA90: [0x6556],  # CJK COMPATIBILITY IDEOGRAPH-FA90
    0x0FA91: [0x6674],  # CJK COMPATIBILITY IDEOGRAPH-FA91
    0x0FA92: [0x6717],  # CJK COMPATIBILITY IDEOGRAPH-FA92
    0x0FA93: [0x671B],  # CJK COMPATIBILITY IDEOGRAPH-FA93
    0x0FA94: [0x6756],  # CJK COMPATIBILITY IDEOGRAPH-FA94
    0x0FA95: [0x6B79],  # CJK COMPATIBILITY IDEOGRAPH-FA95
    0x0FA96: [0x6BBA],  # CJK COMPATIBILITY IDEOGRAPH-FA96
    0x0FA97: [0x6D41],  # CJK COMPATIBILITY IDEOGRAPH-FA97
    0x0FA98: [0x6EDB],  # CJK COMPATIBILITY IDEOGRAPH-FA98
    0x0FA99: [0x6ECB],  # CJK COMPATIBILITY IDEOGRAPH-FA99
    0x0FA9A: [0x6F22],  # CJK COMPATIBILITY IDEOGRAPH-FA9A
    0x0FA9B: [0x701E],  # CJK COMPATIBILITY IDEOGRAPH-FA9B
    0x0FA9C: [0x716E],  # CJK COMPATIBILITY IDEOGRAPH-FA9C
    0x0FA9D: [0x77A7],  # CJK COMPATIBILITY IDEOGRAPH-FA9D
    0x0FA9E: [0x7235],  # CJK COMPATIBILITY IDEOGRAPH-FA9E
    0x0FA9F: [0x72AF],  # CJK COMPATIBILITY IDEOGRAPH-FA9F
    0x0FAA0: [0x732A],  # CJK COMPATIBILITY IDEOGRAPH-FAA0
    0x0FAA1: [0x7471],  # CJK COMPATIBILITY IDEOGRAPH-FAA1
    0x0FAA2: [0x7506],  # CJK COMPATIBILITY IDEOGRAPH-FAA2
    0x0FAA3: [0x753B],  # CJK COMPATIBILITY IDEOGRAPH-FAA3
    0x0FAA4: [0x761D],  # CJK COMPATIBILITY IDEOGRAPH-FAA4
    0x0FAA5: [0x761F],  # CJK COMPATIBILITY IDEOGRAPH-FAA5
    0x0FAA6: [0x76CA],  # CJK COMPATIBILITY IDEOGRAPH-FAA6
    0x0FAA7: [0x76DB],  # CJK COMPATIBILITY IDEOGRAPH-FAA7
    0x0FAA8: [0x76F4],  # CJK COMPATIBILITY IDEOGRAPH-FAA8
    0x0FAA9: [0x774A],  # CJK COMPATIBILITY IDEOGRAPH-FAA9
    0x0FAAA: [0x7740],  # CJK COMPATIBILITY IDEOGRAPH-FAAA
    0x0FAAB: [0x78CC],  # CJK COMPATIBILITY IDEOGRAPH-FAAB
    0x0FAAC: [0x7AB1],  # CJK COMPATIBILITY IDEOGRAPH-FAAC
    0x0FAAD: [0x7BC0],  # CJK COMPATIBILITY IDEOGRAPH-FAAD
    0x0FAAE: [0x7C7B],  # CJK COMPATIBILITY IDEOGRAPH-FAAE
    0x0FAAF: [0x7D5B],  # CJK COMPATIBILITY IDEOGRAPH-FAAF
    0x0FAB0: [0x7DF4],  # CJK COMPATIBILITY IDEOGRAPH-FAB0
    0x0FAB1: [0x7F3E],  # CJK COMPATIBILITY IDEOGRAPH-FAB1
    0x0FAB2: [0x8005],  # CJK COMPATIBILITY IDEOGRAPH-FAB2
    0x0FAB3: [0x8352],  # CJK COMPATIBILITY IDEOGRAPH-FAB3
    0x0FAB4: [0x83EF],  # CJK COMPATIBILITY IDEOGRAPH-FAB4
    0x0FAB5: [0x8779],  # CJK COMPATIBILITY IDEOGRAPH-FAB5
    0x0FAB6: [0x8941],  # CJK COMPATIBILITY IDEOGRAPH-FAB6
    0x0FAB7: [0x8986],  # CJK COMPATIBILITY IDEOGRAPH-FAB7
    0x0FAB8: [0x8996],  # CJK COMPATIBILITY IDEOGRAPH-FAB8
    0x0FAB9: [0x8ABF],  # CJK COMPATIBILITY IDEOGRAPH-FAB9
    0x0FABA: [0x8AF8],  # CJK COMPATIBILITY IDEOGRAPH-FABA
    0x0FABB: [0x8ACB],  # CJK COMPATIBILITY IDEOGRAPH-FABB
    0x0FABC: [0x8B01],  # CJK COMPATIBILITY IDEOGRAPH-FABC
    0x0FABD: [0x8AFE],  # CJK COMPATIBILITY IDEOGRAPH-FABD
    0x0FABE: [0x8AED],  # CJK COMPATIBILITY IDEOGRAPH-FABE
    0x0FABF: [0x8B39],  # CJK COMPATIBILITY IDEOGRAPH-FABF
    0x0FAC0: [0x8B8A],  # CJK COMPATIBILITY IDEOGRAPH-FAC0
    0x0FAC1: [0x8D08],  # CJK COMPATIBILITY IDEOGRAPH-FAC1
    0x0FAC2: [0x8F38],  # CJK COMPATIBILITY IDEOGRAPH-FAC2
    0x0FAC3: [0x9072],  # CJK COMPATIBILITY IDEOGRAPH-FAC3
    0x0FAC4: [0x9199],  # CJK COMPATIBILITY IDEOGRAPH-FAC4
    0x0FAC5: [0x9276],  # CJK COMPATIBILITY IDEOGRAPH-FAC5
    0x0FAC6: [0x967C],  # CJK COMPATIBILITY IDEOGRAPH-FAC6
    0x0FAC7: [0x96E3],  # CJK COMPATIBILITY IDEOGRAPH-FAC7
    0x0FAC8: [0x9756],  # CJK COMPATIBILITY IDEOGRAPH-FAC8
    0x0FAC9: [0x97DB],  # CJK COMPATIBILITY IDEOGRAPH-FAC9
    0x0FACA: [0x97FF],  # CJK COMPATIBILITY IDEOGRAPH-FACA
    0x0FACB: [0x980B],  # CJK COMPATIBILITY IDEOGRAPH-FACB
    0x0FACC: [0x983B],  # CJK COMPATIBILITY IDEOGRAPH-FACC
    0x0FACD: [0x9B12],  # CJK COMPATIBILITY IDEOGRAPH-FACD
    0x0FACE: [0x9F9C],  # CJK COMPATIBILITY IDEOGRAPH-FACE
    0x0FACF: [0x2284A],  # CJK COMPATIBILITY IDEOGRAPH-FACF
    0x0FAD0: [0x22844],  # CJK COMPATIBILITY IDEOGRAPH-FAD0
    0x0FAD1: [0x233D5],  # CJK COMPATIBILITY IDEOGRAPH-FAD1
    0x0FAD2: [0x3B9D],  # CJK COMPATIBILITY IDEOGRAPH-FAD2
    0x0FAD3: [0x4018],  # CJK COMPATIBILITY IDEOGRAPH-FAD3
    0x0FAD4: [0x4039],  # CJK COMPATIBILITY IDEOGRAPH-FAD4
    0x0FAD5: [0x25249],  # CJK COMPATIBILITY IDEOGRAPH-FAD5
    0x0FAD6: [0x25CD0],  # CJK COMPATIBILITY IDEOGRAPH-FAD6
    0x0FAD7: [0x27ED3],  # CJK COMPATIBILITY IDEOGRAPH-FAD7
    0x0FAD8: [0x9F43],  # CJK COMPATIBILITY IDEOGRAPH-FAD8
    0x0FAD9: [0x9F8E],  # CJK COMPATIBILITY IDEOGRAPH-FAD9
    0x0FB00: ["<compat>", 0x0066, 0x0066],  # LATIN SMALL LIGATURE FF
    0x0FB01: ["<compat>", 0x0066, 0x0069],  # LATIN SMALL LIGATURE FI
    0x0FB02: ["<compat>", 0x0066, 0x006C],  # LATIN SMALL LIGATURE FL
    0x0FB03: ["<compat>", 0x0066, 0x0066, 0x0069],  # LATIN SMALL LIGATURE FFI
    0x0FB04: ["<compat>", 0x0066, 0x0066, 0x006C],  # LATIN SMALL LIGATURE FFL
    0x0FB05: ["<compat>", 0x017F, 0x0074],  # LATIN SMALL LIGATURE LONG S T
    0x0FB06: ["<compat>", 0x0073, 0x0074],  # LATIN SMALL LIGATURE ST
    0x0FB13: ["<compat>", 0x0574, 0x0576],  # ARMENIAN SMALL LIGATURE MEN NOW
    0x0FB14: ["<compat>", 0x0574, 0x0565],  # ARMENIAN SMALL LIGATURE MEN ECH
    0x0FB15: ["<compat>", 0x0574, 0x056B],  # ARMENIAN SMALL LIGATURE MEN INI
    0x0FB16: ["<compat>", 0x057E, 0x0576],  # ARMENIAN SMALL LIGATURE VEW NOW
    0x0FB17: ["<compat>", 0x0574, 0x056D],  # ARMENIAN SMALL LIGATURE MEN XEH
    0x0FB1D: [0x05D9, 0x05B4],  # HEBREW LETTER YOD WITH HIRIQ
    0x0FB1F: [0x05F2, 0x05B7],  # HEBREW LIGATURE YIDDISH YOD YOD PATAH
    0x0FB20: ["<font>", 0x05E2],  # HEBREW LETTER ALTERNATIVE AYIN
    0x0FB21: ["<font>", 0x05D0],  # HEBREW LETTER WIDE ALEF
    0x0FB22: ["<font>", 0x05D3],  # HEBREW LETTER WIDE DALET
    0x0FB23: ["<font>", 0x05D4],  # HEBREW LETTER WIDE HE
    0x0FB24: ["<font>", 0x05DB],  # HEBREW LETTER WIDE KAF
    0x0FB25: ["<font>", 0x05DC],  # HEBREW LETTER WIDE LAMED
    0x0FB26: ["<font>", 0x05DD],  # HEBREW LETTER WIDE FINAL MEM
    0x0FB27: ["<font>", 0x05E8],  # HEBREW LETTER WIDE RESH
    0x0FB28: ["<font>", 0x05EA],  # HEBREW LETTER WIDE TAV
    0x0FB29: ["<font>", 0x002B],  # HEBREW LETTER ALTERNATIVE PLUS SIGN
    0x0FB2A: [0x05E9, 0x05C1],  # HEBREW LETTER SHIN WITH SHIN DOT
    0x0FB2B: [0x05E9, 0x05C2],  # HEBREW LETTER SHIN WITH SIN DOT
    0x0FB2C: [0xFB49, 0x05C1],  # HEBREW LETTER SHIN WITH DAGESH AND SHIN DOT
    0x0FB2D: [0xFB49, 0x05C2],  # HEBREW LETTER SHIN WITH DAGESH AND SIN DOT
    0x0FB2E: [0x05D0, 0x05B7],  # HEBREW LETTER ALEF WITH PATAH
    0x0FB2F: [0x05D0, 0x05B8],  # HEBREW LETTER ALEF WITH QAMATS
    0x0FB30: [0x05D0, 0x05BC],  # HEBREW LETTER ALEF WITH MAPIQ
    0x0FB31: [0x05D1, 0x05BC],  # HEBREW LETTER BET WITH DAGESH
    0x0FB32: [0x05D2, 0x05BC],  # HEBREW LETTER GIMEL WITH DAGESH
    0x0FB33: [0x05D3, 0x05BC],  # HEBREW LETTER DALET WITH DAGESH
    0x0FB34: [0x05D4, 0x05BC],  # HEBREW LETTER HE WITH MAPIQ
    0x0FB35: [0x05D5, 0x05BC],  # HEBREW LETTER VAV WITH DAGESH
    0x0FB36: [0x05D6, 0x05BC],  # HEBREW LETTER ZAYIN WITH DAGESH
    0x0FB38: [0x05D8, 0x05BC],  # HEBREW LETTER TET WITH DAGESH
    0x0FB39: [0x05D9, 0x05BC],  # HEBREW LETTER YOD WITH DAGESH
    0x0FB3A: [0x05DA, 0x05BC],  # HEBREW LETTER FINAL KAF WITH DAGESH
    0x0FB3B: [0x05DB, 0x05BC],  # HEBREW LETTER KAF WITH DAGESH
    0x0FB3C: [0x05DC, 0x05BC],  # HEBREW LETTER LAMED WITH DAGESH
    0x0FB3E: [0x05DE, 0x05BC],  # HEBREW LETTER MEM WITH DAGESH
    0x0FB40: [0x05E0, 0x05BC],  # HEBREW LETTER NUN WITH DAGESH
    0x0FB41: [0x05E1, 0x05BC],  # HEBREW LETTER SAMEKH WITH DAGESH
    0x0FB43: [0x05E3, 0x05BC],  # HEBREW LETTER FINAL PE WITH DAGESH
    0x0FB44: [0x05E4, 0x05BC],  # HEBREW LETTER PE WITH DAGESH
    0x0FB46: [0x05E6, 0x05BC],  # HEBREW LETTER TSADI WITH DAGESH
    0x0FB47: [0x05E7, 0x05BC],  # HEBREW LETTER QOF WITH DAGESH
    0x0FB48: [0x05E8, 0x05BC],  # HEBREW LETTER RESH WITH DAGESH
    0x0FB49: [0x05E9, 0x05BC],  # HEBREW LETTER SHIN WITH DAGESH
    0x0FB4A: [0x05EA, 0x05BC],  # HEBREW LETTER TAV WITH DAGESH
    0x0FB4B: [0x05D5, 0x05B9],  # HEBREW LETTER VAV WITH HOLAM
    0x0FB4C: [0x05D1, 0x05BF],  # HEBREW LETTER BET WITH RAFE
    0x0FB4D: [0x05DB, 0x05BF],  # HEBREW LETTER KAF WITH RAFE
    0x0FB4E: [0x05E4, 0x05BF],  # HEBREW LETTER PE WITH RAFE
    0x0FB4F: ["<compat>", 0x05D0, 0x05DC],  # HEBREW LIGATURE ALEF LAMED
    0x0FB50: ["<isolated>", 0x0671],  # ARABIC LETTER ALEF WASLA ISOLATED FORM
    0x0FB51: ["<final>", 0x0671],  # ARABIC LETTER ALEF WASLA FINAL FORM
    0x0FB52: ["<isolated>", 0x067B],  # ARABIC LETTER BEEH ISOLATED FORM
    0x0FB53: ["<final>", 0x067B],  # ARABIC LETTER BEEH FINAL FORM
    0x0FB54: ["<initial>", 0x067B],  # ARABIC LETTER BEEH INITIAL FORM
    0x0FB55: ["<medial>", 0x067B],  # ARABIC LETTER BEEH MEDIAL FORM
    0x0FB56: ["<isolated>", 0x067E],  # ARABIC LETTER PEH ISOLATED FORM
    0x0FB57: ["<final>", 0x067E],  # ARABIC LETTER PEH FINAL FORM
    0x0FB58: ["<initial>", 0x067E],  # ARABIC LETTER PEH INITIAL FORM
    0x0FB59: ["<medial>", 0x067E],  # ARABIC LETTER PEH MEDIAL FORM
    0x0FB5A: ["<isolated>", 0x0680],  # ARABIC LETTER BEHEH ISOLATED FORM
    0x0FB5B: ["<final>", 0x0680],  # ARABIC LETTER BEHEH FINAL FORM
    0x0FB5C: ["<initial>", 0x0680],  # ARABIC LETTER BEHEH INITIAL FORM
    0x0FB5D: ["<medial>", 0x0680],  # ARABIC LETTER BEHEH MEDIAL FORM
    0x0FB5E: ["<isolated>", 0x067A],  # ARABIC LETTER TTEHEH ISOLATED FORM
    0x0FB5F: ["<final>", 0x067A],  # ARABIC LETTER TTEHEH FINAL FORM
    0x0FB60: ["<initial>", 0x067A],  # ARABIC LETTER TTEHEH INITIAL FORM
    0x0FB61: ["<medial>", 0x067A],  # ARABIC LETTER TTEHEH MEDIAL FORM
    0x0FB62: ["<isolated>", 0x067F],  # ARABIC LETTER TEHEH ISOLATED FORM
    0x0FB63: ["<final>", 0x067F],  # ARABIC LETTER TEHEH FINAL FORM
    0x0FB64: ["<initial>", 0x067F],  # ARABIC LETTER TEHEH INITIAL FORM
    0x0FB65: ["<medial>", 0x067F],  # ARABIC LETTER TEHEH MEDIAL FORM
    0x0FB66: ["<isolated>", 0x0679],  # ARABIC LETTER TTEH ISOLATED FORM
    0x0FB67: ["<final>", 0x0679],  # ARABIC LETTER TTEH FINAL FORM
    0x0FB68: ["<initial>", 0x0679],  # ARABIC LETTER TTEH INITIAL FORM
    0x0FB69: ["<medial>", 0x0679],  # ARABIC LETTER TTEH MEDIAL FORM
    0x0FB6A: ["<isolated>", 0x06A4],  # ARABIC LETTER VEH ISOLATED FORM
    0x0FB6B: ["<final>", 0x06A4],  # ARABIC LETTER VEH FINAL FORM
    0x0FB6C: ["<initial>", 0x06A4],  # ARABIC LETTER VEH INITIAL FORM
    0x0FB6D: ["<medial>", 0x06A4],  # ARABIC LETTER VEH MEDIAL FORM
    0x0FB6E: ["<isolated>", 0x06A6],  # ARABIC LETTER PEHEH ISOLATED FORM
    0x0FB6F: ["<final>", 0x06A6],  # ARABIC LETTER PEHEH FINAL FORM
    0x0FB70: ["<initial>", 0x06A6],  # ARABIC LETTER PEHEH INITIAL FORM
    0x0FB71: ["<medial>", 0x06A6],  # ARABIC LETTER PEHEH MEDIAL FORM
    0x0FB72: ["<isolated>", 0x0684],  # ARABIC LETTER DYEH ISOLATED FORM
    0x0FB73: ["<final>", 0x0684],  # ARABIC LETTER DYEH FINAL FORM
    0x0FB74: ["<initial>", 0x0684],  # ARABIC LETTER DYEH INITIAL FORM
    0x0FB75: ["<medial>", 0x0684],  # ARABIC LETTER DYEH MEDIAL FORM
    0x0FB76: ["<isolated>", 0x0683],  # ARABIC LETTER NYEH ISOLATED FORM
    0x0FB77: ["<final>", 0x0683],  # ARABIC LETTER NYEH FINAL FORM
    0x0FB78: ["<initial>", 0x0683],  # ARABIC LETTER NYEH INITIAL FORM
    0x0FB79: ["<medial>", 0x0683],  # ARABIC LETTER NYEH MEDIAL FORM
    0x0FB7A: ["<isolated>", 0x0686],  # ARABIC LETTER TCHEH ISOLATED FORM
    0x0FB7B: ["<final>", 0x0686],  # ARABIC LETTER TCHEH FINAL FORM
    0x0FB7C: ["<initial>", 0x0686],  # ARABIC LETTER TCHEH INITIAL FORM
    0x0FB7D: ["<medial>", 0x0686],  # ARABIC LETTER TCHEH MEDIAL FORM
    0x0FB7E: ["<isolated>", 0x0687],  # ARABIC LETTER TCHEHEH ISOLATED FORM
    0x0FB7F: ["<final>", 0x0687],  # ARABIC LETTER TCHEHEH FINAL FORM
    0x0FB80: ["<initial>", 0x0687],  # ARABIC LETTER TCHEHEH INITIAL FORM
    0x0FB81: ["<medial>", 0x0687],  # ARABIC LETTER TCHEHEH MEDIAL FORM
    0x0FB82: ["<isolated>", 0x068D],  # ARABIC LETTER DDAHAL ISOLATED FORM
    0x0FB83: ["<final>", 0x068D],  # ARABIC LETTER DDAHAL FINAL FORM
    0x0FB84: ["<isolated>", 0x068C],  # ARABIC LETTER DAHAL ISOLATED FORM
    0x0FB85: ["<final>", 0x068C],  # ARABIC LETTER DAHAL FINAL FORM
    0x0FB86: ["<isolated>", 0x068E],  # ARABIC LETTER DUL ISOLATED FORM
    0x0FB87: ["<final>", 0x068E],  # ARABIC LETTER DUL FINAL FORM
    0x0FB88: ["<isolated>", 0x0688],  # ARABIC LETTER DDAL ISOLATED FORM
    0x0FB89: ["<final>", 0x0688],  # ARABIC LETTER DDAL FINAL FORM
    0x0FB8A: ["<isolated>", 0x0698],  # ARABIC LETTER JEH ISOLATED FORM
    0x0FB8B: ["<final>", 0x0698],  # ARABIC LETTER JEH FINAL FORM
    0x0FB8C: ["<isolated>", 0x0691],  # ARABIC LETTER RREH ISOLATED FORM
    0x0FB8D: ["<final>", 0x0691],  # ARABIC LETTER RREH FINAL FORM
    0x0FB8E: ["<isolated>", 0x06A9],  # ARABIC LETTER KEHEH ISOLATED FORM
    0x0FB8F: ["<final>", 0x06A9],  # ARABIC LETTER KEHEH FINAL FORM
    0x0FB90: ["<initial>", 0x06A9],  # ARABIC LETTER KEHEH INITIAL FORM
    0x0FB91: ["<medial>", 0x06A9],  # ARABIC LETTER KEHEH MEDIAL FORM
    0x0FB92: ["<isolated>", 0x06AF],  # ARABIC LETTER GAF ISOLATED FORM
    0x0FB93: ["<final>", 0x06AF],  # ARABIC LETTER GAF FINAL FORM
    0x0FB94: ["<initial>", 0x06AF],  # ARABIC LETTER GAF INITIAL FORM
    0x0FB95: ["<medial>", 0x06AF],  # ARABIC LETTER GAF MEDIAL FORM
    0x0FB96: ["<isolated>", 0x06B3],  # ARABIC LETTER GUEH ISOLATED FORM
    0x0FB97: ["<final>", 0x06B3],  # ARABIC LETTER GUEH FINAL FORM
    0x0FB98: ["<initial>", 0x06B3],  # ARABIC LETTER GUEH INITIAL FORM
    0x0FB99: ["<medial>", 0x06B3],  # ARABIC LETTER GUEH MEDIAL FORM
    0x0FB9A: ["<isolated>", 0x06B1],  # ARABIC LETTER NGOEH ISOLATED FORM
    0x0FB9B: ["<final>", 0x06B1],  # ARABIC LETTER NGOEH FINAL FORM
    0x0FB9C: ["<initial>", 0x06B1],  # ARABIC LETTER NGOEH INITIAL FORM
    0x0FB9D: ["<medial>", 0x06B1],  # ARABIC LETTER NGOEH MEDIAL FORM
    0x0FB9E: ["<isolated>", 0x06BA],  # ARABIC LETTER NOON GHUNNA ISOLATED FORM
    0x0FB9F: ["<final>", 0x06BA],  # ARABIC LETTER NOON GHUNNA FINAL FORM
    0x0FBA0: ["<isolated>", 0x06BB],  # ARABIC LETTER RNOON ISOLATED FORM
    0x0FBA1: ["<final>", 0x06BB],  # ARABIC LETTER RNOON FINAL FORM
    0x0FBA2: ["<initial>", 0x06BB],  # ARABIC LETTER RNOON INITIAL FORM
    0x0FBA3: ["<medial>", 0x06BB],  # ARABIC LETTER RNOON MEDIAL FORM
    0x0FBA4: ["<isolated>", 0x06C0],  # ARABIC LETTER HEH WITH YEH ABOVE ISOLATED FORM
    0x0FBA5: ["<final>", 0x06C0],  # ARABIC LETTER HEH WITH YEH ABOVE FINAL FORM
    0x0FBA6: ["<isolated>", 0x06C1],  # ARABIC LETTER HEH GOAL ISOLATED FORM
    0x0FBA7: ["<final>", 0x06C1],  # ARABIC LETTER HEH GOAL FINAL FORM
    0x0FBA8: ["<initial>", 0x06C1],  # ARABIC LETTER HEH GOAL INITIAL FORM
    0x0FBA9: ["<medial>", 0x06C1],  # ARABIC LETTER HEH GOAL MEDIAL FORM
    0x0FBAA: ["<isolated>", 0x06BE],  # ARABIC LETTER HEH DOACHASHMEE ISOLATED FORM
    0x0FBAB: ["<final>", 0x06BE],  # ARABIC LETTER HEH DOACHASHMEE FINAL FORM
    0x0FBAC: ["<initial>", 0x06BE],  # ARABIC LETTER HEH DOACHASHMEE INITIAL FORM
    0x0FBAD: ["<medial>", 0x06BE],  # ARABIC LETTER HEH DOACHASHMEE MEDIAL FORM
    0x0FBAE: ["<isolated>", 0x06D2],  # ARABIC LETTER YEH BARREE ISOLATED FORM
    0x0FBAF: ["<final>", 0x06D2],  # ARABIC LETTER YEH BARREE FINAL FORM
    0x0FBB0: ["<isolated>", 0x06D3],  # ARABIC LETTER YEH BARREE WITH HAMZA ABOVE ISOLATED FORM
    0x0FBB1: ["<final>", 0x06D3],  # ARABIC LETTER YEH BARREE WITH HAMZA ABOVE FINAL FORM
    0x0FBD3: ["<isolated>", 0x06AD],  # ARABIC LETTER NG ISOLATED FORM
    0x0FBD4: ["<final>", 0x06AD],  # ARABIC LETTER NG FINAL FORM
    0x0FBD5: ["<initial>", 0x06AD],  # ARABIC LETTER NG INITIAL FORM
    0x0FBD6: ["<medial>", 0x06AD],  # ARABIC LETTER NG MEDIAL FORM
    0x0FBD7: ["<isolated>", 0x06C7],  # ARABIC LETTER U ISOLATED FORM
    0x0FBD8: ["<final>", 0x06C7],  # ARABIC LETTER U FINAL FORM
    0x0FBD9: ["<isolated>", 0x06C6],  # ARABIC LETTER OE ISOLATED FORM
    0x0FBDA: ["<final>", 0x06C6],  # ARABIC LETTER OE FINAL FORM
    0x0FBDB: ["<isolated>", 0x06C8],  # ARABIC LETTER YU ISOLATED FORM
    0x0FBDC: ["<final>", 0x06C8],  # ARABIC LETTER YU FINAL FORM
    0x0FBDD: ["<isolated>", 0x0677],  # ARABIC LETTER U WITH HAMZA ABOVE ISOLATED FORM
    0x0FBDE: ["<isolated>", 0x06CB],  # ARABIC LETTER VE ISOLATED FORM
    0x0FBDF: ["<final>", 0x06CB],  # ARABIC LETTER VE FINAL FORM
    0x0FBE0: ["<isolated>", 0x06C5],  # ARABIC LETTER KIRGHIZ OE ISOLATED FORM
    0x0FBE1: ["<final>", 0x06C5],  # ARABIC LETTER KIRGHIZ OE FINAL FORM
    0x0FBE2: ["<isolated>", 0x06C9],  # ARABIC LETTER KIRGHIZ YU ISOLATED FORM
    0x0FBE3: ["<final>", 0x06C9],  # ARABIC LETTER KIRGHIZ YU FINAL FORM
    0x0FBE4: ["<isolated>", 0x06D0],  # ARABIC LETTER E ISOLATED FORM
    0x0FBE5: ["<final>", 0x06D0],  # ARABIC LETTER E FINAL FORM
    0x0FBE6: ["<initial>", 0x06D0],  # ARABIC LETTER E INITIAL FORM
    0x0FBE7: ["<medial>", 0x06D0],  # ARABIC LETTER E MEDIAL FORM
    0x0FBE8: ["<initial>", 0x0649],  # ARABIC LETTER UIGHUR KAZAKH KIRGHIZ ALEF MAKSURA INITIAL FORM
    0x0FBE9: ["<medial>", 0x0649],  # ARABIC LETTER UIGHUR KAZAKH KIRGHIZ ALEF MAKSURA MEDIAL FORM
    0x0FBEA: ["<isolated>", 0x0626, 0x0627],  # ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF ISOLATED FORM
    0x0FBEB: ["<final>", 0x0626, 0x0627],  # ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF FINAL FORM
    0x0FBEC: ["<isolated>", 0x0626, 0x06D5],  # ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH AE ISOLATED FORM
    0x0FBED: ["<final>", 0x0626, 0x06D5],  # ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH AE FINAL FORM
    0x0FBEE: ["<isolated>", 0x0626, 0x0648],  # ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH WAW ISOLATED FORM
    0x0FBEF: ["<final>", 0x0626, 0x0648],  # ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH WAW FINAL FORM
    0x0FBF0: ["<isolated>", 0x0626, 0x06C7],  # ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH U ISOLATED FORM
    0x0FBF1: ["<final>", 0x0626, 0x06C7],  # ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH U FINAL FORM
    0x0FBF2: ["<isolated>", 0x0626, 0x06C6],  # ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH OE ISOLATED FORM
    0x0FBF3: ["<final>", 0x0626, 0x06C6],  # ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH OE FINAL FORM
    0x0FBF4: ["<isolated>", 0x0626, 0x06C8],  # ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YU ISOLATED FORM
    0x0FBF5: ["<final>", 0x0626, 0x06C8],  # ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YU FINAL FORM
    0x0FBF6: ["<isolated>", 0x0626, 0x06D0],  # ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E ISOLATED FORM
    0x0FBF7: ["<final>", 0x0626, 0x06D0],  # ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E FINAL FORM
    0x0FBF8: ["<initial>", 0x0626, 0x06D0],  # ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E INITIAL FORM
    0x0FBF9: ["<isolated>", 0x0626, 0x0649],  # ARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA ISOLATED FORM
    0x0FBFA: ["<final>", 0x0626, 0x0649],  # ARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA FINAL FORM
    0x0FBFB: ["<initial>", 0x0626, 0x0649],  # ARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA INITIAL FORM
    0x0FBFC: ["<isolated>", 0x06CC],  # ARABIC LETTER FARSI YEH ISOLATED FORM
    0x0FBFD: ["<final>", 0x06CC],  # ARABIC LETTER FARSI YEH FINAL FORM
    0x0FBFE: ["<initial>", 0x06CC],  # ARABIC LETTER FARSI YEH INITIAL FORM
    0x0FBFF: ["<medial>", 0x06CC],  # ARABIC LETTER FARSI YEH MEDIAL FORM
    0x0FC00: ["<isolated>", 0x0626, 0x062C],  # ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH JEEM ISOLATED FORM
    0x0FC01: ["<isolated>", 0x0626, 0x062D],  # ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HAH ISOLATED FORM
    0x0FC02: ["<isolated>", 0x0626, 0x0645],  # ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM ISOLATED FORM
    0x0FC03: ["<isolated>", 0x0626, 0x0649],  # ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF MAKSURA ISOLATED FORM
    0x0FC04: ["<isolated>", 0x0626, 0x064A],  # ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YEH ISOLATED FORM
    0x0FC05: ["<isolated>", 0x0628, 0x062C],  # ARABIC LIGATURE BEH WITH JEEM ISOLATED FORM
    0x0FC06: ["<isolated>", 0x0628, 0x062D],  # ARABIC LIGATURE BEH WITH HAH ISOLATED FORM
    0x0FC07: ["<isolated>", 0x0628, 0x062E],  # ARABIC LIGATURE BEH WITH KHAH ISOLATED FORM
    0x0FC08: ["<isolated>", 0x0628, 0x0645],  # ARABIC LIGATURE BEH WITH MEEM ISOLATED FORM
    0x0FC09: ["<isolated>", 0x0628, 0x0649],  # ARABIC LIGATURE BEH WITH ALEF MAKSURA ISOLATED FORM
    0x0FC0A: ["<isolated>", 0x0628, 0x064A],  # ARABIC LIGATURE BEH WITH YEH ISOLATED FORM
    0x0FC0B: ["<isolated>", 0x062A, 0x062C],  # ARABIC LIGATURE TEH WITH JEEM ISOLATED FORM
    0x0FC0C: ["<isolated>", 0x062A, 0x062D],  # ARABIC LIGATURE TEH WITH HAH ISOLATED FORM
    0x0FC0D: ["<isolated>", 0x062A, 0x062E],  # ARABIC LIGATURE TEH WITH KHAH ISOLATED FORM
    0x0FC0E: ["<isolated>", 0x062A, 0x0645],  # ARABIC LIGATURE TEH WITH MEEM ISOLATED FORM
    0x0FC0F: ["<isolated>", 0x062A, 0x0649],  # ARABIC LIGATURE TEH WITH ALEF MAKSURA ISOLATED FORM
    0x0FC10: ["<isolated>", 0x062A, 0x064A],  # ARABIC LIGATURE TEH WITH YEH ISOLATED FORM
    0x0FC11: ["<isolated>", 0x062B, 0x062C],  # ARABIC LIGATURE THEH WITH JEEM ISOLATED FORM
    0x0FC12: ["<isolated>", 0x062B, 0x0645],  # ARABIC LIGATURE THEH WITH MEEM ISOLATED FORM
    0x0FC13: ["<isolated>", 0x062B, 0x0649],  # ARABIC LIGATURE THEH WITH ALEF MAKSURA ISOLATED FORM
    0x0FC14: ["<isolated>", 0x062B, 0x064A],  # ARABIC LIGATURE THEH WITH YEH ISOLATED FORM
    0x0FC15: ["<isolated>", 0x062C, 0x062D],  # ARABIC LIGATURE JEEM WITH HAH ISOLATED FORM
    0x0FC16: ["<isolated>", 0x062C, 0x0645],  # ARABIC LIGATURE JEEM WITH MEEM ISOLATED FORM
    0x0FC17: ["<isolated>", 0x062D, 0x062C],  # ARABIC LIGATURE HAH WITH JEEM ISOLATED FORM
    0x0FC18: ["<isolated>", 0x062D, 0x0645],  # ARABIC LIGATURE HAH WITH MEEM ISOLATED FORM
    0x0FC19: ["<isolated>", 0x062E, 0x062C],  # ARABIC LIGATURE KHAH WITH JEEM ISOLATED FORM
    0x0FC1A: ["<isolated>", 0x062E, 0x062D],  # ARABIC LIGATURE KHAH WITH HAH ISOLATED FORM
    0x0FC1B: ["<isolated>", 0x062E, 0x0645],  # ARABIC LIGATURE KHAH WITH MEEM ISOLATED FORM
    0x0FC1C: ["<isolated>", 0x0633, 0x062C],  # ARABIC LIGATURE SEEN WITH JEEM ISOLATED FORM
    0x0FC1D: ["<isolated>", 0x0633, 0x062D],  # ARABIC LIGATURE SEEN WITH HAH ISOLATED FORM
    0x0FC1E: ["<isolated>", 0x0633, 0x062E],  # ARABIC LIGATURE SEEN WITH KHAH ISOLATED FORM
    0x0FC1F: ["<isolated>", 0x0633, 0x0645],  # ARABIC LIGATURE SEEN WITH MEEM ISOLATED FORM
    0x0FC20: ["<isolated>", 0x0635, 0x062D],  # ARABIC LIGATURE SAD WITH HAH ISOLATED FORM
    0x0FC21: ["<isolated>", 0x0635, 0x0645],  # ARABIC LIGATURE SAD WITH MEEM ISOLATED FORM
    0x0FC22: ["<isolated>", 0x0636, 0x062C],  # ARABIC LIGATURE DAD WITH JEEM ISOLATED FORM
    0x0FC23: ["<isolated>", 0x0636, 0x062D],  # ARABIC LIGATURE DAD WITH HAH ISOLATED FORM
    0x0FC24: ["<isolated>", 0x0636, 0x062E],  # ARABIC LIGATURE DAD WITH KHAH ISOLATED FORM
    0x0FC25: ["<isolated>", 0x0636, 0x0645],  # ARABIC LIGATURE DAD WITH MEEM ISOLATED FORM
    0x0FC26: ["<isolated>", 0x0637, 0x062D],  # ARABIC LIGATURE TAH WITH HAH ISOLATED FORM
    0x0FC27: ["<isolated>", 0x0637, 0x0645],  # ARABIC LIGATURE TAH WITH MEEM ISOLATED FORM
    0x0FC28: ["<isolated>", 0x0638, 0x0645],  # ARABIC LIGATURE ZAH WITH MEEM ISOLATED FORM
    0x0FC29: ["<isolated>", 0x0639, 0x062C],  # ARABIC LIGATURE AIN WITH JEEM ISOLATED FORM
    0x0FC2A: ["<isolated>", 0x0639, 0x0645],  # ARABIC LIGATURE AIN WITH MEEM ISOLATED FORM
    0x0FC2B: ["<isolated>", 0x063A, 0x062C],  # ARABIC LIGATURE GHAIN WITH JEEM ISOLATED FORM
    0x0FC2C: ["<isolated>", 0x063A, 0x0645],  # ARABIC LIGATURE GHAIN WITH MEEM ISOLATED FORM
    0x0FC2D: ["<isolated>", 0x0641, 0x062C],  # ARABIC LIGATURE FEH WITH JEEM ISOLATED FORM
    0x0FC2E: ["<isolated>", 0x0641, 0x062D],  # ARABIC LIGATURE FEH WITH HAH ISOLATED FORM
    0x0FC2F: ["<isolated>", 0x0641, 0x062E],  # ARABIC LIGATURE FEH WITH KHAH ISOLATED FORM
    0x0FC30: ["<isolated>", 0x0641, 0x0645],  # ARABIC LIGATURE FEH WITH MEEM ISOLATED FORM
    0x0FC31: ["<isolated>", 0x0641, 0x0649],  # ARABIC LIGATURE FEH WITH ALEF MAKSURA ISOLATED FORM
    0x0FC32: ["<isolated>", 0x0641, 0x064A],  # ARABIC LIGATURE FEH WITH YEH ISOLATED FORM
    0x0FC33: ["<isolated>", 0x0642, 0x062D],  # ARABIC LIGATURE QAF WITH HAH ISOLATED FORM
    0x0FC34: ["<isolated>", 0x0642, 0x0645],  # ARABIC LIGATURE QAF WITH MEEM ISOLATED FORM
    0x0FC35: ["<isolated>", 0x0642, 0x0649],  # ARABIC LIGATURE QAF WITH ALEF MAKSURA ISOLATED FORM
    0x0FC36: ["<isolated>", 0x0642, 0x064A],  # ARABIC LIGATURE QAF WITH YEH ISOLATED FORM
    0x0FC37: ["<isolated>", 0x0643, 0x0627],  # ARABIC LIGATURE KAF WITH ALEF ISOLATED FORM
    0x0FC38: ["<isolated>", 0x0643, 0x062C],  # ARABIC LIGATURE KAF WITH JEEM ISOLATED FORM
    0x0FC39: ["<isolated>", 0x0643, 0x062D],  # ARABIC LIGATURE KAF WITH HAH ISOLATED FORM
    0x0FC3A: ["<isolated>", 0x0643, 0x062E],  # ARABIC LIGATURE KAF WITH KHAH ISOLATED FORM
    0x0FC3B: ["<isolated>", 0x0643, 0x0644],  # ARABIC LIGATURE KAF WITH LAM ISOLATED FORM
    0x0FC3C: ["<isolated>", 0x0643, 0x0645],  # ARABIC LIGATURE KAF WITH MEEM ISOLATED FORM
    0x0FC3D: ["<isolated>", 0x0643, 0x0649],  # ARABIC LIGATURE KAF WITH ALEF MAKSURA ISOLATED FORM
    0x0FC3E: ["<isolated>", 0x0643, 0x064A],  # ARABIC LIGATURE KAF WITH YEH ISOLATED FORM
    0x0FC3F: ["<isolated>", 0x0644, 0x062C],  # ARABIC LIGATURE LAM WITH JEEM ISOLATED FORM
    0x0FC40: ["<isolated>", 0x0644, 0x062D],  # ARABIC LIGATURE LAM WITH HAH ISOLATED FORM
    0x0FC41: ["<isolated>", 0x0644, 0x062E],  # ARABIC LIGATURE LAM WITH KHAH ISOLATED FORM
    0x0FC42: ["<isolated>", 0x0644, 0x0645],  # ARABIC LIGATURE LAM WITH MEEM ISOLATED FORM
    0x0FC43: ["<isolated>", 0x0644, 0x0649],  # ARABIC LIGATURE LAM WITH ALEF MAKSURA ISOLATED FORM
    0x0FC44: ["<isolated>", 0x0644, 0x064A],  # ARABIC LIGATURE LAM WITH YEH ISOLATED FORM
    0x0FC45: ["<isolated>", 0x0645, 0x062C],  # ARABIC LIGATURE MEEM WITH JEEM ISOLATED FORM
    0x0FC46: ["<isolated>", 0x0645, 0x062D],  # ARABIC LIGATURE MEEM WITH HAH ISOLATED FORM
    0x0FC47: ["<isolated>", 0x0645, 0x062E],  # ARABIC LIGATURE MEEM WITH KHAH ISOLATED FORM
    0x0FC48: ["<isolated>", 0x0645, 0x0645],  # ARABIC LIGATURE MEEM WITH MEEM ISOLATED FORM
    0x0FC49: ["<isolated>", 0x0645, 0x0649],  # ARABIC LIGATURE MEEM WITH ALEF MAKSURA ISOLATED FORM
    0x0FC4A: ["<isolated>", 0x0645, 0x064A],  # ARABIC LIGATURE MEEM WITH YEH ISOLATED FORM
    0x0FC4B: ["<isolated>", 0x0646, 0x062C],  # ARABIC LIGATURE NOON WITH JEEM ISOLATED FORM
    0x0FC4C: ["<isolated>", 0x0646, 0x062D],  # ARABIC LIGATURE NOON WITH HAH ISOLATED FORM
    0x0FC4D: ["<isolated>", 0x0646, 0x062E],  # ARABIC LIGATURE NOON WITH KHAH ISOLATED FORM
    0x0FC4E: ["<isolated>", 0x0646, 0x0645],  # ARABIC LIGATURE NOON WITH MEEM ISOLATED FORM
    0x0FC4F: ["<isolated>", 0x0646, 0x0649],  # ARABIC LIGATURE NOON WITH ALEF MAKSURA ISOLATED FORM
    0x0FC50: ["<isolated>", 0x0646, 0x064A],  # ARABIC LIGATURE NOON WITH YEH ISOLATED FORM
    0x0FC51: ["<isolated>", 0x0647, 0x062C],  # ARABIC LIGATURE HEH WITH JEEM ISOLATED FORM
    0x0FC52: ["<isolated>", 0x0647, 0x0645],  # ARABIC LIGATURE HEH WITH MEEM ISOLATED FORM
    0x0FC53: ["<isolated>", 0x0647, 0x0649],  # ARABIC LIGATURE HEH WITH ALEF MAKSURA ISOLATED FORM
    0x0FC54: ["<isolated>", 0x0647, 0x064A],  # ARABIC LIGATURE HEH WITH YEH ISOLATED FORM
    0x0FC55: ["<isolated>", 0x064A, 0x062C],  # ARABIC LIGATURE YEH WITH JEEM ISOLATED FORM
    0x0FC56: ["<isolated>", 0x064A, 0x062D],  # ARABIC LIGATURE YEH WITH HAH ISOLATED FORM
    0x0FC57: ["<isolated>", 0x064A, 0x062E],  # ARABIC LIGATURE YEH WITH KHAH ISOLATED FORM
    0x0FC58: ["<isolated>", 0x064A, 0x0645],  # ARABIC LIGATURE YEH WITH MEEM ISOLATED FORM
    0x0FC59: ["<isolated>", 0x064A, 0x0649],  # ARABIC LIGATURE YEH WITH ALEF MAKSURA ISOLATED FORM
    0x0FC5A: ["<isolated>", 0x064A, 0x064A],  # ARABIC LIGATURE YEH WITH YEH ISOLATED FORM
    0x0FC5B: ["<isolated>", 0x0630, 0x0670],  # ARABIC LIGATURE THAL WITH SUPERSCRIPT ALEF ISOLATED FORM
    0x0FC5C: ["<isolated>", 0x0631, 0x0670],  # ARABIC LIGATURE REH WITH SUPERSCRIPT ALEF ISOLATED FORM
    0x0FC5D: ["<isolated>", 0x0649, 0x0670],  # ARABIC LIGATURE ALEF MAKSURA WITH SUPERSCRIPT ALEF ISOLATED FORM
    0x0FC5E: ["<isolated>", 0x0020, 0x064C, 0x0651],  # ARABIC LIGATURE SHADDA WITH DAMMATAN ISOLATED FORM
    0x0FC5F: ["<isolated>", 0x0020, 0x064D, 0x0651],  # ARABIC LIGATURE SHADDA WITH KASRATAN ISOLATED FORM
    0x0FC60: ["<isolated>", 0x0020, 0x064E, 0x0651],  # ARABIC LIGATURE SHADDA WITH FATHA ISOLATED FORM
    0x0FC61: ["<isolated>", 0x0020, 0x064F, 0x0651],  # ARABIC LIGATURE SHADDA WITH DAMMA ISOLATED FORM
    0x0FC62: ["<isolated>", 0x0020, 0x0650, 0x0651],  # ARABIC LIGATURE SHADDA WITH KASRA ISOLATED FORM
    0x0FC63: ["<isolated>", 0x0020, 0x0651, 0x0670],  # ARABIC LIGATURE SHADDA WITH SUPERSCRIPT ALEF ISOLATED FORM
    0x0FC64: ["<final>", 0x0626, 0x0631],  # ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH REH FINAL FORM
    0x0FC65: ["<final>", 0x0626, 0x0632],  # ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ZAIN FINAL FORM
    0x0FC66: ["<final>", 0x0626, 0x0645],  # ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM FINAL FORM
    0x0FC67: ["<final>", 0x0626, 0x0646],  # ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH NOON FINAL FORM
    0x0FC68: ["<final>", 0x0626, 0x0649],  # ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF MAKSURA FINAL FORM
    0x0FC69: ["<final>", 0x0626, 0x064A],  # ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YEH FINAL FORM
    0x0FC6A: ["<final>", 0x0628, 0x0631],  # ARABIC LIGATURE BEH WITH REH FINAL FORM
    0x0FC6B: ["<final>", 0x0628, 0x0632],  # ARABIC LIGATURE BEH WITH ZAIN FINAL FORM
    0x0FC6C: ["<final>", 0x0628, 0x0645],  # ARABIC LIGATURE BEH WITH MEEM FINAL FORM
    0x0FC6D: ["<final>", 0x0628, 0x0646],  # ARABIC LIGATURE BEH WITH NOON FINAL FORM
    0x0FC6E: ["<final>", 0x0628, 0x0649],  # ARABIC LIGATURE BEH WITH ALEF MAKSURA FINAL FORM
    0x0FC6F: ["<final>", 0x0628, 0x064A],  # ARABIC LIGATURE BEH WITH YEH FINAL FORM
    0x0FC70: ["<final>", 0x062A, 0x0631],  # ARABIC LIGATURE TEH WITH REH FINAL FORM
    0x0FC71: ["<final>", 0x062A, 0x0632],  # ARABIC LIGATURE TEH WITH ZAIN FINAL FORM
    0x0FC72: ["<final>", 0x062A, 0x0645],  # ARABIC LIGATURE TEH WITH MEEM FINAL FORM
    0x0FC73: ["<final>", 0x062A, 0x0646],  # ARABIC LIGATURE TEH WITH NOON FINAL FORM
    0x0FC74: ["<final>", 0x062A, 0x0649],  # ARABIC LIGATURE TEH WITH ALEF MAKSURA FINAL FORM
    0x0FC75: ["<final>", 0x062A, 0x064A],  # ARABIC LIGATURE TEH WITH YEH FINAL FORM
    0x0FC76: ["<final>", 0x062B, 0x0631],  # ARABIC LIGATURE THEH WITH REH FINAL FORM
    0x0FC77: ["<final>", 0x062B, 0x0632],  # ARABIC LIGATURE THEH WITH ZAIN FINAL FORM
    0x0FC78: ["<final>", 0x062B, 0x0645],  # ARABIC LIGATURE THEH WITH MEEM FINAL FORM
    0x0FC79: ["<final>", 0x062B, 0x0646],  # ARABIC LIGATURE THEH WITH NOON FINAL FORM
    0x0FC7A: ["<final>", 0x062B, 0x0649],  # ARABIC LIGATURE THEH WITH ALEF MAKSURA FINAL FORM
    0x0FC7B: ["<final>", 0x062B, 0x064A],  # ARABIC LIGATURE THEH WITH YEH FINAL FORM
    0x0FC7C: ["<final>", 0x0641, 0x0649],  # ARABIC LIGATURE FEH WITH ALEF MAKSURA FINAL FORM
    0x0FC7D: ["<final>", 0x0641, 0x064A],  # ARABIC LIGATURE FEH WITH YEH FINAL FORM
    0x0FC7E: ["<final>", 0x0642, 0x0649],  # ARABIC LIGATURE QAF WITH ALEF MAKSURA FINAL FORM
    0x0FC7F: ["<final>", 0x0642, 0x064A],  # ARABIC LIGATURE QAF WITH YEH FINAL FORM
    0x0FC80: ["<final>", 0x0643, 0x0627],  # ARABIC LIGATURE KAF WITH ALEF FINAL FORM
    0x0FC81: ["<final>", 0x0643, 0x0644],  # ARABIC LIGATURE KAF WITH LAM FINAL FORM
    0x0FC82: ["<final>", 0x0643, 0x0645],  # ARABIC LIGATURE KAF WITH MEEM FINAL FORM
    0x0FC83: ["<final>", 0x0643, 0x0649],  # ARABIC LIGATURE KAF WITH ALEF MAKSURA FINAL FORM
    0x0FC84: ["<final>", 0x0643, 0x064A],  # ARABIC LIGATURE KAF WITH YEH FINAL FORM
    0x0FC85: ["<final>", 0x0644, 0x0645],  # ARABIC LIGATURE LAM WITH MEEM FINAL FORM
    0x0FC86: ["<final>", 0x0644, 0x0649],  # ARABIC LIGATURE LAM WITH ALEF MAKSURA FINAL FORM
    0x0FC87: ["<final>", 0x0644, 0x064A],  # ARABIC LIGATURE LAM WITH YEH FINAL FORM
    0x0FC88: ["<final>", 0x0645, 0x0627],  # ARABIC LIGATURE MEEM WITH ALEF FINAL FORM
    0x0FC89: ["<final>", 0x0645, 0x0645],  # ARABIC LIGATURE MEEM WITH MEEM FINAL FORM
    0x0FC8A: ["<final>", 0x0646, 0x0631],  # ARABIC LIGATURE NOON WITH REH FINAL FORM
    0x0FC8B: ["<final>", 0x0646, 0x0632],  # ARABIC LIGATURE NOON WITH ZAIN FINAL FORM
    0x0FC8C: ["<final>", 0x0646, 0x0645],  # ARABIC LIGATURE NOON WITH MEEM FINAL FORM
    0x0FC8D: ["<final>", 0x0646, 0x0646],  # ARABIC LIGATURE NOON WITH NOON FINAL FORM
    0x0FC8E: ["<final>", 0x0646, 0x0649],  # ARABIC LIGATURE NOON WITH ALEF MAKSURA FINAL FORM
    0x0FC8F: ["<final>", 0x0646, 0x064A],  # ARABIC LIGATURE NOON WITH YEH FINAL FORM
    0x0FC90: ["<final>", 0x0649, 0x0670],  # ARABIC LIGATURE ALEF MAKSURA WITH SUPERSCRIPT ALEF FINAL FORM
    0x0FC91: ["<final>", 0x064A, 0x0631],  # ARABIC LIGATURE YEH WITH REH FINAL FORM
    0x0FC92: ["<final>", 0x064A, 0x0632],  # ARABIC LIGATURE YEH WITH ZAIN FINAL FORM
    0x0FC93: ["<final>", 0x064A, 0x0645],  # ARABIC LIGATURE YEH WITH MEEM FINAL FORM
    0x0FC94: ["<final>", 0x064A, 0x0646],  # ARABIC LIGATURE YEH WITH NOON FINAL FORM
    0x0FC95: ["<final>", 0x064A, 0x0649],  # ARABIC LIGATURE YEH WITH ALEF MAKSURA FINAL FORM
    0x0FC96: ["<final>", 0x064A, 0x064A],  # ARABIC LIGATURE YEH WITH YEH FINAL FORM
    0x0FC97: ["<initial>", 0x0626, 0x062C],  # ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH JEEM INITIAL FORM
    0x0FC98: ["<initial>", 0x0626, 0x062D],  # ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HAH INITIAL FORM
    0x0FC99: ["<initial>", 0x0626, 0x062E],  # ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH KHAH INITIAL FORM
    0x0FC9A: ["<initial>", 0x0626, 0x0645],  # ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM INITIAL FORM
    0x0FC9B: ["<initial>", 0x0626, 0x0647],  # ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HEH INITIAL FORM
    0x0FC9C: ["<initial>", 0x0628, 0x062C],  # ARABIC LIGATURE BEH WITH JEEM INITIAL FORM
    0x0FC9D: ["<initial>", 0x0628, 0x062D],  # ARABIC LIGATURE BEH WITH HAH INITIAL FORM
    0x0FC9E: ["<initial>", 0x0628, 0x062E],  # ARABIC LIGATURE BEH WITH KHAH INITIAL FORM
    0x0FC9F: ["<initial>", 0x0628, 0x0645],  # ARABIC LIGATURE BEH WITH MEEM INITIAL FORM
    0x0FCA0: ["<initial>", 0x0628, 0x0647],  # ARABIC LIGATURE BEH WITH HEH INITIAL FORM
    0x0FCA1: ["<initial>", 0x062A, 0x062C],  # ARABIC LIGATURE TEH WITH JEEM INITIAL FORM
    0x0FCA2: ["<initial>", 0x062A, 0x062D],  # ARABIC LIGATURE TEH WITH HAH INITIAL FORM
    0x0FCA3: ["<initial>", 0x062A, 0x062E],  # ARABIC LIGATURE TEH WITH KHAH INITIAL FORM
    0x0FCA4: ["<initial>", 0x062A, 0x0645],  # ARABIC LIGATURE TEH WITH MEEM INITIAL FORM
    0x0FCA5: ["<initial>", 0x062A, 0x0647],  # ARABIC LIGATURE TEH WITH HEH INITIAL FORM
    0x0FCA6: ["<initial>", 0x062B, 0x0645],  # ARABIC LIGATURE THEH WITH MEEM INITIAL FORM
    0x0FCA7: ["<initial>", 0x062C, 0x062D],  # ARABIC LIGATURE JEEM WITH HAH INITIAL FORM
    0x0FCA8: ["<initial>", 0x062C, 0x0645],  # ARABIC LIGATURE JEEM WITH MEEM INITIAL FORM
    0x0FCA9: ["<initial>", 0x062D, 0x062C],  # ARABIC LIGATURE HAH WITH JEEM INITIAL FORM
    0x0FCAA: ["<initial>", 0x062D, 0x0645],  # ARABIC LIGATURE HAH WITH MEEM INITIAL FORM
    0x0FCAB: ["<initial>", 0x062E, 0x062C],  # ARABIC LIGATURE KHAH WITH JEEM INITIAL FORM
    0x0FCAC: ["<initial>", 0x062E, 0x0645],  # ARABIC LIGATURE KHAH WITH MEEM INITIAL FORM
    0x0FCAD: ["<initial>", 0x0633, 0x062C],  # ARABIC LIGATURE SEEN WITH JEEM INITIAL FORM
    0x0FCAE: ["<initial>", 0x0633, 0x062D],  # ARABIC LIGATURE SEEN WITH HAH INITIAL FORM
    0x0FCAF: ["<initial>", 0x0633, 0x062E],  # ARABIC LIGATURE SEEN WITH KHAH INITIAL FORM
    0x0FCB0: ["<initial>", 0x0633, 0x0645],  # ARABIC LIGATURE SEEN WITH MEEM INITIAL FORM
    0x0FCB1: ["<initial>", 0x0635, 0x062D],  # ARABIC LIGATURE SAD WITH HAH INITIAL FORM
    0x0FCB2: ["<initial>", 0x0635, 0x062E],  # ARABIC LIGATURE SAD WITH KHAH INITIAL FORM
    0x0FCB3: ["<initial>", 0x0635, 0x0645],  # ARABIC LIGATURE SAD WITH MEEM INITIAL FORM
    0x0FCB4: ["<initial>", 0x0636, 0x062C],  # ARABIC LIGATURE DAD WITH JEEM INITIAL FORM
    0x0FCB5: ["<initial>", 0x0636, 0x062D],  # ARABIC LIGATURE DAD WITH HAH INITIAL FORM
    0x0FCB6: ["<initial>", 0x0636, 0x062E],  # ARABIC LIGATURE DAD WITH KHAH INITIAL FORM
    0x0FCB7: ["<initial>", 0x0636, 0x0645],  # ARABIC LIGATURE DAD WITH MEEM INITIAL FORM
    0x0FCB8: ["<initial>", 0x0637, 0x062D],  # ARABIC LIGATURE TAH WITH HAH INITIAL FORM
    0x0FCB9: ["<initial>", 0x0638, 0x0645],  # ARABIC LIGATURE ZAH WITH MEEM INITIAL FORM
    0x0FCBA: ["<initial>", 0x0639, 0x062C],  # ARABIC LIGATURE AIN WITH JEEM INITIAL FORM
    0x0FCBB: ["<initial>", 0x0639, 0x0645],  # ARABIC LIGATURE AIN WITH MEEM INITIAL FORM
    0x0FCBC: ["<initial>", 0x063A, 0x062C],  # ARABIC LIGATURE GHAIN WITH JEEM INITIAL FORM
    0x0FCBD: ["<initial>", 0x063A, 0x0645],  # ARABIC LIGATURE GHAIN WITH MEEM INITIAL FORM
    0x0FCBE: ["<initial>", 0x0641, 0x062C],  # ARABIC LIGATURE FEH WITH JEEM INITIAL FORM
    0x0FCBF: ["<initial>", 0x0641, 0x062D],  # ARABIC LIGATURE FEH WITH HAH INITIAL FORM
    0x0FCC0: ["<initial>", 0x0641, 0x062E],  # ARABIC LIGATURE FEH WITH KHAH INITIAL FORM
    0x0FCC1: ["<initial>", 0x0641, 0x0645],  # ARABIC LIGATURE FEH WITH MEEM INITIAL FORM
    0x0FCC2: ["<initial>", 0x0642, 0x062D],  # ARABIC LIGATURE QAF WITH HAH INITIAL FORM
    0x0FCC3: ["<initial>", 0x0642, 0x0645],  # ARABIC LIGATURE QAF WITH MEEM INITIAL FORM
    0x0FCC4: ["<initial>", 0x0643, 0x062C],  # ARABIC LIGATURE KAF WITH JEEM INITIAL FORM
    0x0FCC5: ["<initial>", 0x0643, 0x062D],  # ARABIC LIGATURE KAF WITH HAH INITIAL FORM
    0x0FCC6: ["<initial>", 0x0643, 0x062E],  # ARABIC LIGATURE KAF WITH KHAH INITIAL FORM
    0x0FCC7: ["<initial>", 0x0643, 0x0644],  # ARABIC LIGATURE KAF WITH LAM INITIAL FORM
    0x0FCC8: ["<initial>", 0x0643, 0x0645],  # ARABIC LIGATURE KAF WITH MEEM INITIAL FORM
    0x0FCC9: ["<initial>", 0x0644, 0x062C],  # ARABIC LIGATURE LAM WITH JEEM INITIAL FORM
    0x0FCCA: ["<initial>", 0x0644, 0x062D],  # ARABIC LIGATURE LAM WITH HAH INITIAL FORM
    0x0FCCB: ["<initial>", 0x0644, 0x062E],  # ARABIC LIGATURE LAM WITH KHAH INITIAL FORM
    0x0FCCC: ["<initial>", 0x0644, 0x0645],  # ARABIC LIGATURE LAM WITH MEEM INITIAL FORM
    0x0FCCD: ["<initial>", 0x0644, 0x0647],  # ARABIC LIGATURE LAM WITH HEH INITIAL FORM
    0x0FCCE: ["<initial>", 0x0645, 0x062C],  # ARABIC LIGATURE MEEM WITH JEEM INITIAL FORM
    0x0FCCF: ["<initial>", 0x0645, 0x062D],  # ARABIC LIGATURE MEEM WITH HAH INITIAL FORM
    0x0FCD0: ["<initial>", 0x0645, 0x062E],  # ARABIC LIGATURE MEEM WITH KHAH INITIAL FORM
    0x0FCD1: ["<initial>", 0x0645, 0x0645],  # ARABIC LIGATURE MEEM WITH MEEM INITIAL FORM
    0x0FCD2: ["<initial>", 0x0646, 0x062C],  # ARABIC LIGATURE NOON WITH JEEM INITIAL FORM
    0x0FCD3: ["<initial>", 0x0646, 0x062D],  # ARABIC LIGATURE NOON WITH HAH INITIAL FORM
    0x0FCD4: ["<initial>", 0x0646, 0x062E],  # ARABIC LIGATURE NOON WITH KHAH INITIAL FORM
    0x0FCD5: ["<initial>", 0x0646, 0x0645],  # ARABIC LIGATURE NOON WITH MEEM INITIAL FORM
    0x0FCD6: ["<initial>", 0x0646, 0x0647],  # ARABIC LIGATURE NOON WITH HEH INITIAL FORM
    0x0FCD7: ["<initial>", 0x0647, 0x062C],  # ARABIC LIGATURE HEH WITH JEEM INITIAL FORM
    0x0FCD8: ["<initial>", 0x0647, 0x0645],  # ARABIC LIGATURE HEH WITH MEEM INITIAL FORM
    0x0FCD9: ["<initial>", 0x0647, 0x0670],  # ARABIC LIGATURE HEH WITH SUPERSCRIPT ALEF INITIAL FORM
    0x0FCDA: ["<initial>", 0x064A, 0x062C],  # ARABIC LIGATURE YEH WITH JEEM INITIAL FORM
    0x0FCDB: ["<initial>", 0x064A, 0x062D],  # ARABIC LIGATURE YEH WITH HAH INITIAL FORM
    0x0FCDC: ["<initial>", 0x064A, 0x062E],  # ARABIC LIGATURE YEH WITH KHAH INITIAL FORM
    0x0FCDD: ["<initial>", 0x064A, 0x0645],  # ARABIC LIGATURE YEH WITH MEEM INITIAL FORM
    0x0FCDE: ["<initial>", 0x064A, 0x0647],  # ARABIC LIGATURE YEH WITH HEH INITIAL FORM
    0x0FCDF: ["<medial>", 0x0626, 0x0645],  # ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM MEDIAL FORM
    0x0FCE0: ["<medial>", 0x0626, 0x0647],  # ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HEH MEDIAL FORM
    0x0FCE1: ["<medial>", 0x0628, 0x0645],  # ARABIC LIGATURE BEH WITH MEEM MEDIAL FORM
    0x0FCE2: ["<medial>", 0x0628, 0x0647],  # ARABIC LIGATURE BEH WITH HEH MEDIAL FORM
    0x0FCE3: ["<medial>", 0x062A, 0x0645],  # ARABIC LIGATURE TEH WITH MEEM MEDIAL FORM
    0x0FCE4: ["<medial>", 0x062A, 0x0647],  # ARABIC LIGATURE TEH WITH HEH MEDIAL FORM
    0x0FCE5: ["<medial>", 0x062B, 0x0645],  # ARABIC LIGATURE THEH WITH MEEM MEDIAL FORM
    0x0FCE6: ["<medial>", 0x062B, 0x0647],  # ARABIC LIGATURE THEH WITH HEH MEDIAL FORM
    0x0FCE7: ["<medial>", 0x0633, 0x0645],  # ARABIC LIGATURE SEEN WITH MEEM MEDIAL FORM
    0x0FCE8: ["<medial>", 0x0633, 0x0647],  # ARABIC LIGATURE SEEN WITH HEH MEDIAL FORM
    0x0FCE9: ["<medial>", 0x0634, 0x0645],  # ARABIC LIGATURE SHEEN WITH MEEM MEDIAL FORM
    0x0FCEA: ["<medial>", 0x0634, 0x0647],  # ARABIC LIGATURE SHEEN WITH HEH MEDIAL FORM
    0x0FCEB: ["<medial>", 0x0643, 0x0644],  # ARABIC LIGATURE KAF WITH LAM MEDIAL FORM
    0x0FCEC: ["<medial>", 0x0643, 0x0645],  # ARABIC LIGATURE KAF WITH MEEM MEDIAL FORM
    0x0FCED: ["<medial>", 0x0644, 0x0645],  # ARABIC LIGATURE LAM WITH MEEM MEDIAL FORM
    0x0FCEE: ["<medial>", 0x0646, 0x0645],  # ARABIC LIGATURE NOON WITH MEEM MEDIAL FORM
    0x0FCEF: ["<medial>", 0x0646, 0x0647],  # ARABIC LIGATURE NOON WITH HEH MEDIAL FORM
    0x0FCF0: ["<medial>", 0x064A, 0x0645],  # ARABIC LIGATURE YEH WITH MEEM MEDIAL FORM
    0x0FCF1: ["<medial>", 0x064A, 0x0647],  # ARABIC LIGATURE YEH WITH HEH MEDIAL FORM
    0x0FCF2: ["<medial>", 0x0640, 0x064E, 0x0651],  # ARABIC LIGATURE SHADDA WITH FATHA MEDIAL FORM
    0x0FCF3: ["<medial>", 0x0640, 0x064F, 0x0651],  # ARABIC LIGATURE SHADDA WITH DAMMA MEDIAL FORM
    0x0FCF4: ["<medial>", 0x0640, 0x0650, 0x0651],  # ARABIC LIGATURE SHADDA WITH KASRA MEDIAL FORM
    0x0FCF5: ["<isolated>", 0x0637, 0x0649],  # ARABIC LIGATURE TAH WITH ALEF MAKSURA ISOLATED FORM
    0x0FCF6: ["<isolated>", 0x0637, 0x064A],  # ARABIC LIGATURE TAH WITH YEH ISOLATED FORM
    0x0FCF7: ["<isolated>", 0x0639, 0x0649],  # ARABIC LIGATURE AIN WITH ALEF MAKSURA ISOLATED FORM
    0x0FCF8: ["<isolated>", 0x0639, 0x064A],  # ARABIC LIGATURE AIN WITH YEH ISOLATED FORM
    0x0FCF9: ["<isolated>", 0x063A, 0x0649],  # ARABIC LIGATURE GHAIN WITH ALEF MAKSURA ISOLATED FORM
    0x0FCFA: ["<isolated>", 0x063A, 0x064A],  # ARABIC LIGATURE GHAIN WITH YEH ISOLATED FORM
    0x0FCFB: ["<isolated>", 0x0633, 0x0649],  # ARABIC LIGATURE SEEN WITH ALEF MAKSURA ISOLATED FORM
    0x0FCFC: ["<isolated>", 0x0633, 0x064A],  # ARABIC LIGATURE SEEN WITH YEH ISOLATED FORM
    0x0FCFD: ["<isolated>", 0x0634, 0x0649],  # ARABIC LIGATURE SHEEN WITH ALEF MAKSURA ISOLATED FORM
    0x0FCFE: ["<isolated>", 0x0634, 0x064A],  # ARABIC LIGATURE SHEEN WITH YEH ISOLATED FORM
    0x0FCFF: ["<isolated>", 0x062D, 0x0649],  # ARABIC LIGATURE HAH WITH ALEF MAKSURA ISOLATED FORM
    0x0FD00: ["<isolated>", 0x062D, 0x064A],  # ARABIC LIGATURE HAH WITH YEH ISOLATED FORM
    0x0FD01: ["<isolated>", 0x062C, 0x0649],  # ARABIC LIGATURE JEEM WITH ALEF MAKSURA ISOLATED FORM
    0x0FD02: ["<isolated>", 0x062C, 0x064A],  # ARABIC LIGATURE JEEM WITH YEH ISOLATED FORM
    0x0FD03: ["<isolated>", 0x062E, 0x0649],  # ARABIC LIGATURE KHAH WITH ALEF MAKSURA ISOLATED FORM
    0x0FD04: ["<isolated>", 0x062E, 0x064A],  # ARABIC LIGATURE KHAH WITH YEH ISOLATED FORM
    0x0FD05: ["<isolated>", 0x0635, 0x0649],  # ARABIC LIGATURE SAD WITH ALEF MAKSURA ISOLATED FORM
    0x0FD06: ["<isolated>", 0x0635, 0x064A],  # ARABIC LIGATURE SAD WITH YEH ISOLATED FORM
    0x0FD07: ["<isolated>", 0x0636, 0x0649],  # ARABIC LIGATURE DAD WITH ALEF MAKSURA ISOLATED FORM
    0x0FD08: ["<isolated>", 0x0636, 0x064A],  # ARABIC LIGATURE DAD WITH YEH ISOLATED FORM
    0x0FD09: ["<isolated>", 0x0634, 0x062C],  # ARABIC LIGATURE SHEEN WITH JEEM ISOLATED FORM
    0x0FD0A: ["<isolated>", 0x0634, 0x062D],  # ARABIC LIGATURE SHEEN WITH HAH ISOLATED FORM
    0x0FD0B: ["<isolated>", 0x0634, 0x062E],  # ARABIC LIGATURE SHEEN WITH KHAH ISOLATED FORM
    0x0FD0C: ["<isolated>", 0x0634, 0x0645],  # ARABIC LIGATURE SHEEN WITH MEEM ISOLATED FORM
    0x0FD0D: ["<isolated>", 0x0634, 0x0631],  # ARABIC LIGATURE SHEEN WITH REH ISOLATED FORM
    0x0FD0E: ["<isolated>", 0x0633, 0x0631],  # ARABIC LIGATURE SEEN WITH REH ISOLATED FORM
    0x0FD0F: ["<isolated>", 0x0635, 0x0631],  # ARABIC LIGATURE SAD WITH REH ISOLATED FORM
    0x0FD10: ["<isolated>", 0x0636, 0x0631],  # ARABIC LIGATURE DAD WITH REH ISOLATED FORM
    0x0FD11: ["<final>", 0x0637, 0x0649],  # ARABIC LIGATURE TAH WITH ALEF MAKSURA FINAL FORM
    0x0FD12: ["<final>", 0x0637, 0x064A],  # ARABIC LIGATURE TAH WITH YEH FINAL FORM
    0x0FD13: ["<final>", 0x0639, 0x0649],  # ARABIC LIGATURE AIN WITH ALEF MAKSURA FINAL FORM
    0x0FD14: ["<final>", 0x0639, 0x064A],  # ARABIC LIGATURE AIN WITH YEH FINAL FORM
    0x0FD15: ["<final>", 0x063A, 0x0649],  # ARABIC LIGATURE GHAIN WITH ALEF MAKSURA FINAL FORM
    0x0FD16: ["<final>", 0x063A, 0x064A],  # ARABIC LIGATURE GHAIN WITH YEH FINAL FORM
    0x0FD17: ["<final>", 0x0633, 0x0649],  # ARABIC LIGATURE SEEN WITH ALEF MAKSURA FINAL FORM
    0x0FD18: ["<final>", 0x0633, 0x064A],  # ARABIC LIGATURE SEEN WITH YEH FINAL FORM
    0x0FD19: ["<final>", 0x0634, 0x0649],  # ARABIC LIGATURE SHEEN WITH ALEF MAKSURA FINAL FORM
    0x0FD1A: ["<final>", 0x0634, 0x064A],  # ARABIC LIGATURE SHEEN WITH YEH FINAL FORM
    0x0FD1B: ["<final>", 0x062D, 0x0649],  # ARABIC LIGATURE HAH WITH ALEF MAKSURA FINAL FORM
    0x0FD1C: ["<final>", 0x062D, 0x064A],  # ARABIC LIGATURE HAH WITH YEH FINAL FORM
    0x0FD1D: ["<final>", 0x062C, 0x0649],  # ARABIC LIGATURE JEEM WITH ALEF MAKSURA FINAL FORM
    0x0FD1E: ["<final>", 0x062C, 0x064A],  # ARABIC LIGATURE JEEM WITH YEH FINAL FORM
    0x0FD1F: ["<final>", 0x062E, 0x0649],  # ARABIC LIGATURE KHAH WITH ALEF MAKSURA FINAL FORM
    0x0FD20: ["<final>", 0x062E, 0x064A],  # ARABIC LIGATURE KHAH WITH YEH FINAL FORM
    0x0FD21: ["<final>", 0x0635, 0x0649],  # ARABIC LIGATURE SAD WITH ALEF MAKSURA FINAL FORM
    0x0FD22: ["<final>", 0x0635, 0x064A],  # ARABIC LIGATURE SAD WITH YEH FINAL FORM
    0x0FD23: ["<final>", 0x0636, 0x0649],  # ARABIC LIGATURE DAD WITH ALEF MAKSURA FINAL FORM
    0x0FD24: ["<final>", 0x0636, 0x064A],  # ARABIC LIGATURE DAD WITH YEH FINAL FORM
    0x0FD25: ["<final>", 0x0634, 0x062C],  # ARABIC LIGATURE SHEEN WITH JEEM FINAL FORM
    0x0FD26: ["<final>", 0x0634, 0x062D],  # ARABIC LIGATURE SHEEN WITH HAH FINAL FORM
    0x0FD27: ["<final>", 0x0634, 0x062E],  # ARABIC LIGATURE SHEEN WITH KHAH FINAL FORM
    0x0FD28: ["<final>", 0x0634, 0x0645],  # ARABIC LIGATURE SHEEN WITH MEEM FINAL FORM
    0x0FD29: ["<final>", 0x0634, 0x0631],  # ARABIC LIGATURE SHEEN WITH REH FINAL FORM
    0x0FD2A: ["<final>", 0x0633, 0x0631],  # ARABIC LIGATURE SEEN WITH REH FINAL FORM
    0x0FD2B: ["<final>", 0x0635, 0x0631],  # ARABIC LIGATURE SAD WITH REH FINAL FORM
    0x0FD2C: ["<final>", 0x0636, 0x0631],  # ARABIC LIGATURE DAD WITH REH FINAL FORM
    0x0FD2D: ["<initial>", 0x0634, 0x062C],  # ARABIC LIGATURE SHEEN WITH JEEM INITIAL FORM
    0x0FD2E: ["<initial>", 0x0634, 0x062D],  # ARABIC LIGATURE SHEEN WITH HAH INITIAL FORM
    0x0FD2F: ["<initial>", 0x0634, 0x062E],  # ARABIC LIGATURE SHEEN WITH KHAH INITIAL FORM
    0x0FD30: ["<initial>", 0x0634, 0x0645],  # ARABIC LIGATURE SHEEN WITH MEEM INITIAL FORM
    0x0FD31: ["<initial>", 0x0633, 0x0647],  # ARABIC LIGATURE SEEN WITH HEH INITIAL FORM
    0x0FD32: ["<initial>", 0x0634, 0x0647],  # ARABIC LIGATURE SHEEN WITH HEH INITIAL FORM
    0x0FD33: ["<initial>", 0x0637, 0x0645],  # ARABIC LIGATURE TAH WITH MEEM INITIAL FORM
    0x0FD34: ["<medial>", 0x0633, 0x062C],  # ARABIC LIGATURE SEEN WITH JEEM MEDIAL FORM
    0x0FD35: ["<medial>", 0x0633, 0x062D],  # ARABIC LIGATURE SEEN WITH HAH MEDIAL FORM
    0x0FD36: ["<medial>", 0x0633, 0x062E],  # ARABIC LIGATURE SEEN WITH KHAH MEDIAL FORM
    0x0FD37: ["<medial>", 0x0634, 0x062C],  # ARABIC LIGATURE SHEEN WITH JEEM MEDIAL FORM
    0x0FD38: ["<medial>", 0x0634, 0x062D],  # ARABIC LIGATURE SHEEN WITH HAH MEDIAL FORM
    0x0FD39: ["<medial>", 0x0634, 0x062E],  # ARABIC LIGATURE SHEEN WITH KHAH MEDIAL FORM
    0x0FD3A: ["<medial>", 0x0637, 0x0645],  # ARABIC LIGATURE TAH WITH MEEM MEDIAL FORM
    0x0FD3B: ["<medial>", 0x0638, 0x0645],  # ARABIC LIGATURE ZAH WITH MEEM MEDIAL FORM
    0x0FD3C: ["<final>", 0x0627, 0x064B],  # ARABIC LIGATURE ALEF WITH FATHATAN FINAL FORM
    0x0FD3D: ["<isolated>", 0x0627, 0x064B],  # ARABIC LIGATURE ALEF WITH FATHATAN ISOLATED FORM
    0x0FD50: ["<initial>", 0x062A, 0x062C, 0x0645],  # ARABIC LIGATURE TEH WITH JEEM WITH MEEM INITIAL FORM
    0x0FD51: ["<final>", 0x062A, 0x062D, 0x062C],  # ARABIC LIGATURE TEH WITH HAH WITH JEEM FINAL FORM
    0x0FD52: ["<initial>", 0x062A, 0x062D, 0x062C],  # ARABIC LIGATURE TEH WITH HAH WITH JEEM INITIAL FORM
    0x0FD53: ["<initial>", 0x062A, 0x062D, 0x0645],  # ARABIC LIGATURE TEH WITH HAH WITH MEEM INITIAL FORM
    0x0FD54: ["<initial>", 0x062A, 0x062E, 0x0645],  # ARABIC LIGATURE TEH WITH KHAH WITH MEEM INITIAL FORM
    0x0FD55: ["<initial>", 0x062A, 0x0645, 0x062C],  # ARABIC LIGATURE TEH WITH MEEM WITH JEEM INITIAL FORM
    0x0FD56: ["<initial>", 0x062A, 0x0645, 0x062D],  # ARABIC LIGATURE TEH WITH MEEM WITH HAH INITIAL FORM
    0x0FD57: ["<initial>", 0x062A, 0x0645, 0x062E],  # ARABIC LIGATURE TEH WITH MEEM WITH KHAH INITIAL FORM
    0x0FD58: ["<final>", 0x062C, 0x0645, 0x062D],  # ARABIC LIGATURE JEEM WITH MEEM WITH HAH FINAL FORM
    0x0FD59: ["<initial>", 0x062C, 0x0645, 0x062D],  # ARABIC LIGATURE JEEM WITH MEEM WITH HAH INITIAL FORM
    0x0FD5A: ["<final>", 0x062D, 0x0645, 0x064A],  # ARABIC LIGATURE HAH WITH MEEM WITH YEH FINAL FORM
    0x0FD5B: ["<final>", 0x062D, 0x0645, 0x0649],  # ARABIC LIGATURE HAH WITH MEEM WITH ALEF MAKSURA FINAL FORM
    0x0FD5C: ["<initial>", 0x0633, 0x062D, 0x062C],  # ARABIC LIGATURE SEEN WITH HAH WITH JEEM INITIAL FORM
    0x0FD5D: ["<initial>", 0x0633, 0x062C, 0x062D],  # ARABIC LIGATURE SEEN WITH JEEM WITH HAH INITIAL FORM
    0x0FD5E: ["<final>", 0x0633, 0x062C, 0x0649],  # ARABIC LIGATURE SEEN WITH JEEM WITH ALEF MAKSURA FINAL FORM
    0x0FD5F: ["<final>", 0x0633, 0x0645, 0x062D],  # ARABIC LIGATURE SEEN WITH MEEM WITH HAH FINAL FORM
    0x0FD60: ["<initial>", 0x0633, 0x0645, 0x062D],  # ARABIC LIGATURE SEEN WITH MEEM WITH HAH INITIAL FORM
    0x0FD61: ["<initial>", 0x0633, 0x0645, 0x062C],  # ARABIC LIGATURE SEEN WITH MEEM WITH JEEM INITIAL FORM
    0x0FD62: ["<final>", 0x0633, 0x0645, 0x0645],  # ARABIC LIGATURE SEEN WITH MEEM WITH MEEM FINAL FORM
    0x0FD63: ["<initial>", 0x0633, 0x0645, 0x0645],  # ARABIC LIGATURE SEEN WITH MEEM WITH MEEM INITIAL FORM
    0x0FD64: ["<final>", 0x0635, 0x062D, 0x062D],  # ARABIC LIGATURE SAD WITH HAH WITH HAH FINAL FORM
    0x0FD65: ["<initial>", 0x0635, 0x062D, 0x062D],  # ARABIC LIGATURE SAD WITH HAH WITH HAH INITIAL FORM
    0x0FD66: ["<final>", 0x0635, 0x0645, 0x0645],  # ARABIC LIGATURE SAD WITH MEEM WITH MEEM FINAL FORM
    0x0FD67: ["<final>", 0x0634, 0x062D, 0x0645],  # ARABIC LIGATURE SHEEN WITH HAH WITH MEEM FINAL FORM
    0x0FD68: ["<initial>", 0x0634, 0x062D, 0x0645],  # ARABIC LIGATURE SHEEN WITH HAH WITH MEEM INITIAL FORM
    0x0FD69: ["<final>", 0x0634, 0x062C, 0x064A],  # ARABIC LIGATURE SHEEN WITH JEEM WITH YEH FINAL FORM
    0x0FD6A: ["<final>", 0x0634, 0x0645, 0x062E],  # ARABIC LIGATURE SHEEN WITH MEEM WITH KHAH FINAL FORM
    0x0FD6B: ["<initial>", 0x0634, 0x0645, 0x062E],  # ARABIC LIGATURE SHEEN WITH MEEM WITH KHAH INITIAL FORM
    0x0FD6C: ["<final>", 0x0634, 0x0645, 0x0645],  # ARABIC LIGATURE SHEEN WITH MEEM WITH MEEM FINAL FORM
    0x0FD6D: ["<initial>", 0x0634, 0x0645, 0x0645],  # ARABIC LIGATURE SHEEN WITH MEEM WITH MEEM INITIAL FORM
    0x0FD6E: ["<final>", 0x0636, 0x062D, 0x0649],  # ARABIC LIGATURE DAD WITH HAH WITH ALEF MAKSURA FINAL FORM
    0x0FD6F: ["<final>", 0x0636, 0x062E, 0x0645],  # ARABIC LIGATURE DAD WITH KHAH WITH MEEM FINAL FORM
    0x0FD70: ["<initial>", 0x0636, 0x062E, 0x0645],  # ARABIC LIGATURE DAD WITH KHAH WITH MEEM INITIAL FORM
    0x0FD71: ["<final>", 0x0637, 0x0645, 0x062D],  # ARABIC LIGATURE TAH WITH MEEM WITH HAH FINAL FORM
    0x0FD72: ["<initial>", 0x0637, 0x0645, 0x062D],  # ARABIC LIGATURE TAH WITH MEEM WITH HAH INITIAL FORM
    0x0FD73: ["<initial>", 0x0637, 0x0645, 0x0645],  # ARABIC LIGATURE TAH WITH MEEM WITH MEEM INITIAL FORM
    0x0FD74: ["<final>", 0x0637, 0x0645, 0x064A],  # ARABIC LIGATURE TAH WITH MEEM WITH YEH FINAL FORM
    0x0FD75: ["<final>", 0x0639, 0x062C, 0x0645],  # ARABIC LIGATURE AIN WITH JEEM WITH MEEM FINAL FORM
    0x0FD76: ["<final>", 0x0639, 0x0645, 0x0645],  # ARABIC LIGATURE AIN WITH MEEM WITH MEEM FINAL FORM
    0x0FD77: ["<initial>", 0x0639, 0x0645, 0x0645],  # ARABIC LIGATURE AIN WITH MEEM WITH MEEM INITIAL FORM
    0x0FD78: ["<final>", 0x0639, 0x0645, 0x0649],  # ARABIC LIGATURE AIN WITH MEEM WITH ALEF MAKSURA FINAL FORM
    0x0FD79: ["<final>", 0x063A, 0x0645, 0x0645],  # ARABIC LIGATURE GHAIN WITH MEEM WITH MEEM FINAL FORM
    0x0FD7A: ["<final>", 0x063A, 0x0645, 0x064A],  # ARABIC LIGATURE GHAIN WITH MEEM WITH YEH FINAL FORM
    0x0FD7B: ["<final>", 0x063A, 0x0645, 0x0649],  # ARABIC LIGATURE GHAIN WITH MEEM WITH ALEF MAKSURA FINAL FORM
    0x0FD7C: ["<final>", 0x0641, 0x062E, 0x0645],  # ARABIC LIGATURE FEH WITH KHAH WITH MEEM FINAL FORM
    0x0FD7D: ["<initial>", 0x0641, 0x062E, 0x0645],  # ARABIC LIGATURE FEH WITH KHAH WITH MEEM INITIAL FORM
    0x0FD7E: ["<final>", 0x0642, 0x0645, 0x062D],  # ARABIC LIGATURE QAF WITH MEEM WITH HAH FINAL FORM
    0x0FD7F: ["<final>", 0x0642, 0x0645, 0x0645],  # ARABIC LIGATURE QAF WITH MEEM WITH MEEM FINAL FORM
    0x0FD80: ["<final>", 0x0644, 0x062D, 0x0645],  # ARABIC LIGATURE LAM WITH HAH WITH MEEM FINAL FORM
    0x0FD81: ["<final>", 0x0644, 0x062D, 0x064A],  # ARABIC LIGATURE LAM WITH HAH WITH YEH FINAL FORM
    0x0FD82: ["<final>", 0x0644, 0x062D, 0x0649],  # ARABIC LIGATURE LAM WITH HAH WITH ALEF MAKSURA FINAL FORM
    0x0FD83: ["<initial>", 0x0644, 0x062C, 0x062C],  # ARABIC LIGATURE LAM WITH JEEM WITH JEEM INITIAL FORM
    0x0FD84: ["<final>", 0x0644, 0x062C, 0x062C],  # ARABIC LIGATURE LAM WITH JEEM WITH JEEM FINAL FORM
    0x0FD85: ["<final>", 0x0644, 0x062E, 0x0645],  # ARABIC LIGATURE LAM WITH KHAH WITH MEEM FINAL FORM
    0x0FD86: ["<initial>", 0x0644, 0x062E, 0x0645],  # ARABIC LIGATURE LAM WITH KHAH WITH MEEM INITIAL FORM
    0x0FD87: ["<final>", 0x0644, 0x0645, 0x062D],  # ARABIC LIGATURE LAM WITH MEEM WITH HAH FINAL FORM
    0x0FD88: ["<initial>", 0x0644, 0x0645, 0x062D],  # ARABIC LIGATURE LAM WITH MEEM WITH HAH INITIAL FORM
    0x0FD89: ["<initial>", 0x0645, 0x062D, 0x062C],  # ARABIC LIGATURE MEEM WITH HAH WITH JEEM INITIAL FORM
    0x0FD8A: ["<initial>", 0x0645, 0x062D, 0x0645],  # ARABIC LIGATURE MEEM WITH HAH WITH MEEM INITIAL FORM
    0x0FD8B: ["<final>", 0x0645, 0x062D, 0x064A],  # ARABIC LIGATURE MEEM WITH HAH WITH YEH FINAL FORM
    0x0FD8C: ["<initial>", 0x0645, 0x062C, 0x062D],  # ARABIC LIGATURE MEEM WITH JEEM WITH HAH INITIAL FORM
    0x0FD8D: ["<initial>", 0x0645, 0x062C, 0x0645],  # ARABIC LIGATURE MEEM WITH JEEM WITH MEEM INITIAL FORM
    0x0FD8E: ["<initial>", 0x0645, 0x062E, 0x062C],  # ARABIC LIGATURE MEEM WITH KHAH WITH JEEM INITIAL FORM
    0x0FD8F: ["<initial>", 0x0645, 0x062E, 0x0645],  # ARABIC LIGATURE MEEM WITH KHAH WITH MEEM INITIAL FORM
    0x0FD92: ["<initial>", 0x0645, 0x062C, 0x062E],  # ARABIC LIGATURE MEEM WITH JEEM WITH KHAH INITIAL FORM
    0x0FD93: ["<initial>", 0x0647, 0x0645, 0x062C],  # ARABIC LIGATURE HEH WITH MEEM WITH JEEM INITIAL FORM
    0x0FD94: ["<initial>", 0x0647, 0x0645, 0x0645],  # ARABIC LIGATURE HEH WITH MEEM WITH MEEM INITIAL FORM
    0x0FD95: ["<initial>", 0x0646, 0x062D, 0x0645],  # ARABIC LIGATURE NOON WITH HAH WITH MEEM INITIAL FORM
    0x0FD96: ["<final>", 0x0646, 0x062D, 0x0649],  # ARABIC LIGATURE NOON WITH HAH WITH ALEF MAKSURA FINAL FORM
    0x0FD97: ["<final>", 0x0646, 0x062C, 0x0645],  # ARABIC LIGATURE NOON WITH JEEM WITH MEEM FINAL FORM
    0x0FD98: ["<initial>", 0x0646, 0x062C, 0x0645],  # ARABIC LIGATURE NOON WITH JEEM WITH MEEM INITIAL FORM
    0x0FD99: ["<final>", 0x0646, 0x062C, 0x0649],  # ARABIC LIGATURE NOON WITH JEEM WITH ALEF MAKSURA FINAL FORM
    0x0FD9A: ["<final>", 0x0646, 0x0645, 0x064A],  # ARABIC LIGATURE NOON WITH MEEM WITH YEH FINAL FORM
    0x0FD9B: ["<final>", 0x0646, 0x0645, 0x0649],  # ARABIC LIGATURE NOON WITH MEEM WITH ALEF MAKSURA FINAL FORM
    0x0FD9C: ["<final>", 0x064A, 0x0645, 0x0645],  # ARABIC LIGATURE YEH WITH MEEM WITH MEEM FINAL FORM
    0x0FD9D: ["<initial>", 0x064A, 0x0645, 0x0645],  # ARABIC LIGATURE YEH WITH MEEM WITH MEEM INITIAL FORM
    0x0FD9E: ["<final>", 0x0628, 0x062E, 0x064A],  # ARABIC LIGATURE BEH WITH KHAH WITH YEH FINAL FORM
    0x0FD9F: ["<final>", 0x062A, 0x062C, 0x064A],  # ARABIC LIGATURE TEH WITH JEEM WITH YEH FINAL FORM
    0x0FDA0: ["<final>", 0x062A, 0x062C, 0x0649],  # ARABIC LIGATURE TEH WITH JEEM WITH ALEF MAKSURA FINAL FORM
    0x0FDA1: ["<final>", 0x062A, 0x062E, 0x064A],  # ARABIC LIGATURE TEH WITH KHAH WITH YEH FINAL FORM
    0x0FDA2: ["<final>", 0x062A, 0x062E, 0x0649],  # ARABIC LIGATURE TEH WITH KHAH WITH ALEF MAKSURA FINAL FORM
    0x0FDA3: ["<final>", 0x062A, 0x0645, 0x064A],  # ARABIC LIGATURE TEH WITH MEEM WITH YEH FINAL FORM
    0x0FDA4: ["<final>", 0x062A, 0x0645, 0x0649],  # ARABIC LIGATURE TEH WITH MEEM WITH ALEF MAKSURA FINAL FORM
    0x0FDA5: ["<final>", 0x062C, 0x0645, 0x064A],  # ARABIC LIGATURE JEEM WITH MEEM WITH YEH FINAL FORM
    0x0FDA6: ["<final>", 0x062C, 0x062D, 0x0649],  # ARABIC LIGATURE JEEM WITH HAH WITH ALEF MAKSURA FINAL FORM
    0x0FDA7: ["<final>", 0x062C, 0x0645, 0x0649],  # ARABIC LIGATURE JEEM WITH MEEM WITH ALEF MAKSURA FINAL FORM
    0x0FDA8: ["<final>", 0x0633, 0x062E, 0x0649],  # ARABIC LIGATURE SEEN WITH KHAH WITH ALEF MAKSURA FINAL FORM
    0x0FDA9: ["<final>", 0x0635, 0x062D, 0x064A],  # ARABIC LIGATURE SAD WITH HAH WITH YEH FINAL FORM
    0x0FDAA: ["<final>", 0x0634, 0x062D, 0x064A],  # ARABIC LIGATURE SHEEN WITH HAH WITH YEH FINAL FORM
    0x0FDAB: ["<final>", 0x0636, 0x062D, 0x064A],  # ARABIC LIGATURE DAD WITH HAH WITH YEH FINAL FORM
    0x0FDAC: ["<final>", 0x0644, 0x062C, 0x064A],  # ARABIC LIGATURE LAM WITH JEEM WITH YEH FINAL FORM
    0x0FDAD: ["<final>", 0x0644, 0x0645, 0x064A],  # ARABIC LIGATURE LAM WITH MEEM WITH YEH FINAL FORM
    0x0FDAE: ["<final>", 0x064A, 0x062D, 0x064A],  # ARABIC LIGATURE YEH WITH HAH WITH YEH FINAL FORM
    0x0FDAF: ["<final>", 0x064A, 0x062C, 0x064A],  # ARABIC LIGATURE YEH WITH JEEM WITH YEH FINAL FORM
    0x0FDB0: ["<final>", 0x064A, 0x0645, 0x064A],  # ARABIC LIGATURE YEH WITH MEEM WITH YEH FINAL FORM
    0x0FDB1: ["<final>", 0x0645, 0x0645, 0x064A],  # ARABIC LIGATURE MEEM WITH MEEM WITH YEH FINAL FORM
    0x0FDB2: ["<final>", 0x0642, 0x0645, 0x064A],  # ARABIC LIGATURE QAF WITH MEEM WITH YEH FINAL FORM
    0x0FDB3: ["<final>", 0x0646, 0x062D, 0x064A],  # ARABIC LIGATURE NOON WITH HAH WITH YEH FINAL FORM
    0x0FDB4: ["<initial>", 0x0642, 0x0645, 0x062D],  # ARABIC LIGATURE QAF WITH MEEM WITH HAH INITIAL FORM
    0x0FDB5: ["<initial>", 0x0644, 0x062D, 0x0645],  # ARABIC LIGATURE LAM WITH HAH WITH MEEM INITIAL FORM
    0x0FDB6: ["<final>", 0x0639, 0x0645, 0x064A],  # ARABIC LIGATURE AIN WITH MEEM WITH YEH FINAL FORM
    0x0FDB7: ["<final>", 0x0643, 0x0645, 0x064A],  # ARABIC LIGATURE KAF WITH MEEM WITH YEH FINAL FORM
    0x0FDB8: ["<initial>", 0x0646, 0x062C, 0x062D],  # ARABIC LIGATURE NOON WITH JEEM WITH HAH INITIAL FORM
    0x0FDB9: ["<final>", 0x0645, 0x062E, 0x064A],  # ARABIC LIGATURE MEEM WITH KHAH WITH YEH FINAL FORM
    0x0FDBA: ["<initial>", 0x0644, 0x062C, 0x0645],  # ARABIC LIGATURE LAM WITH JEEM WITH MEEM INITIAL FORM
    0x0FDBB: ["<final>", 0x0643, 0x0645, 0x0645],  # ARABIC LIGATURE KAF WITH MEEM WITH MEEM FINAL FORM
    0x0FDBC: ["<final>", 0x0644, 0x062C, 0x0645],  # ARABIC LIGATURE LAM WITH JEEM WITH MEEM FINAL FORM
    0x0FDBD: ["<final>", 0x0646, 0x062C, 0x062D],  # ARABIC LIGATURE NOON WITH JEEM WITH HAH FINAL FORM
    0x0FDBE: ["<final>", 0x062C, 0x062D, 0x064A],  # ARABIC LIGATURE JEEM WITH HAH WITH YEH FINAL FORM
    0x0FDBF: ["<final>", 0x062D, 0x062C, 0x064A],  # ARABIC LIGATURE HAH WITH JEEM WITH YEH FINAL FORM
    0x0FDC0: ["<final>", 0x0645, 0x062C, 0x064A],  # ARABIC LIGATURE MEEM WITH JEEM WITH YEH FINAL FORM
    0x0FDC1: ["<final>", 0x0641, 0x0645, 0x064A],  # ARABIC LIGATURE FEH WITH MEEM WITH YEH FINAL FORM
    0x0FDC2: ["<final>", 0x0628, 0x062D, 0x064A],  # ARABIC LIGATURE BEH WITH HAH WITH YEH FINAL FORM
    0x0FDC3: ["<initial>", 0x0643, 0x0645, 0x0645],  # ARABIC LIGATURE KAF WITH MEEM WITH MEEM INITIAL FORM
    0x0FDC4: ["<initial>", 0x0639, 0x062C, 0x0645],  # ARABIC LIGATURE AIN WITH JEEM WITH MEEM INITIAL FORM
    0x0FDC5: ["<initial>", 0x0635, 0x0645, 0x0645],  # ARABIC LIGATURE SAD WITH MEEM WITH MEEM INITIAL FORM
    0x0FDC6: ["<final>", 0x0633, 0x062E, 0x064A],  # ARABIC LIGATURE SEEN WITH KHAH WITH YEH FINAL FORM
    0x0FDC7: ["<final>", 0x0646, 0x062C, 0x064A],  # ARABIC LIGATURE NOON WITH JEEM WITH YEH FINAL FORM
    0x0FDF0: ["<isolated>", 0x0635, 0x0644, 0x06D2],  # ARABIC LIGATURE SALLA USED AS KORANIC STOP SIGN ISOLATED FORM
    0x0FDF1: ["<isolated>", 0x0642, 0x0644, 0x06D2],  # ARABIC LIGATURE QALA USED AS KORANIC STOP SIGN ISOLATED FORM
    0x0FDF2: ["<isolated>", 0x0627, 0x0644, 0x0644, 0x0647],  # ARABIC LIGATURE ALLAH ISOLATED FORM
    0x0FDF3: ["<isolated>", 0x0627, 0x0643, 0x0628, 0x0631],  # ARABIC LIGATURE AKBAR ISOLATED FORM
    0x0FDF4: ["<isolated>", 0x0645, 0x062D, 0x0645, 0x062F],  # ARABIC LIGATURE MOHAMMAD ISOLATED FORM
    0x0FDF5: ["<isolated>", 0x0635, 0x0644, 0x0639, 0x0645],  # ARABIC LIGATURE SALAM ISOLATED FORM
    0x0FDF6: ["<isolated>", 0x0631, 0x0633, 0x0648, 0x0644],  # ARABIC LIGATURE RASOUL ISOLATED FORM
    0x0FDF7: ["<isolated>", 0x0639, 0x0644, 0x064A, 0x0647],  # ARABIC LIGATURE ALAYHE ISOLATED FORM
    0x0FDF8: ["<isolated>", 0x0648, 0x0633, 0x0644, 0x0645],  # ARABIC LIGATURE WASALLAM ISOLATED FORM
    0x0FDF9: ["<isolated>", 0x0635, 0x0644, 0x0649],  # ARABIC LIGATURE SALLA ISOLATED FORM
    0x0FDFA: ["<isolated>", 0x0635, 0x0644, 0x0649, 0x0020, 0x0627, 0x0644, 0x0644, 0x0647, 0x0020, 0x0639, 0x0644, 0x064A, 0x0647, 0x0020, 0x0648, 0x0633, 0x0644, 0x0645],  # ARABIC LIGATURE SALLALLAHOU ALAYHE WASALLAM
    0x0FDFB: ["<isolated>", 0x062C, 0x0644, 0x0020, 0x062C, 0x0644, 0x0627, 0x0644, 0x0647],  # ARABIC LIGATURE JALLAJALALOUHOU
    0x0FDFC: ["<isolated>", 0x0631, 0x06CC, 0x0627, 0x0644],  # RIAL SIGN
    0x0FE10: ["<vertical>", 0x002C],  # PRESENTATION FORM FOR VERTICAL COMMA
    0x0FE11: ["<vertical>", 0x3001],  # PRESENTATION FORM FOR VERTICAL IDEOGRAPHIC COMMA
    0x0FE12: ["<vertical>", 0x3002],  # PRESENTATION FORM FOR VERTICAL IDEOGRAPHIC FULL STOP
    0x0FE13: ["<vertical>", 0x003A],  # PRESENTATION FORM FOR VERTICAL COLON
    0x0FE14: ["<vertical>", 0x003B],  # PRESENTATION FORM FOR VERTICAL SEMICOLON
    0x0FE15: ["<vertical>", 0x0021],  # PRESENTATION FORM FOR VERTICAL EXCLAMATION MARK
    0x0FE16: ["<vertical>", 0x003F],  # PRESENTATION FORM FOR VERTICAL QUESTION MARK
    0x0FE17: ["<vertical>", 0x3016],  # PRESENTATION FORM FOR VERTICAL LEFT WHITE LENTICULAR BRACKET
    0x0FE18: ["<vertical>", 0x3017],  # PRESENTATION FORM FOR VERTICAL RIGHT WHITE LENTICULAR BRAKCET
    0x0FE19: ["<vertical>", 0x2026],  # PRESENTATION FORM FOR VERTICAL HORIZONTAL ELLIPSIS
    0x0FE30: ["<vertical>", 0x2025],  # PRESENTATION FORM FOR VERTICAL TWO DOT LEADER
    0x0FE31: ["<vertical>", 0x2014],  # PRESENTATION FORM FOR VERTICAL EM DASH
    0x0FE32: ["<vertical>", 0x2013],  # PRESENTATION FORM FOR VERTICAL EN DASH
    0x0FE33: ["<vertical>", 0x005F],  # PRESENTATION FORM FOR VERTICAL LOW LINE
    0x0FE34: ["<vertical>", 0x005F],  # PRESENTATION FORM FOR VERTICAL WAVY LOW LINE
    0x0FE35: ["<vertical>", 0x0028],  # PRESENTATION FORM FOR VERTICAL LEFT PARENTHESIS
    0x0FE36: ["<vertical>", 0x0029],  # PRESENTATION FORM FOR VERTICAL RIGHT PARENTHESIS
    0x0FE37: ["<vertical>", 0x007B],  # PRESENTATION FORM FOR VERTICAL LEFT CURLY BRACKET
    0x0FE38: ["<vertical>", 0x007D],  # PRESENTATION FORM FOR VERTICAL RIGHT CURLY BRACKET
    0x0FE39: ["<vertical>", 0x3014],  # PRESENTATION FORM FOR VERTICAL LEFT TORTOISE SHELL BRACKET
    0x0FE3A: ["<vertical>", 0x3015],  # PRESENTATION FORM FOR VERTICAL RIGHT TORTOISE SHELL BRACKET
    0x0FE3B: ["<vertical>", 0x3010],  # PRESENTATION FORM FOR VERTICAL LEFT BLACK LENTICULAR BRACKET
    0x0FE3C: ["<vertical>", 0x3011],  # PRESENTATION FORM FOR VERTICAL RIGHT BLACK LENTICULAR BRACKET
    0x0FE3D: ["<vertical>", 0x300A],  # PRESENTATION FORM FOR VERTICAL LEFT DOUBLE ANGLE BRACKET
    0x0FE3E: ["<vertical>", 0x300B],  # PRESENTATION FORM FOR VERTICAL RIGHT DOUBLE ANGLE BRACKET
    0x0FE3F: ["<vertical>", 0x3008],  # PRESENTATION FORM FOR VERTICAL LEFT ANGLE BRACKET
    0x0FE40: ["<vertical>", 0x3009],  # PRESENTATION FORM FOR VERTICAL RIGHT ANGLE BRACKET
    0x0FE41: ["<vertical>", 0x300C],  # PRESENTATION FORM FOR VERTICAL LEFT CORNER BRACKET
    0x0FE42: ["<vertical>", 0x300D],  # PRESENTATION FORM FOR VERTICAL RIGHT CORNER BRACKET
    0x0FE43: ["<vertical>", 0x300E],  # PRESENTATION FORM FOR VERTICAL LEFT WHITE CORNER BRACKET
    0x0FE44: ["<vertical>", 0x300F],  # PRESENTATION FORM FOR VERTICAL RIGHT WHITE CORNER BRACKET
    0x0FE47: ["<vertical>", 0x005B],  # PRESENTATION FORM FOR VERTICAL LEFT SQUARE BRACKET
    0x0FE48: ["<vertical>", 0x005D],  # PRESENTATION FORM FOR VERTICAL RIGHT SQUARE BRACKET
    0x0FE49: ["<compat>", 0x203E],  # DASHED OVERLINE
    0x0FE4A: ["<compat>", 0x203E],  # CENTRELINE OVERLINE
    0x0FE4B: ["<compat>", 0x203E],  # WAVY OVERLINE
    0x0FE4C: ["<compat>", 0x203E],  # DOUBLE WAVY OVERLINE
    0x0FE4D: ["<compat>", 0x005F],  # DASHED LOW LINE
    0x0FE4E: ["<compat>", 0x005F],  # CENTRELINE LOW LINE
    0x0FE4F: ["<compat>", 0x005F],  # WAVY LOW LINE
    0x0FE50: ["<small>", 0x002C],  # SMALL COMMA
    0x0FE51: ["<small>", 0x3001],  # SMALL IDEOGRAPHIC COMMA
    0x0FE52: ["<small>", 0x002E],  # SMALL FULL STOP
    0x0FE54: ["<small>", 0x003B],  # SMALL SEMICOLON
    0x0FE55: ["<small>", 0x003A],  # SMALL COLON
    0x0FE56: ["<small>", 0x003F],  # SMALL QUESTION MARK
    0x0FE57: ["<small>", 0x0021],  # SMALL EXCLAMATION MARK
    0x0FE58: ["<small>", 0x2014],  # SMALL EM DASH
    0x0FE59: ["<small>", 0x0028],  # SMALL LEFT PARENTHESIS
    0x0FE5A: ["<small>", 0x0029],  # SMALL RIGHT PARENTHESIS
    0x0FE5B: ["<small>", 0x007B],  # SMALL LEFT CURLY BRACKET
    0x0FE5C: ["<small>", 0x007D],  # SMALL RIGHT CURLY BRACKET
    0x0FE5D: ["<small>", 0x3014],  # SMALL LEFT TORTOISE SHELL BRACKET
    0x0FE5E: ["<small>", 0x3015],  # SMALL RIGHT TORTOISE SHELL BRACKET
    0x0FE5F: ["<small>", 0x0023],  # SMALL NUMBER SIGN
    0x0FE60: ["<small>", 0x0026],  # SMALL AMPERSAND
    0x0FE61: ["<small>", 0x002A],  # SMALL ASTERISK
    0x0FE62: ["<small>", 0x002B],  # SMALL PLUS SIGN
    0x0FE63: ["<small>", 0x002D],  # SMALL HYPHEN-MINUS
    0x0FE64: ["<small>", 0x003C],  # SMALL LESS-THAN SIGN
    0x0FE65: ["<small>", 0x003E],  # SMALL GREATER-THAN SIGN
    0x0FE66: ["<small>", 0x003D],  # SMALL EQUALS SIGN
    0x0FE68: ["<small>", 0x005C],  # SMALL REVERSE SOLIDUS
    0x0FE69: ["<small>", 0x0024],  # SMALL DOLLAR SIGN
    0x0FE6A: ["<small>", 0x0025],  # SMALL PERCENT SIGN
    0x0FE6B: ["<small>", 0x0040],  # SMALL COMMERCIAL AT
    0x0FE70: ["<isolated>", 0x0020, 0x064B],  # ARABIC FATHATAN ISOLATED FORM
    0x0FE71: ["<medial>", 0x0640, 0x064B],  # ARABIC TATWEEL WITH FATHATAN ABOVE
    0x0FE72: ["<isolated>", 0x0020, 0x064C],  # ARABIC DAMMATAN ISOLATED FORM
    0x0FE74: ["<isolated>", 0x0020, 0x064D],  # ARABIC KASRATAN ISOLATED FORM
    0x0FE76: ["<isolated>", 0x0020, 0x064E],  # ARABIC FATHA ISOLATED FORM
    0x0FE77: ["<medial>", 0x0640, 0x064E],  # ARABIC FATHA MEDIAL FORM
    0x0FE78: ["<isolated>", 0x0020, 0x064F],  # ARABIC DAMMA ISOLATED FORM
    0x0FE79: ["<medial>", 0x0640, 0x064F],  # ARABIC DAMMA MEDIAL FORM
    0x0FE7A: ["<isolated>", 0x0020, 0x0650],  # ARABIC KASRA ISOLATED FORM
    0x0FE7B: ["<medial>", 0x0640, 0x0650],  # ARABIC KASRA MEDIAL FORM
    0x0FE7C: ["<isolated>", 0x0020, 0x0651],  # ARABIC SHADDA ISOLATED FORM
    0x0FE7D: ["<medial>", 0x0640, 0x0651],  # ARABIC SHADDA MEDIAL FORM
    0x0FE7E: ["<isolated>", 0x0020, 0x0652],  # ARABIC SUKUN ISOLATED FORM
    0x0FE7F: ["<medial>", 0x0640, 0x0652],  # ARABIC SUKUN MEDIAL FORM
    0x0FE80: ["<isolated>", 0x0621],  # ARABIC LETTER HAMZA ISOLATED FORM
    0x0FE81: ["<isolated>", 0x0622],  # ARABIC LETTER ALEF WITH MADDA ABOVE ISOLATED FORM
    0x0FE82: ["<final>", 0x0622],  # ARABIC LETTER ALEF WITH MADDA ABOVE FINAL FORM
    0x0FE83: ["<isolated>", 0x0623],  # ARABIC LETTER ALEF WITH HAMZA ABOVE ISOLATED FORM
    0x0FE84: ["<final>", 0x0623],  # ARABIC LETTER ALEF WITH HAMZA ABOVE FINAL FORM
    0x0FE85: ["<isolated>", 0x0624],  # ARABIC LETTER WAW WITH HAMZA ABOVE ISOLATED FORM
    0x0FE86: ["<final>", 0x0624],  # ARABIC LETTER WAW WITH HAMZA ABOVE FINAL FORM
    0x0FE87: ["<isolated>", 0x0625],  # ARABIC LETTER ALEF WITH HAMZA BELOW ISOLATED FORM
    0x0FE88: ["<final>", 0x0625],  # ARABIC LETTER ALEF WITH HAMZA BELOW FINAL FORM
    0x0FE89: ["<isolated>", 0x0626],  # ARABIC LETTER YEH WITH HAMZA ABOVE ISOLATED FORM
    0x0FE8A: ["<final>", 0x0626],  # ARABIC LETTER YEH WITH HAMZA ABOVE FINAL FORM
    0x0FE8B: ["<initial>", 0x0626],  # ARABIC LETTER YEH WITH HAMZA ABOVE INITIAL FORM
    0x0FE8C: ["<medial>", 0x0626],  # ARABIC LETTER YEH WITH HAMZA ABOVE MEDIAL FORM
    0x0FE8D: ["<isolated>", 0x0627],  # ARABIC LETTER ALEF ISOLATED FORM
    0x0FE8E: ["<final>", 0x0627],  # ARABIC LETTER ALEF FINAL FORM
    0x0FE8F: ["<isolated>", 0x0628],  # ARABIC LETTER BEH ISOLATED FORM
    0x0FE90: ["<final>", 0x0628],  # ARABIC LETTER BEH FINAL FORM
    0x0FE91: ["<initial>", 0x0628],  # ARABIC LETTER BEH INITIAL FORM
    0x0FE92: ["<medial>", 0x0628],  # ARABIC LETTER BEH MEDIAL FORM
    0x0FE93: ["<isolated>", 0x0629],  # ARABIC LETTER TEH MARBUTA ISOLATED FORM
    0x0FE94: ["<final>", 0x0629],  # ARABIC LETTER TEH MARBUTA FINAL FORM
    0x0FE95: ["<isolated>", 0x062A],  # ARABIC LETTER TEH ISOLATED FORM
    0x0FE96: ["<final>", 0x062A],  # ARABIC LETTER TEH FINAL FORM
    0x0FE97: ["<initial>", 0x062A],  # ARABIC LETTER TEH INITIAL FORM
    0x0FE98: ["<medial>", 0x062A],  # ARABIC LETTER TEH MEDIAL FORM
    0x0FE99: ["<isolated>", 0x062B],  # ARABIC LETTER THEH ISOLATED FORM
    0x0FE9A: ["<final>", 0x062B],  # ARABIC LETTER THEH FINAL FORM
    0x0FE9B: ["<initial>", 0x062B],  # ARABIC LETTER THEH INITIAL FORM
    0x0FE9C: ["<medial>", 0x062B],  # ARABIC LETTER THEH MEDIAL FORM
    0x0FE9D: ["<isolated>", 0x062C],  # ARABIC LETTER JEEM ISOLATED FORM
    0x0FE9E: ["<final>", 0x062C],  # ARABIC LETTER JEEM FINAL FORM
    0x0FE9F: ["<initial>", 0x062C],  # ARABIC LETTER JEEM INITIAL FORM
    0x0FEA0: ["<medial>", 0x062C],  # ARABIC LETTER JEEM MEDIAL FORM
    0x0FEA1: ["<isolated>", 0x062D],  # ARABIC LETTER HAH ISOLATED FORM
    0x0FEA2: ["<final>", 0x062D],  # ARABIC LETTER HAH FINAL FORM
    0x0FEA3: ["<initial>", 0x062D],  # ARABIC LETTER HAH INITIAL FORM
    0x0FEA4: ["<medial>", 0x062D],  # ARABIC LETTER HAH MEDIAL FORM
    0x0FEA5: ["<isolated>", 0x062E],  # ARABIC LETTER KHAH ISOLATED FORM
    0x0FEA6: ["<final>", 0x062E],  # ARABIC LETTER KHAH FINAL FORM
    0x0FEA7: ["<initial>", 0x062E],  # ARABIC LETTER KHAH INITIAL FORM
    0x0FEA8: ["<medial>", 0x062E],  # ARABIC LETTER KHAH MEDIAL FORM
    0x0FEA9: ["<isolated>", 0x062F],  # ARABIC LETTER DAL ISOLATED FORM
    0x0FEAA: ["<final>", 0x062F],  # ARABIC LETTER DAL FINAL FORM
    0x0FEAB: ["<isolated>", 0x0630],  # ARABIC LETTER THAL ISOLATED FORM
    0x0FEAC: ["<final>", 0x0630],  # ARABIC LETTER THAL FINAL FORM
    0x0FEAD: ["<isolated>", 0x0631],  # ARABIC LETTER REH ISOLATED FORM
    0x0FEAE: ["<final>", 0x0631],  # ARABIC LETTER REH FINAL FORM
    0x0FEAF: ["<isolated>", 0x0632],  # ARABIC LETTER ZAIN ISOLATED FORM
    0x0FEB0: ["<final>", 0x0632],  # ARABIC LETTER ZAIN FINAL FORM
    0x0FEB1: ["<isolated>", 0x0633],  # ARABIC LETTER SEEN ISOLATED FORM
    0x0FEB2: ["<final>", 0x0633],  # ARABIC LETTER SEEN FINAL FORM
    0x0FEB3: ["<initial>", 0x0633],  # ARABIC LETTER SEEN INITIAL FORM
    0x0FEB4: ["<medial>", 0x0633],  # ARABIC LETTER SEEN MEDIAL FORM
    0x0FEB5: ["<isolated>", 0x0634],  # ARABIC LETTER SHEEN ISOLATED FORM
    0x0FEB6: ["<final>", 0x0634],  # ARABIC LETTER SHEEN FINAL FORM
    0x0FEB7: ["<initial>", 0x0634],  # ARABIC LETTER SHEEN INITIAL FORM
    0x0FEB8: ["<medial>", 0x0634],  # ARABIC LETTER SHEEN MEDIAL FORM
    0x0FEB9: ["<isolated>", 0x0635],  # ARABIC LETTER SAD ISOLATED FORM
    0x0FEBA: ["<final>", 0x0635],  # ARABIC LETTER SAD FINAL FORM
    0x0FEBB: ["<initial>", 0x0635],  # ARABIC LETTER SAD INITIAL FORM
    0x0FEBC: ["<medial>", 0x0635],  # ARABIC LETTER SAD MEDIAL FORM
    0x0FEBD: ["<isolated>", 0x0636],  # ARABIC LETTER DAD ISOLATED FORM
    0x0FEBE: ["<final>", 0x0636],  # ARABIC LETTER DAD FINAL FORM
    0x0FEBF: ["<initial>", 0x0636],  # ARABIC LETTER DAD INITIAL FORM
    0x0FEC0: ["<medial>", 0x0636],  # ARABIC LETTER DAD MEDIAL FORM
    0x0FEC1: ["<isolated>", 0x0637],  # ARABIC LETTER TAH ISOLATED FORM
    0x0FEC2: ["<final>", 0x0637],  # ARABIC LETTER TAH FINAL FORM
    0x0FEC3: ["<initial>", 0x0637],  # ARABIC LETTER TAH INITIAL FORM
    0x0FEC4: ["<medial>", 0x0637],  # ARABIC LETTER TAH MEDIAL FORM
    0x0FEC5: ["<isolated>", 0x0638],  # ARABIC LETTER ZAH ISOLATED FORM
    0x0FEC6: ["<final>", 0x0638],  # ARABIC LETTER ZAH FINAL FORM
    0x0FEC7: ["<initial>", 0x0638],  # ARABIC LETTER ZAH INITIAL FORM
    0x0FEC8: ["<medial>", 0x0638],  # ARABIC LETTER ZAH MEDIAL FORM
    0x0FEC9: ["<isolated>", 0x0639],  # ARABIC LETTER AIN ISOLATED FORM
    0x0FECA: ["<final>", 0x0639],  # ARABIC LETTER AIN FINAL FORM
    0x0FECB: ["<initial>", 0x0639],  # ARABIC LETTER AIN INITIAL FORM
    0x0FECC: ["<medial>", 0x0639],  # ARABIC LETTER AIN MEDIAL FORM
    0x0FECD: ["<isolated>", 0x063A],  # ARABIC LETTER GHAIN ISOLATED FORM
    0x0FECE: ["<final>", 0x063A],  # ARABIC LETTER GHAIN FINAL FORM
    0x0FECF: ["<initial>", 0x063A],  # ARABIC LETTER GHAIN INITIAL FORM
    0x0FED0: ["<medial>", 0x063A],  # ARABIC LETTER GHAIN MEDIAL FORM
    0x0FED1: ["<isolated>", 0x0641],  # ARABIC LETTER FEH ISOLATED FORM
    0x0FED2: ["<final>", 0x0641],  # ARABIC LETTER FEH FINAL FORM
    0x0FED3: ["<initial>", 0x0641],  # ARABIC LETTER FEH INITIAL FORM
    0x0FED4: ["<medial>", 0x0641],  # ARABIC LETTER FEH MEDIAL FORM
    0x0FED5: ["<isolated>", 0x0642],  # ARABIC LETTER QAF ISOLATED FORM
    0x0FED6: ["<final>", 0x0642],  # ARABIC LETTER QAF FINAL FORM
    0x0FED7: ["<initial>", 0x0642],  # ARABIC LETTER QAF INITIAL FORM
    0x0FED8: ["<medial>", 0x0642],  # ARABIC LETTER QAF MEDIAL FORM
    0x0FED9: ["<isolated>", 0x0643],  # ARABIC LETTER KAF ISOLATED FORM
    0x0FEDA: ["<final>", 0x0643],  # ARABIC LETTER KAF FINAL FORM
    0x0FEDB: ["<initial>", 0x0643],  # ARABIC LETTER KAF INITIAL FORM
    0x0FEDC: ["<medial>", 0x0643],  # ARABIC LETTER KAF MEDIAL FORM
    0x0FEDD: ["<isolated>", 0x0644],  # ARABIC LETTER LAM ISOLATED FORM
    0x0FEDE: ["<final>", 0x0644],  # ARABIC LETTER LAM FINAL FORM
    0x0FEDF: ["<initial>", 0x0644],  # ARABIC LETTER LAM INITIAL FORM
    0x0FEE0: ["<medial>", 0x0644],  # ARABIC LETTER LAM MEDIAL FORM
    0x0FEE1: ["<isolated>", 0x0645],  # ARABIC LETTER MEEM ISOLATED FORM
    0x0FEE2: ["<final>", 0x0645],  # ARABIC LETTER MEEM FINAL FORM
    0x0FEE3: ["<initial>", 0x0645],  # ARABIC LETTER MEEM INITIAL FORM
    0x0FEE4: ["<medial>", 0x0645],  # ARABIC LETTER MEEM MEDIAL FORM
    0x0FEE5: ["<isolated>", 0x0646],  # ARABIC LETTER NOON ISOLATED FORM
    0x0FEE6: ["<final>", 0x0646],  # ARABIC LETTER NOON FINAL FORM
    0x0FEE7: ["<initial>", 0x0646],  # ARABIC LETTER NOON INITIAL FORM
    0x0FEE8: ["<medial>", 0x0646],  # ARABIC LETTER NOON MEDIAL FORM
    0x0FEE9: ["<isolated>", 0x0647],  # ARABIC LETTER HEH ISOLATED FORM
    0x0FEEA: ["<final>", 0x0647],  # ARABIC LETTER HEH FINAL FORM
    0x0FEEB: ["<initial>", 0x0647],  # ARABIC LETTER HEH INITIAL FORM
    0x0FEEC: ["<medial>", 0x0647],  # ARABIC LETTER HEH MEDIAL FORM
    0x0FEED: ["<isolated>", 0x0648],  # ARABIC LETTER WAW ISOLATED FORM
    0x0FEEE: ["<final>", 0x0648],  # ARABIC LETTER WAW FINAL FORM
    0x0FEEF: ["<isolated>", 0x0649],  # ARABIC LETTER ALEF MAKSURA ISOLATED FORM
    0x0FEF0: ["<final>", 0x0649],  # ARABIC LETTER ALEF MAKSURA FINAL FORM
    0x0FEF1: ["<isolated>", 0x064A],  # ARABIC LETTER YEH ISOLATED FORM
    0x0FEF2: ["<final>", 0x064A],  # ARABIC LETTER YEH FINAL FORM
    0x0FEF3: ["<initial>", 0x064A],  # ARABIC LETTER YEH INITIAL FORM
    0x0FEF4: ["<medial>", 0x064A],  # ARABIC LETTER YEH MEDIAL FORM
    0x0FEF5: ["<isolated>", 0x0644, 0x0622],  # ARABIC LIGATURE LAM WITH ALEF WITH MADDA ABOVE ISOLATED FORM
    0x0FEF6: ["<final>", 0x0644, 0x0622],  # ARABIC LIGATURE LAM WITH ALEF WITH MADDA ABOVE FINAL FORM
    0x0FEF7: ["<isolated>", 0x0644, 0x0623],  # ARABIC LIGATURE LAM WITH ALEF WITH HAMZA ABOVE ISOLATED FORM
    0x0FEF8: ["<final>", 0x0644, 0x0623],  # ARABIC LIGATURE LAM WITH ALEF WITH HAMZA ABOVE FINAL FORM
    0x0FEF9: ["<isolated>", 0x0644, 0x0625],  # ARABIC LIGATURE LAM WITH ALEF WITH HAMZA BELOW ISOLATED FORM
    0x0FEFA: ["<final>", 0x0644, 0x0625],  # ARABIC LIGATURE LAM WITH ALEF WITH HAMZA BELOW FINAL FORM
    0x0FEFB: ["<isolated>", 0x0644, 0x0627],  # ARABIC LIGATURE LAM WITH ALEF ISOLATED FORM
    0x0FEFC: ["<final>", 0x0644, 0x0627],  # ARABIC LIGATURE LAM WITH ALEF FINAL FORM
    0x0FF01: ["<wide>", 0x0021],  # FULLWIDTH EXCLAMATION MARK
    0x0FF02: ["<wide>", 0x0022],  # FULLWIDTH QUOTATION MARK
    0x0FF03: ["<wide>", 0x0023],  # FULLWIDTH NUMBER SIGN
    0x0FF04: ["<wide>", 0x0024],  # FULLWIDTH DOLLAR SIGN
    0x0FF05: ["<wide>", 0x0025],  # FULLWIDTH PERCENT SIGN
    0x0FF06: ["<wide>", 0x0026],  # FULLWIDTH AMPERSAND
    0x0FF07: ["<wide>", 0x0027],  # FULLWIDTH APOSTROPHE
    0x0FF08: ["<wide>", 0x0028],  # FULLWIDTH LEFT PARENTHESIS
    0x0FF09: ["<wide>", 0x0029],  # FULLWIDTH RIGHT PARENTHESIS
    0x0FF0A: ["<wide>", 0x002A],  # FULLWIDTH ASTERISK
    0x0FF0B: ["<wide>", 0x002B],  # FULLWIDTH PLUS SIGN
    0x0FF0C: ["<wide>", 0x002C],  # FULLWIDTH COMMA
    0x0FF0D: ["<wide>", 0x002D],  # FULLWIDTH HYPHEN-MINUS
    0x0FF0E: ["<wide>", 0x002E],  # FULLWIDTH FULL STOP
    0x0FF0F: ["<wide>", 0x002F],  # FULLWIDTH SOLIDUS
    0x0FF10: ["<wide>", 0x0030],  # FULLWIDTH DIGIT ZERO
    0x0FF11: ["<wide>", 0x0031],  # FULLWIDTH DIGIT ONE
    0x0FF12: ["<wide>", 0x0032],  # FULLWIDTH DIGIT TWO
    0x0FF13: ["<wide>", 0x0033],  # FULLWIDTH DIGIT THREE
    0x0FF14: ["<wide>", 0x0034],  # FULLWIDTH DIGIT FOUR
    0x0FF15: ["<wide>", 0x0035],  # FULLWIDTH DIGIT FIVE
    0x0FF16: ["<wide>", 0x0036],  # FULLWIDTH DIGIT SIX
    0x0FF17: ["<wide>", 0x0037],  # FULLWIDTH DIGIT SEVEN
    0x0FF18: ["<wide>", 0x0038],  # FULLWIDTH DIGIT EIGHT
    0x0FF19: ["<wide>", 0x0039],  # FULLWIDTH DIGIT NINE
    0x0FF1A: ["<wide>", 0x003A],  # FULLWIDTH COLON
    0x0FF1B: ["<wide>", 0x003B],  # FULLWIDTH SEMICOLON
    0x0FF1C: ["<wide>", 0x003C],  # FULLWIDTH LESS-THAN SIGN
    0x0FF1D: ["<wide>", 0x003D],  # FULLWIDTH EQUALS SIGN
    0x0FF1E: ["<wide>", 0x003E],  # FULLWIDTH GREATER-THAN SIGN
    0x0FF1F: ["<wide>", 0x003F],  # FULLWIDTH QUESTION MARK
    0x0FF20: ["<wide>", 0x0040],  # FULLWIDTH COMMERCIAL AT
    0x0FF21: ["<wide>", 0x0041],  # FULLWIDTH LATIN CAPITAL LETTER A
    0x0FF22: ["<wide>", 0x0042],  # FULLWIDTH LATIN CAPITAL LETTER B
    0x0FF23: ["<wide>", 0x0043],  # FULLWIDTH LATIN CAPITAL LETTER C
    0x0FF24: ["<wide>", 0x0044],  # FULLWIDTH LATIN CAPITAL LETTER D
    0x0FF25: ["<wide>", 0x0045],  # FULLWIDTH LATIN CAPITAL LETTER E
    0x0FF26: ["<wide>", 0x0046],  # FULLWIDTH LATIN CAPITAL LETTER F
    0x0FF27: ["<wide>", 0x0047],  # FULLWIDTH LATIN CAPITAL LETTER G
    0x0FF28: ["<wide>", 0x0048],  # FULLWIDTH LATIN CAPITAL LETTER H
    0x0FF29: ["<wide>", 0x0049],  # FULLWIDTH LATIN CAPITAL LETTER I
    0x0FF2A: ["<wide>", 0x004A],  # FULLWIDTH LATIN CAPITAL LETTER J
    0x0FF2B: ["<wide>", 0x004B],  # FULLWIDTH LATIN CAPITAL LETTER K
    0x0FF2C: ["<wide>", 0x004C],  # FULLWIDTH LATIN CAPITAL LETTER L
    0x0FF2D: ["<wide>", 0x004D],  # FULLWIDTH LATIN CAPITAL LETTER M
    0x0FF2E: ["<wide>", 0x004E],  # FULLWIDTH LATIN CAPITAL LETTER N
    0x0FF2F: ["<wide>", 0x004F],  # FULLWIDTH LATIN CAPITAL LETTER O
    0x0FF30: ["<wide>", 0x0050],  # FULLWIDTH LATIN CAPITAL LETTER P
    0x0FF31: ["<wide>", 0x0051],  # FULLWIDTH LATIN CAPITAL LETTER Q
    0x0FF32: ["<wide>", 0x0052],  # FULLWIDTH LATIN CAPITAL LETTER R
    0x0FF33: ["<wide>", 0x0053],  # FULLWIDTH LATIN CAPITAL LETTER S
    0x0FF34: ["<wide>", 0x0054],  # FULLWIDTH LATIN CAPITAL LETTER T
    0x0FF35: ["<wide>", 0x0055],  # FULLWIDTH LATIN CAPITAL LETTER U
    0x0FF36: ["<wide>", 0x0056],  # FULLWIDTH LATIN CAPITAL LETTER V
    0x0FF37: ["<wide>", 0x0057],  # FULLWIDTH LATIN CAPITAL LETTER W
    0x0FF38: ["<wide>", 0x0058],  # FULLWIDTH LATIN CAPITAL LETTER X
    0x0FF39: ["<wide>", 0x0059],  # FULLWIDTH LATIN CAPITAL LETTER Y
    0x0FF3A: ["<wide>", 0x005A],  # FULLWIDTH LATIN CAPITAL LETTER Z
    0x0FF3B: ["<wide>", 0x005B],  # FULLWIDTH LEFT SQUARE BRACKET
    0x0FF3C: ["<wide>", 0x005C],  # FULLWIDTH REVERSE SOLIDUS
    0x0FF3D: ["<wide>", 0x005D],  # FULLWIDTH RIGHT SQUARE BRACKET
    0x0FF3E: ["<wide>", 0x005E],  # FULLWIDTH CIRCUMFLEX ACCENT
    0x0FF3F: ["<wide>", 0x005F],  # FULLWIDTH LOW LINE
    0x0FF40: ["<wide>", 0x0060],  # FULLWIDTH GRAVE ACCENT
    0x0FF41: ["<wide>", 0x0061],  # FULLWIDTH LATIN SMALL LETTER A
    0x0FF42: ["<wide>", 0x0062],  # FULLWIDTH LATIN SMALL LETTER B
    0x0FF43: ["<wide>", 0x0063],  # FULLWIDTH LATIN SMALL LETTER C
    0x0FF44: ["<wide>", 0x0064],  # FULLWIDTH LATIN SMALL LETTER D
    0x0FF45: ["<wide>", 0x0065],  # FULLWIDTH LATIN SMALL LETTER E
    0x0FF46: ["<wide>", 0x0066],  # FULLWIDTH LATIN SMALL LETTER F
    0x0FF47: ["<wide>", 0x0067],  # FULLWIDTH LATIN SMALL LETTER G
    0x0FF48: ["<wide>", 0x0068],  # FULLWIDTH LATIN SMALL LETTER H
    0x0FF49: ["<wide>", 0x0069],  # FULLWIDTH LATIN SMALL LETTER I
    0x0FF4A: ["<wide>", 0x006A],  # FULLWIDTH LATIN SMALL LETTER J
    0x0FF4B: ["<wide>", 0x006B],  # FULLWIDTH LATIN SMALL LETTER K
    0x0FF4C: ["<wide>", 0x006C],  # FULLWIDTH LATIN SMALL LETTER L
    0x0FF4D: ["<wide>", 0x006D],  # FULLWIDTH LATIN SMALL LETTER M
    0x0FF4E: ["<wide>", 0x006E],  # FULLWIDTH LATIN SMALL LETTER N
    0x0FF4F: ["<wide>", 0x006F],  # FULLWIDTH LATIN SMALL LETTER O
    0x0FF50: ["<wide>", 0x0070],  # FULLWIDTH LATIN SMALL LETTER P
    0x0FF51: ["<wide>", 0x0071],  # FULLWIDTH LATIN SMALL LETTER Q
    0x0FF52: ["<wide>", 0x0072],  # FULLWIDTH LATIN SMALL LETTER R
    0x0FF53: ["<wide>", 0x0073],  # FULLWIDTH LATIN SMALL LETTER S
    0x0FF54: ["<wide>", 0x0074],  # FULLWIDTH LATIN SMALL LETTER T
    0x0FF55: ["<wide>", 0x0075],  # FULLWIDTH LATIN SMALL LETTER U
    0x0FF56: ["<wide>", 0x0076],  # FULLWIDTH LATIN SMALL LETTER V
    0x0FF57: ["<wide>", 0x0077],  # FULLWIDTH LATIN SMALL LETTER W
    0x0FF58: ["<wide>", 0x0078],  # FULLWIDTH LATIN SMALL LETTER X
    0x0FF59: ["<wide>", 0x0079],  # FULLWIDTH LATIN SMALL LETTER Y
    0x0FF5A: ["<wide>", 0x007A],  # FULLWIDTH LATIN SMALL LETTER Z
    0x0FF5B: ["<wide>", 0x007B],  # FULLWIDTH LEFT CURLY BRACKET
    0x0FF5C: ["<wide>", 0x007C],  # FULLWIDTH VERTICAL LINE
    0x0FF5D: ["<wide>", 0x007D],  # FULLWIDTH RIGHT CURLY BRACKET
    0x0FF5E: ["<wide>", 0x007E],  # FULLWIDTH TILDE
    0x0FF5F: ["<wide>", 0x2985],  # FULLWIDTH LEFT WHITE PARENTHESIS
    0x0FF60: ["<wide>", 0x2986],  # FULLWIDTH RIGHT WHITE PARENTHESIS
    0x0FF61: ["<narrow>", 0x3002],  # HALFWIDTH IDEOGRAPHIC FULL STOP
    0x0FF62: ["<narrow>", 0x300C],  # HALFWIDTH LEFT CORNER BRACKET
    0x0FF63: ["<narrow>", 0x300D],  # HALFWIDTH RIGHT CORNER BRACKET
    0x0FF64: ["<narrow>", 0x3001],  # HALFWIDTH IDEOGRAPHIC COMMA
    0x0FF65: ["<narrow>", 0x30FB],  # HALFWIDTH KATAKANA MIDDLE DOT
    0x0FF66: ["<narrow>", 0x30F2],  # HALFWIDTH KATAKANA LETTER WO
    0x0FF67: ["<narrow>", 0x30A1],  # HALFWIDTH KATAKANA LETTER SMALL A
    0x0FF68: ["<narrow>", 0x30A3],  # HALFWIDTH KATAKANA LETTER SMALL I
    0x0FF69: ["<narrow>", 0x30A5],  # HALFWIDTH KATAKANA LETTER SMALL U
    0x0FF6A: ["<narrow>", 0x30A7],  # HALFWIDTH KATAKANA LETTER SMALL E
    0x0FF6B: ["<narrow>", 0x30A9],  # HALFWIDTH KATAKANA LETTER SMALL O
    0x0FF6C: ["<narrow>", 0x30E3],  # HALFWIDTH KATAKANA LETTER SMALL YA
    0x0FF6D: ["<narrow>", 0x30E5],  # HALFWIDTH KATAKANA LETTER SMALL YU
    0x0FF6E: ["<narrow>", 0x30E7],  # HALFWIDTH KATAKANA LETTER SMALL YO
    0x0FF6F: ["<narrow>", 0x30C3],  # HALFWIDTH KATAKANA LETTER SMALL TU
    0x0FF70: ["<narrow>", 0x30FC],  # HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK
    0x0FF71: ["<narrow>", 0x30A2],  # HALFWIDTH KATAKANA LETTER A
    0x0FF72: ["<narrow>", 0x30A4],  # HALFWIDTH KATAKANA LETTER I
    0x0FF73: ["<narrow>", 0x30A6],  # HALFWIDTH KATAKANA LETTER U
    0x0FF74: ["<narrow>", 0x30A8],  # HALFWIDTH KATAKANA LETTER E
    0x0FF75: ["<narrow>", 0x30AA],  # HALFWIDTH KATAKANA LETTER O
    0x0FF76: ["<narrow>", 0x30AB],  # HALFWIDTH KATAKANA LETTER KA
    0x0FF77: ["<narrow>", 0x30AD],  # HALFWIDTH KATAKANA LETTER KI
    0x0FF78: ["<narrow>", 0x30AF],  # HALFWIDTH KATAKANA LETTER KU
    0x0FF79: ["<narrow>", 0x30B1],  # HALFWIDTH KATAKANA LETTER KE
    0x0FF7A: ["<narrow>", 0x30B3],  # HALFWIDTH KATAKANA LETTER KO
    0x0FF7B: ["<narrow>", 0x30B5],  # HALFWIDTH KATAKANA LETTER SA
    0x0FF7C: ["<narrow>", 0x30B7],  # HALFWIDTH KATAKANA LETTER SI
    0x0FF7D: ["<narrow>", 0x30B9],  # HALFWIDTH KATAKANA LETTER SU
    0x0FF7E: ["<narrow>", 0x30BB],  # HALFWIDTH KATAKANA LETTER SE
    0x0FF7F: ["<narrow>", 0x30BD],  # HALFWIDTH KATAKANA LETTER SO
    0x0FF80: ["<narrow>", 0x30BF],  # HALFWIDTH KATAKANA LETTER TA
    0x0FF81: ["<narrow>", 0x30C1],  # HALFWIDTH KATAKANA LETTER TI
    0x0FF82: ["<narrow>", 0x30C4],  # HALFWIDTH KATAKANA LETTER TU
    0x0FF83: ["<narrow>", 0x30C6],  # HALFWIDTH KATAKANA LETTER TE
    0x0FF84: ["<narrow>", 0x30C8],  # HALFWIDTH KATAKANA LETTER TO
    0x0FF85: ["<narrow>", 0x30CA],  # HALFWIDTH KATAKANA LETTER NA
    0x0FF86: ["<narrow>", 0x30CB],  # HALFWIDTH KATAKANA LETTER NI
    0x0FF87: ["<narrow>", 0x30CC],  # HALFWIDTH KATAKANA LETTER NU
    0x0FF88: ["<narrow>", 0x30CD],  # HALFWIDTH KATAKANA LETTER NE
    0x0FF89: ["<narrow>", 0x30CE],  # HALFWIDTH KATAKANA LETTER NO
    0x0FF8A: ["<narrow>", 0x30CF],  # HALFWIDTH KATAKANA LETTER HA
    0x0FF8B: ["<narrow>", 0x30D2],  # HALFWIDTH KATAKANA LETTER HI
    0x0FF8C: ["<narrow>", 0x30D5],  # HALFWIDTH KATAKANA LETTER HU
    0x0FF8D: ["<narrow>", 0x30D8],  # HALFWIDTH KATAKANA LETTER HE
    0x0FF8E: ["<narrow>", 0x30DB],  # HALFWIDTH KATAKANA LETTER HO
    0x0FF8F: ["<narrow>", 0x30DE],  # HALFWIDTH KATAKANA LETTER MA
    0x0FF90: ["<narrow>", 0x30DF],  # HALFWIDTH KATAKANA LETTER MI
    0x0FF91: ["<narrow>", 0x30E0],  # HALFWIDTH KATAKANA LETTER MU
    0x0FF92: ["<narrow>", 0x30E1],  # HALFWIDTH KATAKANA LETTER ME
    0x0FF93: ["<narrow>", 0x30E2],  # HALFWIDTH KATAKANA LETTER MO
    0x0FF94: ["<narrow>", 0x30E4],  # HALFWIDTH KATAKANA LETTER YA
    0x0FF95: ["<narrow>", 0x30E6],  # HALFWIDTH KATAKANA LETTER YU
    0x0FF96: ["<narrow>", 0x30E8],  # HALFWIDTH KATAKANA LETTER YO
    0x0FF97: ["<narrow>", 0x30E9],  # HALFWIDTH KATAKANA LETTER RA
    0x0FF98: ["<narrow>", 0x30EA],  # HALFWIDTH KATAKANA LETTER RI
    0x0FF99: ["<narrow>", 0x30EB],  # HALFWIDTH KATAKANA LETTER RU
    0x0FF9A: ["<narrow>", 0x30EC],  # HALFWIDTH KATAKANA LETTER RE
    0x0FF9B: ["<narrow>", 0x30ED],  # HALFWIDTH KATAKANA LETTER RO
    0x0FF9C: ["<narrow>", 0x30EF],  # HALFWIDTH KATAKANA LETTER WA
    0x0FF9D: ["<narrow>", 0x30F3],  # HALFWIDTH KATAKANA LETTER N
    0x0FF9E: ["<narrow>", 0x3099],  # HALFWIDTH KATAKANA VOICED SOUND MARK
    0x0FF9F: ["<narrow>", 0x309A],  # HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK
    0x0FFA0: ["<narrow>", 0x3164],  # HALFWIDTH HANGUL FILLER
    0x0FFA1: ["<narrow>", 0x3131],  # HALFWIDTH HANGUL LETTER KIYEOK
    0x0FFA2: ["<narrow>", 0x3132],  # HALFWIDTH HANGUL LETTER SSANGKIYEOK
    0x0FFA3: ["<narrow>", 0x3133],  # HALFWIDTH HANGUL LETTER KIYEOK-SIOS
    0x0FFA4: ["<narrow>", 0x3134],  # HALFWIDTH HANGUL LETTER NIEUN
    0x0FFA5: ["<narrow>", 0x3135],  # HALFWIDTH HANGUL LETTER NIEUN-CIEUC
    0x0FFA6: ["<narrow>", 0x3136],  # HALFWIDTH HANGUL LETTER NIEUN-HIEUH
    0x0FFA7: ["<narrow>", 0x3137],  # HALFWIDTH HANGUL LETTER TIKEUT
    0x0FFA8: ["<narrow>", 0x3138],  # HALFWIDTH HANGUL LETTER SSANGTIKEUT
    0x0FFA9: ["<narrow>", 0x3139],  # HALFWIDTH HANGUL LETTER RIEUL
    0x0FFAA: ["<narrow>", 0x313A],  # HALFWIDTH HANGUL LETTER RIEUL-KIYEOK
    0x0FFAB: ["<narrow>", 0x313B],  # HALFWIDTH HANGUL LETTER RIEUL-MIEUM
    0x0FFAC: ["<narrow>", 0x313C],  # HALFWIDTH HANGUL LETTER RIEUL-PIEUP
    0x0FFAD: ["<narrow>", 0x313D],  # HALFWIDTH HANGUL LETTER RIEUL-SIOS
    0x0FFAE: ["<narrow>", 0x313E],  # HALFWIDTH HANGUL LETTER RIEUL-THIEUTH
    0x0FFAF: ["<narrow>", 0x313F],  # HALFWIDTH HANGUL LETTER RIEUL-PHIEUPH
    0x0FFB0: ["<narrow>", 0x3140],  # HALFWIDTH HANGUL LETTER RIEUL-HIEUH
    0x0FFB1: ["<narrow>", 0x3141],  # HALFWIDTH HANGUL LETTER MIEUM
    0x0FFB2: ["<narrow>", 0x3142],  # HALFWIDTH HANGUL LETTER PIEUP
    0x0FFB3: ["<narrow>", 0x3143],  # HALFWIDTH HANGUL LETTER SSANGPIEUP
    0x0FFB4: ["<narrow>", 0x3144],  # HALFWIDTH HANGUL LETTER PIEUP-SIOS
    0x0FFB5: ["<narrow>", 0x3145],  # HALFWIDTH HANGUL LETTER SIOS
    0x0FFB6: ["<narrow>", 0x3146],  # HALFWIDTH HANGUL LETTER SSANGSIOS
    0x0FFB7: ["<narrow>", 0x3147],  # HALFWIDTH HANGUL LETTER IEUNG
    0x0FFB8: ["<narrow>", 0x3148],  # HALFWIDTH HANGUL LETTER CIEUC
    0x0FFB9: ["<narrow>", 0x3149],  # HALFWIDTH HANGUL LETTER SSANGCIEUC
    0x0FFBA: ["<narrow>", 0x314A],  # HALFWIDTH HANGUL LETTER CHIEUCH
    0x0FFBB: ["<narrow>", 0x314B],  # HALFWIDTH HANGUL LETTER KHIEUKH
    0x0FFBC: ["<narrow>", 0x314C],  # HALFWIDTH HANGUL LETTER THIEUTH
    0x0FFBD: ["<narrow>", 0x314D],  # HALFWIDTH HANGUL LETTER PHIEUPH
    0x0FFBE: ["<narrow>", 0x314E],  # HALFWIDTH HANGUL LETTER HIEUH
    0x0FFC2: ["<narrow>", 0x314F],  # HALFWIDTH HANGUL LETTER A
    0x0FFC3: ["<narrow>", 0x3150],  # HALFWIDTH HANGUL LETTER AE
    0x0FFC4: ["<narrow>", 0x3151],  # HALFWIDTH HANGUL LETTER YA
    0x0FFC5: ["<narrow>", 0x3152],  # HALFWIDTH HANGUL LETTER YAE
    0x0FFC6: ["<narrow>", 0x3153],  # HALFWIDTH HANGUL LETTER EO
    0x0FFC7: ["<narrow>", 0x3154],  # HALFWIDTH HANGUL LETTER E
    0x0FFCA: ["<narrow>", 0x3155],  # HALFWIDTH HANGUL LETTER YEO
    0x0FFCB: ["<narrow>", 0x3156],  # HALFWIDTH HANGUL LETTER YE
    0x0FFCC: ["<narrow>", 0x3157],  # HALFWIDTH HANGUL LETTER O
    0x0FFCD: ["<narrow>", 0x3158],  # HALFWIDTH HANGUL LETTER WA
    0x0FFCE: ["<narrow>", 0x3159],  # HALFWIDTH HANGUL LETTER WAE
    0x0FFCF: ["<narrow>", 0x315A],  # HALFWIDTH HANGUL LETTER OE
    0x0FFD2: ["<narrow>", 0x315B],  # HALFWIDTH HANGUL LETTER YO
    0x0FFD3: ["<narrow>", 0x315C],  # HALFWIDTH HANGUL LETTER U
    0x0FFD4: ["<narrow>", 0x315D],  # HALFWIDTH HANGUL LETTER WEO
    0x0FFD5: ["<narrow>", 0x315E],  # HALFWIDTH HANGUL LETTER WE
    0x0FFD6: ["<narrow>", 0x315F],  # HALFWIDTH HANGUL LETTER WI
    0x0FFD7: ["<narrow>", 0x3160],  # HALFWIDTH HANGUL LETTER YU
    0x0FFDA: ["<narrow>", 0x3161],  # HALFWIDTH HANGUL LETTER EU
    0x0FFDB: ["<narrow>", 0x3162],  # HALFWIDTH HANGUL LETTER YI
    0x0FFDC: ["<narrow>", 0x3163],  # HALFWIDTH HANGUL LETTER I
    0x0FFE0: ["<wide>", 0x00A2],  # FULLWIDTH CENT SIGN
    0x0FFE1: ["<wide>", 0x00A3],  # FULLWIDTH POUND SIGN
    0x0FFE2: ["<wide>", 0x00AC],  # FULLWIDTH NOT SIGN
    0x0FFE3: ["<wide>", 0x00AF],  # FULLWIDTH MACRON
    0x0FFE4: ["<wide>", 0x00A6],  # FULLWIDTH BROKEN BAR
    0x0FFE5: ["<wide>", 0x00A5],  # FULLWIDTH YEN SIGN
    0x0FFE6: ["<wide>", 0x20A9],  # FULLWIDTH WON SIGN
    0x0FFE8: ["<narrow>", 0x2502],  # HALFWIDTH FORMS LIGHT VERTICAL
    0x0FFE9: ["<narrow>", 0x2190],  # HALFWIDTH LEFTWARDS ARROW
    0x0FFEA: ["<narrow>", 0x2191],  # HALFWIDTH UPWARDS ARROW
    0x0FFEB: ["<narrow>", 0x2192],  # HALFWIDTH RIGHTWARDS ARROW
    0x0FFEC: ["<narrow>", 0x2193],  # HALFWIDTH DOWNWARDS ARROW
    0x0FFED: ["<narrow>", 0x25A0],  # HALFWIDTH BLACK SQUARE
    0x0FFEE: ["<narrow>", 0x25CB],  # HALFWIDTH WHITE CIRCLE
    0x10781: ["<super>", 0x02D0],  # MODIFIER LETTER SUPERSCRIPT TRIANGULAR COLON
    0x10782: ["<super>", 0x02D1],  # MODIFIER LETTER SUPERSCRIPT HALF TRIANGULAR COLON
    0x10783: ["<super>", 0x00E6],  # MODIFIER LETTER SMALL AE
    0x10784: ["<super>", 0x0299],  # MODIFIER LETTER SMALL CAPITAL B
    0x10785: ["<super>", 0x0253],  # MODIFIER LETTER SMALL B WITH HOOK
    0x10787: ["<super>", 0x02A3],  # MODIFIER LETTER SMALL DZ DIGRAPH
    0x10788: ["<super>", 0xAB66],  # MODIFIER LETTER SMALL DZ DIGRAPH WITH RETROFLEX HOOK
    0x10789: ["<super>", 0x02A5],  # MODIFIER LETTER SMALL DZ DIGRAPH WITH CURL
    0x1078A: ["<super>", 0x02A4],  # MODIFIER LETTER SMALL DEZH DIGRAPH
    0x1078B: ["<super>", 0x0256],  # MODIFIER LETTER SMALL D WITH TAIL
    0x1078C: ["<super>", 0x0257],  # MODIFIER LETTER SMALL D WITH HOOK
    0x1078D: ["<super>", 0x1D91],  # MODIFIER LETTER SMALL D WITH HOOK AND TAIL
    0x1078E: ["<super>", 0x0258],  # MODIFIER LETTER SMALL REVERSED E
    0x1078F: ["<super>", 0x025E],  # MODIFIER LETTER SMALL CLOSED REVERSED OPEN E
    0x10790: ["<super>", 0x02A9],  # MODIFIER LETTER SMALL FENG DIGRAPH
    0x10791: ["<super>", 0x0264],  # MODIFIER LETTER SMALL RAMS HORN
    0x10792: ["<super>", 0x0262],  # MODIFIER LETTER SMALL CAPITAL G
    0x10793: ["<super>", 0x0260],  # MODIFIER LETTER SMALL G WITH HOOK
    0x10794: ["<super>", 0x029B],  # MODIFIER LETTER SMALL CAPITAL G WITH HOOK
    0x10795: ["<super>", 0x0127],  # MODIFIER LETTER SMALL H WITH STROKE
    0x10796: ["<super>", 0x029C],  # MODIFIER LETTER SMALL CAPITAL H
    0x10797: ["<super>", 0x0267],  # MODIFIER LETTER SMALL HENG WITH HOOK
    0x10798: ["<super>", 0x0284],  # MODIFIER LETTER SMALL DOTLESS J WITH STROKE AND HOOK
    0x10799: ["<super>", 0x02AA],  # MODIFIER LETTER SMALL LS DIGRAPH
    0x1079A: ["<super>", 0x02AB],  # MODIFIER LETTER SMALL LZ DIGRAPH
    0x1079B: ["<super>", 0x026C],  # MODIFIER LETTER SMALL L WITH BELT
    0x1079C: ["<super>", 0x1DF04],  # MODIFIER LETTER SMALL CAPITAL L WITH BELT
    0x1079D: ["<super>", 0xA78E],  # MODIFIER LETTER SMALL L WITH RETROFLEX HOOK AND BELT
    0x1079E: ["<super>", 0x026E],  # MODIFIER LETTER SMALL LEZH
    0x1079F: ["<super>", 0x1DF05],  # MODIFIER LETTER SMALL LEZH WITH RETROFLEX HOOK
    0x107A0: ["<super>", 0x028E],  # MODIFIER LETTER SMALL TURNED Y
    0x107A1: ["<super>", 0x1DF06],  # MODIFIER LETTER SMALL TURNED Y WITH BELT
    0x107A2: ["<super>", 0x00F8],  # MODIFIER LETTER SMALL O WITH STROKE
    0x107A3: ["<super>", 0x0276],  # MODIFIER LETTER SMALL CAPITAL OE
    0x107A4: ["<super>", 0x0277],  # MODIFIER LETTER SMALL CLOSED OMEGA
    0x107A5: ["<super>", 0x0071],  # MODIFIER LETTER SMALL Q
    0x107A6: ["<super>", 0x027A],  # MODIFIER LETTER SMALL TURNED R WITH LONG LEG
    0x107A7: ["<super>", 0x1DF08],  # MODIFIER LETTER SMALL TURNED R WITH LONG LEG AND RETROFLEX HOOK
    0x107A8: ["<super>", 0x027D],  # MODIFIER LETTER SMALL R WITH TAIL
    0x107A9: ["<super>", 0x027E],  # MODIFIER LETTER SMALL R WITH FISHHOOK
    0x107AA: ["<super>", 0x0280],  # MODIFIER LETTER SMALL CAPITAL R
    0x107AB: ["<super>", 0x02A8],  # MODIFIER LETTER SMALL TC DIGRAPH WITH CURL
    0x107AC: ["<super>", 0x02A6],  # MODIFIER LETTER SMALL TS DIGRAPH
    0x107AD: ["<super>", 0xAB67],  # MODIFIER LETTER SMALL TS DIGRAPH WITH RETROFLEX HOOK
    0x107AE: ["<super>", 0x02A7],  # MODIFIER LETTER SMALL TESH DIGRAPH
    0x107AF: ["<super>", 0x0288],  # MODIFIER LETTER SMALL T WITH RETROFLEX HOOK
    0x107B0: ["<super>", 0x2C71],  # MODIFIER LETTER SMALL V WITH RIGHT HOOK
    0x107B2: ["<super>", 0x028F],  # MODIFIER LETTER SMALL CAPITAL Y
    0x107B3: ["<super>", 0x02A1],  # MODIFIER LETTER GLOTTAL STOP WITH STROKE
    0x107B4: ["<super>", 0x02A2],  # MODIFIER LETTER REVERSED GLOTTAL STOP WITH STROKE
    0x107B5: ["<super>", 0x0298],  # MODIFIER LETTER BILABIAL CLICK
    0x107B6: ["<super>", 0x01C0],  # MODIFIER LETTER DENTAL CLICK
    0x107B7: ["<super>", 0x01C1],  # MODIFIER LETTER LATERAL CLICK
    0x107B8: ["<super>", 0x01C2],  # MODIFIER LETTER ALVEOLAR CLICK
    0x107B9: ["<super>", 0x1DF0A],  # MODIFIER LETTER RETROFLEX CLICK WITH RETROFLEX HOOK
    0x107BA: ["<super>", 0x1DF1E],  # MODIFIER LETTER SMALL S WITH CURL
    0x1109A: [0x11099, 0x110BA],  # KAITHI LETTER DDDHA
    0x1109C: [0x1109B, 0x110BA],  # KAITHI LETTER RHA
    0x110AB: [0x110A5, 0x110BA],  # KAITHI LETTER VA
    0x1112E: [0x11131, 0x11127],  # CHAKMA VOWEL SIGN O
    0x1112F: [0x11132, 0x11127],  # CHAKMA VOWEL SIGN AU
    0x1134B: [0x11347, 0x1133E],  # GRANTHA VOWEL SIGN OO
    0x1134C: [0x11347, 0x11357],  # GRANTHA VOWEL SIGN AU
    0x114BB: [0x114B9, 0x114BA],  # TIRHUTA VOWEL SIGN AI
    0x114BC: [0x114B9, 0x114B0],  # TIRHUTA VOWEL SIGN O
    0x114BE: [0x114B9, 0x114BD],  # TIRHUTA VOWEL SIGN AU
    0x115BA: [0x115B8, 0x115AF],  # SIDDHAM VOWEL SIGN O
    0x115BB: [0x115B9, 0x115AF],  # SIDDHAM VOWEL SIGN AU
    0x11938: [0x11935, 0x11930],  # DIVES AKURU VOWEL SIGN O
    0x1D15E: [0x1D157, 0x1D165],  # MUSICAL SYMBOL HALF NOTE
    0x1D15F: [0x1D158, 0x1D165],  # MUSICAL SYMBOL QUARTER NOTE
    0x1D160: [0x1D15F, 0x1D16E],  # MUSICAL SYMBOL EIGHTH NOTE
    0x1D161: [0x1D15F, 0x1D16F],  # MUSICAL SYMBOL SIXTEENTH NOTE
    0x1D162: [0x1D15F, 0x1D170],  # MUSICAL SYMBOL THIRTY-SECOND NOTE
    0x1D163: [0x1D15F, 0x1D171],  # MUSICAL SYMBOL SIXTY-FOURTH NOTE
    0x1D164: [0x1D15F, 0x1D172],  # MUSICAL SYMBOL ONE HUNDRED TWENTY-EIGHTH NOTE
    0x1D1BB: [0x1D1B9, 0x1D165],  # MUSICAL SYMBOL MINIMA
    0x1D1BC: [0x1D1BA, 0x1D165],  # MUSICAL SYMBOL MINIMA BLACK
    0x1D1BD: [0x1D1BB, 0x1D16E],  # MUSICAL SYMBOL SEMIMINIMA WHITE
    0x1D1BE: [0x1D1BC, 0x1D16E],  # MUSICAL SYMBOL SEMIMINIMA BLACK
    0x1D1BF: [0x1D1BB, 0x1D16F],  # MUSICAL SYMBOL FUSA WHITE
    0x1D1C0: [0x1D1BC, 0x1D16F],  # MUSICAL SYMBOL FUSA BLACK
    0x1D400: ["<font>", 0x0041],  # MATHEMATICAL BOLD CAPITAL A
    0x1D401: ["<font>", 0x0042],  # MATHEMATICAL BOLD CAPITAL B
    0x1D402: ["<font>", 0x0043],  # MATHEMATICAL BOLD CAPITAL C
    0x1D403: ["<font>", 0x0044],  # MATHEMATICAL BOLD CAPITAL D
    0x1D404: ["<font>", 0x0045],  # MATHEMATICAL BOLD CAPITAL E
    0x1D405: ["<font>", 0x0046],  # MATHEMATICAL BOLD CAPITAL F
    0x1D406: ["<font>", 0x0047],  # MATHEMATICAL BOLD CAPITAL G
    0x1D407: ["<font>", 0x0048],  # MATHEMATICAL BOLD CAPITAL H
    0x1D408: ["<font>", 0x0049],  # MATHEMATICAL BOLD CAPITAL I
    0x1D409: ["<font>", 0x004A],  # MATHEMATICAL BOLD CAPITAL J
    0x1D40A: ["<font>", 0x004B],  # MATHEMATICAL BOLD CAPITAL K
    0x1D40B: ["<font>", 0x004C],  # MATHEMATICAL BOLD CAPITAL L
    0x1D40C: ["<font>", 0x004D],  # MATHEMATICAL BOLD CAPITAL M
    0x1D40D: ["<font>", 0x004E],  # MATHEMATICAL BOLD CAPITAL N
    0x1D40E: ["<font>", 0x004F],  # MATHEMATICAL BOLD CAPITAL O
    0x1D40F: ["<font>", 0x0050],  # MATHEMATICAL BOLD CAPITAL P
    0x1D410: ["<font>", 0x0051],  # MATHEMATICAL BOLD CAPITAL Q
    0x1D411: ["<font>", 0x0052],  # MATHEMATICAL BOLD CAPITAL R
    0x1D412: ["<font>", 0x0053],  # MATHEMATICAL BOLD CAPITAL S
    0x1D413: ["<font>", 0x0054],  # MATHEMATICAL BOLD CAPITAL T
    0x1D414: ["<font>", 0x0055],  # MATHEMATICAL BOLD CAPITAL U
    0x1D415: ["<font>", 0x0056],  # MATHEMATICAL BOLD CAPITAL V
    0x1D416: ["<font>", 0x0057],  # MATHEMATICAL BOLD CAPITAL W
    0x1D417: ["<font>", 0x0058],  # MATHEMATICAL BOLD CAPITAL X
    0x1D418: ["<font>", 0x0059],  # MATHEMATICAL BOLD CAPITAL Y
    0x1D419: ["<font>", 0x005A],  # MATHEMATICAL BOLD CAPITAL Z
    0x1D41A: ["<font>", 0x0061],  # MATHEMATICAL BOLD SMALL A
    0x1D41B: ["<font>", 0x0062],  # MATHEMATICAL BOLD SMALL B
    0x1D41C: ["<font>", 0x0063],  # MATHEMATICAL BOLD SMALL C
    0x1D41D: ["<font>", 0x0064],  # MATHEMATICAL BOLD SMALL D
    0x1D41E: ["<font>", 0x0065],  # MATHEMATICAL BOLD SMALL E
    0x1D41F: ["<font>", 0x0066],  # MATHEMATICAL BOLD SMALL F
    0x1D420: ["<font>", 0x0067],  # MATHEMATICAL BOLD SMALL G
    0x1D421: ["<font>", 0x0068],  # MATHEMATICAL BOLD SMALL H
    0x1D422: ["<font>", 0x0069],  # MATHEMATICAL BOLD SMALL I
    0x1D423: ["<font>", 0x006A],  # MATHEMATICAL BOLD SMALL J
    0x1D424: ["<font>", 0x006B],  # MATHEMATICAL BOLD SMALL K
    0x1D425: ["<font>", 0x006C],  # MATHEMATICAL BOLD SMALL L
    0x1D426: ["<font>", 0x006D],  # MATHEMATICAL BOLD SMALL M
    0x1D427: ["<font>", 0x006E],  # MATHEMATICAL BOLD SMALL N
    0x1D428: ["<font>", 0x006F],  # MATHEMATICAL BOLD SMALL O
    0x1D429: ["<font>", 0x0070],  # MATHEMATICAL BOLD SMALL P
    0x1D42A: ["<font>", 0x0071],  # MATHEMATICAL BOLD SMALL Q
    0x1D42B: ["<font>", 0x0072],  # MATHEMATICAL BOLD SMALL R
    0x1D42C: ["<font>", 0x0073],  # MATHEMATICAL BOLD SMALL S
    0x1D42D: ["<font>", 0x0074],  # MATHEMATICAL BOLD SMALL T
    0x1D42E: ["<font>", 0x0075],  # MATHEMATICAL BOLD SMALL U
    0x1D42F: ["<font>", 0x0076],  # MATHEMATICAL BOLD SMALL V
    0x1D430: ["<font>", 0x0077],  # MATHEMATICAL BOLD SMALL W
    0x1D431: ["<font>", 0x0078],  # MATHEMATICAL BOLD SMALL X
    0x1D432: ["<font>", 0x0079],  # MATHEMATICAL BOLD SMALL Y
    0x1D433: ["<font>", 0x007A],  # MATHEMATICAL BOLD SMALL Z
    0x1D434: ["<font>", 0x0041],  # MATHEMATICAL ITALIC CAPITAL A
    0x1D435: ["<font>", 0x0042],  # MATHEMATICAL ITALIC CAPITAL B
    0x1D436: ["<font>", 0x0043],  # MATHEMATICAL ITALIC CAPITAL C
    0x1D437: ["<font>", 0x0044],  # MATHEMATICAL ITALIC CAPITAL D
    0x1D438: ["<font>", 0x0045],  # MATHEMATICAL ITALIC CAPITAL E
    0x1D439: ["<font>", 0x0046],  # MATHEMATICAL ITALIC CAPITAL F
    0x1D43A: ["<font>", 0x0047],  # MATHEMATICAL ITALIC CAPITAL G
    0x1D43B: ["<font>", 0x0048],  # MATHEMATICAL ITALIC CAPITAL H
    0x1D43C: ["<font>", 0x0049],  # MATHEMATICAL ITALIC CAPITAL I
    0x1D43D: ["<font>", 0x004A],  # MATHEMATICAL ITALIC CAPITAL J
    0x1D43E: ["<font>", 0x004B],  # MATHEMATICAL ITALIC CAPITAL K
    0x1D43F: ["<font>", 0x004C],  # MATHEMATICAL ITALIC CAPITAL L
    0x1D440: ["<font>", 0x004D],  # MATHEMATICAL ITALIC CAPITAL M
    0x1D441: ["<font>", 0x004E],  # MATHEMATICAL ITALIC CAPITAL N
    0x1D442: ["<font>", 0x004F],  # MATHEMATICAL ITALIC CAPITAL O
    0x1D443: ["<font>", 0x0050],  # MATHEMATICAL ITALIC CAPITAL P
    0x1D444: ["<font>", 0x0051],  # MATHEMATICAL ITALIC CAPITAL Q
    0x1D445: ["<font>", 0x0052],  # MATHEMATICAL ITALIC CAPITAL R
    0x1D446: ["<font>", 0x0053],  # MATHEMATICAL ITALIC CAPITAL S
    0x1D447: ["<font>", 0x0054],  # MATHEMATICAL ITALIC CAPITAL T
    0x1D448: ["<font>", 0x0055],  # MATHEMATICAL ITALIC CAPITAL U
    0x1D449: ["<font>", 0x0056],  # MATHEMATICAL ITALIC CAPITAL V
    0x1D44A: ["<font>", 0x0057],  # MATHEMATICAL ITALIC CAPITAL W
    0x1D44B: ["<font>", 0x0058],  # MATHEMATICAL ITALIC CAPITAL X
    0x1D44C: ["<font>", 0x0059],  # MATHEMATICAL ITALIC CAPITAL Y
    0x1D44D: ["<font>", 0x005A],  # MATHEMATICAL ITALIC CAPITAL Z
    0x1D44E: ["<font>", 0x0061],  # MATHEMATICAL ITALIC SMALL A
    0x1D44F: ["<font>", 0x0062],  # MATHEMATICAL ITALIC SMALL B
    0x1D450: ["<font>", 0x0063],  # MATHEMATICAL ITALIC SMALL C
    0x1D451: ["<font>", 0x0064],  # MATHEMATICAL ITALIC SMALL D
    0x1D452: ["<font>", 0x0065],  # MATHEMATICAL ITALIC SMALL E
    0x1D453: ["<font>", 0x0066],  # MATHEMATICAL ITALIC SMALL F
    0x1D454: ["<font>", 0x0067],  # MATHEMATICAL ITALIC SMALL G
    0x1D456: ["<font>", 0x0069],  # MATHEMATICAL ITALIC SMALL I
    0x1D457: ["<font>", 0x006A],  # MATHEMATICAL ITALIC SMALL J
    0x1D458: ["<font>", 0x006B],  # MATHEMATICAL ITALIC SMALL K
    0x1D459: ["<font>", 0x006C],  # MATHEMATICAL ITALIC SMALL L
    0x1D45A: ["<font>", 0x006D],  # MATHEMATICAL ITALIC SMALL M
    0x1D45B: ["<font>", 0x006E],  # MATHEMATICAL ITALIC SMALL N
    0x1D45C: ["<font>", 0x006F],  # MATHEMATICAL ITALIC SMALL O
    0x1D45D: ["<font>", 0x0070],  # MATHEMATICAL ITALIC SMALL P
    0x1D45E: ["<font>", 0x0071],  # MATHEMATICAL ITALIC SMALL Q
    0x1D45F: ["<font>", 0x0072],  # MATHEMATICAL ITALIC SMALL R
    0x1D460: ["<font>", 0x0073],  # MATHEMATICAL ITALIC SMALL S
    0x1D461: ["<font>", 0x0074],  # MATHEMATICAL ITALIC SMALL T
    0x1D462: ["<font>", 0x0075],  # MATHEMATICAL ITALIC SMALL U
    0x1D463: ["<font>", 0x0076],  # MATHEMATICAL ITALIC SMALL V
    0x1D464: ["<font>", 0x0077],  # MATHEMATICAL ITALIC SMALL W
    0x1D465: ["<font>", 0x0078],  # MATHEMATICAL ITALIC SMALL X
    0x1D466: ["<font>", 0x0079],  # MATHEMATICAL ITALIC SMALL Y
    0x1D467: ["<font>", 0x007A],  # MATHEMATICAL ITALIC SMALL Z
    0x1D468: ["<font>", 0x0041],  # MATHEMATICAL BOLD ITALIC CAPITAL A
    0x1D469: ["<font>", 0x0042],  # MATHEMATICAL BOLD ITALIC CAPITAL B
    0x1D46A: ["<font>", 0x0043],  # MATHEMATICAL BOLD ITALIC CAPITAL C
    0x1D46B: ["<font>", 0x0044],  # MATHEMATICAL BOLD ITALIC CAPITAL D
    0x1D46C: ["<font>", 0x0045],  # MATHEMATICAL BOLD ITALIC CAPITAL E
    0x1D46D: ["<font>", 0x0046],  # MATHEMATICAL BOLD ITALIC CAPITAL F
    0x1D46E: ["<font>", 0x0047],  # MATHEMATICAL BOLD ITALIC CAPITAL G
    0x1D46F: ["<font>", 0x0048],  # MATHEMATICAL BOLD ITALIC CAPITAL H
    0x1D470: ["<font>", 0x0049],  # MATHEMATICAL BOLD ITALIC CAPITAL I
    0x1D471: ["<font>", 0x004A],  # MATHEMATICAL BOLD ITALIC CAPITAL J
    0x1D472: ["<font>", 0x004B],  # MATHEMATICAL BOLD ITALIC CAPITAL K
    0x1D473: ["<font>", 0x004C],  # MATHEMATICAL BOLD ITALIC CAPITAL L
    0x1D474: ["<font>", 0x004D],  # MATHEMATICAL BOLD ITALIC CAPITAL M
    0x1D475: ["<font>", 0x004E],  # MATHEMATICAL BOLD ITALIC CAPITAL N
    0x1D476: ["<font>", 0x004F],  # MATHEMATICAL BOLD ITALIC CAPITAL O
    0x1D477: ["<font>", 0x0050],  # MATHEMATICAL BOLD ITALIC CAPITAL P
    0x1D478: ["<font>", 0x0051],  # MATHEMATICAL BOLD ITALIC CAPITAL Q
    0x1D479: ["<font>", 0x0052],  # MATHEMATICAL BOLD ITALIC CAPITAL R
    0x1D47A: ["<font>", 0x0053],  # MATHEMATICAL BOLD ITALIC CAPITAL S
    0x1D47B: ["<font>", 0x0054],  # MATHEMATICAL BOLD ITALIC CAPITAL T
    0x1D47C: ["<font>", 0x0055],  # MATHEMATICAL BOLD ITALIC CAPITAL U
    0x1D47D: ["<font>", 0x0056],  # MATHEMATICAL BOLD ITALIC CAPITAL V
    0x1D47E: ["<font>", 0x0057],  # MATHEMATICAL BOLD ITALIC CAPITAL W
    0x1D47F: ["<font>", 0x0058],  # MATHEMATICAL BOLD ITALIC CAPITAL X
    0x1D480: ["<font>", 0x0059],  # MATHEMATICAL BOLD ITALIC CAPITAL Y
    0x1D481: ["<font>", 0x005A],  # MATHEMATICAL BOLD ITALIC CAPITAL Z
    0x1D482: ["<font>", 0x0061],  # MATHEMATICAL BOLD ITALIC SMALL A
    0x1D483: ["<font>", 0x0062],  # MATHEMATICAL BOLD ITALIC SMALL B
    0x1D484: ["<font>", 0x0063],  # MATHEMATICAL BOLD ITALIC SMALL C
    0x1D485: ["<font>", 0x0064],  # MATHEMATICAL BOLD ITALIC SMALL D
    0x1D486: ["<font>", 0x0065],  # MATHEMATICAL BOLD ITALIC SMALL E
    0x1D487: ["<font>", 0x0066],  # MATHEMATICAL BOLD ITALIC SMALL F
    0x1D488: ["<font>", 0x0067],  # MATHEMATICAL BOLD ITALIC SMALL G
    0x1D489: ["<font>", 0x0068],  # MATHEMATICAL BOLD ITALIC SMALL H
    0x1D48A: ["<font>", 0x0069],  # MATHEMATICAL BOLD ITALIC SMALL I
    0x1D48B: ["<font>", 0x006A],  # MATHEMATICAL BOLD ITALIC SMALL J
    0x1D48C: ["<font>", 0x006B],  # MATHEMATICAL BOLD ITALIC SMALL K
    0x1D48D: ["<font>", 0x006C],  # MATHEMATICAL BOLD ITALIC SMALL L
    0x1D48E: ["<font>", 0x006D],  # MATHEMATICAL BOLD ITALIC SMALL M
    0x1D48F: ["<font>", 0x006E],  # MATHEMATICAL BOLD ITALIC SMALL N
    0x1D490: ["<font>", 0x006F],  # MATHEMATICAL BOLD ITALIC SMALL O
    0x1D491: ["<font>", 0x0070],  # MATHEMATICAL BOLD ITALIC SMALL P
    0x1D492: ["<font>", 0x0071],  # MATHEMATICAL BOLD ITALIC SMALL Q
    0x1D493: ["<font>", 0x0072],  # MATHEMATICAL BOLD ITALIC SMALL R
    0x1D494: ["<font>", 0x0073],  # MATHEMATICAL BOLD ITALIC SMALL S
    0x1D495: ["<font>", 0x0074],  # MATHEMATICAL BOLD ITALIC SMALL T
    0x1D496: ["<font>", 0x0075],  # MATHEMATICAL BOLD ITALIC SMALL U
    0x1D497: ["<font>", 0x0076],  # MATHEMATICAL BOLD ITALIC SMALL V
    0x1D498: ["<font>", 0x0077],  # MATHEMATICAL BOLD ITALIC SMALL W
    0x1D499: ["<font>", 0x0078],  # MATHEMATICAL BOLD ITALIC SMALL X
    0x1D49A: ["<font>", 0x0079],  # MATHEMATICAL BOLD ITALIC SMALL Y
    0x1D49B: ["<font>", 0x007A],  # MATHEMATICAL BOLD ITALIC SMALL Z
    0x1D49C: ["<font>", 0x0041],  # MATHEMATICAL SCRIPT CAPITAL A
    0x1D49E: ["<font>", 0x0043],  # MATHEMATICAL SCRIPT CAPITAL C
    0x1D49F: ["<font>", 0x0044],  # MATHEMATICAL SCRIPT CAPITAL D
    0x1D4A2: ["<font>", 0x0047],  # MATHEMATICAL SCRIPT CAPITAL G
    0x1D4A5: ["<font>", 0x004A],  # MATHEMATICAL SCRIPT CAPITAL J
    0x1D4A6: ["<font>", 0x004B],  # MATHEMATICAL SCRIPT CAPITAL K
    0x1D4A9: ["<font>", 0x004E],  # MATHEMATICAL SCRIPT CAPITAL N
    0x1D4AA: ["<font>", 0x004F],  # MATHEMATICAL SCRIPT CAPITAL O
    0x1D4AB: ["<font>", 0x0050],  # MATHEMATICAL SCRIPT CAPITAL P
    0x1D4AC: ["<font>", 0x0051],  # MATHEMATICAL SCRIPT CAPITAL Q
    0x1D4AE: ["<font>", 0x0053],  # MATHEMATICAL SCRIPT CAPITAL S
    0x1D4AF: ["<font>", 0x0054],  # MATHEMATICAL SCRIPT CAPITAL T
    0x1D4B0: ["<font>", 0x0055],  # MATHEMATICAL SCRIPT CAPITAL U
    0x1D4B1: ["<font>", 0x0056],  # MATHEMATICAL SCRIPT CAPITAL V
    0x1D4B2: ["<font>", 0x0057],  # MATHEMATICAL SCRIPT CAPITAL W
    0x1D4B3: ["<font>", 0x0058],  # MATHEMATICAL SCRIPT CAPITAL X
    0x1D4B4: ["<font>", 0x0059],  # MATHEMATICAL SCRIPT CAPITAL Y
    0x1D4B5: ["<font>", 0x005A],  # MATHEMATICAL SCRIPT CAPITAL Z
    0x1D4B6: ["<font>", 0x0061],  # MATHEMATICAL SCRIPT SMALL A
    0x1D4B7: ["<font>", 0x0062],  # MATHEMATICAL SCRIPT SMALL B
    0x1D4B8: ["<font>", 0x0063],  # MATHEMATICAL SCRIPT SMALL C
    0x1D4B9: ["<font>", 0x0064],  # MATHEMATICAL SCRIPT SMALL D
    0x1D4BB: ["<font>", 0x0066],  # MATHEMATICAL SCRIPT SMALL F
    0x1D4BD: ["<font>", 0x0068],  # MATHEMATICAL SCRIPT SMALL H
    0x1D4BE: ["<font>", 0x0069],  # MATHEMATICAL SCRIPT SMALL I
    0x1D4BF: ["<font>", 0x006A],  # MATHEMATICAL SCRIPT SMALL J
    0x1D4C0: ["<font>", 0x006B],  # MATHEMATICAL SCRIPT SMALL K
    0x1D4C1: ["<font>", 0x006C],  # MATHEMATICAL SCRIPT SMALL L
    0x1D4C2: ["<font>", 0x006D],  # MATHEMATICAL SCRIPT SMALL M
    0x1D4C3: ["<font>", 0x006E],  # MATHEMATICAL SCRIPT SMALL N
    0x1D4C5: ["<font>", 0x0070],  # MATHEMATICAL SCRIPT SMALL P
    0x1D4C6: ["<font>", 0x0071],  # MATHEMATICAL SCRIPT SMALL Q
    0x1D4C7: ["<font>", 0x0072],  # MATHEMATICAL SCRIPT SMALL R
    0x1D4C8: ["<font>", 0x0073],  # MATHEMATICAL SCRIPT SMALL S
    0x1D4C9: ["<font>", 0x0074],  # MATHEMATICAL SCRIPT SMALL T
    0x1D4CA: ["<font>", 0x0075],  # MATHEMATICAL SCRIPT SMALL U
    0x1D4CB: ["<font>", 0x0076],  # MATHEMATICAL SCRIPT SMALL V
    0x1D4CC: ["<font>", 0x0077],  # MATHEMATICAL SCRIPT SMALL W
    0x1D4CD: ["<font>", 0x0078],  # MATHEMATICAL SCRIPT SMALL X
    0x1D4CE: ["<font>", 0x0079],  # MATHEMATICAL SCRIPT SMALL Y
    0x1D4CF: ["<font>", 0x007A],  # MATHEMATICAL SCRIPT SMALL Z
    0x1D4D0: ["<font>", 0x0041],  # MATHEMATICAL BOLD SCRIPT CAPITAL A
    0x1D4D1: ["<font>", 0x0042],  # MATHEMATICAL BOLD SCRIPT CAPITAL B
    0x1D4D2: ["<font>", 0x0043],  # MATHEMATICAL BOLD SCRIPT CAPITAL C
    0x1D4D3: ["<font>", 0x0044],  # MATHEMATICAL BOLD SCRIPT CAPITAL D
    0x1D4D4: ["<font>", 0x0045],  # MATHEMATICAL BOLD SCRIPT CAPITAL E
    0x1D4D5: ["<font>", 0x0046],  # MATHEMATICAL BOLD SCRIPT CAPITAL F
    0x1D4D6: ["<font>", 0x0047],  # MATHEMATICAL BOLD SCRIPT CAPITAL G
    0x1D4D7: ["<font>", 0x0048],  # MATHEMATICAL BOLD SCRIPT CAPITAL H
    0x1D4D8: ["<font>", 0x0049],  # MATHEMATICAL BOLD SCRIPT CAPITAL I
    0x1D4D9: ["<font>", 0x004A],  # MATHEMATICAL BOLD SCRIPT CAPITAL J
    0x1D4DA: ["<font>", 0x004B],  # MATHEMATICAL BOLD SCRIPT CAPITAL K
    0x1D4DB: ["<font>", 0x004C],  # MATHEMATICAL BOLD SCRIPT CAPITAL L
    0x1D4DC: ["<font>", 0x004D],  # MATHEMATICAL BOLD SCRIPT CAPITAL M
    0x1D4DD: ["<font>", 0x004E],  # MATHEMATICAL BOLD SCRIPT CAPITAL N
    0x1D4DE: ["<font>", 0x004F],  # MATHEMATICAL BOLD SCRIPT CAPITAL O
    0x1D4DF: ["<font>", 0x0050],  # MATHEMATICAL BOLD SCRIPT CAPITAL P
    0x1D4E0: ["<font>", 0x0051],  # MATHEMATICAL BOLD SCRIPT CAPITAL Q
    0x1D4E1: ["<font>", 0x0052],  # MATHEMATICAL BOLD SCRIPT CAPITAL R
    0x1D4E2: ["<font>", 0x0053],  # MATHEMATICAL BOLD SCRIPT CAPITAL S
    0x1D4E3: ["<font>", 0x0054],  # MATHEMATICAL BOLD SCRIPT CAPITAL T
    0x1D4E4: ["<font>", 0x0055],  # MATHEMATICAL BOLD SCRIPT CAPITAL U
    0x1D4E5: ["<font>", 0x0056],  # MATHEMATICAL BOLD SCRIPT CAPITAL V
    0x1D4E6: ["<font>", 0x0057],  # MATHEMATICAL BOLD SCRIPT CAPITAL W
    0x1D4E7: ["<font>", 0x0058],  # MATHEMATICAL BOLD SCRIPT CAPITAL X
    0x1D4E8: ["<font>", 0x0059],  # MATHEMATICAL BOLD SCRIPT CAPITAL Y
    0x1D4E9: ["<font>", 0x005A],  # MATHEMATICAL BOLD SCRIPT CAPITAL Z
    0x1D4EA: ["<font>", 0x0061],  # MATHEMATICAL BOLD SCRIPT SMALL A
    0x1D4EB: ["<font>", 0x0062],  # MATHEMATICAL BOLD SCRIPT SMALL B
    0x1D4EC: ["<font>", 0x0063],  # MATHEMATICAL BOLD SCRIPT SMALL C
    0x1D4ED: ["<font>", 0x0064],  # MATHEMATICAL BOLD SCRIPT SMALL D
    0x1D4EE: ["<font>", 0x0065],  # MATHEMATICAL BOLD SCRIPT SMALL E
    0x1D4EF: ["<font>", 0x0066],  # MATHEMATICAL BOLD SCRIPT SMALL F
    0x1D4F0: ["<font>", 0x0067],  # MATHEMATICAL BOLD SCRIPT SMALL G
    0x1D4F1: ["<font>", 0x0068],  # MATHEMATICAL BOLD SCRIPT SMALL H
    0x1D4F2: ["<font>", 0x0069],  # MATHEMATICAL BOLD SCRIPT SMALL I
    0x1D4F3: ["<font>", 0x006A],  # MATHEMATICAL BOLD SCRIPT SMALL J
    0x1D4F4: ["<font>", 0x006B],  # MATHEMATICAL BOLD SCRIPT SMALL K
    0x1D4F5: ["<font>", 0x006C],  # MATHEMATICAL BOLD SCRIPT SMALL L
    0x1D4F6: ["<font>", 0x006D],  # MATHEMATICAL BOLD SCRIPT SMALL M
    0x1D4F7: ["<font>", 0x006E],  # MATHEMATICAL BOLD SCRIPT SMALL N
    0x1D4F8: ["<font>", 0x006F],  # MATHEMATICAL BOLD SCRIPT SMALL O
    0x1D4F9: ["<font>", 0x0070],  # MATHEMATICAL BOLD SCRIPT SMALL P
    0x1D4FA: ["<font>", 0x0071],  # MATHEMATICAL BOLD SCRIPT SMALL Q
    0x1D4FB: ["<font>", 0x0072],  # MATHEMATICAL BOLD SCRIPT SMALL R
    0x1D4FC: ["<font>", 0x0073],  # MATHEMATICAL BOLD SCRIPT SMALL S
    0x1D4FD: ["<font>", 0x0074],  # MATHEMATICAL BOLD SCRIPT SMALL T
    0x1D4FE: ["<font>", 0x0075],  # MATHEMATICAL BOLD SCRIPT SMALL U
    0x1D4FF: ["<font>", 0x0076],  # MATHEMATICAL BOLD SCRIPT SMALL V
    0x1D500: ["<font>", 0x0077],  # MATHEMATICAL BOLD SCRIPT SMALL W
    0x1D501: ["<font>", 0x0078],  # MATHEMATICAL BOLD SCRIPT SMALL X
    0x1D502: ["<font>", 0x0079],  # MATHEMATICAL BOLD SCRIPT SMALL Y
    0x1D503: ["<font>", 0x007A],  # MATHEMATICAL BOLD SCRIPT SMALL Z
    0x1D504: ["<font>", 0x0041],  # MATHEMATICAL FRAKTUR CAPITAL A
    0x1D505: ["<font>", 0x0042],  # MATHEMATICAL FRAKTUR CAPITAL B
    0x1D507: ["<font>", 0x0044],  # MATHEMATICAL FRAKTUR CAPITAL D
    0x1D508: ["<font>", 0x0045],  # MATHEMATICAL FRAKTUR CAPITAL E
    0x1D509: ["<font>", 0x0046],  # MATHEMATICAL FRAKTUR CAPITAL F
    0x1D50A: ["<font>", 0x0047],  # MATHEMATICAL FRAKTUR CAPITAL G
    0x1D50D: ["<font>", 0x004A],  # MATHEMATICAL FRAKTUR CAPITAL J
    0x1D50E: ["<font>", 0x004B],  # MATHEMATICAL FRAKTUR CAPITAL K
    0x1D50F: ["<font>", 0x004C],  # MATHEMATICAL FRAKTUR CAPITAL L
    0x1D510: ["<font>", 0x004D],  # MATHEMATICAL FRAKTUR CAPITAL M
    0x1D511: ["<font>", 0x004E],  # MATHEMATICAL FRAKTUR CAPITAL N
    0x1D512: ["<font>", 0x004F],  # MATHEMATICAL FRAKTUR CAPITAL O
    0x1D513: ["<font>", 0x0050],  # MATHEMATICAL FRAKTUR CAPITAL P
    0x1D514: ["<font>", 0x0051],  # MATHEMATICAL FRAKTUR CAPITAL Q
    0x1D516: ["<font>", 0x0053],  # MATHEMATICAL FRAKTUR CAPITAL S
    0x1D517: ["<font>", 0x0054],  # MATHEMATICAL FRAKTUR CAPITAL T
    0x1D518: ["<font>", 0x0055],  # MATHEMATICAL FRAKTUR CAPITAL U
    0x1D519: ["<font>", 0x0056],  # MATHEMATICAL FRAKTUR CAPITAL V
    0x1D51A: ["<font>", 0x0057],  # MATHEMATICAL FRAKTUR CAPITAL W
    0x1D51B: ["<font>", 0x0058],  # MATHEMATICAL FRAKTUR CAPITAL X
    0x1D51C: ["<font>", 0x0059],  # MATHEMATICAL FRAKTUR CAPITAL Y
    0x1D51E: ["<font>", 0x0061],  # MATHEMATICAL FRAKTUR SMALL A
    0x1D51F: ["<font>", 0x0062],  # MATHEMATICAL FRAKTUR SMALL B
    0x1D520: ["<font>", 0x0063],  # MATHEMATICAL FRAKTUR SMALL C
    0x1D521: ["<font>", 0x0064],  # MATHEMATICAL FRAKTUR SMALL D
    0x1D522: ["<font>", 0x0065],  # MATHEMATICAL FRAKTUR SMALL E
    0x1D523: ["<font>", 0x0066],  # MATHEMATICAL FRAKTUR SMALL F
    0x1D524: ["<font>", 0x0067],  # MATHEMATICAL FRAKTUR SMALL G
    0x1D525: ["<font>", 0x0068],  # MATHEMATICAL FRAKTUR SMALL H
    0x1D526: ["<font>", 0x0069],  # MATHEMATICAL FRAKTUR SMALL I
    0x1D527: ["<font>", 0x006A],  # MATHEMATICAL FRAKTUR SMALL J
    0x1D528: ["<font>", 0x006B],  # MATHEMATICAL FRAKTUR SMALL K
    0x1D529: ["<font>", 0x006C],  # MATHEMATICAL FRAKTUR SMALL L
    0x1D52A: ["<font>", 0x006D],  # MATHEMATICAL FRAKTUR SMALL M
    0x1D52B: ["<font>", 0x006E],  # MATHEMATICAL FRAKTUR SMALL N
    0x1D52C: ["<font>", 0x006F],  # MATHEMATICAL FRAKTUR SMALL O
    0x1D52D: ["<font>", 0x0070],  # MATHEMATICAL FRAKTUR SMALL P
    0x1D52E: ["<font>", 0x0071],  # MATHEMATICAL FRAKTUR SMALL Q
    0x1D52F: ["<font>", 0x0072],  # MATHEMATICAL FRAKTUR SMALL R
    0x1D530: ["<font>", 0x0073],  # MATHEMATICAL FRAKTUR SMALL S
    0x1D531: ["<font>", 0x0074],  # MATHEMATICAL FRAKTUR SMALL T
    0x1D532: ["<font>", 0x0075],  # MATHEMATICAL FRAKTUR SMALL U
    0x1D533: ["<font>", 0x0076],  # MATHEMATICAL FRAKTUR SMALL V
    0x1D534: ["<font>", 0x0077],  # MATHEMATICAL FRAKTUR SMALL W
    0x1D535: ["<font>", 0x0078],  # MATHEMATICAL FRAKTUR SMALL X
    0x1D536: ["<font>", 0x0079],  # MATHEMATICAL FRAKTUR SMALL Y
    0x1D537: ["<font>", 0x007A],  # MATHEMATICAL FRAKTUR SMALL Z
    0x1D538: ["<font>", 0x0041],  # MATHEMATICAL DOUBLE-STRUCK CAPITAL A
    0x1D539: ["<font>", 0x0042],  # MATHEMATICAL DOUBLE-STRUCK CAPITAL B
    0x1D53B: ["<font>", 0x0044],  # MATHEMATICAL DOUBLE-STRUCK CAPITAL D
    0x1D53C: ["<font>", 0x0045],  # MATHEMATICAL DOUBLE-STRUCK CAPITAL E
    0x1D53D: ["<font>", 0x0046],  # MATHEMATICAL DOUBLE-STRUCK CAPITAL F
    0x1D53E: ["<font>", 0x0047],  # MATHEMATICAL DOUBLE-STRUCK CAPITAL G
    0x1D540: ["<font>", 0x0049],  # MATHEMATICAL DOUBLE-STRUCK CAPITAL I
    0x1D541: ["<font>", 0x004A],  # MATHEMATICAL DOUBLE-STRUCK CAPITAL J
    0x1D542: ["<font>", 0x004B],  # MATHEMATICAL DOUBLE-STRUCK CAPITAL K
    0x1D543: ["<font>", 0x004C],  # MATHEMATICAL DOUBLE-STRUCK CAPITAL L
    0x1D544: ["<font>", 0x004D],  # MATHEMATICAL DOUBLE-STRUCK CAPITAL M
    0x1D546: ["<font>", 0x004F],  # MATHEMATICAL DOUBLE-STRUCK CAPITAL O
    0x1D54A: ["<font>", 0x0053],  # MATHEMATICAL DOUBLE-STRUCK CAPITAL S
    0x1D54B: ["<font>", 0x0054],  # MATHEMATICAL DOUBLE-STRUCK CAPITAL T
    0x1D54C: ["<font>", 0x0055],  # MATHEMATICAL DOUBLE-STRUCK CAPITAL U
    0x1D54D: ["<font>", 0x0056],  # MATHEMATICAL DOUBLE-STRUCK CAPITAL V
    0x1D54E: ["<font>", 0x0057],  # MATHEMATICAL DOUBLE-STRUCK CAPITAL W
    0x1D54F: ["<font>", 0x0058],  # MATHEMATICAL DOUBLE-STRUCK CAPITAL X
    0x1D550: ["<font>", 0x0059],  # MATHEMATICAL DOUBLE-STRUCK CAPITAL Y
    0x1D552: ["<font>", 0x0061],  # MATHEMATICAL DOUBLE-STRUCK SMALL A
    0x1D553: ["<font>", 0x0062],  # MATHEMATICAL DOUBLE-STRUCK SMALL B
    0x1D554: ["<font>", 0x0063],  # MATHEMATICAL DOUBLE-STRUCK SMALL C
    0x1D555: ["<font>", 0x0064],  # MATHEMATICAL DOUBLE-STRUCK SMALL D
    0x1D556: ["<font>", 0x0065],  # MATHEMATICAL DOUBLE-STRUCK SMALL E
    0x1D557: ["<font>", 0x0066],  # MATHEMATICAL DOUBLE-STRUCK SMALL F
    0x1D558: ["<font>", 0x0067],  # MATHEMATICAL DOUBLE-STRUCK SMALL G
    0x1D559: ["<font>", 0x0068],  # MATHEMATICAL DOUBLE-STRUCK SMALL H
    0x1D55A: ["<font>", 0x0069],  # MATHEMATICAL DOUBLE-STRUCK SMALL I
    0x1D55B: ["<font>", 0x006A],  # MATHEMATICAL DOUBLE-STRUCK SMALL J
    0x1D55C: ["<font>", 0x006B],  # MATHEMATICAL DOUBLE-STRUCK SMALL K
    0x1D55D: ["<font>", 0x006C],  # MATHEMATICAL DOUBLE-STRUCK SMALL L
    0x1D55E: ["<font>", 0x006D],  # MATHEMATICAL DOUBLE-STRUCK SMALL M
    0x1D55F: ["<font>", 0x006E],  # MATHEMATICAL DOUBLE-STRUCK SMALL N
    0x1D560: ["<font>", 0x006F],  # MATHEMATICAL DOUBLE-STRUCK SMALL O
    0x1D561: ["<font>", 0x0070],  # MATHEMATICAL DOUBLE-STRUCK SMALL P
    0x1D562: ["<font>", 0x0071],  # MATHEMATICAL DOUBLE-STRUCK SMALL Q
    0x1D563: ["<font>", 0x0072],  # MATHEMATICAL DOUBLE-STRUCK SMALL R
    0x1D564: ["<font>", 0x0073],  # MATHEMATICAL DOUBLE-STRUCK SMALL S
    0x1D565: ["<font>", 0x0074],  # MATHEMATICAL DOUBLE-STRUCK SMALL T
    0x1D566: ["<font>", 0x0075],  # MATHEMATICAL DOUBLE-STRUCK SMALL U
    0x1D567: ["<font>", 0x0076],  # MATHEMATICAL DOUBLE-STRUCK SMALL V
    0x1D568: ["<font>", 0x0077],  # MATHEMATICAL DOUBLE-STRUCK SMALL W
    0x1D569: ["<font>", 0x0078],  # MATHEMATICAL DOUBLE-STRUCK SMALL X
    0x1D56A: ["<font>", 0x0079],  # MATHEMATICAL DOUBLE-STRUCK SMALL Y
    0x1D56B: ["<font>", 0x007A],  # MATHEMATICAL DOUBLE-STRUCK SMALL Z
    0x1D56C: ["<font>", 0x0041],  # MATHEMATICAL BOLD FRAKTUR CAPITAL A
    0x1D56D: ["<font>", 0x0042],  # MATHEMATICAL BOLD FRAKTUR CAPITAL B
    0x1D56E: ["<font>", 0x0043],  # MATHEMATICAL BOLD FRAKTUR CAPITAL C
    0x1D56F: ["<font>", 0x0044],  # MATHEMATICAL BOLD FRAKTUR CAPITAL D
    0x1D570: ["<font>", 0x0045],  # MATHEMATICAL BOLD FRAKTUR CAPITAL E
    0x1D571: ["<font>", 0x0046],  # MATHEMATICAL BOLD FRAKTUR CAPITAL F
    0x1D572: ["<font>", 0x0047],  # MATHEMATICAL BOLD FRAKTUR CAPITAL G
    0x1D573: ["<font>", 0x0048],  # MATHEMATICAL BOLD FRAKTUR CAPITAL H
    0x1D574: ["<font>", 0x0049],  # MATHEMATICAL BOLD FRAKTUR CAPITAL I
    0x1D575: ["<font>", 0x004A],  # MATHEMATICAL BOLD FRAKTUR CAPITAL J
    0x1D576: ["<font>", 0x004B],  # MATHEMATICAL BOLD FRAKTUR CAPITAL K
    0x1D577: ["<font>", 0x004C],  # MATHEMATICAL BOLD FRAKTUR CAPITAL L
    0x1D578: ["<font>", 0x004D],  # MATHEMATICAL BOLD FRAKTUR CAPITAL M
    0x1D579: ["<font>", 0x004E],  # MATHEMATICAL BOLD FRAKTUR CAPITAL N
    0x1D57A: ["<font>", 0x004F],  # MATHEMATICAL BOLD FRAKTUR CAPITAL O
    0x1D57B: ["<font>", 0x0050],  # MATHEMATICAL BOLD FRAKTUR CAPITAL P
    0x1D57C: ["<font>", 0x0051],  # MATHEMATICAL BOLD FRAKTUR CAPITAL Q
    0x1D57D: ["<font>", 0x0052],  # MATHEMATICAL BOLD FRAKTUR CAPITAL R
    0x1D57E: ["<font>", 0x0053],  # MATHEMATICAL BOLD FRAKTUR CAPITAL S
    0x1D57F: ["<font>", 0x0054],  # MATHEMATICAL BOLD FRAKTUR CAPITAL T
    0x1D580: ["<font>", 0x0055],  # MATHEMATICAL BOLD FRAKTUR CAPITAL U
    0x1D581: ["<font>", 0x0056],  # MATHEMATICAL BOLD FRAKTUR CAPITAL V
    0x1D582: ["<font>", 0x0057],  # MATHEMATICAL BOLD FRAKTUR CAPITAL W
    0x1D583: ["<font>", 0x0058],  # MATHEMATICAL BOLD FRAKTUR CAPITAL X
    0x1D584: ["<font>", 0x0059],  # MATHEMATICAL BOLD FRAKTUR CAPITAL Y
    0x1D585: ["<font>", 0x005A],  # MATHEMATICAL BOLD FRAKTUR CAPITAL Z
    0x1D586: ["<font>", 0x0061],  # MATHEMATICAL BOLD FRAKTUR SMALL A
    0x1D587: ["<font>", 0x0062],  # MATHEMATICAL BOLD FRAKTUR SMALL B
    0x1D588: ["<font>", 0x0063],  # MATHEMATICAL BOLD FRAKTUR SMALL C
    0x1D589: ["<font>", 0x0064],  # MATHEMATICAL BOLD FRAKTUR SMALL D
    0x1D58A: ["<font>", 0x0065],  # MATHEMATICAL BOLD FRAKTUR SMALL E
    0x1D58B: ["<font>", 0x0066],  # MATHEMATICAL BOLD FRAKTUR SMALL F
    0x1D58C: ["<font>", 0x0067],  # MATHEMATICAL BOLD FRAKTUR SMALL G
    0x1D58D: ["<font>", 0x0068],  # MATHEMATICAL BOLD FRAKTUR SMALL H
    0x1D58E: ["<font>", 0x0069],  # MATHEMATICAL BOLD FRAKTUR SMALL I
    0x1D58F: ["<font>", 0x006A],  # MATHEMATICAL BOLD FRAKTUR SMALL J
    0x1D590: ["<font>", 0x006B],  # MATHEMATICAL BOLD FRAKTUR SMALL K
    0x1D591: ["<font>", 0x006C],  # MATHEMATICAL BOLD FRAKTUR SMALL L
    0x1D592: ["<font>", 0x006D],  # MATHEMATICAL BOLD FRAKTUR SMALL M
    0x1D593: ["<font>", 0x006E],  # MATHEMATICAL BOLD FRAKTUR SMALL N
    0x1D594: ["<font>", 0x006F],  # MATHEMATICAL BOLD FRAKTUR SMALL O
    0x1D595: ["<font>", 0x0070],  # MATHEMATICAL BOLD FRAKTUR SMALL P
    0x1D596: ["<font>", 0x0071],  # MATHEMATICAL BOLD FRAKTUR SMALL Q
    0x1D597: ["<font>", 0x0072],  # MATHEMATICAL BOLD FRAKTUR SMALL R
    0x1D598: ["<font>", 0x0073],  # MATHEMATICAL BOLD FRAKTUR SMALL S
    0x1D599: ["<font>", 0x0074],  # MATHEMATICAL BOLD FRAKTUR SMALL T
    0x1D59A: ["<font>", 0x0075],  # MATHEMATICAL BOLD FRAKTUR SMALL U
    0x1D59B: ["<font>", 0x0076],  # MATHEMATICAL BOLD FRAKTUR SMALL V
    0x1D59C: ["<font>", 0x0077],  # MATHEMATICAL BOLD FRAKTUR SMALL W
    0x1D59D: ["<font>", 0x0078],  # MATHEMATICAL BOLD FRAKTUR SMALL X
    0x1D59E: ["<font>", 0x0079],  # MATHEMATICAL BOLD FRAKTUR SMALL Y
    0x1D59F: ["<font>", 0x007A],  # MATHEMATICAL BOLD FRAKTUR SMALL Z
    0x1D5A0: ["<font>", 0x0041],  # MATHEMATICAL SANS-SERIF CAPITAL A
    0x1D5A1: ["<font>", 0x0042],  # MATHEMATICAL SANS-SERIF CAPITAL B
    0x1D5A2: ["<font>", 0x0043],  # MATHEMATICAL SANS-SERIF CAPITAL C
    0x1D5A3: ["<font>", 0x0044],  # MATHEMATICAL SANS-SERIF CAPITAL D
    0x1D5A4: ["<font>", 0x0045],  # MATHEMATICAL SANS-SERIF CAPITAL E
    0x1D5A5: ["<font>", 0x0046],  # MATHEMATICAL SANS-SERIF CAPITAL F
    0x1D5A6: ["<font>", 0x0047],  # MATHEMATICAL SANS-SERIF CAPITAL G
    0x1D5A7: ["<font>", 0x0048],  # MATHEMATICAL SANS-SERIF CAPITAL H
    0x1D5A8: ["<font>", 0x0049],  # MATHEMATICAL SANS-SERIF CAPITAL I
    0x1D5A9: ["<font>", 0x004A],  # MATHEMATICAL SANS-SERIF CAPITAL J
    0x1D5AA: ["<font>", 0x004B],  # MATHEMATICAL SANS-SERIF CAPITAL K
    0x1D5AB: ["<font>", 0x004C],  # MATHEMATICAL SANS-SERIF CAPITAL L
    0x1D5AC: ["<font>", 0x004D],  # MATHEMATICAL SANS-SERIF CAPITAL M
    0x1D5AD: ["<font>", 0x004E],  # MATHEMATICAL SANS-SERIF CAPITAL N
    0x1D5AE: ["<font>", 0x004F],  # MATHEMATICAL SANS-SERIF CAPITAL O
    0x1D5AF: ["<font>", 0x0050],  # MATHEMATICAL SANS-SERIF CAPITAL P
    0x1D5B0: ["<font>", 0x0051],  # MATHEMATICAL SANS-SERIF CAPITAL Q
    0x1D5B1: ["<font>", 0x0052],  # MATHEMATICAL SANS-SERIF CAPITAL R
    0x1D5B2: ["<font>", 0x0053],  # MATHEMATICAL SANS-SERIF CAPITAL S
    0x1D5B3: ["<font>", 0x0054],  # MATHEMATICAL SANS-SERIF CAPITAL T
    0x1D5B4: ["<font>", 0x0055],  # MATHEMATICAL SANS-SERIF CAPITAL U
    0x1D5B5: ["<font>", 0x0056],  # MATHEMATICAL SANS-SERIF CAPITAL V
    0x1D5B6: ["<font>", 0x0057],  # MATHEMATICAL SANS-SERIF CAPITAL W
    0x1D5B7: ["<font>", 0x0058],  # MATHEMATICAL SANS-SERIF CAPITAL X
    0x1D5B8: ["<font>", 0x0059],  # MATHEMATICAL SANS-SERIF CAPITAL Y
    0x1D5B9: ["<font>", 0x005A],  # MATHEMATICAL SANS-SERIF CAPITAL Z
    0x1D5BA: ["<font>", 0x0061],  # MATHEMATICAL SANS-SERIF SMALL A
    0x1D5BB: ["<font>", 0x0062],  # MATHEMATICAL SANS-SERIF SMALL B
    0x1D5BC: ["<font>", 0x0063],  # MATHEMATICAL SANS-SERIF SMALL C
    0x1D5BD: ["<font>", 0x0064],  # MATHEMATICAL SANS-SERIF SMALL D
    0x1D5BE: ["<font>", 0x0065],  # MATHEMATICAL SANS-SERIF SMALL E
    0x1D5BF: ["<font>", 0x0066],  # MATHEMATICAL SANS-SERIF SMALL F
    0x1D5C0: ["<font>", 0x0067],  # MATHEMATICAL SANS-SERIF SMALL G
    0x1D5C1: ["<font>", 0x0068],  # MATHEMATICAL SANS-SERIF SMALL H
    0x1D5C2: ["<font>", 0x0069],  # MATHEMATICAL SANS-SERIF SMALL I
    0x1D5C3: ["<font>", 0x006A],  # MATHEMATICAL SANS-SERIF SMALL J
    0x1D5C4: ["<font>", 0x006B],  # MATHEMATICAL SANS-SERIF SMALL K
    0x1D5C5: ["<font>", 0x006C],  # MATHEMATICAL SANS-SERIF SMALL L
    0x1D5C6: ["<font>", 0x006D],  # MATHEMATICAL SANS-SERIF SMALL M
    0x1D5C7: ["<font>", 0x006E],  # MATHEMATICAL SANS-SERIF SMALL N
    0x1D5C8: ["<font>", 0x006F],  # MATHEMATICAL SANS-SERIF SMALL O
    0x1D5C9: ["<font>", 0x0070],  # MATHEMATICAL SANS-SERIF SMALL P
    0x1D5CA: ["<font>", 0x0071],  # MATHEMATICAL SANS-SERIF SMALL Q
    0x1D5CB: ["<font>", 0x0072],  # MATHEMATICAL SANS-SERIF SMALL R
    0x1D5CC: ["<font>", 0x0073],  # MATHEMATICAL SANS-SERIF SMALL S
    0x1D5CD: ["<font>", 0x0074],  # MATHEMATICAL SANS-SERIF SMALL T
    0x1D5CE: ["<font>", 0x0075],  # MATHEMATICAL SANS-SERIF SMALL U
    0x1D5CF: ["<font>", 0x0076],  # MATHEMATICAL SANS-SERIF SMALL V
    0x1D5D0: ["<font>", 0x0077],  # MATHEMATICAL SANS-SERIF SMALL W
    0x1D5D1: ["<font>", 0x0078],  # MATHEMATICAL SANS-SERIF SMALL X
    0x1D5D2: ["<font>", 0x0079],  # MATHEMATICAL SANS-SERIF SMALL Y
    0x1D5D3: ["<font>", 0x007A],  # MATHEMATICAL SANS-SERIF SMALL Z
    0x1D5D4: ["<font>", 0x0041],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL A
    0x1D5D5: ["<font>", 0x0042],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL B
    0x1D5D6: ["<font>", 0x0043],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL C
    0x1D5D7: ["<font>", 0x0044],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL D
    0x1D5D8: ["<font>", 0x0045],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL E
    0x1D5D9: ["<font>", 0x0046],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL F
    0x1D5DA: ["<font>", 0x0047],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL G
    0x1D5DB: ["<font>", 0x0048],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL H
    0x1D5DC: ["<font>", 0x0049],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL I
    0x1D5DD: ["<font>", 0x004A],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL J
    0x1D5DE: ["<font>", 0x004B],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL K
    0x1D5DF: ["<font>", 0x004C],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL L
    0x1D5E0: ["<font>", 0x004D],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL M
    0x1D5E1: ["<font>", 0x004E],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL N
    0x1D5E2: ["<font>", 0x004F],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL O
    0x1D5E3: ["<font>", 0x0050],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL P
    0x1D5E4: ["<font>", 0x0051],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL Q
    0x1D5E5: ["<font>", 0x0052],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL R
    0x1D5E6: ["<font>", 0x0053],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL S
    0x1D5E7: ["<font>", 0x0054],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL T
    0x1D5E8: ["<font>", 0x0055],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL U
    0x1D5E9: ["<font>", 0x0056],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL V
    0x1D5EA: ["<font>", 0x0057],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL W
    0x1D5EB: ["<font>", 0x0058],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL X
    0x1D5EC: ["<font>", 0x0059],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL Y
    0x1D5ED: ["<font>", 0x005A],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL Z
    0x1D5EE: ["<font>", 0x0061],  # MATHEMATICAL SANS-SERIF BOLD SMALL A
    0x1D5EF: ["<font>", 0x0062],  # MATHEMATICAL SANS-SERIF BOLD SMALL B
    0x1D5F0: ["<font>", 0x0063],  # MATHEMATICAL SANS-SERIF BOLD SMALL C
    0x1D5F1: ["<font>", 0x0064],  # MATHEMATICAL SANS-SERIF BOLD SMALL D
    0x1D5F2: ["<font>", 0x0065],  # MATHEMATICAL SANS-SERIF BOLD SMALL E
    0x1D5F3: ["<font>", 0x0066],  # MATHEMATICAL SANS-SERIF BOLD SMALL F
    0x1D5F4: ["<font>", 0x0067],  # MATHEMATICAL SANS-SERIF BOLD SMALL G
    0x1D5F5: ["<font>", 0x0068],  # MATHEMATICAL SANS-SERIF BOLD SMALL H
    0x1D5F6: ["<font>", 0x0069],  # MATHEMATICAL SANS-SERIF BOLD SMALL I
    0x1D5F7: ["<font>", 0x006A],  # MATHEMATICAL SANS-SERIF BOLD SMALL J
    0x1D5F8: ["<font>", 0x006B],  # MATHEMATICAL SANS-SERIF BOLD SMALL K
    0x1D5F9: ["<font>", 0x006C],  # MATHEMATICAL SANS-SERIF BOLD SMALL L
    0x1D5FA: ["<font>", 0x006D],  # MATHEMATICAL SANS-SERIF BOLD SMALL M
    0x1D5FB: ["<font>", 0x006E],  # MATHEMATICAL SANS-SERIF BOLD SMALL N
    0x1D5FC: ["<font>", 0x006F],  # MATHEMATICAL SANS-SERIF BOLD SMALL O
    0x1D5FD: ["<font>", 0x0070],  # MATHEMATICAL SANS-SERIF BOLD SMALL P
    0x1D5FE: ["<font>", 0x0071],  # MATHEMATICAL SANS-SERIF BOLD SMALL Q
    0x1D5FF: ["<font>", 0x0072],  # MATHEMATICAL SANS-SERIF BOLD SMALL R
    0x1D600: ["<font>", 0x0073],  # MATHEMATICAL SANS-SERIF BOLD SMALL S
    0x1D601: ["<font>", 0x0074],  # MATHEMATICAL SANS-SERIF BOLD SMALL T
    0x1D602: ["<font>", 0x0075],  # MATHEMATICAL SANS-SERIF BOLD SMALL U
    0x1D603: ["<font>", 0x0076],  # MATHEMATICAL SANS-SERIF BOLD SMALL V
    0x1D604: ["<font>", 0x0077],  # MATHEMATICAL SANS-SERIF BOLD SMALL W
    0x1D605: ["<font>", 0x0078],  # MATHEMATICAL SANS-SERIF BOLD SMALL X
    0x1D606: ["<font>", 0x0079],  # MATHEMATICAL SANS-SERIF BOLD SMALL Y
    0x1D607: ["<font>", 0x007A],  # MATHEMATICAL SANS-SERIF BOLD SMALL Z
    0x1D608: ["<font>", 0x0041],  # MATHEMATICAL SANS-SERIF ITALIC CAPITAL A
    0x1D609: ["<font>", 0x0042],  # MATHEMATICAL SANS-SERIF ITALIC CAPITAL B
    0x1D60A: ["<font>", 0x0043],  # MATHEMATICAL SANS-SERIF ITALIC CAPITAL C
    0x1D60B: ["<font>", 0x0044],  # MATHEMATICAL SANS-SERIF ITALIC CAPITAL D
    0x1D60C: ["<font>", 0x0045],  # MATHEMATICAL SANS-SERIF ITALIC CAPITAL E
    0x1D60D: ["<font>", 0x0046],  # MATHEMATICAL SANS-SERIF ITALIC CAPITAL F
    0x1D60E: ["<font>", 0x0047],  # MATHEMATICAL SANS-SERIF ITALIC CAPITAL G
    0x1D60F: ["<font>", 0x0048],  # MATHEMATICAL SANS-SERIF ITALIC CAPITAL H
    0x1D610: ["<font>", 0x0049],  # MATHEMATICAL SANS-SERIF ITALIC CAPITAL I
    0x1D611: ["<font>", 0x004A],  # MATHEMATICAL SANS-SERIF ITALIC CAPITAL J
    0x1D612: ["<font>", 0x004B],  # MATHEMATICAL SANS-SERIF ITALIC CAPITAL K
    0x1D613: ["<font>", 0x004C],  # MATHEMATICAL SANS-SERIF ITALIC CAPITAL L
    0x1D614: ["<font>", 0x004D],  # MATHEMATICAL SANS-SERIF ITALIC CAPITAL M
    0x1D615: ["<font>", 0x004E],  # MATHEMATICAL SANS-SERIF ITALIC CAPITAL N
    0x1D616: ["<font>", 0x004F],  # MATHEMATICAL SANS-SERIF ITALIC CAPITAL O
    0x1D617: ["<font>", 0x0050],  # MATHEMATICAL SANS-SERIF ITALIC CAPITAL P
    0x1D618: ["<font>", 0x0051],  # MATHEMATICAL SANS-SERIF ITALIC CAPITAL Q
    0x1D619: ["<font>", 0x0052],  # MATHEMATICAL SANS-SERIF ITALIC CAPITAL R
    0x1D61A: ["<font>", 0x0053],  # MATHEMATICAL SANS-SERIF ITALIC CAPITAL S
    0x1D61B: ["<font>", 0x0054],  # MATHEMATICAL SANS-SERIF ITALIC CAPITAL T
    0x1D61C: ["<font>", 0x0055],  # MATHEMATICAL SANS-SERIF ITALIC CAPITAL U
    0x1D61D: ["<font>", 0x0056],  # MATHEMATICAL SANS-SERIF ITALIC CAPITAL V
    0x1D61E: ["<font>", 0x0057],  # MATHEMATICAL SANS-SERIF ITALIC CAPITAL W
    0x1D61F: ["<font>", 0x0058],  # MATHEMATICAL SANS-SERIF ITALIC CAPITAL X
    0x1D620: ["<font>", 0x0059],  # MATHEMATICAL SANS-SERIF ITALIC CAPITAL Y
    0x1D621: ["<font>", 0x005A],  # MATHEMATICAL SANS-SERIF ITALIC CAPITAL Z
    0x1D622: ["<font>", 0x0061],  # MATHEMATICAL SANS-SERIF ITALIC SMALL A
    0x1D623: ["<font>", 0x0062],  # MATHEMATICAL SANS-SERIF ITALIC SMALL B
    0x1D624: ["<font>", 0x0063],  # MATHEMATICAL SANS-SERIF ITALIC SMALL C
    0x1D625: ["<font>", 0x0064],  # MATHEMATICAL SANS-SERIF ITALIC SMALL D
    0x1D626: ["<font>", 0x0065],  # MATHEMATICAL SANS-SERIF ITALIC SMALL E
    0x1D627: ["<font>", 0x0066],  # MATHEMATICAL SANS-SERIF ITALIC SMALL F
    0x1D628: ["<font>", 0x0067],  # MATHEMATICAL SANS-SERIF ITALIC SMALL G
    0x1D629: ["<font>", 0x0068],  # MATHEMATICAL SANS-SERIF ITALIC SMALL H
    0x1D62A: ["<font>", 0x0069],  # MATHEMATICAL SANS-SERIF ITALIC SMALL I
    0x1D62B: ["<font>", 0x006A],  # MATHEMATICAL SANS-SERIF ITALIC SMALL J
    0x1D62C: ["<font>", 0x006B],  # MATHEMATICAL SANS-SERIF ITALIC SMALL K
    0x1D62D: ["<font>", 0x006C],  # MATHEMATICAL SANS-SERIF ITALIC SMALL L
    0x1D62E: ["<font>", 0x006D],  # MATHEMATICAL SANS-SERIF ITALIC SMALL M
    0x1D62F: ["<font>", 0x006E],  # MATHEMATICAL SANS-SERIF ITALIC SMALL N
    0x1D630: ["<font>", 0x006F],  # MATHEMATICAL SANS-SERIF ITALIC SMALL O
    0x1D631: ["<font>", 0x0070],  # MATHEMATICAL SANS-SERIF ITALIC SMALL P
    0x1D632: ["<font>", 0x0071],  # MATHEMATICAL SANS-SERIF ITALIC SMALL Q
    0x1D633: ["<font>", 0x0072],  # MATHEMATICAL SANS-SERIF ITALIC SMALL R
    0x1D634: ["<font>", 0x0073],  # MATHEMATICAL SANS-SERIF ITALIC SMALL S
    0x1D635: ["<font>", 0x0074],  # MATHEMATICAL SANS-SERIF ITALIC SMALL T
    0x1D636: ["<font>", 0x0075],  # MATHEMATICAL SANS-SERIF ITALIC SMALL U
    0x1D637: ["<font>", 0x0076],  # MATHEMATICAL SANS-SERIF ITALIC SMALL V
    0x1D638: ["<font>", 0x0077],  # MATHEMATICAL SANS-SERIF ITALIC SMALL W
    0x1D639: ["<font>", 0x0078],  # MATHEMATICAL SANS-SERIF ITALIC SMALL X
    0x1D63A: ["<font>", 0x0079],  # MATHEMATICAL SANS-SERIF ITALIC SMALL Y
    0x1D63B: ["<font>", 0x007A],  # MATHEMATICAL SANS-SERIF ITALIC SMALL Z
    0x1D63C: ["<font>", 0x0041],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL A
    0x1D63D: ["<font>", 0x0042],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL B
    0x1D63E: ["<font>", 0x0043],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL C
    0x1D63F: ["<font>", 0x0044],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL D
    0x1D640: ["<font>", 0x0045],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL E
    0x1D641: ["<font>", 0x0046],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL F
    0x1D642: ["<font>", 0x0047],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL G
    0x1D643: ["<font>", 0x0048],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL H
    0x1D644: ["<font>", 0x0049],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL I
    0x1D645: ["<font>", 0x004A],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL J
    0x1D646: ["<font>", 0x004B],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL K
    0x1D647: ["<font>", 0x004C],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL L
    0x1D648: ["<font>", 0x004D],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL M
    0x1D649: ["<font>", 0x004E],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL N
    0x1D64A: ["<font>", 0x004F],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL O
    0x1D64B: ["<font>", 0x0050],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL P
    0x1D64C: ["<font>", 0x0051],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL Q
    0x1D64D: ["<font>", 0x0052],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL R
    0x1D64E: ["<font>", 0x0053],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL S
    0x1D64F: ["<font>", 0x0054],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL T
    0x1D650: ["<font>", 0x0055],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL U
    0x1D651: ["<font>", 0x0056],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL V
    0x1D652: ["<font>", 0x0057],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL W
    0x1D653: ["<font>", 0x0058],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL X
    0x1D654: ["<font>", 0x0059],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL Y
    0x1D655: ["<font>", 0x005A],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL Z
    0x1D656: ["<font>", 0x0061],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL A
    0x1D657: ["<font>", 0x0062],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL B
    0x1D658: ["<font>", 0x0063],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL C
    0x1D659: ["<font>", 0x0064],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL D
    0x1D65A: ["<font>", 0x0065],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL E
    0x1D65B: ["<font>", 0x0066],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL F
    0x1D65C: ["<font>", 0x0067],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL G
    0x1D65D: ["<font>", 0x0068],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL H
    0x1D65E: ["<font>", 0x0069],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL I
    0x1D65F: ["<font>", 0x006A],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL J
    0x1D660: ["<font>", 0x006B],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL K
    0x1D661: ["<font>", 0x006C],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL L
    0x1D662: ["<font>", 0x006D],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL M
    0x1D663: ["<font>", 0x006E],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL N
    0x1D664: ["<font>", 0x006F],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL O
    0x1D665: ["<font>", 0x0070],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL P
    0x1D666: ["<font>", 0x0071],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL Q
    0x1D667: ["<font>", 0x0072],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL R
    0x1D668: ["<font>", 0x0073],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL S
    0x1D669: ["<font>", 0x0074],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL T
    0x1D66A: ["<font>", 0x0075],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL U
    0x1D66B: ["<font>", 0x0076],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL V
    0x1D66C: ["<font>", 0x0077],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL W
    0x1D66D: ["<font>", 0x0078],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL X
    0x1D66E: ["<font>", 0x0079],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL Y
    0x1D66F: ["<font>", 0x007A],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL Z
    0x1D670: ["<font>", 0x0041],  # MATHEMATICAL MONOSPACE CAPITAL A
    0x1D671: ["<font>", 0x0042],  # MATHEMATICAL MONOSPACE CAPITAL B
    0x1D672: ["<font>", 0x0043],  # MATHEMATICAL MONOSPACE CAPITAL C
    0x1D673: ["<font>", 0x0044],  # MATHEMATICAL MONOSPACE CAPITAL D
    0x1D674: ["<font>", 0x0045],  # MATHEMATICAL MONOSPACE CAPITAL E
    0x1D675: ["<font>", 0x0046],  # MATHEMATICAL MONOSPACE CAPITAL F
    0x1D676: ["<font>", 0x0047],  # MATHEMATICAL MONOSPACE CAPITAL G
    0x1D677: ["<font>", 0x0048],  # MATHEMATICAL MONOSPACE CAPITAL H
    0x1D678: ["<font>", 0x0049],  # MATHEMATICAL MONOSPACE CAPITAL I
    0x1D679: ["<font>", 0x004A],  # MATHEMATICAL MONOSPACE CAPITAL J
    0x1D67A: ["<font>", 0x004B],  # MATHEMATICAL MONOSPACE CAPITAL K
    0x1D67B: ["<font>", 0x004C],  # MATHEMATICAL MONOSPACE CAPITAL L
    0x1D67C: ["<font>", 0x004D],  # MATHEMATICAL MONOSPACE CAPITAL M
    0x1D67D: ["<font>", 0x004E],  # MATHEMATICAL MONOSPACE CAPITAL N
    0x1D67E: ["<font>", 0x004F],  # MATHEMATICAL MONOSPACE CAPITAL O
    0x1D67F: ["<font>", 0x0050],  # MATHEMATICAL MONOSPACE CAPITAL P
    0x1D680: ["<font>", 0x0051],  # MATHEMATICAL MONOSPACE CAPITAL Q
    0x1D681: ["<font>", 0x0052],  # MATHEMATICAL MONOSPACE CAPITAL R
    0x1D682: ["<font>", 0x0053],  # MATHEMATICAL MONOSPACE CAPITAL S
    0x1D683: ["<font>", 0x0054],  # MATHEMATICAL MONOSPACE CAPITAL T
    0x1D684: ["<font>", 0x0055],  # MATHEMATICAL MONOSPACE CAPITAL U
    0x1D685: ["<font>", 0x0056],  # MATHEMATICAL MONOSPACE CAPITAL V
    0x1D686: ["<font>", 0x0057],  # MATHEMATICAL MONOSPACE CAPITAL W
    0x1D687: ["<font>", 0x0058],  # MATHEMATICAL MONOSPACE CAPITAL X
    0x1D688: ["<font>", 0x0059],  # MATHEMATICAL MONOSPACE CAPITAL Y
    0x1D689: ["<font>", 0x005A],  # MATHEMATICAL MONOSPACE CAPITAL Z
    0x1D68A: ["<font>", 0x0061],  # MATHEMATICAL MONOSPACE SMALL A
    0x1D68B: ["<font>", 0x0062],  # MATHEMATICAL MONOSPACE SMALL B
    0x1D68C: ["<font>", 0x0063],  # MATHEMATICAL MONOSPACE SMALL C
    0x1D68D: ["<font>", 0x0064],  # MATHEMATICAL MONOSPACE SMALL D
    0x1D68E: ["<font>", 0x0065],  # MATHEMATICAL MONOSPACE SMALL E
    0x1D68F: ["<font>", 0x0066],  # MATHEMATICAL MONOSPACE SMALL F
    0x1D690: ["<font>", 0x0067],  # MATHEMATICAL MONOSPACE SMALL G
    0x1D691: ["<font>", 0x0068],  # MATHEMATICAL MONOSPACE SMALL H
    0x1D692: ["<font>", 0x0069],  # MATHEMATICAL MONOSPACE SMALL I
    0x1D693: ["<font>", 0x006A],  # MATHEMATICAL MONOSPACE SMALL J
    0x1D694: ["<font>", 0x006B],  # MATHEMATICAL MONOSPACE SMALL K
    0x1D695: ["<font>", 0x006C],  # MATHEMATICAL MONOSPACE SMALL L
    0x1D696: ["<font>", 0x006D],  # MATHEMATICAL MONOSPACE SMALL M
    0x1D697: ["<font>", 0x006E],  # MATHEMATICAL MONOSPACE SMALL N
    0x1D698: ["<font>", 0x006F],  # MATHEMATICAL MONOSPACE SMALL O
    0x1D699: ["<font>", 0x0070],  # MATHEMATICAL MONOSPACE SMALL P
    0x1D69A: ["<font>", 0x0071],  # MATHEMATICAL MONOSPACE SMALL Q
    0x1D69B: ["<font>", 0x0072],  # MATHEMATICAL MONOSPACE SMALL R
    0x1D69C: ["<font>", 0x0073],  # MATHEMATICAL MONOSPACE SMALL S
    0x1D69D: ["<font>", 0x0074],  # MATHEMATICAL MONOSPACE SMALL T
    0x1D69E: ["<font>", 0x0075],  # MATHEMATICAL MONOSPACE SMALL U
    0x1D69F: ["<font>", 0x0076],  # MATHEMATICAL MONOSPACE SMALL V
    0x1D6A0: ["<font>", 0x0077],  # MATHEMATICAL MONOSPACE SMALL W
    0x1D6A1: ["<font>", 0x0078],  # MATHEMATICAL MONOSPACE SMALL X
    0x1D6A2: ["<font>", 0x0079],  # MATHEMATICAL MONOSPACE SMALL Y
    0x1D6A3: ["<font>", 0x007A],  # MATHEMATICAL MONOSPACE SMALL Z
    0x1D6A4: ["<font>", 0x0131],  # MATHEMATICAL ITALIC SMALL DOTLESS I
    0x1D6A5: ["<font>", 0x0237],  # MATHEMATICAL ITALIC SMALL DOTLESS J
    0x1D6A8: ["<font>", 0x0391],  # MATHEMATICAL BOLD CAPITAL ALPHA
    0x1D6A9: ["<font>", 0x0392],  # MATHEMATICAL BOLD CAPITAL BETA
    0x1D6AA: ["<font>", 0x0393],  # MATHEMATICAL BOLD CAPITAL GAMMA
    0x1D6AB: ["<font>", 0x0394],  # MATHEMATICAL BOLD CAPITAL DELTA
    0x1D6AC: ["<font>", 0x0395],  # MATHEMATICAL BOLD CAPITAL EPSILON
    0x1D6AD: ["<font>", 0x0396],  # MATHEMATICAL BOLD CAPITAL ZETA
    0x1D6AE: ["<font>", 0x0397],  # MATHEMATICAL BOLD CAPITAL ETA
    0x1D6AF: ["<font>", 0x0398],  # MATHEMATICAL BOLD CAPITAL THETA
    0x1D6B0: ["<font>", 0x0399],  # MATHEMATICAL BOLD CAPITAL IOTA
    0x1D6B1: ["<font>", 0x039A],  # MATHEMATICAL BOLD CAPITAL KAPPA
    0x1D6B2: ["<font>", 0x039B],  # MATHEMATICAL BOLD CAPITAL LAMDA
    0x1D6B3: ["<font>", 0x039C],  # MATHEMATICAL BOLD CAPITAL MU
    0x1D6B4: ["<font>", 0x039D],  # MATHEMATICAL BOLD CAPITAL NU
    0x1D6B5: ["<font>", 0x039E],  # MATHEMATICAL BOLD CAPITAL XI
    0x1D6B6: ["<font>", 0x039F],  # MATHEMATICAL BOLD CAPITAL OMICRON
    0x1D6B7: ["<font>", 0x03A0],  # MATHEMATICAL BOLD CAPITAL PI
    0x1D6B8: ["<font>", 0x03A1],  # MATHEMATICAL BOLD CAPITAL RHO
    0x1D6B9: ["<font>", 0x03F4],  # MATHEMATICAL BOLD CAPITAL THETA SYMBOL
    0x1D6BA: ["<font>", 0x03A3],  # MATHEMATICAL BOLD CAPITAL SIGMA
    0x1D6BB: ["<font>", 0x03A4],  # MATHEMATICAL BOLD CAPITAL TAU
    0x1D6BC: ["<font>", 0x03A5],  # MATHEMATICAL BOLD CAPITAL UPSILON
    0x1D6BD: ["<font>", 0x03A6],  # MATHEMATICAL BOLD CAPITAL PHI
    0x1D6BE: ["<font>", 0x03A7],  # MATHEMATICAL BOLD CAPITAL CHI
    0x1D6BF: ["<font>", 0x03A8],  # MATHEMATICAL BOLD CAPITAL PSI
    0x1D6C0: ["<font>", 0x03A9],  # MATHEMATICAL BOLD CAPITAL OMEGA
    0x1D6C1: ["<font>", 0x2207],  # MATHEMATICAL BOLD NABLA
    0x1D6C2: ["<font>", 0x03B1],  # MATHEMATICAL BOLD SMALL ALPHA
    0x1D6C3: ["<font>", 0x03B2],  # MATHEMATICAL BOLD SMALL BETA
    0x1D6C4: ["<font>", 0x03B3],  # MATHEMATICAL BOLD SMALL GAMMA
    0x1D6C5: ["<font>", 0x03B4],  # MATHEMATICAL BOLD SMALL DELTA
    0x1D6C6: ["<font>", 0x03B5],  # MATHEMATICAL BOLD SMALL EPSILON
    0x1D6C7: ["<font>", 0x03B6],  # MATHEMATICAL BOLD SMALL ZETA
    0x1D6C8: ["<font>", 0x03B7],  # MATHEMATICAL BOLD SMALL ETA
    0x1D6C9: ["<font>", 0x03B8],  # MATHEMATICAL BOLD SMALL THETA
    0x1D6CA: ["<font>", 0x03B9],  # MATHEMATICAL BOLD SMALL IOTA
    0x1D6CB: ["<font>", 0x03BA],  # MATHEMATICAL BOLD SMALL KAPPA
    0x1D6CC: ["<font>", 0x03BB],  # MATHEMATICAL BOLD SMALL LAMDA
    0x1D6CD: ["<font>", 0x03BC],  # MATHEMATICAL BOLD SMALL MU
    0x1D6CE: ["<font>", 0x03BD],  # MATHEMATICAL BOLD SMALL NU
    0x1D6CF: ["<font>", 0x03BE],  # MATHEMATICAL BOLD SMALL XI
    0x1D6D0: ["<font>", 0x03BF],  # MATHEMATICAL BOLD SMALL OMICRON
    0x1D6D1: ["<font>", 0x03C0],  # MATHEMATICAL BOLD SMALL PI
    0x1D6D2: ["<font>", 0x03C1],  # MATHEMATICAL BOLD SMALL RHO
    0x1D6D3: ["<font>", 0x03C2],  # MATHEMATICAL BOLD SMALL FINAL SIGMA
    0x1D6D4: ["<font>", 0x03C3],  # MATHEMATICAL BOLD SMALL SIGMA
    0x1D6D5: ["<font>", 0x03C4],  # MATHEMATICAL BOLD SMALL TAU
    0x1D6D6: ["<font>", 0x03C5],  # MATHEMATICAL BOLD SMALL UPSILON
    0x1D6D7: ["<font>", 0x03C6],  # MATHEMATICAL BOLD SMALL PHI
    0x1D6D8: ["<font>", 0x03C7],  # MATHEMATICAL BOLD SMALL CHI
    0x1D6D9: ["<font>", 0x03C8],  # MATHEMATICAL BOLD SMALL PSI
    0x1D6DA: ["<font>", 0x03C9],  # MATHEMATICAL BOLD SMALL OMEGA
    0x1D6DB: ["<font>", 0x2202],  # MATHEMATICAL BOLD PARTIAL DIFFERENTIAL
    0x1D6DC: ["<font>", 0x03F5],  # MATHEMATICAL BOLD EPSILON SYMBOL
    0x1D6DD: ["<font>", 0x03D1],  # MATHEMATICAL BOLD THETA SYMBOL
    0x1D6DE: ["<font>", 0x03F0],  # MATHEMATICAL BOLD KAPPA SYMBOL
    0x1D6DF: ["<font>", 0x03D5],  # MATHEMATICAL BOLD PHI SYMBOL
    0x1D6E0: ["<font>", 0x03F1],  # MATHEMATICAL BOLD RHO SYMBOL
    0x1D6E1: ["<font>", 0x03D6],  # MATHEMATICAL BOLD PI SYMBOL
    0x1D6E2: ["<font>", 0x0391],  # MATHEMATICAL ITALIC CAPITAL ALPHA
    0x1D6E3: ["<font>", 0x0392],  # MATHEMATICAL ITALIC CAPITAL BETA
    0x1D6E4: ["<font>", 0x0393],  # MATHEMATICAL ITALIC CAPITAL GAMMA
    0x1D6E5: ["<font>", 0x0394],  # MATHEMATICAL ITALIC CAPITAL DELTA
    0x1D6E6: ["<font>", 0x0395],  # MATHEMATICAL ITALIC CAPITAL EPSILON
    0x1D6E7: ["<font>", 0x0396],  # MATHEMATICAL ITALIC CAPITAL ZETA
    0x1D6E8: ["<font>", 0x0397],  # MATHEMATICAL ITALIC CAPITAL ETA
    0x1D6E9: ["<font>", 0x0398],  # MATHEMATICAL ITALIC CAPITAL THETA
    0x1D6EA: ["<font>", 0x0399],  # MATHEMATICAL ITALIC CAPITAL IOTA
    0x1D6EB: ["<font>", 0x039A],  # MATHEMATICAL ITALIC CAPITAL KAPPA
    0x1D6EC: ["<font>", 0x039B],  # MATHEMATICAL ITALIC CAPITAL LAMDA
    0x1D6ED: ["<font>", 0x039C],  # MATHEMATICAL ITALIC CAPITAL MU
    0x1D6EE: ["<font>", 0x039D],  # MATHEMATICAL ITALIC CAPITAL NU
    0x1D6EF: ["<font>", 0x039E],  # MATHEMATICAL ITALIC CAPITAL XI
    0x1D6F0: ["<font>", 0x039F],  # MATHEMATICAL ITALIC CAPITAL OMICRON
    0x1D6F1: ["<font>", 0x03A0],  # MATHEMATICAL ITALIC CAPITAL PI
    0x1D6F2: ["<font>", 0x03A1],  # MATHEMATICAL ITALIC CAPITAL RHO
    0x1D6F3: ["<font>", 0x03F4],  # MATHEMATICAL ITALIC CAPITAL THETA SYMBOL
    0x1D6F4: ["<font>", 0x03A3],  # MATHEMATICAL ITALIC CAPITAL SIGMA
    0x1D6F5: ["<font>", 0x03A4],  # MATHEMATICAL ITALIC CAPITAL TAU
    0x1D6F6: ["<font>", 0x03A5],  # MATHEMATICAL ITALIC CAPITAL UPSILON
    0x1D6F7: ["<font>", 0x03A6],  # MATHEMATICAL ITALIC CAPITAL PHI
    0x1D6F8: ["<font>", 0x03A7],  # MATHEMATICAL ITALIC CAPITAL CHI
    0x1D6F9: ["<font>", 0x03A8],  # MATHEMATICAL ITALIC CAPITAL PSI
    0x1D6FA: ["<font>", 0x03A9],  # MATHEMATICAL ITALIC CAPITAL OMEGA
    0x1D6FB: ["<font>", 0x2207],  # MATHEMATICAL ITALIC NABLA
    0x1D6FC: ["<font>", 0x03B1],  # MATHEMATICAL ITALIC SMALL ALPHA
    0x1D6FD: ["<font>", 0x03B2],  # MATHEMATICAL ITALIC SMALL BETA
    0x1D6FE: ["<font>", 0x03B3],  # MATHEMATICAL ITALIC SMALL GAMMA
    0x1D6FF: ["<font>", 0x03B4],  # MATHEMATICAL ITALIC SMALL DELTA
    0x1D700: ["<font>", 0x03B5],  # MATHEMATICAL ITALIC SMALL EPSILON
    0x1D701: ["<font>", 0x03B6],  # MATHEMATICAL ITALIC SMALL ZETA
    0x1D702: ["<font>", 0x03B7],  # MATHEMATICAL ITALIC SMALL ETA
    0x1D703: ["<font>", 0x03B8],  # MATHEMATICAL ITALIC SMALL THETA
    0x1D704: ["<font>", 0x03B9],  # MATHEMATICAL ITALIC SMALL IOTA
    0x1D705: ["<font>", 0x03BA],  # MATHEMATICAL ITALIC SMALL KAPPA
    0x1D706: ["<font>", 0x03BB],  # MATHEMATICAL ITALIC SMALL LAMDA
    0x1D707: ["<font>", 0x03BC],  # MATHEMATICAL ITALIC SMALL MU
    0x1D708: ["<font>", 0x03BD],  # MATHEMATICAL ITALIC SMALL NU
    0x1D709: ["<font>", 0x03BE],  # MATHEMATICAL ITALIC SMALL XI
    0x1D70A: ["<font>", 0x03BF],  # MATHEMATICAL ITALIC SMALL OMICRON
    0x1D70B: ["<font>", 0x03C0],  # MATHEMATICAL ITALIC SMALL PI
    0x1D70C: ["<font>", 0x03C1],  # MATHEMATICAL ITALIC SMALL RHO
    0x1D70D: ["<font>", 0x03C2],  # MATHEMATICAL ITALIC SMALL FINAL SIGMA
    0x1D70E: ["<font>", 0x03C3],  # MATHEMATICAL ITALIC SMALL SIGMA
    0x1D70F: ["<font>", 0x03C4],  # MATHEMATICAL ITALIC SMALL TAU
    0x1D710: ["<font>", 0x03C5],  # MATHEMATICAL ITALIC SMALL UPSILON
    0x1D711: ["<font>", 0x03C6],  # MATHEMATICAL ITALIC SMALL PHI
    0x1D712: ["<font>", 0x03C7],  # MATHEMATICAL ITALIC SMALL CHI
    0x1D713: ["<font>", 0x03C8],  # MATHEMATICAL ITALIC SMALL PSI
    0x1D714: ["<font>", 0x03C9],  # MATHEMATICAL ITALIC SMALL OMEGA
    0x1D715: ["<font>", 0x2202],  # MATHEMATICAL ITALIC PARTIAL DIFFERENTIAL
    0x1D716: ["<font>", 0x03F5],  # MATHEMATICAL ITALIC EPSILON SYMBOL
    0x1D717: ["<font>", 0x03D1],  # MATHEMATICAL ITALIC THETA SYMBOL
    0x1D718: ["<font>", 0x03F0],  # MATHEMATICAL ITALIC KAPPA SYMBOL
    0x1D719: ["<font>", 0x03D5],  # MATHEMATICAL ITALIC PHI SYMBOL
    0x1D71A: ["<font>", 0x03F1],  # MATHEMATICAL ITALIC RHO SYMBOL
    0x1D71B: ["<font>", 0x03D6],  # MATHEMATICAL ITALIC PI SYMBOL
    0x1D71C: ["<font>", 0x0391],  # MATHEMATICAL BOLD ITALIC CAPITAL ALPHA
    0x1D71D: ["<font>", 0x0392],  # MATHEMATICAL BOLD ITALIC CAPITAL BETA
    0x1D71E: ["<font>", 0x0393],  # MATHEMATICAL BOLD ITALIC CAPITAL GAMMA
    0x1D71F: ["<font>", 0x0394],  # MATHEMATICAL BOLD ITALIC CAPITAL DELTA
    0x1D720: ["<font>", 0x0395],  # MATHEMATICAL BOLD ITALIC CAPITAL EPSILON
    0x1D721: ["<font>", 0x0396],  # MATHEMATICAL BOLD ITALIC CAPITAL ZETA
    0x1D722: ["<font>", 0x0397],  # MATHEMATICAL BOLD ITALIC CAPITAL ETA
    0x1D723: ["<font>", 0x0398],  # MATHEMATICAL BOLD ITALIC CAPITAL THETA
    0x1D724: ["<font>", 0x0399],  # MATHEMATICAL BOLD ITALIC CAPITAL IOTA
    0x1D725: ["<font>", 0x039A],  # MATHEMATICAL BOLD ITALIC CAPITAL KAPPA
    0x1D726: ["<font>", 0x039B],  # MATHEMATICAL BOLD ITALIC CAPITAL LAMDA
    0x1D727: ["<font>", 0x039C],  # MATHEMATICAL BOLD ITALIC CAPITAL MU
    0x1D728: ["<font>", 0x039D],  # MATHEMATICAL BOLD ITALIC CAPITAL NU
    0x1D729: ["<font>", 0x039E],  # MATHEMATICAL BOLD ITALIC CAPITAL XI
    0x1D72A: ["<font>", 0x039F],  # MATHEMATICAL BOLD ITALIC CAPITAL OMICRON
    0x1D72B: ["<font>", 0x03A0],  # MATHEMATICAL BOLD ITALIC CAPITAL PI
    0x1D72C: ["<font>", 0x03A1],  # MATHEMATICAL BOLD ITALIC CAPITAL RHO
    0x1D72D: ["<font>", 0x03F4],  # MATHEMATICAL BOLD ITALIC CAPITAL THETA SYMBOL
    0x1D72E: ["<font>", 0x03A3],  # MATHEMATICAL BOLD ITALIC CAPITAL SIGMA
    0x1D72F: ["<font>", 0x03A4],  # MATHEMATICAL BOLD ITALIC CAPITAL TAU
    0x1D730: ["<font>", 0x03A5],  # MATHEMATICAL BOLD ITALIC CAPITAL UPSILON
    0x1D731: ["<font>", 0x03A6],  # MATHEMATICAL BOLD ITALIC CAPITAL PHI
    0x1D732: ["<font>", 0x03A7],  # MATHEMATICAL BOLD ITALIC CAPITAL CHI
    0x1D733: ["<font>", 0x03A8],  # MATHEMATICAL BOLD ITALIC CAPITAL PSI
    0x1D734: ["<font>", 0x03A9],  # MATHEMATICAL BOLD ITALIC CAPITAL OMEGA
    0x1D735: ["<font>", 0x2207],  # MATHEMATICAL BOLD ITALIC NABLA
    0x1D736: ["<font>", 0x03B1],  # MATHEMATICAL BOLD ITALIC SMALL ALPHA
    0x1D737: ["<font>", 0x03B2],  # MATHEMATICAL BOLD ITALIC SMALL BETA
    0x1D738: ["<font>", 0x03B3],  # MATHEMATICAL BOLD ITALIC SMALL GAMMA
    0x1D739: ["<font>", 0x03B4],  # MATHEMATICAL BOLD ITALIC SMALL DELTA
    0x1D73A: ["<font>", 0x03B5],  # MATHEMATICAL BOLD ITALIC SMALL EPSILON
    0x1D73B: ["<font>", 0x03B6],  # MATHEMATICAL BOLD ITALIC SMALL ZETA
    0x1D73C: ["<font>", 0x03B7],  # MATHEMATICAL BOLD ITALIC SMALL ETA
    0x1D73D: ["<font>", 0x03B8],  # MATHEMATICAL BOLD ITALIC SMALL THETA
    0x1D73E: ["<font>", 0x03B9],  # MATHEMATICAL BOLD ITALIC SMALL IOTA
    0x1D73F: ["<font>", 0x03BA],  # MATHEMATICAL BOLD ITALIC SMALL KAPPA
    0x1D740: ["<font>", 0x03BB],  # MATHEMATICAL BOLD ITALIC SMALL LAMDA
    0x1D741: ["<font>", 0x03BC],  # MATHEMATICAL BOLD ITALIC SMALL MU
    0x1D742: ["<font>", 0x03BD],  # MATHEMATICAL BOLD ITALIC SMALL NU
    0x1D743: ["<font>", 0x03BE],  # MATHEMATICAL BOLD ITALIC SMALL XI
    0x1D744: ["<font>", 0x03BF],  # MATHEMATICAL BOLD ITALIC SMALL OMICRON
    0x1D745: ["<font>", 0x03C0],  # MATHEMATICAL BOLD ITALIC SMALL PI
    0x1D746: ["<font>", 0x03C1],  # MATHEMATICAL BOLD ITALIC SMALL RHO
    0x1D747: ["<font>", 0x03C2],  # MATHEMATICAL BOLD ITALIC SMALL FINAL SIGMA
    0x1D748: ["<font>", 0x03C3],  # MATHEMATICAL BOLD ITALIC SMALL SIGMA
    0x1D749: ["<font>", 0x03C4],  # MATHEMATICAL BOLD ITALIC SMALL TAU
    0x1D74A: ["<font>", 0x03C5],  # MATHEMATICAL BOLD ITALIC SMALL UPSILON
    0x1D74B: ["<font>", 0x03C6],  # MATHEMATICAL BOLD ITALIC SMALL PHI
    0x1D74C: ["<font>", 0x03C7],  # MATHEMATICAL BOLD ITALIC SMALL CHI
    0x1D74D: ["<font>", 0x03C8],  # MATHEMATICAL BOLD ITALIC SMALL PSI
    0x1D74E: ["<font>", 0x03C9],  # MATHEMATICAL BOLD ITALIC SMALL OMEGA
    0x1D74F: ["<font>", 0x2202],  # MATHEMATICAL BOLD ITALIC PARTIAL DIFFERENTIAL
    0x1D750: ["<font>", 0x03F5],  # MATHEMATICAL BOLD ITALIC EPSILON SYMBOL
    0x1D751: ["<font>", 0x03D1],  # MATHEMATICAL BOLD ITALIC THETA SYMBOL
    0x1D752: ["<font>", 0x03F0],  # MATHEMATICAL BOLD ITALIC KAPPA SYMBOL
    0x1D753: ["<font>", 0x03D5],  # MATHEMATICAL BOLD ITALIC PHI SYMBOL
    0x1D754: ["<font>", 0x03F1],  # MATHEMATICAL BOLD ITALIC RHO SYMBOL
    0x1D755: ["<font>", 0x03D6],  # MATHEMATICAL BOLD ITALIC PI SYMBOL
    0x1D756: ["<font>", 0x0391],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL ALPHA
    0x1D757: ["<font>", 0x0392],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL BETA
    0x1D758: ["<font>", 0x0393],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL GAMMA
    0x1D759: ["<font>", 0x0394],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL DELTA
    0x1D75A: ["<font>", 0x0395],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL EPSILON
    0x1D75B: ["<font>", 0x0396],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL ZETA
    0x1D75C: ["<font>", 0x0397],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL ETA
    0x1D75D: ["<font>", 0x0398],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL THETA
    0x1D75E: ["<font>", 0x0399],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL IOTA
    0x1D75F: ["<font>", 0x039A],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL KAPPA
    0x1D760: ["<font>", 0x039B],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL LAMDA
    0x1D761: ["<font>", 0x039C],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL MU
    0x1D762: ["<font>", 0x039D],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL NU
    0x1D763: ["<font>", 0x039E],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL XI
    0x1D764: ["<font>", 0x039F],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL OMICRON
    0x1D765: ["<font>", 0x03A0],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL PI
    0x1D766: ["<font>", 0x03A1],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL RHO
    0x1D767: ["<font>", 0x03F4],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL THETA SYMBOL
    0x1D768: ["<font>", 0x03A3],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL SIGMA
    0x1D769: ["<font>", 0x03A4],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL TAU
    0x1D76A: ["<font>", 0x03A5],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL UPSILON
    0x1D76B: ["<font>", 0x03A6],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL PHI
    0x1D76C: ["<font>", 0x03A7],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL CHI
    0x1D76D: ["<font>", 0x03A8],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL PSI
    0x1D76E: ["<font>", 0x03A9],  # MATHEMATICAL SANS-SERIF BOLD CAPITAL OMEGA
    0x1D76F: ["<font>", 0x2207],  # MATHEMATICAL SANS-SERIF BOLD NABLA
    0x1D770: ["<font>", 0x03B1],  # MATHEMATICAL SANS-SERIF BOLD SMALL ALPHA
    0x1D771: ["<font>", 0x03B2],  # MATHEMATICAL SANS-SERIF BOLD SMALL BETA
    0x1D772: ["<font>", 0x03B3],  # MATHEMATICAL SANS-SERIF BOLD SMALL GAMMA
    0x1D773: ["<font>", 0x03B4],  # MATHEMATICAL SANS-SERIF BOLD SMALL DELTA
    0x1D774: ["<font>", 0x03B5],  # MATHEMATICAL SANS-SERIF BOLD SMALL EPSILON
    0x1D775: ["<font>", 0x03B6],  # MATHEMATICAL SANS-SERIF BOLD SMALL ZETA
    0x1D776: ["<font>", 0x03B7],  # MATHEMATICAL SANS-SERIF BOLD SMALL ETA
    0x1D777: ["<font>", 0x03B8],  # MATHEMATICAL SANS-SERIF BOLD SMALL THETA
    0x1D778: ["<font>", 0x03B9],  # MATHEMATICAL SANS-SERIF BOLD SMALL IOTA
    0x1D779: ["<font>", 0x03BA],  # MATHEMATICAL SANS-SERIF BOLD SMALL KAPPA
    0x1D77A: ["<font>", 0x03BB],  # MATHEMATICAL SANS-SERIF BOLD SMALL LAMDA
    0x1D77B: ["<font>", 0x03BC],  # MATHEMATICAL SANS-SERIF BOLD SMALL MU
    0x1D77C: ["<font>", 0x03BD],  # MATHEMATICAL SANS-SERIF BOLD SMALL NU
    0x1D77D: ["<font>", 0x03BE],  # MATHEMATICAL SANS-SERIF BOLD SMALL XI
    0x1D77E: ["<font>", 0x03BF],  # MATHEMATICAL SANS-SERIF BOLD SMALL OMICRON
    0x1D77F: ["<font>", 0x03C0],  # MATHEMATICAL SANS-SERIF BOLD SMALL PI
    0x1D780: ["<font>", 0x03C1],  # MATHEMATICAL SANS-SERIF BOLD SMALL RHO
    0x1D781: ["<font>", 0x03C2],  # MATHEMATICAL SANS-SERIF BOLD SMALL FINAL SIGMA
    0x1D782: ["<font>", 0x03C3],  # MATHEMATICAL SANS-SERIF BOLD SMALL SIGMA
    0x1D783: ["<font>", 0x03C4],  # MATHEMATICAL SANS-SERIF BOLD SMALL TAU
    0x1D784: ["<font>", 0x03C5],  # MATHEMATICAL SANS-SERIF BOLD SMALL UPSILON
    0x1D785: ["<font>", 0x03C6],  # MATHEMATICAL SANS-SERIF BOLD SMALL PHI
    0x1D786: ["<font>", 0x03C7],  # MATHEMATICAL SANS-SERIF BOLD SMALL CHI
    0x1D787: ["<font>", 0x03C8],  # MATHEMATICAL SANS-SERIF BOLD SMALL PSI
    0x1D788: ["<font>", 0x03C9],  # MATHEMATICAL SANS-SERIF BOLD SMALL OMEGA
    0x1D789: ["<font>", 0x2202],  # MATHEMATICAL SANS-SERIF BOLD PARTIAL DIFFERENTIAL
    0x1D78A: ["<font>", 0x03F5],  # MATHEMATICAL SANS-SERIF BOLD EPSILON SYMBOL
    0x1D78B: ["<font>", 0x03D1],  # MATHEMATICAL SANS-SERIF BOLD THETA SYMBOL
    0x1D78C: ["<font>", 0x03F0],  # MATHEMATICAL SANS-SERIF BOLD KAPPA SYMBOL
    0x1D78D: ["<font>", 0x03D5],  # MATHEMATICAL SANS-SERIF BOLD PHI SYMBOL
    0x1D78E: ["<font>", 0x03F1],  # MATHEMATICAL SANS-SERIF BOLD RHO SYMBOL
    0x1D78F: ["<font>", 0x03D6],  # MATHEMATICAL SANS-SERIF BOLD PI SYMBOL
    0x1D790: ["<font>", 0x0391],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL ALPHA
    0x1D791: ["<font>", 0x0392],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL BETA
    0x1D792: ["<font>", 0x0393],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL GAMMA
    0x1D793: ["<font>", 0x0394],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL DELTA
    0x1D794: ["<font>", 0x0395],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL EPSILON
    0x1D795: ["<font>", 0x0396],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL ZETA
    0x1D796: ["<font>", 0x0397],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL ETA
    0x1D797: ["<font>", 0x0398],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL THETA
    0x1D798: ["<font>", 0x0399],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL IOTA
    0x1D799: ["<font>", 0x039A],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL KAPPA
    0x1D79A: ["<font>", 0x039B],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL LAMDA
    0x1D79B: ["<font>", 0x039C],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL MU
    0x1D79C: ["<font>", 0x039D],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL NU
    0x1D79D: ["<font>", 0x039E],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL XI
    0x1D79E: ["<font>", 0x039F],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMICRON
    0x1D79F: ["<font>", 0x03A0],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL PI
    0x1D7A0: ["<font>", 0x03A1],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL RHO
    0x1D7A1: ["<font>", 0x03F4],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL THETA SYMBOL
    0x1D7A2: ["<font>", 0x03A3],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL SIGMA
    0x1D7A3: ["<font>", 0x03A4],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL TAU
    0x1D7A4: ["<font>", 0x03A5],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL UPSILON
    0x1D7A5: ["<font>", 0x03A6],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL PHI
    0x1D7A6: ["<font>", 0x03A7],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL CHI
    0x1D7A7: ["<font>", 0x03A8],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL PSI
    0x1D7A8: ["<font>", 0x03A9],  # MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMEGA
    0x1D7A9: ["<font>", 0x2207],  # MATHEMATICAL SANS-SERIF BOLD ITALIC NABLA
    0x1D7AA: ["<font>", 0x03B1],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ALPHA
    0x1D7AB: ["<font>", 0x03B2],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL BETA
    0x1D7AC: ["<font>", 0x03B3],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL GAMMA
    0x1D7AD: ["<font>", 0x03B4],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL DELTA
    0x1D7AE: ["<font>", 0x03B5],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL EPSILON
    0x1D7AF: ["<font>", 0x03B6],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ZETA
    0x1D7B0: ["<font>", 0x03B7],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ETA
    0x1D7B1: ["<font>", 0x03B8],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL THETA
    0x1D7B2: ["<font>", 0x03B9],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL IOTA
    0x1D7B3: ["<font>", 0x03BA],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL KAPPA
    0x1D7B4: ["<font>", 0x03BB],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL LAMDA
    0x1D7B5: ["<font>", 0x03BC],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL MU
    0x1D7B6: ["<font>", 0x03BD],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL NU
    0x1D7B7: ["<font>", 0x03BE],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL XI
    0x1D7B8: ["<font>", 0x03BF],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMICRON
    0x1D7B9: ["<font>", 0x03C0],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL PI
    0x1D7BA: ["<font>", 0x03C1],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL RHO
    0x1D7BB: ["<font>", 0x03C2],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL FINAL SIGMA
    0x1D7BC: ["<font>", 0x03C3],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL SIGMA
    0x1D7BD: ["<font>", 0x03C4],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL TAU
    0x1D7BE: ["<font>", 0x03C5],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL UPSILON
    0x1D7BF: ["<font>", 0x03C6],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL PHI
    0x1D7C0: ["<font>", 0x03C7],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL CHI
    0x1D7C1: ["<font>", 0x03C8],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL PSI
    0x1D7C2: ["<font>", 0x03C9],  # MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMEGA
    0x1D7C3: ["<font>", 0x2202],  # MATHEMATICAL SANS-SERIF BOLD ITALIC PARTIAL DIFFERENTIAL
    0x1D7C4: ["<font>", 0x03F5],  # MATHEMATICAL SANS-SERIF BOLD ITALIC EPSILON SYMBOL
    0x1D7C5: ["<font>", 0x03D1],  # MATHEMATICAL SANS-SERIF BOLD ITALIC THETA SYMBOL
    0x1D7C6: ["<font>", 0x03F0],  # MATHEMATICAL SANS-SERIF BOLD ITALIC KAPPA SYMBOL
    0x1D7C7: ["<font>", 0x03D5],  # MATHEMATICAL SANS-SERIF BOLD ITALIC PHI SYMBOL
    0x1D7C8: ["<font>", 0x03F1],  # MATHEMATICAL SANS-SERIF BOLD ITALIC RHO SYMBOL
    0x1D7C9: ["<font>", 0x03D6],  # MATHEMATICAL SANS-SERIF BOLD ITALIC PI SYMBOL
    0x1D7CA: ["<font>", 0x03DC],  # MATHEMATICAL BOLD CAPITAL DIGAMMA
    0x1D7CB: ["<font>", 0x03DD],  # MATHEMATICAL BOLD SMALL DIGAMMA
    0x1D7CE: ["<font>", 0x0030],  # MATHEMATICAL BOLD DIGIT ZERO
    0x1D7CF: ["<font>", 0x0031],  # MATHEMATICAL BOLD DIGIT ONE
    0x1D7D0: ["<font>", 0x0032],  # MATHEMATICAL BOLD DIGIT TWO
    0x1D7D1: ["<font>", 0x0033],  # MATHEMATICAL BOLD DIGIT THREE
    0x1D7D2: ["<font>", 0x0034],  # MATHEMATICAL BOLD DIGIT FOUR
    0x1D7D3: ["<font>", 0x0035],  # MATHEMATICAL BOLD DIGIT FIVE
    0x1D7D4: ["<font>", 0x0036],  # MATHEMATICAL BOLD DIGIT SIX
    0x1D7D5: ["<font>", 0x0037],  # MATHEMATICAL BOLD DIGIT SEVEN
    0x1D7D6: ["<font>", 0x0038],  # MATHEMATICAL BOLD DIGIT EIGHT
    0x1D7D7: ["<font>", 0x0039],  # MATHEMATICAL BOLD DIGIT NINE
    0x1D7D8: ["<font>", 0x0030],  # MATHEMATICAL DOUBLE-STRUCK DIGIT ZERO
    0x1D7D9: ["<font>", 0x0031],  # MATHEMATICAL DOUBLE-STRUCK DIGIT ONE
    0x1D7DA: ["<font>", 0x0032],  # MATHEMATICAL DOUBLE-STRUCK DIGIT TWO
    0x1D7DB: ["<font>", 0x0033],  # MATHEMATICAL DOUBLE-STRUCK DIGIT THREE
    0x1D7DC: ["<font>", 0x0034],  # MATHEMATICAL DOUBLE-STRUCK DIGIT FOUR
    0x1D7DD: ["<font>", 0x0035],  # MATHEMATICAL DOUBLE-STRUCK DIGIT FIVE
    0x1D7DE: ["<font>", 0x0036],  # MATHEMATICAL DOUBLE-STRUCK DIGIT SIX
    0x1D7DF: ["<font>", 0x0037],  # MATHEMATICAL DOUBLE-STRUCK DIGIT SEVEN
    0x1D7E0: ["<font>", 0x0038],  # MATHEMATICAL DOUBLE-STRUCK DIGIT EIGHT
    0x1D7E1: ["<font>", 0x0039],  # MATHEMATICAL DOUBLE-STRUCK DIGIT NINE
    0x1D7E2: ["<font>", 0x0030],  # MATHEMATICAL SANS-SERIF DIGIT ZERO
    0x1D7E3: ["<font>", 0x0031],  # MATHEMATICAL SANS-SERIF DIGIT ONE
    0x1D7E4: ["<font>", 0x0032],  # MATHEMATICAL SANS-SERIF DIGIT TWO
    0x1D7E5: ["<font>", 0x0033],  # MATHEMATICAL SANS-SERIF DIGIT THREE
    0x1D7E6: ["<font>", 0x0034],  # MATHEMATICAL SANS-SERIF DIGIT FOUR
    0x1D7E7: ["<font>", 0x0035],  # MATHEMATICAL SANS-SERIF DIGIT FIVE
    0x1D7E8: ["<font>", 0x0036],  # MATHEMATICAL SANS-SERIF DIGIT SIX
    0x1D7E9: ["<font>", 0x0037],  # MATHEMATICAL SANS-SERIF DIGIT SEVEN
    0x1D7EA: ["<font>", 0x0038],  # MATHEMATICAL SANS-SERIF DIGIT EIGHT
    0x1D7EB: ["<font>", 0x0039],  # MATHEMATICAL SANS-SERIF DIGIT NINE
    0x1D7EC: ["<font>", 0x0030],  # MATHEMATICAL SANS-SERIF BOLD DIGIT ZERO
    0x1D7ED: ["<font>", 0x0031],  # MATHEMATICAL SANS-SERIF BOLD DIGIT ONE
    0x1D7EE: ["<font>", 0x0032],  # MATHEMATICAL SANS-SERIF BOLD DIGIT TWO
    0x1D7EF: ["<font>", 0x0033],  # MATHEMATICAL SANS-SERIF BOLD DIGIT THREE
    0x1D7F0: ["<font>", 0x0034],  # MATHEMATICAL SANS-SERIF BOLD DIGIT FOUR
    0x1D7F1: ["<font>", 0x0035],  # MATHEMATICAL SANS-SERIF BOLD DIGIT FIVE
    0x1D7F2: ["<font>", 0x0036],  # MATHEMATICAL SANS-SERIF BOLD DIGIT SIX
    0x1D7F3: ["<font>", 0x0037],  # MATHEMATICAL SANS-SERIF BOLD DIGIT SEVEN
    0x1D7F4: ["<font>", 0x0038],  # MATHEMATICAL SANS-SERIF BOLD DIGIT EIGHT
    0x1D7F5: ["<font>", 0x0039],  # MATHEMATICAL SANS-SERIF BOLD DIGIT NINE
    0x1D7F6: ["<font>", 0x0030],  # MATHEMATICAL MONOSPACE DIGIT ZERO
    0x1D7F7: ["<font>", 0x0031],  # MATHEMATICAL MONOSPACE DIGIT ONE
    0x1D7F8: ["<font>", 0x0032],  # MATHEMATICAL MONOSPACE DIGIT TWO
    0x1D7F9: ["<font>", 0x0033],  # MATHEMATICAL MONOSPACE DIGIT THREE
    0x1D7FA: ["<font>", 0x0034],  # MATHEMATICAL MONOSPACE DIGIT FOUR
    0x1D7FB: ["<font>", 0x0035],  # MATHEMATICAL MONOSPACE DIGIT FIVE
    0x1D7FC: ["<font>", 0x0036],  # MATHEMATICAL MONOSPACE DIGIT SIX
    0x1D7FD: ["<font>", 0x0037],  # MATHEMATICAL MONOSPACE DIGIT SEVEN
    0x1D7FE: ["<font>", 0x0038],  # MATHEMATICAL MONOSPACE DIGIT EIGHT
    0x1D7FF: ["<font>", 0x0039],  # MATHEMATICAL MONOSPACE DIGIT NINE
    0x1E030: ["<super>", 0x0430],  # MODIFIER LETTER CYRILLIC SMALL A
    0x1E031: ["<super>", 0x0431],  # MODIFIER LETTER CYRILLIC SMALL BE
    0x1E032: ["<super>", 0x0432],  # MODIFIER LETTER CYRILLIC SMALL VE
    0x1E033: ["<super>", 0x0433],  # MODIFIER LETTER CYRILLIC SMALL GHE
    0x1E034: ["<super>", 0x0434],  # MODIFIER LETTER CYRILLIC SMALL DE
    0x1E035: ["<super>", 0x0435],  # MODIFIER LETTER CYRILLIC SMALL IE
    0x1E036: ["<super>", 0x0436],  # MODIFIER LETTER CYRILLIC SMALL ZHE
    0x1E037: ["<super>", 0x0437],  # MODIFIER LETTER CYRILLIC SMALL ZE
    0x1E038: ["<super>", 0x0438],  # MODIFIER LETTER CYRILLIC SMALL I
    0x1E039: ["<super>", 0x043A],  # MODIFIER LETTER CYRILLIC SMALL KA
    0x1E03A: ["<super>", 0x043B],  # MODIFIER LETTER CYRILLIC SMALL EL
    0x1E03B: ["<super>", 0x043C],  # MODIFIER LETTER CYRILLIC SMALL EM
    0x1E03C: ["<super>", 0x043E],  # MODIFIER LETTER CYRILLIC SMALL O
    0x1E03D: ["<super>", 0x043F],  # MODIFIER LETTER CYRILLIC SMALL PE
    0x1E03E: ["<super>", 0x0440],  # MODIFIER LETTER CYRILLIC SMALL ER
    0x1E03F: ["<super>", 0x0441],  # MODIFIER LETTER CYRILLIC SMALL ES
    0x1E040: ["<super>", 0x0442],  # MODIFIER LETTER CYRILLIC SMALL TE
    0x1E041: ["<super>", 0x0443],  # MODIFIER LETTER CYRILLIC SMALL U
    0x1E042: ["<super>", 0x0444],  # MODIFIER LETTER CYRILLIC SMALL EF
    0x1E043: ["<super>", 0x0445],  # MODIFIER LETTER CYRILLIC SMALL HA
    0x1E044: ["<super>", 0x0446],  # MODIFIER LETTER CYRILLIC SMALL TSE
    0x1E045: ["<super>", 0x0447],  # MODIFIER LETTER CYRILLIC SMALL CHE
    0x1E046: ["<super>", 0x0448],  # MODIFIER LETTER CYRILLIC SMALL SHA
    0x1E047: ["<super>", 0x044B],  # MODIFIER LETTER CYRILLIC SMALL YERU
    0x1E048: ["<super>", 0x044D],  # MODIFIER LETTER CYRILLIC SMALL E
    0x1E049: ["<super>", 0x044E],  # MODIFIER LETTER CYRILLIC SMALL YU
    0x1E04A: ["<super>", 0xA689],  # MODIFIER LETTER CYRILLIC SMALL DZZE
    0x1E04B: ["<super>", 0x04D9],  # MODIFIER LETTER CYRILLIC SMALL SCHWA
    0x1E04C: ["<super>", 0x0456],  # MODIFIER LETTER CYRILLIC SMALL BYELORUSSIAN-UKRAINIAN I
    0x1E04D: ["<super>", 0x0458],  # MODIFIER LETTER CYRILLIC SMALL JE
    0x1E04E: ["<super>", 0x04E9],  # MODIFIER LETTER CYRILLIC SMALL BARRED O
    0x1E04F: ["<super>", 0x04AF],  # MODIFIER LETTER CYRILLIC SMALL STRAIGHT U
    0x1E050: ["<super>", 0x04CF],  # MODIFIER LETTER CYRILLIC SMALL PALOCHKA
    0x1E051: ["<sub>", 0x0430],  # CYRILLIC SUBSCRIPT SMALL LETTER A
    0x1E052: ["<sub>", 0x0431],  # CYRILLIC SUBSCRIPT SMALL LETTER BE
    0x1E053: ["<sub>", 0x0432],  # CYRILLIC SUBSCRIPT SMALL LETTER VE
    0x1E054: ["<sub>", 0x0433],  # CYRILLIC SUBSCRIPT SMALL LETTER GHE
    0x1E055: ["<sub>", 0x0434],  # CYRILLIC SUBSCRIPT SMALL LETTER DE
    0x1E056: ["<sub>", 0x0435],  # CYRILLIC SUBSCRIPT SMALL LETTER IE
    0x1E057: ["<sub>", 0x0436],  # CYRILLIC SUBSCRIPT SMALL LETTER ZHE
    0x1E058: ["<sub>", 0x0437],  # CYRILLIC SUBSCRIPT SMALL LETTER ZE
    0x1E059: ["<sub>", 0x0438],  # CYRILLIC SUBSCRIPT SMALL LETTER I
    0x1E05A: ["<sub>", 0x043A],  # CYRILLIC SUBSCRIPT SMALL LETTER KA
    0x1E05B: ["<sub>", 0x043B],  # CYRILLIC SUBSCRIPT SMALL LETTER EL
    0x1E05C: ["<sub>", 0x043E],  # CYRILLIC SUBSCRIPT SMALL LETTER O
    0x1E05D: ["<sub>", 0x043F],  # CYRILLIC SUBSCRIPT SMALL LETTER PE
    0x1E05E: ["<sub>", 0x0441],  # CYRILLIC SUBSCRIPT SMALL LETTER ES
    0x1E05F: ["<sub>", 0x0443],  # CYRILLIC SUBSCRIPT SMALL LETTER U
    0x1E060: ["<sub>", 0x0444],  # CYRILLIC SUBSCRIPT SMALL LETTER EF
    0x1E061: ["<sub>", 0x0445],  # CYRILLIC SUBSCRIPT SMALL LETTER HA
    0x1E062: ["<sub>", 0x0446],  # CYRILLIC SUBSCRIPT SMALL LETTER TSE
    0x1E063: ["<sub>", 0x0447],  # CYRILLIC SUBSCRIPT SMALL LETTER CHE
    0x1E064: ["<sub>", 0x0448],  # CYRILLIC SUBSCRIPT SMALL LETTER SHA
    0x1E065: ["<sub>", 0x044A],  # CYRILLIC SUBSCRIPT SMALL LETTER HARD SIGN
    0x1E066: ["<sub>", 0x044B],  # CYRILLIC SUBSCRIPT SMALL LETTER YERU
    0x1E067: ["<sub>", 0x0491],  # CYRILLIC SUBSCRIPT SMALL LETTER GHE WITH UPTURN
    0x1E068: ["<sub>", 0x0456],  # CYRILLIC SUBSCRIPT SMALL LETTER BYELORUSSIAN-UKRAINIAN I
    0x1E069: ["<sub>", 0x0455],  # CYRILLIC SUBSCRIPT SMALL LETTER DZE
    0x1E06A: ["<sub>", 0x045F],  # CYRILLIC SUBSCRIPT SMALL LETTER DZHE
    0x1E06B: ["<super>", 0x04AB],  # MODIFIER LETTER CYRILLIC SMALL ES WITH DESCENDER
    0x1E06C: ["<super>", 0xA651],  # MODIFIER LETTER CYRILLIC SMALL YERU WITH BACK YER
    0x1E06D: ["<super>", 0x04B1],  # MODIFIER LETTER CYRILLIC SMALL STRAIGHT U WITH STROKE
    0x1EE00: ["<font>", 0x0627],  # ARABIC MATHEMATICAL ALEF
    0x1EE01: ["<font>", 0x0628],  # ARABIC MATHEMATICAL BEH
    0x1EE02: ["<font>", 0x062C],  # ARABIC MATHEMATICAL JEEM
    0x1EE03: ["<font>", 0x062F],  # ARABIC MATHEMATICAL DAL
    0x1EE05: ["<font>", 0x0648],  # ARABIC MATHEMATICAL WAW
    0x1EE06: ["<font>", 0x0632],  # ARABIC MATHEMATICAL ZAIN
    0x1EE07: ["<font>", 0x062D],  # ARABIC MATHEMATICAL HAH
    0x1EE08: ["<font>", 0x0637],  # ARABIC MATHEMATICAL TAH
    0x1EE09: ["<font>", 0x064A],  # ARABIC MATHEMATICAL YEH
    0x1EE0A: ["<font>", 0x0643],  # ARABIC MATHEMATICAL KAF
    0x1EE0B: ["<font>", 0x0644],  # ARABIC MATHEMATICAL LAM
    0x1EE0C: ["<font>", 0x0645],  # ARABIC MATHEMATICAL MEEM
    0x1EE0D: ["<font>", 0x0646],  # ARABIC MATHEMATICAL NOON
    0x1EE0E: ["<font>", 0x0633],  # ARABIC MATHEMATICAL SEEN
    0x1EE0F: ["<font>", 0x0639],  # ARABIC MATHEMATICAL AIN
    0x1EE10: ["<font>", 0x0641],  # ARABIC MATHEMATICAL FEH
    0x1EE11: ["<font>", 0x0635],  # ARABIC MATHEMATICAL SAD
    0x1EE12: ["<font>", 0x0642],  # ARABIC MATHEMATICAL QAF
    0x1EE13: ["<font>", 0x0631],  # ARABIC MATHEMATICAL REH
    0x1EE14: ["<font>", 0x0634],  # ARABIC MATHEMATICAL SHEEN
    0x1EE15: ["<font>", 0x062A],  # ARABIC MATHEMATICAL TEH
    0x1EE16: ["<font>", 0x062B],  # ARABIC MATHEMATICAL THEH
    0x1EE17: ["<font>", 0x062E],  # ARABIC MATHEMATICAL KHAH
    0x1EE18: ["<font>", 0x0630],  # ARABIC MATHEMATICAL THAL
    0x1EE19: ["<font>", 0x0636],  # ARABIC MATHEMATICAL DAD
    0x1EE1A: ["<font>", 0x0638],  # ARABIC MATHEMATICAL ZAH
    0x1EE1B: ["<font>", 0x063A],  # ARABIC MATHEMATICAL GHAIN
    0x1EE1C: ["<font>", 0x066E],  # ARABIC MATHEMATICAL DOTLESS BEH
    0x1EE1D: ["<font>", 0x06BA],  # ARABIC MATHEMATICAL DOTLESS NOON
    0x1EE1E: ["<font>", 0x06A1],  # ARABIC MATHEMATICAL DOTLESS FEH
    0x1EE1F: ["<font>", 0x066F],  # ARABIC MATHEMATICAL DOTLESS QAF
    0x1EE21: ["<font>", 0x0628],  # ARABIC MATHEMATICAL INITIAL BEH
    0x1EE22: ["<font>", 0x062C],  # ARABIC MATHEMATICAL INITIAL JEEM
    0x1EE24: ["<font>", 0x0647],  # ARABIC MATHEMATICAL INITIAL HEH
    0x1EE27: ["<font>", 0x062D],  # ARABIC MATHEMATICAL INITIAL HAH
    0x1EE29: ["<font>", 0x064A],  # ARABIC MATHEMATICAL INITIAL YEH
    0x1EE2A: ["<font>", 0x0643],  # ARABIC MATHEMATICAL INITIAL KAF
    0x1EE2B: ["<font>", 0x0644],  # ARABIC MATHEMATICAL INITIAL LAM
    0x1EE2C: ["<font>", 0x0645],  # ARABIC MATHEMATICAL INITIAL MEEM
    0x1EE2D: ["<font>", 0x0646],  # ARABIC MATHEMATICAL INITIAL NOON
    0x1EE2E: ["<font>", 0x0633],  # ARABIC MATHEMATICAL INITIAL SEEN
    0x1EE2F: ["<font>", 0x0639],  # ARABIC MATHEMATICAL INITIAL AIN
    0x1EE30: ["<font>", 0x0641],  # ARABIC MATHEMATICAL INITIAL FEH
    0x1EE31: ["<font>", 0x0635],  # ARABIC MATHEMATICAL INITIAL SAD
    0x1EE32: ["<font>", 0x0642],  # ARABIC MATHEMATICAL INITIAL QAF
    0x1EE34: ["<font>", 0x0634],  # ARABIC MATHEMATICAL INITIAL SHEEN
    0x1EE35: ["<font>", 0x062A],  # ARABIC MATHEMATICAL INITIAL TEH
    0x1EE36: ["<font>", 0x062B],  # ARABIC MATHEMATICAL INITIAL THEH
    0x1EE37: ["<font>", 0x062E],  # ARABIC MATHEMATICAL INITIAL KHAH
    0x1EE39: ["<font>", 0x0636],  # ARABIC MATHEMATICAL INITIAL DAD
    0x1EE3B: ["<font>", 0x063A],  # ARABIC MATHEMATICAL INITIAL GHAIN
    0x1EE42: ["<font>", 0x062C],  # ARABIC MATHEMATICAL TAILED JEEM
    0x1EE47: ["<font>", 0x062D],  # ARABIC MATHEMATICAL TAILED HAH
    0x1EE49: ["<font>", 0x064A],  # ARABIC MATHEMATICAL TAILED YEH
    0x1EE4B: ["<font>", 0x0644],  # ARABIC MATHEMATICAL TAILED LAM
    0x1EE4D: ["<font>", 0x0646],  # ARABIC MATHEMATICAL TAILED NOON
    0x1EE4E: ["<font>", 0x0633],  # ARABIC MATHEMATICAL TAILED SEEN
    0x1EE4F: ["<font>", 0x0639],  # ARABIC MATHEMATICAL TAILED AIN
    0x1EE51: ["<font>", 0x0635],  # ARABIC MATHEMATICAL TAILED SAD
    0x1EE52: ["<font>", 0x0642],  # ARABIC MATHEMATICAL TAILED QAF
    0x1EE54: ["<font>", 0x0634],  # ARABIC MATHEMATICAL TAILED SHEEN
    0x1EE57: ["<font>", 0x062E],  # ARABIC MATHEMATICAL TAILED KHAH
    0x1EE59: ["<font>", 0x0636],  # ARABIC MATHEMATICAL TAILED DAD
    0x1EE5B: ["<font>", 0x063A],  # ARABIC MATHEMATICAL TAILED GHAIN
    0x1EE5D: ["<font>", 0x06BA],  # ARABIC MATHEMATICAL TAILED DOTLESS NOON
    0x1EE5F: ["<font>", 0x066F],  # ARABIC MATHEMATICAL TAILED DOTLESS QAF
    0x1EE61: ["<font>", 0x0628],  # ARABIC MATHEMATICAL STRETCHED BEH
    0x1EE62: ["<font>", 0x062C],  # ARABIC MATHEMATICAL STRETCHED JEEM
    0x1EE64: ["<font>", 0x0647],  # ARABIC MATHEMATICAL STRETCHED HEH
    0x1EE67: ["<font>", 0x062D],  # ARABIC MATHEMATICAL STRETCHED HAH
    0x1EE68: ["<font>", 0x0637],  # ARABIC MATHEMATICAL STRETCHED TAH
    0x1EE69: ["<font>", 0x064A],  # ARABIC MATHEMATICAL STRETCHED YEH
    0x1EE6A: ["<font>", 0x0643],  # ARABIC MATHEMATICAL STRETCHED KAF
    0x1EE6C: ["<font>", 0x0645],  # ARABIC MATHEMATICAL STRETCHED MEEM
    0x1EE6D: ["<font>", 0x0646],  # ARABIC MATHEMATICAL STRETCHED NOON
    0x1EE6E: ["<font>", 0x0633],  # ARABIC MATHEMATICAL STRETCHED SEEN
    0x1EE6F: ["<font>", 0x0639],  # ARABIC MATHEMATICAL STRETCHED AIN
    0x1EE70: ["<font>", 0x0641],  # ARABIC MATHEMATICAL STRETCHED FEH
    0x1EE71: ["<font>", 0x0635],  # ARABIC MATHEMATICAL STRETCHED SAD
    0x1EE72: ["<font>", 0x0642],  # ARABIC MATHEMATICAL STRETCHED QAF
    0x1EE74: ["<font>", 0x0634],  # ARABIC MATHEMATICAL STRETCHED SHEEN
    0x1EE75: ["<font>", 0x062A],  # ARABIC MATHEMATICAL STRETCHED TEH
    0x1EE76: ["<font>", 0x062B],  # ARABIC MATHEMATICAL STRETCHED THEH
    0x1EE77: ["<font>", 0x062E],  # ARABIC MATHEMATICAL STRETCHED KHAH
    0x1EE79: ["<font>", 0x0636],  # ARABIC MATHEMATICAL STRETCHED DAD
    0x1EE7A: ["<font>", 0x0638],  # ARABIC MATHEMATICAL STRETCHED ZAH
    0x1EE7B: ["<font>", 0x063A],  # ARABIC MATHEMATICAL STRETCHED GHAIN
    0x1EE7C: ["<font>", 0x066E],  # ARABIC MATHEMATICAL STRETCHED DOTLESS BEH
    0x1EE7E: ["<font>", 0x06A1],  # ARABIC MATHEMATICAL STRETCHED DOTLESS FEH
    0x1EE80: ["<font>", 0x0627],  # ARABIC MATHEMATICAL LOOPED ALEF
    0x1EE81: ["<font>", 0x0628],  # ARABIC MATHEMATICAL LOOPED BEH
    0x1EE82: ["<font>", 0x062C],  # ARABIC MATHEMATICAL LOOPED JEEM
    0x1EE83: ["<font>", 0x062F],  # ARABIC MATHEMATICAL LOOPED DAL
    0x1EE84: ["<font>", 0x0647],  # ARABIC MATHEMATICAL LOOPED HEH
    0x1EE85: ["<font>", 0x0648],  # ARABIC MATHEMATICAL LOOPED WAW
    0x1EE86: ["<font>", 0x0632],  # ARABIC MATHEMATICAL LOOPED ZAIN
    0x1EE87: ["<font>", 0x062D],  # ARABIC MATHEMATICAL LOOPED HAH
    0x1EE88: ["<font>", 0x0637],  # ARABIC MATHEMATICAL LOOPED TAH
    0x1EE89: ["<font>", 0x064A],  # ARABIC MATHEMATICAL LOOPED YEH
    0x1EE8B: ["<font>", 0x0644],  # ARABIC MATHEMATICAL LOOPED LAM
    0x1EE8C: ["<font>", 0x0645],  # ARABIC MATHEMATICAL LOOPED MEEM
    0x1EE8D: ["<font>", 0x0646],  # ARABIC MATHEMATICAL LOOPED NOON
    0x1EE8E: ["<font>", 0x0633],  # ARABIC MATHEMATICAL LOOPED SEEN
    0x1EE8F: ["<font>", 0x0639],  # ARABIC MATHEMATICAL LOOPED AIN
    0x1EE90: ["<font>", 0x0641],  # ARABIC MATHEMATICAL LOOPED FEH
    0x1EE91: ["<font>", 0x0635],  # ARABIC MATHEMATICAL LOOPED SAD
    0x1EE92: ["<font>", 0x0642],  # ARABIC MATHEMATICAL LOOPED QAF
    0x1EE93: ["<font>", 0x0631],  # ARABIC MATHEMATICAL LOOPED REH
    0x1EE94: ["<font>", 0x0634],  # ARABIC MATHEMATICAL LOOPED SHEEN
    0x1EE95: ["<font>", 0x062A],  # ARABIC MATHEMATICAL LOOPED TEH
    0x1EE96: ["<font>", 0x062B],  # ARABIC MATHEMATICAL LOOPED THEH
    0x1EE97: ["<font>", 0x062E],  # ARABIC MATHEMATICAL LOOPED KHAH
    0x1EE98: ["<font>", 0x0630],  # ARABIC MATHEMATICAL LOOPED THAL
    0x1EE99: ["<font>", 0x0636],  # ARABIC MATHEMATICAL LOOPED DAD
    0x1EE9A: ["<font>", 0x0638],  # ARABIC MATHEMATICAL LOOPED ZAH
    0x1EE9B: ["<font>", 0x063A],  # ARABIC MATHEMATICAL LOOPED GHAIN
    0x1EEA1: ["<font>", 0x0628],  # ARABIC MATHEMATICAL DOUBLE-STRUCK BEH
    0x1EEA2: ["<font>", 0x062C],  # ARABIC MATHEMATICAL DOUBLE-STRUCK JEEM
    0x1EEA3: ["<font>", 0x062F],  # ARABIC MATHEMATICAL DOUBLE-STRUCK DAL
    0x1EEA5: ["<font>", 0x0648],  # ARABIC MATHEMATICAL DOUBLE-STRUCK WAW
    0x1EEA6: ["<font>", 0x0632],  # ARABIC MATHEMATICAL DOUBLE-STRUCK ZAIN
    0x1EEA7: ["<font>", 0x062D],  # ARABIC MATHEMATICAL DOUBLE-STRUCK HAH
    0x1EEA8: ["<font>", 0x0637],  # ARABIC MATHEMATICAL DOUBLE-STRUCK TAH
    0x1EEA9: ["<font>", 0x064A],  # ARABIC MATHEMATICAL DOUBLE-STRUCK YEH
    0x1EEAB: ["<font>", 0x0644],  # ARABIC MATHEMATICAL DOUBLE-STRUCK LAM
    0x1EEAC: ["<font>", 0x0645],  # ARABIC MATHEMATICAL DOUBLE-STRUCK MEEM
    0x1EEAD: ["<font>", 0x0646],  # ARABIC MATHEMATICAL DOUBLE-STRUCK NOON
    0x1EEAE: ["<font>", 0x0633],  # ARABIC MATHEMATICAL DOUBLE-STRUCK SEEN
    0x1EEAF: ["<font>", 0x0639],  # ARABIC MATHEMATICAL DOUBLE-STRUCK AIN
    0x1EEB0: ["<font>", 0x0641],  # ARABIC MATHEMATICAL DOUBLE-STRUCK FEH
    0x1EEB1: ["<font>", 0x0635],  # ARABIC MATHEMATICAL DOUBLE-STRUCK SAD
    0x1EEB2: ["<font>", 0x0642],  # ARABIC MATHEMATICAL DOUBLE-STRUCK QAF
    0x1EEB3: ["<font>", 0x0631],  # ARABIC MATHEMATICAL DOUBLE-STRUCK REH
    0x1EEB4: ["<font>", 0x0634],  # ARABIC MATHEMATICAL DOUBLE-STRUCK SHEEN
    0x1EEB5: ["<font>", 0x062A],  # ARABIC MATHEMATICAL DOUBLE-STRUCK TEH
    0x1EEB6: ["<font>", 0x062B],  # ARABIC MATHEMATICAL DOUBLE-STRUCK THEH
    0x1EEB7: ["<font>", 0x062E],  # ARABIC MATHEMATICAL DOUBLE-STRUCK KHAH
    0x1EEB8: ["<font>", 0x0630],  # ARABIC MATHEMATICAL DOUBLE-STRUCK THAL
    0x1EEB9: ["<font>", 0x0636],  # ARABIC MATHEMATICAL DOUBLE-STRUCK DAD
    0x1EEBA: ["<font>", 0x0638],  # ARABIC MATHEMATICAL DOUBLE-STRUCK ZAH
    0x1EEBB: ["<font>", 0x063A],  # ARABIC MATHEMATICAL DOUBLE-STRUCK GHAIN
    0x1F100: ["<compat>", 0x0030, 0x002E],  # DIGIT ZERO FULL STOP
    0x1F101: ["<compat>", 0x0030, 0x002C],  # DIGIT ZERO COMMA
    0x1F102: ["<compat>", 0x0031, 0x002C],  # DIGIT ONE COMMA
    0x1F103: ["<compat>", 0x0032, 0x002C],  # DIGIT TWO COMMA
    0x1F104: ["<compat>", 0x0033, 0x002C],  # DIGIT THREE COMMA
    0x1F105: ["<compat>", 0x0034, 0x002C],  # DIGIT FOUR COMMA
    0x1F106: ["<compat>", 0x0035, 0x002C],  # DIGIT FIVE COMMA
    0x1F107: ["<compat>", 0x0036, 0x002C],  # DIGIT SIX COMMA
    0x1F108: ["<compat>", 0x0037, 0x002C],  # DIGIT SEVEN COMMA
    0x1F109: ["<compat>", 0x0038, 0x002C],  # DIGIT EIGHT COMMA
    0x1F10A: ["<compat>", 0x0039, 0x002C],  # DIGIT NINE COMMA
    0x1F110: ["<compat>", 0x0028, 0x0041, 0x0029],  # PARENTHESIZED LATIN CAPITAL LETTER A
    0x1F111: ["<compat>", 0x0028, 0x0042, 0x0029],  # PARENTHESIZED LATIN CAPITAL LETTER B
    0x1F112: ["<compat>", 0x0028, 0x0043, 0x0029],  # PARENTHESIZED LATIN CAPITAL LETTER C
    0x1F113: ["<compat>", 0x0028, 0x0044, 0x0029],  # PARENTHESIZED LATIN CAPITAL LETTER D
    0x1F114: ["<compat>", 0x0028, 0x0045, 0x0029],  # PARENTHESIZED LATIN CAPITAL LETTER E
    0x1F115: ["<compat>", 0x0028, 0x0046, 0x0029],  # PARENTHESIZED LATIN CAPITAL LETTER F
    0x1F116: ["<compat>", 0x0028, 0x0047, 0x0029],  # PARENTHESIZED LATIN CAPITAL LETTER G
    0x1F117: ["<compat>", 0x0028, 0x0048, 0x0029],  # PARENTHESIZED LATIN CAPITAL LETTER H
    0x1F118: ["<compat>", 0x0028, 0x0049, 0x0029],  # PARENTHESIZED LATIN CAPITAL LETTER I
    0x1F119: ["<compat>", 0x0028, 0x004A, 0x0029],  # PARENTHESIZED LATIN CAPITAL LETTER J
    0x1F11A: ["<compat>", 0x0028, 0x004B, 0x0029],  # PARENTHESIZED LATIN CAPITAL LETTER K
    0x1F11B: ["<compat>", 0x0028, 0x004C, 0x0029],  # PARENTHESIZED LATIN CAPITAL LETTER L
    0x1F11C: ["<compat>", 0x0028, 0x004D, 0x0029],  # PARENTHESIZED LATIN CAPITAL LETTER M
    0x1F11D: ["<compat>", 0x0028, 0x004E, 0x0029],  # PARENTHESIZED LATIN CAPITAL LETTER N
    0x1F11E: ["<compat>", 0x0028, 0x004F, 0x0029],  # PARENTHESIZED LATIN CAPITAL LETTER O
    0x1F11F: ["<compat>", 0x0028, 0x0050, 0x0029],  # PARENTHESIZED LATIN CAPITAL LETTER P
    0x1F120: ["<compat>", 0x0028, 0x0051, 0x0029],  # PARENTHESIZED LATIN CAPITAL LETTER Q
    0x1F121: ["<compat>", 0x0028, 0x0052, 0x0029],  # PARENTHESIZED LATIN CAPITAL LETTER R
    0x1F122: ["<compat>", 0x0028, 0x0053, 0x0029],  # PARENTHESIZED LATIN CAPITAL LETTER S
    0x1F123: ["<compat>", 0x0028, 0x0054, 0x0029],  # PARENTHESIZED LATIN CAPITAL LETTER T
    0x1F124: ["<compat>", 0x0028, 0x0055, 0x0029],  # PARENTHESIZED LATIN CAPITAL LETTER U
    0x1F125: ["<compat>", 0x0028, 0x0056, 0x0029],  # PARENTHESIZED LATIN CAPITAL LETTER V
    0x1F126: ["<compat>", 0x0028, 0x0057, 0x0029],  # PARENTHESIZED LATIN CAPITAL LETTER W
    0x1F127: ["<compat>", 0x0028, 0x0058, 0x0029],  # PARENTHESIZED LATIN CAPITAL LETTER X
    0x1F128: ["<compat>", 0x0028, 0x0059, 0x0029],  # PARENTHESIZED LATIN CAPITAL LETTER Y
    0x1F129: ["<compat>", 0x0028, 0x005A, 0x0029],  # PARENTHESIZED LATIN CAPITAL LETTER Z
    0x1F12A: ["<compat>", 0x3014, 0x0053, 0x3015],  # TORTOISE SHELL BRACKETED LATIN CAPITAL LETTER S
    0x1F12B: ["<circle>", 0x0043],  # CIRCLED ITALIC LATIN CAPITAL LETTER C
    0x1F12C: ["<circle>", 0x0052],  # CIRCLED ITALIC LATIN CAPITAL LETTER R
    0x1F12D: ["<circle>", 0x0043, 0x0044],  # CIRCLED CD
    0x1F12E: ["<circle>", 0x0057, 0x005A],  # CIRCLED WZ
    0x1F130: ["<square>", 0x0041],  # SQUARED LATIN CAPITAL LETTER A
    0x1F131: ["<square>", 0x0042],  # SQUARED LATIN CAPITAL LETTER B
    0x1F132: ["<square>", 0x0043],  # SQUARED LATIN CAPITAL LETTER C
    0x1F133: ["<square>", 0x0044],  # SQUARED LATIN CAPITAL LETTER D
    0x1F134: ["<square>", 0x0045],  # SQUARED LATIN CAPITAL LETTER E
    0x1F135: ["<square>", 0x0046],  # SQUARED LATIN CAPITAL LETTER F
    0x1F136: ["<square>", 0x0047],  # SQUARED LATIN CAPITAL LETTER G
    0x1F137: ["<square>", 0x0048],  # SQUARED LATIN CAPITAL LETTER H
    0x1F138: ["<square>", 0x0049],  # SQUARED LATIN CAPITAL LETTER I
    0x1F139: ["<square>", 0x004A],  # SQUARED LATIN CAPITAL LETTER J
    0x1F13A: ["<square>", 0x004B],  # SQUARED LATIN CAPITAL LETTER K
    0x1F13B: ["<square>", 0x004C],  # SQUARED LATIN CAPITAL LETTER L
    0x1F13C: ["<square>", 0x004D],  # SQUARED LATIN CAPITAL LETTER M
    0x1F13D: ["<square>", 0x004E],  # SQUARED LATIN CAPITAL LETTER N
    0x1F13E: ["<square>", 0x004F],  # SQUARED LATIN CAPITAL LETTER O
    0x1F13F: ["<square>", 0x0050],  # SQUARED LATIN CAPITAL LETTER P
    0x1F140: ["<square>", 0x0051],  # SQUARED LATIN CAPITAL LETTER Q
    0x1F141: ["<square>", 0x0052],  # SQUARED LATIN CAPITAL LETTER R
    0x1F142: ["<square>", 0x0053],  # SQUARED LATIN CAPITAL LETTER S
    0x1F143: ["<square>", 0x0054],  # SQUARED LATIN CAPITAL LETTER T
    0x1F144: ["<square>", 0x0055],  # SQUARED LATIN CAPITAL LETTER U
    0x1F145: ["<square>", 0x0056],  # SQUARED LATIN CAPITAL LETTER V
    0x1F146: ["<square>", 0x0057],  # SQUARED LATIN CAPITAL LETTER W
    0x1F147: ["<square>", 0x0058],  # SQUARED LATIN CAPITAL LETTER X
    0x1F148: ["<square>", 0x0059],  # SQUARED LATIN CAPITAL LETTER Y
    0x1F149: ["<square>", 0x005A],  # SQUARED LATIN CAPITAL LETTER Z
    0x1F14A: ["<square>", 0x0048, 0x0056],  # SQUARED HV
    0x1F14B: ["<square>", 0x004D, 0x0056],  # SQUARED MV
    0x1F14C: ["<square>", 0x0053, 0x0044],  # SQUARED SD
    0x1F14D: ["<square>", 0x0053, 0x0053],  # SQUARED SS
    0x1F14E: ["<square>", 0x0050, 0x0050, 0x0056],  # SQUARED PPV
    0x1F14F: ["<square>", 0x0057, 0x0043],  # SQUARED WC
    0x1F16A: ["<super>", 0x004D, 0x0043],  # RAISED MC SIGN
    0x1F16B: ["<super>", 0x004D, 0x0044],  # RAISED MD SIGN
    0x1F16C: ["<super>", 0x004D, 0x0052],  # RAISED MR SIGN
    0x1F190: ["<square>", 0x0044, 0x004A],  # SQUARE DJ
    0x1F200: ["<square>", 0x307B, 0x304B],  # SQUARE HIRAGANA HOKA
    0x1F201: ["<square>", 0x30B3, 0x30B3],  # SQUARED KATAKANA KOKO
    0x1F202: ["<square>", 0x30B5],  # SQUARED KATAKANA SA
    0x1F210: ["<square>", 0x624B],  # SQUARED CJK UNIFIED IDEOGRAPH-624B
    0x1F211: ["<square>", 0x5B57],  # SQUARED CJK UNIFIED IDEOGRAPH-5B57
    0x1F212: ["<square>", 0x53CC],  # SQUARED CJK UNIFIED IDEOGRAPH-53CC
    0x1F213: ["<square>", 0x30C7],  # SQUARED KATAKANA DE
    0x1F214: ["<square>", 0x4E8C],  # SQUARED CJK UNIFIED IDEOGRAPH-4E8C
    0x1F215: ["<square>", 0x591A],  # SQUARED CJK UNIFIED IDEOGRAPH-591A
    0x1F216: ["<square>", 0x89E3],  # SQUARED CJK UNIFIED IDEOGRAPH-89E3
    0x1F217: ["<square>", 0x5929],  # SQUARED CJK UNIFIED IDEOGRAPH-5929
    0x1F218: ["<square>", 0x4EA4],  # SQUARED CJK UNIFIED IDEOGRAPH-4EA4
    0x1F219: ["<square>", 0x6620],  # SQUARED CJK UNIFIED IDEOGRAPH-6620
    0x1F21A: ["<square>", 0x7121],  # SQUARED CJK UNIFIED IDEOGRAPH-7121
    0x1F21B: ["<square>", 0x6599],  # SQUARED CJK UNIFIED IDEOGRAPH-6599
    0x1F21C: ["<square>", 0x524D],  # SQUARED CJK UNIFIED IDEOGRAPH-524D
    0x1F21D: ["<square>", 0x5F8C],  # SQUARED CJK UNIFIED IDEOGRAPH-5F8C
    0x1F21E: ["<square>", 0x518D],  # SQUARED CJK UNIFIED IDEOGRAPH-518D
    0x1F21F: ["<square>", 0x65B0],  # SQUARED CJK UNIFIED IDEOGRAPH-65B0
    0x1F220: ["<square>", 0x521D],  # SQUARED CJK UNIFIED IDEOGRAPH-521D
    0x1F221: ["<square>", 0x7D42],  # SQUARED CJK UNIFIED IDEOGRAPH-7D42
    0x1F222: ["<square>", 0x751F],  # SQUARED CJK UNIFIED IDEOGRAPH-751F
    0x1F223: ["<square>", 0x8CA9],  # SQUARED CJK UNIFIED IDEOGRAPH-8CA9
    0x1F224: ["<square>", 0x58F0],  # SQUARED CJK UNIFIED IDEOGRAPH-58F0
    0x1F225: ["<square>", 0x5439],  # SQUARED CJK UNIFIED IDEOGRAPH-5439
    0x1F226: ["<square>", 0x6F14],  # SQUARED CJK UNIFIED IDEOGRAPH-6F14
    0x1F227: ["<square>", 0x6295],  # SQUARED CJK UNIFIED IDEOGRAPH-6295
    0x1F228: ["<square>", 0x6355],  # SQUARED CJK UNIFIED IDEOGRAPH-6355
    0x1F229: ["<square>", 0x4E00],  # SQUARED CJK UNIFIED IDEOGRAPH-4E00
    0x1F22A: ["<square>", 0x4E09],  # SQUARED CJK UNIFIED IDEOGRAPH-4E09
    0x1F22B: ["<square>", 0x904A],  # SQUARED CJK UNIFIED IDEOGRAPH-904A
    0x1F22C: ["<square>", 0x5DE6],  # SQUARED CJK UNIFIED IDEOGRAPH-5DE6
    0x1F22D: ["<square>", 0x4E2D],  # SQUARED CJK UNIFIED IDEOGRAPH-4E2D
    0x1F22E: ["<square>", 0x53F3],  # SQUARED CJK UNIFIED IDEOGRAPH-53F3
    0x1F22F: ["<square>", 0x6307],  # SQUARED CJK UNIFIED IDEOGRAPH-6307
    0x1F230: ["<square>", 0x8D70],  # SQUARED CJK UNIFIED IDEOGRAPH-8D70
    0x1F231: ["<square>", 0x6253],  # SQUARED CJK UNIFIED IDEOGRAPH-6253
    0x1F232: ["<square>", 0x7981],  # SQUARED CJK UNIFIED IDEOGRAPH-7981
    0x1F233: ["<square>", 0x7A7A],  # SQUARED CJK UNIFIED IDEOGRAPH-7A7A
    0x1F234: ["<square>", 0x5408],  # SQUARED CJK UNIFIED IDEOGRAPH-5408
    0x1F235: ["<square>", 0x6E80],  # SQUARED CJK UNIFIED IDEOGRAPH-6E80
    0x1F236: ["<square>", 0x6709],  # SQUARED CJK UNIFIED IDEOGRAPH-6709
    0x1F237: ["<square>", 0x6708],  # SQUARED CJK UNIFIED IDEOGRAPH-6708
    0x1F238: ["<square>", 0x7533],  # SQUARED CJK UNIFIED IDEOGRAPH-7533
    0x1F239: ["<square>", 0x5272],  # SQUARED CJK UNIFIED IDEOGRAPH-5272
    0x1F23A: ["<square>", 0x55B6],  # SQUARED CJK UNIFIED IDEOGRAPH-55B6
    0x1F23B: ["<square>", 0x914D],  # SQUARED CJK UNIFIED IDEOGRAPH-914D
    0x1F240: ["<compat>", 0x3014, 0x672C, 0x3015],  # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-672C
    0x1F241: ["<compat>", 0x3014, 0x4E09, 0x3015],  # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-4E09
    0x1F242: ["<compat>", 0x3014, 0x4E8C, 0x3015],  # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-4E8C
    0x1F243: ["<compat>", 0x3014, 0x5B89, 0x3015],  # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-5B89
    0x1F244: ["<compat>", 0x3014, 0x70B9, 0x3015],  # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-70B9
    0x1F245: ["<compat>", 0x3014, 0x6253, 0x3015],  # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-6253
    0x1F246: ["<compat>", 0x3014, 0x76D7, 0x3015],  # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-76D7
    0x1F247: ["<compat>", 0x3014, 0x52DD, 0x3015],  # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-52DD
    0x1F248: ["<compat>", 0x3014, 0x6557, 0x3015],  # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-6557
    0x1F250: ["<circle>", 0x5F97],  # CIRCLED IDEOGRAPH ADVANTAGE
    0x1F251: ["<circle>", 0x53EF],  # CIRCLED IDEOGRAPH ACCEPT
    0x1FBF0: ["<font>", 0x0030],  # SEGMENTED DIGIT ZERO
    0x1FBF1: ["<font>", 0x0031],  # SEGMENTED DIGIT ONE
    0x1FBF2: ["<font>", 0x0032],  # SEGMENTED DIGIT TWO
    0x1FBF3: ["<font>", 0x0033],  # SEGMENTED DIGIT THREE
    0x1FBF4: ["<font>", 0x0034],  # SEGMENTED DIGIT FOUR
    0x1FBF5: ["<font>", 0x0035],  # SEGMENTED DIGIT FIVE
    0x1FBF6: ["<font>", 0x0036],  # SEGMENTED DIGIT SIX
    0x1FBF7: ["<font>", 0x0037],  # SEGMENTED DIGIT SEVEN
    0x1FBF8: ["<font>", 0x0038],  # SEGMENTED DIGIT EIGHT
    0x1FBF9: ["<font>", 0x0039],  # SEGMENTED DIGIT NINE
    0x2F800: [0x4E3D],  # CJK COMPATIBILITY IDEOGRAPH-2F800
    0x2F801: [0x4E38],  # CJK COMPATIBILITY IDEOGRAPH-2F801
    0x2F802: [0x4E41],  # CJK COMPATIBILITY IDEOGRAPH-2F802
    0x2F803: [0x20122],  # CJK COMPATIBILITY IDEOGRAPH-2F803
    0x2F804: [0x4F60],  # CJK COMPATIBILITY IDEOGRAPH-2F804
    0x2F805: [0x4FAE],  # CJK COMPATIBILITY IDEOGRAPH-2F805
    0x2F806: [0x4FBB],  # CJK COMPATIBILITY IDEOGRAPH-2F806
    0x2F807: [0x5002],  # CJK COMPATIBILITY IDEOGRAPH-2F807
    0x2F808: [0x507A],  # CJK COMPATIBILITY IDEOGRAPH-2F808
    0x2F809: [0x5099],  # CJK COMPATIBILITY IDEOGRAPH-2F809
    0x2F80A: [0x50E7],  # CJK COMPATIBILITY IDEOGRAPH-2F80A
    0x2F80B: [0x50CF],  # CJK COMPATIBILITY IDEOGRAPH-2F80B
    0x2F80C: [0x349E],  # CJK COMPATIBILITY IDEOGRAPH-2F80C
    0x2F80D: [0x2063A],  # CJK COMPATIBILITY IDEOGRAPH-2F80D
    0x2F80E: [0x514D],  # CJK COMPATIBILITY IDEOGRAPH-2F80E
    0x2F80F: [0x5154],  # CJK COMPATIBILITY IDEOGRAPH-2F80F
    0x2F810: [0x5164],  # CJK COMPATIBILITY IDEOGRAPH-2F810
    0x2F811: [0x5177],  # CJK COMPATIBILITY IDEOGRAPH-2F811
    0x2F812: [0x2051C],  # CJK COMPATIBILITY IDEOGRAPH-2F812
    0x2F813: [0x34B9],  # CJK COMPATIBILITY IDEOGRAPH-2F813
    0x2F814: [0x5167],  # CJK COMPATIBILITY IDEOGRAPH-2F814
    0x2F815: [0x518D],  # CJK COMPATIBILITY IDEOGRAPH-2F815
    0x2F816: [0x2054B],  # CJK COMPATIBILITY IDEOGRAPH-2F816
    0x2F817: [0x5197],  # CJK COMPATIBILITY IDEOGRAPH-2F817
    0x2F818: [0x51A4],  # CJK COMPATIBILITY IDEOGRAPH-2F818
    0x2F819: [0x4ECC],  # CJK COMPATIBILITY IDEOGRAPH-2F819
    0x2F81A: [0x51AC],  # CJK COMPATIBILITY IDEOGRAPH-2F81A
    0x2F81B: [0x51B5],  # CJK COMPATIBILITY IDEOGRAPH-2F81B
    0x2F81C: [0x291DF],  # CJK COMPATIBILITY IDEOGRAPH-2F81C
    0x2F81D: [0x51F5],  # CJK COMPATIBILITY IDEOGRAPH-2F81D
    0x2F81E: [0x5203],  # CJK COMPATIBILITY IDEOGRAPH-2F81E
    0x2F81F: [0x34DF],  # CJK COMPATIBILITY IDEOGRAPH-2F81F
    0x2F820: [0x523B],  # CJK COMPATIBILITY IDEOGRAPH-2F820
    0x2F821: [0x5246],  # CJK COMPATIBILITY IDEOGRAPH-2F821
    0x2F822: [0x5272],  # CJK COMPATIBILITY IDEOGRAPH-2F822
    0x2F823: [0x5277],  # CJK COMPATIBILITY IDEOGRAPH-2F823
    0x2F824: [0x3515],  # CJK COMPATIBILITY IDEOGRAPH-2F824
    0x2F825: [0x52C7],  # CJK COMPATIBILITY IDEOGRAPH-2F825
    0x2F826: [0x52C9],  # CJK COMPATIBILITY IDEOGRAPH-2F826
    0x2F827: [0x52E4],  # CJK COMPATIBILITY IDEOGRAPH-2F827
    0x2F828: [0x52FA],  # CJK COMPATIBILITY IDEOGRAPH-2F828
    0x2F829: [0x5305],  # CJK COMPATIBILITY IDEOGRAPH-2F829
    0x2F82A: [0x5306],  # CJK COMPATIBILITY IDEOGRAPH-2F82A
    0x2F82B: [0x5317],  # CJK COMPATIBILITY IDEOGRAPH-2F82B
    0x2F82C: [0x5349],  # CJK COMPATIBILITY IDEOGRAPH-2F82C
    0x2F82D: [0x5351],  # CJK COMPATIBILITY IDEOGRAPH-2F82D
    0x2F82E: [0x535A],  # CJK COMPATIBILITY IDEOGRAPH-2F82E
    0x2F82F: [0x5373],  # CJK COMPATIBILITY IDEOGRAPH-2F82F
    0x2F830: [0x537D],  # CJK COMPATIBILITY IDEOGRAPH-2F830
    0x2F831: [0x537F],  # CJK COMPATIBILITY IDEOGRAPH-2F831
    0x2F832: [0x537F],  # CJK COMPATIBILITY IDEOGRAPH-2F832
    0x2F833: [0x537F],  # CJK COMPATIBILITY IDEOGRAPH-2F833
    0x2F834: [0x20A2C],  # CJK COMPATIBILITY IDEOGRAPH-2F834
    0x2F835: [0x7070],  # CJK COMPATIBILITY IDEOGRAPH-2F835
    0x2F836: [0x53CA],  # CJK COMPATIBILITY IDEOGRAPH-2F836
    0x2F837: [0x53DF],  # CJK COMPATIBILITY IDEOGRAPH-2F837
    0x2F838: [0x20B63],  # CJK COMPATIBILITY IDEOGRAPH-2F838
    0x2F839: [0x53EB],  # CJK COMPATIBILITY IDEOGRAPH-2F839
    0x2F83A: [0x53F1],  # CJK COMPATIBILITY IDEOGRAPH-2F83A
    0x2F83B: [0x5406],  # CJK COMPATIBILITY IDEOGRAPH-2F83B
    0x2F83C: [0x549E],  # CJK COMPATIBILITY IDEOGRAPH-2F83C
    0x2F83D: [0x5438],  # CJK COMPATIBILITY IDEOGRAPH-2F83D
    0x2F83E: [0x5448],  # CJK COMPATIBILITY IDEOGRAPH-2F83E
    0x2F83F: [0x5468],  # CJK COMPATIBILITY IDEOGRAPH-2F83F
    0x2F840: [0x54A2],  # CJK COMPATIBILITY IDEOGRAPH-2F840
    0x2F841: [0x54F6],  # CJK COMPATIBILITY IDEOGRAPH-2F841
    0x2F842: [0x5510],  # CJK COMPATIBILITY IDEOGRAPH-2F842
    0x2F843: [0x5553],  # CJK COMPATIBILITY IDEOGRAPH-2F843
    0x2F844: [0x5563],  # CJK COMPATIBILITY IDEOGRAPH-2F844
    0x2F845: [0x5584],  # CJK COMPATIBILITY IDEOGRAPH-2F845
    0x2F846: [0x5584],  # CJK COMPATIBILITY IDEOGRAPH-2F846
    0x2F847: [0x5599],  # CJK COMPATIBILITY IDEOGRAPH-2F847
    0x2F848: [0x55AB],  # CJK COMPATIBILITY IDEOGRAPH-2F848
    0x2F849: [0x55B3],  # CJK COMPATIBILITY IDEOGRAPH-2F849
    0x2F84A: [0x55C2],  # CJK COMPATIBILITY IDEOGRAPH-2F84A
    0x2F84B: [0x5716],  # CJK COMPATIBILITY IDEOGRAPH-2F84B
    0x2F84C: [0x5606],  # CJK COMPATIBILITY IDEOGRAPH-2F84C
    0x2F84D: [0x5717],  # CJK COMPATIBILITY IDEOGRAPH-2F84D
    0x2F84E: [0x5651],  # CJK COMPATIBILITY IDEOGRAPH-2F84E
    0x2F84F: [0x5674],  # CJK COMPATIBILITY IDEOGRAPH-2F84F
    0x2F850: [0x5207],  # CJK COMPATIBILITY IDEOGRAPH-2F850
    0x2F851: [0x58EE],  # CJK COMPATIBILITY IDEOGRAPH-2F851
    0x2F852: [0x57CE],  # CJK COMPATIBILITY IDEOGRAPH-2F852
    0x2F853: [0x57F4],  # CJK COMPATIBILITY IDEOGRAPH-2F853
    0x2F854: [0x580D],  # CJK COMPATIBILITY IDEOGRAPH-2F854
    0x2F855: [0x578B],  # CJK COMPATIBILITY IDEOGRAPH-2F855
    0x2F856: [0x5832],  # CJK COMPATIBILITY IDEOGRAPH-2F856
    0x2F857: [0x5831],  # CJK COMPATIBILITY IDEOGRAPH-2F857
    0x2F858: [0x58AC],  # CJK COMPATIBILITY IDEOGRAPH-2F858
    0x2F859: [0x214E4],  # CJK COMPATIBILITY IDEOGRAPH-2F859
    0x2F85A: [0x58F2],  # CJK COMPATIBILITY IDEOGRAPH-2F85A
    0x2F85B: [0x58F7],  # CJK COMPATIBILITY IDEOGRAPH-2F85B
    0x2F85C: [0x5906],  # CJK COMPATIBILITY IDEOGRAPH-2F85C
    0x2F85D: [0x591A],  # CJK COMPATIBILITY IDEOGRAPH-2F85D
    0x2F85E: [0x5922],  # CJK COMPATIBILITY IDEOGRAPH-2F85E
    0x2F85F: [0x5962],  # CJK COMPATIBILITY IDEOGRAPH-2F85F
    0x2F860: [0x216A8],  # CJK COMPATIBILITY IDEOGRAPH-2F860
    0x2F861: [0x216EA],  # CJK COMPATIBILITY IDEOGRAPH-2F861
    0x2F862: [0x59EC],  # CJK COMPATIBILITY IDEOGRAPH-2F862
    0x2F863: [0x5A1B],  # CJK COMPATIBILITY IDEOGRAPH-2F863
    0x2F864: [0x5A27],  # CJK COMPATIBILITY IDEOGRAPH-2F864
    0x2F865: [0x59D8],  # CJK COMPATIBILITY IDEOGRAPH-2F865
    0x2F866: [0x5A66],  # CJK COMPATIBILITY IDEOGRAPH-2F866
    0x2F867: [0x36EE],  # CJK COMPATIBILITY IDEOGRAPH-2F867
    0x2F868: [0x36FC],  # CJK COMPATIBILITY IDEOGRAPH-2F868
    0x2F869: [0x5B08],  # CJK COMPATIBILITY IDEOGRAPH-2F869
    0x2F86A: [0x5B3E],  # CJK COMPATIBILITY IDEOGRAPH-2F86A
    0x2F86B: [0x5B3E],  # CJK COMPATIBILITY IDEOGRAPH-2F86B
    0x2F86C: [0x219C8],  # CJK COMPATIBILITY IDEOGRAPH-2F86C
    0x2F86D: [0x5BC3],  # CJK COMPATIBILITY IDEOGRAPH-2F86D
    0x2F86E: [0x5BD8],  # CJK COMPATIBILITY IDEOGRAPH-2F86E
    0x2F86F: [0x5BE7],  # CJK COMPATIBILITY IDEOGRAPH-2F86F
    0x2F870: [0x5BF3],  # CJK COMPATIBILITY IDEOGRAPH-2F870
    0x2F871: [0x21B18],  # CJK COMPATIBILITY IDEOGRAPH-2F871
    0x2F872: [0x5BFF],  # CJK COMPATIBILITY IDEOGRAPH-2F872
    0x2F873: [0x5C06],  # CJK COMPATIBILITY IDEOGRAPH-2F873
    0x2F874: [0x5F53],  # CJK COMPATIBILITY IDEOGRAPH-2F874
    0x2F875: [0x5C22],  # CJK COMPATIBILITY IDEOGRAPH-2F875
    0x2F876: [0x3781],  # CJK COMPATIBILITY IDEOGRAPH-2F876
    0x2F877: [0x5C60],  # CJK COMPATIBILITY IDEOGRAPH-2F877
    0x2F878: [0x5C6E],  # CJK COMPATIBILITY IDEOGRAPH-2F878
    0x2F879: [0x5CC0],  # CJK COMPATIBILITY IDEOGRAPH-2F879
    0x2F87A: [0x5C8D],  # CJK COMPATIBILITY IDEOGRAPH-2F87A
    0x2F87B: [0x21DE4],  # CJK COMPATIBILITY IDEOGRAPH-2F87B
    0x2F87C: [0x5D43],  # CJK COMPATIBILITY IDEOGRAPH-2F87C
    0x2F87D: [0x21DE6],  # CJK COMPATIBILITY IDEOGRAPH-2F87D
    0x2F87E: [0x5D6E],  # CJK COMPATIBILITY IDEOGRAPH-2F87E
    0x2F87F: [0x5D6B],  # CJK COMPATIBILITY IDEOGRAPH-2F87F
    0x2F880: [0x5D7C],  # CJK COMPATIBILITY IDEOGRAPH-2F880
    0x2F881: [0x5DE1],  # CJK COMPATIBILITY IDEOGRAPH-2F881
    0x2F882: [0x5DE2],  # CJK COMPATIBILITY IDEOGRAPH-2F882
    0x2F883: [0x382F],  # CJK COMPATIBILITY IDEOGRAPH-2F883
    0x2F884: [0x5DFD],  # CJK COMPATIBILITY IDEOGRAPH-2F884
    0x2F885: [0x5E28],  # CJK COMPATIBILITY IDEOGRAPH-2F885
    0x2F886: [0x5E3D],  # CJK COMPATIBILITY IDEOGRAPH-2F886
    0x2F887: [0x5E69],  # CJK COMPATIBILITY IDEOGRAPH-2F887
    0x2F888: [0x3862],  # CJK COMPATIBILITY IDEOGRAPH-2F888
    0x2F889: [0x22183],  # CJK COMPATIBILITY IDEOGRAPH-2F889
    0x2F88A: [0x387C],  # CJK COMPATIBILITY IDEOGRAPH-2F88A
    0x2F88B: [0x5EB0],  # CJK COMPATIBILITY IDEOGRAPH-2F88B
    0x2F88C: [0x5EB3],  # CJK COMPATIBILITY IDEOGRAPH-2F88C
    0x2F88D: [0x5EB6],  # CJK COMPATIBILITY IDEOGRAPH-2F88D
    0x2F88E: [0x5ECA],  # CJK COMPATIBILITY IDEOGRAPH-2F88E
    0x2F88F: [0x2A392],  # CJK COMPATIBILITY IDEOGRAPH-2F88F
    0x2F890: [0x5EFE],  # CJK COMPATIBILITY IDEOGRAPH-2F890
    0x2F891: [0x22331],  # CJK COMPATIBILITY IDEOGRAPH-2F891
    0x2F892: [0x22331],  # CJK COMPATIBILITY IDEOGRAPH-2F892
    0x2F893: [0x8201],  # CJK COMPATIBILITY IDEOGRAPH-2F893
    0x2F894: [0x5F22],  # CJK COMPATIBILITY IDEOGRAPH-2F894
    0x2F895: [0x5F22],  # CJK COMPATIBILITY IDEOGRAPH-2F895
    0x2F896: [0x38C7],  # CJK COMPATIBILITY IDEOGRAPH-2F896
    0x2F897: [0x232B8],  # CJK COMPATIBILITY IDEOGRAPH-2F897
    0x2F898: [0x261DA],  # CJK COMPATIBILITY IDEOGRAPH-2F898
    0x2F899: [0x5F62],  # CJK COMPATIBILITY IDEOGRAPH-2F899
    0x2F89A: [0x5F6B],  # CJK COMPATIBILITY IDEOGRAPH-2F89A
    0x2F89B: [0x38E3],  # CJK COMPATIBILITY IDEOGRAPH-2F89B
    0x2F89C: [0x5F9A],  # CJK COMPATIBILITY IDEOGRAPH-2F89C
    0x2F89D: [0x5FCD],  # CJK COMPATIBILITY IDEOGRAPH-2F89D
    0x2F89E: [0x5FD7],  # CJK COMPATIBILITY IDEOGRAPH-2F89E
    0x2F89F: [0x5FF9],  # CJK COMPATIBILITY IDEOGRAPH-2F89F
    0x2F8A0: [0x6081],  # CJK COMPATIBILITY IDEOGRAPH-2F8A0
    0x2F8A1: [0x393A],  # CJK COMPATIBILITY IDEOGRAPH-2F8A1
    0x2F8A2: [0x391C],  # CJK COMPATIBILITY IDEOGRAPH-2F8A2
    0x2F8A3: [0x6094],  # CJK COMPATIBILITY IDEOGRAPH-2F8A3
    0x2F8A4: [0x226D4],  # CJK COMPATIBILITY IDEOGRAPH-2F8A4
    0x2F8A5: [0x60C7],  # CJK COMPATIBILITY IDEOGRAPH-2F8A5
    0x2F8A6: [0x6148],  # CJK COMPATIBILITY IDEOGRAPH-2F8A6
    0x2F8A7: [0x614C],  # CJK COMPATIBILITY IDEOGRAPH-2F8A7
    0x2F8A8: [0x614E],  # CJK COMPATIBILITY IDEOGRAPH-2F8A8
    0x2F8A9: [0x614C],  # CJK COMPATIBILITY IDEOGRAPH-2F8A9
    0x2F8AA: [0x617A],  # CJK COMPATIBILITY IDEOGRAPH-2F8AA
    0x2F8AB: [0x618E],  # CJK COMPATIBILITY IDEOGRAPH-2F8AB
    0x2F8AC: [0x61B2],  # CJK COMPATIBILITY IDEOGRAPH-2F8AC
    0x2F8AD: [0x61A4],  # CJK COMPATIBILITY IDEOGRAPH-2F8AD
    0x2F8AE: [0x61AF],  # CJK COMPATIBILITY IDEOGRAPH-2F8AE
    0x2F8AF: [0x61DE],  # CJK COMPATIBILITY IDEOGRAPH-2F8AF
    0x2F8B0: [0x61F2],  # CJK COMPATIBILITY IDEOGRAPH-2F8B0
    0x2F8B1: [0x61F6],  # CJK COMPATIBILITY IDEOGRAPH-2F8B1
    0x2F8B2: [0x6210],  # CJK COMPATIBILITY IDEOGRAPH-2F8B2
    0x2F8B3: [0x621B],  # CJK COMPATIBILITY IDEOGRAPH-2F8B3
    0x2F8B4: [0x625D],  # CJK COMPATIBILITY IDEOGRAPH-2F8B4
    0x2F8B5: [0x62B1],  # CJK COMPATIBILITY IDEOGRAPH-2F8B5
    0x2F8B6: [0x62D4],  # CJK COMPATIBILITY IDEOGRAPH-2F8B6
    0x2F8B7: [0x6350],  # CJK COMPATIBILITY IDEOGRAPH-2F8B7
    0x2F8B8: [0x22B0C],  # CJK COMPATIBILITY IDEOGRAPH-2F8B8
    0x2F8B9: [0x633D],  # CJK COMPATIBILITY IDEOGRAPH-2F8B9
    0x2F8BA: [0x62FC],  # CJK COMPATIBILITY IDEOGRAPH-2F8BA
    0x2F8BB: [0x6368],  # CJK COMPATIBILITY IDEOGRAPH-2F8BB
    0x2F8BC: [0x6383],  # CJK COMPATIBILITY IDEOGRAPH-2F8BC
    0x2F8BD: [0x63E4],  # CJK COMPATIBILITY IDEOGRAPH-2F8BD
    0x2F8BE: [0x22BF1],  # CJK COMPATIBILITY IDEOGRAPH-2F8BE
    0x2F8BF: [0x6422],  # CJK COMPATIBILITY IDEOGRAPH-2F8BF
    0x2F8C0: [0x63C5],  # CJK COMPATIBILITY IDEOGRAPH-2F8C0
    0x2F8C1: [0x63A9],  # CJK COMPATIBILITY IDEOGRAPH-2F8C1
    0x2F8C2: [0x3A2E],  # CJK COMPATIBILITY IDEOGRAPH-2F8C2
    0x2F8C3: [0x6469],  # CJK COMPATIBILITY IDEOGRAPH-2F8C3
    0x2F8C4: [0x647E],  # CJK COMPATIBILITY IDEOGRAPH-2F8C4
    0x2F8C5: [0x649D],  # CJK COMPATIBILITY IDEOGRAPH-2F8C5
    0x2F8C6: [0x6477],  # CJK COMPATIBILITY IDEOGRAPH-2F8C6
    0x2F8C7: [0x3A6C],  # CJK COMPATIBILITY IDEOGRAPH-2F8C7
    0x2F8C8: [0x654F],  # CJK COMPATIBILITY IDEOGRAPH-2F8C8
    0x2F8C9: [0x656C],  # CJK COMPATIBILITY IDEOGRAPH-2F8C9
    0x2F8CA: [0x2300A],  # CJK COMPATIBILITY IDEOGRAPH-2F8CA
    0x2F8CB: [0x65E3],  # CJK COMPATIBILITY IDEOGRAPH-2F8CB
    0x2F8CC: [0x66F8],  # CJK COMPATIBILITY IDEOGRAPH-2F8CC
    0x2F8CD: [0x6649],  # CJK COMPATIBILITY IDEOGRAPH-2F8CD
    0x2F8CE: [0x3B19],  # CJK COMPATIBILITY IDEOGRAPH-2F8CE
    0x2F8CF: [0x6691],  # CJK COMPATIBILITY IDEOGRAPH-2F8CF
    0x2F8D0: [0x3B08],  # CJK COMPATIBILITY IDEOGRAPH-2F8D0
    0x2F8D1: [0x3AE4],  # CJK COMPATIBILITY IDEOGRAPH-2F8D1
    0x2F8D2: [0x5192],  # CJK COMPATIBILITY IDEOGRAPH-2F8D2
    0x2F8D3: [0x5195],  # CJK COMPATIBILITY IDEOGRAPH-2F8D3
    0x2F8D4: [0x6700],  # CJK COMPATIBILITY IDEOGRAPH-2F8D4
    0x2F8D5: [0x669C],  # CJK COMPATIBILITY IDEOGRAPH-2F8D5
    0x2F8D6: [0x80AD],  # CJK COMPATIBILITY IDEOGRAPH-2F8D6
    0x2F8D7: [0x43D9],  # CJK COMPATIBILITY IDEOGRAPH-2F8D7
    0x2F8D8: [0x6717],  # CJK COMPATIBILITY IDEOGRAPH-2F8D8
    0x2F8D9: [0x671B],  # CJK COMPATIBILITY IDEOGRAPH-2F8D9
    0x2F8DA: [0x6721],  # CJK COMPATIBILITY IDEOGRAPH-2F8DA
    0x2F8DB: [0x675E],  # CJK COMPATIBILITY IDEOGRAPH-2F8DB
    0x2F8DC: [0x6753],  # CJK COMPATIBILITY IDEOGRAPH-2F8DC
    0x2F8DD: [0x233C3],  # CJK COMPATIBILITY IDEOGRAPH-2F8DD
    0x2F8DE: [0x3B49],  # CJK COMPATIBILITY IDEOGRAPH-2F8DE
    0x2F8DF: [0x67FA],  # CJK COMPATIBILITY IDEOGRAPH-2F8DF
    0x2F8E0: [0x6785],  # CJK COMPATIBILITY IDEOGRAPH-2F8E0
    0x2F8E1: [0x6852],  # CJK COMPATIBILITY IDEOGRAPH-2F8E1
    0x2F8E2: [0x6885],  # CJK COMPATIBILITY IDEOGRAPH-2F8E2
    0x2F8E3: [0x2346D],  # CJK COMPATIBILITY IDEOGRAPH-2F8E3
    0x2F8E4: [0x688E],  # CJK COMPATIBILITY IDEOGRAPH-2F8E4
    0x2F8E5: [0x681F],  # CJK COMPATIBILITY IDEOGRAPH-2F8E5
    0x2F8E6: [0x6914],  # CJK COMPATIBILITY IDEOGRAPH-2F8E6
    0x2F8E7: [0x3B9D],  # CJK COMPATIBILITY IDEOGRAPH-2F8E7
    0x2F8E8: [0x6942],  # CJK COMPATIBILITY IDEOGRAPH-2F8E8
    0x2F8E9: [0x69A3],  # CJK COMPATIBILITY IDEOGRAPH-2F8E9
    0x2F8EA: [0x69EA],  # CJK COMPATIBILITY IDEOGRAPH-2F8EA
    0x2F8EB: [0x6AA8],  # CJK COMPATIBILITY IDEOGRAPH-2F8EB
    0x2F8EC: [0x236A3],  # CJK COMPATIBILITY IDEOGRAPH-2F8EC
    0x2F8ED: [0x6ADB],  # CJK COMPATIBILITY IDEOGRAPH-2F8ED
    0x2F8EE: [0x3C18],  # CJK COMPATIBILITY IDEOGRAPH-2F8EE
    0x2F8EF: [0x6B21],  # CJK COMPATIBILITY IDEOGRAPH-2F8EF
    0x2F8F0: [0x238A7],  # CJK COMPATIBILITY IDEOGRAPH-2F8F0
    0x2F8F1: [0x6B54],  # CJK COMPATIBILITY IDEOGRAPH-2F8F1
    0x2F8F2: [0x3C4E],  # CJK COMPATIBILITY IDEOGRAPH-2F8F2
    0x2F8F3: [0x6B72],  # CJK COMPATIBILITY IDEOGRAPH-2F8F3
    0x2F8F4: [0x6B9F],  # CJK COMPATIBILITY IDEOGRAPH-2F8F4
    0x2F8F5: [0x6BBA],  # CJK COMPATIBILITY IDEOGRAPH-2F8F5
    0x2F8F6: [0x6BBB],  # CJK COMPATIBILITY IDEOGRAPH-2F8F6
    0x2F8F7: [0x23A8D],  # CJK COMPATIBILITY IDEOGRAPH-2F8F7
    0x2F8F8: [0x21D0B],  # CJK COMPATIBILITY IDEOGRAPH-2F8F8
    0x2F8F9: [0x23AFA],  # CJK COMPATIBILITY IDEOGRAPH-2F8F9
    0x2F8FA: [0x6C4E],  # CJK COMPATIBILITY IDEOGRAPH-2F8FA
    0x2F8FB: [0x23CBC],  # CJK COMPATIBILITY IDEOGRAPH-2F8FB
    0x2F8FC: [0x6CBF],  # CJK COMPATIBILITY IDEOGRAPH-2F8FC
    0x2F8FD: [0x6CCD],  # CJK COMPATIBILITY IDEOGRAPH-2F8FD
    0x2F8FE: [0x6C67],  # CJK COMPATIBILITY IDEOGRAPH-2F8FE
    0x2F8FF: [0x6D16],  # CJK COMPATIBILITY IDEOGRAPH-2F8FF
    0x2F900: [0x6D3E],  # CJK COMPATIBILITY IDEOGRAPH-2F900
    0x2F901: [0x6D77],  # CJK COMPATIBILITY IDEOGRAPH-2F901
    0x2F902: [0x6D41],  # CJK COMPATIBILITY IDEOGRAPH-2F902
    0x2F903: [0x6D69],  # CJK COMPATIBILITY IDEOGRAPH-2F903
    0x2F904: [0x6D78],  # CJK COMPATIBILITY IDEOGRAPH-2F904
    0x2F905: [0x6D85],  # CJK COMPATIBILITY IDEOGRAPH-2F905
    0x2F906: [0x23D1E],  # CJK COMPATIBILITY IDEOGRAPH-2F906
    0x2F907: [0x6D34],  # CJK COMPATIBILITY IDEOGRAPH-2F907
    0x2F908: [0x6E2F],  # CJK COMPATIBILITY IDEOGRAPH-2F908
    0x2F909: [0x6E6E],  # CJK COMPATIBILITY IDEOGRAPH-2F909
    0x2F90A: [0x3D33],  # CJK COMPATIBILITY IDEOGRAPH-2F90A
    0x2F90B: [0x6ECB],  # CJK COMPATIBILITY IDEOGRAPH-2F90B
    0x2F90C: [0x6EC7],  # CJK COMPATIBILITY IDEOGRAPH-2F90C
    0x2F90D: [0x23ED1],  # CJK COMPATIBILITY IDEOGRAPH-2F90D
    0x2F90E: [0x6DF9],  # CJK COMPATIBILITY IDEOGRAPH-2F90E
    0x2F90F: [0x6F6E],  # CJK COMPATIBILITY IDEOGRAPH-2F90F
    0x2F910: [0x23F5E],  # CJK COMPATIBILITY IDEOGRAPH-2F910
    0x2F911: [0x23F8E],  # CJK COMPATIBILITY IDEOGRAPH-2F911
    0x2F912: [0x6FC6],  # CJK COMPATIBILITY IDEOGRAPH-2F912
    0x2F913: [0x7039],  # CJK COMPATIBILITY IDEOGRAPH-2F913
    0x2F914: [0x701E],  # CJK COMPATIBILITY IDEOGRAPH-2F914
    0x2F915: [0x701B],  # CJK COMPATIBILITY IDEOGRAPH-2F915
    0x2F916: [0x3D96],  # CJK COMPATIBILITY IDEOGRAPH-2F916
    0x2F917: [0x704A],  # CJK COMPATIBILITY IDEOGRAPH-2F917
    0x2F918: [0x707D],  # CJK COMPATIBILITY IDEOGRAPH-2F918
    0x2F919: [0x7077],  # CJK COMPATIBILITY IDEOGRAPH-2F919
    0x2F91A: [0x70AD],  # CJK COMPATIBILITY IDEOGRAPH-2F91A
    0x2F91B: [0x20525],  # CJK COMPATIBILITY IDEOGRAPH-2F91B
    0x2F91C: [0x7145],  # CJK COMPATIBILITY IDEOGRAPH-2F91C
    0x2F91D: [0x24263],  # CJK COMPATIBILITY IDEOGRAPH-2F91D
    0x2F91E: [0x719C],  # CJK COMPATIBILITY IDEOGRAPH-2F91E
    0x2F91F: [0x243AB],  # CJK COMPATIBILITY IDEOGRAPH-2F91F
    0x2F920: [0x7228],  # CJK COMPATIBILITY IDEOGRAPH-2F920
    0x2F921: [0x7235],  # CJK COMPATIBILITY IDEOGRAPH-2F921
    0x2F922: [0x7250],  # CJK COMPATIBILITY IDEOGRAPH-2F922
    0x2F923: [0x24608],  # CJK COMPATIBILITY IDEOGRAPH-2F923
    0x2F924: [0x7280],  # CJK COMPATIBILITY IDEOGRAPH-2F924
    0x2F925: [0x7295],  # CJK COMPATIBILITY IDEOGRAPH-2F925
    0x2F926: [0x24735],  # CJK COMPATIBILITY IDEOGRAPH-2F926
    0x2F927: [0x24814],  # CJK COMPATIBILITY IDEOGRAPH-2F927
    0x2F928: [0x737A],  # CJK COMPATIBILITY IDEOGRAPH-2F928
    0x2F929: [0x738B],  # CJK COMPATIBILITY IDEOGRAPH-2F929
    0x2F92A: [0x3EAC],  # CJK COMPATIBILITY IDEOGRAPH-2F92A
    0x2F92B: [0x73A5],  # CJK COMPATIBILITY IDEOGRAPH-2F92B
    0x2F92C: [0x3EB8],  # CJK COMPATIBILITY IDEOGRAPH-2F92C
    0x2F92D: [0x3EB8],  # CJK COMPATIBILITY IDEOGRAPH-2F92D
    0x2F92E: [0x7447],  # CJK COMPATIBILITY IDEOGRAPH-2F92E
    0x2F92F: [0x745C],  # CJK COMPATIBILITY IDEOGRAPH-2F92F
    0x2F930: [0x7471],  # CJK COMPATIBILITY IDEOGRAPH-2F930
    0x2F931: [0x7485],  # CJK COMPATIBILITY IDEOGRAPH-2F931
    0x2F932: [0x74CA],  # CJK COMPATIBILITY IDEOGRAPH-2F932
    0x2F933: [0x3F1B],  # CJK COMPATIBILITY IDEOGRAPH-2F933
    0x2F934: [0x7524],  # CJK COMPATIBILITY IDEOGRAPH-2F934
    0x2F935: [0x24C36],  # CJK COMPATIBILITY IDEOGRAPH-2F935
    0x2F936: [0x753E],  # CJK COMPATIBILITY IDEOGRAPH-2F936
    0x2F937: [0x24C92],  # CJK COMPATIBILITY IDEOGRAPH-2F937
    0x2F938: [0x7570],  # CJK COMPATIBILITY IDEOGRAPH-2F938
    0x2F939: [0x2219F],  # CJK COMPATIBILITY IDEOGRAPH-2F939
    0x2F93A: [0x7610],  # CJK COMPATIBILITY IDEOGRAPH-2F93A
    0x2F93B: [0x24FA1],  # CJK COMPATIBILITY IDEOGRAPH-2F93B
    0x2F93C: [0x24FB8],  # CJK COMPATIBILITY IDEOGRAPH-2F93C
    0x2F93D: [0x25044],  # CJK COMPATIBILITY IDEOGRAPH-2F93D
    0x2F93E: [0x3FFC],  # CJK COMPATIBILITY IDEOGRAPH-2F93E
    0x2F93F: [0x4008],  # CJK COMPATIBILITY IDEOGRAPH-2F93F
    0x2F940: [0x76F4],  # CJK COMPATIBILITY IDEOGRAPH-2F940
    0x2F941: [0x250F3],  # CJK COMPATIBILITY IDEOGRAPH-2F941
    0x2F942: [0x250F2],  # CJK COMPATIBILITY IDEOGRAPH-2F942
    0x2F943: [0x25119],  # CJK COMPATIBILITY IDEOGRAPH-2F943
    0x2F944: [0x25133],  # CJK COMPATIBILITY IDEOGRAPH-2F944
    0x2F945: [0x771E],  # CJK COMPATIBILITY IDEOGRAPH-2F945
    0x2F946: [0x771F],  # CJK COMPATIBILITY IDEOGRAPH-2F946
    0x2F947: [0x771F],  # CJK COMPATIBILITY IDEOGRAPH-2F947
    0x2F948: [0x774A],  # CJK COMPATIBILITY IDEOGRAPH-2F948
    0x2F949: [0x4039],  # CJK COMPATIBILITY IDEOGRAPH-2F949
    0x2F94A: [0x778B],  # CJK COMPATIBILITY IDEOGRAPH-2F94A
    0x2F94B: [0x4046],  # CJK COMPATIBILITY IDEOGRAPH-2F94B
    0x2F94C: [0x4096],  # CJK COMPATIBILITY IDEOGRAPH-2F94C
    0x2F94D: [0x2541D],  # CJK COMPATIBILITY IDEOGRAPH-2F94D
    0x2F94E: [0x784E],  # CJK COMPATIBILITY IDEOGRAPH-2F94E
    0x2F94F: [0x788C],  # CJK COMPATIBILITY IDEOGRAPH-2F94F
    0x2F950: [0x78CC],  # CJK COMPATIBILITY IDEOGRAPH-2F950
    0x2F951: [0x40E3],  # CJK COMPATIBILITY IDEOGRAPH-2F951
    0x2F952: [0x25626],  # CJK COMPATIBILITY IDEOGRAPH-2F952
    0x2F953: [0x7956],  # CJK COMPATIBILITY IDEOGRAPH-2F953
    0x2F954: [0x2569A],  # CJK COMPATIBILITY IDEOGRAPH-2F954
    0x2F955: [0x256C5],  # CJK COMPATIBILITY IDEOGRAPH-2F955
    0x2F956: [0x798F],  # CJK COMPATIBILITY IDEOGRAPH-2F956
    0x2F957: [0x79EB],  # CJK COMPATIBILITY IDEOGRAPH-2F957
    0x2F958: [0x412F],  # CJK COMPATIBILITY IDEOGRAPH-2F958
    0x2F959: [0x7A40],  # CJK COMPATIBILITY IDEOGRAPH-2F959
    0x2F95A: [0x7A4A],  # CJK COMPATIBILITY IDEOGRAPH-2F95A
    0x2F95B: [0x7A4F],  # CJK COMPATIBILITY IDEOGRAPH-2F95B
    0x2F95C: [0x2597C],  # CJK COMPATIBILITY IDEOGRAPH-2F95C
    0x2F95D: [0x25AA7],  # CJK COMPATIBILITY IDEOGRAPH-2F95D
    0x2F95E: [0x25AA7],  # CJK COMPATIBILITY IDEOGRAPH-2F95E
    0x2F95F: [0x7AEE],  # CJK COMPATIBILITY IDEOGRAPH-2F95F
    0x2F960: [0x4202],  # CJK COMPATIBILITY IDEOGRAPH-2F960
    0x2F961: [0x25BAB],  # CJK COMPATIBILITY IDEOGRAPH-2F961
    0x2F962: [0x7BC6],  # CJK COMPATIBILITY IDEOGRAPH-2F962
    0x2F963: [0x7BC9],  # CJK COMPATIBILITY IDEOGRAPH-2F963
    0x2F964: [0x4227],  # CJK COMPATIBILITY IDEOGRAPH-2F964
    0x2F965: [0x25C80],  # CJK COMPATIBILITY IDEOGRAPH-2F965
    0x2F966: [0x7CD2],  # CJK COMPATIBILITY IDEOGRAPH-2F966
    0x2F967: [0x42A0],  # CJK COMPATIBILITY IDEOGRAPH-2F967
    0x2F968: [0x7CE8],  # CJK COMPATIBILITY IDEOGRAPH-2F968
    0x2F969: [0x7CE3],  # CJK COMPATIBILITY IDEOGRAPH-2F969
    0x2F96A: [0x7D00],  # CJK COMPATIBILITY IDEOGRAPH-2F96A
    0x2F96B: [0x25F86],  # CJK COMPATIBILITY IDEOGRAPH-2F96B
    0x2F96C: [0x7D63],  # CJK COMPATIBILITY IDEOGRAPH-2F96C
    0x2F96D: [0x4301],  # CJK COMPATIBILITY IDEOGRAPH-2F96D
    0x2F96E: [0x7DC7],  # CJK COMPATIBILITY IDEOGRAPH-2F96E
    0x2F96F: [0x7E02],  # CJK COMPATIBILITY IDEOGRAPH-2F96F
    0x2F970: [0x7E45],  # CJK COMPATIBILITY IDEOGRAPH-2F970
    0x2F971: [0x4334],  # CJK COMPATIBILITY IDEOGRAPH-2F971
    0x2F972: [0x26228],  # CJK COMPATIBILITY IDEOGRAPH-2F972
    0x2F973: [0x26247],  # CJK COMPATIBILITY IDEOGRAPH-2F973
    0x2F974: [0x4359],  # CJK COMPATIBILITY IDEOGRAPH-2F974
    0x2F975: [0x262D9],  # CJK COMPATIBILITY IDEOGRAPH-2F975
    0x2F976: [0x7F7A],  # CJK COMPATIBILITY IDEOGRAPH-2F976
    0x2F977: [0x2633E],  # CJK COMPATIBILITY IDEOGRAPH-2F977
    0x2F978: [0x7F95],  # CJK COMPATIBILITY IDEOGRAPH-2F978
    0x2F979: [0x7FFA],  # CJK COMPATIBILITY IDEOGRAPH-2F979
    0x2F97A: [0x8005],  # CJK COMPATIBILITY IDEOGRAPH-2F97A
    0x2F97B: [0x264DA],  # CJK COMPATIBILITY IDEOGRAPH-2F97B
    0x2F97C: [0x26523],  # CJK COMPATIBILITY IDEOGRAPH-2F97C
    0x2F97D: [0x8060],  # CJK COMPATIBILITY IDEOGRAPH-2F97D
    0x2F97E: [0x265A8],  # CJK COMPATIBILITY IDEOGRAPH-2F97E
    0x2F97F: [0x8070],  # CJK COMPATIBILITY IDEOGRAPH-2F97F
    0x2F980: [0x2335F],  # CJK COMPATIBILITY IDEOGRAPH-2F980
    0x2F981: [0x43D5],  # CJK COMPATIBILITY IDEOGRAPH-2F981
    0x2F982: [0x80B2],  # CJK COMPATIBILITY IDEOGRAPH-2F982
    0x2F983: [0x8103],  # CJK COMPATIBILITY IDEOGRAPH-2F983
    0x2F984: [0x440B],  # CJK COMPATIBILITY IDEOGRAPH-2F984
    0x2F985: [0x813E],  # CJK COMPATIBILITY IDEOGRAPH-2F985
    0x2F986: [0x5AB5],  # CJK COMPATIBILITY IDEOGRAPH-2F986
    0x2F987: [0x267A7],  # CJK COMPATIBILITY IDEOGRAPH-2F987
    0x2F988: [0x267B5],  # CJK COMPATIBILITY IDEOGRAPH-2F988
    0x2F989: [0x23393],  # CJK COMPATIBILITY IDEOGRAPH-2F989
    0x2F98A: [0x2339C],  # CJK COMPATIBILITY IDEOGRAPH-2F98A
    0x2F98B: [0x8201],  # CJK COMPATIBILITY IDEOGRAPH-2F98B
    0x2F98C: [0x8204],  # CJK COMPATIBILITY IDEOGRAPH-2F98C
    0x2F98D: [0x8F9E],  # CJK COMPATIBILITY IDEOGRAPH-2F98D
    0x2F98E: [0x446B],  # CJK COMPATIBILITY IDEOGRAPH-2F98E
    0x2F98F: [0x8291],  # CJK COMPATIBILITY IDEOGRAPH-2F98F
    0x2F990: [0x828B],  # CJK COMPATIBILITY IDEOGRAPH-2F990
    0x2F991: [0x829D],  # CJK COMPATIBILITY IDEOGRAPH-2F991
    0x2F992: [0x52B3],  # CJK COMPATIBILITY IDEOGRAPH-2F992
    0x2F993: [0x82B1],  # CJK COMPATIBILITY IDEOGRAPH-2F993
    0x2F994: [0x82B3],  # CJK COMPATIBILITY IDEOGRAPH-2F994
    0x2F995: [0x82BD],  # CJK COMPATIBILITY IDEOGRAPH-2F995
    0x2F996: [0x82E6],  # CJK COMPATIBILITY IDEOGRAPH-2F996
    0x2F997: [0x26B3C],  # CJK COMPATIBILITY IDEOGRAPH-2F997
    0x2F998: [0x82E5],  # CJK COMPATIBILITY IDEOGRAPH-2F998
    0x2F999: [0x831D],  # CJK COMPATIBILITY IDEOGRAPH-2F999
    0x2F99A: [0x8363],  # CJK COMPATIBILITY IDEOGRAPH-2F99A
    0x2F99B: [0x83AD],  # CJK COMPATIBILITY IDEOGRAPH-2F99B
    0x2F99C: [0x8323],  # CJK COMPATIBILITY IDEOGRAPH-2F99C
    0x2F99D: [0x83BD],  # CJK COMPATIBILITY IDEOGRAPH-2F99D
    0x2F99E: [0x83E7],  # CJK COMPATIBILITY IDEOGRAPH-2F99E
    0x2F99F: [0x8457],  # CJK COMPATIBILITY IDEOGRAPH-2F99F
    0x2F9A0: [0x8353],  # CJK COMPATIBILITY IDEOGRAPH-2F9A0
    0x2F9A1: [0x83CA],  # CJK COMPATIBILITY IDEOGRAPH-2F9A1
    0x2F9A2: [0x83CC],  # CJK COMPATIBILITY IDEOGRAPH-2F9A2
    0x2F9A3: [0x83DC],  # CJK COMPATIBILITY IDEOGRAPH-2F9A3
    0x2F9A4: [0x26C36],  # CJK COMPATIBILITY IDEOGRAPH-2F9A4
    0x2F9A5: [0x26D6B],  # CJK COMPATIBILITY IDEOGRAPH-2F9A5
    0x2F9A6: [0x26CD5],  # CJK COMPATIBILITY IDEOGRAPH-2F9A6
    0x2F9A7: [0x452B],  # CJK COMPATIBILITY IDEOGRAPH-2F9A7
    0x2F9A8: [0x84F1],  # CJK COMPATIBILITY IDEOGRAPH-2F9A8
    0x2F9A9: [0x84F3],  # CJK COMPATIBILITY IDEOGRAPH-2F9A9
    0x2F9AA: [0x8516],  # CJK COMPATIBILITY IDEOGRAPH-2F9AA
    0x2F9AB: [0x273CA],  # CJK COMPATIBILITY IDEOGRAPH-2F9AB
    0x2F9AC: [0x8564],  # CJK COMPATIBILITY IDEOGRAPH-2F9AC
    0x2F9AD: [0x26F2C],  # CJK COMPATIBILITY IDEOGRAPH-2F9AD
    0x2F9AE: [0x455D],  # CJK COMPATIBILITY IDEOGRAPH-2F9AE
    0x2F9AF: [0x4561],  # CJK COMPATIBILITY IDEOGRAPH-2F9AF
    0x2F9B0: [0x26FB1],  # CJK COMPATIBILITY IDEOGRAPH-2F9B0
    0x2F9B1: [0x270D2],  # CJK COMPATIBILITY IDEOGRAPH-2F9B1
    0x2F9B2: [0x456B],  # CJK COMPATIBILITY IDEOGRAPH-2F9B2
    0x2F9B3: [0x8650],  # CJK COMPATIBILITY IDEOGRAPH-2F9B3
    0x2F9B4: [0x865C],  # CJK COMPATIBILITY IDEOGRAPH-2F9B4
    0x2F9B5: [0x8667],  # CJK COMPATIBILITY IDEOGRAPH-2F9B5
    0x2F9B6: [0x8669],  # CJK COMPATIBILITY IDEOGRAPH-2F9B6
    0x2F9B7: [0x86A9],  # CJK COMPATIBILITY IDEOGRAPH-2F9B7
    0x2F9B8: [0x8688],  # CJK COMPATIBILITY IDEOGRAPH-2F9B8
    0x2F9B9: [0x870E],  # CJK COMPATIBILITY IDEOGRAPH-2F9B9
    0x2F9BA: [0x86E2],  # CJK COMPATIBILITY IDEOGRAPH-2F9BA
    0x2F9BB: [0x8779],  # CJK COMPATIBILITY IDEOGRAPH-2F9BB
    0x2F9BC: [0x8728],  # CJK COMPATIBILITY IDEOGRAPH-2F9BC
    0x2F9BD: [0x876B],  # CJK COMPATIBILITY IDEOGRAPH-2F9BD
    0x2F9BE: [0x8786],  # CJK COMPATIBILITY IDEOGRAPH-2F9BE
    0x2F9BF: [0x45D7],  # CJK COMPATIBILITY IDEOGRAPH-2F9BF
    0x2F9C0: [0x87E1],  # CJK COMPATIBILITY IDEOGRAPH-2F9C0
    0x2F9C1: [0x8801],  # CJK COMPATIBILITY IDEOGRAPH-2F9C1
    0x2F9C2: [0x45F9],  # CJK COMPATIBILITY IDEOGRAPH-2F9C2
    0x2F9C3: [0x8860],  # CJK COMPATIBILITY IDEOGRAPH-2F9C3
    0x2F9C4: [0x8863],  # CJK COMPATIBILITY IDEOGRAPH-2F9C4
    0x2F9C5: [0x27667],  # CJK COMPATIBILITY IDEOGRAPH-2F9C5
    0x2F9C6: [0x88D7],  # CJK COMPATIBILITY IDEOGRAPH-2F9C6
    0x2F9C7: [0x88DE],  # CJK COMPATIBILITY IDEOGRAPH-2F9C7
    0x2F9C8: [0x4635],  # CJK COMPATIBILITY IDEOGRAPH-2F9C8
    0x2F9C9: [0x88FA],  # CJK COMPATIBILITY IDEOGRAPH-2F9C9
    0x2F9CA: [0x34BB],  # CJK COMPATIBILITY IDEOGRAPH-2F9CA
    0x2F9CB: [0x278AE],  # CJK COMPATIBILITY IDEOGRAPH-2F9CB
    0x2F9CC: [0x27966],  # CJK COMPATIBILITY IDEOGRAPH-2F9CC
    0x2F9CD: [0x46BE],  # CJK COMPATIBILITY IDEOGRAPH-2F9CD
    0x2F9CE: [0x46C7],  # CJK COMPATIBILITY IDEOGRAPH-2F9CE
    0x2F9CF: [0x8AA0],  # CJK COMPATIBILITY IDEOGRAPH-2F9CF
    0x2F9D0: [0x8AED],  # CJK COMPATIBILITY IDEOGRAPH-2F9D0
    0x2F9D1: [0x8B8A],  # CJK COMPATIBILITY IDEOGRAPH-2F9D1
    0x2F9D2: [0x8C55],  # CJK COMPATIBILITY IDEOGRAPH-2F9D2
    0x2F9D3: [0x27CA8],  # CJK COMPATIBILITY IDEOGRAPH-2F9D3
    0x2F9D4: [0x8CAB],  # CJK COMPATIBILITY IDEOGRAPH-2F9D4
    0x2F9D5: [0x8CC1],  # CJK COMPATIBILITY IDEOGRAPH-2F9D5
    0x2F9D6: [0x8D1B],  # CJK COMPATIBILITY IDEOGRAPH-2F9D6
    0x2F9D7: [0x8D77],  # CJK COMPATIBILITY IDEOGRAPH-2F9D7
    0x2F9D8: [0x27F2F],  # CJK COMPATIBILITY IDEOGRAPH-2F9D8
    0x2F9D9: [0x20804],  # CJK COMPATIBILITY IDEOGRAPH-2F9D9
    0x2F9DA: [0x8DCB],  # CJK COMPATIBILITY IDEOGRAPH-2F9DA
    0x2F9DB: [0x8DBC],  # CJK COMPATIBILITY IDEOGRAPH-2F9DB
    0x2F9DC: [0x8DF0],  # CJK COMPATIBILITY IDEOGRAPH-2F9DC
    0x2F9DD: [0x208DE],  # CJK COMPATIBILITY IDEOGRAPH-2F9DD
    0x2F9DE: [0x8ED4],  # CJK COMPATIBILITY IDEOGRAPH-2F9DE
    0x2F9DF: [0x8F38],  # CJK COMPATIBILITY IDEOGRAPH-2F9DF
    0x2F9E0: [0x285D2],  # CJK COMPATIBILITY IDEOGRAPH-2F9E0
    0x2F9E1: [0x285ED],  # CJK COMPATIBILITY IDEOGRAPH-2F9E1
    0x2F9E2: [0x9094],  # CJK COMPATIBILITY IDEOGRAPH-2F9E2
    0x2F9E3: [0x90F1],  # CJK COMPATIBILITY IDEOGRAPH-2F9E3
    0x2F9E4: [0x9111],  # CJK COMPATIBILITY IDEOGRAPH-2F9E4
    0x2F9E5: [0x2872E],  # CJK COMPATIBILITY IDEOGRAPH-2F9E5
    0x2F9E6: [0x911B],  # CJK COMPATIBILITY IDEOGRAPH-2F9E6
    0x2F9E7: [0x9238],  # CJK COMPATIBILITY IDEOGRAPH-2F9E7
    0x2F9E8: [0x92D7],  # CJK COMPATIBILITY IDEOGRAPH-2F9E8
    0x2F9E9: [0x92D8],  # CJK COMPATIBILITY IDEOGRAPH-2F9E9
    0x2F9EA: [0x927C],  # CJK COMPATIBILITY IDEOGRAPH-2F9EA
    0x2F9EB: [0x93F9],  # CJK COMPATIBILITY IDEOGRAPH-2F9EB
    0x2F9EC: [0x9415],  # CJK COMPATIBILITY IDEOGRAPH-2F9EC
    0x2F9ED: [0x28BFA],  # CJK COMPATIBILITY IDEOGRAPH-2F9ED
    0x2F9EE: [0x958B],  # CJK COMPATIBILITY IDEOGRAPH-2F9EE
    0x2F9EF: [0x4995],  # CJK COMPATIBILITY IDEOGRAPH-2F9EF
    0x2F9F0: [0x95B7],  # CJK COMPATIBILITY IDEOGRAPH-2F9F0
    0x2F9F1: [0x28D77],  # CJK COMPATIBILITY IDEOGRAPH-2F9F1
    0x2F9F2: [0x49E6],  # CJK COMPATIBILITY IDEOGRAPH-2F9F2
    0x2F9F3: [0x96C3],  # CJK COMPATIBILITY IDEOGRAPH-2F9F3
    0x2F9F4: [0x5DB2],  # CJK COMPATIBILITY IDEOGRAPH-2F9F4
    0x2F9F5: [0x9723],  # CJK COMPATIBILITY IDEOGRAPH-2F9F5
    0x2F9F6: [0x29145],  # CJK COMPATIBILITY IDEOGRAPH-2F9F6
    0x2F9F7: [0x2921A],  # CJK COMPATIBILITY IDEOGRAPH-2F9F7
    0x2F9F8: [0x4A6E],  # CJK COMPATIBILITY IDEOGRAPH-2F9F8
    0x2F9F9: [0x4A76],  # CJK COMPATIBILITY IDEOGRAPH-2F9F9
    0x2F9FA: [0x97E0],  # CJK COMPATIBILITY IDEOGRAPH-2F9FA
    0x2F9FB: [0x2940A],  # CJK COMPATIBILITY IDEOGRAPH-2F9FB
    0x2F9FC: [0x4AB2],  # CJK COMPATIBILITY IDEOGRAPH-2F9FC
    0x2F9FD: [0x29496],  # CJK COMPATIBILITY IDEOGRAPH-2F9FD
    0x2F9FE: [0x980B],  # CJK COMPATIBILITY IDEOGRAPH-2F9FE
    0x2F9FF: [0x980B],  # CJK COMPATIBILITY IDEOGRAPH-2F9FF
    0x2FA00: [0x9829],  # CJK COMPATIBILITY IDEOGRAPH-2FA00
    0x2FA01: [0x295B6],  # CJK COMPATIBILITY IDEOGRAPH-2FA01
    0x2FA02: [0x98E2],  # CJK COMPATIBILITY IDEOGRAPH-2FA02
    0x2FA03: [0x4B33],  # CJK COMPATIBILITY IDEOGRAPH-2FA03
    0x2FA04: [0x9929],  # CJK COMPATIBILITY IDEOGRAPH-2FA04
    0x2FA05: [0x99A7],  # CJK COMPATIBILITY IDEOGRAPH-2FA05
    0x2FA06: [0x99C2],  # CJK COMPATIBILITY IDEOGRAPH-2FA06
    0x2FA07: [0x99FE],  # CJK COMPATIBILITY IDEOGRAPH-2FA07
    0x2FA08: [0x4BCE],  # CJK COMPATIBILITY IDEOGRAPH-2FA08
    0x2FA09: [0x29B30],  # CJK COMPATIBILITY IDEOGRAPH-2FA09
    0x2FA0A: [0x9B12],  # CJK COMPATIBILITY IDEOGRAPH-2FA0A
    0x2FA0B: [0x9C40],  # CJK COMPATIBILITY IDEOGRAPH-2FA0B
    0x2FA0C: [0x9CFD],  # CJK COMPATIBILITY IDEOGRAPH-2FA0C
    0x2FA0D: [0x4CCE],  # CJK COMPATIBILITY IDEOGRAPH-2FA0D
    0x2FA0E: [0x4CED],  # CJK COMPATIBILITY IDEOGRAPH-2FA0E
    0x2FA0F: [0x9D67],  # CJK COMPATIBILITY IDEOGRAPH-2FA0F
    0x2FA10: [0x2A0CE],  # CJK COMPATIBILITY IDEOGRAPH-2FA10
    0x2FA11: [0x4CF8],  # CJK COMPATIBILITY IDEOGRAPH-2FA11
    0x2FA12: [0x2A105],  # CJK COMPATIBILITY IDEOGRAPH-2FA12
    0x2FA13: [0x2A20E],  # CJK COMPATIBILITY IDEOGRAPH-2FA13
    0x2FA14: [0x2A291],  # CJK COMPATIBILITY IDEOGRAPH-2FA14
    0x2FA15: [0x9EBB],  # CJK COMPATIBILITY IDEOGRAPH-2FA15
    0x2FA16: [0x4D56],  # CJK COMPATIBILITY IDEOGRAPH-2FA16
    0x2FA17: [0x9EF9],  # CJK COMPATIBILITY IDEOGRAPH-2FA17
    0x2FA18: [0x9EFE],  # CJK COMPATIBILITY IDEOGRAPH-2FA18
    0x2FA19: [0x9F05],  # CJK COMPATIBILITY IDEOGRAPH-2FA19
    0x2FA1A: [0x9F0F],  # CJK COMPATIBILITY IDEOGRAPH-2FA1A
    0x2FA1B: [0x9F16],  # CJK COMPATIBILITY IDEOGRAPH-2FA1B
    0x2FA1C: [0x9F3B],  # CJK COMPATIBILITY IDEOGRAPH-2FA1C
    0x2FA1D: [0x2A600],  # CJK COMPATIBILITY IDEOGRAPH-2FA1D
}

# Non-zero canonical combining class values
_CCC = {
    0x00300: 230,  # COMBINING GRAVE ACCENT
    0x00301: 230,  # COMBINING ACUTE ACCENT
    0x00302: 230,  # COMBINING CIRCUMFLEX ACCENT
    0x00303: 230,  # COMBINING TILDE
    0x00304: 230,  # COMBINING MACRON
    0x00305: 230,  # COMBINING OVERLINE
    0x00306: 230,  # COMBINING BREVE
    0x00307: 230,  # COMBINING DOT ABOVE
    0x00308: 230,  # COMBINING DIAERESIS
    0x00309: 230,  # COMBINING HOOK ABOVE
    0x0030A: 230,  # COMBINING RING ABOVE
    0x0030B: 230,  # COMBINING DOUBLE ACUTE ACCENT
    0x0030C: 230,  # COMBINING CARON
    0x0030D: 230,  # COMBINING VERTICAL LINE ABOVE
    0x0030E: 230,  # COMBINING DOUBLE VERTICAL LINE ABOVE
    0x0030F: 230,  # COMBINING DOUBLE GRAVE ACCENT
    0x00310: 230,  # COMBINING CANDRABINDU
    0x00311: 230,  # COMBINING INVERTED BREVE
    0x00312: 230,  # COMBINING TURNED COMMA ABOVE
    0x00313: 230,  # COMBINING COMMA ABOVE
    0x00314: 230,  # COMBINING REVERSED COMMA ABOVE
    0x00315: 232,  # COMBINING COMMA ABOVE RIGHT
    0x00316: 220,  # COMBINING GRAVE ACCENT BELOW
    0x00317: 220,  # COMBINING ACUTE ACCENT BELOW
    0x00318: 220,  # COMBINING LEFT TACK BELOW
    0x00319: 220,  # COMBINING RIGHT TACK BELOW
    0x0031A: 232,  # COMBINING LEFT ANGLE ABOVE
    0x0031B: 216,  # COMBINING HORN
    0x0031C: 220,  # COMBINING LEFT HALF RING BELOW
    0x0031D: 220,  # COMBINING UP TACK BELOW
    0x0031E: 220,  # COMBINING DOWN TACK BELOW
    0x0031F: 220,  # COMBINING PLUS SIGN BELOW
    0x00320: 220,  # COMBINING MINUS SIGN BELOW
    0x00321: 202,  # COMBINING PALATALIZED HOOK BELOW
    0x00322: 202,  # COMBINING RETROFLEX HOOK BELOW
    0x00323: 220,  # COMBINING DOT BELOW
    0x00324: 220,  # COMBINING DIAERESIS BELOW
    0x00325: 220,  # COMBINING RING BELOW
    0x00326: 220,  # COMBINING COMMA BELOW
    0x00327: 202,  # COMBINING CEDILLA
    0x00328: 202,  # COMBINING OGONEK
    0x00329: 220,  # COMBINING VERTICAL LINE BELOW
    0x0032A: 220,  # COMBINING BRIDGE BELOW
    0x0032B: 220,  # COMBINING INVERTED DOUBLE ARCH BELOW
    0x0032C: 220,  # COMBINING CARON BELOW
    0x0032D: 220,  # COMBINING CIRCUMFLEX ACCENT BELOW
    0x0032E: 220,  # COMBINING BREVE BELOW
    0x0032F: 220,  # COMBINING INVERTED BREVE BELOW
    0x00330: 220,  # COMBINING TILDE BELOW
    0x00331: 220,  # COMBINING MACRON BELOW
    0x00332: 220,  # COMBINING LOW LINE
    0x00333: 220,  # COMBINING DOUBLE LOW LINE
    0x00334:   1,  # COMBINING TILDE OVERLAY
    0x00335:   1,  # COMBINING SHORT STROKE OVERLAY
    0x00336:   1,  # COMBINING LONG STROKE OVERLAY
    0x00337:   1,  # COMBINING SHORT SOLIDUS OVERLAY
    0x00338:   1,  # COMBINING LONG SOLIDUS OVERLAY
    0x00339: 220,  # COMBINING RIGHT HALF RING BELOW
    0x0033A: 220,  # COMBINING INVERTED BRIDGE BELOW
    0x0033B: 220,  # COMBINING SQUARE BELOW
    0x0033C: 220,  # COMBINING SEAGULL BELOW
    0x0033D: 230,  # COMBINING X ABOVE
    0x0033E: 230,  # COMBINING VERTICAL TILDE
    0x0033F: 230,  # COMBINING DOUBLE OVERLINE
    0x00340: 230,  # COMBINING GRAVE TONE MARK
    0x00341: 230,  # COMBINING ACUTE TONE MARK
    0x00342: 230,  # COMBINING GREEK PERISPOMENI
    0x00343: 230,  # COMBINING GREEK KORONIS
    0x00344: 230,  # COMBINING GREEK DIALYTIKA TONOS
    0x00345: 240,  # COMBINING GREEK YPOGEGRAMMENI
    0x00346: 230,  # COMBINING BRIDGE ABOVE
    0x00347: 220,  # COMBINING EQUALS SIGN BELOW
    0x00348: 220,  # COMBINING DOUBLE VERTICAL LINE BELOW
    0x00349: 220,  # COMBINING LEFT ANGLE BELOW
    0x0034A: 230,  # COMBINING NOT TILDE ABOVE
    0x0034B: 230,  # COMBINING HOMOTHETIC ABOVE
    0x0034C: 230,  # COMBINING ALMOST EQUAL TO ABOVE
    0x0034D: 220,  # COMBINING LEFT RIGHT ARROW BELOW
    0x0034E: 220,  # COMBINING UPWARDS ARROW BELOW
    0x00350: 230,  # COMBINING RIGHT ARROWHEAD ABOVE
    0x00351: 230,  # COMBINING LEFT HALF RING ABOVE
    0x00352: 230,  # COMBINING FERMATA
    0x00353: 220,  # COMBINING X BELOW
    0x00354: 220,  # COMBINING LEFT ARROWHEAD BELOW
    0x00355: 220,  # COMBINING RIGHT ARROWHEAD BELOW
    0x00356: 220,  # COMBINING RIGHT ARROWHEAD AND UP ARROWHEAD BELOW
    0x00357: 230,  # COMBINING RIGHT HALF RING ABOVE
    0x00358: 232,  # COMBINING DOT ABOVE RIGHT
    0x00359: 220,  # COMBINING ASTERISK BELOW
    0x0035A: 220,  # COMBINING DOUBLE RING BELOW
    0x0035B: 230,  # COMBINING ZIGZAG ABOVE
    0x0035C: 233,  # COMBINING DOUBLE BREVE BELOW
    0x0035D: 234,  # COMBINING DOUBLE BREVE
    0x0035E: 234,  # COMBINING DOUBLE MACRON
    0x0035F: 233,  # COMBINING DOUBLE MACRON BELOW
    0x00360: 234,  # COMBINING DOUBLE TILDE
    0x00361: 234,  # COMBINING DOUBLE INVERTED BREVE
    0x00362: 233,  # COMBINING DOUBLE RIGHTWARDS ARROW BELOW
    0x00363: 230,  # COMBINING LATIN SMALL LETTER A
    0x00364: 230,  # COMBINING LATIN SMALL LETTER E
    0x00365: 230,  # COMBINING LATIN SMALL LETTER I
    0x00366: 230,  # COMBINING LATIN SMALL LETTER O
    0x00367: 230,  # COMBINING LATIN SMALL LETTER U
    0x00368: 230,  # COMBINING LATIN SMALL LETTER C
    0x00369: 230,  # COMBINING LATIN SMALL LETTER D
    0x0036A: 230,  # COMBINING LATIN SMALL LETTER H
    0x0036B: 230,  # COMBINING LATIN SMALL LETTER M
    0x0036C: 230,  # COMBINING LATIN SMALL LETTER R
    0x0036D: 230,  # COMBINING LATIN SMALL LETTER T
    0x0036E: 230,  # COMBINING LATIN SMALL LETTER V
    0x0036F: 230,  # COMBINING LATIN SMALL LETTER X
    0x00483: 230,  # COMBINING CYRILLIC TITLO
    0x00484: 230,  # COMBINING CYRILLIC PALATALIZATION
    0x00485: 230,  # COMBINING CYRILLIC DASIA PNEUMATA
    0x00486: 230,  # COMBINING CYRILLIC PSILI PNEUMATA
    0x00487: 230,  # COMBINING CYRILLIC POKRYTIE
    0x00591: 220,  # HEBREW ACCENT ETNAHTA
    0x00592: 230,  # HEBREW ACCENT SEGOL
    0x00593: 230,  # HEBREW ACCENT SHALSHELET
    0x00594: 230,  # HEBREW ACCENT ZAQEF QATAN
    0x00595: 230,  # HEBREW ACCENT ZAQEF GADOL
    0x00596: 220,  # HEBREW ACCENT TIPEHA
    0x00597: 230,  # HEBREW ACCENT REVIA
    0x00598: 230,  # HEBREW ACCENT ZARQA
    0x00599: 230,  # HEBREW ACCENT PASHTA
    0x0059A: 222,  # HEBREW ACCENT YETIV
    0x0059B: 220,  # HEBREW ACCENT TEVIR
    0x0059C: 230,  # HEBREW ACCENT GERESH
    0x0059D: 230,  # HEBREW ACCENT GERESH MUQDAM
    0x0059E: 230,  # HEBREW ACCENT GERSHAYIM
    0x0059F: 230,  # HEBREW ACCENT QARNEY PARA
    0x005A0: 230,  # HEBREW ACCENT TELISHA GEDOLA
    0x005A1: 230,  # HEBREW ACCENT PAZER
    0x005A2: 220,  # HEBREW ACCENT ATNAH HAFUKH
    0x005A3: 220,  # HEBREW ACCENT MUNAH
    0x005A4: 220,  # HEBREW ACCENT MAHAPAKH
    0x005A5: 220,  # HEBREW ACCENT MERKHA
    0x005A6: 220,  # HEBREW ACCENT MERKHA KEFULA
    0x005A7: 220,  # HEBREW ACCENT DARGA
    0x005A8: 230,  # HEBREW ACCENT QADMA
    0x005A9: 230,  # HEBREW ACCENT TELISHA QETANA
    0x005AA: 220,  # HEBREW ACCENT YERAH BEN YOMO
    0x005AB: 230,  # HEBREW ACCENT OLE
    0x005AC: 230,  # HEBREW ACCENT ILUY
    0x005AD: 222,  # HEBREW ACCENT DEHI
    0x005AE: 228,  # HEBREW ACCENT ZINOR
    0x005AF: 230,  # HEBREW MARK MASORA CIRCLE
    0x005B0:  10,  # HEBREW POINT SHEVA
    0x005B1:  11,  # HEBREW POINT HATAF SEGOL
    0x005B2:  12,  # HEBREW POINT HATAF PATAH
    0x005B3:  13,  # HEBREW POINT HATAF QAMATS
    0x005B4:  14,  # HEBREW POINT HIRIQ
    0x005B5:  15,  # HEBREW POINT TSERE
    0x005B6:  16,  # HEBREW POINT SEGOL
    0x005B7:  17,  # HEBREW POINT PATAH
    0x005B8:  18,  # HEBREW POINT QAMATS
    0x005B9:  19,  # HEBREW POINT HOLAM
    0x005BA:  19,  # HEBREW POINT HOLAM HASER FOR VAV
    0x005BB:  20,  # HEBREW POINT QUBUTS
    0x005BC:  21,  # HEBREW POINT DAGESH OR MAPIQ
    0x005BD:  22,  # HEBREW POINT METEG
    0x005BF:  23,  # HEBREW POINT RAFE
    0x005C1:  24,  # HEBREW POINT SHIN DOT
    0x005C2:  25,  # HEBREW POINT SIN DOT
    0x005C4: 230,  # HEBREW MARK UPPER DOT
    0x005C5: 220,  # HEBREW MARK LOWER DOT
    0x005C7:  18,  # HEBREW POINT QAMATS QATAN
    0x00610: 230,  # ARABIC SIGN SALLALLAHOU ALAYHE WASSALLAM
    0x00611: 230,  # ARABIC SIGN ALAYHE ASSALLAM
    0x00612: 230,  # ARABIC SIGN RAHMATULLAH ALAYHE
    0x00613: 230,  # ARABIC SIGN RADI ALLAHOU ANHU
    0x00614: 230,  # ARABIC SIGN TAKHALLUS
    0x00615: 230,  # ARABIC SMALL HIGH TAH
    0x00616: 230,  # ARABIC SMALL HIGH LIGATURE ALEF WITH LAM WITH YEH
    0x00617: 230,  # ARABIC SMALL HIGH ZAIN
    0x00618:  30,  # ARABIC SMALL FATHA
    0x00619:  31,  # ARABIC SMALL DAMMA
    0x0061A:  32,  # ARABIC SMALL KASRA
    0x0064B:  27,  # ARABIC FATHATAN
    0x0064C:  28,  # ARABIC DAMMATAN
    0x0064D:  29,  # ARABIC KASRATAN
    0x0064E:  30,  # ARABIC FATHA
    0x0064F:  31,  # ARABIC DAMMA
    0x00650:  32,  # ARABIC KASRA
    0x00651:  33,  # ARABIC SHADDA
    0x00652:  34,  # ARABIC SUKUN
    0x00653: 230,  # ARABIC MADDAH ABOVE
    0x00654: 230,  # ARABIC HAMZA ABOVE
    0x00655: 220,  # ARABIC HAMZA BELOW
    0x00656: 220,  # ARABIC SUBSCRIPT ALEF
    0x00657: 230,  # ARABIC INVERTED DAMMA
    0x00658: 230,  # ARABIC MARK NOON GHUNNA
    0x00659: 230,  # ARABIC ZWARAKAY
    0x0065A: 230,  # ARABIC VOWEL SIGN SMALL V ABOVE
    0x0065B: 230,  # ARABIC VOWEL SIGN INVERTED SMALL V ABOVE
    0x0065C: 220,  # ARABIC VOWEL SIGN DOT BELOW
    0x0065D: 230,  # ARABIC REVERSED DAMMA
    0x0065E: 230,  # ARABIC FATHA WITH TWO DOTS
    0x0065F: 220,  # ARABIC WAVY HAMZA BELOW
    0x00670:  35,  # ARABIC LETTER SUPERSCRIPT ALEF
    0x006D6: 230,  # ARABIC SMALL HIGH LIGATURE SAD WITH LAM WITH ALEF MAKSURA
    0x006D7: 230,  # ARABIC SMALL HIGH LIGATURE QAF WITH LAM WITH ALEF MAKSURA
    0x006D8: 230,  # ARABIC SMALL HIGH MEEM INITIAL FORM
    0x006D9: 230,  # ARABIC SMALL HIGH LAM ALEF
    0x006DA: 230,  # ARABIC SMALL HIGH JEEM
    0x006DB: 230,  # ARABIC SMALL HIGH THREE DOTS
    0x006DC: 230,  # ARABIC SMALL HIGH SEEN
    0x006DF: 230,  # ARABIC SMALL HIGH ROUNDED ZERO
    0x006E0: 230,  # ARABIC SMALL HIGH UPRIGHT RECTANGULAR ZERO
    0x006E1: 230,  # ARABIC SMALL HIGH DOTLESS HEAD OF KHAH
    0x006E2: 230,  # ARABIC SMALL HIGH MEEM ISOLATED FORM
    0x006E3: 220,  # ARABIC SMALL LOW SEEN
    0x006E4: 230,  # ARABIC SMALL HIGH MADDA
    0x006E7: 230,  # ARABIC SMALL HIGH YEH
    0x006E8: 230,  # ARABIC SMALL HIGH NOON
    0x006EA: 220,  # ARABIC EMPTY CENTRE LOW STOP
    0x006EB: 230,  # ARABIC EMPTY CENTRE HIGH STOP
    0x006EC: 230,  # ARABIC ROUNDED HIGH STOP WITH FILLED CENTRE
    0x006ED: 220,  # ARABIC SMALL LOW MEEM
    0x00711:  36,  # SYRIAC LETTER SUPERSCRIPT ALAPH
    0x00730: 230,  # SYRIAC PTHAHA ABOVE
    0x00731: 220,  # SYRIAC PTHAHA BELOW
    0x00732: 230,  # SYRIAC PTHAHA DOTTED
    0x00733: 230,  # SYRIAC ZQAPHA ABOVE
    0x00734: 220,  # SYRIAC ZQAPHA BELOW
    0x00735: 230,  # SYRIAC ZQAPHA DOTTED
    0x00736: 230,  # SYRIAC RBASA ABOVE
    0x00737: 220,  # SYRIAC RBASA BELOW
    0x00738: 220,  # SYRIAC DOTTED ZLAMA HORIZONTAL
    0x00739: 220,  # SYRIAC DOTTED ZLAMA ANGULAR
    0x0073A: 230,  # SYRIAC HBASA ABOVE
    0x0073B: 220,  # SYRIAC HBASA BELOW
    0x0073C: 220,  # SYRIAC HBASA-ESASA DOTTED
    0x0073D: 230,  # SYRIAC ESASA ABOVE
    0x0073E: 220,  # SYRIAC ESASA BELOW
    0x0073F: 230,  # SYRIAC RWAHA
    0x00740: 230,  # SYRIAC FEMININE DOT
    0x00741: 230,  # SYRIAC QUSHSHAYA
    0x00742: 220,  # SYRIAC RUKKAKHA
    0x00743: 230,  # SYRIAC TWO VERTICAL DOTS ABOVE
    0x00744: 220,  # SYRIAC TWO VERTICAL DOTS BELOW
    0x00745: 230,  # SYRIAC THREE DOTS ABOVE
    0x00746: 220,  # SYRIAC THREE DOTS BELOW
    0x00747: 230,  # SYRIAC OBLIQUE LINE ABOVE
    0x00748: 220,  # SYRIAC OBLIQUE LINE BELOW
    0x00749: 230,  # SYRIAC MUSIC
    0x0074A: 230,  # SYRIAC BARREKH
    0x007EB: 230,  # NKO COMBINING SHORT HIGH TONE
    0x007EC: 230,  # NKO COMBINING SHORT LOW TONE
    0x007ED: 230,  # NKO COMBINING SHORT RISING TONE
    0x007EE: 230,  # NKO COMBINING LONG DESCENDING TONE
    0x007EF: 230,  # NKO COMBINING LONG HIGH TONE
    0x007F0: 230,  # NKO COMBINING LONG LOW TONE
    0x007F1: 230,  # NKO COMBINING LONG RISING TONE
    0x007F2: 220,  # NKO COMBINING NASALIZATION MARK
    0x007F3: 230,  # NKO COMBINING DOUBLE DOT ABOVE
    0x007FD: 220,  # NKO DANTAYALAN
    0x00816: 230,  # SAMARITAN MARK IN
    0x00817: 230,  # SAMARITAN MARK IN-ALAF
    0x00818: 230,  # SAMARITAN MARK OCCLUSION
    0x00819: 230,  # SAMARITAN MARK DAGESH
    0x0081B: 230,  # SAMARITAN MARK EPENTHETIC YUT
    0x0081C: 230,  # SAMARITAN VOWEL SIGN LONG E
    0x0081D: 230,  # SAMARITAN VOWEL SIGN E
    0x0081E: 230,  # SAMARITAN VOWEL SIGN OVERLONG AA
    0x0081F: 230,  # SAMARITAN VOWEL SIGN LONG AA
    0x00820: 230,  # SAMARITAN VOWEL SIGN AA
    0x00821: 230,  # SAMARITAN VOWEL SIGN OVERLONG A
    0x00822: 230,  # SAMARITAN VOWEL SIGN LONG A
    0x00823: 230,  # SAMARITAN VOWEL SIGN A
    0x00825: 230,  # SAMARITAN VOWEL SIGN SHORT A
    0x00826: 230,  # SAMARITAN VOWEL SIGN LONG U
    0x00827: 230,  # SAMARITAN VOWEL SIGN U
    0x00829: 230,  # SAMARITAN VOWEL SIGN LONG I
    0x0082A: 230,  # SAMARITAN VOWEL SIGN I
    0x0082B: 230,  # SAMARITAN VOWEL SIGN O
    0x0082C: 230,  # SAMARITAN VOWEL SIGN SUKUN
    0x0082D: 230,  # SAMARITAN MARK NEQUDAA
    0x00859: 220,  # MANDAIC AFFRICATION MARK
    0x0085A: 220,  # MANDAIC VOCALIZATION MARK
    0x0085B: 220,  # MANDAIC GEMINATION MARK
    0x00898: 230,  # ARABIC SMALL HIGH WORD AL-JUZ
    0x00899: 220,  # ARABIC SMALL LOW WORD ISHMAAM
    0x0089A: 220,  # ARABIC SMALL LOW WORD IMAALA
    0x0089B: 220,  # ARABIC SMALL LOW WORD TASHEEL
    0x0089C: 230,  # ARABIC MADDA WAAJIB
    0x0089D: 230,  # ARABIC SUPERSCRIPT ALEF MOKHASSAS
    0x0089E: 230,  # ARABIC DOUBLED MADDA
    0x0089F: 230,  # ARABIC HALF MADDA OVER MADDA
    0x008CA: 230,  # ARABIC SMALL HIGH FARSI YEH
    0x008CB: 230,  # ARABIC SMALL HIGH YEH BARREE WITH TWO DOTS BELOW
    0x008CC: 230,  # ARABIC SMALL HIGH WORD SAH
    0x008CD: 230,  # ARABIC SMALL HIGH ZAH
    0x008CE: 230,  # ARABIC LARGE ROUND DOT ABOVE
    0x008CF: 220,  # ARABIC LARGE ROUND DOT BELOW
    0x008D0: 220,  # ARABIC SUKUN BELOW
    0x008D1: 220,  # ARABIC LARGE CIRCLE BELOW
    0x008D2: 220,  # ARABIC LARGE ROUND DOT INSIDE CIRCLE BELOW
    0x008D3: 220,  # ARABIC SMALL LOW WAW
    0x008D4: 230,  # ARABIC SMALL HIGH WORD AR-RUB
    0x008D5: 230,  # ARABIC SMALL HIGH SAD
    0x008D6: 230,  # ARABIC SMALL HIGH AIN
    0x008D7: 230,  # ARABIC SMALL HIGH QAF
    0x008D8: 230,  # ARABIC SMALL HIGH NOON WITH KASRA
    0x008D9: 230,  # ARABIC SMALL LOW NOON WITH KASRA
    0x008DA: 230,  # ARABIC SMALL HIGH WORD ATH-THALATHA
    0x008DB: 230,  # ARABIC SMALL HIGH WORD AS-SAJDA
    0x008DC: 230,  # ARABIC SMALL HIGH WORD AN-NISF
    0x008DD: 230,  # ARABIC SMALL HIGH WORD SAKTA
    0x008DE: 230,  # ARABIC SMALL HIGH WORD QIF
    0x008DF: 230,  # ARABIC SMALL HIGH WORD WAQFA
    0x008E0: 230,  # ARABIC SMALL HIGH FOOTNOTE MARKER
    0x008E1: 230,  # ARABIC SMALL HIGH SIGN SAFHA
    0x008E3: 220,  # ARABIC TURNED DAMMA BELOW
    0x008E4: 230,  # ARABIC CURLY FATHA
    0x008E5: 230,  # ARABIC CURLY DAMMA
    0x008E6: 220,  # ARABIC CURLY KASRA
    0x008E7: 230,  # ARABIC CURLY FATHATAN
    0x008E8: 230,  # ARABIC CURLY DAMMATAN
    0x008E9: 220,  # ARABIC CURLY KASRATAN
    0x008EA: 230,  # ARABIC TONE ONE DOT ABOVE
    0x008EB: 230,  # ARABIC TONE TWO DOTS ABOVE
    0x008EC: 230,  # ARABIC TONE LOOP ABOVE
    0x008ED: 220,  # ARABIC TONE ONE DOT BELOW
    0x008EE: 220,  # ARABIC TONE TWO DOTS BELOW
    0x008EF: 220,  # ARABIC TONE LOOP BELOW
    0x008F0:  27,  # ARABIC OPEN FATHATAN
    0x008F1:  28,  # ARABIC OPEN DAMMATAN
    0x008F2:  29,  # ARABIC OPEN KASRATAN
    0x008F3: 230,  # ARABIC SMALL HIGH WAW
    0x008F4: 230,  # ARABIC FATHA WITH RING
    0x008F5: 230,  # ARABIC FATHA WITH DOT ABOVE
    0x008F6: 220,  # ARABIC KASRA WITH DOT BELOW
    0x008F7: 230,  # ARABIC LEFT ARROWHEAD ABOVE
    0x008F8: 230,  # ARABIC RIGHT ARROWHEAD ABOVE
    0x008F9: 220,  # ARABIC LEFT ARROWHEAD BELOW
    0x008FA: 220,  # ARABIC RIGHT ARROWHEAD BELOW
    0x008FB: 230,  # ARABIC DOUBLE RIGHT ARROWHEAD ABOVE
    0x008FC: 230,  # ARABIC DOUBLE RIGHT ARROWHEAD ABOVE WITH DOT
    0x008FD: 230,  # ARABIC RIGHT ARROWHEAD ABOVE WITH DOT
    0x008FE: 230,  # ARABIC DAMMA WITH DOT
    0x008FF: 230,  # ARABIC MARK SIDEWAYS NOON GHUNNA
    0x0093C:   7,  # DEVANAGARI SIGN NUKTA
    0x0094D:   9,  # DEVANAGARI SIGN VIRAMA
    0x00951: 230,  # DEVANAGARI STRESS SIGN UDATTA
    0x00952: 220,  # DEVANAGARI STRESS SIGN ANUDATTA
    0x00953: 230,  # DEVANAGARI GRAVE ACCENT
    0x00954: 230,  # DEVANAGARI ACUTE ACCENT
    0x009BC:   7,  # BENGALI SIGN NUKTA
    0x009CD:   9,  # BENGALI SIGN VIRAMA
    0x009FE: 230,  # BENGALI SANDHI MARK
    0x00A3C:   7,  # GURMUKHI SIGN NUKTA
    0x00A4D:   9,  # GURMUKHI SIGN VIRAMA
    0x00ABC:   7,  # GUJARATI SIGN NUKTA
    0x00ACD:   9,  # GUJARATI SIGN VIRAMA
    0x00B3C:   7,  # ORIYA SIGN NUKTA
    0x00B4D:   9,  # ORIYA SIGN VIRAMA
    0x00BCD:   9,  # TAMIL SIGN VIRAMA
    0x00C3C:   7,  # TELUGU SIGN NUKTA
    0x00C4D:   9,  # TELUGU SIGN VIRAMA
    0x00C55:  84,  # TELUGU LENGTH MARK
    0x00C56:  91,  # TELUGU AI LENGTH MARK
    0x00CBC:   7,  # KANNADA SIGN NUKTA
    0x00CCD:   9,  # KANNADA SIGN VIRAMA
    0x00D3B:   9,  # MALAYALAM SIGN VERTICAL BAR VIRAMA
    0x00D3C:   9,  # MALAYALAM SIGN CIRCULAR VIRAMA
    0x00D4D:   9,  # MALAYALAM SIGN VIRAMA
    0x00DCA:   9,  # SINHALA SIGN AL-LAKUNA
    0x00E38: 103,  # THAI CHARACTER SARA U
    0x00E39: 103,  # THAI CHARACTER SARA UU
    0x00E3A:   9,  # THAI CHARACTER PHINTHU
    0x00E48: 107,  # THAI CHARACTER MAI EK
    0x00E49: 107,  # THAI CHARACTER MAI THO
    0x00E4A: 107,  # THAI CHARACTER MAI TRI
    0x00E4B: 107,  # THAI CHARACTER MAI CHATTAWA
    0x00EB8: 118,  # LAO VOWEL SIGN U
    0x00EB9: 118,  # LAO VOWEL SIGN UU
    0x00EBA:   9,  # LAO SIGN PALI VIRAMA
    0x00EC8: 122,  # LAO TONE MAI EK
    0x00EC9: 122,  # LAO TONE MAI THO
    0x00ECA: 122,  # LAO TONE MAI TI
    0x00ECB: 122,  # LAO TONE MAI CATAWA
    0x00F18: 220,  # TIBETAN ASTROLOGICAL SIGN -KHYUD PA
    0x00F19: 220,  # TIBETAN ASTROLOGICAL SIGN SDONG TSHUGS
    0x00F35: 220,  # TIBETAN MARK NGAS BZUNG NYI ZLA
    0x00F37: 220,  # TIBETAN MARK NGAS BZUNG SGOR RTAGS
    0x00F39: 216,  # TIBETAN MARK TSA -PHRU
    0x00F71: 129,  # TIBETAN VOWEL SIGN AA
    0x00F72: 130,  # TIBETAN VOWEL SIGN I
    0x00F74: 132,  # TIBETAN VOWEL SIGN U
    0x00F7A: 130,  # TIBETAN VOWEL SIGN E
    0x00F7B: 130,  # TIBETAN VOWEL SIGN EE
    0x00F7C: 130,  # TIBETAN VOWEL SIGN O
    0x00F7D: 130,  # TIBETAN VOWEL SIGN OO
    0x00F80: 130,  # TIBETAN VOWEL SIGN REVERSED I
    0x00F82: 230,  # TIBETAN SIGN NYI ZLA NAA DA
    0x00F83: 230,  # TIBETAN SIGN SNA LDAN
    0x00F84:   9,  # TIBETAN MARK HALANTA
    0x00F86: 230,  # TIBETAN SIGN LCI RTAGS
    0x00F87: 230,  # TIBETAN SIGN YANG RTAGS
    0x00FC6: 220,  # TIBETAN SYMBOL PADMA GDAN
    0x01037:   7,  # MYANMAR SIGN DOT BELOW
    0x01039:   9,  # MYANMAR SIGN VIRAMA
    0x0103A:   9,  # MYANMAR SIGN ASAT
    0x0108D: 220,  # MYANMAR SIGN SHAN COUNCIL EMPHATIC TONE
    0x0135D: 230,  # ETHIOPIC COMBINING GEMINATION AND VOWEL LENGTH MARK
    0x0135E: 230,  # ETHIOPIC COMBINING VOWEL LENGTH MARK
    0x0135F: 230,  # ETHIOPIC COMBINING GEMINATION MARK
    0x01714:   9,  # TAGALOG SIGN VIRAMA
    0x01715:   9,  # TAGALOG SIGN PAMUDPOD
    0x01734:   9,  # HANUNOO SIGN PAMUDPOD
    0x017D2:   9,  # KHMER SIGN COENG
    0x017DD: 230,  # KHMER SIGN ATTHACAN
    0x018A9: 228,  # MONGOLIAN LETTER ALI GALI DAGALGA
    0x01939: 222,  # LIMBU SIGN MUKPHRENG
    0x0193A: 230,  # LIMBU SIGN KEMPHRENG
    0x0193B: 220,  # LIMBU SIGN SA-I
    0x01A17: 230,  # BUGINESE VOWEL SIGN I
    0x01A18: 220,  # BUGINESE VOWEL SIGN U
    0x01A60:   9,  # TAI THAM SIGN SAKOT
    0x01A75: 230,  # TAI THAM SIGN TONE-1
    0x01A76: 230,  # TAI THAM SIGN TONE-2
    0x01A77: 230,  # TAI THAM SIGN KHUEN TONE-3
    0x01A78: 230,  # TAI THAM SIGN KHUEN TONE-4
    0x01A79: 230,  # TAI THAM SIGN KHUEN TONE-5
    0x01A7A: 230,  # TAI THAM SIGN RA HAAM
    0x01A7B: 230,  # TAI THAM SIGN MAI SAM
    0x01A7C: 230,  # TAI THAM SIGN KHUEN-LUE KARAN
    0x01A7F: 220,  # TAI THAM COMBINING CRYPTOGRAMMIC DOT
    0x01AB0: 230,  # COMBINING DOUBLED CIRCUMFLEX ACCENT
    0x01AB1: 230,  # COMBINING DIAERESIS-RING
    0x01AB2: 230,  # COMBINING INFINITY
    0x01AB3: 230,  # COMBINING DOWNWARDS ARROW
    0x01AB4: 230,  # COMBINING TRIPLE DOT
    0x01AB5: 220,  # COMBINING X-X BELOW
    0x01AB6: 220,  # COMBINING WIGGLY LINE BELOW
    0x01AB7: 220,  # COMBINING OPEN MARK BELOW
    0x01AB8: 220,  # COMBINING DOUBLE OPEN MARK BELOW
    0x01AB9: 220,  # COMBINING LIGHT CENTRALIZATION STROKE BELOW
    0x01ABA: 220,  # COMBINING STRONG CENTRALIZATION STROKE BELOW
    0x01ABB: 230,  # COMBINING PARENTHESES ABOVE
    0x01ABC: 230,  # COMBINING DOUBLE PARENTHESES ABOVE
    0x01ABD: 220,  # COMBINING PARENTHESES BELOW
    0x01ABF: 220,  # COMBINING LATIN SMALL LETTER W BELOW
    0x01AC0: 220,  # COMBINING LATIN SMALL LETTER TURNED W BELOW
    0x01AC1: 230,  # COMBINING LEFT PARENTHESIS ABOVE LEFT
    0x01AC2: 230,  # COMBINING RIGHT PARENTHESIS ABOVE RIGHT
    0x01AC3: 220,  # COMBINING LEFT PARENTHESIS BELOW LEFT
    0x01AC4: 220,  # COMBINING RIGHT PARENTHESIS BELOW RIGHT
    0x01AC5: 230,  # COMBINING SQUARE BRACKETS ABOVE
    0x01AC6: 230,  # COMBINING NUMBER SIGN ABOVE
    0x01AC7: 230,  # COMBINING INVERTED DOUBLE ARCH ABOVE
    0x01AC8: 230,  # COMBINING PLUS SIGN ABOVE
    0x01AC9: 230,  # COMBINING DOUBLE PLUS SIGN ABOVE
    0x01ACA: 220,  # COMBINING DOUBLE PLUS SIGN BELOW
    0x01ACB: 230,  # COMBINING TRIPLE ACUTE ACCENT
    0x01ACC: 230,  # COMBINING LATIN SMALL LETTER INSULAR G
    0x01ACD: 230,  # COMBINING LATIN SMALL LETTER INSULAR R
    0x01ACE: 230,  # COMBINING LATIN SMALL LETTER INSULAR T
    0x01B34:   7,  # BALINESE SIGN REREKAN
    0x01B44:   9,  # BALINESE ADEG ADEG
    0x01B6B: 230,  # BALINESE MUSICAL SYMBOL COMBINING TEGEH
    0x01B6C: 220,  # BALINESE MUSICAL SYMBOL COMBINING ENDEP
    0x01B6D: 230,  # BALINESE MUSICAL SYMBOL COMBINING KEMPUL
    0x01B6E: 230,  # BALINESE MUSICAL SYMBOL COMBINING KEMPLI
    0x01B6F: 230,  # BALINESE MUSICAL SYMBOL COMBINING JEGOGAN
    0x01B70: 230,  # BALINESE MUSICAL SYMBOL COMBINING KEMPUL WITH JEGOGAN
    0x01B71: 230,  # BALINESE MUSICAL SYMBOL COMBINING KEMPLI WITH JEGOGAN
    0x01B72: 230,  # BALINESE MUSICAL SYMBOL COMBINING BENDE
    0x01B73: 230,  # BALINESE MUSICAL SYMBOL COMBINING GONG
    0x01BAA:   9,  # SUNDANESE SIGN PAMAAEH
    0x01BAB:   9,  # SUNDANESE SIGN VIRAMA
    0x01BE6:   7,  # BATAK SIGN TOMPI
    0x01BF2:   9,  # BATAK PANGOLAT
    0x01BF3:   9,  # BATAK PANONGONAN
    0x01C37:   7,  # LEPCHA SIGN NUKTA
    0x01CD0: 230,  # VEDIC TONE KARSHANA
    0x01CD1: 230,  # VEDIC TONE SHARA
    0x01CD2: 230,  # VEDIC TONE PRENKHA
    0x01CD4:   1,  # VEDIC SIGN YAJURVEDIC MIDLINE SVARITA
    0x01CD5: 220,  # VEDIC TONE YAJURVEDIC AGGRAVATED INDEPENDENT SVARITA
    0x01CD6: 220,  # VEDIC TONE YAJURVEDIC INDEPENDENT SVARITA
    0x01CD7: 220,  # VEDIC TONE YAJURVEDIC KATHAKA INDEPENDENT SVARITA
    0x01CD8: 220,  # VEDIC TONE CANDRA BELOW
    0x01CD9: 220,  # VEDIC TONE YAJURVEDIC KATHAKA INDEPENDENT SVARITA SCHROEDER
    0x01CDA: 230,  # VEDIC TONE DOUBLE SVARITA
    0x01CDB: 230,  # VEDIC TONE TRIPLE SVARITA
    0x01CDC: 220,  # VEDIC TONE KATHAKA ANUDATTA
    0x01CDD: 220,  # VEDIC TONE DOT BELOW
    0x01CDE: 220,  # VEDIC TONE TWO DOTS BELOW
    0x01CDF: 220,  # VEDIC TONE THREE DOTS BELOW
    0x01CE0: 230,  # VEDIC TONE RIGVEDIC KASHMIRI INDEPENDENT SVARITA
    0x01CE2:   1,  # VEDIC SIGN VISARGA SVARITA
    0x01CE3:   1,  # VEDIC SIGN VISARGA UDATTA
    0x01CE4:   1,  # VEDIC SIGN REVERSED VISARGA UDATTA
    0x01CE5:   1,  # VEDIC SIGN VISARGA ANUDATTA
    0x01CE6:   1,  # VEDIC SIGN REVERSED VISARGA ANUDATTA
    0x01CE7:   1,  # VEDIC SIGN VISARGA UDATTA WITH TAIL
    0x01CE8:   1,  # VEDIC SIGN VISARGA ANUDATTA WITH TAIL
    0x01CED: 220,  # VEDIC SIGN TIRYAK
    0x01CF4: 230,  # VEDIC TONE CANDRA ABOVE
    0x01CF8: 230,  # VEDIC TONE RING ABOVE
    0x01CF9: 230,  # VEDIC TONE DOUBLE RING ABOVE
    0x01DC0: 230,  # COMBINING DOTTED GRAVE ACCENT
    0x01DC1: 230,  # COMBINING DOTTED ACUTE ACCENT
    0x01DC2: 220,  # COMBINING SNAKE BELOW
    0x01DC3: 230,  # COMBINING SUSPENSION MARK
    0x01DC4: 230,  # COMBINING MACRON-ACUTE
    0x01DC5: 230,  # COMBINING GRAVE-MACRON
    0x01DC6: 230,  # COMBINING MACRON-GRAVE
    0x01DC7: 230,  # COMBINING ACUTE-MACRON
    0x01DC8: 230,  # COMBINING GRAVE-ACUTE-GRAVE
    0x01DC9: 230,  # COMBINING ACUTE-GRAVE-ACUTE
    0x01DCA: 220,  # COMBINING LATIN SMALL LETTER R BELOW
    0x01DCB: 230,  # COMBINING BREVE-MACRON
    0x01DCC: 230,  # COMBINING MACRON-BREVE
    0x01DCD: 234,  # COMBINING DOUBLE CIRCUMFLEX ABOVE
    0x01DCE: 214,  # COMBINING OGONEK ABOVE
    0x01DCF: 220,  # COMBINING ZIGZAG BELOW
    0x01DD0: 202,  # COMBINING IS BELOW
    0x01DD1: 230,  # COMBINING UR ABOVE
    0x01DD2: 230,  # COMBINING US ABOVE
    0x01DD3: 230,  # COMBINING LATIN SMALL LETTER FLATTENED OPEN A ABOVE
    0x01DD4: 230,  # COMBINING LATIN SMALL LETTER AE
    0x01DD5: 230,  # COMBINING LATIN SMALL LETTER AO
    0x01DD6: 230,  # COMBINING LATIN SMALL LETTER AV
    0x01DD7: 230,  # COMBINING LATIN SMALL LETTER C CEDILLA
    0x01DD8: 230,  # COMBINING LATIN SMALL LETTER INSULAR D
    0x01DD9: 230,  # COMBINING LATIN SMALL LETTER ETH
    0x01DDA: 230,  # COMBINING LATIN SMALL LETTER G
    0x01DDB: 230,  # COMBINING LATIN LETTER SMALL CAPITAL G
    0x01DDC: 230,  # COMBINING LATIN SMALL LETTER K
    0x01DDD: 230,  # COMBINING LATIN SMALL LETTER L
    0x01DDE: 230,  # COMBINING LATIN LETTER SMALL CAPITAL L
    0x01DDF: 230,  # COMBINING LATIN LETTER SMALL CAPITAL M
    0x01DE0: 230,  # COMBINING LATIN SMALL LETTER N
    0x01DE1: 230,  # COMBINING LATIN LETTER SMALL CAPITAL N
    0x01DE2: 230,  # COMBINING LATIN LETTER SMALL CAPITAL R
    0x01DE3: 230,  # COMBINING LATIN SMALL LETTER R ROTUNDA
    0x01DE4: 230,  # COMBINING LATIN SMALL LETTER S
    0x01DE5: 230,  # COMBINING LATIN SMALL LETTER LONG S
    0x01DE6: 230,  # COMBINING LATIN SMALL LETTER Z
    0x01DE7: 230,  # COMBINING LATIN SMALL LETTER ALPHA
    0x01DE8: 230,  # COMBINING LATIN SMALL LETTER B
    0x01DE9: 230,  # COMBINING LATIN SMALL LETTER BETA
    0x01DEA: 230,  # COMBINING LATIN SMALL LETTER SCHWA
    0x01DEB: 230,  # COMBINING LATIN SMALL LETTER F
    0x01DEC: 230,  # COMBINING LATIN SMALL LETTER L WITH DOUBLE MIDDLE TILDE
    0x01DED: 230,  # COMBINING LATIN SMALL LETTER O WITH LIGHT CENTRALIZATION STROKE
    0x01DEE: 230,  # COMBINING LATIN SMALL LETTER P
    0x01DEF: 230,  # COMBINING LATIN SMALL LETTER ESH
    0x01DF0: 230,  # COMBINING LATIN SMALL LETTER U WITH LIGHT CENTRALIZATION STROKE
    0x01DF1: 230,  # COMBINING LATIN SMALL LETTER W
    0x01DF2: 230,  # COMBINING LATIN SMALL LETTER A WITH DIAERESIS
    0x01DF3: 230,  # COMBINING LATIN SMALL LETTER O WITH DIAERESIS
    0x01DF4: 230,  # COMBINING LATIN SMALL LETTER U WITH DIAERESIS
    0x01DF5: 230,  # COMBINING UP TACK ABOVE
    0x01DF6: 232,  # COMBINING KAVYKA ABOVE RIGHT
    0x01DF7: 228,  # COMBINING KAVYKA ABOVE LEFT
    0x01DF8: 228,  # COMBINING DOT ABOVE LEFT
    0x01DF9: 220,  # COMBINING WIDE INVERTED BRIDGE BELOW
    0x01DFA: 218,  # COMBINING DOT BELOW LEFT
    0x01DFB: 230,  # COMBINING DELETION MARK
    0x01DFC: 233,  # COMBINING DOUBLE INVERTED BREVE BELOW
    0x01DFD: 220,  # COMBINING ALMOST EQUAL TO BELOW
    0x01DFE: 230,  # COMBINING LEFT ARROWHEAD ABOVE
    0x01DFF: 220,  # COMBINING RIGHT ARROWHEAD AND DOWN ARROWHEAD BELOW
    0x020D0: 230,  # COMBINING LEFT HARPOON ABOVE
    0x020D1: 230,  # COMBINING RIGHT HARPOON ABOVE
    0x020D2:   1,  # COMBINING LONG VERTICAL LINE OVERLAY
    0x020D3:   1,  # COMBINING SHORT VERTICAL LINE OVERLAY
    0x020D4: 230,  # COMBINING ANTICLOCKWISE ARROW ABOVE
    0x020D5: 230,  # COMBINING CLOCKWISE ARROW ABOVE
    0x020D6: 230,  # COMBINING LEFT ARROW ABOVE
    0x020D7: 230,  # COMBINING RIGHT ARROW ABOVE
    0x020D8:   1,  # COMBINING RING OVERLAY
    0x020D9:   1,  # COMBINING CLOCKWISE RING OVERLAY
    0x020DA:   1,  # COMBINING ANTICLOCKWISE RING OVERLAY
    0x020DB: 230,  # COMBINING THREE DOTS ABOVE
    0x020DC: 230,  # COMBINING FOUR DOTS ABOVE
    0x020E1: 230,  # COMBINING LEFT RIGHT ARROW ABOVE
    0x020E5:   1,  # COMBINING REVERSE SOLIDUS OVERLAY
    0x020E6:   1,  # COMBINING DOUBLE VERTICAL STROKE OVERLAY
    0x020E7: 230,  # COMBINING ANNUITY SYMBOL
    0x020E8: 220,  # COMBINING TRIPLE UNDERDOT
    0x020E9: 230,  # COMBINING WIDE BRIDGE ABOVE
    0x020EA:   1,  # COMBINING LEFTWARDS ARROW OVERLAY
    0x020EB:   1,  # COMBINING LONG DOUBLE SOLIDUS OVERLAY
    0x020EC: 220,  # COMBINING RIGHTWARDS HARPOON WITH BARB DOWNWARDS
    0x020ED: 220,  # COMBINING LEFTWARDS HARPOON WITH BARB DOWNWARDS
    0x020EE: 220,  # COMBINING LEFT ARROW BELOW
    0x020EF: 220,  # COMBINING RIGHT ARROW BELOW
    0x020F0: 230,  # COMBINING ASTERISK ABOVE
    0x02CEF: 230,  # COPTIC COMBINING NI ABOVE
    0x02CF0: 230,  # COPTIC COMBINING SPIRITUS ASPER
    0x02CF1: 230,  # COPTIC COMBINING SPIRITUS LENIS
    0x02D7F:   9,  # TIFINAGH CONSONANT JOINER
    0x02DE0: 230,  # COMBINING CYRILLIC LETTER BE
    0x02DE1: 230,  # COMBINING CYRILLIC LETTER VE
    0x02DE2: 230,  # COMBINING CYRILLIC LETTER GHE
    0x02DE3: 230,  # COMBINING CYRILLIC LETTER DE
    0x02DE4: 230,  # COMBINING CYRILLIC LETTER ZHE
    0x02DE5: 230,  # COMBINING CYRILLIC LETTER ZE
    0x02DE6: 230,  # COMBINING CYRILLIC LETTER KA
    0x02DE7: 230,  # COMBINING CYRILLIC LETTER EL
    0x02DE8: 230,  # COMBINING CYRILLIC LETTER EM
    0x02DE9: 230,  # COMBINING CYRILLIC LETTER EN
    0x02DEA: 230,  # COMBINING CYRILLIC LETTER O
    0x02DEB: 230,  # COMBINING CYRILLIC LETTER PE
    0x02DEC: 230,  # COMBINING CYRILLIC LETTER ER
    0x02DED: 230,  # COMBINING CYRILLIC LETTER ES
    0x02DEE: 230,  # COMBINING CYRILLIC LETTER TE
    0x02DEF: 230,  # COMBINING CYRILLIC LETTER HA
    0x02DF0: 230,  # COMBINING CYRILLIC LETTER TSE
    0x02DF1: 230,  # COMBINING CYRILLIC LETTER CHE
    0x02DF2: 230,  # COMBINING CYRILLIC LETTER SHA
    0x02DF3: 230,  # COMBINING CYRILLIC LETTER SHCHA
    0x02DF4: 230,  # COMBINING CYRILLIC LETTER FITA
    0x02DF5: 230,  # COMBINING CYRILLIC LETTER ES-TE
    0x02DF6: 230,  # COMBINING CYRILLIC LETTER A
    0x02DF7: 230,  # COMBINING CYRILLIC LETTER IE
    0x02DF8: 230,  # COMBINING CYRILLIC LETTER DJERV
    0x02DF9: 230,  # COMBINING CYRILLIC LETTER MONOGRAPH UK
    0x02DFA: 230,  # COMBINING CYRILLIC LETTER YAT
    0x02DFB: 230,  # COMBINING CYRILLIC LETTER YU
    0x02DFC: 230,  # COMBINING CYRILLIC LETTER IOTIFIED A
    0x02DFD: 230,  # COMBINING CYRILLIC LETTER LITTLE YUS
    0x02DFE: 230,  # COMBINING CYRILLIC LETTER BIG YUS
    0x02DFF: 230,  # COMBINING CYRILLIC LETTER IOTIFIED BIG YUS
    0x0302A: 218,  # IDEOGRAPHIC LEVEL TONE MARK
    0x0302B: 228,  # IDEOGRAPHIC RISING TONE MARK
    0x0302C: 232,  # IDEOGRAPHIC DEPARTING TONE MARK
    0x0302D: 222,  # IDEOGRAPHIC ENTERING TONE MARK
    0x0302E: 224,  # HANGUL SINGLE DOT TONE MARK
    0x0302F: 224,  # HANGUL DOUBLE DOT TONE MARK
    0x03099:   8,  # COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK
    0x0309A:   8,  # COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
    0x0A66F: 230,  # COMBINING CYRILLIC VZMET
    0x0A674: 230,  # COMBINING CYRILLIC LETTER UKRAINIAN IE
    0x0A675: 230,  # COMBINING CYRILLIC LETTER I
    0x0A676: 230,  # COMBINING CYRILLIC LETTER YI
    0x0A677: 230,  # COMBINING CYRILLIC LETTER U
    0x0A678: 230,  # COMBINING CYRILLIC LETTER HARD SIGN
    0x0A679: 230,  # COMBINING CYRILLIC LETTER YERU
    0x0A67A: 230,  # COMBINING CYRILLIC LETTER SOFT SIGN
    0x0A67B: 230,  # COMBINING CYRILLIC LETTER OMEGA
    0x0A67C: 230,  # COMBINING CYRILLIC KAVYKA
    0x0A67D: 230,  # COMBINING CYRILLIC PAYEROK
    0x0A69E: 230,  # COMBINING CYRILLIC LETTER EF
    0x0A69F: 230,  # COMBINING CYRILLIC LETTER IOTIFIED E
    0x0A6F0: 230,  # BAMUM COMBINING MARK KOQNDON
    0x0A6F1: 230,  # BAMUM COMBINING MARK TUKWENTIS
    0x0A806:   9,  # SYLOTI NAGRI SIGN HASANTA
    0x0A82C:   9,  # SYLOTI NAGRI SIGN ALTERNATE HASANTA
    0x0A8C4:   9,  # SAURASHTRA SIGN VIRAMA
    0x0A8E0: 230,  # COMBINING DEVANAGARI DIGIT ZERO
    0x0A8E1: 230,  # COMBINING DEVANAGARI DIGIT ONE
    0x0A8E2: 230,  # COMBINING DEVANAGARI DIGIT TWO
    0x0A8E3: 230,  # COMBINING DEVANAGARI DIGIT THREE
    0x0A8E4: 230,  # COMBINING DEVANAGARI DIGIT FOUR
    0x0A8E5: 230,  # COMBINING DEVANAGARI DIGIT FIVE
    0x0A8E6: 230,  # COMBINING DEVANAGARI DIGIT SIX
    0x0A8E7: 230,  # COMBINING DEVANAGARI DIGIT SEVEN
    0x0A8E8: 230,  # COMBINING DEVANAGARI DIGIT EIGHT
    0x0A8E9: 230,  # COMBINING DEVANAGARI DIGIT NINE
    0x0A8EA: 230,  # COMBINING DEVANAGARI LETTER A
    0x0A8EB: 230,  # COMBINING DEVANAGARI LETTER U
    0x0A8EC: 230,  # COMBINING DEVANAGARI LETTER KA
    0x0A8ED: 230,  # COMBINING DEVANAGARI LETTER NA
    0x0A8EE: 230,  # COMBINING DEVANAGARI LETTER PA
    0x0A8EF: 230,  # COMBINING DEVANAGARI LETTER RA
    0x0A8F0: 230,  # COMBINING DEVANAGARI LETTER VI
    0x0A8F1: 230,  # COMBINING DEVANAGARI SIGN AVAGRAHA
    0x0A92B: 220,  # KAYAH LI TONE PLOPHU
    0x0A92C: 220,  # KAYAH LI TONE CALYA
    0x0A92D: 220,  # KAYAH LI TONE CALYA PLOPHU
    0x0A953:   9,  # REJANG VIRAMA
    0x0A9B3:   7,  # JAVANESE SIGN CECAK TELU
    0x0A9C0:   9,  # JAVANESE PANGKON
    0x0AAB0: 230,  # TAI VIET MAI KANG
    0x0AAB2: 230,  # TAI VIET VOWEL I
    0x0AAB3: 230,  # TAI VIET VOWEL UE
    0x0AAB4: 220,  # TAI VIET VOWEL U
    0x0AAB7: 230,  # TAI VIET MAI KHIT
    0x0AAB8: 230,  # TAI VIET VOWEL IA
    0x0AABE: 230,  # TAI VIET VOWEL AM
    0x0AABF: 230,  # TAI VIET TONE MAI EK
    0x0AAC1: 230,  # TAI VIET TONE MAI THO
    0x0AAF6:   9,  # MEETEI MAYEK VIRAMA
    0x0ABED:   9,  # MEETEI MAYEK APUN IYEK
    0x0FB1E:  26,  # HEBREW POINT JUDEO-SPANISH VARIKA
    0x0FE20: 230,  # COMBINING LIGATURE LEFT HALF
    0x0FE21: 230,  # COMBINING LIGATURE RIGHT HALF
    0x0FE22: 230,  # COMBINING DOUBLE TILDE LEFT HALF
    0x0FE23: 230,  # COMBINING DOUBLE TILDE RIGHT HALF
    0x0FE24: 230,  # COMBINING MACRON LEFT HALF
    0x0FE25: 230,  # COMBINING MACRON RIGHT HALF
    0x0FE26: 230,  # COMBINING CONJOINING MACRON
    0x0FE27: 220,  # COMBINING LIGATURE LEFT HALF BELOW
    0x0FE28: 220,  # COMBINING LIGATURE RIGHT HALF BELOW
    0x0FE29: 220,  # COMBINING TILDE LEFT HALF BELOW
    0x0FE2A: 220,  # COMBINING TILDE RIGHT HALF BELOW
    0x0FE2B: 220,  # COMBINING MACRON LEFT HALF BELOW
    0x0FE2C: 220,  # COMBINING MACRON RIGHT HALF BELOW
    0x0FE2D: 220,  # COMBINING CONJOINING MACRON BELOW
    0x0FE2E: 230,  # COMBINING CYRILLIC TITLO LEFT HALF
    0x0FE2F: 230,  # COMBINING CYRILLIC TITLO RIGHT HALF
    0x101FD: 220,  # PHAISTOS DISC SIGN COMBINING OBLIQUE STROKE
    0x102E0: 220,  # COPTIC EPACT THOUSANDS MARK
    0x10376: 230,  # COMBINING OLD PERMIC LETTER AN
    0x10377: 230,  # COMBINING OLD PERMIC LETTER DOI
    0x10378: 230,  # COMBINING OLD PERMIC LETTER ZATA
    0x10379: 230,  # COMBINING OLD PERMIC LETTER NENOE
    0x1037A: 230,  # COMBINING OLD PERMIC LETTER SII
    0x10A0D: 220,  # KHAROSHTHI SIGN DOUBLE RING BELOW
    0x10A0F: 230,  # KHAROSHTHI SIGN VISARGA
    0x10A38: 230,  # KHAROSHTHI SIGN BAR ABOVE
    0x10A39:   1,  # KHAROSHTHI SIGN CAUDA
    0x10A3A: 220,  # KHAROSHTHI SIGN DOT BELOW
    0x10A3F:   9,  # KHAROSHTHI VIRAMA
    0x10AE5: 230,  # MANICHAEAN ABBREVIATION MARK ABOVE
    0x10AE6: 220,  # MANICHAEAN ABBREVIATION MARK BELOW
    0x10D24: 230,  # HANIFI ROHINGYA SIGN HARBAHAY
    0x10D25: 230,  # HANIFI ROHINGYA SIGN TAHALA
    0x10D26: 230,  # HANIFI ROHINGYA SIGN TANA
    0x10D27: 230,  # HANIFI ROHINGYA SIGN TASSI
    0x10EAB: 230,  # YEZIDI COMBINING HAMZA MARK
    0x10EAC: 230,  # YEZIDI COMBINING MADDA MARK
    0x10EFD: 220,  # ARABIC SMALL LOW WORD SAKTA
    0x10EFE: 220,  # ARABIC SMALL LOW WORD QASR
    0x10EFF: 220,  # ARABIC SMALL LOW WORD MADDA
    0x10F46: 220,  # SOGDIAN COMBINING DOT BELOW
    0x10F47: 220,  # SOGDIAN COMBINING TWO DOTS BELOW
    0x10F48: 230,  # SOGDIAN COMBINING DOT ABOVE
    0x10F49: 230,  # SOGDIAN COMBINING TWO DOTS ABOVE
    0x10F4A: 230,  # SOGDIAN COMBINING CURVE ABOVE
    0x10F4B: 220,  # SOGDIAN COMBINING CURVE BELOW
    0x10F4C: 230,  # SOGDIAN COMBINING HOOK ABOVE
    0x10F4D: 220,  # SOGDIAN COMBINING HOOK BELOW
    0x10F4E: 220,  # SOGDIAN COMBINING LONG HOOK BELOW
    0x10F4F: 220,  # SOGDIAN COMBINING RESH BELOW
    0x10F50: 220,  # SOGDIAN COMBINING STROKE BELOW
    0x10F82: 230,  # OLD UYGHUR COMBINING DOT ABOVE
    0x10F83: 220,  # OLD UYGHUR COMBINING DOT BELOW
    0x10F84: 230,  # OLD UYGHUR COMBINING TWO DOTS ABOVE
    0x10F85: 220,  # OLD UYGHUR COMBINING TWO DOTS BELOW
    0x11046:   9,  # BRAHMI VIRAMA
    0x11070:   9,  # BRAHMI SIGN OLD TAMIL VIRAMA
    0x1107F:   9,  # BRAHMI NUMBER JOINER
    0x110B9:   9,  # KAITHI SIGN VIRAMA
    0x110BA:   7,  # KAITHI SIGN NUKTA
    0x11100: 230,  # CHAKMA SIGN CANDRABINDU
    0x11101: 230,  # CHAKMA SIGN ANUSVARA
    0x11102: 230,  # CHAKMA SIGN VISARGA
    0x11133:   9,  # CHAKMA VIRAMA
    0x11134:   9,  # CHAKMA MAAYYAA
    0x11173:   7,  # MAHAJANI SIGN NUKTA
    0x111C0:   9,  # SHARADA SIGN VIRAMA
    0x111CA:   7,  # SHARADA SIGN NUKTA
    0x11235:   9,  # KHOJKI SIGN VIRAMA
    0x11236:   7,  # KHOJKI SIGN NUKTA
    0x112E9:   7,  # KHUDAWADI SIGN NUKTA
    0x112EA:   9,  # KHUDAWADI SIGN VIRAMA
    0x1133B:   7,  # COMBINING BINDU BELOW
    0x1133C:   7,  # GRANTHA SIGN NUKTA
    0x1134D:   9,  # GRANTHA SIGN VIRAMA
    0x11366: 230,  # COMBINING GRANTHA DIGIT ZERO
    0x11367: 230,  # COMBINING GRANTHA DIGIT ONE
    0x11368: 230,  # COMBINING GRANTHA DIGIT TWO
    0x11369: 230,  # COMBINING GRANTHA DIGIT THREE
    0x1136A: 230,  # COMBINING GRANTHA DIGIT FOUR
    0x1136B: 230,  # COMBINING GRANTHA DIGIT FIVE
    0x1136C: 230,  # COMBINING GRANTHA DIGIT SIX
    0x11370: 230,  # COMBINING GRANTHA LETTER A
    0x11371: 230,  # COMBINING GRANTHA LETTER KA
    0x11372: 230,  # COMBINING GRANTHA LETTER NA
    0x11373: 230,  # COMBINING GRANTHA LETTER VI
    0x11374: 230,  # COMBINING GRANTHA LETTER PA
    0x11442:   9,  # NEWA SIGN VIRAMA
    0x11446:   7,  # NEWA SIGN NUKTA
    0x1145E: 230,  # NEWA SANDHI MARK
    0x114C2:   9,  # TIRHUTA SIGN VIRAMA
    0x114C3:   7,  # TIRHUTA SIGN NUKTA
    0x115BF:   9,  # SIDDHAM SIGN VIRAMA
    0x115C0:   7,  # SIDDHAM SIGN NUKTA
    0x1163F:   9,  # MODI SIGN VIRAMA
    0x116B6:   9,  # TAKRI SIGN VIRAMA
    0x116B7:   7,  # TAKRI SIGN NUKTA
    0x1172B:   9,  # AHOM SIGN KILLER
    0x11839:   9,  # DOGRA SIGN VIRAMA
    0x1183A:   7,  # DOGRA SIGN NUKTA
    0x1193D:   9,  # DIVES AKURU SIGN HALANTA
    0x1193E:   9,  # DIVES AKURU VIRAMA
    0x11943:   7,  # DIVES AKURU SIGN NUKTA
    0x119E0:   9,  # NANDINAGARI SIGN VIRAMA
    0x11A34:   9,  # ZANABAZAR SQUARE SIGN VIRAMA
    0x11A47:   9,  # ZANABAZAR SQUARE SUBJOINER
    0x11A99:   9,  # SOYOMBO SUBJOINER
    0x11C3F:   9,  # BHAIKSUKI SIGN VIRAMA
    0x11D42:   7,  # MASARAM GONDI SIGN NUKTA
    0x11D44:   9,  # MASARAM GONDI SIGN HALANTA
    0x11D45:   9,  # MASARAM GONDI VIRAMA
    0x11D97:   9,  # GUNJALA GONDI VIRAMA
    0x11F41:   9,  # KAWI SIGN KILLER
    0x11F42:   9,  # KAWI CONJOINER
    0x16AF0:   1,  # BASSA VAH COMBINING HIGH TONE
    0x16AF1:   1,  # BASSA VAH COMBINING LOW TONE
    0x16AF2:   1,  # BASSA VAH COMBINING MID TONE
    0x16AF3:   1,  # BASSA VAH COMBINING LOW-MID TONE
    0x16AF4:   1,  # BASSA VAH COMBINING HIGH-LOW TONE
    0x16B30: 230,  # PAHAWH HMONG MARK CIM TUB
    0x16B31: 230,  # PAHAWH HMONG MARK CIM SO
    0x16B32: 230,  # PAHAWH HMONG MARK CIM KES
    0x16B33: 230,  # PAHAWH HMONG MARK CIM KHAV
    0x16B34: 230,  # PAHAWH HMONG MARK CIM SUAM
    0x16B35: 230,  # PAHAWH HMONG MARK CIM HOM
    0x16B36: 230,  # PAHAWH HMONG MARK CIM TAUM
    0x16FF0:   6,  # VIETNAMESE ALTERNATE READING MARK CA
    0x16FF1:   6,  # VIETNAMESE ALTERNATE READING MARK NHAY
    0x1BC9E:   1,  # DUPLOYAN DOUBLE MARK
    0x1D165: 216,  # MUSICAL SYMBOL COMBINING STEM
    0x1D166: 216,  # MUSICAL SYMBOL COMBINING SPRECHGESANG STEM
    0x1D167:   1,  # MUSICAL SYMBOL COMBINING TREMOLO-1
    0x1D168:   1,  # MUSICAL SYMBOL COMBINING TREMOLO-2
    0x1D169:   1,  # MUSICAL SYMBOL COMBINING TREMOLO-3
    0x1D16D: 226,  # MUSICAL SYMBOL COMBINING AUGMENTATION DOT
    0x1D16E: 216,  # MUSICAL SYMBOL COMBINING FLAG-1
    0x1D16F: 216,  # MUSICAL SYMBOL COMBINING FLAG-2
    0x1D170: 216,  # MUSICAL SYMBOL COMBINING FLAG-3
    0x1D171: 216,  # MUSICAL SYMBOL COMBINING FLAG-4
    0x1D172: 216,  # MUSICAL SYMBOL COMBINING FLAG-5
    0x1D17B: 220,  # MUSICAL SYMBOL COMBINING ACCENT
    0x1D17C: 220,  # MUSICAL SYMBOL COMBINING STACCATO
    0x1D17D: 220,  # MUSICAL SYMBOL COMBINING TENUTO
    0x1D17E: 220,  # MUSICAL SYMBOL COMBINING STACCATISSIMO
    0x1D17F: 220,  # MUSICAL SYMBOL COMBINING MARCATO
    0x1D180: 220,  # MUSICAL SYMBOL COMBINING MARCATO-STACCATO
    0x1D181: 220,  # MUSICAL SYMBOL COMBINING ACCENT-STACCATO
    0x1D182: 220,  # MUSICAL SYMBOL COMBINING LOURE
    0x1D185: 230,  # MUSICAL SYMBOL COMBINING DOIT
    0x1D186: 230,  # MUSICAL SYMBOL COMBINING RIP
    0x1D187: 230,  # MUSICAL SYMBOL COMBINING FLIP
    0x1D188: 230,  # MUSICAL SYMBOL COMBINING SMEAR
    0x1D189: 230,  # MUSICAL SYMBOL COMBINING BEND
    0x1D18A: 220,  # MUSICAL SYMBOL COMBINING DOUBLE TONGUE
    0x1D18B: 220,  # MUSICAL SYMBOL COMBINING TRIPLE TONGUE
    0x1D1AA: 230,  # MUSICAL SYMBOL COMBINING DOWN BOW
    0x1D1AB: 230,  # MUSICAL SYMBOL COMBINING UP BOW
    0x1D1AC: 230,  # MUSICAL SYMBOL COMBINING HARMONIC
    0x1D1AD: 230,  # MUSICAL SYMBOL COMBINING SNAP PIZZICATO
    0x1D242: 230,  # COMBINING GREEK MUSICAL TRISEME
    0x1D243: 230,  # COMBINING GREEK MUSICAL TETRASEME
    0x1D244: 230,  # COMBINING GREEK MUSICAL PENTASEME
    0x1E000: 230,  # COMBINING GLAGOLITIC LETTER AZU
    0x1E001: 230,  # COMBINING GLAGOLITIC LETTER BUKY
    0x1E002: 230,  # COMBINING GLAGOLITIC LETTER VEDE
    0x1E003: 230,  # COMBINING GLAGOLITIC LETTER GLAGOLI
    0x1E004: 230,  # COMBINING GLAGOLITIC LETTER DOBRO
    0x1E005: 230,  # COMBINING GLAGOLITIC LETTER YESTU
    0x1E006: 230,  # COMBINING GLAGOLITIC LETTER ZHIVETE
    0x1E008: 230,  # COMBINING GLAGOLITIC LETTER ZEMLJA
    0x1E009: 230,  # COMBINING GLAGOLITIC LETTER IZHE
    0x1E00A: 230,  # COMBINING GLAGOLITIC LETTER INITIAL IZHE
    0x1E00B: 230,  # COMBINING GLAGOLITIC LETTER I
    0x1E00C: 230,  # COMBINING GLAGOLITIC LETTER DJERVI
    0x1E00D: 230,  # COMBINING GLAGOLITIC LETTER KAKO
    0x1E00E: 230,  # COMBINING GLAGOLITIC LETTER LJUDIJE
    0x1E00F: 230,  # COMBINING GLAGOLITIC LETTER MYSLITE
    0x1E010: 230,  # COMBINING GLAGOLITIC LETTER NASHI
    0x1E011: 230,  # COMBINING GLAGOLITIC LETTER ONU
    0x1E012: 230,  # COMBINING GLAGOLITIC LETTER POKOJI
    0x1E013: 230,  # COMBINING GLAGOLITIC LETTER RITSI
    0x1E014: 230,  # COMBINING GLAGOLITIC LETTER SLOVO
    0x1E015: 230,  # COMBINING GLAGOLITIC LETTER TVRIDO
    0x1E016: 230,  # COMBINING GLAGOLITIC LETTER UKU
    0x1E017: 230,  # COMBINING GLAGOLITIC LETTER FRITU
    0x1E018: 230,  # COMBINING GLAGOLITIC LETTER HERU
    0x1E01B: 230,  # COMBINING GLAGOLITIC LETTER SHTA
    0x1E01C: 230,  # COMBINING GLAGOLITIC LETTER TSI
    0x1E01D: 230,  # COMBINING GLAGOLITIC LETTER CHRIVI
    0x1E01E: 230,  # COMBINING GLAGOLITIC LETTER SHA
    0x1E01F: 230,  # COMBINING GLAGOLITIC LETTER YERU
    0x1E020: 230,  # COMBINING GLAGOLITIC LETTER YERI
    0x1E021: 230,  # COMBINING GLAGOLITIC LETTER YATI
    0x1E023: 230,  # COMBINING GLAGOLITIC LETTER YU
    0x1E024: 230,  # COMBINING GLAGOLITIC LETTER SMALL YUS
    0x1E026: 230,  # COMBINING GLAGOLITIC LETTER YO
    0x1E027: 230,  # COMBINING GLAGOLITIC LETTER IOTATED SMALL YUS
    0x1E028: 230,  # COMBINING GLAGOLITIC LETTER BIG YUS
    0x1E029: 230,  # COMBINING GLAGOLITIC LETTER IOTATED BIG YUS
    0x1E02A: 230,  # COMBINING GLAGOLITIC LETTER FITA
    0x1E08F: 230,  # COMBINING CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I
    0x1E130: 230,  # NYIAKENG PUACHUE HMONG TONE-B
    0x1E131: 230,  # NYIAKENG PUACHUE HMONG TONE-M
    0x1E132: 230,  # NYIAKENG PUACHUE HMONG TONE-J
    0x1E133: 230,  # NYIAKENG PUACHUE HMONG TONE-V
    0x1E134: 230,  # NYIAKENG PUACHUE HMONG TONE-S
    0x1E135: 230,  # NYIAKENG PUACHUE HMONG TONE-G
    0x1E136: 230,  # NYIAKENG PUACHUE HMONG TONE-D
    0x1E2AE: 230,  # TOTO SIGN RISING TONE
    0x1E2EC: 230,  # WANCHO TONE TUP
    0x1E2ED: 230,  # WANCHO TONE TUPNI
    0x1E2EE: 230,  # WANCHO TONE KOI
    0x1E2EF: 230,  # WANCHO TONE KOINI
    0x1E4EC: 232,  # NAG MUNDARI SIGN MUHOR
    0x1E4ED: 232,  # NAG MUNDARI SIGN TOYOR
    0x1E4EE: 220,  # NAG MUNDARI SIGN IKIR
    0x1E4EF: 230,  # NAG MUNDARI SIGN SUTUH
    0x1E8D0: 220,  # MENDE KIKAKUI COMBINING NUMBER TEENS
    0x1E8D1: 220,  # MENDE KIKAKUI COMBINING NUMBER TENS
    0x1E8D2: 220,  # MENDE KIKAKUI COMBINING NUMBER HUNDREDS
    0x1E8D3: 220,  # MENDE KIKAKUI COMBINING NUMBER THOUSANDS
    0x1E8D4: 220,  # MENDE KIKAKUI COMBINING NUMBER TEN THOUSANDS
    0x1E8D5: 220,  # MENDE KIKAKUI COMBINING NUMBER HUNDRED THOUSANDS
    0x1E8D6: 220,  # MENDE KIKAKUI COMBINING NUMBER MILLIONS
    0x1E944: 230,  # ADLAM ALIF LENGTHENER
    0x1E945: 230,  # ADLAM VOWEL LENGTHENER
    0x1E946: 230,  # ADLAM GEMINATION MARK
    0x1E947: 230,  # ADLAM HAMZA
    0x1E948: 230,  # ADLAM CONSONANT MODIFIER
    0x1E949: 230,  # ADLAM GEMINATE CONSONANT MODIFIER
    0x1E94A:   7,  # ADLAM NUKTA
}

# Composition exclusions
_COMP_EXCL = {
    0x00958,  # DEVANAGARI LETTER QA
    0x00959,  # DEVANAGARI LETTER KHHA
    0x0095A,  # DEVANAGARI LETTER GHHA
    0x0095B,  # DEVANAGARI LETTER ZA
    0x0095C,  # DEVANAGARI LETTER DDDHA
    0x0095D,  # DEVANAGARI LETTER RHA
    0x0095E,  # DEVANAGARI LETTER FA
    0x0095F,  # DEVANAGARI LETTER YYA
    0x009DC,  # BENGALI LETTER RRA
    0x009DD,  # BENGALI LETTER RHA
    0x009DF,  # BENGALI LETTER YYA
    0x00A33,  # GURMUKHI LETTER LLA
    0x00A36,  # GURMUKHI LETTER SHA
    0x00A59,  # GURMUKHI LETTER KHHA
    0x00A5A,  # GURMUKHI LETTER GHHA
    0x00A5B,  # GURMUKHI LETTER ZA
    0x00A5E,  # GURMUKHI LETTER FA
    0x00B5C,  # ORIYA LETTER RRA
    0x00B5D,  # ORIYA LETTER RHA
    0x00F43,  # TIBETAN LETTER GHA
    0x00F4D,  # TIBETAN LETTER DDHA
    0x00F52,  # TIBETAN LETTER DHA
    0x00F57,  # TIBETAN LETTER BHA
    0x00F5C,  # TIBETAN LETTER DZHA
    0x00F69,  # TIBETAN LETTER KSSA
    0x00F76,  # TIBETAN VOWEL SIGN VOCALIC R
    0x00F78,  # TIBETAN VOWEL SIGN VOCALIC L
    0x00F93,  # TIBETAN SUBJOINED LETTER GHA
    0x00F9D,  # TIBETAN SUBJOINED LETTER DDHA
    0x00FA2,  # TIBETAN SUBJOINED LETTER DHA
    0x00FA7,  # TIBETAN SUBJOINED LETTER BHA
    0x00FAC,  # TIBETAN SUBJOINED LETTER DZHA
    0x00FB9,  # TIBETAN SUBJOINED LETTER KSSA
    0x0FB1D,  # HEBREW LETTER YOD WITH HIRIQ
    0x0FB1F,  # HEBREW LIGATURE YIDDISH YOD YOD PATAH
    0x0FB2A,  # HEBREW LETTER SHIN WITH SHIN DOT
    0x0FB2B,  # HEBREW LETTER SHIN WITH SIN DOT
    0x0FB2C,  # HEBREW LETTER SHIN WITH DAGESH AND SHIN DOT
    0x0FB2D,  # HEBREW LETTER SHIN WITH DAGESH AND SIN DOT
    0x0FB2E,  # HEBREW LETTER ALEF WITH PATAH
    0x0FB2F,  # HEBREW LETTER ALEF WITH QAMATS
    0x0FB30,  # HEBREW LETTER ALEF WITH MAPIQ
    0x0FB31,  # HEBREW LETTER BET WITH DAGESH
    0x0FB32,  # HEBREW LETTER GIMEL WITH DAGESH
    0x0FB33,  # HEBREW LETTER DALET WITH DAGESH
    0x0FB34,  # HEBREW LETTER HE WITH MAPIQ
    0x0FB35,  # HEBREW LETTER VAV WITH DAGESH
    0x0FB36,  # HEBREW LETTER ZAYIN WITH DAGESH
    0x0FB38,  # HEBREW LETTER TET WITH DAGESH
    0x0FB39,  # HEBREW LETTER YOD WITH DAGESH
    0x0FB3A,  # HEBREW LETTER FINAL KAF WITH DAGESH
    0x0FB3B,  # HEBREW LETTER KAF WITH DAGESH
    0x0FB3C,  # HEBREW LETTER LAMED WITH DAGESH
    0x0FB3E,  # HEBREW LETTER MEM WITH DAGESH
    0x0FB40,  # HEBREW LETTER NUN WITH DAGESH
    0x0FB41,  # HEBREW LETTER SAMEKH WITH DAGESH
    0x0FB43,  # HEBREW LETTER FINAL PE WITH DAGESH
    0x0FB44,  # HEBREW LETTER PE WITH DAGESH
    0x0FB46,  # HEBREW LETTER TSADI WITH DAGESH
    0x0FB47,  # HEBREW LETTER QOF WITH DAGESH
    0x0FB48,  # HEBREW LETTER RESH WITH DAGESH
    0x0FB49,  # HEBREW LETTER SHIN WITH DAGESH
    0x0FB4A,  # HEBREW LETTER TAV WITH DAGESH
    0x0FB4B,  # HEBREW LETTER VAV WITH HOLAM
    0x0FB4C,  # HEBREW LETTER BET WITH RAFE
    0x0FB4D,  # HEBREW LETTER KAF WITH RAFE
    0x0FB4E,  # HEBREW LETTER PE WITH RAFE
    0x02ADC,  # FORKING
    0x1D15E,  # MUSICAL SYMBOL HALF NOTE
    0x1D15F,  # MUSICAL SYMBOL QUARTER NOTE
    0x1D160,  # MUSICAL SYMBOL EIGHTH NOTE
    0x1D161,  # MUSICAL SYMBOL SIXTEENTH NOTE
    0x1D162,  # MUSICAL SYMBOL THIRTY-SECOND NOTE
    0x1D163,  # MUSICAL SYMBOL SIXTY-FOURTH NOTE
    0x1D164,  # MUSICAL SYMBOL ONE HUNDRED TWENTY-EIGHTH NOTE
    0x1D1BB,  # MUSICAL SYMBOL MINIMA
    0x1D1BC,  # MUSICAL SYMBOL MINIMA BLACK
    0x1D1BD,  # MUSICAL SYMBOL SEMIMINIMA WHITE
    0x1D1BE,  # MUSICAL SYMBOL SEMIMINIMA BLACK
    0x1D1BF,  # MUSICAL SYMBOL FUSA WHITE
    0x1D1C0,  # MUSICAL SYMBOL FUSA BLACK
}

# Quick_Check property values
_QC_PROP_VAL = {

    # NFD_Quick_Check=No
    # Characters that cannot ever occur in the normalization form D
    "NFD_QC=N": set([
        *range(0x000C0, 0x000C5 + 1),
        *range(0x000C7, 0x000CF + 1),
        *range(0x000D1, 0x000D6 + 1),
        *range(0x000D9, 0x000DD + 1),
        *range(0x000E0, 0x000E5 + 1),
        *range(0x000E7, 0x000EF + 1),
        *range(0x000F1, 0x000F6 + 1),
        *range(0x000F9, 0x000FD + 1),
        *range(0x000FF, 0x0010F + 1),
        *range(0x00112, 0x00125 + 1),
        *range(0x00128, 0x00130 + 1),
        *range(0x00134, 0x00137 + 1),
        *range(0x00139, 0x0013E + 1),
        *range(0x00143, 0x00148 + 1),
        *range(0x0014C, 0x00151 + 1),
        *range(0x00154, 0x00165 + 1),
        *range(0x00168, 0x0017E + 1),
        *range(0x001A0, 0x001A1 + 1),
        *range(0x001AF, 0x001B0 + 1),
        *range(0x001CD, 0x001DC + 1),
        *range(0x001DE, 0x001E3 + 1),
        *range(0x001E6, 0x001F0 + 1),
        *range(0x001F4, 0x001F5 + 1),
        *range(0x001F8, 0x0021B + 1),
        *range(0x0021E, 0x0021F + 1),
        *range(0x00226, 0x00233 + 1),
        *range(0x00340, 0x00341 + 1),
        *range(0x00343, 0x00344 + 1),
        0x00374,
        0x0037E,
        0x00385,
        0x00386,
        0x00387,
        *range(0x00388, 0x0038A + 1),
        0x0038C,
        *range(0x0038E, 0x00390 + 1),
        *range(0x003AA, 0x003B0 + 1),
        *range(0x003CA, 0x003CE + 1),
        *range(0x003D3, 0x003D4 + 1),
        *range(0x00400, 0x00401 + 1),
        0x00403,
        0x00407,
        *range(0x0040C, 0x0040E + 1),
        0x00419,
        0x00439,
        *range(0x00450, 0x00451 + 1),
        0x00453,
        0x00457,
        *range(0x0045C, 0x0045E + 1),
        *range(0x00476, 0x00477 + 1),
        *range(0x004C1, 0x004C2 + 1),
        *range(0x004D0, 0x004D3 + 1),
        *range(0x004D6, 0x004D7 + 1),
        *range(0x004DA, 0x004DF + 1),
        *range(0x004E2, 0x004E7 + 1),
        *range(0x004EA, 0x004F5 + 1),
        *range(0x004F8, 0x004F9 + 1),
        *range(0x00622, 0x00626 + 1),
        0x006C0,
        0x006C2,
        0x006D3,
        0x00929,
        0x00931,
        0x00934,
        *range(0x00958, 0x0095F + 1),
        *range(0x009CB, 0x009CC + 1),
        *range(0x009DC, 0x009DD + 1),
        0x009DF,
        0x00A33,
        0x00A36,
        *range(0x00A59, 0x00A5B + 1),
        0x00A5E,
        0x00B48,
        *range(0x00B4B, 0x00B4C + 1),
        *range(0x00B5C, 0x00B5D + 1),
        0x00B94,
        *range(0x00BCA, 0x00BCC + 1),
        0x00C48,
        0x00CC0,
        *range(0x00CC7, 0x00CC8 + 1),
        *range(0x00CCA, 0x00CCB + 1),
        *range(0x00D4A, 0x00D4C + 1),
        0x00DDA,
        *range(0x00DDC, 0x00DDE + 1),
        0x00F43,
        0x00F4D,
        0x00F52,
        0x00F57,
        0x00F5C,
        0x00F69,
        0x00F73,
        *range(0x00F75, 0x00F76 + 1),
        0x00F78,
        0x00F81,
        0x00F93,
        0x00F9D,
        0x00FA2,
        0x00FA7,
        0x00FAC,
        0x00FB9,
        0x01026,
        0x01B06,
        0x01B08,
        0x01B0A,
        0x01B0C,
        0x01B0E,
        0x01B12,
        0x01B3B,
        0x01B3D,
        *range(0x01B40, 0x01B41 + 1),
        0x01B43,
        *range(0x01E00, 0x01E99 + 1),
        0x01E9B,
        *range(0x01EA0, 0x01EF9 + 1),
        *range(0x01F00, 0x01F15 + 1),
        *range(0x01F18, 0x01F1D + 1),
        *range(0x01F20, 0x01F45 + 1),
        *range(0x01F48, 0x01F4D + 1),
        *range(0x01F50, 0x01F57 + 1),
        0x01F59,
        0x01F5B,
        0x01F5D,
        *range(0x01F5F, 0x01F7D + 1),
        *range(0x01F80, 0x01FB4 + 1),
        *range(0x01FB6, 0x01FBC + 1),
        0x01FBE,
        0x01FC1,
        *range(0x01FC2, 0x01FC4 + 1),
        *range(0x01FC6, 0x01FCC + 1),
        *range(0x01FCD, 0x01FCF + 1),
        *range(0x01FD0, 0x01FD3 + 1),
        *range(0x01FD6, 0x01FDB + 1),
        *range(0x01FDD, 0x01FDF + 1),
        *range(0x01FE0, 0x01FEC + 1),
        *range(0x01FED, 0x01FEF + 1),
        *range(0x01FF2, 0x01FF4 + 1),
        *range(0x01FF6, 0x01FFC + 1),
        0x01FFD,
        *range(0x02000, 0x02001 + 1),
        0x02126,
        *range(0x0212A, 0x0212B + 1),
        *range(0x0219A, 0x0219B + 1),
        0x021AE,
        0x021CD,
        *range(0x021CE, 0x021CF + 1),
        0x02204,
        0x02209,
        0x0220C,
        0x02224,
        0x02226,
        0x02241,
        0x02244,
        0x02247,
        0x02249,
        0x02260,
        0x02262,
        *range(0x0226D, 0x02271 + 1),
        *range(0x02274, 0x02275 + 1),
        *range(0x02278, 0x02279 + 1),
        *range(0x02280, 0x02281 + 1),
        *range(0x02284, 0x02285 + 1),
        *range(0x02288, 0x02289 + 1),
        *range(0x022AC, 0x022AF + 1),
        *range(0x022E0, 0x022E3 + 1),
        *range(0x022EA, 0x022ED + 1),
        0x02329,
        0x0232A,
        0x02ADC,
        0x0304C,
        0x0304E,
        0x03050,
        0x03052,
        0x03054,
        0x03056,
        0x03058,
        0x0305A,
        0x0305C,
        0x0305E,
        0x03060,
        0x03062,
        0x03065,
        0x03067,
        0x03069,
        *range(0x03070, 0x03071 + 1),
        *range(0x03073, 0x03074 + 1),
        *range(0x03076, 0x03077 + 1),
        *range(0x03079, 0x0307A + 1),
        *range(0x0307C, 0x0307D + 1),
        0x03094,
        0x0309E,
        0x030AC,
        0x030AE,
        0x030B0,
        0x030B2,
        0x030B4,
        0x030B6,
        0x030B8,
        0x030BA,
        0x030BC,
        0x030BE,
        0x030C0,
        0x030C2,
        0x030C5,
        0x030C7,
        0x030C9,
        *range(0x030D0, 0x030D1 + 1),
        *range(0x030D3, 0x030D4 + 1),
        *range(0x030D6, 0x030D7 + 1),
        *range(0x030D9, 0x030DA + 1),
        *range(0x030DC, 0x030DD + 1),
        0x030F4,
        *range(0x030F7, 0x030FA + 1),
        0x030FE,
        *range(0x0AC00, 0x0D7A3 + 1),
        *range(0x0F900, 0x0FA0D + 1),
        0x0FA10,
        0x0FA12,
        *range(0x0FA15, 0x0FA1E + 1),
        0x0FA20,
        0x0FA22,
        *range(0x0FA25, 0x0FA26 + 1),
        *range(0x0FA2A, 0x0FA6D + 1),
        *range(0x0FA70, 0x0FAD9 + 1),
        0x0FB1D,
        0x0FB1F,
        *range(0x0FB2A, 0x0FB36 + 1),
        *range(0x0FB38, 0x0FB3C + 1),
        0x0FB3E,
        *range(0x0FB40, 0x0FB41 + 1),
        *range(0x0FB43, 0x0FB44 + 1),
        *range(0x0FB46, 0x0FB4E + 1),
        0x1109A,
        0x1109C,
        0x110AB,
        *range(0x1112E, 0x1112F + 1),
        *range(0x1134B, 0x1134C + 1),
        *range(0x114BB, 0x114BC + 1),
        0x114BE,
        *range(0x115BA, 0x115BB + 1),
        0x11938,
        *range(0x1D15E, 0x1D164 + 1),
        *range(0x1D1BB, 0x1D1C0 + 1),
        *range(0x2F800, 0x2FA1D + 1),
    ]),

    # NFKD_Quick_Check=No
    # Characters that cannot ever occur in the normalization form KD
    "NFKD_QC=N": set([
        0x000A0,
        0x000A8,
        0x000AA,
        0x000AF,
        *range(0x000B2, 0x000B3 + 1),
        0x000B4,
        0x000B5,
        0x000B8,
        0x000B9,
        0x000BA,
        *range(0x000BC, 0x000BE + 1),
        *range(0x000C0, 0x000C5 + 1),
        *range(0x000C7, 0x000CF + 1),
        *range(0x000D1, 0x000D6 + 1),
        *range(0x000D9, 0x000DD + 1),
        *range(0x000E0, 0x000E5 + 1),
        *range(0x000E7, 0x000EF + 1),
        *range(0x000F1, 0x000F6 + 1),
        *range(0x000F9, 0x000FD + 1),
        *range(0x000FF, 0x0010F + 1),
        *range(0x00112, 0x00125 + 1),
        *range(0x00128, 0x00130 + 1),
        *range(0x00132, 0x00137 + 1),
        *range(0x00139, 0x00140 + 1),
        *range(0x00143, 0x00149 + 1),
        *range(0x0014C, 0x00151 + 1),
        *range(0x00154, 0x00165 + 1),
        *range(0x00168, 0x0017F + 1),
        *range(0x001A0, 0x001A1 + 1),
        *range(0x001AF, 0x001B0 + 1),
        *range(0x001C4, 0x001DC + 1),
        *range(0x001DE, 0x001E3 + 1),
        *range(0x001E6, 0x001F5 + 1),
        *range(0x001F8, 0x0021B + 1),
        *range(0x0021E, 0x0021F + 1),
        *range(0x00226, 0x00233 + 1),
        *range(0x002B0, 0x002B8 + 1),
        *range(0x002D8, 0x002DD + 1),
        *range(0x002E0, 0x002E4 + 1),
        *range(0x00340, 0x00341 + 1),
        *range(0x00343, 0x00344 + 1),
        0x00374,
        0x0037A,
        0x0037E,
        *range(0x00384, 0x00385 + 1),
        0x00386,
        0x00387,
        *range(0x00388, 0x0038A + 1),
        0x0038C,
        *range(0x0038E, 0x00390 + 1),
        *range(0x003AA, 0x003B0 + 1),
        *range(0x003CA, 0x003CE + 1),
        *range(0x003D0, 0x003D6 + 1),
        *range(0x003F0, 0x003F2 + 1),
        *range(0x003F4, 0x003F5 + 1),
        0x003F9,
        *range(0x00400, 0x00401 + 1),
        0x00403,
        0x00407,
        *range(0x0040C, 0x0040E + 1),
        0x00419,
        0x00439,
        *range(0x00450, 0x00451 + 1),
        0x00453,
        0x00457,
        *range(0x0045C, 0x0045E + 1),
        *range(0x00476, 0x00477 + 1),
        *range(0x004C1, 0x004C2 + 1),
        *range(0x004D0, 0x004D3 + 1),
        *range(0x004D6, 0x004D7 + 1),
        *range(0x004DA, 0x004DF + 1),
        *range(0x004E2, 0x004E7 + 1),
        *range(0x004EA, 0x004F5 + 1),
        *range(0x004F8, 0x004F9 + 1),
        0x00587,
        *range(0x00622, 0x00626 + 1),
        *range(0x00675, 0x00678 + 1),
        0x006C0,
        0x006C2,
        0x006D3,
        0x00929,
        0x00931,
        0x00934,
        *range(0x00958, 0x0095F + 1),
        *range(0x009CB, 0x009CC + 1),
        *range(0x009DC, 0x009DD + 1),
        0x009DF,
        0x00A33,
        0x00A36,
        *range(0x00A59, 0x00A5B + 1),
        0x00A5E,
        0x00B48,
        *range(0x00B4B, 0x00B4C + 1),
        *range(0x00B5C, 0x00B5D + 1),
        0x00B94,
        *range(0x00BCA, 0x00BCC + 1),
        0x00C48,
        0x00CC0,
        *range(0x00CC7, 0x00CC8 + 1),
        *range(0x00CCA, 0x00CCB + 1),
        *range(0x00D4A, 0x00D4C + 1),
        0x00DDA,
        *range(0x00DDC, 0x00DDE + 1),
        0x00E33,
        0x00EB3,
        *range(0x00EDC, 0x00EDD + 1),
        0x00F0C,
        0x00F43,
        0x00F4D,
        0x00F52,
        0x00F57,
        0x00F5C,
        0x00F69,
        0x00F73,
        *range(0x00F75, 0x00F79 + 1),
        0x00F81,
        0x00F93,
        0x00F9D,
        0x00FA2,
        0x00FA7,
        0x00FAC,
        0x00FB9,
        0x01026,
        0x010FC,
        0x01B06,
        0x01B08,
        0x01B0A,
        0x01B0C,
        0x01B0E,
        0x01B12,
        0x01B3B,
        0x01B3D,
        *range(0x01B40, 0x01B41 + 1),
        0x01B43,
        *range(0x01D2C, 0x01D2E + 1),
        *range(0x01D30, 0x01D3A + 1),
        *range(0x01D3C, 0x01D4D + 1),
        *range(0x01D4F, 0x01D6A + 1),
        0x01D78,
        *range(0x01D9B, 0x01DBF + 1),
        *range(0x01E00, 0x01E9B + 1),
        *range(0x01EA0, 0x01EF9 + 1),
        *range(0x01F00, 0x01F15 + 1),
        *range(0x01F18, 0x01F1D + 1),
        *range(0x01F20, 0x01F45 + 1),
        *range(0x01F48, 0x01F4D + 1),
        *range(0x01F50, 0x01F57 + 1),
        0x01F59,
        0x01F5B,
        0x01F5D,
        *range(0x01F5F, 0x01F7D + 1),
        *range(0x01F80, 0x01FB4 + 1),
        *range(0x01FB6, 0x01FBC + 1),
        0x01FBD,
        0x01FBE,
        *range(0x01FBF, 0x01FC1 + 1),
        *range(0x01FC2, 0x01FC4 + 1),
        *range(0x01FC6, 0x01FCC + 1),
        *range(0x01FCD, 0x01FCF + 1),
        *range(0x01FD0, 0x01FD3 + 1),
        *range(0x01FD6, 0x01FDB + 1),
        *range(0x01FDD, 0x01FDF + 1),
        *range(0x01FE0, 0x01FEC + 1),
        *range(0x01FED, 0x01FEF + 1),
        *range(0x01FF2, 0x01FF4 + 1),
        *range(0x01FF6, 0x01FFC + 1),
        *range(0x01FFD, 0x01FFE + 1),
        *range(0x02000, 0x0200A + 1),
        0x02011,
        0x02017,
        *range(0x02024, 0x02026 + 1),
        0x0202F,
        *range(0x02033, 0x02034 + 1),
        *range(0x02036, 0x02037 + 1),
        0x0203C,
        0x0203E,
        *range(0x02047, 0x02049 + 1),
        0x02057,
        0x0205F,
        0x02070,
        0x02071,
        *range(0x02074, 0x02079 + 1),
        *range(0x0207A, 0x0207C + 1),
        0x0207D,
        0x0207E,
        0x0207F,
        *range(0x02080, 0x02089 + 1),
        *range(0x0208A, 0x0208C + 1),
        0x0208D,
        0x0208E,
        *range(0x02090, 0x0209C + 1),
        0x020A8,
        *range(0x02100, 0x02101 + 1),
        0x02102,
        0x02103,
        *range(0x02105, 0x02106 + 1),
        0x02107,
        0x02109,
        *range(0x0210A, 0x02113 + 1),
        0x02115,
        0x02116,
        *range(0x02119, 0x0211D + 1),
        *range(0x02120, 0x02122 + 1),
        0x02124,
        0x02126,
        0x02128,
        *range(0x0212A, 0x0212D + 1),
        *range(0x0212F, 0x02131 + 1),
        *range(0x02133, 0x02134 + 1),
        *range(0x02135, 0x02138 + 1),
        0x02139,
        0x0213B,
        *range(0x0213C, 0x0213F + 1),
        0x02140,
        *range(0x02145, 0x02149 + 1),
        *range(0x02150, 0x0215F + 1),
        *range(0x02160, 0x0217F + 1),
        0x02189,
        *range(0x0219A, 0x0219B + 1),
        0x021AE,
        0x021CD,
        *range(0x021CE, 0x021CF + 1),
        0x02204,
        0x02209,
        0x0220C,
        0x02224,
        0x02226,
        *range(0x0222C, 0x0222D + 1),
        *range(0x0222F, 0x02230 + 1),
        0x02241,
        0x02244,
        0x02247,
        0x02249,
        0x02260,
        0x02262,
        *range(0x0226D, 0x02271 + 1),
        *range(0x02274, 0x02275 + 1),
        *range(0x02278, 0x02279 + 1),
        *range(0x02280, 0x02281 + 1),
        *range(0x02284, 0x02285 + 1),
        *range(0x02288, 0x02289 + 1),
        *range(0x022AC, 0x022AF + 1),
        *range(0x022E0, 0x022E3 + 1),
        *range(0x022EA, 0x022ED + 1),
        0x02329,
        0x0232A,
        *range(0x02460, 0x0249B + 1),
        *range(0x0249C, 0x024E9 + 1),
        0x024EA,
        0x02A0C,
        *range(0x02A74, 0x02A76 + 1),
        0x02ADC,
        *range(0x02C7C, 0x02C7D + 1),
        0x02D6F,
        0x02E9F,
        0x02EF3,
        *range(0x02F00, 0x02FD5 + 1),
        0x03000,
        0x03036,
        *range(0x03038, 0x0303A + 1),
        0x0304C,
        0x0304E,
        0x03050,
        0x03052,
        0x03054,
        0x03056,
        0x03058,
        0x0305A,
        0x0305C,
        0x0305E,
        0x03060,
        0x03062,
        0x03065,
        0x03067,
        0x03069,
        *range(0x03070, 0x03071 + 1),
        *range(0x03073, 0x03074 + 1),
        *range(0x03076, 0x03077 + 1),
        *range(0x03079, 0x0307A + 1),
        *range(0x0307C, 0x0307D + 1),
        0x03094,
        *range(0x0309B, 0x0309C + 1),
        0x0309E,
        0x0309F,
        0x030AC,
        0x030AE,
        0x030B0,
        0x030B2,
        0x030B4,
        0x030B6,
        0x030B8,
        0x030BA,
        0x030BC,
        0x030BE,
        0x030C0,
        0x030C2,
        0x030C5,
        0x030C7,
        0x030C9,
        *range(0x030D0, 0x030D1 + 1),
        *range(0x030D3, 0x030D4 + 1),
        *range(0x030D6, 0x030D7 + 1),
        *range(0x030D9, 0x030DA + 1),
        *range(0x030DC, 0x030DD + 1),
        0x030F4,
        *range(0x030F7, 0x030FA + 1),
        0x030FE,
        0x030FF,
        *range(0x03131, 0x0318E + 1),
        *range(0x03192, 0x03195 + 1),
        *range(0x03196, 0x0319F + 1),
        *range(0x03200, 0x0321E + 1),
        *range(0x03220, 0x03229 + 1),
        *range(0x0322A, 0x03247 + 1),
        0x03250,
        *range(0x03251, 0x0325F + 1),
        *range(0x03260, 0x0327E + 1),
        *range(0x03280, 0x03289 + 1),
        *range(0x0328A, 0x032B0 + 1),
        *range(0x032B1, 0x032BF + 1),
        *range(0x032C0, 0x033FF + 1),
        *range(0x0A69C, 0x0A69D + 1),
        0x0A770,
        *range(0x0A7F2, 0x0A7F4 + 1),
        *range(0x0A7F8, 0x0A7F9 + 1),
        *range(0x0AB5C, 0x0AB5F + 1),
        0x0AB69,
        *range(0x0AC00, 0x0D7A3 + 1),
        *range(0x0F900, 0x0FA0D + 1),
        0x0FA10,
        0x0FA12,
        *range(0x0FA15, 0x0FA1E + 1),
        0x0FA20,
        0x0FA22,
        *range(0x0FA25, 0x0FA26 + 1),
        *range(0x0FA2A, 0x0FA6D + 1),
        *range(0x0FA70, 0x0FAD9 + 1),
        *range(0x0FB00, 0x0FB06 + 1),
        *range(0x0FB13, 0x0FB17 + 1),
        0x0FB1D,
        *range(0x0FB1F, 0x0FB28 + 1),
        0x0FB29,
        *range(0x0FB2A, 0x0FB36 + 1),
        *range(0x0FB38, 0x0FB3C + 1),
        0x0FB3E,
        *range(0x0FB40, 0x0FB41 + 1),
        *range(0x0FB43, 0x0FB44 + 1),
        *range(0x0FB46, 0x0FBB1 + 1),
        *range(0x0FBD3, 0x0FD3D + 1),
        *range(0x0FD50, 0x0FD8F + 1),
        *range(0x0FD92, 0x0FDC7 + 1),
        *range(0x0FDF0, 0x0FDFB + 1),
        0x0FDFC,
        *range(0x0FE10, 0x0FE16 + 1),
        0x0FE17,
        0x0FE18,
        0x0FE19,
        0x0FE30,
        *range(0x0FE31, 0x0FE32 + 1),
        *range(0x0FE33, 0x0FE34 + 1),
        0x0FE35,
        0x0FE36,
        0x0FE37,
        0x0FE38,
        0x0FE39,
        0x0FE3A,
        0x0FE3B,
        0x0FE3C,
        0x0FE3D,
        0x0FE3E,
        0x0FE3F,
        0x0FE40,
        0x0FE41,
        0x0FE42,
        0x0FE43,
        0x0FE44,
        0x0FE47,
        0x0FE48,
        *range(0x0FE49, 0x0FE4C + 1),
        *range(0x0FE4D, 0x0FE4F + 1),
        *range(0x0FE50, 0x0FE52 + 1),
        *range(0x0FE54, 0x0FE57 + 1),
        0x0FE58,
        0x0FE59,
        0x0FE5A,
        0x0FE5B,
        0x0FE5C,
        0x0FE5D,
        0x0FE5E,
        *range(0x0FE5F, 0x0FE61 + 1),
        0x0FE62,
        0x0FE63,
        *range(0x0FE64, 0x0FE66 + 1),
        0x0FE68,
        0x0FE69,
        *range(0x0FE6A, 0x0FE6B + 1),
        *range(0x0FE70, 0x0FE72 + 1),
        0x0FE74,
        *range(0x0FE76, 0x0FEFC + 1),
        *range(0x0FF01, 0x0FF03 + 1),
        0x0FF04,
        *range(0x0FF05, 0x0FF07 + 1),
        0x0FF08,
        0x0FF09,
        0x0FF0A,
        0x0FF0B,
        0x0FF0C,
        0x0FF0D,
        *range(0x0FF0E, 0x0FF0F + 1),
        *range(0x0FF10, 0x0FF19 + 1),
        *range(0x0FF1A, 0x0FF1B + 1),
        *range(0x0FF1C, 0x0FF1E + 1),
        *range(0x0FF1F, 0x0FF20 + 1),
        *range(0x0FF21, 0x0FF3A + 1),
        0x0FF3B,
        0x0FF3C,
        0x0FF3D,
        0x0FF3E,
        0x0FF3F,
        0x0FF40,
        *range(0x0FF41, 0x0FF5A + 1),
        0x0FF5B,
        0x0FF5C,
        0x0FF5D,
        0x0FF5E,
        0x0FF5F,
        0x0FF60,
        0x0FF61,
        0x0FF62,
        0x0FF63,
        *range(0x0FF64, 0x0FF65 + 1),
        *range(0x0FF66, 0x0FF6F + 1),
        0x0FF70,
        *range(0x0FF71, 0x0FF9D + 1),
        *range(0x0FF9E, 0x0FF9F + 1),
        *range(0x0FFA0, 0x0FFBE + 1),
        *range(0x0FFC2, 0x0FFC7 + 1),
        *range(0x0FFCA, 0x0FFCF + 1),
        *range(0x0FFD2, 0x0FFD7 + 1),
        *range(0x0FFDA, 0x0FFDC + 1),
        *range(0x0FFE0, 0x0FFE1 + 1),
        0x0FFE2,
        0x0FFE3,
        0x0FFE4,
        *range(0x0FFE5, 0x0FFE6 + 1),
        0x0FFE8,
        *range(0x0FFE9, 0x0FFEC + 1),
        *range(0x0FFED, 0x0FFEE + 1),
        *range(0x10781, 0x10785 + 1),
        *range(0x10787, 0x107B0 + 1),
        *range(0x107B2, 0x107BA + 1),
        0x1109A,
        0x1109C,
        0x110AB,
        *range(0x1112E, 0x1112F + 1),
        *range(0x1134B, 0x1134C + 1),
        *range(0x114BB, 0x114BC + 1),
        0x114BE,
        *range(0x115BA, 0x115BB + 1),
        0x11938,
        *range(0x1D15E, 0x1D164 + 1),
        *range(0x1D1BB, 0x1D1C0 + 1),
        *range(0x1D400, 0x1D454 + 1),
        *range(0x1D456, 0x1D49C + 1),
        *range(0x1D49E, 0x1D49F + 1),
        0x1D4A2,
        *range(0x1D4A5, 0x1D4A6 + 1),
        *range(0x1D4A9, 0x1D4AC + 1),
        *range(0x1D4AE, 0x1D4B9 + 1),
        0x1D4BB,
        *range(0x1D4BD, 0x1D4C3 + 1),
        *range(0x1D4C5, 0x1D505 + 1),
        *range(0x1D507, 0x1D50A + 1),
        *range(0x1D50D, 0x1D514 + 1),
        *range(0x1D516, 0x1D51C + 1),
        *range(0x1D51E, 0x1D539 + 1),
        *range(0x1D53B, 0x1D53E + 1),
        *range(0x1D540, 0x1D544 + 1),
        0x1D546,
        *range(0x1D54A, 0x1D550 + 1),
        *range(0x1D552, 0x1D6A5 + 1),
        *range(0x1D6A8, 0x1D6C0 + 1),
        0x1D6C1,
        *range(0x1D6C2, 0x1D6DA + 1),
        0x1D6DB,
        *range(0x1D6DC, 0x1D6FA + 1),
        0x1D6FB,
        *range(0x1D6FC, 0x1D714 + 1),
        0x1D715,
        *range(0x1D716, 0x1D734 + 1),
        0x1D735,
        *range(0x1D736, 0x1D74E + 1),
        0x1D74F,
        *range(0x1D750, 0x1D76E + 1),
        0x1D76F,
        *range(0x1D770, 0x1D788 + 1),
        0x1D789,
        *range(0x1D78A, 0x1D7A8 + 1),
        0x1D7A9,
        *range(0x1D7AA, 0x1D7C2 + 1),
        0x1D7C3,
        *range(0x1D7C4, 0x1D7CB + 1),
        *range(0x1D7CE, 0x1D7FF + 1),
        *range(0x1E030, 0x1E06D + 1),
        *range(0x1EE00, 0x1EE03 + 1),
        *range(0x1EE05, 0x1EE1F + 1),
        *range(0x1EE21, 0x1EE22 + 1),
        0x1EE24,
        0x1EE27,
        *range(0x1EE29, 0x1EE32 + 1),
        *range(0x1EE34, 0x1EE37 + 1),
        0x1EE39,
        0x1EE3B,
        0x1EE42,
        0x1EE47,
        0x1EE49,
        0x1EE4B,
        *range(0x1EE4D, 0x1EE4F + 1),
        *range(0x1EE51, 0x1EE52 + 1),
        0x1EE54,
        0x1EE57,
        0x1EE59,
        0x1EE5B,
        0x1EE5D,
        0x1EE5F,
        *range(0x1EE61, 0x1EE62 + 1),
        0x1EE64,
        *range(0x1EE67, 0x1EE6A + 1),
        *range(0x1EE6C, 0x1EE72 + 1),
        *range(0x1EE74, 0x1EE77 + 1),
        *range(0x1EE79, 0x1EE7C + 1),
        0x1EE7E,
        *range(0x1EE80, 0x1EE89 + 1),
        *range(0x1EE8B, 0x1EE9B + 1),
        *range(0x1EEA1, 0x1EEA3 + 1),
        *range(0x1EEA5, 0x1EEA9 + 1),
        *range(0x1EEAB, 0x1EEBB + 1),
        *range(0x1F100, 0x1F10A + 1),
        *range(0x1F110, 0x1F12E + 1),
        *range(0x1F130, 0x1F14F + 1),
        *range(0x1F16A, 0x1F16C + 1),
        0x1F190,
        *range(0x1F200, 0x1F202 + 1),
        *range(0x1F210, 0x1F23B + 1),
        *range(0x1F240, 0x1F248 + 1),
        *range(0x1F250, 0x1F251 + 1),
        *range(0x1FBF0, 0x1FBF9 + 1),
        *range(0x2F800, 0x2FA1D + 1),
    ]),

    # NFC_Quick_Check=No
    # Characters that cannot ever occur in the normalization form C
    "NFC_QC=N": set([
        *range(0x00340, 0x00341 + 1),
        *range(0x00343, 0x00344 + 1),
        0x00374,
        0x0037E,
        0x00387,
        *range(0x00958, 0x0095F + 1),
        *range(0x009DC, 0x009DD + 1),
        0x009DF,
        0x00A33,
        0x00A36,
        *range(0x00A59, 0x00A5B + 1),
        0x00A5E,
        *range(0x00B5C, 0x00B5D + 1),
        0x00F43,
        0x00F4D,
        0x00F52,
        0x00F57,
        0x00F5C,
        0x00F69,
        0x00F73,
        *range(0x00F75, 0x00F76 + 1),
        0x00F78,
        0x00F81,
        0x00F93,
        0x00F9D,
        0x00FA2,
        0x00FA7,
        0x00FAC,
        0x00FB9,
        0x01F71,
        0x01F73,
        0x01F75,
        0x01F77,
        0x01F79,
        0x01F7B,
        0x01F7D,
        0x01FBB,
        0x01FBE,
        0x01FC9,
        0x01FCB,
        0x01FD3,
        0x01FDB,
        0x01FE3,
        0x01FEB,
        *range(0x01FEE, 0x01FEF + 1),
        0x01FF9,
        0x01FFB,
        0x01FFD,
        *range(0x02000, 0x02001 + 1),
        0x02126,
        *range(0x0212A, 0x0212B + 1),
        0x02329,
        0x0232A,
        0x02ADC,
        *range(0x0F900, 0x0FA0D + 1),
        0x0FA10,
        0x0FA12,
        *range(0x0FA15, 0x0FA1E + 1),
        0x0FA20,
        0x0FA22,
        *range(0x0FA25, 0x0FA26 + 1),
        *range(0x0FA2A, 0x0FA6D + 1),
        *range(0x0FA70, 0x0FAD9 + 1),
        0x0FB1D,
        0x0FB1F,
        *range(0x0FB2A, 0x0FB36 + 1),
        *range(0x0FB38, 0x0FB3C + 1),
        0x0FB3E,
        *range(0x0FB40, 0x0FB41 + 1),
        *range(0x0FB43, 0x0FB44 + 1),
        *range(0x0FB46, 0x0FB4E + 1),
        *range(0x1D15E, 0x1D164 + 1),
        *range(0x1D1BB, 0x1D1C0 + 1),
        *range(0x2F800, 0x2FA1D + 1),
    ]),

    # NFC_Quick_Check=Maybe
    # Characters that may or may not occur in the normalization form C,
    # depending on the context
    "NFC_QC=M": set([
        *range(0x00300, 0x00304 + 1),
        *range(0x00306, 0x0030C + 1),
        0x0030F,
        0x00311,
        *range(0x00313, 0x00314 + 1),
        0x0031B,
        *range(0x00323, 0x00328 + 1),
        *range(0x0032D, 0x0032E + 1),
        *range(0x00330, 0x00331 + 1),
        0x00338,
        0x00342,
        0x00345,
        *range(0x00653, 0x00655 + 1),
        0x0093C,
        0x009BE,
        0x009D7,
        0x00B3E,
        0x00B56,
        0x00B57,
        0x00BBE,
        0x00BD7,
        0x00C56,
        0x00CC2,
        *range(0x00CD5, 0x00CD6 + 1),
        0x00D3E,
        0x00D57,
        0x00DCA,
        0x00DCF,
        0x00DDF,
        0x0102E,
        *range(0x01161, 0x01175 + 1),
        *range(0x011A8, 0x011C2 + 1),
        0x01B35,
        *range(0x03099, 0x0309A + 1),
        0x110BA,
        0x11127,
        0x1133E,
        0x11357,
        0x114B0,
        0x114BA,
        0x114BD,
        0x115AF,
        0x11930,
    ]),

    # NFKC_Quick_Check=No
    # Characters that cannot ever occur in the normalization form KC
    "NFKC_QC=N": set([
        0x000A0,
        0x000A8,
        0x000AA,
        0x000AF,
        *range(0x000B2, 0x000B3 + 1),
        0x000B4,
        0x000B5,
        0x000B8,
        0x000B9,
        0x000BA,
        *range(0x000BC, 0x000BE + 1),
        *range(0x00132, 0x00133 + 1),
        *range(0x0013F, 0x00140 + 1),
        0x00149,
        0x0017F,
        *range(0x001C4, 0x001CC + 1),
        *range(0x001F1, 0x001F3 + 1),
        *range(0x002B0, 0x002B8 + 1),
        *range(0x002D8, 0x002DD + 1),
        *range(0x002E0, 0x002E4 + 1),
        *range(0x00340, 0x00341 + 1),
        *range(0x00343, 0x00344 + 1),
        0x00374,
        0x0037A,
        0x0037E,
        *range(0x00384, 0x00385 + 1),
        0x00387,
        *range(0x003D0, 0x003D6 + 1),
        *range(0x003F0, 0x003F2 + 1),
        *range(0x003F4, 0x003F5 + 1),
        0x003F9,
        0x00587,
        *range(0x00675, 0x00678 + 1),
        *range(0x00958, 0x0095F + 1),
        *range(0x009DC, 0x009DD + 1),
        0x009DF,
        0x00A33,
        0x00A36,
        *range(0x00A59, 0x00A5B + 1),
        0x00A5E,
        *range(0x00B5C, 0x00B5D + 1),
        0x00E33,
        0x00EB3,
        *range(0x00EDC, 0x00EDD + 1),
        0x00F0C,
        0x00F43,
        0x00F4D,
        0x00F52,
        0x00F57,
        0x00F5C,
        0x00F69,
        0x00F73,
        *range(0x00F75, 0x00F79 + 1),
        0x00F81,
        0x00F93,
        0x00F9D,
        0x00FA2,
        0x00FA7,
        0x00FAC,
        0x00FB9,
        0x010FC,
        *range(0x01D2C, 0x01D2E + 1),
        *range(0x01D30, 0x01D3A + 1),
        *range(0x01D3C, 0x01D4D + 1),
        *range(0x01D4F, 0x01D6A + 1),
        0x01D78,
        *range(0x01D9B, 0x01DBF + 1),
        *range(0x01E9A, 0x01E9B + 1),
        0x01F71,
        0x01F73,
        0x01F75,
        0x01F77,
        0x01F79,
        0x01F7B,
        0x01F7D,
        0x01FBB,
        0x01FBD,
        0x01FBE,
        *range(0x01FBF, 0x01FC1 + 1),
        0x01FC9,
        0x01FCB,
        *range(0x01FCD, 0x01FCF + 1),
        0x01FD3,
        0x01FDB,
        *range(0x01FDD, 0x01FDF + 1),
        0x01FE3,
        0x01FEB,
        *range(0x01FED, 0x01FEF + 1),
        0x01FF9,
        0x01FFB,
        *range(0x01FFD, 0x01FFE + 1),
        *range(0x02000, 0x0200A + 1),
        0x02011,
        0x02017,
        *range(0x02024, 0x02026 + 1),
        0x0202F,
        *range(0x02033, 0x02034 + 1),
        *range(0x02036, 0x02037 + 1),
        0x0203C,
        0x0203E,
        *range(0x02047, 0x02049 + 1),
        0x02057,
        0x0205F,
        0x02070,
        0x02071,
        *range(0x02074, 0x02079 + 1),
        *range(0x0207A, 0x0207C + 1),
        0x0207D,
        0x0207E,
        0x0207F,
        *range(0x02080, 0x02089 + 1),
        *range(0x0208A, 0x0208C + 1),
        0x0208D,
        0x0208E,
        *range(0x02090, 0x0209C + 1),
        0x020A8,
        *range(0x02100, 0x02101 + 1),
        0x02102,
        0x02103,
        *range(0x02105, 0x02106 + 1),
        0x02107,
        0x02109,
        *range(0x0210A, 0x02113 + 1),
        0x02115,
        0x02116,
        *range(0x02119, 0x0211D + 1),
        *range(0x02120, 0x02122 + 1),
        0x02124,
        0x02126,
        0x02128,
        *range(0x0212A, 0x0212D + 1),
        *range(0x0212F, 0x02131 + 1),
        *range(0x02133, 0x02134 + 1),
        *range(0x02135, 0x02138 + 1),
        0x02139,
        0x0213B,
        *range(0x0213C, 0x0213F + 1),
        0x02140,
        *range(0x02145, 0x02149 + 1),
        *range(0x02150, 0x0215F + 1),
        *range(0x02160, 0x0217F + 1),
        0x02189,
        *range(0x0222C, 0x0222D + 1),
        *range(0x0222F, 0x02230 + 1),
        0x02329,
        0x0232A,
        *range(0x02460, 0x0249B + 1),
        *range(0x0249C, 0x024E9 + 1),
        0x024EA,
        0x02A0C,
        *range(0x02A74, 0x02A76 + 1),
        0x02ADC,
        *range(0x02C7C, 0x02C7D + 1),
        0x02D6F,
        0x02E9F,
        0x02EF3,
        *range(0x02F00, 0x02FD5 + 1),
        0x03000,
        0x03036,
        *range(0x03038, 0x0303A + 1),
        *range(0x0309B, 0x0309C + 1),
        0x0309F,
        0x030FF,
        *range(0x03131, 0x0318E + 1),
        *range(0x03192, 0x03195 + 1),
        *range(0x03196, 0x0319F + 1),
        *range(0x03200, 0x0321E + 1),
        *range(0x03220, 0x03229 + 1),
        *range(0x0322A, 0x03247 + 1),
        0x03250,
        *range(0x03251, 0x0325F + 1),
        *range(0x03260, 0x0327E + 1),
        *range(0x03280, 0x03289 + 1),
        *range(0x0328A, 0x032B0 + 1),
        *range(0x032B1, 0x032BF + 1),
        *range(0x032C0, 0x033FF + 1),
        *range(0x0A69C, 0x0A69D + 1),
        0x0A770,
        *range(0x0A7F2, 0x0A7F4 + 1),
        *range(0x0A7F8, 0x0A7F9 + 1),
        *range(0x0AB5C, 0x0AB5F + 1),
        0x0AB69,
        *range(0x0F900, 0x0FA0D + 1),
        0x0FA10,
        0x0FA12,
        *range(0x0FA15, 0x0FA1E + 1),
        0x0FA20,
        0x0FA22,
        *range(0x0FA25, 0x0FA26 + 1),
        *range(0x0FA2A, 0x0FA6D + 1),
        *range(0x0FA70, 0x0FAD9 + 1),
        *range(0x0FB00, 0x0FB06 + 1),
        *range(0x0FB13, 0x0FB17 + 1),
        0x0FB1D,
        *range(0x0FB1F, 0x0FB28 + 1),
        0x0FB29,
        *range(0x0FB2A, 0x0FB36 + 1),
        *range(0x0FB38, 0x0FB3C + 1),
        0x0FB3E,
        *range(0x0FB40, 0x0FB41 + 1),
        *range(0x0FB43, 0x0FB44 + 1),
        *range(0x0FB46, 0x0FBB1 + 1),
        *range(0x0FBD3, 0x0FD3D + 1),
        *range(0x0FD50, 0x0FD8F + 1),
        *range(0x0FD92, 0x0FDC7 + 1),
        *range(0x0FDF0, 0x0FDFB + 1),
        0x0FDFC,
        *range(0x0FE10, 0x0FE16 + 1),
        0x0FE17,
        0x0FE18,
        0x0FE19,
        0x0FE30,
        *range(0x0FE31, 0x0FE32 + 1),
        *range(0x0FE33, 0x0FE34 + 1),
        0x0FE35,
        0x0FE36,
        0x0FE37,
        0x0FE38,
        0x0FE39,
        0x0FE3A,
        0x0FE3B,
        0x0FE3C,
        0x0FE3D,
        0x0FE3E,
        0x0FE3F,
        0x0FE40,
        0x0FE41,
        0x0FE42,
        0x0FE43,
        0x0FE44,
        0x0FE47,
        0x0FE48,
        *range(0x0FE49, 0x0FE4C + 1),
        *range(0x0FE4D, 0x0FE4F + 1),
        *range(0x0FE50, 0x0FE52 + 1),
        *range(0x0FE54, 0x0FE57 + 1),
        0x0FE58,
        0x0FE59,
        0x0FE5A,
        0x0FE5B,
        0x0FE5C,
        0x0FE5D,
        0x0FE5E,
        *range(0x0FE5F, 0x0FE61 + 1),
        0x0FE62,
        0x0FE63,
        *range(0x0FE64, 0x0FE66 + 1),
        0x0FE68,
        0x0FE69,
        *range(0x0FE6A, 0x0FE6B + 1),
        *range(0x0FE70, 0x0FE72 + 1),
        0x0FE74,
        *range(0x0FE76, 0x0FEFC + 1),
        *range(0x0FF01, 0x0FF03 + 1),
        0x0FF04,
        *range(0x0FF05, 0x0FF07 + 1),
        0x0FF08,
        0x0FF09,
        0x0FF0A,
        0x0FF0B,
        0x0FF0C,
        0x0FF0D,
        *range(0x0FF0E, 0x0FF0F + 1),
        *range(0x0FF10, 0x0FF19 + 1),
        *range(0x0FF1A, 0x0FF1B + 1),
        *range(0x0FF1C, 0x0FF1E + 1),
        *range(0x0FF1F, 0x0FF20 + 1),
        *range(0x0FF21, 0x0FF3A + 1),
        0x0FF3B,
        0x0FF3C,
        0x0FF3D,
        0x0FF3E,
        0x0FF3F,
        0x0FF40,
        *range(0x0FF41, 0x0FF5A + 1),
        0x0FF5B,
        0x0FF5C,
        0x0FF5D,
        0x0FF5E,
        0x0FF5F,
        0x0FF60,
        0x0FF61,
        0x0FF62,
        0x0FF63,
        *range(0x0FF64, 0x0FF65 + 1),
        *range(0x0FF66, 0x0FF6F + 1),
        0x0FF70,
        *range(0x0FF71, 0x0FF9D + 1),
        *range(0x0FF9E, 0x0FF9F + 1),
        *range(0x0FFA0, 0x0FFBE + 1),
        *range(0x0FFC2, 0x0FFC7 + 1),
        *range(0x0FFCA, 0x0FFCF + 1),
        *range(0x0FFD2, 0x0FFD7 + 1),
        *range(0x0FFDA, 0x0FFDC + 1),
        *range(0x0FFE0, 0x0FFE1 + 1),
        0x0FFE2,
        0x0FFE3,
        0x0FFE4,
        *range(0x0FFE5, 0x0FFE6 + 1),
        0x0FFE8,
        *range(0x0FFE9, 0x0FFEC + 1),
        *range(0x0FFED, 0x0FFEE + 1),
        *range(0x10781, 0x10785 + 1),
        *range(0x10787, 0x107B0 + 1),
        *range(0x107B2, 0x107BA + 1),
        *range(0x1D15E, 0x1D164 + 1),
        *range(0x1D1BB, 0x1D1C0 + 1),
        *range(0x1D400, 0x1D454 + 1),
        *range(0x1D456, 0x1D49C + 1),
        *range(0x1D49E, 0x1D49F + 1),
        0x1D4A2,
        *range(0x1D4A5, 0x1D4A6 + 1),
        *range(0x1D4A9, 0x1D4AC + 1),
        *range(0x1D4AE, 0x1D4B9 + 1),
        0x1D4BB,
        *range(0x1D4BD, 0x1D4C3 + 1),
        *range(0x1D4C5, 0x1D505 + 1),
        *range(0x1D507, 0x1D50A + 1),
        *range(0x1D50D, 0x1D514 + 1),
        *range(0x1D516, 0x1D51C + 1),
        *range(0x1D51E, 0x1D539 + 1),
        *range(0x1D53B, 0x1D53E + 1),
        *range(0x1D540, 0x1D544 + 1),
        0x1D546,
        *range(0x1D54A, 0x1D550 + 1),
        *range(0x1D552, 0x1D6A5 + 1),
        *range(0x1D6A8, 0x1D6C0 + 1),
        0x1D6C1,
        *range(0x1D6C2, 0x1D6DA + 1),
        0x1D6DB,
        *range(0x1D6DC, 0x1D6FA + 1),
        0x1D6FB,
        *range(0x1D6FC, 0x1D714 + 1),
        0x1D715,
        *range(0x1D716, 0x1D734 + 1),
        0x1D735,
        *range(0x1D736, 0x1D74E + 1),
        0x1D74F,
        *range(0x1D750, 0x1D76E + 1),
        0x1D76F,
        *range(0x1D770, 0x1D788 + 1),
        0x1D789,
        *range(0x1D78A, 0x1D7A8 + 1),
        0x1D7A9,
        *range(0x1D7AA, 0x1D7C2 + 1),
        0x1D7C3,
        *range(0x1D7C4, 0x1D7CB + 1),
        *range(0x1D7CE, 0x1D7FF + 1),
        *range(0x1E030, 0x1E06D + 1),
        *range(0x1EE00, 0x1EE03 + 1),
        *range(0x1EE05, 0x1EE1F + 1),
        *range(0x1EE21, 0x1EE22 + 1),
        0x1EE24,
        0x1EE27,
        *range(0x1EE29, 0x1EE32 + 1),
        *range(0x1EE34, 0x1EE37 + 1),
        0x1EE39,
        0x1EE3B,
        0x1EE42,
        0x1EE47,
        0x1EE49,
        0x1EE4B,
        *range(0x1EE4D, 0x1EE4F + 1),
        *range(0x1EE51, 0x1EE52 + 1),
        0x1EE54,
        0x1EE57,
        0x1EE59,
        0x1EE5B,
        0x1EE5D,
        0x1EE5F,
        *range(0x1EE61, 0x1EE62 + 1),
        0x1EE64,
        *range(0x1EE67, 0x1EE6A + 1),
        *range(0x1EE6C, 0x1EE72 + 1),
        *range(0x1EE74, 0x1EE77 + 1),
        *range(0x1EE79, 0x1EE7C + 1),
        0x1EE7E,
        *range(0x1EE80, 0x1EE89 + 1),
        *range(0x1EE8B, 0x1EE9B + 1),
        *range(0x1EEA1, 0x1EEA3 + 1),
        *range(0x1EEA5, 0x1EEA9 + 1),
        *range(0x1EEAB, 0x1EEBB + 1),
        *range(0x1F100, 0x1F10A + 1),
        *range(0x1F110, 0x1F12E + 1),
        *range(0x1F130, 0x1F14F + 1),
        *range(0x1F16A, 0x1F16C + 1),
        0x1F190,
        *range(0x1F200, 0x1F202 + 1),
        *range(0x1F210, 0x1F23B + 1),
        *range(0x1F240, 0x1F248 + 1),
        *range(0x1F250, 0x1F251 + 1),
        *range(0x1FBF0, 0x1FBF9 + 1),
        *range(0x2F800, 0x2FA1D + 1),
    ]),

    # NFKC_Quick_Check=Maybe
    # Characters that may or may not occur in the normalization form KC,
    # depending on the context
    "NFKC_QC=M": set([
        *range(0x00300, 0x00304 + 1),
        *range(0x00306, 0x0030C + 1),
        0x0030F,
        0x00311,
        *range(0x00313, 0x00314 + 1),
        0x0031B,
        *range(0x00323, 0x00328 + 1),
        *range(0x0032D, 0x0032E + 1),
        *range(0x00330, 0x00331 + 1),
        0x00338,
        0x00342,
        0x00345,
        *range(0x00653, 0x00655 + 1),
        0x0093C,
        0x009BE,
        0x009D7,
        0x00B3E,
        0x00B56,
        0x00B57,
        0x00BBE,
        0x00BD7,
        0x00C56,
        0x00CC2,
        *range(0x00CD5, 0x00CD6 + 1),
        0x00D3E,
        0x00D57,
        0x00DCA,
        0x00DCF,
        0x00DDF,
        0x0102E,
        *range(0x01161, 0x01175 + 1),
        *range(0x011A8, 0x011C2 + 1),
        0x01B35,
        *range(0x03099, 0x0309A + 1),
        0x110BA,
        0x11127,
        0x1133E,
        0x11357,
        0x114B0,
        0x114BA,
        0x114BD,
        0x115AF,
        0x11930,
    ]),
}
