# pylint: disable=missing-module-docstring
from pathlib import Path

from setuptools import find_packages, setup

import versioneer

with open("requirements.in", encoding="utf-8") as f:
    requirements = f.read().splitlines()

this_directory = Path(__file__).parent
long_description = (this_directory / "README.md").read_text()

setup(
    name="logprep",
    version=versioneer.get_version(),
    cmdclass=versioneer.get_cmdclass(),
    description="Logprep allows to collect, process and forward log messages from various data "
    "sources.",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/fkie-cad/Logprep",
    author="Logprep Team",
    license="LGPL-2.1 license",
    classifiers=[
        "Programming Language :: Python",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
    ],
    project_urls={
        "Homepage": "https://github.com/fkie-cad/Logprep",
        "Documentation": "https://logprep.readthedocs.io/en/latest/",
    },
    packages=find_packages(),
    include_package_data=True,
    install_requires=["setuptools"] + requirements,
    python_requires=">=3.10",
    entry_points={
        "console_scripts": [
            "logprep = logprep.run_logprep:main",
        ]
    },
)
