"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TextractClassificationConfigurator = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const dynamodb = require("aws-cdk-lib/aws-dynamodb");
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const sfn = require("aws-cdk-lib/aws-stepfunctions");
const tasks = require("aws-cdk-lib/aws-stepfunctions-tasks");
const cfnCustomResourceConfiguratorPrefill_1 = require("./cfnCustomResourceConfiguratorPrefill");
class TextractClassificationConfigurator extends sfn.StateMachineFragment {
    constructor(parent, id, props) {
        super(parent, id);
        this.configurationTable = new dynamodb.Table(this, 'TextractConfigurationTable', {
            partitionKey: {
                name: 'DOCUMENT_TYPE',
                type: dynamodb.AttributeType.STRING,
            },
            removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY,
            billingMode: dynamodb.BillingMode.PAY_PER_REQUEST,
        });
        const textractDocTypeConfig = new cfnCustomResourceConfiguratorPrefill_1.TextractConfiguration(this, 'DocTypeConfig', {
            configuration_table: this.configurationTable.tableName,
        });
        textractDocTypeConfig.node.addDependency(this.configurationTable);
        var lambdaMemoryMB = props.lambdaMemoryMB === undefined ? 1024 : props.lambdaMemoryMB;
        var lambdaTimeout = props.lambdaTimeout === undefined ? 900 : props.lambdaTimeout;
        var lambdaLogLevel = props.lambdaLogLevel === undefined ? 'DEBUG' : props.lambdaLogLevel;
        this.configuratorFunction = new lambda.DockerImageFunction(this, 'ClassificationConfigurator', {
            code: lambda.DockerImageCode.fromImageAsset(path.join(__dirname, '../lambda/configurator/')),
            memorySize: lambdaMemoryMB,
            timeout: aws_cdk_lib_1.Duration.seconds(lambdaTimeout),
            environment: {
                CONFIGURATION_TABLE: this.configurationTable.tableName,
                LOG_LEVEL: lambdaLogLevel,
            },
        });
        this.configuratorFunction.addToRolePolicy(new iam.PolicyStatement({ actions: ['dynamodb:*'], resources: ['*'] }));
        this.configuratorFunctionLogGroupName = this.configuratorFunction.logGroup.logGroupName;
        const configuratorLambdaInvoke = new tasks.LambdaInvoke(this, id, {
            lambdaFunction: this.configuratorFunction,
            timeout: aws_cdk_lib_1.Duration.seconds(100),
            outputPath: '$.Payload',
        });
        this.startState = configuratorLambdaInvoke;
        this.endStates = [configuratorLambdaInvoke];
    }
}
exports.TextractClassificationConfigurator = TextractClassificationConfigurator;
_a = JSII_RTTI_SYMBOL_1;
TextractClassificationConfigurator[_a] = { fqn: "schadem-cdk-construct-textract-generic-async.TextractClassificationConfigurator", version: "0.0.4" };
//# sourceMappingURL=data:application/json;base64,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