import * as iam from 'aws-cdk-lib/aws-iam';
import { IRole } from 'aws-cdk-lib/aws-iam';
import * as lambda from 'aws-cdk-lib/aws-lambda';
import { ILogGroup } from 'aws-cdk-lib/aws-logs';
import * as sns from 'aws-cdk-lib/aws-sns';
import * as sqs from 'aws-cdk-lib/aws-sqs';
import * as sfn from 'aws-cdk-lib/aws-stepfunctions';
import { LambdaInvoke } from 'aws-cdk-lib/aws-stepfunctions-tasks';
import { Construct } from 'constructs';
export { TextractGenericSyncSfnTask, TextractGenericSyncSfnTaskProps } from './textractSync';
export { TextractPOCDecider, TextractDPPOCDeciderProps } from './textractDecider';
export { TextractClassificationConfigurator, TextractClassificationConfiguratorProps } from './textractClassificationConfigurator';
export { TextractAsyncToJSON, TextractAsyncToJSONProps } from './textractOutputConfigToJSON';
export { TextractGenerateCSV, TextractGenerateCSVProps } from './textractGenerateCSV';
export declare function validatePatternSupported(integrationPattern: sfn.IntegrationPattern, supportedPatterns: sfn.IntegrationPattern[]): void;
export declare function integrationResourceArn(service: string, api: string, integrationPattern?: sfn.IntegrationPattern): string;
export interface TextractGenericAsyncSfnTaskProps extends sfn.TaskStateBaseProps {
    readonly s3OutputBucket: string;
    /** default classification, if a specific document types e. g. ID documents or expenses or invoices should be processed vs generic */
    /** The prefix to use for the output files */
    readonly s3OutputPrefix?: string;
    /** The prefix to use for the temporary output files (e. g. output from async process before stiching together) */
    readonly s3TempOutputPrefix: string;
    /** location of input S3 objects - if left empty will generate rule for s3 access to all [*] */
    readonly s3InputBucket?: string;
    /** prefix for input S3 objects - if left empty will generate rule for s3 access to all [*] */
    readonly s3InputPrefix?: string;
    /** The prefix to use for the output files */
    readonly textractAPI?: 'GENERIC' | 'EXPENSE';
    readonly lambdaLogLevel?: string;
    /**not implemented yet */
    readonly enableMonitoring?: boolean;
    /** not implemented yet */
    readonly enableDashboard?: boolean;
    /** not implemented yet */
    readonly customFunction?: LambdaInvoke;
    readonly workflowTracingEnabled?: boolean;
    /** how long can we wait for the process (default is 48 hours (60*48=2880)) */
    readonly textractStateMachineTimeoutMinutes?: number;
    readonly taskTokenTableName?: string;
    /**
         * The JSON input for the execution, same as that of StartExecution.
         *
         * @see https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html
         *
         * @default - The state input (JSON path '$')
         */
    readonly input?: sfn.TaskInput;
    /**
            * The name of the execution, same as that of StartExecution.
            *
            * @see https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html
            *
            * @default - None
            */
    readonly name?: string;
    /**
            * Pass the execution ID from the context object to the execution input.
            * This allows the Step Functions UI to link child executions from parent executions, making it easier to trace execution flow across state machines.
            *
            * If you set this property to `true`, the `input` property must be an object (provided by `sfn.TaskInput.fromObject`) or omitted entirely.
            *
            * @see https://docs.aws.amazon.com/step-functions/latest/dg/concepts-nested-workflows.html#nested-execution-startid
            *
            * @default - false
            */
    readonly associateWithParent?: boolean;
}
export declare class TextractGenericAsyncSfnTask extends sfn.TaskStateBase {
    private readonly props;
    private static readonly SUPPORTED_INTEGRATION_PATTERNS;
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    protected readonly taskPolicies?: iam.PolicyStatement[];
    private readonly integrationPattern;
    stateMachine: sfn.IStateMachine;
    putOnSQSLambdaLogGroup: ILogGroup;
    startTextractLambdaLogGroup: ILogGroup;
    receiveStartSNSLambdaLogGroup: ILogGroup;
    dashboardName: string;
    taskTokenTableName: string;
    textractAsyncSNSRole: IRole;
    textractAsyncSNS: sns.ITopic;
    textractAsyncSQS: sqs.IQueue;
    version: string;
    textractAsyncCallFunction: lambda.IFunction;
    textractPutOnSQSFunction: lambda.IFunction;
    textractAsyncReceiveSNSFunction: lambda.IFunction;
    constructor(scope: Construct, id: string, props: TextractGenericAsyncSfnTaskProps);
    /**
         * @internal
         */
    protected _renderTask(): any;
    /**
         * As StateMachineArn is extracted automatically from the state machine object included in the constructor,
         *
         * the scoped access policy should be generated accordingly.
         *
         * This means the action of StartExecution should be restricted on the given state machine, instead of being granted to all the resources (*).
         */
    private createScopedAccessPolicy;
}
//# sourceMappingURL=index.d.ts.map