# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### TextractAsyncToJSON <a name="TextractAsyncToJSON" id="schadem-cdk-construct-textract-generic-async.TextractAsyncToJSON"></a>

#### Initializers <a name="Initializers" id="schadem-cdk-construct-textract-generic-async.TextractAsyncToJSON.Initializer"></a>

```typescript
import { TextractAsyncToJSON } from 'schadem-cdk-construct-textract-generic-async'

new TextractAsyncToJSON(parent: Construct, id: string, props: TextractAsyncToJSONProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractAsyncToJSON.Initializer.parameter.parent">parent</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractAsyncToJSON.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractAsyncToJSON.Initializer.parameter.props">props</a></code> | <code><a href="#schadem-cdk-construct-textract-generic-async.TextractAsyncToJSONProps">TextractAsyncToJSONProps</a></code> | *No description.* |

---

##### `parent`<sup>Required</sup> <a name="parent" id="schadem-cdk-construct-textract-generic-async.TextractAsyncToJSON.Initializer.parameter.parent"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="schadem-cdk-construct-textract-generic-async.TextractAsyncToJSON.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="schadem-cdk-construct-textract-generic-async.TextractAsyncToJSON.Initializer.parameter.props"></a>

- *Type:* <a href="#schadem-cdk-construct-textract-generic-async.TextractAsyncToJSONProps">TextractAsyncToJSONProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractAsyncToJSON.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractAsyncToJSON.next">next</a></code> | Continue normal execution with the given state. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractAsyncToJSON.prefixStates">prefixStates</a></code> | Prefix the IDs of all states in this state machine fragment. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractAsyncToJSON.toSingleState">toSingleState</a></code> | Wrap all states in this state machine fragment up into a single state. |

---

##### `toString` <a name="toString" id="schadem-cdk-construct-textract-generic-async.TextractAsyncToJSON.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `next` <a name="next" id="schadem-cdk-construct-textract-generic-async.TextractAsyncToJSON.next"></a>

```typescript
public next(next: IChainable): Chain
```

Continue normal execution with the given state.

###### `next`<sup>Required</sup> <a name="next" id="schadem-cdk-construct-textract-generic-async.TextractAsyncToJSON.next.parameter.next"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.IChainable

---

##### `prefixStates` <a name="prefixStates" id="schadem-cdk-construct-textract-generic-async.TextractAsyncToJSON.prefixStates"></a>

```typescript
public prefixStates(prefix?: string): StateMachineFragment
```

Prefix the IDs of all states in this state machine fragment.

Use this to avoid multiple copies of the state machine all having the
same state IDs.

###### `prefix`<sup>Optional</sup> <a name="prefix" id="schadem-cdk-construct-textract-generic-async.TextractAsyncToJSON.prefixStates.parameter.prefix"></a>

- *Type:* string

The prefix to add.

Will use construct ID by default.

---

##### `toSingleState` <a name="toSingleState" id="schadem-cdk-construct-textract-generic-async.TextractAsyncToJSON.toSingleState"></a>

```typescript
public toSingleState(options?: SingleStateOptions): Parallel
```

Wrap all states in this state machine fragment up into a single state.

This can be used to add retry or error handling onto this state
machine fragment.

Be aware that this changes the result of the inner state machine
to be an array with the result of the state machine in it. Adjust
your paths accordingly. For example, change 'outputPath' to
'$[0]'.

###### `options`<sup>Optional</sup> <a name="options" id="schadem-cdk-construct-textract-generic-async.TextractAsyncToJSON.toSingleState.parameter.options"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.SingleStateOptions

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractAsyncToJSON.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="schadem-cdk-construct-textract-generic-async.TextractAsyncToJSON.isConstruct"></a>

```typescript
import { TextractAsyncToJSON } from 'schadem-cdk-construct-textract-generic-async'

TextractAsyncToJSON.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="schadem-cdk-construct-textract-generic-async.TextractAsyncToJSON.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractAsyncToJSON.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractAsyncToJSON.property.endStates">endStates</a></code> | <code>aws-cdk-lib.aws_stepfunctions.INextable[]</code> | The states to chain onto if this fragment is used. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractAsyncToJSON.property.id">id</a></code> | <code>string</code> | Descriptive identifier for this chainable. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractAsyncToJSON.property.startState">startState</a></code> | <code>aws-cdk-lib.aws_stepfunctions.State</code> | The start state of this state machine fragment. |

---

##### `node`<sup>Required</sup> <a name="node" id="schadem-cdk-construct-textract-generic-async.TextractAsyncToJSON.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `endStates`<sup>Required</sup> <a name="endStates" id="schadem-cdk-construct-textract-generic-async.TextractAsyncToJSON.property.endStates"></a>

```typescript
public readonly endStates: INextable[];
```

- *Type:* aws-cdk-lib.aws_stepfunctions.INextable[]

The states to chain onto if this fragment is used.

---

##### `id`<sup>Required</sup> <a name="id" id="schadem-cdk-construct-textract-generic-async.TextractAsyncToJSON.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

Descriptive identifier for this chainable.

---

##### `startState`<sup>Required</sup> <a name="startState" id="schadem-cdk-construct-textract-generic-async.TextractAsyncToJSON.property.startState"></a>

```typescript
public readonly startState: State;
```

- *Type:* aws-cdk-lib.aws_stepfunctions.State

The start state of this state machine fragment.

---


### TextractClassificationConfigurator <a name="TextractClassificationConfigurator" id="schadem-cdk-construct-textract-generic-async.TextractClassificationConfigurator"></a>

#### Initializers <a name="Initializers" id="schadem-cdk-construct-textract-generic-async.TextractClassificationConfigurator.Initializer"></a>

```typescript
import { TextractClassificationConfigurator } from 'schadem-cdk-construct-textract-generic-async'

new TextractClassificationConfigurator(parent: Construct, id: string, props: TextractClassificationConfiguratorProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractClassificationConfigurator.Initializer.parameter.parent">parent</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractClassificationConfigurator.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractClassificationConfigurator.Initializer.parameter.props">props</a></code> | <code><a href="#schadem-cdk-construct-textract-generic-async.TextractClassificationConfiguratorProps">TextractClassificationConfiguratorProps</a></code> | *No description.* |

---

##### `parent`<sup>Required</sup> <a name="parent" id="schadem-cdk-construct-textract-generic-async.TextractClassificationConfigurator.Initializer.parameter.parent"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="schadem-cdk-construct-textract-generic-async.TextractClassificationConfigurator.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="schadem-cdk-construct-textract-generic-async.TextractClassificationConfigurator.Initializer.parameter.props"></a>

- *Type:* <a href="#schadem-cdk-construct-textract-generic-async.TextractClassificationConfiguratorProps">TextractClassificationConfiguratorProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractClassificationConfigurator.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractClassificationConfigurator.next">next</a></code> | Continue normal execution with the given state. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractClassificationConfigurator.prefixStates">prefixStates</a></code> | Prefix the IDs of all states in this state machine fragment. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractClassificationConfigurator.toSingleState">toSingleState</a></code> | Wrap all states in this state machine fragment up into a single state. |

---

##### `toString` <a name="toString" id="schadem-cdk-construct-textract-generic-async.TextractClassificationConfigurator.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `next` <a name="next" id="schadem-cdk-construct-textract-generic-async.TextractClassificationConfigurator.next"></a>

```typescript
public next(next: IChainable): Chain
```

Continue normal execution with the given state.

###### `next`<sup>Required</sup> <a name="next" id="schadem-cdk-construct-textract-generic-async.TextractClassificationConfigurator.next.parameter.next"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.IChainable

---

##### `prefixStates` <a name="prefixStates" id="schadem-cdk-construct-textract-generic-async.TextractClassificationConfigurator.prefixStates"></a>

```typescript
public prefixStates(prefix?: string): StateMachineFragment
```

Prefix the IDs of all states in this state machine fragment.

Use this to avoid multiple copies of the state machine all having the
same state IDs.

###### `prefix`<sup>Optional</sup> <a name="prefix" id="schadem-cdk-construct-textract-generic-async.TextractClassificationConfigurator.prefixStates.parameter.prefix"></a>

- *Type:* string

The prefix to add.

Will use construct ID by default.

---

##### `toSingleState` <a name="toSingleState" id="schadem-cdk-construct-textract-generic-async.TextractClassificationConfigurator.toSingleState"></a>

```typescript
public toSingleState(options?: SingleStateOptions): Parallel
```

Wrap all states in this state machine fragment up into a single state.

This can be used to add retry or error handling onto this state
machine fragment.

Be aware that this changes the result of the inner state machine
to be an array with the result of the state machine in it. Adjust
your paths accordingly. For example, change 'outputPath' to
'$[0]'.

###### `options`<sup>Optional</sup> <a name="options" id="schadem-cdk-construct-textract-generic-async.TextractClassificationConfigurator.toSingleState.parameter.options"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.SingleStateOptions

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractClassificationConfigurator.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="schadem-cdk-construct-textract-generic-async.TextractClassificationConfigurator.isConstruct"></a>

```typescript
import { TextractClassificationConfigurator } from 'schadem-cdk-construct-textract-generic-async'

TextractClassificationConfigurator.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="schadem-cdk-construct-textract-generic-async.TextractClassificationConfigurator.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractClassificationConfigurator.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractClassificationConfigurator.property.endStates">endStates</a></code> | <code>aws-cdk-lib.aws_stepfunctions.INextable[]</code> | The states to chain onto if this fragment is used. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractClassificationConfigurator.property.id">id</a></code> | <code>string</code> | Descriptive identifier for this chainable. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractClassificationConfigurator.property.startState">startState</a></code> | <code>aws-cdk-lib.aws_stepfunctions.State</code> | The start state of this state machine fragment. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractClassificationConfigurator.property.configurationTable">configurationTable</a></code> | <code>aws-cdk-lib.aws_dynamodb.ITable</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractClassificationConfigurator.property.configuratorFunction">configuratorFunction</a></code> | <code>aws-cdk-lib.aws_lambda.IFunction</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractClassificationConfigurator.property.configuratorFunctionLogGroupName">configuratorFunctionLogGroupName</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="schadem-cdk-construct-textract-generic-async.TextractClassificationConfigurator.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `endStates`<sup>Required</sup> <a name="endStates" id="schadem-cdk-construct-textract-generic-async.TextractClassificationConfigurator.property.endStates"></a>

```typescript
public readonly endStates: INextable[];
```

- *Type:* aws-cdk-lib.aws_stepfunctions.INextable[]

The states to chain onto if this fragment is used.

---

##### `id`<sup>Required</sup> <a name="id" id="schadem-cdk-construct-textract-generic-async.TextractClassificationConfigurator.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

Descriptive identifier for this chainable.

---

##### `startState`<sup>Required</sup> <a name="startState" id="schadem-cdk-construct-textract-generic-async.TextractClassificationConfigurator.property.startState"></a>

```typescript
public readonly startState: State;
```

- *Type:* aws-cdk-lib.aws_stepfunctions.State

The start state of this state machine fragment.

---

##### `configurationTable`<sup>Required</sup> <a name="configurationTable" id="schadem-cdk-construct-textract-generic-async.TextractClassificationConfigurator.property.configurationTable"></a>

```typescript
public readonly configurationTable: ITable;
```

- *Type:* aws-cdk-lib.aws_dynamodb.ITable

---

##### `configuratorFunction`<sup>Required</sup> <a name="configuratorFunction" id="schadem-cdk-construct-textract-generic-async.TextractClassificationConfigurator.property.configuratorFunction"></a>

```typescript
public readonly configuratorFunction: IFunction;
```

- *Type:* aws-cdk-lib.aws_lambda.IFunction

---

##### `configuratorFunctionLogGroupName`<sup>Required</sup> <a name="configuratorFunctionLogGroupName" id="schadem-cdk-construct-textract-generic-async.TextractClassificationConfigurator.property.configuratorFunctionLogGroupName"></a>

```typescript
public readonly configuratorFunctionLogGroupName: string;
```

- *Type:* string

---


### TextractGenerateCSV <a name="TextractGenerateCSV" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV"></a>

#### Initializers <a name="Initializers" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.Initializer"></a>

```typescript
import { TextractGenerateCSV } from 'schadem-cdk-construct-textract-generic-async'

new TextractGenerateCSV(scope: Construct, id: string, props: TextractGenerateCSVProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.Initializer.parameter.props">props</a></code> | <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSVProps">TextractGenerateCSVProps</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.Initializer.parameter.props"></a>

- *Type:* <a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSVProps">TextractGenerateCSVProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.addPrefix">addPrefix</a></code> | Add a prefix to the stateId of this state. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.bindToGraph">bindToGraph</a></code> | Register this state as part of the given graph. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.toStateJson">toStateJson</a></code> | Return the Amazon States Language object for this state. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.addCatch">addCatch</a></code> | Add a recovery handler for this state. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.addRetry">addRetry</a></code> | Add retry configuration for this state. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.metric">metric</a></code> | Return the given named metric for this Task. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.metricFailed">metricFailed</a></code> | Metric for the number of times this activity fails. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.metricHeartbeatTimedOut">metricHeartbeatTimedOut</a></code> | Metric for the number of times the heartbeat times out for this activity. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.metricRunTime">metricRunTime</a></code> | The interval, in milliseconds, between the time the Task starts and the time it closes. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.metricScheduled">metricScheduled</a></code> | Metric for the number of times this activity is scheduled. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.metricScheduleTime">metricScheduleTime</a></code> | The interval, in milliseconds, for which the activity stays in the schedule state. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.metricStarted">metricStarted</a></code> | Metric for the number of times this activity is started. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.metricSucceeded">metricSucceeded</a></code> | Metric for the number of times this activity succeeds. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.metricTime">metricTime</a></code> | The interval, in milliseconds, between the time the activity is scheduled and the time it closes. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.metricTimedOut">metricTimedOut</a></code> | Metric for the number of times this activity times out. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.next">next</a></code> | Continue normal execution with the given state. |

---

##### `toString` <a name="toString" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addPrefix` <a name="addPrefix" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.addPrefix"></a>

```typescript
public addPrefix(x: string): void
```

Add a prefix to the stateId of this state.

###### `x`<sup>Required</sup> <a name="x" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.addPrefix.parameter.x"></a>

- *Type:* string

---

##### `bindToGraph` <a name="bindToGraph" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.bindToGraph"></a>

```typescript
public bindToGraph(graph: StateGraph): void
```

Register this state as part of the given graph.

Don't call this. It will be called automatically when you work
with states normally.

###### `graph`<sup>Required</sup> <a name="graph" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.bindToGraph.parameter.graph"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.StateGraph

---

##### `toStateJson` <a name="toStateJson" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.toStateJson"></a>

```typescript
public toStateJson(): object
```

Return the Amazon States Language object for this state.

##### `addCatch` <a name="addCatch" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.addCatch"></a>

```typescript
public addCatch(handler: IChainable, props?: CatchProps): TaskStateBase
```

Add a recovery handler for this state.

When a particular error occurs, execution will continue at the error
handler instead of failing the state machine execution.

###### `handler`<sup>Required</sup> <a name="handler" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.addCatch.parameter.handler"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.IChainable

---

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.addCatch.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.CatchProps

---

##### `addRetry` <a name="addRetry" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.addRetry"></a>

```typescript
public addRetry(props?: RetryProps): TaskStateBase
```

Add retry configuration for this state.

This controls if and how the execution will be retried if a particular
error occurs.

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.addRetry.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.RetryProps

---

##### `metric` <a name="metric" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.metric"></a>

```typescript
public metric(metricName: string, props?: MetricOptions): Metric
```

Return the given named metric for this Task.

###### `metricName`<sup>Required</sup> <a name="metricName" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.metric.parameter.metricName"></a>

- *Type:* string

---

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.metric.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `metricFailed` <a name="metricFailed" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.metricFailed"></a>

```typescript
public metricFailed(props?: MetricOptions): Metric
```

Metric for the number of times this activity fails.

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.metricFailed.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `metricHeartbeatTimedOut` <a name="metricHeartbeatTimedOut" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.metricHeartbeatTimedOut"></a>

```typescript
public metricHeartbeatTimedOut(props?: MetricOptions): Metric
```

Metric for the number of times the heartbeat times out for this activity.

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.metricHeartbeatTimedOut.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `metricRunTime` <a name="metricRunTime" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.metricRunTime"></a>

```typescript
public metricRunTime(props?: MetricOptions): Metric
```

The interval, in milliseconds, between the time the Task starts and the time it closes.

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.metricRunTime.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `metricScheduled` <a name="metricScheduled" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.metricScheduled"></a>

```typescript
public metricScheduled(props?: MetricOptions): Metric
```

Metric for the number of times this activity is scheduled.

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.metricScheduled.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `metricScheduleTime` <a name="metricScheduleTime" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.metricScheduleTime"></a>

```typescript
public metricScheduleTime(props?: MetricOptions): Metric
```

The interval, in milliseconds, for which the activity stays in the schedule state.

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.metricScheduleTime.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `metricStarted` <a name="metricStarted" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.metricStarted"></a>

```typescript
public metricStarted(props?: MetricOptions): Metric
```

Metric for the number of times this activity is started.

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.metricStarted.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `metricSucceeded` <a name="metricSucceeded" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.metricSucceeded"></a>

```typescript
public metricSucceeded(props?: MetricOptions): Metric
```

Metric for the number of times this activity succeeds.

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.metricSucceeded.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `metricTime` <a name="metricTime" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.metricTime"></a>

```typescript
public metricTime(props?: MetricOptions): Metric
```

The interval, in milliseconds, between the time the activity is scheduled and the time it closes.

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.metricTime.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `metricTimedOut` <a name="metricTimedOut" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.metricTimedOut"></a>

```typescript
public metricTimedOut(props?: MetricOptions): Metric
```

Metric for the number of times this activity times out.

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.metricTimedOut.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `next` <a name="next" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.next"></a>

```typescript
public next(next: IChainable): Chain
```

Continue normal execution with the given state.

###### `next`<sup>Required</sup> <a name="next" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.next.parameter.next"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.IChainable

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.filterNextables">filterNextables</a></code> | Return only the states that allow chaining from an array of states. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.findReachableEndStates">findReachableEndStates</a></code> | Find the set of end states states reachable through transitions from the given start state. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.findReachableStates">findReachableStates</a></code> | Find the set of states reachable through transitions from the given start state. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.prefixStates">prefixStates</a></code> | Add a prefix to the stateId of all States found in a construct tree. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.isConstruct"></a>

```typescript
import { TextractGenerateCSV } from 'schadem-cdk-construct-textract-generic-async'

TextractGenerateCSV.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `filterNextables` <a name="filterNextables" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.filterNextables"></a>

```typescript
import { TextractGenerateCSV } from 'schadem-cdk-construct-textract-generic-async'

TextractGenerateCSV.filterNextables(states: State[])
```

Return only the states that allow chaining from an array of states.

###### `states`<sup>Required</sup> <a name="states" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.filterNextables.parameter.states"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.State[]

---

##### `findReachableEndStates` <a name="findReachableEndStates" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.findReachableEndStates"></a>

```typescript
import { TextractGenerateCSV } from 'schadem-cdk-construct-textract-generic-async'

TextractGenerateCSV.findReachableEndStates(start: State, options?: FindStateOptions)
```

Find the set of end states states reachable through transitions from the given start state.

###### `start`<sup>Required</sup> <a name="start" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.findReachableEndStates.parameter.start"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.State

---

###### `options`<sup>Optional</sup> <a name="options" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.findReachableEndStates.parameter.options"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.FindStateOptions

---

##### `findReachableStates` <a name="findReachableStates" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.findReachableStates"></a>

```typescript
import { TextractGenerateCSV } from 'schadem-cdk-construct-textract-generic-async'

TextractGenerateCSV.findReachableStates(start: State, options?: FindStateOptions)
```

Find the set of states reachable through transitions from the given start state.

This does not retrieve states from within sub-graphs, such as states within a Parallel state's branch.

###### `start`<sup>Required</sup> <a name="start" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.findReachableStates.parameter.start"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.State

---

###### `options`<sup>Optional</sup> <a name="options" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.findReachableStates.parameter.options"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.FindStateOptions

---

##### `prefixStates` <a name="prefixStates" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.prefixStates"></a>

```typescript
import { TextractGenerateCSV } from 'schadem-cdk-construct-textract-generic-async'

TextractGenerateCSV.prefixStates(root: IConstruct, prefix: string)
```

Add a prefix to the stateId of all States found in a construct tree.

###### `root`<sup>Required</sup> <a name="root" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.prefixStates.parameter.root"></a>

- *Type:* constructs.IConstruct

---

###### `prefix`<sup>Required</sup> <a name="prefix" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.prefixStates.parameter.prefix"></a>

- *Type:* string

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.property.endStates">endStates</a></code> | <code>aws-cdk-lib.aws_stepfunctions.INextable[]</code> | Continuable states of this Chainable. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.property.id">id</a></code> | <code>string</code> | Descriptive identifier for this chainable. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.property.startState">startState</a></code> | <code>aws-cdk-lib.aws_stepfunctions.State</code> | First state of this Chainable. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.property.stateId">stateId</a></code> | <code>string</code> | Tokenized string that evaluates to the state's ID. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.property.generateCSVLambda">generateCSVLambda</a></code> | <code>aws-cdk-lib.aws_lambda.IFunction</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.property.generateCSVLogGroup">generateCSVLogGroup</a></code> | <code>aws-cdk-lib.aws_logs.ILogGroup</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.property.stateMachine">stateMachine</a></code> | <code>aws-cdk-lib.aws_stepfunctions.StateMachine</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `endStates`<sup>Required</sup> <a name="endStates" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.property.endStates"></a>

```typescript
public readonly endStates: INextable[];
```

- *Type:* aws-cdk-lib.aws_stepfunctions.INextable[]

Continuable states of this Chainable.

---

##### `id`<sup>Required</sup> <a name="id" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

Descriptive identifier for this chainable.

---

##### `startState`<sup>Required</sup> <a name="startState" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.property.startState"></a>

```typescript
public readonly startState: State;
```

- *Type:* aws-cdk-lib.aws_stepfunctions.State

First state of this Chainable.

---

##### `stateId`<sup>Required</sup> <a name="stateId" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.property.stateId"></a>

```typescript
public readonly stateId: string;
```

- *Type:* string

Tokenized string that evaluates to the state's ID.

---

##### `generateCSVLambda`<sup>Required</sup> <a name="generateCSVLambda" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.property.generateCSVLambda"></a>

```typescript
public readonly generateCSVLambda: IFunction;
```

- *Type:* aws-cdk-lib.aws_lambda.IFunction

---

##### `generateCSVLogGroup`<sup>Required</sup> <a name="generateCSVLogGroup" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.property.generateCSVLogGroup"></a>

```typescript
public readonly generateCSVLogGroup: ILogGroup;
```

- *Type:* aws-cdk-lib.aws_logs.ILogGroup

---

##### `stateMachine`<sup>Required</sup> <a name="stateMachine" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSV.property.stateMachine"></a>

```typescript
public readonly stateMachine: StateMachine;
```

- *Type:* aws-cdk-lib.aws_stepfunctions.StateMachine

---


### TextractGenericAsyncSfnTask <a name="TextractGenericAsyncSfnTask" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask"></a>

#### Initializers <a name="Initializers" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.Initializer"></a>

```typescript
import { TextractGenericAsyncSfnTask } from 'schadem-cdk-construct-textract-generic-async'

new TextractGenericAsyncSfnTask(scope: Construct, id: string, props: TextractGenericAsyncSfnTaskProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.Initializer.parameter.props">props</a></code> | <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps">TextractGenericAsyncSfnTaskProps</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.Initializer.parameter.props"></a>

- *Type:* <a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps">TextractGenericAsyncSfnTaskProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.addPrefix">addPrefix</a></code> | Add a prefix to the stateId of this state. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.bindToGraph">bindToGraph</a></code> | Register this state as part of the given graph. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.toStateJson">toStateJson</a></code> | Return the Amazon States Language object for this state. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.addCatch">addCatch</a></code> | Add a recovery handler for this state. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.addRetry">addRetry</a></code> | Add retry configuration for this state. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.metric">metric</a></code> | Return the given named metric for this Task. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.metricFailed">metricFailed</a></code> | Metric for the number of times this activity fails. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.metricHeartbeatTimedOut">metricHeartbeatTimedOut</a></code> | Metric for the number of times the heartbeat times out for this activity. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.metricRunTime">metricRunTime</a></code> | The interval, in milliseconds, between the time the Task starts and the time it closes. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.metricScheduled">metricScheduled</a></code> | Metric for the number of times this activity is scheduled. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.metricScheduleTime">metricScheduleTime</a></code> | The interval, in milliseconds, for which the activity stays in the schedule state. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.metricStarted">metricStarted</a></code> | Metric for the number of times this activity is started. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.metricSucceeded">metricSucceeded</a></code> | Metric for the number of times this activity succeeds. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.metricTime">metricTime</a></code> | The interval, in milliseconds, between the time the activity is scheduled and the time it closes. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.metricTimedOut">metricTimedOut</a></code> | Metric for the number of times this activity times out. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.next">next</a></code> | Continue normal execution with the given state. |

---

##### `toString` <a name="toString" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addPrefix` <a name="addPrefix" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.addPrefix"></a>

```typescript
public addPrefix(x: string): void
```

Add a prefix to the stateId of this state.

###### `x`<sup>Required</sup> <a name="x" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.addPrefix.parameter.x"></a>

- *Type:* string

---

##### `bindToGraph` <a name="bindToGraph" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.bindToGraph"></a>

```typescript
public bindToGraph(graph: StateGraph): void
```

Register this state as part of the given graph.

Don't call this. It will be called automatically when you work
with states normally.

###### `graph`<sup>Required</sup> <a name="graph" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.bindToGraph.parameter.graph"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.StateGraph

---

##### `toStateJson` <a name="toStateJson" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.toStateJson"></a>

```typescript
public toStateJson(): object
```

Return the Amazon States Language object for this state.

##### `addCatch` <a name="addCatch" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.addCatch"></a>

```typescript
public addCatch(handler: IChainable, props?: CatchProps): TaskStateBase
```

Add a recovery handler for this state.

When a particular error occurs, execution will continue at the error
handler instead of failing the state machine execution.

###### `handler`<sup>Required</sup> <a name="handler" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.addCatch.parameter.handler"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.IChainable

---

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.addCatch.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.CatchProps

---

##### `addRetry` <a name="addRetry" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.addRetry"></a>

```typescript
public addRetry(props?: RetryProps): TaskStateBase
```

Add retry configuration for this state.

This controls if and how the execution will be retried if a particular
error occurs.

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.addRetry.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.RetryProps

---

##### `metric` <a name="metric" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.metric"></a>

```typescript
public metric(metricName: string, props?: MetricOptions): Metric
```

Return the given named metric for this Task.

###### `metricName`<sup>Required</sup> <a name="metricName" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.metric.parameter.metricName"></a>

- *Type:* string

---

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.metric.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `metricFailed` <a name="metricFailed" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.metricFailed"></a>

```typescript
public metricFailed(props?: MetricOptions): Metric
```

Metric for the number of times this activity fails.

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.metricFailed.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `metricHeartbeatTimedOut` <a name="metricHeartbeatTimedOut" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.metricHeartbeatTimedOut"></a>

```typescript
public metricHeartbeatTimedOut(props?: MetricOptions): Metric
```

Metric for the number of times the heartbeat times out for this activity.

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.metricHeartbeatTimedOut.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `metricRunTime` <a name="metricRunTime" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.metricRunTime"></a>

```typescript
public metricRunTime(props?: MetricOptions): Metric
```

The interval, in milliseconds, between the time the Task starts and the time it closes.

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.metricRunTime.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `metricScheduled` <a name="metricScheduled" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.metricScheduled"></a>

```typescript
public metricScheduled(props?: MetricOptions): Metric
```

Metric for the number of times this activity is scheduled.

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.metricScheduled.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `metricScheduleTime` <a name="metricScheduleTime" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.metricScheduleTime"></a>

```typescript
public metricScheduleTime(props?: MetricOptions): Metric
```

The interval, in milliseconds, for which the activity stays in the schedule state.

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.metricScheduleTime.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `metricStarted` <a name="metricStarted" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.metricStarted"></a>

```typescript
public metricStarted(props?: MetricOptions): Metric
```

Metric for the number of times this activity is started.

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.metricStarted.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `metricSucceeded` <a name="metricSucceeded" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.metricSucceeded"></a>

```typescript
public metricSucceeded(props?: MetricOptions): Metric
```

Metric for the number of times this activity succeeds.

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.metricSucceeded.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `metricTime` <a name="metricTime" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.metricTime"></a>

```typescript
public metricTime(props?: MetricOptions): Metric
```

The interval, in milliseconds, between the time the activity is scheduled and the time it closes.

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.metricTime.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `metricTimedOut` <a name="metricTimedOut" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.metricTimedOut"></a>

```typescript
public metricTimedOut(props?: MetricOptions): Metric
```

Metric for the number of times this activity times out.

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.metricTimedOut.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `next` <a name="next" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.next"></a>

```typescript
public next(next: IChainable): Chain
```

Continue normal execution with the given state.

###### `next`<sup>Required</sup> <a name="next" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.next.parameter.next"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.IChainable

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.filterNextables">filterNextables</a></code> | Return only the states that allow chaining from an array of states. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.findReachableEndStates">findReachableEndStates</a></code> | Find the set of end states states reachable through transitions from the given start state. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.findReachableStates">findReachableStates</a></code> | Find the set of states reachable through transitions from the given start state. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.prefixStates">prefixStates</a></code> | Add a prefix to the stateId of all States found in a construct tree. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.isConstruct"></a>

```typescript
import { TextractGenericAsyncSfnTask } from 'schadem-cdk-construct-textract-generic-async'

TextractGenericAsyncSfnTask.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `filterNextables` <a name="filterNextables" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.filterNextables"></a>

```typescript
import { TextractGenericAsyncSfnTask } from 'schadem-cdk-construct-textract-generic-async'

TextractGenericAsyncSfnTask.filterNextables(states: State[])
```

Return only the states that allow chaining from an array of states.

###### `states`<sup>Required</sup> <a name="states" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.filterNextables.parameter.states"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.State[]

---

##### `findReachableEndStates` <a name="findReachableEndStates" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.findReachableEndStates"></a>

```typescript
import { TextractGenericAsyncSfnTask } from 'schadem-cdk-construct-textract-generic-async'

TextractGenericAsyncSfnTask.findReachableEndStates(start: State, options?: FindStateOptions)
```

Find the set of end states states reachable through transitions from the given start state.

###### `start`<sup>Required</sup> <a name="start" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.findReachableEndStates.parameter.start"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.State

---

###### `options`<sup>Optional</sup> <a name="options" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.findReachableEndStates.parameter.options"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.FindStateOptions

---

##### `findReachableStates` <a name="findReachableStates" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.findReachableStates"></a>

```typescript
import { TextractGenericAsyncSfnTask } from 'schadem-cdk-construct-textract-generic-async'

TextractGenericAsyncSfnTask.findReachableStates(start: State, options?: FindStateOptions)
```

Find the set of states reachable through transitions from the given start state.

This does not retrieve states from within sub-graphs, such as states within a Parallel state's branch.

###### `start`<sup>Required</sup> <a name="start" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.findReachableStates.parameter.start"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.State

---

###### `options`<sup>Optional</sup> <a name="options" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.findReachableStates.parameter.options"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.FindStateOptions

---

##### `prefixStates` <a name="prefixStates" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.prefixStates"></a>

```typescript
import { TextractGenericAsyncSfnTask } from 'schadem-cdk-construct-textract-generic-async'

TextractGenericAsyncSfnTask.prefixStates(root: IConstruct, prefix: string)
```

Add a prefix to the stateId of all States found in a construct tree.

###### `root`<sup>Required</sup> <a name="root" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.prefixStates.parameter.root"></a>

- *Type:* constructs.IConstruct

---

###### `prefix`<sup>Required</sup> <a name="prefix" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.prefixStates.parameter.prefix"></a>

- *Type:* string

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.property.endStates">endStates</a></code> | <code>aws-cdk-lib.aws_stepfunctions.INextable[]</code> | Continuable states of this Chainable. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.property.id">id</a></code> | <code>string</code> | Descriptive identifier for this chainable. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.property.startState">startState</a></code> | <code>aws-cdk-lib.aws_stepfunctions.State</code> | First state of this Chainable. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.property.stateId">stateId</a></code> | <code>string</code> | Tokenized string that evaluates to the state's ID. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.property.dashboardName">dashboardName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.property.putOnSQSLambdaLogGroup">putOnSQSLambdaLogGroup</a></code> | <code>aws-cdk-lib.aws_logs.ILogGroup</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.property.receiveStartSNSLambdaLogGroup">receiveStartSNSLambdaLogGroup</a></code> | <code>aws-cdk-lib.aws_logs.ILogGroup</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.property.startTextractLambdaLogGroup">startTextractLambdaLogGroup</a></code> | <code>aws-cdk-lib.aws_logs.ILogGroup</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.property.stateMachine">stateMachine</a></code> | <code>aws-cdk-lib.aws_stepfunctions.IStateMachine</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.property.taskTokenTableName">taskTokenTableName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.property.textractAsyncCallFunction">textractAsyncCallFunction</a></code> | <code>aws-cdk-lib.aws_lambda.IFunction</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.property.textractAsyncReceiveSNSFunction">textractAsyncReceiveSNSFunction</a></code> | <code>aws-cdk-lib.aws_lambda.IFunction</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.property.textractAsyncSNS">textractAsyncSNS</a></code> | <code>aws-cdk-lib.aws_sns.ITopic</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.property.textractAsyncSNSRole">textractAsyncSNSRole</a></code> | <code>aws-cdk-lib.aws_iam.IRole</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.property.textractAsyncSQS">textractAsyncSQS</a></code> | <code>aws-cdk-lib.aws_sqs.IQueue</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.property.textractPutOnSQSFunction">textractPutOnSQSFunction</a></code> | <code>aws-cdk-lib.aws_lambda.IFunction</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.property.version">version</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `endStates`<sup>Required</sup> <a name="endStates" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.property.endStates"></a>

```typescript
public readonly endStates: INextable[];
```

- *Type:* aws-cdk-lib.aws_stepfunctions.INextable[]

Continuable states of this Chainable.

---

##### `id`<sup>Required</sup> <a name="id" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

Descriptive identifier for this chainable.

---

##### `startState`<sup>Required</sup> <a name="startState" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.property.startState"></a>

```typescript
public readonly startState: State;
```

- *Type:* aws-cdk-lib.aws_stepfunctions.State

First state of this Chainable.

---

##### `stateId`<sup>Required</sup> <a name="stateId" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.property.stateId"></a>

```typescript
public readonly stateId: string;
```

- *Type:* string

Tokenized string that evaluates to the state's ID.

---

##### `dashboardName`<sup>Required</sup> <a name="dashboardName" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.property.dashboardName"></a>

```typescript
public readonly dashboardName: string;
```

- *Type:* string

---

##### `putOnSQSLambdaLogGroup`<sup>Required</sup> <a name="putOnSQSLambdaLogGroup" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.property.putOnSQSLambdaLogGroup"></a>

```typescript
public readonly putOnSQSLambdaLogGroup: ILogGroup;
```

- *Type:* aws-cdk-lib.aws_logs.ILogGroup

---

##### `receiveStartSNSLambdaLogGroup`<sup>Required</sup> <a name="receiveStartSNSLambdaLogGroup" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.property.receiveStartSNSLambdaLogGroup"></a>

```typescript
public readonly receiveStartSNSLambdaLogGroup: ILogGroup;
```

- *Type:* aws-cdk-lib.aws_logs.ILogGroup

---

##### `startTextractLambdaLogGroup`<sup>Required</sup> <a name="startTextractLambdaLogGroup" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.property.startTextractLambdaLogGroup"></a>

```typescript
public readonly startTextractLambdaLogGroup: ILogGroup;
```

- *Type:* aws-cdk-lib.aws_logs.ILogGroup

---

##### `stateMachine`<sup>Required</sup> <a name="stateMachine" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.property.stateMachine"></a>

```typescript
public readonly stateMachine: IStateMachine;
```

- *Type:* aws-cdk-lib.aws_stepfunctions.IStateMachine

---

##### `taskTokenTableName`<sup>Required</sup> <a name="taskTokenTableName" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.property.taskTokenTableName"></a>

```typescript
public readonly taskTokenTableName: string;
```

- *Type:* string

---

##### `textractAsyncCallFunction`<sup>Required</sup> <a name="textractAsyncCallFunction" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.property.textractAsyncCallFunction"></a>

```typescript
public readonly textractAsyncCallFunction: IFunction;
```

- *Type:* aws-cdk-lib.aws_lambda.IFunction

---

##### `textractAsyncReceiveSNSFunction`<sup>Required</sup> <a name="textractAsyncReceiveSNSFunction" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.property.textractAsyncReceiveSNSFunction"></a>

```typescript
public readonly textractAsyncReceiveSNSFunction: IFunction;
```

- *Type:* aws-cdk-lib.aws_lambda.IFunction

---

##### `textractAsyncSNS`<sup>Required</sup> <a name="textractAsyncSNS" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.property.textractAsyncSNS"></a>

```typescript
public readonly textractAsyncSNS: ITopic;
```

- *Type:* aws-cdk-lib.aws_sns.ITopic

---

##### `textractAsyncSNSRole`<sup>Required</sup> <a name="textractAsyncSNSRole" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.property.textractAsyncSNSRole"></a>

```typescript
public readonly textractAsyncSNSRole: IRole;
```

- *Type:* aws-cdk-lib.aws_iam.IRole

---

##### `textractAsyncSQS`<sup>Required</sup> <a name="textractAsyncSQS" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.property.textractAsyncSQS"></a>

```typescript
public readonly textractAsyncSQS: IQueue;
```

- *Type:* aws-cdk-lib.aws_sqs.IQueue

---

##### `textractPutOnSQSFunction`<sup>Required</sup> <a name="textractPutOnSQSFunction" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.property.textractPutOnSQSFunction"></a>

```typescript
public readonly textractPutOnSQSFunction: IFunction;
```

- *Type:* aws-cdk-lib.aws_lambda.IFunction

---

##### `version`<sup>Required</sup> <a name="version" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTask.property.version"></a>

```typescript
public readonly version: string;
```

- *Type:* string

---


### TextractGenericSyncSfnTask <a name="TextractGenericSyncSfnTask" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask"></a>

#### Initializers <a name="Initializers" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.Initializer"></a>

```typescript
import { TextractGenericSyncSfnTask } from 'schadem-cdk-construct-textract-generic-async'

new TextractGenericSyncSfnTask(scope: Construct, id: string, props: TextractGenericSyncSfnTaskProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.Initializer.parameter.props">props</a></code> | <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps">TextractGenericSyncSfnTaskProps</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.Initializer.parameter.props"></a>

- *Type:* <a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps">TextractGenericSyncSfnTaskProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.addPrefix">addPrefix</a></code> | Add a prefix to the stateId of this state. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.bindToGraph">bindToGraph</a></code> | Register this state as part of the given graph. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.toStateJson">toStateJson</a></code> | Return the Amazon States Language object for this state. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.addCatch">addCatch</a></code> | Add a recovery handler for this state. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.addRetry">addRetry</a></code> | Add retry configuration for this state. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.metric">metric</a></code> | Return the given named metric for this Task. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.metricFailed">metricFailed</a></code> | Metric for the number of times this activity fails. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.metricHeartbeatTimedOut">metricHeartbeatTimedOut</a></code> | Metric for the number of times the heartbeat times out for this activity. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.metricRunTime">metricRunTime</a></code> | The interval, in milliseconds, between the time the Task starts and the time it closes. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.metricScheduled">metricScheduled</a></code> | Metric for the number of times this activity is scheduled. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.metricScheduleTime">metricScheduleTime</a></code> | The interval, in milliseconds, for which the activity stays in the schedule state. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.metricStarted">metricStarted</a></code> | Metric for the number of times this activity is started. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.metricSucceeded">metricSucceeded</a></code> | Metric for the number of times this activity succeeds. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.metricTime">metricTime</a></code> | The interval, in milliseconds, between the time the activity is scheduled and the time it closes. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.metricTimedOut">metricTimedOut</a></code> | Metric for the number of times this activity times out. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.next">next</a></code> | Continue normal execution with the given state. |

---

##### `toString` <a name="toString" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addPrefix` <a name="addPrefix" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.addPrefix"></a>

```typescript
public addPrefix(x: string): void
```

Add a prefix to the stateId of this state.

###### `x`<sup>Required</sup> <a name="x" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.addPrefix.parameter.x"></a>

- *Type:* string

---

##### `bindToGraph` <a name="bindToGraph" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.bindToGraph"></a>

```typescript
public bindToGraph(graph: StateGraph): void
```

Register this state as part of the given graph.

Don't call this. It will be called automatically when you work
with states normally.

###### `graph`<sup>Required</sup> <a name="graph" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.bindToGraph.parameter.graph"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.StateGraph

---

##### `toStateJson` <a name="toStateJson" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.toStateJson"></a>

```typescript
public toStateJson(): object
```

Return the Amazon States Language object for this state.

##### `addCatch` <a name="addCatch" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.addCatch"></a>

```typescript
public addCatch(handler: IChainable, props?: CatchProps): TaskStateBase
```

Add a recovery handler for this state.

When a particular error occurs, execution will continue at the error
handler instead of failing the state machine execution.

###### `handler`<sup>Required</sup> <a name="handler" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.addCatch.parameter.handler"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.IChainable

---

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.addCatch.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.CatchProps

---

##### `addRetry` <a name="addRetry" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.addRetry"></a>

```typescript
public addRetry(props?: RetryProps): TaskStateBase
```

Add retry configuration for this state.

This controls if and how the execution will be retried if a particular
error occurs.

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.addRetry.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.RetryProps

---

##### `metric` <a name="metric" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.metric"></a>

```typescript
public metric(metricName: string, props?: MetricOptions): Metric
```

Return the given named metric for this Task.

###### `metricName`<sup>Required</sup> <a name="metricName" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.metric.parameter.metricName"></a>

- *Type:* string

---

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.metric.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `metricFailed` <a name="metricFailed" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.metricFailed"></a>

```typescript
public metricFailed(props?: MetricOptions): Metric
```

Metric for the number of times this activity fails.

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.metricFailed.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `metricHeartbeatTimedOut` <a name="metricHeartbeatTimedOut" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.metricHeartbeatTimedOut"></a>

```typescript
public metricHeartbeatTimedOut(props?: MetricOptions): Metric
```

Metric for the number of times the heartbeat times out for this activity.

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.metricHeartbeatTimedOut.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `metricRunTime` <a name="metricRunTime" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.metricRunTime"></a>

```typescript
public metricRunTime(props?: MetricOptions): Metric
```

The interval, in milliseconds, between the time the Task starts and the time it closes.

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.metricRunTime.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `metricScheduled` <a name="metricScheduled" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.metricScheduled"></a>

```typescript
public metricScheduled(props?: MetricOptions): Metric
```

Metric for the number of times this activity is scheduled.

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.metricScheduled.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `metricScheduleTime` <a name="metricScheduleTime" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.metricScheduleTime"></a>

```typescript
public metricScheduleTime(props?: MetricOptions): Metric
```

The interval, in milliseconds, for which the activity stays in the schedule state.

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.metricScheduleTime.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `metricStarted` <a name="metricStarted" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.metricStarted"></a>

```typescript
public metricStarted(props?: MetricOptions): Metric
```

Metric for the number of times this activity is started.

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.metricStarted.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `metricSucceeded` <a name="metricSucceeded" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.metricSucceeded"></a>

```typescript
public metricSucceeded(props?: MetricOptions): Metric
```

Metric for the number of times this activity succeeds.

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.metricSucceeded.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `metricTime` <a name="metricTime" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.metricTime"></a>

```typescript
public metricTime(props?: MetricOptions): Metric
```

The interval, in milliseconds, between the time the activity is scheduled and the time it closes.

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.metricTime.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `metricTimedOut` <a name="metricTimedOut" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.metricTimedOut"></a>

```typescript
public metricTimedOut(props?: MetricOptions): Metric
```

Metric for the number of times this activity times out.

###### `props`<sup>Optional</sup> <a name="props" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.metricTimedOut.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.MetricOptions

---

##### `next` <a name="next" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.next"></a>

```typescript
public next(next: IChainable): Chain
```

Continue normal execution with the given state.

###### `next`<sup>Required</sup> <a name="next" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.next.parameter.next"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.IChainable

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.filterNextables">filterNextables</a></code> | Return only the states that allow chaining from an array of states. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.findReachableEndStates">findReachableEndStates</a></code> | Find the set of end states states reachable through transitions from the given start state. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.findReachableStates">findReachableStates</a></code> | Find the set of states reachable through transitions from the given start state. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.prefixStates">prefixStates</a></code> | Add a prefix to the stateId of all States found in a construct tree. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.isConstruct"></a>

```typescript
import { TextractGenericSyncSfnTask } from 'schadem-cdk-construct-textract-generic-async'

TextractGenericSyncSfnTask.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `filterNextables` <a name="filterNextables" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.filterNextables"></a>

```typescript
import { TextractGenericSyncSfnTask } from 'schadem-cdk-construct-textract-generic-async'

TextractGenericSyncSfnTask.filterNextables(states: State[])
```

Return only the states that allow chaining from an array of states.

###### `states`<sup>Required</sup> <a name="states" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.filterNextables.parameter.states"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.State[]

---

##### `findReachableEndStates` <a name="findReachableEndStates" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.findReachableEndStates"></a>

```typescript
import { TextractGenericSyncSfnTask } from 'schadem-cdk-construct-textract-generic-async'

TextractGenericSyncSfnTask.findReachableEndStates(start: State, options?: FindStateOptions)
```

Find the set of end states states reachable through transitions from the given start state.

###### `start`<sup>Required</sup> <a name="start" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.findReachableEndStates.parameter.start"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.State

---

###### `options`<sup>Optional</sup> <a name="options" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.findReachableEndStates.parameter.options"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.FindStateOptions

---

##### `findReachableStates` <a name="findReachableStates" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.findReachableStates"></a>

```typescript
import { TextractGenericSyncSfnTask } from 'schadem-cdk-construct-textract-generic-async'

TextractGenericSyncSfnTask.findReachableStates(start: State, options?: FindStateOptions)
```

Find the set of states reachable through transitions from the given start state.

This does not retrieve states from within sub-graphs, such as states within a Parallel state's branch.

###### `start`<sup>Required</sup> <a name="start" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.findReachableStates.parameter.start"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.State

---

###### `options`<sup>Optional</sup> <a name="options" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.findReachableStates.parameter.options"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.FindStateOptions

---

##### `prefixStates` <a name="prefixStates" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.prefixStates"></a>

```typescript
import { TextractGenericSyncSfnTask } from 'schadem-cdk-construct-textract-generic-async'

TextractGenericSyncSfnTask.prefixStates(root: IConstruct, prefix: string)
```

Add a prefix to the stateId of all States found in a construct tree.

###### `root`<sup>Required</sup> <a name="root" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.prefixStates.parameter.root"></a>

- *Type:* constructs.IConstruct

---

###### `prefix`<sup>Required</sup> <a name="prefix" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.prefixStates.parameter.prefix"></a>

- *Type:* string

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.property.endStates">endStates</a></code> | <code>aws-cdk-lib.aws_stepfunctions.INextable[]</code> | Continuable states of this Chainable. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.property.id">id</a></code> | <code>string</code> | Descriptive identifier for this chainable. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.property.startState">startState</a></code> | <code>aws-cdk-lib.aws_stepfunctions.State</code> | First state of this Chainable. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.property.stateId">stateId</a></code> | <code>string</code> | Tokenized string that evaluates to the state's ID. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.property.dashboardName">dashboardName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.property.putOnSQSLambdaLogGroup">putOnSQSLambdaLogGroup</a></code> | <code>aws-cdk-lib.aws_logs.ILogGroup</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.property.stateMachine">stateMachine</a></code> | <code>aws-cdk-lib.aws_stepfunctions.IStateMachine</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.property.textractPutOnSQSFunction">textractPutOnSQSFunction</a></code> | <code>aws-cdk-lib.aws_lambda.IFunction</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.property.textractSyncCallFunction">textractSyncCallFunction</a></code> | <code>aws-cdk-lib.aws_lambda.IFunction</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.property.textractSyncLambdaLogGroup">textractSyncLambdaLogGroup</a></code> | <code>aws-cdk-lib.aws_logs.ILogGroup</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.property.textractSyncSQS">textractSyncSQS</a></code> | <code>aws-cdk-lib.aws_sqs.IQueue</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.property.version">version</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `endStates`<sup>Required</sup> <a name="endStates" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.property.endStates"></a>

```typescript
public readonly endStates: INextable[];
```

- *Type:* aws-cdk-lib.aws_stepfunctions.INextable[]

Continuable states of this Chainable.

---

##### `id`<sup>Required</sup> <a name="id" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

Descriptive identifier for this chainable.

---

##### `startState`<sup>Required</sup> <a name="startState" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.property.startState"></a>

```typescript
public readonly startState: State;
```

- *Type:* aws-cdk-lib.aws_stepfunctions.State

First state of this Chainable.

---

##### `stateId`<sup>Required</sup> <a name="stateId" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.property.stateId"></a>

```typescript
public readonly stateId: string;
```

- *Type:* string

Tokenized string that evaluates to the state's ID.

---

##### `dashboardName`<sup>Required</sup> <a name="dashboardName" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.property.dashboardName"></a>

```typescript
public readonly dashboardName: string;
```

- *Type:* string

---

##### `putOnSQSLambdaLogGroup`<sup>Required</sup> <a name="putOnSQSLambdaLogGroup" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.property.putOnSQSLambdaLogGroup"></a>

```typescript
public readonly putOnSQSLambdaLogGroup: ILogGroup;
```

- *Type:* aws-cdk-lib.aws_logs.ILogGroup

---

##### `stateMachine`<sup>Required</sup> <a name="stateMachine" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.property.stateMachine"></a>

```typescript
public readonly stateMachine: IStateMachine;
```

- *Type:* aws-cdk-lib.aws_stepfunctions.IStateMachine

---

##### `textractPutOnSQSFunction`<sup>Required</sup> <a name="textractPutOnSQSFunction" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.property.textractPutOnSQSFunction"></a>

```typescript
public readonly textractPutOnSQSFunction: IFunction;
```

- *Type:* aws-cdk-lib.aws_lambda.IFunction

---

##### `textractSyncCallFunction`<sup>Required</sup> <a name="textractSyncCallFunction" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.property.textractSyncCallFunction"></a>

```typescript
public readonly textractSyncCallFunction: IFunction;
```

- *Type:* aws-cdk-lib.aws_lambda.IFunction

---

##### `textractSyncLambdaLogGroup`<sup>Required</sup> <a name="textractSyncLambdaLogGroup" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.property.textractSyncLambdaLogGroup"></a>

```typescript
public readonly textractSyncLambdaLogGroup: ILogGroup;
```

- *Type:* aws-cdk-lib.aws_logs.ILogGroup

---

##### `textractSyncSQS`<sup>Required</sup> <a name="textractSyncSQS" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.property.textractSyncSQS"></a>

```typescript
public readonly textractSyncSQS: IQueue;
```

- *Type:* aws-cdk-lib.aws_sqs.IQueue

---

##### `version`<sup>Required</sup> <a name="version" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTask.property.version"></a>

```typescript
public readonly version: string;
```

- *Type:* string

---


### TextractPOCDecider <a name="TextractPOCDecider" id="schadem-cdk-construct-textract-generic-async.TextractPOCDecider"></a>

#### Initializers <a name="Initializers" id="schadem-cdk-construct-textract-generic-async.TextractPOCDecider.Initializer"></a>

```typescript
import { TextractPOCDecider } from 'schadem-cdk-construct-textract-generic-async'

new TextractPOCDecider(parent: Construct, id: string, props: TextractDPPOCDeciderProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractPOCDecider.Initializer.parameter.parent">parent</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractPOCDecider.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractPOCDecider.Initializer.parameter.props">props</a></code> | <code><a href="#schadem-cdk-construct-textract-generic-async.TextractDPPOCDeciderProps">TextractDPPOCDeciderProps</a></code> | *No description.* |

---

##### `parent`<sup>Required</sup> <a name="parent" id="schadem-cdk-construct-textract-generic-async.TextractPOCDecider.Initializer.parameter.parent"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="schadem-cdk-construct-textract-generic-async.TextractPOCDecider.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="schadem-cdk-construct-textract-generic-async.TextractPOCDecider.Initializer.parameter.props"></a>

- *Type:* <a href="#schadem-cdk-construct-textract-generic-async.TextractDPPOCDeciderProps">TextractDPPOCDeciderProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractPOCDecider.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractPOCDecider.next">next</a></code> | Continue normal execution with the given state. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractPOCDecider.prefixStates">prefixStates</a></code> | Prefix the IDs of all states in this state machine fragment. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractPOCDecider.toSingleState">toSingleState</a></code> | Wrap all states in this state machine fragment up into a single state. |

---

##### `toString` <a name="toString" id="schadem-cdk-construct-textract-generic-async.TextractPOCDecider.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `next` <a name="next" id="schadem-cdk-construct-textract-generic-async.TextractPOCDecider.next"></a>

```typescript
public next(next: IChainable): Chain
```

Continue normal execution with the given state.

###### `next`<sup>Required</sup> <a name="next" id="schadem-cdk-construct-textract-generic-async.TextractPOCDecider.next.parameter.next"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.IChainable

---

##### `prefixStates` <a name="prefixStates" id="schadem-cdk-construct-textract-generic-async.TextractPOCDecider.prefixStates"></a>

```typescript
public prefixStates(prefix?: string): StateMachineFragment
```

Prefix the IDs of all states in this state machine fragment.

Use this to avoid multiple copies of the state machine all having the
same state IDs.

###### `prefix`<sup>Optional</sup> <a name="prefix" id="schadem-cdk-construct-textract-generic-async.TextractPOCDecider.prefixStates.parameter.prefix"></a>

- *Type:* string

The prefix to add.

Will use construct ID by default.

---

##### `toSingleState` <a name="toSingleState" id="schadem-cdk-construct-textract-generic-async.TextractPOCDecider.toSingleState"></a>

```typescript
public toSingleState(options?: SingleStateOptions): Parallel
```

Wrap all states in this state machine fragment up into a single state.

This can be used to add retry or error handling onto this state
machine fragment.

Be aware that this changes the result of the inner state machine
to be an array with the result of the state machine in it. Adjust
your paths accordingly. For example, change 'outputPath' to
'$[0]'.

###### `options`<sup>Optional</sup> <a name="options" id="schadem-cdk-construct-textract-generic-async.TextractPOCDecider.toSingleState.parameter.options"></a>

- *Type:* aws-cdk-lib.aws_stepfunctions.SingleStateOptions

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractPOCDecider.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="schadem-cdk-construct-textract-generic-async.TextractPOCDecider.isConstruct"></a>

```typescript
import { TextractPOCDecider } from 'schadem-cdk-construct-textract-generic-async'

TextractPOCDecider.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="schadem-cdk-construct-textract-generic-async.TextractPOCDecider.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractPOCDecider.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractPOCDecider.property.endStates">endStates</a></code> | <code>aws-cdk-lib.aws_stepfunctions.INextable[]</code> | The states to chain onto if this fragment is used. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractPOCDecider.property.id">id</a></code> | <code>string</code> | Descriptive identifier for this chainable. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractPOCDecider.property.startState">startState</a></code> | <code>aws-cdk-lib.aws_stepfunctions.State</code> | The start state of this state machine fragment. |

---

##### `node`<sup>Required</sup> <a name="node" id="schadem-cdk-construct-textract-generic-async.TextractPOCDecider.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `endStates`<sup>Required</sup> <a name="endStates" id="schadem-cdk-construct-textract-generic-async.TextractPOCDecider.property.endStates"></a>

```typescript
public readonly endStates: INextable[];
```

- *Type:* aws-cdk-lib.aws_stepfunctions.INextable[]

The states to chain onto if this fragment is used.

---

##### `id`<sup>Required</sup> <a name="id" id="schadem-cdk-construct-textract-generic-async.TextractPOCDecider.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

Descriptive identifier for this chainable.

---

##### `startState`<sup>Required</sup> <a name="startState" id="schadem-cdk-construct-textract-generic-async.TextractPOCDecider.property.startState"></a>

```typescript
public readonly startState: State;
```

- *Type:* aws-cdk-lib.aws_stepfunctions.State

The start state of this state machine fragment.

---


## Structs <a name="Structs" id="Structs"></a>

### TextractAsyncToJSONProps <a name="TextractAsyncToJSONProps" id="schadem-cdk-construct-textract-generic-async.TextractAsyncToJSONProps"></a>

#### Initializer <a name="Initializer" id="schadem-cdk-construct-textract-generic-async.TextractAsyncToJSONProps.Initializer"></a>

```typescript
import { TextractAsyncToJSONProps } from 'schadem-cdk-construct-textract-generic-async'

const textractAsyncToJSONProps: TextractAsyncToJSONProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractAsyncToJSONProps.property.s3OutputBucket">s3OutputBucket</a></code> | <code>string</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractAsyncToJSONProps.property.s3OutputPrefix">s3OutputPrefix</a></code> | <code>string</code> | The prefix to use for the output files. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractAsyncToJSONProps.property.lambdaLogLevel">lambdaLogLevel</a></code> | <code>string</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractAsyncToJSONProps.property.lambdaMemoryMB">lambdaMemoryMB</a></code> | <code>number</code> | memory of Lambda function (may need to increase for larger documents). |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractAsyncToJSONProps.property.lambdaTimeout">lambdaTimeout</a></code> | <code>number</code> | *No description.* |

---

##### `s3OutputBucket`<sup>Required</sup> <a name="s3OutputBucket" id="schadem-cdk-construct-textract-generic-async.TextractAsyncToJSONProps.property.s3OutputBucket"></a>

```typescript
public readonly s3OutputBucket: string;
```

- *Type:* string

---

##### `s3OutputPrefix`<sup>Required</sup> <a name="s3OutputPrefix" id="schadem-cdk-construct-textract-generic-async.TextractAsyncToJSONProps.property.s3OutputPrefix"></a>

```typescript
public readonly s3OutputPrefix: string;
```

- *Type:* string

The prefix to use for the output files.

---

##### `lambdaLogLevel`<sup>Optional</sup> <a name="lambdaLogLevel" id="schadem-cdk-construct-textract-generic-async.TextractAsyncToJSONProps.property.lambdaLogLevel"></a>

```typescript
public readonly lambdaLogLevel: string;
```

- *Type:* string

---

##### `lambdaMemoryMB`<sup>Optional</sup> <a name="lambdaMemoryMB" id="schadem-cdk-construct-textract-generic-async.TextractAsyncToJSONProps.property.lambdaMemoryMB"></a>

```typescript
public readonly lambdaMemoryMB: number;
```

- *Type:* number

memory of Lambda function (may need to increase for larger documents).

---

##### `lambdaTimeout`<sup>Optional</sup> <a name="lambdaTimeout" id="schadem-cdk-construct-textract-generic-async.TextractAsyncToJSONProps.property.lambdaTimeout"></a>

```typescript
public readonly lambdaTimeout: number;
```

- *Type:* number

---

### TextractClassificationConfiguratorProps <a name="TextractClassificationConfiguratorProps" id="schadem-cdk-construct-textract-generic-async.TextractClassificationConfiguratorProps"></a>

#### Initializer <a name="Initializer" id="schadem-cdk-construct-textract-generic-async.TextractClassificationConfiguratorProps.Initializer"></a>

```typescript
import { TextractClassificationConfiguratorProps } from 'schadem-cdk-construct-textract-generic-async'

const textractClassificationConfiguratorProps: TextractClassificationConfiguratorProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractClassificationConfiguratorProps.property.lambdaLogLevel">lambdaLogLevel</a></code> | <code>string</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractClassificationConfiguratorProps.property.lambdaMemoryMB">lambdaMemoryMB</a></code> | <code>number</code> | memory of Lambda function (may need to increase for larger documents). |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractClassificationConfiguratorProps.property.lambdaTimeout">lambdaTimeout</a></code> | <code>number</code> | *No description.* |

---

##### `lambdaLogLevel`<sup>Optional</sup> <a name="lambdaLogLevel" id="schadem-cdk-construct-textract-generic-async.TextractClassificationConfiguratorProps.property.lambdaLogLevel"></a>

```typescript
public readonly lambdaLogLevel: string;
```

- *Type:* string

---

##### `lambdaMemoryMB`<sup>Optional</sup> <a name="lambdaMemoryMB" id="schadem-cdk-construct-textract-generic-async.TextractClassificationConfiguratorProps.property.lambdaMemoryMB"></a>

```typescript
public readonly lambdaMemoryMB: number;
```

- *Type:* number

memory of Lambda function (may need to increase for larger documents).

---

##### `lambdaTimeout`<sup>Optional</sup> <a name="lambdaTimeout" id="schadem-cdk-construct-textract-generic-async.TextractClassificationConfiguratorProps.property.lambdaTimeout"></a>

```typescript
public readonly lambdaTimeout: number;
```

- *Type:* number

---

### TextractDPPOCDeciderProps <a name="TextractDPPOCDeciderProps" id="schadem-cdk-construct-textract-generic-async.TextractDPPOCDeciderProps"></a>

#### Initializer <a name="Initializer" id="schadem-cdk-construct-textract-generic-async.TextractDPPOCDeciderProps.Initializer"></a>

```typescript
import { TextractDPPOCDeciderProps } from 'schadem-cdk-construct-textract-generic-async'

const textractDPPOCDeciderProps: TextractDPPOCDeciderProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractDPPOCDeciderProps.property.lambdaMemoryMB">lambdaMemoryMB</a></code> | <code>number</code> | memory of Lambda function (may need to increase for larger documents). |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractDPPOCDeciderProps.property.lambdaTimeout">lambdaTimeout</a></code> | <code>number</code> | *No description.* |

---

##### `lambdaMemoryMB`<sup>Optional</sup> <a name="lambdaMemoryMB" id="schadem-cdk-construct-textract-generic-async.TextractDPPOCDeciderProps.property.lambdaMemoryMB"></a>

```typescript
public readonly lambdaMemoryMB: number;
```

- *Type:* number

memory of Lambda function (may need to increase for larger documents).

---

##### `lambdaTimeout`<sup>Optional</sup> <a name="lambdaTimeout" id="schadem-cdk-construct-textract-generic-async.TextractDPPOCDeciderProps.property.lambdaTimeout"></a>

```typescript
public readonly lambdaTimeout: number;
```

- *Type:* number

---

### TextractGenerateCSVProps <a name="TextractGenerateCSVProps" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSVProps"></a>

#### Initializer <a name="Initializer" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSVProps.Initializer"></a>

```typescript
import { TextractGenerateCSVProps } from 'schadem-cdk-construct-textract-generic-async'

const textractGenerateCSVProps: TextractGenerateCSVProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSVProps.property.comment">comment</a></code> | <code>string</code> | An optional description for this state. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSVProps.property.heartbeat">heartbeat</a></code> | <code>aws-cdk-lib.Duration</code> | Timeout for the heartbeat. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSVProps.property.inputPath">inputPath</a></code> | <code>string</code> | JSONPath expression to select part of the state to be the input to this state. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSVProps.property.integrationPattern">integrationPattern</a></code> | <code>aws-cdk-lib.aws_stepfunctions.IntegrationPattern</code> | AWS Step Functions integrates with services directly in the Amazon States Language. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSVProps.property.outputPath">outputPath</a></code> | <code>string</code> | JSONPath expression to select select a portion of the state output to pass to the next state. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSVProps.property.resultPath">resultPath</a></code> | <code>string</code> | JSONPath expression to indicate where to inject the state's output. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSVProps.property.resultSelector">resultSelector</a></code> | <code>{[ key: string ]: any}</code> | The JSON that will replace the state's raw result and become the effective result before ResultPath is applied. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSVProps.property.timeout">timeout</a></code> | <code>aws-cdk-lib.Duration</code> | Timeout for the state machine. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSVProps.property.csvS3OutputBucket">csvS3OutputBucket</a></code> | <code>string</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSVProps.property.csvS3OutputPrefix">csvS3OutputPrefix</a></code> | <code>string</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSVProps.property.associateWithParent">associateWithParent</a></code> | <code>boolean</code> | Pass the execution ID from the context object to the execution input. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSVProps.property.input">input</a></code> | <code>aws-cdk-lib.aws_stepfunctions.TaskInput</code> | The JSON input for the execution, same as that of StartExecution. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSVProps.property.lambdaLogLevel">lambdaLogLevel</a></code> | <code>string</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSVProps.property.lambdaMemoryMB">lambdaMemoryMB</a></code> | <code>number</code> | memory of Lambda function (may need to increase for larger documents). |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSVProps.property.lambdaTimeout">lambdaTimeout</a></code> | <code>number</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSVProps.property.name">name</a></code> | <code>string</code> | The name of the execution, same as that of StartExecution. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenerateCSVProps.property.outputType">outputType</a></code> | <code>string</code> | *No description.* |

---

##### `comment`<sup>Optional</sup> <a name="comment" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSVProps.property.comment"></a>

```typescript
public readonly comment: string;
```

- *Type:* string
- *Default:* No comment

An optional description for this state.

---

##### `heartbeat`<sup>Optional</sup> <a name="heartbeat" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSVProps.property.heartbeat"></a>

```typescript
public readonly heartbeat: Duration;
```

- *Type:* aws-cdk-lib.Duration
- *Default:* None

Timeout for the heartbeat.

---

##### `inputPath`<sup>Optional</sup> <a name="inputPath" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSVProps.property.inputPath"></a>

```typescript
public readonly inputPath: string;
```

- *Type:* string
- *Default:* The entire task input (JSON path '$')

JSONPath expression to select part of the state to be the input to this state.

May also be the special value JsonPath.DISCARD, which will cause the effective
input to be the empty object {}.

---

##### `integrationPattern`<sup>Optional</sup> <a name="integrationPattern" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSVProps.property.integrationPattern"></a>

```typescript
public readonly integrationPattern: IntegrationPattern;
```

- *Type:* aws-cdk-lib.aws_stepfunctions.IntegrationPattern
- *Default:* `IntegrationPattern.REQUEST_RESPONSE` for most tasks. `IntegrationPattern.RUN_JOB` for the following exceptions: `BatchSubmitJob`, `EmrAddStep`, `EmrCreateCluster`, `EmrTerminationCluster`, and `EmrContainersStartJobRun`.

AWS Step Functions integrates with services directly in the Amazon States Language.

You can control these AWS services using service integration patterns

> [https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token](https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token)

---

##### `outputPath`<sup>Optional</sup> <a name="outputPath" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSVProps.property.outputPath"></a>

```typescript
public readonly outputPath: string;
```

- *Type:* string
- *Default:* The entire JSON node determined by the state input, the task result, and resultPath is passed to the next state (JSON path '$')

JSONPath expression to select select a portion of the state output to pass to the next state.

May also be the special value JsonPath.DISCARD, which will cause the effective
output to be the empty object {}.

---

##### `resultPath`<sup>Optional</sup> <a name="resultPath" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSVProps.property.resultPath"></a>

```typescript
public readonly resultPath: string;
```

- *Type:* string
- *Default:* Replaces the entire input with the result (JSON path '$')

JSONPath expression to indicate where to inject the state's output.

May also be the special value JsonPath.DISCARD, which will cause the state's
input to become its output.

---

##### `resultSelector`<sup>Optional</sup> <a name="resultSelector" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSVProps.property.resultSelector"></a>

```typescript
public readonly resultSelector: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}
- *Default:* None

The JSON that will replace the state's raw result and become the effective result before ResultPath is applied.

You can use ResultSelector to create a payload with values that are static
or selected from the state's raw result.

> [https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector](https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector)

---

##### `timeout`<sup>Optional</sup> <a name="timeout" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSVProps.property.timeout"></a>

```typescript
public readonly timeout: Duration;
```

- *Type:* aws-cdk-lib.Duration
- *Default:* None

Timeout for the state machine.

---

##### `csvS3OutputBucket`<sup>Required</sup> <a name="csvS3OutputBucket" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSVProps.property.csvS3OutputBucket"></a>

```typescript
public readonly csvS3OutputBucket: string;
```

- *Type:* string

---

##### `csvS3OutputPrefix`<sup>Required</sup> <a name="csvS3OutputPrefix" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSVProps.property.csvS3OutputPrefix"></a>

```typescript
public readonly csvS3OutputPrefix: string;
```

- *Type:* string

---

##### `associateWithParent`<sup>Optional</sup> <a name="associateWithParent" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSVProps.property.associateWithParent"></a>

```typescript
public readonly associateWithParent: boolean;
```

- *Type:* boolean
- *Default:* false

Pass the execution ID from the context object to the execution input.

This allows the Step Functions UI to link child executions from parent executions, making it easier to trace execution flow across state machines.

If you set this property to `true`, the `input` property must be an object (provided by `sfn.TaskInput.fromObject`) or omitted entirely.

> [https://docs.aws.amazon.com/step-functions/latest/dg/concepts-nested-workflows.html#nested-execution-startid](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-nested-workflows.html#nested-execution-startid)

---

##### `input`<sup>Optional</sup> <a name="input" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSVProps.property.input"></a>

```typescript
public readonly input: TaskInput;
```

- *Type:* aws-cdk-lib.aws_stepfunctions.TaskInput
- *Default:* The state input (JSON path '$')

The JSON input for the execution, same as that of StartExecution.

> [https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html](https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html)

---

##### `lambdaLogLevel`<sup>Optional</sup> <a name="lambdaLogLevel" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSVProps.property.lambdaLogLevel"></a>

```typescript
public readonly lambdaLogLevel: string;
```

- *Type:* string

---

##### `lambdaMemoryMB`<sup>Optional</sup> <a name="lambdaMemoryMB" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSVProps.property.lambdaMemoryMB"></a>

```typescript
public readonly lambdaMemoryMB: number;
```

- *Type:* number

memory of Lambda function (may need to increase for larger documents).

---

##### `lambdaTimeout`<sup>Optional</sup> <a name="lambdaTimeout" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSVProps.property.lambdaTimeout"></a>

```typescript
public readonly lambdaTimeout: number;
```

- *Type:* number

---

##### `name`<sup>Optional</sup> <a name="name" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSVProps.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string
- *Default:* None

The name of the execution, same as that of StartExecution.

> [https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html](https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html)

---

##### `outputType`<sup>Optional</sup> <a name="outputType" id="schadem-cdk-construct-textract-generic-async.TextractGenerateCSVProps.property.outputType"></a>

```typescript
public readonly outputType: string;
```

- *Type:* string

---

### TextractGenericAsyncSfnTaskProps <a name="TextractGenericAsyncSfnTaskProps" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps"></a>

#### Initializer <a name="Initializer" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.Initializer"></a>

```typescript
import { TextractGenericAsyncSfnTaskProps } from 'schadem-cdk-construct-textract-generic-async'

const textractGenericAsyncSfnTaskProps: TextractGenericAsyncSfnTaskProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.comment">comment</a></code> | <code>string</code> | An optional description for this state. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.heartbeat">heartbeat</a></code> | <code>aws-cdk-lib.Duration</code> | Timeout for the heartbeat. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.inputPath">inputPath</a></code> | <code>string</code> | JSONPath expression to select part of the state to be the input to this state. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.integrationPattern">integrationPattern</a></code> | <code>aws-cdk-lib.aws_stepfunctions.IntegrationPattern</code> | AWS Step Functions integrates with services directly in the Amazon States Language. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.outputPath">outputPath</a></code> | <code>string</code> | JSONPath expression to select select a portion of the state output to pass to the next state. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.resultPath">resultPath</a></code> | <code>string</code> | JSONPath expression to indicate where to inject the state's output. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.resultSelector">resultSelector</a></code> | <code>{[ key: string ]: any}</code> | The JSON that will replace the state's raw result and become the effective result before ResultPath is applied. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.timeout">timeout</a></code> | <code>aws-cdk-lib.Duration</code> | Timeout for the state machine. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.s3OutputBucket">s3OutputBucket</a></code> | <code>string</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.s3TempOutputPrefix">s3TempOutputPrefix</a></code> | <code>string</code> | The prefix to use for the temporary output files (e. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.associateWithParent">associateWithParent</a></code> | <code>boolean</code> | Pass the execution ID from the context object to the execution input. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.customFunction">customFunction</a></code> | <code>aws-cdk-lib.aws_stepfunctions_tasks.LambdaInvoke</code> | not implemented yet. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.enableDashboard">enableDashboard</a></code> | <code>boolean</code> | not implemented yet. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.enableMonitoring">enableMonitoring</a></code> | <code>boolean</code> | not implemented yet. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.input">input</a></code> | <code>aws-cdk-lib.aws_stepfunctions.TaskInput</code> | The JSON input for the execution, same as that of StartExecution. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.lambdaLogLevel">lambdaLogLevel</a></code> | <code>string</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.name">name</a></code> | <code>string</code> | The name of the execution, same as that of StartExecution. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.s3InputBucket">s3InputBucket</a></code> | <code>string</code> | location of input S3 objects - if left empty will generate rule for s3 access to all [*]. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.s3InputPrefix">s3InputPrefix</a></code> | <code>string</code> | prefix for input S3 objects - if left empty will generate rule for s3 access to all [*]. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.s3OutputPrefix">s3OutputPrefix</a></code> | <code>string</code> | The prefix to use for the output files. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.taskTokenTableName">taskTokenTableName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.textractAPI">textractAPI</a></code> | <code>string</code> | The prefix to use for the output files. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.textractStateMachineTimeoutMinutes">textractStateMachineTimeoutMinutes</a></code> | <code>number</code> | how long can we wait for the process (default is 48 hours (60*48=2880)). |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.workflowTracingEnabled">workflowTracingEnabled</a></code> | <code>boolean</code> | *No description.* |

---

##### `comment`<sup>Optional</sup> <a name="comment" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.comment"></a>

```typescript
public readonly comment: string;
```

- *Type:* string
- *Default:* No comment

An optional description for this state.

---

##### `heartbeat`<sup>Optional</sup> <a name="heartbeat" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.heartbeat"></a>

```typescript
public readonly heartbeat: Duration;
```

- *Type:* aws-cdk-lib.Duration
- *Default:* None

Timeout for the heartbeat.

---

##### `inputPath`<sup>Optional</sup> <a name="inputPath" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.inputPath"></a>

```typescript
public readonly inputPath: string;
```

- *Type:* string
- *Default:* The entire task input (JSON path '$')

JSONPath expression to select part of the state to be the input to this state.

May also be the special value JsonPath.DISCARD, which will cause the effective
input to be the empty object {}.

---

##### `integrationPattern`<sup>Optional</sup> <a name="integrationPattern" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.integrationPattern"></a>

```typescript
public readonly integrationPattern: IntegrationPattern;
```

- *Type:* aws-cdk-lib.aws_stepfunctions.IntegrationPattern
- *Default:* `IntegrationPattern.REQUEST_RESPONSE` for most tasks. `IntegrationPattern.RUN_JOB` for the following exceptions: `BatchSubmitJob`, `EmrAddStep`, `EmrCreateCluster`, `EmrTerminationCluster`, and `EmrContainersStartJobRun`.

AWS Step Functions integrates with services directly in the Amazon States Language.

You can control these AWS services using service integration patterns

> [https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token](https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token)

---

##### `outputPath`<sup>Optional</sup> <a name="outputPath" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.outputPath"></a>

```typescript
public readonly outputPath: string;
```

- *Type:* string
- *Default:* The entire JSON node determined by the state input, the task result, and resultPath is passed to the next state (JSON path '$')

JSONPath expression to select select a portion of the state output to pass to the next state.

May also be the special value JsonPath.DISCARD, which will cause the effective
output to be the empty object {}.

---

##### `resultPath`<sup>Optional</sup> <a name="resultPath" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.resultPath"></a>

```typescript
public readonly resultPath: string;
```

- *Type:* string
- *Default:* Replaces the entire input with the result (JSON path '$')

JSONPath expression to indicate where to inject the state's output.

May also be the special value JsonPath.DISCARD, which will cause the state's
input to become its output.

---

##### `resultSelector`<sup>Optional</sup> <a name="resultSelector" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.resultSelector"></a>

```typescript
public readonly resultSelector: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}
- *Default:* None

The JSON that will replace the state's raw result and become the effective result before ResultPath is applied.

You can use ResultSelector to create a payload with values that are static
or selected from the state's raw result.

> [https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector](https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector)

---

##### `timeout`<sup>Optional</sup> <a name="timeout" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.timeout"></a>

```typescript
public readonly timeout: Duration;
```

- *Type:* aws-cdk-lib.Duration
- *Default:* None

Timeout for the state machine.

---

##### `s3OutputBucket`<sup>Required</sup> <a name="s3OutputBucket" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.s3OutputBucket"></a>

```typescript
public readonly s3OutputBucket: string;
```

- *Type:* string

---

##### `s3TempOutputPrefix`<sup>Required</sup> <a name="s3TempOutputPrefix" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.s3TempOutputPrefix"></a>

```typescript
public readonly s3TempOutputPrefix: string;
```

- *Type:* string

The prefix to use for the temporary output files (e.

g. output from async process before stiching together)

---

##### `associateWithParent`<sup>Optional</sup> <a name="associateWithParent" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.associateWithParent"></a>

```typescript
public readonly associateWithParent: boolean;
```

- *Type:* boolean
- *Default:* false

Pass the execution ID from the context object to the execution input.

This allows the Step Functions UI to link child executions from parent executions, making it easier to trace execution flow across state machines.

If you set this property to `true`, the `input` property must be an object (provided by `sfn.TaskInput.fromObject`) or omitted entirely.

> [https://docs.aws.amazon.com/step-functions/latest/dg/concepts-nested-workflows.html#nested-execution-startid](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-nested-workflows.html#nested-execution-startid)

---

##### `customFunction`<sup>Optional</sup> <a name="customFunction" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.customFunction"></a>

```typescript
public readonly customFunction: LambdaInvoke;
```

- *Type:* aws-cdk-lib.aws_stepfunctions_tasks.LambdaInvoke

not implemented yet.

---

##### `enableDashboard`<sup>Optional</sup> <a name="enableDashboard" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.enableDashboard"></a>

```typescript
public readonly enableDashboard: boolean;
```

- *Type:* boolean

not implemented yet.

---

##### `enableMonitoring`<sup>Optional</sup> <a name="enableMonitoring" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.enableMonitoring"></a>

```typescript
public readonly enableMonitoring: boolean;
```

- *Type:* boolean

not implemented yet.

---

##### `input`<sup>Optional</sup> <a name="input" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.input"></a>

```typescript
public readonly input: TaskInput;
```

- *Type:* aws-cdk-lib.aws_stepfunctions.TaskInput
- *Default:* The state input (JSON path '$')

The JSON input for the execution, same as that of StartExecution.

> [https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html](https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html)

---

##### `lambdaLogLevel`<sup>Optional</sup> <a name="lambdaLogLevel" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.lambdaLogLevel"></a>

```typescript
public readonly lambdaLogLevel: string;
```

- *Type:* string

---

##### `name`<sup>Optional</sup> <a name="name" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string
- *Default:* None

The name of the execution, same as that of StartExecution.

> [https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html](https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html)

---

##### `s3InputBucket`<sup>Optional</sup> <a name="s3InputBucket" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.s3InputBucket"></a>

```typescript
public readonly s3InputBucket: string;
```

- *Type:* string

location of input S3 objects - if left empty will generate rule for s3 access to all [*].

---

##### `s3InputPrefix`<sup>Optional</sup> <a name="s3InputPrefix" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.s3InputPrefix"></a>

```typescript
public readonly s3InputPrefix: string;
```

- *Type:* string

prefix for input S3 objects - if left empty will generate rule for s3 access to all [*].

---

##### `s3OutputPrefix`<sup>Optional</sup> <a name="s3OutputPrefix" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.s3OutputPrefix"></a>

```typescript
public readonly s3OutputPrefix: string;
```

- *Type:* string

The prefix to use for the output files.

---

##### `taskTokenTableName`<sup>Optional</sup> <a name="taskTokenTableName" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.taskTokenTableName"></a>

```typescript
public readonly taskTokenTableName: string;
```

- *Type:* string

---

##### `textractAPI`<sup>Optional</sup> <a name="textractAPI" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.textractAPI"></a>

```typescript
public readonly textractAPI: string;
```

- *Type:* string

The prefix to use for the output files.

---

##### `textractStateMachineTimeoutMinutes`<sup>Optional</sup> <a name="textractStateMachineTimeoutMinutes" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.textractStateMachineTimeoutMinutes"></a>

```typescript
public readonly textractStateMachineTimeoutMinutes: number;
```

- *Type:* number

how long can we wait for the process (default is 48 hours (60*48=2880)).

---

##### `workflowTracingEnabled`<sup>Optional</sup> <a name="workflowTracingEnabled" id="schadem-cdk-construct-textract-generic-async.TextractGenericAsyncSfnTaskProps.property.workflowTracingEnabled"></a>

```typescript
public readonly workflowTracingEnabled: boolean;
```

- *Type:* boolean

---

### TextractGenericSyncSfnTaskProps <a name="TextractGenericSyncSfnTaskProps" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps"></a>

#### Initializer <a name="Initializer" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.Initializer"></a>

```typescript
import { TextractGenericSyncSfnTaskProps } from 'schadem-cdk-construct-textract-generic-async'

const textractGenericSyncSfnTaskProps: TextractGenericSyncSfnTaskProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.comment">comment</a></code> | <code>string</code> | An optional description for this state. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.heartbeat">heartbeat</a></code> | <code>aws-cdk-lib.Duration</code> | Timeout for the heartbeat. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.inputPath">inputPath</a></code> | <code>string</code> | JSONPath expression to select part of the state to be the input to this state. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.integrationPattern">integrationPattern</a></code> | <code>aws-cdk-lib.aws_stepfunctions.IntegrationPattern</code> | AWS Step Functions integrates with services directly in the Amazon States Language. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.outputPath">outputPath</a></code> | <code>string</code> | JSONPath expression to select select a portion of the state output to pass to the next state. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.resultPath">resultPath</a></code> | <code>string</code> | JSONPath expression to indicate where to inject the state's output. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.resultSelector">resultSelector</a></code> | <code>{[ key: string ]: any}</code> | The JSON that will replace the state's raw result and become the effective result before ResultPath is applied. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.timeout">timeout</a></code> | <code>aws-cdk-lib.Duration</code> | Timeout for the state machine. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.s3OutputBucket">s3OutputBucket</a></code> | <code>string</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.s3OutputPrefix">s3OutputPrefix</a></code> | <code>string</code> | The prefix to use for the output files. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.associateWithParent">associateWithParent</a></code> | <code>boolean</code> | Pass the execution ID from the context object to the execution input. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.customFunction">customFunction</a></code> | <code>aws-cdk-lib.aws_stepfunctions_tasks.LambdaInvoke</code> | not implemented yet. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.enableDashboard">enableDashboard</a></code> | <code>boolean</code> | not implemented yet. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.enableMonitoring">enableMonitoring</a></code> | <code>boolean</code> | not implemented yet. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.input">input</a></code> | <code>aws-cdk-lib.aws_stepfunctions.TaskInput</code> | The JSON input for the execution, same as that of StartExecution. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.lambdaLogLevel">lambdaLogLevel</a></code> | <code>string</code> | The prefix to use for the output files. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.name">name</a></code> | <code>string</code> | The name of the execution, same as that of StartExecution. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.s3InputBucket">s3InputBucket</a></code> | <code>string</code> | location of input S3 objects - if left empty will generate rule for s3 access to all [*]. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.s3InputPrefix">s3InputPrefix</a></code> | <code>string</code> | prefix for input S3 objects - if left empty will generate rule for s3 access to all [*]. |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.textractAPI">textractAPI</a></code> | <code>string</code> | *No description.* |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.textractStateMachineTimeoutMinutes">textractStateMachineTimeoutMinutes</a></code> | <code>number</code> | how long can we wait for the process (default is 48 hours (60*48=2880)). |
| <code><a href="#schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.workflowTracingEnabled">workflowTracingEnabled</a></code> | <code>boolean</code> | *No description.* |

---

##### `comment`<sup>Optional</sup> <a name="comment" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.comment"></a>

```typescript
public readonly comment: string;
```

- *Type:* string
- *Default:* No comment

An optional description for this state.

---

##### `heartbeat`<sup>Optional</sup> <a name="heartbeat" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.heartbeat"></a>

```typescript
public readonly heartbeat: Duration;
```

- *Type:* aws-cdk-lib.Duration
- *Default:* None

Timeout for the heartbeat.

---

##### `inputPath`<sup>Optional</sup> <a name="inputPath" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.inputPath"></a>

```typescript
public readonly inputPath: string;
```

- *Type:* string
- *Default:* The entire task input (JSON path '$')

JSONPath expression to select part of the state to be the input to this state.

May also be the special value JsonPath.DISCARD, which will cause the effective
input to be the empty object {}.

---

##### `integrationPattern`<sup>Optional</sup> <a name="integrationPattern" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.integrationPattern"></a>

```typescript
public readonly integrationPattern: IntegrationPattern;
```

- *Type:* aws-cdk-lib.aws_stepfunctions.IntegrationPattern
- *Default:* `IntegrationPattern.REQUEST_RESPONSE` for most tasks. `IntegrationPattern.RUN_JOB` for the following exceptions: `BatchSubmitJob`, `EmrAddStep`, `EmrCreateCluster`, `EmrTerminationCluster`, and `EmrContainersStartJobRun`.

AWS Step Functions integrates with services directly in the Amazon States Language.

You can control these AWS services using service integration patterns

> [https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token](https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token)

---

##### `outputPath`<sup>Optional</sup> <a name="outputPath" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.outputPath"></a>

```typescript
public readonly outputPath: string;
```

- *Type:* string
- *Default:* The entire JSON node determined by the state input, the task result, and resultPath is passed to the next state (JSON path '$')

JSONPath expression to select select a portion of the state output to pass to the next state.

May also be the special value JsonPath.DISCARD, which will cause the effective
output to be the empty object {}.

---

##### `resultPath`<sup>Optional</sup> <a name="resultPath" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.resultPath"></a>

```typescript
public readonly resultPath: string;
```

- *Type:* string
- *Default:* Replaces the entire input with the result (JSON path '$')

JSONPath expression to indicate where to inject the state's output.

May also be the special value JsonPath.DISCARD, which will cause the state's
input to become its output.

---

##### `resultSelector`<sup>Optional</sup> <a name="resultSelector" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.resultSelector"></a>

```typescript
public readonly resultSelector: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}
- *Default:* None

The JSON that will replace the state's raw result and become the effective result before ResultPath is applied.

You can use ResultSelector to create a payload with values that are static
or selected from the state's raw result.

> [https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector](https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector)

---

##### `timeout`<sup>Optional</sup> <a name="timeout" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.timeout"></a>

```typescript
public readonly timeout: Duration;
```

- *Type:* aws-cdk-lib.Duration
- *Default:* None

Timeout for the state machine.

---

##### `s3OutputBucket`<sup>Required</sup> <a name="s3OutputBucket" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.s3OutputBucket"></a>

```typescript
public readonly s3OutputBucket: string;
```

- *Type:* string

---

##### `s3OutputPrefix`<sup>Required</sup> <a name="s3OutputPrefix" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.s3OutputPrefix"></a>

```typescript
public readonly s3OutputPrefix: string;
```

- *Type:* string

The prefix to use for the output files.

---

##### `associateWithParent`<sup>Optional</sup> <a name="associateWithParent" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.associateWithParent"></a>

```typescript
public readonly associateWithParent: boolean;
```

- *Type:* boolean
- *Default:* false

Pass the execution ID from the context object to the execution input.

This allows the Step Functions UI to link child executions from parent executions, making it easier to trace execution flow across state machines.

If you set this property to `true`, the `input` property must be an object (provided by `sfn.TaskInput.fromObject`) or omitted entirely.

> [https://docs.aws.amazon.com/step-functions/latest/dg/concepts-nested-workflows.html#nested-execution-startid](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-nested-workflows.html#nested-execution-startid)

---

##### `customFunction`<sup>Optional</sup> <a name="customFunction" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.customFunction"></a>

```typescript
public readonly customFunction: LambdaInvoke;
```

- *Type:* aws-cdk-lib.aws_stepfunctions_tasks.LambdaInvoke

not implemented yet.

---

##### `enableDashboard`<sup>Optional</sup> <a name="enableDashboard" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.enableDashboard"></a>

```typescript
public readonly enableDashboard: boolean;
```

- *Type:* boolean

not implemented yet.

---

##### `enableMonitoring`<sup>Optional</sup> <a name="enableMonitoring" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.enableMonitoring"></a>

```typescript
public readonly enableMonitoring: boolean;
```

- *Type:* boolean

not implemented yet.

---

##### `input`<sup>Optional</sup> <a name="input" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.input"></a>

```typescript
public readonly input: TaskInput;
```

- *Type:* aws-cdk-lib.aws_stepfunctions.TaskInput
- *Default:* The state input (JSON path '$')

The JSON input for the execution, same as that of StartExecution.

> [https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html](https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html)

---

##### `lambdaLogLevel`<sup>Optional</sup> <a name="lambdaLogLevel" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.lambdaLogLevel"></a>

```typescript
public readonly lambdaLogLevel: string;
```

- *Type:* string

The prefix to use for the output files.

---

##### `name`<sup>Optional</sup> <a name="name" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string
- *Default:* None

The name of the execution, same as that of StartExecution.

> [https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html](https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html)

---

##### `s3InputBucket`<sup>Optional</sup> <a name="s3InputBucket" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.s3InputBucket"></a>

```typescript
public readonly s3InputBucket: string;
```

- *Type:* string

location of input S3 objects - if left empty will generate rule for s3 access to all [*].

---

##### `s3InputPrefix`<sup>Optional</sup> <a name="s3InputPrefix" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.s3InputPrefix"></a>

```typescript
public readonly s3InputPrefix: string;
```

- *Type:* string

prefix for input S3 objects - if left empty will generate rule for s3 access to all [*].

---

##### `textractAPI`<sup>Optional</sup> <a name="textractAPI" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.textractAPI"></a>

```typescript
public readonly textractAPI: string;
```

- *Type:* string

---

##### `textractStateMachineTimeoutMinutes`<sup>Optional</sup> <a name="textractStateMachineTimeoutMinutes" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.textractStateMachineTimeoutMinutes"></a>

```typescript
public readonly textractStateMachineTimeoutMinutes: number;
```

- *Type:* number

how long can we wait for the process (default is 48 hours (60*48=2880)).

---

##### `workflowTracingEnabled`<sup>Optional</sup> <a name="workflowTracingEnabled" id="schadem-cdk-construct-textract-generic-async.TextractGenericSyncSfnTaskProps.property.workflowTracingEnabled"></a>

```typescript
public readonly workflowTracingEnabled: boolean;
```

- *Type:* boolean

---



