# coding: utf-8

"""
    Visier Data In APIs

    Visier APIs for sending data to Visier and running data load jobs.

    The version of the OpenAPI document: 22222222.99201.1906
    Contact: alpine@visier.com

    Please note that this SDK is currently in beta.
    Functionality and behavior may change in future releases.
    We encourage you to provide feedback and report any issues encountered during your use.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from visier_api_data_in.models.designer_workday_o_auth_params_dto import DesignerWorkdayOAuthParamsDTO
from visier_api_data_in.models.designer_workday_refresh_token_params_dto import DesignerWorkdayRefreshTokenParamsDTO
from typing import Optional, Set
from typing_extensions import Self

class DesignerWorkdayAuthParamsDTO(BaseModel):
    """
    DesignerWorkdayAuthParamsDTO
    """ # noqa: E501
    user_id: Optional[StrictStr] = Field(default=None, alias="userId")
    domain_name: Optional[StrictStr] = Field(default=None, alias="domainName")
    implementation_name: Optional[StrictStr] = Field(default=None, alias="implementationName")
    password: Optional[StrictStr] = None
    o_auth: Optional[DesignerWorkdayOAuthParamsDTO] = Field(default=None, alias="oAuth")
    ref_token: Optional[DesignerWorkdayRefreshTokenParamsDTO] = Field(default=None, alias="refToken")
    integration_system_id: Optional[StrictStr] = Field(default=None, alias="integrationSystemId")
    api_key: Optional[StrictStr] = Field(default=None, alias="apiKey")
    __properties: ClassVar[List[str]] = ["userId", "domainName", "implementationName", "password", "oAuth", "refToken", "integrationSystemId", "apiKey"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DesignerWorkdayAuthParamsDTO from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of o_auth
        if self.o_auth:
            _dict['oAuth'] = self.o_auth.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ref_token
        if self.ref_token:
            _dict['refToken'] = self.ref_token.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DesignerWorkdayAuthParamsDTO from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "userId": obj.get("userId"),
            "domainName": obj.get("domainName"),
            "implementationName": obj.get("implementationName"),
            "password": obj.get("password"),
            "oAuth": DesignerWorkdayOAuthParamsDTO.from_dict(obj["oAuth"]) if obj.get("oAuth") is not None else None,
            "refToken": DesignerWorkdayRefreshTokenParamsDTO.from_dict(obj["refToken"]) if obj.get("refToken") is not None else None,
            "integrationSystemId": obj.get("integrationSystemId"),
            "apiKey": obj.get("apiKey")
        })
        return _obj


