# coding: utf-8

"""
    Visier Data In APIs

    Visier APIs for sending data to Visier and running data load jobs.

    The version of the OpenAPI document: 22222222.99201.1906
    Contact: alpine@visier.com

    Please note that this SDK is currently in beta.
    Functionality and behavior may change in future releases.
    We encourage you to provide feedback and report any issues encountered during your use.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from visier_api_data_in.models.designer_adp_auth_params_dto import DesignerAdpAuthParamsDTO
from visier_api_data_in.models.designer_bamboo_auth_params_dto import DesignerBambooAuthParamsDTO
from visier_api_data_in.models.designer_basic_s3_auth_params_dto import DesignerBasicS3AuthParamsDTO
from visier_api_data_in.models.designer_big_query_auth_params_dto import DesignerBigQueryAuthParamsDTO
from visier_api_data_in.models.designer_copy_s3_auth_params_dto import DesignerCopyS3AuthParamsDTO
from visier_api_data_in.models.designer_databricks_auth_params_dto import DesignerDatabricksAuthParamsDTO
from visier_api_data_in.models.designer_dayforce_v2_auth_params_dto import DesignerDayforceV2AuthParamsDTO
from visier_api_data_in.models.designer_dimensions_auth_params_dto import DesignerDimensionsAuthParamsDTO
from visier_api_data_in.models.designer_fusion_auth_params_dto import DesignerFusionAuthParamsDTO
from visier_api_data_in.models.designer_gong_auth_params_dto import DesignerGongAuthParamsDTO
from visier_api_data_in.models.designer_google_sheets_auth_params_dto import DesignerGoogleSheetsAuthParamsDTO
from visier_api_data_in.models.designer_google_workspace_auth_params_dto import DesignerGoogleWorkspaceAuthParamsDTO
from visier_api_data_in.models.designer_greenhouse_auth_params_dto import DesignerGreenhouseAuthParamsDTO
from visier_api_data_in.models.designer_icims_auth_params_dto import DesignerIcimsAuthParamsDTO
from visier_api_data_in.models.designer_internal_s3_auth_params_dto import DesignerInternalS3AuthParamsDTO
from visier_api_data_in.models.designer_jdbc_auth_params_dto import DesignerJdbcAuthParamsDTO
from visier_api_data_in.models.designer_jira_auth_params_dto import DesignerJiraAuthParamsDTO
from visier_api_data_in.models.designer_lever_auth_params_dto import DesignerLeverAuthParamsDTO
from visier_api_data_in.models.designer_medallia_auth_params_dto import DesignerMedalliaAuthParamsDTO
from visier_api_data_in.models.designer_microsoft365_auth_params_dto import DesignerMicrosoft365AuthParamsDTO
from visier_api_data_in.models.designer_my_sql_auth_params_dto import DesignerMySqlAuthParamsDTO
from visier_api_data_in.models.designer_namely_auth_params_dto import DesignerNamelyAuthParamsDTO
from visier_api_data_in.models.designer_oracle_db_auth_params_dto import DesignerOracleDbAuthParamsDTO
from visier_api_data_in.models.designer_qualtrics_auth_params_dto import DesignerQualtricsAuthParamsDTO
from visier_api_data_in.models.designer_redshift_auth_params_dto import DesignerRedshiftAuthParamsDTO
from visier_api_data_in.models.designer_salesforce_auth_params_dto import DesignerSalesforceAuthParamsDTO
from visier_api_data_in.models.designer_salesforce_v2_auth_params_dto import DesignerSalesforceV2AuthParamsDTO
from visier_api_data_in.models.designer_service_now_auth_params_dto import DesignerServiceNowAuthParamsDTO
from visier_api_data_in.models.designer_service_now_v2_auth_params_dto import DesignerServiceNowV2AuthParamsDTO
from visier_api_data_in.models.designer_slack_auth_params_dto import DesignerSlackAuthParamsDTO
from visier_api_data_in.models.designer_snowflake_auth_params_dto import DesignerSnowflakeAuthParamsDTO
from visier_api_data_in.models.designer_sql_server_auth_params_dto import DesignerSqlServerAuthParamsDTO
from visier_api_data_in.models.designer_success_factors_auth_params_dto import DesignerSuccessFactorsAuthParamsDTO
from visier_api_data_in.models.designer_ultimate_auth_params_dto import DesignerUltimateAuthParamsDTO
from visier_api_data_in.models.designer_willow_auth_params_dto import DesignerWillowAuthParamsDTO
from visier_api_data_in.models.designer_workday_auth_params_dto import DesignerWorkdayAuthParamsDTO
from visier_api_data_in.models.designer_workday_raas_auth_params_dto import DesignerWorkdayRaasAuthParamsDTO
from visier_api_data_in.models.designer_zoom_auth_params_dto import DesignerZoomAuthParamsDTO
from typing import Optional, Set
from typing_extensions import Self

class DesignerDataProviderAuthParamsDTO(BaseModel):
    """
    DesignerDataProviderAuthParamsDTO
    """ # noqa: E501
    tenant_domain_name: Optional[StrictStr] = Field(default=None, alias="tenantDomainName")
    provider: Optional[StrictStr] = Field(default=None, description="The data provider associated with the credential.")
    bamboo_auth_params: Optional[DesignerBambooAuthParamsDTO] = Field(default=None, alias="bambooAuthParams")
    greenhouse_auth_params: Optional[DesignerGreenhouseAuthParamsDTO] = Field(default=None, alias="greenhouseAuthParams")
    google_sheets_auth_params: Optional[DesignerGoogleSheetsAuthParamsDTO] = Field(default=None, alias="googleSheetsAuthParams")
    jira_auth_params: Optional[DesignerJiraAuthParamsDTO] = Field(default=None, alias="jiraAuthParams")
    lever_auth_params: Optional[DesignerLeverAuthParamsDTO] = Field(default=None, alias="leverAuthParams")
    namely_auth_params: Optional[DesignerNamelyAuthParamsDTO] = Field(default=None, alias="namelyAuthParams")
    qualtrics_auth_params: Optional[DesignerQualtricsAuthParamsDTO] = Field(default=None, alias="qualtricsAuthParams")
    salesforce_auth_params: Optional[DesignerSalesforceAuthParamsDTO] = Field(default=None, alias="salesforceAuthParams")
    ultimate_auth_params: Optional[DesignerUltimateAuthParamsDTO] = Field(default=None, alias="ultimateAuthParams")
    workday_auth_params: Optional[DesignerWorkdayAuthParamsDTO] = Field(default=None, alias="workdayAuthParams")
    icims_auth_params: Optional[DesignerIcimsAuthParamsDTO] = Field(default=None, alias="icimsAuthParams")
    service_now_auth_params: Optional[DesignerServiceNowAuthParamsDTO] = Field(default=None, alias="serviceNowAuthParams")
    jdbc_auth_params: Optional[DesignerJdbcAuthParamsDTO] = Field(default=None, alias="jdbcAuthParams")
    s3_auth_params: Optional[DesignerBasicS3AuthParamsDTO] = Field(default=None, alias="s3AuthParams")
    internal_s3_auth_params: Optional[DesignerInternalS3AuthParamsDTO] = Field(default=None, alias="internalS3AuthParams")
    copy_s3_auth_params: Optional[DesignerCopyS3AuthParamsDTO] = Field(default=None, alias="copyS3AuthParams")
    redshift_auth_params: Optional[DesignerRedshiftAuthParamsDTO] = Field(default=None, alias="redshiftAuthParams")
    snowflake_auth_params: Optional[DesignerSnowflakeAuthParamsDTO] = Field(default=None, alias="snowflakeAuthParams")
    big_query_auth_params: Optional[DesignerBigQueryAuthParamsDTO] = Field(default=None, alias="bigQueryAuthParams")
    sql_server_auth_params: Optional[DesignerSqlServerAuthParamsDTO] = Field(default=None, alias="sqlServerAuthParams")
    dimensions_auth_params: Optional[DesignerDimensionsAuthParamsDTO] = Field(default=None, alias="dimensionsAuthParams")
    willow_auth_params: Optional[DesignerWillowAuthParamsDTO] = Field(default=None, alias="willowAuthParams")
    empty_auth_params: Optional[Dict[str, Any]] = Field(default=None, alias="emptyAuthParams")
    success_factors_auth_params: Optional[DesignerSuccessFactorsAuthParamsDTO] = Field(default=None, alias="successFactorsAuthParams")
    fusion_auth_params: Optional[DesignerFusionAuthParamsDTO] = Field(default=None, alias="fusionAuthParams")
    adp_auth_params: Optional[DesignerAdpAuthParamsDTO] = Field(default=None, alias="adpAuthParams")
    medallia_auth_params: Optional[DesignerMedalliaAuthParamsDTO] = Field(default=None, alias="medalliaAuthParams")
    salesforce_v2_auth_params: Optional[DesignerSalesforceV2AuthParamsDTO] = Field(default=None, alias="salesforceV2AuthParams")
    gong_auth_params: Optional[DesignerGongAuthParamsDTO] = Field(default=None, alias="gongAuthParams")
    zoom_auth_params: Optional[DesignerZoomAuthParamsDTO] = Field(default=None, alias="zoomAuthParams")
    dayforce_v2_auth_params: Optional[DesignerDayforceV2AuthParamsDTO] = Field(default=None, alias="dayforceV2AuthParams")
    slack_auth_params: Optional[DesignerSlackAuthParamsDTO] = Field(default=None, alias="slackAuthParams")
    my_sql_auth_params: Optional[DesignerMySqlAuthParamsDTO] = Field(default=None, alias="mySqlAuthParams")
    workday_raas_auth_params: Optional[DesignerWorkdayRaasAuthParamsDTO] = Field(default=None, alias="workdayRaasAuthParams")
    ms365_auth_params: Optional[DesignerMicrosoft365AuthParamsDTO] = Field(default=None, alias="ms365AuthParams")
    google_workspace_auth_params: Optional[DesignerGoogleWorkspaceAuthParamsDTO] = Field(default=None, alias="googleWorkspaceAuthParams")
    oracle_db_auth_params: Optional[DesignerOracleDbAuthParamsDTO] = Field(default=None, alias="oracleDbAuthParams")
    service_now_v2_auth_params: Optional[DesignerServiceNowV2AuthParamsDTO] = Field(default=None, alias="serviceNowV2AuthParams")
    databricks_auth_params: Optional[DesignerDatabricksAuthParamsDTO] = Field(default=None, alias="databricksAuthParams")
    has_updates: Optional[StrictBool] = Field(default=None, alias="hasUpdates")
    auth_context: Optional[StrictStr] = Field(default=None, alias="authContext")
    __properties: ClassVar[List[str]] = ["tenantDomainName", "provider", "bambooAuthParams", "greenhouseAuthParams", "googleSheetsAuthParams", "jiraAuthParams", "leverAuthParams", "namelyAuthParams", "qualtricsAuthParams", "salesforceAuthParams", "ultimateAuthParams", "workdayAuthParams", "icimsAuthParams", "serviceNowAuthParams", "jdbcAuthParams", "s3AuthParams", "internalS3AuthParams", "copyS3AuthParams", "redshiftAuthParams", "snowflakeAuthParams", "bigQueryAuthParams", "sqlServerAuthParams", "dimensionsAuthParams", "willowAuthParams", "emptyAuthParams", "successFactorsAuthParams", "fusionAuthParams", "adpAuthParams", "medalliaAuthParams", "salesforceV2AuthParams", "gongAuthParams", "zoomAuthParams", "dayforceV2AuthParams", "slackAuthParams", "mySqlAuthParams", "workdayRaasAuthParams", "ms365AuthParams", "googleWorkspaceAuthParams", "oracleDbAuthParams", "serviceNowV2AuthParams", "databricksAuthParams", "hasUpdates", "authContext"]

    @field_validator('provider')
    def provider_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Bamboo', 'GoogleSheets', 'Greenhouse', 'Jira', 'Lever', 'Namely', 'Qualtrics', 'Salesforce', 'UKG', 'Workday', 'Icims', 'ServiceNow', 'Jdbc', 'BasicS3', 'InternalS3', 'CopyS3', 'Redshift', 'Snowflake', 'BigQuery', 'SqlServer', 'Dimensions', 'IcimsPartnerProviderRedshift', 'Willow', 'SuccessFactors', 'IcimsV2', 'ADP', 'WorkdayV2', 'ServiceNowV2', 'Medallia', 'Fusion', 'SalesforceV2', 'Gong', 'Zoom', 'GoogleCalendar', 'UKGV2', 'DayforceV2', 'GoogleActivityReport', 'Slack', 'MySql', 'WorkdayRaas', 'Microsoft365', 'GoogleWorkspace', 'OracleDb', 'SmartRecruiters', 'WorkdayWQL', 'OEMCornerstone', 'Databricks', 'JiraV2']):
            raise ValueError("must be one of enum values ('Bamboo', 'GoogleSheets', 'Greenhouse', 'Jira', 'Lever', 'Namely', 'Qualtrics', 'Salesforce', 'UKG', 'Workday', 'Icims', 'ServiceNow', 'Jdbc', 'BasicS3', 'InternalS3', 'CopyS3', 'Redshift', 'Snowflake', 'BigQuery', 'SqlServer', 'Dimensions', 'IcimsPartnerProviderRedshift', 'Willow', 'SuccessFactors', 'IcimsV2', 'ADP', 'WorkdayV2', 'ServiceNowV2', 'Medallia', 'Fusion', 'SalesforceV2', 'Gong', 'Zoom', 'GoogleCalendar', 'UKGV2', 'DayforceV2', 'GoogleActivityReport', 'Slack', 'MySql', 'WorkdayRaas', 'Microsoft365', 'GoogleWorkspace', 'OracleDb', 'SmartRecruiters', 'WorkdayWQL', 'OEMCornerstone', 'Databricks', 'JiraV2')")
        return value

    @field_validator('auth_context')
    def auth_context_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['DefaultDataExtraction', 'WorkplaceDynamicsDataExtraction', 'Notification']):
            raise ValueError("must be one of enum values ('DefaultDataExtraction', 'WorkplaceDynamicsDataExtraction', 'Notification')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DesignerDataProviderAuthParamsDTO from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of bamboo_auth_params
        if self.bamboo_auth_params:
            _dict['bambooAuthParams'] = self.bamboo_auth_params.to_dict()
        # override the default output from pydantic by calling `to_dict()` of greenhouse_auth_params
        if self.greenhouse_auth_params:
            _dict['greenhouseAuthParams'] = self.greenhouse_auth_params.to_dict()
        # override the default output from pydantic by calling `to_dict()` of google_sheets_auth_params
        if self.google_sheets_auth_params:
            _dict['googleSheetsAuthParams'] = self.google_sheets_auth_params.to_dict()
        # override the default output from pydantic by calling `to_dict()` of jira_auth_params
        if self.jira_auth_params:
            _dict['jiraAuthParams'] = self.jira_auth_params.to_dict()
        # override the default output from pydantic by calling `to_dict()` of lever_auth_params
        if self.lever_auth_params:
            _dict['leverAuthParams'] = self.lever_auth_params.to_dict()
        # override the default output from pydantic by calling `to_dict()` of namely_auth_params
        if self.namely_auth_params:
            _dict['namelyAuthParams'] = self.namely_auth_params.to_dict()
        # override the default output from pydantic by calling `to_dict()` of qualtrics_auth_params
        if self.qualtrics_auth_params:
            _dict['qualtricsAuthParams'] = self.qualtrics_auth_params.to_dict()
        # override the default output from pydantic by calling `to_dict()` of salesforce_auth_params
        if self.salesforce_auth_params:
            _dict['salesforceAuthParams'] = self.salesforce_auth_params.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ultimate_auth_params
        if self.ultimate_auth_params:
            _dict['ultimateAuthParams'] = self.ultimate_auth_params.to_dict()
        # override the default output from pydantic by calling `to_dict()` of workday_auth_params
        if self.workday_auth_params:
            _dict['workdayAuthParams'] = self.workday_auth_params.to_dict()
        # override the default output from pydantic by calling `to_dict()` of icims_auth_params
        if self.icims_auth_params:
            _dict['icimsAuthParams'] = self.icims_auth_params.to_dict()
        # override the default output from pydantic by calling `to_dict()` of service_now_auth_params
        if self.service_now_auth_params:
            _dict['serviceNowAuthParams'] = self.service_now_auth_params.to_dict()
        # override the default output from pydantic by calling `to_dict()` of jdbc_auth_params
        if self.jdbc_auth_params:
            _dict['jdbcAuthParams'] = self.jdbc_auth_params.to_dict()
        # override the default output from pydantic by calling `to_dict()` of s3_auth_params
        if self.s3_auth_params:
            _dict['s3AuthParams'] = self.s3_auth_params.to_dict()
        # override the default output from pydantic by calling `to_dict()` of internal_s3_auth_params
        if self.internal_s3_auth_params:
            _dict['internalS3AuthParams'] = self.internal_s3_auth_params.to_dict()
        # override the default output from pydantic by calling `to_dict()` of copy_s3_auth_params
        if self.copy_s3_auth_params:
            _dict['copyS3AuthParams'] = self.copy_s3_auth_params.to_dict()
        # override the default output from pydantic by calling `to_dict()` of redshift_auth_params
        if self.redshift_auth_params:
            _dict['redshiftAuthParams'] = self.redshift_auth_params.to_dict()
        # override the default output from pydantic by calling `to_dict()` of snowflake_auth_params
        if self.snowflake_auth_params:
            _dict['snowflakeAuthParams'] = self.snowflake_auth_params.to_dict()
        # override the default output from pydantic by calling `to_dict()` of big_query_auth_params
        if self.big_query_auth_params:
            _dict['bigQueryAuthParams'] = self.big_query_auth_params.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sql_server_auth_params
        if self.sql_server_auth_params:
            _dict['sqlServerAuthParams'] = self.sql_server_auth_params.to_dict()
        # override the default output from pydantic by calling `to_dict()` of dimensions_auth_params
        if self.dimensions_auth_params:
            _dict['dimensionsAuthParams'] = self.dimensions_auth_params.to_dict()
        # override the default output from pydantic by calling `to_dict()` of willow_auth_params
        if self.willow_auth_params:
            _dict['willowAuthParams'] = self.willow_auth_params.to_dict()
        # override the default output from pydantic by calling `to_dict()` of success_factors_auth_params
        if self.success_factors_auth_params:
            _dict['successFactorsAuthParams'] = self.success_factors_auth_params.to_dict()
        # override the default output from pydantic by calling `to_dict()` of fusion_auth_params
        if self.fusion_auth_params:
            _dict['fusionAuthParams'] = self.fusion_auth_params.to_dict()
        # override the default output from pydantic by calling `to_dict()` of adp_auth_params
        if self.adp_auth_params:
            _dict['adpAuthParams'] = self.adp_auth_params.to_dict()
        # override the default output from pydantic by calling `to_dict()` of medallia_auth_params
        if self.medallia_auth_params:
            _dict['medalliaAuthParams'] = self.medallia_auth_params.to_dict()
        # override the default output from pydantic by calling `to_dict()` of salesforce_v2_auth_params
        if self.salesforce_v2_auth_params:
            _dict['salesforceV2AuthParams'] = self.salesforce_v2_auth_params.to_dict()
        # override the default output from pydantic by calling `to_dict()` of gong_auth_params
        if self.gong_auth_params:
            _dict['gongAuthParams'] = self.gong_auth_params.to_dict()
        # override the default output from pydantic by calling `to_dict()` of zoom_auth_params
        if self.zoom_auth_params:
            _dict['zoomAuthParams'] = self.zoom_auth_params.to_dict()
        # override the default output from pydantic by calling `to_dict()` of dayforce_v2_auth_params
        if self.dayforce_v2_auth_params:
            _dict['dayforceV2AuthParams'] = self.dayforce_v2_auth_params.to_dict()
        # override the default output from pydantic by calling `to_dict()` of slack_auth_params
        if self.slack_auth_params:
            _dict['slackAuthParams'] = self.slack_auth_params.to_dict()
        # override the default output from pydantic by calling `to_dict()` of my_sql_auth_params
        if self.my_sql_auth_params:
            _dict['mySqlAuthParams'] = self.my_sql_auth_params.to_dict()
        # override the default output from pydantic by calling `to_dict()` of workday_raas_auth_params
        if self.workday_raas_auth_params:
            _dict['workdayRaasAuthParams'] = self.workday_raas_auth_params.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ms365_auth_params
        if self.ms365_auth_params:
            _dict['ms365AuthParams'] = self.ms365_auth_params.to_dict()
        # override the default output from pydantic by calling `to_dict()` of google_workspace_auth_params
        if self.google_workspace_auth_params:
            _dict['googleWorkspaceAuthParams'] = self.google_workspace_auth_params.to_dict()
        # override the default output from pydantic by calling `to_dict()` of oracle_db_auth_params
        if self.oracle_db_auth_params:
            _dict['oracleDbAuthParams'] = self.oracle_db_auth_params.to_dict()
        # override the default output from pydantic by calling `to_dict()` of service_now_v2_auth_params
        if self.service_now_v2_auth_params:
            _dict['serviceNowV2AuthParams'] = self.service_now_v2_auth_params.to_dict()
        # override the default output from pydantic by calling `to_dict()` of databricks_auth_params
        if self.databricks_auth_params:
            _dict['databricksAuthParams'] = self.databricks_auth_params.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DesignerDataProviderAuthParamsDTO from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "tenantDomainName": obj.get("tenantDomainName"),
            "provider": obj.get("provider"),
            "bambooAuthParams": DesignerBambooAuthParamsDTO.from_dict(obj["bambooAuthParams"]) if obj.get("bambooAuthParams") is not None else None,
            "greenhouseAuthParams": DesignerGreenhouseAuthParamsDTO.from_dict(obj["greenhouseAuthParams"]) if obj.get("greenhouseAuthParams") is not None else None,
            "googleSheetsAuthParams": DesignerGoogleSheetsAuthParamsDTO.from_dict(obj["googleSheetsAuthParams"]) if obj.get("googleSheetsAuthParams") is not None else None,
            "jiraAuthParams": DesignerJiraAuthParamsDTO.from_dict(obj["jiraAuthParams"]) if obj.get("jiraAuthParams") is not None else None,
            "leverAuthParams": DesignerLeverAuthParamsDTO.from_dict(obj["leverAuthParams"]) if obj.get("leverAuthParams") is not None else None,
            "namelyAuthParams": DesignerNamelyAuthParamsDTO.from_dict(obj["namelyAuthParams"]) if obj.get("namelyAuthParams") is not None else None,
            "qualtricsAuthParams": DesignerQualtricsAuthParamsDTO.from_dict(obj["qualtricsAuthParams"]) if obj.get("qualtricsAuthParams") is not None else None,
            "salesforceAuthParams": DesignerSalesforceAuthParamsDTO.from_dict(obj["salesforceAuthParams"]) if obj.get("salesforceAuthParams") is not None else None,
            "ultimateAuthParams": DesignerUltimateAuthParamsDTO.from_dict(obj["ultimateAuthParams"]) if obj.get("ultimateAuthParams") is not None else None,
            "workdayAuthParams": DesignerWorkdayAuthParamsDTO.from_dict(obj["workdayAuthParams"]) if obj.get("workdayAuthParams") is not None else None,
            "icimsAuthParams": DesignerIcimsAuthParamsDTO.from_dict(obj["icimsAuthParams"]) if obj.get("icimsAuthParams") is not None else None,
            "serviceNowAuthParams": DesignerServiceNowAuthParamsDTO.from_dict(obj["serviceNowAuthParams"]) if obj.get("serviceNowAuthParams") is not None else None,
            "jdbcAuthParams": DesignerJdbcAuthParamsDTO.from_dict(obj["jdbcAuthParams"]) if obj.get("jdbcAuthParams") is not None else None,
            "s3AuthParams": DesignerBasicS3AuthParamsDTO.from_dict(obj["s3AuthParams"]) if obj.get("s3AuthParams") is not None else None,
            "internalS3AuthParams": DesignerInternalS3AuthParamsDTO.from_dict(obj["internalS3AuthParams"]) if obj.get("internalS3AuthParams") is not None else None,
            "copyS3AuthParams": DesignerCopyS3AuthParamsDTO.from_dict(obj["copyS3AuthParams"]) if obj.get("copyS3AuthParams") is not None else None,
            "redshiftAuthParams": DesignerRedshiftAuthParamsDTO.from_dict(obj["redshiftAuthParams"]) if obj.get("redshiftAuthParams") is not None else None,
            "snowflakeAuthParams": DesignerSnowflakeAuthParamsDTO.from_dict(obj["snowflakeAuthParams"]) if obj.get("snowflakeAuthParams") is not None else None,
            "bigQueryAuthParams": DesignerBigQueryAuthParamsDTO.from_dict(obj["bigQueryAuthParams"]) if obj.get("bigQueryAuthParams") is not None else None,
            "sqlServerAuthParams": DesignerSqlServerAuthParamsDTO.from_dict(obj["sqlServerAuthParams"]) if obj.get("sqlServerAuthParams") is not None else None,
            "dimensionsAuthParams": DesignerDimensionsAuthParamsDTO.from_dict(obj["dimensionsAuthParams"]) if obj.get("dimensionsAuthParams") is not None else None,
            "willowAuthParams": DesignerWillowAuthParamsDTO.from_dict(obj["willowAuthParams"]) if obj.get("willowAuthParams") is not None else None,
            "emptyAuthParams": obj.get("emptyAuthParams"),
            "successFactorsAuthParams": DesignerSuccessFactorsAuthParamsDTO.from_dict(obj["successFactorsAuthParams"]) if obj.get("successFactorsAuthParams") is not None else None,
            "fusionAuthParams": DesignerFusionAuthParamsDTO.from_dict(obj["fusionAuthParams"]) if obj.get("fusionAuthParams") is not None else None,
            "adpAuthParams": DesignerAdpAuthParamsDTO.from_dict(obj["adpAuthParams"]) if obj.get("adpAuthParams") is not None else None,
            "medalliaAuthParams": DesignerMedalliaAuthParamsDTO.from_dict(obj["medalliaAuthParams"]) if obj.get("medalliaAuthParams") is not None else None,
            "salesforceV2AuthParams": DesignerSalesforceV2AuthParamsDTO.from_dict(obj["salesforceV2AuthParams"]) if obj.get("salesforceV2AuthParams") is not None else None,
            "gongAuthParams": DesignerGongAuthParamsDTO.from_dict(obj["gongAuthParams"]) if obj.get("gongAuthParams") is not None else None,
            "zoomAuthParams": DesignerZoomAuthParamsDTO.from_dict(obj["zoomAuthParams"]) if obj.get("zoomAuthParams") is not None else None,
            "dayforceV2AuthParams": DesignerDayforceV2AuthParamsDTO.from_dict(obj["dayforceV2AuthParams"]) if obj.get("dayforceV2AuthParams") is not None else None,
            "slackAuthParams": DesignerSlackAuthParamsDTO.from_dict(obj["slackAuthParams"]) if obj.get("slackAuthParams") is not None else None,
            "mySqlAuthParams": DesignerMySqlAuthParamsDTO.from_dict(obj["mySqlAuthParams"]) if obj.get("mySqlAuthParams") is not None else None,
            "workdayRaasAuthParams": DesignerWorkdayRaasAuthParamsDTO.from_dict(obj["workdayRaasAuthParams"]) if obj.get("workdayRaasAuthParams") is not None else None,
            "ms365AuthParams": DesignerMicrosoft365AuthParamsDTO.from_dict(obj["ms365AuthParams"]) if obj.get("ms365AuthParams") is not None else None,
            "googleWorkspaceAuthParams": DesignerGoogleWorkspaceAuthParamsDTO.from_dict(obj["googleWorkspaceAuthParams"]) if obj.get("googleWorkspaceAuthParams") is not None else None,
            "oracleDbAuthParams": DesignerOracleDbAuthParamsDTO.from_dict(obj["oracleDbAuthParams"]) if obj.get("oracleDbAuthParams") is not None else None,
            "serviceNowV2AuthParams": DesignerServiceNowV2AuthParamsDTO.from_dict(obj["serviceNowV2AuthParams"]) if obj.get("serviceNowV2AuthParams") is not None else None,
            "databricksAuthParams": DesignerDatabricksAuthParamsDTO.from_dict(obj["databricksAuthParams"]) if obj.get("databricksAuthParams") is not None else None,
            "hasUpdates": obj.get("hasUpdates"),
            "authContext": obj.get("authContext")
        })
        return _obj


