# coding: utf-8

"""
    gnomockd

    `gnomockd` is an HTTP wrapper for [Gnomock](https://github.com/orlangure/gnomock) integration and end-to-end testing toolkit. It allows to use Gnomock outside of Go ecosystem. Not all Gnomock features exist in this wrapper, but official presets, as well as basic general configuration, are supported.   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from gnomock.configuration import Configuration


class Postgres(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'db': 'str',
        'user': 'str',
        'password': 'str',
        'queries': 'list[str]',
        'queries_file': 'str'
    }

    attribute_map = {
        'db': 'db',
        'user': 'user',
        'password': 'password',
        'queries': 'queries',
        'queries_file': 'queries_file'
    }

    def __init__(self, db=None, user=None, password=None, queries=None, queries_file=None, local_vars_configuration=None):  # noqa: E501
        """Postgres - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._db = None
        self._user = None
        self._password = None
        self._queries = None
        self._queries_file = None
        self.discriminator = None

        if db is not None:
            self.db = db
        if user is not None:
            self.user = user
        if password is not None:
            self.password = password
        if queries is not None:
            self.queries = queries
        if queries_file is not None:
            self.queries_file = queries_file

    @property
    def db(self):
        """Gets the db of this Postgres.  # noqa: E501

        Database name to create. By default, `postgres` is used.  # noqa: E501

        :return: The db of this Postgres.  # noqa: E501
        :rtype: str
        """
        return self._db

    @db.setter
    def db(self, db):
        """Sets the db of this Postgres.

        Database name to create. By default, `postgres` is used.  # noqa: E501

        :param db: The db of this Postgres.  # noqa: E501
        :type: str
        """

        self._db = db

    @property
    def user(self):
        """Gets the user of this Postgres.  # noqa: E501

        User to create in the container. By default, `postgres` is used with password `password`.   # noqa: E501

        :return: The user of this Postgres.  # noqa: E501
        :rtype: str
        """
        return self._user

    @user.setter
    def user(self, user):
        """Sets the user of this Postgres.

        User to create in the container. By default, `postgres` is used with password `password`.   # noqa: E501

        :param user: The user of this Postgres.  # noqa: E501
        :type: str
        """

        self._user = user

    @property
    def password(self):
        """Gets the password of this Postgres.  # noqa: E501

        New user's password.  # noqa: E501

        :return: The password of this Postgres.  # noqa: E501
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """Sets the password of this Postgres.

        New user's password.  # noqa: E501

        :param password: The password of this Postgres.  # noqa: E501
        :type: str
        """

        self._password = password

    @property
    def queries(self):
        """Gets the queries of this Postgres.  # noqa: E501

        A list of queries to execute while setting up the container.   # noqa: E501

        :return: The queries of this Postgres.  # noqa: E501
        :rtype: list[str]
        """
        return self._queries

    @queries.setter
    def queries(self, queries):
        """Sets the queries of this Postgres.

        A list of queries to execute while setting up the container.   # noqa: E501

        :param queries: The queries of this Postgres.  # noqa: E501
        :type: list[str]
        """

        self._queries = queries

    @property
    def queries_file(self):
        """Gets the queries_file of this Postgres.  # noqa: E501

        A SQL file to execute while setting up container state.  # noqa: E501

        :return: The queries_file of this Postgres.  # noqa: E501
        :rtype: str
        """
        return self._queries_file

    @queries_file.setter
    def queries_file(self, queries_file):
        """Sets the queries_file of this Postgres.

        A SQL file to execute while setting up container state.  # noqa: E501

        :param queries_file: The queries_file of this Postgres.  # noqa: E501
        :type: str
        """

        self._queries_file = queries_file

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Postgres):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Postgres):
            return True

        return self.to_dict() != other.to_dict()
