/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.gtile;

import java.util.Arrays;
import java.util.List;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.gtile.GConnection;
import net.sourceforge.plantuml.activitydiagram3.gtile.GPoint;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public abstract class GAbstractConnection
implements GConnection {
    protected final GPoint gpoint1;
    protected final GPoint gpoint2;

    public GAbstractConnection(GPoint gpoint1, GPoint gpoint2) {
        this.gpoint1 = gpoint1;
        this.gpoint2 = gpoint2;
    }

    public String toString() {
        return "[" + this.gpoint1 + "]->[" + this.gpoint2 + "]";
    }

    @Override
    public final List<GPoint> getHooks() {
        return Arrays.asList(this.gpoint1, this.gpoint2);
    }

    @Override
    public final void drawTranslatable(UGraphic ug) {
        Swimlane swimlane2;
        Swimlane swimlane1 = this.gpoint1.getSwimlane();
        if (swimlane1 == (swimlane2 = this.gpoint2.getSwimlane())) {
            return;
        }
        UTranslate translate1 = swimlane1.getTranslate();
        UTranslate translate2 = swimlane2.getTranslate();
        this.drawTranslate(ug, translate1, translate2);
    }

    public void drawTranslate(UGraphic ug, UTranslate translate1, UTranslate translate2) {
        throw new UnsupportedOperationException();
    }
}

