# ory-client-client
Documentation for all public and administrative Ory APIs. Administrative APIs can only be accessed
with a valid Personal Access Token. Public APIs are mostly used in browsers.


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v0.0.1-alpha.1
- Package version: v0.0.1-alpha.1
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/ory/sdk.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/ory/sdk.git`)

Then import the package:
```python
import ory_client_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import ory_client_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import ory_client_client
from pprint import pprint
from ory_client_client.api import default_api
from ory_client_client.model.create_identity import CreateIdentity
from ory_client_client.model.create_recovery_link import CreateRecoveryLink
from ory_client_client.model.error_container import ErrorContainer
from ory_client_client.model.generic_error import GenericError
from ory_client_client.model.identity import Identity
from ory_client_client.model.inline_response200 import InlineResponse200
from ory_client_client.model.inline_response2001 import InlineResponse2001
from ory_client_client.model.inline_response503 import InlineResponse503
from ory_client_client.model.json_error import JsonError
from ory_client_client.model.login_flow import LoginFlow
from ory_client_client.model.login_via_api_response import LoginViaApiResponse
from ory_client_client.model.recovery_flow import RecoveryFlow
from ory_client_client.model.recovery_link import RecoveryLink
from ory_client_client.model.registration_flow import RegistrationFlow
from ory_client_client.model.registration_via_api_response import RegistrationViaApiResponse
from ory_client_client.model.revoke_session import RevokeSession
from ory_client_client.model.session import Session
from ory_client_client.model.settings_flow import SettingsFlow
from ory_client_client.model.settings_via_api_response import SettingsViaApiResponse
from ory_client_client.model.submit_self_service_login_flow import SubmitSelfServiceLoginFlow
from ory_client_client.model.submit_self_service_recovery_flow_with_link_method import SubmitSelfServiceRecoveryFlowWithLinkMethod
from ory_client_client.model.submit_self_service_registration_flow import SubmitSelfServiceRegistrationFlow
from ory_client_client.model.submit_self_service_settings_flow import SubmitSelfServiceSettingsFlow
from ory_client_client.model.update_identity import UpdateIdentity
from ory_client_client.model.verification_flow import VerificationFlow
# Defining the host is optional and defaults to https://playground.projects.oryapis.com
# See configuration.py for a list of all supported configuration parameters.
configuration = ory_client_client.Configuration(
    host = "https://playground.projects.oryapis.com"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization: oryToken
configuration = ory_client_client.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)


# Enter a context with an instance of the API client
with ory_client_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = default_api.DefaultApi(api_client)
    create_identity = CreateIdentity(
        schema_id="schema_id_example",
        traits={},
    ) # CreateIdentity |  (optional)

    try:
        # Create an Identity
        api_response = api_instance.create_identity_admin(create_identity=create_identity)
        pprint(api_response)
    except ory_client_client.ApiException as e:
        print("Exception when calling DefaultApi->create_identity_admin: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://playground.projects.oryapis.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**create_identity_admin**](docs/DefaultApi.md#create_identity_admin) | **POST** /api/kratos/admin/identities | Create an Identity
*DefaultApi* | [**create_recovery_link_admin**](docs/DefaultApi.md#create_recovery_link_admin) | **POST** /api/kratos/admin/recovery/link | Create a Recovery Link
*DefaultApi* | [**delete_identity_admin**](docs/DefaultApi.md#delete_identity_admin) | **DELETE** /api/kratos/admin/identities/{id} | Delete an Identity
*DefaultApi* | [**get_identity_admin**](docs/DefaultApi.md#get_identity_admin) | **GET** /api/kratos/admin/identities/{id} | Get an Identity
*DefaultApi* | [**get_schema**](docs/DefaultApi.md#get_schema) | **GET** /api/kratos/public/schemas/{id} | 
*DefaultApi* | [**get_schema_admin**](docs/DefaultApi.md#get_schema_admin) | **GET** /api/kratos/admin/schemas/{id} | 
*DefaultApi* | [**get_self_service_error**](docs/DefaultApi.md#get_self_service_error) | **GET** /api/kratos/public/self-service/errors | Get User-Facing Self-Service Errors
*DefaultApi* | [**get_self_service_error_admin**](docs/DefaultApi.md#get_self_service_error_admin) | **GET** /api/kratos/admin/self-service/errors | Get User-Facing Self-Service Errors
*DefaultApi* | [**get_self_service_login_flow**](docs/DefaultApi.md#get_self_service_login_flow) | **GET** /api/kratos/public/self-service/login/flows | Get Login Flow
*DefaultApi* | [**get_self_service_login_flow_admin**](docs/DefaultApi.md#get_self_service_login_flow_admin) | **GET** /api/kratos/admin/self-service/login/flows | Get Login Flow
*DefaultApi* | [**get_self_service_recovery_flow**](docs/DefaultApi.md#get_self_service_recovery_flow) | **GET** /api/kratos/public/self-service/recovery/flows | Get information about a recovery flow
*DefaultApi* | [**get_self_service_recovery_flow_admin**](docs/DefaultApi.md#get_self_service_recovery_flow_admin) | **GET** /api/kratos/admin/self-service/recovery/flows | Get information about a recovery flow
*DefaultApi* | [**get_self_service_registration_flow**](docs/DefaultApi.md#get_self_service_registration_flow) | **GET** /api/kratos/public/self-service/registration/flows | Get Registration Flow
*DefaultApi* | [**get_self_service_registration_flow_admin**](docs/DefaultApi.md#get_self_service_registration_flow_admin) | **GET** /api/kratos/admin/self-service/registration/flows | Get Registration Flow
*DefaultApi* | [**get_self_service_settings_flow**](docs/DefaultApi.md#get_self_service_settings_flow) | **GET** /api/kratos/public/self-service/settings/flows | Get Settings Flow
*DefaultApi* | [**get_self_service_settings_flow_admin**](docs/DefaultApi.md#get_self_service_settings_flow_admin) | **GET** /api/kratos/admin/self-service/settings/flows | Get Settings Flow
*DefaultApi* | [**get_self_service_verification_flow**](docs/DefaultApi.md#get_self_service_verification_flow) | **GET** /api/kratos/public/self-service/verification/flows | Get Verification Flow
*DefaultApi* | [**get_self_service_verification_flow_admin**](docs/DefaultApi.md#get_self_service_verification_flow_admin) | **GET** /api/kratos/admin/self-service/verification/flows | Get Verification Flow
*DefaultApi* | [**get_version_admin**](docs/DefaultApi.md#get_version_admin) | **GET** /api/kratos/admin/version | Return Running Software Version.
*DefaultApi* | [**initialize_self_service_browser_logout_flow**](docs/DefaultApi.md#initialize_self_service_browser_logout_flow) | **GET** /api/kratos/public/self-service/browser/flows/logout | Initialize Browser-Based Logout User Flow
*DefaultApi* | [**initialize_self_service_login_via_api_flow**](docs/DefaultApi.md#initialize_self_service_login_via_api_flow) | **GET** /api/kratos/public/self-service/login/api | Initialize Login Flow for API clients
*DefaultApi* | [**initialize_self_service_login_via_browser_flow**](docs/DefaultApi.md#initialize_self_service_login_via_browser_flow) | **GET** /api/kratos/public/self-service/login/browser | Initialize Login Flow for browsers
*DefaultApi* | [**initialize_self_service_recovery_via_api_flow**](docs/DefaultApi.md#initialize_self_service_recovery_via_api_flow) | **GET** /api/kratos/public/self-service/recovery/api | Initialize Recovery Flow for API Clients
*DefaultApi* | [**initialize_self_service_recovery_via_browser_flow**](docs/DefaultApi.md#initialize_self_service_recovery_via_browser_flow) | **GET** /api/kratos/public/self-service/recovery/browser | Initialize Recovery Flow for Browser Clients
*DefaultApi* | [**initialize_self_service_registration**](docs/DefaultApi.md#initialize_self_service_registration) | **GET** /api/kratos/public/self-service/registration/api | Initialize Registration Flow for API clients
*DefaultApi* | [**initialize_self_service_registration_for_browsers**](docs/DefaultApi.md#initialize_self_service_registration_for_browsers) | **GET** /api/kratos/public/self-service/registration/browser | Initialize Registration Flow for browsers
*DefaultApi* | [**initialize_self_service_settings_via_api_flow**](docs/DefaultApi.md#initialize_self_service_settings_via_api_flow) | **GET** /api/kratos/public/self-service/settings/api | Initialize Settings Flow for API Clients
*DefaultApi* | [**initialize_self_service_settings_via_browser_flow**](docs/DefaultApi.md#initialize_self_service_settings_via_browser_flow) | **GET** /api/kratos/public/self-service/settings/browser | Initialize Settings Flow for Browsers
*DefaultApi* | [**initialize_self_service_verification_via_api_flow**](docs/DefaultApi.md#initialize_self_service_verification_via_api_flow) | **GET** /api/kratos/public/self-service/verification/api | Initialize Verification Flow for API Clients
*DefaultApi* | [**initialize_self_service_verification_via_browser_flow**](docs/DefaultApi.md#initialize_self_service_verification_via_browser_flow) | **GET** /api/kratos/public/self-service/verification/browser | Initialize Verification Flow for Browser Clients
*DefaultApi* | [**is_alive_admin**](docs/DefaultApi.md#is_alive_admin) | **GET** /api/kratos/admin/health/alive | Check HTTP Server Status
*DefaultApi* | [**is_ready_admin**](docs/DefaultApi.md#is_ready_admin) | **GET** /api/kratos/admin/health/ready | Check HTTP Server and Database Status
*DefaultApi* | [**list_identities_admin**](docs/DefaultApi.md#list_identities_admin) | **GET** /api/kratos/admin/identities | List Identities
*DefaultApi* | [**prometheus_admin**](docs/DefaultApi.md#prometheus_admin) | **GET** /api/kratos/admin/metrics/prometheus | Get snapshot metrics from the Hydra service. If you&#39;re using k8s, you can then add annotations to your deployment like so:
*DefaultApi* | [**revoke_session**](docs/DefaultApi.md#revoke_session) | **DELETE** /api/kratos/public/sessions | Initialize Logout Flow for API Clients - Revoke a Session
*DefaultApi* | [**submit_self_service_login_flow**](docs/DefaultApi.md#submit_self_service_login_flow) | **POST** /api/kratos/public/self-service/login | Submit a Login Flow
*DefaultApi* | [**submit_self_service_recovery_flow**](docs/DefaultApi.md#submit_self_service_recovery_flow) | **POST** /api/kratos/public/self-service/recovery | Complete Recovery Flow
*DefaultApi* | [**submit_self_service_recovery_flow_with_link_method**](docs/DefaultApi.md#submit_self_service_recovery_flow_with_link_method) | **POST** /api/kratos/public/self-service/recovery/methods/link | Complete Recovery Flow with Link Method
*DefaultApi* | [**submit_self_service_registration_flow**](docs/DefaultApi.md#submit_self_service_registration_flow) | **POST** /api/kratos/public/self-service/registration | Submit a Registration Flow
*DefaultApi* | [**submit_self_service_settings_flow**](docs/DefaultApi.md#submit_self_service_settings_flow) | **POST** /api/kratos/public/self-service/settings | Complete Settings Flow
*DefaultApi* | [**submit_self_service_verification_flow**](docs/DefaultApi.md#submit_self_service_verification_flow) | **POST** /api/kratos/public/self-service/verification/methods/link | Complete Verification Flow
*DefaultApi* | [**to_session**](docs/DefaultApi.md#to_session) | **GET** /api/kratos/public/sessions/whoami | Check Who the Current HTTP Session Belongs To
*DefaultApi* | [**update_identity_admin**](docs/DefaultApi.md#update_identity_admin) | **PUT** /api/kratos/admin/identities/{id} | Update an Identity


## Documentation For Models

 - [AuthenticateOKBody](docs/AuthenticateOKBody.md)
 - [ContainerChangeResponseItem](docs/ContainerChangeResponseItem.md)
 - [ContainerCreateCreatedBody](docs/ContainerCreateCreatedBody.md)
 - [ContainerTopOKBody](docs/ContainerTopOKBody.md)
 - [ContainerUpdateOKBody](docs/ContainerUpdateOKBody.md)
 - [ContainerWaitOKBody](docs/ContainerWaitOKBody.md)
 - [ContainerWaitOKBodyError](docs/ContainerWaitOKBodyError.md)
 - [CreateIdentity](docs/CreateIdentity.md)
 - [CreateRecoveryLink](docs/CreateRecoveryLink.md)
 - [ErrorContainer](docs/ErrorContainer.md)
 - [ErrorResponse](docs/ErrorResponse.md)
 - [GenericError](docs/GenericError.md)
 - [GraphDriverData](docs/GraphDriverData.md)
 - [HealthNotReadyStatus](docs/HealthNotReadyStatus.md)
 - [HealthStatus](docs/HealthStatus.md)
 - [IdResponse](docs/IdResponse.md)
 - [Identity](docs/Identity.md)
 - [IdentityCredentials](docs/IdentityCredentials.md)
 - [ImageDeleteResponseItem](docs/ImageDeleteResponseItem.md)
 - [ImageSummary](docs/ImageSummary.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse2001](docs/InlineResponse2001.md)
 - [InlineResponse503](docs/InlineResponse503.md)
 - [JsonError](docs/JsonError.md)
 - [LoginFlow](docs/LoginFlow.md)
 - [LoginViaApiResponse](docs/LoginViaApiResponse.md)
 - [Meta](docs/Meta.md)
 - [Plugin](docs/Plugin.md)
 - [PluginConfig](docs/PluginConfig.md)
 - [PluginConfigArgs](docs/PluginConfigArgs.md)
 - [PluginConfigInterface](docs/PluginConfigInterface.md)
 - [PluginConfigLinux](docs/PluginConfigLinux.md)
 - [PluginConfigNetwork](docs/PluginConfigNetwork.md)
 - [PluginConfigRootfs](docs/PluginConfigRootfs.md)
 - [PluginConfigUser](docs/PluginConfigUser.md)
 - [PluginDevice](docs/PluginDevice.md)
 - [PluginEnv](docs/PluginEnv.md)
 - [PluginInterfaceType](docs/PluginInterfaceType.md)
 - [PluginMount](docs/PluginMount.md)
 - [PluginSettings](docs/PluginSettings.md)
 - [Port](docs/Port.md)
 - [RecoveryAddress](docs/RecoveryAddress.md)
 - [RecoveryFlow](docs/RecoveryFlow.md)
 - [RecoveryLink](docs/RecoveryLink.md)
 - [RegistrationFlow](docs/RegistrationFlow.md)
 - [RegistrationViaApiResponse](docs/RegistrationViaApiResponse.md)
 - [RevokeSession](docs/RevokeSession.md)
 - [ServiceUpdateResponse](docs/ServiceUpdateResponse.md)
 - [Session](docs/Session.md)
 - [SettingsFlow](docs/SettingsFlow.md)
 - [SettingsProfileFormConfig](docs/SettingsProfileFormConfig.md)
 - [SettingsViaApiResponse](docs/SettingsViaApiResponse.md)
 - [SubmitSelfServiceBrowserSettingsOIDCFlowPayload](docs/SubmitSelfServiceBrowserSettingsOIDCFlowPayload.md)
 - [SubmitSelfServiceLoginFlow](docs/SubmitSelfServiceLoginFlow.md)
 - [SubmitSelfServiceLoginFlowWithPasswordMethod](docs/SubmitSelfServiceLoginFlowWithPasswordMethod.md)
 - [SubmitSelfServiceRecoveryFlowWithLinkMethod](docs/SubmitSelfServiceRecoveryFlowWithLinkMethod.md)
 - [SubmitSelfServiceRegistrationFlow](docs/SubmitSelfServiceRegistrationFlow.md)
 - [SubmitSelfServiceRegistrationFlowWithPasswordMethod](docs/SubmitSelfServiceRegistrationFlowWithPasswordMethod.md)
 - [SubmitSelfServiceSettingsFlow](docs/SubmitSelfServiceSettingsFlow.md)
 - [SubmitSelfServiceSettingsFlowWithPasswordMethod](docs/SubmitSelfServiceSettingsFlowWithPasswordMethod.md)
 - [SubmitSelfServiceSettingsFlowWithProfileMethod](docs/SubmitSelfServiceSettingsFlowWithProfileMethod.md)
 - [SubmitSelfServiceVerificationFlowWithLinkMethod](docs/SubmitSelfServiceVerificationFlowWithLinkMethod.md)
 - [UiContainer](docs/UiContainer.md)
 - [UiNode](docs/UiNode.md)
 - [UiNodeAnchorAttributes](docs/UiNodeAnchorAttributes.md)
 - [UiNodeAttributes](docs/UiNodeAttributes.md)
 - [UiNodeImageAttributes](docs/UiNodeImageAttributes.md)
 - [UiNodeInputAttributes](docs/UiNodeInputAttributes.md)
 - [UiNodeInputAttributesValue](docs/UiNodeInputAttributesValue.md)
 - [UiNodeTextAttributes](docs/UiNodeTextAttributes.md)
 - [UiNodes](docs/UiNodes.md)
 - [UiText](docs/UiText.md)
 - [UiTexts](docs/UiTexts.md)
 - [UpdateIdentity](docs/UpdateIdentity.md)
 - [VerifiableIdentityAddress](docs/VerifiableIdentityAddress.md)
 - [VerificationFlow](docs/VerificationFlow.md)
 - [Version](docs/Version.md)
 - [Volume](docs/Volume.md)
 - [VolumeUsageData](docs/VolumeUsageData.md)


## Documentation For Authorization


## oryToken

- **Type**: Bearer authentication


## sessionCookie

- **Type**: API key
- **API key parameter name**: ory_kratos_session
- **Location**: 


## sessionToken

- **Type**: Bearer authentication


## Author

support@ory.sh


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in ory_client_client.apis and ory_client_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from ory_client_client.api.default_api import DefaultApi`
- `from ory_client_client.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import ory_client_client
from ory_client_client.apis import *
from ory_client_client.models import *
```

